/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Emulator;
import emulator.Settings;
import emulator.ui.swt.devutils.ClasspathEntry;
import emulator.ui.swt.devutils.ClasspathEntryType;
import emulator.ui.swt.devutils.idea.m;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ProjectConfigGenerator {
    public static final String encodingFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"Encoding\" addBOMForNewFiles=\"with BOM under Windows, with no BOM otherwise\" />\n</project>";
    public static final String miscFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"ProjectRootManager\" version=\"2\" languageLevel=\"JDK_1_3\" project-jdk-name=\"1.8 CLDC Devtime\" project-jdk-type=\"JavaSDK\">\n    <output url=\"file://$PROJECT_DIR$/bin\" />\n  </component>\n</project>";
    public static final String rootGitignoreFile = "### IntelliJ IDEA ###\nout/\n!**/src/main/**/out/\n!**/src/test/**/out/\nproguard-local.cfg\n.idea/runConfigurations\n\n### Eclipse ###\n.apt_generated\n.classpath\n.factorypath\n.project\n.settings\nbin/\ndeployed/\n\n### NetBeans ###\n/nbproject/private/\n/nbbuild/\n/dist/\n/nbdist/\n/.nb-gradle/\n\n### VS Code ###\n.vscode/\n\n### Mac OS ###\n.DS_Store";
    public static final String ideaGitignoreFile = "# Default ignored files\n/shelf/\n/workspace.xml\n# Editor-based HTTP Client requests\n/httpRequests/\n# Datasource local storage ignored files\n/dataSources/\n/dataSources.local.xml\n";

    public static String buildLocalProguardConfig(String string, String string2, ClasspathEntry[] classpathEntryArray) {
        String string3 = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# This config file is gitignored and reset on each deploy.");
        stringBuilder.append(string3);
        stringBuilder.append("# Actual configuration should live in another file, \"proguard.cfg\" by default.");
        stringBuilder.append(string3);
        for (String string4 : m.a()) {
            stringBuilder.append("-libraryjars '");
            stringBuilder.append(string4);
            stringBuilder.append("'");
            stringBuilder.append(string3);
        }
        for (ClasspathEntry classpathEntry : classpathEntryArray) {
            if (classpathEntry.type != ClasspathEntryType.HeaderLibrary) continue;
            stringBuilder.append("-libraryjars '");
            if (classpathEntry.isLocalPath) {
                stringBuilder.append(Paths.get(string, new String[0]).resolve(classpathEntry.path));
            } else {
                stringBuilder.append(classpathEntry.path);
            }
            stringBuilder.append("'");
            stringBuilder.append(string3);
        }
        stringBuilder.append("-printseeds '").append(Paths.get(string, "deployed", "pro_seeds.txt")).append("'");
        stringBuilder.append(string3);
        stringBuilder.append("-printmapping '").append(Paths.get(string, "deployed", "pro_map.txt")).append("'");
        stringBuilder.append(string3);
        stringBuilder.append("-dontusemixedcaseclassnames -dontnote -defaultpackage '' -microedition -target 1.2 -optimizations !library/*,!code/simplification/object");
        stringBuilder.append(string3);
        stringBuilder.append("-keep public class * extends javax.microedition.midlet.MIDlet");
        stringBuilder.append(string3);
        stringBuilder.append("-assumenosideeffects public class java.lang.StringBuffer {");
        stringBuilder.append(string3);
        stringBuilder.append("    public java.lang.String toString();");
        stringBuilder.append(string3);
        stringBuilder.append("    public char charAt(int);");
        stringBuilder.append(string3);
        stringBuilder.append("    public int capacity();");
        stringBuilder.append(string3);
        stringBuilder.append("    public int codePointAt(int);");
        stringBuilder.append(string3);
        stringBuilder.append("    public int codePointBefore(int);");
        stringBuilder.append(string3);
        stringBuilder.append("    public int indexOf(java.lang.String,int);");
        stringBuilder.append(string3);
        stringBuilder.append("    public int lastIndexOf(java.lang.String);");
        stringBuilder.append(string3);
        stringBuilder.append("    public int lastIndexOf(java.lang.String,int);");
        stringBuilder.append(string3);
        stringBuilder.append("    public int length();");
        stringBuilder.append(string3);
        stringBuilder.append("    public java.lang.String substring(int);");
        stringBuilder.append(string3);
        stringBuilder.append("    public java.lang.String substring(int,int);");
        stringBuilder.append(string3);
        stringBuilder.append("}");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String buildManifest(String string, String string2, String string3) {
        String string4 = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Manifest-Version: 1.0").append(string4);
        stringBuilder.append("MicroEdition-Configuration: CLDC-1.1").append(string4);
        stringBuilder.append("MicroEdition-Profile: MIDP-2.0").append(string4);
        stringBuilder.append("MIDlet-Vendor: Anonymous developer").append(string4);
        stringBuilder.append("MIDlet-Version: 0.0.1").append(string4);
        stringBuilder.append("MIDlet-Name: ").append(string3).append(string4);
        stringBuilder.append("MIDlet-1: ").append(string3).append(",,").append(string2).append(string4);
        stringBuilder.append("MIDlet-Jar-URL: ").append(string).append(".jar").append(string4);
        return stringBuilder.toString();
    }

    public static String buildDummyMidlet(String string) {
        String string2;
        String string3 = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        if (string.indexOf(46) != -1) {
            String[] stringArray = ProjectConfigGenerator.splitByLastDot(string);
            string2 = stringArray[1];
            stringBuilder.append("package ").append(stringArray[0]).append(";").append(string3);
        } else {
            string2 = string;
        }
        stringBuilder.append("import javax.microedition.lcdui.Display;").append(string3);
        stringBuilder.append("import javax.microedition.lcdui.Form;").append(string3);
        stringBuilder.append("import javax.microedition.midlet.MIDlet;").append(string3);
        stringBuilder.append(string3);
        stringBuilder.append("public class ").append(string2).append(" extends MIDlet {").append(string3);
        stringBuilder.append("    protected void startApp() {").append(string3);
        stringBuilder.append("        Form f = new Form(\"").append(string2).append("\");").append(string3);
        stringBuilder.append("        f.append(\"Your MIDlet seems to run.\");").append(string3);
        stringBuilder.append("        Display.getDisplay(this).setCurrent(f);").append(string3);
        stringBuilder.append("    }").append(string3);
        stringBuilder.append(string3);
        stringBuilder.append("    protected void pauseApp() {").append(string3);
        stringBuilder.append("    }").append(string3);
        stringBuilder.append(string3);
        stringBuilder.append("    protected void destroyApp(boolean unconditional) {").append(string3);
        stringBuilder.append("    }").append(string3);
        stringBuilder.append("}").append(string3);
        return stringBuilder.toString();
    }

    public static String buildModulesFile(String string) {
        String string2 = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(string2);
        stringBuilder.append("<project version=\"4\">").append(string2);
        stringBuilder.append("  <component name=\"ProjectModuleManager\">").append(string2);
        stringBuilder.append("    <modules>").append(string2);
        stringBuilder.append("      <module fileurl=\"file://$PROJECT_DIR$/").append(string).append(".iml\" filepath=\"$PROJECT_DIR$/").append(string).append(".iml\" />").append(string2);
        stringBuilder.append("    </modules>").append(string2);
        stringBuilder.append("  </component>").append(string2);
        stringBuilder.append("</project>");
        return stringBuilder.toString();
    }

    public static String buildArtifactConfig(String string, boolean bl2) {
        String string2 = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<component name=\"ArtifactManager\">").append(string2);
        stringBuilder.append("  <artifact type=\"jar\" name=\"").append(string).append("\">").append(string2);
        stringBuilder.append("    <output-path>$PROJECT_DIR$/deployed/raw</output-path>").append(string2);
        stringBuilder.append("    <root id=\"archive\" name=\"").append(string).append(".jar\">").append(string2);
        stringBuilder.append("      <element id=\"directory\" name=\"META-INF\">").append(string2);
        if (bl2) {
            stringBuilder.append("        <element id=\"file-copy\" output-file-name=\"MANIFEST.MF\" path=\"$PROJECT_DIR$/Application Descriptor\" />").append(string2);
        } else {
            stringBuilder.append("        <element id=\"file-copy\" path=\"$PROJECT_DIR$/META-INF/MANIFEST.MF\" />").append(string2);
        }
        stringBuilder.append("      </element>").append(string2);
        stringBuilder.append("      <element id=\"module-output\" name=\"").append(string).append("\" />").append(string2);
        stringBuilder.append("    </root>").append(string2);
        stringBuilder.append("  </artifact>").append(string2);
        stringBuilder.append("</component>");
        return stringBuilder.toString();
    }

    public static String buildKemRunConfig(String string, String string2, String string3, boolean bl2) {
        String string4 = bl2 ? "Application Descriptor" : "META-INF/MANIFEST.MF";
        return "<component name=\"ProjectRunConfigurationManager\">\n  <configuration default=\"false\" name=\"Launch &quot;" + string2.replace("&", "&amp;").replace("\"", "&quot;") + "&quot; with KEmulator\" type=\"Application\" factoryName=\"Application\">\n    <option name=\"ALTERNATIVE_JRE_PATH\" value=\"1.8 CLDC Runtime\" />\n    <option name=\"ALTERNATIVE_JRE_PATH_ENABLED\" value=\"true\" />\n    <option name=\"MAIN_CLASS_NAME\" value=\"emulator.Emulator\" />\n    <module name=\"" + string + "\" />\n    <option name=\"PROGRAM_PARAMETERS\" value=\"-cp &quot;$OutputPath$&quot; -midlet &quot;" + string3 + "&quot; -jad &quot;$PROJECT_DIR$/" + string4 + "&quot; -uei\" />\n    <option name=\"VM_PARAMETERS\" value=\"-XX:+IgnoreUnrecognizedVMOptions -Djna.nosys=true -Dfile.encoding=UTF-8 -XstartOnFirstThread\" />\n    <option name=\"WORKING_DIRECTORY\" value=\"" + Emulator.getAbsolutePath() + "\" />\n    <method v=\"2\">\n      <option name=\"Make\" enabled=\"true\" />\n    </method>\n  </configuration>\n</component>";
    }

    public static String buildRestoreRunConfig(String string) {
        return "<component name=\"ProjectRunConfigurationManager\">\n  <configuration default=\"false\" name=\"Restore project\" type=\"Application\" factoryName=\"Application\">\n    <option name=\"ALTERNATIVE_JRE_PATH\" value=\"1.8 CLDC Runtime\" />\n    <option name=\"ALTERNATIVE_JRE_PATH_ENABLED\" value=\"true\" />\n    <option name=\"MAIN_CLASS_NAME\" value=\"emulator.Emulator\" />\n    <module name=\"" + string + "\" />\n    <option name=\"PROGRAM_PARAMETERS\" value=\"-restore &quot;$PROJECT_DIR$&quot;\" />\n    <option name=\"WORKING_DIRECTORY\" value=\"" + Emulator.getAbsolutePath() + "\" />\n    <method v=\"2\">\n      <option name=\"Make\" enabled=\"true\" />\n    </method>\n  </configuration>\n</component>";
    }

    public static String buildPackageRunConfig(String string, ArrayList arrayList, String string2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@');
        stringBuilder.append("proguard-local.cfg");
        for (String string3 : arrayList) {
            stringBuilder.append(" -injars &quot;");
            stringBuilder.append(string3);
            stringBuilder.append("&quot;");
        }
        stringBuilder.append(" -outjars &quot;");
        stringBuilder.append(string2);
        stringBuilder.append("&quot;");
        if (bl2) {
            stringBuilder.append(" -dontoptimize -dontshrink -dontobfuscate -keep class *");
        } else {
            stringBuilder.append(" @");
            stringBuilder.append("proguard.cfg");
        }
        return "<component name=\"ProjectRunConfigurationManager\">\n  <configuration default=\"false\" name=\"Package &quot;" + string + "&quot; (" + (bl2 ? "development" : "release") + ")\" type=\"JarApplication\">\n    <option name=\"JAR_PATH\" value=\"" + Settings.proguardPath + "\" />\n    <option name=\"PROGRAM_PARAMETERS\" value=\"" + stringBuilder + "\" />\n    <option name=\"WORKING_DIRECTORY\" value=\"$PROJECT_DIR$\" />\n    <option name=\"ALTERNATIVE_JRE_PATH_ENABLED\" value=\"true\" />\n    <option name=\"ALTERNATIVE_JRE_PATH\" value=\"1.8 CLDC Runtime\" />\n    <method v=\"2\">\n      <option name=\"BuildArtifacts\" enabled=\"true\">\n        <artifact name=\"" + string + "\" />\n      </option>\n    </method>\n  </configuration>\n</component>";
    }

    public static ClasspathEntry[] generateIML(Path path, Path path2) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        ClasspathEntry[] classpathEntryArray;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("module");
        element.setAttribute("type", "JAVA_MODULE");
        element.setAttribute("version", "4");
        document.appendChild(element);
        Element element2 = document.createElement("component");
        element2.setAttribute("name", "NewModuleRootManager");
        element2.setAttribute("LANGUAGE_LEVEL", "JDK_1_3");
        element2.setAttribute("inherit-compiler-output", "true");
        element.appendChild(element2);
        Element element3 = document.createElement("output");
        element3.setAttribute("url", "file://$MODULE_DIR$/bin");
        element2.appendChild(element3);
        Element element4 = document.createElement("output-test");
        element4.setAttribute("url", "file://$MODULE_DIR$/bin");
        element2.appendChild(element4);
        element2.appendChild(document.createElement("exclude-output"));
        Element element5 = document.createElement("content");
        element5.setAttribute("url", "file://$MODULE_DIR$");
        element2.appendChild(element5);
        Element element6 = document.createElement("orderEntry");
        element6.setAttribute("type", "inheritedJdk");
        element2.appendChild(element6);
        Element element7 = document.createElement("orderEntry");
        element7.setAttribute("type", "sourceFolder");
        element7.setAttribute("forTests", "false");
        element2.appendChild(element7);
        if (path == null) {
            ProjectConfigGenerator.addSourceFolder(document, element5, "src", false);
            ProjectConfigGenerator.addSourceFolder(document, element5, "res", true);
            classpathEntryArray = new ClasspathEntry[]{};
        } else {
            if (Files.exists(path, new LinkOption[0])) {
                classpathEntryArray = ClasspathEntry.readFromEclipse(path);
            } else {
                classpathEntryArray = ClasspathEntry.readFromConfigless(path.getParent());
                System.out.println("Warning! Classpath file is missing. Default paths were guessed.");
            }
            block6: for (ClasspathEntry object2 : classpathEntryArray) {
                if (!object2.isLocalPath) {
                    throw new IllegalArgumentException("Non-local paths in classpath are not supported yet. Please restructure your project to not rely on them.");
                }
                switch (object2.type) {
                    case Source: 
                    case LibrarySource: {
                        ProjectConfigGenerator.addSourceFolder(document, element5, object2.path, false);
                        continue block6;
                    }
                    case Resource: {
                        ProjectConfigGenerator.addSourceFolder(document, element5, object2.path, true);
                        continue block6;
                    }
                    case HeaderLibrary: {
                        ProjectConfigGenerator.addLibrary(document, element2, object2.path, false);
                        continue block6;
                    }
                    case ExportedLibrary: {
                        ProjectConfigGenerator.addLibrary(document, element2, object2.path, true);
                    }
                }
            }
        }
        Element element8 = document.createElement("excludeFolder");
        element8.setAttribute("url", "file://$MODULE_DIR$/deployed");
        element5.appendChild(element8);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("standalone", "no");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(path2.toFile());
        transformer.transform(dOMSource, streamResult);
        return classpathEntryArray;
    }

    private static void addSourceFolder(Document document, Element element, String string, boolean bl2) {
        Element element2 = document.createElement("sourceFolder");
        element2.setAttribute("url", "file://$MODULE_DIR$/" + string);
        if (bl2) {
            element2.setAttribute("type", "java-resource");
        } else {
            element2.setAttribute("isTestSource", "false");
        }
        element.appendChild(element2);
    }

    private static void addLibrary(Document document, Element element, String string, boolean bl2) {
        Element element2 = document.createElement("orderEntry");
        element2.setAttribute("type", "module-library");
        if (bl2) {
            element2.setAttribute("exported", "");
        }
        element.appendChild(element2);
        Element element3 = document.createElement("library");
        element2.appendChild(element3);
        Element element4 = document.createElement("CLASSES");
        element3.appendChild(element4);
        Element element5 = document.createElement("root");
        element5.setAttribute("url", "jar://$MODULE_DIR$/" + string + "!/");
        element4.appendChild(element5);
        element3.appendChild(document.createElement("JAVADOC"));
        element3.appendChild(document.createElement("SOURCES"));
    }

    public static String[] splitByLastDot(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return new String[]{string, ""};
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        return new String[]{string2, string3};
    }
}

