/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import kemnn.fd;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Component$Identifier;
import net.java.games.input.Component$Identifier$Button;
import net.java.games.input.Controller;
import net.java.games.input.Controller$Type;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DIAbstractController;
import net.java.games.input.DIComponent;
import net.java.games.input.DIDeviceObject;
import net.java.games.input.DIIdentifierMap;
import net.java.games.input.DIKeyboard;
import net.java.games.input.DIMouse;
import net.java.games.input.DirectInputEnvironmentPlugin$1;
import net.java.games.input.DirectInputEnvironmentPlugin$2;
import net.java.games.input.DirectInputEnvironmentPlugin$3;
import net.java.games.input.DirectInputEnvironmentPlugin$4;
import net.java.games.input.DummyWindow;
import net.java.games.input.IDirectInput;
import net.java.games.input.IDirectInputDevice;
import net.java.games.input.Keyboard;
import net.java.games.input.Mouse;

public final class DirectInputEnvironmentPlugin
extends ControllerEnvironment
implements fd {
    private static boolean supported = false;
    private final Controller[] controllers;
    private final List active_devices = new ArrayList();
    private final DummyWindow window;

    static void loadLibrary(String string) {
        AccessController.doPrivileged(new DirectInputEnvironmentPlugin$1(string));
    }

    static String getPrivilegedProperty(String string) {
        return (String)AccessController.doPrivileged(new DirectInputEnvironmentPlugin$2(string));
    }

    static String getPrivilegedProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new DirectInputEnvironmentPlugin$3(string, string2));
    }

    public DirectInputEnvironmentPlugin() {
        DummyWindow dummyWindow = null;
        Controller[] controllerArray = new Controller[]{};
        if (this.isSupported()) {
            try {
                dummyWindow = new DummyWindow();
                try {
                    controllerArray = this.enumControllers(dummyWindow);
                }
                catch (IOException iOException) {
                    dummyWindow.destroy();
                    throw iOException;
                }
            }
            catch (IOException iOException) {
                DirectInputEnvironmentPlugin.logln(new StringBuffer().append("Failed to enumerate devices: ").append(iOException.getMessage()).toString());
            }
            this.window = dummyWindow;
            this.controllers = controllerArray;
            AccessController.doPrivileged(new DirectInputEnvironmentPlugin$4(this));
        } else {
            this.window = null;
            this.controllers = controllerArray;
        }
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    private final Component[] createComponents(IDirectInputDevice iDirectInputDevice, boolean bl2) {
        List list2 = iDirectInputDevice.getObjects();
        ArrayList<DIComponent> arrayList = new ArrayList<DIComponent>();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            DIDeviceObject dIDeviceObject = (DIDeviceObject)list2.get(i2);
            Component$Identifier component$Identifier = dIDeviceObject.getIdentifier();
            if (component$Identifier == null) continue;
            if (bl2 && component$Identifier instanceof Component$Identifier$Button) {
                component$Identifier = DIIdentifierMap.mapMouseButtonIdentifier((Component$Identifier$Button)component$Identifier);
            }
            DIComponent dIComponent = new DIComponent(component$Identifier, dIDeviceObject);
            arrayList.add(dIComponent);
            iDirectInputDevice.registerComponent(dIDeviceObject, dIComponent);
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        return componentArray;
    }

    private final Mouse createMouseFromDevice(IDirectInputDevice iDirectInputDevice) {
        Component[] componentArray = this.createComponents(iDirectInputDevice, true);
        DIMouse dIMouse = new DIMouse(iDirectInputDevice, componentArray, new Controller[0], iDirectInputDevice.getRumblers());
        if (dIMouse.getX() != null && dIMouse.getY() != null && dIMouse.getPrimaryButton() != null) {
            return dIMouse;
        }
        return null;
    }

    private final AbstractController createControllerFromDevice(IDirectInputDevice iDirectInputDevice, Controller$Type controller$Type) {
        Component[] componentArray = this.createComponents(iDirectInputDevice, false);
        DIAbstractController dIAbstractController = new DIAbstractController(iDirectInputDevice, componentArray, new Controller[0], iDirectInputDevice.getRumblers(), controller$Type);
        return dIAbstractController;
    }

    private final Keyboard createKeyboardFromDevice(IDirectInputDevice iDirectInputDevice) {
        Component[] componentArray = this.createComponents(iDirectInputDevice, false);
        return new DIKeyboard(iDirectInputDevice, componentArray, new Controller[0], iDirectInputDevice.getRumblers());
    }

    private final Controller createControllerFromDevice(IDirectInputDevice iDirectInputDevice) {
        switch (iDirectInputDevice.getType()) {
            case 18: {
                return this.createMouseFromDevice(iDirectInputDevice);
            }
            case 19: {
                return this.createKeyboardFromDevice(iDirectInputDevice);
            }
            case 21: {
                return this.createControllerFromDevice(iDirectInputDevice, Controller$Type.GAMEPAD);
            }
            case 22: {
                return this.createControllerFromDevice(iDirectInputDevice, Controller$Type.WHEEL);
            }
            case 20: 
            case 23: 
            case 24: {
                return this.createControllerFromDevice(iDirectInputDevice, Controller$Type.STICK);
            }
        }
        return this.createControllerFromDevice(iDirectInputDevice, Controller$Type.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Controller[] enumControllers(DummyWindow dummyWindow) throws IOException {
        Controller[] controllerArray;
        ArrayList<Controller> arrayList = new ArrayList<Controller>();
        IDirectInput iDirectInput = new IDirectInput(dummyWindow);
        try {
            controllerArray = iDirectInput.getDevices();
            for (int i2 = 0; i2 < controllerArray.size(); ++i2) {
                IDirectInputDevice iDirectInputDevice = (IDirectInputDevice)controllerArray.get(i2);
                Controller controller = this.createControllerFromDevice(iDirectInputDevice);
                if (controller != null) {
                    arrayList.add(controller);
                    this.active_devices.add(iDirectInputDevice);
                    continue;
                }
                iDirectInputDevice.release();
            }
        }
        finally {
            iDirectInput.release();
        }
        controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    static boolean access$002(boolean bl2) {
        supported = bl2;
        return supported;
    }

    static List access$200(DirectInputEnvironmentPlugin directInputEnvironmentPlugin) {
        return directInputEnvironmentPlugin.active_devices;
    }

    static {
        String string = DirectInputEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (string.startsWith("Windows")) {
            supported = true;
            if ("x86".equals(DirectInputEnvironmentPlugin.getPrivilegedProperty("os.arch"))) {
                DirectInputEnvironmentPlugin.loadLibrary("jinput-dx8");
            } else {
                DirectInputEnvironmentPlugin.loadLibrary("jinput-dx8_64");
            }
        }
    }
}

