/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.zip.CRC32;
import java.util.zip.ZipException;
import org.apache.tools.zip.UnixStat;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;

public class AsiExtraField
implements Cloneable,
UnixStat,
ZipExtraField {
    private static final ZipShort HEADER_ID = new ZipShort(30062);
    private static final int WORD = 4;
    private int mode = 0;
    private int uid = 0;
    private int gid = 0;
    private String link = "";
    private boolean dirFlag = false;
    private CRC32 crc = new CRC32();

    @Override
    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(14 + this.getLinkedFile().getBytes().length);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    @Override
    public byte[] getLocalFileDataData() {
        byte[] byArray = new byte[this.getLocalFileDataLength().getValue() - 4];
        System.arraycopy(ZipShort.getBytes(this.getMode()), 0, byArray, 0, 2);
        byte[] byArray2 = this.getLinkedFile().getBytes();
        System.arraycopy(ZipLong.getBytes(byArray2.length), 0, byArray, 2, 4);
        System.arraycopy(ZipShort.getBytes(this.getUserId()), 0, byArray, 6, 2);
        System.arraycopy(ZipShort.getBytes(this.getGroupId()), 0, byArray, 8, 2);
        System.arraycopy(byArray2, 0, byArray, 10, byArray2.length);
        this.crc.reset();
        this.crc.update(byArray);
        long l2 = this.crc.getValue();
        byte[] byArray3 = new byte[byArray.length + 4];
        System.arraycopy(ZipLong.getBytes(l2), 0, byArray3, 0, 4);
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        return byArray3;
    }

    @Override
    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public void setUserId(int n2) {
        this.uid = n2;
    }

    public int getUserId() {
        return this.uid;
    }

    public void setGroupId(int n2) {
        this.gid = n2;
    }

    public int getGroupId() {
        return this.gid;
    }

    public void setLinkedFile(String string) {
        this.link = string;
        this.mode = this.getMode(this.mode);
    }

    public String getLinkedFile() {
        return this.link;
    }

    public boolean isLink() {
        return this.getLinkedFile().length() != 0;
    }

    public void setMode(int n2) {
        this.mode = this.getMode(n2);
    }

    public int getMode() {
        return this.mode;
    }

    public void setDirectory(boolean bl2) {
        this.dirFlag = bl2;
        this.mode = this.getMode(this.mode);
    }

    public boolean isDirectory() {
        return this.dirFlag && !this.isLink();
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n2, int n3) throws ZipException {
        String string;
        AsiExtraField asiExtraField;
        long l2 = ZipLong.getValue(byArray, n2);
        byte[] byArray2 = new byte[n3 - 4];
        System.arraycopy(byArray, n2 + 4, byArray2, 0, n3 - 4);
        this.crc.reset();
        this.crc.update(byArray2);
        long l3 = this.crc.getValue();
        if (l2 != l3) {
            throw new ZipException(new StringBuffer().append("bad CRC checksum ").append(Long.toHexString(l2)).append(" instead of ").append(Long.toHexString(l3)).toString());
        }
        int n4 = ZipShort.getValue(byArray2, 0);
        byte[] byArray3 = new byte[(int)ZipLong.getValue(byArray2, 2)];
        this.uid = ZipShort.getValue(byArray2, 6);
        this.gid = ZipShort.getValue(byArray2, 8);
        if (byArray3.length == 0) {
            asiExtraField = this;
            string = "";
        } else {
            System.arraycopy(byArray2, 10, byArray3, 0, byArray3.length);
            asiExtraField = this;
            string = new String(byArray3);
        }
        asiExtraField.link = string;
        this.setDirectory((n4 & 0x4000) != 0);
        this.setMode(n4);
    }

    protected int getMode(int n2) {
        int n3;
        block4: {
            int n4;
            block3: {
                block2: {
                    n3 = 32768;
                    if (!this.isLink()) break block2;
                    n4 = 40960;
                    break block3;
                }
                if (!this.isDirectory()) break block4;
                n4 = 16384;
            }
            n3 = n4;
        }
        return n3 | n2 & 0xFFF;
    }
}

