/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.bridj.BridJ;
import org.bridj.CRuntime$MethodCallInfoBuilder;
import org.bridj.DynamicFunction;
import org.bridj.JNI;
import org.bridj.MethodCallInfo;
import org.bridj.Pointer;

public class DynamicFunctionFactory {
    final Constructor constructor;
    final Method method;
    final long callbackHandle;

    DynamicFunctionFactory(Class clazz, Method method, CRuntime$MethodCallInfoBuilder cRuntime$MethodCallInfoBuilder) {
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
            this.method = method;
            MethodCallInfo methodCallInfo = cRuntime$MethodCallInfoBuilder.apply(method);
            this.callbackHandle = JNI.bindJavaToCCallbacks(methodCallInfo);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("Failed to instantiate callback : " + throwable, throwable);
        }
    }

    protected void finalize() throws Throwable {
        if (BridJ.debugNeverFree) {
            return;
        }
        JNI.freeJavaToCCallbacks(this.callbackHandle, 1);
    }

    public DynamicFunction newInstance(Pointer pointer) {
        if (pointer == null) {
            return null;
        }
        try {
            DynamicFunction dynamicFunction = (DynamicFunction)this.constructor.newInstance(new Object[0]);
            dynamicFunction.peer = pointer;
            dynamicFunction.method = this.method;
            dynamicFunction.factory = this;
            return dynamicFunction;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("Failed to instantiate callback : " + throwable, throwable);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.method + ")";
    }
}

