/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.win32.OS;

public class Pattern
extends Resource {
    public int handle;

    public Pattern(Device device, Image image) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device.checkGDIP();
        int[] nArray = image.createGdipImage();
        int n2 = nArray[0];
        int n3 = Gdip.Image_GetWidth(n2);
        int n4 = Gdip.Image_GetHeight(n2);
        this.handle = Gdip.TextureBrush_new(n2, 0, 0.0f, 0.0f, n3, n4);
        Gdip.Bitmap_delete(n2);
        if (nArray[1] != 0) {
            int n5 = OS.GetProcessHeap();
            OS.HeapFree(n5, 0, nArray[1]);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Pattern(Device device, float f2, float f3, float f4, float f5, Color color, Color color2) {
        this(device, f2, f3, f4, f5, color, 255, color2, 255);
    }

    public Pattern(Device device, float f2, float f3, float f4, float f5, Color color, int n2, Color color2, int n3) {
        super(device);
        f2 = DPIUtil.autoScaleUp(f2);
        f3 = DPIUtil.autoScaleUp(f3);
        f4 = DPIUtil.autoScaleUp(f4);
        f5 = DPIUtil.autoScaleUp(f5);
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        this.device.checkGDIP();
        int n4 = color.handle;
        int n5 = n4 >> 16 & 0xFF | n4 & 0xFF00 | (n4 & 0xFF) << 16;
        int n6 = Gdip.Color_new((n2 & 0xFF) << 24 | n5);
        if (f2 == f4 && f3 == f5) {
            this.handle = Gdip.SolidBrush_new(n6);
            if (this.handle == 0) {
                SWT.error(2);
            }
        } else {
            int n7 = color2.handle;
            n5 = n7 >> 16 & 0xFF | n7 & 0xFF00 | (n7 & 0xFF) << 16;
            int n8 = Gdip.Color_new((n3 & 0xFF) << 24 | n5);
            PointF pointF = new PointF();
            pointF.X = f2;
            pointF.Y = f3;
            PointF pointF2 = new PointF();
            pointF2.X = f4;
            pointF2.Y = f5;
            this.handle = Gdip.LinearGradientBrush_new(pointF, pointF2, n6, n8);
            if (this.handle == 0) {
                SWT.error(2);
            }
            if (n2 != 255 || n3 != 255) {
                int n9 = (int)((float)(n2 & 0xFF) * 0.5f + (float)(n3 & 0xFF) * 0.5f);
                int n10 = (int)((float)((n4 & 0xFF) >> 0) * 0.5f + (float)((n7 & 0xFF) >> 0) * 0.5f);
                int n11 = (int)((float)((n4 & 0xFF00) >> 8) * 0.5f + (float)((n7 & 0xFF00) >> 8) * 0.5f);
                int n12 = (int)((float)((n4 & 0xFF0000) >> 16) * 0.5f + (float)((n7 & 0xFF0000) >> 16) * 0.5f);
                int n13 = Gdip.Color_new(n9 << 24 | n10 << 16 | n11 << 8 | n12);
                Gdip.LinearGradientBrush_SetInterpolationColors(this.handle, new int[]{n6, n13, n8}, new float[]{0.0f, 0.5f, 1.0f}, 3);
                Gdip.Color_delete(n13);
            }
            Gdip.Color_delete(n8);
        }
        Gdip.Color_delete(n6);
        this.init();
    }

    @Override
    void destroy() {
        int n2 = Gdip.Brush_GetType(this.handle);
        switch (n2) {
            case 0: {
                Gdip.SolidBrush_delete(this.handle);
                break;
            }
            case 1: {
                Gdip.HatchBrush_delete(this.handle);
                break;
            }
            case 4: {
                Gdip.LinearGradientBrush_delete(this.handle);
                break;
            }
            case 2: {
                Gdip.TextureBrush_delete(this.handle);
            }
        }
        this.handle = 0;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + this.handle + "}";
    }
}

