/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;

public class Callback {
    Object object;
    String method;
    String signature;
    int argCount;
    int address;
    int errorResult;
    boolean isStatic;
    boolean isArrayBased;
    static final boolean is32Bit = C.PTR_SIZEOF == 4;
    static final String PTR_SIGNATURE = is32Bit ? "I" : "J";
    static final String SIGNATURE_0 = Callback.getSignature(0);
    static final String SIGNATURE_1 = Callback.getSignature(1);
    static final String SIGNATURE_2 = Callback.getSignature(2);
    static final String SIGNATURE_3 = Callback.getSignature(3);
    static final String SIGNATURE_4 = Callback.getSignature(4);
    static final String SIGNATURE_N = "([" + PTR_SIGNATURE + ")" + PTR_SIGNATURE;

    public Callback(Object object, String string, int n2) {
        this(object, string, n2, false);
    }

    public Callback(Object object, String string, int n2, boolean bl2) {
        this(object, string, n2, bl2, 0);
    }

    public Callback(Object object, String string, int n2, boolean bl2, int n3) {
        this.object = object;
        this.method = string;
        this.argCount = n2;
        this.isStatic = object instanceof Class;
        this.isArrayBased = bl2;
        this.errorResult = n3;
        if (bl2) {
            this.signature = SIGNATURE_N;
        } else {
            switch (n2) {
                case 0: {
                    this.signature = SIGNATURE_0;
                    break;
                }
                case 1: {
                    this.signature = SIGNATURE_1;
                    break;
                }
                case 2: {
                    this.signature = SIGNATURE_2;
                    break;
                }
                case 3: {
                    this.signature = SIGNATURE_3;
                    break;
                }
                case 4: {
                    this.signature = SIGNATURE_4;
                    break;
                }
                default: {
                    this.signature = Callback.getSignature(n2);
                }
            }
        }
        this.address = Callback.bind(this, object, string, this.signature, n2, this.isStatic, bl2, n3);
    }

    public Callback(Object object, String string, Type type2, Type[] typeArray) {
        this.object = object;
        this.method = string;
        this.argCount = typeArray != null ? typeArray.length : 0;
        this.isStatic = object instanceof Class;
        this.isArrayBased = false;
        this.errorResult = 0;
        Function<Type, String> function = type -> {
            if (Integer.TYPE.equals(type)) {
                return "I";
            }
            if (Long.TYPE.equals(type)) {
                return "J";
            }
            if (Void.TYPE.equals(type)) {
                return "V";
            }
            if (Byte.TYPE.equals(type)) {
                return "B";
            }
            if (Character.TYPE.equals(type)) {
                return "C";
            }
            if (Double.TYPE.equals(type)) {
                return "D";
            }
            if (Float.TYPE.equals(type)) {
                return "F";
            }
            if (Short.TYPE.equals(type)) {
                return "S";
            }
            if (Boolean.TYPE.equals(type)) {
                return "Z";
            }
            SWT.error(5, null, type.toString() + "Not supported");
            return null;
        };
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Type type3 : typeArray) {
            if (type3.equals(Void.TYPE)) {
                SWT.error(5, null, "void is not a valid argument");
            }
            stringBuilder.append(function.apply(type3));
        }
        stringBuilder.append(")");
        stringBuilder.append(function.apply(type2));
        this.signature = stringBuilder.toString();
        if (is32Bit) {
            this.signature = this.signature.replace("J", "I");
        }
        this.address = Callback.bind(this, this.object, this.method, this.signature, this.argCount, this.isStatic, this.isArrayBased, this.errorResult);
    }

    static synchronized native int bind(Callback var0, Object var1, String var2, String var3, int var4, boolean var5, boolean var6, int var7);

    public void dispose() {
        if (this.object == null) {
            return;
        }
        Callback.unbind(this);
        this.signature = null;
        this.method = null;
        this.object = null;
        this.address = 0;
    }

    public int getAddress() {
        return this.address;
    }

    public static native String getPlatform();

    public static native int getEntryCount();

    static String getSignature(int n2) {
        String string = "(";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + PTR_SIGNATURE;
        }
        string = string + ")" + PTR_SIGNATURE;
        return string;
    }

    public static final synchronized native void setEnabled(boolean var0);

    public static final synchronized native boolean getEnabled();

    static final void ignoreCallbacks(boolean bl2) {
        Callback.setEnabled(!bl2);
    }

    public static final synchronized native void reset();

    static final synchronized native void unbind(Callback var0);
}

