/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.internal.image.PngDecodingDataStream;
import org.eclipse.swt.internal.image.PngHuffmanTable;

public class PngHuffmanTables {
    PngHuffmanTable literalTable;
    PngHuffmanTable distanceTable;
    static PngHuffmanTable FixedLiteralTable;
    static PngHuffmanTable FixedDistanceTable;
    static final int LiteralTableSize = 288;
    static final int[] FixedLiteralLengths;
    static final int DistanceTableSize = 32;
    static final int[] FixedDistanceLengths;
    static final int LengthCodeTableSize = 19;
    static final int[] LengthCodeOrder;

    static PngHuffmanTables getDynamicTables(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        return new PngHuffmanTables(pngDecodingDataStream);
    }

    static PngHuffmanTables getFixedTables() {
        return new PngHuffmanTables();
    }

    private PngHuffmanTable getFixedLiteralTable() {
        if (FixedLiteralTable == null) {
            FixedLiteralTable = new PngHuffmanTable(FixedLiteralLengths);
        }
        return FixedLiteralTable;
    }

    private PngHuffmanTable getFixedDistanceTable() {
        if (FixedDistanceTable == null) {
            FixedDistanceTable = new PngHuffmanTable(FixedDistanceLengths);
        }
        return FixedDistanceTable;
    }

    private PngHuffmanTables() {
        this.literalTable = this.getFixedLiteralTable();
        this.distanceTable = this.getFixedDistanceTable();
    }

    private PngHuffmanTables(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        int n2 = 257 + pngDecodingDataStream.getNextIdatBits(5);
        int n3 = 1 + pngDecodingDataStream.getNextIdatBits(5);
        int n4 = 4 + pngDecodingDataStream.getNextIdatBits(4);
        if (n4 > 19) {
            pngDecodingDataStream.error();
        }
        int[] nArray = new int[19];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[PngHuffmanTables.LengthCodeOrder[i2]] = pngDecodingDataStream.getNextIdatBits(3);
        }
        PngHuffmanTable pngHuffmanTable = new PngHuffmanTable(nArray);
        int[] nArray2 = this.readLengths(pngDecodingDataStream, n2, pngHuffmanTable, 288);
        int[] nArray3 = this.readLengths(pngDecodingDataStream, n3, pngHuffmanTable, 32);
        this.literalTable = new PngHuffmanTable(nArray2);
        this.distanceTable = new PngHuffmanTable(nArray3);
    }

    private int[] readLengths(PngDecodingDataStream pngDecodingDataStream, int n2, PngHuffmanTable pngHuffmanTable, int n3) throws IOException {
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            int n7 = pngHuffmanTable.getNextValue(pngDecodingDataStream);
            if (n7 < 16) {
                nArray[n4] = n7;
                ++n4;
                continue;
            }
            if (n7 == 16) {
                n6 = pngDecodingDataStream.getNextIdatBits(2) + 3;
                for (n5 = 0; n5 < n6; ++n5) {
                    nArray[n4] = nArray[n4 - 1];
                    ++n4;
                }
                continue;
            }
            if (n7 == 17) {
                n6 = pngDecodingDataStream.getNextIdatBits(3) + 3;
                for (n5 = 0; n5 < n6; ++n5) {
                    nArray[n4] = 0;
                    ++n4;
                }
                continue;
            }
            if (n7 == 18) {
                n6 = pngDecodingDataStream.getNextIdatBits(7) + 11;
                for (n5 = 0; n5 < n6; ++n5) {
                    nArray[n4] = 0;
                    ++n4;
                }
                continue;
            }
            pngDecodingDataStream.error();
        }
        return nArray;
    }

    int getNextLiteralValue(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        return this.literalTable.getNextValue(pngDecodingDataStream);
    }

    int getNextDistanceValue(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        return this.distanceTable.getNextValue(pngDecodingDataStream);
    }

    static {
        FixedLiteralLengths = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8};
        FixedDistanceLengths = new int[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
        LengthCodeOrder = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    }
}

