/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messageCount;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;
    static final int GROW_SIZE = 4;
    static final int MESSAGE_LIMIT = 64;
    static final boolean IS_COCOA = "cocoa".equals(SWT.getPlatform());
    static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    public Synchronizer(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveAllEventsTo(Synchronizer synchronizer) {
        int n2;
        RunnableLock[] runnableLockArray;
        Object object = this.messageLock;
        synchronized (object) {
            runnableLockArray = this.messages;
            this.messages = null;
            n2 = this.messageCount;
            this.messageCount = 0;
        }
        synchronizer.addFirst(runnableLockArray, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFirst(RunnableLock[] runnableLockArray, int n2) {
        if (n2 <= 0) {
            return;
        }
        boolean bl2 = false;
        Object object = this.messageLock;
        synchronized (object) {
            int n3 = this.messageCount + Math.max(n2, 4);
            if (this.messages == null) {
                this.messages = new RunnableLock[n3];
            }
            if (this.messages.length < this.messageCount + n2) {
                RunnableLock[] runnableLockArray2 = new RunnableLock[n3];
                System.arraycopy(this.messages, 0, runnableLockArray2, n2, this.messageCount);
                this.messages = runnableLockArray2;
            } else {
                System.arraycopy(this.messages, 0, this.messages, n2, this.messageCount);
            }
            System.arraycopy(runnableLockArray, 0, this.messages, 0, n2);
            bl2 = this.messageCount == 0;
            this.messageCount += n2;
        }
        if (bl2) {
            this.display.wakeThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(RunnableLock runnableLock) {
        boolean bl2 = false;
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messageCount == this.messages.length) {
                RunnableLock[] runnableLockArray = new RunnableLock[this.messageCount + 4];
                System.arraycopy(this.messages, 0, runnableLockArray, 0, this.messageCount);
                this.messages = runnableLockArray;
            }
            this.messages[this.messageCount++] = runnableLock;
            bl2 = this.messageCount == 1;
        }
        if (bl2) {
            this.display.wakeThread();
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable == null && !IS_GTK && !IS_COCOA) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMessageCount() {
        Object object = this.messageLock;
        synchronized (object) {
            return this.messageCount;
        }
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messageCount == 0) {
                return null;
            }
            RunnableLock runnableLock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0 && this.messages.length > 64) {
                this.messages = null;
            }
            return runnableLock;
        }
    }

    boolean runAsyncMessages() {
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runAsyncMessages(boolean bl2) {
        boolean bl3 = false;
        do {
            RunnableLock runnableLock;
            if ((runnableLock = this.removeFirst()) == null) {
                return bl3;
            }
            bl3 = true;
            RunnableLock runnableLock2 = runnableLock;
            synchronized (runnableLock2) {
                this.syncThread = runnableLock.thread;
                this.display.sendPreEvent(0);
                try {
                    runnableLock.run(this.display);
                }
                catch (Throwable throwable) {
                    runnableLock.throwable = throwable;
                    SWT.error(46, throwable);
                }
                finally {
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.sendPostEvent(0);
                    }
                    this.syncThread = null;
                    runnableLock.notifyAll();
                }
            }
        } while (bl2);
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncExec(Runnable runnable) {
        RunnableLock runnableLock = null;
        Object object = Device.class;
        synchronized (Device.class) {
            if (this.display == null || this.display.isDisposed()) {
                SWT.error(45);
            }
            if (!this.display.isValidThread()) {
                if (runnable == null) {
                    this.display.wake();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                runnableLock = new RunnableLock(runnable);
                runnableLock.thread = Thread.currentThread();
                this.addLast(runnableLock);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (runnableLock == null) {
                if (runnable != null) {
                    this.display.sendPreEvent(0);
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException runtimeException) {
                        this.display.getRuntimeExceptionHandler().accept(runtimeException);
                    }
                    catch (Error error) {
                        this.display.getErrorHandler().accept(error);
                    }
                    finally {
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.sendPostEvent(0);
                        }
                    }
                }
                return;
            }
            object = runnableLock;
            synchronized (object) {
                boolean bl2 = false;
                while (!runnableLock.done()) {
                    try {
                        runnableLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                if (runnableLock.throwable != null) {
                    SWT.error(46, runnableLock.throwable);
                }
            }
            return;
        }
    }
}

