/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTBHOTITEM;
import org.eclipse.swt.internal.win32.NMTOOLBAR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int lastFocusId;
    int lastArrowId;
    int lastHotId;
    ToolItem[] items;
    ToolItem[] tabItemList;
    boolean ignoreResize;
    boolean ignoreMouse;
    ImageList imageList;
    ImageList disabledImageList;
    ImageList hotImageList;
    static final int ToolBarProc;
    static final TCHAR ToolBarClass;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;

    public ToolBar(Composite composite, int n2) {
        super(composite, ToolBar.checkStyle(n2));
        if ((n2 & 0x200) != 0) {
            this.style |= 0x200;
            int n3 = OS.GetWindowLong(this.handle, -16);
            if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (n2 & 0x20000) != 0) {
                n3 |= 0x1000;
            }
            OS.SetWindowLong(this.handle, -16, n3 | 0x80);
        } else {
            this.style |= 0x100;
        }
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (n3 == 262) {
            return OS.DefWindowProc(n2, n3, n4, n5);
        }
        return OS.CallWindowProc(ToolBarProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x800000) == 0) {
            n2 |= 0x80000;
        }
        if ((n2 & 0x200) != 0) {
            n2 &= 0xFFFFFFBF;
        }
        return n2 & 0xFFFFFCFF;
    }

    @Override
    void checkBuffered() {
        super.checkBuffered();
        if (OS.COMCTL32_MAJOR >= 6) {
            this.style |= 0x20000000;
        }
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        Object object;
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x200) != 0) {
            object = new RECT();
            TBBUTTON tBBUTTON = new TBBUTTON();
            int n6 = OS.SendMessage(this.handle, 1048, 0, 0);
            for (int i2 = 0; i2 < n6; ++i2) {
                OS.SendMessage(this.handle, 1053, i2, (RECT)object);
                n5 = Math.max(n5, ((RECT)object).bottom);
                OS.SendMessage(this.handle, 1047, i2, tBBUTTON);
                if ((tBBUTTON.fsStyle & 1) != 0) {
                    TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                    tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                    tBBUTTONINFO.dwMask = 64;
                    OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, tBBUTTON.idCommand, tBBUTTONINFO);
                    n4 = Math.max(n4, tBBUTTONINFO.cx);
                    continue;
                }
                n4 = Math.max(n4, ((RECT)object).right);
            }
        } else {
            object = new RECT();
            OS.GetWindowRect(this.handle, (RECT)object);
            int n7 = ((RECT)object).right - ((RECT)object).left;
            int n8 = ((RECT)object).bottom - ((RECT)object).top;
            int n9 = this.getBorderWidthInPixels();
            int n10 = n2 == -1 ? 16383 : n2 + n9 * 2;
            int n11 = n3 == -1 ? 16383 : n3 + n9 * 2;
            boolean bl3 = this.getDrawing() && OS.IsWindowVisible(this.handle);
            this.ignoreResize = true;
            if (bl3) {
                OS.UpdateWindow(this.handle);
            }
            int n12 = 30;
            this.SetWindowPos(this.handle, 0, 0, 0, n10, n11, n12);
            int n13 = OS.SendMessage(this.handle, 1048, 0, 0);
            if (n13 != 0) {
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, n13 - 1, rECT);
                n4 = Math.max(n4, rECT.right);
                n5 = Math.max(n5, rECT.bottom);
            }
            this.SetWindowPos(this.handle, 0, 0, 0, n7, n8, n12);
            if (bl3) {
                OS.ValidateRect(this.handle, null);
            }
            this.ignoreResize = false;
        }
        if (n4 == 0) {
            n4 = 24;
        }
        if (n5 == 0) {
            n5 = 22;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        object = this.computeTrimInPixels(0, 0, n4, n5);
        n4 = ((Rectangle)object).width;
        n5 = ((Rectangle)object).height;
        return new Point(n4, n5);
    }

    @Override
    Rectangle computeTrimInPixels(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = super.computeTrimInPixels(n2, n3, n4, n5);
        int n6 = OS.GetWindowLong(this.handle, -16);
        if ((n6 & 0x40) == 0) {
            rectangle.height += 2;
        }
        return rectangle;
    }

    @Override
    Widget computeTabGroup() {
        int n2;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            for (n2 = 0; n2 < toolItemArray.length && toolItemArray[n2].control == null; ++n2) {
            }
            if (n2 == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        if ((n2 = OS.SendMessage(this.handle, 1095, 0, 0)) == -1) {
            n2 = this.lastHotId;
        }
        while (n2 >= 0) {
            ToolItem toolItem = toolItemArray[n2];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n2;
        }
        return super.computeTabGroup();
    }

    @Override
    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n2;
            for (n2 = 0; n2 < toolItemArray.length && toolItemArray[n2].control == null; ++n2) {
            }
            if (n2 == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        for (int i2 = 0; i2 < toolItemArray2.length; ++i2) {
            ToolItem toolItem = toolItemArray2[i2];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    @Override
    void createHandle() {
        int n2;
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if (!((this.style & 0x800000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            n2 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n2 &= 0xFFFF7FFF);
        }
        n2 = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n2, 0);
        OS.SendMessage(this.handle, 1054, TBBUTTON.sizeof, 0);
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
        int n3 = 25;
        if (OS.COMCTL32_MAJOR >= 6) {
            n3 |= 0x80;
        }
        OS.SendMessage(this.handle, 1108, 0, n3);
    }

    void createItem(ToolItem toolItem, int n2) {
        int n3;
        int n4 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (0 > n2 || n2 > n4) {
            this.error(6);
        }
        for (n3 = 0; n3 < this.items.length && this.items[n3] != null; ++n3) {
        }
        if (n3 == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        int n5 = toolItem.widgetStyle();
        TBBUTTON tBBUTTON = new TBBUTTON();
        tBBUTTON.idCommand = n3;
        tBBUTTON.fsStyle = (byte)n5;
        tBBUTTON.fsState = (byte)4;
        if ((n5 & 1) == 0) {
            tBBUTTON.iBitmap = -2;
        }
        if (OS.SendMessage(this.handle, OS.TB_INSERTBUTTON, n2, tBBUTTON) == 0) {
            this.error(14);
        }
        toolItem.id = n3;
        this.items[toolItem.id] = toolItem;
        if ((this.style & 0x200) != 0) {
            this.setRowCount(n4 + 1);
        }
        this.layoutItems();
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.lastHotId = -1;
        this.lastArrowId = -1;
        this.lastFocusId = -1;
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    void destroyItem(ToolItem toolItem) {
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 9;
        int n2 = OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, toolItem.id, tBBUTTONINFO);
        if ((tBBUTTONINFO.fsStyle & 1) == 0 && tBBUTTONINFO.iImage != -2) {
            if (this.imageList != null) {
                this.imageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.hotImageList != null) {
                this.hotImageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.disabledImageList != null) {
                this.disabledImageList.put(tBBUTTONINFO.iImage, null);
            }
        }
        OS.SendMessage(this.handle, 1046, n2, 0);
        if (toolItem.id == this.lastFocusId) {
            this.lastFocusId = -1;
        }
        if (toolItem.id == this.lastArrowId) {
            this.lastArrowId = -1;
        }
        if (toolItem.id == this.lastHotId) {
            this.lastHotId = -1;
        }
        this.items[toolItem.id] = null;
        toolItem.id = -1;
        int n3 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (n3 == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 1072, 0, 0);
                this.display.releaseToolImageList(this.imageList);
            }
            if (this.hotImageList != null) {
                OS.SendMessage(this.handle, 1076, 0, 0);
                this.display.releaseToolHotImageList(this.hotImageList);
            }
            if (this.disabledImageList != null) {
                OS.SendMessage(this.handle, 1078, 0, 0);
                this.display.releaseToolDisabledImageList(this.disabledImageList);
            }
            this.disabledImageList = null;
            this.hotImageList = null;
            this.imageList = null;
            this.items = new ToolItem[4];
        }
        if ((this.style & 0x200) != 0) {
            this.setRowCount(n3 - 1);
        }
        this.layoutItems();
    }

    @Override
    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            ToolItem toolItem = this.items[i2];
            if (toolItem == null || (toolItem.style & 2) != 0) continue;
            toolItem.updateImages(bl2 && toolItem.getEnabled());
        }
    }

    ImageList getDisabledImageList() {
        return this.disabledImageList;
    }

    ImageList getHotImageList() {
        return this.hotImageList;
    }

    ImageList getImageList() {
        return this.imageList;
    }

    public ToolItem getItem(int n2) {
        TBBUTTON tBBUTTON;
        int n3;
        this.checkWidget();
        int n4 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (0 > n2 || n2 >= n4) {
            this.error(6);
        }
        if ((n3 = OS.SendMessage(this.handle, 1047, n2, tBBUTTON = new TBBUTTON())) == 0) {
            this.error(8);
        }
        return this.items[tBBUTTON.idCommand];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    ToolItem getItemInPixels(Point point) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i2 = 0; i2 < toolItemArray.length; ++i2) {
            Rectangle rectangle = toolItemArray[i2].getBoundsInPixels();
            if (!rectangle.contains(point)) continue;
            return toolItemArray[i2];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1048, 0, 0);
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        int n2 = OS.SendMessage(this.handle, 1048, 0, 0);
        TBBUTTON tBBUTTON = new TBBUTTON();
        ToolItem[] toolItemArray = new ToolItem[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            OS.SendMessage(this.handle, 1047, i2, tBBUTTON);
            toolItemArray[i2] = this.items[tBBUTTON.idCommand];
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        if ((this.style & 0x200) != 0) {
            return OS.SendMessage(this.handle, 1048, 0, 0);
        }
        return OS.SendMessage(this.handle, 1064, 0, 0);
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.tabItemList.length; ++i2) {
            if (this.tabItemList[i2].isDisposed()) continue;
            ++n2;
        }
        if (n2 == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < this.tabItemList.length; ++i3) {
            if (this.tabItemList[i3].isDisposed()) continue;
            toolItemArray[n3++] = this.tabItemList[i3];
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        return OS.SendMessage(this.handle, 1049, toolItem.id, 0);
    }

    void layoutItems() {
        int n2;
        int n3;
        int n4;
        int n5;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.style & 0x20000) != 0 && (this.style & 0x200) == 0) {
            n5 = 0;
            boolean bl2 = false;
            for (n4 = 0; n4 < this.items.length; ++n4) {
                ToolItem toolItem = this.items[n4];
                if (toolItem == null) continue;
                if (n5 == 0) {
                    int n6 = n5 = toolItem.text.length() != 0 ? 1 : 0;
                }
                if (!bl2) {
                    boolean bl3 = bl2 = toolItem.image != null;
                }
                if (n5 != 0 && bl2) break;
            }
            n3 = n4 = OS.GetWindowLong(this.handle, -16);
            n3 = n5 != 0 && bl2 ? (n3 |= 0x1000) : (n3 &= 0xFFFFEFFF);
            if (n3 != n4) {
                this.setDropDownItems(false);
                OS.SetWindowLong(this.handle, -16, n3);
                n2 = OS.SendMessage(this.handle, 49, 0, 0);
                OS.SendMessage(this.handle, 48, n2, 0);
                this.setDropDownItems(true);
            }
        }
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 1057, 0, 0);
        }
        if ((this.style & 0x200) != 0 && (n5 = OS.SendMessage(this.handle, 1048, 0, 0)) > 1) {
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 64;
            n4 = OS.SendMessage(this.handle, 1082, 0, 0);
            tBBUTTONINFO.cx = (short)OS.LOWORD(n4);
            n2 = 0;
            for (n3 = 0; n3 < this.items.length; ++n3) {
                ToolItem toolItem = this.items[n3];
                if (toolItem == null || (toolItem.style & 4) == 0) continue;
                n2 = 1;
                break;
            }
            if (n3 < this.items.length) {
                int n7 = OS.SendMessage(this.handle, 1110, 0, 0);
                tBBUTTONINFO.cx = (short)(tBBUTTONINFO.cx + OS.LOWORD(n7 + n2) * 2);
            }
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                ToolItem toolItem = this.items[i2];
                if (toolItem == null || (toolItem.style & 2) != 0) continue;
                OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, toolItem.id, tBBUTTONINFO);
            }
        }
        if ((this.style & 0x240) != 0 && ((n5 = OS.GetWindowLong(this.handle, -16)) & 0x1000) != 0) {
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 64;
            for (n4 = 0; n4 < this.items.length; ++n4) {
                ToolItem toolItem = this.items[n4];
                if (toolItem == null || toolItem.cx <= 0) continue;
                tBBUTTONINFO.cx = toolItem.cx;
                OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, toolItem.id, tBBUTTONINFO);
            }
        }
        for (n5 = 0; n5 < this.items.length; ++n5) {
            ToolItem toolItem = this.items[n5];
            if (toolItem == null) continue;
            toolItem.resizeControl();
        }
    }

    @Override
    boolean mnemonicHit(char c2) {
        int[] nArray;
        int n2 = Display.wcsToMbcs(c2);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, n2, nArray = new int[1]) == 0) {
            return false;
        }
        if ((this.style & 0x800000) != 0 && !this.setTabGroupFocus()) {
            return false;
        }
        int n3 = OS.SendMessage(this.handle, 1049, nArray[0], 0);
        if (n3 == -1) {
            return false;
        }
        OS.SendMessage(this.handle, 1096, n3, 0);
        this.items[nArray[0]].click(false);
        return true;
    }

    @Override
    boolean mnemonicMatch(char c2) {
        int[] nArray;
        int n2 = Display.wcsToMbcs(c2);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, n2, nArray = new int[1]) == 0) {
            return false;
        }
        int n3 = OS.SendMessage(this.handle, 1049, nArray[0], 0);
        if (n3 == -1) {
            return false;
        }
        return this.findMnemonic(this.items[nArray[0]].text) != '\u0000';
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                ToolItem toolItem = this.items[i2];
                if (toolItem == null || toolItem.isDisposed()) continue;
                toolItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 1072, 0, 0);
            this.display.releaseToolImageList(this.imageList);
        }
        if (this.hotImageList != null) {
            OS.SendMessage(this.handle, 1076, 0, 0);
            this.display.releaseToolHotImageList(this.hotImageList);
        }
        if (this.disabledImageList != null) {
            OS.SendMessage(this.handle, 1078, 0, 0);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
        }
        this.disabledImageList = null;
        this.hotImageList = null;
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            ToolItem toolItem = this.items[i2];
            if (toolItem == null || toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    @Override
    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                ToolItem toolItem = this.items[i2];
                if (toolItem == null) continue;
                toolItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    @Override
    void setBackgroundImage(int n2) {
        super.setBackgroundImage(n2);
        this.setBackgroundTransparent(n2 != 0);
    }

    @Override
    void setBackgroundPixel(int n2) {
        super.setBackgroundPixel(n2);
        this.setBackgroundTransparent(n2 != -1);
    }

    void setBackgroundTransparent(boolean bl2) {
        if (!((this.style & 0x800000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            int n2 = OS.GetWindowLong(this.handle, -16);
            n2 = !bl2 && this.findBackgroundControl() == null ? (n2 &= 0xFFFF7FFF) : (n2 |= 0x8000);
            OS.SetWindowLong(this.handle, -16, n2);
        }
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6) {
        if (this.parent.lpwp != null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
            this.parent.setResizeChildren(false);
            this.parent.setResizeChildren(true);
        }
        super.setBoundsInPixels(n2, n3, n4, n5, n6);
    }

    @Override
    void setDefaultFont() {
        super.setDefaultFont();
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
    }

    void setDropDownItems(boolean bl2) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            ToolItem toolItem;
            int n2;
            boolean bl3 = false;
            boolean bl4 = false;
            for (n2 = 0; n2 < this.items.length; ++n2) {
                toolItem = this.items[n2];
                if (toolItem == null) continue;
                if (!bl3) {
                    boolean bl5 = bl3 = toolItem.text.length() != 0;
                }
                if (!bl4) {
                    boolean bl6 = bl4 = toolItem.image != null;
                }
                if (bl3 && bl4) break;
            }
            if (bl4 && !bl3) {
                for (n2 = 0; n2 < this.items.length; ++n2) {
                    toolItem = this.items[n2];
                    if (toolItem == null || (toolItem.style & 4) == 0) continue;
                    TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                    tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                    tBBUTTONINFO.dwMask = 8;
                    OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, toolItem.id, tBBUTTONINFO);
                    tBBUTTONINFO.fsStyle = bl2 ? (byte)(tBBUTTONINFO.fsStyle | 8) : (byte)(tBBUTTONINFO.fsStyle & 0xFFFFFFF7);
                    OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, toolItem.id, tBBUTTONINFO);
                }
            }
        }
    }

    void setDisabledImageList(ImageList imageList) {
        if (this.disabledImageList == imageList) {
            return;
        }
        int n2 = 0;
        this.disabledImageList = imageList;
        if (this.disabledImageList != null) {
            n2 = this.disabledImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1078, 0, n2);
        this.setDropDownItems(true);
    }

    @Override
    public void setFont(Font font) {
        ToolItem toolItem;
        int n2;
        this.checkWidget();
        this.setDropDownItems(false);
        super.setFont(font);
        this.setDropDownItems(true);
        int n3 = 60;
        for (n2 = 0; n2 < this.items.length && ((toolItem = this.items[n2]) == null || (toolItem.style & n3) == 0); ++n2) {
        }
        if (n2 == this.items.length) {
            OS.SendMessage(this.handle, 1056, 0, 0);
            OS.SendMessage(this.handle, 1055, 0, 0);
        }
        this.layoutItems();
    }

    void setHotImageList(ImageList imageList) {
        if (this.hotImageList == imageList) {
            return;
        }
        int n2 = 0;
        this.hotImageList = imageList;
        if (this.hotImageList != null) {
            n2 = this.hotImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1076, 0, n2);
        this.setDropDownItems(true);
    }

    void setImageList(ImageList imageList) {
        if (this.imageList == imageList) {
            return;
        }
        int n2 = 0;
        this.imageList = imageList;
        if (this.imageList != null) {
            n2 = imageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1072, 0, n2);
        this.setDropDownItems(true);
    }

    @Override
    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (!super.setParent(composite)) {
            return false;
        }
        int n2 = composite.handle;
        OS.SendMessage(this.handle, 1061, n2, 0);
        int n3 = composite.getShell().handle;
        int n4 = OS.SendMessage(this.handle, 1059, 0, 0);
        OS.SetWindowLongPtr(n4, -8, n3);
        return true;
    }

    @Override
    public void setRedraw(boolean bl2) {
        this.checkWidget();
        this.setDropDownItems(false);
        super.setRedraw(bl2);
        this.setDropDownItems(true);
    }

    void setRowCount(int n2) {
        if ((this.style & 0x200) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            OS.MapWindowPoints(0, this.parent.handle, rECT, 2);
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 1063, OS.MAKEWPARAM(n2 += 2, 1), 0);
            int n3 = 22;
            this.SetWindowPos(this.handle, 0, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n3);
            this.ignoreResize = false;
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            for (int i2 = 0; i2 < toolItemArray.length; ++i2) {
                ToolItem toolItem = toolItemArray[i2];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent == this) continue;
                this.error(32);
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    @Override
    boolean setTabItemFocus() {
        ToolItem toolItem;
        int n2;
        for (n2 = 0; !(n2 >= this.items.length || (toolItem = this.items[n2]) != null && (toolItem.style & 2) == 0 && toolItem.getEnabled()); ++n2) {
        }
        if (n2 == this.items.length) {
            return false;
        }
        return super.setTabItemFocus();
    }

    @Override
    boolean updateTextDirection(int n2) {
        if (super.updateTextDirection(n2)) {
            ToolItem[] toolItemArray = this._getItems();
            int n3 = toolItemArray.length;
            while (n3-- > 0) {
                toolItemArray[n3].updateTextDirection(this.style & Integer.MIN_VALUE);
            }
            return true;
        }
        return false;
    }

    @Override
    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        if (!this.hasCursor()) {
            return "";
        }
        int n2 = nMTTDISPINFO.idFrom;
        int n3 = OS.SendMessage(this.handle, 1059, 0, 0);
        if (n3 == nMTTDISPINFO.hwndFrom) {
            ToolItem toolItem;
            int n4 = -2080374784;
            nMTTDISPINFO.uFlags = (this.style & n4) != 0 && (this.style & n4) != n4 ? (nMTTDISPINFO.uFlags |= 4) : (nMTTDISPINFO.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (0 <= n2 && n2 < this.items.length && (toolItem = this.items[n2]) != null) {
                if (this.lastArrowId != -1) {
                    return "";
                }
                return toolItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    @Override
    void updateOrientation() {
        super.updateOrientation();
        if (this.imageList != null) {
            Point point = this.imageList.getImageSize();
            ImageList imageList = this.display.getImageListToolBar(this.style & 0x4000000, point.x, point.y);
            ImageList imageList2 = this.display.getImageListToolBarHot(this.style & 0x4000000, point.x, point.y);
            ImageList imageList3 = this.display.getImageListToolBarDisabled(this.style & 0x4000000, point.x, point.y);
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 1;
            int n2 = OS.SendMessage(this.handle, 1048, 0, 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                ToolItem toolItem = this.items[i2];
                if ((toolItem.style & 2) != 0 || toolItem.image == null) continue;
                OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, toolItem.id, tBBUTTONINFO);
                if (tBBUTTONINFO.iImage == -2) continue;
                Image image = this.imageList.get(tBBUTTONINFO.iImage);
                Image image2 = this.hotImageList.get(tBBUTTONINFO.iImage);
                Image image3 = this.disabledImageList.get(tBBUTTONINFO.iImage);
                this.imageList.put(tBBUTTONINFO.iImage, null);
                this.hotImageList.put(tBBUTTONINFO.iImage, null);
                this.disabledImageList.put(tBBUTTONINFO.iImage, null);
                tBBUTTONINFO.iImage = imageList.add(image);
                imageList2.add(image2);
                imageList3.add(image3);
                OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, toolItem.id, tBBUTTONINFO);
            }
            this.display.releaseToolImageList(this.imageList);
            this.display.releaseToolHotImageList(this.hotImageList);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
            OS.SendMessage(this.handle, 1072, 0, imageList.getHandle());
            OS.SendMessage(this.handle, 1076, 0, imageList2.getHandle());
            OS.SendMessage(this.handle, 1078, 0, imageList3.getHandle());
            this.imageList = imageList;
            this.hotImageList = imageList2;
            this.disabledImageList = imageList3;
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 4 | 0x100 | 0x2000;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n2 |= 0x8000;
        }
        if ((this.style & 8) == 0) {
            n2 |= 0x40;
        }
        if ((this.style & 0x40) != 0) {
            n2 |= 0x200;
        }
        if ((this.style & 0x800000) != 0) {
            n2 |= 0x800;
        }
        if (!(OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || (this.style & 0x20000) == 0)) {
            n2 |= 0x1000;
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        return ToolBarClass;
    }

    @Override
    int windowProc() {
        return ToolBarProc;
    }

    @Override
    LRESULT WM_CAPTURECHANGED(int n2, int n3) {
        LRESULT lRESULT = super.WM_CAPTURECHANGED(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            int n4;
            ToolItem toolItem = this.items[i2];
            if (toolItem == null || ((n4 = OS.SendMessage(this.handle, 1042, toolItem.id, 0)) & 2) == 0) continue;
            OS.SendMessage(this.handle, 1041, toolItem.id, n4 &= 0xFFFFFFFD);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_CHAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 32: {
                TBBUTTON tBBUTTON;
                int n4;
                int n5 = OS.SendMessage(this.handle, 1095, 0, 0);
                if (n5 == -1 || (n4 = OS.SendMessage(this.handle, 1047, n5, tBBUTTON = new TBBUTTON())) == 0) break;
                this.items[tBBUTTON.idCommand].click(false);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_COMMAND(int n2, int n3) {
        LRESULT lRESULT = super.WM_COMMAND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_ERASEBKGND(int n2, int n3) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (this.findBackgroundControl() != null && OS.COMCTL32_MAJOR < 6) {
            this.drawBackground(n2);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETDLGCODE(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8193);
    }

    @Override
    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 32: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(int n2, int n3) {
        TBBUTTON tBBUTTON;
        int n4 = OS.SendMessage(this.handle, 1095, 0, 0);
        int n5 = OS.SendMessage(this.handle, 1047, n4, tBBUTTON = new TBBUTTON());
        if (n5 != 0) {
            this.lastFocusId = tBBUTTON.idCommand;
        }
        return super.WM_KILLFOCUS(n2, n3);
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(n2, n3);
    }

    @Override
    LRESULT WM_LBUTTONUP(int n2, int n3) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(n2, n3);
    }

    @Override
    LRESULT WM_MOUSELEAVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            int n4 = OS.SendMessage(this.handle, 1059, 0, 0);
            if (OS.SendMessage(n4, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0) {
                OS.SendMessage(n4, OS.TTM_DELTOOL, 0, tOOLINFO);
                OS.SendMessage(n4, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_MOUSEMOVE(int n2, int n3) {
        if (OS.GetMessagePos() != this.display.lastMouse) {
            this.lastArrowId = -1;
        }
        return super.WM_MOUSEMOVE(n2, n3);
    }

    @Override
    LRESULT WM_NOTIFY(int n2, int n3) {
        LRESULT lRESULT = super.WM_NOTIFY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.lastFocusId != -1 && this.handle == OS.GetFocus()) {
            int n4 = OS.SendMessage(this.handle, 1049, this.lastFocusId, 0);
            OS.SendMessage(this.handle, 1096, n4, 0);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        if (this.ignoreResize) {
            int n4 = this.callWindowProc(this.handle, 5, n2, n3);
            if (n4 == 0) {
                return LRESULT.ZERO;
            }
            return new LRESULT(n4);
        }
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if ((this.style & 0x800) != 0 && (this.style & 0x40) != 0) {
            int n5;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n6 = this.getBorderWidthInPixels() * 2;
            RECT rECT2 = new RECT();
            int n7 = OS.SendMessage(this.handle, 1048, 0, 0);
            for (n5 = 0; n5 < n7; ++n5) {
                OS.SendMessage(this.handle, 1053, n5, rECT2);
                OS.MapWindowPoints(this.handle, 0, rECT2, 2);
                if (rECT2.right > rECT.right - n6 * 2) break;
            }
            int n8 = OS.SendMessage(this.handle, 1109, 0, 0);
            n8 = n5 == n7 ? (n8 |= 0x10) : (n8 &= 0xFFFFFFEF);
            OS.SendMessage(this.handle, 1108, 0, n8);
        }
        this.layoutItems();
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if ((this.style & 0x40) == 0) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (OS.SendMessage(this.handle, 1064, 0, 0) == 1) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        RECT rECT2 = new RECT();
        OS.SetRect(rECT2, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT2);
        int n4 = rECT.right - rECT.left;
        int n5 = rECT2.right - rECT2.left;
        if (n5 > n4) {
            RECT rECT3 = new RECT();
            int n6 = rECT2.bottom - rECT2.top;
            OS.SetRect(rECT3, n4 - 2, 0, n4, n6);
            OS.InvalidateRect(this.handle, rECT3, false);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmCommandChild(int n2, int n3) {
        ToolItem toolItem = this.items[OS.LOWORD(n2)];
        if (toolItem == null) {
            return null;
        }
        return toolItem.wmCommandChild(n2, n3);
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -710: {
                NMTOOLBAR nMTOOLBAR = new NMTOOLBAR();
                OS.MoveMemory(nMTOOLBAR, n3, NMTOOLBAR.sizeof);
                ToolItem toolItem = this.items[nMTOOLBAR.iItem];
                if (toolItem == null) break;
                Event event = new Event();
                event.detail = 4;
                int n4 = OS.SendMessage(this.handle, 1049, nMTOOLBAR.iItem, 0);
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, n4, rECT);
                event.setLocationInPixels(rECT.left, rECT.bottom);
                toolItem.sendSelectionEvent(13, event, false);
                break;
            }
            case -12: {
                if (OS.COMCTL32_MAJOR < 6) break;
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, n3, NMCUSTOMDRAW.sizeof);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 3: {
                        int n5 = OS.GetWindowLong(this.handle, -16);
                        if ((n5 & 0x800) == 0) {
                            this.drawBackground(nMCUSTOMDRAW.hdc);
                        } else {
                            RECT rECT = new RECT();
                            OS.SetRect(rECT, nMCUSTOMDRAW.left, nMCUSTOMDRAW.top, nMCUSTOMDRAW.right, nMCUSTOMDRAW.bottom);
                            this.drawBackground(nMCUSTOMDRAW.hdc, rECT);
                        }
                        return new LRESULT(4);
                    }
                }
                break;
            }
            case -713: {
                if (OS.IsWinCE) break;
                NMTBHOTITEM nMTBHOTITEM = new NMTBHOTITEM();
                OS.MoveMemory(nMTBHOTITEM, n3, NMTBHOTITEM.sizeof);
                switch (nMTBHOTITEM.dwFlags) {
                    case 1: {
                        if (this.lastArrowId == -1) break;
                        return LRESULT.ONE;
                    }
                    case 2: {
                        RECT rECT = new RECT();
                        OS.GetClientRect(this.handle, rECT);
                        int n6 = OS.SendMessage(this.handle, 1049, nMTBHOTITEM.idNew, 0);
                        RECT rECT2 = new RECT();
                        OS.SendMessage(this.handle, 1053, n6, rECT2);
                        if (rECT2.right > rECT.right || rECT2.bottom > rECT.bottom) {
                            return LRESULT.ONE;
                        }
                        this.lastArrowId = nMTBHOTITEM.idNew;
                        break;
                    }
                    default: {
                        this.lastArrowId = -1;
                    }
                }
                if ((nMTBHOTITEM.dwFlags & 0x20) != 0) break;
                this.lastHotId = nMTBHOTITEM.idNew;
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    static {
        ToolBarClass = new TCHAR(0, "ToolbarWindow32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ToolBarClass, wNDCLASS);
        ToolBarProc = wNDCLASS.lpfnWndProc;
    }
}

