/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.Serializable;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int resizeCursor;
    Cursor clientCursor;
    int cursorOrientation = 0;
    boolean inEvent = false;
    boolean drawn;
    int hwndTransparent;
    int hwndOpaque;
    int oldTransparentProc;
    int oldOpaqueProc;
    int oldX;
    int oldY;
    static boolean IsVista = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0);
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n2) {
        super(composite, Tracker.checkStyle(n2));
        this.parent = composite;
    }

    public Tracker(Display display, int n2) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n2);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n2 = this.bounds.x + this.bounds.width / 2;
        int n3 = this.bounds.y;
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        return new Point(pOINT.x, pOINT.y);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n2 = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n3 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        if (this.clientCursor == null) {
            int n4 = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    n4 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 1024: {
                    n4 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 16384: {
                    n4 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 131072: {
                    n4 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 16512: {
                    n4 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 132096: {
                    n4 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 17408: {
                    n4 = OS.LoadCursor(0, 32643);
                    break;
                }
                case 131200: {
                    n4 = OS.LoadCursor(0, 32643);
                    break;
                }
                default: {
                    n4 = OS.LoadCursor(0, 32646);
                }
            }
            OS.SetCursor(n4);
            if (this.resizeCursor != 0) {
                OS.DestroyCursor(this.resizeCursor);
            }
            this.resizeCursor = n4;
        }
        return new Point(pOINT.x, pOINT.y);
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x24480) == 0) {
            n2 |= 0x24480;
        }
        return n2;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n2 = this.rectangles[0].x;
        int n3 = this.rectangles[0].y;
        int n4 = this.rectangles[0].x + this.rectangles[0].width;
        int n5 = this.rectangles[0].y + this.rectangles[0].height;
        for (int i2 = 1; i2 < this.rectangles.length; ++i2) {
            int n6;
            int n7;
            if (this.rectangles[i2].x < n2) {
                n2 = this.rectangles[i2].x;
            }
            if (this.rectangles[i2].y < n3) {
                n3 = this.rectangles[i2].y;
            }
            if ((n7 = this.rectangles[i2].x + this.rectangles[i2].width) > n4) {
                n4 = n7;
            }
            if ((n6 = this.rectangles[i2].y + this.rectangles[i2].height) <= n5) continue;
            n5 = n6;
        }
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (this.bounds.width != 0) {
                    n2 = (rectangleArray[i2].x - this.bounds.x) * 100 / this.bounds.width;
                    n4 = rectangleArray[i2].width * 100 / this.bounds.width;
                } else {
                    n4 = 100;
                }
                if (this.bounds.height != 0) {
                    n3 = (rectangleArray[i2].y - this.bounds.y) * 100 / this.bounds.height;
                    n5 = rectangleArray[i2].height * 100 / this.bounds.height;
                } else {
                    n5 = 100;
                }
                rectangleArray2[i2] = new Rectangle(n2, n3, n4, n5);
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray, boolean bl2) {
        if (this.hwndOpaque != 0) {
            RECT rECT = new RECT();
            int n2 = bl2 ? 3 : 1;
            for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                Rectangle rectangle = rectangleArray[i2];
                rECT.left = rectangle.x - n2;
                rECT.top = rectangle.y - n2;
                rECT.right = rectangle.x + rectangle.width + n2 * 2;
                rECT.bottom = rectangle.y + rectangle.height + n2 * 2;
                OS.MapWindowPoints(0, this.hwndOpaque, rECT, 2);
                OS.RedrawWindow(this.hwndOpaque, rECT, 0, 1);
            }
            return;
        }
        int n3 = 1;
        int n4 = this.parent == null ? OS.GetDesktopWindow() : this.parent.handle;
        int n5 = OS.GetDCEx(n4, 0, 2);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (bl2) {
            n3 = 3;
            byte[] byArray = new byte[]{-86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0};
            n6 = OS.CreateBitmap(8, 8, 1, 1, byArray);
            n7 = OS.CreatePatternBrush(n6);
            n8 = OS.SelectObject(n5, n7);
        }
        for (int i3 = 0; i3 < rectangleArray.length; ++i3) {
            Rectangle rectangle = rectangleArray[i3];
            OS.PatBlt(n5, rectangle.x, rectangle.y, rectangle.width, n3, 5898313);
            OS.PatBlt(n5, rectangle.x, rectangle.y + n3, n3, rectangle.height - n3 * 2, 5898313);
            OS.PatBlt(n5, rectangle.x + rectangle.width - n3, rectangle.y + n3, n3, rectangle.height - n3 * 2, 5898313);
            OS.PatBlt(n5, rectangle.x, rectangle.y + rectangle.height - n3, rectangle.width, n3, 5898313);
        }
        if (bl2) {
            OS.SelectObject(n5, n8);
            OS.DeleteObject(n7);
            OS.DeleteObject(n6);
        }
        OS.ReleaseDC(n4, n5);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = this.getRectanglesInPixels();
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray[i2] = DPIUtil.autoScaleDown(rectangleArray[i2]);
        }
        return rectangleArray;
    }

    Rectangle[] getRectanglesInPixels() {
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Rectangle rectangle = this.rectangles[i2];
            rectangleArray[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int n2, int n3) {
        if (this.bounds == null) {
            return;
        }
        if (n2 < 0 && (this.style & 0x4000) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x20000) == 0) {
            n2 = 0;
        }
        if (n3 < 0 && (this.style & 0x80) == 0) {
            n3 = 0;
        }
        if (n3 > 0 && (this.style & 0x400) == 0) {
            n3 = 0;
        }
        if (n2 == 0 && n3 == 0) {
            return;
        }
        this.bounds.x += n2;
        this.bounds.y += n3;
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            this.rectangles[i2].x += n2;
            this.rectangles[i2].y += n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        int n2;
        Serializable serializable;
        boolean bl2;
        int n3;
        this.checkWidget();
        this.cancelled = false;
        this.tracking = true;
        int n4 = this.style & 0x480;
        if (n4 == 128 || n4 == 1024) {
            this.cursorOrientation |= n4;
        }
        if ((n3 = this.style & 0x24000) == 16384 || n3 == 131072) {
            this.cursorOrientation |= n3;
        }
        Callback callback = null;
        boolean bl3 = bl2 = OS.GetKeyState(1) < 0;
        if (IsVista && this.parent == null) {
            serializable = this.display.getBoundsInPixels();
            this.hwndTransparent = OS.CreateWindowEx(0x8080080, this.display.windowClass, null, Integer.MIN_VALUE, serializable.x, serializable.y, serializable.width, serializable.height, 0, 0, OS.GetModuleHandle(null), null);
            OS.SetLayeredWindowAttributes(this.hwndTransparent, 0, (byte)1, 2);
            this.hwndOpaque = OS.CreateWindowEx(0x8080080, this.display.windowClass, null, Integer.MIN_VALUE, serializable.x, serializable.y, serializable.width, serializable.height, this.hwndTransparent, 0, OS.GetModuleHandle(null), null);
            OS.SetLayeredWindowAttributes(this.hwndOpaque, 0xFFFFFF, (byte)0, 3);
            this.drawn = false;
            callback = new Callback(this, "transparentProc", 4);
            n2 = callback.getAddress();
            if (n2 == 0) {
                this.error(3);
            }
            this.oldTransparentProc = OS.GetWindowLongPtr(this.hwndTransparent, -4);
            OS.SetWindowLongPtr(this.hwndTransparent, -4, n2);
            this.oldOpaqueProc = OS.GetWindowLongPtr(this.hwndOpaque, -4);
            OS.SetWindowLongPtr(this.hwndOpaque, -4, n2);
            OS.ShowWindow(this.hwndTransparent, 4);
            OS.ShowWindow(this.hwndOpaque, 4);
        } else if (!bl2) {
            serializable = this.display.getBoundsInPixels();
            this.hwndTransparent = OS.CreateWindowEx(32, this.display.windowClass, null, Integer.MIN_VALUE, serializable.x, serializable.y, serializable.width, serializable.height, 0, 0, OS.GetModuleHandle(null), null);
            callback = new Callback(this, "transparentProc", 4);
            n2 = callback.getAddress();
            if (n2 == 0) {
                this.error(3);
            }
            this.oldTransparentProc = OS.GetWindowLongPtr(this.hwndTransparent, -4);
            OS.SetWindowLongPtr(this.hwndTransparent, -4, n2);
            OS.ShowWindow(this.hwndTransparent, 4);
        }
        this.update();
        this.drawRectangles(this.rectangles, this.stippled);
        serializable = null;
        if (bl2) {
            POINT pOINT = new POINT();
            OS.GetCursorPos(pOINT);
            serializable = new Point(pOINT.x, pOINT.y);
        } else {
            serializable = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
        }
        if (serializable != null) {
            this.oldX = ((Point)serializable).x;
            this.oldY = ((Point)serializable).y;
        }
        Display display = this.display;
        try {
            MSG mSG = new MSG();
            while (!(!this.tracking || this.cancelled || this.parent != null && this.parent.isDisposed())) {
                display.runSkin();
                display.runDeferredLayouts();
                display.sendPreExternalEventDispatchEvent();
                OS.GetMessage(mSG, 0, 0, 0);
                display.sendPostExternalEventDispatchEvent();
                OS.TranslateMessage(mSG);
                switch (mSG.message) {
                    case 512: 
                    case 514: {
                        this.wmMouse(mSG.message, mSG.wParam, mSG.lParam);
                        break;
                    }
                    case 646: {
                        this.wmIMEChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                        break;
                    }
                    case 258: {
                        this.wmChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                        break;
                    }
                    case 256: {
                        this.wmKeyDown(mSG.hwnd, mSG.wParam, mSG.lParam);
                        break;
                    }
                    case 257: {
                        this.wmKeyUp(mSG.hwnd, mSG.wParam, mSG.lParam);
                        break;
                    }
                    case 262: {
                        this.wmSysChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                        break;
                    }
                    case 260: {
                        this.wmSysKeyDown(mSG.hwnd, mSG.wParam, mSG.lParam);
                        break;
                    }
                    case 261: {
                        this.wmSysKeyUp(mSG.hwnd, mSG.wParam, mSG.lParam);
                    }
                }
                if (256 <= mSG.message && mSG.message <= 264 || 512 <= mSG.message && mSG.message <= 525) continue;
                if (this.hwndOpaque == 0 && mSG.message == 15) {
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                OS.DispatchMessage(mSG);
                if (this.hwndOpaque == 0 && mSG.message == 15) {
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                display.runAsyncMessages(false);
            }
            if (bl2) {
                OS.ReleaseCapture();
            }
            if (!this.isDisposed()) {
                this.update();
                this.drawRectangles(this.rectangles, this.stippled);
            }
        }
        finally {
            if (this.hwndTransparent != 0) {
                OS.DestroyWindow(this.hwndTransparent);
                this.hwndTransparent = 0;
            }
            this.hwndOpaque = 0;
            if (callback != null) {
                callback.dispose();
                this.oldOpaqueProc = 0;
                this.oldTransparentProc = 0;
            }
            if (this.resizeCursor != 0) {
                OS.DestroyCursor(this.resizeCursor);
                this.resizeCursor = 0;
            }
        }
        this.tracking = false;
        return !this.cancelled;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    void resizeRectangles(int n2, int n3) {
        Rectangle rectangle;
        int n4;
        if (this.bounds == null) {
            return;
        }
        if (n2 < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (n2 > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (n3 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (n3 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n2 > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n2 -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (n4 = 0; n4 < this.proportions.length; ++n4) {
                        rectangle = this.proportions[n4];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n2) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n2 += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (n4 = 0; n4 < this.proportions.length; ++n4) {
                    rectangle = this.proportions[n4];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n3 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n3 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (n4 = 0; n4 < this.proportions.length; ++n4) {
                        rectangle = this.proportions[n4];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n3) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n3 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (n4 = 0; n4 < this.proportions.length; ++n4) {
                    rectangle = this.proportions[n4];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n2;
            this.bounds.width -= n2;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n2;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n3;
            this.bounds.height -= n3;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n3;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Rectangle rectangle2 = this.proportions[i2];
            rectangleArray[i2] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.clientCursor = cursor;
        if (cursor != null && this.inEvent) {
            OS.SetCursor(this.clientCursor.handle);
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray2[i2] = DPIUtil.autoScaleUp(rectangleArray[i2]);
        }
        this.setRectanglesInPixels(rectangleArray2);
    }

    void setRectanglesInPixels(Rectangle[] rectangleArray) {
        this.rectangles = new Rectangle[rectangleArray.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            Rectangle rectangle = rectangleArray[i2];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl2) {
        this.checkWidget();
        this.stippled = bl2;
    }

    int transparentProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 132: {
                if (!this.inEvent) break;
                return -1;
            }
            case 32: {
                if (this.clientCursor != null) {
                    OS.SetCursor(this.clientCursor.handle);
                    return 1;
                }
                if (this.resizeCursor == 0) break;
                OS.SetCursor(this.resizeCursor);
                return 1;
            }
            case 15: {
                Object[] objectArray;
                if (this.hwndOpaque != n2) break;
                PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
                int n6 = OS.BeginPaint(n2, pAINTSTRUCT);
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = OS.CreateSolidBrush(0xFFFFFF);
                n9 = OS.SelectObject(n6, n10);
                OS.PatBlt(n6, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right - pAINTSTRUCT.left, pAINTSTRUCT.bottom - pAINTSTRUCT.top, 15728673);
                OS.SelectObject(n6, n9);
                OS.DeleteObject(n10);
                int n11 = 1;
                if (this.stippled) {
                    n11 = 3;
                    objectArray = new byte[]{-86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0};
                    n7 = OS.CreateBitmap(8, 8, 1, 1, (byte[])objectArray);
                    n8 = OS.CreatePatternBrush(n7);
                    n9 = OS.SelectObject(n6, n8);
                    OS.SetBkColor(n6, 0xF0F0F0);
                } else {
                    n9 = OS.SelectObject(n6, OS.GetStockObject(4));
                }
                objectArray = this.rectangles;
                RECT rECT = new RECT();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Rectangle rectangle = objectArray[i2];
                    rECT.left = rectangle.x;
                    rECT.top = rectangle.y;
                    rECT.right = rectangle.x + rectangle.width;
                    rECT.bottom = rectangle.y + rectangle.height;
                    OS.MapWindowPoints(0, this.hwndOpaque, rECT, 2);
                    int n12 = rECT.right - rECT.left;
                    int n13 = rECT.bottom - rECT.top;
                    OS.PatBlt(n6, rECT.left, rECT.top, n12, n11, 15728673);
                    OS.PatBlt(n6, rECT.left, rECT.top + n11, n11, n13 - n11 * 2, 15728673);
                    OS.PatBlt(n6, rECT.right - n11, rECT.top + n11, n11, n13 - n11 * 2, 15728673);
                    OS.PatBlt(n6, rECT.left, rECT.bottom - n11, n12, n11, 15728673);
                }
                OS.SelectObject(n6, n9);
                if (this.stippled) {
                    OS.DeleteObject(n8);
                    OS.DeleteObject(n7);
                }
                OS.EndPaint(n2, pAINTSTRUCT);
                if (!this.drawn) {
                    OS.SetLayeredWindowAttributes(this.hwndOpaque, 0xFFFFFF, (byte)-1, 3);
                    this.drawn = true;
                }
                return 0;
            }
        }
        return OS.CallWindowProc(n2 == this.hwndTransparent ? this.oldTransparentProc : this.oldOpaqueProc, n2, n3, n4, n5);
    }

    void update() {
        if (this.hwndOpaque != 0) {
            return;
        }
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            Shell shell = this.parent.getShell();
            shell.update(true);
        } else {
            this.display.update();
        }
    }

    @Override
    LRESULT wmKeyDown(int n2, int n3, int n4) {
        LRESULT lRESULT = super.wmKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = this.parent != null && (this.parent.style & 0x8000000) != 0;
        int n5 = OS.GetKeyState(17) < 0 ? 1 : 9;
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 27: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 13: {
                this.tracking = false;
                break;
            }
            case 37: {
                n6 = bl2 ? n5 : -n5;
                break;
            }
            case 39: {
                n6 = bl2 ? -n5 : n5;
                break;
            }
            case 38: {
                n7 = -n5;
                break;
            }
            case 40: {
                n7 = n5;
            }
        }
        if (n6 != 0 || n7 != 0) {
            Serializable serializable;
            Rectangle[] rectangleArray = this.rectangles;
            boolean bl3 = this.stippled;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
                serializable = this.rectangles[i2];
                rectangleArray2[i2] = new Rectangle(serializable.x, serializable.y, serializable.width, serializable.height);
            }
            Event event = new Event();
            event.setLocationInPixels(this.oldX + n6, this.oldY + n7);
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(n6, n7);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl4 = false;
                if (this.rectangles != rectangleArray) {
                    int n8 = this.rectangles.length;
                    if (n8 != rectangleArray2.length) {
                        bl4 = true;
                    } else {
                        for (int i3 = 0; i3 < n8; ++i3) {
                            if (this.rectangles[i3].equals(rectangleArray2[i3])) continue;
                            bl4 = true;
                            break;
                        }
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                serializable = this.adjustResizeCursor();
            } else {
                this.moveRectangles(n6, n7);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl5 = false;
                if (this.rectangles != rectangleArray) {
                    int n9 = this.rectangles.length;
                    if (n9 != rectangleArray2.length) {
                        bl5 = true;
                    } else {
                        for (int i4 = 0; i4 < n9; ++i4) {
                            if (this.rectangles[i4].equals(rectangleArray2[i4])) continue;
                            bl5 = true;
                            break;
                        }
                    }
                } else {
                    bl5 = true;
                }
                if (bl5) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                serializable = this.adjustMoveCursor();
            }
            if (serializable != null) {
                this.oldX = ((Point)serializable).x;
                this.oldY = ((Point)serializable).y;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmSysKeyDown(int n2, int n3, int n4) {
        LRESULT lRESULT = super.wmSysKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.cancelled = true;
        this.tracking = false;
        return lRESULT;
    }

    LRESULT wmMouse(int n2, int n3, int n4) {
        boolean bl2 = this.parent != null && (this.parent.style & 0x8000000) != 0;
        int n5 = OS.GetMessagePos();
        int n6 = OS.GET_X_LPARAM(n5);
        int n7 = OS.GET_Y_LPARAM(n5);
        if (n6 != this.oldX || n7 != this.oldY) {
            Rectangle[] rectangleArray = this.rectangles;
            boolean bl3 = this.stippled;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
                Rectangle rectangle = this.rectangles[i2];
                rectangleArray2[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            event.setLocationInPixels(n6, n7);
            if ((this.style & 0x10) != 0) {
                Point point;
                if (bl2) {
                    this.resizeRectangles(this.oldX - n6, n7 - this.oldY);
                } else {
                    this.resizeRectangles(n6 - this.oldX, n7 - this.oldY);
                }
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl4 = false;
                if (this.rectangles != rectangleArray) {
                    int n8 = this.rectangles.length;
                    if (n8 != rectangleArray2.length) {
                        bl4 = true;
                    } else {
                        for (int i3 = 0; i3 < n8; ++i3) {
                            if (this.rectangles[i3].equals(rectangleArray2[i3])) continue;
                            bl4 = true;
                            break;
                        }
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    n6 = point.x;
                    n7 = point.y;
                }
            } else {
                if (bl2) {
                    this.moveRectangles(this.oldX - n6, n7 - this.oldY);
                } else {
                    this.moveRectangles(n6 - this.oldX, n7 - this.oldY);
                }
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl5 = false;
                if (this.rectangles != rectangleArray) {
                    int n9 = this.rectangles.length;
                    if (n9 != rectangleArray2.length) {
                        bl5 = true;
                    } else {
                        for (int i4 = 0; i4 < n9; ++i4) {
                            if (this.rectangles[i4].equals(rectangleArray2[i4])) continue;
                            bl5 = true;
                            break;
                        }
                    }
                } else {
                    bl5 = true;
                }
                if (bl5) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
            }
            this.oldX = n6;
            this.oldY = n7;
        }
        this.tracking = n2 != 514;
        return null;
    }
}

