/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.swt;

import java.nio.IntBuffer;
import java.util.HashSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGL;
import org.lwjgl.opengl.swt.AbstractPlatformGLCanvas;
import org.lwjgl.opengl.swt.GLCanvas;
import org.lwjgl.opengl.swt.GLData;
import org.lwjgl.opengl.swt.GLData$API;
import org.lwjgl.opengl.swt.GLData$Profile;
import org.lwjgl.opengl.swt.GLData$ReleaseBehavior;
import org.lwjgl.opengl.swt.PlatformWin32GLCanvas$1;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.GDI32;
import org.lwjgl.system.windows.PIXELFORMATDESCRIPTOR;
import org.lwjgl.system.windows.User32;

class PlatformWin32GLCanvas
extends AbstractPlatformGLCanvas {
    private static final String USE_OWNDC_KEY = "org.eclipse.swt.internal.win32.useOwnDC";
    private long wglDelayBeforeSwapNVAddr = 0L;
    private boolean wglDelayBeforeSwapNVAddr_set = false;

    PlatformWin32GLCanvas() {
    }

    private void encodePixelFormatAttribs(IntBuffer intBuffer, GLData gLData) {
        intBuffer.put(8193).put(1);
        intBuffer.put(8208).put(1);
        intBuffer.put(8195).put(8231);
        if (gLData.doubleBuffer) {
            intBuffer.put(8209).put(1);
        }
        if (gLData.pixelFormatFloat) {
            intBuffer.put(8211).put(8608);
        } else {
            intBuffer.put(8211).put(8235);
        }
        if (gLData.redSize > 0) {
            intBuffer.put(8213).put(gLData.redSize);
        }
        if (gLData.greenSize > 0) {
            intBuffer.put(8215).put(gLData.greenSize);
        }
        if (gLData.blueSize > 0) {
            intBuffer.put(8217).put(gLData.blueSize);
        }
        if (gLData.alphaSize > 0) {
            intBuffer.put(8219).put(gLData.alphaSize);
        }
        if (gLData.depthSize > 0) {
            intBuffer.put(8226).put(gLData.depthSize);
        }
        if (gLData.stencilSize > 0) {
            intBuffer.put(8227).put(gLData.stencilSize);
        }
        if (gLData.accumRedSize > 0) {
            intBuffer.put(8222).put(gLData.accumRedSize);
        }
        if (gLData.accumGreenSize > 0) {
            intBuffer.put(8223).put(gLData.accumGreenSize);
        }
        if (gLData.accumBlueSize > 0) {
            intBuffer.put(8224).put(gLData.accumBlueSize);
        }
        if (gLData.accumAlphaSize > 0) {
            intBuffer.put(8225).put(gLData.accumAlphaSize);
        }
        if (gLData.accumRedSize > 0 || gLData.accumGreenSize > 0 || gLData.accumBlueSize > 0 || gLData.accumAlphaSize > 0) {
            intBuffer.put(8221).put(gLData.accumRedSize + gLData.accumGreenSize + gLData.accumBlueSize + gLData.accumAlphaSize);
        }
        if (gLData.sRGB) {
            intBuffer.put(8361).put(1);
        }
        if (gLData.samples > 0) {
            intBuffer.put(8257).put(1);
            intBuffer.put(8258).put(gLData.samples);
            if (gLData.colorSamplesNV > 0) {
                intBuffer.put(8377).put(gLData.colorSamplesNV);
            }
        }
        intBuffer.put(0);
    }

    @Override
    public int checkStyle(Composite composite, int n2) {
        if (composite != null) {
            composite.getDisplay().setData(USE_OWNDC_KEY, Boolean.TRUE);
        }
        return n2;
    }

    @Override
    public void resetStyle(Composite composite) {
        composite.getDisplay().setData(USE_OWNDC_KEY, Boolean.FALSE);
    }

    @Override
    public long create(GLCanvas gLCanvas, GLData gLData, GLData gLData2) {
        Canvas canvas = new Canvas(gLCanvas.getParent(), this.checkStyle(gLCanvas.getParent(), gLCanvas.getStyle()));
        long l2 = 0L;
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            l2 = this.create(gLCanvas.handle, canvas.handle, gLData, gLData2);
        }
        catch (SWTException sWTException) {
            memoryStack.setPointer(n2);
            SWT.error(38, sWTException);
        }
        long l3 = l2;
        canvas.dispose();
        PlatformWin32GLCanvas$1 platformWin32GLCanvas$1 = new PlatformWin32GLCanvas$1(this, gLCanvas, l3);
        gLCanvas.addListener(12, platformWin32GLCanvas$1);
        return l2;
    }

    private long create(long l2, long l3, GLData gLData, GLData gLData2) throws SWTException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l4;
        long l5;
        MemoryStack memoryStack = MemoryStack.stackGet();
        long l6 = memoryStack.nmalloc(4, 32);
        PlatformWin32GLCanvas.validateAttributes(gLData);
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.callocStack();
        pIXELFORMATDESCRIPTOR.nSize((short)PIXELFORMATDESCRIPTOR.SIZEOF);
        pIXELFORMATDESCRIPTOR.nVersion((short)1);
        pIXELFORMATDESCRIPTOR.dwLayerMask(0);
        pIXELFORMATDESCRIPTOR.iPixelType((byte)0);
        int n7 = 36;
        if (gLData.doubleBuffer) {
            n7 |= 1;
        }
        if (gLData.stereo) {
            n7 |= 2;
        }
        pIXELFORMATDESCRIPTOR.dwFlags(n7);
        pIXELFORMATDESCRIPTOR.cRedBits((byte)gLData.redSize);
        pIXELFORMATDESCRIPTOR.cGreenBits((byte)gLData.greenSize);
        pIXELFORMATDESCRIPTOR.cBlueBits((byte)gLData.blueSize);
        pIXELFORMATDESCRIPTOR.cAlphaBits((byte)gLData.alphaSize);
        pIXELFORMATDESCRIPTOR.cDepthBits((byte)gLData.depthSize);
        pIXELFORMATDESCRIPTOR.cStencilBits((byte)gLData.stencilSize);
        pIXELFORMATDESCRIPTOR.cAccumRedBits((byte)gLData.accumRedSize);
        pIXELFORMATDESCRIPTOR.cAccumGreenBits((byte)gLData.accumGreenSize);
        pIXELFORMATDESCRIPTOR.cAccumBlueBits((byte)gLData.accumBlueSize);
        pIXELFORMATDESCRIPTOR.cAccumAlphaBits((byte)gLData.accumAlphaSize);
        pIXELFORMATDESCRIPTOR.cAccumBits((byte)(gLData.accumRedSize + gLData.accumGreenSize + gLData.accumBlueSize + gLData.accumAlphaSize));
        long l7 = User32.GetDC(l3);
        int n8 = GDI32.ChoosePixelFormat(null, l7, pIXELFORMATDESCRIPTOR);
        if (n8 == 0 || !GDI32.SetPixelFormat(null, l7, n8, pIXELFORMATDESCRIPTOR)) {
            User32.ReleaseDC(l3, l7);
            throw new SWTException("Unsupported pixel format");
        }
        long l8 = WGL.wglCreateContext(null, l7);
        if (l8 == 0L) {
            User32.ReleaseDC(l3, l7);
            throw new SWTException("Failed to create OpenGL context");
        }
        long l9 = WGL.wglGetCurrentContext(null);
        long l10 = WGL.wglGetCurrentDC();
        boolean bl2 = WGL.wglMakeCurrent(null, l7, l8);
        if (!bl2) {
            User32.ReleaseDC(l3, l7);
            WGL.wglDeleteContext(null, l8);
            throw new SWTException("Failed to make OpenGL context current");
        }
        String string = null;
        long l11 = WGL.wglGetProcAddress(null, "wglGetExtensionsStringARB");
        string = l11 != 0L ? ((l5 = JNI.callPP(l7, l11)) != 0L ? MemoryUtil.memASCII(l5) : "") : ((l5 = WGL.wglGetProcAddress(null, "wglGetExtensionsStringEXT")) != 0L ? ((l4 = JNI.callP(l5)) != 0L ? MemoryUtil.memASCII(l4) : "") : "");
        String[] stringArray = string.split(" ");
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        String[] stringArray2 = stringArray;
        int n9 = stringArray.length;
        int n10 = 0;
        while (n10 < n9) {
            String string2 = stringArray2[n10];
            hashSet.add(string2);
            ++n10;
        }
        bl2 = User32.ReleaseDC(l3, l7);
        if (!bl2) {
            WGL.wglDeleteContext(null, l8);
            WGL.wglMakeCurrent(null, l10, l9);
            throw new SWTException("Could not release dummy DC");
        }
        if (!(PlatformWin32GLCanvas.atLeast30(gLData.majorVersion, gLData.minorVersion) || gLData.samples != 0 || gLData.sRGB || gLData.pixelFormatFloat || gLData.contextReleaseBehavior != null || gLData.robustness || gLData.api == GLData$API.GLES)) {
            int n11;
            l4 = User32.GetDC(l2);
            GDI32.SetPixelFormat(null, l4, n8, pIXELFORMATDESCRIPTOR);
            bl2 = WGL.wglDeleteContext(null, l8);
            if (!bl2) {
                User32.ReleaseDC(l2, l4);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("Could not delete dummy GL context");
            }
            long l12 = WGL.wglCreateContext(null, l4);
            if (gLData.swapInterval != null) {
                boolean bl3;
                n11 = hashSet.contains("WGL_EXT_swap_control");
                if (n11 == 0) {
                    User32.ReleaseDC(l2, l4);
                    WGL.wglMakeCurrent(null, l10, l9);
                    WGL.wglDeleteContext(null, l12);
                    throw new SWTException("Swap interval requested but WGL_EXT_swap_control is unavailable");
                }
                if (gLData.swapInterval < 0 && !(bl3 = hashSet.contains("WGL_EXT_swap_control_tear"))) {
                    User32.ReleaseDC(l2, l4);
                    WGL.wglMakeCurrent(null, l10, l9);
                    WGL.wglDeleteContext(null, l12);
                    throw new SWTException("Negative swap interval requested but WGL_EXT_swap_control_tear is unavailable");
                }
                bl2 = WGL.wglMakeCurrent(null, l4, l12);
                if (!bl2) {
                    User32.ReleaseDC(l2, l4);
                    WGL.wglMakeCurrent(null, l10, l9);
                    WGL.wglDeleteContext(null, l12);
                    throw new SWTException("Could not make GL context current");
                }
                long l13 = WGL.wglGetProcAddress(null, "wglSwapIntervalEXT");
                if (l13 != 0L) {
                    JNI.callI(gLData.swapInterval, l13);
                }
            }
            if (gLData.swapGroupNV > 0 || gLData.swapBarrierNV > 0) {
                n11 = hashSet.contains("WGL_NV_swap_group");
                if (n11 == 0) {
                    User32.ReleaseDC(l2, l4);
                    WGL.wglMakeCurrent(null, l10, l9);
                    WGL.wglDeleteContext(null, l12);
                    throw new SWTException("Swap group or barrier requested but WGL_NV_swap_group is unavailable");
                }
                bl2 = WGL.wglMakeCurrent(null, l4, l12);
                try {
                    this.wglNvSwapGroupAndBarrier(gLData, memoryStack.getAddress() + (long)memoryStack.getPointer(), l4);
                }
                catch (SWTException sWTException) {
                    User32.ReleaseDC(l2, l4);
                    WGL.wglMakeCurrent(null, l10, l9);
                    WGL.wglDeleteContext(null, l12);
                    throw sWTException;
                }
            }
            if (gLData.shareContext != null && !(bl2 = WGL.wglShareLists(null, l12, gLData.shareContext.context))) {
                User32.ReleaseDC(l2, l4);
                WGL.wglMakeCurrent(null, l10, l9);
                WGL.wglDeleteContext(null, l12);
                throw new SWTException("Failed while configuring context sharing");
            }
            n11 = GDI32.DescribePixelFormat(null, l4, n8, pIXELFORMATDESCRIPTOR);
            if (n11 == 0) {
                User32.ReleaseDC(l2, l4);
                WGL.wglMakeCurrent(null, l10, l9);
                WGL.wglDeleteContext(null, l12);
                throw new SWTException("Failed to describe pixel format");
            }
            bl2 = User32.ReleaseDC(l2, l4);
            if (!bl2) {
                WGL.wglMakeCurrent(null, l10, l9);
                WGL.wglDeleteContext(null, l12);
                throw new SWTException("Could not release DC");
            }
            gLData2.redSize = pIXELFORMATDESCRIPTOR.cRedBits();
            gLData2.greenSize = pIXELFORMATDESCRIPTOR.cGreenBits();
            gLData2.blueSize = pIXELFORMATDESCRIPTOR.cBlueBits();
            gLData2.alphaSize = pIXELFORMATDESCRIPTOR.cAlphaBits();
            gLData2.depthSize = pIXELFORMATDESCRIPTOR.cDepthBits();
            gLData2.stencilSize = pIXELFORMATDESCRIPTOR.cStencilBits();
            int n12 = pIXELFORMATDESCRIPTOR.dwFlags();
            gLData2.doubleBuffer = (n12 & 1) != 0;
            gLData2.stereo = (n12 & 2) != 0;
            gLData2.accumRedSize = pIXELFORMATDESCRIPTOR.cAccumRedBits();
            gLData2.accumGreenSize = pIXELFORMATDESCRIPTOR.cAccumGreenBits();
            gLData2.accumBlueSize = pIXELFORMATDESCRIPTOR.cAccumBlueBits();
            gLData2.accumAlphaSize = pIXELFORMATDESCRIPTOR.cAccumAlphaBits();
            WGL.wglMakeCurrent(null, l10, l9);
            return l12;
        }
        if (!hashSet.contains("WGL_ARB_create_context")) {
            WGL.wglDeleteContext(null, l8);
            WGL.wglMakeCurrent(null, l10, l9);
            throw new SWTException("Extended context attributes requested but WGL_ARB_create_context is unavailable");
        }
        l4 = WGL.wglGetProcAddress(null, "wglCreateContextAttribsARB");
        if (l4 == 0L) {
            WGL.wglDeleteContext(null, l8);
            WGL.wglMakeCurrent(null, l10, l9);
            throw new SWTException("WGL_ARB_create_context available but wglCreateContextAttribsARB is NULL");
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(64);
        long l14 = MemoryUtil.memAddress(intBuffer);
        long l15 = User32.GetDC(l2);
        if (gLData.samples > 0 || gLData.sRGB || gLData.pixelFormatFloat) {
            long l16 = WGL.wglGetProcAddress(null, "wglChoosePixelFormatARB");
            if (l16 == 0L && (l16 = WGL.wglGetProcAddress(null, "wglChoosePixelFormatEXT")) == 0L) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("No support for wglChoosePixelFormatARB/EXT. Cannot query supported pixel formats.");
            }
            if (gLData.samples > 0) {
                boolean bl4;
                n6 = hashSet.contains("WGL_ARB_multisample");
                n5 = hashSet.contains("WGL_EXT_multisample");
                if (n6 == 0 && n5 == 0) {
                    User32.ReleaseDC(l2, l15);
                    WGL.wglDeleteContext(null, l8);
                    WGL.wglMakeCurrent(null, l10, l9);
                    throw new SWTException("Multisampling requested but neither WGL_ARB_multisample nor WGL_EXT_multisample available");
                }
                if (gLData.colorSamplesNV > 0 && !(bl4 = hashSet.contains("WGL_NV_multisample_coverage"))) {
                    User32.ReleaseDC(l2, l15);
                    WGL.wglDeleteContext(null, l8);
                    WGL.wglMakeCurrent(null, l10, l9);
                    throw new SWTException("Color samples requested but WGL_NV_multisample_coverage is unavailable");
                }
            }
            if (gLData.sRGB && (n6 = hashSet.contains("WGL_EXT_framebuffer_sRGB")) == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("sRGB color space requested but WGL_EXT_framebuffer_sRGB is unavailable");
            }
            if (gLData.pixelFormatFloat && (n6 = hashSet.contains("WGL_ARB_pixel_format_float")) == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("Floating-point format requested but WGL_ARB_pixel_format_float is unavailable");
            }
            this.encodePixelFormatAttribs(intBuffer, gLData);
            bl2 = JNI.callPPPPPI(l15, l14, 0L, 1, l6 + 4L, l6, l16) == 1;
            n6 = MemoryUtil.memGetInt(l6);
            if (!bl2 || n6 == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("No supported pixel format found.");
            }
            n8 = MemoryUtil.memGetInt(l6 + 4L);
            n5 = GDI32.DescribePixelFormat(null, l15, n8, pIXELFORMATDESCRIPTOR);
            if (n5 == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("Failed to validate supported pixel format.");
            }
            long l17 = WGL.wglGetProcAddress(null, "wglGetPixelFormatAttribivARB");
            if (l17 == 0L && (l17 = WGL.wglGetProcAddress(null, "wglGetPixelFormatAttribivEXT")) == 0L) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("No support for wglGetPixelFormatAttribivARB/EXT. Cannot get effective pixel format attributes.");
            }
            intBuffer.rewind();
            intBuffer.put(8209);
            intBuffer.put(8210);
            intBuffer.put(8211);
            intBuffer.put(8213);
            intBuffer.put(8215);
            intBuffer.put(8217);
            intBuffer.put(8219);
            intBuffer.put(8222);
            intBuffer.put(8223);
            intBuffer.put(8224);
            intBuffer.put(8225);
            intBuffer.put(8226);
            intBuffer.put(8227);
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer(intBuffer.position());
            long l18 = MemoryUtil.memAddress(intBuffer2);
            boolean bl5 = bl2 = JNI.callPPPI(l15, n8, 0, intBuffer.position(), l14, l18, l17) == 1;
            if (!bl2) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("Failed to get pixel format attributes.");
            }
            gLData2.doubleBuffer = intBuffer2.get(0) == 1;
            gLData2.stereo = intBuffer2.get(1) == 1;
            n4 = intBuffer2.get(2);
            gLData2.pixelFormatFloat = n4 == 8608;
            gLData2.redSize = intBuffer2.get(3);
            gLData2.greenSize = intBuffer2.get(4);
            gLData2.blueSize = intBuffer2.get(5);
            gLData2.alphaSize = intBuffer2.get(6);
            gLData2.accumRedSize = intBuffer2.get(7);
            gLData2.accumGreenSize = intBuffer2.get(8);
            gLData2.accumBlueSize = intBuffer2.get(9);
            gLData2.accumAlphaSize = intBuffer2.get(10);
            gLData2.depthSize = intBuffer2.get(11);
            gLData2.stencilSize = intBuffer2.get(12);
        }
        intBuffer.rewind();
        if (gLData.api == GLData$API.GL && PlatformWin32GLCanvas.atLeast30(gLData.majorVersion, gLData.minorVersion) || gLData.api == GLData$API.GLES && gLData.majorVersion > 0) {
            intBuffer.put(8337).put(gLData.majorVersion);
            intBuffer.put(8338).put(gLData.minorVersion);
        }
        int n13 = 0;
        if (gLData.api == GLData$API.GL) {
            if (gLData.profile == GLData$Profile.COMPATIBILITY) {
                n13 = 2;
            } else if (gLData.profile == GLData$Profile.CORE) {
                n13 = 1;
            }
        } else if (gLData.api == GLData$API.GLES) {
            n3 = hashSet.contains("WGL_EXT_create_context_es2_profile") ? 1 : 0;
            if (n3 == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("OpenGL ES API requested but WGL_EXT_create_context_es2_profile is unavailable");
            }
            n13 = 4;
        }
        if (n13 > 0) {
            n3 = hashSet.contains("WGL_ARB_create_context_profile");
            if (n3 == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("OpenGL profile requested but WGL_ARB_create_context_profile is unavailable");
            }
            intBuffer.put(37158).put(n13);
        }
        n3 = 0;
        if (gLData.debug) {
            n3 |= 1;
        }
        if (gLData.forwardCompatible) {
            n3 |= 2;
        }
        if (gLData.noErrorContext) {
            n3 |= 8;
            intBuffer.put(12723).put(1);
        }
        if (gLData.robustness) {
            n6 = string.contains("WGL_ARB_create_context_robustness") ? 1 : 0;
            if (n6 == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("Context with robust buffer access requested but WGL_ARB_create_context_robustness is unavailable");
            }
            n3 |= 4;
            if (gLData.loseContextOnReset) {
                intBuffer.put(33366).put(33362);
            }
            if (gLData.contextResetIsolation) {
                n5 = string.contains("WGL_ARB_robustness_application_isolation") ? 1 : 0;
                boolean bl6 = string.contains("WGL_ARB_robustness_share_group_isolation");
                if (n5 == 0 && !bl6) {
                    User32.ReleaseDC(l2, l15);
                    WGL.wglDeleteContext(null, l8);
                    WGL.wglMakeCurrent(null, l10, l9);
                    throw new SWTException("Robustness isolation requested but neither WGL_ARB_robustness_application_isolation nor WGL_ARB_robustness_share_group_isolation available");
                }
                n3 |= 8;
            }
        }
        if (n3 > 0) {
            intBuffer.put(8340).put(n3);
        }
        if (gLData.contextReleaseBehavior != null) {
            n6 = hashSet.contains("WGL_ARB_context_flush_control") ? 1 : 0;
            if (n6 == 0) {
                User32.ReleaseDC(l2, l15);
                WGL.wglDeleteContext(null, l8);
                WGL.wglMakeCurrent(null, l10, l9);
                throw new SWTException("Context release behavior requested but WGL_ARB_context_flush_control is unavailable");
            }
            if (gLData.contextReleaseBehavior == GLData$ReleaseBehavior.NONE) {
                intBuffer.put(8343).put(0);
            } else if (gLData.contextReleaseBehavior == GLData$ReleaseBehavior.FLUSH) {
                intBuffer.put(8343).put(8344);
            }
        }
        intBuffer.put(0).put(0);
        bl2 = GDI32.SetPixelFormat(null, l15, n8, pIXELFORMATDESCRIPTOR);
        if (!bl2) {
            User32.ReleaseDC(l2, l15);
            WGL.wglDeleteContext(null, l8);
            WGL.wglMakeCurrent(null, l10, l9);
            throw new SWTException("Failed to set pixel format.");
        }
        long l19 = JNI.callPPPP(l15, gLData.shareContext != null ? gLData.shareContext.context : 0L, l14, l4);
        WGL.wglDeleteContext(null, l8);
        if (l19 == 0L) {
            User32.ReleaseDC(l2, l15);
            WGL.wglMakeCurrent(null, l10, l9);
            throw new SWTException("Failed to create OpenGL context.");
        }
        WGL.wglMakeCurrent(null, l15, l19);
        if (gLData.swapInterval != null) {
            boolean bl7;
            boolean bl8 = hashSet.contains("WGL_EXT_swap_control");
            if (!bl8) {
                User32.ReleaseDC(l2, l15);
                WGL.wglMakeCurrent(null, l10, l9);
                WGL.wglDeleteContext(null, l19);
                throw new SWTException("Swap interval requested but WGL_EXT_swap_control is unavailable");
            }
            if (gLData.swapInterval < 0 && !(bl7 = hashSet.contains("WGL_EXT_swap_control_tear"))) {
                User32.ReleaseDC(l2, l15);
                WGL.wglMakeCurrent(null, l10, l9);
                WGL.wglDeleteContext(null, l19);
                throw new SWTException("Negative swap interval requested but WGL_EXT_swap_control_tear is unavailable");
            }
            long l20 = WGL.wglGetProcAddress(null, "wglSwapIntervalEXT");
            if (l20 != 0L) {
                JNI.callI(gLData.swapInterval, l20);
            }
        }
        if (gLData.swapGroupNV > 0 || gLData.swapBarrierNV > 0) {
            boolean bl9 = hashSet.contains("WGL_NV_swap_group");
            if (!bl9) {
                User32.ReleaseDC(l2, l15);
                WGL.wglMakeCurrent(null, l10, l9);
                WGL.wglDeleteContext(null, l19);
                throw new SWTException("Swap group or barrier requested but WGL_NV_swap_group is unavailable");
            }
            try {
                this.wglNvSwapGroupAndBarrier(gLData, l6, l15);
            }
            catch (SWTException sWTException) {
                User32.ReleaseDC(l2, l15);
                WGL.wglMakeCurrent(null, l10, l9);
                WGL.wglDeleteContext(null, l19);
                throw sWTException;
            }
        }
        User32.ReleaseDC(l2, l15);
        long l21 = GL.getFunctionProvider().getFunctionAddress("glGetIntegerv");
        long l22 = GL.getFunctionProvider().getFunctionAddress("glGetString");
        gLData2.api = gLData.api;
        if (PlatformWin32GLCanvas.atLeast30(gLData.majorVersion, gLData.minorVersion)) {
            JNI.callPV(33307, l6, l21);
            gLData2.majorVersion = MemoryUtil.memGetInt(l6);
            JNI.callPV(33308, l6, l21);
            gLData2.minorVersion = MemoryUtil.memGetInt(l6);
            JNI.callPV(33310, l6, l21);
            n2 = MemoryUtil.memGetInt(l6);
            gLData2.debug = (n2 & 2) != 0;
            gLData2.forwardCompatible = (n2 & 1) != 0;
            gLData2.robustness = (n2 & 4) != 0;
        } else if (gLData.api == GLData$API.GL) {
            APIUtil$APIVersion aPIUtil$APIVersion = APIUtil.apiParseVersion(MemoryUtil.memUTF8(Checks.check(JNI.callP(7938, l22))));
            gLData2.majorVersion = aPIUtil$APIVersion.major;
            gLData2.minorVersion = aPIUtil$APIVersion.minor;
        } else if (gLData.api == GLData$API.GLES) {
            APIUtil$APIVersion aPIUtil$APIVersion = APIUtil.apiParseVersion(MemoryUtil.memUTF8(Checks.check(JNI.callP(7938, l22))));
            gLData2.majorVersion = aPIUtil$APIVersion.major;
            gLData2.minorVersion = aPIUtil$APIVersion.minor;
        }
        if (gLData.api == GLData$API.GL && PlatformWin32GLCanvas.atLeast32(gLData2.majorVersion, gLData2.minorVersion)) {
            boolean bl10;
            JNI.callPV(37158, l6, l21);
            n2 = MemoryUtil.memGetInt(l6);
            n4 = (n2 & 1) != 0 ? 1 : 0;
            boolean bl11 = bl10 = (n2 & 2) != 0;
            gLData2.profile = bl10 ? GLData$Profile.COMPATIBILITY : (n4 != 0 ? GLData$Profile.CORE : null);
        }
        if (gLData.samples >= 1) {
            JNI.callPV(32937, l6, l21);
            gLData2.samples = MemoryUtil.memGetInt(l6);
            JNI.callPV(32936, l6, l21);
            gLData2.sampleBuffers = MemoryUtil.memGetInt(l6);
            n2 = hashSet.contains("WGL_NV_multisample_coverage") ? 1 : 0;
            if (n2 != 0) {
                JNI.callPV(36384, l6, l21);
                gLData2.colorSamplesNV = MemoryUtil.memGetInt(l6);
            }
        }
        WGL.wglMakeCurrent(null, l10, l9);
        return l19;
    }

    private void wglNvSwapGroupAndBarrier(GLData gLData, long l2, long l3) throws SWTException {
        long l4 = WGL.wglGetProcAddress(null, "wglQueryMaxSwapGroupsNV");
        int n2 = JNI.callPPPI(l3, l2, l2 + 4L, l4);
        int n3 = MemoryUtil.memGetInt(l2);
        if (n3 < gLData.swapGroupNV) {
            throw new SWTException("Swap group exceeds maximum group index");
        }
        int n4 = MemoryUtil.memGetInt(l2 + 4L);
        if (n4 < gLData.swapBarrierNV) {
            throw new SWTException("Swap barrier exceeds maximum barrier index");
        }
        if (gLData.swapGroupNV > 0) {
            long l5 = WGL.wglGetProcAddress(null, "wglJoinSwapGroupNV");
            if (l5 == 0L) {
                throw new SWTException("WGL_NV_swap_group available but wglJoinSwapGroupNV is NULL");
            }
            n2 = JNI.callPI(l3, gLData.swapGroupNV, l5);
            if (n2 == 0) {
                throw new SWTException("Failed to join swap group");
            }
            if (gLData.swapBarrierNV > 0) {
                long l6 = WGL.wglGetProcAddress(null, "wglBindSwapBarrierNV");
                if (l6 == 0L) {
                    throw new SWTException("WGL_NV_swap_group available but wglBindSwapBarrierNV is NULL");
                }
                n2 = JNI.callI(gLData.swapGroupNV, gLData.swapBarrierNV, l6);
                if (n2 == 0) {
                    throw new SWTException("Failed to bind swap barrier. Probably no G-Sync card installed.");
                }
            }
        }
    }

    @Override
    public boolean isCurrent(long l2) {
        long l3 = WGL.wglGetCurrentContext(null);
        return l3 == l2;
    }

    @Override
    public boolean makeCurrent(GLCanvas gLCanvas, long l2) {
        long l3 = User32.GetDC(gLCanvas.handle);
        boolean bl2 = WGL.wglMakeCurrent(null, l3, l2);
        User32.ReleaseDC(gLCanvas.handle, l3);
        return bl2;
    }

    @Override
    public boolean deleteContext(GLCanvas gLCanvas, long l2) {
        boolean bl2 = WGL.wglDeleteContext(null, l2);
        return bl2;
    }

    @Override
    public boolean swapBuffers(GLCanvas gLCanvas) {
        long l2 = User32.GetDC(gLCanvas.handle);
        boolean bl2 = GDI32.SwapBuffers(null, l2);
        User32.ReleaseDC(gLCanvas.handle, l2);
        return bl2;
    }

    @Override
    public boolean delayBeforeSwapNV(GLCanvas gLCanvas, float f2) {
        if (!this.wglDelayBeforeSwapNVAddr_set) {
            this.wglDelayBeforeSwapNVAddr = WGL.wglGetProcAddress(null, "wglDelayBeforeSwapNV");
            this.wglDelayBeforeSwapNVAddr_set = true;
        }
        if (this.wglDelayBeforeSwapNVAddr == 0L) {
            throw new UnsupportedOperationException("wglDelayBeforeSwapNV is unavailable");
        }
        long l2 = User32.GetDC(gLCanvas.handle);
        int n2 = JNI.callPI(l2, f2, this.wglDelayBeforeSwapNVAddr);
        User32.ReleaseDC(gLCanvas.handle, l2);
        return n2 == 1;
    }
}

