/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer$Default;

public abstract class CustomBuffer
extends Pointer$Default {
    protected ByteBuffer container;
    protected int mark;
    protected int position;
    protected int limit;
    protected int capacity;

    protected CustomBuffer(long l2, ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        super(l2);
        this.container = byteBuffer;
        this.mark = n2;
        this.position = n3;
        this.limit = n4;
        this.capacity = n5;
    }

    public abstract int sizeof();

    public long address0() {
        return this.address;
    }

    @Override
    public long address() {
        return this.address + Integer.toUnsignedLong(this.position) * (long)this.sizeof();
    }

    public long address(int n2) {
        return this.address + Integer.toUnsignedLong(n2) * (long)this.sizeof();
    }

    public void free() {
        MemoryUtil.nmemFree(this.address);
    }

    public int capacity() {
        return this.capacity;
    }

    public int position() {
        return this.position;
    }

    public CustomBuffer position(int n2) {
        if (n2 < 0 || this.limit < n2) {
            throw new IllegalArgumentException();
        }
        this.position = n2;
        if (n2 < this.mark) {
            this.mark = -1;
        }
        return this.self();
    }

    public int limit() {
        return this.limit;
    }

    public CustomBuffer limit(int n2) {
        if (n2 < 0 || this.capacity < n2) {
            throw new IllegalArgumentException();
        }
        this.limit = n2;
        if (n2 < this.position) {
            this.position = n2;
        }
        if (n2 < this.mark) {
            this.mark = -1;
        }
        return this.self();
    }

    public CustomBuffer mark() {
        this.mark = this.position;
        return this.self();
    }

    public CustomBuffer reset() {
        int n2 = this.mark;
        if (n2 < 0) {
            throw new InvalidMarkException();
        }
        this.position = n2;
        return this.self();
    }

    public CustomBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this.self();
    }

    public CustomBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this.self();
    }

    public CustomBuffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this.self();
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public boolean hasRemaining() {
        return this.position < this.limit;
    }

    public CustomBuffer slice() {
        return this.create(this.address + Integer.toUnsignedLong(this.position) * (long)this.sizeof(), this.container, -1, 0, this.remaining(), this.remaining());
    }

    public CustomBuffer slice(int n2, int n3) {
        int n4 = this.position + n2;
        if (n2 < 0 || this.limit < n2) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || this.capacity - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return this.create(this.address + Integer.toUnsignedLong(n4) * (long)this.sizeof(), this.container, -1, 0, n3, n3);
    }

    public CustomBuffer duplicate() {
        return this.create(this.address, this.container, this.mark, this.position, this.limit, this.capacity);
    }

    public CustomBuffer put(CustomBuffer customBuffer) {
        if (customBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n2 = customBuffer.remaining();
        if (this.remaining() < n2) {
            throw new BufferOverflowException();
        }
        MemoryUtil.memCopy(customBuffer.address(), this.address(), Integer.toUnsignedLong(n2) * (long)this.sizeof());
        this.position += n2;
        return this.self();
    }

    public CustomBuffer compact() {
        MemoryUtil.memCopy(this.address(), this.address, Integer.toUnsignedLong(this.remaining()) * (long)this.sizeof());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.mark = -1;
        return this.self();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    protected abstract CustomBuffer self();

    protected abstract CustomBuffer create(long var1, ByteBuffer var3, int var4, int var5, int var6, int var7);

    protected final int nextGetIndex() {
        if (this.position < this.limit) {
            return this.position++;
        }
        throw new BufferUnderflowException();
    }

    protected final int nextPutIndex() {
        if (this.position < this.limit) {
            return this.position++;
        }
        throw new BufferOverflowException();
    }
}

