/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XCirculateEvent$Buffer;

public class XCirculateEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EVENT;
    public static final int WINDOW;
    public static final int PLACE;

    protected XCirculateEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XCirculateEvent create(long l2, ByteBuffer byteBuffer) {
        return new XCirculateEvent(l2, byteBuffer);
    }

    public XCirculateEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XCirculateEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XCirculateEvent.ntype(this.address());
    }

    public long serial() {
        return XCirculateEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XCirculateEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XCirculateEvent.ndisplay(this.address());
    }

    public long event() {
        return XCirculateEvent.nevent(this.address());
    }

    public long window() {
        return XCirculateEvent.nwindow(this.address());
    }

    public int place() {
        return XCirculateEvent.nplace(this.address());
    }

    public XCirculateEvent type(int n2) {
        XCirculateEvent.ntype(this.address(), n2);
        return this;
    }

    public XCirculateEvent serial(long l2) {
        XCirculateEvent.nserial(this.address(), l2);
        return this;
    }

    public XCirculateEvent send_event(boolean bl2) {
        XCirculateEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XCirculateEvent display(long l2) {
        XCirculateEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XCirculateEvent event(long l2) {
        XCirculateEvent.nevent(this.address(), l2);
        return this;
    }

    public XCirculateEvent window(long l2) {
        XCirculateEvent.nwindow(this.address(), l2);
        return this;
    }

    public XCirculateEvent place(int n2) {
        XCirculateEvent.nplace(this.address(), n2);
        return this;
    }

    public XCirculateEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, int n3) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.event(l4);
        this.window(l5);
        this.place(n3);
        return this;
    }

    public XCirculateEvent set(XCirculateEvent xCirculateEvent) {
        MemoryUtil.memCopy(xCirculateEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XCirculateEvent malloc() {
        return new XCirculateEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XCirculateEvent calloc() {
        return new XCirculateEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XCirculateEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XCirculateEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XCirculateEvent create(long l2) {
        return new XCirculateEvent(l2, null);
    }

    public static XCirculateEvent createSafe(long l2) {
        return l2 == 0L ? null : new XCirculateEvent(l2, null);
    }

    public static XCirculateEvent$Buffer malloc(int n2) {
        return new XCirculateEvent$Buffer(MemoryUtil.nmemAllocChecked(XCirculateEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XCirculateEvent$Buffer calloc(int n2) {
        return new XCirculateEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XCirculateEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XCirculateEvent.__create(n2, SIZEOF);
        return new XCirculateEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XCirculateEvent$Buffer create(long l2, int n2) {
        return new XCirculateEvent$Buffer(l2, n2);
    }

    public static XCirculateEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XCirculateEvent$Buffer(l2, n2);
    }

    public static XCirculateEvent mallocStack() {
        return XCirculateEvent.malloc(MemoryStack.stackGet());
    }

    public static XCirculateEvent callocStack() {
        return XCirculateEvent.calloc(MemoryStack.stackGet());
    }

    public static XCirculateEvent mallocStack(MemoryStack memoryStack) {
        return XCirculateEvent.malloc(memoryStack);
    }

    public static XCirculateEvent callocStack(MemoryStack memoryStack) {
        return XCirculateEvent.calloc(memoryStack);
    }

    public static XCirculateEvent$Buffer mallocStack(int n2) {
        return XCirculateEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XCirculateEvent$Buffer callocStack(int n2) {
        return XCirculateEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XCirculateEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XCirculateEvent.malloc(n2, memoryStack);
    }

    public static XCirculateEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XCirculateEvent.calloc(n2, memoryStack);
    }

    public static XCirculateEvent malloc(MemoryStack memoryStack) {
        return new XCirculateEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XCirculateEvent calloc(MemoryStack memoryStack) {
        return new XCirculateEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XCirculateEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XCirculateEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XCirculateEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XCirculateEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nevent(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)EVENT);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int nplace(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)PLACE);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nevent(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)EVENT, l3);
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nplace(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)PLACE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XCirculateEvent.__struct(XCirculateEvent.__member(4), XCirculateEvent.__member(CLONG_SIZE), XCirculateEvent.__member(4), XCirculateEvent.__member(POINTER_SIZE), XCirculateEvent.__member(CLONG_SIZE), XCirculateEvent.__member(CLONG_SIZE), XCirculateEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        EVENT = struct$Layout.offsetof(4);
        WINDOW = struct$Layout.offsetof(5);
        PLACE = struct$Layout.offsetof(6);
    }
}

