/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XConfigureEvent$Buffer;

public class XConfigureEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int BORDER_WIDTH;
    public static final int ABOVE;
    public static final int OVERRIDE_REDIRECT;

    protected XConfigureEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XConfigureEvent create(long l2, ByteBuffer byteBuffer) {
        return new XConfigureEvent(l2, byteBuffer);
    }

    public XConfigureEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XConfigureEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XConfigureEvent.ntype(this.address());
    }

    public long serial() {
        return XConfigureEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XConfigureEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XConfigureEvent.ndisplay(this.address());
    }

    public long window() {
        return XConfigureEvent.nwindow(this.address());
    }

    public int x() {
        return XConfigureEvent.nx(this.address());
    }

    public int y() {
        return XConfigureEvent.ny(this.address());
    }

    public int width() {
        return XConfigureEvent.nwidth(this.address());
    }

    public int height() {
        return XConfigureEvent.nheight(this.address());
    }

    public int border_width() {
        return XConfigureEvent.nborder_width(this.address());
    }

    public long above() {
        return XConfigureEvent.nabove(this.address());
    }

    public boolean override_redirect() {
        return XConfigureEvent.noverride_redirect(this.address()) != 0;
    }

    public XConfigureEvent type(int n2) {
        XConfigureEvent.ntype(this.address(), n2);
        return this;
    }

    public XConfigureEvent serial(long l2) {
        XConfigureEvent.nserial(this.address(), l2);
        return this;
    }

    public XConfigureEvent send_event(boolean bl2) {
        XConfigureEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XConfigureEvent display(long l2) {
        XConfigureEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XConfigureEvent window(long l2) {
        XConfigureEvent.nwindow(this.address(), l2);
        return this;
    }

    public XConfigureEvent x(int n2) {
        XConfigureEvent.nx(this.address(), n2);
        return this;
    }

    public XConfigureEvent y(int n2) {
        XConfigureEvent.ny(this.address(), n2);
        return this;
    }

    public XConfigureEvent width(int n2) {
        XConfigureEvent.nwidth(this.address(), n2);
        return this;
    }

    public XConfigureEvent height(int n2) {
        XConfigureEvent.nheight(this.address(), n2);
        return this;
    }

    public XConfigureEvent border_width(int n2) {
        XConfigureEvent.nborder_width(this.address(), n2);
        return this;
    }

    public XConfigureEvent above(long l2) {
        XConfigureEvent.nabove(this.address(), l2);
        return this;
    }

    public XConfigureEvent override_redirect(boolean bl2) {
        XConfigureEvent.noverride_redirect(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XConfigureEvent set(int n2, long l2, boolean bl2, long l3, long l4, int n3, int n4, int n5, int n6, int n7, long l5, boolean bl3) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.window(l4);
        this.x(n3);
        this.y(n4);
        this.width(n5);
        this.height(n6);
        this.border_width(n7);
        this.above(l5);
        this.override_redirect(bl3);
        return this;
    }

    public XConfigureEvent set(XConfigureEvent xConfigureEvent) {
        MemoryUtil.memCopy(xConfigureEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XConfigureEvent malloc() {
        return new XConfigureEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XConfigureEvent calloc() {
        return new XConfigureEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XConfigureEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XConfigureEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XConfigureEvent create(long l2) {
        return new XConfigureEvent(l2, null);
    }

    public static XConfigureEvent createSafe(long l2) {
        return l2 == 0L ? null : new XConfigureEvent(l2, null);
    }

    public static XConfigureEvent$Buffer malloc(int n2) {
        return new XConfigureEvent$Buffer(MemoryUtil.nmemAllocChecked(XConfigureEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XConfigureEvent$Buffer calloc(int n2) {
        return new XConfigureEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XConfigureEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XConfigureEvent.__create(n2, SIZEOF);
        return new XConfigureEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XConfigureEvent$Buffer create(long l2, int n2) {
        return new XConfigureEvent$Buffer(l2, n2);
    }

    public static XConfigureEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XConfigureEvent$Buffer(l2, n2);
    }

    public static XConfigureEvent mallocStack() {
        return XConfigureEvent.malloc(MemoryStack.stackGet());
    }

    public static XConfigureEvent callocStack() {
        return XConfigureEvent.calloc(MemoryStack.stackGet());
    }

    public static XConfigureEvent mallocStack(MemoryStack memoryStack) {
        return XConfigureEvent.malloc(memoryStack);
    }

    public static XConfigureEvent callocStack(MemoryStack memoryStack) {
        return XConfigureEvent.calloc(memoryStack);
    }

    public static XConfigureEvent$Buffer mallocStack(int n2) {
        return XConfigureEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XConfigureEvent$Buffer callocStack(int n2) {
        return XConfigureEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XConfigureEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XConfigureEvent.malloc(n2, memoryStack);
    }

    public static XConfigureEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XConfigureEvent.calloc(n2, memoryStack);
    }

    public static XConfigureEvent malloc(MemoryStack memoryStack) {
        return new XConfigureEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XConfigureEvent calloc(MemoryStack memoryStack) {
        return new XConfigureEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XConfigureEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XConfigureEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XConfigureEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XConfigureEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int nx(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)X);
    }

    public static int ny(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)Y);
    }

    public static int nwidth(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)WIDTH);
    }

    public static int nheight(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)HEIGHT);
    }

    public static int nborder_width(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)BORDER_WIDTH);
    }

    public static long nabove(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)ABOVE);
    }

    public static int noverride_redirect(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)OVERRIDE_REDIRECT);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nx(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)Y, n2);
    }

    public static void nwidth(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)WIDTH, n2);
    }

    public static void nheight(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)HEIGHT, n2);
    }

    public static void nborder_width(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)BORDER_WIDTH, n2);
    }

    public static void nabove(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)ABOVE, l3);
    }

    public static void noverride_redirect(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)OVERRIDE_REDIRECT, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XConfigureEvent.__struct(XConfigureEvent.__member(4), XConfigureEvent.__member(CLONG_SIZE), XConfigureEvent.__member(4), XConfigureEvent.__member(POINTER_SIZE), XConfigureEvent.__member(CLONG_SIZE), XConfigureEvent.__member(4), XConfigureEvent.__member(4), XConfigureEvent.__member(4), XConfigureEvent.__member(4), XConfigureEvent.__member(4), XConfigureEvent.__member(CLONG_SIZE), XConfigureEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        X = struct$Layout.offsetof(5);
        Y = struct$Layout.offsetof(6);
        WIDTH = struct$Layout.offsetof(7);
        HEIGHT = struct$Layout.offsetof(8);
        BORDER_WIDTH = struct$Layout.offsetof(9);
        ABOVE = struct$Layout.offsetof(10);
        OVERRIDE_REDIRECT = struct$Layout.offsetof(11);
    }
}

