/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XGraphicsExposeEvent$Buffer;

public class XGraphicsExposeEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int DRAWABLE;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int COUNT;
    public static final int MAJOR_CODE;
    public static final int MINOR_CODE;

    protected XGraphicsExposeEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XGraphicsExposeEvent create(long l2, ByteBuffer byteBuffer) {
        return new XGraphicsExposeEvent(l2, byteBuffer);
    }

    public XGraphicsExposeEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XGraphicsExposeEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XGraphicsExposeEvent.ntype(this.address());
    }

    public long serial() {
        return XGraphicsExposeEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XGraphicsExposeEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XGraphicsExposeEvent.ndisplay(this.address());
    }

    public long drawable() {
        return XGraphicsExposeEvent.ndrawable(this.address());
    }

    public int x() {
        return XGraphicsExposeEvent.nx(this.address());
    }

    public int y() {
        return XGraphicsExposeEvent.ny(this.address());
    }

    public int width() {
        return XGraphicsExposeEvent.nwidth(this.address());
    }

    public int height() {
        return XGraphicsExposeEvent.nheight(this.address());
    }

    public int count() {
        return XGraphicsExposeEvent.ncount(this.address());
    }

    public int major_code() {
        return XGraphicsExposeEvent.nmajor_code(this.address());
    }

    public int minor_code() {
        return XGraphicsExposeEvent.nminor_code(this.address());
    }

    public XGraphicsExposeEvent type(int n2) {
        XGraphicsExposeEvent.ntype(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent serial(long l2) {
        XGraphicsExposeEvent.nserial(this.address(), l2);
        return this;
    }

    public XGraphicsExposeEvent send_event(boolean bl2) {
        XGraphicsExposeEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XGraphicsExposeEvent display(long l2) {
        XGraphicsExposeEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XGraphicsExposeEvent drawable(long l2) {
        XGraphicsExposeEvent.ndrawable(this.address(), l2);
        return this;
    }

    public XGraphicsExposeEvent x(int n2) {
        XGraphicsExposeEvent.nx(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent y(int n2) {
        XGraphicsExposeEvent.ny(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent width(int n2) {
        XGraphicsExposeEvent.nwidth(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent height(int n2) {
        XGraphicsExposeEvent.nheight(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent count(int n2) {
        XGraphicsExposeEvent.ncount(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent major_code(int n2) {
        XGraphicsExposeEvent.nmajor_code(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent minor_code(int n2) {
        XGraphicsExposeEvent.nminor_code(this.address(), n2);
        return this;
    }

    public XGraphicsExposeEvent set(int n2, long l2, boolean bl2, long l3, long l4, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.drawable(l4);
        this.x(n3);
        this.y(n4);
        this.width(n5);
        this.height(n6);
        this.count(n7);
        this.major_code(n8);
        this.minor_code(n9);
        return this;
    }

    public XGraphicsExposeEvent set(XGraphicsExposeEvent xGraphicsExposeEvent) {
        MemoryUtil.memCopy(xGraphicsExposeEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XGraphicsExposeEvent malloc() {
        return new XGraphicsExposeEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XGraphicsExposeEvent calloc() {
        return new XGraphicsExposeEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XGraphicsExposeEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XGraphicsExposeEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XGraphicsExposeEvent create(long l2) {
        return new XGraphicsExposeEvent(l2, null);
    }

    public static XGraphicsExposeEvent createSafe(long l2) {
        return l2 == 0L ? null : new XGraphicsExposeEvent(l2, null);
    }

    public static XGraphicsExposeEvent$Buffer malloc(int n2) {
        return new XGraphicsExposeEvent$Buffer(MemoryUtil.nmemAllocChecked(XGraphicsExposeEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XGraphicsExposeEvent$Buffer calloc(int n2) {
        return new XGraphicsExposeEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XGraphicsExposeEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XGraphicsExposeEvent.__create(n2, SIZEOF);
        return new XGraphicsExposeEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XGraphicsExposeEvent$Buffer create(long l2, int n2) {
        return new XGraphicsExposeEvent$Buffer(l2, n2);
    }

    public static XGraphicsExposeEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XGraphicsExposeEvent$Buffer(l2, n2);
    }

    public static XGraphicsExposeEvent mallocStack() {
        return XGraphicsExposeEvent.malloc(MemoryStack.stackGet());
    }

    public static XGraphicsExposeEvent callocStack() {
        return XGraphicsExposeEvent.calloc(MemoryStack.stackGet());
    }

    public static XGraphicsExposeEvent mallocStack(MemoryStack memoryStack) {
        return XGraphicsExposeEvent.malloc(memoryStack);
    }

    public static XGraphicsExposeEvent callocStack(MemoryStack memoryStack) {
        return XGraphicsExposeEvent.calloc(memoryStack);
    }

    public static XGraphicsExposeEvent$Buffer mallocStack(int n2) {
        return XGraphicsExposeEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XGraphicsExposeEvent$Buffer callocStack(int n2) {
        return XGraphicsExposeEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XGraphicsExposeEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XGraphicsExposeEvent.malloc(n2, memoryStack);
    }

    public static XGraphicsExposeEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XGraphicsExposeEvent.calloc(n2, memoryStack);
    }

    public static XGraphicsExposeEvent malloc(MemoryStack memoryStack) {
        return new XGraphicsExposeEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XGraphicsExposeEvent calloc(MemoryStack memoryStack) {
        return new XGraphicsExposeEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XGraphicsExposeEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XGraphicsExposeEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XGraphicsExposeEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XGraphicsExposeEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long ndrawable(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)DRAWABLE);
    }

    public static int nx(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)X);
    }

    public static int ny(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)Y);
    }

    public static int nwidth(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)WIDTH);
    }

    public static int nheight(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)HEIGHT);
    }

    public static int ncount(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)COUNT);
    }

    public static int nmajor_code(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)MAJOR_CODE);
    }

    public static int nminor_code(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)MINOR_CODE);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void ndrawable(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)DRAWABLE, l3);
    }

    public static void nx(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)Y, n2);
    }

    public static void nwidth(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)WIDTH, n2);
    }

    public static void nheight(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)HEIGHT, n2);
    }

    public static void ncount(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)COUNT, n2);
    }

    public static void nmajor_code(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)MAJOR_CODE, n2);
    }

    public static void nminor_code(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)MINOR_CODE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XGraphicsExposeEvent.__struct(XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(CLONG_SIZE), XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(POINTER_SIZE), XGraphicsExposeEvent.__member(CLONG_SIZE), XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(4), XGraphicsExposeEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        DRAWABLE = struct$Layout.offsetof(4);
        X = struct$Layout.offsetof(5);
        Y = struct$Layout.offsetof(6);
        WIDTH = struct$Layout.offsetof(7);
        HEIGHT = struct$Layout.offsetof(8);
        COUNT = struct$Layout.offsetof(9);
        MAJOR_CODE = struct$Layout.offsetof(10);
        MINOR_CODE = struct$Layout.offsetof(11);
    }
}

