/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURing$Buffer;
import org.lwjgl.system.linux.liburing.IOURingCQ;
import org.lwjgl.system.linux.liburing.IOURingSQ;

public class IOURing
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SQ;
    public static final int CQ;
    public static final int FLAGS;
    public static final int RING_FD;
    public static final int FEATURES;
    public static final int ENTER_RING_FD;
    public static final int INT_FLAGS;
    public static final int PAD;
    public static final int PAD2;

    protected IOURing(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURing create(long l2, ByteBuffer byteBuffer) {
        return new IOURing(l2, byteBuffer);
    }

    public IOURing(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURing.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public IOURingSQ sq() {
        return IOURing.nsq(this.address());
    }

    public IOURingCQ cq() {
        return IOURing.ncq(this.address());
    }

    public int flags() {
        return IOURing.nflags(this.address());
    }

    public int ring_fd() {
        return IOURing.nring_fd(this.address());
    }

    public int features() {
        return IOURing.nfeatures(this.address());
    }

    public int enter_ring_fd() {
        return IOURing.nenter_ring_fd(this.address());
    }

    public byte int_flags() {
        return IOURing.nint_flags(this.address());
    }

    public IOURing sq(IOURingSQ iOURingSQ) {
        IOURing.nsq(this.address(), iOURingSQ);
        return this;
    }

    public IOURing sq(Consumer consumer) {
        consumer.accept(this.sq());
        return this;
    }

    public IOURing cq(IOURingCQ iOURingCQ) {
        IOURing.ncq(this.address(), iOURingCQ);
        return this;
    }

    public IOURing cq(Consumer consumer) {
        consumer.accept(this.cq());
        return this;
    }

    public IOURing flags(int n2) {
        IOURing.nflags(this.address(), n2);
        return this;
    }

    public IOURing ring_fd(int n2) {
        IOURing.nring_fd(this.address(), n2);
        return this;
    }

    public IOURing features(int n2) {
        IOURing.nfeatures(this.address(), n2);
        return this;
    }

    public IOURing enter_ring_fd(int n2) {
        IOURing.nenter_ring_fd(this.address(), n2);
        return this;
    }

    public IOURing int_flags(byte by2) {
        IOURing.nint_flags(this.address(), by2);
        return this;
    }

    public IOURing set(IOURingSQ iOURingSQ, IOURingCQ iOURingCQ, int n2, int n3, int n4, int n5, byte by2) {
        this.sq(iOURingSQ);
        this.cq(iOURingCQ);
        this.flags(n2);
        this.ring_fd(n3);
        this.features(n4);
        this.enter_ring_fd(n5);
        this.int_flags(by2);
        return this;
    }

    public IOURing set(IOURing iOURing) {
        MemoryUtil.memCopy(iOURing.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURing malloc() {
        return new IOURing(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURing calloc() {
        return new IOURing(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURing create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURing(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURing create(long l2) {
        return new IOURing(l2, null);
    }

    public static IOURing createSafe(long l2) {
        return l2 == 0L ? null : new IOURing(l2, null);
    }

    public static IOURing$Buffer malloc(int n2) {
        return new IOURing$Buffer(MemoryUtil.nmemAllocChecked(IOURing.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURing$Buffer calloc(int n2) {
        return new IOURing$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURing$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURing.__create(n2, SIZEOF);
        return new IOURing$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURing$Buffer create(long l2, int n2) {
        return new IOURing$Buffer(l2, n2);
    }

    public static IOURing$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURing$Buffer(l2, n2);
    }

    public static IOURing malloc(MemoryStack memoryStack) {
        return new IOURing(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURing calloc(MemoryStack memoryStack) {
        return new IOURing(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURing$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURing$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURing$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURing$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static IOURingSQ nsq(long l2) {
        return IOURingSQ.create(l2 + (long)SQ);
    }

    public static IOURingCQ ncq(long l2) {
        return IOURingCQ.create(l2 + (long)CQ);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static int nring_fd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RING_FD);
    }

    public static int nfeatures(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FEATURES);
    }

    public static int nenter_ring_fd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)ENTER_RING_FD);
    }

    public static byte nint_flags(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)INT_FLAGS);
    }

    public static ByteBuffer npad(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)PAD, 3);
    }

    public static byte npad(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)PAD + Checks.check(n2, 3) * 1L);
    }

    public static int npad2(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)PAD2);
    }

    public static void nsq(long l2, IOURingSQ iOURingSQ) {
        MemoryUtil.memCopy(iOURingSQ.address(), l2 + (long)SQ, IOURingSQ.SIZEOF);
    }

    public static void ncq(long l2, IOURingCQ iOURingCQ) {
        MemoryUtil.memCopy(iOURingCQ.address(), l2 + (long)CQ, IOURingCQ.SIZEOF);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void nring_fd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RING_FD, n2);
    }

    public static void nfeatures(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FEATURES, n2);
    }

    public static void nenter_ring_fd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)ENTER_RING_FD, n2);
    }

    public static void nint_flags(long l2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)INT_FLAGS, by2);
    }

    public static void npad(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)PAD, byteBuffer.remaining() * 1);
    }

    public static void npad(long l2, int n2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)PAD + Checks.check(n2, 3) * 1L, by2);
    }

    public static void npad2(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)PAD2, n2);
    }

    public static void validate(long l2) {
        IOURingSQ.validate(l2 + (long)SQ);
        IOURingCQ.validate(l2 + (long)CQ);
    }

    static {
        Struct$Layout struct$Layout = IOURing.__struct(IOURing.__member(IOURingSQ.SIZEOF, IOURingSQ.ALIGNOF), IOURing.__member(IOURingCQ.SIZEOF, IOURingCQ.ALIGNOF), IOURing.__member(4), IOURing.__member(4), IOURing.__member(4), IOURing.__member(4), IOURing.__member(1), IOURing.__array(1, 3), IOURing.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        SQ = struct$Layout.offsetof(0);
        CQ = struct$Layout.offsetof(1);
        FLAGS = struct$Layout.offsetof(2);
        RING_FD = struct$Layout.offsetof(3);
        FEATURES = struct$Layout.offsetof(4);
        ENTER_RING_FD = struct$Layout.offsetof(5);
        INT_FLAGS = struct$Layout.offsetof(6);
        PAD = struct$Layout.offsetof(7);
        PAD2 = struct$Layout.offsetof(8);
    }
}

