/*
 * Decompiled with CFR 0.152.
 */
package ru.nnproject.symbiangl;

import emulator.Emulator;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGL11;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL11;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import ru.nnproject.symbiangl.GLException;

public class GL {
    private static boolean loaded;
    private static GL instance;
    private static Canvas targetCanvas;
    private static Graphics targetGraphics;
    static int contextHandle;
    private static Thread contextCreator;
    private static boolean contextActive;
    private static EGL10 egl;
    private static EGLDisplay eglDisplay;
    private static EGLContext eglContext;
    private static EGLSurface eglSurface;
    private static EGLConfig eglConfig;
    private static GL11 gl;

    private GL() {
    }

    public static void create(Canvas canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("canvas");
        }
        GL.create(canvas, new Graphics(Emulator.getEmulator().getScreen().getBackBufferImage(), Emulator.getEmulator().getScreen().getXRayScreenImage()));
    }

    public static void create(Graphics graphics) {
        GL.create(null, graphics);
    }

    static void create(Canvas canvas, Graphics graphics) {
        if (contextHandle != 0) {
            throw new GLException("create", "Context already exists");
        }
        if (graphics == null) {
            throw new IllegalArgumentException("graphics");
        }
        egl = (EGL10)EGLContext.getEGL();
        eglDisplay = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        egl.eglInitialize(eglDisplay, null);
        int[] nArray = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, -1, 12344};
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        egl.eglChooseConfig(eglDisplay, nArray, eGLConfigArray, 1, null);
        eglConfig = eGLConfigArray[0];
        eglContext = egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, null);
        eglSurface = egl.eglCreateWindowSurface(eglDisplay, eglConfig, graphics, null);
        gl = (GL11)eglContext.getGL();
        targetCanvas = canvas;
        targetGraphics = graphics;
        contextCreator = Thread.currentThread();
        contextHandle = 1;
    }

    public static void createPbuffer(int[] nArray, int[] nArray2) {
        if (contextHandle != 0) {
            throw new GLException("createPbufferContext", "Context already exists");
        }
        if (nArray != null && (nArray.length % 2 != 1 || nArray[nArray.length - 1] != 12344)) {
            throw new IllegalArgumentException("eglConfigAttribs");
        }
        if (nArray2 != null && (nArray2.length % 2 != 1 || nArray2[nArray2.length - 1] != 12344)) {
            throw new IllegalArgumentException("eglSurfaceAttribs");
        }
        eglContext = egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, null);
        eglSurface = egl.eglCreatePbufferSurface(eglDisplay, eglConfig, nArray2);
        gl = (GL11)eglContext.getGL();
        contextCreator = Thread.currentThread();
        contextHandle = 1;
        targetCanvas = null;
        targetGraphics = null;
    }

    public static void makeCurrent() {
        if (contextHandle == 0) {
            throw new GLException("makeCurrent", "Context not created");
        }
        if (contextActive) {
            throw new GLException("makeCurrent", "Context already active");
        }
        if (Thread.currentThread() != contextCreator) {
            throw new GLException("makeCurrent", "Called from different thread");
        }
        egl.eglMakeCurrent(eglDisplay, eglSurface, eglSurface, eglContext);
        contextActive = true;
    }

    public static void release() {
        GL.checkContext("release");
        egl.eglMakeCurrent(eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        contextActive = false;
    }

    public static void destroy() {
        if (contextHandle == 0) {
            throw new GLException("destroyContext", "No context");
        }
        if (Thread.currentThread() != contextCreator) {
            throw new GLException("destroy", "Called from different thread");
        }
        if (contextActive) {
            GL.release();
        }
        egl.eglDestroyContext(eglDisplay, eglContext);
        egl.eglDestroySurface(eglDisplay, eglSurface);
        contextCreator = null;
        targetGraphics = null;
        contextHandle = 0;
    }

    public static boolean swapBuffers() {
        GL.checkContext("swapBuffers");
        if (egl.eglSwapBuffers(eglDisplay, eglSurface)) {
            if (targetCanvas instanceof GameCanvas) {
                ((GameCanvas)targetCanvas).flushGraphics();
            }
            return true;
        }
        return false;
    }

    public static boolean setVsync(boolean bl2) {
        GL.checkContext("setVsync");
        if (targetGraphics != null && targetCanvas == null) {
            throw new GLException("create", "Invalid operation");
        }
        return ((EGL11)egl).eglSwapInterval(eglDisplay, bl2 ? 1 : 0);
    }

    public static void glAlphaFunc(int n2, float f2) {
        GL.checkContext("glAlphaFunc");
        gl.glAlphaFunc(n2, f2);
    }

    public static void glClearColor(float f2, float f3, float f4, float f5) {
        GL.checkContext("glClearColor");
        gl.glClearColor(f2, f3, f4, f5);
    }

    public static void glClearDepthf(float f2) {
        GL.checkContext("glClearDepthf");
        gl.glClearDepthf(f2);
    }

    public static void glClipPlanef(int n2, FloatBuffer floatBuffer) {
        GL.checkContext("glClipPlanef");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("equation = null");
        }
        gl.glClipPlanef(n2, floatBuffer);
    }

    public static void glColor4f(float f2, float f3, float f4, float f5) {
        GL.checkContext("glColor4f");
        gl.glColor4f(f2, f3, f4, f5);
    }

    public static void glDepthRangef(float f2, float f3) {
        GL.checkContext("glDepthRangef");
        gl.glDepthRangef(f2, f3);
    }

    public static void glFogf(int n2, float f2) {
        GL.checkContext("glFogf");
        gl.glFogf(n2, f2);
    }

    public static void glFogfv(int n2, FloatBuffer floatBuffer) {
        GL.checkContext("glFogfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glFogfv(n2, floatBuffer);
    }

    public static void glFrustumf(float f2, float f3, float f4, float f5, float f6, float f7) {
        GL.checkContext("glFrustumf");
        gl.glFrustumf(f2, f3, f4, f5, f6, f7);
    }

    public static void glGetClipPlanef(int n2, FloatBuffer floatBuffer) {
        GL.checkContext("glGetClipPlanef");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("eqn = null");
        }
        if (floatBuffer.remaining() < 4) {
            throw new IllegalArgumentException("eqn.remaining() < 4");
        }
        gl.glGetClipPlanef(n2, floatBuffer);
    }

    public static void glGetFloatv(int n2, FloatBuffer floatBuffer) {
        GL.checkContext("glGetFloatv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetFloatv(n2, floatBuffer);
    }

    public static void glGetLightfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glGetLightfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetLightfv(n2, n3, floatBuffer);
    }

    public static void glGetMaterialfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glGetMaterialfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetMaterialfv(n2, n3, floatBuffer);
    }

    public static void glGetTexEnvfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glGetTexEnvfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetTexEnvfv(n2, n3, floatBuffer);
    }

    public static void glGetTexParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glGetTexParameterfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetTexParameterfv(n2, n3, floatBuffer);
    }

    public static void glLightModelf(int n2, float f2) {
        GL.checkContext("glLightModelf");
        gl.glLightModelf(n2, f2);
    }

    public static void glLightModelfv(int n2, FloatBuffer floatBuffer) {
        GL.checkContext("glLightModelfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glLightModelfv(n2, floatBuffer);
    }

    public static void glLightf(int n2, int n3, float f2) {
        GL.checkContext("glLightf");
        gl.glLightf(n2, n3, f2);
    }

    public static void glLightfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glLightfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glLightfv(n2, n3, floatBuffer);
    }

    public static void glLineWidth(float f2) {
        GL.checkContext("glLineWidth");
        gl.glLineWidth(f2);
    }

    public static void glLoadMatrixf(FloatBuffer floatBuffer) {
        GL.checkContext("glLoadMatrixf");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("m = null");
        }
        gl.glLoadMatrixf(floatBuffer);
    }

    public static void glMaterialf(int n2, int n3, float f2) {
        GL.checkContext("glMaterialf");
        gl.glMaterialf(n2, n3, f2);
    }

    public static void glMaterialfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glMaterialfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glMaterialfv(n2, n3, floatBuffer);
    }

    public static void glMultMatrixf(FloatBuffer floatBuffer) {
        GL.checkContext("glMultMatrixf");
        gl.glMultMatrixf(floatBuffer);
    }

    public static void glMultiTexCoord4f(int n2, float f2, float f3, float f4, float f5) {
        GL.checkContext("glMultiTexCoord4f");
        gl.glMultiTexCoord4f(n2, f2, f3, f4, f5);
    }

    public static void glNormal3f(float f2, float f3, float f4) {
        GL.checkContext("glNormal3f");
        gl.glNormal3f(f2, f3, f4);
    }

    public static void glOrthof(float f2, float f3, float f4, float f5, float f6, float f7) {
        GL.checkContext("glOrthof");
        gl.glOrthof(f2, f3, f4, f5, f6, f7);
    }

    public static void glPointParameterf(int n2, float f2) {
        GL.checkContext("glPointParameterf");
        gl.glPointParameterf(n2, f2);
    }

    public static void glPointParameterfv(int n2, FloatBuffer floatBuffer) {
        GL.checkContext("glPointParameterfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glPointParameterfv(n2, floatBuffer);
    }

    public static void glPointSize(float f2) {
        GL.checkContext("glPointSize");
        gl.glPointSize(f2);
    }

    public static void glPolygonOffset(float f2, float f3) {
        GL.checkContext("glPolygonOffset");
        gl.glPolygonOffset(f2, f3);
    }

    public static void glRotatef(float f2, float f3, float f4, float f5) {
        GL.checkContext("glRotatef");
        gl.glRotatef(f2, f3, f4, f5);
    }

    public static void glScalef(float f2, float f3, float f4) {
        GL.checkContext("glScalef");
        gl.glScalef(f2, f3, f4);
    }

    public static void glTexEnvf(int n2, int n3, float f2) {
        GL.checkContext("glTexEnvf");
        gl.glTexEnvf(n2, n3, f2);
    }

    public static void glTexEnvfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glTexEnvfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glTexEnvfv(n2, n3, floatBuffer);
    }

    public static void glTexParameterf(int n2, int n3, float f2) {
        GL.checkContext("glTexParameterf");
        gl.glTexParameterf(n2, n3, f2);
    }

    public static void glTexParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL.checkContext("glTexParameterfv");
        if (floatBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glTexParameterfv(n2, n3, floatBuffer);
    }

    public static void glTranslatef(float f2, float f3, float f4) {
        GL.checkContext("glTranslatef");
        gl.glTranslatef(f2, f3, f4);
    }

    public static void glActiveTexture(int n2) {
        GL.checkContext("glActiveTexture");
        gl.glActiveTexture(n2);
    }

    public static void glAlphaFuncx(int n2, int n3) {
        GL.checkContext("glAlphaFuncx");
        gl.glAlphaFuncx(n2, n3);
    }

    public static void glBindBuffer(int n2, int n3) {
        GL.checkContext("glBindBuffer");
        gl.glBindBuffer(n2, n3);
    }

    public static void glBindTexture(int n2, int n3) {
        GL.checkContext("glBindTexture");
        gl.glBindTexture(n2, n3);
    }

    public static void glBlendFunc(int n2, int n3) {
        GL.checkContext("glBlendFunc");
        gl.glBlendFunc(n2, n3);
    }

    public static void glBufferData(int n2, int n3, Buffer buffer, int n4) {
        GL.checkContext("glBufferData");
        if (buffer == null) {
            throw new IllegalArgumentException("data = null");
        }
        gl.glBufferData(n2, n3, buffer, n4);
    }

    public static void glBufferSubData(int n2, int n3, int n4, Buffer buffer) {
        GL.checkContext("glBufferSubData");
        if (buffer == null) {
            throw new IllegalArgumentException("data = null");
        }
        gl.glBufferSubData(n2, n3, n4, buffer);
    }

    public static void glClear(int n2) {
        GL.checkContext("glClear");
        gl.glClear(n2);
    }

    public static void glClearColorx(int n2, int n3, int n4, int n5) {
        GL.checkContext("glClearColorx");
        gl.glClearColorx(n2, n3, n4, n5);
    }

    public static void glClearDepthx(int n2) {
        GL.checkContext("glClearDepthx");
        gl.glClearDepthx(n2);
    }

    public static void glClearStencil(int n2) {
        GL.checkContext("glClearStencil");
        gl.glClearStencil(n2);
    }

    public static void glClientActiveTexture(int n2) {
        GL.checkContext("glClientActiveTexture");
        gl.glClientActiveTexture(n2);
    }

    public static void glClipPlanex(int n2, IntBuffer intBuffer) {
        GL.checkContext("glClipPlanex");
        if (intBuffer == null) {
            throw new IllegalArgumentException("equation = null");
        }
        gl.glClipPlanex(n2, intBuffer);
    }

    public static void glColor4ub(byte by2, byte by3, byte by4, byte by5) {
        GL.checkContext("glColor4ub");
        gl.glColor4ub(by2, by3, by4, by5);
    }

    public static void glColor4x(int n2, int n3, int n4, int n5) {
        GL.checkContext("glColor4x");
        gl.glColor4x(n2, n3, n4, n5);
    }

    public static void glColorMask(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        GL.checkContext("glColorMask");
        gl.glColorMask(bl2, bl3, bl4, bl5);
    }

    public static void glColorPointer(int n2, int n3, int n4, Buffer buffer) {
        GL.checkContext("glColorPointer");
        if (buffer == null) {
            throw new IllegalArgumentException("pointer = null");
        }
        gl.glColorPointer(n2, n3, n4, buffer);
    }

    public static void glColorPointer(int n2, int n3, int n4, int n5) {
        GL.checkContext("glColorPointer");
        if (n5 < 0) {
            throw new IllegalArgumentException("pointer < 0");
        }
        gl.glColorPointer(n2, n3, n4, n5);
    }

    public static void glCompressedTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GL.checkContext("glCompressedTexImage2D");
        if (buffer == null) {
            throw new IllegalArgumentException("data = null");
        }
        gl.glCompressedTexImage2D(n2, n3, n4, n5, n6, n7, n8, buffer);
    }

    public static void glCompressedTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        GL.checkContext("glCompressedTexSubImage2D");
        if (buffer == null) {
            throw new IllegalArgumentException("data = null");
        }
        gl.glCompressedTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
    }

    public static void glCopyTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GL.checkContext("glCopyTexImage2D");
        gl.glCopyTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static void glCopyTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GL.checkContext("glCopyTexSubImage2D");
        gl.glCopyTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static void glCullFace(int n2) {
        GL.checkContext("glCullFace");
        gl.glCullFace(n2);
    }

    public static void glDeleteBuffers(int n2, IntBuffer intBuffer) {
        GL.checkContext("glDeleteBuffers");
        if (intBuffer == null) {
            throw new IllegalArgumentException("buffer = null");
        }
        gl.glDeleteBuffers(n2, intBuffer);
    }

    public static void glDeleteTextures(int n2, IntBuffer intBuffer) {
        GL.checkContext("glDeleteTextures");
        if (intBuffer == null) {
            throw new IllegalArgumentException("textures = null");
        }
        gl.glDeleteTextures(n2, intBuffer);
    }

    public static void glDepthFunc(int n2) {
        GL.checkContext("glDepthFunc");
        gl.glDepthFunc(n2);
    }

    public static void glDepthMask(boolean bl2) {
        GL.checkContext("glDepthMask");
        gl.glDepthMask(bl2);
    }

    public static void glDepthRangex(int n2, int n3) {
        GL.checkContext("glDepthRangex");
        gl.glDepthRangex(n2, n3);
    }

    public static void glDisable(int n2) {
        GL.checkContext("glDisable");
        gl.glDisable(n2);
    }

    public static void glDisableClientState(int n2) {
        GL.checkContext("glDisableClientState");
        gl.glDisableClientState(n2);
    }

    public static void glDrawArrays(int n2, int n3, int n4) {
        GL.checkContext("glDrawArrays");
        gl.glDrawArrays(n2, n3, n4);
    }

    public static void glDrawElements(int n2, int n3, int n4, Buffer buffer) {
        GL.checkContext("glDrawElements");
        if (buffer == null) {
            throw new IllegalArgumentException("indices = null");
        }
        gl.glDrawElements(n2, n3, n4, buffer);
    }

    public static void glDrawElements(int n2, int n3, int n4, int n5) {
        GL.checkContext("glDrawElements");
        gl.glDrawElements(n2, n3, n4, n5);
    }

    public static void glEnable(int n2) {
        GL.checkContext("glEnable");
        gl.glEnable(n2);
    }

    public static void glEnableClientState(int n2) {
        GL.checkContext("glEnableClientState");
        gl.glEnableClientState(n2);
    }

    public static void glFinish() {
        GL.checkContext("glFinish");
        gl.glFinish();
    }

    public static void glFlush() {
        GL.checkContext("glFlush");
        gl.glFlush();
    }

    public static void glFogx(int n2, int n3) {
        GL.checkContext("glFogx");
        gl.glFogx(n2, n3);
    }

    public static void glFogxv(int n2, IntBuffer intBuffer) {
        GL.checkContext("glFogxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glFogxv(n2, intBuffer);
    }

    public static void glFrontFace(int n2) {
        GL.checkContext("glFrontFace");
        gl.glFrontFace(n2);
    }

    public static void glFrustumx(int n2, int n3, int n4, int n5, int n6, int n7) {
        GL.checkContext("glFrustumx");
        gl.glFrustumx(n2, n3, n4, n5, n6, n7);
    }

    public static void glGetBooleanv(int n2, IntBuffer intBuffer) {
        GL.checkContext("glGetBooleanv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetBooleanv(n2, intBuffer);
    }

    public static void glGetBufferParameteriv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glGetBufferParameteriv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetBufferParameteriv(n2, n3, intBuffer);
    }

    public static void glGetClipPlanex(int n2, IntBuffer intBuffer) {
        GL.checkContext("glGetClipPlanex");
        if (intBuffer == null) {
            throw new IllegalArgumentException("eqn = null");
        }
        if (intBuffer.remaining() < 4) {
            throw new IllegalArgumentException("eqn.remaining() < 4");
        }
        gl.glGetClipPlanex(n2, intBuffer);
    }

    public static void glGenBuffers(int n2, IntBuffer intBuffer) {
        GL.checkContext("glGenBuffers");
        if (intBuffer == null) {
            throw new IllegalArgumentException("buffers = null");
        }
        gl.glGenBuffers(n2, intBuffer);
    }

    public static void glGenTextures(int n2, IntBuffer intBuffer) {
        GL.checkContext("glGenTextures");
        if (intBuffer == null) {
            throw new IllegalArgumentException("textures = null");
        }
        gl.glGenTextures(n2, intBuffer);
    }

    public static int glGetError() {
        GL.checkContext("glGetError");
        return gl.glGetError();
    }

    public static void glGetFixedv(int n2, IntBuffer intBuffer) {
        GL.checkContext("glGetFixedv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetFixedv(n2, intBuffer);
    }

    public static void glGetIntegerv(int n2, IntBuffer intBuffer) {
        GL.checkContext("glGetIntegerv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetIntegerv(n2, intBuffer);
    }

    public static void glGetLightxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glGetLightxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetLightxv(n2, n3, intBuffer);
    }

    public static void glGetMaterialxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glGetMaterialxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetMaterialxv(n2, n3, intBuffer);
    }

    public static void glGetPointerv(int n2, Buffer[] bufferArray) {
        GL.checkContext("glGetPointerv");
        if (bufferArray == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetPointerv(n2, bufferArray);
    }

    public static String glGetString(int n2) {
        GL.checkContext("glGetString");
        return gl.glGetString(n2);
    }

    public static void glGetTexEnviv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glGetTexEnviv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetTexEnviv(n2, n3, intBuffer);
    }

    public static void glGetTexEnvxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glGetTexEnvxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetTexEnvxv(n2, n3, intBuffer);
    }

    public static void glGetTexParameteriv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glGetTexParameteriv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetTexParameteriv(n2, n3, intBuffer);
    }

    public static void glGetTexParameterxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glGetTexParameterxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glGetTexParameterxv(n2, n3, intBuffer);
    }

    public static void glHint(int n2, int n3) {
        GL.checkContext("glHint");
        gl.glHint(n2, n3);
    }

    public static boolean glIsBuffer(int n2) {
        GL.checkContext("glIsBuffer");
        return gl.glIsBuffer(n2);
    }

    public static boolean glIsEnabled(int n2) {
        GL.checkContext("glIsEnabled");
        return gl.glIsEnabled(n2);
    }

    public static boolean glIsTexture(int n2) {
        GL.checkContext("glIsTexture");
        return gl.glIsTexture(n2);
    }

    public static void glLightModelx(int n2, int n3) {
        GL.checkContext("glLightModelx");
        gl.glLightModelx(n2, n3);
    }

    public static void glLightModelxv(int n2, IntBuffer intBuffer) {
        GL.checkContext("glLightModelxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glLightModelxv(n2, intBuffer);
    }

    public static void glLightx(int n2, int n3, int n4) {
        GL.checkContext("glLightx");
        gl.glLightx(n2, n3, n4);
    }

    public static void glLightxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glLightxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glLightxv(n2, n3, intBuffer);
    }

    public static void glLineWidthx(int n2) {
        GL.checkContext("glLineWidthx");
        gl.glLineWidthx(n2);
    }

    public static void glLoadIdentity() {
        GL.checkContext("glLoadIdentity");
        gl.glLoadIdentity();
    }

    public static void glLoadMatrixx(IntBuffer intBuffer) {
        GL.checkContext("glLoadMatrixx");
        if (intBuffer == null) {
            throw new IllegalArgumentException("m = null");
        }
        gl.glLoadMatrixx(intBuffer);
    }

    public static void glLogicOp(int n2) {
        GL.checkContext("glLogicOp");
        gl.glLogicOp(n2);
    }

    public static void glMaterialx(int n2, int n3, int n4) {
        GL.checkContext("glMaterialx");
        gl.glMaterialx(n2, n3, n4);
    }

    public static void glMaterialxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glMaterialxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glMaterialxv(n2, n3, intBuffer);
    }

    public static void glMatrixMode(int n2) {
        GL.checkContext("glMatrixMode");
        gl.glMatrixMode(n2);
    }

    public static void glMultMatrixx(IntBuffer intBuffer) {
        GL.checkContext("glMultMatrixx");
        if (intBuffer == null) {
            throw new IllegalArgumentException("m = null");
        }
        gl.glMultMatrixx(intBuffer);
    }

    public static void glMultiTexCoord4x(int n2, int n3, int n4, int n5, int n6) {
        GL.checkContext("glMultiTexCoord4x");
        gl.glMultiTexCoord4x(n2, n3, n4, n5, n6);
    }

    public static void glNormal3x(int n2, int n3, int n4) {
        GL.checkContext("glNormal3x");
        gl.glNormal3x(n2, n3, n4);
    }

    public static void glNormalPointer(int n2, int n3, Buffer buffer) {
        GL.checkContext("glNormalPointer");
        if (buffer == null) {
            throw new IllegalArgumentException("pointer = null");
        }
        gl.glNormalPointer(n2, n3, buffer);
    }

    public static void glNormalPointer(int n2, int n3, int n4) {
        GL.checkContext("glNormalPointer");
        if (n4 < 0) {
            throw new IllegalArgumentException("pointer < 0");
        }
        gl.glNormalPointer(n2, n3, n4);
    }

    public static void glOrthox(int n2, int n3, int n4, int n5, int n6, int n7) {
        GL.checkContext("glOrthox");
        gl.glOrthox(n2, n3, n4, n5, n6, n7);
    }

    public static void glPixelStorei(int n2, int n3) {
        GL.checkContext("glPixelStorei");
        gl.glPixelStorei(n2, n3);
    }

    public static void glPointParameterx(int n2, int n3) {
        GL.checkContext("glPointParameterx");
        gl.glPointParameterx(n2, n3);
    }

    public static void glPointParameterxv(int n2, IntBuffer intBuffer) {
        GL.checkContext("glPointParameterxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glPointParameterxv(n2, intBuffer);
    }

    public static void glPointSizex(int n2) {
        GL.checkContext("glPointSizex");
        gl.glPointSizex(n2);
    }

    public static void glPolygonOffsetx(int n2, int n3) {
        GL.checkContext("glPolygonOffsetx");
        gl.glPolygonOffsetx(n2, n3);
    }

    public static void glPopMatrix() {
        GL.checkContext("glPopMatrix");
        gl.glPopMatrix();
    }

    public static void glPushMatrix() {
        GL.checkContext("glPushMatrix");
        gl.glPushMatrix();
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        GL.checkContext("glReadPixels");
        if (buffer == null) {
            throw new IllegalArgumentException("pixels = null");
        }
        gl.glReadPixels(n2, n3, n4, n5, n6, n7, buffer);
    }

    public static void glRotatex(int n2, int n3, int n4, int n5) {
        GL.checkContext("glRotatex");
        gl.glRotatex(n2, n3, n4, n5);
    }

    public static void glSampleCoverage(float f2, boolean bl2) {
        GL.checkContext("glSampleCoverage");
        gl.glSampleCoverage(f2, bl2);
    }

    public static void glSampleCoveragex(int n2, boolean bl2) {
        GL.checkContext("glSampleCoveragex");
        gl.glSampleCoveragex(n2, bl2);
    }

    public static void glScalex(int n2, int n3, int n4) {
        GL.checkContext("glScalex");
        gl.glScalex(n2, n3, n4);
    }

    public static void glScissor(int n2, int n3, int n4, int n5) {
        GL.checkContext("glScissor");
        gl.glScissor(n2, n3, n4, n5);
    }

    public static void glShadeModel(int n2) {
        GL.checkContext("glShadeModel");
        gl.glShadeModel(n2);
    }

    public static void glStencilFunc(int n2, int n3, int n4) {
        GL.checkContext("glStencilFunc");
        gl.glStencilFunc(n2, n3, n4);
    }

    public static void glStencilMask(int n2) {
        GL.checkContext("glStencilMask");
        gl.glStencilMask(n2);
    }

    public static void glStencilOp(int n2, int n3, int n4) {
        GL.checkContext("glStencilOp");
        gl.glStencilOp(n2, n3, n4);
    }

    public static void glTexCoordPointer(int n2, int n3, int n4, Buffer buffer) {
        GL.checkContext("glTexCoordPointer");
        if (buffer == null) {
            throw new IllegalArgumentException("pointer = null");
        }
        gl.glTexCoordPointer(n2, n3, n4, buffer);
    }

    public static void glTexCoordPointer(int n2, int n3, int n4, int n5) {
        GL.checkContext("glTexCoordPointer");
        if (n5 < 0) {
            throw new IllegalArgumentException("pointer < 0");
        }
        gl.glTexCoordPointer(n2, n3, n4, n5);
    }

    public static void glTexEnvi(int n2, int n3, int n4) {
        GL.checkContext("glTexEnvi");
        gl.glTexEnvi(n2, n3, n4);
    }

    public static void glTexEnvx(int n2, int n3, int n4) {
        GL.checkContext("glTexEnvx");
        gl.glTexEnvx(n2, n3, n4);
    }

    public static void glTexEnviv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glTexEnviv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glTexEnviv(n2, n3, intBuffer);
    }

    public static void glTexEnvxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glTexEnvxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glTexEnvxv(n2, n3, intBuffer);
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        GL.checkContext("glTexImage2D");
        if (buffer == null) {
            throw new IllegalArgumentException("pixels = null");
        }
        gl.glTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
    }

    public static void glTexParameteri(int n2, int n3, int n4) {
        GL.checkContext("glTexParameteri");
        gl.glTexParameteri(n2, n3, n4);
    }

    public static void glTexParameterx(int n2, int n3, int n4) {
        GL.checkContext("glTexParameterx");
        gl.glTexParameterx(n2, n3, n4);
    }

    public static void glTexParameteriv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glTexParameteriv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glTexParameteriv(n2, n3, intBuffer);
    }

    public static void glTexParameterxv(int n2, int n3, IntBuffer intBuffer) {
        GL.checkContext("glTexParameterxv");
        if (intBuffer == null) {
            throw new IllegalArgumentException("params = null");
        }
        gl.glTexParameterxv(n2, n3, intBuffer);
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        GL.checkContext("glTexSubImage2D");
        if (buffer == null) {
            throw new IllegalArgumentException("pixels = null");
        }
        gl.glTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
    }

    public static void glTranslatex(int n2, int n3, int n4) {
        GL.checkContext("glTranslatex");
        gl.glTranslatex(n2, n3, n4);
    }

    public static void glVertexPointer(int n2, int n3, int n4, Buffer buffer) {
        GL.checkContext("glVertexPointer");
        if (buffer == null) {
            throw new IllegalArgumentException("pointer = null");
        }
        gl.glVertexPointer(n2, n3, n4, buffer);
    }

    public static void glVertexPointer(int n2, int n3, int n4, int n5) {
        GL.checkContext("glVertexPointer");
        if (n5 < 0) {
            throw new IllegalArgumentException("pointer < 0");
        }
        gl.glVertexPointer(n2, n3, n4, n5);
    }

    public static void glViewport(int n2, int n3, int n4, int n5) {
        GL.checkContext("glViewport");
        gl.glViewport(n2, n3, n4, n5);
    }

    static void checkContext(String string) {
        if (contextHandle == 0) {
            throw new GLException(string, "No context");
        }
        if (!contextActive) {
            throw new GLException(string, "Context not active");
        }
        if (Thread.currentThread() != contextCreator) {
            throw new GLException(string, "Called from different thread");
        }
    }

    static {
        try {
            loaded = true;
            instance = new GL();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

