/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import ru.woesss.j2me.micro3d.Program;
import ru.woesss.j2me.micro3d.TextureImpl;

final class Program$Color
extends Program {
    private static final String VERTEX = "/shaders/color.vsh";
    private static final String FRAGMENT = "/shaders/color.fsh";
    int uSphereSize;
    int uToonThreshold;
    int uToonHigh;
    int uToonLow;

    Program$Color() {
        super(VERTEX, FRAGMENT);
    }

    @Override
    protected void getLocations() {
        this.aPosition = GL20.glGetAttribLocation(this.id, "aPosition");
        this.aNormal = GL20.glGetAttribLocation(this.id, "aNormal");
        this.aColorData = GL20.glGetAttribLocation(this.id, "aColorData");
        this.aMaterial = GL20.glGetAttribLocation(this.id, "aMaterial");
        this.uMatrix = GL20.glGetUniformLocation(this.id, "uMatrix");
        this.uNormalMatrix = GL20.glGetUniformLocation(this.id, "uNormalMatrix");
        this.uAmbIntensity = GL20.glGetUniformLocation(this.id, "uAmbIntensity");
        this.uDirIntensity = GL20.glGetUniformLocation(this.id, "uDirIntensity");
        this.uLightDir = GL20.glGetUniformLocation(this.id, "uLightDir");
        this.uSphereSize = GL20.glGetUniformLocation(this.id, "uSphereSize");
        this.uToonThreshold = GL20.glGetUniformLocation(this.id, "uToonThreshold");
        this.uToonHigh = GL20.glGetUniformLocation(this.id, "uToonHigh");
        this.uToonLow = GL20.glGetUniformLocation(this.id, "uToonLow");
        this.use();
        GL20.glUniform1i(GL20.glGetUniformLocation(this.id, "uSphereUnit"), 2);
    }

    void setColor(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        float f2 = (float)(byteBuffer.get() & 0xFF) / 255.0f;
        float f3 = (float)(byteBuffer.get() & 0xFF) / 255.0f;
        float f4 = (float)(byteBuffer.get() & 0xFF) / 255.0f;
        GL20.glVertexAttrib3f(this.aColorData, f2, f3, f4);
    }

    void setToonShading(int n2, int n3, int n4, int n5) {
        if ((n2 & 4) != 0) {
            GL20.glUniform1f(this.uToonThreshold, (float)n3 / 255.0f);
            GL20.glUniform1f(this.uToonHigh, (float)n4 / 255.0f);
            GL20.glUniform1f(this.uToonLow, (float)n5 / 255.0f);
        } else {
            GL20.glUniform1f(this.uToonThreshold, -1.0f);
        }
    }

    void bindMatrices(float[] fArray, float[] fArray2) {
        GL20.glUniformMatrix4fv(this.uMatrix, false, fArray);
        GL20.glUniformMatrix3fv(this.uNormalMatrix, false, fArray2);
    }

    void setSphere(TextureImpl textureImpl) {
        if (textureImpl != null) {
            int n2 = textureImpl.getId();
            GL20.glActiveTexture(33986);
            GL11.glBindTexture(3553, n2);
            GL20.glUniform2f(this.uSphereSize, textureImpl.getWidth(), textureImpl.getHeight());
        } else {
            GL20.glUniform2f(this.uSphereSize, -1.0f, -1.0f);
        }
    }
}

