/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.custom.ResourceManager;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import org.lwjgl.opengl.GL20;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.Light;
import ru.woesss.j2me.micro3d.MathUtil;
import ru.woesss.j2me.micro3d.Program$Color;
import ru.woesss.j2me.micro3d.Program$Simple;
import ru.woesss.j2me.micro3d.Program$Sprite;
import ru.woesss.j2me.micro3d.Program$Tex;
import ru.woesss.j2me.micro3d.Render;

abstract class Program {
    static Program$Tex tex;
    static Program$Color color;
    static Program$Simple simple;
    static Program$Sprite sprite;
    private static boolean isCreated;
    protected final int id;
    protected int uAmbIntensity;
    protected int uDirIntensity;
    protected int uLightDir;
    protected int uMatrix;
    protected int uNormalMatrix;
    int aPosition;
    int aNormal;
    int aColorData;
    int aMaterial;

    Program(String string, String string2) {
        try {
            this.id = this.createProgram(string, string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.getLocations();
        Render.checkGlError("getLocations");
    }

    static void create() {
        if (isCreated) {
            return;
        }
        tex = new Program$Tex();
        color = new Program$Color();
        simple = new Program$Simple();
        sprite = new Program$Sprite();
    }

    private int createProgram(String string, String string2) throws IOException {
        String string3 = new String(ResourceManager.getBytes(this.getClass().getResourceAsStream(string)), StandardCharsets.UTF_8);
        String string4 = new String(ResourceManager.getBytes(this.getClass().getResourceAsStream(string2)), StandardCharsets.UTF_8);
        System.out.println("loadShader " + string);
        int n2 = this.loadShader(35633, string3);
        System.out.println("loadShader " + string2);
        int n3 = this.loadShader(35632, string4);
        int n4 = GL20.glCreateProgram();
        GL20.glAttachShader(n4, n2);
        GL20.glAttachShader(n4, n3);
        GL20.glLinkProgram(n4);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        GL20.glGetProgramiv(n4, 35714, intBuffer);
        if (intBuffer.get(0) == 0) {
            String string5 = GL20.glGetProgramInfoLog(n4, 512);
            System.out.println("createProgram: " + string5);
        }
        GL20.glDeleteShader(n2);
        GL20.glDeleteShader(n3);
        Render.checkGlError("glLinkProgram");
        return n4;
    }

    protected int loadShader(int n2, String string) {
        int n3 = GL20.glCreateShader(n2);
        GL20.glShaderSource(n3, (CharSequence)string);
        GL20.glCompileShader(n3);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        GL20.glGetShaderiv(n3, 35713, intBuffer);
        if (intBuffer.get(0) == 0) {
            String string2 = GL20.glGetShaderInfoLog(n3, 512);
            System.out.println("loadShader: " + string2);
        }
        Render.checkGlError("glCompileShader");
        return n3;
    }

    void use() {
        GL20.glUseProgram(this.id);
    }

    protected abstract void getLocations();

    static void release() {
        if (!isCreated) {
            return;
        }
        tex.delete();
        color.delete();
        simple.delete();
        sprite.delete();
        isCreated = false;
    }

    void delete() {
        GL20.glDeleteProgram(this.id);
        Render.checkGlError("program delete");
    }

    void setLight(Light light) {
        if (light == null) {
            GL20.glUniform1f(this.uAmbIntensity, -1.0f);
            return;
        }
        GL20.glUniform1f(this.uAmbIntensity, (float)MathUtil.clamp(light.ambIntensity, 0, 4096) * 2.4414062E-4f);
        GL20.glUniform1f(this.uDirIntensity, (float)MathUtil.clamp(light.dirIntensity, 0, 16384) * 2.4414062E-4f);
        float f2 = light.x;
        float f3 = light.y;
        float f4 = light.z;
        float f5 = -1.0f / (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        GL20.glUniform3f(this.uLightDir, f2 * f5, f3 * f5, f4 * f5);
    }
}

