/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery;

import com.sun.jna.NativeLibrary;
import com.sun.jna.StringArray;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.factory.discovery.strategy.LinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.OsxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.WindowsNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.support.version.LibVlcVersion;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class NativeDiscovery {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private static boolean a;
    private NativeDiscoveryStrategy a;
    private String a;
    private static final NativeDiscoveryStrategy[] a;
    private final NativeDiscoveryStrategy[] b;

    public NativeDiscovery(NativeDiscoveryStrategy ... nativeDiscoveryStrategyArray) {
        this.b = nativeDiscoveryStrategyArray.length > 0 ? nativeDiscoveryStrategyArray : a;
    }

    public final boolean discover() {
        if (a) {
            return true;
        }
        for (NativeDiscoveryStrategy nativeDiscoveryStrategy : this.b) {
            String string;
            if (!nativeDiscoveryStrategy.supported() || (string = nativeDiscoveryStrategy.discover()) == null) continue;
            if (nativeDiscoveryStrategy.onFound(string)) {
                NativeLibrary.addSearchPath(RuntimeUtil.getLibVlcLibraryName(), string);
            }
            this.a(string, nativeDiscoveryStrategy);
            if (this.a()) {
                this.a = nativeDiscoveryStrategy;
                this.a = string;
                this.onFound(string, nativeDiscoveryStrategy);
                a = true;
                return true;
            }
            this.onFailed(string, nativeDiscoveryStrategy);
            return false;
        }
        this.onNotFound();
        return false;
    }

    public final NativeDiscoveryStrategy successfulStrategy() {
        return this.a;
    }

    public final String discoveredPath() {
        return this.a;
    }

    private void a(String string, NativeDiscoveryStrategy nativeDiscoveryStrategy) {
        String string2 = System.getenv(PLUGIN_ENV_NAME);
        if (string2 == null || string2.length() == 0) {
            nativeDiscoveryStrategy.onSetPluginPath(string);
        }
    }

    private boolean a() {
        try {
            libvlc_instance_t libvlc_instance_t2 = LibVlc.libvlc_new(0, new StringArray(new String[0]));
            if (libvlc_instance_t2 != null) {
                LibVlc.libvlc_release(libvlc_instance_t2);
                LibVlcVersion libVlcVersion = new LibVlcVersion();
                if (libVlcVersion.isSupported()) {
                    return true;
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError.getMessage());
        }
        return false;
    }

    protected void onFound(String string, NativeDiscoveryStrategy nativeDiscoveryStrategy) {
    }

    protected void onFailed(String string, NativeDiscoveryStrategy nativeDiscoveryStrategy) {
    }

    protected void onNotFound() {
    }

    static {
        a = new NativeDiscoveryStrategy[]{new LinuxNativeDiscoveryStrategy(), new OsxNativeDiscoveryStrategy(), new WindowsNativeDiscoveryStrategy()};
    }
}

