/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import java.io.IOException;
import ru.woesss.micro3d.PlatformHelper;

public class ActionTable {
    int nPointer;

    public ActionTable(byte[] b) {
        if (b == null) {
            throw new NullPointerException();
        }
        this.nPointer = this.nInit(b);
        if (this.nPointer == 0) {
            throw new RuntimeException();
        }
    }

    public ActionTable(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        byte[] b = PlatformHelper.getResourceBytes((String)name);
        if (b == null) {
            throw new IOException("Resource \"" + name + "\" not found");
        }
        this.nPointer = this.nInit(b);
        if (this.nPointer == 0) {
            throw new RuntimeException();
        }
    }

    public final int getNumAction() {
        return this.getNumActions();
    }

    public final int getNumActions() {
        if (this.nPointer == 0) {
            throw new RuntimeException("already disposed");
        }
        return this.nGetNumActions();
    }

    public final int getNumFrame(int idx) {
        return this.getNumFrames(idx);
    }

    public final int getNumFrames(int idx) {
        if (this.nPointer == 0) {
            throw new RuntimeException("already disposed");
        }
        if (idx < 0 || idx >= this.nGetNumActions()) {
            throw new IllegalArgumentException();
        }
        return this.nGetNumFrames(idx);
    }

    public final void dispose() {
        if (this.nPointer != 0) {
            this.nFinalize();
            this.nPointer = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private native int nInit(byte[] var1);

    private native int nGetNumActions();

    private native int nGetNumFrames(int var1);

    private native void nFinalize();

    private static native void nInitClass();

    static {
        System.loadLibrary("java_micro3d_v3_32");
        ActionTable.nInitClass();
    }
}

