/*
 * Decompiled with CFR 0.152.
 */
package ru.nnproject.kemulator.windowapi;

import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.ImageAWT;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public final class SecondaryWindow {
    JFrame frame = new JFrame();
    CanvasImpl awtCanvas;
    javax.microedition.lcdui.Canvas listener;
    private ImageAWT screenBuffer;

    private SecondaryWindow(String string, int n, int n2) {
        this.frame.setTitle(string);
        this.awtCanvas = new CanvasImpl();
        this.awtCanvas.addKeyListener(this.awtCanvas);
        this.awtCanvas.addMouseListener(this.awtCanvas);
        this.awtCanvas.addComponentListener(this.awtCanvas);
        this.awtCanvas.addMouseMotionListener(this.awtCanvas);
        this.frame.add(this.awtCanvas);
        this.frame.setBounds(100, 100, n, n2);
    }

    public static SecondaryWindow create(String string, int n, int n2) {
        return new SecondaryWindow(string, n, n2);
    }

    public int getWidth() {
        return this.awtCanvas.getWidth();
    }

    public int getHeight() {
        return this.awtCanvas.getHeight();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.frame.setBounds(n, n2, n3, n4);
    }

    public void setResizable(boolean bl) {
        this.frame.setResizable(bl);
    }

    public void setAlwaysOnTop(boolean bl) {
        this.frame.setAlwaysOnTop(bl);
    }

    public void setTitle(String string) {
        this.frame.setTitle(string);
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
        if (bl) {
            this.frame.repaint();
        }
    }

    public void repaint() {
        this.awtCanvas.repaint();
    }

    public void setListener(javax.microedition.lcdui.Canvas canvas) {
        this.listener = canvas;
        if (canvas != null) {
            canvas.setFullScreenMode(true);
            this.awtCanvas.repaint();
        }
    }

    private class CanvasImpl
    extends Canvas
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    ComponentListener {
        private CanvasImpl() {
        }

        public void paint(Graphics graphics) {
            if (SecondaryWindow.this.screenBuffer == null || SecondaryWindow.this.screenBuffer.getWidth() != this.getWidth() || SecondaryWindow.this.screenBuffer.getHeight() != this.getHeight()) {
                SecondaryWindow.this.screenBuffer = new ImageAWT(new BufferedImage(this.getWidth(), this.getHeight(), 1));
            }
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokePaint((IImage)SecondaryWindow.this.screenBuffer, null);
            }
            graphics.drawImage(SecondaryWindow.this.screenBuffer.getBufferedImage(), 0, 0, null);
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokeKeyPressed(keyEvent.getKeyCode());
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokeKeyReleased(keyEvent.getKeyCode());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokePointerPressed(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokePointerReleased(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokeSizeChanged(this.getWidth(), this.getHeight());
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokeSizeChanged(this.getWidth(), this.getHeight());
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokeShowNotify();
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokeHideNotify();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokePointerDragged(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

