/* agbtty.h
   a tty for the GBA

Copyright 2003 Damian Yerrick

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

*/


#ifndef AGBTTY_H
#define AGBTTY_H

#include <sys/types.h>
#include <stdlib.h>

extern unsigned int agbtty_cur_scrollback;

int agbtty_init(void);
int agbtty_init_cursor(void);
int agbtty_show_cursor(int shown);
int agbtty_set_map(size_t nt);
int agbtty_putc(int c);
ssize_t agbtty_write(const void *buf, size_t size);
int agbtty_puts(const char *buf);
int agbtty_gotoxy(unsigned int x, unsigned int y);
unsigned int agbtty_textattr(unsigned int attr);
int agbtty_scrollback(size_t n_lines);


#endif
