/* bongo.c
   Test DK Bongos on Game Boy Player

Copyright 2004 Damian Yerrick

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

*/

#include "pin8gba.h"
#include "agbtty.h"


void wait4vbl(void)
{
#if 1
  asm volatile("mov r2, #0; swi 0x05" ::: "r0", "r1", "r2", "r3");
#else
  while(LCD_Y != 159);
#endif
  while(LCD_Y != 160);

}

void isr(void);

void setup_isr(void)
{
  /* set the ISR */
  SET_MASTER_ISR(isr);
  /* turn on interrupt sources */
  LCDSTAT = LCDSTAT_VBLIRQ;  /* vbl interrupt */
  /* turn on interrupt controller */
  INTMASK = INT_VBLANK;
  INTENABLE = 1;
}

void dump_joy(unsigned int down)
{
  static const unsigned char x[10] = {8,6,3,5,2,0,1,1,9,0};
  static const unsigned char y[10] = {1,2,3,3,2,2,1,3,0,0};
  static const unsigned char c[10] = "ABSRRLUDRL";
  unsigned int i;

  for(i = 0; i < 10; i++, down >>= 1)
  {
    agbtty_gotoxy(x[i] + 18, y[i] + 15 );
    agbtty_putc(down & 1 ? c[i] : ' ');
  }
}


const char bongos_pic[] =
"    DK Bongos     Controller\n"
"   ,-.     ,-.\n"
"  /   \\---/   \\\n"
" (-___-) (-___-)\n"
" :\\   /+-+\\   /:\n"
" : `-' : : `-' :\n"
" :\\   /: :\\   /:"
;

int main(void)
{
  unsigned int last_joy = 0x3ff;

  agbtty_init();
  LCDMODE = 0 | LCDMODE_BG0;
  PALRAM[0] = RGB( 8, 8, 8);
  PALRAM[1] = RGB(31,31,31);
  agbtty_puts("\n"
              "Controller & DK Bongos Test\n"
              " 2004 Damian Yerrick\n\n"
              "For DK Bongos, set the Game\n"
              "Boy Player's control type to\n"
              "where X and Y press L and R.\n"
              "The clap sensor isn't very\n"
              "sensitive; you'll need to\n"
              "hit the drum on the side.");
  agbtty_gotoxy(0, 13);
  agbtty_puts(bongos_pic);
  setup_isr();
  while(1)
  {
    int j, jnew;

    wait4vbl();

    j = JOY ^ 0x3ff;
    jnew = j & ~last_joy;
    last_joy = j;

    dump_joy(j);

    agbtty_gotoxy(4, 15);
    agbtty_putc(JOY_L & j ? 'O' : ' ');
    agbtty_gotoxy(12, 15);
    agbtty_putc(JOY_R & j ? 'O' : ' ');
    agbtty_gotoxy(4, 17);
    agbtty_putc(JOY_B & j ? 'O' : ' ');
    agbtty_gotoxy(12, 17);
    agbtty_putc(JOY_A & j ? 'O' : ' ');
    agbtty_gotoxy(8, 16);
    agbtty_putc(JOY_SELECT & j ? 'X' : ' ');
    agbtty_gotoxy(8, 18);
    agbtty_putc(JOY_START & j ? 'S' : ' ');
  }
}

