export default [
    {
        "title": "Home",
        "fileName": "index.html",
        "text": "Home Welcome to Duplicate Records Handler!"
    },
    {
        "title": "DuplicateRecordHandlersTest",
        "fileName": "DuplicateRecordHandlersTest.html",
        "text": "DuplicateRecordHandlersTest Tests for DuplicateRecord trigger handlers Signature @isTest private class DuplicateRecordHandlersTest See DuplicateRecordItemTriggerHandler , DuplicateRecordSetTriggerHandler Author David Schach Since 11/13/2019 Initial Version 02/28/2022 PMD-identified cleanup DuplicateRecordHandlersTest Methods dupeAccountsCreate() dupeAccountsMerge() dupeAccountsUpdate() dupeContactsCreate() dupeContactsMerge() dupeLeadsCreate() dupeLeadsMerge() dupeLeadsMergeFuture() futureMergeLeads(lId) We have a future method to allow us to run our trigger handler in future context makeData() setupAccounts(acctCount) setupContact(acctId) setupContacts(accts) setupLead() dupeAccountsCreate() Signature @isTest private static void dupeAccountsCreate() dupeAccountsMerge() Signature @isTest private static void dupeAccountsMerge() dupeAccountsUpdate() Signature @isTest private static void dupeAccountsUpdate() dupeContactsCreate() Signature @isTest private static void dupeContactsCreate() dupeContactsMerge() Signature @isTest private static void dupeContactsMerge() dupeLeadsCreate() Signature @isTest private static void dupeLeadsCreate() dupeLeadsMerge() Signature @isTest private static void dupeLeadsMerge() dupeLeadsMergeFuture() Signature @isTest private static void dupeLeadsMergeFuture() futureMergeLeads(lId) We have a future method to allow us to run our trigger handler in future context Signature @future private static void futureMergeLeads(Id lId) Parameters lId Type: Id Lead Id to keep when merging leads in test class makeData() Signature @TestSetup static void makeData() setupAccounts(acctCount) Signature static List<Account> setupAccounts(Integer acctCount) setupContact(acctId) Signature static Contact setupContact(Id acctId) setupContacts(accts) Signature static List<Contact> setupContacts(List<Account> accts) setupLead() Signature static Lead setupLead()"
    },
    {
        "title": "DuplicateRecordItemTriggerHandler",
        "fileName": "DuplicateRecordItemTriggerHandler.html",
        "text": "DuplicateRecordItemTriggerHandler Trigger Handler for DuplicateRecordItem Signature public inherited sharing class DuplicateRecordItemTriggerHandler See DuplicateRecordHandlersTest Author David Schach Since 04/19/2021     Initial Version 02/28/2022     Static to instance trigger handler methods DuplicateRecordItemTriggerHandler Methods assortDuplicateItems(newRecords) Assign object type and then handle all records handleAccounts(newAccounts, recordIDs) Handle Accounts(may be duplicated for any object) handleContacts(newContacts, recordIDs) Handle Contacts(may be duplicated for any object) handleLeads(newLeads, recordIDs) Handle Leads(may be duplicated for any object) handleTrigger(newRecords, oldRecords, newRecordsMap, oldRecordsMap, triggerEvent) Handle all trigger records updateDuplicateRecordSet(newRecords) Update the parent DuplicateRecordItem  records assortDuplicateItems(newRecords) Assign object type and then handle all records Signature private void assortDuplicateItems(List<DuplicateRecordItem> newRecords) Parameters newRecords Type: List<DuplicateRecordItem> Trigger.new Author David Schach handleAccounts(newAccounts, recordIDs) Handle Accounts(may be duplicated for any object) Signature private void handleAccounts(List<DuplicateRecordItem> newAccounts, Set<Id> recordIDs) Parameters newAccounts Type: List<DuplicateRecordItem> Trigger.new recordIDs Type: Set<Id> AccountIDs, which are technically in newAccounts, but included for simplicity Author David Schach handleContacts(newContacts, recordIDs) Handle Contacts(may be duplicated for any object) Signature private void handleContacts(List<DuplicateRecordItem> newContacts, Set<Id> recordIDs) Parameters newContacts Type: List<DuplicateRecordItem> Trigger.new recordIDs Type: Set<Id> ContactIDs, which are technically in newContacts, but included for simplicity Author David Schach handleLeads(newLeads, recordIDs) Handle Leads(may be duplicated for any object) Signature private void handleLeads(List<DuplicateRecordItem> newLeads, Set<Id> recordIDs) Parameters newLeads Type: List<DuplicateRecordItem> Trigger.new recordIDs Type: Set<Id> LeadIDs, which are technically in newLeads, but included for simplicity Author David Schach handleTrigger(newRecords, oldRecords, newRecordsMap, oldRecordsMap, triggerEvent) Handle all trigger records Signature public void handleTrigger(\t\tList<DuplicateRecordItem> newRecords,\t\tList<DuplicateRecordItem> oldRecords,\t\tMap<Id, DuplicateRecordItem> newRecordsMap,\t\tMap<Id, DuplicateRecordItem> oldRecordsMap,\t\tSystem.TriggerOperation triggerEvent\t) Parameters newRecords Type: \t\tList<DuplicateRecordItem> Trigger.new oldRecords    Trigger.old newRecordsMap Type: DuplicateRecordItem> Trigger.newMap oldRecordsMap Type: DuplicateRecordItem> Trigger.oldMap triggerEvent  Trigger context enum Author David Schach updateDuplicateRecordSet(newRecords) Update the parent DuplicateRecordItem  records Signature private void updateDuplicateRecordSet(List<DuplicateRecordItem> newRecords) Parameters newRecords Type: List<DuplicateRecordItem> Trigger.new Author David Schach"
    },
    {
        "title": "DuplicateRecordSetTriggerHandler",
        "fileName": "DuplicateRecordSetTriggerHandler.html",
        "text": "DuplicateRecordSetTriggerHandler Trigger Handler for DuplicateRecordSet Signature public inherited sharing class DuplicateRecordSetTriggerHandler See DuplicateRecordHandlersTest Author David Schach Since 04/19/2021 Initial Version 04/19/2021 Moved deletion of sets to the Item trigger handler for more control and to delete 0 record count sets 02/28/2022 Static to instance trigger handler methods 09/14/2022 Salesforce may be auto-deleting single-record sets, so setting allOrNothing to false DuplicateRecordSetTriggerHandler Methods deleteSingleRecordSetsFuture(candidatesToDelete) Future delete DuplicateRecordSet  records with only 1 DuplicateRecordItem deleteUnnecessaryRecordSets(candidatesToDelete) Declare deletion in a synchronous method so it can be called from either the main handler class or an asychronous method.(DRY) findSingleRecordSets(newRecords, oldRecordsMap) Query for all single-item DuplicateRecordSet  records First we exclude DRS records where the DRI count was and is zero. This allows us to instantiate the record. We don't know why DRS records are also updated when they are created, but that's the situation. Then we delete DRS records where RecordCount < 2(0 or 1) and can do so because we allowed the creation of the DRS. handleTrigger(newRecords, oldRecords, newRecordsMap, oldRecordsMap, triggerEvent) Handle all trigger records deleteSingleRecordSetsFuture(candidatesToDelete) Future delete DuplicateRecordSet  records with only 1 DuplicateRecordItem Signature @future public static void deleteSingleRecordSetsFuture(Set<Id> candidatesToDelete) Parameters candidatesToDelete Type: Set<Id> Queried DuplicateRecordSet  records with 1 DuplicateRecordItem Author David Schach deleteUnnecessaryRecordSets(candidatesToDelete) Declare deletion in a synchronous method so it can be called from either the main handler class or an asychronous method.(DRY) Signature private static void deleteUnnecessaryRecordSets(Set<Id> candidatesToDelete) Parameters candidatesToDelete Type: Set<Id> DuplicateRecordSet  IDs to delete findSingleRecordSets(newRecords, oldRecordsMap) Query for all single-item DuplicateRecordSet  records First we exclude DRS records where the DRI count was and is zero. This allows us to instantiate the record. We don't know why DRS records are also updated when they are created, but that's the situation. Then we delete DRS records where RecordCount < 2(0 or 1) and can do so because we allowed the creation of the DRS. Signature public void findSingleRecordSets(List<DuplicateRecordSet> newRecords, Map<Id, DuplicateRecordSet> oldRecordsMap) Parameters newRecords Type: List<DuplicateRecordSet> Trigger.new oldRecordsMap Type: Map<Id, DuplicateRecordSet> Trigger.oldMap Author David Schach handleTrigger(newRecords, oldRecords, newRecordsMap, oldRecordsMap, triggerEvent) Handle all trigger records Signature public void handleTrigger(\t\tList<DuplicateRecordSet> newRecords,\t\tList<DuplicateRecordSet> oldRecords,\t\tMap<Id, DuplicateRecordSet> newRecordsMap,\t\tMap<Id, DuplicateRecordSet> oldRecordsMap,\t\tSystem.TriggerOperation triggerEvent\t) Parameters newRecords Type: \t\tList<DuplicateRecordSet> Trigger.new oldRecords    Trigger.old newRecordsMap Type: DuplicateRecordSet> Trigger.newMap oldRecordsMap Type: DuplicateRecordSet> Trigger.oldMap triggerEvent  Trigger context enum Author David Schach"
    }
];
