/*
 * Decompiled with CFR 0.152.
 */
package com.cypress.clocksolver;

import com.cypress.clocksolver.ExitCode;
import java.util.Map;

public class PllSolver {
    public static final String ID = "PLL";
    private static final int ARG_IDX_SRC_FREQ = 1;
    private static final int ARG_IDX_TARGET_FREQ = 2;
    private static final int ARG_IDX_LF_MODE = 3;
    private static final int ARG_IDX_MIN_POWER = 4;
    private static final String FEEDBACK_DIV_KEY = "feedbackDiv";
    private static final String REFERENCE_DIV_KEY = "referenceDiv";
    private static final String OUTPUT_DIV_KEY = "outputDiv";
    private static final int MIN_IN_FREQ = 4;
    private static final int MAX_IN_FREQ = 64;
    private static final int PFD_MIN = 4;
    private static final int PFD_MAX = 8;
    private static final int OUT_MIN = 2;
    private static final int OUT_MAX = 16;
    private static final int REF_MIN = 1;
    private static final int REF_MAX = 18;
    private static final int FB_MAX_LF = 56;
    private static final int FB_MIN = 22;
    private static final int FB_MAX_NORM = 112;
    private static final int VCO_MIN_LF = 170;
    private static final int VCO_MAX_LF = 200;
    private static final int VCO_MIN_NORM = 200;
    private static final int VCO_MAX_NORM = 400;
    private static final double DOUBLE_COMPARE_EPSILON = 1.0E-5;

    public static ExitCode solve(String[] args, Map<String, String> computedValues) {
        ExitCode retVal;
        if (args.length != 5) {
            System.err.println("PLL Solver requires 4 arguments:");
            System.err.println("\tdouble srcFreqMHz - Source clock frequency for the PLL in MHz.");
            System.err.println("\tdouble targetFreqMHz - Output frequency of the PLL in MHz.");
            System.err.println("\tboolean lfMode - CLK_PLL_CONFIG register, PLL_LF_MODE bit.");
            System.err.println("\tboolean minPower - Optimize for min power rather min jitter.");
            retVal = ExitCode.ERROR_ARG_COUNT;
        } else {
            try {
                double srcFreqMHz = Double.parseDouble(args[1]);
                double targetFreqMHz = Double.parseDouble(args[2]);
                boolean lfMode = Boolean.parseBoolean(args[3]);
                boolean minPower = Boolean.parseBoolean(args[4]);
                if (srcFreqMHz < 4.0 || 64.0 < srcFreqMHz) {
                    System.err.println(String.format("Invalid PLL input frequency '%1$f'. Must be within the rage %2$d-%3$d.", srcFreqMHz, 4, 64));
                    retVal = ExitCode.ERROR_ARG_VALUE;
                } else {
                    retVal = PllSolver.solve(srcFreqMHz, targetFreqMHz, lfMode, minPower, computedValues);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Unable to parse argument values: " + e.getMessage());
                retVal = ExitCode.ERROR_ARG_VALUE;
            }
        }
        return retVal;
    }

    public static ExitCode solve(double srcFreqMHz, double targetFreqMHz, boolean lfMode, boolean minPower, Map<String, String> computedValues) {
        ExitCode exitCode;
        int divFb = 22;
        int divRef = 1;
        int divOut = 2;
        double freqRatio = srcFreqMHz / targetFreqMHz;
        double leastErrorFound = Double.MAX_VALUE;
        int fbMax = lfMode ? 56 : 112;
        for (int p = 22; p <= fbMax; ++p) {
            for (int q = 1; q <= 18; ++q) {
                double pfdRefFreq = srcFreqMHz / (double)q;
                double vcoFreq = pfdRefFreq * (double)p;
                if (!PllSolver.IsPfdRefInRange(pfdRefFreq) || !PllSolver.IsVcoInRange(vcoFreq, lfMode)) continue;
                for (int o = 2; o <= 16; ++o) {
                    double error = Math.abs(1.0 - freqRatio * (double)p / (double)(q * o));
                    if (!(error < leastErrorFound) && (!PllSolver.doubleEquals(error, leastErrorFound) || divOut > o != minPower)) continue;
                    leastErrorFound = error;
                    divFb = p;
                    divRef = q;
                    divOut = o;
                }
            }
        }
        if (leastErrorFound == Double.MAX_VALUE) {
            exitCode = ExitCode.ERROR_ID;
        } else {
            computedValues.put(FEEDBACK_DIV_KEY, Integer.toString(divFb));
            computedValues.put(REFERENCE_DIV_KEY, Integer.toString(divRef));
            computedValues.put(OUTPUT_DIV_KEY, Integer.toString(divOut));
            exitCode = ExitCode.SUCCESS;
        }
        return exitCode;
    }

    private static boolean IsVcoInRange(double vcoFreq, boolean lfMode) {
        return lfMode ? 170.0 <= vcoFreq && vcoFreq <= 200.0 : 200.0 <= vcoFreq && vcoFreq <= 400.0;
    }

    private static boolean IsPfdRefInRange(double pfdRefFrequency) {
        return 4.0 <= pfdRefFrequency && pfdRefFrequency <= 8.0;
    }

    private static boolean doubleEquals(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }
}

