/*
 * Decompiled with CFR 0.152.
 */
package com.cypress.i2c_solver;

import com.cypress.i2c_solver.ExitCode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class i2c_solver {
    private static final String ID_SLAVE = "Slave";
    private static final String ID_MASTER = "Master";
    private static final int ARG_IDX_DATA_RATE_HZ = 1;
    private static final int ARG_IDX_SCB_CLK_HZ = 2;
    private static final String LOW_OVERSAMPLE = "lowOversample";
    private static final String HIGH_OVERSAMPLE = "highOversample";
    private static final String DIGITAL_FILTER = "digitalFilter";
    private static final int DIV_MHZ = 1000000;
    private static final int DIV_KHZ = 1000;
    private static final int I2C_DATA_RATE_STD = 100000;
    private static final int I2C_DATA_RATE_FST = 400000;
    private static final int I2C_DATA_RATE_FSTP = 1000000;
    private static final double I2C_MASTER_STD_CLK_MIN_MHZ = 1.55;
    private static final double I2C_MASTER_STD_CLK_MAX_MHZ = 3.2;
    private static final int I2C_MASTER_STD_CLK_MIN_HZ = 1550000;
    private static final int I2C_MASTER_STD_CLK_MAX_HZ = 3200000;
    private static final int I2C_MASTER_STD_SCL_LOW = 5000;
    private static final int I2C_MASTER_STD_SCL_HIGH = 5000;
    private static final double I2C_MASTER_FST_CLK_MIN_MHZ = 7.82;
    private static final double I2C_MASTER_FST_CLK_MAX_MHZ = 10.0;
    private static final int I2C_MASTER_FST_CLK_MIN_HZ = 7820000;
    private static final int I2C_MASTER_FST_CLK_MAX_HZ = 10000000;
    private static final int I2C_MASTER_FST_SCL_LOW = 1600;
    private static final int I2C_MASTER_FST_SCL_HIGH = 900;
    private static final double I2C_MASTER_FSTP_CLK_MIN_MHZ = 14.32;
    private static final double I2C_MASTER_FSTP_CLK_MAX_MHZ = 25.8;
    private static final int I2C_MASTER_FSTP_CLK_MIN_HZ = 14320000;
    private static final int I2C_MASTER_FSTP_CLK_MAX_HZ = 25800000;
    private static final int I2C_MASTER_FSTP_SCL_LOW = 620;
    private static final int I2C_MASTER_FSTP_SCL_HIGH = 380;
    private static final int I2C_LOW_PHASE_MAX = 16;
    private static final int I2C_HIGH_PHASE_MAX = 16;
    private static final int I2C_DUTY_CYCLE_MAX = 32;

    public static void main(String[] args) {
        ExitCode returnCode = i2c_solver.Execute(args);
        System.exit(returnCode.Value);
    }

    /*
     * WARNING - void declaration
     */
    public static ExitCode Execute(String[] args) {
        ExitCode returnCode;
        if (args.length != 3) {
            System.err.println("I2C data rate solver requires 3 arguments:");
            System.err.println("\tstring id - Master or Slave.");
            System.err.println("\tinteger dataRateHz - Desired I2C data rate in Hz.");
            System.err.println("\tinteger scbClockHz - SCB source clock frequency in Hz.");
            System.err.println("");
            returnCode = ExitCode.ERROR_ARG_COUNT;
        } else {
            void var5_8;
            String id = args[0];
            ConcurrentHashMap<String, String> computedValues = new ConcurrentHashMap<String, String>();
            String string = id;
            int n = -1;
            switch (string.hashCode()) {
                case 79966647: {
                    if (!string.equals(ID_SLAVE)) break;
                    boolean bl = false;
                    break;
                }
                case -1997400446: {
                    if (!string.equals(ID_MASTER)) break;
                    boolean bl = true;
                }
            }
            switch (var5_8) {
                case 0: {
                    returnCode = i2c_solver.SlaveSetDataRate(computedValues);
                    break;
                }
                case 1: {
                    try {
                        int dataRateHz = Integer.parseInt(args[1]);
                        int scbClockHz = Integer.parseInt(args[2]);
                        returnCode = i2c_solver.MasterSetDataRate(dataRateHz, scbClockHz, computedValues);
                        if (ExitCode.SUCCESS == returnCode) break;
                        for (Map.Entry param : computedValues.entrySet()) {
                            System.out.println(String.format("param:%1$s=%2$s", param.getKey(), param.getValue()));
                        }
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Unable to parse argument values: " + e.getMessage());
                        returnCode = ExitCode.ERROR_ARG_VALUE;
                        break;
                    }
                }
                default: {
                    System.err.println(String.format("Unhandled solver: %1$s", id));
                    returnCode = ExitCode.ERROR_ID;
                }
            }
            if (ExitCode.SUCCESS == returnCode) {
                for (Map.Entry entry : computedValues.entrySet()) {
                    System.out.println(String.format("param:%1$s=%2$s", entry.getKey(), entry.getValue()));
                }
            }
        }
        return returnCode;
    }

    public static ExitCode MasterSetDataRate(int dataRateHz, int scbClockHz, Map<String, String> computedValues) {
        ExitCode exitCode;
        int sclLow = 0;
        int sclHigh = 0;
        int lowPhase = 0;
        int highPhase = 0;
        boolean enableMedian = false;
        if (dataRateHz == 0) {
            exitCode = ExitCode.ERROR_DATA_RATE_RANGE;
        } else if (dataRateHz <= 100000) {
            if (scbClockHz >= 1550000 && scbClockHz <= 3200000) {
                sclLow = 5000;
                sclHigh = 5000;
                enableMedian = false;
                exitCode = ExitCode.SUCCESS;
            } else {
                exitCode = ExitCode.ERROR_I2C_FREQ_RANGE;
            }
        } else if (dataRateHz <= 400000) {
            if (scbClockHz >= 7820000 && scbClockHz <= 10000000) {
                sclLow = 1600;
                sclHigh = 900;
                enableMedian = false;
                exitCode = ExitCode.SUCCESS;
            } else {
                exitCode = ExitCode.ERROR_I2C_FREQ_RANGE;
            }
        } else if (dataRateHz <= 1000000) {
            if (scbClockHz >= 14320000 && scbClockHz <= 25800000) {
                sclLow = 620;
                sclHigh = 380;
                enableMedian = true;
                exitCode = ExitCode.SUCCESS;
            } else {
                exitCode = ExitCode.ERROR_I2C_FREQ_RANGE;
            }
        } else {
            exitCode = ExitCode.ERROR_DATA_RATE_RANGE;
        }
        if (exitCode == ExitCode.SUCCESS) {
            int period = 1000000000 / scbClockHz;
            lowPhase = sclLow / period;
            if (period * lowPhase < sclLow) {
                ++lowPhase;
            }
            if (lowPhase > 16) {
                lowPhase = 16;
            }
            boolean updateLowPhase = lowPhase < 16;
            highPhase = sclHigh / period;
            if (period * highPhase < sclHigh) {
                ++highPhase;
            }
            if (highPhase > 16) {
                highPhase = 16;
            }
            int actualDataRateHz = scbClockHz / (lowPhase + highPhase);
            while (actualDataRateHz > dataRateHz && lowPhase + highPhase < 32) {
                if (updateLowPhase) {
                    if (lowPhase < 16) {
                        ++lowPhase;
                        updateLowPhase = false;
                    }
                } else if (highPhase < 16) {
                    ++highPhase;
                    updateLowPhase = lowPhase < 16;
                }
                actualDataRateHz = scbClockHz / (lowPhase + highPhase);
            }
        }
        computedValues.put(LOW_OVERSAMPLE, Integer.toString(lowPhase));
        computedValues.put(HIGH_OVERSAMPLE, Integer.toString(highPhase));
        computedValues.put(DIGITAL_FILTER, Boolean.toString(enableMedian));
        return exitCode;
    }

    public static ExitCode SlaveSetDataRate(Map<String, String> computedValues) {
        computedValues.put(LOW_OVERSAMPLE, Integer.toString(0));
        computedValues.put(HIGH_OVERSAMPLE, Integer.toString(0));
        computedValues.put(DIGITAL_FILTER, Boolean.toString(false));
        return ExitCode.SUCCESS;
    }
}

