/*
 * Decompiled with CFR 0.152.
 */
package com.cypress.sar_scheduler;

import com.cypress.sar_scheduler.CySchedChan;
import com.cypress.sar_scheduler.CySchedule;
import com.cypress.sar_scheduler.CyTimingComparator;
import com.cypress.sar_scheduler.CyTimingInfo;
import com.cypress.sar_scheduler.ExitCode;
import com.cypress.sar_scheduler.SampleTime;
import com.cypress.sar_scheduler.SamplesAveraged;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Scheduler {
    private static final int ARG_IDX_HF_CLK_RATE = 0;
    private static final int ARG_IDX_IS_FIXED_CLOCK = 1;
    private static final int ARG_IDX_CLK_RATE = 2;
    private static final int ARG_IDX_MIN_CLK_RATE = 3;
    private static final int ARG_IDX_MAX_CLK_RATE = 4;
    private static final int ARG_IDX_IS_SINGLE_SHOT = 5;
    private static final int ARG_IDX_SAMPLE_RATE = 6;
    private static final int ARG_IDX_NUM_CHANNELS = 7;
    private static final int ARG_IDX_CHANNEL_INFO = 8;
    private static final int NUM_ARGS_PER_CHANNEL = 2;
    public static final int ADC_CLOCKS_NOT_SAMPLING = 1;
    public static final int APERTURE_TIMER_COUNT = 4;
    public static final int APERTURE_TIMER_MIN = 2;
    public static final int APERTURE_TIMER_MAX = 1023;
    public static final long ADC_CLOCK_MAX_HZ = 60000000L;
    public static final long ADC_CLOCK_MIN_HZ = 1000000L;
    public static final int MIN_ADC_CLOCK_DIV = 2;
    public static final int MAX_NUM_CHANNELS = 16;
    private static double hfClockRate;
    private static boolean isFixedClock;
    private static double fixedAdcClockRate;
    private static double minClockRate;
    private static double maxClockRate;
    private static boolean isSingleShot;
    private static double targetSampleRate;
    private static int numChannels;
    private static List<CySchedChan> channels;
    private static CySchedule solution;
    private static double adcClockDivider;

    public static void main(String[] args) {
        ExitCode returnCode = Scheduler.Execute(args);
        System.exit(returnCode.Value);
    }

    public static ExitCode Execute(String[] args) {
        ExitCode returnCode;
        if (args.length < 3) {
            System.err.println("");
            returnCode = ExitCode.ERROR_ARG_COUNT;
        } else {
            hfClockRate = Double.parseDouble(args[0]);
            isFixedClock = Boolean.parseBoolean(args[1]);
            fixedAdcClockRate = Double.parseDouble(args[2]);
            minClockRate = Double.parseDouble(args[3]);
            maxClockRate = Double.parseDouble(args[4]);
            isSingleShot = Boolean.parseBoolean(args[5]);
            targetSampleRate = Double.parseDouble(args[6]);
            numChannels = Integer.parseInt(args[7]);
            for (int i = 0; i < numChannels; ++i) {
                double minAcqTimeNs = Double.parseDouble(args[8 + i * 2]);
                int samplesPerScan = Scheduler.GetSamplesPerScan(args[8 + i * 2 + 1]);
                CySchedChan chan = new CySchedChan(minAcqTimeNs, samplesPerScan);
                channels.add(chan);
            }
            boolean isScheduleOK = Scheduler.Run();
            if (!isScheduleOK) {
                returnCode = ExitCode.ERROR_FAIL_SCHEDULING;
            } else {
                Scheduler.WriteOutput();
                returnCode = ExitCode.SUCCESS;
            }
        }
        return returnCode;
    }

    public static int GetSamplesPerScan(String arg) {
        int samplesPerScan;
        try {
            samplesPerScan = SamplesAveraged.valueOf((String)arg).Value;
        }
        catch (IllegalArgumentException e) {
            samplesPerScan = Integer.parseInt(arg);
        }
        return samplesPerScan;
    }

    public static void WriteOutput() {
        System.out.println(String.format("param:achieved_sample_rate=%s", Scheduler.solution.AchievedSampleRate));
        System.out.println(String.format("param:achieved_sample_period=%.2f us", Scheduler.solution.AchievedScanPeriod_Us));
        System.out.println(String.format("param:adc_clock_divider=%s", adcClockDivider));
        for (int chanNum = 0; chanNum < 16; ++chanNum) {
            String ch_sample_time_sel;
            double ch_achieved_sample_time;
            double ch_achieved_acq_time;
            if (chanNum < Scheduler.solution.Channels.size()) {
                CySchedChan chan = Scheduler.solution.Channels.get(chanNum);
                ch_achieved_acq_time = chan.achievedAcqTimeNs;
                ch_achieved_sample_time = chan.achievedSampleTimeNs;
                ch_sample_time_sel = SampleTime.values()[chan.Timer].name();
            } else {
                ch_achieved_acq_time = 0.0;
                ch_achieved_sample_time = 0.0;
                ch_sample_time_sel = "";
            }
            System.out.println(String.format("param:ch%s_achieved_acq_time=%s ns", chanNum, (int)ch_achieved_acq_time));
            System.out.println(String.format("param:ch%s_achieved_sample_time=%s ns", chanNum, (int)ch_achieved_sample_time));
            System.out.println(String.format("param:ch%s_sample_time_sel=%s", chanNum, ch_sample_time_sel));
        }
        for (int sampleTime = 0; sampleTime < Scheduler.solution.Apertures_AdcClock.size(); ++sampleTime) {
            int aperture = Scheduler.solution.Apertures_AdcClock.get(sampleTime);
            if (aperture == 0) {
                aperture = 2;
            }
            System.out.println(String.format("param:sample_time_%s=%s", sampleTime, aperture));
        }
    }

    public static boolean Run() {
        int ScanPeriod_AdcClock;
        boolean isScheduleOK = true;
        double adcClockRate = fixedAdcClockRate;
        if (!isFixedClock) {
            adcClockDivider = Scheduler.SelectAdcClockDivider();
            adcClockRate = hfClockRate / adcClockDivider;
        }
        if ((ScanPeriod_AdcClock = Scheduler.FindMappedScanAdcClocks(solution = isSingleShot ? Scheduler.ScheduleAdcOneShot(adcClockRate) : Scheduler.ScheduleAdcOnlyWithFixedAdcClock(adcClockRate))) > 0) {
            Scheduler.solution.AchievedSampleRate = Math.round(adcClockRate / (double)ScanPeriod_AdcClock);
            Scheduler.solution.AchievedScanPeriod_Us = 1000000.0 / (double)Scheduler.solution.AchievedSampleRate;
            for (int chanNum = 0; chanNum < Scheduler.solution.Channels.size(); ++chanNum) {
                double adcClocks = Scheduler.solution.Channels.get((int)chanNum).mappedAcqAdcClocks;
                double achievedAperture_Ns = Math.round(1.0E9 * (adcClocks -= 1.0) / adcClockRate);
                double achievedSampleTime_Ns = Math.round(1.0E9 * (double)Scheduler.solution.Channels.get((int)chanNum).mappedTotalAdcClocks / adcClockRate);
                Scheduler.solution.Channels.get((int)chanNum).achievedAcqTimeNs = achievedAperture_Ns;
                Scheduler.solution.Channels.get((int)chanNum).achievedSampleTimeNs = achievedSampleTime_Ns;
            }
        } else {
            isScheduleOK = false;
            Scheduler.solution.AchievedSampleRate = 0L;
            Scheduler.solution.AchievedScanPeriod_Us = 0.0;
            for (int chanNum = 0; chanNum < Scheduler.solution.Channels.size(); ++chanNum) {
                Scheduler.solution.Channels.get((int)chanNum).achievedAcqTimeNs = 0.0;
            }
        }
        return isScheduleOK;
    }

    public static CySchedule ScheduleAdcOnlyWithFixedAdcClock(double adcClockRate) {
        CySchedule solution = new CySchedule(channels);
        Scheduler.FindMinScanAdcClocks(solution, adcClockRate);
        List<CyTimingInfo> chanTimesNoPad = Scheduler.GetChannelTimingInfo(solution);
        Collections.sort(chanTimesNoPad, new CyTimingComparator());
        ArrayList<Integer> apertureClocksNoPad = new ArrayList<Integer>(solution.Apertures_AdcClock);
        ArrayList<CyTimingInfo> chanTimesPad = new ArrayList<CyTimingInfo>(chanTimesNoPad);
        ArrayList<Integer> apertureClocksPad = new ArrayList<Integer>(apertureClocksNoPad);
        int padIndex = Scheduler.FindPaddingChannel(chanTimesPad);
        if (padIndex != 0) {
            CyTimingInfo padChan = (CyTimingInfo)chanTimesPad.get(padIndex);
            chanTimesPad.remove(padIndex);
            chanTimesPad.add(0, padChan);
        }
        Scheduler.OptimizeApertures(chanTimesNoPad, 0, chanTimesNoPad.size(), apertureClocksNoPad, 0, apertureClocksNoPad.size());
        solution.Apertures_AdcClock = apertureClocksNoPad;
        Scheduler.SetChannelTimers(solution, 0, solution.Apertures_AdcClock.size());
        int mappedMinScanAdcClocksNoPad = Scheduler.FindMappedScanAdcClocks(solution);
        Scheduler.OptimizeApertures(chanTimesPad, 1, chanTimesPad.size(), apertureClocksPad, 1, apertureClocksPad.size());
        apertureClocksPad.set(0, ((CyTimingInfo)chanTimesPad.get((int)0)).IdealSample_AdcClock);
        solution.Apertures_AdcClock = apertureClocksPad;
        Scheduler.SetChannelTimers(solution, 1, solution.Apertures_AdcClock.size());
        solution.Channels.get((int)((CyTimingInfo)chanTimesPad.get((int)0)).ChannelNum).Timer = 0;
        int mappedMinScanAdcClocksPad = Scheduler.FindMappedScanAdcClocks(solution);
        int targetScanAdcClocks = Scheduler.AdcClocks(targetSampleRate, adcClockRate);
        if (mappedMinScanAdcClocksPad <= targetScanAdcClocks) {
            int padAmount = targetScanAdcClocks - mappedMinScanAdcClocksPad;
            int samplesPerScan = solution.Channels.get((int)((CyTimingInfo)chanTimesPad.get((int)0)).ChannelNum).samplesPerScan;
            if (samplesPerScan > 1) {
                padAmount += samplesPerScan / 2;
                padAmount /= samplesPerScan;
            }
            solution.Apertures_AdcClock.set(0, solution.Apertures_AdcClock.get(0) + padAmount);
            solution.Apertures_AdcClock.set(0, Math.min(solution.Apertures_AdcClock.get(0), 1023));
        } else if (Math.abs(mappedMinScanAdcClocksNoPad - targetScanAdcClocks) < Math.abs(mappedMinScanAdcClocksPad - targetScanAdcClocks)) {
            solution.Apertures_AdcClock = apertureClocksNoPad;
            Scheduler.SetChannelTimers(solution, 0, solution.Apertures_AdcClock.size());
        }
        return solution;
    }

    public static CySchedule ScheduleAdcOneShot(double adcClkRate) {
        solution = new CySchedule(channels);
        Scheduler.FindMinScanAdcClocks(solution, adcClkRate);
        List<CyTimingInfo> chanTimesNoPad = Scheduler.GetChannelTimingInfo(solution);
        Collections.sort(chanTimesNoPad, new CyTimingComparator());
        ArrayList<Integer> apertureClocksNoPad = new ArrayList<Integer>(Scheduler.solution.Apertures_AdcClock);
        Scheduler.OptimizeApertures(chanTimesNoPad, 0, chanTimesNoPad.size(), apertureClocksNoPad, 0, apertureClocksNoPad.size());
        Scheduler.solution.Apertures_AdcClock = apertureClocksNoPad;
        Scheduler.SetChannelTimers(solution, 0, Scheduler.solution.Apertures_AdcClock.size());
        return solution;
    }

    private static int FindMinScanAdcClocks(CySchedule solution, double adcClockRate) {
        int minScanAdcClocks = 0;
        for (CySchedChan chan : solution.Channels) {
            chan.minAcqAdcClocksNeeded = Scheduler.ApertureAdcClocks(chan.minAcqTimeNs, adcClockRate);
            chan.minTotalAdcClocksNeeded = chan.minAcqAdcClocksNeeded + chan.minConvAdcClocksNeeded;
            chan.minTotalAdcClocksNeeded *= chan.samplesPerScan;
            if (!chan.IsEnabled) {
                chan.minTotalAdcClocksNeeded = 0;
            }
            minScanAdcClocks += chan.minTotalAdcClocksNeeded;
        }
        return minScanAdcClocks;
    }

    public static int ApertureAdcClocks(double apertureNs, double adcClockRate) {
        double adcClockNs = 1.0E9 / adcClockRate;
        double apertureClocks = apertureNs / adcClockNs;
        apertureClocks += 1.0;
        int clocks = (int)Math.ceil(apertureClocks -= 0.5 / adcClockNs);
        clocks = Math.min(clocks, 1023);
        clocks = Math.max(clocks, 2);
        return clocks;
    }

    private static List<CyTimingInfo> GetChannelTimingInfo(CySchedule solution) {
        ArrayList<CyTimingInfo> chanTimings = new ArrayList<CyTimingInfo>();
        for (int chanNum = 0; chanNum < solution.Channels.size(); ++chanNum) {
            CySchedChan chan = solution.Channels.get(chanNum);
            CyTimingInfo info = new CyTimingInfo(chan.minAcqAdcClocksNeeded, chan.samplesPerScan, chanNum, chan.IsEnabled);
            chanTimings.add(info);
        }
        return chanTimings;
    }

    private static int FindPaddingChannel(List<CyTimingInfo> chanTimes) {
        int bestPadIndex = 0;
        for (int padIndex = 1; padIndex < chanTimes.size(); ++padIndex) {
            if (chanTimes.get(bestPadIndex).ComparePaddingMerit(chanTimes.get(padIndex)) <= 0) continue;
            bestPadIndex = padIndex;
        }
        return bestPadIndex;
    }

    public static long OptimizeApertures(List<CyTimingInfo> chanTimes, int chanBase, int chanTop, List<Integer> apertureClocks, int apertureBase, int apertureTop) {
        long cost = 0L;
        if (chanTop == chanBase) {
            for (int index = apertureBase; index < apertureTop; ++index) {
                apertureClocks.set(index, 0);
            }
        } else if (apertureBase + 1 == apertureTop) {
            int apertureTime = chanTimes.get((int)(chanTop - 1)).IdealSample_AdcClock;
            apertureClocks.set(apertureBase, apertureTime);
            cost = Scheduler.CalcApertureCost(chanTimes, chanBase, chanTop, apertureTime);
        } else {
            long minCost = Long.MAX_VALUE;
            ArrayList<Integer> minClocks = new ArrayList<Integer>(apertureClocks);
            int chanNum = chanBase;
            while (chanNum < chanTop) {
                int nextChanNum;
                int apertureTime = chanTimes.get((int)chanNum).IdealSample_AdcClock;
                for (nextChanNum = chanNum; nextChanNum < chanTop && chanTimes.get((int)nextChanNum).IdealSample_AdcClock == apertureTime; ++nextChanNum) {
                }
                ArrayList<Integer> branchClocks = new ArrayList<Integer>(apertureClocks);
                long branchCost = Scheduler.CalcApertureCost(chanTimes, chanBase, nextChanNum, apertureTime) + Scheduler.OptimizeApertures(chanTimes, nextChanNum, chanTop, branchClocks, apertureBase + 1, apertureTop);
                if (minCost > branchCost) {
                    minCost = branchCost;
                    minClocks = branchClocks;
                    minClocks.set(apertureBase, apertureTime);
                }
                chanNum = nextChanNum;
            }
            cost = minCost;
            for (int index = apertureBase; index < apertureTop; ++index) {
                apertureClocks.set(index, (Integer)minClocks.get(index));
            }
        }
        return cost;
    }

    public static long CalcApertureCost(List<CyTimingInfo> chanTimes, int chanBase, int chanTop, long aperture) {
        long cost = 0L;
        for (int chanNum = chanBase; chanNum < chanTop; ++chanNum) {
            CyTimingInfo chan = chanTimes.get(chanNum);
            long chanExcess = aperture - (long)chan.IdealSample_AdcClock;
            cost += (chanExcess *= (long)chan.SampleCount);
        }
        return cost;
    }

    private static void SetChannelTimers(CySchedule solution, int timerBase, int timerTop) {
        for (CySchedChan chan : solution.Channels) {
            Scheduler.SetTimer(solution, chan, timerBase, timerTop);
        }
    }

    private static void SetTimer(CySchedule solution, CySchedChan chan, int timerBase, int timerTop) {
        for (int timer = timerBase; timer < timerTop; ++timer) {
            if (chan.minAcqAdcClocksNeeded > solution.Apertures_AdcClock.get(timer)) continue;
            chan.Timer = timer;
            break;
        }
    }

    private static int FindMappedScanAdcClocks(CySchedule solution) {
        int mappedScanAdcClocks = 0;
        for (CySchedChan chan : solution.Channels) {
            Scheduler.FindMappedChannelScanAdcClocks(chan, solution.Apertures_AdcClock);
            mappedScanAdcClocks += chan.mappedTotalAdcClocks;
        }
        return mappedScanAdcClocks;
    }

    private static void FindMappedChannelScanAdcClocks(CySchedChan chan, List<Integer> apertures_AdcClock) {
        chan.mappedAcqAdcClocks = apertures_AdcClock.get(chan.Timer);
        chan.mappedTotalAdcClocks = chan.mappedAcqAdcClocks + chan.minConvAdcClocksNeeded;
        chan.mappedTotalAdcClocks *= chan.samplesPerScan;
    }

    public static int AdcClocks(double targetFrequency, double adcClockRate) {
        double clocks = adcClockRate / targetFrequency;
        clocks = Math.ceil(clocks);
        return (int)clocks;
    }

    public static long SelectAdcClockDivider() {
        long adcClockDivider;
        if (isSingleShot) {
            adcClockDivider = 2L;
        } else {
            List<Double> minScan = Scheduler.FindAdcClockParameters();
            double minScanSample_ns = minScan.get(0);
            double minScanConv_AdcClock = minScan.get(1);
            double minScanSampleTime_s = minScanSample_ns / 1.0E9;
            double targetScanPeriod_s = 1.0 / targetSampleRate;
            double allowedConversionTime_s = targetScanPeriod_s - minScanSampleTime_s;
            double adcClockHz = (minScanConv_AdcClock + 512.0) / allowedConversionTime_s;
            adcClockDivider = Math.round(hfClockRate / adcClockHz);
        }
        adcClockDivider = Scheduler.ClipAdcClockDividerToLimits(adcClockDivider);
        return adcClockDivider;
    }

    private static List<Double> FindAdcClockParameters() {
        ArrayList<Double> minScan = new ArrayList<Double>();
        double minScanSampleNs = 0.0;
        double minScanConvAdcClocks = 0.0;
        for (CySchedChan chan : channels) {
            double minSampleNs = chan.minAcqTimeNs;
            double minConvAdcClocks = chan.minConvAdcClocksNeeded;
            if (chan.samplesPerScan > 1) {
                minSampleNs *= (double)chan.samplesPerScan;
                minConvAdcClocks *= (double)chan.samplesPerScan;
            }
            minScanSampleNs += minSampleNs;
            minScanConvAdcClocks += minConvAdcClocks;
        }
        minScan.add(minScanSampleNs);
        minScan.add(minScanConvAdcClocks);
        return minScan;
    }

    private static long ClipAdcClockDividerToLimits(long adcClockDivider) {
        long maxDivider = (long)Math.floor(hfClockRate / minClockRate);
        long minDivider = (long)Math.ceil(hfClockRate / maxClockRate);
        long clippedAdcClockDivider = Math.min(adcClockDivider, maxDivider);
        clippedAdcClockDivider = Math.max(clippedAdcClockDivider, minDivider);
        clippedAdcClockDivider = Math.max(clippedAdcClockDivider, 2L);
        return clippedAdcClockDivider;
    }

    static {
        channels = new ArrayList<CySchedChan>();
        adcClockDivider = 0.0;
    }
}

