/***************************************************************************//**
* \file SDIO_HOST_cfg.h
*
* \brief
*  This file provides the configuration of the UDB based SDIO driver.
*
********************************************************************************
* \copyright
* Copyright 2016-2020 Cypress Semiconductor Corporation
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#if !defined(CY_SDIO_CFG_H)
#define CY_SDIO_CFG_H

#include <string.h>

#include "cy_dma.h"
#include "cy_sysclk.h"
#include "cy_trigmux.h"

#if defined(__cplusplus)
extern "C" {
#endif

#define CYREG_PROT_SMPU_MS0_CTL 0x40240000u
#define CYREG_PROT_SMPU_MS1_CTL 0x40240004u
#define CYREG_PROT_SMPU_MS2_CTL 0x40240008u
#define CYREG_PROT_SMPU_MS3_CTL 0x4024000cu
#define CYREG_PROT_SMPU_MS14_CTL 0x40240038u

#define CYDEV_UDB_UDBPAIR1_UDBSNG0_BASE 0x40342200u
#define CYDEV_UDB_UDBPAIR0_UDBSNG1_BASE 0x40342080u

#define CYREG_UDB_UDBPAIR0_UDBSNG0_RC_CFG0 0x4034205cu
#define CYREG_UDB_UDBPAIR0_UDBSNG1_RC_CFG0 0x403420dcu

#define CYREG_UDB_UDBPAIR1_UDBSNG0_RC_CFG0 0x4034225cu
#define CYREG_UDB_UDBPAIR1_UDBSNG1_RC_CFG0 0x403422dcu

#define CYREG_UDB_UDBPAIR2_UDBSNG0_RC_CFG0 0x4034245cu
#define CYREG_UDB_UDBPAIR2_UDBSNG1_RC_CFG0 0x403424dcu
#define CYREG_UDB_UDBPAIR3_UDBSNG0_RC_CFG0 0x4034265cu
#define CYREG_UDB_UDBPAIR3_UDBSNG1_RC_CFG0 0x403426dcu
#define CYREG_UDB_UDBPAIR4_UDBSNG0_RC_CFG0 0x4034285cu
#define CYREG_UDB_UDBPAIR4_UDBSNG1_RC_CFG0 0x403428dcu
#define CYREG_UDB_UDBPAIR5_UDBSNG0_RC_CFG0 0x40342a5cu
#define CYREG_UDB_UDBPAIR5_UDBSNG1_RC_CFG0 0x40342adcu

#define CYDEV_UDB_UDBPAIR4_UDBSNG0_BASE 0x40342800u
#define CYDEV_UDB_UDBPAIR3_UDBSNG1_BASE 0x40342680u
#define CYDEV_UDB_UDBPAIR1_UDBSNG1_BASE 0x40342280u
#define CYDEV_UDB_UDBPAIR0_UDBSNG0_BASE 0x40342000u

#define CYDEV_UDB_UDBPAIR0_ROUTE_BASE 0x40342100u
#define CYDEV_UDB_UDBPAIR1_ROUTE_BASE 0x40342300u
#define CYDEV_UDB_UDBPAIR2_ROUTE_BASE 0x40342500u
#define CYDEV_UDB_UDBPAIR3_ROUTE_BASE 0x40342700u
#define CYDEV_UDB_UDBPAIR4_ROUTE_BASE 0x40342900u
#define CYDEV_UDB_UDBPAIR5_ROUTE_BASE 0x40342b00u


#define CYDEV_UDB_UDBPAIR2_UDBSNG0_BASE 0x40342400u
#define CYDEV_UDB_UDBPAIR2_UDBSNG1_BASE 0x40342480u
#define CYDEV_UDB_UDBPAIR3_UDBSNG0_BASE 0x40342600u
#define CYDEV_UDB_UDBPAIR4_UDBSNG1_BASE 0x40342880u
#define CYDEV_UDB_UDBPAIR5_UDBSNG0_BASE 0x40342a00u
#define CYDEV_UDB_UDBPAIR5_UDBSNG1_BASE 0x40342a80u


#define CYDEV_UDB_DSI0_BASE 0x40346000u
#define CYDEV_UDB_DSI1_BASE 0x40346080u
#define CYDEV_UDB_DSI2_BASE 0x40346100u
#define CYDEV_UDB_DSI3_BASE 0x40346180u
#define CYDEV_UDB_DSI4_BASE 0x40346200u
#define CYDEV_UDB_DSI5_BASE 0x40346280u
#define CYDEV_UDB_DSI6_BASE 0x40346300u
#define CYDEV_UDB_DSI7_BASE 0x40346380u
#define CYDEV_UDB_DSI8_BASE 0x40346400u
#define CYDEV_UDB_DSI9_BASE 0x40346480u
#define CYDEV_UDB_DSI10_BASE 0x40346500u
#define CYDEV_UDB_DSI11_BASE 0x40346580u

#define CYREG_UDB_UDBIF_INT_CLK_CTL 0x40347904u

/*************Defines for UDBs from Creator*****************************/
/***********These come for cyfitter.h**********************************/

/* SDIO_HOST_bSDIO */
#define SDIO_HOST_bSDIO_blockCounter_u0__16BIT_A0_REG 0x40341008u
#define SDIO_HOST_bSDIO_blockCounter_u0__16BIT_A1_REG 0x40341108u
#define SDIO_HOST_bSDIO_blockCounter_u0__16BIT_D0_REG 0x40341208u
#define SDIO_HOST_bSDIO_blockCounter_u0__16BIT_D1_REG 0x40341308u
#define SDIO_HOST_bSDIO_blockCounter_u0__16BIT_DP_AUX_CTL_REG 0x40341908u
#define SDIO_HOST_bSDIO_blockCounter_u0__16BIT_F0_REG 0x40341408u
#define SDIO_HOST_bSDIO_blockCounter_u0__16BIT_F1_REG 0x40341508u
#define SDIO_HOST_bSDIO_blockCounter_u0__32BIT_A0_REG 0x40341008u
#define SDIO_HOST_bSDIO_blockCounter_u0__32BIT_A1_REG 0x40341108u
#define SDIO_HOST_bSDIO_blockCounter_u0__32BIT_D0_REG 0x40341208u
#define SDIO_HOST_bSDIO_blockCounter_u0__32BIT_D1_REG 0x40341308u
#define SDIO_HOST_bSDIO_blockCounter_u0__32BIT_DP_AUX_CTL_REG 0x40341908u
#define SDIO_HOST_bSDIO_blockCounter_u0__32BIT_F0_REG 0x40341408u
#define SDIO_HOST_bSDIO_blockCounter_u0__32BIT_F1_REG 0x40341508u
#define SDIO_HOST_bSDIO_blockCounter_u0__A0_A1_REG 0x40340008u
#define SDIO_HOST_bSDIO_blockCounter_u0__A0_REG 0x40341008u
#define SDIO_HOST_bSDIO_blockCounter_u0__A1_REG 0x40341108u
#define SDIO_HOST_bSDIO_blockCounter_u0__D0_D1_REG 0x40340108u
#define SDIO_HOST_bSDIO_blockCounter_u0__D0_REG 0x40341208u
#define SDIO_HOST_bSDIO_blockCounter_u0__D1_REG 0x40341308u
#define SDIO_HOST_bSDIO_blockCounter_u0__DP_AUX_CTL_REG 0x40341908u
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_CFG0 0x40342240u
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_CFG1 0x40342244u
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_CFG2 0x40342248u
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_CFG3 0x4034224Cu
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_CFG4 0x40342250u
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_OPC0 0x40342264u
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_OPC1 0x40342268u
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_OPC2 0x4034226Cu
#define SDIO_HOST_bSDIO_blockCounter_u0__DPATH_OPC3 0x40342270u
#define SDIO_HOST_bSDIO_blockCounter_u0__F0_F1_REG 0x40340208u
#define SDIO_HOST_bSDIO_blockCounter_u0__F0_REG 0x40341408u
#define SDIO_HOST_bSDIO_blockCounter_u0__F1_REG 0x40341508u
#define SDIO_HOST_bSDIO_blockCounter_u0__RC_CFG0 0x4034225Cu
#define SDIO_HOST_bSDIO_blockCounter_u0__RC_CFG1 0x40342260u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_CONTROL_AUX_CTL_REG 0x40341924u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_CONTROL_CONTROL_REG 0x40341724u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_CONTROL_COUNT_REG 0x40341724u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_COUNT_CONTROL_REG 0x40341724u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_COUNT_COUNT_REG 0x40341724u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_MASK_MASK_REG 0x40341824u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_MASK_PERIOD_REG 0x40341824u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_PERIOD_MASK_REG 0x40341824u
#define SDIO_HOST_bSDIO_byteCounter__16BIT_PERIOD_PERIOD_REG 0x40341824u
#define SDIO_HOST_bSDIO_byteCounter__CONTROL_AUX_CTL_REG 0x40341924u
#define SDIO_HOST_bSDIO_byteCounter__CONTROL_REG 0x40341724u
#define SDIO_HOST_bSDIO_byteCounter__CONTROL_ST_REG 0x40340324u
#define SDIO_HOST_bSDIO_byteCounter__COUNT_REG 0x40341724u
#define SDIO_HOST_bSDIO_byteCounter__COUNT_ST_REG 0x40340324u
#define SDIO_HOST_bSDIO_byteCounter__MASK_CTL_AUX_CTL_REG 0x40340424u
#define SDIO_HOST_bSDIO_byteCounter__PER_CTL_AUX_CTL_REG 0x40340424u
#define SDIO_HOST_bSDIO_byteCounter__PERIOD_REG 0x40341824u
#define SDIO_HOST_bSDIO_byteCounter__RC_CFG0 0x403428DCu
#define SDIO_HOST_bSDIO_byteCounter__RC_CFG1 0x403428E0u
#define SDIO_HOST_bSDIO_byteCounter__SC_CFG0 0x403428D4u
#define SDIO_HOST_bSDIO_byteCounter__SC_CFG1 0x403428D8u
#define SDIO_HOST_bSDIO_byteCounter_ST__16BIT_STATUS_AUX_CTL_REG 0x40341924u
#define SDIO_HOST_bSDIO_byteCounter_ST__16BIT_STATUS_REG 0x40341624u
#define SDIO_HOST_bSDIO_byteCounter_ST__MASK_REG 0x40341824u
#define SDIO_HOST_bSDIO_byteCounter_ST__MASK_ST_AUX_CTL_REG 0x40340424u
#define SDIO_HOST_bSDIO_byteCounter_ST__PER_ST_AUX_CTL_REG 0x40340424u
#define SDIO_HOST_bSDIO_byteCounter_ST__RC_CFG0 0x403428DCu
#define SDIO_HOST_bSDIO_byteCounter_ST__RC_CFG1 0x403428E0u
#define SDIO_HOST_bSDIO_byteCounter_ST__SC_CFG0 0x403428D4u
#define SDIO_HOST_bSDIO_byteCounter_ST__SC_CFG1 0x403428D8u
#define SDIO_HOST_bSDIO_byteCounter_ST__STATUS_AUX_CTL_REG 0x40341924u
#define SDIO_HOST_bSDIO_byteCounter_ST__STATUS_CNT_REG 0x40340324u
#define SDIO_HOST_bSDIO_byteCounter_ST__STATUS_CONTROL_REG 0x40340324u
#define SDIO_HOST_bSDIO_byteCounter_ST__STATUS_REG 0x40341624u
#define SDIO_HOST_bSDIO_CMD__16BIT_A0_REG 0x40341000u
#define SDIO_HOST_bSDIO_CMD__16BIT_A1_REG 0x40341100u
#define SDIO_HOST_bSDIO_CMD__16BIT_D0_REG 0x40341200u
#define SDIO_HOST_bSDIO_CMD__16BIT_D1_REG 0x40341300u
#define SDIO_HOST_bSDIO_CMD__16BIT_DP_AUX_CTL_REG 0x40341900u
#define SDIO_HOST_bSDIO_CMD__16BIT_F0_REG 0x40341400u
#define SDIO_HOST_bSDIO_CMD__16BIT_F1_REG 0x40341500u
#define SDIO_HOST_bSDIO_CMD__32BIT_A0_REG 0x40341000u
#define SDIO_HOST_bSDIO_CMD__32BIT_A1_REG 0x40341100u
#define SDIO_HOST_bSDIO_CMD__32BIT_D0_REG 0x40341200u
#define SDIO_HOST_bSDIO_CMD__32BIT_D1_REG 0x40341300u
#define SDIO_HOST_bSDIO_CMD__32BIT_DP_AUX_CTL_REG 0x40341900u
#define SDIO_HOST_bSDIO_CMD__32BIT_F0_REG 0x40341400u
#define SDIO_HOST_bSDIO_CMD__32BIT_F1_REG 0x40341500u
#define SDIO_HOST_bSDIO_CMD__A0_A1_REG 0x40340000u
#define SDIO_HOST_bSDIO_CMD__A0_REG 0x40341000u
#define SDIO_HOST_bSDIO_CMD__A1_REG 0x40341100u
#define SDIO_HOST_bSDIO_CMD__D0_D1_REG 0x40340100u
#define SDIO_HOST_bSDIO_CMD__D0_REG 0x40341200u
#define SDIO_HOST_bSDIO_CMD__D1_REG 0x40341300u
#define SDIO_HOST_bSDIO_CMD__DP_AUX_CTL_REG 0x40341900u
#define SDIO_HOST_bSDIO_CMD__DPATH_CFG0 0x40342040u
#define SDIO_HOST_bSDIO_CMD__DPATH_CFG1 0x40342044u
#define SDIO_HOST_bSDIO_CMD__DPATH_CFG2 0x40342048u
#define SDIO_HOST_bSDIO_CMD__DPATH_CFG3 0x4034204Cu
#define SDIO_HOST_bSDIO_CMD__DPATH_CFG4 0x40342050u
#define SDIO_HOST_bSDIO_CMD__DPATH_OPC0 0x40342064u
#define SDIO_HOST_bSDIO_CMD__DPATH_OPC1 0x40342068u
#define SDIO_HOST_bSDIO_CMD__DPATH_OPC2 0x4034206Cu
#define SDIO_HOST_bSDIO_CMD__DPATH_OPC3 0x40342070u
#define SDIO_HOST_bSDIO_CMD__F0_F1_REG 0x40340200u
#define SDIO_HOST_bSDIO_CMD__F0_REG 0x40341400u
#define SDIO_HOST_bSDIO_CMD__F1_REG 0x40341500u
#define SDIO_HOST_bSDIO_CMD__RC_CFG0 0x4034205Cu
#define SDIO_HOST_bSDIO_CMD__RC_CFG1 0x40342060u
#define SDIO_HOST_bSDIO_cmdBitCounter__CONTROL_AUX_CTL_REG 0x4034192Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__CONTROL_REG 0x4034172Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__CONTROL_ST_REG 0x4034032Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__COUNT_REG 0x4034172Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__COUNT_ST_REG 0x4034032Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__MASK_CTL_AUX_CTL_REG 0x4034042Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__PER_CTL_AUX_CTL_REG 0x4034042Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__PERIOD_REG 0x4034182Cu
#define SDIO_HOST_bSDIO_cmdBitCounter__RC_CFG0 0x40342ADCu
#define SDIO_HOST_bSDIO_cmdBitCounter__RC_CFG1 0x40342AE0u
#define SDIO_HOST_bSDIO_cmdBitCounter__SC_CFG0 0x40342AD4u
#define SDIO_HOST_bSDIO_cmdBitCounter__SC_CFG1 0x40342AD8u
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__MASK_REG 0x4034182Cu
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__MASK_ST_AUX_CTL_REG 0x4034042Cu
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__PER_ST_AUX_CTL_REG 0x4034042Cu
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__RC_CFG0 0x40342ADCu
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__RC_CFG1 0x40342AE0u
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__SC_CFG0 0x40342AD4u
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__SC_CFG1 0x40342AD8u
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__STATUS_AUX_CTL_REG 0x4034192Cu
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__STATUS_CNT_REG 0x4034032Cu
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__STATUS_CONTROL_REG 0x4034032Cu
#define SDIO_HOST_bSDIO_cmdBitCounter_ST__STATUS_REG 0x4034162Cu
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_CONTROL_AUX_CTL_REG 0x40341928u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_CONTROL_CONTROL_REG 0x40341728u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_CONTROL_COUNT_REG 0x40341728u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_COUNT_CONTROL_REG 0x40341728u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_COUNT_COUNT_REG 0x40341728u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_MASK_MASK_REG 0x40341828u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_MASK_PERIOD_REG 0x40341828u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_PERIOD_MASK_REG 0x40341828u
#define SDIO_HOST_bSDIO_crcBitCounter__16BIT_PERIOD_PERIOD_REG 0x40341828u
#define SDIO_HOST_bSDIO_crcBitCounter__CONTROL_AUX_CTL_REG 0x40341928u
#define SDIO_HOST_bSDIO_crcBitCounter__CONTROL_REG 0x40341728u
#define SDIO_HOST_bSDIO_crcBitCounter__CONTROL_ST_REG 0x40340328u
#define SDIO_HOST_bSDIO_crcBitCounter__COUNT_REG 0x40341728u
#define SDIO_HOST_bSDIO_crcBitCounter__COUNT_ST_REG 0x40340328u
#define SDIO_HOST_bSDIO_crcBitCounter__MASK_CTL_AUX_CTL_REG 0x40340428u
#define SDIO_HOST_bSDIO_crcBitCounter__PER_CTL_AUX_CTL_REG 0x40340428u
#define SDIO_HOST_bSDIO_crcBitCounter__PERIOD_REG 0x40341828u
#define SDIO_HOST_bSDIO_crcBitCounter__RC_CFG0 0x40342A5Cu
#define SDIO_HOST_bSDIO_crcBitCounter__RC_CFG1 0x40342A60u
#define SDIO_HOST_bSDIO_crcBitCounter__SC_CFG0 0x40342A54u
#define SDIO_HOST_bSDIO_crcBitCounter__SC_CFG1 0x40342A58u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__16BIT_STATUS_AUX_CTL_REG 0x40341928u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__16BIT_STATUS_REG 0x40341628u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__MASK_REG 0x40341828u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__MASK_ST_AUX_CTL_REG 0x40340428u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__PER_ST_AUX_CTL_REG 0x40340428u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__RC_CFG0 0x40342A5Cu
#define SDIO_HOST_bSDIO_crcBitCounter_ST__RC_CFG1 0x40342A60u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__SC_CFG0 0x40342A54u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__SC_CFG1 0x40342A58u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__STATUS_AUX_CTL_REG 0x40341928u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__STATUS_CNT_REG 0x40340328u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__STATUS_CONTROL_REG 0x40340328u
#define SDIO_HOST_bSDIO_crcBitCounter_ST__STATUS_REG 0x40341628u
#define SDIO_HOST_bSDIO_CtrlReg__0__MASK 0x01u
#define SDIO_HOST_bSDIO_CtrlReg__0__POS 0
#define SDIO_HOST_bSDIO_CtrlReg__1__MASK 0x02u
#define SDIO_HOST_bSDIO_CtrlReg__1__POS 1
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_CONTROL_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_CONTROL_CONTROL_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_CONTROL_COUNT_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_COUNT_CONTROL_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_COUNT_COUNT_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_MASK_MASK_REG 0x40341818u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_MASK_PERIOD_REG 0x40341818u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_PERIOD_MASK_REG 0x40341818u
#define SDIO_HOST_bSDIO_CtrlReg__16BIT_PERIOD_PERIOD_REG 0x40341818u
#define SDIO_HOST_bSDIO_CtrlReg__2__MASK 0x04u
#define SDIO_HOST_bSDIO_CtrlReg__2__POS 2
#define SDIO_HOST_bSDIO_CtrlReg__3__MASK 0x08u
#define SDIO_HOST_bSDIO_CtrlReg__3__POS 3
#define SDIO_HOST_bSDIO_CtrlReg__32BIT_CONTROL_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_CtrlReg__32BIT_CONTROL_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__32BIT_COUNT_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__32BIT_PERIOD_REG 0x40341818u
#define SDIO_HOST_bSDIO_CtrlReg__4__MASK 0x10u
#define SDIO_HOST_bSDIO_CtrlReg__4__POS 4
#define SDIO_HOST_bSDIO_CtrlReg__6__MASK 0x40u
#define SDIO_HOST_bSDIO_CtrlReg__6__POS 6
#define SDIO_HOST_bSDIO_CtrlReg__7__MASK 0x80u
#define SDIO_HOST_bSDIO_CtrlReg__7__POS 7
#define SDIO_HOST_bSDIO_CtrlReg__CONTROL_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_CtrlReg__CONTROL_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__CONTROL_ST_REG 0x40340318u
#define SDIO_HOST_bSDIO_CtrlReg__COUNT_REG 0x40341718u
#define SDIO_HOST_bSDIO_CtrlReg__COUNT_ST_REG 0x40340318u
#define SDIO_HOST_bSDIO_CtrlReg__MASK 0xDFu
#define SDIO_HOST_bSDIO_CtrlReg__MASK_CTL_AUX_CTL_REG 0x40340418u
#define SDIO_HOST_bSDIO_CtrlReg__PER_CTL_AUX_CTL_REG 0x40340418u
#define SDIO_HOST_bSDIO_CtrlReg__PERIOD_REG 0x40341818u
#define SDIO_HOST_bSDIO_CtrlReg__RC_CFG0 0x4034265Cu
#define SDIO_HOST_bSDIO_CtrlReg__RC_CFG1 0x40342660u
#define SDIO_HOST_bSDIO_CtrlReg__SC_CFG0 0x40342654u
#define SDIO_HOST_bSDIO_CtrlReg__SC_CFG1 0x40342658u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__16BIT_A0_REG 0x40341010u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__16BIT_A1_REG 0x40341110u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__16BIT_D0_REG 0x40341210u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__16BIT_D1_REG 0x40341310u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__16BIT_DP_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__16BIT_F0_REG 0x40341410u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__16BIT_F1_REG 0x40341510u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__32BIT_A0_REG 0x40341010u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__32BIT_A1_REG 0x40341110u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__32BIT_D0_REG 0x40341210u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__32BIT_D1_REG 0x40341310u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__32BIT_DP_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__32BIT_F0_REG 0x40341410u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__32BIT_F1_REG 0x40341510u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__A0_A1_REG 0x40340010u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__A0_REG 0x40341010u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__A1_REG 0x40341110u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__D0_D1_REG 0x40340110u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__D0_REG 0x40341210u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__D1_REG 0x40341310u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DP_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_CFG0 0x40342440u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_CFG1 0x40342444u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_CFG2 0x40342448u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_CFG3 0x4034244Cu
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_CFG4 0x40342450u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_OPC0 0x40342464u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_OPC1 0x40342468u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_OPC2 0x4034246Cu
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__DPATH_OPC3 0x40342470u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__F0_F1_REG 0x40340210u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__F0_REG 0x40341410u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__F1_REG 0x40341510u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__MSK_DP_AUX_CTL_REG 0x40340410u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__PER_DP_AUX_CTL_REG 0x40340410u
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__RC_CFG0 0x4034245Cu
#define SDIO_HOST_bSDIO_DAT_CRC0_u0__RC_CFG1 0x40342460u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__16BIT_A0_REG 0x40341014u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__16BIT_A1_REG 0x40341114u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__16BIT_D0_REG 0x40341214u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__16BIT_D1_REG 0x40341314u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__16BIT_DP_AUX_CTL_REG 0x40341914u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__16BIT_F0_REG 0x40341414u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__16BIT_F1_REG 0x40341514u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__32BIT_A0_REG 0x40341014u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__32BIT_A1_REG 0x40341114u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__32BIT_D0_REG 0x40341214u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__32BIT_D1_REG 0x40341314u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__32BIT_DP_AUX_CTL_REG 0x40341914u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__32BIT_F0_REG 0x40341414u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__32BIT_F1_REG 0x40341514u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__A0_A1_REG 0x40340014u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__A0_REG 0x40341014u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__A1_REG 0x40341114u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__D0_D1_REG 0x40340114u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__D0_REG 0x40341214u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__D1_REG 0x40341314u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DP_AUX_CTL_REG 0x40341914u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_CFG0 0x403424C0u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_CFG1 0x403424C4u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_CFG2 0x403424C8u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_CFG3 0x403424CCu
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_CFG4 0x403424D0u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_OPC0 0x403424E4u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_OPC1 0x403424E8u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_OPC2 0x403424ECu
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__DPATH_OPC3 0x403424F0u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__F0_F1_REG 0x40340214u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__F0_REG 0x40341414u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__F1_REG 0x40341514u
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__RC_CFG0 0x403424DCu
#define SDIO_HOST_bSDIO_DAT_CRC0_u1__RC_CFG1 0x403424E0u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__16BIT_A0_REG 0x40341028u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__16BIT_A1_REG 0x40341128u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__16BIT_D0_REG 0x40341228u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__16BIT_D1_REG 0x40341328u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__16BIT_DP_AUX_CTL_REG 0x40341928u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__16BIT_F0_REG 0x40341428u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__16BIT_F1_REG 0x40341528u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__A0_A1_REG 0x40340028u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__A0_REG 0x40341028u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__A1_REG 0x40341128u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__D0_D1_REG 0x40340128u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__D0_REG 0x40341228u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__D1_REG 0x40341328u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DP_AUX_CTL_REG 0x40341928u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_CFG0 0x40342A40u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_CFG1 0x40342A44u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_CFG2 0x40342A48u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_CFG3 0x40342A4Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_CFG4 0x40342A50u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_OPC0 0x40342A64u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_OPC1 0x40342A68u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_OPC2 0x40342A6Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__DPATH_OPC3 0x40342A70u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__F0_F1_REG 0x40340228u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__F0_REG 0x40341428u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__F1_REG 0x40341528u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__MSK_DP_AUX_CTL_REG 0x40340428u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__PER_DP_AUX_CTL_REG 0x40340428u
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__RC_CFG0 0x40342A5Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u0__RC_CFG1 0x40342A60u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__A0_A1_REG 0x4034002Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__A0_REG 0x4034102Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__A1_REG 0x4034112Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__D0_D1_REG 0x4034012Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__D0_REG 0x4034122Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__D1_REG 0x4034132Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DP_AUX_CTL_REG 0x4034192Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_CFG0 0x40342AC0u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_CFG1 0x40342AC4u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_CFG2 0x40342AC8u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_CFG3 0x40342ACCu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_CFG4 0x40342AD0u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_OPC0 0x40342AE4u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_OPC1 0x40342AE8u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_OPC2 0x40342AECu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__DPATH_OPC3 0x40342AF0u
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__F0_F1_REG 0x4034022Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__F0_REG 0x4034142Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__F1_REG 0x4034152Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__MSK_DP_AUX_CTL_REG 0x4034042Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__PER_DP_AUX_CTL_REG 0x4034042Cu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__RC_CFG0 0x40342ADCu
#define SDIO_HOST_bSDIO_DAT_CRC1_u1__RC_CFG1 0x40342AE0u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__16BIT_A0_REG 0x40341020u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__16BIT_A1_REG 0x40341120u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__16BIT_D0_REG 0x40341220u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__16BIT_D1_REG 0x40341320u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__16BIT_DP_AUX_CTL_REG 0x40341920u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__16BIT_F0_REG 0x40341420u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__16BIT_F1_REG 0x40341520u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__32BIT_A0_REG 0x40341020u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__32BIT_A1_REG 0x40341120u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__32BIT_D0_REG 0x40341220u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__32BIT_D1_REG 0x40341320u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__32BIT_DP_AUX_CTL_REG 0x40341920u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__32BIT_F0_REG 0x40341420u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__32BIT_F1_REG 0x40341520u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__A0_A1_REG 0x40340020u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__A0_REG 0x40341020u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__A1_REG 0x40341120u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__D0_D1_REG 0x40340120u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__D0_REG 0x40341220u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__D1_REG 0x40341320u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DP_AUX_CTL_REG 0x40341920u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_CFG0 0x40342840u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_CFG1 0x40342844u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_CFG2 0x40342848u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_CFG3 0x4034284Cu
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_CFG4 0x40342850u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_OPC0 0x40342864u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_OPC1 0x40342868u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_OPC2 0x4034286Cu
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__DPATH_OPC3 0x40342870u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__F0_F1_REG 0x40340220u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__F0_REG 0x40341420u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__F1_REG 0x40341520u
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__RC_CFG0 0x4034285Cu
#define SDIO_HOST_bSDIO_DAT_CRC2_u0__RC_CFG1 0x40342860u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__16BIT_A0_REG 0x40341024u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__16BIT_A1_REG 0x40341124u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__16BIT_D0_REG 0x40341224u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__16BIT_D1_REG 0x40341324u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__16BIT_DP_AUX_CTL_REG 0x40341924u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__16BIT_F0_REG 0x40341424u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__16BIT_F1_REG 0x40341524u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__A0_A1_REG 0x40340024u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__A0_REG 0x40341024u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__A1_REG 0x40341124u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__D0_D1_REG 0x40340124u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__D0_REG 0x40341224u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__D1_REG 0x40341324u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DP_AUX_CTL_REG 0x40341924u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_CFG0 0x403428C0u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_CFG1 0x403428C4u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_CFG2 0x403428C8u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_CFG3 0x403428CCu
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_CFG4 0x403428D0u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_OPC0 0x403428E4u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_OPC1 0x403428E8u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_OPC2 0x403428ECu
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__DPATH_OPC3 0x403428F0u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__F0_F1_REG 0x40340224u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__F0_REG 0x40341424u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__F1_REG 0x40341524u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__MSK_DP_AUX_CTL_REG 0x40340424u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__PER_DP_AUX_CTL_REG 0x40340424u
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__RC_CFG0 0x403428DCu
#define SDIO_HOST_bSDIO_DAT_CRC2_u1__RC_CFG1 0x403428E0u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__16BIT_A0_REG 0x40341018u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__16BIT_A1_REG 0x40341118u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__16BIT_D0_REG 0x40341218u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__16BIT_D1_REG 0x40341318u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__16BIT_DP_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__16BIT_F0_REG 0x40341418u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__16BIT_F1_REG 0x40341518u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__32BIT_A0_REG 0x40341018u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__32BIT_A1_REG 0x40341118u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__32BIT_D0_REG 0x40341218u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__32BIT_D1_REG 0x40341318u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__32BIT_DP_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__32BIT_F0_REG 0x40341418u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__32BIT_F1_REG 0x40341518u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__A0_A1_REG 0x40340018u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__A0_REG 0x40341018u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__A1_REG 0x40341118u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__D0_D1_REG 0x40340118u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__D0_REG 0x40341218u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__D1_REG 0x40341318u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DP_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_CFG0 0x40342640u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_CFG1 0x40342644u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_CFG2 0x40342648u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_CFG3 0x4034264Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_CFG4 0x40342650u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_OPC0 0x40342664u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_OPC1 0x40342668u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_OPC2 0x4034266Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__DPATH_OPC3 0x40342670u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__F0_F1_REG 0x40340218u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__F0_REG 0x40341418u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__F1_REG 0x40341518u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__MSK_DP_AUX_CTL_REG 0x40340418u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__PER_DP_AUX_CTL_REG 0x40340418u
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__RC_CFG0 0x4034265Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u0__RC_CFG1 0x40342660u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__16BIT_A0_REG 0x4034101Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__16BIT_A1_REG 0x4034111Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__16BIT_D0_REG 0x4034121Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__16BIT_D1_REG 0x4034131Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__16BIT_DP_AUX_CTL_REG 0x4034191Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__16BIT_F0_REG 0x4034141Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__16BIT_F1_REG 0x4034151Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__32BIT_A0_REG 0x4034101Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__32BIT_A1_REG 0x4034111Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__32BIT_D0_REG 0x4034121Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__32BIT_D1_REG 0x4034131Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__32BIT_DP_AUX_CTL_REG 0x4034191Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__32BIT_F0_REG 0x4034141Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__32BIT_F1_REG 0x4034151Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__A0_A1_REG 0x4034001Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__A0_REG 0x4034101Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__A1_REG 0x4034111Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__D0_D1_REG 0x4034011Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__D0_REG 0x4034121Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__D1_REG 0x4034131Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DP_AUX_CTL_REG 0x4034191Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_CFG0 0x403426C0u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_CFG1 0x403426C4u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_CFG2 0x403426C8u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_CFG3 0x403426CCu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_CFG4 0x403426D0u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_OPC0 0x403426E4u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_OPC1 0x403426E8u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_OPC2 0x403426ECu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__DPATH_OPC3 0x403426F0u
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__F0_F1_REG 0x4034021Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__F0_REG 0x4034141Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__F1_REG 0x4034151Cu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__RC_CFG0 0x403426DCu
#define SDIO_HOST_bSDIO_DAT_CRC3_u1__RC_CFG1 0x403426E0u
#define SDIO_HOST_bSDIO_Read_DP__16BIT_A0_REG 0x40341004u
#define SDIO_HOST_bSDIO_Read_DP__16BIT_A1_REG 0x40341104u
#define SDIO_HOST_bSDIO_Read_DP__16BIT_D0_REG 0x40341204u
#define SDIO_HOST_bSDIO_Read_DP__16BIT_D1_REG 0x40341304u
#define SDIO_HOST_bSDIO_Read_DP__16BIT_DP_AUX_CTL_REG 0x40341904u
#define SDIO_HOST_bSDIO_Read_DP__16BIT_F0_REG 0x40341404u
#define SDIO_HOST_bSDIO_Read_DP__16BIT_F1_REG 0x40341504u
#define SDIO_HOST_bSDIO_Read_DP__32BIT_A0_REG 0x40341004u
#define SDIO_HOST_bSDIO_Read_DP__32BIT_A1_REG 0x40341104u
#define SDIO_HOST_bSDIO_Read_DP__32BIT_D0_REG 0x40341204u
#define SDIO_HOST_bSDIO_Read_DP__32BIT_D1_REG 0x40341304u
#define SDIO_HOST_bSDIO_Read_DP__32BIT_DP_AUX_CTL_REG 0x40341904u
#define SDIO_HOST_bSDIO_Read_DP__32BIT_F0_REG 0x40341404u
#define SDIO_HOST_bSDIO_Read_DP__32BIT_F1_REG 0x40341504u
#define SDIO_HOST_bSDIO_Read_DP__A0_A1_REG 0x40340004u
#define SDIO_HOST_bSDIO_Read_DP__A0_REG 0x40341004u
#define SDIO_HOST_bSDIO_Read_DP__A1_REG 0x40341104u
#define SDIO_HOST_bSDIO_Read_DP__D0_D1_REG 0x40340104u
#define SDIO_HOST_bSDIO_Read_DP__D0_REG 0x40341204u
#define SDIO_HOST_bSDIO_Read_DP__D1_REG 0x40341304u
#define SDIO_HOST_bSDIO_Read_DP__DP_AUX_CTL_REG 0x40341904u
#define SDIO_HOST_bSDIO_Read_DP__DPATH_CFG0 0x403420C0u
#define SDIO_HOST_bSDIO_Read_DP__DPATH_CFG1 0x403420C4u
#define SDIO_HOST_bSDIO_Read_DP__DPATH_CFG2 0x403420C8u
#define SDIO_HOST_bSDIO_Read_DP__DPATH_CFG3 0x403420CCu
#define SDIO_HOST_bSDIO_Read_DP__DPATH_CFG4 0x403420D0u
#define SDIO_HOST_bSDIO_Read_DP__DPATH_OPC0 0x403420E4u
#define SDIO_HOST_bSDIO_Read_DP__DPATH_OPC1 0x403420E8u
#define SDIO_HOST_bSDIO_Read_DP__DPATH_OPC2 0x403420ECu
#define SDIO_HOST_bSDIO_Read_DP__DPATH_OPC3 0x403420F0u
#define SDIO_HOST_bSDIO_Read_DP__F0_F1_REG 0x40340204u
#define SDIO_HOST_bSDIO_Read_DP__F0_REG 0x40341404u
#define SDIO_HOST_bSDIO_Read_DP__F1_REG 0x40341504u
#define SDIO_HOST_bSDIO_Read_DP__RC_CFG0 0x403420DCu
#define SDIO_HOST_bSDIO_Read_DP__RC_CFG1 0x403420E0u
#define SDIO_HOST_bSDIO_Read_DP_PI__16BIT_STATUS_AUX_CTL_REG 0x40341904u
#define SDIO_HOST_bSDIO_Read_DP_PI__16BIT_STATUS_REG 0x40341604u
#define SDIO_HOST_bSDIO_Read_DP_PI__32BIT_MASK_REG 0x40341804u
#define SDIO_HOST_bSDIO_Read_DP_PI__32BIT_STATUS_AUX_CTL_REG 0x40341904u
#define SDIO_HOST_bSDIO_Read_DP_PI__32BIT_STATUS_REG 0x40341604u
#define SDIO_HOST_bSDIO_Read_DP_PI__MASK_REG 0x40341804u
#define SDIO_HOST_bSDIO_Read_DP_PI__RC_CFG0 0x403420DCu
#define SDIO_HOST_bSDIO_Read_DP_PI__RC_CFG1 0x403420E0u
#define SDIO_HOST_bSDIO_Read_DP_PI__SC_CFG0 0x403420D4u
#define SDIO_HOST_bSDIO_Read_DP_PI__SC_CFG1 0x403420D8u
#define SDIO_HOST_bSDIO_Read_DP_PI__STATUS_AUX_CTL_REG 0x40341904u
#define SDIO_HOST_bSDIO_Read_DP_PI__STATUS_REG 0x40341604u
#define SDIO_HOST_bSDIO_StatusReg__0__MASK 0x01u
#define SDIO_HOST_bSDIO_StatusReg__0__POS 0
#define SDIO_HOST_bSDIO_StatusReg__1__MASK 0x02u
#define SDIO_HOST_bSDIO_StatusReg__1__POS 1
#define SDIO_HOST_bSDIO_StatusReg__16BIT_STATUS_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_StatusReg__16BIT_STATUS_REG 0x40341618u
#define SDIO_HOST_bSDIO_StatusReg__2__MASK 0x04u
#define SDIO_HOST_bSDIO_StatusReg__2__POS 2
#define SDIO_HOST_bSDIO_StatusReg__3__MASK 0x08u
#define SDIO_HOST_bSDIO_StatusReg__3__POS 3
#define SDIO_HOST_bSDIO_StatusReg__32BIT_MASK_REG 0x40341818u
#define SDIO_HOST_bSDIO_StatusReg__32BIT_STATUS_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_StatusReg__32BIT_STATUS_REG 0x40341618u
#define SDIO_HOST_bSDIO_StatusReg__6__MASK 0x40u
#define SDIO_HOST_bSDIO_StatusReg__6__POS 6
#define SDIO_HOST_bSDIO_StatusReg__MASK 0x4Fu
#define SDIO_HOST_bSDIO_StatusReg__MASK_REG 0x40341818u
#define SDIO_HOST_bSDIO_StatusReg__MASK_ST_AUX_CTL_REG 0x40340418u
#define SDIO_HOST_bSDIO_StatusReg__PER_ST_AUX_CTL_REG 0x40340418u
#define SDIO_HOST_bSDIO_StatusReg__RC_CFG0 0x4034265Cu
#define SDIO_HOST_bSDIO_StatusReg__RC_CFG1 0x40342660u
#define SDIO_HOST_bSDIO_StatusReg__SC_CFG0 0x40342654u
#define SDIO_HOST_bSDIO_StatusReg__SC_CFG1 0x40342658u
#define SDIO_HOST_bSDIO_StatusReg__STATUS_AUX_CTL_REG 0x40341918u
#define SDIO_HOST_bSDIO_StatusReg__STATUS_CNT_REG 0x40340318u
#define SDIO_HOST_bSDIO_StatusReg__STATUS_CONTROL_REG 0x40340318u
#define SDIO_HOST_bSDIO_StatusReg__STATUS_REG 0x40341618u
#define SDIO_HOST_bSDIO_Write_DP__16BIT_A0_REG 0x4034100Cu
#define SDIO_HOST_bSDIO_Write_DP__16BIT_A1_REG 0x4034110Cu
#define SDIO_HOST_bSDIO_Write_DP__16BIT_D0_REG 0x4034120Cu
#define SDIO_HOST_bSDIO_Write_DP__16BIT_D1_REG 0x4034130Cu
#define SDIO_HOST_bSDIO_Write_DP__16BIT_DP_AUX_CTL_REG 0x4034190Cu
#define SDIO_HOST_bSDIO_Write_DP__16BIT_F0_REG 0x4034140Cu
#define SDIO_HOST_bSDIO_Write_DP__16BIT_F1_REG 0x4034150Cu
#define SDIO_HOST_bSDIO_Write_DP__32BIT_A0_REG 0x4034100Cu
#define SDIO_HOST_bSDIO_Write_DP__32BIT_A1_REG 0x4034110Cu
#define SDIO_HOST_bSDIO_Write_DP__32BIT_D0_REG 0x4034120Cu
#define SDIO_HOST_bSDIO_Write_DP__32BIT_D1_REG 0x4034130Cu
#define SDIO_HOST_bSDIO_Write_DP__32BIT_DP_AUX_CTL_REG 0x4034190Cu
#define SDIO_HOST_bSDIO_Write_DP__32BIT_F0_REG 0x4034140Cu
#define SDIO_HOST_bSDIO_Write_DP__32BIT_F1_REG 0x4034150Cu
#define SDIO_HOST_bSDIO_Write_DP__A0_A1_REG 0x4034000Cu
#define SDIO_HOST_bSDIO_Write_DP__A0_REG 0x4034100Cu
#define SDIO_HOST_bSDIO_Write_DP__A1_REG 0x4034110Cu
#define SDIO_HOST_bSDIO_Write_DP__D0_D1_REG 0x4034010Cu
#define SDIO_HOST_bSDIO_Write_DP__D0_REG 0x4034120Cu
#define SDIO_HOST_bSDIO_Write_DP__D1_REG 0x4034130Cu
#define SDIO_HOST_bSDIO_Write_DP__DP_AUX_CTL_REG 0x4034190Cu
#define SDIO_HOST_bSDIO_Write_DP__DPATH_CFG0 0x403422C0u
#define SDIO_HOST_bSDIO_Write_DP__DPATH_CFG1 0x403422C4u
#define SDIO_HOST_bSDIO_Write_DP__DPATH_CFG2 0x403422C8u
#define SDIO_HOST_bSDIO_Write_DP__DPATH_CFG3 0x403422CCu
#define SDIO_HOST_bSDIO_Write_DP__DPATH_CFG4 0x403422D0u
#define SDIO_HOST_bSDIO_Write_DP__DPATH_OPC0 0x403422E4u
#define SDIO_HOST_bSDIO_Write_DP__DPATH_OPC1 0x403422E8u
#define SDIO_HOST_bSDIO_Write_DP__DPATH_OPC2 0x403422ECu
#define SDIO_HOST_bSDIO_Write_DP__DPATH_OPC3 0x403422F0u
#define SDIO_HOST_bSDIO_Write_DP__F0_F1_REG 0x4034020Cu
#define SDIO_HOST_bSDIO_Write_DP__F0_REG 0x4034140Cu
#define SDIO_HOST_bSDIO_Write_DP__F1_REG 0x4034150Cu
#define SDIO_HOST_bSDIO_Write_DP__MSK_DP_AUX_CTL_REG 0x4034040Cu
#define SDIO_HOST_bSDIO_Write_DP__PER_DP_AUX_CTL_REG 0x4034040Cu
#define SDIO_HOST_bSDIO_Write_DP__RC_CFG0 0x403422DCu
#define SDIO_HOST_bSDIO_Write_DP__RC_CFG1 0x403422E0u
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_CONTROL_AUX_CTL_REG 0x4034190Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_CONTROL_CONTROL_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_CONTROL_COUNT_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_COUNT_CONTROL_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_COUNT_COUNT_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_MASK_MASK_REG 0x4034180Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_MASK_PERIOD_REG 0x4034180Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_PERIOD_MASK_REG 0x4034180Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__16BIT_PERIOD_PERIOD_REG 0x4034180Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__32BIT_CONTROL_AUX_CTL_REG 0x4034190Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__32BIT_CONTROL_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__32BIT_COUNT_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__32BIT_PERIOD_REG 0x4034180Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__CONTROL_AUX_CTL_REG 0x4034190Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__CONTROL_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__CONTROL_ST_REG 0x4034030Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__COUNT_REG 0x4034170Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__COUNT_ST_REG 0x4034030Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__MASK_CTL_AUX_CTL_REG 0x4034040Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__PER_CTL_AUX_CTL_REG 0x4034040Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__PERIOD_REG 0x4034180Cu
#define SDIO_HOST_bSDIO_Write_DP_PO__RC_CFG0 0x403422DCu
#define SDIO_HOST_bSDIO_Write_DP_PO__RC_CFG1 0x403422E0u
#define SDIO_HOST_bSDIO_Write_DP_PO__SC_CFG0 0x403422D4u
#define SDIO_HOST_bSDIO_Write_DP_PO__SC_CFG1 0x403422D8u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_CONTROL_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_CONTROL_CONTROL_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_CONTROL_COUNT_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_COUNT_CONTROL_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_COUNT_COUNT_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_MASK_MASK_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_MASK_PERIOD_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_PERIOD_MASK_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter__16BIT_PERIOD_PERIOD_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter__32BIT_CONTROL_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_writeCrcCounter__32BIT_CONTROL_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__32BIT_COUNT_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__32BIT_PERIOD_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter__CONTROL_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_writeCrcCounter__CONTROL_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__CONTROL_ST_REG 0x40340310u
#define SDIO_HOST_bSDIO_writeCrcCounter__COUNT_REG 0x40341710u
#define SDIO_HOST_bSDIO_writeCrcCounter__COUNT_ST_REG 0x40340310u
#define SDIO_HOST_bSDIO_writeCrcCounter__MASK_CTL_AUX_CTL_REG 0x40340410u
#define SDIO_HOST_bSDIO_writeCrcCounter__PER_CTL_AUX_CTL_REG 0x40340410u
#define SDIO_HOST_bSDIO_writeCrcCounter__PERIOD_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter__RC_CFG0 0x4034245Cu
#define SDIO_HOST_bSDIO_writeCrcCounter__RC_CFG1 0x40342460u
#define SDIO_HOST_bSDIO_writeCrcCounter__SC_CFG0 0x40342454u
#define SDIO_HOST_bSDIO_writeCrcCounter__SC_CFG1 0x40342458u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__16BIT_STATUS_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__16BIT_STATUS_REG 0x40341610u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__32BIT_MASK_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__32BIT_STATUS_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__32BIT_STATUS_REG 0x40341610u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__MASK_REG 0x40341810u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__MASK_ST_AUX_CTL_REG 0x40340410u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__PER_ST_AUX_CTL_REG 0x40340410u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__RC_CFG0 0x4034245Cu
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__RC_CFG1 0x40342460u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__SC_CFG0 0x40342454u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__SC_CFG1 0x40342458u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__STATUS_AUX_CTL_REG 0x40341910u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__STATUS_CNT_REG 0x40340310u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__STATUS_CONTROL_REG 0x40340310u
#define SDIO_HOST_bSDIO_writeCrcCounter_ST__STATUS_REG 0x40341610u
#define SDIO_HOST_CMD_DMA_DW__BLOCK_HW DW0
#define SDIO_HOST_CMD_DMA_DW__BLOCK_NUMBER 0u
#define SDIO_HOST_CMD_DMA_DW__CHANNEL_HW DW0_CH_STRUCT1
#define SDIO_HOST_CMD_DMA_DW__CHANNEL_NUMBER 1u
#define SDIO_HOST_CMD_DMA_DW__TR_IN TRIG0_OUT_CPUSS_DW0_TR_IN1
#define SDIO_HOST_Internal_Clock__DIV_IDX 0
#define SDIO_HOST_Internal_Clock__DIV_NUM 0
#define SDIO_HOST_Internal_Clock__DIV_TYPE CY_SYSCLK_DIV_8_BIT
#define SDIO_HOST_Read_DMA_DW__BLOCK_HW DW1
#define SDIO_HOST_Read_DMA_DW__BLOCK_NUMBER 1u
#define SDIO_HOST_Read_DMA_DW__CHANNEL_HW DW1_CH_STRUCT3
#define SDIO_HOST_Read_DMA_DW__CHANNEL_NUMBER 3u
#define SDIO_HOST_Read_DMA_DW__TR_IN TRIG1_OUT_CPUSS_DW1_TR_IN3
#define SDIO_HOST_Resp_DMA_DW__BLOCK_HW DW0
#define SDIO_HOST_Resp_DMA_DW__BLOCK_NUMBER 0u
#define SDIO_HOST_Resp_DMA_DW__CHANNEL_HW DW0_CH_STRUCT0
#define SDIO_HOST_Resp_DMA_DW__CHANNEL_NUMBER 0u
#define SDIO_HOST_Resp_DMA_DW__TR_IN TRIG0_OUT_CPUSS_DW0_TR_IN0
#define SDIO_HOST_Write_DMA_DW__BLOCK_HW DW1
#define SDIO_HOST_Write_DMA_DW__BLOCK_NUMBER 1u
#define SDIO_HOST_Write_DMA_DW__CHANNEL_HW DW1_CH_STRUCT1
#define SDIO_HOST_Write_DMA_DW__CHANNEL_NUMBER 1u
#define SDIO_HOST_Write_DMA_DW__TR_IN TRIG1_OUT_CPUSS_DW1_TR_IN1


/***************************CMD DMA***************************************/
#define SDIO_HOST_CMD_DMA_DW_BLOCK       (0u)
#define SDIO_HOST_CMD_DMA_DW_CHANNEL     (1u)
#define SDIO_HOST_CMD_DMA_HW             (DW0)
#define SDIO_HOST_CMD_DMA_INTR_MASK      (CY_DMA_INTR_MASK)

/* Channel settings */
#define SDIO_HOST_CMD_DMA_PRIORITY       (1u)
#define SDIO_HOST_CMD_DMA_DESCRIPTOR_NUM (1u)
#define SDIO_HOST_CMD_DMA_PREEMPTABLE    (true)
#define SDIO_HOST_CMD_DMA_BUFFERABLE     (false)

extern cy_stc_dma_descriptor_config_t SDIO_HOST_CMD_DMA_CMD_DMA_Desc_config;
extern cy_stc_dma_descriptor_t SDIO_HOST_CMD_DMA_CMD_DMA_Desc;

/***************************Read DMA***************************************/
#define SDIO_HOST_Read_DMA_DW_BLOCK       (1u)
#define SDIO_HOST_Read_DMA_DW_CHANNEL     (3u)
#define SDIO_HOST_Read_DMA_HW             (DW1)
#define SDIO_HOST_Read_DMA_INTR_MASK      (CY_DMA_INTR_MASK)

/* Channel settings */
#define SDIO_HOST_Read_DMA_PRIORITY       (0u)
#define SDIO_HOST_Read_DMA_DESCRIPTOR_NUM (1u)
#define SDIO_HOST_Read_DMA_PREEMPTABLE    (false)
#define SDIO_HOST_Read_DMA_BUFFERABLE     (false)

extern cy_stc_dma_descriptor_config_t SDIO_HOST_Read_DMA_Read_DMA_Desc_config;
extern cy_stc_dma_descriptor_t SDIO_HOST_Read_DMA_Read_DMA_Desc;

/***************************Resp DMA***************************************/
#define SDIO_HOST_Resp_DMA_DW_BLOCK       (0u)
#define SDIO_HOST_Resp_DMA_DW_CHANNEL     (0u)
#define SDIO_HOST_Resp_DMA_HW             (DW0)
#define SDIO_HOST_Resp_DMA_INTR_MASK      (CY_DMA_INTR_MASK)

/* Channel settings */
#define SDIO_HOST_Resp_DMA_PRIORITY       (1u)
#define SDIO_HOST_Resp_DMA_DESCRIPTOR_NUM (1u)
#define SDIO_HOST_Resp_DMA_PREEMPTABLE    (true)
#define SDIO_HOST_Resp_DMA_BUFFERABLE     (false)

extern cy_stc_dma_descriptor_config_t SDIO_HOST_Resp_DMA_Resp_DMA_Desc_config;
extern cy_stc_dma_descriptor_t SDIO_HOST_Resp_DMA_Resp_DMA_Desc;

/***************************Write DMA***************************************/
#define SDIO_HOST_Write_DMA_DW_BLOCK       (1u)
#define SDIO_HOST_Write_DMA_DW_CHANNEL     (1u)
#define SDIO_HOST_Write_DMA_HW             (DW1)
#define SDIO_HOST_Write_DMA_INTR_MASK      (CY_DMA_INTR_MASK)

/* Channel settings */
#define SDIO_HOST_Write_DMA_PRIORITY       (0u)
#define SDIO_HOST_Write_DMA_DESCRIPTOR_NUM (1u)
#define SDIO_HOST_Write_DMA_PREEMPTABLE    (false)
#define SDIO_HOST_Write_DMA_BUFFERABLE     (true)

extern cy_stc_dma_descriptor_config_t SDIO_HOST_Write_DMA_Write_DMA_Desc_config;
extern cy_stc_dma_descriptor_t SDIO_HOST_Write_DMA_Write_DMA_Desc;

/***************************SDIO Clock**************************************/
/** The peripheral clock divider number */
#define SDIO_HOST_Internal_Clock_DIV_NUM ((uint32_t)SDIO_HOST_Internal_Clock__DIV_NUM)
/** The peripheral clock divider type */
#define SDIO_HOST_Internal_Clock_DIV_TYPE ((cy_en_divider_types_t)SDIO_HOST_Internal_Clock__DIV_TYPE)

/*Function for configuring TriggerMuxes*/
void SDIO_Host_Config_TriggerMuxes(void);

/*Function for configuring UDBs*/
void SDIO_Host_Config_UDBs(void);

/* SDIO_HOST_Read_Int */
#define SDIO_HOST_Read_Int__INTC_CORTEXM4_ASSIGNED 1
#define SDIO_HOST_Read_Int__INTC_CORTEXM4_PRIORITY 7u
#define SDIO_HOST_Read_Int__INTC_NUMBER 69u
#define SDIO_HOST_Read_Int_INTC_CORTEXM4_ASSIGNED 1
#define SDIO_HOST_Read_Int_INTC_CORTEXM4_PRIORITY 7u
#define SDIO_HOST_Read_Int_INTC_NUMBER 69u

/* SDIO_HOST_sdio_int */
#define SDIO_HOST_sdio_int__INTC_CORTEXM4_ASSIGNED 1
#define SDIO_HOST_sdio_int__INTC_CORTEXM4_PRIORITY 7u
#define SDIO_HOST_sdio_int__INTC_NUMBER 122u
#define SDIO_HOST_sdio_int_INTC_CORTEXM4_ASSIGNED 1
#define SDIO_HOST_sdio_int_INTC_CORTEXM4_PRIORITY 7u
#define SDIO_HOST_sdio_int_INTC_NUMBER 122u

/* SDIO_HOST_Write_Int */
#define SDIO_HOST_Write_Int__INTC_CORTEXM4_ASSIGNED 1
#define SDIO_HOST_Write_Int__INTC_CORTEXM4_PRIORITY 7u
#define SDIO_HOST_Write_Int__INTC_NUMBER 67u
#define SDIO_HOST_Write_Int_INTC_CORTEXM4_ASSIGNED 1
#define SDIO_HOST_Write_Int_INTC_CORTEXM4_PRIORITY 7u
#define SDIO_HOST_Write_Int_INTC_NUMBER 67u

#if defined(__cplusplus)
}
#endif

#endif /* !defined(CY_SDIO_CFG_H) */

/* [] END OF FILE */
