/***************************************************************************//**
* \file cyhal_triggers_psoc6_01.h
*
* \brief
* PSoC6_01 family HAL triggers header
*
* \note
* Generator version: 1.5.7254.19579
*
********************************************************************************
* \copyright
* Copyright 2016-2020 Cypress Semiconductor Corporation
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#ifndef _CYHAL_TRIGGERS_PSOC6_01_H_
#define _CYHAL_TRIGGERS_PSOC6_01_H_

/**
 * \addtogroup group_hal_psoc6_triggers_psoc6_01 PSOC6_01
 * \ingroup group_hal_psoc6_triggers
 * \{
 * Trigger connections for psoc6_01
 */

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

/** @brief Name of each output trigger. */
typedef enum
{
    TRIGGER_CPUSS_CTI_TR_IN0 = 0, //!< CPUSS Cross-Triggering-Interface trigger multiplexer (CTI) - cpuss.cti_tr_in[0]
    TRIGGER_CPUSS_CTI_TR_IN1 = 1, //!< CPUSS Cross-Triggering-Interface trigger multiplexer (CTI) - cpuss.cti_tr_in[1]
    TRIGGER_CPUSS_DW0_TR_IN0 = 2, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[0]
    TRIGGER_CPUSS_DW0_TR_IN1 = 3, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[1]
    TRIGGER_CPUSS_DW0_TR_IN2 = 4, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[2]
    TRIGGER_CPUSS_DW0_TR_IN3 = 5, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[3]
    TRIGGER_CPUSS_DW0_TR_IN4 = 6, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[4]
    TRIGGER_CPUSS_DW0_TR_IN5 = 7, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[5]
    TRIGGER_CPUSS_DW0_TR_IN6 = 8, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[6]
    TRIGGER_CPUSS_DW0_TR_IN7 = 9, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[7]
    TRIGGER_CPUSS_DW0_TR_IN8 = 10, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[8]
    TRIGGER_CPUSS_DW0_TR_IN9 = 11, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[9]
    TRIGGER_CPUSS_DW0_TR_IN10 = 12, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[10]
    TRIGGER_CPUSS_DW0_TR_IN11 = 13, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[11]
    TRIGGER_CPUSS_DW0_TR_IN12 = 14, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[12]
    TRIGGER_CPUSS_DW0_TR_IN13 = 15, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[13]
    TRIGGER_CPUSS_DW0_TR_IN14 = 16, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[14]
    TRIGGER_CPUSS_DW0_TR_IN15 = 17, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[15]
    TRIGGER_CPUSS_DW1_TR_IN0 = 18, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[0]
    TRIGGER_CPUSS_DW1_TR_IN1 = 19, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[1]
    TRIGGER_CPUSS_DW1_TR_IN2 = 20, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[2]
    TRIGGER_CPUSS_DW1_TR_IN3 = 21, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[3]
    TRIGGER_CPUSS_DW1_TR_IN4 = 22, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[4]
    TRIGGER_CPUSS_DW1_TR_IN5 = 23, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[5]
    TRIGGER_CPUSS_DW1_TR_IN6 = 24, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[6]
    TRIGGER_CPUSS_DW1_TR_IN7 = 25, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[7]
    TRIGGER_CPUSS_DW1_TR_IN8 = 26, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[8]
    TRIGGER_CPUSS_DW1_TR_IN9 = 27, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[9]
    TRIGGER_CPUSS_DW1_TR_IN10 = 28, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[10]
    TRIGGER_CPUSS_DW1_TR_IN11 = 29, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[11]
    TRIGGER_CPUSS_DW1_TR_IN12 = 30, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[12]
    TRIGGER_CPUSS_DW1_TR_IN13 = 31, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[13]
    TRIGGER_CPUSS_DW1_TR_IN14 = 32, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[14]
    TRIGGER_CPUSS_DW1_TR_IN15 = 33, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[15]
    TRIGGER_PASS_TR_SAR_IN = 34, //!< PASS trigger multiplexer - pass.tr_sar_in
    TRIGGER_PERI_TR_IO_OUTPUT0 = 35, //!< GPIO/HSIOM trigger multiplexer - peri.tr_io_output[0]
    TRIGGER_PERI_TR_IO_OUTPUT1 = 36, //!< GPIO/HSIOM trigger multiplexer - peri.tr_io_output[1]
    TRIGGER_PROFILE_TR_START = 37, //!< PROFILE trigger multiplexer - profile.tr_start
    TRIGGER_PROFILE_TR_STOP = 38, //!< PROFILE trigger multiplexer - profile.tr_stop
    TRIGGER_TCPWM0_TR_IN0 = 39, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[0]
    TRIGGER_TCPWM0_TR_IN1 = 40, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[1]
    TRIGGER_TCPWM0_TR_IN2 = 41, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[2]
    TRIGGER_TCPWM0_TR_IN3 = 42, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[3]
    TRIGGER_TCPWM0_TR_IN4 = 43, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[4]
    TRIGGER_TCPWM0_TR_IN5 = 44, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[5]
    TRIGGER_TCPWM0_TR_IN6 = 45, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[6]
    TRIGGER_TCPWM0_TR_IN7 = 46, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[7]
    TRIGGER_TCPWM0_TR_IN8 = 47, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[8]
    TRIGGER_TCPWM0_TR_IN9 = 48, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[9]
    TRIGGER_TCPWM0_TR_IN10 = 49, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[10]
    TRIGGER_TCPWM0_TR_IN11 = 50, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[11]
    TRIGGER_TCPWM0_TR_IN12 = 51, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[12]
    TRIGGER_TCPWM0_TR_IN13 = 52, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[13]
    TRIGGER_TCPWM1_TR_IN0 = 53, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[0]
    TRIGGER_TCPWM1_TR_IN1 = 54, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[1]
    TRIGGER_TCPWM1_TR_IN2 = 55, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[2]
    TRIGGER_TCPWM1_TR_IN3 = 56, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[3]
    TRIGGER_TCPWM1_TR_IN4 = 57, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[4]
    TRIGGER_TCPWM1_TR_IN5 = 58, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[5]
    TRIGGER_TCPWM1_TR_IN6 = 59, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[6]
    TRIGGER_TCPWM1_TR_IN7 = 60, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[7]
    TRIGGER_TCPWM1_TR_IN8 = 61, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[8]
    TRIGGER_TCPWM1_TR_IN9 = 62, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[9]
    TRIGGER_TCPWM1_TR_IN10 = 63, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[10]
    TRIGGER_TCPWM1_TR_IN11 = 64, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[11]
    TRIGGER_TCPWM1_TR_IN12 = 65, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[12]
    TRIGGER_TCPWM1_TR_IN13 = 66, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[13]
    TRIGGER_TR_GROUP0_INPUT1 = 67, //!< Datawire output trigger reduction mux - tr_group[0].input[1]
    TRIGGER_TR_GROUP0_INPUT2 = 68, //!< Datawire output trigger reduction mux - tr_group[0].input[2]
    TRIGGER_TR_GROUP0_INPUT3 = 69, //!< Datawire output trigger reduction mux - tr_group[0].input[3]
    TRIGGER_TR_GROUP0_INPUT4 = 70, //!< Datawire output trigger reduction mux - tr_group[0].input[4]
    TRIGGER_TR_GROUP0_INPUT5 = 71, //!< Datawire output trigger reduction mux - tr_group[0].input[5]
    TRIGGER_TR_GROUP0_INPUT6 = 72, //!< Datawire output trigger reduction mux - tr_group[0].input[6]
    TRIGGER_TR_GROUP0_INPUT7 = 73, //!< Datawire output trigger reduction mux - tr_group[0].input[7]
    TRIGGER_TR_GROUP0_INPUT8 = 74, //!< Datawire output trigger reduction mux - tr_group[0].input[8]
    TRIGGER_TR_GROUP0_INPUT9 = 75, //!< TCPWM trigger output reduction mux - tr_group[0].input[9]
    TRIGGER_TR_GROUP0_INPUT10 = 76, //!< TCPWM trigger output reduction mux - tr_group[0].input[10]
    TRIGGER_TR_GROUP0_INPUT11 = 77, //!< TCPWM trigger output reduction mux - tr_group[0].input[11]
    TRIGGER_TR_GROUP0_INPUT12 = 78, //!< TCPWM trigger output reduction mux - tr_group[0].input[12]
    TRIGGER_TR_GROUP0_INPUT13 = 79, //!< TCPWM trigger output reduction mux - tr_group[0].input[13]
    TRIGGER_TR_GROUP0_INPUT14 = 80, //!< TCPWM trigger output reduction mux - tr_group[0].input[14]
    TRIGGER_TR_GROUP0_INPUT15 = 81, //!< TCPWM trigger output reduction mux - tr_group[0].input[15]
    TRIGGER_TR_GROUP0_INPUT16 = 82, //!< TCPWM trigger output reduction mux - tr_group[0].input[16]
    TRIGGER_TR_GROUP0_INPUT17 = 83, //!< TCPWM trigger output reduction mux - tr_group[0].input[17]
    TRIGGER_TR_GROUP0_INPUT18 = 84, //!< TCPWM trigger output reduction mux - tr_group[0].input[18]
    TRIGGER_TR_GROUP0_INPUT19 = 85, //!< TCPWM trigger output reduction mux - tr_group[0].input[19]
    TRIGGER_TR_GROUP0_INPUT20 = 86, //!< TCPWM trigger output reduction mux - tr_group[0].input[20]
    TRIGGER_TR_GROUP0_INPUT21 = 87, //!< TCPWM trigger output reduction mux - tr_group[0].input[21]
    TRIGGER_TR_GROUP0_INPUT22 = 88, //!< TCPWM trigger output reduction mux - tr_group[0].input[22]
    TRIGGER_TR_GROUP0_INPUT23 = 89, //!< TCPWM trigger output reduction mux - tr_group[0].input[23]
    TRIGGER_TR_GROUP0_INPUT24 = 90, //!< TCPWM trigger output reduction mux - tr_group[0].input[24]
    TRIGGER_TR_GROUP0_INPUT25 = 91, //!< HSIOM Pin input reduction mux - tr_group[0].input[25]
    TRIGGER_TR_GROUP0_INPUT26 = 92, //!< HSIOM Pin input reduction mux - tr_group[0].input[26]
    TRIGGER_TR_GROUP0_INPUT27 = 93, //!< DMA request reduction mux - tr_group[0].input[27]
    TRIGGER_TR_GROUP0_INPUT28 = 94, //!< DMA request reduction mux - tr_group[0].input[28]
    TRIGGER_TR_GROUP0_INPUT29 = 95, //!< DMA request reduction mux - tr_group[0].input[29]
    TRIGGER_TR_GROUP0_INPUT30 = 96, //!< DMA request reduction mux - tr_group[0].input[30]
    TRIGGER_TR_GROUP0_INPUT31 = 97, //!< DMA request reduction mux - tr_group[0].input[31]
    TRIGGER_TR_GROUP0_INPUT32 = 98, //!< DMA request reduction mux - tr_group[0].input[32]
    TRIGGER_TR_GROUP0_INPUT33 = 99, //!< DMA request reduction mux - tr_group[0].input[33]
    TRIGGER_TR_GROUP0_INPUT34 = 100, //!< DMA request reduction mux - tr_group[0].input[34]
    TRIGGER_TR_GROUP0_INPUT35 = 101, //!< DMA request reduction mux - tr_group[0].input[35]
    TRIGGER_TR_GROUP0_INPUT36 = 102, //!< DMA request reduction mux - tr_group[0].input[36]
    TRIGGER_TR_GROUP0_INPUT37 = 103, //!< DMA request reduction mux - tr_group[0].input[37]
    TRIGGER_TR_GROUP0_INPUT38 = 104, //!< DMA request reduction mux - tr_group[0].input[38]
    TRIGGER_TR_GROUP0_INPUT39 = 105, //!< DMA request reduction mux - tr_group[0].input[39]
    TRIGGER_TR_GROUP0_INPUT40 = 106, //!< DMA request reduction mux - tr_group[0].input[40]
    TRIGGER_TR_GROUP0_INPUT41 = 107, //!< DMA request reduction mux - tr_group[0].input[41]
    TRIGGER_TR_GROUP0_INPUT42 = 108, //!< DMA request reduction mux - tr_group[0].input[42]
    TRIGGER_TR_GROUP0_INPUT43 = 109, //!< Trigger input reduction mux - tr_group[0].input[43]
    TRIGGER_TR_GROUP0_INPUT44 = 110, //!< Trigger input reduction mux - tr_group[0].input[44]
    TRIGGER_TR_GROUP0_INPUT45 = 111, //!< Trigger input reduction mux - tr_group[0].input[45]
    TRIGGER_TR_GROUP0_INPUT46 = 112, //!< Trigger input reduction mux - tr_group[0].input[46]
    TRIGGER_TR_GROUP0_INPUT47 = 113, //!< Trigger input reduction mux - tr_group[0].input[47]
    TRIGGER_TR_GROUP0_INPUT48 = 114, //!< Trigger input reduction mux - tr_group[0].input[48]
    TRIGGER_TR_GROUP0_INPUT49 = 115, //!< Trigger input reduction mux - tr_group[0].input[49]
    TRIGGER_TR_GROUP0_INPUT50 = 116, //!< Trigger input reduction mux - tr_group[0].input[50]
    TRIGGER_TR_GROUP1_INPUT1 = 117, //!< Datawire output trigger reduction mux - tr_group[1].input[1]
    TRIGGER_TR_GROUP1_INPUT2 = 118, //!< Datawire output trigger reduction mux - tr_group[1].input[2]
    TRIGGER_TR_GROUP1_INPUT3 = 119, //!< Datawire output trigger reduction mux - tr_group[1].input[3]
    TRIGGER_TR_GROUP1_INPUT4 = 120, //!< Datawire output trigger reduction mux - tr_group[1].input[4]
    TRIGGER_TR_GROUP1_INPUT5 = 121, //!< Datawire output trigger reduction mux - tr_group[1].input[5]
    TRIGGER_TR_GROUP1_INPUT6 = 122, //!< Datawire output trigger reduction mux - tr_group[1].input[6]
    TRIGGER_TR_GROUP1_INPUT7 = 123, //!< Datawire output trigger reduction mux - tr_group[1].input[7]
    TRIGGER_TR_GROUP1_INPUT8 = 124, //!< Datawire output trigger reduction mux - tr_group[1].input[8]
    TRIGGER_TR_GROUP1_INPUT9 = 125, //!< TCPWM trigger output reduction mux - tr_group[1].input[9]
    TRIGGER_TR_GROUP1_INPUT10 = 126, //!< TCPWM trigger output reduction mux - tr_group[1].input[10]
    TRIGGER_TR_GROUP1_INPUT11 = 127, //!< TCPWM trigger output reduction mux - tr_group[1].input[11]
    TRIGGER_TR_GROUP1_INPUT12 = 128, //!< TCPWM trigger output reduction mux - tr_group[1].input[12]
    TRIGGER_TR_GROUP1_INPUT13 = 129, //!< TCPWM trigger output reduction mux - tr_group[1].input[13]
    TRIGGER_TR_GROUP1_INPUT14 = 130, //!< TCPWM trigger output reduction mux - tr_group[1].input[14]
    TRIGGER_TR_GROUP1_INPUT15 = 131, //!< TCPWM trigger output reduction mux - tr_group[1].input[15]
    TRIGGER_TR_GROUP1_INPUT16 = 132, //!< TCPWM trigger output reduction mux - tr_group[1].input[16]
    TRIGGER_TR_GROUP1_INPUT17 = 133, //!< TCPWM trigger output reduction mux - tr_group[1].input[17]
    TRIGGER_TR_GROUP1_INPUT18 = 134, //!< TCPWM trigger output reduction mux - tr_group[1].input[18]
    TRIGGER_TR_GROUP1_INPUT19 = 135, //!< TCPWM trigger output reduction mux - tr_group[1].input[19]
    TRIGGER_TR_GROUP1_INPUT20 = 136, //!< TCPWM trigger output reduction mux - tr_group[1].input[20]
    TRIGGER_TR_GROUP1_INPUT21 = 137, //!< TCPWM trigger output reduction mux - tr_group[1].input[21]
    TRIGGER_TR_GROUP1_INPUT22 = 138, //!< TCPWM trigger output reduction mux - tr_group[1].input[22]
    TRIGGER_TR_GROUP1_INPUT23 = 139, //!< TCPWM trigger output reduction mux - tr_group[1].input[23]
    TRIGGER_TR_GROUP1_INPUT24 = 140, //!< TCPWM trigger output reduction mux - tr_group[1].input[24]
    TRIGGER_TR_GROUP1_INPUT25 = 141, //!< HSIOM Pin input reduction mux - tr_group[1].input[25]
    TRIGGER_TR_GROUP1_INPUT26 = 142, //!< HSIOM Pin input reduction mux - tr_group[1].input[26]
    TRIGGER_TR_GROUP1_INPUT27 = 143, //!< DMA request reduction mux - tr_group[1].input[27]
    TRIGGER_TR_GROUP1_INPUT28 = 144, //!< DMA request reduction mux - tr_group[1].input[28]
    TRIGGER_TR_GROUP1_INPUT29 = 145, //!< DMA request reduction mux - tr_group[1].input[29]
    TRIGGER_TR_GROUP1_INPUT30 = 146, //!< DMA request reduction mux - tr_group[1].input[30]
    TRIGGER_TR_GROUP1_INPUT31 = 147, //!< DMA request reduction mux - tr_group[1].input[31]
    TRIGGER_TR_GROUP1_INPUT32 = 148, //!< DMA request reduction mux - tr_group[1].input[32]
    TRIGGER_TR_GROUP1_INPUT33 = 149, //!< DMA request reduction mux - tr_group[1].input[33]
    TRIGGER_TR_GROUP1_INPUT34 = 150, //!< DMA request reduction mux - tr_group[1].input[34]
    TRIGGER_TR_GROUP1_INPUT35 = 151, //!< DMA request reduction mux - tr_group[1].input[35]
    TRIGGER_TR_GROUP1_INPUT36 = 152, //!< DMA request reduction mux - tr_group[1].input[36]
    TRIGGER_TR_GROUP1_INPUT37 = 153, //!< DMA request reduction mux - tr_group[1].input[37]
    TRIGGER_TR_GROUP1_INPUT38 = 154, //!< DMA request reduction mux - tr_group[1].input[38]
    TRIGGER_TR_GROUP1_INPUT39 = 155, //!< DMA request reduction mux - tr_group[1].input[39]
    TRIGGER_TR_GROUP1_INPUT40 = 156, //!< DMA request reduction mux - tr_group[1].input[40]
    TRIGGER_TR_GROUP1_INPUT41 = 157, //!< DMA request reduction mux - tr_group[1].input[41]
    TRIGGER_TR_GROUP1_INPUT42 = 158, //!< DMA request reduction mux - tr_group[1].input[42]
    TRIGGER_TR_GROUP1_INPUT43 = 159, //!< Trigger input reduction mux - tr_group[1].input[43]
    TRIGGER_TR_GROUP1_INPUT44 = 160, //!< Trigger input reduction mux - tr_group[1].input[44]
    TRIGGER_TR_GROUP1_INPUT45 = 161, //!< Trigger input reduction mux - tr_group[1].input[45]
    TRIGGER_TR_GROUP1_INPUT46 = 162, //!< Trigger input reduction mux - tr_group[1].input[46]
    TRIGGER_TR_GROUP1_INPUT47 = 163, //!< Trigger input reduction mux - tr_group[1].input[47]
    TRIGGER_TR_GROUP1_INPUT48 = 164, //!< Trigger input reduction mux - tr_group[1].input[48]
    TRIGGER_TR_GROUP1_INPUT49 = 165, //!< Trigger input reduction mux - tr_group[1].input[49]
    TRIGGER_TR_GROUP1_INPUT50 = 166, //!< Trigger input reduction mux - tr_group[1].input[50]
    TRIGGER_TR_GROUP2_INPUT1 = 167, //!< Datawire output trigger reduction mux - tr_group[2].input[1]
    TRIGGER_TR_GROUP2_INPUT2 = 168, //!< Datawire output trigger reduction mux - tr_group[2].input[2]
    TRIGGER_TR_GROUP2_INPUT3 = 169, //!< Datawire output trigger reduction mux - tr_group[2].input[3]
    TRIGGER_TR_GROUP2_INPUT4 = 170, //!< Datawire output trigger reduction mux - tr_group[2].input[4]
    TRIGGER_TR_GROUP2_INPUT5 = 171, //!< Datawire output trigger reduction mux - tr_group[2].input[5]
    TRIGGER_TR_GROUP2_INPUT6 = 172, //!< Datawire output trigger reduction mux - tr_group[2].input[6]
    TRIGGER_TR_GROUP2_INPUT7 = 173, //!< Datawire output trigger reduction mux - tr_group[2].input[7]
    TRIGGER_TR_GROUP2_INPUT8 = 174, //!< Datawire output trigger reduction mux - tr_group[2].input[8]
    TRIGGER_TR_GROUP2_INPUT9 = 175, //!< TCPWM trigger output reduction mux - tr_group[2].input[9]
    TRIGGER_TR_GROUP2_INPUT10 = 176, //!< TCPWM trigger output reduction mux - tr_group[2].input[10]
    TRIGGER_TR_GROUP2_INPUT11 = 177, //!< TCPWM trigger output reduction mux - tr_group[2].input[11]
    TRIGGER_TR_GROUP2_INPUT12 = 178, //!< TCPWM trigger output reduction mux - tr_group[2].input[12]
    TRIGGER_TR_GROUP2_INPUT13 = 179, //!< TCPWM trigger output reduction mux - tr_group[2].input[13]
    TRIGGER_TR_GROUP2_INPUT14 = 180, //!< TCPWM trigger output reduction mux - tr_group[2].input[14]
    TRIGGER_TR_GROUP2_INPUT15 = 181, //!< TCPWM trigger output reduction mux - tr_group[2].input[15]
    TRIGGER_TR_GROUP2_INPUT16 = 182, //!< TCPWM trigger output reduction mux - tr_group[2].input[16]
    TRIGGER_TR_GROUP2_INPUT17 = 183, //!< TCPWM trigger output reduction mux - tr_group[2].input[17]
    TRIGGER_TR_GROUP2_INPUT18 = 184, //!< TCPWM trigger output reduction mux - tr_group[2].input[18]
    TRIGGER_TR_GROUP2_INPUT19 = 185, //!< TCPWM trigger output reduction mux - tr_group[2].input[19]
    TRIGGER_TR_GROUP2_INPUT20 = 186, //!< TCPWM trigger output reduction mux - tr_group[2].input[20]
    TRIGGER_TR_GROUP2_INPUT21 = 187, //!< TCPWM trigger output reduction mux - tr_group[2].input[21]
    TRIGGER_TR_GROUP2_INPUT22 = 188, //!< TCPWM trigger output reduction mux - tr_group[2].input[22]
    TRIGGER_TR_GROUP2_INPUT23 = 189, //!< TCPWM trigger output reduction mux - tr_group[2].input[23]
    TRIGGER_TR_GROUP2_INPUT24 = 190, //!< TCPWM trigger output reduction mux - tr_group[2].input[24]
    TRIGGER_TR_GROUP2_INPUT25 = 191, //!< HSIOM Pin input reduction mux - tr_group[2].input[25]
    TRIGGER_TR_GROUP2_INPUT26 = 192, //!< HSIOM Pin input reduction mux - tr_group[2].input[26]
    TRIGGER_TR_GROUP2_INPUT27 = 193, //!< HSIOM Pin input reduction mux - tr_group[2].input[27]
    TRIGGER_TR_GROUP2_INPUT28 = 194, //!< HSIOM Pin input reduction mux - tr_group[2].input[28]
    TRIGGER_TR_GROUP2_INPUT29 = 195, //!< HSIOM Pin input reduction mux - tr_group[2].input[29]
    TRIGGER_TR_GROUP2_INPUT30 = 196, //!< HSIOM Pin input reduction mux - tr_group[2].input[30]
    TRIGGER_TR_GROUP2_INPUT31 = 197, //!< HSIOM Pin input reduction mux - tr_group[2].input[31]
    TRIGGER_TR_GROUP2_INPUT32 = 198, //!< HSIOM Pin input reduction mux - tr_group[2].input[32]
    TRIGGER_TR_GROUP2_INPUT33 = 199, //!< DMA request reduction mux - tr_group[2].input[33]
    TRIGGER_TR_GROUP2_INPUT34 = 200, //!< DMA request reduction mux - tr_group[2].input[34]
    TRIGGER_TR_GROUP2_INPUT35 = 201, //!< Trigger input reduction mux - tr_group[2].input[35]
    TRIGGER_TR_GROUP2_INPUT36 = 202, //!< Trigger input reduction mux - tr_group[2].input[36]
    TRIGGER_TR_GROUP2_INPUT37 = 203, //!< Trigger input reduction mux - tr_group[2].input[37]
    TRIGGER_TR_GROUP2_INPUT38 = 204, //!< Trigger input reduction mux - tr_group[2].input[38]
    TRIGGER_TR_GROUP2_INPUT39 = 205, //!< Trigger input reduction mux - tr_group[2].input[39]
    TRIGGER_TR_GROUP2_INPUT40 = 206, //!< Trigger input reduction mux - tr_group[2].input[40]
    TRIGGER_TR_GROUP2_INPUT41 = 207, //!< Trigger input reduction mux - tr_group[2].input[41]
    TRIGGER_TR_GROUP2_INPUT42 = 208, //!< Trigger input reduction mux - tr_group[2].input[42]
    TRIGGER_TR_GROUP3_INPUT1 = 209, //!< Datawire output trigger reduction mux - tr_group[3].input[1]
    TRIGGER_TR_GROUP3_INPUT2 = 210, //!< Datawire output trigger reduction mux - tr_group[3].input[2]
    TRIGGER_TR_GROUP3_INPUT3 = 211, //!< Datawire output trigger reduction mux - tr_group[3].input[3]
    TRIGGER_TR_GROUP3_INPUT4 = 212, //!< Datawire output trigger reduction mux - tr_group[3].input[4]
    TRIGGER_TR_GROUP3_INPUT5 = 213, //!< Datawire output trigger reduction mux - tr_group[3].input[5]
    TRIGGER_TR_GROUP3_INPUT6 = 214, //!< Datawire output trigger reduction mux - tr_group[3].input[6]
    TRIGGER_TR_GROUP3_INPUT7 = 215, //!< Datawire output trigger reduction mux - tr_group[3].input[7]
    TRIGGER_TR_GROUP3_INPUT8 = 216, //!< Datawire output trigger reduction mux - tr_group[3].input[8]
    TRIGGER_TR_GROUP3_INPUT9 = 217, //!< TCPWM trigger output reduction mux - tr_group[3].input[9]
    TRIGGER_TR_GROUP3_INPUT10 = 218, //!< TCPWM trigger output reduction mux - tr_group[3].input[10]
    TRIGGER_TR_GROUP3_INPUT11 = 219, //!< TCPWM trigger output reduction mux - tr_group[3].input[11]
    TRIGGER_TR_GROUP3_INPUT12 = 220, //!< TCPWM trigger output reduction mux - tr_group[3].input[12]
    TRIGGER_TR_GROUP3_INPUT13 = 221, //!< TCPWM trigger output reduction mux - tr_group[3].input[13]
    TRIGGER_TR_GROUP3_INPUT14 = 222, //!< TCPWM trigger output reduction mux - tr_group[3].input[14]
    TRIGGER_TR_GROUP3_INPUT15 = 223, //!< TCPWM trigger output reduction mux - tr_group[3].input[15]
    TRIGGER_TR_GROUP3_INPUT16 = 224, //!< TCPWM trigger output reduction mux - tr_group[3].input[16]
    TRIGGER_TR_GROUP3_INPUT17 = 225, //!< TCPWM trigger output reduction mux - tr_group[3].input[17]
    TRIGGER_TR_GROUP3_INPUT18 = 226, //!< TCPWM trigger output reduction mux - tr_group[3].input[18]
    TRIGGER_TR_GROUP3_INPUT19 = 227, //!< TCPWM trigger output reduction mux - tr_group[3].input[19]
    TRIGGER_TR_GROUP3_INPUT20 = 228, //!< TCPWM trigger output reduction mux - tr_group[3].input[20]
    TRIGGER_TR_GROUP3_INPUT21 = 229, //!< TCPWM trigger output reduction mux - tr_group[3].input[21]
    TRIGGER_TR_GROUP3_INPUT22 = 230, //!< TCPWM trigger output reduction mux - tr_group[3].input[22]
    TRIGGER_TR_GROUP3_INPUT23 = 231, //!< TCPWM trigger output reduction mux - tr_group[3].input[23]
    TRIGGER_TR_GROUP3_INPUT24 = 232, //!< TCPWM trigger output reduction mux - tr_group[3].input[24]
    TRIGGER_TR_GROUP3_INPUT25 = 233, //!< HSIOM Pin input reduction mux - tr_group[3].input[25]
    TRIGGER_TR_GROUP3_INPUT26 = 234, //!< HSIOM Pin input reduction mux - tr_group[3].input[26]
    TRIGGER_TR_GROUP3_INPUT27 = 235, //!< HSIOM Pin input reduction mux - tr_group[3].input[27]
    TRIGGER_TR_GROUP3_INPUT28 = 236, //!< HSIOM Pin input reduction mux - tr_group[3].input[28]
    TRIGGER_TR_GROUP3_INPUT29 = 237, //!< HSIOM Pin input reduction mux - tr_group[3].input[29]
    TRIGGER_TR_GROUP3_INPUT30 = 238, //!< HSIOM Pin input reduction mux - tr_group[3].input[30]
    TRIGGER_TR_GROUP3_INPUT31 = 239, //!< HSIOM Pin input reduction mux - tr_group[3].input[31]
    TRIGGER_TR_GROUP3_INPUT32 = 240, //!< HSIOM Pin input reduction mux - tr_group[3].input[32]
    TRIGGER_TR_GROUP3_INPUT33 = 241, //!< DMA request reduction mux - tr_group[3].input[33]
    TRIGGER_TR_GROUP3_INPUT34 = 242, //!< DMA request reduction mux - tr_group[3].input[34]
    TRIGGER_TR_GROUP3_INPUT35 = 243, //!< Trigger input reduction mux - tr_group[3].input[35]
    TRIGGER_TR_GROUP3_INPUT36 = 244, //!< Trigger input reduction mux - tr_group[3].input[36]
    TRIGGER_TR_GROUP3_INPUT37 = 245, //!< Trigger input reduction mux - tr_group[3].input[37]
    TRIGGER_TR_GROUP3_INPUT38 = 246, //!< Trigger input reduction mux - tr_group[3].input[38]
    TRIGGER_TR_GROUP3_INPUT39 = 247, //!< Trigger input reduction mux - tr_group[3].input[39]
    TRIGGER_TR_GROUP3_INPUT40 = 248, //!< Trigger input reduction mux - tr_group[3].input[40]
    TRIGGER_TR_GROUP3_INPUT41 = 249, //!< Trigger input reduction mux - tr_group[3].input[41]
    TRIGGER_TR_GROUP3_INPUT42 = 250, //!< Trigger input reduction mux - tr_group[3].input[42]
    TRIGGER_TR_GROUP4_INPUT1 = 251, //!< Datawire output trigger reduction mux - tr_group[4].input[1]
    TRIGGER_TR_GROUP4_INPUT2 = 252, //!< Datawire output trigger reduction mux - tr_group[4].input[2]
    TRIGGER_TR_GROUP4_INPUT3 = 253, //!< Datawire output trigger reduction mux - tr_group[4].input[3]
    TRIGGER_TR_GROUP4_INPUT4 = 254, //!< Datawire output trigger reduction mux - tr_group[4].input[4]
    TRIGGER_TR_GROUP4_INPUT5 = 255, //!< Datawire output trigger reduction mux - tr_group[4].input[5]
    TRIGGER_TR_GROUP4_INPUT6 = 256, //!< Datawire output trigger reduction mux - tr_group[4].input[6]
    TRIGGER_TR_GROUP4_INPUT7 = 257, //!< Datawire output trigger reduction mux - tr_group[4].input[7]
    TRIGGER_TR_GROUP4_INPUT8 = 258, //!< Datawire output trigger reduction mux - tr_group[4].input[8]
    TRIGGER_TR_GROUP4_INPUT9 = 259, //!< TCPWM trigger output reduction mux - tr_group[4].input[9]
    TRIGGER_TR_GROUP4_INPUT10 = 260, //!< TCPWM trigger output reduction mux - tr_group[4].input[10]
    TRIGGER_TR_GROUP4_INPUT11 = 261, //!< TCPWM trigger output reduction mux - tr_group[4].input[11]
    TRIGGER_TR_GROUP4_INPUT12 = 262, //!< TCPWM trigger output reduction mux - tr_group[4].input[12]
    TRIGGER_TR_GROUP4_INPUT13 = 263, //!< TCPWM trigger output reduction mux - tr_group[4].input[13]
    TRIGGER_TR_GROUP4_INPUT14 = 264, //!< TCPWM trigger output reduction mux - tr_group[4].input[14]
    TRIGGER_TR_GROUP4_INPUT15 = 265, //!< TCPWM trigger output reduction mux - tr_group[4].input[15]
    TRIGGER_TR_GROUP4_INPUT16 = 266, //!< TCPWM trigger output reduction mux - tr_group[4].input[16]
    TRIGGER_TR_GROUP4_INPUT17 = 267, //!< TCPWM trigger output reduction mux - tr_group[4].input[17]
    TRIGGER_TR_GROUP4_INPUT18 = 268, //!< TCPWM trigger output reduction mux - tr_group[4].input[18]
    TRIGGER_TR_GROUP4_INPUT19 = 269, //!< TCPWM trigger output reduction mux - tr_group[4].input[19]
    TRIGGER_TR_GROUP4_INPUT20 = 270, //!< TCPWM trigger output reduction mux - tr_group[4].input[20]
    TRIGGER_TR_GROUP4_INPUT21 = 271, //!< TCPWM trigger output reduction mux - tr_group[4].input[21]
    TRIGGER_TR_GROUP4_INPUT22 = 272, //!< TCPWM trigger output reduction mux - tr_group[4].input[22]
    TRIGGER_TR_GROUP4_INPUT23 = 273, //!< TCPWM trigger output reduction mux - tr_group[4].input[23]
    TRIGGER_TR_GROUP4_INPUT24 = 274, //!< TCPWM trigger output reduction mux - tr_group[4].input[24]
    TRIGGER_TR_GROUP4_INPUT25 = 275, //!< HSIOM Pin input reduction mux - tr_group[4].input[25]
    TRIGGER_TR_GROUP4_INPUT26 = 276, //!< HSIOM Pin input reduction mux - tr_group[4].input[26]
    TRIGGER_TR_GROUP4_INPUT27 = 277, //!< HSIOM Pin input reduction mux - tr_group[4].input[27]
    TRIGGER_TR_GROUP4_INPUT28 = 278, //!< HSIOM Pin input reduction mux - tr_group[4].input[28]
    TRIGGER_TR_GROUP4_INPUT29 = 279, //!< HSIOM Pin input reduction mux - tr_group[4].input[29]
    TRIGGER_TR_GROUP4_INPUT30 = 280, //!< HSIOM Pin input reduction mux - tr_group[4].input[30]
    TRIGGER_TR_GROUP4_INPUT31 = 281, //!< HSIOM Pin input reduction mux - tr_group[4].input[31]
    TRIGGER_TR_GROUP4_INPUT32 = 282, //!< HSIOM Pin input reduction mux - tr_group[4].input[32]
    TRIGGER_TR_GROUP4_INPUT33 = 283, //!< DMA request reduction mux - tr_group[4].input[33]
    TRIGGER_TR_GROUP4_INPUT34 = 284, //!< DMA request reduction mux - tr_group[4].input[34]
    TRIGGER_TR_GROUP4_INPUT35 = 285, //!< Trigger input reduction mux - tr_group[4].input[35]
    TRIGGER_TR_GROUP4_INPUT36 = 286, //!< Trigger input reduction mux - tr_group[4].input[36]
    TRIGGER_TR_GROUP4_INPUT37 = 287, //!< Trigger input reduction mux - tr_group[4].input[37]
    TRIGGER_TR_GROUP4_INPUT38 = 288, //!< Trigger input reduction mux - tr_group[4].input[38]
    TRIGGER_TR_GROUP4_INPUT39 = 289, //!< Trigger input reduction mux - tr_group[4].input[39]
    TRIGGER_TR_GROUP4_INPUT40 = 290, //!< Trigger input reduction mux - tr_group[4].input[40]
    TRIGGER_TR_GROUP4_INPUT41 = 291, //!< Trigger input reduction mux - tr_group[4].input[41]
    TRIGGER_TR_GROUP4_INPUT42 = 292, //!< Trigger input reduction mux - tr_group[4].input[42]
    TRIGGER_TR_GROUP5_INPUT1 = 293, //!< Datawire output trigger reduction mux - tr_group[5].input[1]
    TRIGGER_TR_GROUP5_INPUT2 = 294, //!< Datawire output trigger reduction mux - tr_group[5].input[2]
    TRIGGER_TR_GROUP5_INPUT3 = 295, //!< Datawire output trigger reduction mux - tr_group[5].input[3]
    TRIGGER_TR_GROUP5_INPUT4 = 296, //!< Datawire output trigger reduction mux - tr_group[5].input[4]
    TRIGGER_TR_GROUP5_INPUT5 = 297, //!< Datawire output trigger reduction mux - tr_group[5].input[5]
    TRIGGER_TR_GROUP5_INPUT6 = 298, //!< Datawire output trigger reduction mux - tr_group[5].input[6]
    TRIGGER_TR_GROUP5_INPUT7 = 299, //!< Datawire output trigger reduction mux - tr_group[5].input[7]
    TRIGGER_TR_GROUP5_INPUT8 = 300, //!< Datawire output trigger reduction mux - tr_group[5].input[8]
    TRIGGER_TR_GROUP5_INPUT9 = 301, //!< TCPWM trigger output reduction mux - tr_group[5].input[9]
    TRIGGER_TR_GROUP5_INPUT10 = 302, //!< TCPWM trigger output reduction mux - tr_group[5].input[10]
    TRIGGER_TR_GROUP5_INPUT11 = 303, //!< TCPWM trigger output reduction mux - tr_group[5].input[11]
    TRIGGER_TR_GROUP5_INPUT12 = 304, //!< TCPWM trigger output reduction mux - tr_group[5].input[12]
    TRIGGER_TR_GROUP5_INPUT13 = 305, //!< TCPWM trigger output reduction mux - tr_group[5].input[13]
    TRIGGER_TR_GROUP5_INPUT14 = 306, //!< TCPWM trigger output reduction mux - tr_group[5].input[14]
    TRIGGER_TR_GROUP5_INPUT15 = 307, //!< TCPWM trigger output reduction mux - tr_group[5].input[15]
    TRIGGER_TR_GROUP5_INPUT16 = 308, //!< TCPWM trigger output reduction mux - tr_group[5].input[16]
    TRIGGER_TR_GROUP5_INPUT17 = 309, //!< TCPWM trigger output reduction mux - tr_group[5].input[17]
    TRIGGER_TR_GROUP5_INPUT18 = 310, //!< TCPWM trigger output reduction mux - tr_group[5].input[18]
    TRIGGER_TR_GROUP5_INPUT19 = 311, //!< TCPWM trigger output reduction mux - tr_group[5].input[19]
    TRIGGER_TR_GROUP5_INPUT20 = 312, //!< TCPWM trigger output reduction mux - tr_group[5].input[20]
    TRIGGER_TR_GROUP5_INPUT21 = 313, //!< TCPWM trigger output reduction mux - tr_group[5].input[21]
    TRIGGER_TR_GROUP5_INPUT22 = 314, //!< TCPWM trigger output reduction mux - tr_group[5].input[22]
    TRIGGER_TR_GROUP5_INPUT23 = 315, //!< TCPWM trigger output reduction mux - tr_group[5].input[23]
    TRIGGER_TR_GROUP5_INPUT24 = 316, //!< TCPWM trigger output reduction mux - tr_group[5].input[24]
    TRIGGER_TR_GROUP5_INPUT25 = 317, //!< HSIOM Pin input reduction mux - tr_group[5].input[25]
    TRIGGER_TR_GROUP5_INPUT26 = 318, //!< HSIOM Pin input reduction mux - tr_group[5].input[26]
    TRIGGER_TR_GROUP5_INPUT27 = 319, //!< HSIOM Pin input reduction mux - tr_group[5].input[27]
    TRIGGER_TR_GROUP5_INPUT28 = 320, //!< HSIOM Pin input reduction mux - tr_group[5].input[28]
    TRIGGER_TR_GROUP5_INPUT29 = 321, //!< HSIOM Pin input reduction mux - tr_group[5].input[29]
    TRIGGER_TR_GROUP5_INPUT30 = 322, //!< HSIOM Pin input reduction mux - tr_group[5].input[30]
    TRIGGER_TR_GROUP5_INPUT31 = 323, //!< HSIOM Pin input reduction mux - tr_group[5].input[31]
    TRIGGER_TR_GROUP5_INPUT32 = 324, //!< HSIOM Pin input reduction mux - tr_group[5].input[32]
    TRIGGER_TR_GROUP5_INPUT33 = 325, //!< DMA request reduction mux - tr_group[5].input[33]
    TRIGGER_TR_GROUP5_INPUT34 = 326, //!< DMA request reduction mux - tr_group[5].input[34]
    TRIGGER_TR_GROUP5_INPUT35 = 327, //!< Trigger input reduction mux - tr_group[5].input[35]
    TRIGGER_TR_GROUP5_INPUT36 = 328, //!< Trigger input reduction mux - tr_group[5].input[36]
    TRIGGER_TR_GROUP5_INPUT37 = 329, //!< Trigger input reduction mux - tr_group[5].input[37]
    TRIGGER_TR_GROUP5_INPUT38 = 330, //!< Trigger input reduction mux - tr_group[5].input[38]
    TRIGGER_TR_GROUP5_INPUT39 = 331, //!< Trigger input reduction mux - tr_group[5].input[39]
    TRIGGER_TR_GROUP5_INPUT40 = 332, //!< Trigger input reduction mux - tr_group[5].input[40]
    TRIGGER_TR_GROUP5_INPUT41 = 333, //!< Trigger input reduction mux - tr_group[5].input[41]
    TRIGGER_TR_GROUP5_INPUT42 = 334, //!< Trigger input reduction mux - tr_group[5].input[42]
    TRIGGER_TR_GROUP6_INPUT1 = 335, //!< Datawire output trigger reduction mux - tr_group[6].input[1]
    TRIGGER_TR_GROUP6_INPUT2 = 336, //!< Datawire output trigger reduction mux - tr_group[6].input[2]
    TRIGGER_TR_GROUP6_INPUT3 = 337, //!< Datawire output trigger reduction mux - tr_group[6].input[3]
    TRIGGER_TR_GROUP6_INPUT4 = 338, //!< Datawire output trigger reduction mux - tr_group[6].input[4]
    TRIGGER_TR_GROUP6_INPUT5 = 339, //!< Datawire output trigger reduction mux - tr_group[6].input[5]
    TRIGGER_TR_GROUP6_INPUT6 = 340, //!< Datawire output trigger reduction mux - tr_group[6].input[6]
    TRIGGER_TR_GROUP6_INPUT7 = 341, //!< Datawire output trigger reduction mux - tr_group[6].input[7]
    TRIGGER_TR_GROUP6_INPUT8 = 342, //!< Datawire output trigger reduction mux - tr_group[6].input[8]
    TRIGGER_TR_GROUP6_INPUT9 = 343, //!< TCPWM trigger output reduction mux - tr_group[6].input[9]
    TRIGGER_TR_GROUP6_INPUT10 = 344, //!< TCPWM trigger output reduction mux - tr_group[6].input[10]
    TRIGGER_TR_GROUP6_INPUT11 = 345, //!< TCPWM trigger output reduction mux - tr_group[6].input[11]
    TRIGGER_TR_GROUP6_INPUT12 = 346, //!< TCPWM trigger output reduction mux - tr_group[6].input[12]
    TRIGGER_TR_GROUP6_INPUT13 = 347, //!< TCPWM trigger output reduction mux - tr_group[6].input[13]
    TRIGGER_TR_GROUP6_INPUT14 = 348, //!< TCPWM trigger output reduction mux - tr_group[6].input[14]
    TRIGGER_TR_GROUP6_INPUT15 = 349, //!< TCPWM trigger output reduction mux - tr_group[6].input[15]
    TRIGGER_TR_GROUP6_INPUT16 = 350, //!< TCPWM trigger output reduction mux - tr_group[6].input[16]
    TRIGGER_TR_GROUP6_INPUT17 = 351, //!< TCPWM trigger output reduction mux - tr_group[6].input[17]
    TRIGGER_TR_GROUP6_INPUT18 = 352, //!< TCPWM trigger output reduction mux - tr_group[6].input[18]
    TRIGGER_TR_GROUP6_INPUT19 = 353, //!< TCPWM trigger output reduction mux - tr_group[6].input[19]
    TRIGGER_TR_GROUP6_INPUT20 = 354, //!< TCPWM trigger output reduction mux - tr_group[6].input[20]
    TRIGGER_TR_GROUP6_INPUT21 = 355, //!< TCPWM trigger output reduction mux - tr_group[6].input[21]
    TRIGGER_TR_GROUP6_INPUT22 = 356, //!< TCPWM trigger output reduction mux - tr_group[6].input[22]
    TRIGGER_TR_GROUP6_INPUT23 = 357, //!< TCPWM trigger output reduction mux - tr_group[6].input[23]
    TRIGGER_TR_GROUP6_INPUT24 = 358, //!< TCPWM trigger output reduction mux - tr_group[6].input[24]
    TRIGGER_TR_GROUP6_INPUT25 = 359, //!< HSIOM Pin input reduction mux - tr_group[6].input[25]
    TRIGGER_TR_GROUP6_INPUT26 = 360, //!< HSIOM Pin input reduction mux - tr_group[6].input[26]
    TRIGGER_TR_GROUP6_INPUT27 = 361, //!< HSIOM Pin input reduction mux - tr_group[6].input[27]
    TRIGGER_TR_GROUP6_INPUT28 = 362, //!< HSIOM Pin input reduction mux - tr_group[6].input[28]
    TRIGGER_TR_GROUP6_INPUT29 = 363, //!< HSIOM Pin input reduction mux - tr_group[6].input[29]
    TRIGGER_TR_GROUP6_INPUT30 = 364, //!< HSIOM Pin input reduction mux - tr_group[6].input[30]
    TRIGGER_TR_GROUP6_INPUT31 = 365, //!< HSIOM Pin input reduction mux - tr_group[6].input[31]
    TRIGGER_TR_GROUP6_INPUT32 = 366, //!< HSIOM Pin input reduction mux - tr_group[6].input[32]
    TRIGGER_TR_GROUP6_INPUT33 = 367, //!< DMA request reduction mux - tr_group[6].input[33]
    TRIGGER_TR_GROUP6_INPUT34 = 368, //!< DMA request reduction mux - tr_group[6].input[34]
    TRIGGER_TR_GROUP6_INPUT35 = 369, //!< Trigger input reduction mux - tr_group[6].input[35]
    TRIGGER_TR_GROUP6_INPUT36 = 370, //!< Trigger input reduction mux - tr_group[6].input[36]
    TRIGGER_TR_GROUP6_INPUT37 = 371, //!< Trigger input reduction mux - tr_group[6].input[37]
    TRIGGER_TR_GROUP6_INPUT38 = 372, //!< Trigger input reduction mux - tr_group[6].input[38]
    TRIGGER_TR_GROUP6_INPUT39 = 373, //!< Trigger input reduction mux - tr_group[6].input[39]
    TRIGGER_TR_GROUP6_INPUT40 = 374, //!< Trigger input reduction mux - tr_group[6].input[40]
    TRIGGER_TR_GROUP6_INPUT41 = 375, //!< Trigger input reduction mux - tr_group[6].input[41]
    TRIGGER_TR_GROUP6_INPUT42 = 376, //!< Trigger input reduction mux - tr_group[6].input[42]
    TRIGGER_TR_GROUP7_INPUT1 = 377, //!< Datawire output trigger reduction mux - tr_group[7].input[1]
    TRIGGER_TR_GROUP7_INPUT2 = 378, //!< Datawire output trigger reduction mux - tr_group[7].input[2]
    TRIGGER_TR_GROUP7_INPUT3 = 379, //!< Datawire output trigger reduction mux - tr_group[7].input[3]
    TRIGGER_TR_GROUP7_INPUT4 = 380, //!< Datawire output trigger reduction mux - tr_group[7].input[4]
    TRIGGER_TR_GROUP7_INPUT5 = 381, //!< Datawire output trigger reduction mux - tr_group[7].input[5]
    TRIGGER_TR_GROUP7_INPUT6 = 382, //!< Datawire output trigger reduction mux - tr_group[7].input[6]
    TRIGGER_TR_GROUP7_INPUT7 = 383, //!< Datawire output trigger reduction mux - tr_group[7].input[7]
    TRIGGER_TR_GROUP7_INPUT8 = 384, //!< Datawire output trigger reduction mux - tr_group[7].input[8]
    TRIGGER_TR_GROUP7_INPUT9 = 385, //!< TCPWM trigger output reduction mux - tr_group[7].input[9]
    TRIGGER_TR_GROUP7_INPUT10 = 386, //!< TCPWM trigger output reduction mux - tr_group[7].input[10]
    TRIGGER_TR_GROUP7_INPUT11 = 387, //!< TCPWM trigger output reduction mux - tr_group[7].input[11]
    TRIGGER_TR_GROUP7_INPUT12 = 388, //!< TCPWM trigger output reduction mux - tr_group[7].input[12]
    TRIGGER_TR_GROUP7_INPUT13 = 389, //!< TCPWM trigger output reduction mux - tr_group[7].input[13]
    TRIGGER_TR_GROUP7_INPUT14 = 390, //!< TCPWM trigger output reduction mux - tr_group[7].input[14]
    TRIGGER_TR_GROUP7_INPUT15 = 391, //!< TCPWM trigger output reduction mux - tr_group[7].input[15]
    TRIGGER_TR_GROUP7_INPUT16 = 392, //!< TCPWM trigger output reduction mux - tr_group[7].input[16]
    TRIGGER_TR_GROUP7_INPUT17 = 393, //!< TCPWM trigger output reduction mux - tr_group[7].input[17]
    TRIGGER_TR_GROUP7_INPUT18 = 394, //!< TCPWM trigger output reduction mux - tr_group[7].input[18]
    TRIGGER_TR_GROUP7_INPUT19 = 395, //!< TCPWM trigger output reduction mux - tr_group[7].input[19]
    TRIGGER_TR_GROUP7_INPUT20 = 396, //!< TCPWM trigger output reduction mux - tr_group[7].input[20]
    TRIGGER_TR_GROUP7_INPUT21 = 397, //!< TCPWM trigger output reduction mux - tr_group[7].input[21]
    TRIGGER_TR_GROUP7_INPUT22 = 398, //!< TCPWM trigger output reduction mux - tr_group[7].input[22]
    TRIGGER_TR_GROUP7_INPUT23 = 399, //!< TCPWM trigger output reduction mux - tr_group[7].input[23]
    TRIGGER_TR_GROUP7_INPUT24 = 400, //!< TCPWM trigger output reduction mux - tr_group[7].input[24]
    TRIGGER_TR_GROUP7_INPUT25 = 401, //!< HSIOM Pin input reduction mux - tr_group[7].input[25]
    TRIGGER_TR_GROUP7_INPUT26 = 402, //!< HSIOM Pin input reduction mux - tr_group[7].input[26]
    TRIGGER_TR_GROUP7_INPUT27 = 403, //!< HSIOM Pin input reduction mux - tr_group[7].input[27]
    TRIGGER_TR_GROUP7_INPUT28 = 404, //!< HSIOM Pin input reduction mux - tr_group[7].input[28]
    TRIGGER_TR_GROUP7_INPUT29 = 405, //!< HSIOM Pin input reduction mux - tr_group[7].input[29]
    TRIGGER_TR_GROUP7_INPUT30 = 406, //!< HSIOM Pin input reduction mux - tr_group[7].input[30]
    TRIGGER_TR_GROUP7_INPUT31 = 407, //!< HSIOM Pin input reduction mux - tr_group[7].input[31]
    TRIGGER_TR_GROUP7_INPUT32 = 408, //!< HSIOM Pin input reduction mux - tr_group[7].input[32]
    TRIGGER_TR_GROUP7_INPUT33 = 409, //!< DMA request reduction mux - tr_group[7].input[33]
    TRIGGER_TR_GROUP7_INPUT34 = 410, //!< DMA request reduction mux - tr_group[7].input[34]
    TRIGGER_TR_GROUP7_INPUT35 = 411, //!< Trigger input reduction mux - tr_group[7].input[35]
    TRIGGER_TR_GROUP7_INPUT36 = 412, //!< Trigger input reduction mux - tr_group[7].input[36]
    TRIGGER_TR_GROUP7_INPUT37 = 413, //!< Trigger input reduction mux - tr_group[7].input[37]
    TRIGGER_TR_GROUP7_INPUT38 = 414, //!< Trigger input reduction mux - tr_group[7].input[38]
    TRIGGER_TR_GROUP7_INPUT39 = 415, //!< Trigger input reduction mux - tr_group[7].input[39]
    TRIGGER_TR_GROUP7_INPUT40 = 416, //!< Trigger input reduction mux - tr_group[7].input[40]
    TRIGGER_TR_GROUP7_INPUT41 = 417, //!< Trigger input reduction mux - tr_group[7].input[41]
    TRIGGER_TR_GROUP7_INPUT42 = 418, //!< Trigger input reduction mux - tr_group[7].input[42]
    TRIGGER_TR_GROUP8_INPUT1 = 419, //!< Datawire output trigger reduction mux - tr_group[8].input[1]
    TRIGGER_TR_GROUP8_INPUT2 = 420, //!< Datawire output trigger reduction mux - tr_group[8].input[2]
    TRIGGER_TR_GROUP8_INPUT3 = 421, //!< Datawire output trigger reduction mux - tr_group[8].input[3]
    TRIGGER_TR_GROUP8_INPUT4 = 422, //!< Datawire output trigger reduction mux - tr_group[8].input[4]
    TRIGGER_TR_GROUP8_INPUT5 = 423, //!< Datawire output trigger reduction mux - tr_group[8].input[5]
    TRIGGER_TR_GROUP8_INPUT6 = 424, //!< Datawire output trigger reduction mux - tr_group[8].input[6]
    TRIGGER_TR_GROUP8_INPUT7 = 425, //!< Datawire output trigger reduction mux - tr_group[8].input[7]
    TRIGGER_TR_GROUP8_INPUT8 = 426, //!< Datawire output trigger reduction mux - tr_group[8].input[8]
    TRIGGER_TR_GROUP8_INPUT9 = 427, //!< TCPWM trigger output reduction mux - tr_group[8].input[9]
    TRIGGER_TR_GROUP8_INPUT10 = 428, //!< TCPWM trigger output reduction mux - tr_group[8].input[10]
    TRIGGER_TR_GROUP8_INPUT11 = 429, //!< TCPWM trigger output reduction mux - tr_group[8].input[11]
    TRIGGER_TR_GROUP8_INPUT12 = 430, //!< TCPWM trigger output reduction mux - tr_group[8].input[12]
    TRIGGER_TR_GROUP8_INPUT13 = 431, //!< TCPWM trigger output reduction mux - tr_group[8].input[13]
    TRIGGER_TR_GROUP8_INPUT14 = 432, //!< TCPWM trigger output reduction mux - tr_group[8].input[14]
    TRIGGER_TR_GROUP8_INPUT15 = 433, //!< TCPWM trigger output reduction mux - tr_group[8].input[15]
    TRIGGER_TR_GROUP8_INPUT16 = 434, //!< TCPWM trigger output reduction mux - tr_group[8].input[16]
    TRIGGER_TR_GROUP8_INPUT17 = 435, //!< TCPWM trigger output reduction mux - tr_group[8].input[17]
    TRIGGER_TR_GROUP8_INPUT18 = 436, //!< TCPWM trigger output reduction mux - tr_group[8].input[18]
    TRIGGER_TR_GROUP8_INPUT19 = 437, //!< TCPWM trigger output reduction mux - tr_group[8].input[19]
    TRIGGER_TR_GROUP8_INPUT20 = 438, //!< TCPWM trigger output reduction mux - tr_group[8].input[20]
    TRIGGER_TR_GROUP8_INPUT21 = 439, //!< TCPWM trigger output reduction mux - tr_group[8].input[21]
    TRIGGER_TR_GROUP8_INPUT22 = 440, //!< TCPWM trigger output reduction mux - tr_group[8].input[22]
    TRIGGER_TR_GROUP8_INPUT23 = 441, //!< TCPWM trigger output reduction mux - tr_group[8].input[23]
    TRIGGER_TR_GROUP8_INPUT24 = 442, //!< TCPWM trigger output reduction mux - tr_group[8].input[24]
    TRIGGER_TR_GROUP8_INPUT25 = 443, //!< HSIOM Pin input reduction mux - tr_group[8].input[25]
    TRIGGER_TR_GROUP8_INPUT26 = 444, //!< HSIOM Pin input reduction mux - tr_group[8].input[26]
    TRIGGER_TR_GROUP8_INPUT27 = 445, //!< HSIOM Pin input reduction mux - tr_group[8].input[27]
    TRIGGER_TR_GROUP8_INPUT28 = 446, //!< HSIOM Pin input reduction mux - tr_group[8].input[28]
    TRIGGER_TR_GROUP8_INPUT29 = 447, //!< HSIOM Pin input reduction mux - tr_group[8].input[29]
    TRIGGER_TR_GROUP8_INPUT30 = 448, //!< HSIOM Pin input reduction mux - tr_group[8].input[30]
    TRIGGER_TR_GROUP8_INPUT31 = 449, //!< HSIOM Pin input reduction mux - tr_group[8].input[31]
    TRIGGER_TR_GROUP8_INPUT32 = 450, //!< HSIOM Pin input reduction mux - tr_group[8].input[32]
    TRIGGER_TR_GROUP8_INPUT33 = 451, //!< DMA request reduction mux - tr_group[8].input[33]
    TRIGGER_TR_GROUP8_INPUT34 = 452, //!< DMA request reduction mux - tr_group[8].input[34]
    TRIGGER_TR_GROUP8_INPUT35 = 453, //!< Trigger input reduction mux - tr_group[8].input[35]
    TRIGGER_TR_GROUP8_INPUT36 = 454, //!< Trigger input reduction mux - tr_group[8].input[36]
    TRIGGER_TR_GROUP8_INPUT37 = 455, //!< Trigger input reduction mux - tr_group[8].input[37]
    TRIGGER_TR_GROUP8_INPUT38 = 456, //!< Trigger input reduction mux - tr_group[8].input[38]
    TRIGGER_TR_GROUP8_INPUT39 = 457, //!< Trigger input reduction mux - tr_group[8].input[39]
    TRIGGER_TR_GROUP8_INPUT40 = 458, //!< Trigger input reduction mux - tr_group[8].input[40]
    TRIGGER_TR_GROUP8_INPUT41 = 459, //!< Trigger input reduction mux - tr_group[8].input[41]
    TRIGGER_TR_GROUP8_INPUT42 = 460, //!< Trigger input reduction mux - tr_group[8].input[42]
    TRIGGER_UDB_TR_DW_ACK0 = 461, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[0]
    TRIGGER_UDB_TR_DW_ACK1 = 462, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[1]
    TRIGGER_UDB_TR_DW_ACK2 = 463, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[2]
    TRIGGER_UDB_TR_DW_ACK3 = 464, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[3]
    TRIGGER_UDB_TR_DW_ACK4 = 465, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[4]
    TRIGGER_UDB_TR_DW_ACK5 = 466, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[5]
    TRIGGER_UDB_TR_DW_ACK6 = 467, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[6]
    TRIGGER_UDB_TR_DW_ACK7 = 468, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[7]
    TRIGGER_UDB_TR_IN0 = 469, //!< UDB trigger multiplexer - udb.tr_in[0]
    TRIGGER_UDB_TR_IN1 = 470, //!< UDB trigger multiplexer - udb.tr_in[1]
    TRIGGER_USB_DMA_BURSTEND0 = 471, //!< USB DMA burstend multiplexer - usb.dma_burstend[0]
    TRIGGER_USB_DMA_BURSTEND1 = 472, //!< USB DMA burstend multiplexer - usb.dma_burstend[1]
    TRIGGER_USB_DMA_BURSTEND2 = 473, //!< USB DMA burstend multiplexer - usb.dma_burstend[2]
    TRIGGER_USB_DMA_BURSTEND3 = 474, //!< USB DMA burstend multiplexer - usb.dma_burstend[3]
    TRIGGER_USB_DMA_BURSTEND4 = 475, //!< USB DMA burstend multiplexer - usb.dma_burstend[4]
    TRIGGER_USB_DMA_BURSTEND5 = 476, //!< USB DMA burstend multiplexer - usb.dma_burstend[5]
    TRIGGER_USB_DMA_BURSTEND6 = 477, //!< USB DMA burstend multiplexer - usb.dma_burstend[6]
    TRIGGER_USB_DMA_BURSTEND7 = 478, //!< USB DMA burstend multiplexer - usb.dma_burstend[7]
} cyhal_trigger_dest_psoc6_01_t;

/** Typedef from device family specific trigger dest to generic trigger dest */
typedef cyhal_trigger_dest_psoc6_01_t cyhal_dest_t;

/** \cond INTERNAL */
/** Maps each cyhal_destination_t to a mux index.
 * If bit 8 of the mux index is set, this denotes that the trigger is a
 * one to one trigger.
 */
extern const uint8_t cyhal_dest_to_mux[479];

/* Maps each cyhal_destination_t to a specific output in its mux */
extern const uint8_t cyhal_mux_dest_index[479];
/** \endcond */

#if defined(__cplusplus)
}
#endif /* __cplusplus */
/** \} group_hal_psoc6_triggers_psoc6_01 */
#endif /* _CYHAL_TRIGGERS_PSOC6_01_H_ */


/* [] END OF FILE */
