# PSoC 6 Peripheral Driver Library

### Overview
The Cypress PDL simplifies software development for PSoC 6 family of devices.
The PDL integrates device header files, startup code, and 
peripheral drivers into a single package. The drivers abstract the hardware functions into a set of 
easy-to-use APIs. These are fully documented in the [PDL API Reference Manual](https://cypresssemiconductorco.github.io/psoc6pdl/pdl_api_reference_manual/html/index.html). 

This version of the PDL is compatible with ModusToolbox. It is not compatible 
with PSoC Creator. The most recent PSoC Creator-compatible version of the PDL 
is [available here](https://www.cypress.com/documentation/software-and-drivers/peripheral-driver-library-pdl).

### Features
* Includes all the updates made to the peripheral drivers for ModusToolbox™ software
* Contains standard set of PSoC® 6 digital and analog peripheral drivers that enable rapid peripheral software development in third-party IDEs
* The ARM Cortex® Microcontroller Software Interface Standard (CMSIS) core access header files
* CMSIS compliant device header files, startup code (platform initialization) and device configuration header files

The PDL reduces the need to understand register usage and bit structures, 
thus easing software development for the extensive set of peripherals in the 
PSoC 6 series. 
See the [PDL API Reference Manual](https://cypresssemiconductorco.github.io/psoc6pdl/pdl_api_reference_manual/html/index.html) for more detailed information.
See the [PDL Release Notes](./RELEASE.md) for release-specific information.

### Peripheral Drivers
The PDL provides a high-level API to configure, initialize, and use a peripheral driver. 
The drivers are designed for peripheral IP blocks. 
See [PDL API Reference](https://cypresssemiconductorco.github.io/psoc6pdl/pdl_api_reference_manual/html/modules.html) for the list of drivers.

### Quick Start
See the [PDL API Reference Manual Getting Started section](https://cypresssemiconductorco.github.io/psoc6pdl/pdl_api_reference_manual/html/page_getting_started.html) for quick start instructions.

### More information
* [Peripheral Driver Library Release Notes](./RELEASE.md)
* [Peripheral Driver Library API Reference Manual](https://cypresssemiconductorco.github.io/psoc6pdl/pdl_api_reference_manual/html/index.html)
* [ModusToolbox Software Environment, Quick Start Guide, Documentation, and Videos](https://www.cypress.com/products/modustoolbox-software-environment)
* [ModusToolbox Device Configurator Tool Guide](https://www.cypress.com/ModusToolboxDeviceConfig)
* [AN210781 Getting Started with PSoC 6 MCU with Bluetooth Low Energy (BLE) Connectivity](http://www.cypress.com/an210781)
* [PSoC 6 Technical Reference Manuals](https://www.cypress.com/search/all/PSoC%206%20Technical%20Reference%20Manual?f%5b0%5d=meta_type%3Atechnical_documents&f%5b1%5d=resource_meta_type%3A583)
* [PSoC 6 MCU Datasheets](https://www.cypress.com/search/all?f%5b0%5d=meta_type%3Atechnical_documents&f%5b1%5d=resource_meta_type%3A575&f%5b2%5d=field_related_products%3A114026)
* [Cypress Semiconductor](http://www.cypress.com)

---
© Cypress Semiconductor Corporation, 2020.