# This file defines variables for various sets of devices. Each variable is a 
# list of the MPNs that have that capability or feature.

# Major device capabilities.
CY_DEVICES_WITH_M0P=CY8C6246BZI-D04 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C6336BZI-BLD13 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6247FDI-D02 CY8C6247FDI-D32 CY8C6336BZI-BUD13 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6247FDI-D52 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6336BZI-BLD14 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6247WI-D54 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54 CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C624ABZI-S2D04 CY8C624ABZI-S2D14 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C624ABZI-D04 CY8C624ABZI-D14 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43 CY8C624ALQI-D42 CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245FNI-S3D71 CY8C6245AZI-S3D62 CY8C6245LQI-S3D62 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245FNI-S3D41 CY8C6245AZI-S3D12 CY8C6245LQI-S3D12 CY8C6245FNI-S3D11 CY8C6245AZI-S3D02 CY8C6245LQI-S3D02 CY8C6245WI-S3D72
CY_DEVICES_WITH_BLE=CY8C6336BZI-BLF03 CY8C6316BZI-BLF03 CY8C6316BZI-BLF53 CY8C6336BZI-BLD13 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6336BZI-BUD13 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6337BZI-BLF13 CY8C6336BZI-BLF04 CY8C6316BZI-BLF04 CY8C6316BZI-BLF54 CY8C6336BZI-BLD14 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6336LQI-BLF02 CY8C6336LQI-BLF42 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53
CY_DEVICES_WITH_UDBS=CY8C6116BZI-F54 CY8C6136BZI-F34 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6117BZI-F34 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C6316BZI-BLF53 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C6247FDI-D32 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6247FDI-D52 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6316BZI-BLF54 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD33 CY8C6137WI-F54 CY8C6117WI-F34 CY8C6247WI-D54 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54
CY_DEVICES_WITH_FS_USB=CY8C6036BZI-F04 CY8C6016BZI-F04 CY8C6116BZI-F54 CY8C6136BZI-F14 CY8C6136BZI-F34 CY8C6137BZI-F14 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6117BZI-F34 CY8C6246BZI-D04 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C637BZI-MD76 CY8C6137FDI-F02 CY8C6117FDI-F02 CY8C6247FDI-D02 CY8C6247FDI-D32 CY8C6336BZI-BUD13 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6136FDI-F42 CY8C6247FDI-D52 CY8C6136FTI-F42 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6336BZI-BLF04 CY8C6316BZI-BLF04 CY8C6316BZI-BLF54 CY8C6336BZI-BLD14 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6137WI-F54 CY8C6117WI-F34 CY8C6247WI-D54 CYB06447BZI-BLD54 CYB06447BZI-D54 CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C624ABZI-S2D04 CY8C624ABZI-S2D14 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C614ABZI-S2F04 CY8C614AAZI-S2F04 CY8C614AFNI-S2F03 CY8C614AAZI-S2F14 CY8C614ABZI-S2F44 CY8C614AAZI-S2F44 CY8C614AFNI-S2F43 CY8C6148BZI-S2F44 CY8C6148AZI-S2F44 CY8C6148FNI-S2F43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C624ABZI-D04 CY8C624ABZI-D14 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43 CY8C624ALQI-D42 CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245AZI-S3D62 CY8C6245LQI-S3D62 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245AZI-S3D12 CY8C6245LQI-S3D12 CY8C6245AZI-S3D02 CY8C6245LQI-S3D02 CY8C6245WI-S3D72 CY8C6145AZI-S3F72 CY8C6145LQI-S3F72 CY8C6145AZI-S3F62 CY8C6145LQI-S3F62 CY8C6145AZI-S3F42 CY8C6145LQI-S3F42 CY8C6145AZI-S3F12 CY8C6145LQI-S3F12 CY8C6145AZI-S3F02 CY8C6145LQI-S3F02
CY_DEVICES_WITH_CAPSENSE=CY8C6116BZI-F54 CY8C6136BZI-F14 CY8C6136BZI-F34 CY8C6137BZI-F14 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6117BZI-F34 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C6316BZI-BLF53 CY8C6336BZI-BLD13 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6247FDI-D32 CY8C6336BZI-BUD13 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6337BZI-BLF13 CY8C6136FDI-F42 CY8C6247FDI-D52 CY8C6136FTI-F42 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6316BZI-BLF54 CY8C6336BZI-BLD14 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6137WI-F54 CY8C6117WI-F34 CY8C6247WI-D54 CY8C6336LQI-BLF42 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54 CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C624ABZI-S2D14 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C614AAZI-S2F14 CY8C614ABZI-S2F44 CY8C614AAZI-S2F44 CY8C614AFNI-S2F43 CY8C6148BZI-S2F44 CY8C6148AZI-S2F44 CY8C6148FNI-S2F43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C624ABZI-D14 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43 CY8C624ALQI-D42 CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245FNI-S3D71 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245FNI-S3D41 CY8C6245AZI-S3D12 CY8C6245LQI-S3D12 CY8C6245FNI-S3D11 CY8C6245WI-S3D72 CY8C6145AZI-S3F72 CY8C6145LQI-S3F72 CY8C6145FNI-S3F71 CY8C6145AZI-S3F42 CY8C6145LQI-S3F42 CY8C6145FNI-S3F41 CY8C6145AZI-S3F12 CY8C6145LQI-S3F12 CY8C6145FNI-S3F11
CY_DEVICES_WITH_CRYPTO=CY8C6116BZI-F54 CY8C6137BZI-F54 CY8C6247BZI-D44 CY8C6247BZI-D54 CY8C6316BZI-BLF53 CY8C6347BZI-BLD43 CY8C6347BZI-BLD53 CY8C6347FMI-BLD43 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6347BZI-BUD43 CY8C6347BZI-BUD53 CY8C6136FDI-F42 CY8C6247FDI-D52 CY8C6136FTI-F42 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6316BZI-BLF54 CY8C6347BZI-BLD44 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD43 CY8C6137WI-F54 CY8C6247WI-D54 CY8C6336LQI-BLF42 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54 CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C614ABZI-S2F44 CY8C614AAZI-S2F44 CY8C614AFNI-S2F43 CY8C6148BZI-S2F44 CY8C6148AZI-S2F44 CY8C6148FNI-S2F43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43 CY8C624ALQI-D42 CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245FNI-S3D71 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245FNI-S3D41 CY8C6245WI-S3D72 CY8C6145AZI-S3F72 CY8C6145LQI-S3F72 CY8C6145FNI-S3F71 CY8C6145AZI-S3F42 CY8C6145LQI-S3F42 CY8C6145FNI-S3F41
CY_DEVICES_SECURE=CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54 CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CYB06445LQI-S3D42

# Different classifications of devices.
CY_DEVICES_WITH_DIE_PSOC6ABLE2=CY8C6036BZI-F04 CY8C6016BZI-F04 CY8C6116BZI-F54 CY8C6136BZI-F14 CY8C6136BZI-F34 CY8C6137BZI-F14 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6117BZI-F34 CY8C6246BZI-D04 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C6336BZI-BLF03 CY8C6316BZI-BLF03 CY8C6316BZI-BLF53 CY8C6336BZI-BLD13 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6137FDI-F02 CY8C6117FDI-F02 CY8C6247FDI-D02 CY8C6247FDI-D32 CY8C6336BZI-BUD13 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6337BZI-BLF13 CY8C6136FDI-F42 CY8C6247FDI-D52 CY8C6136FTI-F42 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6336BZI-BLF04 CY8C6316BZI-BLF04 CY8C6316BZI-BLF54 CY8C6336BZI-BLD14 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6137WI-F54 CY8C6117WI-F34 CY8C6247WI-D54 CY8C6336LQI-BLF02 CY8C6336LQI-BLF42 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54
CY_DEVICES_WITH_DIE_PSOC6A2M=CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C624ABZI-S2D04 CY8C624ABZI-S2D14 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C614ABZI-S2F04 CY8C614AAZI-S2F04 CY8C614AFNI-S2F03 CY8C614AAZI-S2F14 CY8C614ABZI-S2F44 CY8C614AAZI-S2F44 CY8C614AFNI-S2F43 CY8C6148BZI-S2F44 CY8C6148AZI-S2F44 CY8C6148FNI-S2F43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C624ABZI-D04 CY8C624ABZI-D14 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43 CY8C624ALQI-D42
CY_DEVICES_WITH_DIE_PSOC6A512K=CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245FNI-S3D71 CY8C6245AZI-S3D62 CY8C6245LQI-S3D62 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245FNI-S3D41 CY8C6245AZI-S3D12 CY8C6245LQI-S3D12 CY8C6245FNI-S3D11 CY8C6245AZI-S3D02 CY8C6245LQI-S3D02 CY8C6245WI-S3D72 CY8C6145AZI-S3F72 CY8C6145LQI-S3F72 CY8C6145FNI-S3F71 CY8C6145AZI-S3F62 CY8C6145LQI-S3F62 CY8C6145AZI-S3F42 CY8C6145LQI-S3F42 CY8C6145FNI-S3F41 CY8C6145AZI-S3F12 CY8C6145LQI-S3F12 CY8C6145FNI-S3F11 CY8C6145AZI-S3F02 CY8C6145LQI-S3F02

CY_DEVICES_WITH_FLASH_KB_512=CY8C6036BZI-F04 CY8C6016BZI-F04 CY8C6116BZI-F54 CY8C6136BZI-F14 CY8C6136BZI-F34 CY8C6246BZI-D04 CY8C6336BZI-BLF03 CY8C6316BZI-BLF03 CY8C6316BZI-BLF53 CY8C6336BZI-BLD13 CY8C6336BZI-BUD13 CY8C6136FDI-F42 CY8C6136FTI-F42 CY8C6336BZI-BLF04 CY8C6316BZI-BLF04 CY8C6316BZI-BLF54 CY8C6336BZI-BLD14 CY8C6336LQI-BLF02 CY8C6336LQI-BLF42 CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245FNI-S3D71 CY8C6245AZI-S3D62 CY8C6245LQI-S3D62 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CY8C6245FNI-S3D41 CY8C6245AZI-S3D12 CY8C6245LQI-S3D12 CY8C6245FNI-S3D11 CY8C6245AZI-S3D02 CY8C6245LQI-S3D02 CY8C6245WI-S3D72 CY8C6145AZI-S3F72 CY8C6145LQI-S3F72 CY8C6145FNI-S3F71 CY8C6145AZI-S3F62 CY8C6145LQI-S3F62 CY8C6145AZI-S3F42 CY8C6145LQI-S3F42 CY8C6145FNI-S3F41 CY8C6145AZI-S3F12 CY8C6145LQI-S3F12 CY8C6145FNI-S3F11 CY8C6145AZI-S3F02 CY8C6145LQI-S3F02
CY_DEVICES_WITH_FLASH_KB_1024=CY8C6137BZI-F14 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6117BZI-F34 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6137FDI-F02 CY8C6117FDI-F02 CY8C6247FDI-D02 CY8C6247FDI-D32 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6337BZI-BLF13 CY8C6247FDI-D52 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6137WI-F54 CY8C6117WI-F34 CY8C6247WI-D54 CY8C6347LQI-BLD52 CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C6148BZI-S2F44 CY8C6148AZI-S2F44 CY8C6148FNI-S2F43 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43
CY_DEVICES_WITH_FLASH_KB_832=CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54
CY_DEVICES_WITH_FLASH_KB_1856=CYB0644ABZI-S2D44 CYS0644ABZI-S2D44
CY_DEVICES_WITH_FLASH_KB_2048=CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C624ABZI-S2D04 CY8C624ABZI-S2D14 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C614ABZI-S2F04 CY8C614AAZI-S2F04 CY8C614AFNI-S2F03 CY8C614AAZI-S2F14 CY8C614ABZI-S2F44 CY8C614AAZI-S2F44 CY8C614AFNI-S2F43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C624ABZI-D04 CY8C624ABZI-D14 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C624ALQI-D42
CY_DEVICES_WITH_FLASH_KB_448=CYB06445LQI-S3D42

CY_DEVICES_WITH_SRAM_KB_128=CY8C6036BZI-F04 CY8C6016BZI-F04 CY8C6116BZI-F54 CY8C6136BZI-F14 CY8C6136BZI-F34 CY8C6246BZI-D04 CY8C6336BZI-BLF03 CY8C6316BZI-BLF03 CY8C6316BZI-BLF53 CY8C6336BZI-BLD13 CY8C6336BZI-BUD13 CY8C6136FDI-F42 CY8C6136FTI-F42 CY8C6336BZI-BLF04 CY8C6316BZI-BLF04 CY8C6316BZI-BLF54 CY8C6336BZI-BLD14 CY8C6336LQI-BLF02 CY8C6336LQI-BLF42
CY_DEVICES_WITH_SRAM_KB_288=CY8C6137BZI-F14 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6117BZI-F34 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6137FDI-F02 CY8C6117FDI-F02 CY8C6247FDI-D02 CY8C6247FDI-D32 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6337BZI-BLF13 CY8C6247FDI-D52 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6137WI-F54 CY8C6117WI-F34 CY8C6247WI-D54 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54
CY_DEVICES_WITH_SRAM_KB_1024=CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C624ABZI-S2D04 CY8C624ABZI-S2D14 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C614ABZI-S2F04 CY8C614AAZI-S2F04 CY8C614AFNI-S2F03 CY8C614AAZI-S2F14 CY8C614ABZI-S2F44 CY8C614AAZI-S2F44 CY8C614AFNI-S2F43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C624ABZI-D04 CY8C624ABZI-D14 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C624ALQI-D42
CY_DEVICES_WITH_SRAM_KB_512=CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C6148BZI-S2F44 CY8C6148AZI-S2F44 CY8C6148FNI-S2F43 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43
CY_DEVICES_WITH_SRAM_KB_256=CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245FNI-S3D71 CY8C6245AZI-S3D62 CY8C6245LQI-S3D62 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245FNI-S3D41 CY8C6245AZI-S3D12 CY8C6245LQI-S3D12 CY8C6245FNI-S3D11 CY8C6245AZI-S3D02 CY8C6245LQI-S3D02 CY8C6245WI-S3D72 CY8C6145AZI-S3F72 CY8C6145LQI-S3F72 CY8C6145FNI-S3F71 CY8C6145AZI-S3F62 CY8C6145LQI-S3F62 CY8C6145AZI-S3F42 CY8C6145LQI-S3F42 CY8C6145FNI-S3F41 CY8C6145AZI-S3F12 CY8C6145LQI-S3F12 CY8C6145FNI-S3F11 CY8C6145AZI-S3F02 CY8C6145LQI-S3F02

CY_DEVICES_WITH_MAX_SPEED_MHZ_150=CY8C6036BZI-F04 CY8C6136BZI-F14 CY8C6136BZI-F34 CY8C6137BZI-F14 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6246BZI-D04 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C6336BZI-BLF03 CY8C6336BZI-BLD13 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637BZI-MD76 CY8C637BZI-BLD74 CY8C637FMI-BLD73 CY8C68237BZ-BLE CY8C68237FM-BLE CY8C6137FDI-F02 CY8C6247FDI-D02 CY8C6247FDI-D32 CY8C6336BZI-BUD13 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53 CY8C6337BZI-BLF13 CY8C6136FDI-F42 CY8C6247FDI-D52 CY8C6136FTI-F42 CY8C6247FTI-D52 CY8C6247BZI-AUD54 CY8C6336BZI-BLF04 CY8C6336BZI-BLD14 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CY8C6247BFI-D54 CYBLE-416045-02 CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33 CY8C6137WI-F54 CY8C6247WI-D54 CY8C6336LQI-BLF02 CY8C6336LQI-BLF42 CY8C6347LQI-BLD52 CYB06447BZI-BLD54 CYB06447BZI-BLD53 CYB06447BZI-D54 CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624AAZI-S2D44 CY8C624AFNI-S2D43 CY8C624ABZI-S2D04 CY8C624ABZI-S2D14 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C6248BZI-S2D44 CY8C6248AZI-S2D44 CY8C6248FNI-S2D43 CY8C614ABZI-S2F04 CY8C614AAZI-S2F04 CY8C614AFNI-S2F03 CY8C614AAZI-S2F14 CY8C614ABZI-S2F44 CY8C614AAZI-S2F44 CY8C614AFNI-S2F43 CY8C6148BZI-S2F44 CY8C6148AZI-S2F44 CY8C6148FNI-S2F43 CY8C624ABZI-D44 CY8C624AAZI-D44 CY8C624AFNI-D43 CY8C624ABZI-D04 CY8C624ABZI-D14 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C6248BZI-D44 CY8C6248AZI-D44 CY8C6248FNI-D43 CY8C624ALQI-D42 CY8C6245AZI-S3D72 CY8C6245LQI-S3D72 CY8C6245FNI-S3D71 CY8C6245AZI-S3D62 CY8C6245LQI-S3D62 CY8C6245AZI-S3D42 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245FNI-S3D41 CY8C6245AZI-S3D12 CY8C6245LQI-S3D12 CY8C6245FNI-S3D11 CY8C6245AZI-S3D02 CY8C6245LQI-S3D02 CY8C6245WI-S3D72 CY8C6145AZI-S3F72 CY8C6145LQI-S3F72 CY8C6145FNI-S3F71 CY8C6145AZI-S3F62 CY8C6145LQI-S3F62 CY8C6145AZI-S3F42 CY8C6145LQI-S3F42 CY8C6145FNI-S3F41 CY8C6145AZI-S3F12 CY8C6145LQI-S3F12 CY8C6145FNI-S3F11 CY8C6145AZI-S3F02 CY8C6145LQI-S3F02
CY_DEVICES_WITH_MAX_SPEED_MHZ_50=CY8C6016BZI-F04 CY8C6116BZI-F54 CY8C6117BZI-F34 CY8C6316BZI-BLF03 CY8C6316BZI-BLF53 CY8C6117FDI-F02 CY8C6316BZI-BLF04 CY8C6316BZI-BLF54 CY8C6117WI-F34

CY_DEVICES_WITH_PACKAGE_124-BGA=CY8C6036BZI-F04 CY8C6016BZI-F04 CY8C6116BZI-F54 CY8C6136BZI-F14 CY8C6136BZI-F34 CY8C6137BZI-F14 CY8C6137BZI-F34 CY8C6137BZI-F54 CY8C6117BZI-F34 CY8C6246BZI-D04 CY8C6247BZI-D44 CY8C6247BZI-D34 CY8C6247BZI-D54 CY8C637BZI-MD76 CY8C6247BZI-AUD54 CY8C6247BFI-D54 CY8C6137WI-F54 CY8C6117WI-F34 CY8C6247WI-D54 CYB06447BZI-D54 CYB0644ABZI-S2D44 CYS0644ABZI-S2D44 CY8C624ABZI-S2D44A0 CY8C624ABZI-S2D44 CY8C624ABZI-S2D04 CY8C624ABZI-S2D14 CY8C6248BZI-S2D44 CY8C614ABZI-S2F04 CY8C614ABZI-S2F44 CY8C6148BZI-S2F44 CY8C624ABZI-D44 CY8C624ABZI-D04 CY8C624ABZI-D14 CY8C6248BZI-D44
CY_DEVICES_WITH_PACKAGE_116-BGA-BLE=CY8C6336BZI-BLF03 CY8C6316BZI-BLF03 CY8C6316BZI-BLF53 CY8C6336BZI-BLD13 CY8C6347BZI-BLD43 CY8C6347BZI-BLD33 CY8C6347BZI-BLD53 CY8C637BZI-BLD74 CY8C68237BZ-BLE CY8C6337BZI-BLF13 CYB06447BZI-BLD53
CY_DEVICES_WITH_PACKAGE_104-M-CSP-BLE=CY8C6347FMI-BLD13 CY8C6347FMI-BLD43 CY8C6347FMI-BLD33 CY8C6347FMI-BLD53 CY8C637FMI-BLD73 CY8C68237FM-BLE
CY_DEVICES_WITH_PACKAGE_80-WLCSP=CY8C6137FDI-F02 CY8C6117FDI-F02 CY8C6247FDI-D02 CY8C6247FDI-D32 CY8C6136FDI-F42 CY8C6247FDI-D52 CY8C6136FTI-F42 CY8C6247FTI-D52
CY_DEVICES_WITH_PACKAGE_116-BGA-USB=CY8C6336BZI-BUD13 CY8C6347BZI-BUD43 CY8C6347BZI-BUD33 CY8C6347BZI-BUD53
CY_DEVICES_WITH_PACKAGE_124-BGA-SIP=CY8C6336BZI-BLF04 CY8C6316BZI-BLF04 CY8C6316BZI-BLF54 CY8C6336BZI-BLD14 CY8C6347BZI-BLD44 CY8C6347BZI-BLD34 CY8C6347BZI-BLD54 CYB06447BZI-BLD54
CY_DEVICES_WITH_PACKAGE_43-SMT=CYBLE-416045-02
CY_DEVICES_WITH_PACKAGE_104-M-CSP-BLE-USB=CY8C6347FMI-BUD53 CY8C6347FMI-BUD13 CY8C6347FMI-BUD43 CY8C6347FMI-BUD33
CY_DEVICES_WITH_PACKAGE_68-QFN-BLE=CY8C6336LQI-BLF02 CY8C6336LQI-BLF42 CY8C6347LQI-BLD52
CY_DEVICES_WITH_PACKAGE_128-TQFP=CY8C624AAZI-S2D44 CY8C624AAZI-S2D14 CY8C6248AZI-S2D14 CY8C6248AZI-S2D44 CY8C614AAZI-S2F04 CY8C614AAZI-S2F14 CY8C614AAZI-S2F44 CY8C6148AZI-S2F44 CY8C624AAZI-D44 CY8C624AAZI-D14 CY8C6248AZI-D14 CY8C6248AZI-D44
CY_DEVICES_WITH_PACKAGE_100-WLCSP=CY8C624AFNI-S2D43 CY8C6248FNI-S2D43 CY8C614AFNI-S2F03 CY8C614AFNI-S2F43 CY8C6148FNI-S2F43 CY8C624AFNI-D43 CY8C6248FNI-D43
CY_DEVICES_WITH_PACKAGE_68-QFN=CY8C624ALQI-D42 CY8C6245LQI-S3D72 CY8C6245LQI-S3D62 CY8C6245LQI-S3D42 CYB06445LQI-S3D42 CY8C6245LQI-S3D12 CY8C6245LQI-S3D02 CY8C6145LQI-S3F72 CY8C6145LQI-S3F62 CY8C6145LQI-S3F42 CY8C6145LQI-S3F12 CY8C6145LQI-S3F02
CY_DEVICES_WITH_PACKAGE_100-TQFP=CY8C6245AZI-S3D72 CY8C6245AZI-S3D62 CY8C6245AZI-S3D42 CY8C6245AZI-S3D12 CY8C6245AZI-S3D02 CY8C6145AZI-S3F72 CY8C6145AZI-S3F62 CY8C6145AZI-S3F42 CY8C6145AZI-S3F12 CY8C6145AZI-S3F02
CY_DEVICES_WITH_PACKAGE_49-WLCSP=CY8C6245FNI-S3D71 CY8C6245FNI-S3D41 CY8C6245FNI-S3D11 CY8C6145FNI-S3F71 CY8C6145FNI-S3F41 CY8C6145FNI-S3F11
CY_DEVICES_WITH_PACKAGE_KGD=CY8C6245WI-S3D72

