/*
 * Copyright (c) 2019, Nuvoton Technology Corporation
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PeripheralPins.h"

//*** ADC ***

const PinMap PinMap_ADC[] = {
    {PB_0, ADC_0_0, SYS_GPB_MFPL_PB0MFP_EADC0_CH0},
    {PB_1, ADC_0_1, SYS_GPB_MFPL_PB1MFP_EADC0_CH1},
    {PB_2, ADC_0_2, SYS_GPB_MFPL_PB2MFP_EADC0_CH2},
    {PB_3, ADC_0_3, SYS_GPB_MFPL_PB3MFP_EADC0_CH3},
    {PB_4, ADC_0_4, SYS_GPB_MFPL_PB4MFP_EADC0_CH4},
    {PB_5, ADC_0_5, SYS_GPB_MFPL_PB5MFP_EADC0_CH5},
    {PB_6, ADC_0_6, SYS_GPB_MFPL_PB6MFP_EADC0_CH6},
    {PB_7, ADC_0_7, SYS_GPB_MFPL_PB7MFP_EADC0_CH7},
    {PB_8, ADC_0_8, SYS_GPB_MFPH_PB8MFP_EADC0_CH8},
    {PB_9, ADC_0_9, SYS_GPB_MFPH_PB9MFP_EADC0_CH9},
    {PB_10, ADC_0_10, SYS_GPB_MFPH_PB10MFP_EADC0_CH10},
    {PB_11, ADC_0_11, SYS_GPB_MFPH_PB11MFP_EADC0_CH11},
    {PB_12, ADC_0_12, SYS_GPB_MFPH_PB12MFP_EADC0_CH12},
    {PB_13, ADC_0_13, SYS_GPB_MFPH_PB13MFP_EADC0_CH13},
    {PB_14, ADC_0_14, SYS_GPB_MFPH_PB14MFP_EADC0_CH14},
    {PB_15, ADC_0_15, SYS_GPB_MFPH_PB15MFP_EADC0_CH15},

    {NC,   NC,    0}
};

//*** DAC ***

const PinMap PinMap_DAC[] = {
    {PB_12, DAC_0_0, SYS_GPB_MFPH_PB12MFP_DAC0_OUT},

    {NC,   NC,    0}
};

//*** I2C ***

const PinMap PinMap_I2C_SDA[] = {
    {PA_2, I2C_1, SYS_GPA_MFPL_PA2MFP_I2C1_SDA},
    {PA_4, I2C_0, SYS_GPA_MFPL_PA4MFP_I2C0_SDA},
    {PA_6, I2C_1, SYS_GPA_MFPL_PA6MFP_I2C1_SDA},
    {PA_13, I2C_1, SYS_GPA_MFPH_PA13MFP_I2C1_SDA},
    {PB_0, I2C_1, SYS_GPB_MFPL_PB0MFP_I2C1_SDA},
    {PB_2, I2C_1, SYS_GPB_MFPL_PB2MFP_I2C1_SDA},
    {PB_4, I2C_0, SYS_GPB_MFPL_PB4MFP_I2C0_SDA},
    {PB_10, I2C_1, SYS_GPB_MFPH_PB10MFP_I2C1_SDA},
    {PC_0, I2C_0, SYS_GPC_MFPL_PC0MFP_I2C0_SDA},
    {PC_4, I2C_1, SYS_GPC_MFPL_PC4MFP_I2C1_SDA},
    {PC_8, I2C_0, SYS_GPC_MFPH_PC8MFP_I2C0_SDA},
    {PC_11, I2C_0, SYS_GPC_MFPH_PC11MFP_I2C0_SDA},
    {PD_4, I2C_1, SYS_GPD_MFPL_PD4MFP_I2C1_SDA},
    {PD_6, I2C_0, SYS_GPD_MFPL_PD6MFP_I2C0_SDA},
    {PE_0, I2C_1, SYS_GPE_MFPL_PE0MFP_I2C1_SDA},
    {PF_1, I2C_1, SYS_GPF_MFPL_PF1MFP_I2C1_SDA},
    {PF_2, I2C_0, SYS_GPF_MFPL_PF2MFP_I2C0_SDA},

    {NC,    NC,    0}
};

const PinMap PinMap_I2C_SCL[] = {
    {PA_3, I2C_1, SYS_GPA_MFPL_PA3MFP_I2C1_SCL},
    {PA_5, I2C_0, SYS_GPA_MFPL_PA5MFP_I2C0_SCL},
    {PA_7, I2C_1, SYS_GPA_MFPL_PA7MFP_I2C1_SCL},
    {PA_12, I2C_1, SYS_GPA_MFPH_PA12MFP_I2C1_SCL},
    {PB_1, I2C_1, SYS_GPB_MFPL_PB1MFP_I2C1_SCL},
    {PB_3, I2C_1, SYS_GPB_MFPL_PB3MFP_I2C1_SCL},
    {PB_5, I2C_0, SYS_GPB_MFPL_PB5MFP_I2C0_SCL},
    {PB_11, I2C_1, SYS_GPB_MFPH_PB11MFP_I2C1_SCL},
    {PC_1, I2C_0, SYS_GPC_MFPL_PC1MFP_I2C0_SCL},
    {PC_5, I2C_1, SYS_GPC_MFPL_PC5MFP_I2C1_SCL},
    {PC_12, I2C_0, SYS_GPC_MFPH_PC12MFP_I2C0_SCL},
    {PD_5, I2C_1, SYS_GPD_MFPL_PD5MFP_I2C1_SCL},
    {PD_7, I2C_0, SYS_GPD_MFPL_PD7MFP_I2C0_SCL},
    {PE_1, I2C_1, SYS_GPE_MFPL_PE1MFP_I2C1_SCL},
    {PE_13, I2C_0, SYS_GPE_MFPH_PE13MFP_I2C0_SCL},
    {PF_0, I2C_1, SYS_GPF_MFPL_PF0MFP_I2C1_SCL},
    {PF_3, I2C_0, SYS_GPF_MFPL_PF3MFP_I2C0_SCL},

    {NC,    NC,    0}
};

//*** PWM ***

const PinMap PinMap_PWM[] = {
    {PA_0, PWM_0_5, SYS_GPA_MFPL_PA0MFP_PWM0_CH5},
    {PA_1, PWM_0_4, SYS_GPA_MFPL_PA1MFP_PWM0_CH4},
    {PA_2, PWM_0_3, SYS_GPA_MFPL_PA2MFP_PWM0_CH3},
    {PA_3, PWM_0_2, SYS_GPA_MFPL_PA3MFP_PWM0_CH2},
    {PA_4, PWM_0_1, SYS_GPA_MFPL_PA4MFP_PWM0_CH1},
    {PA_5, PWM_0_0, SYS_GPA_MFPL_PA5MFP_PWM0_CH0},
    {PA_6, PWM_1_5, SYS_GPA_MFPL_PA6MFP_PWM1_CH5},
    {PA_7, PWM_1_4, SYS_GPA_MFPL_PA7MFP_PWM1_CH4},
    {PB_0, PWM_0_5, SYS_GPB_MFPL_PB0MFP_PWM0_CH5},
    {NU_PINNAME_BIND(PB_0, PWM_0_5), PWM_0_5, SYS_GPB_MFPL_PB0MFP_PWM0_CH5},
    {PB_0, PWM_1_5, SYS_GPB_MFPL_PB0MFP_PWM1_CH5},
    {NU_PINNAME_BIND(PB_0, PWM_1_5), PWM_1_5, SYS_GPB_MFPL_PB0MFP_PWM1_CH5},
    {PB_1, PWM_0_4, SYS_GPB_MFPL_PB1MFP_PWM0_CH4},
    {NU_PINNAME_BIND(PB_1, PWM_0_4), PWM_0_4, SYS_GPB_MFPL_PB1MFP_PWM0_CH4},
    {PB_1, PWM_1_4, SYS_GPB_MFPL_PB1MFP_PWM1_CH4},
    {NU_PINNAME_BIND(PB_1, PWM_1_4), PWM_1_4, SYS_GPB_MFPL_PB1MFP_PWM1_CH4},
    {PB_2, PWM_0_3, SYS_GPB_MFPL_PB2MFP_PWM0_CH3},
    {PB_3, PWM_0_2, SYS_GPB_MFPL_PB3MFP_PWM0_CH2},
    {PB_4, PWM_0_1, SYS_GPB_MFPL_PB4MFP_PWM0_CH1},
    {PB_5, PWM_0_0, SYS_GPB_MFPL_PB5MFP_PWM0_CH0},
    {PB_6, PWM_1_5, SYS_GPB_MFPL_PB6MFP_PWM1_CH5},
    {PB_7, PWM_1_4, SYS_GPB_MFPL_PB7MFP_PWM1_CH4},
    {PB_12, PWM_1_3, SYS_GPB_MFPH_PB12MFP_PWM1_CH3},
    {PB_13, PWM_1_2, SYS_GPB_MFPH_PB13MFP_PWM1_CH2},
    {PB_14, PWM_1_1, SYS_GPB_MFPH_PB14MFP_PWM1_CH1},
    {PB_15, PWM_1_0, SYS_GPB_MFPH_PB15MFP_PWM1_CH0},
    {PC_0, PWM_1_5, SYS_GPC_MFPL_PC0MFP_PWM1_CH5},
    {PC_1, PWM_1_4, SYS_GPC_MFPL_PC1MFP_PWM1_CH4},
    {PC_2, PWM_1_3, SYS_GPC_MFPL_PC2MFP_PWM1_CH3},
    {PC_3, PWM_1_2, SYS_GPC_MFPL_PC3MFP_PWM1_CH2},
    {PC_4, PWM_1_1, SYS_GPC_MFPL_PC4MFP_PWM1_CH1},
    {PC_5, PWM_1_0, SYS_GPC_MFPL_PC5MFP_PWM1_CH0},
    {PC_6, PWM_1_3, SYS_GPC_MFPL_PC6MFP_PWM1_CH3},
    {PC_7, PWM_1_2, SYS_GPC_MFPL_PC7MFP_PWM1_CH2},
    {PC_8, PWM_1_1, SYS_GPC_MFPH_PC8MFP_PWM1_CH1},
    {PC_9, PWM_1_3, SYS_GPC_MFPH_PC9MFP_PWM1_CH3},
    {PC_10, PWM_1_2, SYS_GPC_MFPH_PC10MFP_PWM1_CH2},
    {PC_11, PWM_1_1, SYS_GPC_MFPH_PC11MFP_PWM1_CH1},
    {PC_12, PWM_1_0, SYS_GPC_MFPH_PC12MFP_PWM1_CH0},
    {PD_15, PWM_0_5, SYS_GPD_MFPH_PD15MFP_PWM0_CH5},
    {PE_2, PWM_0_5, SYS_GPE_MFPL_PE2MFP_PWM0_CH5},
    {PE_3, PWM_0_4, SYS_GPE_MFPL_PE3MFP_PWM0_CH4},
    {PE_4, PWM_0_3, SYS_GPE_MFPL_PE4MFP_PWM0_CH3},
    {PE_5, PWM_0_2, SYS_GPE_MFPL_PE5MFP_PWM0_CH2},
    {PE_6, PWM_0_1, SYS_GPE_MFPL_PE6MFP_PWM0_CH1},
    {PE_7, PWM_0_0, SYS_GPE_MFPL_PE7MFP_PWM0_CH0},
    {PE_8, PWM_0_0, SYS_GPE_MFPH_PE8MFP_PWM0_CH0},
    {PE_9, PWM_0_1, SYS_GPE_MFPH_PE9MFP_PWM0_CH1},
    {PE_10, PWM_0_2, SYS_GPE_MFPH_PE10MFP_PWM0_CH2},
    {PE_11, PWM_0_3, SYS_GPE_MFPH_PE11MFP_PWM0_CH3},
    {PE_12, PWM_0_4, SYS_GPE_MFPH_PE12MFP_PWM0_CH4},
    {PE_13, PWM_0_5, SYS_GPE_MFPH_PE13MFP_PWM0_CH5},
    {NU_PINNAME_BIND(PE_13, PWM_0_5), PWM_0_5, SYS_GPE_MFPH_PE13MFP_PWM0_CH5},
    {PE_13, PWM_1_0, SYS_GPE_MFPH_PE13MFP_PWM1_CH0},
    {NU_PINNAME_BIND(PE_13, PWM_1_0), PWM_1_0, SYS_GPE_MFPH_PE13MFP_PWM1_CH0},
    {PF_4, PWM_0_1, SYS_GPF_MFPL_PF4MFP_PWM0_CH1},
    {PF_5, PWM_0_0, SYS_GPF_MFPL_PF5MFP_PWM0_CH0},
    {PF_14, PWM_0_4, SYS_GPF_MFPH_PF14MFP_PWM0_CH4},

    {NC,    NC,    0}
};

//*** SERIAL ***

const PinMap PinMap_UART_TX[] = {
    {PA_1, UART_0, SYS_GPA_MFPL_PA1MFP_UART0_TXD},
    {PA_3, UART_1, SYS_GPA_MFPL_PA3MFP_UART1_TXD},
    {PA_5, UART_0, SYS_GPA_MFPL_PA5MFP_UART0_TXD},
    {PA_7, UART_0, SYS_GPA_MFPL_PA7MFP_UART0_TXD},
    {PA_9, UART_1, SYS_GPA_MFPH_PA9MFP_UART1_TXD},
    {PA_14, UART_0, SYS_GPA_MFPH_PA14MFP_UART0_TXD},
    {PB_1, UART_2, SYS_GPB_MFPL_PB1MFP_UART2_TXD},
    {PB_3, UART_1, SYS_GPB_MFPL_PB3MFP_UART1_TXD},
    {PB_5, UART_2, SYS_GPB_MFPL_PB5MFP_UART2_TXD},
    {PB_7, UART_1, SYS_GPB_MFPL_PB7MFP_UART1_TXD},
    {PB_9, UART_0, SYS_GPB_MFPH_PB9MFP_UART0_TXD},
    {PB_13, UART_0, SYS_GPB_MFPH_PB13MFP_UART0_TXD},
    {PC_1, UART_2, SYS_GPC_MFPL_PC1MFP_UART2_TXD},
    {PC_5, UART_2, SYS_GPC_MFPL_PC5MFP_UART2_TXD},
    {PC_12, UART_0, SYS_GPC_MFPH_PC12MFP_UART0_TXD},
    {PD_3, UART_0, SYS_GPD_MFPL_PD3MFP_UART0_TXD},
    {PD_7, UART_1, SYS_GPD_MFPL_PD7MFP_UART1_TXD},
    {PD_11, UART_1, SYS_GPD_MFPH_PD11MFP_UART1_TXD},
    {PE_8, UART_2, SYS_GPE_MFPH_PE8MFP_UART2_TXD},
    {PE_13, UART_1, SYS_GPE_MFPH_PE13MFP_UART1_TXD},
    {PE_14, UART_2, SYS_GPE_MFPH_PE14MFP_UART2_TXD},
    {PF_0, UART_0, SYS_GPF_MFPL_PF0MFP_UART0_TXD},
    {NU_PINNAME_BIND(PF_0, UART_0), UART_0, SYS_GPF_MFPL_PF0MFP_UART0_TXD},
    {PF_0, UART_1, SYS_GPF_MFPL_PF0MFP_UART1_TXD},
    {NU_PINNAME_BIND(PF_0, UART_1), UART_1, SYS_GPF_MFPL_PF0MFP_UART1_TXD},
    {PF_3, UART_0, SYS_GPF_MFPL_PF3MFP_UART0_TXD},
    {PF_4, UART_2, SYS_GPF_MFPL_PF4MFP_UART2_TXD},

    {NC,    NC,     0}
};

const PinMap PinMap_UART_RX[] = {
    {PA_0, UART_0, SYS_GPA_MFPL_PA0MFP_UART0_RXD},
    {PA_2, UART_1, SYS_GPA_MFPL_PA2MFP_UART1_RXD},
    {PA_4, UART_0, SYS_GPA_MFPL_PA4MFP_UART0_RXD},
    {PA_6, UART_0, SYS_GPA_MFPL_PA6MFP_UART0_RXD},
    {PA_8, UART_1, SYS_GPA_MFPH_PA8MFP_UART1_RXD},
    {PA_15, UART_0, SYS_GPA_MFPH_PA15MFP_UART0_RXD},
    {PB_0, UART_2, SYS_GPB_MFPL_PB0MFP_UART2_RXD},
    {PB_2, UART_1, SYS_GPB_MFPL_PB2MFP_UART1_RXD},
    {PB_4, UART_2, SYS_GPB_MFPL_PB4MFP_UART2_RXD},
    {PB_6, UART_1, SYS_GPB_MFPL_PB6MFP_UART1_RXD},
    {PB_8, UART_0, SYS_GPB_MFPH_PB8MFP_UART0_RXD},
    {PB_12, UART_0, SYS_GPB_MFPH_PB12MFP_UART0_RXD},
    {PC_0, UART_2, SYS_GPC_MFPL_PC0MFP_UART2_RXD},
    {PC_4, UART_2, SYS_GPC_MFPL_PC4MFP_UART2_RXD},
    {PC_8, UART_1, SYS_GPC_MFPH_PC8MFP_UART1_RXD},
    {PC_11, UART_0, SYS_GPC_MFPH_PC11MFP_UART0_RXD},
    {PD_2, UART_0, SYS_GPD_MFPL_PD2MFP_UART0_RXD},
    {PD_6, UART_1, SYS_GPD_MFPL_PD6MFP_UART1_RXD},
    {PD_10, UART_1, SYS_GPD_MFPH_PD10MFP_UART1_RXD},
    {PD_12, UART_2, SYS_GPD_MFPH_PD12MFP_UART2_RXD},
    {PE_9, UART_2, SYS_GPE_MFPH_PE9MFP_UART2_RXD},
    {PE_15, UART_2, SYS_GPE_MFPH_PE15MFP_UART2_RXD},
    {PF_1, UART_0, SYS_GPF_MFPL_PF1MFP_UART0_RXD},
    {NU_PINNAME_BIND(PF_1, UART_0), UART_0, SYS_GPF_MFPL_PF1MFP_UART0_RXD},
    {PF_1, UART_1, SYS_GPF_MFPL_PF1MFP_UART1_RXD},
    {NU_PINNAME_BIND(PF_1, UART_1), UART_1, SYS_GPF_MFPL_PF1MFP_UART1_RXD},
    {PF_2, UART_0, SYS_GPF_MFPL_PF2MFP_UART0_RXD},
    {PF_5, UART_2, SYS_GPF_MFPL_PF5MFP_UART2_RXD},

    {NC,    NC,     0}
};

const PinMap PinMap_UART_RTS[] = {
    {PA_0, UART_1, SYS_GPA_MFPL_PA0MFP_UART1_nRTS},
    {PA_4, UART_0, SYS_GPA_MFPL_PA4MFP_UART0_nRTS},
    {PB_8, UART_1, SYS_GPB_MFPH_PB8MFP_UART1_nRTS},
    {PB_10, UART_0, SYS_GPB_MFPH_PB10MFP_UART0_nRTS},
    {PB_14, UART_0, SYS_GPB_MFPH_PB14MFP_UART0_nRTS},
    {PC_3, UART_2, SYS_GPC_MFPL_PC3MFP_UART2_nRTS},
    {PC_6, UART_0, SYS_GPC_MFPL_PC6MFP_UART0_nRTS},
    {PD_8, UART_2, SYS_GPD_MFPH_PD8MFP_UART2_nRTS},
    {PE_12, UART_1, SYS_GPE_MFPH_PE12MFP_UART1_nRTS},
    {PF_4, UART_2, SYS_GPF_MFPL_PF4MFP_UART2_nRTS},

    {NC,    NC,     0}
};

const PinMap PinMap_UART_CTS[] = {
    {PA_1, UART_1, SYS_GPA_MFPL_PA1MFP_UART1_nCTS},
    {PA_5, UART_0, SYS_GPA_MFPL_PA5MFP_UART0_nCTS},
    {PB_9, UART_1, SYS_GPB_MFPH_PB9MFP_UART1_nCTS},
    {PB_11, UART_0, SYS_GPB_MFPH_PB11MFP_UART0_nCTS},
    {PB_15, UART_0, SYS_GPB_MFPH_PB15MFP_UART0_nCTS},
    {PC_2, UART_2, SYS_GPC_MFPL_PC2MFP_UART2_nCTS},
    {PC_7, UART_0, SYS_GPC_MFPL_PC7MFP_UART0_nCTS},
    {PD_9, UART_2, SYS_GPD_MFPH_PD9MFP_UART2_nCTS},
    {PE_11, UART_1, SYS_GPE_MFPH_PE11MFP_UART1_nCTS},
    {PF_5, UART_2, SYS_GPF_MFPL_PF5MFP_UART2_nCTS},

    {NC,    NC,     0}
};

//*** SPI ***

const PinMap PinMap_SPI_MOSI[] = {
    {PA_0, SPI_0, SYS_GPA_MFPL_PA0MFP_SPI0_MOSI},
    {PB_12, SPI_0, SYS_GPB_MFPH_PB12MFP_SPI0_MOSI},
    {PD_0, SPI_0, SYS_GPD_MFPL_PD0MFP_SPI0_MOSI},
    {PF_6, SPI_0, SYS_GPF_MFPL_PF6MFP_SPI0_MOSI},

    {NC,    NC,    0}
};

const PinMap PinMap_SPI_MISO[] = {
    {PA_1, SPI_0, SYS_GPA_MFPL_PA1MFP_SPI0_MISO},
    {PB_13, SPI_0, SYS_GPB_MFPH_PB13MFP_SPI0_MISO},
    {PD_1, SPI_0, SYS_GPD_MFPL_PD1MFP_SPI0_MISO},
    {PF_7, SPI_0, SYS_GPF_MFPL_PF7MFP_SPI0_MISO},

    {NC,    NC,    0}
};

const PinMap PinMap_SPI_SCLK[] = {
    {PA_2, SPI_0, SYS_GPA_MFPL_PA2MFP_SPI0_CLK},
    {PB_14, SPI_0, SYS_GPB_MFPH_PB14MFP_SPI0_CLK},
    {PD_2, SPI_0, SYS_GPD_MFPL_PD2MFP_SPI0_CLK},

    {NC,    NC,    0}
};

const PinMap PinMap_SPI_SSEL[] = {
    {PA_3, SPI_0, SYS_GPA_MFPL_PA3MFP_SPI0_SS},
    {PB_15, SPI_0, SYS_GPB_MFPH_PB15MFP_SPI0_SS},
    {PD_3, SPI_0, SYS_GPD_MFPL_PD3MFP_SPI0_SS},

    {NC,    NC,    0}
};
