/*
 * Copyright (c) 2019, Nuvoton Technology Corporation
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flash_api.h"

#if DEVICE_FLASH

#include "flash_data.h"
#include "mbed_critical.h"
#include "M251_mem.h"

// This is a flash algo binary blob. It is PIC (position independent code) that should be stored in RAM
// NOTE: On ARMv7-M/ARMv8-M, instruction fetches are always little-endian.
static uint32_t FLASH_ALGO[] = {
    0xb088b5b0, 0x460c4613, 0x90064605, 0x92049105, 0x90032064, 0x1000f240, 0x0000f2c4, 0x60012159, 
    0x60012116, 0x60012188, 0x21016800, 0x93024208, 0x95009401, 0xe7ffd103, 0x90072001, 0xf240e038, 
    0xf2c42000, 0x68010000, 0x43112204, 0xf2406001, 0xf2c42004, 0x68010000, 0x60014311, 0x9803e7ff, 
    0x91031e41, 0xd0012800, 0xe7f8e7ff, 0x0000f24c, 0x0000f2c4, 0x222d6801, 0x60014311, 0x011cf24c, 
    0x0100f2c4, 0x2301680a, 0x600a431a, 0x42186800, 0xe7ffd103, 0x90072001, 0xf24ce00a, 0xf2c40000, 
    0x68010000, 0x43112240, 0x20006001, 0xe7ff9007, 0xb0089807, 0xb082bdb0, 0x90014601, 0xe7ff9100, 
    0x0010f24c, 0x0000f2c4, 0x21016800, 0xd0014208, 0xe7f5e7ff, 0x0000f24c, 0x0000f2c4, 0x222d6801, 
    0x60014391, 0x001cf24c, 0x0000f2c4, 0x22016801, 0x60014391, 0xb0022000, 0xb0834770, 0x90014601, 
    0xe7ff9100, 0x0010f24c, 0x0000f2c4, 0x21016800, 0xd0014208, 0xe7f5e7ff, 0x0000f24c, 0x0000f2c4, 
    0x22406801, 0x60014311, 0x000cf24c, 0x0000f2c4, 0x60012122, 0x21039801, 0xf24c4388, 0xf2c40104, 
    0x60080100, 0x0010f24c, 0x0000f2c4, 0x60012101, 0x8f6ff3bf, 0xf24ce7ff, 0xf2c40010, 0x68000000, 
    0x42082101, 0xe7ffd001, 0xf24ce7f5, 0xf2c40000, 0x68000000, 0x42082140, 0xe7ffd00b, 0x0000f24c, 
    0x0000f2c4, 0x22406801, 0x60014311, 0x90022001, 0x2000e002, 0xe7ff9002, 0xb0039802, 0xb5804770, 
    0x460ab088, 0x90064603, 0x20009105, 0x92029004, 0xe7ff9301, 0x99059804, 0xd2104288, 0x9806e7ff, 
    0x1c4a9904, 0x00899204, 0xf7ff5840, 0x9003ff96, 0xd0032800, 0x9803e7ff, 0xe0039007, 0x2000e7ea, 
    0xe7ff9007, 0xb0089807, 0xb5b0bd80, 0x4613b08a, 0x4605460c, 0x91079008, 0x20009206, 0x90039004, 
    0x94019302, 0xe7ff9500, 0x0010f24c, 0x0000f2c4, 0x21016800, 0xd0014208, 0xe7f5e7ff, 0x0000f24c, 
    0x0000f2c4, 0x22406801, 0x60014311, 0x1cc09807, 0x43882103, 0xe7ff9007, 0x28009807, 0xe7ffd04c, 
    0x7800a808, 0x28000640, 0xe7ffd10f, 0x28809807, 0xe7ffd30b, 0x90052080, 0x99059808, 0x9b049a06, 
    0xf00018d2, 0x9003f83f, 0xa808e022, 0x06407800, 0xd1112800, 0x9807e7ff, 0xd30d2810, 0x9807e7ff, 
    0x4388210f, 0x98089005, 0x9a069905, 0x18d29b04, 0xf828f000, 0xe00a9003, 0x90059807, 0x99059808, 
    0x9b049a06, 0xf00018d2, 0x9003f8de, 0xe7ffe7ff, 0x99089805, 0x90081808, 0x99049805, 0x90041808, 
    0x99079805, 0x90071a08, 0x28009803, 0xe7ffd003, 0x90092001, 0xe7afe003, 0x90092000, 0x9809e7ff, 
    0xbdb0b00a, 0xb088b5b0, 0x460c4613, 0x90074605, 0x92059106, 0x90049805, 0x300f9806, 0x4388210f, 
    0x93039006, 0x95019402, 0xf24ce7ff, 0xf2c40010, 0x68000000, 0x42082101, 0xe7ffd001, 0xf24ce7f5, 
    0xf2c40000, 0x68010000, 0x43112240, 0x98076001, 0x4388210f, 0x0104f24c, 0x0100f2c4, 0xf24c6008, 
    0xf2c4000c, 0x21270000, 0x98046001, 0xf984f000, 0x0180f24c, 0x0100f2c4, 0x98046008, 0x90041d00, 
    0xf0009804, 0xf24cf979, 0xf2c40184, 0x60080100, 0x1d009804, 0x98049004, 0xf96ef000, 0x0188f24c, 
    0x0100f2c4, 0x98046008, 0x90041d00, 0xf0009804, 0xf24cf963, 0xf2c4018c, 0x60080100, 0x1d009804, 
    0xf24c9004, 0xf2c40010, 0x21010000, 0x98066001, 0x90063810, 0x9806e7ff, 0xd0462800, 0xe7ffe7ff, 
    0x00c0f24c, 0x0000f2c4, 0x21306800, 0xd0014208, 0xe7f5e7ff, 0xf0009804, 0xf24cf93f, 0xf2c40180, 
    0x60080100, 0x1d009804, 0x98049004, 0xf934f000, 0x0184f24c, 0x0100f2c4, 0x98046008, 0x90041d00, 
    0xf24ce7ff, 0xf2c400c0, 0x68000000, 0x420821c0, 0xe7ffd001, 0x9804e7f5, 0xf91ef000, 0x0188f24c, 
    0x0100f2c4, 0x98046008, 0x90041d00, 0xf0009804, 0xf24cf913, 0xf2c4018c, 0x60080100, 0x1d009804, 
    0x98069004, 0x90063810, 0xe7ffe7b5, 0x0010f24c, 0x0000f2c4, 0x21016800, 0xd0014208, 0xe7f5e7ff, 
    0xb0082000, 0xb5b0bdb0, 0x4613b088, 0x4605460c, 0x91059006, 0x98059204, 0x21031cc0, 0x90054388, 
    0x94029303, 0xe7ff9501, 0x0010f24c, 0x0000f2c4, 0x21016800, 0xd0014208, 0xe7f5e7ff, 0x0000f24c, 
    0x0000f2c4, 0x22406801, 0x60014311, 0x000cf24c, 0x0000f2c4, 0x60012121, 0x9805e7ff, 0xd0412800, 
    0x9806e7ff, 0x43882103, 0x0104f24c, 0x0100f2c4, 0x98046008, 0xf8c0f000, 0x0108f24c, 0x0100f2c4, 
    0xf24c6008, 0xf2c40010, 0x21010000, 0xf3bf6001, 0xe7ff8f6f, 0x0010f24c, 0x0000f2c4, 0x21016800, 
    0xd0014208, 0xe7f5e7ff, 0x0000f24c, 0x0000f2c4, 0x21406800, 0xd00b4208, 0xf24ce7ff, 0xf2c40000, 
    0x68010000, 0x43112240, 0x20016001, 0xe00c9007, 0x1d009806, 0x98049006, 0x90041d00, 0x1f009805, 
    0xe7ba9005, 0x90072000, 0x9807e7ff, 0xbdb0b008, 0xb088b5b0, 0x460c4613, 0x90064605, 0x92049105, 
    0x1cc09805, 0x43882103, 0x93039005, 0x95019402, 0xf24ce7ff, 0xf2c40010, 0x68000000, 0x42082101, 
    0xe7ffd001, 0xf24ce7f5, 0xf2c40000, 0x68010000, 0x43112240, 0xf24c6001, 0xf2c4000c, 0x21000000, 
    0xe7ff6001, 0x28009805, 0xe7ffd050, 0x21039806, 0xf24c4388, 0xf2c40104, 0x60080100, 0x0008f24c, 
    0x0000f2c4, 0x60012100, 0x0010f24c, 0x0000f2c4, 0x60012101, 0x8f6ff3bf, 0xf24ce7ff, 0xf2c40010, 
    0x68000000, 0x42082101, 0xe7ffd001, 0xf24ce7f5, 0xf2c40000, 0x68000000, 0x42082140, 0xe7ffd00b, 
    0x0000f24c, 0x0000f2c4, 0x22406801, 0x60014311, 0x90079806, 0xf24ce01d, 0xf2c40008, 0x68000000, 
    0x90009904, 0xf0004608, 0x9900f817, 0xd0034281, 0x9806e7ff, 0xe00c9007, 0x1d009806, 0x98049006, 
    0x90041d00, 0x1f009805, 0xe7ab9005, 0x90079806, 0x9807e7ff, 0xbdb0b008, 0x4601b083, 0x98029002, 
    0x92021c42, 0x90017800, 0x1c429802, 0x78009202, 0x9a010200, 0x90011810, 0x1c429802, 0x78009202, 
    0x9a010400, 0x90011810, 0x1c429802, 0x78009202, 0x9a010600, 0x90011810, 0x91009801, 0x4770b003, 
    0x00000000, 
};

static const flash_algo_t flash_algo_config = {
    .init = 0x00000001,
    .uninit = 0x000000b7,
    .erase_sector = 0x000000fb,
    .program_page = 0x000001eb,
    .static_base = 0x000006a0,
    .algo_blob = FLASH_ALGO
};

/* Secure flash */
static const sector_info_t sectors_info[] = {
    {MBED_ROM_START, 0x200},                                // (start, sector size)
};

/* Secure flash */
static const flash_target_config_t flash_target_config = {
    .page_size  = 4,                                        // 4 bytes
                                                            // Here page_size is program unit, which is different
                                                            // than FMC definition.
    .flash_start = MBED_ROM_START,
    .flash_size = MBED_ROM_SIZE,
    .sectors = sectors_info,
    .sector_info_count = sizeof(sectors_info) / sizeof(sector_info_t)
};

void flash_set_target_config(flash_t *obj)
{
    obj->flash_algo = &flash_algo_config;
    obj->target_config = &flash_target_config;
}
#endif  // #if DEVICE_FLASH
