/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef DMAC_IOBITMASK_H
#define DMAC_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define DMAC_N0SA_0S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_0S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_0S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_0S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_0S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_0S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_0S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_0S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_0S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_0S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_0S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_0S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_0S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_0S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_0S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_0S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_0S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_0S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_0S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_0S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_0S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_0S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_0S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_0S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_0S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_0S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_0S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_0S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_0S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_0S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_0S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_0S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_0S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_0S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_0S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_0S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_0S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_0S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_0S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_0S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_0S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_0S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_0S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_0S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_0S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_0S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_0S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_0S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_0S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_0S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_0S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_0S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_0S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_0S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_0S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_0S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_0S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_0S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_0S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_0S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_0S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_0S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_0S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_0S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_0S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_0S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_0S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_0S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_0S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_0S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_0S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_0S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_0S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_0S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_0S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_0S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_0S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_0S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_0S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_0S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_0S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_0S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_0S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_0S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_0S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_0S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_0S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_0S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_0S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_0S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_0S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_0S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_0S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_0S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_0S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_0S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_0S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_0S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_0S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_0S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_0S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_0S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_0S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_0S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_0S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_0S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_0S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_0S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_0S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_0S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_0S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_0S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_0S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_0S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_1S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_1S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_1S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_1S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_1S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_1S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_1S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_1S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_1S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_1S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_1S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_1S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_1S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_1S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_1S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_1S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_1S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_1S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_1S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_1S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_1S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_1S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_1S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_1S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_1S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_1S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_1S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_1S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_1S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_1S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_1S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_1S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_1S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_1S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_1S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_1S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_1S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_1S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_1S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_1S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_1S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_1S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_1S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_1S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_1S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_1S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_1S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_1S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_1S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_1S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_1S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_1S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_1S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_1S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_1S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_1S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_1S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_1S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_1S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_1S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_1S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_1S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_1S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_1S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_1S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_1S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_1S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_1S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_1S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_1S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_1S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_1S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_1S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_1S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_1S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_1S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_1S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_1S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_1S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_1S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_1S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_1S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_1S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_1S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_1S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_1S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_1S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_1S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_1S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_1S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_1S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_1S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_1S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_1S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_1S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_1S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_1S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_1S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_1S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_1S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_1S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_1S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_1S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_1S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_1S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_1S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_1S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_1S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_1S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_1S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_1S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_1S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_1S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_1S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_2S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_2S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_2S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_2S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_2S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_2S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_2S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_2S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_2S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_2S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_2S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_2S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_2S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_2S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_2S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_2S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_2S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_2S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_2S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_2S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_2S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_2S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_2S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_2S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_2S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_2S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_2S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_2S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_2S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_2S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_2S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_2S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_2S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_2S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_2S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_2S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_2S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_2S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_2S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_2S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_2S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_2S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_2S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_2S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_2S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_2S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_2S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_2S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_2S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_2S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_2S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_2S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_2S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_2S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_2S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_2S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_2S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_2S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_2S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_2S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_2S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_2S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_2S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_2S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_2S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_2S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_2S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_2S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_2S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_2S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_2S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_2S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_2S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_2S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_2S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_2S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_2S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_2S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_2S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_2S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_2S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_2S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_2S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_2S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_2S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_2S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_2S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_2S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_2S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_2S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_2S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_2S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_2S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_2S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_2S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_2S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_2S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_2S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_2S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_2S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_2S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_2S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_2S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_2S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_2S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_2S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_2S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_2S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_2S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_2S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_2S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_2S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_2S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_2S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_3S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_3S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_3S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_3S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_3S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_3S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_3S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_3S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_3S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_3S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_3S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_3S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_3S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_3S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_3S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_3S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_3S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_3S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_3S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_3S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_3S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_3S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_3S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_3S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_3S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_3S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_3S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_3S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_3S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_3S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_3S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_3S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_3S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_3S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_3S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_3S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_3S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_3S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_3S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_3S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_3S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_3S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_3S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_3S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_3S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_3S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_3S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_3S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_3S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_3S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_3S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_3S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_3S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_3S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_3S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_3S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_3S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_3S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_3S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_3S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_3S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_3S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_3S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_3S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_3S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_3S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_3S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_3S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_3S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_3S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_3S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_3S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_3S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_3S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_3S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_3S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_3S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_3S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_3S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_3S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_3S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_3S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_3S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_3S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_3S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_3S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_3S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_3S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_3S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_3S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_3S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_3S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_3S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_3S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_3S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_3S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_3S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_3S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_3S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_3S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_3S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_3S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_3S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_3S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_3S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_3S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_3S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_3S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_3S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_3S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_3S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_3S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_3S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_3S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_4S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_4S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_4S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_4S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_4S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_4S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_4S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_4S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_4S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_4S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_4S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_4S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_4S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_4S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_4S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_4S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_4S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_4S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_4S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_4S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_4S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_4S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_4S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_4S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_4S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_4S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_4S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_4S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_4S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_4S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_4S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_4S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_4S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_4S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_4S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_4S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_4S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_4S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_4S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_4S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_4S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_4S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_4S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_4S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_4S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_4S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_4S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_4S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_4S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_4S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_4S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_4S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_4S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_4S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_4S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_4S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_4S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_4S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_4S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_4S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_4S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_4S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_4S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_4S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_4S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_4S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_4S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_4S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_4S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_4S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_4S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_4S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_4S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_4S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_4S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_4S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_4S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_4S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_4S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_4S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_4S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_4S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_4S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_4S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_4S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_4S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_4S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_4S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_4S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_4S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_4S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_4S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_4S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_4S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_4S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_4S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_4S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_4S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_4S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_4S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_4S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_4S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_4S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_4S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_4S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_4S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_4S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_4S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_4S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_4S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_4S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_4S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_4S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_4S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_5S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_5S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_5S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_5S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_5S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_5S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_5S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_5S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_5S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_5S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_5S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_5S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_5S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_5S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_5S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_5S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_5S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_5S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_5S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_5S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_5S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_5S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_5S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_5S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_5S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_5S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_5S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_5S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_5S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_5S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_5S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_5S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_5S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_5S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_5S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_5S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_5S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_5S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_5S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_5S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_5S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_5S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_5S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_5S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_5S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_5S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_5S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_5S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_5S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_5S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_5S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_5S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_5S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_5S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_5S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_5S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_5S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_5S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_5S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_5S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_5S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_5S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_5S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_5S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_5S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_5S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_5S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_5S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_5S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_5S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_5S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_5S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_5S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_5S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_5S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_5S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_5S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_5S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_5S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_5S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_5S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_5S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_5S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_5S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_5S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_5S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_5S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_5S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_5S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_5S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_5S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_5S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_5S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_5S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_5S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_5S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_5S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_5S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_5S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_5S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_5S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_5S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_5S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_5S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_5S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_5S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_5S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_5S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_5S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_5S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_5S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_5S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_5S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_5S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_6S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_6S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_6S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_6S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_6S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_6S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_6S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_6S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_6S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_6S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_6S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_6S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_6S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_6S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_6S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_6S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_6S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_6S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_6S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_6S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_6S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_6S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_6S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_6S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_6S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_6S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_6S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_6S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_6S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_6S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_6S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_6S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_6S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_6S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_6S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_6S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_6S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_6S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_6S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_6S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_6S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_6S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_6S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_6S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_6S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_6S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_6S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_6S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_6S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_6S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_6S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_6S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_6S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_6S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_6S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_6S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_6S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_6S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_6S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_6S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_6S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_6S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_6S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_6S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_6S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_6S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_6S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_6S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_6S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_6S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_6S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_6S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_6S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_6S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_6S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_6S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_6S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_6S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_6S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_6S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_6S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_6S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_6S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_6S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_6S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_6S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_6S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_6S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_6S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_6S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_6S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_6S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_6S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_6S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_6S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_6S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_6S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_6S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_6S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_6S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_6S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_6S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_6S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_6S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_6S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_6S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_6S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_6S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_6S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_6S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_6S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_6S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_6S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_6S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_7S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_7S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_7S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_7S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_7S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_7S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_7S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_7S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_7S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_7S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_7S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_7S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_7S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_7S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_7S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_7S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_7S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_7S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_7S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_7S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_7S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_7S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_7S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_7S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_7S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_7S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_7S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_7S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_7S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_7S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_7S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_7S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_7S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_7S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_7S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_7S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_7S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_7S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_7S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_7S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_7S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_7S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_7S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_7S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_7S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_7S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_7S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_7S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_7S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_7S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_7S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_7S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_7S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_7S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_7S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_7S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_7S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_7S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_7S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_7S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_7S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_7S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_7S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_7S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_7S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_7S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_7S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_7S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_7S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_7S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_7S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_7S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_7S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_7S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_7S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_7S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_7S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_7S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_7S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_7S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_7S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_7S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_7S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_7S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_7S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_7S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_7S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_7S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_7S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_7S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_7S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_7S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_7S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_7S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_7S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_7S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_7S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_7S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_7S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_7S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_7S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_7S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_7S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_7S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_7S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_7S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_7S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_7S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_7S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_7S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_7S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_7S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_7S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_7S_CRLA_SHIFT                                                (0u)
#define DMAC_DCTRL_0_7S_PR                                                     (0x00000001u)
#define DMAC_DCTRL_0_7S_PR_SHIFT                                               (0u)
#define DMAC_DCTRL_0_7S_LVINT                                                  (0x00000002u)
#define DMAC_DCTRL_0_7S_LVINT_SHIFT                                            (1u)
#define DMAC_DCTRL_0_7S_LDPR                                                   (0x00070000u)
#define DMAC_DCTRL_0_7S_LDPR_SHIFT                                             (16u)
#define DMAC_DCTRL_0_7S_LDCA                                                   (0x00F00000u)
#define DMAC_DCTRL_0_7S_LDCA_SHIFT                                             (20u)
#define DMAC_DCTRL_0_7S_LWPR                                                   (0x07000000u)
#define DMAC_DCTRL_0_7S_LWPR_SHIFT                                             (24u)
#define DMAC_DCTRL_0_7S_LWCA                                                   (0xF0000000u)
#define DMAC_DCTRL_0_7S_LWCA_SHIFT                                             (28u)
#define DMAC_DSTAT_EN_0_7S_EN0                                                 (0x00000001u)
#define DMAC_DSTAT_EN_0_7S_EN0_SHIFT                                           (0u)
#define DMAC_DSTAT_EN_0_7S_EN1                                                 (0x00000002u)
#define DMAC_DSTAT_EN_0_7S_EN1_SHIFT                                           (1u)
#define DMAC_DSTAT_EN_0_7S_EN2                                                 (0x00000004u)
#define DMAC_DSTAT_EN_0_7S_EN2_SHIFT                                           (2u)
#define DMAC_DSTAT_EN_0_7S_EN3                                                 (0x00000008u)
#define DMAC_DSTAT_EN_0_7S_EN3_SHIFT                                           (3u)
#define DMAC_DSTAT_EN_0_7S_EN4                                                 (0x00000010u)
#define DMAC_DSTAT_EN_0_7S_EN4_SHIFT                                           (4u)
#define DMAC_DSTAT_EN_0_7S_EN5                                                 (0x00000020u)
#define DMAC_DSTAT_EN_0_7S_EN5_SHIFT                                           (5u)
#define DMAC_DSTAT_EN_0_7S_EN6                                                 (0x00000040u)
#define DMAC_DSTAT_EN_0_7S_EN6_SHIFT                                           (6u)
#define DMAC_DSTAT_EN_0_7S_EN7                                                 (0x00000080u)
#define DMAC_DSTAT_EN_0_7S_EN7_SHIFT                                           (7u)
#define DMAC_DSTAT_ER_0_7S_ER0                                                 (0x00000001u)
#define DMAC_DSTAT_ER_0_7S_ER0_SHIFT                                           (0u)
#define DMAC_DSTAT_ER_0_7S_ER1                                                 (0x00000002u)
#define DMAC_DSTAT_ER_0_7S_ER1_SHIFT                                           (1u)
#define DMAC_DSTAT_ER_0_7S_ER2                                                 (0x00000004u)
#define DMAC_DSTAT_ER_0_7S_ER2_SHIFT                                           (2u)
#define DMAC_DSTAT_ER_0_7S_ER3                                                 (0x00000008u)
#define DMAC_DSTAT_ER_0_7S_ER3_SHIFT                                           (3u)
#define DMAC_DSTAT_ER_0_7S_ER4                                                 (0x00000010u)
#define DMAC_DSTAT_ER_0_7S_ER4_SHIFT                                           (4u)
#define DMAC_DSTAT_ER_0_7S_ER5                                                 (0x00000020u)
#define DMAC_DSTAT_ER_0_7S_ER5_SHIFT                                           (5u)
#define DMAC_DSTAT_ER_0_7S_ER6                                                 (0x00000040u)
#define DMAC_DSTAT_ER_0_7S_ER6_SHIFT                                           (6u)
#define DMAC_DSTAT_ER_0_7S_ER7                                                 (0x00000080u)
#define DMAC_DSTAT_ER_0_7S_ER7_SHIFT                                           (7u)
#define DMAC_DSTAT_END_0_7S_END0                                               (0x00000001u)
#define DMAC_DSTAT_END_0_7S_END0_SHIFT                                         (0u)
#define DMAC_DSTAT_END_0_7S_END1                                               (0x00000002u)
#define DMAC_DSTAT_END_0_7S_END1_SHIFT                                         (1u)
#define DMAC_DSTAT_END_0_7S_END2                                               (0x00000004u)
#define DMAC_DSTAT_END_0_7S_END2_SHIFT                                         (2u)
#define DMAC_DSTAT_END_0_7S_END3                                               (0x00000008u)
#define DMAC_DSTAT_END_0_7S_END3_SHIFT                                         (3u)
#define DMAC_DSTAT_END_0_7S_END4                                               (0x00000010u)
#define DMAC_DSTAT_END_0_7S_END4_SHIFT                                         (4u)
#define DMAC_DSTAT_END_0_7S_END5                                               (0x00000020u)
#define DMAC_DSTAT_END_0_7S_END5_SHIFT                                         (5u)
#define DMAC_DSTAT_END_0_7S_END6                                               (0x00000040u)
#define DMAC_DSTAT_END_0_7S_END6_SHIFT                                         (6u)
#define DMAC_DSTAT_END_0_7S_END7                                               (0x00000080u)
#define DMAC_DSTAT_END_0_7S_END7_SHIFT                                         (7u)
#define DMAC_DSTAT_TC_0_7S_TC0                                                 (0x00000001u)
#define DMAC_DSTAT_TC_0_7S_TC0_SHIFT                                           (0u)
#define DMAC_DSTAT_TC_0_7S_TC1                                                 (0x00000002u)
#define DMAC_DSTAT_TC_0_7S_TC1_SHIFT                                           (1u)
#define DMAC_DSTAT_TC_0_7S_TC2                                                 (0x00000004u)
#define DMAC_DSTAT_TC_0_7S_TC2_SHIFT                                           (2u)
#define DMAC_DSTAT_TC_0_7S_TC3                                                 (0x00000008u)
#define DMAC_DSTAT_TC_0_7S_TC3_SHIFT                                           (3u)
#define DMAC_DSTAT_TC_0_7S_TC4                                                 (0x00000010u)
#define DMAC_DSTAT_TC_0_7S_TC4_SHIFT                                           (4u)
#define DMAC_DSTAT_TC_0_7S_TC5                                                 (0x00000020u)
#define DMAC_DSTAT_TC_0_7S_TC5_SHIFT                                           (5u)
#define DMAC_DSTAT_TC_0_7S_TC6                                                 (0x00000040u)
#define DMAC_DSTAT_TC_0_7S_TC6_SHIFT                                           (6u)
#define DMAC_DSTAT_TC_0_7S_TC7                                                 (0x00000080u)
#define DMAC_DSTAT_TC_0_7S_TC7_SHIFT                                           (7u)
#define DMAC_DSTAT_SUS_0_7S_SUS0                                               (0x00000001u)
#define DMAC_DSTAT_SUS_0_7S_SUS0_SHIFT                                         (0u)
#define DMAC_DSTAT_SUS_0_7S_SUS1                                               (0x00000002u)
#define DMAC_DSTAT_SUS_0_7S_SUS1_SHIFT                                         (1u)
#define DMAC_DSTAT_SUS_0_7S_SUS2                                               (0x00000004u)
#define DMAC_DSTAT_SUS_0_7S_SUS2_SHIFT                                         (2u)
#define DMAC_DSTAT_SUS_0_7S_SUS3                                               (0x00000008u)
#define DMAC_DSTAT_SUS_0_7S_SUS3_SHIFT                                         (3u)
#define DMAC_DSTAT_SUS_0_7S_SUS4                                               (0x00000010u)
#define DMAC_DSTAT_SUS_0_7S_SUS4_SHIFT                                         (4u)
#define DMAC_DSTAT_SUS_0_7S_SUS5                                               (0x00000020u)
#define DMAC_DSTAT_SUS_0_7S_SUS5_SHIFT                                         (5u)
#define DMAC_DSTAT_SUS_0_7S_SUS6                                               (0x00000040u)
#define DMAC_DSTAT_SUS_0_7S_SUS6_SHIFT                                         (6u)
#define DMAC_DSTAT_SUS_0_7S_SUS7                                               (0x00000080u)
#define DMAC_DSTAT_SUS_0_7S_SUS7_SHIFT                                         (7u)
#define DMAC_N0SA_8S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_8S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_8S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_8S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_8S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_8S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_8S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_8S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_8S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_8S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_8S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_8S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_8S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_8S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_8S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_8S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_8S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_8S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_8S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_8S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_8S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_8S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_8S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_8S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_8S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_8S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_8S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_8S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_8S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_8S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_8S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_8S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_8S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_8S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_8S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_8S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_8S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_8S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_8S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_8S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_8S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_8S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_8S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_8S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_8S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_8S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_8S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_8S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_8S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_8S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_8S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_8S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_8S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_8S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_8S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_8S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_8S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_8S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_8S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_8S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_8S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_8S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_8S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_8S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_8S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_8S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_8S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_8S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_8S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_8S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_8S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_8S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_8S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_8S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_8S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_8S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_8S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_8S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_8S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_8S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_8S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_8S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_8S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_8S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_8S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_8S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_8S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_8S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_8S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_8S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_8S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_8S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_8S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_8S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_8S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_8S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_8S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_8S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_8S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_8S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_8S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_8S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_8S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_8S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_8S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_8S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_8S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_8S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_8S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_8S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_8S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_8S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_8S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_8S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_9S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_9S_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_9S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_9S_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_9S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_9S_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_9S_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_9S_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_9S_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_9S_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_9S_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_9S_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_9S_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_9S_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_9S_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_9S_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_9S_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_9S_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_9S_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_9S_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_9S_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_9S_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_9S_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_9S_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_9S_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_9S_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_9S_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_9S_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_9S_END                                                     (0x00000020u)
#define DMAC_CHSTAT_9S_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_9S_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_9S_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_9S_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_9S_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_9S_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_9S_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_9S_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_9S_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_9S_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_9S_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_9S_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_9S_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_9S_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_9S_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_9S_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_9S_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_9S_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_9S_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_9S_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_9S_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_9S_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_9S_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_9S_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_9S_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_9S_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_9S_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_9S_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_9S_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_9S_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_9S_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_9S_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_9S_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_9S_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_9S_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_9S_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_9S_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_9S_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_9S_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_9S_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_9S_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_9S_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_9S_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_9S_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_9S_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_9S_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_9S_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_9S_AM                                                       (0x00000700u)
#define DMAC_CHCFG_9S_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_9S_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_9S_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_9S_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_9S_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_9S_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_9S_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_9S_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_9S_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_9S_TM                                                       (0x00400000u)
#define DMAC_CHCFG_9S_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_9S_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_9S_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_9S_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_9S_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_9S_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_9S_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_9S_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_9S_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_9S_REN                                                      (0x40000000u)
#define DMAC_CHCFG_9S_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_9S_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_9S_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_9S_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_9S_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_9S_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_9S_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_9S_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_9S_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_9S_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_9S_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_9S_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_9S_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_9S_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_9S_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_9S_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_9S_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_10S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N0SA_10S_SA_SHIFT                                                 (0u)
#define DMAC_N0DA_10S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N0DA_10S_DA_SHIFT                                                 (0u)
#define DMAC_N0TB_10S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N0TB_10S_TB_SHIFT                                                 (0u)
#define DMAC_N1SA_10S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N1SA_10S_SA_SHIFT                                                 (0u)
#define DMAC_N1DA_10S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N1DA_10S_DA_SHIFT                                                 (0u)
#define DMAC_N1TB_10S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N1TB_10S_TB_SHIFT                                                 (0u)
#define DMAC_CRSA_10S_CRSA                                                     (0xFFFFFFFFu)
#define DMAC_CRSA_10S_CRSA_SHIFT                                               (0u)
#define DMAC_CRDA_10S_CRDA                                                     (0xFFFFFFFFu)
#define DMAC_CRDA_10S_CRDA_SHIFT                                               (0u)
#define DMAC_CRTB_10S_CRTB                                                     (0xFFFFFFFFu)
#define DMAC_CRTB_10S_CRTB_SHIFT                                               (0u)
#define DMAC_CHSTAT_10S_EN                                                     (0x00000001u)
#define DMAC_CHSTAT_10S_EN_SHIFT                                               (0u)
#define DMAC_CHSTAT_10S_RQST                                                   (0x00000002u)
#define DMAC_CHSTAT_10S_RQST_SHIFT                                             (1u)
#define DMAC_CHSTAT_10S_TACT                                                   (0x00000004u)
#define DMAC_CHSTAT_10S_TACT_SHIFT                                             (2u)
#define DMAC_CHSTAT_10S_SUS                                                    (0x00000008u)
#define DMAC_CHSTAT_10S_SUS_SHIFT                                              (3u)
#define DMAC_CHSTAT_10S_ER                                                     (0x00000010u)
#define DMAC_CHSTAT_10S_ER_SHIFT                                               (4u)
#define DMAC_CHSTAT_10S_END                                                    (0x00000020u)
#define DMAC_CHSTAT_10S_END_SHIFT                                              (5u)
#define DMAC_CHSTAT_10S_TC                                                     (0x00000040u)
#define DMAC_CHSTAT_10S_TC_SHIFT                                               (6u)
#define DMAC_CHSTAT_10S_SR                                                     (0x00000080u)
#define DMAC_CHSTAT_10S_SR_SHIFT                                               (7u)
#define DMAC_CHSTAT_10S_DL                                                     (0x00000100u)
#define DMAC_CHSTAT_10S_DL_SHIFT                                               (8u)
#define DMAC_CHSTAT_10S_DW                                                     (0x00000200u)
#define DMAC_CHSTAT_10S_DW_SHIFT                                               (9u)
#define DMAC_CHSTAT_10S_DER                                                    (0x00000400u)
#define DMAC_CHSTAT_10S_DER_SHIFT                                              (10u)
#define DMAC_CHSTAT_10S_MODE                                                   (0x00000800u)
#define DMAC_CHSTAT_10S_MODE_SHIFT                                             (11u)
#define DMAC_CHSTAT_10S_INTMSK                                                 (0x00010000u)
#define DMAC_CHSTAT_10S_INTMSK_SHIFT                                           (16u)
#define DMAC_CHCTRL_10S_SETEN                                                  (0x00000001u)
#define DMAC_CHCTRL_10S_SETEN_SHIFT                                            (0u)
#define DMAC_CHCTRL_10S_CLREN                                                  (0x00000002u)
#define DMAC_CHCTRL_10S_CLREN_SHIFT                                            (1u)
#define DMAC_CHCTRL_10S_STG                                                    (0x00000004u)
#define DMAC_CHCTRL_10S_STG_SHIFT                                              (2u)
#define DMAC_CHCTRL_10S_SWRST                                                  (0x00000008u)
#define DMAC_CHCTRL_10S_SWRST_SHIFT                                            (3u)
#define DMAC_CHCTRL_10S_CLRRQ                                                  (0x00000010u)
#define DMAC_CHCTRL_10S_CLRRQ_SHIFT                                            (4u)
#define DMAC_CHCTRL_10S_CLREND                                                 (0x00000020u)
#define DMAC_CHCTRL_10S_CLREND_SHIFT                                           (5u)
#define DMAC_CHCTRL_10S_CLRTC                                                  (0x00000040u)
#define DMAC_CHCTRL_10S_CLRTC_SHIFT                                            (6u)
#define DMAC_CHCTRL_10S_SETSUS                                                 (0x00000100u)
#define DMAC_CHCTRL_10S_SETSUS_SHIFT                                           (8u)
#define DMAC_CHCTRL_10S_CLRSUS                                                 (0x00000200u)
#define DMAC_CHCTRL_10S_CLRSUS_SHIFT                                           (9u)
#define DMAC_CHCTRL_10S_SETINTMSK                                              (0x00010000u)
#define DMAC_CHCTRL_10S_SETINTMSK_SHIFT                                        (16u)
#define DMAC_CHCTRL_10S_CLRINTMSK                                              (0x00020000u)
#define DMAC_CHCTRL_10S_CLRINTMSK_SHIFT                                        (17u)
#define DMAC_CHCFG_10S_SEL                                                     (0x00000007u)
#define DMAC_CHCFG_10S_SEL_SHIFT                                               (0u)
#define DMAC_CHCFG_10S_REQD                                                    (0x00000008u)
#define DMAC_CHCFG_10S_REQD_SHIFT                                              (3u)
#define DMAC_CHCFG_10S_LOEN                                                    (0x00000010u)
#define DMAC_CHCFG_10S_LOEN_SHIFT                                              (4u)
#define DMAC_CHCFG_10S_HIEN                                                    (0x00000020u)
#define DMAC_CHCFG_10S_HIEN_SHIFT                                              (5u)
#define DMAC_CHCFG_10S_LVL                                                     (0x00000040u)
#define DMAC_CHCFG_10S_LVL_SHIFT                                               (6u)
#define DMAC_CHCFG_10S_AM                                                      (0x00000700u)
#define DMAC_CHCFG_10S_AM_SHIFT                                                (8u)
#define DMAC_CHCFG_10S_SDS                                                     (0x0000F000u)
#define DMAC_CHCFG_10S_SDS_SHIFT                                               (12u)
#define DMAC_CHCFG_10S_DDS                                                     (0x000F0000u)
#define DMAC_CHCFG_10S_DDS_SHIFT                                               (16u)
#define DMAC_CHCFG_10S_SAD                                                     (0x00100000u)
#define DMAC_CHCFG_10S_SAD_SHIFT                                               (20u)
#define DMAC_CHCFG_10S_DAD                                                     (0x00200000u)
#define DMAC_CHCFG_10S_DAD_SHIFT                                               (21u)
#define DMAC_CHCFG_10S_TM                                                      (0x00400000u)
#define DMAC_CHCFG_10S_TM_SHIFT                                                (22u)
#define DMAC_CHCFG_10S_DEM                                                     (0x01000000u)
#define DMAC_CHCFG_10S_DEM_SHIFT                                               (24u)
#define DMAC_CHCFG_10S_SBE                                                     (0x08000000u)
#define DMAC_CHCFG_10S_SBE_SHIFT                                               (27u)
#define DMAC_CHCFG_10S_RSEL                                                    (0x10000000u)
#define DMAC_CHCFG_10S_RSEL_SHIFT                                              (28u)
#define DMAC_CHCFG_10S_RSW                                                     (0x20000000u)
#define DMAC_CHCFG_10S_RSW_SHIFT                                               (29u)
#define DMAC_CHCFG_10S_REN                                                     (0x40000000u)
#define DMAC_CHCFG_10S_REN_SHIFT                                               (30u)
#define DMAC_CHCFG_10S_DMS                                                     (0x80000000u)
#define DMAC_CHCFG_10S_DMS_SHIFT                                               (31u)
#define DMAC_CHITVL_10S_ITVL                                                   (0x0000FFFFu)
#define DMAC_CHITVL_10S_ITVL_SHIFT                                             (0u)
#define DMAC_CHEXT_10S_SPR                                                     (0x00000007u)
#define DMAC_CHEXT_10S_SPR_SHIFT                                               (0u)
#define DMAC_CHEXT_10S_SCA                                                     (0x000000F0u)
#define DMAC_CHEXT_10S_SCA_SHIFT                                               (4u)
#define DMAC_CHEXT_10S_DPR                                                     (0x00000700u)
#define DMAC_CHEXT_10S_DPR_SHIFT                                               (8u)
#define DMAC_CHEXT_10S_DCA                                                     (0x0000F000u)
#define DMAC_CHEXT_10S_DCA_SHIFT                                               (12u)
#define DMAC_NXLA_10S_NXLA                                                     (0xFFFFFFFFu)
#define DMAC_NXLA_10S_NXLA_SHIFT                                               (0u)
#define DMAC_CRLA_10S_CRLA                                                     (0xFFFFFFFFu)
#define DMAC_CRLA_10S_CRLA_SHIFT                                               (0u)
#define DMAC_N0SA_11S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N0SA_11S_SA_SHIFT                                                 (0u)
#define DMAC_N0DA_11S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N0DA_11S_DA_SHIFT                                                 (0u)
#define DMAC_N0TB_11S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N0TB_11S_TB_SHIFT                                                 (0u)
#define DMAC_N1SA_11S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N1SA_11S_SA_SHIFT                                                 (0u)
#define DMAC_N1DA_11S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N1DA_11S_DA_SHIFT                                                 (0u)
#define DMAC_N1TB_11S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N1TB_11S_TB_SHIFT                                                 (0u)
#define DMAC_CRSA_11S_CRSA                                                     (0xFFFFFFFFu)
#define DMAC_CRSA_11S_CRSA_SHIFT                                               (0u)
#define DMAC_CRDA_11S_CRDA                                                     (0xFFFFFFFFu)
#define DMAC_CRDA_11S_CRDA_SHIFT                                               (0u)
#define DMAC_CRTB_11S_CRTB                                                     (0xFFFFFFFFu)
#define DMAC_CRTB_11S_CRTB_SHIFT                                               (0u)
#define DMAC_CHSTAT_11S_EN                                                     (0x00000001u)
#define DMAC_CHSTAT_11S_EN_SHIFT                                               (0u)
#define DMAC_CHSTAT_11S_RQST                                                   (0x00000002u)
#define DMAC_CHSTAT_11S_RQST_SHIFT                                             (1u)
#define DMAC_CHSTAT_11S_TACT                                                   (0x00000004u)
#define DMAC_CHSTAT_11S_TACT_SHIFT                                             (2u)
#define DMAC_CHSTAT_11S_SUS                                                    (0x00000008u)
#define DMAC_CHSTAT_11S_SUS_SHIFT                                              (3u)
#define DMAC_CHSTAT_11S_ER                                                     (0x00000010u)
#define DMAC_CHSTAT_11S_ER_SHIFT                                               (4u)
#define DMAC_CHSTAT_11S_END                                                    (0x00000020u)
#define DMAC_CHSTAT_11S_END_SHIFT                                              (5u)
#define DMAC_CHSTAT_11S_TC                                                     (0x00000040u)
#define DMAC_CHSTAT_11S_TC_SHIFT                                               (6u)
#define DMAC_CHSTAT_11S_SR                                                     (0x00000080u)
#define DMAC_CHSTAT_11S_SR_SHIFT                                               (7u)
#define DMAC_CHSTAT_11S_DL                                                     (0x00000100u)
#define DMAC_CHSTAT_11S_DL_SHIFT                                               (8u)
#define DMAC_CHSTAT_11S_DW                                                     (0x00000200u)
#define DMAC_CHSTAT_11S_DW_SHIFT                                               (9u)
#define DMAC_CHSTAT_11S_DER                                                    (0x00000400u)
#define DMAC_CHSTAT_11S_DER_SHIFT                                              (10u)
#define DMAC_CHSTAT_11S_MODE                                                   (0x00000800u)
#define DMAC_CHSTAT_11S_MODE_SHIFT                                             (11u)
#define DMAC_CHSTAT_11S_INTMSK                                                 (0x00010000u)
#define DMAC_CHSTAT_11S_INTMSK_SHIFT                                           (16u)
#define DMAC_CHCTRL_11S_SETEN                                                  (0x00000001u)
#define DMAC_CHCTRL_11S_SETEN_SHIFT                                            (0u)
#define DMAC_CHCTRL_11S_CLREN                                                  (0x00000002u)
#define DMAC_CHCTRL_11S_CLREN_SHIFT                                            (1u)
#define DMAC_CHCTRL_11S_STG                                                    (0x00000004u)
#define DMAC_CHCTRL_11S_STG_SHIFT                                              (2u)
#define DMAC_CHCTRL_11S_SWRST                                                  (0x00000008u)
#define DMAC_CHCTRL_11S_SWRST_SHIFT                                            (3u)
#define DMAC_CHCTRL_11S_CLRRQ                                                  (0x00000010u)
#define DMAC_CHCTRL_11S_CLRRQ_SHIFT                                            (4u)
#define DMAC_CHCTRL_11S_CLREND                                                 (0x00000020u)
#define DMAC_CHCTRL_11S_CLREND_SHIFT                                           (5u)
#define DMAC_CHCTRL_11S_CLRTC                                                  (0x00000040u)
#define DMAC_CHCTRL_11S_CLRTC_SHIFT                                            (6u)
#define DMAC_CHCTRL_11S_SETSUS                                                 (0x00000100u)
#define DMAC_CHCTRL_11S_SETSUS_SHIFT                                           (8u)
#define DMAC_CHCTRL_11S_CLRSUS                                                 (0x00000200u)
#define DMAC_CHCTRL_11S_CLRSUS_SHIFT                                           (9u)
#define DMAC_CHCTRL_11S_SETINTMSK                                              (0x00010000u)
#define DMAC_CHCTRL_11S_SETINTMSK_SHIFT                                        (16u)
#define DMAC_CHCTRL_11S_CLRINTMSK                                              (0x00020000u)
#define DMAC_CHCTRL_11S_CLRINTMSK_SHIFT                                        (17u)
#define DMAC_CHCFG_11S_SEL                                                     (0x00000007u)
#define DMAC_CHCFG_11S_SEL_SHIFT                                               (0u)
#define DMAC_CHCFG_11S_REQD                                                    (0x00000008u)
#define DMAC_CHCFG_11S_REQD_SHIFT                                              (3u)
#define DMAC_CHCFG_11S_LOEN                                                    (0x00000010u)
#define DMAC_CHCFG_11S_LOEN_SHIFT                                              (4u)
#define DMAC_CHCFG_11S_HIEN                                                    (0x00000020u)
#define DMAC_CHCFG_11S_HIEN_SHIFT                                              (5u)
#define DMAC_CHCFG_11S_LVL                                                     (0x00000040u)
#define DMAC_CHCFG_11S_LVL_SHIFT                                               (6u)
#define DMAC_CHCFG_11S_AM                                                      (0x00000700u)
#define DMAC_CHCFG_11S_AM_SHIFT                                                (8u)
#define DMAC_CHCFG_11S_SDS                                                     (0x0000F000u)
#define DMAC_CHCFG_11S_SDS_SHIFT                                               (12u)
#define DMAC_CHCFG_11S_DDS                                                     (0x000F0000u)
#define DMAC_CHCFG_11S_DDS_SHIFT                                               (16u)
#define DMAC_CHCFG_11S_SAD                                                     (0x00100000u)
#define DMAC_CHCFG_11S_SAD_SHIFT                                               (20u)
#define DMAC_CHCFG_11S_DAD                                                     (0x00200000u)
#define DMAC_CHCFG_11S_DAD_SHIFT                                               (21u)
#define DMAC_CHCFG_11S_TM                                                      (0x00400000u)
#define DMAC_CHCFG_11S_TM_SHIFT                                                (22u)
#define DMAC_CHCFG_11S_DEM                                                     (0x01000000u)
#define DMAC_CHCFG_11S_DEM_SHIFT                                               (24u)
#define DMAC_CHCFG_11S_SBE                                                     (0x08000000u)
#define DMAC_CHCFG_11S_SBE_SHIFT                                               (27u)
#define DMAC_CHCFG_11S_RSEL                                                    (0x10000000u)
#define DMAC_CHCFG_11S_RSEL_SHIFT                                              (28u)
#define DMAC_CHCFG_11S_RSW                                                     (0x20000000u)
#define DMAC_CHCFG_11S_RSW_SHIFT                                               (29u)
#define DMAC_CHCFG_11S_REN                                                     (0x40000000u)
#define DMAC_CHCFG_11S_REN_SHIFT                                               (30u)
#define DMAC_CHCFG_11S_DMS                                                     (0x80000000u)
#define DMAC_CHCFG_11S_DMS_SHIFT                                               (31u)
#define DMAC_CHITVL_11S_ITVL                                                   (0x0000FFFFu)
#define DMAC_CHITVL_11S_ITVL_SHIFT                                             (0u)
#define DMAC_CHEXT_11S_SPR                                                     (0x00000007u)
#define DMAC_CHEXT_11S_SPR_SHIFT                                               (0u)
#define DMAC_CHEXT_11S_SCA                                                     (0x000000F0u)
#define DMAC_CHEXT_11S_SCA_SHIFT                                               (4u)
#define DMAC_CHEXT_11S_DPR                                                     (0x00000700u)
#define DMAC_CHEXT_11S_DPR_SHIFT                                               (8u)
#define DMAC_CHEXT_11S_DCA                                                     (0x0000F000u)
#define DMAC_CHEXT_11S_DCA_SHIFT                                               (12u)
#define DMAC_NXLA_11S_NXLA                                                     (0xFFFFFFFFu)
#define DMAC_NXLA_11S_NXLA_SHIFT                                               (0u)
#define DMAC_CRLA_11S_CRLA                                                     (0xFFFFFFFFu)
#define DMAC_CRLA_11S_CRLA_SHIFT                                               (0u)
#define DMAC_N0SA_12S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N0SA_12S_SA_SHIFT                                                 (0u)
#define DMAC_N0DA_12S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N0DA_12S_DA_SHIFT                                                 (0u)
#define DMAC_N0TB_12S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N0TB_12S_TB_SHIFT                                                 (0u)
#define DMAC_N1SA_12S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N1SA_12S_SA_SHIFT                                                 (0u)
#define DMAC_N1DA_12S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N1DA_12S_DA_SHIFT                                                 (0u)
#define DMAC_N1TB_12S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N1TB_12S_TB_SHIFT                                                 (0u)
#define DMAC_CRSA_12S_CRSA                                                     (0xFFFFFFFFu)
#define DMAC_CRSA_12S_CRSA_SHIFT                                               (0u)
#define DMAC_CRDA_12S_CRDA                                                     (0xFFFFFFFFu)
#define DMAC_CRDA_12S_CRDA_SHIFT                                               (0u)
#define DMAC_CRTB_12S_CRTB                                                     (0xFFFFFFFFu)
#define DMAC_CRTB_12S_CRTB_SHIFT                                               (0u)
#define DMAC_CHSTAT_12S_EN                                                     (0x00000001u)
#define DMAC_CHSTAT_12S_EN_SHIFT                                               (0u)
#define DMAC_CHSTAT_12S_RQST                                                   (0x00000002u)
#define DMAC_CHSTAT_12S_RQST_SHIFT                                             (1u)
#define DMAC_CHSTAT_12S_TACT                                                   (0x00000004u)
#define DMAC_CHSTAT_12S_TACT_SHIFT                                             (2u)
#define DMAC_CHSTAT_12S_SUS                                                    (0x00000008u)
#define DMAC_CHSTAT_12S_SUS_SHIFT                                              (3u)
#define DMAC_CHSTAT_12S_ER                                                     (0x00000010u)
#define DMAC_CHSTAT_12S_ER_SHIFT                                               (4u)
#define DMAC_CHSTAT_12S_END                                                    (0x00000020u)
#define DMAC_CHSTAT_12S_END_SHIFT                                              (5u)
#define DMAC_CHSTAT_12S_TC                                                     (0x00000040u)
#define DMAC_CHSTAT_12S_TC_SHIFT                                               (6u)
#define DMAC_CHSTAT_12S_SR                                                     (0x00000080u)
#define DMAC_CHSTAT_12S_SR_SHIFT                                               (7u)
#define DMAC_CHSTAT_12S_DL                                                     (0x00000100u)
#define DMAC_CHSTAT_12S_DL_SHIFT                                               (8u)
#define DMAC_CHSTAT_12S_DW                                                     (0x00000200u)
#define DMAC_CHSTAT_12S_DW_SHIFT                                               (9u)
#define DMAC_CHSTAT_12S_DER                                                    (0x00000400u)
#define DMAC_CHSTAT_12S_DER_SHIFT                                              (10u)
#define DMAC_CHSTAT_12S_MODE                                                   (0x00000800u)
#define DMAC_CHSTAT_12S_MODE_SHIFT                                             (11u)
#define DMAC_CHSTAT_12S_INTMSK                                                 (0x00010000u)
#define DMAC_CHSTAT_12S_INTMSK_SHIFT                                           (16u)
#define DMAC_CHCTRL_12S_SETEN                                                  (0x00000001u)
#define DMAC_CHCTRL_12S_SETEN_SHIFT                                            (0u)
#define DMAC_CHCTRL_12S_CLREN                                                  (0x00000002u)
#define DMAC_CHCTRL_12S_CLREN_SHIFT                                            (1u)
#define DMAC_CHCTRL_12S_STG                                                    (0x00000004u)
#define DMAC_CHCTRL_12S_STG_SHIFT                                              (2u)
#define DMAC_CHCTRL_12S_SWRST                                                  (0x00000008u)
#define DMAC_CHCTRL_12S_SWRST_SHIFT                                            (3u)
#define DMAC_CHCTRL_12S_CLRRQ                                                  (0x00000010u)
#define DMAC_CHCTRL_12S_CLRRQ_SHIFT                                            (4u)
#define DMAC_CHCTRL_12S_CLREND                                                 (0x00000020u)
#define DMAC_CHCTRL_12S_CLREND_SHIFT                                           (5u)
#define DMAC_CHCTRL_12S_CLRTC                                                  (0x00000040u)
#define DMAC_CHCTRL_12S_CLRTC_SHIFT                                            (6u)
#define DMAC_CHCTRL_12S_SETSUS                                                 (0x00000100u)
#define DMAC_CHCTRL_12S_SETSUS_SHIFT                                           (8u)
#define DMAC_CHCTRL_12S_CLRSUS                                                 (0x00000200u)
#define DMAC_CHCTRL_12S_CLRSUS_SHIFT                                           (9u)
#define DMAC_CHCTRL_12S_SETINTMSK                                              (0x00010000u)
#define DMAC_CHCTRL_12S_SETINTMSK_SHIFT                                        (16u)
#define DMAC_CHCTRL_12S_CLRINTMSK                                              (0x00020000u)
#define DMAC_CHCTRL_12S_CLRINTMSK_SHIFT                                        (17u)
#define DMAC_CHCFG_12S_SEL                                                     (0x00000007u)
#define DMAC_CHCFG_12S_SEL_SHIFT                                               (0u)
#define DMAC_CHCFG_12S_REQD                                                    (0x00000008u)
#define DMAC_CHCFG_12S_REQD_SHIFT                                              (3u)
#define DMAC_CHCFG_12S_LOEN                                                    (0x00000010u)
#define DMAC_CHCFG_12S_LOEN_SHIFT                                              (4u)
#define DMAC_CHCFG_12S_HIEN                                                    (0x00000020u)
#define DMAC_CHCFG_12S_HIEN_SHIFT                                              (5u)
#define DMAC_CHCFG_12S_LVL                                                     (0x00000040u)
#define DMAC_CHCFG_12S_LVL_SHIFT                                               (6u)
#define DMAC_CHCFG_12S_AM                                                      (0x00000700u)
#define DMAC_CHCFG_12S_AM_SHIFT                                                (8u)
#define DMAC_CHCFG_12S_SDS                                                     (0x0000F000u)
#define DMAC_CHCFG_12S_SDS_SHIFT                                               (12u)
#define DMAC_CHCFG_12S_DDS                                                     (0x000F0000u)
#define DMAC_CHCFG_12S_DDS_SHIFT                                               (16u)
#define DMAC_CHCFG_12S_SAD                                                     (0x00100000u)
#define DMAC_CHCFG_12S_SAD_SHIFT                                               (20u)
#define DMAC_CHCFG_12S_DAD                                                     (0x00200000u)
#define DMAC_CHCFG_12S_DAD_SHIFT                                               (21u)
#define DMAC_CHCFG_12S_TM                                                      (0x00400000u)
#define DMAC_CHCFG_12S_TM_SHIFT                                                (22u)
#define DMAC_CHCFG_12S_DEM                                                     (0x01000000u)
#define DMAC_CHCFG_12S_DEM_SHIFT                                               (24u)
#define DMAC_CHCFG_12S_SBE                                                     (0x08000000u)
#define DMAC_CHCFG_12S_SBE_SHIFT                                               (27u)
#define DMAC_CHCFG_12S_RSEL                                                    (0x10000000u)
#define DMAC_CHCFG_12S_RSEL_SHIFT                                              (28u)
#define DMAC_CHCFG_12S_RSW                                                     (0x20000000u)
#define DMAC_CHCFG_12S_RSW_SHIFT                                               (29u)
#define DMAC_CHCFG_12S_REN                                                     (0x40000000u)
#define DMAC_CHCFG_12S_REN_SHIFT                                               (30u)
#define DMAC_CHCFG_12S_DMS                                                     (0x80000000u)
#define DMAC_CHCFG_12S_DMS_SHIFT                                               (31u)
#define DMAC_CHITVL_12S_ITVL                                                   (0x0000FFFFu)
#define DMAC_CHITVL_12S_ITVL_SHIFT                                             (0u)
#define DMAC_CHEXT_12S_SPR                                                     (0x00000007u)
#define DMAC_CHEXT_12S_SPR_SHIFT                                               (0u)
#define DMAC_CHEXT_12S_SCA                                                     (0x000000F0u)
#define DMAC_CHEXT_12S_SCA_SHIFT                                               (4u)
#define DMAC_CHEXT_12S_DPR                                                     (0x00000700u)
#define DMAC_CHEXT_12S_DPR_SHIFT                                               (8u)
#define DMAC_CHEXT_12S_DCA                                                     (0x0000F000u)
#define DMAC_CHEXT_12S_DCA_SHIFT                                               (12u)
#define DMAC_NXLA_12S_NXLA                                                     (0xFFFFFFFFu)
#define DMAC_NXLA_12S_NXLA_SHIFT                                               (0u)
#define DMAC_CRLA_12S_CRLA                                                     (0xFFFFFFFFu)
#define DMAC_CRLA_12S_CRLA_SHIFT                                               (0u)
#define DMAC_N0SA_13S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N0SA_13S_SA_SHIFT                                                 (0u)
#define DMAC_N0DA_13S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N0DA_13S_DA_SHIFT                                                 (0u)
#define DMAC_N0TB_13S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N0TB_13S_TB_SHIFT                                                 (0u)
#define DMAC_N1SA_13S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N1SA_13S_SA_SHIFT                                                 (0u)
#define DMAC_N1DA_13S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N1DA_13S_DA_SHIFT                                                 (0u)
#define DMAC_N1TB_13S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N1TB_13S_TB_SHIFT                                                 (0u)
#define DMAC_CRSA_13S_CRSA                                                     (0xFFFFFFFFu)
#define DMAC_CRSA_13S_CRSA_SHIFT                                               (0u)
#define DMAC_CRDA_13S_CRDA                                                     (0xFFFFFFFFu)
#define DMAC_CRDA_13S_CRDA_SHIFT                                               (0u)
#define DMAC_CRTB_13S_CRTB                                                     (0xFFFFFFFFu)
#define DMAC_CRTB_13S_CRTB_SHIFT                                               (0u)
#define DMAC_CHSTAT_13S_EN                                                     (0x00000001u)
#define DMAC_CHSTAT_13S_EN_SHIFT                                               (0u)
#define DMAC_CHSTAT_13S_RQST                                                   (0x00000002u)
#define DMAC_CHSTAT_13S_RQST_SHIFT                                             (1u)
#define DMAC_CHSTAT_13S_TACT                                                   (0x00000004u)
#define DMAC_CHSTAT_13S_TACT_SHIFT                                             (2u)
#define DMAC_CHSTAT_13S_SUS                                                    (0x00000008u)
#define DMAC_CHSTAT_13S_SUS_SHIFT                                              (3u)
#define DMAC_CHSTAT_13S_ER                                                     (0x00000010u)
#define DMAC_CHSTAT_13S_ER_SHIFT                                               (4u)
#define DMAC_CHSTAT_13S_END                                                    (0x00000020u)
#define DMAC_CHSTAT_13S_END_SHIFT                                              (5u)
#define DMAC_CHSTAT_13S_TC                                                     (0x00000040u)
#define DMAC_CHSTAT_13S_TC_SHIFT                                               (6u)
#define DMAC_CHSTAT_13S_SR                                                     (0x00000080u)
#define DMAC_CHSTAT_13S_SR_SHIFT                                               (7u)
#define DMAC_CHSTAT_13S_DL                                                     (0x00000100u)
#define DMAC_CHSTAT_13S_DL_SHIFT                                               (8u)
#define DMAC_CHSTAT_13S_DW                                                     (0x00000200u)
#define DMAC_CHSTAT_13S_DW_SHIFT                                               (9u)
#define DMAC_CHSTAT_13S_DER                                                    (0x00000400u)
#define DMAC_CHSTAT_13S_DER_SHIFT                                              (10u)
#define DMAC_CHSTAT_13S_MODE                                                   (0x00000800u)
#define DMAC_CHSTAT_13S_MODE_SHIFT                                             (11u)
#define DMAC_CHSTAT_13S_INTMSK                                                 (0x00010000u)
#define DMAC_CHSTAT_13S_INTMSK_SHIFT                                           (16u)
#define DMAC_CHCTRL_13S_SETEN                                                  (0x00000001u)
#define DMAC_CHCTRL_13S_SETEN_SHIFT                                            (0u)
#define DMAC_CHCTRL_13S_CLREN                                                  (0x00000002u)
#define DMAC_CHCTRL_13S_CLREN_SHIFT                                            (1u)
#define DMAC_CHCTRL_13S_STG                                                    (0x00000004u)
#define DMAC_CHCTRL_13S_STG_SHIFT                                              (2u)
#define DMAC_CHCTRL_13S_SWRST                                                  (0x00000008u)
#define DMAC_CHCTRL_13S_SWRST_SHIFT                                            (3u)
#define DMAC_CHCTRL_13S_CLRRQ                                                  (0x00000010u)
#define DMAC_CHCTRL_13S_CLRRQ_SHIFT                                            (4u)
#define DMAC_CHCTRL_13S_CLREND                                                 (0x00000020u)
#define DMAC_CHCTRL_13S_CLREND_SHIFT                                           (5u)
#define DMAC_CHCTRL_13S_CLRTC                                                  (0x00000040u)
#define DMAC_CHCTRL_13S_CLRTC_SHIFT                                            (6u)
#define DMAC_CHCTRL_13S_SETSUS                                                 (0x00000100u)
#define DMAC_CHCTRL_13S_SETSUS_SHIFT                                           (8u)
#define DMAC_CHCTRL_13S_CLRSUS                                                 (0x00000200u)
#define DMAC_CHCTRL_13S_CLRSUS_SHIFT                                           (9u)
#define DMAC_CHCTRL_13S_SETINTMSK                                              (0x00010000u)
#define DMAC_CHCTRL_13S_SETINTMSK_SHIFT                                        (16u)
#define DMAC_CHCTRL_13S_CLRINTMSK                                              (0x00020000u)
#define DMAC_CHCTRL_13S_CLRINTMSK_SHIFT                                        (17u)
#define DMAC_CHCFG_13S_SEL                                                     (0x00000007u)
#define DMAC_CHCFG_13S_SEL_SHIFT                                               (0u)
#define DMAC_CHCFG_13S_REQD                                                    (0x00000008u)
#define DMAC_CHCFG_13S_REQD_SHIFT                                              (3u)
#define DMAC_CHCFG_13S_LOEN                                                    (0x00000010u)
#define DMAC_CHCFG_13S_LOEN_SHIFT                                              (4u)
#define DMAC_CHCFG_13S_HIEN                                                    (0x00000020u)
#define DMAC_CHCFG_13S_HIEN_SHIFT                                              (5u)
#define DMAC_CHCFG_13S_LVL                                                     (0x00000040u)
#define DMAC_CHCFG_13S_LVL_SHIFT                                               (6u)
#define DMAC_CHCFG_13S_AM                                                      (0x00000700u)
#define DMAC_CHCFG_13S_AM_SHIFT                                                (8u)
#define DMAC_CHCFG_13S_SDS                                                     (0x0000F000u)
#define DMAC_CHCFG_13S_SDS_SHIFT                                               (12u)
#define DMAC_CHCFG_13S_DDS                                                     (0x000F0000u)
#define DMAC_CHCFG_13S_DDS_SHIFT                                               (16u)
#define DMAC_CHCFG_13S_SAD                                                     (0x00100000u)
#define DMAC_CHCFG_13S_SAD_SHIFT                                               (20u)
#define DMAC_CHCFG_13S_DAD                                                     (0x00200000u)
#define DMAC_CHCFG_13S_DAD_SHIFT                                               (21u)
#define DMAC_CHCFG_13S_TM                                                      (0x00400000u)
#define DMAC_CHCFG_13S_TM_SHIFT                                                (22u)
#define DMAC_CHCFG_13S_DEM                                                     (0x01000000u)
#define DMAC_CHCFG_13S_DEM_SHIFT                                               (24u)
#define DMAC_CHCFG_13S_SBE                                                     (0x08000000u)
#define DMAC_CHCFG_13S_SBE_SHIFT                                               (27u)
#define DMAC_CHCFG_13S_RSEL                                                    (0x10000000u)
#define DMAC_CHCFG_13S_RSEL_SHIFT                                              (28u)
#define DMAC_CHCFG_13S_RSW                                                     (0x20000000u)
#define DMAC_CHCFG_13S_RSW_SHIFT                                               (29u)
#define DMAC_CHCFG_13S_REN                                                     (0x40000000u)
#define DMAC_CHCFG_13S_REN_SHIFT                                               (30u)
#define DMAC_CHCFG_13S_DMS                                                     (0x80000000u)
#define DMAC_CHCFG_13S_DMS_SHIFT                                               (31u)
#define DMAC_CHITVL_13S_ITVL                                                   (0x0000FFFFu)
#define DMAC_CHITVL_13S_ITVL_SHIFT                                             (0u)
#define DMAC_CHEXT_13S_SPR                                                     (0x00000007u)
#define DMAC_CHEXT_13S_SPR_SHIFT                                               (0u)
#define DMAC_CHEXT_13S_SCA                                                     (0x000000F0u)
#define DMAC_CHEXT_13S_SCA_SHIFT                                               (4u)
#define DMAC_CHEXT_13S_DPR                                                     (0x00000700u)
#define DMAC_CHEXT_13S_DPR_SHIFT                                               (8u)
#define DMAC_CHEXT_13S_DCA                                                     (0x0000F000u)
#define DMAC_CHEXT_13S_DCA_SHIFT                                               (12u)
#define DMAC_NXLA_13S_NXLA                                                     (0xFFFFFFFFu)
#define DMAC_NXLA_13S_NXLA_SHIFT                                               (0u)
#define DMAC_CRLA_13S_CRLA                                                     (0xFFFFFFFFu)
#define DMAC_CRLA_13S_CRLA_SHIFT                                               (0u)
#define DMAC_N0SA_14S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N0SA_14S_SA_SHIFT                                                 (0u)
#define DMAC_N0DA_14S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N0DA_14S_DA_SHIFT                                                 (0u)
#define DMAC_N0TB_14S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N0TB_14S_TB_SHIFT                                                 (0u)
#define DMAC_N1SA_14S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N1SA_14S_SA_SHIFT                                                 (0u)
#define DMAC_N1DA_14S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N1DA_14S_DA_SHIFT                                                 (0u)
#define DMAC_N1TB_14S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N1TB_14S_TB_SHIFT                                                 (0u)
#define DMAC_CRSA_14S_CRSA                                                     (0xFFFFFFFFu)
#define DMAC_CRSA_14S_CRSA_SHIFT                                               (0u)
#define DMAC_CRDA_14S_CRDA                                                     (0xFFFFFFFFu)
#define DMAC_CRDA_14S_CRDA_SHIFT                                               (0u)
#define DMAC_CRTB_14S_CRTB                                                     (0xFFFFFFFFu)
#define DMAC_CRTB_14S_CRTB_SHIFT                                               (0u)
#define DMAC_CHSTAT_14S_EN                                                     (0x00000001u)
#define DMAC_CHSTAT_14S_EN_SHIFT                                               (0u)
#define DMAC_CHSTAT_14S_RQST                                                   (0x00000002u)
#define DMAC_CHSTAT_14S_RQST_SHIFT                                             (1u)
#define DMAC_CHSTAT_14S_TACT                                                   (0x00000004u)
#define DMAC_CHSTAT_14S_TACT_SHIFT                                             (2u)
#define DMAC_CHSTAT_14S_SUS                                                    (0x00000008u)
#define DMAC_CHSTAT_14S_SUS_SHIFT                                              (3u)
#define DMAC_CHSTAT_14S_ER                                                     (0x00000010u)
#define DMAC_CHSTAT_14S_ER_SHIFT                                               (4u)
#define DMAC_CHSTAT_14S_END                                                    (0x00000020u)
#define DMAC_CHSTAT_14S_END_SHIFT                                              (5u)
#define DMAC_CHSTAT_14S_TC                                                     (0x00000040u)
#define DMAC_CHSTAT_14S_TC_SHIFT                                               (6u)
#define DMAC_CHSTAT_14S_SR                                                     (0x00000080u)
#define DMAC_CHSTAT_14S_SR_SHIFT                                               (7u)
#define DMAC_CHSTAT_14S_DL                                                     (0x00000100u)
#define DMAC_CHSTAT_14S_DL_SHIFT                                               (8u)
#define DMAC_CHSTAT_14S_DW                                                     (0x00000200u)
#define DMAC_CHSTAT_14S_DW_SHIFT                                               (9u)
#define DMAC_CHSTAT_14S_DER                                                    (0x00000400u)
#define DMAC_CHSTAT_14S_DER_SHIFT                                              (10u)
#define DMAC_CHSTAT_14S_MODE                                                   (0x00000800u)
#define DMAC_CHSTAT_14S_MODE_SHIFT                                             (11u)
#define DMAC_CHSTAT_14S_INTMSK                                                 (0x00010000u)
#define DMAC_CHSTAT_14S_INTMSK_SHIFT                                           (16u)
#define DMAC_CHCTRL_14S_SETEN                                                  (0x00000001u)
#define DMAC_CHCTRL_14S_SETEN_SHIFT                                            (0u)
#define DMAC_CHCTRL_14S_CLREN                                                  (0x00000002u)
#define DMAC_CHCTRL_14S_CLREN_SHIFT                                            (1u)
#define DMAC_CHCTRL_14S_STG                                                    (0x00000004u)
#define DMAC_CHCTRL_14S_STG_SHIFT                                              (2u)
#define DMAC_CHCTRL_14S_SWRST                                                  (0x00000008u)
#define DMAC_CHCTRL_14S_SWRST_SHIFT                                            (3u)
#define DMAC_CHCTRL_14S_CLRRQ                                                  (0x00000010u)
#define DMAC_CHCTRL_14S_CLRRQ_SHIFT                                            (4u)
#define DMAC_CHCTRL_14S_CLREND                                                 (0x00000020u)
#define DMAC_CHCTRL_14S_CLREND_SHIFT                                           (5u)
#define DMAC_CHCTRL_14S_CLRTC                                                  (0x00000040u)
#define DMAC_CHCTRL_14S_CLRTC_SHIFT                                            (6u)
#define DMAC_CHCTRL_14S_SETSUS                                                 (0x00000100u)
#define DMAC_CHCTRL_14S_SETSUS_SHIFT                                           (8u)
#define DMAC_CHCTRL_14S_CLRSUS                                                 (0x00000200u)
#define DMAC_CHCTRL_14S_CLRSUS_SHIFT                                           (9u)
#define DMAC_CHCTRL_14S_SETINTMSK                                              (0x00010000u)
#define DMAC_CHCTRL_14S_SETINTMSK_SHIFT                                        (16u)
#define DMAC_CHCTRL_14S_CLRINTMSK                                              (0x00020000u)
#define DMAC_CHCTRL_14S_CLRINTMSK_SHIFT                                        (17u)
#define DMAC_CHCFG_14S_SEL                                                     (0x00000007u)
#define DMAC_CHCFG_14S_SEL_SHIFT                                               (0u)
#define DMAC_CHCFG_14S_REQD                                                    (0x00000008u)
#define DMAC_CHCFG_14S_REQD_SHIFT                                              (3u)
#define DMAC_CHCFG_14S_LOEN                                                    (0x00000010u)
#define DMAC_CHCFG_14S_LOEN_SHIFT                                              (4u)
#define DMAC_CHCFG_14S_HIEN                                                    (0x00000020u)
#define DMAC_CHCFG_14S_HIEN_SHIFT                                              (5u)
#define DMAC_CHCFG_14S_LVL                                                     (0x00000040u)
#define DMAC_CHCFG_14S_LVL_SHIFT                                               (6u)
#define DMAC_CHCFG_14S_AM                                                      (0x00000700u)
#define DMAC_CHCFG_14S_AM_SHIFT                                                (8u)
#define DMAC_CHCFG_14S_SDS                                                     (0x0000F000u)
#define DMAC_CHCFG_14S_SDS_SHIFT                                               (12u)
#define DMAC_CHCFG_14S_DDS                                                     (0x000F0000u)
#define DMAC_CHCFG_14S_DDS_SHIFT                                               (16u)
#define DMAC_CHCFG_14S_SAD                                                     (0x00100000u)
#define DMAC_CHCFG_14S_SAD_SHIFT                                               (20u)
#define DMAC_CHCFG_14S_DAD                                                     (0x00200000u)
#define DMAC_CHCFG_14S_DAD_SHIFT                                               (21u)
#define DMAC_CHCFG_14S_TM                                                      (0x00400000u)
#define DMAC_CHCFG_14S_TM_SHIFT                                                (22u)
#define DMAC_CHCFG_14S_DEM                                                     (0x01000000u)
#define DMAC_CHCFG_14S_DEM_SHIFT                                               (24u)
#define DMAC_CHCFG_14S_SBE                                                     (0x08000000u)
#define DMAC_CHCFG_14S_SBE_SHIFT                                               (27u)
#define DMAC_CHCFG_14S_RSEL                                                    (0x10000000u)
#define DMAC_CHCFG_14S_RSEL_SHIFT                                              (28u)
#define DMAC_CHCFG_14S_RSW                                                     (0x20000000u)
#define DMAC_CHCFG_14S_RSW_SHIFT                                               (29u)
#define DMAC_CHCFG_14S_REN                                                     (0x40000000u)
#define DMAC_CHCFG_14S_REN_SHIFT                                               (30u)
#define DMAC_CHCFG_14S_DMS                                                     (0x80000000u)
#define DMAC_CHCFG_14S_DMS_SHIFT                                               (31u)
#define DMAC_CHITVL_14S_ITVL                                                   (0x0000FFFFu)
#define DMAC_CHITVL_14S_ITVL_SHIFT                                             (0u)
#define DMAC_CHEXT_14S_SPR                                                     (0x00000007u)
#define DMAC_CHEXT_14S_SPR_SHIFT                                               (0u)
#define DMAC_CHEXT_14S_SCA                                                     (0x000000F0u)
#define DMAC_CHEXT_14S_SCA_SHIFT                                               (4u)
#define DMAC_CHEXT_14S_DPR                                                     (0x00000700u)
#define DMAC_CHEXT_14S_DPR_SHIFT                                               (8u)
#define DMAC_CHEXT_14S_DCA                                                     (0x0000F000u)
#define DMAC_CHEXT_14S_DCA_SHIFT                                               (12u)
#define DMAC_NXLA_14S_NXLA                                                     (0xFFFFFFFFu)
#define DMAC_NXLA_14S_NXLA_SHIFT                                               (0u)
#define DMAC_CRLA_14S_CRLA                                                     (0xFFFFFFFFu)
#define DMAC_CRLA_14S_CRLA_SHIFT                                               (0u)
#define DMAC_N0SA_15S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N0SA_15S_SA_SHIFT                                                 (0u)
#define DMAC_N0DA_15S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N0DA_15S_DA_SHIFT                                                 (0u)
#define DMAC_N0TB_15S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N0TB_15S_TB_SHIFT                                                 (0u)
#define DMAC_N1SA_15S_SA                                                       (0xFFFFFFFFu)
#define DMAC_N1SA_15S_SA_SHIFT                                                 (0u)
#define DMAC_N1DA_15S_DA                                                       (0xFFFFFFFFu)
#define DMAC_N1DA_15S_DA_SHIFT                                                 (0u)
#define DMAC_N1TB_15S_TB                                                       (0xFFFFFFFFu)
#define DMAC_N1TB_15S_TB_SHIFT                                                 (0u)
#define DMAC_CRSA_15S_CRSA                                                     (0xFFFFFFFFu)
#define DMAC_CRSA_15S_CRSA_SHIFT                                               (0u)
#define DMAC_CRDA_15S_CRDA                                                     (0xFFFFFFFFu)
#define DMAC_CRDA_15S_CRDA_SHIFT                                               (0u)
#define DMAC_CRTB_15S_CRTB                                                     (0xFFFFFFFFu)
#define DMAC_CRTB_15S_CRTB_SHIFT                                               (0u)
#define DMAC_CHSTAT_15S_EN                                                     (0x00000001u)
#define DMAC_CHSTAT_15S_EN_SHIFT                                               (0u)
#define DMAC_CHSTAT_15S_RQST                                                   (0x00000002u)
#define DMAC_CHSTAT_15S_RQST_SHIFT                                             (1u)
#define DMAC_CHSTAT_15S_TACT                                                   (0x00000004u)
#define DMAC_CHSTAT_15S_TACT_SHIFT                                             (2u)
#define DMAC_CHSTAT_15S_SUS                                                    (0x00000008u)
#define DMAC_CHSTAT_15S_SUS_SHIFT                                              (3u)
#define DMAC_CHSTAT_15S_ER                                                     (0x00000010u)
#define DMAC_CHSTAT_15S_ER_SHIFT                                               (4u)
#define DMAC_CHSTAT_15S_END                                                    (0x00000020u)
#define DMAC_CHSTAT_15S_END_SHIFT                                              (5u)
#define DMAC_CHSTAT_15S_TC                                                     (0x00000040u)
#define DMAC_CHSTAT_15S_TC_SHIFT                                               (6u)
#define DMAC_CHSTAT_15S_SR                                                     (0x00000080u)
#define DMAC_CHSTAT_15S_SR_SHIFT                                               (7u)
#define DMAC_CHSTAT_15S_DL                                                     (0x00000100u)
#define DMAC_CHSTAT_15S_DL_SHIFT                                               (8u)
#define DMAC_CHSTAT_15S_DW                                                     (0x00000200u)
#define DMAC_CHSTAT_15S_DW_SHIFT                                               (9u)
#define DMAC_CHSTAT_15S_DER                                                    (0x00000400u)
#define DMAC_CHSTAT_15S_DER_SHIFT                                              (10u)
#define DMAC_CHSTAT_15S_MODE                                                   (0x00000800u)
#define DMAC_CHSTAT_15S_MODE_SHIFT                                             (11u)
#define DMAC_CHSTAT_15S_INTMSK                                                 (0x00010000u)
#define DMAC_CHSTAT_15S_INTMSK_SHIFT                                           (16u)
#define DMAC_CHCTRL_15S_SETEN                                                  (0x00000001u)
#define DMAC_CHCTRL_15S_SETEN_SHIFT                                            (0u)
#define DMAC_CHCTRL_15S_CLREN                                                  (0x00000002u)
#define DMAC_CHCTRL_15S_CLREN_SHIFT                                            (1u)
#define DMAC_CHCTRL_15S_STG                                                    (0x00000004u)
#define DMAC_CHCTRL_15S_STG_SHIFT                                              (2u)
#define DMAC_CHCTRL_15S_SWRST                                                  (0x00000008u)
#define DMAC_CHCTRL_15S_SWRST_SHIFT                                            (3u)
#define DMAC_CHCTRL_15S_CLRRQ                                                  (0x00000010u)
#define DMAC_CHCTRL_15S_CLRRQ_SHIFT                                            (4u)
#define DMAC_CHCTRL_15S_CLREND                                                 (0x00000020u)
#define DMAC_CHCTRL_15S_CLREND_SHIFT                                           (5u)
#define DMAC_CHCTRL_15S_CLRTC                                                  (0x00000040u)
#define DMAC_CHCTRL_15S_CLRTC_SHIFT                                            (6u)
#define DMAC_CHCTRL_15S_SETSUS                                                 (0x00000100u)
#define DMAC_CHCTRL_15S_SETSUS_SHIFT                                           (8u)
#define DMAC_CHCTRL_15S_CLRSUS                                                 (0x00000200u)
#define DMAC_CHCTRL_15S_CLRSUS_SHIFT                                           (9u)
#define DMAC_CHCTRL_15S_SETINTMSK                                              (0x00010000u)
#define DMAC_CHCTRL_15S_SETINTMSK_SHIFT                                        (16u)
#define DMAC_CHCTRL_15S_CLRINTMSK                                              (0x00020000u)
#define DMAC_CHCTRL_15S_CLRINTMSK_SHIFT                                        (17u)
#define DMAC_CHCFG_15S_SEL                                                     (0x00000007u)
#define DMAC_CHCFG_15S_SEL_SHIFT                                               (0u)
#define DMAC_CHCFG_15S_REQD                                                    (0x00000008u)
#define DMAC_CHCFG_15S_REQD_SHIFT                                              (3u)
#define DMAC_CHCFG_15S_LOEN                                                    (0x00000010u)
#define DMAC_CHCFG_15S_LOEN_SHIFT                                              (4u)
#define DMAC_CHCFG_15S_HIEN                                                    (0x00000020u)
#define DMAC_CHCFG_15S_HIEN_SHIFT                                              (5u)
#define DMAC_CHCFG_15S_LVL                                                     (0x00000040u)
#define DMAC_CHCFG_15S_LVL_SHIFT                                               (6u)
#define DMAC_CHCFG_15S_AM                                                      (0x00000700u)
#define DMAC_CHCFG_15S_AM_SHIFT                                                (8u)
#define DMAC_CHCFG_15S_SDS                                                     (0x0000F000u)
#define DMAC_CHCFG_15S_SDS_SHIFT                                               (12u)
#define DMAC_CHCFG_15S_DDS                                                     (0x000F0000u)
#define DMAC_CHCFG_15S_DDS_SHIFT                                               (16u)
#define DMAC_CHCFG_15S_SAD                                                     (0x00100000u)
#define DMAC_CHCFG_15S_SAD_SHIFT                                               (20u)
#define DMAC_CHCFG_15S_DAD                                                     (0x00200000u)
#define DMAC_CHCFG_15S_DAD_SHIFT                                               (21u)
#define DMAC_CHCFG_15S_TM                                                      (0x00400000u)
#define DMAC_CHCFG_15S_TM_SHIFT                                                (22u)
#define DMAC_CHCFG_15S_DEM                                                     (0x01000000u)
#define DMAC_CHCFG_15S_DEM_SHIFT                                               (24u)
#define DMAC_CHCFG_15S_SBE                                                     (0x08000000u)
#define DMAC_CHCFG_15S_SBE_SHIFT                                               (27u)
#define DMAC_CHCFG_15S_RSEL                                                    (0x10000000u)
#define DMAC_CHCFG_15S_RSEL_SHIFT                                              (28u)
#define DMAC_CHCFG_15S_RSW                                                     (0x20000000u)
#define DMAC_CHCFG_15S_RSW_SHIFT                                               (29u)
#define DMAC_CHCFG_15S_REN                                                     (0x40000000u)
#define DMAC_CHCFG_15S_REN_SHIFT                                               (30u)
#define DMAC_CHCFG_15S_DMS                                                     (0x80000000u)
#define DMAC_CHCFG_15S_DMS_SHIFT                                               (31u)
#define DMAC_CHITVL_15S_ITVL                                                   (0x0000FFFFu)
#define DMAC_CHITVL_15S_ITVL_SHIFT                                             (0u)
#define DMAC_CHEXT_15S_SPR                                                     (0x00000007u)
#define DMAC_CHEXT_15S_SPR_SHIFT                                               (0u)
#define DMAC_CHEXT_15S_SCA                                                     (0x000000F0u)
#define DMAC_CHEXT_15S_SCA_SHIFT                                               (4u)
#define DMAC_CHEXT_15S_DPR                                                     (0x00000700u)
#define DMAC_CHEXT_15S_DPR_SHIFT                                               (8u)
#define DMAC_CHEXT_15S_DCA                                                     (0x0000F000u)
#define DMAC_CHEXT_15S_DCA_SHIFT                                               (12u)
#define DMAC_NXLA_15S_NXLA                                                     (0xFFFFFFFFu)
#define DMAC_NXLA_15S_NXLA_SHIFT                                               (0u)
#define DMAC_CRLA_15S_CRLA                                                     (0xFFFFFFFFu)
#define DMAC_CRLA_15S_CRLA_SHIFT                                               (0u)
#define DMAC_DCTRL_8_15S_PR                                                    (0x00000001u)
#define DMAC_DCTRL_8_15S_PR_SHIFT                                              (0u)
#define DMAC_DCTRL_8_15S_LVINT                                                 (0x00000002u)
#define DMAC_DCTRL_8_15S_LVINT_SHIFT                                           (1u)
#define DMAC_DCTRL_8_15S_LDPR                                                  (0x00070000u)
#define DMAC_DCTRL_8_15S_LDPR_SHIFT                                            (16u)
#define DMAC_DCTRL_8_15S_LDCA                                                  (0x00F00000u)
#define DMAC_DCTRL_8_15S_LDCA_SHIFT                                            (20u)
#define DMAC_DCTRL_8_15S_LWPR                                                  (0x07000000u)
#define DMAC_DCTRL_8_15S_LWPR_SHIFT                                            (24u)
#define DMAC_DCTRL_8_15S_LWCA                                                  (0xF0000000u)
#define DMAC_DCTRL_8_15S_LWCA_SHIFT                                            (28u)
#define DMAC_DSTAT_EN_8_15S_EN8                                                (0x00000001u)
#define DMAC_DSTAT_EN_8_15S_EN8_SHIFT                                          (0u)
#define DMAC_DSTAT_EN_8_15S_EN9                                                (0x00000002u)
#define DMAC_DSTAT_EN_8_15S_EN9_SHIFT                                          (1u)
#define DMAC_DSTAT_EN_8_15S_EN10                                               (0x00000004u)
#define DMAC_DSTAT_EN_8_15S_EN10_SHIFT                                         (2u)
#define DMAC_DSTAT_EN_8_15S_EN11                                               (0x00000008u)
#define DMAC_DSTAT_EN_8_15S_EN11_SHIFT                                         (3u)
#define DMAC_DSTAT_EN_8_15S_EN12                                               (0x00000010u)
#define DMAC_DSTAT_EN_8_15S_EN12_SHIFT                                         (4u)
#define DMAC_DSTAT_EN_8_15S_EN13                                               (0x00000020u)
#define DMAC_DSTAT_EN_8_15S_EN13_SHIFT                                         (5u)
#define DMAC_DSTAT_EN_8_15S_EN14                                               (0x00000040u)
#define DMAC_DSTAT_EN_8_15S_EN14_SHIFT                                         (6u)
#define DMAC_DSTAT_EN_8_15S_EN15                                               (0x00000080u)
#define DMAC_DSTAT_EN_8_15S_EN15_SHIFT                                         (7u)
#define DMAC_DSTAT_ER_8_15S_ER8                                                (0x00000001u)
#define DMAC_DSTAT_ER_8_15S_ER8_SHIFT                                          (0u)
#define DMAC_DSTAT_ER_8_15S_ER9                                                (0x00000002u)
#define DMAC_DSTAT_ER_8_15S_ER9_SHIFT                                          (1u)
#define DMAC_DSTAT_ER_8_15S_ER10                                               (0x00000004u)
#define DMAC_DSTAT_ER_8_15S_ER10_SHIFT                                         (2u)
#define DMAC_DSTAT_ER_8_15S_ER11                                               (0x00000008u)
#define DMAC_DSTAT_ER_8_15S_ER11_SHIFT                                         (3u)
#define DMAC_DSTAT_ER_8_15S_ER12                                               (0x00000010u)
#define DMAC_DSTAT_ER_8_15S_ER12_SHIFT                                         (4u)
#define DMAC_DSTAT_ER_8_15S_ER13                                               (0x00000020u)
#define DMAC_DSTAT_ER_8_15S_ER13_SHIFT                                         (5u)
#define DMAC_DSTAT_ER_8_15S_ER14                                               (0x00000040u)
#define DMAC_DSTAT_ER_8_15S_ER14_SHIFT                                         (6u)
#define DMAC_DSTAT_ER_8_15S_ER15                                               (0x00000080u)
#define DMAC_DSTAT_ER_8_15S_ER15_SHIFT                                         (7u)
#define DMAC_DSTAT_END_8_15S_END8                                              (0x00000001u)
#define DMAC_DSTAT_END_8_15S_END8_SHIFT                                        (0u)
#define DMAC_DSTAT_END_8_15S_END9                                              (0x00000002u)
#define DMAC_DSTAT_END_8_15S_END9_SHIFT                                        (1u)
#define DMAC_DSTAT_END_8_15S_END10                                             (0x00000004u)
#define DMAC_DSTAT_END_8_15S_END10_SHIFT                                       (2u)
#define DMAC_DSTAT_END_8_15S_END11                                             (0x00000008u)
#define DMAC_DSTAT_END_8_15S_END11_SHIFT                                       (3u)
#define DMAC_DSTAT_END_8_15S_END12                                             (0x00000010u)
#define DMAC_DSTAT_END_8_15S_END12_SHIFT                                       (4u)
#define DMAC_DSTAT_END_8_15S_END13                                             (0x00000020u)
#define DMAC_DSTAT_END_8_15S_END13_SHIFT                                       (5u)
#define DMAC_DSTAT_END_8_15S_END14                                             (0x00000040u)
#define DMAC_DSTAT_END_8_15S_END14_SHIFT                                       (6u)
#define DMAC_DSTAT_END_8_15S_END15                                             (0x00000080u)
#define DMAC_DSTAT_END_8_15S_END15_SHIFT                                       (7u)
#define DMAC_DSTAT_TC_8_15S_TC8                                                (0x00000001u)
#define DMAC_DSTAT_TC_8_15S_TC8_SHIFT                                          (0u)
#define DMAC_DSTAT_TC_8_15S_TC9                                                (0x00000002u)
#define DMAC_DSTAT_TC_8_15S_TC9_SHIFT                                          (1u)
#define DMAC_DSTAT_TC_8_15S_TC10                                               (0x00000004u)
#define DMAC_DSTAT_TC_8_15S_TC10_SHIFT                                         (2u)
#define DMAC_DSTAT_TC_8_15S_TC11                                               (0x00000008u)
#define DMAC_DSTAT_TC_8_15S_TC11_SHIFT                                         (3u)
#define DMAC_DSTAT_TC_8_15S_TC12                                               (0x00000010u)
#define DMAC_DSTAT_TC_8_15S_TC12_SHIFT                                         (4u)
#define DMAC_DSTAT_TC_8_15S_TC13                                               (0x00000020u)
#define DMAC_DSTAT_TC_8_15S_TC13_SHIFT                                         (5u)
#define DMAC_DSTAT_TC_8_15S_TC14                                               (0x00000040u)
#define DMAC_DSTAT_TC_8_15S_TC14_SHIFT                                         (6u)
#define DMAC_DSTAT_TC_8_15S_TC15                                               (0x00000080u)
#define DMAC_DSTAT_TC_8_15S_TC15_SHIFT                                         (7u)
#define DMAC_DSTAT_SUS_8_15S_SUS8                                              (0x00000001u)
#define DMAC_DSTAT_SUS_8_15S_SUS8_SHIFT                                        (0u)
#define DMAC_DSTAT_SUS_8_15S_SUS9                                              (0x00000002u)
#define DMAC_DSTAT_SUS_8_15S_SUS9_SHIFT                                        (1u)
#define DMAC_DSTAT_SUS_8_15S_SUS10                                             (0x00000004u)
#define DMAC_DSTAT_SUS_8_15S_SUS10_SHIFT                                       (2u)
#define DMAC_DSTAT_SUS_8_15S_SUS11                                             (0x00000008u)
#define DMAC_DSTAT_SUS_8_15S_SUS11_SHIFT                                       (3u)
#define DMAC_DSTAT_SUS_8_15S_SUS12                                             (0x00000010u)
#define DMAC_DSTAT_SUS_8_15S_SUS12_SHIFT                                       (4u)
#define DMAC_DSTAT_SUS_8_15S_SUS13                                             (0x00000020u)
#define DMAC_DSTAT_SUS_8_15S_SUS13_SHIFT                                       (5u)
#define DMAC_DSTAT_SUS_8_15S_SUS14                                             (0x00000040u)
#define DMAC_DSTAT_SUS_8_15S_SUS14_SHIFT                                       (6u)
#define DMAC_DSTAT_SUS_8_15S_SUS15                                             (0x00000080u)
#define DMAC_DSTAT_SUS_8_15S_SUS15_SHIFT                                       (7u)
#define DMAC_DMARS0S_CH0_RID                                                   (0x00000003u)
#define DMAC_DMARS0S_CH0_RID_SHIFT                                             (0u)
#define DMAC_DMARS0S_CH0_MID                                                   (0x000003FCu)
#define DMAC_DMARS0S_CH0_MID_SHIFT                                             (2u)
#define DMAC_DMARS0S_CH1_RID                                                   (0x00030000u)
#define DMAC_DMARS0S_CH1_RID_SHIFT                                             (16u)
#define DMAC_DMARS0S_CH1_MID                                                   (0x03FC0000u)
#define DMAC_DMARS0S_CH1_MID_SHIFT                                             (18u)
#define DMAC_DMARS1S_CH2_RID                                                   (0x00000003u)
#define DMAC_DMARS1S_CH2_RID_SHIFT                                             (0u)
#define DMAC_DMARS1S_CH2_MID                                                   (0x000003FCu)
#define DMAC_DMARS1S_CH2_MID_SHIFT                                             (2u)
#define DMAC_DMARS1S_CH3_RID                                                   (0x00030000u)
#define DMAC_DMARS1S_CH3_RID_SHIFT                                             (16u)
#define DMAC_DMARS1S_CH3_MID                                                   (0x03FC0000u)
#define DMAC_DMARS1S_CH3_MID_SHIFT                                             (18u)
#define DMAC_DMARS2S_CH4_RID                                                   (0x00000003u)
#define DMAC_DMARS2S_CH4_RID_SHIFT                                             (0u)
#define DMAC_DMARS2S_CH4_MID                                                   (0x000003FCu)
#define DMAC_DMARS2S_CH4_MID_SHIFT                                             (2u)
#define DMAC_DMARS2S_CH5_RID                                                   (0x00030000u)
#define DMAC_DMARS2S_CH5_RID_SHIFT                                             (16u)
#define DMAC_DMARS2S_CH5_MID                                                   (0x03FC0000u)
#define DMAC_DMARS2S_CH5_MID_SHIFT                                             (18u)
#define DMAC_DMARS3S_CH6_RID                                                   (0x00000003u)
#define DMAC_DMARS3S_CH6_RID_SHIFT                                             (0u)
#define DMAC_DMARS3S_CH6_MID                                                   (0x000003FCu)
#define DMAC_DMARS3S_CH6_MID_SHIFT                                             (2u)
#define DMAC_DMARS3S_CH7_RID                                                   (0x00030000u)
#define DMAC_DMARS3S_CH7_RID_SHIFT                                             (16u)
#define DMAC_DMARS3S_CH7_MID                                                   (0x03FC0000u)
#define DMAC_DMARS3S_CH7_MID_SHIFT                                             (18u)
#define DMAC_DMARS4S_CH8_RID                                                   (0x00000003u)
#define DMAC_DMARS4S_CH8_RID_SHIFT                                             (0u)
#define DMAC_DMARS4S_CH8_MID                                                   (0x000003FCu)
#define DMAC_DMARS4S_CH8_MID_SHIFT                                             (2u)
#define DMAC_DMARS4S_CH9_RID                                                   (0x00030000u)
#define DMAC_DMARS4S_CH9_RID_SHIFT                                             (16u)
#define DMAC_DMARS4S_CH9_MID                                                   (0x03FC0000u)
#define DMAC_DMARS4S_CH9_MID_SHIFT                                             (18u)
#define DMAC_DMARS5S_CH10_RID                                                  (0x00000003u)
#define DMAC_DMARS5S_CH10_RID_SHIFT                                            (0u)
#define DMAC_DMARS5S_CH10_MID                                                  (0x000003FCu)
#define DMAC_DMARS5S_CH10_MID_SHIFT                                            (2u)
#define DMAC_DMARS5S_CH11_RID                                                  (0x00030000u)
#define DMAC_DMARS5S_CH11_RID_SHIFT                                            (16u)
#define DMAC_DMARS5S_CH11_MID                                                  (0x03FC0000u)
#define DMAC_DMARS5S_CH11_MID_SHIFT                                            (18u)
#define DMAC_DMARS6S_CH12_RID                                                  (0x00000003u)
#define DMAC_DMARS6S_CH12_RID_SHIFT                                            (0u)
#define DMAC_DMARS6S_CH12_MID                                                  (0x000003FCu)
#define DMAC_DMARS6S_CH12_MID_SHIFT                                            (2u)
#define DMAC_DMARS6S_CH13_RID                                                  (0x00030000u)
#define DMAC_DMARS6S_CH13_RID_SHIFT                                            (16u)
#define DMAC_DMARS6S_CH13_MID                                                  (0x03FC0000u)
#define DMAC_DMARS6S_CH13_MID_SHIFT                                            (18u)
#define DMAC_DMARS7S_CH14_RID                                                  (0x00000003u)
#define DMAC_DMARS7S_CH14_RID_SHIFT                                            (0u)
#define DMAC_DMARS7S_CH14_MID                                                  (0x000003FCu)
#define DMAC_DMARS7S_CH14_MID_SHIFT                                            (2u)
#define DMAC_DMARS7S_CH15_RID                                                  (0x00030000u)
#define DMAC_DMARS7S_CH15_RID_SHIFT                                            (16u)
#define DMAC_DMARS7S_CH15_MID                                                  (0x03FC0000u)
#define DMAC_DMARS7S_CH15_MID_SHIFT                                            (18u)
#define DMAC_N0SA_0_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_0_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_0_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_0_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_0_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_0_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_0_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_0_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_0_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_0_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_0_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_0_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_0_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_0_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_0_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_0_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_0_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_0_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_0_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_0_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_0_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_0_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_0_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_0_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_0_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_0_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_0_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_0_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_0_END                                                      (0x00000020u)
#define DMAC_CHSTAT_0_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_0_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_0_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_0_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_0_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_0_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_0_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_0_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_0_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_0_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_0_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_0_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_0_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_0_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_0_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_0_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_0_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_0_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_0_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_0_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_0_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_0_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_0_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_0_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_0_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_0_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_0_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_0_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_0_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_0_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_0_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_0_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_0_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_0_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_0_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_0_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_0_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_0_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_0_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_0_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_0_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_0_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_0_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_0_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_0_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_0_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_0_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_0_AM                                                        (0x00000700u)
#define DMAC_CHCFG_0_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_0_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_0_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_0_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_0_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_0_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_0_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_0_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_0_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_0_TM                                                        (0x00400000u)
#define DMAC_CHCFG_0_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_0_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_0_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_0_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_0_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_0_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_0_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_0_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_0_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_0_REN                                                       (0x40000000u)
#define DMAC_CHCFG_0_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_0_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_0_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_0_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_0_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_0_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_0_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_0_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_0_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_0_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_0_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_0_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_0_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_0_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_0_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_0_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_0_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_1_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_1_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_1_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_1_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_1_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_1_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_1_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_1_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_1_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_1_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_1_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_1_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_1_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_1_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_1_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_1_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_1_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_1_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_1_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_1_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_1_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_1_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_1_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_1_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_1_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_1_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_1_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_1_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_1_END                                                      (0x00000020u)
#define DMAC_CHSTAT_1_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_1_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_1_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_1_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_1_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_1_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_1_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_1_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_1_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_1_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_1_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_1_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_1_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_1_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_1_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_1_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_1_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_1_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_1_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_1_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_1_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_1_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_1_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_1_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_1_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_1_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_1_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_1_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_1_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_1_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_1_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_1_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_1_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_1_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_1_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_1_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_1_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_1_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_1_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_1_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_1_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_1_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_1_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_1_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_1_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_1_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_1_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_1_AM                                                        (0x00000700u)
#define DMAC_CHCFG_1_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_1_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_1_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_1_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_1_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_1_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_1_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_1_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_1_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_1_TM                                                        (0x00400000u)
#define DMAC_CHCFG_1_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_1_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_1_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_1_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_1_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_1_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_1_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_1_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_1_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_1_REN                                                       (0x40000000u)
#define DMAC_CHCFG_1_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_1_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_1_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_1_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_1_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_1_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_1_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_1_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_1_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_1_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_1_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_1_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_1_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_1_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_1_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_1_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_1_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_2_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_2_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_2_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_2_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_2_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_2_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_2_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_2_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_2_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_2_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_2_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_2_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_2_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_2_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_2_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_2_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_2_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_2_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_2_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_2_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_2_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_2_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_2_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_2_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_2_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_2_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_2_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_2_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_2_END                                                      (0x00000020u)
#define DMAC_CHSTAT_2_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_2_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_2_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_2_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_2_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_2_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_2_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_2_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_2_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_2_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_2_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_2_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_2_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_2_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_2_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_2_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_2_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_2_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_2_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_2_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_2_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_2_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_2_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_2_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_2_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_2_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_2_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_2_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_2_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_2_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_2_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_2_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_2_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_2_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_2_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_2_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_2_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_2_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_2_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_2_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_2_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_2_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_2_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_2_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_2_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_2_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_2_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_2_AM                                                        (0x00000700u)
#define DMAC_CHCFG_2_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_2_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_2_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_2_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_2_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_2_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_2_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_2_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_2_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_2_TM                                                        (0x00400000u)
#define DMAC_CHCFG_2_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_2_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_2_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_2_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_2_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_2_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_2_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_2_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_2_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_2_REN                                                       (0x40000000u)
#define DMAC_CHCFG_2_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_2_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_2_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_2_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_2_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_2_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_2_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_2_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_2_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_2_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_2_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_2_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_2_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_2_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_2_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_2_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_2_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_3_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_3_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_3_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_3_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_3_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_3_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_3_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_3_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_3_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_3_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_3_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_3_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_3_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_3_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_3_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_3_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_3_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_3_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_3_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_3_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_3_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_3_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_3_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_3_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_3_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_3_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_3_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_3_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_3_END                                                      (0x00000020u)
#define DMAC_CHSTAT_3_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_3_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_3_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_3_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_3_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_3_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_3_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_3_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_3_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_3_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_3_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_3_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_3_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_3_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_3_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_3_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_3_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_3_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_3_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_3_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_3_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_3_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_3_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_3_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_3_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_3_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_3_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_3_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_3_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_3_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_3_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_3_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_3_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_3_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_3_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_3_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_3_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_3_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_3_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_3_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_3_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_3_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_3_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_3_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_3_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_3_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_3_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_3_AM                                                        (0x00000700u)
#define DMAC_CHCFG_3_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_3_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_3_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_3_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_3_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_3_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_3_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_3_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_3_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_3_TM                                                        (0x00400000u)
#define DMAC_CHCFG_3_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_3_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_3_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_3_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_3_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_3_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_3_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_3_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_3_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_3_REN                                                       (0x40000000u)
#define DMAC_CHCFG_3_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_3_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_3_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_3_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_3_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_3_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_3_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_3_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_3_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_3_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_3_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_3_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_3_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_3_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_3_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_3_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_3_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_4_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_4_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_4_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_4_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_4_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_4_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_4_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_4_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_4_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_4_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_4_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_4_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_4_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_4_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_4_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_4_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_4_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_4_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_4_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_4_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_4_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_4_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_4_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_4_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_4_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_4_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_4_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_4_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_4_END                                                      (0x00000020u)
#define DMAC_CHSTAT_4_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_4_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_4_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_4_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_4_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_4_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_4_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_4_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_4_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_4_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_4_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_4_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_4_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_4_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_4_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_4_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_4_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_4_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_4_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_4_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_4_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_4_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_4_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_4_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_4_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_4_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_4_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_4_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_4_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_4_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_4_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_4_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_4_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_4_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_4_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_4_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_4_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_4_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_4_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_4_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_4_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_4_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_4_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_4_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_4_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_4_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_4_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_4_AM                                                        (0x00000700u)
#define DMAC_CHCFG_4_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_4_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_4_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_4_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_4_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_4_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_4_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_4_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_4_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_4_TM                                                        (0x00400000u)
#define DMAC_CHCFG_4_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_4_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_4_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_4_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_4_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_4_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_4_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_4_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_4_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_4_REN                                                       (0x40000000u)
#define DMAC_CHCFG_4_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_4_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_4_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_4_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_4_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_4_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_4_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_4_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_4_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_4_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_4_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_4_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_4_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_4_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_4_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_4_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_4_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_5_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_5_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_5_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_5_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_5_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_5_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_5_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_5_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_5_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_5_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_5_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_5_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_5_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_5_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_5_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_5_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_5_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_5_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_5_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_5_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_5_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_5_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_5_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_5_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_5_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_5_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_5_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_5_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_5_END                                                      (0x00000020u)
#define DMAC_CHSTAT_5_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_5_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_5_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_5_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_5_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_5_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_5_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_5_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_5_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_5_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_5_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_5_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_5_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_5_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_5_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_5_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_5_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_5_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_5_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_5_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_5_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_5_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_5_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_5_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_5_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_5_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_5_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_5_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_5_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_5_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_5_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_5_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_5_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_5_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_5_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_5_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_5_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_5_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_5_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_5_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_5_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_5_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_5_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_5_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_5_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_5_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_5_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_5_AM                                                        (0x00000700u)
#define DMAC_CHCFG_5_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_5_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_5_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_5_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_5_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_5_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_5_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_5_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_5_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_5_TM                                                        (0x00400000u)
#define DMAC_CHCFG_5_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_5_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_5_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_5_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_5_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_5_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_5_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_5_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_5_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_5_REN                                                       (0x40000000u)
#define DMAC_CHCFG_5_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_5_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_5_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_5_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_5_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_5_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_5_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_5_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_5_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_5_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_5_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_5_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_5_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_5_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_5_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_5_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_5_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_6_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_6_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_6_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_6_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_6_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_6_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_6_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_6_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_6_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_6_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_6_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_6_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_6_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_6_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_6_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_6_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_6_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_6_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_6_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_6_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_6_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_6_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_6_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_6_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_6_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_6_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_6_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_6_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_6_END                                                      (0x00000020u)
#define DMAC_CHSTAT_6_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_6_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_6_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_6_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_6_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_6_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_6_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_6_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_6_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_6_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_6_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_6_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_6_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_6_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_6_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_6_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_6_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_6_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_6_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_6_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_6_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_6_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_6_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_6_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_6_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_6_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_6_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_6_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_6_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_6_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_6_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_6_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_6_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_6_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_6_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_6_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_6_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_6_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_6_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_6_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_6_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_6_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_6_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_6_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_6_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_6_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_6_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_6_AM                                                        (0x00000700u)
#define DMAC_CHCFG_6_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_6_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_6_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_6_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_6_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_6_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_6_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_6_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_6_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_6_TM                                                        (0x00400000u)
#define DMAC_CHCFG_6_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_6_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_6_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_6_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_6_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_6_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_6_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_6_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_6_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_6_REN                                                       (0x40000000u)
#define DMAC_CHCFG_6_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_6_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_6_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_6_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_6_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_6_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_6_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_6_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_6_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_6_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_6_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_6_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_6_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_6_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_6_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_6_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_6_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_7_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_7_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_7_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_7_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_7_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_7_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_7_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_7_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_7_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_7_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_7_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_7_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_7_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_7_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_7_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_7_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_7_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_7_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_7_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_7_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_7_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_7_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_7_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_7_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_7_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_7_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_7_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_7_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_7_END                                                      (0x00000020u)
#define DMAC_CHSTAT_7_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_7_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_7_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_7_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_7_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_7_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_7_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_7_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_7_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_7_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_7_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_7_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_7_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_7_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_7_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_7_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_7_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_7_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_7_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_7_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_7_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_7_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_7_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_7_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_7_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_7_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_7_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_7_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_7_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_7_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_7_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_7_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_7_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_7_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_7_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_7_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_7_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_7_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_7_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_7_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_7_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_7_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_7_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_7_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_7_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_7_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_7_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_7_AM                                                        (0x00000700u)
#define DMAC_CHCFG_7_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_7_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_7_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_7_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_7_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_7_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_7_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_7_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_7_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_7_TM                                                        (0x00400000u)
#define DMAC_CHCFG_7_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_7_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_7_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_7_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_7_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_7_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_7_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_7_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_7_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_7_REN                                                       (0x40000000u)
#define DMAC_CHCFG_7_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_7_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_7_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_7_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_7_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_7_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_7_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_7_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_7_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_7_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_7_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_7_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_7_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_7_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_7_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_7_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_7_CRLA_SHIFT                                                 (0u)
#define DMAC_DCTRL_0_7_PR                                                      (0x00000001u)
#define DMAC_DCTRL_0_7_PR_SHIFT                                                (0u)
#define DMAC_DCTRL_0_7_LVINT                                                   (0x00000002u)
#define DMAC_DCTRL_0_7_LVINT_SHIFT                                             (1u)
#define DMAC_DCTRL_0_7_LDPR                                                    (0x00070000u)
#define DMAC_DCTRL_0_7_LDPR_SHIFT                                              (16u)
#define DMAC_DCTRL_0_7_LDCA                                                    (0x00F00000u)
#define DMAC_DCTRL_0_7_LDCA_SHIFT                                              (20u)
#define DMAC_DCTRL_0_7_LWPR                                                    (0x07000000u)
#define DMAC_DCTRL_0_7_LWPR_SHIFT                                              (24u)
#define DMAC_DCTRL_0_7_LWCA                                                    (0xF0000000u)
#define DMAC_DCTRL_0_7_LWCA_SHIFT                                              (28u)
#define DMAC_DSTAT_EN_0_7_EN0                                                  (0x00000001u)
#define DMAC_DSTAT_EN_0_7_EN0_SHIFT                                            (0u)
#define DMAC_DSTAT_EN_0_7_EN1                                                  (0x00000002u)
#define DMAC_DSTAT_EN_0_7_EN1_SHIFT                                            (1u)
#define DMAC_DSTAT_EN_0_7_EN2                                                  (0x00000004u)
#define DMAC_DSTAT_EN_0_7_EN2_SHIFT                                            (2u)
#define DMAC_DSTAT_EN_0_7_EN3                                                  (0x00000008u)
#define DMAC_DSTAT_EN_0_7_EN3_SHIFT                                            (3u)
#define DMAC_DSTAT_EN_0_7_EN4                                                  (0x00000010u)
#define DMAC_DSTAT_EN_0_7_EN4_SHIFT                                            (4u)
#define DMAC_DSTAT_EN_0_7_EN5                                                  (0x00000020u)
#define DMAC_DSTAT_EN_0_7_EN5_SHIFT                                            (5u)
#define DMAC_DSTAT_EN_0_7_EN6                                                  (0x00000040u)
#define DMAC_DSTAT_EN_0_7_EN6_SHIFT                                            (6u)
#define DMAC_DSTAT_EN_0_7_EN7                                                  (0x00000080u)
#define DMAC_DSTAT_EN_0_7_EN7_SHIFT                                            (7u)
#define DMAC_DSTAT_ER_0_7_ER0                                                  (0x00000001u)
#define DMAC_DSTAT_ER_0_7_ER0_SHIFT                                            (0u)
#define DMAC_DSTAT_ER_0_7_ER1                                                  (0x00000002u)
#define DMAC_DSTAT_ER_0_7_ER1_SHIFT                                            (1u)
#define DMAC_DSTAT_ER_0_7_ER2                                                  (0x00000004u)
#define DMAC_DSTAT_ER_0_7_ER2_SHIFT                                            (2u)
#define DMAC_DSTAT_ER_0_7_ER3                                                  (0x00000008u)
#define DMAC_DSTAT_ER_0_7_ER3_SHIFT                                            (3u)
#define DMAC_DSTAT_ER_0_7_ER4                                                  (0x00000010u)
#define DMAC_DSTAT_ER_0_7_ER4_SHIFT                                            (4u)
#define DMAC_DSTAT_ER_0_7_ER5                                                  (0x00000020u)
#define DMAC_DSTAT_ER_0_7_ER5_SHIFT                                            (5u)
#define DMAC_DSTAT_ER_0_7_ER6                                                  (0x00000040u)
#define DMAC_DSTAT_ER_0_7_ER6_SHIFT                                            (6u)
#define DMAC_DSTAT_ER_0_7_ER7                                                  (0x00000080u)
#define DMAC_DSTAT_ER_0_7_ER7_SHIFT                                            (7u)
#define DMAC_DSTAT_END_0_7_END0                                                (0x00000001u)
#define DMAC_DSTAT_END_0_7_END0_SHIFT                                          (0u)
#define DMAC_DSTAT_END_0_7_END1                                                (0x00000002u)
#define DMAC_DSTAT_END_0_7_END1_SHIFT                                          (1u)
#define DMAC_DSTAT_END_0_7_END2                                                (0x00000004u)
#define DMAC_DSTAT_END_0_7_END2_SHIFT                                          (2u)
#define DMAC_DSTAT_END_0_7_END3                                                (0x00000008u)
#define DMAC_DSTAT_END_0_7_END3_SHIFT                                          (3u)
#define DMAC_DSTAT_END_0_7_END4                                                (0x00000010u)
#define DMAC_DSTAT_END_0_7_END4_SHIFT                                          (4u)
#define DMAC_DSTAT_END_0_7_END5                                                (0x00000020u)
#define DMAC_DSTAT_END_0_7_END5_SHIFT                                          (5u)
#define DMAC_DSTAT_END_0_7_END6                                                (0x00000040u)
#define DMAC_DSTAT_END_0_7_END6_SHIFT                                          (6u)
#define DMAC_DSTAT_END_0_7_END7                                                (0x00000080u)
#define DMAC_DSTAT_END_0_7_END7_SHIFT                                          (7u)
#define DMAC_DSTAT_TC_0_7_TC0                                                  (0x00000001u)
#define DMAC_DSTAT_TC_0_7_TC0_SHIFT                                            (0u)
#define DMAC_DSTAT_TC_0_7_TC1                                                  (0x00000002u)
#define DMAC_DSTAT_TC_0_7_TC1_SHIFT                                            (1u)
#define DMAC_DSTAT_TC_0_7_TC2                                                  (0x00000004u)
#define DMAC_DSTAT_TC_0_7_TC2_SHIFT                                            (2u)
#define DMAC_DSTAT_TC_0_7_TC3                                                  (0x00000008u)
#define DMAC_DSTAT_TC_0_7_TC3_SHIFT                                            (3u)
#define DMAC_DSTAT_TC_0_7_TC4                                                  (0x00000010u)
#define DMAC_DSTAT_TC_0_7_TC4_SHIFT                                            (4u)
#define DMAC_DSTAT_TC_0_7_TC5                                                  (0x00000020u)
#define DMAC_DSTAT_TC_0_7_TC5_SHIFT                                            (5u)
#define DMAC_DSTAT_TC_0_7_TC6                                                  (0x00000040u)
#define DMAC_DSTAT_TC_0_7_TC6_SHIFT                                            (6u)
#define DMAC_DSTAT_TC_0_7_TC7                                                  (0x00000080u)
#define DMAC_DSTAT_TC_0_7_TC7_SHIFT                                            (7u)
#define DMAC_DSTAT_SUS_0_7_SUS0                                                (0x00000001u)
#define DMAC_DSTAT_SUS_0_7_SUS0_SHIFT                                          (0u)
#define DMAC_DSTAT_SUS_0_7_SUS1                                                (0x00000002u)
#define DMAC_DSTAT_SUS_0_7_SUS1_SHIFT                                          (1u)
#define DMAC_DSTAT_SUS_0_7_SUS2                                                (0x00000004u)
#define DMAC_DSTAT_SUS_0_7_SUS2_SHIFT                                          (2u)
#define DMAC_DSTAT_SUS_0_7_SUS3                                                (0x00000008u)
#define DMAC_DSTAT_SUS_0_7_SUS3_SHIFT                                          (3u)
#define DMAC_DSTAT_SUS_0_7_SUS4                                                (0x00000010u)
#define DMAC_DSTAT_SUS_0_7_SUS4_SHIFT                                          (4u)
#define DMAC_DSTAT_SUS_0_7_SUS5                                                (0x00000020u)
#define DMAC_DSTAT_SUS_0_7_SUS5_SHIFT                                          (5u)
#define DMAC_DSTAT_SUS_0_7_SUS6                                                (0x00000040u)
#define DMAC_DSTAT_SUS_0_7_SUS6_SHIFT                                          (6u)
#define DMAC_DSTAT_SUS_0_7_SUS7                                                (0x00000080u)
#define DMAC_DSTAT_SUS_0_7_SUS7_SHIFT                                          (7u)
#define DMAC_N0SA_8_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_8_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_8_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_8_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_8_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_8_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_8_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_8_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_8_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_8_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_8_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_8_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_8_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_8_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_8_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_8_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_8_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_8_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_8_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_8_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_8_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_8_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_8_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_8_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_8_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_8_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_8_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_8_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_8_END                                                      (0x00000020u)
#define DMAC_CHSTAT_8_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_8_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_8_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_8_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_8_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_8_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_8_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_8_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_8_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_8_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_8_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_8_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_8_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_8_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_8_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_8_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_8_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_8_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_8_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_8_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_8_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_8_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_8_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_8_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_8_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_8_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_8_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_8_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_8_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_8_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_8_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_8_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_8_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_8_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_8_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_8_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_8_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_8_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_8_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_8_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_8_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_8_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_8_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_8_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_8_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_8_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_8_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_8_AM                                                        (0x00000700u)
#define DMAC_CHCFG_8_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_8_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_8_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_8_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_8_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_8_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_8_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_8_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_8_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_8_TM                                                        (0x00400000u)
#define DMAC_CHCFG_8_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_8_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_8_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_8_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_8_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_8_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_8_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_8_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_8_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_8_REN                                                       (0x40000000u)
#define DMAC_CHCFG_8_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_8_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_8_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_8_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_8_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_8_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_8_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_8_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_8_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_8_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_8_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_8_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_8_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_8_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_8_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_8_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_8_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_9_SA                                                         (0xFFFFFFFFu)
#define DMAC_N0SA_9_SA_SHIFT                                                   (0u)
#define DMAC_N0DA_9_DA                                                         (0xFFFFFFFFu)
#define DMAC_N0DA_9_DA_SHIFT                                                   (0u)
#define DMAC_N0TB_9_TB                                                         (0xFFFFFFFFu)
#define DMAC_N0TB_9_TB_SHIFT                                                   (0u)
#define DMAC_N1SA_9_SA                                                         (0xFFFFFFFFu)
#define DMAC_N1SA_9_SA_SHIFT                                                   (0u)
#define DMAC_N1DA_9_DA                                                         (0xFFFFFFFFu)
#define DMAC_N1DA_9_DA_SHIFT                                                   (0u)
#define DMAC_N1TB_9_TB                                                         (0xFFFFFFFFu)
#define DMAC_N1TB_9_TB_SHIFT                                                   (0u)
#define DMAC_CRSA_9_CRSA                                                       (0xFFFFFFFFu)
#define DMAC_CRSA_9_CRSA_SHIFT                                                 (0u)
#define DMAC_CRDA_9_CRDA                                                       (0xFFFFFFFFu)
#define DMAC_CRDA_9_CRDA_SHIFT                                                 (0u)
#define DMAC_CRTB_9_CRTB                                                       (0xFFFFFFFFu)
#define DMAC_CRTB_9_CRTB_SHIFT                                                 (0u)
#define DMAC_CHSTAT_9_EN                                                       (0x00000001u)
#define DMAC_CHSTAT_9_EN_SHIFT                                                 (0u)
#define DMAC_CHSTAT_9_RQST                                                     (0x00000002u)
#define DMAC_CHSTAT_9_RQST_SHIFT                                               (1u)
#define DMAC_CHSTAT_9_TACT                                                     (0x00000004u)
#define DMAC_CHSTAT_9_TACT_SHIFT                                               (2u)
#define DMAC_CHSTAT_9_SUS                                                      (0x00000008u)
#define DMAC_CHSTAT_9_SUS_SHIFT                                                (3u)
#define DMAC_CHSTAT_9_ER                                                       (0x00000010u)
#define DMAC_CHSTAT_9_ER_SHIFT                                                 (4u)
#define DMAC_CHSTAT_9_END                                                      (0x00000020u)
#define DMAC_CHSTAT_9_END_SHIFT                                                (5u)
#define DMAC_CHSTAT_9_TC                                                       (0x00000040u)
#define DMAC_CHSTAT_9_TC_SHIFT                                                 (6u)
#define DMAC_CHSTAT_9_SR                                                       (0x00000080u)
#define DMAC_CHSTAT_9_SR_SHIFT                                                 (7u)
#define DMAC_CHSTAT_9_DL                                                       (0x00000100u)
#define DMAC_CHSTAT_9_DL_SHIFT                                                 (8u)
#define DMAC_CHSTAT_9_DW                                                       (0x00000200u)
#define DMAC_CHSTAT_9_DW_SHIFT                                                 (9u)
#define DMAC_CHSTAT_9_DER                                                      (0x00000400u)
#define DMAC_CHSTAT_9_DER_SHIFT                                                (10u)
#define DMAC_CHSTAT_9_MODE                                                     (0x00000800u)
#define DMAC_CHSTAT_9_MODE_SHIFT                                               (11u)
#define DMAC_CHSTAT_9_INTMSK                                                   (0x00010000u)
#define DMAC_CHSTAT_9_INTMSK_SHIFT                                             (16u)
#define DMAC_CHCTRL_9_SETEN                                                    (0x00000001u)
#define DMAC_CHCTRL_9_SETEN_SHIFT                                              (0u)
#define DMAC_CHCTRL_9_CLREN                                                    (0x00000002u)
#define DMAC_CHCTRL_9_CLREN_SHIFT                                              (1u)
#define DMAC_CHCTRL_9_STG                                                      (0x00000004u)
#define DMAC_CHCTRL_9_STG_SHIFT                                                (2u)
#define DMAC_CHCTRL_9_SWRST                                                    (0x00000008u)
#define DMAC_CHCTRL_9_SWRST_SHIFT                                              (3u)
#define DMAC_CHCTRL_9_CLRRQ                                                    (0x00000010u)
#define DMAC_CHCTRL_9_CLRRQ_SHIFT                                              (4u)
#define DMAC_CHCTRL_9_CLREND                                                   (0x00000020u)
#define DMAC_CHCTRL_9_CLREND_SHIFT                                             (5u)
#define DMAC_CHCTRL_9_CLRTC                                                    (0x00000040u)
#define DMAC_CHCTRL_9_CLRTC_SHIFT                                              (6u)
#define DMAC_CHCTRL_9_SETSUS                                                   (0x00000100u)
#define DMAC_CHCTRL_9_SETSUS_SHIFT                                             (8u)
#define DMAC_CHCTRL_9_CLRSUS                                                   (0x00000200u)
#define DMAC_CHCTRL_9_CLRSUS_SHIFT                                             (9u)
#define DMAC_CHCTRL_9_SETINTMSK                                                (0x00010000u)
#define DMAC_CHCTRL_9_SETINTMSK_SHIFT                                          (16u)
#define DMAC_CHCTRL_9_CLRINTMSK                                                (0x00020000u)
#define DMAC_CHCTRL_9_CLRINTMSK_SHIFT                                          (17u)
#define DMAC_CHCFG_9_SEL                                                       (0x00000007u)
#define DMAC_CHCFG_9_SEL_SHIFT                                                 (0u)
#define DMAC_CHCFG_9_REQD                                                      (0x00000008u)
#define DMAC_CHCFG_9_REQD_SHIFT                                                (3u)
#define DMAC_CHCFG_9_LOEN                                                      (0x00000010u)
#define DMAC_CHCFG_9_LOEN_SHIFT                                                (4u)
#define DMAC_CHCFG_9_HIEN                                                      (0x00000020u)
#define DMAC_CHCFG_9_HIEN_SHIFT                                                (5u)
#define DMAC_CHCFG_9_LVL                                                       (0x00000040u)
#define DMAC_CHCFG_9_LVL_SHIFT                                                 (6u)
#define DMAC_CHCFG_9_AM                                                        (0x00000700u)
#define DMAC_CHCFG_9_AM_SHIFT                                                  (8u)
#define DMAC_CHCFG_9_SDS                                                       (0x0000F000u)
#define DMAC_CHCFG_9_SDS_SHIFT                                                 (12u)
#define DMAC_CHCFG_9_DDS                                                       (0x000F0000u)
#define DMAC_CHCFG_9_DDS_SHIFT                                                 (16u)
#define DMAC_CHCFG_9_SAD                                                       (0x00100000u)
#define DMAC_CHCFG_9_SAD_SHIFT                                                 (20u)
#define DMAC_CHCFG_9_DAD                                                       (0x00200000u)
#define DMAC_CHCFG_9_DAD_SHIFT                                                 (21u)
#define DMAC_CHCFG_9_TM                                                        (0x00400000u)
#define DMAC_CHCFG_9_TM_SHIFT                                                  (22u)
#define DMAC_CHCFG_9_DEM                                                       (0x01000000u)
#define DMAC_CHCFG_9_DEM_SHIFT                                                 (24u)
#define DMAC_CHCFG_9_SBE                                                       (0x08000000u)
#define DMAC_CHCFG_9_SBE_SHIFT                                                 (27u)
#define DMAC_CHCFG_9_RSEL                                                      (0x10000000u)
#define DMAC_CHCFG_9_RSEL_SHIFT                                                (28u)
#define DMAC_CHCFG_9_RSW                                                       (0x20000000u)
#define DMAC_CHCFG_9_RSW_SHIFT                                                 (29u)
#define DMAC_CHCFG_9_REN                                                       (0x40000000u)
#define DMAC_CHCFG_9_REN_SHIFT                                                 (30u)
#define DMAC_CHCFG_9_DMS                                                       (0x80000000u)
#define DMAC_CHCFG_9_DMS_SHIFT                                                 (31u)
#define DMAC_CHITVL_9_ITVL                                                     (0x0000FFFFu)
#define DMAC_CHITVL_9_ITVL_SHIFT                                               (0u)
#define DMAC_CHEXT_9_SPR                                                       (0x00000007u)
#define DMAC_CHEXT_9_SPR_SHIFT                                                 (0u)
#define DMAC_CHEXT_9_SCA                                                       (0x000000F0u)
#define DMAC_CHEXT_9_SCA_SHIFT                                                 (4u)
#define DMAC_CHEXT_9_DPR                                                       (0x00000700u)
#define DMAC_CHEXT_9_DPR_SHIFT                                                 (8u)
#define DMAC_CHEXT_9_DCA                                                       (0x0000F000u)
#define DMAC_CHEXT_9_DCA_SHIFT                                                 (12u)
#define DMAC_NXLA_9_NXLA                                                       (0xFFFFFFFFu)
#define DMAC_NXLA_9_NXLA_SHIFT                                                 (0u)
#define DMAC_CRLA_9_CRLA                                                       (0xFFFFFFFFu)
#define DMAC_CRLA_9_CRLA_SHIFT                                                 (0u)
#define DMAC_N0SA_10_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_10_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_10_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_10_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_10_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_10_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_10_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_10_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_10_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_10_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_10_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_10_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_10_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_10_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_10_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_10_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_10_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_10_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_10_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_10_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_10_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_10_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_10_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_10_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_10_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_10_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_10_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_10_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_10_END                                                     (0x00000020u)
#define DMAC_CHSTAT_10_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_10_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_10_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_10_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_10_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_10_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_10_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_10_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_10_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_10_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_10_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_10_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_10_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_10_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_10_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_10_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_10_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_10_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_10_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_10_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_10_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_10_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_10_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_10_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_10_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_10_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_10_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_10_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_10_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_10_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_10_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_10_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_10_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_10_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_10_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_10_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_10_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_10_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_10_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_10_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_10_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_10_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_10_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_10_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_10_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_10_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_10_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_10_AM                                                       (0x00000700u)
#define DMAC_CHCFG_10_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_10_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_10_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_10_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_10_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_10_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_10_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_10_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_10_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_10_TM                                                       (0x00400000u)
#define DMAC_CHCFG_10_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_10_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_10_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_10_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_10_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_10_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_10_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_10_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_10_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_10_REN                                                      (0x40000000u)
#define DMAC_CHCFG_10_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_10_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_10_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_10_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_10_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_10_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_10_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_10_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_10_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_10_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_10_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_10_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_10_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_10_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_10_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_10_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_10_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_11_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_11_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_11_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_11_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_11_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_11_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_11_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_11_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_11_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_11_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_11_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_11_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_11_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_11_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_11_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_11_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_11_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_11_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_11_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_11_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_11_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_11_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_11_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_11_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_11_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_11_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_11_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_11_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_11_END                                                     (0x00000020u)
#define DMAC_CHSTAT_11_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_11_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_11_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_11_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_11_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_11_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_11_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_11_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_11_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_11_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_11_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_11_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_11_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_11_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_11_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_11_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_11_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_11_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_11_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_11_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_11_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_11_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_11_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_11_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_11_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_11_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_11_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_11_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_11_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_11_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_11_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_11_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_11_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_11_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_11_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_11_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_11_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_11_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_11_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_11_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_11_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_11_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_11_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_11_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_11_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_11_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_11_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_11_AM                                                       (0x00000700u)
#define DMAC_CHCFG_11_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_11_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_11_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_11_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_11_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_11_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_11_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_11_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_11_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_11_TM                                                       (0x00400000u)
#define DMAC_CHCFG_11_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_11_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_11_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_11_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_11_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_11_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_11_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_11_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_11_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_11_REN                                                      (0x40000000u)
#define DMAC_CHCFG_11_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_11_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_11_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_11_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_11_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_11_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_11_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_11_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_11_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_11_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_11_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_11_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_11_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_11_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_11_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_11_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_11_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_12_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_12_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_12_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_12_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_12_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_12_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_12_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_12_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_12_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_12_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_12_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_12_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_12_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_12_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_12_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_12_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_12_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_12_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_12_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_12_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_12_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_12_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_12_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_12_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_12_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_12_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_12_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_12_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_12_END                                                     (0x00000020u)
#define DMAC_CHSTAT_12_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_12_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_12_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_12_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_12_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_12_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_12_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_12_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_12_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_12_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_12_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_12_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_12_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_12_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_12_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_12_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_12_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_12_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_12_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_12_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_12_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_12_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_12_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_12_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_12_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_12_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_12_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_12_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_12_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_12_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_12_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_12_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_12_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_12_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_12_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_12_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_12_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_12_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_12_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_12_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_12_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_12_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_12_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_12_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_12_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_12_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_12_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_12_AM                                                       (0x00000700u)
#define DMAC_CHCFG_12_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_12_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_12_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_12_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_12_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_12_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_12_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_12_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_12_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_12_TM                                                       (0x00400000u)
#define DMAC_CHCFG_12_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_12_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_12_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_12_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_12_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_12_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_12_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_12_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_12_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_12_REN                                                      (0x40000000u)
#define DMAC_CHCFG_12_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_12_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_12_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_12_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_12_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_12_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_12_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_12_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_12_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_12_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_12_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_12_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_12_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_12_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_12_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_12_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_12_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_13_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_13_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_13_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_13_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_13_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_13_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_13_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_13_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_13_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_13_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_13_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_13_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_13_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_13_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_13_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_13_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_13_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_13_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_13_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_13_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_13_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_13_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_13_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_13_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_13_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_13_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_13_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_13_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_13_END                                                     (0x00000020u)
#define DMAC_CHSTAT_13_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_13_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_13_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_13_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_13_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_13_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_13_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_13_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_13_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_13_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_13_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_13_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_13_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_13_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_13_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_13_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_13_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_13_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_13_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_13_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_13_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_13_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_13_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_13_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_13_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_13_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_13_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_13_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_13_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_13_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_13_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_13_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_13_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_13_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_13_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_13_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_13_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_13_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_13_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_13_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_13_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_13_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_13_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_13_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_13_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_13_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_13_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_13_AM                                                       (0x00000700u)
#define DMAC_CHCFG_13_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_13_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_13_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_13_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_13_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_13_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_13_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_13_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_13_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_13_TM                                                       (0x00400000u)
#define DMAC_CHCFG_13_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_13_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_13_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_13_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_13_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_13_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_13_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_13_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_13_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_13_REN                                                      (0x40000000u)
#define DMAC_CHCFG_13_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_13_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_13_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_13_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_13_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_13_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_13_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_13_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_13_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_13_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_13_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_13_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_13_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_13_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_13_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_13_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_13_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_14_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_14_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_14_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_14_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_14_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_14_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_14_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_14_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_14_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_14_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_14_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_14_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_14_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_14_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_14_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_14_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_14_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_14_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_14_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_14_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_14_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_14_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_14_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_14_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_14_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_14_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_14_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_14_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_14_END                                                     (0x00000020u)
#define DMAC_CHSTAT_14_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_14_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_14_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_14_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_14_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_14_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_14_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_14_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_14_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_14_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_14_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_14_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_14_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_14_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_14_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_14_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_14_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_14_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_14_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_14_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_14_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_14_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_14_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_14_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_14_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_14_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_14_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_14_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_14_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_14_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_14_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_14_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_14_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_14_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_14_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_14_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_14_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_14_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_14_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_14_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_14_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_14_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_14_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_14_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_14_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_14_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_14_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_14_AM                                                       (0x00000700u)
#define DMAC_CHCFG_14_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_14_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_14_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_14_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_14_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_14_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_14_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_14_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_14_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_14_TM                                                       (0x00400000u)
#define DMAC_CHCFG_14_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_14_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_14_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_14_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_14_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_14_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_14_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_14_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_14_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_14_REN                                                      (0x40000000u)
#define DMAC_CHCFG_14_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_14_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_14_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_14_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_14_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_14_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_14_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_14_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_14_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_14_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_14_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_14_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_14_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_14_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_14_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_14_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_14_CRLA_SHIFT                                                (0u)
#define DMAC_N0SA_15_SA                                                        (0xFFFFFFFFu)
#define DMAC_N0SA_15_SA_SHIFT                                                  (0u)
#define DMAC_N0DA_15_DA                                                        (0xFFFFFFFFu)
#define DMAC_N0DA_15_DA_SHIFT                                                  (0u)
#define DMAC_N0TB_15_TB                                                        (0xFFFFFFFFu)
#define DMAC_N0TB_15_TB_SHIFT                                                  (0u)
#define DMAC_N1SA_15_SA                                                        (0xFFFFFFFFu)
#define DMAC_N1SA_15_SA_SHIFT                                                  (0u)
#define DMAC_N1DA_15_DA                                                        (0xFFFFFFFFu)
#define DMAC_N1DA_15_DA_SHIFT                                                  (0u)
#define DMAC_N1TB_15_TB                                                        (0xFFFFFFFFu)
#define DMAC_N1TB_15_TB_SHIFT                                                  (0u)
#define DMAC_CRSA_15_CRSA                                                      (0xFFFFFFFFu)
#define DMAC_CRSA_15_CRSA_SHIFT                                                (0u)
#define DMAC_CRDA_15_CRDA                                                      (0xFFFFFFFFu)
#define DMAC_CRDA_15_CRDA_SHIFT                                                (0u)
#define DMAC_CRTB_15_CRTB                                                      (0xFFFFFFFFu)
#define DMAC_CRTB_15_CRTB_SHIFT                                                (0u)
#define DMAC_CHSTAT_15_EN                                                      (0x00000001u)
#define DMAC_CHSTAT_15_EN_SHIFT                                                (0u)
#define DMAC_CHSTAT_15_RQST                                                    (0x00000002u)
#define DMAC_CHSTAT_15_RQST_SHIFT                                              (1u)
#define DMAC_CHSTAT_15_TACT                                                    (0x00000004u)
#define DMAC_CHSTAT_15_TACT_SHIFT                                              (2u)
#define DMAC_CHSTAT_15_SUS                                                     (0x00000008u)
#define DMAC_CHSTAT_15_SUS_SHIFT                                               (3u)
#define DMAC_CHSTAT_15_ER                                                      (0x00000010u)
#define DMAC_CHSTAT_15_ER_SHIFT                                                (4u)
#define DMAC_CHSTAT_15_END                                                     (0x00000020u)
#define DMAC_CHSTAT_15_END_SHIFT                                               (5u)
#define DMAC_CHSTAT_15_TC                                                      (0x00000040u)
#define DMAC_CHSTAT_15_TC_SHIFT                                                (6u)
#define DMAC_CHSTAT_15_SR                                                      (0x00000080u)
#define DMAC_CHSTAT_15_SR_SHIFT                                                (7u)
#define DMAC_CHSTAT_15_DL                                                      (0x00000100u)
#define DMAC_CHSTAT_15_DL_SHIFT                                                (8u)
#define DMAC_CHSTAT_15_DW                                                      (0x00000200u)
#define DMAC_CHSTAT_15_DW_SHIFT                                                (9u)
#define DMAC_CHSTAT_15_DER                                                     (0x00000400u)
#define DMAC_CHSTAT_15_DER_SHIFT                                               (10u)
#define DMAC_CHSTAT_15_MODE                                                    (0x00000800u)
#define DMAC_CHSTAT_15_MODE_SHIFT                                              (11u)
#define DMAC_CHSTAT_15_INTMSK                                                  (0x00010000u)
#define DMAC_CHSTAT_15_INTMSK_SHIFT                                            (16u)
#define DMAC_CHCTRL_15_SETEN                                                   (0x00000001u)
#define DMAC_CHCTRL_15_SETEN_SHIFT                                             (0u)
#define DMAC_CHCTRL_15_CLREN                                                   (0x00000002u)
#define DMAC_CHCTRL_15_CLREN_SHIFT                                             (1u)
#define DMAC_CHCTRL_15_STG                                                     (0x00000004u)
#define DMAC_CHCTRL_15_STG_SHIFT                                               (2u)
#define DMAC_CHCTRL_15_SWRST                                                   (0x00000008u)
#define DMAC_CHCTRL_15_SWRST_SHIFT                                             (3u)
#define DMAC_CHCTRL_15_CLRRQ                                                   (0x00000010u)
#define DMAC_CHCTRL_15_CLRRQ_SHIFT                                             (4u)
#define DMAC_CHCTRL_15_CLREND                                                  (0x00000020u)
#define DMAC_CHCTRL_15_CLREND_SHIFT                                            (5u)
#define DMAC_CHCTRL_15_CLRTC                                                   (0x00000040u)
#define DMAC_CHCTRL_15_CLRTC_SHIFT                                             (6u)
#define DMAC_CHCTRL_15_SETSUS                                                  (0x00000100u)
#define DMAC_CHCTRL_15_SETSUS_SHIFT                                            (8u)
#define DMAC_CHCTRL_15_CLRSUS                                                  (0x00000200u)
#define DMAC_CHCTRL_15_CLRSUS_SHIFT                                            (9u)
#define DMAC_CHCTRL_15_SETINTMSK                                               (0x00010000u)
#define DMAC_CHCTRL_15_SETINTMSK_SHIFT                                         (16u)
#define DMAC_CHCTRL_15_CLRINTMSK                                               (0x00020000u)
#define DMAC_CHCTRL_15_CLRINTMSK_SHIFT                                         (17u)
#define DMAC_CHCFG_15_SEL                                                      (0x00000007u)
#define DMAC_CHCFG_15_SEL_SHIFT                                                (0u)
#define DMAC_CHCFG_15_REQD                                                     (0x00000008u)
#define DMAC_CHCFG_15_REQD_SHIFT                                               (3u)
#define DMAC_CHCFG_15_LOEN                                                     (0x00000010u)
#define DMAC_CHCFG_15_LOEN_SHIFT                                               (4u)
#define DMAC_CHCFG_15_HIEN                                                     (0x00000020u)
#define DMAC_CHCFG_15_HIEN_SHIFT                                               (5u)
#define DMAC_CHCFG_15_LVL                                                      (0x00000040u)
#define DMAC_CHCFG_15_LVL_SHIFT                                                (6u)
#define DMAC_CHCFG_15_AM                                                       (0x00000700u)
#define DMAC_CHCFG_15_AM_SHIFT                                                 (8u)
#define DMAC_CHCFG_15_SDS                                                      (0x0000F000u)
#define DMAC_CHCFG_15_SDS_SHIFT                                                (12u)
#define DMAC_CHCFG_15_DDS                                                      (0x000F0000u)
#define DMAC_CHCFG_15_DDS_SHIFT                                                (16u)
#define DMAC_CHCFG_15_SAD                                                      (0x00100000u)
#define DMAC_CHCFG_15_SAD_SHIFT                                                (20u)
#define DMAC_CHCFG_15_DAD                                                      (0x00200000u)
#define DMAC_CHCFG_15_DAD_SHIFT                                                (21u)
#define DMAC_CHCFG_15_TM                                                       (0x00400000u)
#define DMAC_CHCFG_15_TM_SHIFT                                                 (22u)
#define DMAC_CHCFG_15_DEM                                                      (0x01000000u)
#define DMAC_CHCFG_15_DEM_SHIFT                                                (24u)
#define DMAC_CHCFG_15_SBE                                                      (0x08000000u)
#define DMAC_CHCFG_15_SBE_SHIFT                                                (27u)
#define DMAC_CHCFG_15_RSEL                                                     (0x10000000u)
#define DMAC_CHCFG_15_RSEL_SHIFT                                               (28u)
#define DMAC_CHCFG_15_RSW                                                      (0x20000000u)
#define DMAC_CHCFG_15_RSW_SHIFT                                                (29u)
#define DMAC_CHCFG_15_REN                                                      (0x40000000u)
#define DMAC_CHCFG_15_REN_SHIFT                                                (30u)
#define DMAC_CHCFG_15_DMS                                                      (0x80000000u)
#define DMAC_CHCFG_15_DMS_SHIFT                                                (31u)
#define DMAC_CHITVL_15_ITVL                                                    (0x0000FFFFu)
#define DMAC_CHITVL_15_ITVL_SHIFT                                              (0u)
#define DMAC_CHEXT_15_SPR                                                      (0x00000007u)
#define DMAC_CHEXT_15_SPR_SHIFT                                                (0u)
#define DMAC_CHEXT_15_SCA                                                      (0x000000F0u)
#define DMAC_CHEXT_15_SCA_SHIFT                                                (4u)
#define DMAC_CHEXT_15_DPR                                                      (0x00000700u)
#define DMAC_CHEXT_15_DPR_SHIFT                                                (8u)
#define DMAC_CHEXT_15_DCA                                                      (0x0000F000u)
#define DMAC_CHEXT_15_DCA_SHIFT                                                (12u)
#define DMAC_NXLA_15_NXLA                                                      (0xFFFFFFFFu)
#define DMAC_NXLA_15_NXLA_SHIFT                                                (0u)
#define DMAC_CRLA_15_CRLA                                                      (0xFFFFFFFFu)
#define DMAC_CRLA_15_CRLA_SHIFT                                                (0u)
#define DMAC_DCTRL_8_15_PR                                                     (0x00000001u)
#define DMAC_DCTRL_8_15_PR_SHIFT                                               (0u)
#define DMAC_DCTRL_8_15_LVINT                                                  (0x00000002u)
#define DMAC_DCTRL_8_15_LVINT_SHIFT                                            (1u)
#define DMAC_DCTRL_8_15_LDPR                                                   (0x00070000u)
#define DMAC_DCTRL_8_15_LDPR_SHIFT                                             (16u)
#define DMAC_DCTRL_8_15_LDCA                                                   (0x00F00000u)
#define DMAC_DCTRL_8_15_LDCA_SHIFT                                             (20u)
#define DMAC_DCTRL_8_15_LWPR                                                   (0x07000000u)
#define DMAC_DCTRL_8_15_LWPR_SHIFT                                             (24u)
#define DMAC_DCTRL_8_15_LWCA                                                   (0xF0000000u)
#define DMAC_DCTRL_8_15_LWCA_SHIFT                                             (28u)
#define DMAC_DSTAT_EN_8_15_EN8                                                 (0x00000001u)
#define DMAC_DSTAT_EN_8_15_EN8_SHIFT                                           (0u)
#define DMAC_DSTAT_EN_8_15_EN9                                                 (0x00000002u)
#define DMAC_DSTAT_EN_8_15_EN9_SHIFT                                           (1u)
#define DMAC_DSTAT_EN_8_15_EN10                                                (0x00000004u)
#define DMAC_DSTAT_EN_8_15_EN10_SHIFT                                          (2u)
#define DMAC_DSTAT_EN_8_15_EN11                                                (0x00000008u)
#define DMAC_DSTAT_EN_8_15_EN11_SHIFT                                          (3u)
#define DMAC_DSTAT_EN_8_15_EN12                                                (0x00000010u)
#define DMAC_DSTAT_EN_8_15_EN12_SHIFT                                          (4u)
#define DMAC_DSTAT_EN_8_15_EN13                                                (0x00000020u)
#define DMAC_DSTAT_EN_8_15_EN13_SHIFT                                          (5u)
#define DMAC_DSTAT_EN_8_15_EN14                                                (0x00000040u)
#define DMAC_DSTAT_EN_8_15_EN14_SHIFT                                          (6u)
#define DMAC_DSTAT_EN_8_15_EN15                                                (0x00000080u)
#define DMAC_DSTAT_EN_8_15_EN15_SHIFT                                          (7u)
#define DMAC_DSTAT_ER_8_15_ER8                                                 (0x00000001u)
#define DMAC_DSTAT_ER_8_15_ER8_SHIFT                                           (0u)
#define DMAC_DSTAT_ER_8_15_ER9                                                 (0x00000002u)
#define DMAC_DSTAT_ER_8_15_ER9_SHIFT                                           (1u)
#define DMAC_DSTAT_ER_8_15_ER10                                                (0x00000004u)
#define DMAC_DSTAT_ER_8_15_ER10_SHIFT                                          (2u)
#define DMAC_DSTAT_ER_8_15_ER11                                                (0x00000008u)
#define DMAC_DSTAT_ER_8_15_ER11_SHIFT                                          (3u)
#define DMAC_DSTAT_ER_8_15_ER12                                                (0x00000010u)
#define DMAC_DSTAT_ER_8_15_ER12_SHIFT                                          (4u)
#define DMAC_DSTAT_ER_8_15_ER13                                                (0x00000020u)
#define DMAC_DSTAT_ER_8_15_ER13_SHIFT                                          (5u)
#define DMAC_DSTAT_ER_8_15_ER14                                                (0x00000040u)
#define DMAC_DSTAT_ER_8_15_ER14_SHIFT                                          (6u)
#define DMAC_DSTAT_ER_8_15_ER15                                                (0x00000080u)
#define DMAC_DSTAT_ER_8_15_ER15_SHIFT                                          (7u)
#define DMAC_DSTAT_END_8_15_END8                                               (0x00000001u)
#define DMAC_DSTAT_END_8_15_END8_SHIFT                                         (0u)
#define DMAC_DSTAT_END_8_15_END9                                               (0x00000002u)
#define DMAC_DSTAT_END_8_15_END9_SHIFT                                         (1u)
#define DMAC_DSTAT_END_8_15_END10                                              (0x00000004u)
#define DMAC_DSTAT_END_8_15_END10_SHIFT                                        (2u)
#define DMAC_DSTAT_END_8_15_END11                                              (0x00000008u)
#define DMAC_DSTAT_END_8_15_END11_SHIFT                                        (3u)
#define DMAC_DSTAT_END_8_15_END12                                              (0x00000010u)
#define DMAC_DSTAT_END_8_15_END12_SHIFT                                        (4u)
#define DMAC_DSTAT_END_8_15_END13                                              (0x00000020u)
#define DMAC_DSTAT_END_8_15_END13_SHIFT                                        (5u)
#define DMAC_DSTAT_END_8_15_END14                                              (0x00000040u)
#define DMAC_DSTAT_END_8_15_END14_SHIFT                                        (6u)
#define DMAC_DSTAT_END_8_15_END15                                              (0x00000080u)
#define DMAC_DSTAT_END_8_15_END15_SHIFT                                        (7u)
#define DMAC_DSTAT_TC_8_15_TC8                                                 (0x00000001u)
#define DMAC_DSTAT_TC_8_15_TC8_SHIFT                                           (0u)
#define DMAC_DSTAT_TC_8_15_TC9                                                 (0x00000002u)
#define DMAC_DSTAT_TC_8_15_TC9_SHIFT                                           (1u)
#define DMAC_DSTAT_TC_8_15_TC10                                                (0x00000004u)
#define DMAC_DSTAT_TC_8_15_TC10_SHIFT                                          (2u)
#define DMAC_DSTAT_TC_8_15_TC11                                                (0x00000008u)
#define DMAC_DSTAT_TC_8_15_TC11_SHIFT                                          (3u)
#define DMAC_DSTAT_TC_8_15_TC12                                                (0x00000010u)
#define DMAC_DSTAT_TC_8_15_TC12_SHIFT                                          (4u)
#define DMAC_DSTAT_TC_8_15_TC13                                                (0x00000020u)
#define DMAC_DSTAT_TC_8_15_TC13_SHIFT                                          (5u)
#define DMAC_DSTAT_TC_8_15_TC14                                                (0x00000040u)
#define DMAC_DSTAT_TC_8_15_TC14_SHIFT                                          (6u)
#define DMAC_DSTAT_TC_8_15_TC15                                                (0x00000080u)
#define DMAC_DSTAT_TC_8_15_TC15_SHIFT                                          (7u)
#define DMAC_DSTAT_SUS_8_15_SUS8                                               (0x00000001u)
#define DMAC_DSTAT_SUS_8_15_SUS8_SHIFT                                         (0u)
#define DMAC_DSTAT_SUS_8_15_SUS9                                               (0x00000002u)
#define DMAC_DSTAT_SUS_8_15_SUS9_SHIFT                                         (1u)
#define DMAC_DSTAT_SUS_8_15_SUS10                                              (0x00000004u)
#define DMAC_DSTAT_SUS_8_15_SUS10_SHIFT                                        (2u)
#define DMAC_DSTAT_SUS_8_15_SUS11                                              (0x00000008u)
#define DMAC_DSTAT_SUS_8_15_SUS11_SHIFT                                        (3u)
#define DMAC_DSTAT_SUS_8_15_SUS12                                              (0x00000010u)
#define DMAC_DSTAT_SUS_8_15_SUS12_SHIFT                                        (4u)
#define DMAC_DSTAT_SUS_8_15_SUS13                                              (0x00000020u)
#define DMAC_DSTAT_SUS_8_15_SUS13_SHIFT                                        (5u)
#define DMAC_DSTAT_SUS_8_15_SUS14                                              (0x00000040u)
#define DMAC_DSTAT_SUS_8_15_SUS14_SHIFT                                        (6u)
#define DMAC_DSTAT_SUS_8_15_SUS15                                              (0x00000080u)
#define DMAC_DSTAT_SUS_8_15_SUS15_SHIFT                                        (7u)
#define DMAC_DMARS0_CH0_RID                                                    (0x00000003u)
#define DMAC_DMARS0_CH0_RID_SHIFT                                              (0u)
#define DMAC_DMARS0_CH0_MID                                                    (0x000003FCu)
#define DMAC_DMARS0_CH0_MID_SHIFT                                              (2u)
#define DMAC_DMARS0_CH1_RID                                                    (0x00030000u)
#define DMAC_DMARS0_CH1_RID_SHIFT                                              (16u)
#define DMAC_DMARS0_CH1_MID                                                    (0x03FC0000u)
#define DMAC_DMARS0_CH1_MID_SHIFT                                              (18u)
#define DMAC_DMARS1_CH2_RID                                                    (0x00000003u)
#define DMAC_DMARS1_CH2_RID_SHIFT                                              (0u)
#define DMAC_DMARS1_CH2_MID                                                    (0x000003FCu)
#define DMAC_DMARS1_CH2_MID_SHIFT                                              (2u)
#define DMAC_DMARS1_CH3_RID                                                    (0x00030000u)
#define DMAC_DMARS1_CH3_RID_SHIFT                                              (16u)
#define DMAC_DMARS1_CH3_MID                                                    (0x03FC0000u)
#define DMAC_DMARS1_CH3_MID_SHIFT                                              (18u)
#define DMAC_DMARS2_CH4_RID                                                    (0x00000003u)
#define DMAC_DMARS2_CH4_RID_SHIFT                                              (0u)
#define DMAC_DMARS2_CH4_MID                                                    (0x000003FCu)
#define DMAC_DMARS2_CH4_MID_SHIFT                                              (2u)
#define DMAC_DMARS2_CH5_RID                                                    (0x00030000u)
#define DMAC_DMARS2_CH5_RID_SHIFT                                              (16u)
#define DMAC_DMARS2_CH5_MID                                                    (0x03FC0000u)
#define DMAC_DMARS2_CH5_MID_SHIFT                                              (18u)
#define DMAC_DMARS3_CH6_RID                                                    (0x00000003u)
#define DMAC_DMARS3_CH6_RID_SHIFT                                              (0u)
#define DMAC_DMARS3_CH6_MID                                                    (0x000003FCu)
#define DMAC_DMARS3_CH6_MID_SHIFT                                              (2u)
#define DMAC_DMARS3_CH7_RID                                                    (0x00030000u)
#define DMAC_DMARS3_CH7_RID_SHIFT                                              (16u)
#define DMAC_DMARS3_CH7_MID                                                    (0x03FC0000u)
#define DMAC_DMARS3_CH7_MID_SHIFT                                              (18u)
#define DMAC_DMARS4_CH8_RID                                                    (0x00000003u)
#define DMAC_DMARS4_CH8_RID_SHIFT                                              (0u)
#define DMAC_DMARS4_CH8_MID                                                    (0x000003FCu)
#define DMAC_DMARS4_CH8_MID_SHIFT                                              (2u)
#define DMAC_DMARS4_CH9_RID                                                    (0x00030000u)
#define DMAC_DMARS4_CH9_RID_SHIFT                                              (16u)
#define DMAC_DMARS4_CH9_MID                                                    (0x03FC0000u)
#define DMAC_DMARS4_CH9_MID_SHIFT                                              (18u)
#define DMAC_DMARS5_CH10_RID                                                   (0x00000003u)
#define DMAC_DMARS5_CH10_RID_SHIFT                                             (0u)
#define DMAC_DMARS5_CH10_MID                                                   (0x000003FCu)
#define DMAC_DMARS5_CH10_MID_SHIFT                                             (2u)
#define DMAC_DMARS5_CH11_RID                                                   (0x00030000u)
#define DMAC_DMARS5_CH11_RID_SHIFT                                             (16u)
#define DMAC_DMARS5_CH11_MID                                                   (0x03FC0000u)
#define DMAC_DMARS5_CH11_MID_SHIFT                                             (18u)
#define DMAC_DMARS6_CH12_RID                                                   (0x00000003u)
#define DMAC_DMARS6_CH12_RID_SHIFT                                             (0u)
#define DMAC_DMARS6_CH12_MID                                                   (0x000003FCu)
#define DMAC_DMARS6_CH12_MID_SHIFT                                             (2u)
#define DMAC_DMARS6_CH13_RID                                                   (0x00030000u)
#define DMAC_DMARS6_CH13_RID_SHIFT                                             (16u)
#define DMAC_DMARS6_CH13_MID                                                   (0x03FC0000u)
#define DMAC_DMARS6_CH13_MID_SHIFT                                             (18u)
#define DMAC_DMARS7_CH14_RID                                                   (0x00000003u)
#define DMAC_DMARS7_CH14_RID_SHIFT                                             (0u)
#define DMAC_DMARS7_CH14_MID                                                   (0x000003FCu)
#define DMAC_DMARS7_CH14_MID_SHIFT                                             (2u)
#define DMAC_DMARS7_CH15_RID                                                   (0x00030000u)
#define DMAC_DMARS7_CH15_RID_SHIFT                                             (16u)
#define DMAC_DMARS7_CH15_MID                                                   (0x03FC0000u)
#define DMAC_DMARS7_CH15_MID_SHIFT                                             (18u)

#endif
