/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef EPTPC_IOBITMASK_H
#define EPTPC_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define EPTPC_PTRSTR_RESET                                                     (0x00000001u)
#define EPTPC_PTRSTR_RESET_SHIFT                                               (0u)
#define EPTPC_STCSELR_SCLKSEL                                                  (0x00000700u)
#define EPTPC_STCSELR_SCLKSEL_SHIFT                                            (8u)
#define EPTPC_BYPASS_BYPASS0                                                   (0x00000001u)
#define EPTPC_BYPASS_BYPASS0_SHIFT                                             (0u)
#define EPTPC_BYPASS_BYPASS1                                                   (0x00010000u)
#define EPTPC_BYPASS_BYPASS1_SHIFT                                             (16u)
#define EPTPC_MIESR_ST                                                         (0x00000001u)
#define EPTPC_MIESR_ST_SHIFT                                                   (0u)
#define EPTPC_MIESR_SY0                                                        (0x00000002u)
#define EPTPC_MIESR_SY0_SHIFT                                                  (1u)
#define EPTPC_MIESR_SY1                                                        (0x00000004u)
#define EPTPC_MIESR_SY1_SHIFT                                                  (2u)
#define EPTPC_MIESR_PRC                                                        (0x00000008u)
#define EPTPC_MIESR_PRC_SHIFT                                                  (3u)
#define EPTPC_MIESR_CYC0                                                       (0x00010000u)
#define EPTPC_MIESR_CYC0_SHIFT                                                 (16u)
#define EPTPC_MIESR_CYC1                                                       (0x00020000u)
#define EPTPC_MIESR_CYC1_SHIFT                                                 (17u)
#define EPTPC_MIESR_CYC2                                                       (0x00040000u)
#define EPTPC_MIESR_CYC2_SHIFT                                                 (18u)
#define EPTPC_MIESR_CYC3                                                       (0x00080000u)
#define EPTPC_MIESR_CYC3_SHIFT                                                 (19u)
#define EPTPC_MIESR_CYC4                                                       (0x00100000u)
#define EPTPC_MIESR_CYC4_SHIFT                                                 (20u)
#define EPTPC_MIESR_CYC5                                                       (0x00200000u)
#define EPTPC_MIESR_CYC5_SHIFT                                                 (21u)
#define EPTPC_MIEIPR_ST                                                        (0x00000001u)
#define EPTPC_MIEIPR_ST_SHIFT                                                  (0u)
#define EPTPC_MIEIPR_SY0                                                       (0x00000002u)
#define EPTPC_MIEIPR_SY0_SHIFT                                                 (1u)
#define EPTPC_MIEIPR_SY1                                                       (0x00000004u)
#define EPTPC_MIEIPR_SY1_SHIFT                                                 (2u)
#define EPTPC_MIEIPR_PR                                                        (0x00000008u)
#define EPTPC_MIEIPR_PR_SHIFT                                                  (3u)
#define EPTPC_MIEIPR_CYC0                                                      (0x00010000u)
#define EPTPC_MIEIPR_CYC0_SHIFT                                                (16u)
#define EPTPC_MIEIPR_CYC1                                                      (0x00020000u)
#define EPTPC_MIEIPR_CYC1_SHIFT                                                (17u)
#define EPTPC_MIEIPR_CYC2                                                      (0x00040000u)
#define EPTPC_MIEIPR_CYC2_SHIFT                                                (18u)
#define EPTPC_MIEIPR_CYC3                                                      (0x00080000u)
#define EPTPC_MIEIPR_CYC3_SHIFT                                                (19u)
#define EPTPC_MIEIPR_CYC4                                                      (0x00100000u)
#define EPTPC_MIEIPR_CYC4_SHIFT                                                (20u)
#define EPTPC_MIEIPR_CYC5                                                      (0x00200000u)
#define EPTPC_MIEIPR_CYC5_SHIFT                                                (21u)
#define EPTPC_ELIPPR_PLSP                                                      (0x00010000u)
#define EPTPC_ELIPPR_PLSP_SHIFT                                                (16u)
#define EPTPC_ELIPPR_PLSN                                                      (0x01000000u)
#define EPTPC_ELIPPR_PLSN_SHIFT                                                (24u)
#define EPTPC_ELIPACR_PLSP                                                     (0x00010000u)
#define EPTPC_ELIPACR_PLSP_SHIFT                                               (16u)
#define EPTPC_ELIPACR_PLSN                                                     (0x01000000u)
#define EPTPC_ELIPACR_PLSN_SHIFT                                               (24u)
#define EPTPC_STSR_SYNC                                                        (0x00000001u)
#define EPTPC_STSR_SYNC_SHIFT                                                  (0u)
#define EPTPC_STSR_SYNCOUT                                                     (0x00000002u)
#define EPTPC_STSR_SYNCOUT_SHIFT                                               (1u)
#define EPTPC_STSR_SYNTOUT                                                     (0x00000008u)
#define EPTPC_STSR_SYNTOUT_SHIFT                                               (3u)
#define EPTPC_STSR_W10D                                                        (0x00000010u)
#define EPTPC_STSR_W10D_SHIFT                                                  (4u)
#define EPTPC_STIPR_SYNC                                                       (0x00000001u)
#define EPTPC_STIPR_SYNC_SHIFT                                                 (0u)
#define EPTPC_STIPR_SYNCOUT                                                    (0x00000002u)
#define EPTPC_STIPR_SYNCOUT_SHIFT                                              (1u)
#define EPTPC_STIPR_SYNTOUT                                                    (0x00000008u)
#define EPTPC_STIPR_SYNTOUT_SHIFT                                              (3u)
#define EPTPC_STIPR_W10D                                                       (0x00000010u)
#define EPTPC_STIPR_W10D_SHIFT                                                 (4u)
#define EPTPC_STCFR_STCF                                                       (0x00000003u)
#define EPTPC_STCFR_STCF_SHIFT                                                 (0u)
#define EPTPC_STMR_WINT                                                        (0x000000FFu)
#define EPTPC_STMR_WINT_SHIFT                                                  (0u)
#define EPTPC_STMR_CMOD                                                        (0x00002000u)
#define EPTPC_STMR_CMOD_SHIFT                                                  (13u)
#define EPTPC_STMR_W10S                                                        (0x00008000u)
#define EPTPC_STMR_W10S_SHIFT                                                  (15u)
#define EPTPC_STMR_SYTH                                                        (0x000F0000u)
#define EPTPC_STMR_SYTH_SHIFT                                                  (16u)
#define EPTPC_STMR_DVTH                                                        (0x00F00000u)
#define EPTPC_STMR_DVTH_SHIFT                                                  (20u)
#define EPTPC_STMR_ALEN0                                                       (0x10000000u)
#define EPTPC_STMR_ALEN0_SHIFT                                                 (28u)
#define EPTPC_STMR_ALEN1                                                       (0x20000000u)
#define EPTPC_STMR_ALEN1_SHIFT                                                 (29u)
#define EPTPC_SYNTOR_SYNTOR                                                    (0xFFFFFFFFu)
#define EPTPC_SYNTOR_SYNTOR_SHIFT                                              (0u)
#define EPTPC_IPTSELR_IPTSEL0                                                  (0x00000001u)
#define EPTPC_IPTSELR_IPTSEL0_SHIFT                                            (0u)
#define EPTPC_IPTSELR_IPTSEL1                                                  (0x00000002u)
#define EPTPC_IPTSELR_IPTSEL1_SHIFT                                            (1u)
#define EPTPC_IPTSELR_IPTSEL2                                                  (0x00000004u)
#define EPTPC_IPTSELR_IPTSEL2_SHIFT                                            (2u)
#define EPTPC_IPTSELR_IPTSEL3                                                  (0x00000008u)
#define EPTPC_IPTSELR_IPTSEL3_SHIFT                                            (3u)
#define EPTPC_IPTSELR_IPTSEL4                                                  (0x00000010u)
#define EPTPC_IPTSELR_IPTSEL4_SHIFT                                            (4u)
#define EPTPC_IPTSELR_IPTSEL5                                                  (0x00000020u)
#define EPTPC_IPTSELR_IPTSEL5_SHIFT                                            (5u)
#define EPTPC_MITSELR_MINTEN0                                                  (0x00000001u)
#define EPTPC_MITSELR_MINTEN0_SHIFT                                            (0u)
#define EPTPC_MITSELR_MINTEN1                                                  (0x00000002u)
#define EPTPC_MITSELR_MINTEN1_SHIFT                                            (1u)
#define EPTPC_MITSELR_MINTEN2                                                  (0x00000004u)
#define EPTPC_MITSELR_MINTEN2_SHIFT                                            (2u)
#define EPTPC_MITSELR_MINTEN3                                                  (0x00000008u)
#define EPTPC_MITSELR_MINTEN3_SHIFT                                            (3u)
#define EPTPC_MITSELR_MINTEN4                                                  (0x00000010u)
#define EPTPC_MITSELR_MINTEN4_SHIFT                                            (4u)
#define EPTPC_MITSELR_MINTEN5                                                  (0x00000020u)
#define EPTPC_MITSELR_MINTEN5_SHIFT                                            (5u)
#define EPTPC_STCHSELR_SYSEL                                                   (0x00000001u)
#define EPTPC_STCHSELR_SYSEL_SHIFT                                             (0u)
#define EPTPC_SYNSTARTR_STR                                                    (0x00000001u)
#define EPTPC_SYNSTARTR_STR_SHIFT                                              (0u)
#define EPTPC_LCIVLDR_LOAD                                                     (0x00000001u)
#define EPTPC_LCIVLDR_LOAD_SHIFT                                               (0u)
#define EPTPC_SYNTDARU_SYNTDARU                                                (0xFFFFFFFFu)
#define EPTPC_SYNTDARU_SYNTDARU_SHIFT                                          (0u)
#define EPTPC_SYNTDARL_SYNTDARL                                                (0xFFFFFFFFu)
#define EPTPC_SYNTDARL_SYNTDARL_SHIFT                                          (0u)
#define EPTPC_SYNTDBRU_SYNTDBRU                                                (0xFFFFFFFFu)
#define EPTPC_SYNTDBRU_SYNTDBRU_SHIFT                                          (0u)
#define EPTPC_SYNTDBRL_SYNTDBRL                                                (0xFFFFFFFFu)
#define EPTPC_SYNTDBRL_SYNTDBRL_SHIFT                                          (0u)
#define EPTPC_LCIVRU_LCIVRU                                                    (0x0000FFFFu)
#define EPTPC_LCIVRU_LCIVRU_SHIFT                                              (0u)
#define EPTPC_LCIVRM_LCIVRM                                                    (0x0000FFFFu)
#define EPTPC_LCIVRM_LCIVRM_SHIFT                                              (0u)
#define EPTPC_LCIVRL_LCIVRL                                                    (0x0000FFFFu)
#define EPTPC_LCIVRL_LCIVRL_SHIFT                                              (0u)
#define EPTPC_GETW10R_GW10                                                     (0x00000001u)
#define EPTPC_GETW10R_GW10_SHIFT                                               (0u)
#define EPTPC_PLIMITRU_PLIMITRU                                                (0x7FFFFFFFu)
#define EPTPC_PLIMITRU_PLIMITRU_SHIFT                                          (0u)
#define EPTPC_PLIMITRM_PLIMITRM                                                (0xFFFFFFFFu)
#define EPTPC_PLIMITRM_PLIMITRM_SHIFT                                          (0u)
#define EPTPC_PLIMITRL_PLIMITRL                                                (0xFFFFFFFFu)
#define EPTPC_PLIMITRL_PLIMITRL_SHIFT                                          (0u)
#define EPTPC_MLIMITRU_MLIMITRU                                                (0x7FFFFFFFu)
#define EPTPC_MLIMITRU_MLIMITRU_SHIFT                                          (0u)
#define EPTPC_MLIMITRM_MLIMITRM                                                (0xFFFFFFFFu)
#define EPTPC_MLIMITRM_MLIMITRM_SHIFT                                          (0u)
#define EPTPC_MLIMITRL_MLIMITRL                                                (0xFFFFFFFFu)
#define EPTPC_MLIMITRL_MLIMITRL_SHIFT                                          (0u)
#define EPTPC_GETINFOR_INFO                                                    (0x00000001u)
#define EPTPC_GETINFOR_INFO_SHIFT                                              (0u)
#define EPTPC_LCCVRU_LCCVRU                                                    (0x0000FFFFu)
#define EPTPC_LCCVRU_LCCVRU_SHIFT                                              (0u)
#define EPTPC_LCCVRM_LCCVRM                                                    (0xFFFFFFFFu)
#define EPTPC_LCCVRM_LCCVRM_SHIFT                                              (0u)
#define EPTPC_LCCVRL_LCCVRL                                                    (0xFFFFFFFFu)
#define EPTPC_LCCVRL_LCCVRL_SHIFT                                              (0u)
#define EPTPC_PW10VRU_PW10VRU                                                  (0xFFFFFFFFu)
#define EPTPC_PW10VRU_PW10VRU_SHIFT                                            (0u)
#define EPTPC_PW10VRM_PW10VRM                                                  (0xFFFFFFFFu)
#define EPTPC_PW10VRM_PW10VRM_SHIFT                                            (0u)
#define EPTPC_PW10VRL_PW10VRL                                                  (0xFFFFFFFFu)
#define EPTPC_PW10VRL_PW10VRL_SHIFT                                            (0u)
#define EPTPC_MW10RU_MW10RU                                                    (0xFFFFFFFFu)
#define EPTPC_MW10RU_MW10RU_SHIFT                                              (0u)
#define EPTPC_MW10RM_MW10RM                                                    (0xFFFFFFFFu)
#define EPTPC_MW10RM_MW10RM_SHIFT                                              (0u)
#define EPTPC_MW10RL_MW10RL                                                    (0xFFFFFFFFu)
#define EPTPC_MW10RL_MW10RL_SHIFT                                              (0u)
#define EPTPC_TMSTTRU0_TMSTTRU0                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRU0_TMSTTRU0_SHIFT                                          (0u)
#define EPTPC_TMSTTRL0_TMSTTRL0                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRL0_TMSTTRL0_SHIFT                                          (0u)
#define EPTPC_TMCYCR0_TMCYCR0                                                  (0xFFFFFFFFu)
#define EPTPC_TMCYCR0_TMCYCR0_SHIFT                                            (0u)
#define EPTPC_TMPLSR0_TMPLSR0                                                  (0x1FFFFFFFu)
#define EPTPC_TMPLSR0_TMPLSR0_SHIFT                                            (0u)
#define EPTPC_TMSTTRU1_TMSTTRU1                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRU1_TMSTTRU1_SHIFT                                          (0u)
#define EPTPC_TMSTTRL1_TMSTTRL1                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRL1_TMSTTRL1_SHIFT                                          (0u)
#define EPTPC_TMCYCR1_TMCYCR1                                                  (0xFFFFFFFFu)
#define EPTPC_TMCYCR1_TMCYCR1_SHIFT                                            (0u)
#define EPTPC_TMPLSR1_TMPLSR1                                                  (0x1FFFFFFFu)
#define EPTPC_TMPLSR1_TMPLSR1_SHIFT                                            (0u)
#define EPTPC_TMSTTRU2_TMSTTRU2                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRU2_TMSTTRU2_SHIFT                                          (0u)
#define EPTPC_TMSTTRL2_TMSTTRL2                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRL2_TMSTTRL2_SHIFT                                          (0u)
#define EPTPC_TMCYCR2_TMCYCR2                                                  (0xFFFFFFFFu)
#define EPTPC_TMCYCR2_TMCYCR2_SHIFT                                            (0u)
#define EPTPC_TMPLSR2_TMPLSR2                                                  (0x1FFFFFFFu)
#define EPTPC_TMPLSR2_TMPLSR2_SHIFT                                            (0u)
#define EPTPC_TMSTTRU3_TMSTTRU3                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRU3_TMSTTRU3_SHIFT                                          (0u)
#define EPTPC_TMSTTRL3_TMSTTRL3                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRL3_TMSTTRL3_SHIFT                                          (0u)
#define EPTPC_TMCYCR3_TMCYCR3                                                  (0xFFFFFFFFu)
#define EPTPC_TMCYCR3_TMCYCR3_SHIFT                                            (0u)
#define EPTPC_TMPLSR3_TMPLSR3                                                  (0x1FFFFFFFu)
#define EPTPC_TMPLSR3_TMPLSR3_SHIFT                                            (0u)
#define EPTPC_TMSTTRU4_TMSTTRU4                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRU4_TMSTTRU4_SHIFT                                          (0u)
#define EPTPC_TMSTTRL4_TMSTTRL4                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRL4_TMSTTRL4_SHIFT                                          (0u)
#define EPTPC_TMCYCR4_TMCYCR4                                                  (0xFFFFFFFFu)
#define EPTPC_TMCYCR4_TMCYCR4_SHIFT                                            (0u)
#define EPTPC_TMPLSR4_TMPLSR4                                                  (0x1FFFFFFFu)
#define EPTPC_TMPLSR4_TMPLSR4_SHIFT                                            (0u)
#define EPTPC_TMSTTRU5_TMSTTRU5                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRU5_TMSTTRU5_SHIFT                                          (0u)
#define EPTPC_TMSTTRL5_TMSTTRL5                                                (0xFFFFFFFFu)
#define EPTPC_TMSTTRL5_TMSTTRL5_SHIFT                                          (0u)
#define EPTPC_TMCYCR5_TMCYCR5                                                  (0xFFFFFFFFu)
#define EPTPC_TMCYCR5_TMCYCR5_SHIFT                                            (0u)
#define EPTPC_TMPLSR5_TMPLSR5                                                  (0x1FFFFFFFu)
#define EPTPC_TMPLSR5_TMPLSR5_SHIFT                                            (0u)
#define EPTPC_TMSTARTR_EN0                                                     (0x00000001u)
#define EPTPC_TMSTARTR_EN0_SHIFT                                               (0u)
#define EPTPC_TMSTARTR_EN1                                                     (0x00000002u)
#define EPTPC_TMSTARTR_EN1_SHIFT                                               (1u)
#define EPTPC_TMSTARTR_EN2                                                     (0x00000004u)
#define EPTPC_TMSTARTR_EN2_SHIFT                                               (2u)
#define EPTPC_TMSTARTR_EN3                                                     (0x00000008u)
#define EPTPC_TMSTARTR_EN3_SHIFT                                               (3u)
#define EPTPC_TMSTARTR_EN4                                                     (0x00000010u)
#define EPTPC_TMSTARTR_EN4_SHIFT                                               (4u)
#define EPTPC_TMSTARTR_EN5                                                     (0x00000020u)
#define EPTPC_TMSTARTR_EN5_SHIFT                                               (5u)
#define EPTPC_PRSR_OVRE0                                                       (0x00000001u)
#define EPTPC_PRSR_OVRE0_SHIFT                                                 (0u)
#define EPTPC_PRSR_OVRE1                                                       (0x00000002u)
#define EPTPC_PRSR_OVRE1_SHIFT                                                 (1u)
#define EPTPC_PRSR_OVRE2                                                       (0x00000004u)
#define EPTPC_PRSR_OVRE2_SHIFT                                                 (2u)
#define EPTPC_PRSR_OVRE3                                                       (0x00000008u)
#define EPTPC_PRSR_OVRE3_SHIFT                                                 (3u)
#define EPTPC_PRSR_MACE                                                        (0x00000100u)
#define EPTPC_PRSR_MACE_SHIFT                                                  (8u)
#define EPTPC_PRSR_URE0                                                        (0x10000000u)
#define EPTPC_PRSR_URE0_SHIFT                                                  (28u)
#define EPTPC_PRSR_URE1                                                        (0x20000000u)
#define EPTPC_PRSR_URE1_SHIFT                                                  (29u)
#define EPTPC_PRIPR_OVRE0                                                      (0x00000001u)
#define EPTPC_PRIPR_OVRE0_SHIFT                                                (0u)
#define EPTPC_PRIPR_OVRE1                                                      (0x00000002u)
#define EPTPC_PRIPR_OVRE1_SHIFT                                                (1u)
#define EPTPC_PRIPR_OVRE2                                                      (0x00000004u)
#define EPTPC_PRIPR_OVRE2_SHIFT                                                (2u)
#define EPTPC_PRIPR_OVRE3                                                      (0x00000008u)
#define EPTPC_PRIPR_OVRE3_SHIFT                                                (3u)
#define EPTPC_PRIPR_MACE                                                       (0x00000100u)
#define EPTPC_PRIPR_MACE_SHIFT                                                 (8u)
#define EPTPC_PRIPR_URE0                                                       (0x10000000u)
#define EPTPC_PRIPR_URE0_SHIFT                                                 (28u)
#define EPTPC_PRIPR_URE1                                                       (0x20000000u)
#define EPTPC_PRIPR_URE1_SHIFT                                                 (29u)
#define EPTPC_PRMACRU0_PRMACRU0                                                (0x00FFFFFFu)
#define EPTPC_PRMACRU0_PRMACRU0_SHIFT                                          (0u)
#define EPTPC_PRMACRL0_PRMACRL0                                                (0x00FFFFFFu)
#define EPTPC_PRMACRL0_PRMACRL0_SHIFT                                          (0u)
#define EPTPC_PRMACRU1_PRMACRU1                                                (0x00FFFFFFu)
#define EPTPC_PRMACRU1_PRMACRU1_SHIFT                                          (0u)
#define EPTPC_PRMACRL1_PRMACRL1                                                (0x00FFFFFFu)
#define EPTPC_PRMACRL1_PRMACRL1_SHIFT                                          (0u)
#define EPTPC_TRNDISR_TDIS                                                     (0x00000003u)
#define EPTPC_TRNDISR_TDIS_SHIFT                                               (0u)
#define EPTPC_TRNMR_MOD                                                        (0x00000001u)
#define EPTPC_TRNMR_MOD_SHIFT                                                  (0u)
#define EPTPC_TRNMR_FWD0                                                       (0x00000100u)
#define EPTPC_TRNMR_FWD0_SHIFT                                                 (8u)
#define EPTPC_TRNMR_FWD1                                                       (0x00000200u)
#define EPTPC_TRNMR_FWD1_SHIFT                                                 (9u)
#define EPTPC_TRNCTTDR_THVAL                                                   (0x000007FFu)
#define EPTPC_TRNCTTDR_THVAL_SHIFT                                             (0u)
#define EPTPC_SYSR_OFMUD                                                       (0x00000001u)
#define EPTPC_SYSR_OFMUD_SHIFT                                                 (0u)
#define EPTPC_SYSR_INTCHG                                                      (0x00000002u)
#define EPTPC_SYSR_INTCHG_SHIFT                                                (1u)
#define EPTPC_SYSR_MPDUD                                                       (0x00000004u)
#define EPTPC_SYSR_MPDUD_SHIFT                                                 (2u)
#define EPTPC_SYSR_DRPTO                                                       (0x00000010u)
#define EPTPC_SYSR_DRPTO_SHIFT                                                 (4u)
#define EPTPC_SYSR_INTDEV                                                      (0x00000020u)
#define EPTPC_SYSR_INTDEV_SHIFT                                                (5u)
#define EPTPC_SYSR_DRQOVR                                                      (0x00000040u)
#define EPTPC_SYSR_DRQOVR_SHIFT                                                (6u)
#define EPTPC_SYSR_RECLP                                                       (0x00001000u)
#define EPTPC_SYSR_RECLP_SHIFT                                                 (12u)
#define EPTPC_SYSR_INFABT                                                      (0x00004000u)
#define EPTPC_SYSR_INFABT_SHIFT                                                (14u)
#define EPTPC_SYSR_RESDN                                                       (0x00010000u)
#define EPTPC_SYSR_RESDN_SHIFT                                                 (16u)
#define EPTPC_SYSR_GENDN                                                       (0x00020000u)
#define EPTPC_SYSR_GENDN_SHIFT                                                 (17u)
#define EPTPC_SYIPR_OFMUD                                                      (0x00000001u)
#define EPTPC_SYIPR_OFMUD_SHIFT                                                (0u)
#define EPTPC_SYIPR_INTCHG                                                     (0x00000002u)
#define EPTPC_SYIPR_INTCHG_SHIFT                                               (1u)
#define EPTPC_SYIPR_MPDUD                                                      (0x00000004u)
#define EPTPC_SYIPR_MPDUD_SHIFT                                                (2u)
#define EPTPC_SYIPR_DRPTO                                                      (0x00000010u)
#define EPTPC_SYIPR_DRPTO_SHIFT                                                (4u)
#define EPTPC_SYIPR_INTDEV                                                     (0x00000020u)
#define EPTPC_SYIPR_INTDEV_SHIFT                                               (5u)
#define EPTPC_SYIPR_DRQOVR                                                     (0x00000040u)
#define EPTPC_SYIPR_DRQOVR_SHIFT                                               (6u)
#define EPTPC_SYIPR_RECLP                                                      (0x00001000u)
#define EPTPC_SYIPR_RECLP_SHIFT                                                (12u)
#define EPTPC_SYIPR_INFABT                                                     (0x00004000u)
#define EPTPC_SYIPR_INFABT_SHIFT                                               (14u)
#define EPTPC_SYIPR_RESDN                                                      (0x00010000u)
#define EPTPC_SYIPR_RESDN_SHIFT                                                (16u)
#define EPTPC_SYIPR_GENDN                                                      (0x00020000u)
#define EPTPC_SYIPR_GENDN_SHIFT                                                (17u)
#define EPTPC_SYMACRU_SYMACRU                                                  (0x00FFFFFFu)
#define EPTPC_SYMACRU_SYMACRU_SHIFT                                            (0u)
#define EPTPC_SYMACRL_SYMACRL                                                  (0x00FFFFFFu)
#define EPTPC_SYMACRL_SYMACRL_SHIFT                                            (0u)
#define EPTPC_SYLLCCTLR_CTL                                                    (0x000000FFu)
#define EPTPC_SYLLCCTLR_CTL_SHIFT                                              (0u)
#define EPTPC_SYIPADDRR_SYIPADDRR                                              (0xFFFFFFFFu)
#define EPTPC_SYIPADDRR_SYIPADDRR_SHIFT                                        (0u)
#define EPTPC_SYSPVRR_VER                                                      (0x0000000Fu)
#define EPTPC_SYSPVRR_VER_SHIFT                                                (0u)
#define EPTPC_SYSPVRR_TRSP                                                     (0x000000F0u)
#define EPTPC_SYSPVRR_TRSP_SHIFT                                               (4u)
#define EPTPC_SYDOMR_DNUM                                                      (0x000000FFu)
#define EPTPC_SYDOMR_DNUM_SHIFT                                                (0u)
#define EPTPC_ANFR_FLAG0                                                       (0x00000001u)
#define EPTPC_ANFR_FLAG0_SHIFT                                                 (0u)
#define EPTPC_ANFR_FLAG1                                                       (0x00000002u)
#define EPTPC_ANFR_FLAG1_SHIFT                                                 (1u)
#define EPTPC_ANFR_FLAG2                                                       (0x00000004u)
#define EPTPC_ANFR_FLAG2_SHIFT                                                 (2u)
#define EPTPC_ANFR_FLAG3                                                       (0x00000008u)
#define EPTPC_ANFR_FLAG3_SHIFT                                                 (3u)
#define EPTPC_ANFR_FLAG4                                                       (0x00000010u)
#define EPTPC_ANFR_FLAG4_SHIFT                                                 (4u)
#define EPTPC_ANFR_FLAG5                                                       (0x00000020u)
#define EPTPC_ANFR_FLAG5_SHIFT                                                 (5u)
#define EPTPC_ANFR_FLAG8                                                       (0x00000100u)
#define EPTPC_ANFR_FLAG8_SHIFT                                                 (8u)
#define EPTPC_ANFR_FLAG10                                                      (0x00000400u)
#define EPTPC_ANFR_FLAG10_SHIFT                                                (10u)
#define EPTPC_ANFR_FLAG13                                                      (0x00002000u)
#define EPTPC_ANFR_FLAG13_SHIFT                                                (13u)
#define EPTPC_ANFR_FLAG14                                                      (0x00004000u)
#define EPTPC_ANFR_FLAG14_SHIFT                                                (14u)
#define EPTPC_SYNFR_FLAG10                                                     (0x00000400u)
#define EPTPC_SYNFR_FLAG10_SHIFT                                               (10u)
#define EPTPC_SYNFR_FLAG13                                                     (0x00002000u)
#define EPTPC_SYNFR_FLAG13_SHIFT                                               (13u)
#define EPTPC_SYNFR_FLAG14                                                     (0x00004000u)
#define EPTPC_SYNFR_FLAG14_SHIFT                                               (14u)
#define EPTPC_DYRQFR_FLAG10                                                    (0x00000400u)
#define EPTPC_DYRQFR_FLAG10_SHIFT                                              (10u)
#define EPTPC_DYRQFR_FLAG13                                                    (0x00002000u)
#define EPTPC_DYRQFR_FLAG13_SHIFT                                              (13u)
#define EPTPC_DYRQFR_FLAG14                                                    (0x00004000u)
#define EPTPC_DYRQFR_FLAG14_SHIFT                                              (14u)
#define EPTPC_DYRPFR_FLAG8                                                     (0x00000100u)
#define EPTPC_DYRPFR_FLAG8_SHIFT                                               (8u)
#define EPTPC_DYRPFR_FLAG9                                                     (0x00000200u)
#define EPTPC_DYRPFR_FLAG9_SHIFT                                               (9u)
#define EPTPC_DYRPFR_FLAG10                                                    (0x00000400u)
#define EPTPC_DYRPFR_FLAG10_SHIFT                                              (10u)
#define EPTPC_DYRPFR_FLAG13                                                    (0x00002000u)
#define EPTPC_DYRPFR_FLAG13_SHIFT                                              (13u)
#define EPTPC_DYRPFR_FLAG14                                                    (0x00004000u)
#define EPTPC_DYRPFR_FLAG14_SHIFT                                              (14u)
#define EPTPC_SYCIDRL_SYCIDRL                                                  (0xFFFFFFFFu)
#define EPTPC_SYCIDRL_SYCIDRL_SHIFT                                            (0u)
#define EPTPC_SYCIDRU_SYCIDRU                                                  (0xFFFFFFFFu)
#define EPTPC_SYCIDRU_SYCIDRU_SHIFT                                            (0u)
#define EPTPC_SYPNUMR_PNUM                                                     (0x0000FFFFu)
#define EPTPC_SYPNUMR_PNUM_SHIFT                                               (0u)
#define EPTPC_SYRVLDR_BMUP                                                     (0x00000001u)
#define EPTPC_SYRVLDR_BMUP_SHIFT                                               (0u)
#define EPTPC_SYRVLDR_STUP                                                     (0x00000002u)
#define EPTPC_SYRVLDR_STUP_SHIFT                                               (1u)
#define EPTPC_SYRVLDR_ANUP                                                     (0x00000004u)
#define EPTPC_SYRVLDR_ANUP_SHIFT                                               (2u)
#define EPTPC_SYRFL1R_ANCE                                                     (0x00000003u)
#define EPTPC_SYRFL1R_ANCE_SHIFT                                               (0u)
#define EPTPC_SYRFL1R_SYNC                                                     (0x00000070u)
#define EPTPC_SYRFL1R_SYNC_SHIFT                                               (4u)
#define EPTPC_SYRFL1R_FUP                                                      (0x00000700u)
#define EPTPC_SYRFL1R_FUP_SHIFT                                                (8u)
#define EPTPC_SYRFL1R_DRQ                                                      (0x00007000u)
#define EPTPC_SYRFL1R_DRQ_SHIFT                                                (12u)
#define EPTPC_SYRFL1R_DRP                                                      (0x00070000u)
#define EPTPC_SYRFL1R_DRP_SHIFT                                                (16u)
#define EPTPC_SYRFL1R_PDRQ                                                     (0x00700000u)
#define EPTPC_SYRFL1R_PDRQ_SHIFT                                               (20u)
#define EPTPC_SYRFL1R_PDRP                                                     (0x07000000u)
#define EPTPC_SYRFL1R_PDRP_SHIFT                                               (24u)
#define EPTPC_SYRFL1R_PDFUP                                                    (0x70000000u)
#define EPTPC_SYRFL1R_PDFUP_SHIFT                                              (28u)
#define EPTPC_SYRFL2R_MAN                                                      (0x00000003u)
#define EPTPC_SYRFL2R_MAN_SHIFT                                                (0u)
#define EPTPC_SYRFL2R_SIG                                                      (0x00000030u)
#define EPTPC_SYRFL2R_SIG_SHIFT                                                (4u)
#define EPTPC_SYRFL2R_ILL                                                      (0x30000000u)
#define EPTPC_SYRFL2R_ILL_SHIFT                                                (28u)
#define EPTPC_SYTRENR_ANCE                                                     (0x00000001u)
#define EPTPC_SYTRENR_ANCE_SHIFT                                               (0u)
#define EPTPC_SYTRENR_SYNC                                                     (0x00000010u)
#define EPTPC_SYTRENR_SYNC_SHIFT                                               (4u)
#define EPTPC_SYTRENR_DRQ                                                      (0x00000100u)
#define EPTPC_SYTRENR_DRQ_SHIFT                                                (8u)
#define EPTPC_SYTRENR_PDRQ                                                     (0x00001000u)
#define EPTPC_SYTRENR_PDRQ_SHIFT                                               (12u)
#define EPTPC_MTCIDL_MTCIDL                                                    (0xFFFFFFFFu)
#define EPTPC_MTCIDL_MTCIDL_SHIFT                                              (0u)
#define EPTPC_MTCIDU_MTCIDU                                                    (0xFFFFFFFFu)
#define EPTPC_MTCIDU_MTCIDU_SHIFT                                              (0u)
#define EPTPC_MTPID_PNUM                                                       (0x0000FFFFu)
#define EPTPC_MTPID_PNUM_SHIFT                                                 (0u)
#define EPTPC_SYTLIR_ANCE                                                      (0x000000FFu)
#define EPTPC_SYTLIR_ANCE_SHIFT                                                (0u)
#define EPTPC_SYTLIR_SYNC                                                      (0x0000FF00u)
#define EPTPC_SYTLIR_SYNC_SHIFT                                                (8u)
#define EPTPC_SYTLIR_DREQ                                                      (0x00FF0000u)
#define EPTPC_SYTLIR_DREQ_SHIFT                                                (16u)
#define EPTPC_SYRLIR_ANCE                                                      (0x000000FFu)
#define EPTPC_SYRLIR_ANCE_SHIFT                                                (0u)
#define EPTPC_SYRLIR_SYNC                                                      (0x0000FF00u)
#define EPTPC_SYRLIR_SYNC_SHIFT                                                (8u)
#define EPTPC_SYRLIR_DRESP                                                     (0x00FF0000u)
#define EPTPC_SYRLIR_DRESP_SHIFT                                               (16u)
#define EPTPC_OFMRL_OFMRL                                                      (0xFFFFFFFFu)
#define EPTPC_OFMRL_OFMRL_SHIFT                                                (0u)
#define EPTPC_OFMRU_OFMRU                                                      (0xFFFFFFFFu)
#define EPTPC_OFMRU_OFMRU_SHIFT                                                (0u)
#define EPTPC_MPDRU_MPDRU                                                      (0xFFFFFFFFu)
#define EPTPC_MPDRU_MPDRU_SHIFT                                                (0u)
#define EPTPC_MPDRL_MPDRL                                                      (0xFFFFFFFFu)
#define EPTPC_MPDRL_MPDRL_SHIFT                                                (0u)
#define EPTPC_GMPR_GMPR2                                                       (0x000000FFu)
#define EPTPC_GMPR_GMPR2_SHIFT                                                 (0u)
#define EPTPC_GMPR_GMPR1                                                       (0x00FF0000u)
#define EPTPC_GMPR_GMPR1_SHIFT                                                 (16u)
#define EPTPC_GMCQR_GMCQR                                                      (0xFFFFFFFFu)
#define EPTPC_GMCQR_GMCQR_SHIFT                                                (0u)
#define EPTPC_GMIDRU_GMIDRU                                                    (0xFFFFFFFFu)
#define EPTPC_GMIDRU_GMIDRU_SHIFT                                              (0u)
#define EPTPC_GMIDRL_GMIDRL                                                    (0xFFFFFFFFu)
#define EPTPC_GMIDRL_GMIDRL_SHIFT                                              (0u)
#define EPTPC_CUOTSR_TSRC                                                      (0x000000FFu)
#define EPTPC_CUOTSR_TSRC_SHIFT                                                (0u)
#define EPTPC_CUOTSR_CUTO                                                      (0xFFFF0000u)
#define EPTPC_CUOTSR_CUTO_SHIFT                                                (16u)
#define EPTPC_SRR_SRMV                                                         (0x0000FFFFu)
#define EPTPC_SRR_SRMV_SHIFT                                                   (0u)
#define EPTPC_PPMACRU_PPMACRU                                                  (0x00FFFFFFu)
#define EPTPC_PPMACRU_PPMACRU_SHIFT                                            (0u)
#define EPTPC_PPMACRL_PPMACRL                                                  (0x00FFFFFFu)
#define EPTPC_PPMACRL_PPMACRL_SHIFT                                            (0u)
#define EPTPC_PDMACRU_PDMACRU                                                  (0x00FFFFFFu)
#define EPTPC_PDMACRU_PDMACRU_SHIFT                                            (0u)
#define EPTPC_PDMACRL_PDMACRL                                                  (0x00FFFFFFu)
#define EPTPC_PDMACRL_PDMACRL_SHIFT                                            (0u)
#define EPTPC_PETYPER_TYPE                                                     (0x0000FFFFu)
#define EPTPC_PETYPER_TYPE_SHIFT                                               (0u)
#define EPTPC_PPIPR_PPIPR                                                      (0xFFFFFFFFu)
#define EPTPC_PPIPR_PPIPR_SHIFT                                                (0u)
#define EPTPC_PDIPR_PDIPR                                                      (0xFFFFFFFFu)
#define EPTPC_PDIPR_PDIPR_SHIFT                                                (0u)
#define EPTPC_PETOSR_EVTO                                                      (0x000000FFu)
#define EPTPC_PETOSR_EVTO_SHIFT                                                (0u)
#define EPTPC_PGTOSR_GETO                                                      (0x000000FFu)
#define EPTPC_PGTOSR_GETO_SHIFT                                                (0u)
#define EPTPC_PPTTLR_PRTL                                                      (0x000000FFu)
#define EPTPC_PPTTLR_PRTL_SHIFT                                                (0u)
#define EPTPC_PDTTLR_PDTL                                                      (0x000000FFu)
#define EPTPC_PDTTLR_PDTL_SHIFT                                                (0u)
#define EPTPC_PEUDPR_EVUPT                                                     (0x0000FFFFu)
#define EPTPC_PEUDPR_EVUPT_SHIFT                                               (0u)
#define EPTPC_PGUDPR_GEUPT                                                     (0x0000FFFFu)
#define EPTPC_PGUDPR_GEUPT_SHIFT                                               (0u)
#define EPTPC_FFLTR_SEL                                                        (0x00000001u)
#define EPTPC_FFLTR_SEL_SHIFT                                                  (0u)
#define EPTPC_FFLTR_PRT                                                        (0x00000002u)
#define EPTPC_FFLTR_PRT_SHIFT                                                  (1u)
#define EPTPC_FFLTR_ENB                                                        (0x00000004u)
#define EPTPC_FFLTR_ENB_SHIFT                                                  (2u)
#define EPTPC_FFLTR_EXTPRM                                                     (0x00010000u)
#define EPTPC_FFLTR_EXTPRM_SHIFT                                               (16u)
#define EPTPC_FMAC0RU_FMAC0RU                                                  (0x00FFFFFFu)
#define EPTPC_FMAC0RU_FMAC0RU_SHIFT                                            (0u)
#define EPTPC_FMAC0RL_FMAC0RL                                                  (0x00FFFFFFu)
#define EPTPC_FMAC0RL_FMAC0RL_SHIFT                                            (0u)
#define EPTPC_FMAC1RU_FMAC1RU                                                  (0x00FFFFFFu)
#define EPTPC_FMAC1RU_FMAC1RU_SHIFT                                            (0u)
#define EPTPC_FMAC1RL_FMAC1RL                                                  (0x00FFFFFFu)
#define EPTPC_FMAC1RL_FMAC1RL_SHIFT                                            (0u)
#define EPTPC_DASYMRU_DASYMRU                                                  (0x0000FFFFu)
#define EPTPC_DASYMRU_DASYMRU_SHIFT                                            (0u)
#define EPTPC_DASYMRL_DASYMRL                                                  (0xFFFFFFFFu)
#define EPTPC_DASYMRL_DASYMRL_SHIFT                                            (0u)
#define EPTPC_TSLATR_EGP                                                       (0x0000FFFFu)
#define EPTPC_TSLATR_EGP_SHIFT                                                 (0u)
#define EPTPC_TSLATR_INGP                                                      (0xFFFF0000u)
#define EPTPC_TSLATR_INGP_SHIFT                                                (16u)
#define EPTPC_SYCONFR_TCYC                                                     (0x000000FFu)
#define EPTPC_SYCONFR_TCYC_SHIFT                                               (0u)
#define EPTPC_SYCONFR_SBDIS                                                    (0x00001000u)
#define EPTPC_SYCONFR_SBDIS_SHIFT                                              (12u)
#define EPTPC_SYCONFR_FILDIS                                                   (0x00010000u)
#define EPTPC_SYCONFR_FILDIS_SHIFT                                             (16u)
#define EPTPC_SYCONFR_TCMOD                                                    (0x00100000u)
#define EPTPC_SYCONFR_TCMOD_SHIFT                                              (20u)
#define EPTPC_SYFORMR_FORM0                                                    (0x00000001u)
#define EPTPC_SYFORMR_FORM0_SHIFT                                              (0u)
#define EPTPC_SYFORMR_FORM1                                                    (0x00000002u)
#define EPTPC_SYFORMR_FORM1_SHIFT                                              (1u)
#define EPTPC_RSTOUTR_RSTOUTR                                                  (0xFFFFFFFFu)
#define EPTPC_RSTOUTR_RSTOUTR_SHIFT                                            (0u)

#endif
