/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef GPT_IOBITMASK_H
#define GPT_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define GPT_GTECR_EVCON                                                        (0x80u)
#define GPT_GTECR_EVCON_SHIFT                                                  (7u)
#define GPT_GTESR0_EVS                                                         (0x007Fu)
#define GPT_GTESR0_EVS_SHIFT                                                   (0u)
#define GPT_GTESR1_EVS                                                         (0x007Fu)
#define GPT_GTESR1_EVS_SHIFT                                                   (0u)
#define GPT_GTESR2_EVS                                                         (0x007Fu)
#define GPT_GTESR2_EVS_SHIFT                                                   (0u)
#define GPT_GTESR3_EVS                                                         (0x007Fu)
#define GPT_GTESR3_EVS_SHIFT                                                   (0u)
#define GPT_GTESR4_EVS                                                         (0x007Fu)
#define GPT_GTESR4_EVS_SHIFT                                                   (0u)
#define GPT_GTESR5_EVS                                                         (0x007Fu)
#define GPT_GTESR5_EVS_SHIFT                                                   (0u)
#define GPT_GTESR6_EVS                                                         (0x007Fu)
#define GPT_GTESR6_EVS_SHIFT                                                   (0u)
#define GPT_GTESR7_EVS                                                         (0x007Fu)
#define GPT_GTESR7_EVS_SHIFT                                                   (0u)
#define GPT_GTWP_WP                                                            (0x00000001u)
#define GPT_GTWP_WP_SHIFT                                                      (0u)
#define GPT_GTWP_PRKEY                                                         (0x0000FF00u)
#define GPT_GTWP_PRKEY_SHIFT                                                   (8u)
#define GPT_GTSTR_CSTRT0                                                       (0x00000001u)
#define GPT_GTSTR_CSTRT0_SHIFT                                                 (0u)
#define GPT_GTSTR_CSTRT1                                                       (0x00000002u)
#define GPT_GTSTR_CSTRT1_SHIFT                                                 (1u)
#define GPT_GTSTR_CSTRT2                                                       (0x00000004u)
#define GPT_GTSTR_CSTRT2_SHIFT                                                 (2u)
#define GPT_GTSTR_CSTRT3                                                       (0x00000008u)
#define GPT_GTSTR_CSTRT3_SHIFT                                                 (3u)
#define GPT_GTSTR_CSTRT4                                                       (0x00000010u)
#define GPT_GTSTR_CSTRT4_SHIFT                                                 (4u)
#define GPT_GTSTR_CSTRT5                                                       (0x00000020u)
#define GPT_GTSTR_CSTRT5_SHIFT                                                 (5u)
#define GPT_GTSTR_CSTRT6                                                       (0x00000040u)
#define GPT_GTSTR_CSTRT6_SHIFT                                                 (6u)
#define GPT_GTSTR_CSTRT7                                                       (0x00000080u)
#define GPT_GTSTR_CSTRT7_SHIFT                                                 (7u)
#define GPT_GTSTP_CSTOP0                                                       (0x00000001u)
#define GPT_GTSTP_CSTOP0_SHIFT                                                 (0u)
#define GPT_GTSTP_CSTOP1                                                       (0x00000002u)
#define GPT_GTSTP_CSTOP1_SHIFT                                                 (1u)
#define GPT_GTSTP_CSTOP2                                                       (0x00000004u)
#define GPT_GTSTP_CSTOP2_SHIFT                                                 (2u)
#define GPT_GTSTP_CSTOP3                                                       (0x00000008u)
#define GPT_GTSTP_CSTOP3_SHIFT                                                 (3u)
#define GPT_GTSTP_CSTOP4                                                       (0x00000010u)
#define GPT_GTSTP_CSTOP4_SHIFT                                                 (4u)
#define GPT_GTSTP_CSTOP5                                                       (0x00000020u)
#define GPT_GTSTP_CSTOP5_SHIFT                                                 (5u)
#define GPT_GTSTP_CSTOP6                                                       (0x00000040u)
#define GPT_GTSTP_CSTOP6_SHIFT                                                 (6u)
#define GPT_GTSTP_CSTOP7                                                       (0x00000080u)
#define GPT_GTSTP_CSTOP7_SHIFT                                                 (7u)
#define GPT_GTCLR_CCLR0                                                        (0x00000001u)
#define GPT_GTCLR_CCLR0_SHIFT                                                  (0u)
#define GPT_GTCLR_CCLR1                                                        (0x00000002u)
#define GPT_GTCLR_CCLR1_SHIFT                                                  (1u)
#define GPT_GTCLR_CCLR2                                                        (0x00000004u)
#define GPT_GTCLR_CCLR2_SHIFT                                                  (2u)
#define GPT_GTCLR_CCLR3                                                        (0x00000008u)
#define GPT_GTCLR_CCLR3_SHIFT                                                  (3u)
#define GPT_GTCLR_CCLR4                                                        (0x00000010u)
#define GPT_GTCLR_CCLR4_SHIFT                                                  (4u)
#define GPT_GTCLR_CCLR5                                                        (0x00000020u)
#define GPT_GTCLR_CCLR5_SHIFT                                                  (5u)
#define GPT_GTCLR_CCLR6                                                        (0x00000040u)
#define GPT_GTCLR_CCLR6_SHIFT                                                  (6u)
#define GPT_GTCLR_CCLR7                                                        (0x00000080u)
#define GPT_GTCLR_CCLR7_SHIFT                                                  (7u)
#define GPT_GTSSR_SSGTRGAR                                                     (0x00000001u)
#define GPT_GTSSR_SSGTRGAR_SHIFT                                               (0u)
#define GPT_GTSSR_SSGTRGAF                                                     (0x00000002u)
#define GPT_GTSSR_SSGTRGAF_SHIFT                                               (1u)
#define GPT_GTSSR_SSGTRGBR                                                     (0x00000004u)
#define GPT_GTSSR_SSGTRGBR_SHIFT                                               (2u)
#define GPT_GTSSR_SSGTRGBF                                                     (0x00000008u)
#define GPT_GTSSR_SSGTRGBF_SHIFT                                               (3u)
#define GPT_GTSSR_SSGTRGCR                                                     (0x00000010u)
#define GPT_GTSSR_SSGTRGCR_SHIFT                                               (4u)
#define GPT_GTSSR_SSGTRGCF                                                     (0x00000020u)
#define GPT_GTSSR_SSGTRGCF_SHIFT                                               (5u)
#define GPT_GTSSR_SSGTRGDR                                                     (0x00000040u)
#define GPT_GTSSR_SSGTRGDR_SHIFT                                               (6u)
#define GPT_GTSSR_SSGTRGDF                                                     (0x00000080u)
#define GPT_GTSSR_SSGTRGDF_SHIFT                                               (7u)
#define GPT_GTSSR_SSCARBL                                                      (0x00000100u)
#define GPT_GTSSR_SSCARBL_SHIFT                                                (8u)
#define GPT_GTSSR_SSCARBH                                                      (0x00000200u)
#define GPT_GTSSR_SSCARBH_SHIFT                                                (9u)
#define GPT_GTSSR_SSCAFBL                                                      (0x00000400u)
#define GPT_GTSSR_SSCAFBL_SHIFT                                                (10u)
#define GPT_GTSSR_SSCAFBH                                                      (0x00000800u)
#define GPT_GTSSR_SSCAFBH_SHIFT                                                (11u)
#define GPT_GTSSR_SSCBRAL                                                      (0x00001000u)
#define GPT_GTSSR_SSCBRAL_SHIFT                                                (12u)
#define GPT_GTSSR_SSCBRAH                                                      (0x00002000u)
#define GPT_GTSSR_SSCBRAH_SHIFT                                                (13u)
#define GPT_GTSSR_SSCBFAL                                                      (0x00004000u)
#define GPT_GTSSR_SSCBFAL_SHIFT                                                (14u)
#define GPT_GTSSR_SSCBFAH                                                      (0x00008000u)
#define GPT_GTSSR_SSCBFAH_SHIFT                                                (15u)
#define GPT_GTSSR_SSEVTA                                                       (0x00010000u)
#define GPT_GTSSR_SSEVTA_SHIFT                                                 (16u)
#define GPT_GTSSR_SSEVTB                                                       (0x00020000u)
#define GPT_GTSSR_SSEVTB_SHIFT                                                 (17u)
#define GPT_GTSSR_SSEVTC                                                       (0x00040000u)
#define GPT_GTSSR_SSEVTC_SHIFT                                                 (18u)
#define GPT_GTSSR_SSEVTD                                                       (0x00080000u)
#define GPT_GTSSR_SSEVTD_SHIFT                                                 (19u)
#define GPT_GTSSR_SSEVTE                                                       (0x00100000u)
#define GPT_GTSSR_SSEVTE_SHIFT                                                 (20u)
#define GPT_GTSSR_SSEVTF                                                       (0x00200000u)
#define GPT_GTSSR_SSEVTF_SHIFT                                                 (21u)
#define GPT_GTSSR_SSEVTG                                                       (0x00400000u)
#define GPT_GTSSR_SSEVTG_SHIFT                                                 (22u)
#define GPT_GTSSR_SSEVTH                                                       (0x00800000u)
#define GPT_GTSSR_SSEVTH_SHIFT                                                 (23u)
#define GPT_GTSSR_CSTRT                                                        (0x80000000u)
#define GPT_GTSSR_CSTRT_SHIFT                                                  (31u)
#define GPT_GTPSR_PSGTRGAR                                                     (0x00000001u)
#define GPT_GTPSR_PSGTRGAR_SHIFT                                               (0u)
#define GPT_GTPSR_PSGTRGAF                                                     (0x00000002u)
#define GPT_GTPSR_PSGTRGAF_SHIFT                                               (1u)
#define GPT_GTPSR_PSGTRGBR                                                     (0x00000004u)
#define GPT_GTPSR_PSGTRGBR_SHIFT                                               (2u)
#define GPT_GTPSR_PSGTRGBF                                                     (0x00000008u)
#define GPT_GTPSR_PSGTRGBF_SHIFT                                               (3u)
#define GPT_GTPSR_PSGTRGCR                                                     (0x00000010u)
#define GPT_GTPSR_PSGTRGCR_SHIFT                                               (4u)
#define GPT_GTPSR_PSGTRGCF                                                     (0x00000020u)
#define GPT_GTPSR_PSGTRGCF_SHIFT                                               (5u)
#define GPT_GTPSR_PSGTRGDR                                                     (0x00000040u)
#define GPT_GTPSR_PSGTRGDR_SHIFT                                               (6u)
#define GPT_GTPSR_PSGTRGDF                                                     (0x00000080u)
#define GPT_GTPSR_PSGTRGDF_SHIFT                                               (7u)
#define GPT_GTPSR_PSCARBL                                                      (0x00000100u)
#define GPT_GTPSR_PSCARBL_SHIFT                                                (8u)
#define GPT_GTPSR_PSCARBH                                                      (0x00000200u)
#define GPT_GTPSR_PSCARBH_SHIFT                                                (9u)
#define GPT_GTPSR_PSCAFBL                                                      (0x00000400u)
#define GPT_GTPSR_PSCAFBL_SHIFT                                                (10u)
#define GPT_GTPSR_PSCAFBH                                                      (0x00000800u)
#define GPT_GTPSR_PSCAFBH_SHIFT                                                (11u)
#define GPT_GTPSR_PSCBRAL                                                      (0x00001000u)
#define GPT_GTPSR_PSCBRAL_SHIFT                                                (12u)
#define GPT_GTPSR_PSCBRAH                                                      (0x00002000u)
#define GPT_GTPSR_PSCBRAH_SHIFT                                                (13u)
#define GPT_GTPSR_PSCBFAL                                                      (0x00004000u)
#define GPT_GTPSR_PSCBFAL_SHIFT                                                (14u)
#define GPT_GTPSR_PSCBFAH                                                      (0x00008000u)
#define GPT_GTPSR_PSCBFAH_SHIFT                                                (15u)
#define GPT_GTPSR_PSEVTA                                                       (0x00010000u)
#define GPT_GTPSR_PSEVTA_SHIFT                                                 (16u)
#define GPT_GTPSR_PSEVTB                                                       (0x00020000u)
#define GPT_GTPSR_PSEVTB_SHIFT                                                 (17u)
#define GPT_GTPSR_PSEVTC                                                       (0x00040000u)
#define GPT_GTPSR_PSEVTC_SHIFT                                                 (18u)
#define GPT_GTPSR_PSEVTD                                                       (0x00080000u)
#define GPT_GTPSR_PSEVTD_SHIFT                                                 (19u)
#define GPT_GTPSR_PSEVTE                                                       (0x00100000u)
#define GPT_GTPSR_PSEVTE_SHIFT                                                 (20u)
#define GPT_GTPSR_PSEVTF                                                       (0x00200000u)
#define GPT_GTPSR_PSEVTF_SHIFT                                                 (21u)
#define GPT_GTPSR_PSEVTG                                                       (0x00400000u)
#define GPT_GTPSR_PSEVTG_SHIFT                                                 (22u)
#define GPT_GTPSR_PSEVTH                                                       (0x00800000u)
#define GPT_GTPSR_PSEVTH_SHIFT                                                 (23u)
#define GPT_GTPSR_CSTOP                                                        (0x80000000u)
#define GPT_GTPSR_CSTOP_SHIFT                                                  (31u)
#define GPT_GTCSR_CSGTRGAR                                                     (0x00000001u)
#define GPT_GTCSR_CSGTRGAR_SHIFT                                               (0u)
#define GPT_GTCSR_CSGTRGAF                                                     (0x00000002u)
#define GPT_GTCSR_CSGTRGAF_SHIFT                                               (1u)
#define GPT_GTCSR_CSGTRGBR                                                     (0x00000004u)
#define GPT_GTCSR_CSGTRGBR_SHIFT                                               (2u)
#define GPT_GTCSR_CSGTRGBF                                                     (0x00000008u)
#define GPT_GTCSR_CSGTRGBF_SHIFT                                               (3u)
#define GPT_GTCSR_CSGTRGCR                                                     (0x00000010u)
#define GPT_GTCSR_CSGTRGCR_SHIFT                                               (4u)
#define GPT_GTCSR_CSGTRGCF                                                     (0x00000020u)
#define GPT_GTCSR_CSGTRGCF_SHIFT                                               (5u)
#define GPT_GTCSR_CSGTRGDR                                                     (0x00000040u)
#define GPT_GTCSR_CSGTRGDR_SHIFT                                               (6u)
#define GPT_GTCSR_CSGTRGDF                                                     (0x00000080u)
#define GPT_GTCSR_CSGTRGDF_SHIFT                                               (7u)
#define GPT_GTCSR_CSCARBL                                                      (0x00000100u)
#define GPT_GTCSR_CSCARBL_SHIFT                                                (8u)
#define GPT_GTCSR_CSCARBH                                                      (0x00000200u)
#define GPT_GTCSR_CSCARBH_SHIFT                                                (9u)
#define GPT_GTCSR_CSCAFBL                                                      (0x00000400u)
#define GPT_GTCSR_CSCAFBL_SHIFT                                                (10u)
#define GPT_GTCSR_CSCAFBH                                                      (0x00000800u)
#define GPT_GTCSR_CSCAFBH_SHIFT                                                (11u)
#define GPT_GTCSR_CSCBRAL                                                      (0x00001000u)
#define GPT_GTCSR_CSCBRAL_SHIFT                                                (12u)
#define GPT_GTCSR_CSCBRAH                                                      (0x00002000u)
#define GPT_GTCSR_CSCBRAH_SHIFT                                                (13u)
#define GPT_GTCSR_CSCBFAL                                                      (0x00004000u)
#define GPT_GTCSR_CSCBFAL_SHIFT                                                (14u)
#define GPT_GTCSR_CSCBFAH                                                      (0x00008000u)
#define GPT_GTCSR_CSCBFAH_SHIFT                                                (15u)
#define GPT_GTCSR_CSEVTA                                                       (0x00010000u)
#define GPT_GTCSR_CSEVTA_SHIFT                                                 (16u)
#define GPT_GTCSR_CSEVTB                                                       (0x00020000u)
#define GPT_GTCSR_CSEVTB_SHIFT                                                 (17u)
#define GPT_GTCSR_CSEVTC                                                       (0x00040000u)
#define GPT_GTCSR_CSEVTC_SHIFT                                                 (18u)
#define GPT_GTCSR_CSEVTD                                                       (0x00080000u)
#define GPT_GTCSR_CSEVTD_SHIFT                                                 (19u)
#define GPT_GTCSR_CSEVTE                                                       (0x00100000u)
#define GPT_GTCSR_CSEVTE_SHIFT                                                 (20u)
#define GPT_GTCSR_CSEVTF                                                       (0x00200000u)
#define GPT_GTCSR_CSEVTF_SHIFT                                                 (21u)
#define GPT_GTCSR_CSEVTG                                                       (0x00400000u)
#define GPT_GTCSR_CSEVTG_SHIFT                                                 (22u)
#define GPT_GTCSR_CSEVTH                                                       (0x00800000u)
#define GPT_GTCSR_CSEVTH_SHIFT                                                 (23u)
#define GPT_GTCSR_CCLR                                                         (0x80000000u)
#define GPT_GTCSR_CCLR_SHIFT                                                   (31u)
#define GPT_GTUPSR_USGTRGAR                                                    (0x00000001u)
#define GPT_GTUPSR_USGTRGAR_SHIFT                                              (0u)
#define GPT_GTUPSR_USGTRGAF                                                    (0x00000002u)
#define GPT_GTUPSR_USGTRGAF_SHIFT                                              (1u)
#define GPT_GTUPSR_USGTRGBR                                                    (0x00000004u)
#define GPT_GTUPSR_USGTRGBR_SHIFT                                              (2u)
#define GPT_GTUPSR_USGTRGBF                                                    (0x00000008u)
#define GPT_GTUPSR_USGTRGBF_SHIFT                                              (3u)
#define GPT_GTUPSR_USGTRGCR                                                    (0x00000010u)
#define GPT_GTUPSR_USGTRGCR_SHIFT                                              (4u)
#define GPT_GTUPSR_USGTRGCF                                                    (0x00000020u)
#define GPT_GTUPSR_USGTRGCF_SHIFT                                              (5u)
#define GPT_GTUPSR_USGTRGDR                                                    (0x00000040u)
#define GPT_GTUPSR_USGTRGDR_SHIFT                                              (6u)
#define GPT_GTUPSR_USGTRGDF                                                    (0x00000080u)
#define GPT_GTUPSR_USGTRGDF_SHIFT                                              (7u)
#define GPT_GTUPSR_USCARBL                                                     (0x00000100u)
#define GPT_GTUPSR_USCARBL_SHIFT                                               (8u)
#define GPT_GTUPSR_USCARBH                                                     (0x00000200u)
#define GPT_GTUPSR_USCARBH_SHIFT                                               (9u)
#define GPT_GTUPSR_USCAFBL                                                     (0x00000400u)
#define GPT_GTUPSR_USCAFBL_SHIFT                                               (10u)
#define GPT_GTUPSR_USCAFBH                                                     (0x00000800u)
#define GPT_GTUPSR_USCAFBH_SHIFT                                               (11u)
#define GPT_GTUPSR_USCBRAL                                                     (0x00001000u)
#define GPT_GTUPSR_USCBRAL_SHIFT                                               (12u)
#define GPT_GTUPSR_USCBRAH                                                     (0x00002000u)
#define GPT_GTUPSR_USCBRAH_SHIFT                                               (13u)
#define GPT_GTUPSR_USCBFAL                                                     (0x00004000u)
#define GPT_GTUPSR_USCBFAL_SHIFT                                               (14u)
#define GPT_GTUPSR_USCBFAH                                                     (0x00008000u)
#define GPT_GTUPSR_USCBFAH_SHIFT                                               (15u)
#define GPT_GTUPSR_USEVTA                                                      (0x00010000u)
#define GPT_GTUPSR_USEVTA_SHIFT                                                (16u)
#define GPT_GTUPSR_USEVTB                                                      (0x00020000u)
#define GPT_GTUPSR_USEVTB_SHIFT                                                (17u)
#define GPT_GTUPSR_USEVTC                                                      (0x00040000u)
#define GPT_GTUPSR_USEVTC_SHIFT                                                (18u)
#define GPT_GTUPSR_USEVTD                                                      (0x00080000u)
#define GPT_GTUPSR_USEVTD_SHIFT                                                (19u)
#define GPT_GTUPSR_USEVTE                                                      (0x00100000u)
#define GPT_GTUPSR_USEVTE_SHIFT                                                (20u)
#define GPT_GTUPSR_USEVTF                                                      (0x00200000u)
#define GPT_GTUPSR_USEVTF_SHIFT                                                (21u)
#define GPT_GTUPSR_USEVTG                                                      (0x00400000u)
#define GPT_GTUPSR_USEVTG_SHIFT                                                (22u)
#define GPT_GTUPSR_USEVTH                                                      (0x00800000u)
#define GPT_GTUPSR_USEVTH_SHIFT                                                (23u)
#define GPT_GTDNSR_DSGTRGAR                                                    (0x00000001u)
#define GPT_GTDNSR_DSGTRGAR_SHIFT                                              (0u)
#define GPT_GTDNSR_DSGTRGAF                                                    (0x00000002u)
#define GPT_GTDNSR_DSGTRGAF_SHIFT                                              (1u)
#define GPT_GTDNSR_DSGTRGBR                                                    (0x00000004u)
#define GPT_GTDNSR_DSGTRGBR_SHIFT                                              (2u)
#define GPT_GTDNSR_DSGTRGBF                                                    (0x00000008u)
#define GPT_GTDNSR_DSGTRGBF_SHIFT                                              (3u)
#define GPT_GTDNSR_DSGTRGCR                                                    (0x00000010u)
#define GPT_GTDNSR_DSGTRGCR_SHIFT                                              (4u)
#define GPT_GTDNSR_DSGTRGCF                                                    (0x00000020u)
#define GPT_GTDNSR_DSGTRGCF_SHIFT                                              (5u)
#define GPT_GTDNSR_DSGTRGDR                                                    (0x00000040u)
#define GPT_GTDNSR_DSGTRGDR_SHIFT                                              (6u)
#define GPT_GTDNSR_DSGTRGDF                                                    (0x00000080u)
#define GPT_GTDNSR_DSGTRGDF_SHIFT                                              (7u)
#define GPT_GTDNSR_DSCARBL                                                     (0x00000100u)
#define GPT_GTDNSR_DSCARBL_SHIFT                                               (8u)
#define GPT_GTDNSR_DSCARBH                                                     (0x00000200u)
#define GPT_GTDNSR_DSCARBH_SHIFT                                               (9u)
#define GPT_GTDNSR_DSCAFBL                                                     (0x00000400u)
#define GPT_GTDNSR_DSCAFBL_SHIFT                                               (10u)
#define GPT_GTDNSR_DSCAFBH                                                     (0x00000800u)
#define GPT_GTDNSR_DSCAFBH_SHIFT                                               (11u)
#define GPT_GTDNSR_DSCBRAL                                                     (0x00001000u)
#define GPT_GTDNSR_DSCBRAL_SHIFT                                               (12u)
#define GPT_GTDNSR_DSCBRAH                                                     (0x00002000u)
#define GPT_GTDNSR_DSCBRAH_SHIFT                                               (13u)
#define GPT_GTDNSR_DSCBFAL                                                     (0x00004000u)
#define GPT_GTDNSR_DSCBFAL_SHIFT                                               (14u)
#define GPT_GTDNSR_DSCBFAH                                                     (0x00008000u)
#define GPT_GTDNSR_DSCBFAH_SHIFT                                               (15u)
#define GPT_GTDNSR_DSEVTA                                                      (0x00010000u)
#define GPT_GTDNSR_DSEVTA_SHIFT                                                (16u)
#define GPT_GTDNSR_DSEVTB                                                      (0x00020000u)
#define GPT_GTDNSR_DSEVTB_SHIFT                                                (17u)
#define GPT_GTDNSR_DSEVTC                                                      (0x00040000u)
#define GPT_GTDNSR_DSEVTC_SHIFT                                                (18u)
#define GPT_GTDNSR_DSEVTD                                                      (0x00080000u)
#define GPT_GTDNSR_DSEVTD_SHIFT                                                (19u)
#define GPT_GTDNSR_DSEVTE                                                      (0x00100000u)
#define GPT_GTDNSR_DSEVTE_SHIFT                                                (20u)
#define GPT_GTDNSR_DSEVTF                                                      (0x00200000u)
#define GPT_GTDNSR_DSEVTF_SHIFT                                                (21u)
#define GPT_GTDNSR_DSEVTG                                                      (0x00400000u)
#define GPT_GTDNSR_DSEVTG_SHIFT                                                (22u)
#define GPT_GTDNSR_DSEVTH                                                      (0x00800000u)
#define GPT_GTDNSR_DSEVTH_SHIFT                                                (23u)
#define GPT_GTICASR_ASGTRGAR                                                   (0x00000001u)
#define GPT_GTICASR_ASGTRGAR_SHIFT                                             (0u)
#define GPT_GTICASR_ASGTRGAF                                                   (0x00000002u)
#define GPT_GTICASR_ASGTRGAF_SHIFT                                             (1u)
#define GPT_GTICASR_ASGTRGBR                                                   (0x00000004u)
#define GPT_GTICASR_ASGTRGBR_SHIFT                                             (2u)
#define GPT_GTICASR_ASGTRGBF                                                   (0x00000008u)
#define GPT_GTICASR_ASGTRGBF_SHIFT                                             (3u)
#define GPT_GTICASR_ASGTRGCR                                                   (0x00000010u)
#define GPT_GTICASR_ASGTRGCR_SHIFT                                             (4u)
#define GPT_GTICASR_ASGTRGCF                                                   (0x00000020u)
#define GPT_GTICASR_ASGTRGCF_SHIFT                                             (5u)
#define GPT_GTICASR_ASGTRGDR                                                   (0x00000040u)
#define GPT_GTICASR_ASGTRGDR_SHIFT                                             (6u)
#define GPT_GTICASR_ASGTRGDF                                                   (0x00000080u)
#define GPT_GTICASR_ASGTRGDF_SHIFT                                             (7u)
#define GPT_GTICASR_ASCARBL                                                    (0x00000100u)
#define GPT_GTICASR_ASCARBL_SHIFT                                              (8u)
#define GPT_GTICASR_ASCARBH                                                    (0x00000200u)
#define GPT_GTICASR_ASCARBH_SHIFT                                              (9u)
#define GPT_GTICASR_ASCAFBL                                                    (0x00000400u)
#define GPT_GTICASR_ASCAFBL_SHIFT                                              (10u)
#define GPT_GTICASR_ASCAFBH                                                    (0x00000800u)
#define GPT_GTICASR_ASCAFBH_SHIFT                                              (11u)
#define GPT_GTICASR_ASCBRAL                                                    (0x00001000u)
#define GPT_GTICASR_ASCBRAL_SHIFT                                              (12u)
#define GPT_GTICASR_ASCBRAH                                                    (0x00002000u)
#define GPT_GTICASR_ASCBRAH_SHIFT                                              (13u)
#define GPT_GTICASR_ASCBFAL                                                    (0x00004000u)
#define GPT_GTICASR_ASCBFAL_SHIFT                                              (14u)
#define GPT_GTICASR_ASCBFAH                                                    (0x00008000u)
#define GPT_GTICASR_ASCBFAH_SHIFT                                              (15u)
#define GPT_GTICASR_ASEVTA                                                     (0x00010000u)
#define GPT_GTICASR_ASEVTA_SHIFT                                               (16u)
#define GPT_GTICASR_ASEVTB                                                     (0x00020000u)
#define GPT_GTICASR_ASEVTB_SHIFT                                               (17u)
#define GPT_GTICASR_ASEVTC                                                     (0x00040000u)
#define GPT_GTICASR_ASEVTC_SHIFT                                               (18u)
#define GPT_GTICASR_ASEVTD                                                     (0x00080000u)
#define GPT_GTICASR_ASEVTD_SHIFT                                               (19u)
#define GPT_GTICASR_ASEVTE                                                     (0x00100000u)
#define GPT_GTICASR_ASEVTE_SHIFT                                               (20u)
#define GPT_GTICASR_ASEVTF                                                     (0x00200000u)
#define GPT_GTICASR_ASEVTF_SHIFT                                               (21u)
#define GPT_GTICASR_ASEVTG                                                     (0x00400000u)
#define GPT_GTICASR_ASEVTG_SHIFT                                               (22u)
#define GPT_GTICASR_ASEVTH                                                     (0x00800000u)
#define GPT_GTICASR_ASEVTH_SHIFT                                               (23u)
#define GPT_GTICBSR_BSGTRGAR                                                   (0x00000001u)
#define GPT_GTICBSR_BSGTRGAR_SHIFT                                             (0u)
#define GPT_GTICBSR_BSGTRGAF                                                   (0x00000002u)
#define GPT_GTICBSR_BSGTRGAF_SHIFT                                             (1u)
#define GPT_GTICBSR_BSGTRGBR                                                   (0x00000004u)
#define GPT_GTICBSR_BSGTRGBR_SHIFT                                             (2u)
#define GPT_GTICBSR_BSGTRGBF                                                   (0x00000008u)
#define GPT_GTICBSR_BSGTRGBF_SHIFT                                             (3u)
#define GPT_GTICBSR_BSGTRGCR                                                   (0x00000010u)
#define GPT_GTICBSR_BSGTRGCR_SHIFT                                             (4u)
#define GPT_GTICBSR_BSGTRGCF                                                   (0x00000020u)
#define GPT_GTICBSR_BSGTRGCF_SHIFT                                             (5u)
#define GPT_GTICBSR_BSGTRGDR                                                   (0x00000040u)
#define GPT_GTICBSR_BSGTRGDR_SHIFT                                             (6u)
#define GPT_GTICBSR_BSGTRGDF                                                   (0x00000080u)
#define GPT_GTICBSR_BSGTRGDF_SHIFT                                             (7u)
#define GPT_GTICBSR_BSCARBL                                                    (0x00000100u)
#define GPT_GTICBSR_BSCARBL_SHIFT                                              (8u)
#define GPT_GTICBSR_BSCARBH                                                    (0x00000200u)
#define GPT_GTICBSR_BSCARBH_SHIFT                                              (9u)
#define GPT_GTICBSR_BSCAFBL                                                    (0x00000400u)
#define GPT_GTICBSR_BSCAFBL_SHIFT                                              (10u)
#define GPT_GTICBSR_BSCAFBH                                                    (0x00000800u)
#define GPT_GTICBSR_BSCAFBH_SHIFT                                              (11u)
#define GPT_GTICBSR_BSCBRAL                                                    (0x00001000u)
#define GPT_GTICBSR_BSCBRAL_SHIFT                                              (12u)
#define GPT_GTICBSR_BSCBRAH                                                    (0x00002000u)
#define GPT_GTICBSR_BSCBRAH_SHIFT                                              (13u)
#define GPT_GTICBSR_BSCBFAL                                                    (0x00004000u)
#define GPT_GTICBSR_BSCBFAL_SHIFT                                              (14u)
#define GPT_GTICBSR_BSCBFAH                                                    (0x00008000u)
#define GPT_GTICBSR_BSCBFAH_SHIFT                                              (15u)
#define GPT_GTICBSR_BSEVTA                                                     (0x00010000u)
#define GPT_GTICBSR_BSEVTA_SHIFT                                               (16u)
#define GPT_GTICBSR_BSEVTB                                                     (0x00020000u)
#define GPT_GTICBSR_BSEVTB_SHIFT                                               (17u)
#define GPT_GTICBSR_BSEVTC                                                     (0x00040000u)
#define GPT_GTICBSR_BSEVTC_SHIFT                                               (18u)
#define GPT_GTICBSR_BSEVTD                                                     (0x00080000u)
#define GPT_GTICBSR_BSEVTD_SHIFT                                               (19u)
#define GPT_GTICBSR_BSEVTE                                                     (0x00100000u)
#define GPT_GTICBSR_BSEVTE_SHIFT                                               (20u)
#define GPT_GTICBSR_BSEVTF                                                     (0x00200000u)
#define GPT_GTICBSR_BSEVTF_SHIFT                                               (21u)
#define GPT_GTICBSR_BSEVTG                                                     (0x00400000u)
#define GPT_GTICBSR_BSEVTG_SHIFT                                               (22u)
#define GPT_GTICBSR_BSEVTH                                                     (0x00800000u)
#define GPT_GTICBSR_BSEVTH_SHIFT                                               (23u)
#define GPT_GTCR_CST                                                           (0x00000001u)
#define GPT_GTCR_CST_SHIFT                                                     (0u)
#define GPT_GTCR_MD                                                            (0x00070000u)
#define GPT_GTCR_MD_SHIFT                                                      (16u)
#define GPT_GTCR_TPCS                                                          (0x07000000u)
#define GPT_GTCR_TPCS_SHIFT                                                    (24u)
#define GPT_GTUDDTYC_UD                                                        (0x00000001u)
#define GPT_GTUDDTYC_UD_SHIFT                                                  (0u)
#define GPT_GTUDDTYC_UDF                                                       (0x00000002u)
#define GPT_GTUDDTYC_UDF_SHIFT                                                 (1u)
#define GPT_GTUDDTYC_OADTY                                                     (0x00030000u)
#define GPT_GTUDDTYC_OADTY_SHIFT                                               (16u)
#define GPT_GTUDDTYC_OADTYF                                                    (0x00040000u)
#define GPT_GTUDDTYC_OADTYF_SHIFT                                              (18u)
#define GPT_GTUDDTYC_OADTYR                                                    (0x00080000u)
#define GPT_GTUDDTYC_OADTYR_SHIFT                                              (19u)
#define GPT_GTUDDTYC_OBDTY                                                     (0x03000000u)
#define GPT_GTUDDTYC_OBDTY_SHIFT                                               (24u)
#define GPT_GTUDDTYC_OBDTYF                                                    (0x04000000u)
#define GPT_GTUDDTYC_OBDTYF_SHIFT                                              (26u)
#define GPT_GTUDDTYC_OBDTYR                                                    (0x08000000u)
#define GPT_GTUDDTYC_OBDTYR_SHIFT                                              (27u)
#define GPT_GTIOR_GTIOA                                                        (0x0000001Fu)
#define GPT_GTIOR_GTIOA_SHIFT                                                  (0u)
#define GPT_GTIOR_OADFLT                                                       (0x00000040u)
#define GPT_GTIOR_OADFLT_SHIFT                                                 (6u)
#define GPT_GTIOR_OAHLD                                                        (0x00000080u)
#define GPT_GTIOR_OAHLD_SHIFT                                                  (7u)
#define GPT_GTIOR_OAE                                                          (0x00000100u)
#define GPT_GTIOR_OAE_SHIFT                                                    (8u)
#define GPT_GTIOR_OADF                                                         (0x00000600u)
#define GPT_GTIOR_OADF_SHIFT                                                   (9u)
#define GPT_GTIOR_NFAEN                                                        (0x00002000u)
#define GPT_GTIOR_NFAEN_SHIFT                                                  (13u)
#define GPT_GTIOR_NFCSA                                                        (0x0000C000u)
#define GPT_GTIOR_NFCSA_SHIFT                                                  (14u)
#define GPT_GTIOR_GTIOB                                                        (0x001F0000u)
#define GPT_GTIOR_GTIOB_SHIFT                                                  (16u)
#define GPT_GTIOR_OBDFLT                                                       (0x00400000u)
#define GPT_GTIOR_OBDFLT_SHIFT                                                 (22u)
#define GPT_GTIOR_OBHLD                                                        (0x00800000u)
#define GPT_GTIOR_OBHLD_SHIFT                                                  (23u)
#define GPT_GTIOR_OBE                                                          (0x01000000u)
#define GPT_GTIOR_OBE_SHIFT                                                    (24u)
#define GPT_GTIOR_OBDF                                                         (0x06000000u)
#define GPT_GTIOR_OBDF_SHIFT                                                   (25u)
#define GPT_GTIOR_NFBEN                                                        (0x20000000u)
#define GPT_GTIOR_NFBEN_SHIFT                                                  (29u)
#define GPT_GTIOR_NFCSB                                                        (0xC0000000u)
#define GPT_GTIOR_NFCSB_SHIFT                                                  (30u)
#define GPT_GTINTAD_GTINTA                                                     (0x00000001u)
#define GPT_GTINTAD_GTINTA_SHIFT                                               (0u)
#define GPT_GTINTAD_GTINTB                                                     (0x00000002u)
#define GPT_GTINTAD_GTINTB_SHIFT                                               (1u)
#define GPT_GTINTAD_GTINTC                                                     (0x00000004u)
#define GPT_GTINTAD_GTINTC_SHIFT                                               (2u)
#define GPT_GTINTAD_GTINTD                                                     (0x00000008u)
#define GPT_GTINTAD_GTINTD_SHIFT                                               (3u)
#define GPT_GTINTAD_GTINTE                                                     (0x00000010u)
#define GPT_GTINTAD_GTINTE_SHIFT                                               (4u)
#define GPT_GTINTAD_GTINTF                                                     (0x00000020u)
#define GPT_GTINTAD_GTINTF_SHIFT                                               (5u)
#define GPT_GTINTAD_GTINTPR                                                    (0x000000C0u)
#define GPT_GTINTAD_GTINTPR_SHIFT                                              (6u)
#define GPT_GTINTAD_ADTRAUEN                                                   (0x00010000u)
#define GPT_GTINTAD_ADTRAUEN_SHIFT                                             (16u)
#define GPT_GTINTAD_ADTRADEN                                                   (0x00020000u)
#define GPT_GTINTAD_ADTRADEN_SHIFT                                             (17u)
#define GPT_GTINTAD_ADTRBUEN                                                   (0x00040000u)
#define GPT_GTINTAD_ADTRBUEN_SHIFT                                             (18u)
#define GPT_GTINTAD_ADTRBDEN                                                   (0x00080000u)
#define GPT_GTINTAD_ADTRBDEN_SHIFT                                             (19u)
#define GPT_GTINTAD_GRP                                                        (0x03000000u)
#define GPT_GTINTAD_GRP_SHIFT                                                  (24u)
#define GPT_GTINTAD_GRPDTE                                                     (0x10000000u)
#define GPT_GTINTAD_GRPDTE_SHIFT                                               (28u)
#define GPT_GTINTAD_GRPABH                                                     (0x20000000u)
#define GPT_GTINTAD_GRPABH_SHIFT                                               (29u)
#define GPT_GTINTAD_GRPABL                                                     (0x40000000u)
#define GPT_GTINTAD_GRPABL_SHIFT                                               (30u)
#define GPT_GTST_TCFA                                                          (0x00000001u)
#define GPT_GTST_TCFA_SHIFT                                                    (0u)
#define GPT_GTST_TCFB                                                          (0x00000002u)
#define GPT_GTST_TCFB_SHIFT                                                    (1u)
#define GPT_GTST_TCFC                                                          (0x00000004u)
#define GPT_GTST_TCFC_SHIFT                                                    (2u)
#define GPT_GTST_TCFD                                                          (0x00000008u)
#define GPT_GTST_TCFD_SHIFT                                                    (3u)
#define GPT_GTST_TCFE                                                          (0x00000010u)
#define GPT_GTST_TCFE_SHIFT                                                    (4u)
#define GPT_GTST_TCFF                                                          (0x00000020u)
#define GPT_GTST_TCFF_SHIFT                                                    (5u)
#define GPT_GTST_TCFPO                                                         (0x00000040u)
#define GPT_GTST_TCFPO_SHIFT                                                   (6u)
#define GPT_GTST_TCFPU                                                         (0x00000080u)
#define GPT_GTST_TCFPU_SHIFT                                                   (7u)
#define GPT_GTST_ITCNT                                                         (0x00000700u)
#define GPT_GTST_ITCNT_SHIFT                                                   (8u)
#define GPT_GTST_TUCF                                                          (0x00008000u)
#define GPT_GTST_TUCF_SHIFT                                                    (15u)
#define GPT_GTST_ADTRAUF                                                       (0x00010000u)
#define GPT_GTST_ADTRAUF_SHIFT                                                 (16u)
#define GPT_GTST_ADTRADF                                                       (0x00020000u)
#define GPT_GTST_ADTRADF_SHIFT                                                 (17u)
#define GPT_GTST_ADTRBUF                                                       (0x00040000u)
#define GPT_GTST_ADTRBUF_SHIFT                                                 (18u)
#define GPT_GTST_ADTRBDF                                                       (0x00080000u)
#define GPT_GTST_ADTRBDF_SHIFT                                                 (19u)
#define GPT_GTST_ODF                                                           (0x01000000u)
#define GPT_GTST_ODF_SHIFT                                                     (24u)
#define GPT_GTST_DTEF                                                          (0x10000000u)
#define GPT_GTST_DTEF_SHIFT                                                    (28u)
#define GPT_GTST_OABHF                                                         (0x20000000u)
#define GPT_GTST_OABHF_SHIFT                                                   (29u)
#define GPT_GTST_OABLF                                                         (0x40000000u)
#define GPT_GTST_OABLF_SHIFT                                                   (30u)
#define GPT_GTBER_BD                                                           (0x0000000Fu)
#define GPT_GTBER_BD_SHIFT                                                     (0u)
#define GPT_GTBER_CCRA                                                         (0x00030000u)
#define GPT_GTBER_CCRA_SHIFT                                                   (16u)
#define GPT_GTBER_CCRB                                                         (0x000C0000u)
#define GPT_GTBER_CCRB_SHIFT                                                   (18u)
#define GPT_GTBER_PR                                                           (0x00300000u)
#define GPT_GTBER_PR_SHIFT                                                     (20u)
#define GPT_GTBER_CCRSWT                                                       (0x00400000u)
#define GPT_GTBER_CCRSWT_SHIFT                                                 (22u)
#define GPT_GTBER_ADTTA                                                        (0x03000000u)
#define GPT_GTBER_ADTTA_SHIFT                                                  (24u)
#define GPT_GTBER_ADTDA                                                        (0x04000000u)
#define GPT_GTBER_ADTDA_SHIFT                                                  (26u)
#define GPT_GTBER_ADTTB                                                        (0x30000000u)
#define GPT_GTBER_ADTTB_SHIFT                                                  (28u)
#define GPT_GTBER_ADTDB                                                        (0x40000000u)
#define GPT_GTBER_ADTDB_SHIFT                                                  (30u)
#define GPT_GTITC_ITLA                                                         (0x00000001u)
#define GPT_GTITC_ITLA_SHIFT                                                   (0u)
#define GPT_GTITC_ITLB                                                         (0x00000002u)
#define GPT_GTITC_ITLB_SHIFT                                                   (1u)
#define GPT_GTITC_ITLC                                                         (0x00000004u)
#define GPT_GTITC_ITLC_SHIFT                                                   (2u)
#define GPT_GTITC_ITLD                                                         (0x00000008u)
#define GPT_GTITC_ITLD_SHIFT                                                   (3u)
#define GPT_GTITC_ITLE                                                         (0x00000010u)
#define GPT_GTITC_ITLE_SHIFT                                                   (4u)
#define GPT_GTITC_ITLF                                                         (0x00000020u)
#define GPT_GTITC_ITLF_SHIFT                                                   (5u)
#define GPT_GTITC_IVTC                                                         (0x000000C0u)
#define GPT_GTITC_IVTC_SHIFT                                                   (6u)
#define GPT_GTITC_IVTT                                                         (0x00000700u)
#define GPT_GTITC_IVTT_SHIFT                                                   (8u)
#define GPT_GTITC_ADTAL                                                        (0x00001000u)
#define GPT_GTITC_ADTAL_SHIFT                                                  (12u)
#define GPT_GTITC_ADTBL                                                        (0x00004000u)
#define GPT_GTITC_ADTBL_SHIFT                                                  (14u)
#define GPT_GTCNT_GTCNT                                                        (0xFFFFFFFFu)
#define GPT_GTCNT_GTCNT_SHIFT                                                  (0u)
#define GPT_GTCCRA_GTCCRA                                                      (0xFFFFFFFFu)
#define GPT_GTCCRA_GTCCRA_SHIFT                                                (0u)
#define GPT_GTCCRB_GTCCRB                                                      (0xFFFFFFFFu)
#define GPT_GTCCRB_GTCCRB_SHIFT                                                (0u)
#define GPT_GTCCRC_GTCCRC                                                      (0xFFFFFFFFu)
#define GPT_GTCCRC_GTCCRC_SHIFT                                                (0u)
#define GPT_GTCCRE_GTCCRE                                                      (0xFFFFFFFFu)
#define GPT_GTCCRE_GTCCRE_SHIFT                                                (0u)
#define GPT_GTCCRD_GTCCRD                                                      (0xFFFFFFFFu)
#define GPT_GTCCRD_GTCCRD_SHIFT                                                (0u)
#define GPT_GTCCRF_GTCCRF                                                      (0xFFFFFFFFu)
#define GPT_GTCCRF_GTCCRF_SHIFT                                                (0u)
#define GPT_GTPR_GTPR                                                          (0xFFFFFFFFu)
#define GPT_GTPR_GTPR_SHIFT                                                    (0u)
#define GPT_GTPBR_GTPBR                                                        (0xFFFFFFFFu)
#define GPT_GTPBR_GTPBR_SHIFT                                                  (0u)
#define GPT_GTPDBR_GTPDBR                                                      (0xFFFFFFFFu)
#define GPT_GTPDBR_GTPDBR_SHIFT                                                (0u)
#define GPT_GTADTRA_GTADTRA                                                    (0xFFFFFFFFu)
#define GPT_GTADTRA_GTADTRA_SHIFT                                              (0u)
#define GPT_GTADTBRA_GTADTBRA                                                  (0xFFFFFFFFu)
#define GPT_GTADTBRA_GTADTBRA_SHIFT                                            (0u)
#define GPT_GTADTDBRA_GTADTDBRA                                                (0xFFFFFFFFu)
#define GPT_GTADTDBRA_GTADTDBRA_SHIFT                                          (0u)
#define GPT_GTADTRB_GTADTRB                                                    (0xFFFFFFFFu)
#define GPT_GTADTRB_GTADTRB_SHIFT                                              (0u)
#define GPT_GTADTBRB_GTADTBRB                                                  (0xFFFFFFFFu)
#define GPT_GTADTBRB_GTADTBRB_SHIFT                                            (0u)
#define GPT_GTADTDBRB_GTADTDBRB                                                (0xFFFFFFFFu)
#define GPT_GTADTDBRB_GTADTDBRB_SHIFT                                          (0u)
#define GPT_GTDTCR_TDE                                                         (0x00000001u)
#define GPT_GTDTCR_TDE_SHIFT                                                   (0u)
#define GPT_GTDTCR_TDBUE                                                       (0x00000010u)
#define GPT_GTDTCR_TDBUE_SHIFT                                                 (4u)
#define GPT_GTDTCR_TDBDE                                                       (0x00000020u)
#define GPT_GTDTCR_TDBDE_SHIFT                                                 (5u)
#define GPT_GTDTCR_TDFER                                                       (0x00000100u)
#define GPT_GTDTCR_TDFER_SHIFT                                                 (8u)
#define GPT_GTDVU_GTDVU                                                        (0xFFFFFFFFu)
#define GPT_GTDVU_GTDVU_SHIFT                                                  (0u)
#define GPT_GTDVD_GTDVD                                                        (0xFFFFFFFFu)
#define GPT_GTDVD_GTDVD_SHIFT                                                  (0u)
#define GPT_GTDBU_GTDBU                                                        (0xFFFFFFFFu)
#define GPT_GTDBU_GTDBU_SHIFT                                                  (0u)
#define GPT_GTDBD_GTDBD                                                        (0xFFFFFFFFu)
#define GPT_GTDBD_GTDBD_SHIFT                                                  (0u)
#define GPT_GTSOS_SOS                                                          (0x00000003u)
#define GPT_GTSOS_SOS_SHIFT                                                    (0u)
#define GPT_GTSOTR_SOTR                                                        (0x00000001u)
#define GPT_GTSOTR_SOTR_SHIFT                                                  (0u)

#endif
