/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef INTC_IOBITMASK_H
#define INTC_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define INTC_GICD_CTLR_EnableGrp0                                              (0x00000001u)
#define INTC_GICD_CTLR_EnableGrp0_SHIFT                                        (0u)
#define INTC_GICD_CTLR_EnableGrp1                                              (0x00000002u)
#define INTC_GICD_CTLR_EnableGrp1_SHIFT                                        (1u)
#define INTC_GICD_TYPER_ITLinesNumber                                          (0x0000001Fu)
#define INTC_GICD_TYPER_ITLinesNumber_SHIFT                                    (0u)
#define INTC_GICD_TYPER_CPUNumber                                              (0x000000E0u)
#define INTC_GICD_TYPER_CPUNumber_SHIFT                                        (5u)
#define INTC_GICD_TYPER_SecurityExtn                                           (0x00000400u)
#define INTC_GICD_TYPER_SecurityExtn_SHIFT                                     (10u)
#define INTC_GICD_TYPER_LSPI                                                   (0x0000F800u)
#define INTC_GICD_TYPER_LSPI_SHIFT                                             (11u)
#define INTC_GICD_IIDR_Implementer                                             (0x00000FFFu)
#define INTC_GICD_IIDR_Implementer_SHIFT                                       (0u)
#define INTC_GICD_IIDR_Revision                                                (0x0000F000u)
#define INTC_GICD_IIDR_Revision_SHIFT                                          (12u)
#define INTC_GICD_IIDR_Variant                                                 (0x000F0000u)
#define INTC_GICD_IIDR_Variant_SHIFT                                           (16u)
#define INTC_GICD_IIDR_ProductID                                               (0xFF000000u)
#define INTC_GICD_IIDR_ProductID_SHIFT                                         (24u)
#define INTC_GICD_IGROUPR0_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR0_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR1_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR1_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR2_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR2_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR3_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR3_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR4_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR4_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR5_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR5_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR6_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR6_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR7_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR7_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR8_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR8_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR9_Securitystatusbits                                  (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR9_Securitystatusbits_SHIFT                            (0u)
#define INTC_GICD_IGROUPR10_Securitystatusbits                                 (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR10_Securitystatusbits_SHIFT                           (0u)
#define INTC_GICD_IGROUPR11_Securitystatusbits                                 (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR11_Securitystatusbits_SHIFT                           (0u)
#define INTC_GICD_IGROUPR12_Securitystatusbits                                 (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR12_Securitystatusbits_SHIFT                           (0u)
#define INTC_GICD_IGROUPR13_Securitystatusbits                                 (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR13_Securitystatusbits_SHIFT                           (0u)
#define INTC_GICD_IGROUPR14_Securitystatusbits                                 (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR14_Securitystatusbits_SHIFT                           (0u)
#define INTC_GICD_IGROUPR15_Securitystatusbits                                 (0xFFFFFFFFu)
#define INTC_GICD_IGROUPR15_Securitystatusbits_SHIFT                           (0u)
#define INTC_GICD_ISENABLER0_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER0_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER1_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER1_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER2_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER2_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER3_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER3_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER4_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER4_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER5_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER5_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER6_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER6_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER7_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER7_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER8_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER8_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER9_Set_enablebits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER9_Set_enablebits_SHIFT                              (0u)
#define INTC_GICD_ISENABLER10_Set_enablebits                                   (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER10_Set_enablebits_SHIFT                             (0u)
#define INTC_GICD_ISENABLER11_Set_enablebits                                   (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER11_Set_enablebits_SHIFT                             (0u)
#define INTC_GICD_ISENABLER12_Set_enablebits                                   (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER12_Set_enablebits_SHIFT                             (0u)
#define INTC_GICD_ISENABLER13_Set_enablebits                                   (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER13_Set_enablebits_SHIFT                             (0u)
#define INTC_GICD_ISENABLER14_Set_enablebits                                   (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER14_Set_enablebits_SHIFT                             (0u)
#define INTC_GICD_ISENABLER15_Set_enablebits                                   (0xFFFFFFFFu)
#define INTC_GICD_ISENABLER15_Set_enablebits_SHIFT                             (0u)
#define INTC_GICD_ICENABLER0_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER0_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER1_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER1_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER2_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER2_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER3_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER3_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER4_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER4_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER5_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER5_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER6_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER6_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER7_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER7_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER8_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER8_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER9_Clear_enablebits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER9_Clear_enablebits_SHIFT                            (0u)
#define INTC_GICD_ICENABLER10_Clear_enablebits                                 (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER10_Clear_enablebits_SHIFT                           (0u)
#define INTC_GICD_ICENABLER11_Clear_enablebits                                 (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER11_Clear_enablebits_SHIFT                           (0u)
#define INTC_GICD_ICENABLER12_Clear_enablebits                                 (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER12_Clear_enablebits_SHIFT                           (0u)
#define INTC_GICD_ICENABLER13_Clear_enablebits                                 (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER13_Clear_enablebits_SHIFT                           (0u)
#define INTC_GICD_ICENABLER14_Clear_enablebits                                 (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER14_Clear_enablebits_SHIFT                           (0u)
#define INTC_GICD_ICENABLER15_Clear_enablebits                                 (0xFFFFFFFFu)
#define INTC_GICD_ICENABLER15_Clear_enablebits_SHIFT                           (0u)
#define INTC_GICD_ISPENDR0_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR0_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR1_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR1_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR2_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR2_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR3_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR3_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR4_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR4_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR5_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR5_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR6_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR6_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR7_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR7_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR8_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR8_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR9_Set_pendingbits                                     (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR9_Set_pendingbits_SHIFT                               (0u)
#define INTC_GICD_ISPENDR10_Set_pendingbits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR10_Set_pendingbits_SHIFT                              (0u)
#define INTC_GICD_ISPENDR11_Set_pendingbits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR11_Set_pendingbits_SHIFT                              (0u)
#define INTC_GICD_ISPENDR12_Set_pendingbits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR12_Set_pendingbits_SHIFT                              (0u)
#define INTC_GICD_ISPENDR13_Set_pendingbits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR13_Set_pendingbits_SHIFT                              (0u)
#define INTC_GICD_ISPENDR14_Set_pendingbits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR14_Set_pendingbits_SHIFT                              (0u)
#define INTC_GICD_ISPENDR15_Set_pendingbits                                    (0xFFFFFFFFu)
#define INTC_GICD_ISPENDR15_Set_pendingbits_SHIFT                              (0u)
#define INTC_GICD_ICPENDR0_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR0_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR1_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR1_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR2_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR2_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR3_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR3_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR4_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR4_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR5_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR5_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR6_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR6_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR7_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR7_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR8_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR8_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR9_Clear_pendingbits                                   (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR9_Clear_pendingbits_SHIFT                             (0u)
#define INTC_GICD_ICPENDR10_Clear_pendingbits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR10_Clear_pendingbits_SHIFT                            (0u)
#define INTC_GICD_ICPENDR11_Clear_pendingbits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR11_Clear_pendingbits_SHIFT                            (0u)
#define INTC_GICD_ICPENDR12_Clear_pendingbits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR12_Clear_pendingbits_SHIFT                            (0u)
#define INTC_GICD_ICPENDR13_Clear_pendingbits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR13_Clear_pendingbits_SHIFT                            (0u)
#define INTC_GICD_ICPENDR14_Clear_pendingbits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR14_Clear_pendingbits_SHIFT                            (0u)
#define INTC_GICD_ICPENDR15_Clear_pendingbits                                  (0xFFFFFFFFu)
#define INTC_GICD_ICPENDR15_Clear_pendingbits_SHIFT                            (0u)
#define INTC_GICD_ISACTIVER0_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER0_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER1_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER1_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER2_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER2_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER3_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER3_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER4_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER4_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER5_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER5_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER6_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER6_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER7_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER7_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER8_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER8_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER9_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER9_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ISACTIVER10_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER10_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ISACTIVER11_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER11_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ISACTIVER12_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER12_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ISACTIVER13_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER13_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ISACTIVER14_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER14_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ISACTIVER15_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ISACTIVER15_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ICACTIVER0_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER0_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER1_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER1_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER2_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER2_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER3_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER3_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER4_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER4_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER5_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER5_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER6_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER6_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER7_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER7_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER8_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER8_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER9_Activebits                                        (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER9_Activebits_SHIFT                                  (0u)
#define INTC_GICD_ICACTIVER10_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER10_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ICACTIVER11_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER11_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ICACTIVER12_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER12_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ICACTIVER13_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER13_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ICACTIVER14_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER14_Activebits_SHIFT                                 (0u)
#define INTC_GICD_ICACTIVER15_Activebits                                       (0xFFFFFFFFu)
#define INTC_GICD_ICACTIVER15_Activebits_SHIFT                                 (0u)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR0_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR1_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR2_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR3_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR4_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR5_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR6_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR7_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR8_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset0                              (0x000000FFu)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset0_SHIFT                        (0u)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset1                              (0x0000FF00u)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset1_SHIFT                        (8u)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset2                              (0x00FF0000u)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset2_SHIFT                        (16u)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset3                              (0xFF000000u)
#define INTC_GICD_IPRIORITYR9_Prioritybyteoffset3_SHIFT                        (24u)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR10_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR11_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR12_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR13_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR14_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR15_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR16_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR17_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR18_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR19_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR20_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR21_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR22_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR23_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR24_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR25_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR26_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR27_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR28_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR29_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR30_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR31_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR32_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR33_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR34_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR35_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR36_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR37_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR38_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR39_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR40_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR41_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR42_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR43_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR44_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR45_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR46_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR47_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR48_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR49_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR50_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR51_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR52_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR53_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR54_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR55_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR56_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR57_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR58_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR59_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR60_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR61_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR62_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR63_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR64_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR65_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR66_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR67_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR68_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR69_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR70_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR71_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR72_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR73_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR74_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR75_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR76_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR77_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR78_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR79_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR80_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR81_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR82_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR83_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR84_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR85_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR86_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR87_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR88_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR89_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR90_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR91_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR92_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR93_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR94_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR95_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR96_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR97_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR98_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset0                             (0x000000FFu)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset0_SHIFT                       (0u)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset1                             (0x0000FF00u)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset1_SHIFT                       (8u)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset2                             (0x00FF0000u)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset2_SHIFT                       (16u)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset3                             (0xFF000000u)
#define INTC_GICD_IPRIORITYR99_Prioritybyteoffset3_SHIFT                       (24u)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR100_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR101_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR102_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR103_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR104_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR105_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR106_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR107_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR108_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR109_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR110_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR111_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR112_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR113_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR114_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR115_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR116_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR117_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR118_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR119_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR120_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR121_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR122_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR123_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR124_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR125_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR126_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset0                            (0x000000FFu)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset0_SHIFT                      (0u)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset1                            (0x0000FF00u)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset1_SHIFT                      (8u)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset2                            (0x00FF0000u)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset2_SHIFT                      (16u)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset3                            (0xFF000000u)
#define INTC_GICD_IPRIORITYR127_Prioritybyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR0_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR1_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR2_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR3_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR4_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR5_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR6_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR7_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR8_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset0                              (0x000000FFu)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset0_SHIFT                        (0u)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset1                              (0x0000FF00u)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset1_SHIFT                        (8u)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset2                              (0x00FF0000u)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset2_SHIFT                        (16u)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset3                              (0xFF000000u)
#define INTC_GICD_ITARGETR9_CPUtargetsbyteoffset3_SHIFT                        (24u)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR10_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR11_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR12_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR13_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR14_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR15_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR16_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR17_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR18_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR19_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR20_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR21_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR22_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR23_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR24_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR25_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR26_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR27_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR28_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR29_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR30_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR31_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR32_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR33_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR34_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR35_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR36_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR37_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR38_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR39_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR40_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR41_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR42_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR43_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR44_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR45_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR46_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR47_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR48_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR49_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR50_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR51_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR52_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR53_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR54_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR55_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR56_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR57_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR58_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR59_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR60_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR61_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR62_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR63_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR64_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR65_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR66_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR67_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR68_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR69_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR70_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR71_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR72_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR73_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR74_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR75_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR76_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR77_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR78_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR79_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR80_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR81_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR82_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR83_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR84_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR85_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR86_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR87_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR88_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR89_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR90_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR91_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR92_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR93_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR94_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR95_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR96_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR97_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR98_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset0                             (0x000000FFu)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset0_SHIFT                       (0u)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset1                             (0x0000FF00u)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset1_SHIFT                       (8u)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset2                             (0x00FF0000u)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset2_SHIFT                       (16u)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset3                             (0xFF000000u)
#define INTC_GICD_ITARGETR99_CPUtargetsbyteoffset3_SHIFT                       (24u)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR100_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR101_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR102_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR103_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR104_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR105_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR106_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR107_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR108_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR109_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR110_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR111_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR112_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR113_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR114_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR115_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR116_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR117_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR118_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR119_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR120_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR121_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR122_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR123_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR124_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR125_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR126_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset0                            (0x000000FFu)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset0_SHIFT                      (0u)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset1                            (0x0000FF00u)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset1_SHIFT                      (8u)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset2                            (0x00FF0000u)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset2_SHIFT                      (16u)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset3                            (0xFF000000u)
#define INTC_GICD_ITARGETR127_CPUtargetsbyteoffset3_SHIFT                      (24u)
#define INTC_GICD_ICFGR0_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR0_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR1_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR1_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR2_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR2_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR3_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR3_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR4_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR4_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR5_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR5_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR6_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR6_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR7_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR7_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR8_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR8_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR9_Int_config                                            (0xFFFFFFFFu)
#define INTC_GICD_ICFGR9_Int_config_SHIFT                                      (0u)
#define INTC_GICD_ICFGR10_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR10_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR11_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR11_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR12_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR12_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR13_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR13_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR14_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR14_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR15_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR15_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR16_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR16_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR17_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR17_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR18_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR18_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR19_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR19_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR20_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR20_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR21_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR21_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR22_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR22_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR23_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR23_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR24_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR24_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR25_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR25_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR26_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR26_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR27_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR27_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR28_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR28_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR29_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR29_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR30_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR30_Int_config_SHIFT                                     (0u)
#define INTC_GICD_ICFGR31_Int_config                                           (0xFFFFFFFFu)
#define INTC_GICD_ICFGR31_Int_config_SHIFT                                     (0u)
#define INTC_GICD_PPISR_ppi_status                                             (0x0000FFFFu)
#define INTC_GICD_PPISR_ppi_status_SHIFT                                       (0u)
#define INTC_GICD_SPISR0_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR0_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR1_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR1_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR2_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR2_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR3_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR3_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR4_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR4_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR5_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR5_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR6_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR6_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR7_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR7_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR8_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR8_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR9_spi_status                                            (0xFFFFFFFFu)
#define INTC_GICD_SPISR9_spi_status_SHIFT                                      (0u)
#define INTC_GICD_SPISR10_spi_status                                           (0xFFFFFFFFu)
#define INTC_GICD_SPISR10_spi_status_SHIFT                                     (0u)
#define INTC_GICD_SPISR11_spi_status                                           (0xFFFFFFFFu)
#define INTC_GICD_SPISR11_spi_status_SHIFT                                     (0u)
#define INTC_GICD_SPISR12_spi_status                                           (0xFFFFFFFFu)
#define INTC_GICD_SPISR12_spi_status_SHIFT                                     (0u)
#define INTC_GICD_SPISR13_spi_status                                           (0xFFFFFFFFu)
#define INTC_GICD_SPISR13_spi_status_SHIFT                                     (0u)
#define INTC_GICD_SPISR14_spi_status                                           (0xFFFFFFFFu)
#define INTC_GICD_SPISR14_spi_status_SHIFT                                     (0u)
#define INTC_GICD_SGIR_SGIINTID                                                (0x0000000Fu)
#define INTC_GICD_SGIR_SGIINTID_SHIFT                                          (0u)
#define INTC_GICD_SGIR_NSATT                                                   (0x00008000u)
#define INTC_GICD_SGIR_NSATT_SHIFT                                             (15u)
#define INTC_GICD_SGIR_CPUTargetList                                           (0x00FF0000u)
#define INTC_GICD_SGIR_CPUTargetList_SHIFT                                     (16u)
#define INTC_GICD_SGIR_TargetListFilter                                        (0x03000000u)
#define INTC_GICD_SGIR_TargetListFilter_SHIFT                                  (24u)
#define INTC_GICD_CPENDSGIR0_SGI0_Clers_pending                                (0x000000FFu)
#define INTC_GICD_CPENDSGIR0_SGI0_Clers_pending_SHIFT                          (0u)
#define INTC_GICD_CPENDSGIR0_SGI1_Clers_pending                                (0x0000FF00u)
#define INTC_GICD_CPENDSGIR0_SGI1_Clers_pending_SHIFT                          (8u)
#define INTC_GICD_CPENDSGIR0_SGI2_Clers_pending                                (0x00FF0000u)
#define INTC_GICD_CPENDSGIR0_SGI2_Clers_pending_SHIFT                          (16u)
#define INTC_GICD_CPENDSGIR0_SGI3_Clers_pending                                (0xFF000000u)
#define INTC_GICD_CPENDSGIR0_SGI3_Clers_pending_SHIFT                          (24u)
#define INTC_GICD_CPENDSGIR1_SGI4_Clers_pending                                (0x000000FFu)
#define INTC_GICD_CPENDSGIR1_SGI4_Clers_pending_SHIFT                          (0u)
#define INTC_GICD_CPENDSGIR1_SGI5_Clers_pending                                (0x0000FF00u)
#define INTC_GICD_CPENDSGIR1_SGI5_Clers_pending_SHIFT                          (8u)
#define INTC_GICD_CPENDSGIR1_SGI6_Clers_pending                                (0x00FF0000u)
#define INTC_GICD_CPENDSGIR1_SGI6_Clers_pending_SHIFT                          (16u)
#define INTC_GICD_CPENDSGIR1_SGI7_Clers_pending                                (0xFF000000u)
#define INTC_GICD_CPENDSGIR1_SGI7_Clers_pending_SHIFT                          (24u)
#define INTC_GICD_CPENDSGIR2_SGI8_Clers_pending                                (0x000000FFu)
#define INTC_GICD_CPENDSGIR2_SGI8_Clers_pending_SHIFT                          (0u)
#define INTC_GICD_CPENDSGIR2_SGI9_Clers_pending                                (0x0000FF00u)
#define INTC_GICD_CPENDSGIR2_SGI9_Clers_pending_SHIFT                          (8u)
#define INTC_GICD_CPENDSGIR2_SGI10_Clers_pending                               (0x00FF0000u)
#define INTC_GICD_CPENDSGIR2_SGI10_Clers_pending_SHIFT                         (16u)
#define INTC_GICD_CPENDSGIR2_SGI11_Clers_pending                               (0xFF000000u)
#define INTC_GICD_CPENDSGIR2_SGI11_Clers_pending_SHIFT                         (24u)
#define INTC_GICD_CPENDSGIR3_SGI12_Clers_pending                               (0x000000FFu)
#define INTC_GICD_CPENDSGIR3_SGI12_Clers_pending_SHIFT                         (0u)
#define INTC_GICD_CPENDSGIR3_SGI13_Clers_pending                               (0x0000FF00u)
#define INTC_GICD_CPENDSGIR3_SGI13_Clers_pending_SHIFT                         (8u)
#define INTC_GICD_CPENDSGIR3_SGI14_Clers_pending                               (0x00FF0000u)
#define INTC_GICD_CPENDSGIR3_SGI14_Clers_pending_SHIFT                         (16u)
#define INTC_GICD_CPENDSGIR3_SGI15_Clers_pending                               (0xFF000000u)
#define INTC_GICD_CPENDSGIR3_SGI15_Clers_pending_SHIFT                         (24u)
#define INTC_GICD_SPENDSGIR0_SGI0_Set_pending                                  (0x000000FFu)
#define INTC_GICD_SPENDSGIR0_SGI0_Set_pending_SHIFT                            (0u)
#define INTC_GICD_SPENDSGIR0_SGI1_Set_pending                                  (0x0000FF00u)
#define INTC_GICD_SPENDSGIR0_SGI1_Set_pending_SHIFT                            (8u)
#define INTC_GICD_SPENDSGIR0_SGI2_Set_pending                                  (0x00FF0000u)
#define INTC_GICD_SPENDSGIR0_SGI2_Set_pending_SHIFT                            (16u)
#define INTC_GICD_SPENDSGIR0_SGI3_Set_pending                                  (0xFF000000u)
#define INTC_GICD_SPENDSGIR0_SGI3_Set_pending_SHIFT                            (24u)
#define INTC_GICD_SPENDSGIR1_SGI4_Set_pending                                  (0x000000FFu)
#define INTC_GICD_SPENDSGIR1_SGI4_Set_pending_SHIFT                            (0u)
#define INTC_GICD_SPENDSGIR1_SGI5_Set_pending                                  (0x0000FF00u)
#define INTC_GICD_SPENDSGIR1_SGI5_Set_pending_SHIFT                            (8u)
#define INTC_GICD_SPENDSGIR1_SGI6_Set_pending                                  (0x00FF0000u)
#define INTC_GICD_SPENDSGIR1_SGI6_Set_pending_SHIFT                            (16u)
#define INTC_GICD_SPENDSGIR1_SGI7_Set_pending                                  (0xFF000000u)
#define INTC_GICD_SPENDSGIR1_SGI7_Set_pending_SHIFT                            (24u)
#define INTC_GICD_SPENDSGIR2_SGI8_Set_pending                                  (0x000000FFu)
#define INTC_GICD_SPENDSGIR2_SGI8_Set_pending_SHIFT                            (0u)
#define INTC_GICD_SPENDSGIR2_SGI9_Set_pending                                  (0x0000FF00u)
#define INTC_GICD_SPENDSGIR2_SGI9_Set_pending_SHIFT                            (8u)
#define INTC_GICD_SPENDSGIR2_SGI10_Set_pending                                 (0x00FF0000u)
#define INTC_GICD_SPENDSGIR2_SGI10_Set_pending_SHIFT                           (16u)
#define INTC_GICD_SPENDSGIR2_SGI11_Set_pending                                 (0xFF000000u)
#define INTC_GICD_SPENDSGIR2_SGI11_Set_pending_SHIFT                           (24u)
#define INTC_GICD_SPENDSGIR3_SGI12_Set_pending                                 (0x000000FFu)
#define INTC_GICD_SPENDSGIR3_SGI12_Set_pending_SHIFT                           (0u)
#define INTC_GICD_SPENDSGIR3_SGI13_Set_pending                                 (0x0000FF00u)
#define INTC_GICD_SPENDSGIR3_SGI13_Set_pending_SHIFT                           (8u)
#define INTC_GICD_SPENDSGIR3_SGI14_Set_pending                                 (0x00FF0000u)
#define INTC_GICD_SPENDSGIR3_SGI14_Set_pending_SHIFT                           (16u)
#define INTC_GICD_SPENDSGIR3_SGI15_Set_pending                                 (0xFF000000u)
#define INTC_GICD_SPENDSGIR3_SGI15_Set_pending_SHIFT                           (24u)
#define INTC_GICD_PIDR4_ARM_CCfield                                            (0x0000000Fu)
#define INTC_GICD_PIDR4_ARM_CCfield_SHIFT                                      (0u)
#define INTC_GICD_PIDR4_ARM_Reserved                                           (0x000000F0u)
#define INTC_GICD_PIDR4_ARM_Reserved_SHIFT                                     (4u)
#define INTC_GICD_PIDR5_ARM_Reserved                                           (0x000000FFu)
#define INTC_GICD_PIDR5_ARM_Reserved_SHIFT                                     (0u)
#define INTC_GICD_PIDR6_ARM_Reserved                                           (0x000000FFu)
#define INTC_GICD_PIDR6_ARM_Reserved_SHIFT                                     (0u)
#define INTC_GICD_PIDR7_ARM_Reserved                                           (0x000000FFu)
#define INTC_GICD_PIDR7_ARM_Reserved_SHIFT                                     (0u)
#define INTC_GICD_PIDR0_ARM_DIDfield                                           (0x000000FFu)
#define INTC_GICD_PIDR0_ARM_DIDfield_SHIFT                                     (0u)
#define INTC_GICD_PIDR1_ARM_DIDfield                                           (0x0000000Fu)
#define INTC_GICD_PIDR1_ARM_DIDfield_SHIFT                                     (0u)
#define INTC_GICD_PIDR1_ARM_AIDfield                                           (0x000000F0u)
#define INTC_GICD_PIDR1_ARM_AIDfield_SHIFT                                     (4u)
#define INTC_GICD_PIDR2_ARM_AIDfield                                           (0x00000007u)
#define INTC_GICD_PIDR2_ARM_AIDfield_SHIFT                                     (0u)
#define INTC_GICD_PIDR2_ARM_UJEPfield                                          (0x00000008u)
#define INTC_GICD_PIDR2_ARM_UJEPfield_SHIFT                                    (3u)
#define INTC_GICD_PIDR2_Arfield                                                (0x000000F0u)
#define INTC_GICD_PIDR2_Arfield_SHIFT                                          (4u)
#define INTC_GICD_PIDR3_ARM_Reserved                                           (0x0000000Fu)
#define INTC_GICD_PIDR3_ARM_Reserved_SHIFT                                     (0u)
#define INTC_GICD_PIDR3_ARM_Rfield                                             (0x000000F0u)
#define INTC_GICD_PIDR3_ARM_Rfield_SHIFT                                       (4u)
#define INTC_GICD_CIDR0_ARM_FVPCD                                              (0x000000FFu)
#define INTC_GICD_CIDR0_ARM_FVPCD_SHIFT                                        (0u)
#define INTC_GICD_CIDR1_ARM_FVPCD                                              (0x000000FFu)
#define INTC_GICD_CIDR1_ARM_FVPCD_SHIFT                                        (0u)
#define INTC_GICD_CIDR2_ARM_FVPCD                                              (0x000000FFu)
#define INTC_GICD_CIDR2_ARM_FVPCD_SHIFT                                        (0u)
#define INTC_GICD_CIDR3_ARM_FVPCD                                              (0x000000FFu)
#define INTC_GICD_CIDR3_ARM_FVPCD_SHIFT                                        (0u)
#define INTC_GICC_CTLR_EnableGrp0                                              (0x00000001u)
#define INTC_GICC_CTLR_EnableGrp0_SHIFT                                        (0u)
#define INTC_GICC_CTLR_EnableGrp1                                              (0x00000002u)
#define INTC_GICC_CTLR_EnableGrp1_SHIFT                                        (1u)
#define INTC_GICC_CTLR_AckCtl                                                  (0x00000004u)
#define INTC_GICC_CTLR_AckCtl_SHIFT                                            (2u)
#define INTC_GICC_CTLR_FIQEn                                                   (0x00000008u)
#define INTC_GICC_CTLR_FIQEn_SHIFT                                             (3u)
#define INTC_GICC_CTLR_CBPR                                                    (0x00000010u)
#define INTC_GICC_CTLR_CBPR_SHIFT                                              (4u)
#define INTC_GICC_CTLR_FIQBypDisGrp0                                           (0x00000020u)
#define INTC_GICC_CTLR_FIQBypDisGrp0_SHIFT                                     (5u)
#define INTC_GICC_CTLR_IRQBypDisGrp0                                           (0x00000040u)
#define INTC_GICC_CTLR_IRQBypDisGrp0_SHIFT                                     (6u)
#define INTC_GICC_CTLR_FIQBypDisGrp1                                           (0x00000080u)
#define INTC_GICC_CTLR_FIQBypDisGrp1_SHIFT                                     (7u)
#define INTC_GICC_CTLR_IRQBypDisGrp1                                           (0x00000100u)
#define INTC_GICC_CTLR_IRQBypDisGrp1_SHIFT                                     (8u)
#define INTC_GICC_CTLR_EOImodeS                                                (0x00000200u)
#define INTC_GICC_CTLR_EOImodeS_SHIFT                                          (9u)
#define INTC_GICC_CTLR_EOImodeNS                                               (0x00000400u)
#define INTC_GICC_CTLR_EOImodeNS_SHIFT                                         (10u)
#define INTC_GICC_PMR_Priority                                                 (0x000000FFu)
#define INTC_GICC_PMR_Priority_SHIFT                                           (0u)
#define INTC_GICC_BPR_Binarypoint                                              (0x00000007u)
#define INTC_GICC_BPR_Binarypoint_SHIFT                                        (0u)
#define INTC_GICC_IAR_InterruptID                                              (0x000003FFu)
#define INTC_GICC_IAR_InterruptID_SHIFT                                        (0u)
#define INTC_GICC_IAR_CPUID                                                    (0x00001C00u)
#define INTC_GICC_IAR_CPUID_SHIFT                                              (10u)
#define INTC_GICC_EOIR_EOIINTID                                                (0x000003FFu)
#define INTC_GICC_EOIR_EOIINTID_SHIFT                                          (0u)
#define INTC_GICC_EOIR_CPUID                                                   (0x00001C00u)
#define INTC_GICC_EOIR_CPUID_SHIFT                                             (10u)
#define INTC_GICC_RPR_Priority                                                 (0x000000FFu)
#define INTC_GICC_RPR_Priority_SHIFT                                           (0u)
#define INTC_GICC_HPPIR_PENDINTID                                              (0x000003FFu)
#define INTC_GICC_HPPIR_PENDINTID_SHIFT                                        (0u)
#define INTC_GICC_HPPIR_CPUID                                                  (0x00001C00u)
#define INTC_GICC_HPPIR_CPUID_SHIFT                                            (10u)
#define INTC_GICC_ABPR_Binarypoint                                             (0x00000007u)
#define INTC_GICC_ABPR_Binarypoint_SHIFT                                       (0u)
#define INTC_GICC_AIAR_InterruptID                                             (0x000003FFu)
#define INTC_GICC_AIAR_InterruptID_SHIFT                                       (0u)
#define INTC_GICC_AIAR_CPUID                                                   (0x00001C00u)
#define INTC_GICC_AIAR_CPUID_SHIFT                                             (10u)
#define INTC_GICC_AEOIR_InterruptID                                            (0x000003FFu)
#define INTC_GICC_AEOIR_InterruptID_SHIFT                                      (0u)
#define INTC_GICC_AEOIR_CPUID                                                  (0x00001C00u)
#define INTC_GICC_AEOIR_CPUID_SHIFT                                            (10u)
#define INTC_GICC_AHPPIR_PENDINTID                                             (0x000003FFu)
#define INTC_GICC_AHPPIR_PENDINTID_SHIFT                                       (0u)
#define INTC_GICC_AHPPIR_CPUID                                                 (0x00001C00u)
#define INTC_GICC_AHPPIR_CPUID_SHIFT                                           (10u)
#define INTC_GICC_APR0_AP_Group0                                               (0xFFFFFFFFu)
#define INTC_GICC_APR0_AP_Group0_SHIFT                                         (0u)
#define INTC_GICC_NSAPR0_AP_Group1                                             (0x0000FFFFu)
#define INTC_GICC_NSAPR0_AP_Group1_SHIFT                                       (0u)
#define INTC_GICC_NSAPR0_AP_Group0                                             (0xFFFF0000u)
#define INTC_GICC_NSAPR0_AP_Group0_SHIFT                                       (16u)
#define INTC_GICC_IIDR_Implementer                                             (0x00000FFFu)
#define INTC_GICC_IIDR_Implementer_SHIFT                                       (0u)
#define INTC_GICC_IIDR_Revision                                                (0x0000F000u)
#define INTC_GICC_IIDR_Revision_SHIFT                                          (12u)
#define INTC_GICC_IIDR_Architectureversion                                     (0x000F0000u)
#define INTC_GICC_IIDR_Architectureversion_SHIFT                               (16u)
#define INTC_GICC_IIDR_ProductID                                               (0xFFF00000u)
#define INTC_GICC_IIDR_ProductID_SHIFT                                         (20u)
#define INTC_GICC_DIR_InterruptID                                              (0x000003FFu)
#define INTC_GICC_DIR_InterruptID_SHIFT                                        (0u)
#define INTC_GICC_DIR_CPUID                                                    (0x00001C00u)
#define INTC_GICC_DIR_CPUID_SHIFT                                              (10u)
#define INTC_ICR0_NMIF                                                         (0x0002u)
#define INTC_ICR0_NMIF_SHIFT                                                   (1u)
#define INTC_ICR0_NMIE                                                         (0x0100u)
#define INTC_ICR0_NMIE_SHIFT                                                   (8u)
#define INTC_ICR0_NMIL                                                         (0x8000u)
#define INTC_ICR0_NMIL_SHIFT                                                   (15u)
#define INTC_ICR1_IRQ00S                                                       (0x0001u)
#define INTC_ICR1_IRQ00S_SHIFT                                                 (0u)
#define INTC_ICR1_IRQ01S                                                       (0x0002u)
#define INTC_ICR1_IRQ01S_SHIFT                                                 (1u)
#define INTC_ICR1_IRQ10S                                                       (0x0004u)
#define INTC_ICR1_IRQ10S_SHIFT                                                 (2u)
#define INTC_ICR1_IRQ11S                                                       (0x0008u)
#define INTC_ICR1_IRQ11S_SHIFT                                                 (3u)
#define INTC_ICR1_IRQ20S                                                       (0x0010u)
#define INTC_ICR1_IRQ20S_SHIFT                                                 (4u)
#define INTC_ICR1_IRQ21S                                                       (0x0020u)
#define INTC_ICR1_IRQ21S_SHIFT                                                 (5u)
#define INTC_ICR1_IRQ30S                                                       (0x0040u)
#define INTC_ICR1_IRQ30S_SHIFT                                                 (6u)
#define INTC_ICR1_IRQ31S                                                       (0x0080u)
#define INTC_ICR1_IRQ31S_SHIFT                                                 (7u)
#define INTC_ICR1_IRQ40S                                                       (0x0100u)
#define INTC_ICR1_IRQ40S_SHIFT                                                 (8u)
#define INTC_ICR1_IRQ41S                                                       (0x0200u)
#define INTC_ICR1_IRQ41S_SHIFT                                                 (9u)
#define INTC_ICR1_IRQ50S                                                       (0x0400u)
#define INTC_ICR1_IRQ50S_SHIFT                                                 (10u)
#define INTC_ICR1_IRQ51S                                                       (0x0800u)
#define INTC_ICR1_IRQ51S_SHIFT                                                 (11u)
#define INTC_ICR1_IRQ60S                                                       (0x1000u)
#define INTC_ICR1_IRQ60S_SHIFT                                                 (12u)
#define INTC_ICR1_IRQ61S                                                       (0x2000u)
#define INTC_ICR1_IRQ61S_SHIFT                                                 (13u)
#define INTC_ICR1_IRQ70S                                                       (0x4000u)
#define INTC_ICR1_IRQ70S_SHIFT                                                 (14u)
#define INTC_ICR1_IRQ71S                                                       (0x8000u)
#define INTC_ICR1_IRQ71S_SHIFT                                                 (15u)
#define INTC_IRQRR_IRQ0F                                                       (0x0001u)
#define INTC_IRQRR_IRQ0F_SHIFT                                                 (0u)
#define INTC_IRQRR_IRQ1F                                                       (0x0002u)
#define INTC_IRQRR_IRQ1F_SHIFT                                                 (1u)
#define INTC_IRQRR_IRQ2F                                                       (0x0004u)
#define INTC_IRQRR_IRQ2F_SHIFT                                                 (2u)
#define INTC_IRQRR_IRQ3F                                                       (0x0008u)
#define INTC_IRQRR_IRQ3F_SHIFT                                                 (3u)
#define INTC_IRQRR_IRQ4F                                                       (0x0010u)
#define INTC_IRQRR_IRQ4F_SHIFT                                                 (4u)
#define INTC_IRQRR_IRQ5F                                                       (0x0020u)
#define INTC_IRQRR_IRQ5F_SHIFT                                                 (5u)
#define INTC_IRQRR_IRQ6F                                                       (0x0040u)
#define INTC_IRQRR_IRQ6F_SHIFT                                                 (6u)
#define INTC_IRQRR_IRQ7F                                                       (0x0080u)
#define INTC_IRQRR_IRQ7F_SHIFT                                                 (7u)
#define INTC_IRQRR_IRQMSK                                                      (0x8000u)
#define INTC_IRQRR_IRQMSK_SHIFT                                                (15u)
#define INTC_SSTBCCR0_DP                                                       (0x0001u)
#define INTC_SSTBCCR0_DP_SHIFT                                                 (0u)
#define INTC_SSTBCCR0_DM                                                       (0x0002u)
#define INTC_SSTBCCR0_DM_SHIFT                                                 (1u)
#define INTC_SSTBCCR0_VBUSIN                                                   (0x0100u)
#define INTC_SSTBCCR0_VBUSIN_SHIFT                                             (8u)
#define INTC_SSTBCCR0_OVRCLR                                                   (0x0200u)
#define INTC_SSTBCCR0_OVRCLR_SHIFT                                             (9u)
#define INTC_SSTBCCR0_CC1_RD                                                   (0x0400u)
#define INTC_SSTBCCR0_CC1_RD_SHIFT                                             (10u)
#define INTC_SSTBCCR0_CC2_RD                                                   (0x0800u)
#define INTC_SSTBCCR0_CC2_RD_SHIFT                                             (11u)
#define INTC_SSTBCCR1_DP                                                       (0x0001u)
#define INTC_SSTBCCR1_DP_SHIFT                                                 (0u)
#define INTC_SSTBCCR1_DM                                                       (0x0002u)
#define INTC_SSTBCCR1_DM_SHIFT                                                 (1u)
#define INTC_SSTBCCR1_VBUSIN                                                   (0x0100u)
#define INTC_SSTBCCR1_VBUSIN_SHIFT                                             (8u)
#define INTC_SSTBCCR1_OVRCLR                                                   (0x0200u)
#define INTC_SSTBCCR1_OVRCLR_SHIFT                                             (9u)
#define INTC_SSTBCCR1_CC1_RD                                                   (0x0400u)
#define INTC_SSTBCCR1_CC1_RD_SHIFT                                             (10u)
#define INTC_SSTBCCR1_CC2_RD                                                   (0x0800u)
#define INTC_SSTBCCR1_CC2_RD_SHIFT                                             (11u)
#define INTC_SSTBCRR0_DP                                                       (0x0001u)
#define INTC_SSTBCRR0_DP_SHIFT                                                 (0u)
#define INTC_SSTBCRR0_DM                                                       (0x0002u)
#define INTC_SSTBCRR0_DM_SHIFT                                                 (1u)
#define INTC_SSTBCRR0_VBUSIN                                                   (0x0100u)
#define INTC_SSTBCRR0_VBUSIN_SHIFT                                             (8u)
#define INTC_SSTBCRR0_OVRCLR                                                   (0x0200u)
#define INTC_SSTBCRR0_OVRCLR_SHIFT                                             (9u)
#define INTC_SSTBCRR0_CC1_RD                                                   (0x0400u)
#define INTC_SSTBCRR0_CC1_RD_SHIFT                                             (10u)
#define INTC_SSTBCRR0_CC2_RD                                                   (0x0800u)
#define INTC_SSTBCRR0_CC2_RD_SHIFT                                             (11u)
#define INTC_SSTBCRR1_DP                                                       (0x0001u)
#define INTC_SSTBCRR1_DP_SHIFT                                                 (0u)
#define INTC_SSTBCRR1_DM                                                       (0x0002u)
#define INTC_SSTBCRR1_DM_SHIFT                                                 (1u)
#define INTC_SSTBCRR1_VBUSIN                                                   (0x0100u)
#define INTC_SSTBCRR1_VBUSIN_SHIFT                                             (8u)
#define INTC_SSTBCRR1_OVRCLR                                                   (0x0200u)
#define INTC_SSTBCRR1_OVRCLR_SHIFT                                             (9u)
#define INTC_SSTBCRR1_CC1_RD                                                   (0x0400u)
#define INTC_SSTBCRR1_CC1_RD_SHIFT                                             (10u)
#define INTC_SSTBCRR1_CC2_RD                                                   (0x0800u)
#define INTC_SSTBCRR1_CC2_RD_SHIFT                                             (11u)

#endif
