/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef MTU_IOBITMASK_H
#define MTU_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define MTU_TOERA_OE3B                                                         (0x01u)
#define MTU_TOERA_OE3B_SHIFT                                                   (0u)
#define MTU_TOERA_OE4A                                                         (0x02u)
#define MTU_TOERA_OE4A_SHIFT                                                   (1u)
#define MTU_TOERA_OE4B                                                         (0x04u)
#define MTU_TOERA_OE4B_SHIFT                                                   (2u)
#define MTU_TOERA_OE3D                                                         (0x08u)
#define MTU_TOERA_OE3D_SHIFT                                                   (3u)
#define MTU_TOERA_OE4C                                                         (0x10u)
#define MTU_TOERA_OE4C_SHIFT                                                   (4u)
#define MTU_TOERA_OE4D                                                         (0x20u)
#define MTU_TOERA_OE4D_SHIFT                                                   (5u)
#define MTU_TGCRA_UF                                                           (0x01u)
#define MTU_TGCRA_UF_SHIFT                                                     (0u)
#define MTU_TGCRA_VF                                                           (0x02u)
#define MTU_TGCRA_VF_SHIFT                                                     (1u)
#define MTU_TGCRA_WF                                                           (0x04u)
#define MTU_TGCRA_WF_SHIFT                                                     (2u)
#define MTU_TGCRA_FB                                                           (0x08u)
#define MTU_TGCRA_FB_SHIFT                                                     (3u)
#define MTU_TGCRA_P                                                            (0x10u)
#define MTU_TGCRA_P_SHIFT                                                      (4u)
#define MTU_TGCRA_N                                                            (0x20u)
#define MTU_TGCRA_N_SHIFT                                                      (5u)
#define MTU_TGCRA_BDC                                                          (0x40u)
#define MTU_TGCRA_BDC_SHIFT                                                    (6u)
#define MTU_TOCR1A_OLSP                                                        (0x01u)
#define MTU_TOCR1A_OLSP_SHIFT                                                  (0u)
#define MTU_TOCR1A_OLSN                                                        (0x02u)
#define MTU_TOCR1A_OLSN_SHIFT                                                  (1u)
#define MTU_TOCR1A_TOCS                                                        (0x04u)
#define MTU_TOCR1A_TOCS_SHIFT                                                  (2u)
#define MTU_TOCR1A_TOCL                                                        (0x08u)
#define MTU_TOCR1A_TOCL_SHIFT                                                  (3u)
#define MTU_TOCR1A_PSYE                                                        (0x40u)
#define MTU_TOCR1A_PSYE_SHIFT                                                  (6u)
#define MTU_TOCR2A_OLS1P                                                       (0x01u)
#define MTU_TOCR2A_OLS1P_SHIFT                                                 (0u)
#define MTU_TOCR2A_OLS1N                                                       (0x02u)
#define MTU_TOCR2A_OLS1N_SHIFT                                                 (1u)
#define MTU_TOCR2A_OLS2P                                                       (0x04u)
#define MTU_TOCR2A_OLS2P_SHIFT                                                 (2u)
#define MTU_TOCR2A_OLS2N                                                       (0x08u)
#define MTU_TOCR2A_OLS2N_SHIFT                                                 (3u)
#define MTU_TOCR2A_OLS3P                                                       (0x10u)
#define MTU_TOCR2A_OLS3P_SHIFT                                                 (4u)
#define MTU_TOCR2A_OLS3N                                                       (0x20u)
#define MTU_TOCR2A_OLS3N_SHIFT                                                 (5u)
#define MTU_TOCR2A_BF                                                          (0xC0u)
#define MTU_TOCR2A_BF_SHIFT                                                    (6u)
#define MTU_TCDRA_TCDRA                                                        (0xFFFFu)
#define MTU_TCDRA_TCDRA_SHIFT                                                  (0u)
#define MTU_TDDRA_TDDRA                                                        (0xFFFFu)
#define MTU_TDDRA_TDDRA_SHIFT                                                  (0u)
#define MTU_TCNTSA_TCNTSA                                                      (0xFFFFu)
#define MTU_TCNTSA_TCNTSA_SHIFT                                                (0u)
#define MTU_TCBRA_TCBRA                                                        (0xFFFFu)
#define MTU_TCBRA_TCBRA_SHIFT                                                  (0u)
#define MTU_TITCR1A_T4VCOR                                                     (0x07u)
#define MTU_TITCR1A_T4VCOR_SHIFT                                               (0u)
#define MTU_TITCR1A_T4VEN                                                      (0x08u)
#define MTU_TITCR1A_T4VEN_SHIFT                                                (3u)
#define MTU_TITCR1A_T3ACOR                                                     (0x70u)
#define MTU_TITCR1A_T3ACOR_SHIFT                                               (4u)
#define MTU_TITCR1A_T3AEN                                                      (0x80u)
#define MTU_TITCR1A_T3AEN_SHIFT                                                (7u)
#define MTU_TITCNT1A_T4VCNT                                                    (0x07u)
#define MTU_TITCNT1A_T4VCNT_SHIFT                                              (0u)
#define MTU_TITCNT1A_T3ACNT                                                    (0x70u)
#define MTU_TITCNT1A_T3ACNT_SHIFT                                              (4u)
#define MTU_TBTERA_BTE                                                         (0x03u)
#define MTU_TBTERA_BTE_SHIFT                                                   (0u)
#define MTU_TDERA_TDER                                                         (0x01u)
#define MTU_TDERA_TDER_SHIFT                                                   (0u)
#define MTU_TOLBRA_OLS1P                                                       (0x01u)
#define MTU_TOLBRA_OLS1P_SHIFT                                                 (0u)
#define MTU_TOLBRA_OLS1N                                                       (0x02u)
#define MTU_TOLBRA_OLS1N_SHIFT                                                 (1u)
#define MTU_TOLBRA_OLS2P                                                       (0x04u)
#define MTU_TOLBRA_OLS2P_SHIFT                                                 (2u)
#define MTU_TOLBRA_OLS2N                                                       (0x08u)
#define MTU_TOLBRA_OLS2N_SHIFT                                                 (3u)
#define MTU_TOLBRA_OLS3P                                                       (0x10u)
#define MTU_TOLBRA_OLS3P_SHIFT                                                 (4u)
#define MTU_TOLBRA_OLS3N                                                       (0x20u)
#define MTU_TOLBRA_OLS3N_SHIFT                                                 (5u)
#define MTU_TITMRA_TITM                                                        (0x01u)
#define MTU_TITMRA_TITM_SHIFT                                                  (0u)
#define MTU_TITCR2A_TRG4COR                                                    (0x07u)
#define MTU_TITCR2A_TRG4COR_SHIFT                                              (0u)
#define MTU_TITCNT2A_TRG4CNT                                                   (0x07u)
#define MTU_TITCNT2A_TRG4CNT_SHIFT                                             (0u)
#define MTU_TWCRA_WRE                                                          (0x01u)
#define MTU_TWCRA_WRE_SHIFT                                                    (0u)
#define MTU_TWCRA_SCC                                                          (0x02u)
#define MTU_TWCRA_SCC_SHIFT                                                    (1u)
#define MTU_TWCRA_CCE                                                          (0x80u)
#define MTU_TWCRA_CCE_SHIFT                                                    (7u)
#define MTU_TMDR2A_DRS                                                         (0x01u)
#define MTU_TMDR2A_DRS_SHIFT                                                   (0u)
#define MTU_TSTRA_CST0                                                         (0x01u)
#define MTU_TSTRA_CST0_SHIFT                                                   (0u)
#define MTU_TSTRA_CST1                                                         (0x02u)
#define MTU_TSTRA_CST1_SHIFT                                                   (1u)
#define MTU_TSTRA_CST2                                                         (0x04u)
#define MTU_TSTRA_CST2_SHIFT                                                   (2u)
#define MTU_TSTRA_CST8                                                         (0x08u)
#define MTU_TSTRA_CST8_SHIFT                                                   (3u)
#define MTU_TSTRA_CST3                                                         (0x40u)
#define MTU_TSTRA_CST3_SHIFT                                                   (6u)
#define MTU_TSTRA_CST4                                                         (0x80u)
#define MTU_TSTRA_CST4_SHIFT                                                   (7u)
#define MTU_TSYRA_SYNC0                                                        (0x01u)
#define MTU_TSYRA_SYNC0_SHIFT                                                  (0u)
#define MTU_TSYRA_SYNC1                                                        (0x02u)
#define MTU_TSYRA_SYNC1_SHIFT                                                  (1u)
#define MTU_TSYRA_SYNC2                                                        (0x04u)
#define MTU_TSYRA_SYNC2_SHIFT                                                  (2u)
#define MTU_TSYRA_SYNC3                                                        (0x40u)
#define MTU_TSYRA_SYNC3_SHIFT                                                  (6u)
#define MTU_TSYRA_SYNC4                                                        (0x80u)
#define MTU_TSYRA_SYNC4_SHIFT                                                  (7u)
#define MTU_TCSYSTR_SCH7                                                       (0x01u)
#define MTU_TCSYSTR_SCH7_SHIFT                                                 (0u)
#define MTU_TCSYSTR_SCH6                                                       (0x02u)
#define MTU_TCSYSTR_SCH6_SHIFT                                                 (1u)
#define MTU_TCSYSTR_SCH4                                                       (0x08u)
#define MTU_TCSYSTR_SCH4_SHIFT                                                 (3u)
#define MTU_TCSYSTR_SCH3                                                       (0x10u)
#define MTU_TCSYSTR_SCH3_SHIFT                                                 (4u)
#define MTU_TCSYSTR_SCH2                                                       (0x20u)
#define MTU_TCSYSTR_SCH2_SHIFT                                                 (5u)
#define MTU_TCSYSTR_SCH1                                                       (0x40u)
#define MTU_TCSYSTR_SCH1_SHIFT                                                 (6u)
#define MTU_TCSYSTR_SCH0                                                       (0x80u)
#define MTU_TCSYSTR_SCH0_SHIFT                                                 (7u)
#define MTU_TRWERA_RWE                                                         (0x01u)
#define MTU_TRWERA_RWE_SHIFT                                                   (0u)
#define MTU_TOERB_OE6B                                                         (0x01u)
#define MTU_TOERB_OE6B_SHIFT                                                   (0u)
#define MTU_TOERB_OE7A                                                         (0x02u)
#define MTU_TOERB_OE7A_SHIFT                                                   (1u)
#define MTU_TOERB_OE7B                                                         (0x04u)
#define MTU_TOERB_OE7B_SHIFT                                                   (2u)
#define MTU_TOERB_OE6D                                                         (0x08u)
#define MTU_TOERB_OE6D_SHIFT                                                   (3u)
#define MTU_TOERB_OE7C                                                         (0x10u)
#define MTU_TOERB_OE7C_SHIFT                                                   (4u)
#define MTU_TOERB_OE7D                                                         (0x20u)
#define MTU_TOERB_OE7D_SHIFT                                                   (5u)
#define MTU_TOCR1B_OLSP                                                        (0x01u)
#define MTU_TOCR1B_OLSP_SHIFT                                                  (0u)
#define MTU_TOCR1B_OLSN                                                        (0x02u)
#define MTU_TOCR1B_OLSN_SHIFT                                                  (1u)
#define MTU_TOCR1B_TOCS                                                        (0x04u)
#define MTU_TOCR1B_TOCS_SHIFT                                                  (2u)
#define MTU_TOCR1B_TOCL                                                        (0x08u)
#define MTU_TOCR1B_TOCL_SHIFT                                                  (3u)
#define MTU_TOCR1B_PSYE                                                        (0x40u)
#define MTU_TOCR1B_PSYE_SHIFT                                                  (6u)
#define MTU_TOCR2B_OLS1P                                                       (0x01u)
#define MTU_TOCR2B_OLS1P_SHIFT                                                 (0u)
#define MTU_TOCR2B_OLS1N                                                       (0x02u)
#define MTU_TOCR2B_OLS1N_SHIFT                                                 (1u)
#define MTU_TOCR2B_OLS2P                                                       (0x04u)
#define MTU_TOCR2B_OLS2P_SHIFT                                                 (2u)
#define MTU_TOCR2B_OLS2N                                                       (0x08u)
#define MTU_TOCR2B_OLS2N_SHIFT                                                 (3u)
#define MTU_TOCR2B_OLS3P                                                       (0x10u)
#define MTU_TOCR2B_OLS3P_SHIFT                                                 (4u)
#define MTU_TOCR2B_OLS3N                                                       (0x20u)
#define MTU_TOCR2B_OLS3N_SHIFT                                                 (5u)
#define MTU_TOCR2B_BF                                                          (0xC0u)
#define MTU_TOCR2B_BF_SHIFT                                                    (6u)
#define MTU_TCDRB_TCDRB                                                        (0xFFFFu)
#define MTU_TCDRB_TCDRB_SHIFT                                                  (0u)
#define MTU_TDDRB_TDDRB                                                        (0xFFFFu)
#define MTU_TDDRB_TDDRB_SHIFT                                                  (0u)
#define MTU_TCNTSB_TCNTSB                                                      (0xFFFFu)
#define MTU_TCNTSB_TCNTSB_SHIFT                                                (0u)
#define MTU_TCBRB_TCBRB                                                        (0xFFFFu)
#define MTU_TCBRB_TCBRB_SHIFT                                                  (0u)
#define MTU_TITCR1B_T7VCOR                                                     (0x07u)
#define MTU_TITCR1B_T7VCOR_SHIFT                                               (0u)
#define MTU_TITCR1B_T7VEN                                                      (0x08u)
#define MTU_TITCR1B_T7VEN_SHIFT                                                (3u)
#define MTU_TITCR1B_T6ACOR                                                     (0x70u)
#define MTU_TITCR1B_T6ACOR_SHIFT                                               (4u)
#define MTU_TITCR1B_T6AEN                                                      (0x80u)
#define MTU_TITCR1B_T6AEN_SHIFT                                                (7u)
#define MTU_TITCNT1B_T7VCNT                                                    (0x07u)
#define MTU_TITCNT1B_T7VCNT_SHIFT                                              (0u)
#define MTU_TITCNT1B_T6ACNT                                                    (0x70u)
#define MTU_TITCNT1B_T6ACNT_SHIFT                                              (4u)
#define MTU_TBTERB_BTE                                                         (0x03u)
#define MTU_TBTERB_BTE_SHIFT                                                   (0u)
#define MTU_TDERB_TDER                                                         (0x01u)
#define MTU_TDERB_TDER_SHIFT                                                   (0u)
#define MTU_TOLBRB_OLS1P                                                       (0x01u)
#define MTU_TOLBRB_OLS1P_SHIFT                                                 (0u)
#define MTU_TOLBRB_OLS1N                                                       (0x02u)
#define MTU_TOLBRB_OLS1N_SHIFT                                                 (1u)
#define MTU_TOLBRB_OLS2P                                                       (0x04u)
#define MTU_TOLBRB_OLS2P_SHIFT                                                 (2u)
#define MTU_TOLBRB_OLS2N                                                       (0x08u)
#define MTU_TOLBRB_OLS2N_SHIFT                                                 (3u)
#define MTU_TOLBRB_OLS3P                                                       (0x10u)
#define MTU_TOLBRB_OLS3P_SHIFT                                                 (4u)
#define MTU_TOLBRB_OLS3N                                                       (0x20u)
#define MTU_TOLBRB_OLS3N_SHIFT                                                 (5u)
#define MTU_TITMRB_TITM                                                        (0x01u)
#define MTU_TITMRB_TITM_SHIFT                                                  (0u)
#define MTU_TITCR2B_TRG7COR                                                    (0x07u)
#define MTU_TITCR2B_TRG7COR_SHIFT                                              (0u)
#define MTU_TITCNT2B_TRG7CNT                                                   (0x07u)
#define MTU_TITCNT2B_TRG7CNT_SHIFT                                             (0u)
#define MTU_TWCRB_WRE                                                          (0x01u)
#define MTU_TWCRB_WRE_SHIFT                                                    (0u)
#define MTU_TWCRB_SCC                                                          (0x02u)
#define MTU_TWCRB_SCC_SHIFT                                                    (1u)
#define MTU_TWCRB_CCE                                                          (0x80u)
#define MTU_TWCRB_CCE_SHIFT                                                    (7u)
#define MTU_TMDR2B_DRS                                                         (0x01u)
#define MTU_TMDR2B_DRS_SHIFT                                                   (0u)
#define MTU_TSTRB_CST6                                                         (0x40u)
#define MTU_TSTRB_CST6_SHIFT                                                   (6u)
#define MTU_TSTRB_CST7                                                         (0x80u)
#define MTU_TSTRB_CST7_SHIFT                                                   (7u)
#define MTU_TSYRB_SYNC6                                                        (0x40u)
#define MTU_TSYRB_SYNC6_SHIFT                                                  (6u)
#define MTU_TSYRB_SYNC7                                                        (0x80u)
#define MTU_TSYRB_SYNC7_SHIFT                                                  (7u)
#define MTU_TRWERB_RWE                                                         (0x01u)
#define MTU_TRWERB_RWE_SHIFT                                                   (0u)
#define MTU_NFCR0_NFAEN                                                        (0x01u)
#define MTU_NFCR0_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR0_NFBEN                                                        (0x02u)
#define MTU_NFCR0_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR0_NFCEN                                                        (0x04u)
#define MTU_NFCR0_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR0_NFDEN                                                        (0x08u)
#define MTU_NFCR0_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR0_NFCS                                                         (0x30u)
#define MTU_NFCR0_NFCS_SHIFT                                                   (4u)
#define MTU_NFCRC_NFAEN                                                        (0x01u)
#define MTU_NFCRC_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCRC_NFBEN                                                        (0x02u)
#define MTU_NFCRC_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCRC_NFCEN                                                        (0x04u)
#define MTU_NFCRC_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCRC_NFDEN                                                        (0x08u)
#define MTU_NFCRC_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCRC_NFCSC                                                        (0x30u)
#define MTU_NFCRC_NFCSC_SHIFT                                                  (4u)
#define MTU_TCR_TPSC                                                           (0x07u)
#define MTU_TCR_TPSC_SHIFT                                                     (0u)
#define MTU_TCR_CKEG                                                           (0x18u)
#define MTU_TCR_CKEG_SHIFT                                                     (3u)
#define MTU_TCR_CCLR                                                           (0xE0u)
#define MTU_TCR_CCLR_SHIFT                                                     (5u)
#define MTU_TMDR1_MD                                                           (0x0Fu)
#define MTU_TMDR1_MD_SHIFT                                                     (0u)
#define MTU_TMDR1_BFA                                                          (0x10u)
#define MTU_TMDR1_BFA_SHIFT                                                    (4u)
#define MTU_TMDR1_BFB                                                          (0x20u)
#define MTU_TMDR1_BFB_SHIFT                                                    (5u)
#define MTU_TMDR1_BFE                                                          (0x40u)
#define MTU_TMDR1_BFE_SHIFT                                                    (6u)
#define MTU_TIORH_IOA                                                          (0x0Fu)
#define MTU_TIORH_IOA_SHIFT                                                    (0u)
#define MTU_TIORH_IOB                                                          (0xF0u)
#define MTU_TIORH_IOB_SHIFT                                                    (4u)
#define MTU_TIORL_IOC                                                          (0x0Fu)
#define MTU_TIORL_IOC_SHIFT                                                    (0u)
#define MTU_TIORL_IOD                                                          (0xF0u)
#define MTU_TIORL_IOD_SHIFT                                                    (4u)
#define MTU_TIER_TGIEA                                                         (0x01u)
#define MTU_TIER_TGIEA_SHIFT                                                   (0u)
#define MTU_TIER_TGIEB                                                         (0x02u)
#define MTU_TIER_TGIEB_SHIFT                                                   (1u)
#define MTU_TIER_TGIEC                                                         (0x04u)
#define MTU_TIER_TGIEC_SHIFT                                                   (2u)
#define MTU_TIER_TGIED                                                         (0x08u)
#define MTU_TIER_TGIED_SHIFT                                                   (3u)
#define MTU_TIER_TCIEV                                                         (0x10u)
#define MTU_TIER_TCIEV_SHIFT                                                   (4u)
#define MTU_TIER_TTGE                                                          (0x80u)
#define MTU_TIER_TTGE_SHIFT                                                    (7u)
#define MTU_TCNT_TCNT                                                          (0xFFFFu)
#define MTU_TCNT_TCNT_SHIFT                                                    (0u)
#define MTU_TGRA_TGRA                                                          (0xFFFFu)
#define MTU_TGRA_TGRA_SHIFT                                                    (0u)
#define MTU_TGRB_TGRB                                                          (0xFFFFu)
#define MTU_TGRB_TGRB_SHIFT                                                    (0u)
#define MTU_TGRC_TGRC                                                          (0xFFFFu)
#define MTU_TGRC_TGRC_SHIFT                                                    (0u)
#define MTU_TGRD_TGRD                                                          (0xFFFFu)
#define MTU_TGRD_TGRD_SHIFT                                                    (0u)
#define MTU_TGRE_TGRE                                                          (0xFFFFu)
#define MTU_TGRE_TGRE_SHIFT                                                    (0u)
#define MTU_TGRF_TGRF                                                          (0xFFFFu)
#define MTU_TGRF_TGRF_SHIFT                                                    (0u)
#define MTU_TIER2_TGIEE                                                        (0x01u)
#define MTU_TIER2_TGIEE_SHIFT                                                  (0u)
#define MTU_TIER2_TGIEF                                                        (0x02u)
#define MTU_TIER2_TGIEF_SHIFT                                                  (1u)
#define MTU_TIER2_TTGE2                                                        (0x80u)
#define MTU_TIER2_TTGE2_SHIFT                                                  (7u)
#define MTU_TBTM_TTSA                                                          (0x01u)
#define MTU_TBTM_TTSA_SHIFT                                                    (0u)
#define MTU_TBTM_TTSB                                                          (0x02u)
#define MTU_TBTM_TTSB_SHIFT                                                    (1u)
#define MTU_TBTM_TTSE                                                          (0x04u)
#define MTU_TBTM_TTSE_SHIFT                                                    (2u)
#define MTU_TCR2_TPSC2                                                         (0x07u)
#define MTU_TCR2_TPSC2_SHIFT                                                   (0u)
#define MTU_NFCR1_NFAEN                                                        (0x01u)
#define MTU_NFCR1_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR1_NFBEN                                                        (0x02u)
#define MTU_NFCR1_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR1_NFCEN                                                        (0x04u)
#define MTU_NFCR1_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR1_NFDEN                                                        (0x08u)
#define MTU_NFCR1_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR1_NFCS                                                         (0x30u)
#define MTU_NFCR1_NFCS_SHIFT                                                   (4u)
#define MTU_TIOR_IOA                                                           (0x0Fu)
#define MTU_TIOR_IOA_SHIFT                                                     (0u)
#define MTU_TIOR_IOB                                                           (0xF0u)
#define MTU_TIOR_IOB_SHIFT                                                     (4u)
#define MTU_TIER_TCIEU                                                         (0x20u)
#define MTU_TIER_TCIEU_SHIFT                                                   (5u)
#define MTU_TSR_TCFD                                                           (0x80u)
#define MTU_TSR_TCFD_SHIFT                                                     (7u)
#define MTU_TICCR_I1AE                                                         (0x01u)
#define MTU_TICCR_I1AE_SHIFT                                                   (0u)
#define MTU_TICCR_I1BE                                                         (0x02u)
#define MTU_TICCR_I1BE_SHIFT                                                   (1u)
#define MTU_TICCR_I2AE                                                         (0x04u)
#define MTU_TICCR_I2AE_SHIFT                                                   (2u)
#define MTU_TICCR_I2BE                                                         (0x08u)
#define MTU_TICCR_I2BE_SHIFT                                                   (3u)
#define MTU_TMDR3_LWA                                                          (0x01u)
#define MTU_TMDR3_LWA_SHIFT                                                    (0u)
#define MTU_TMDR3_PHCKSEL                                                      (0x02u)
#define MTU_TMDR3_PHCKSEL_SHIFT                                                (1u)
#define MTU_TCR2_PCB                                                           (0x18u)
#define MTU_TCR2_PCB_SHIFT                                                     (3u)
#define MTU_TCNTLW_TCNTLW                                                      (0xFFFFFFFFu)
#define MTU_TCNTLW_TCNTLW_SHIFT                                                (0u)
#define MTU_TGRALW_TGRALW                                                      (0xFFFFFFFFu)
#define MTU_TGRALW_TGRALW_SHIFT                                                (0u)
#define MTU_TGRBLW_TGRBLW                                                      (0xFFFFFFFFu)
#define MTU_TGRBLW_TGRBLW_SHIFT                                                (0u)
#define MTU_NFCR2_NFAEN                                                        (0x01u)
#define MTU_NFCR2_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR2_NFBEN                                                        (0x02u)
#define MTU_NFCR2_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR2_NFCEN                                                        (0x04u)
#define MTU_NFCR2_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR2_NFDEN                                                        (0x08u)
#define MTU_NFCR2_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR2_NFCS                                                         (0x30u)
#define MTU_NFCR2_NFCS_SHIFT                                                   (4u)
#define MTU_NFCR3_NFAEN                                                        (0x01u)
#define MTU_NFCR3_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR3_NFBEN                                                        (0x02u)
#define MTU_NFCR3_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR3_NFCEN                                                        (0x04u)
#define MTU_NFCR3_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR3_NFDEN                                                        (0x08u)
#define MTU_NFCR3_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR3_NFCS                                                         (0x30u)
#define MTU_NFCR3_NFCS_SHIFT                                                   (4u)
#define MTU_TIER_TTGE2                                                         (0x40u)
#define MTU_TIER_TTGE2_SHIFT                                                   (6u)
#define MTU_TADCR_ITB4VE                                                       (0x0001u)
#define MTU_TADCR_ITB4VE_SHIFT                                                 (0u)
#define MTU_TADCR_ITB3AE                                                       (0x0002u)
#define MTU_TADCR_ITB3AE_SHIFT                                                 (1u)
#define MTU_TADCR_ITA4VE                                                       (0x0004u)
#define MTU_TADCR_ITA4VE_SHIFT                                                 (2u)
#define MTU_TADCR_ITA3AE                                                       (0x0008u)
#define MTU_TADCR_ITA3AE_SHIFT                                                 (3u)
#define MTU_TADCR_DT4BE                                                        (0x0010u)
#define MTU_TADCR_DT4BE_SHIFT                                                  (4u)
#define MTU_TADCR_UT4BE                                                        (0x0020u)
#define MTU_TADCR_UT4BE_SHIFT                                                  (5u)
#define MTU_TADCR_DT4AE                                                        (0x0040u)
#define MTU_TADCR_DT4AE_SHIFT                                                  (6u)
#define MTU_TADCR_UT4AE                                                        (0x0080u)
#define MTU_TADCR_UT4AE_SHIFT                                                  (7u)
#define MTU_TADCR_BF                                                           (0xC000u)
#define MTU_TADCR_BF_SHIFT                                                     (14u)
#define MTU_TADCORA_TADCORA                                                    (0xFFFFu)
#define MTU_TADCORA_TADCORA_SHIFT                                              (0u)
#define MTU_TADCORB_TADCORB                                                    (0xFFFFu)
#define MTU_TADCORB_TADCORB_SHIFT                                              (0u)
#define MTU_TADCOBRA_TADCOBRA                                                  (0xFFFFu)
#define MTU_TADCOBRA_TADCOBRA_SHIFT                                            (0u)
#define MTU_TADCOBRB_TADCOBRB                                                  (0xFFFFu)
#define MTU_TADCOBRB_TADCOBRB_SHIFT                                            (0u)
#define MTU_NFCR4_NFAEN                                                        (0x01u)
#define MTU_NFCR4_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR4_NFBEN                                                        (0x02u)
#define MTU_NFCR4_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR4_NFCEN                                                        (0x04u)
#define MTU_NFCR4_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR4_NFDEN                                                        (0x08u)
#define MTU_NFCR4_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR4_NFCS                                                         (0x30u)
#define MTU_NFCR4_NFCS_SHIFT                                                   (4u)
#define MTU_NFCR5_NFUEN                                                        (0x01u)
#define MTU_NFCR5_NFUEN_SHIFT                                                  (0u)
#define MTU_NFCR5_NFVEN                                                        (0x02u)
#define MTU_NFCR5_NFVEN_SHIFT                                                  (1u)
#define MTU_NFCR5_NFWEN                                                        (0x04u)
#define MTU_NFCR5_NFWEN_SHIFT                                                  (2u)
#define MTU_NFCR5_NFCS                                                         (0x30u)
#define MTU_NFCR5_NFCS_SHIFT                                                   (4u)
#define MTU_TCNTU_TCNTU                                                        (0xFFFFu)
#define MTU_TCNTU_TCNTU_SHIFT                                                  (0u)
#define MTU_TGRU_TGRU                                                          (0xFFFFu)
#define MTU_TGRU_TGRU_SHIFT                                                    (0u)
#define MTU_TCRU_TPSC                                                          (0x03u)
#define MTU_TCRU_TPSC_SHIFT                                                    (0u)
#define MTU_TCR2U_TPSC2                                                        (0x07u)
#define MTU_TCR2U_TPSC2_SHIFT                                                  (0u)
#define MTU_TCR2U_CKEG                                                         (0x18u)
#define MTU_TCR2U_CKEG_SHIFT                                                   (3u)
#define MTU_TIORU_IOC                                                          (0x1Fu)
#define MTU_TIORU_IOC_SHIFT                                                    (0u)
#define MTU_TCNTV_TCNTV                                                        (0xFFFFu)
#define MTU_TCNTV_TCNTV_SHIFT                                                  (0u)
#define MTU_TGRV_TGRV                                                          (0xFFFFu)
#define MTU_TGRV_TGRV_SHIFT                                                    (0u)
#define MTU_TCRV_TPSC                                                          (0x03u)
#define MTU_TCRV_TPSC_SHIFT                                                    (0u)
#define MTU_TCR2V_TPSC2                                                        (0x07u)
#define MTU_TCR2V_TPSC2_SHIFT                                                  (0u)
#define MTU_TCR2V_CKEG                                                         (0x18u)
#define MTU_TCR2V_CKEG_SHIFT                                                   (3u)
#define MTU_TIORV_IOC                                                          (0x1Fu)
#define MTU_TIORV_IOC_SHIFT                                                    (0u)
#define MTU_TCNTW_TCNTW                                                        (0xFFFFu)
#define MTU_TCNTW_TCNTW_SHIFT                                                  (0u)
#define MTU_TGRW_TGRW                                                          (0xFFFFu)
#define MTU_TGRW_TGRW_SHIFT                                                    (0u)
#define MTU_TCRW_TPSC                                                          (0x03u)
#define MTU_TCRW_TPSC_SHIFT                                                    (0u)
#define MTU_TCR2W_TPSC2                                                        (0x07u)
#define MTU_TCR2W_TPSC2_SHIFT                                                  (0u)
#define MTU_TCR2W_CKEG                                                         (0x18u)
#define MTU_TCR2W_CKEG_SHIFT                                                   (3u)
#define MTU_TIORW_IOC                                                          (0x1Fu)
#define MTU_TIORW_IOC_SHIFT                                                    (0u)
#define MTU_TIER_TGIE5W                                                        (0x01u)
#define MTU_TIER_TGIE5W_SHIFT                                                  (0u)
#define MTU_TIER_TGIE5V                                                        (0x02u)
#define MTU_TIER_TGIE5V_SHIFT                                                  (1u)
#define MTU_TIER_TGIE5U                                                        (0x04u)
#define MTU_TIER_TGIE5U_SHIFT                                                  (2u)
#define MTU_TSTR_CSTW5                                                         (0x01u)
#define MTU_TSTR_CSTW5_SHIFT                                                   (0u)
#define MTU_TSTR_CSTV5                                                         (0x02u)
#define MTU_TSTR_CSTV5_SHIFT                                                   (1u)
#define MTU_TSTR_CSTU5                                                         (0x04u)
#define MTU_TSTR_CSTU5_SHIFT                                                   (2u)
#define MTU_TCNTCMPCLR_CMPCLR5W                                                (0x01u)
#define MTU_TCNTCMPCLR_CMPCLR5W_SHIFT                                          (0u)
#define MTU_TCNTCMPCLR_CMPCLR5V                                                (0x02u)
#define MTU_TCNTCMPCLR_CMPCLR5V_SHIFT                                          (1u)
#define MTU_TCNTCMPCLR_CMPCLR5U                                                (0x04u)
#define MTU_TCNTCMPCLR_CMPCLR5U_SHIFT                                          (2u)
#define MTU_TSYCR_CE2B                                                         (0x01u)
#define MTU_TSYCR_CE2B_SHIFT                                                   (0u)
#define MTU_TSYCR_CE2A                                                         (0x02u)
#define MTU_TSYCR_CE2A_SHIFT                                                   (1u)
#define MTU_TSYCR_CE1B                                                         (0x04u)
#define MTU_TSYCR_CE1B_SHIFT                                                   (2u)
#define MTU_TSYCR_CE1A                                                         (0x08u)
#define MTU_TSYCR_CE1A_SHIFT                                                   (3u)
#define MTU_TSYCR_CE0D                                                         (0x10u)
#define MTU_TSYCR_CE0D_SHIFT                                                   (4u)
#define MTU_TSYCR_CE0C                                                         (0x20u)
#define MTU_TSYCR_CE0C_SHIFT                                                   (5u)
#define MTU_TSYCR_CE0B                                                         (0x40u)
#define MTU_TSYCR_CE0B_SHIFT                                                   (6u)
#define MTU_TSYCR_CE0A                                                         (0x80u)
#define MTU_TSYCR_CE0A_SHIFT                                                   (7u)
#define MTU_NFCR6_NFAEN                                                        (0x01u)
#define MTU_NFCR6_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR6_NFBEN                                                        (0x02u)
#define MTU_NFCR6_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR6_NFCEN                                                        (0x04u)
#define MTU_NFCR6_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR6_NFDEN                                                        (0x08u)
#define MTU_NFCR6_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR6_NFCS                                                         (0x30u)
#define MTU_NFCR6_NFCS_SHIFT                                                   (4u)
#define MTU_TADCR_ITB7VE                                                       (0x0001u)
#define MTU_TADCR_ITB7VE_SHIFT                                                 (0u)
#define MTU_TADCR_ITB6AE                                                       (0x0002u)
#define MTU_TADCR_ITB6AE_SHIFT                                                 (1u)
#define MTU_TADCR_ITA7VE                                                       (0x0004u)
#define MTU_TADCR_ITA7VE_SHIFT                                                 (2u)
#define MTU_TADCR_ITA6AE                                                       (0x0008u)
#define MTU_TADCR_ITA6AE_SHIFT                                                 (3u)
#define MTU_TADCR_DT7BE                                                        (0x0010u)
#define MTU_TADCR_DT7BE_SHIFT                                                  (4u)
#define MTU_TADCR_UT7BE                                                        (0x0020u)
#define MTU_TADCR_UT7BE_SHIFT                                                  (5u)
#define MTU_TADCR_DT7AE                                                        (0x0040u)
#define MTU_TADCR_DT7AE_SHIFT                                                  (6u)
#define MTU_TADCR_UT7AE                                                        (0x0080u)
#define MTU_TADCR_UT7AE_SHIFT                                                  (7u)
#define MTU_NFCR7_NFAEN                                                        (0x01u)
#define MTU_NFCR7_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR7_NFBEN                                                        (0x02u)
#define MTU_NFCR7_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR7_NFCEN                                                        (0x04u)
#define MTU_NFCR7_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR7_NFDEN                                                        (0x08u)
#define MTU_NFCR7_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR7_NFCS                                                         (0x30u)
#define MTU_NFCR7_NFCS_SHIFT                                                   (4u)
#define MTU_NFCR8_NFAEN                                                        (0x01u)
#define MTU_NFCR8_NFAEN_SHIFT                                                  (0u)
#define MTU_NFCR8_NFBEN                                                        (0x02u)
#define MTU_NFCR8_NFBEN_SHIFT                                                  (1u)
#define MTU_NFCR8_NFCEN                                                        (0x04u)
#define MTU_NFCR8_NFCEN_SHIFT                                                  (2u)
#define MTU_NFCR8_NFDEN                                                        (0x08u)
#define MTU_NFCR8_NFDEN_SHIFT                                                  (3u)
#define MTU_NFCR8_NFCS                                                         (0x30u)
#define MTU_NFCR8_NFCS_SHIFT                                                   (4u)

#endif
