/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef PRR_IOBITMASK_H
#define PRR_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define PRR_BSID_DID                                                           (0xFFFFFFFFu)
#define PRR_BSID_DID_SHIFT                                                     (0u)
#define PRR_AXIBUSCTL0_ETHAXCACHE                                              (0x00000003u)
#define PRR_AXIBUSCTL0_ETHAXCACHE_SHIFT                                        (0u)
#define PRR_AXIBUSCTL0_JCUAWCACHE                                              (0x000F0000u)
#define PRR_AXIBUSCTL0_JCUAWCACHE_SHIFT                                        (16u)
#define PRR_AXIBUSCTL0_JCUARCACHE                                              (0x0F000000u)
#define PRR_AXIBUSCTL0_JCUARCACHE_SHIFT                                        (24u)
#define PRR_AXIBUSCTL1_VINAWCACHE                                              (0x0000000Fu)
#define PRR_AXIBUSCTL1_VINAWCACHE_SHIFT                                        (0u)
#define PRR_AXIBUSCTL1_IMR20AWCACHE                                            (0x000F0000u)
#define PRR_AXIBUSCTL1_IMR20AWCACHE_SHIFT                                      (16u)
#define PRR_AXIBUSCTL1_IMR20ARCACHE                                            (0x0F000000u)
#define PRR_AXIBUSCTL1_IMR20ARCACHE_SHIFT                                      (24u)
#define PRR_AXIBUSCTL2_CEUAWCACHE                                              (0x0000000Fu)
#define PRR_AXIBUSCTL2_CEUAWCACHE_SHIFT                                        (0u)
#define PRR_AXIBUSCTL3_SDMMC1AWCACHE                                           (0x0000000Fu)
#define PRR_AXIBUSCTL3_SDMMC1AWCACHE_SHIFT                                     (0u)
#define PRR_AXIBUSCTL3_SDMMC1ARCACHE                                           (0x00000F00u)
#define PRR_AXIBUSCTL3_SDMMC1ARCACHE_SHIFT                                     (8u)
#define PRR_AXIBUSCTL3_SDMMC0AWCACHE                                           (0x000F0000u)
#define PRR_AXIBUSCTL3_SDMMC0AWCACHE_SHIFT                                     (16u)
#define PRR_AXIBUSCTL3_SDMMC0ARCACHE                                           (0x0F000000u)
#define PRR_AXIBUSCTL3_SDMMC0ARCACHE_SHIFT                                     (24u)
#define PRR_AXIBUSCTL4_DRPAWCACHE                                              (0x0000000Fu)
#define PRR_AXIBUSCTL4_DRPAWCACHE_SHIFT                                        (0u)
#define PRR_AXIBUSCTL4_DRPARCACHE                                              (0x00000F00u)
#define PRR_AXIBUSCTL4_DRPARCACHE_SHIFT                                        (8u)
#define PRR_AXIBUSCTL4_NANDAWCACHE                                             (0x000F0000u)
#define PRR_AXIBUSCTL4_NANDAWCACHE_SHIFT                                       (16u)
#define PRR_AXIBUSCTL4_NANDARCACHE                                             (0x0F000000u)
#define PRR_AXIBUSCTL4_NANDARCACHE_SHIFT                                       (24u)
#define PRR_AXIBUSCTL5_D2D1AXCACHE                                             (0x00000003u)
#define PRR_AXIBUSCTL5_D2D1AXCACHE_SHIFT                                       (0u)
#define PRR_AXIBUSCTL5_D2D0AXCACHE                                             (0x00030000u)
#define PRR_AXIBUSCTL5_D2D0AXCACHE_SHIFT                                       (16u)
#define PRR_AXIBUSCTL6_VDC602ARCACHE                                           (0x00000F00u)
#define PRR_AXIBUSCTL6_VDC602ARCACHE_SHIFT                                     (8u)
#define PRR_AXIBUSCTL6_VDC601AWCACHE                                           (0x000F0000u)
#define PRR_AXIBUSCTL6_VDC601AWCACHE_SHIFT                                     (16u)
#define PRR_AXIBUSCTL6_VDC601ARCACHE                                           (0x0F000000u)
#define PRR_AXIBUSCTL6_VDC601ARCACHE_SHIFT                                     (24u)
#define PRR_AXIBUSCTL7_VDC604ARCACHE                                           (0x00000F00u)
#define PRR_AXIBUSCTL7_VDC604ARCACHE_SHIFT                                     (8u)
#define PRR_AXIRERRCTL0_CEURERREN                                              (0x00000100u)
#define PRR_AXIRERRCTL0_CEURERREN_SHIFT                                        (8u)
#define PRR_AXIRERRCTL0_VINRERREN                                              (0x00010000u)
#define PRR_AXIRERRCTL0_VINRERREN_SHIFT                                        (16u)
#define PRR_AXIRERRCTL0_IMR20RERREN                                            (0x00100000u)
#define PRR_AXIRERRCTL0_IMR20RERREN_SHIFT                                      (20u)
#define PRR_AXIRERRCTL0_JCURERREN                                              (0x10000000u)
#define PRR_AXIRERRCTL0_JCURERREN_SHIFT                                        (28u)
#define PRR_AXIRERRCTL1_DRPRERREN                                              (0x00010000u)
#define PRR_AXIRERRCTL1_DRPRERREN_SHIFT                                        (16u)
#define PRR_AXIRERRCTL1_NANDRERREN                                             (0x00100000u)
#define PRR_AXIRERRCTL1_NANDRERREN_SHIFT                                       (20u)
#define PRR_AXIRERRCTL1_SDMMC1RERREN                                           (0x01000000u)
#define PRR_AXIRERRCTL1_SDMMC1RERREN_SHIFT                                     (24u)
#define PRR_AXIRERRCTL1_SDMMC0RERREN                                           (0x10000000u)
#define PRR_AXIRERRCTL1_SDMMC0RERREN_SHIFT                                     (28u)
#define PRR_AXIRERRCTL2_VDC604RERREN                                           (0x00010000u)
#define PRR_AXIRERRCTL2_VDC604RERREN_SHIFT                                     (16u)
#define PRR_AXIRERRCTL2_VDC602RERREN                                           (0x01000000u)
#define PRR_AXIRERRCTL2_VDC602RERREN_SHIFT                                     (24u)
#define PRR_AXIRERRCTL2_VDC601RERREN                                           (0x10000000u)
#define PRR_AXIRERRCTL2_VDC601RERREN_SHIFT                                     (28u)
#define PRR_AXIRERRST0_CEUBRESP                                                (0x00000300u)
#define PRR_AXIRERRST0_CEUBRESP_SHIFT                                          (8u)
#define PRR_AXIRERRST0_VINBRESP                                                (0x00030000u)
#define PRR_AXIRERRST0_VINBRESP_SHIFT                                          (16u)
#define PRR_AXIRERRST0_IMR20BRESP                                              (0x00300000u)
#define PRR_AXIRERRST0_IMR20BRESP_SHIFT                                        (20u)
#define PRR_AXIRERRST0_IMR20RRESP                                              (0x00C00000u)
#define PRR_AXIRERRST0_IMR20RRESP_SHIFT                                        (22u)
#define PRR_AXIRERRST0_JCUBRESP                                                (0x30000000u)
#define PRR_AXIRERRST0_JCUBRESP_SHIFT                                          (28u)
#define PRR_AXIRERRST0_JCURRESP                                                (0xC0000000u)
#define PRR_AXIRERRST0_JCURRESP_SHIFT                                          (30u)
#define PRR_AXIRERRST1_DRPBRESP                                                (0x00030000u)
#define PRR_AXIRERRST1_DRPBRESP_SHIFT                                          (16u)
#define PRR_AXIRERRST1_DRPRRESP                                                (0x000C0000u)
#define PRR_AXIRERRST1_DRPRRESP_SHIFT                                          (18u)
#define PRR_AXIRERRST1_NANDBRESP                                               (0x00300000u)
#define PRR_AXIRERRST1_NANDBRESP_SHIFT                                         (20u)
#define PRR_AXIRERRST1_NANDRRESP                                               (0x00C00000u)
#define PRR_AXIRERRST1_NANDRRESP_SHIFT                                         (22u)
#define PRR_AXIRERRST1_SDMMC1BRESP                                             (0x03000000u)
#define PRR_AXIRERRST1_SDMMC1BRESP_SHIFT                                       (24u)
#define PRR_AXIRERRST1_SDMMC1RRESP                                             (0x0C000000u)
#define PRR_AXIRERRST1_SDMMC1RRESP_SHIFT                                       (26u)
#define PRR_AXIRERRST1_SDMMC0BRESP                                             (0x30000000u)
#define PRR_AXIRERRST1_SDMMC0BRESP_SHIFT                                       (28u)
#define PRR_AXIRERRST1_SDMMC0RRESP                                             (0xC0000000u)
#define PRR_AXIRERRST1_SDMMC0RRESP_SHIFT                                       (30u)
#define PRR_AXIRERRST2_VDC604RRESP                                             (0x000C0000u)
#define PRR_AXIRERRST2_VDC604RRESP_SHIFT                                       (18u)
#define PRR_AXIRERRST2_VDC602RRESP                                             (0x0C000000u)
#define PRR_AXIRERRST2_VDC602RRESP_SHIFT                                       (26u)
#define PRR_AXIRERRST2_VDC601BRESP                                             (0x30000000u)
#define PRR_AXIRERRST2_VDC601BRESP_SHIFT                                       (28u)
#define PRR_AXIRERRST2_VDC601RRESP                                             (0xC0000000u)
#define PRR_AXIRERRST2_VDC601RRESP_SHIFT                                       (30u)
#define PRR_AXIRERRCLR0_CEUBRESPCLR                                            (0x00000100u)
#define PRR_AXIRERRCLR0_CEUBRESPCLR_SHIFT                                      (8u)
#define PRR_AXIRERRCLR0_SERBRESPCLR                                            (0x00001000u)
#define PRR_AXIRERRCLR0_SERBRESPCLR_SHIFT                                      (12u)
#define PRR_AXIRERRCLR0_SERRRESPCLR                                            (0x00004000u)
#define PRR_AXIRERRCLR0_SERRRESPCLR_SHIFT                                      (14u)
#define PRR_AXIRERRCLR0_VINBRESPCLR                                            (0x00010000u)
#define PRR_AXIRERRCLR0_VINBRESPCLR_SHIFT                                      (16u)
#define PRR_AXIRERRCLR0_IMR20BRESPCLR                                          (0x00100000u)
#define PRR_AXIRERRCLR0_IMR20BRESPCLR_SHIFT                                    (20u)
#define PRR_AXIRERRCLR0_IMR20RRESPCLR                                          (0x00400000u)
#define PRR_AXIRERRCLR0_IMR20RRESPCLR_SHIFT                                    (22u)
#define PRR_AXIRERRCLR0_JCUBRESPCLR                                            (0x10000000u)
#define PRR_AXIRERRCLR0_JCUBRESPCLR_SHIFT                                      (28u)
#define PRR_AXIRERRCLR0_JCURRESPCLR                                            (0x40000000u)
#define PRR_AXIRERRCLR0_JCURRESPCLR_SHIFT                                      (30u)
#define PRR_AXIRERRCLR1_DRPBRESPCLR                                            (0x00010000u)
#define PRR_AXIRERRCLR1_DRPBRESPCLR_SHIFT                                      (16u)
#define PRR_AXIRERRCLR1_DRPRRESPCLR                                            (0x00040000u)
#define PRR_AXIRERRCLR1_DRPRRESPCLR_SHIFT                                      (18u)
#define PRR_AXIRERRCLR1_NANDBRESPCLR                                           (0x00100000u)
#define PRR_AXIRERRCLR1_NANDBRESPCLR_SHIFT                                     (20u)
#define PRR_AXIRERRCLR1_NANDRRESPCLR                                           (0x00400000u)
#define PRR_AXIRERRCLR1_NANDRRESPCLR_SHIFT                                     (22u)
#define PRR_AXIRERRCLR1_SDMMC1BRESPCLR                                         (0x01000000u)
#define PRR_AXIRERRCLR1_SDMMC1BRESPCLR_SHIFT                                   (24u)
#define PRR_AXIRERRCLR1_SDMMC1RRESPCLR                                         (0x04000000u)
#define PRR_AXIRERRCLR1_SDMMC1RRESPCLR_SHIFT                                   (26u)
#define PRR_AXIRERRCLR1_SDMMC0BRESPCLR                                         (0x10000000u)
#define PRR_AXIRERRCLR1_SDMMC0BRESPCLR_SHIFT                                   (28u)
#define PRR_AXIRERRCLR1_SDMMC0RRESPCLR                                         (0x40000000u)
#define PRR_AXIRERRCLR1_SDMMC0RRESPCLR_SHIFT                                   (30u)
#define PRR_AXIRERRCLR2_VDC604RRESPCLR                                         (0x00040000u)
#define PRR_AXIRERRCLR2_VDC604RRESPCLR_SHIFT                                   (18u)
#define PRR_AXIRERRCLR2_VDC602RRESPCLR                                         (0x04000000u)
#define PRR_AXIRERRCLR2_VDC602RRESPCLR_SHIFT                                   (26u)
#define PRR_AXIRERRCLR2_VDC601BRESPCLR                                         (0x10000000u)
#define PRR_AXIRERRCLR2_VDC601BRESPCLR_SHIFT                                   (28u)
#define PRR_AXIRERRCLR2_VDC601RRESPCLR                                         (0x40000000u)
#define PRR_AXIRERRCLR2_VDC601RRESPCLR_SHIFT                                   (30u)
#define PRR_MSTACCCTL0_VINAWNS                                                 (0x00000002u)
#define PRR_MSTACCCTL0_VINAWNS_SHIFT                                           (1u)
#define PRR_MSTACCCTL0_IMR20AWNS                                               (0x00000200u)
#define PRR_MSTACCCTL0_IMR20AWNS_SHIFT                                         (9u)
#define PRR_MSTACCCTL0_IMR20ARNS                                               (0x00002000u)
#define PRR_MSTACCCTL0_IMR20ARNS_SHIFT                                         (13u)
#define PRR_MSTACCCTL0_ETHAxNS                                                 (0x00020000u)
#define PRR_MSTACCCTL0_ETHAxNS_SHIFT                                           (17u)
#define PRR_MSTACCCTL0_JCUAWNS                                                 (0x02000000u)
#define PRR_MSTACCCTL0_JCUAWNS_SHIFT                                           (25u)
#define PRR_MSTACCCTL0_JCUARNS                                                 (0x20000000u)
#define PRR_MSTACCCTL0_JCUARNS_SHIFT                                           (29u)
#define PRR_MSTACCCTL1_SDMMC1AWNS                                              (0x00000002u)
#define PRR_MSTACCCTL1_SDMMC1AWNS_SHIFT                                        (1u)
#define PRR_MSTACCCTL1_SDMMC1ARNS                                              (0x00000020u)
#define PRR_MSTACCCTL1_SDMMC1ARNS_SHIFT                                        (5u)
#define PRR_MSTACCCTL1_SDMMC0AWNS                                              (0x00000200u)
#define PRR_MSTACCCTL1_SDMMC0AWNS_SHIFT                                        (9u)
#define PRR_MSTACCCTL1_SDMMC0ARNS                                              (0x00002000u)
#define PRR_MSTACCCTL1_SDMMC0ARNS_SHIFT                                        (13u)
#define PRR_MSTACCCTL1_CEUAWNS                                                 (0x00020000u)
#define PRR_MSTACCCTL1_CEUAWNS_SHIFT                                           (17u)
#define PRR_MSTACCCTL2_D2D1AxNS                                                (0x00000002u)
#define PRR_MSTACCCTL2_D2D1AxNS_SHIFT                                          (1u)
#define PRR_MSTACCCTL2_D2D0AxNS                                                (0x00000200u)
#define PRR_MSTACCCTL2_D2D0AxNS_SHIFT                                          (9u)
#define PRR_MSTACCCTL2_DRPAWNS                                                 (0x00020000u)
#define PRR_MSTACCCTL2_DRPAWNS_SHIFT                                           (17u)
#define PRR_MSTACCCTL2_DRPARNS                                                 (0x00200000u)
#define PRR_MSTACCCTL2_DRPARNS_SHIFT                                           (21u)
#define PRR_MSTACCCTL2_NANDAWNS                                                (0x02000000u)
#define PRR_MSTACCCTL2_NANDAWNS_SHIFT                                          (25u)
#define PRR_MSTACCCTL2_NANDARNS                                                (0x20000000u)
#define PRR_MSTACCCTL2_NANDARNS_SHIFT                                          (29u)
#define PRR_MSTACCCTL3_VDC604ARNS                                              (0x00000020u)
#define PRR_MSTACCCTL3_VDC604ARNS_SHIFT                                        (5u)
#define PRR_MSTACCCTL3_VDC602ARNS                                              (0x00200000u)
#define PRR_MSTACCCTL3_VDC602ARNS_SHIFT                                        (21u)
#define PRR_MSTACCCTL3_VDC601AWNS                                              (0x02000000u)
#define PRR_MSTACCCTL3_VDC601AWNS_SHIFT                                        (25u)
#define PRR_MSTACCCTL3_VDC601ARNS                                              (0x20000000u)
#define PRR_MSTACCCTL3_VDC601ARNS_SHIFT                                        (29u)
#define PRR_MSTACCCTL4_USB11AxNS                                               (0x00000002u)
#define PRR_MSTACCCTL4_USB11AxNS_SHIFT                                         (1u)
#define PRR_MSTACCCTL4_USB10AxNS                                               (0x00000200u)
#define PRR_MSTACCCTL4_USB10AxNS_SHIFT                                         (9u)
#define PRR_MSTACCCTL4_USB01AxNS                                               (0x00020000u)
#define PRR_MSTACCCTL4_USB01AxNS_SHIFT                                         (17u)
#define PRR_MSTACCCTL4_USB00AxNS                                               (0x02000000u)
#define PRR_MSTACCCTL4_USB00AxNS_SHIFT                                         (25u)
#define PRR_SLVACCCTL0_WDTNS                                                   (0x00000010u)
#define PRR_SLVACCCTL0_WDTNS_SHIFT                                             (4u)
#define PRR_SLVACCCTL0_INTC2NS                                                 (0x00000040u)
#define PRR_SLVACCCTL0_INTC2NS_SHIFT                                           (6u)
#define PRR_SLVACCCTL0_POEGNS                                                  (0x00004000u)
#define PRR_SLVACCCTL0_POEGNS_SHIFT                                            (14u)
#define PRR_SLVACCCTL0_POE3NS                                                  (0x00010000u)
#define PRR_SLVACCCTL0_POE3NS_SHIFT                                            (16u)
#define PRR_SLVACCCTL0_GPTNS                                                   (0x00040000u)
#define PRR_SLVACCCTL0_GPTNS_SHIFT                                             (18u)
#define PRR_SLVACCCTL0_MTU3NS                                                  (0x00100000u)
#define PRR_SLVACCCTL0_MTU3NS_SHIFT                                            (20u)
#define PRR_SLVACCCTL0_IMR20NS                                                 (0x00400000u)
#define PRR_SLVACCCTL0_IMR20NS_SHIFT                                           (22u)
#define PRR_SLVACCCTL0_VDC60NS                                                 (0x01000000u)
#define PRR_SLVACCCTL0_VDC60NS_SHIFT                                           (24u)
#define PRR_SLVACCCTL0_SYSNS                                                   (0x40000000u)
#define PRR_SLVACCCTL0_SYSNS_SHIFT                                             (30u)
#define PRR_SLVACCCTL1_RSPINS                                                  (0x00000001u)
#define PRR_SLVACCCTL1_RSPINS_SHIFT                                            (0u)
#define PRR_SLVACCCTL1_JCUNS                                                   (0x00000004u)
#define PRR_SLVACCCTL1_JCUNS_SHIFT                                             (2u)
#define PRR_SLVACCCTL1_SCIFNS                                                  (0x00000010u)
#define PRR_SLVACCCTL1_SCIFNS_SHIFT                                            (4u)
#define PRR_SLVACCCTL1_SCINS                                                   (0x00000040u)
#define PRR_SLVACCCTL1_SCINS_SHIFT                                             (6u)
#define PRR_SLVACCCTL1_IRDANS                                                  (0x00000100u)
#define PRR_SLVACCCTL1_IRDANS_SHIFT                                            (8u)
#define PRR_SLVACCCTL1_ADNS                                                    (0x00000400u)
#define PRR_SLVACCCTL1_ADNS_SHIFT                                              (10u)
#define PRR_SLVACCCTL1_SENS                                                    (0x00004000u)
#define PRR_SLVACCCTL1_SENS_SHIFT                                              (14u)
#define PRR_SLVACCCTL1_RCANNS                                                  (0x00010000u)
#define PRR_SLVACCCTL1_RCANNS_SHIFT                                            (16u)
#define PRR_SLVACCCTL1_SPDIFNS                                                 (0x00040000u)
#define PRR_SLVACCCTL1_SPDIFNS_SHIFT                                           (18u)
#define PRR_SLVACCCTL1_SSIFNS                                                  (0x00100000u)
#define PRR_SLVACCCTL1_SSIFNS_SHIFT                                            (20u)
#define PRR_SLVACCCTL1_OSTM2NS                                                 (0x00400000u)
#define PRR_SLVACCCTL1_OSTM2NS_SHIFT                                           (22u)
#define PRR_SLVACCCTL1_OSTM1NS                                                 (0x01000000u)
#define PRR_SLVACCCTL1_OSTM1NS_SHIFT                                           (24u)
#define PRR_SLVACCCTL1_OSTM0NS                                                 (0x04000000u)
#define PRR_SLVACCCTL1_OSTM0NS_SHIFT                                           (26u)
#define PRR_SLVACCCTL1_I2CNS                                                   (0x10000000u)
#define PRR_SLVACCCTL1_I2CNS_SHIFT                                             (28u)
#define PRR_SLVACCCTL1_GPIONS                                                  (0x40000000u)
#define PRR_SLVACCCTL1_GPIONS_SHIFT                                            (30u)
#define PRR_SLVACCCTL2_TSIPNS                                                  (0x00000004u)
#define PRR_SLVACCCTL2_TSIPNS_SHIFT                                            (2u)
#define PRR_SLVACCCTL2_DRPNS                                                   (0x00000010u)
#define PRR_SLVACCCTL2_DRPNS_SHIFT                                             (4u)
#define PRR_SLVACCCTL2_CEUNS                                                   (0x00000040u)
#define PRR_SLVACCCTL2_CEUNS_SHIFT                                             (6u)
#define PRR_SLVACCCTL2_USB11NS                                                 (0x00000100u)
#define PRR_SLVACCCTL2_USB11NS_SHIFT                                           (8u)
#define PRR_SLVACCCTL2_USB10NS                                                 (0x00000400u)
#define PRR_SLVACCCTL2_USB10NS_SHIFT                                           (10u)
#define PRR_SLVACCCTL2_USB01NS                                                 (0x00001000u)
#define PRR_SLVACCCTL2_USB01NS_SHIFT                                           (12u)
#define PRR_SLVACCCTL2_USB00NS                                                 (0x00004000u)
#define PRR_SLVACCCTL2_USB00NS_SHIFT                                           (14u)
#define PRR_SLVACCCTL2_VINNS                                                   (0x00400000u)
#define PRR_SLVACCCTL2_VINNS_SHIFT                                             (22u)
#define PRR_SLVACCCTL2_MIPINS                                                  (0x01000000u)
#define PRR_SLVACCCTL2_MIPINS_SHIFT                                            (24u)
#define PRR_SLVACCCTL2_D2DNS                                                   (0x04000000u)
#define PRR_SLVACCCTL2_D2DNS_SHIFT                                             (26u)
#define PRR_SLVACCCTL2_ETHNS                                                   (0x40000000u)
#define PRR_SLVACCCTL2_ETHNS_SHIFT                                             (30u)
#define PRR_SLVACCCTL3_CSNS                                                    (0x00100000u)
#define PRR_SLVACCCTL3_CSNS_SHIFT                                              (20u)
#define PRR_SLVACCCTL3_NANDNS                                                  (0x01000000u)
#define PRR_SLVACCCTL3_NANDNS_SHIFT                                            (24u)
#define PRR_SLVACCCTL3_SDMMC1NS                                                (0x04000000u)
#define PRR_SLVACCCTL3_SDMMC1NS_SHIFT                                          (26u)
#define PRR_SLVACCCTL3_SDMMC0NS                                                (0x10000000u)
#define PRR_SLVACCCTL3_SDMMC0NS_SHIFT                                          (28u)
#define PRR_SLVACCCTL4_VRAM4NS                                                 (0x00000100u)
#define PRR_SLVACCCTL4_VRAM4NS_SHIFT                                           (8u)
#define PRR_SLVACCCTL4_VRAM3NS                                                 (0x00000400u)
#define PRR_SLVACCCTL4_VRAM3NS_SHIFT                                           (10u)
#define PRR_SLVACCCTL4_VRAM2NS                                                 (0x00001000u)
#define PRR_SLVACCCTL4_VRAM2NS_SHIFT                                           (12u)
#define PRR_SLVACCCTL4_VRAM1NS                                                 (0x00004000u)
#define PRR_SLVACCCTL4_VRAM1NS_SHIFT                                           (14u)
#define PRR_SLVACCCTL4_VRAM0NS                                                 (0x00010000u)
#define PRR_SLVACCCTL4_VRAM0NS_SHIFT                                           (16u)
#define PRR_SLVACCCTL4_RRAMNS                                                  (0x00040000u)
#define PRR_SLVACCCTL4_RRAMNS_SHIFT                                            (18u)
#define PRR_SLVACCCTL4_HYPRNS                                                  (0x00100000u)
#define PRR_SLVACCCTL4_HYPRNS_SHIFT                                            (20u)
#define PRR_SLVACCCTL4_HYPNS                                                   (0x00400000u)
#define PRR_SLVACCCTL4_HYPNS_SHIFT                                             (22u)
#define PRR_SLVACCCTL4_OCTARNS                                                 (0x01000000u)
#define PRR_SLVACCCTL4_OCTARNS_SHIFT                                           (24u)
#define PRR_SLVACCCTL4_OCTANS                                                  (0x04000000u)
#define PRR_SLVACCCTL4_OCTANS_SHIFT                                            (26u)
#define PRR_SLVACCCTL4_SPINS                                                   (0x10000000u)
#define PRR_SLVACCCTL4_SPINS_SHIFT                                             (28u)
#define PRR_SLVACCCTL4_BSCNS                                                   (0x40000000u)
#define PRR_SLVACCCTL4_BSCNS_SHIFT                                             (30u)

#endif
