/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef RCAN_IOBITMASK_H
#define RCAN_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define RCAN_RSCAN0C0CFG_BRP                                                   (0x000003FFu)
#define RCAN_RSCAN0C0CFG_BRP_SHIFT                                             (0u)
#define RCAN_RSCAN0C0CFG_TSEG1                                                 (0x000F0000u)
#define RCAN_RSCAN0C0CFG_TSEG1_SHIFT                                           (16u)
#define RCAN_RSCAN0C0CFG_TSEG2                                                 (0x00700000u)
#define RCAN_RSCAN0C0CFG_TSEG2_SHIFT                                           (20u)
#define RCAN_RSCAN0C0CFG_SJW                                                   (0x03000000u)
#define RCAN_RSCAN0C0CFG_SJW_SHIFT                                             (24u)
#define RCAN_RSCAN0C0CTR_CHMDC                                                 (0x00000003u)
#define RCAN_RSCAN0C0CTR_CHMDC_SHIFT                                           (0u)
#define RCAN_RSCAN0C0CTR_CSLPR                                                 (0x00000004u)
#define RCAN_RSCAN0C0CTR_CSLPR_SHIFT                                           (2u)
#define RCAN_RSCAN0C0CTR_RTBO                                                  (0x00000008u)
#define RCAN_RSCAN0C0CTR_RTBO_SHIFT                                            (3u)
#define RCAN_RSCAN0C0CTR_BEIE                                                  (0x00000100u)
#define RCAN_RSCAN0C0CTR_BEIE_SHIFT                                            (8u)
#define RCAN_RSCAN0C0CTR_EWIE                                                  (0x00000200u)
#define RCAN_RSCAN0C0CTR_EWIE_SHIFT                                            (9u)
#define RCAN_RSCAN0C0CTR_EPIE                                                  (0x00000400u)
#define RCAN_RSCAN0C0CTR_EPIE_SHIFT                                            (10u)
#define RCAN_RSCAN0C0CTR_BOEIE                                                 (0x00000800u)
#define RCAN_RSCAN0C0CTR_BOEIE_SHIFT                                           (11u)
#define RCAN_RSCAN0C0CTR_BORIE                                                 (0x00001000u)
#define RCAN_RSCAN0C0CTR_BORIE_SHIFT                                           (12u)
#define RCAN_RSCAN0C0CTR_OLIE                                                  (0x00002000u)
#define RCAN_RSCAN0C0CTR_OLIE_SHIFT                                            (13u)
#define RCAN_RSCAN0C0CTR_BLIE                                                  (0x00004000u)
#define RCAN_RSCAN0C0CTR_BLIE_SHIFT                                            (14u)
#define RCAN_RSCAN0C0CTR_ALIE                                                  (0x00008000u)
#define RCAN_RSCAN0C0CTR_ALIE_SHIFT                                            (15u)
#define RCAN_RSCAN0C0CTR_TAIE                                                  (0x00010000u)
#define RCAN_RSCAN0C0CTR_TAIE_SHIFT                                            (16u)
#define RCAN_RSCAN0C0CTR_BOM                                                   (0x00600000u)
#define RCAN_RSCAN0C0CTR_BOM_SHIFT                                             (21u)
#define RCAN_RSCAN0C0CTR_ERRD                                                  (0x00800000u)
#define RCAN_RSCAN0C0CTR_ERRD_SHIFT                                            (23u)
#define RCAN_RSCAN0C0CTR_CTME                                                  (0x01000000u)
#define RCAN_RSCAN0C0CTR_CTME_SHIFT                                            (24u)
#define RCAN_RSCAN0C0CTR_CTMS                                                  (0x06000000u)
#define RCAN_RSCAN0C0CTR_CTMS_SHIFT                                            (25u)
#define RCAN_RSCAN0C0CTR_CRCT                                                  (0x40000000u)
#define RCAN_RSCAN0C0CTR_CRCT_SHIFT                                            (30u)
#define RCAN_RSCAN0C0STS_CRSTSTS                                               (0x00000001u)
#define RCAN_RSCAN0C0STS_CRSTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0C0STS_CHLTSTS                                               (0x00000002u)
#define RCAN_RSCAN0C0STS_CHLTSTS_SHIFT                                         (1u)
#define RCAN_RSCAN0C0STS_CSLPSTS                                               (0x00000004u)
#define RCAN_RSCAN0C0STS_CSLPSTS_SHIFT                                         (2u)
#define RCAN_RSCAN0C0STS_EPSTS                                                 (0x00000008u)
#define RCAN_RSCAN0C0STS_EPSTS_SHIFT                                           (3u)
#define RCAN_RSCAN0C0STS_BOSTS                                                 (0x00000010u)
#define RCAN_RSCAN0C0STS_BOSTS_SHIFT                                           (4u)
#define RCAN_RSCAN0C0STS_TRMSTS                                                (0x00000020u)
#define RCAN_RSCAN0C0STS_TRMSTS_SHIFT                                          (5u)
#define RCAN_RSCAN0C0STS_RECSTS                                                (0x00000040u)
#define RCAN_RSCAN0C0STS_RECSTS_SHIFT                                          (6u)
#define RCAN_RSCAN0C0STS_COMSTS                                                (0x00000080u)
#define RCAN_RSCAN0C0STS_COMSTS_SHIFT                                          (7u)
#define RCAN_RSCAN0C0STS_REC                                                   (0x00FF0000u)
#define RCAN_RSCAN0C0STS_REC_SHIFT                                             (16u)
#define RCAN_RSCAN0C0STS_TEC                                                   (0xFF000000u)
#define RCAN_RSCAN0C0STS_TEC_SHIFT                                             (24u)
#define RCAN_RSCAN0C0ERFL_BEF                                                  (0x00000001u)
#define RCAN_RSCAN0C0ERFL_BEF_SHIFT                                            (0u)
#define RCAN_RSCAN0C0ERFL_EWF                                                  (0x00000002u)
#define RCAN_RSCAN0C0ERFL_EWF_SHIFT                                            (1u)
#define RCAN_RSCAN0C0ERFL_EPF                                                  (0x00000004u)
#define RCAN_RSCAN0C0ERFL_EPF_SHIFT                                            (2u)
#define RCAN_RSCAN0C0ERFL_BOEF                                                 (0x00000008u)
#define RCAN_RSCAN0C0ERFL_BOEF_SHIFT                                           (3u)
#define RCAN_RSCAN0C0ERFL_BORF                                                 (0x00000010u)
#define RCAN_RSCAN0C0ERFL_BORF_SHIFT                                           (4u)
#define RCAN_RSCAN0C0ERFL_OVLF                                                 (0x00000020u)
#define RCAN_RSCAN0C0ERFL_OVLF_SHIFT                                           (5u)
#define RCAN_RSCAN0C0ERFL_BLF                                                  (0x00000040u)
#define RCAN_RSCAN0C0ERFL_BLF_SHIFT                                            (6u)
#define RCAN_RSCAN0C0ERFL_ALF                                                  (0x00000080u)
#define RCAN_RSCAN0C0ERFL_ALF_SHIFT                                            (7u)
#define RCAN_RSCAN0C0ERFL_SERR                                                 (0x00000100u)
#define RCAN_RSCAN0C0ERFL_SERR_SHIFT                                           (8u)
#define RCAN_RSCAN0C0ERFL_FERR                                                 (0x00000200u)
#define RCAN_RSCAN0C0ERFL_FERR_SHIFT                                           (9u)
#define RCAN_RSCAN0C0ERFL_AERR                                                 (0x00000400u)
#define RCAN_RSCAN0C0ERFL_AERR_SHIFT                                           (10u)
#define RCAN_RSCAN0C0ERFL_CERR                                                 (0x00000800u)
#define RCAN_RSCAN0C0ERFL_CERR_SHIFT                                           (11u)
#define RCAN_RSCAN0C0ERFL_B1ERR                                                (0x00001000u)
#define RCAN_RSCAN0C0ERFL_B1ERR_SHIFT                                          (12u)
#define RCAN_RSCAN0C0ERFL_B0ERR                                                (0x00002000u)
#define RCAN_RSCAN0C0ERFL_B0ERR_SHIFT                                          (13u)
#define RCAN_RSCAN0C0ERFL_ADERR                                                (0x00004000u)
#define RCAN_RSCAN0C0ERFL_ADERR_SHIFT                                          (14u)
#define RCAN_RSCAN0C0ERFL_CRCREG                                               (0x7FFF0000u)
#define RCAN_RSCAN0C0ERFL_CRCREG_SHIFT                                         (16u)
#define RCAN_RSCAN0C1CFG_BRP                                                   (0x000003FFu)
#define RCAN_RSCAN0C1CFG_BRP_SHIFT                                             (0u)
#define RCAN_RSCAN0C1CFG_TSEG1                                                 (0x000F0000u)
#define RCAN_RSCAN0C1CFG_TSEG1_SHIFT                                           (16u)
#define RCAN_RSCAN0C1CFG_TSEG2                                                 (0x00700000u)
#define RCAN_RSCAN0C1CFG_TSEG2_SHIFT                                           (20u)
#define RCAN_RSCAN0C1CFG_SJW                                                   (0x03000000u)
#define RCAN_RSCAN0C1CFG_SJW_SHIFT                                             (24u)
#define RCAN_RSCAN0C1CTR_CHMDC                                                 (0x00000003u)
#define RCAN_RSCAN0C1CTR_CHMDC_SHIFT                                           (0u)
#define RCAN_RSCAN0C1CTR_CSLPR                                                 (0x00000004u)
#define RCAN_RSCAN0C1CTR_CSLPR_SHIFT                                           (2u)
#define RCAN_RSCAN0C1CTR_RTBO                                                  (0x00000008u)
#define RCAN_RSCAN0C1CTR_RTBO_SHIFT                                            (3u)
#define RCAN_RSCAN0C1CTR_BEIE                                                  (0x00000100u)
#define RCAN_RSCAN0C1CTR_BEIE_SHIFT                                            (8u)
#define RCAN_RSCAN0C1CTR_EWIE                                                  (0x00000200u)
#define RCAN_RSCAN0C1CTR_EWIE_SHIFT                                            (9u)
#define RCAN_RSCAN0C1CTR_EPIE                                                  (0x00000400u)
#define RCAN_RSCAN0C1CTR_EPIE_SHIFT                                            (10u)
#define RCAN_RSCAN0C1CTR_BOEIE                                                 (0x00000800u)
#define RCAN_RSCAN0C1CTR_BOEIE_SHIFT                                           (11u)
#define RCAN_RSCAN0C1CTR_BORIE                                                 (0x00001000u)
#define RCAN_RSCAN0C1CTR_BORIE_SHIFT                                           (12u)
#define RCAN_RSCAN0C1CTR_OLIE                                                  (0x00002000u)
#define RCAN_RSCAN0C1CTR_OLIE_SHIFT                                            (13u)
#define RCAN_RSCAN0C1CTR_BLIE                                                  (0x00004000u)
#define RCAN_RSCAN0C1CTR_BLIE_SHIFT                                            (14u)
#define RCAN_RSCAN0C1CTR_ALIE                                                  (0x00008000u)
#define RCAN_RSCAN0C1CTR_ALIE_SHIFT                                            (15u)
#define RCAN_RSCAN0C1CTR_TAIE                                                  (0x00010000u)
#define RCAN_RSCAN0C1CTR_TAIE_SHIFT                                            (16u)
#define RCAN_RSCAN0C1CTR_BOM                                                   (0x00600000u)
#define RCAN_RSCAN0C1CTR_BOM_SHIFT                                             (21u)
#define RCAN_RSCAN0C1CTR_ERRD                                                  (0x00800000u)
#define RCAN_RSCAN0C1CTR_ERRD_SHIFT                                            (23u)
#define RCAN_RSCAN0C1CTR_CTME                                                  (0x01000000u)
#define RCAN_RSCAN0C1CTR_CTME_SHIFT                                            (24u)
#define RCAN_RSCAN0C1CTR_CTMS                                                  (0x06000000u)
#define RCAN_RSCAN0C1CTR_CTMS_SHIFT                                            (25u)
#define RCAN_RSCAN0C1CTR_CRCT                                                  (0x40000000u)
#define RCAN_RSCAN0C1CTR_CRCT_SHIFT                                            (30u)
#define RCAN_RSCAN0C1STS_CRSTSTS                                               (0x00000001u)
#define RCAN_RSCAN0C1STS_CRSTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0C1STS_CHLTSTS                                               (0x00000002u)
#define RCAN_RSCAN0C1STS_CHLTSTS_SHIFT                                         (1u)
#define RCAN_RSCAN0C1STS_CSLPSTS                                               (0x00000004u)
#define RCAN_RSCAN0C1STS_CSLPSTS_SHIFT                                         (2u)
#define RCAN_RSCAN0C1STS_EPSTS                                                 (0x00000008u)
#define RCAN_RSCAN0C1STS_EPSTS_SHIFT                                           (3u)
#define RCAN_RSCAN0C1STS_BOSTS                                                 (0x00000010u)
#define RCAN_RSCAN0C1STS_BOSTS_SHIFT                                           (4u)
#define RCAN_RSCAN0C1STS_TRMSTS                                                (0x00000020u)
#define RCAN_RSCAN0C1STS_TRMSTS_SHIFT                                          (5u)
#define RCAN_RSCAN0C1STS_RECSTS                                                (0x00000040u)
#define RCAN_RSCAN0C1STS_RECSTS_SHIFT                                          (6u)
#define RCAN_RSCAN0C1STS_COMSTS                                                (0x00000080u)
#define RCAN_RSCAN0C1STS_COMSTS_SHIFT                                          (7u)
#define RCAN_RSCAN0C1STS_REC                                                   (0x00FF0000u)
#define RCAN_RSCAN0C1STS_REC_SHIFT                                             (16u)
#define RCAN_RSCAN0C1STS_TEC                                                   (0xFF000000u)
#define RCAN_RSCAN0C1STS_TEC_SHIFT                                             (24u)
#define RCAN_RSCAN0C1ERFL_BEF                                                  (0x00000001u)
#define RCAN_RSCAN0C1ERFL_BEF_SHIFT                                            (0u)
#define RCAN_RSCAN0C1ERFL_EWF                                                  (0x00000002u)
#define RCAN_RSCAN0C1ERFL_EWF_SHIFT                                            (1u)
#define RCAN_RSCAN0C1ERFL_EPF                                                  (0x00000004u)
#define RCAN_RSCAN0C1ERFL_EPF_SHIFT                                            (2u)
#define RCAN_RSCAN0C1ERFL_BOEF                                                 (0x00000008u)
#define RCAN_RSCAN0C1ERFL_BOEF_SHIFT                                           (3u)
#define RCAN_RSCAN0C1ERFL_BORF                                                 (0x00000010u)
#define RCAN_RSCAN0C1ERFL_BORF_SHIFT                                           (4u)
#define RCAN_RSCAN0C1ERFL_OVLF                                                 (0x00000020u)
#define RCAN_RSCAN0C1ERFL_OVLF_SHIFT                                           (5u)
#define RCAN_RSCAN0C1ERFL_BLF                                                  (0x00000040u)
#define RCAN_RSCAN0C1ERFL_BLF_SHIFT                                            (6u)
#define RCAN_RSCAN0C1ERFL_ALF                                                  (0x00000080u)
#define RCAN_RSCAN0C1ERFL_ALF_SHIFT                                            (7u)
#define RCAN_RSCAN0C1ERFL_SERR                                                 (0x00000100u)
#define RCAN_RSCAN0C1ERFL_SERR_SHIFT                                           (8u)
#define RCAN_RSCAN0C1ERFL_FERR                                                 (0x00000200u)
#define RCAN_RSCAN0C1ERFL_FERR_SHIFT                                           (9u)
#define RCAN_RSCAN0C1ERFL_AERR                                                 (0x00000400u)
#define RCAN_RSCAN0C1ERFL_AERR_SHIFT                                           (10u)
#define RCAN_RSCAN0C1ERFL_CERR                                                 (0x00000800u)
#define RCAN_RSCAN0C1ERFL_CERR_SHIFT                                           (11u)
#define RCAN_RSCAN0C1ERFL_B1ERR                                                (0x00001000u)
#define RCAN_RSCAN0C1ERFL_B1ERR_SHIFT                                          (12u)
#define RCAN_RSCAN0C1ERFL_B0ERR                                                (0x00002000u)
#define RCAN_RSCAN0C1ERFL_B0ERR_SHIFT                                          (13u)
#define RCAN_RSCAN0C1ERFL_ADERR                                                (0x00004000u)
#define RCAN_RSCAN0C1ERFL_ADERR_SHIFT                                          (14u)
#define RCAN_RSCAN0C1ERFL_CRCREG                                               (0x7FFF0000u)
#define RCAN_RSCAN0C1ERFL_CRCREG_SHIFT                                         (16u)
#define RCAN_RSCAN0GCFG_TPRI                                                   (0x00000001u)
#define RCAN_RSCAN0GCFG_TPRI_SHIFT                                             (0u)
#define RCAN_RSCAN0GCFG_DCE                                                    (0x00000002u)
#define RCAN_RSCAN0GCFG_DCE_SHIFT                                              (1u)
#define RCAN_RSCAN0GCFG_DRE                                                    (0x00000004u)
#define RCAN_RSCAN0GCFG_DRE_SHIFT                                              (2u)
#define RCAN_RSCAN0GCFG_MME                                                    (0x00000008u)
#define RCAN_RSCAN0GCFG_MME_SHIFT                                              (3u)
#define RCAN_RSCAN0GCFG_DCS                                                    (0x00000010u)
#define RCAN_RSCAN0GCFG_DCS_SHIFT                                              (4u)
#define RCAN_RSCAN0GCFG_TMTSCE                                                 (0x00000080u)
#define RCAN_RSCAN0GCFG_TMTSCE_SHIFT                                           (7u)
#define RCAN_RSCAN0GCFG_TSP                                                    (0x00000F00u)
#define RCAN_RSCAN0GCFG_TSP_SHIFT                                              (8u)
#define RCAN_RSCAN0GCFG_TSSS                                                   (0x00001000u)
#define RCAN_RSCAN0GCFG_TSSS_SHIFT                                             (12u)
#define RCAN_RSCAN0GCFG_TSBTCS                                                 (0x0000E000u)
#define RCAN_RSCAN0GCFG_TSBTCS_SHIFT                                           (13u)
#define RCAN_RSCAN0GCFG_ITRCP                                                  (0xFFFF0000u)
#define RCAN_RSCAN0GCFG_ITRCP_SHIFT                                            (16u)
#define RCAN_RSCAN0GCTR_GMDC                                                   (0x00000003u)
#define RCAN_RSCAN0GCTR_GMDC_SHIFT                                             (0u)
#define RCAN_RSCAN0GCTR_GSLPR                                                  (0x00000004u)
#define RCAN_RSCAN0GCTR_GSLPR_SHIFT                                            (2u)
#define RCAN_RSCAN0GCTR_DEIE                                                   (0x00000100u)
#define RCAN_RSCAN0GCTR_DEIE_SHIFT                                             (8u)
#define RCAN_RSCAN0GCTR_MEIE                                                   (0x00000200u)
#define RCAN_RSCAN0GCTR_MEIE_SHIFT                                             (9u)
#define RCAN_RSCAN0GCTR_THLEIE                                                 (0x00000400u)
#define RCAN_RSCAN0GCTR_THLEIE_SHIFT                                           (10u)
#define RCAN_RSCAN0GCTR_TSRST                                                  (0x00010000u)
#define RCAN_RSCAN0GCTR_TSRST_SHIFT                                            (16u)
#define RCAN_RSCAN0GSTS_GRSTSTS                                                (0x00000001u)
#define RCAN_RSCAN0GSTS_GRSTSTS_SHIFT                                          (0u)
#define RCAN_RSCAN0GSTS_GHLTSTS                                                (0x00000002u)
#define RCAN_RSCAN0GSTS_GHLTSTS_SHIFT                                          (1u)
#define RCAN_RSCAN0GSTS_GSLPSTS                                                (0x00000004u)
#define RCAN_RSCAN0GSTS_GSLPSTS_SHIFT                                          (2u)
#define RCAN_RSCAN0GSTS_GRAMINIT                                               (0x00000008u)
#define RCAN_RSCAN0GSTS_GRAMINIT_SHIFT                                         (3u)
#define RCAN_RSCAN0GERFL_DEF                                                   (0x00000001u)
#define RCAN_RSCAN0GERFL_DEF_SHIFT                                             (0u)
#define RCAN_RSCAN0GERFL_MES                                                   (0x00000002u)
#define RCAN_RSCAN0GERFL_MES_SHIFT                                             (1u)
#define RCAN_RSCAN0GERFL_THLES                                                 (0x00000004u)
#define RCAN_RSCAN0GERFL_THLES_SHIFT                                           (2u)
#define RCAN_RSCAN0GTSC_TS                                                     (0x0000FFFFu)
#define RCAN_RSCAN0GTSC_TS_SHIFT                                               (0u)
#define RCAN_RSCAN0GAFLECTR_AFLPN                                              (0x0000001Fu)
#define RCAN_RSCAN0GAFLECTR_AFLPN_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLECTR_AFLDAE                                             (0x00000100u)
#define RCAN_RSCAN0GAFLECTR_AFLDAE_SHIFT                                       (8u)
#define RCAN_RSCAN0GAFLCFG0_RNC1                                               (0x00FF0000u)
#define RCAN_RSCAN0GAFLCFG0_RNC1_SHIFT                                         (16u)
#define RCAN_RSCAN0GAFLCFG0_RNC0                                               (0xFF000000u)
#define RCAN_RSCAN0GAFLCFG0_RNC0_SHIFT                                         (24u)
#define RCAN_RSCAN0RMNB_NRXMB                                                  (0x000000FFu)
#define RCAN_RSCAN0RMNB_NRXMB_SHIFT                                            (0u)
#define RCAN_RSCAN0RMND0_RMNS0                                                 (0x00000001u)
#define RCAN_RSCAN0RMND0_RMNS0_SHIFT                                           (0u)
#define RCAN_RSCAN0RMND0_RMNS1                                                 (0x00000002u)
#define RCAN_RSCAN0RMND0_RMNS1_SHIFT                                           (1u)
#define RCAN_RSCAN0RMND0_RMNS2                                                 (0x00000004u)
#define RCAN_RSCAN0RMND0_RMNS2_SHIFT                                           (2u)
#define RCAN_RSCAN0RMND0_RMNS3                                                 (0x00000008u)
#define RCAN_RSCAN0RMND0_RMNS3_SHIFT                                           (3u)
#define RCAN_RSCAN0RMND0_RMNS4                                                 (0x00000010u)
#define RCAN_RSCAN0RMND0_RMNS4_SHIFT                                           (4u)
#define RCAN_RSCAN0RMND0_RMNS5                                                 (0x00000020u)
#define RCAN_RSCAN0RMND0_RMNS5_SHIFT                                           (5u)
#define RCAN_RSCAN0RMND0_RMNS6                                                 (0x00000040u)
#define RCAN_RSCAN0RMND0_RMNS6_SHIFT                                           (6u)
#define RCAN_RSCAN0RMND0_RMNS7                                                 (0x00000080u)
#define RCAN_RSCAN0RMND0_RMNS7_SHIFT                                           (7u)
#define RCAN_RSCAN0RMND0_RMNS8                                                 (0x00000100u)
#define RCAN_RSCAN0RMND0_RMNS8_SHIFT                                           (8u)
#define RCAN_RSCAN0RMND0_RMNS9                                                 (0x00000200u)
#define RCAN_RSCAN0RMND0_RMNS9_SHIFT                                           (9u)
#define RCAN_RSCAN0RMND0_RMNS10                                                (0x00000400u)
#define RCAN_RSCAN0RMND0_RMNS10_SHIFT                                          (10u)
#define RCAN_RSCAN0RMND0_RMNS11                                                (0x00000800u)
#define RCAN_RSCAN0RMND0_RMNS11_SHIFT                                          (11u)
#define RCAN_RSCAN0RMND0_RMNS12                                                (0x00001000u)
#define RCAN_RSCAN0RMND0_RMNS12_SHIFT                                          (12u)
#define RCAN_RSCAN0RMND0_RMNS13                                                (0x00002000u)
#define RCAN_RSCAN0RMND0_RMNS13_SHIFT                                          (13u)
#define RCAN_RSCAN0RMND0_RMNS14                                                (0x00004000u)
#define RCAN_RSCAN0RMND0_RMNS14_SHIFT                                          (14u)
#define RCAN_RSCAN0RMND0_RMNS15                                                (0x00008000u)
#define RCAN_RSCAN0RMND0_RMNS15_SHIFT                                          (15u)
#define RCAN_RSCAN0RMND0_RMNS16                                                (0x00010000u)
#define RCAN_RSCAN0RMND0_RMNS16_SHIFT                                          (16u)
#define RCAN_RSCAN0RMND0_RMNS17                                                (0x00020000u)
#define RCAN_RSCAN0RMND0_RMNS17_SHIFT                                          (17u)
#define RCAN_RSCAN0RMND0_RMNS18                                                (0x00040000u)
#define RCAN_RSCAN0RMND0_RMNS18_SHIFT                                          (18u)
#define RCAN_RSCAN0RMND0_RMNS19                                                (0x00080000u)
#define RCAN_RSCAN0RMND0_RMNS19_SHIFT                                          (19u)
#define RCAN_RSCAN0RMND0_RMNS20                                                (0x00100000u)
#define RCAN_RSCAN0RMND0_RMNS20_SHIFT                                          (20u)
#define RCAN_RSCAN0RMND0_RMNS21                                                (0x00200000u)
#define RCAN_RSCAN0RMND0_RMNS21_SHIFT                                          (21u)
#define RCAN_RSCAN0RMND0_RMNS22                                                (0x00400000u)
#define RCAN_RSCAN0RMND0_RMNS22_SHIFT                                          (22u)
#define RCAN_RSCAN0RMND0_RMNS23                                                (0x00800000u)
#define RCAN_RSCAN0RMND0_RMNS23_SHIFT                                          (23u)
#define RCAN_RSCAN0RMND0_RMNS24                                                (0x01000000u)
#define RCAN_RSCAN0RMND0_RMNS24_SHIFT                                          (24u)
#define RCAN_RSCAN0RMND0_RMNS25                                                (0x02000000u)
#define RCAN_RSCAN0RMND0_RMNS25_SHIFT                                          (25u)
#define RCAN_RSCAN0RMND0_RMNS26                                                (0x04000000u)
#define RCAN_RSCAN0RMND0_RMNS26_SHIFT                                          (26u)
#define RCAN_RSCAN0RMND0_RMNS27                                                (0x08000000u)
#define RCAN_RSCAN0RMND0_RMNS27_SHIFT                                          (27u)
#define RCAN_RSCAN0RMND0_RMNS28                                                (0x10000000u)
#define RCAN_RSCAN0RMND0_RMNS28_SHIFT                                          (28u)
#define RCAN_RSCAN0RMND0_RMNS29                                                (0x20000000u)
#define RCAN_RSCAN0RMND0_RMNS29_SHIFT                                          (29u)
#define RCAN_RSCAN0RMND0_RMNS30                                                (0x40000000u)
#define RCAN_RSCAN0RMND0_RMNS30_SHIFT                                          (30u)
#define RCAN_RSCAN0RMND0_RMNS31                                                (0x80000000u)
#define RCAN_RSCAN0RMND0_RMNS31_SHIFT                                          (31u)
#define RCAN_RSCAN0RFCC0_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC0_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC0_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC0_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC0_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC0_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC0_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC0_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC0_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC0_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFCC1_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC1_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC1_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC1_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC1_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC1_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC1_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC1_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC1_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC1_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFCC2_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC2_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC2_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC2_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC2_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC2_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC2_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC2_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC2_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC2_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFCC3_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC3_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC3_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC3_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC3_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC3_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC3_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC3_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC3_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC3_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFCC4_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC4_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC4_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC4_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC4_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC4_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC4_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC4_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC4_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC4_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFCC5_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC5_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC5_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC5_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC5_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC5_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC5_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC5_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC5_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC5_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFCC6_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC6_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC6_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC6_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC6_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC6_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC6_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC6_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC6_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC6_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFCC7_RFE                                                   (0x00000001u)
#define RCAN_RSCAN0RFCC7_RFE_SHIFT                                             (0u)
#define RCAN_RSCAN0RFCC7_RFIE                                                  (0x00000002u)
#define RCAN_RSCAN0RFCC7_RFIE_SHIFT                                            (1u)
#define RCAN_RSCAN0RFCC7_RFDC                                                  (0x00000700u)
#define RCAN_RSCAN0RFCC7_RFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0RFCC7_RFIM                                                  (0x00001000u)
#define RCAN_RSCAN0RFCC7_RFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0RFCC7_RFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0RFCC7_RFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0RFSTS0_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS0_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS0_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS0_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS0_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS0_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS0_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS0_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS0_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS0_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFSTS1_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS1_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS1_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS1_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS1_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS1_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS1_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS1_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS1_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS1_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFSTS2_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS2_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS2_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS2_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS2_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS2_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS2_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS2_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS2_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS2_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFSTS3_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS3_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS3_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS3_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS3_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS3_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS3_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS3_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS3_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS3_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFSTS4_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS4_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS4_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS4_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS4_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS4_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS4_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS4_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS4_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS4_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFSTS5_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS5_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS5_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS5_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS5_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS5_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS5_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS5_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS5_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS5_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFSTS6_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS6_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS6_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS6_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS6_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS6_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS6_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS6_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS6_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS6_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFSTS7_RFEMP                                                (0x00000001u)
#define RCAN_RSCAN0RFSTS7_RFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0RFSTS7_RFFLL                                                (0x00000002u)
#define RCAN_RSCAN0RFSTS7_RFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0RFSTS7_RFMLT                                                (0x00000004u)
#define RCAN_RSCAN0RFSTS7_RFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0RFSTS7_RFIF                                                 (0x00000008u)
#define RCAN_RSCAN0RFSTS7_RFIF_SHIFT                                           (3u)
#define RCAN_RSCAN0RFSTS7_RFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0RFSTS7_RFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0RFPCTR0_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR0_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0RFPCTR1_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR1_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0RFPCTR2_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR2_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0RFPCTR3_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR3_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0RFPCTR4_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR4_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0RFPCTR5_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR5_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0RFPCTR6_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR6_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0RFPCTR7_RFPC                                                (0x000000FFu)
#define RCAN_RSCAN0RFPCTR7_RFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0CFCC0_CFE                                                   (0x00000001u)
#define RCAN_RSCAN0CFCC0_CFE_SHIFT                                             (0u)
#define RCAN_RSCAN0CFCC0_CFRXIE                                                (0x00000002u)
#define RCAN_RSCAN0CFCC0_CFRXIE_SHIFT                                          (1u)
#define RCAN_RSCAN0CFCC0_CFTXIE                                                (0x00000004u)
#define RCAN_RSCAN0CFCC0_CFTXIE_SHIFT                                          (2u)
#define RCAN_RSCAN0CFCC0_CFDC                                                  (0x00000700u)
#define RCAN_RSCAN0CFCC0_CFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0CFCC0_CFIM                                                  (0x00001000u)
#define RCAN_RSCAN0CFCC0_CFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0CFCC0_CFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0CFCC0_CFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0CFCC0_CFM                                                   (0x00030000u)
#define RCAN_RSCAN0CFCC0_CFM_SHIFT                                             (16u)
#define RCAN_RSCAN0CFCC0_CFITSS                                                (0x00040000u)
#define RCAN_RSCAN0CFCC0_CFITSS_SHIFT                                          (18u)
#define RCAN_RSCAN0CFCC0_CFITR                                                 (0x00080000u)
#define RCAN_RSCAN0CFCC0_CFITR_SHIFT                                           (19u)
#define RCAN_RSCAN0CFCC0_CFTML                                                 (0x00F00000u)
#define RCAN_RSCAN0CFCC0_CFTML_SHIFT                                           (20u)
#define RCAN_RSCAN0CFCC0_CFITT                                                 (0xFF000000u)
#define RCAN_RSCAN0CFCC0_CFITT_SHIFT                                           (24u)
#define RCAN_RSCAN0CFCC1_CFE                                                   (0x00000001u)
#define RCAN_RSCAN0CFCC1_CFE_SHIFT                                             (0u)
#define RCAN_RSCAN0CFCC1_CFRXIE                                                (0x00000002u)
#define RCAN_RSCAN0CFCC1_CFRXIE_SHIFT                                          (1u)
#define RCAN_RSCAN0CFCC1_CFTXIE                                                (0x00000004u)
#define RCAN_RSCAN0CFCC1_CFTXIE_SHIFT                                          (2u)
#define RCAN_RSCAN0CFCC1_CFDC                                                  (0x00000700u)
#define RCAN_RSCAN0CFCC1_CFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0CFCC1_CFIM                                                  (0x00001000u)
#define RCAN_RSCAN0CFCC1_CFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0CFCC1_CFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0CFCC1_CFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0CFCC1_CFM                                                   (0x00030000u)
#define RCAN_RSCAN0CFCC1_CFM_SHIFT                                             (16u)
#define RCAN_RSCAN0CFCC1_CFITSS                                                (0x00040000u)
#define RCAN_RSCAN0CFCC1_CFITSS_SHIFT                                          (18u)
#define RCAN_RSCAN0CFCC1_CFITR                                                 (0x00080000u)
#define RCAN_RSCAN0CFCC1_CFITR_SHIFT                                           (19u)
#define RCAN_RSCAN0CFCC1_CFTML                                                 (0x00F00000u)
#define RCAN_RSCAN0CFCC1_CFTML_SHIFT                                           (20u)
#define RCAN_RSCAN0CFCC1_CFITT                                                 (0xFF000000u)
#define RCAN_RSCAN0CFCC1_CFITT_SHIFT                                           (24u)
#define RCAN_RSCAN0CFCC2_CFE                                                   (0x00000001u)
#define RCAN_RSCAN0CFCC2_CFE_SHIFT                                             (0u)
#define RCAN_RSCAN0CFCC2_CFRXIE                                                (0x00000002u)
#define RCAN_RSCAN0CFCC2_CFRXIE_SHIFT                                          (1u)
#define RCAN_RSCAN0CFCC2_CFTXIE                                                (0x00000004u)
#define RCAN_RSCAN0CFCC2_CFTXIE_SHIFT                                          (2u)
#define RCAN_RSCAN0CFCC2_CFDC                                                  (0x00000700u)
#define RCAN_RSCAN0CFCC2_CFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0CFCC2_CFIM                                                  (0x00001000u)
#define RCAN_RSCAN0CFCC2_CFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0CFCC2_CFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0CFCC2_CFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0CFCC2_CFM                                                   (0x00030000u)
#define RCAN_RSCAN0CFCC2_CFM_SHIFT                                             (16u)
#define RCAN_RSCAN0CFCC2_CFITSS                                                (0x00040000u)
#define RCAN_RSCAN0CFCC2_CFITSS_SHIFT                                          (18u)
#define RCAN_RSCAN0CFCC2_CFITR                                                 (0x00080000u)
#define RCAN_RSCAN0CFCC2_CFITR_SHIFT                                           (19u)
#define RCAN_RSCAN0CFCC2_CFTML                                                 (0x00F00000u)
#define RCAN_RSCAN0CFCC2_CFTML_SHIFT                                           (20u)
#define RCAN_RSCAN0CFCC2_CFITT                                                 (0xFF000000u)
#define RCAN_RSCAN0CFCC2_CFITT_SHIFT                                           (24u)
#define RCAN_RSCAN0CFCC3_CFE                                                   (0x00000001u)
#define RCAN_RSCAN0CFCC3_CFE_SHIFT                                             (0u)
#define RCAN_RSCAN0CFCC3_CFRXIE                                                (0x00000002u)
#define RCAN_RSCAN0CFCC3_CFRXIE_SHIFT                                          (1u)
#define RCAN_RSCAN0CFCC3_CFTXIE                                                (0x00000004u)
#define RCAN_RSCAN0CFCC3_CFTXIE_SHIFT                                          (2u)
#define RCAN_RSCAN0CFCC3_CFDC                                                  (0x00000700u)
#define RCAN_RSCAN0CFCC3_CFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0CFCC3_CFIM                                                  (0x00001000u)
#define RCAN_RSCAN0CFCC3_CFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0CFCC3_CFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0CFCC3_CFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0CFCC3_CFM                                                   (0x00030000u)
#define RCAN_RSCAN0CFCC3_CFM_SHIFT                                             (16u)
#define RCAN_RSCAN0CFCC3_CFITSS                                                (0x00040000u)
#define RCAN_RSCAN0CFCC3_CFITSS_SHIFT                                          (18u)
#define RCAN_RSCAN0CFCC3_CFITR                                                 (0x00080000u)
#define RCAN_RSCAN0CFCC3_CFITR_SHIFT                                           (19u)
#define RCAN_RSCAN0CFCC3_CFTML                                                 (0x00F00000u)
#define RCAN_RSCAN0CFCC3_CFTML_SHIFT                                           (20u)
#define RCAN_RSCAN0CFCC3_CFITT                                                 (0xFF000000u)
#define RCAN_RSCAN0CFCC3_CFITT_SHIFT                                           (24u)
#define RCAN_RSCAN0CFCC4_CFE                                                   (0x00000001u)
#define RCAN_RSCAN0CFCC4_CFE_SHIFT                                             (0u)
#define RCAN_RSCAN0CFCC4_CFRXIE                                                (0x00000002u)
#define RCAN_RSCAN0CFCC4_CFRXIE_SHIFT                                          (1u)
#define RCAN_RSCAN0CFCC4_CFTXIE                                                (0x00000004u)
#define RCAN_RSCAN0CFCC4_CFTXIE_SHIFT                                          (2u)
#define RCAN_RSCAN0CFCC4_CFDC                                                  (0x00000700u)
#define RCAN_RSCAN0CFCC4_CFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0CFCC4_CFIM                                                  (0x00001000u)
#define RCAN_RSCAN0CFCC4_CFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0CFCC4_CFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0CFCC4_CFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0CFCC4_CFM                                                   (0x00030000u)
#define RCAN_RSCAN0CFCC4_CFM_SHIFT                                             (16u)
#define RCAN_RSCAN0CFCC4_CFITSS                                                (0x00040000u)
#define RCAN_RSCAN0CFCC4_CFITSS_SHIFT                                          (18u)
#define RCAN_RSCAN0CFCC4_CFITR                                                 (0x00080000u)
#define RCAN_RSCAN0CFCC4_CFITR_SHIFT                                           (19u)
#define RCAN_RSCAN0CFCC4_CFTML                                                 (0x00F00000u)
#define RCAN_RSCAN0CFCC4_CFTML_SHIFT                                           (20u)
#define RCAN_RSCAN0CFCC4_CFITT                                                 (0xFF000000u)
#define RCAN_RSCAN0CFCC4_CFITT_SHIFT                                           (24u)
#define RCAN_RSCAN0CFCC5_CFE                                                   (0x00000001u)
#define RCAN_RSCAN0CFCC5_CFE_SHIFT                                             (0u)
#define RCAN_RSCAN0CFCC5_CFRXIE                                                (0x00000002u)
#define RCAN_RSCAN0CFCC5_CFRXIE_SHIFT                                          (1u)
#define RCAN_RSCAN0CFCC5_CFTXIE                                                (0x00000004u)
#define RCAN_RSCAN0CFCC5_CFTXIE_SHIFT                                          (2u)
#define RCAN_RSCAN0CFCC5_CFDC                                                  (0x00000700u)
#define RCAN_RSCAN0CFCC5_CFDC_SHIFT                                            (8u)
#define RCAN_RSCAN0CFCC5_CFIM                                                  (0x00001000u)
#define RCAN_RSCAN0CFCC5_CFIM_SHIFT                                            (12u)
#define RCAN_RSCAN0CFCC5_CFIGCV                                                (0x0000E000u)
#define RCAN_RSCAN0CFCC5_CFIGCV_SHIFT                                          (13u)
#define RCAN_RSCAN0CFCC5_CFM                                                   (0x00030000u)
#define RCAN_RSCAN0CFCC5_CFM_SHIFT                                             (16u)
#define RCAN_RSCAN0CFCC5_CFITSS                                                (0x00040000u)
#define RCAN_RSCAN0CFCC5_CFITSS_SHIFT                                          (18u)
#define RCAN_RSCAN0CFCC5_CFITR                                                 (0x00080000u)
#define RCAN_RSCAN0CFCC5_CFITR_SHIFT                                           (19u)
#define RCAN_RSCAN0CFCC5_CFTML                                                 (0x00F00000u)
#define RCAN_RSCAN0CFCC5_CFTML_SHIFT                                           (20u)
#define RCAN_RSCAN0CFCC5_CFITT                                                 (0xFF000000u)
#define RCAN_RSCAN0CFCC5_CFITT_SHIFT                                           (24u)
#define RCAN_RSCAN0CFSTS0_CFEMP                                                (0x00000001u)
#define RCAN_RSCAN0CFSTS0_CFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0CFSTS0_CFFLL                                                (0x00000002u)
#define RCAN_RSCAN0CFSTS0_CFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0CFSTS0_CFMLT                                                (0x00000004u)
#define RCAN_RSCAN0CFSTS0_CFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0CFSTS0_CFRXIF                                               (0x00000008u)
#define RCAN_RSCAN0CFSTS0_CFRXIF_SHIFT                                         (3u)
#define RCAN_RSCAN0CFSTS0_CFTXIF                                               (0x00000010u)
#define RCAN_RSCAN0CFSTS0_CFTXIF_SHIFT                                         (4u)
#define RCAN_RSCAN0CFSTS0_CFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0CFSTS0_CFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0CFSTS1_CFEMP                                                (0x00000001u)
#define RCAN_RSCAN0CFSTS1_CFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0CFSTS1_CFFLL                                                (0x00000002u)
#define RCAN_RSCAN0CFSTS1_CFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0CFSTS1_CFMLT                                                (0x00000004u)
#define RCAN_RSCAN0CFSTS1_CFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0CFSTS1_CFRXIF                                               (0x00000008u)
#define RCAN_RSCAN0CFSTS1_CFRXIF_SHIFT                                         (3u)
#define RCAN_RSCAN0CFSTS1_CFTXIF                                               (0x00000010u)
#define RCAN_RSCAN0CFSTS1_CFTXIF_SHIFT                                         (4u)
#define RCAN_RSCAN0CFSTS1_CFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0CFSTS1_CFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0CFSTS2_CFEMP                                                (0x00000001u)
#define RCAN_RSCAN0CFSTS2_CFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0CFSTS2_CFFLL                                                (0x00000002u)
#define RCAN_RSCAN0CFSTS2_CFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0CFSTS2_CFMLT                                                (0x00000004u)
#define RCAN_RSCAN0CFSTS2_CFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0CFSTS2_CFRXIF                                               (0x00000008u)
#define RCAN_RSCAN0CFSTS2_CFRXIF_SHIFT                                         (3u)
#define RCAN_RSCAN0CFSTS2_CFTXIF                                               (0x00000010u)
#define RCAN_RSCAN0CFSTS2_CFTXIF_SHIFT                                         (4u)
#define RCAN_RSCAN0CFSTS2_CFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0CFSTS2_CFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0CFSTS3_CFEMP                                                (0x00000001u)
#define RCAN_RSCAN0CFSTS3_CFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0CFSTS3_CFFLL                                                (0x00000002u)
#define RCAN_RSCAN0CFSTS3_CFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0CFSTS3_CFMLT                                                (0x00000004u)
#define RCAN_RSCAN0CFSTS3_CFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0CFSTS3_CFRXIF                                               (0x00000008u)
#define RCAN_RSCAN0CFSTS3_CFRXIF_SHIFT                                         (3u)
#define RCAN_RSCAN0CFSTS3_CFTXIF                                               (0x00000010u)
#define RCAN_RSCAN0CFSTS3_CFTXIF_SHIFT                                         (4u)
#define RCAN_RSCAN0CFSTS3_CFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0CFSTS3_CFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0CFSTS4_CFEMP                                                (0x00000001u)
#define RCAN_RSCAN0CFSTS4_CFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0CFSTS4_CFFLL                                                (0x00000002u)
#define RCAN_RSCAN0CFSTS4_CFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0CFSTS4_CFMLT                                                (0x00000004u)
#define RCAN_RSCAN0CFSTS4_CFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0CFSTS4_CFRXIF                                               (0x00000008u)
#define RCAN_RSCAN0CFSTS4_CFRXIF_SHIFT                                         (3u)
#define RCAN_RSCAN0CFSTS4_CFTXIF                                               (0x00000010u)
#define RCAN_RSCAN0CFSTS4_CFTXIF_SHIFT                                         (4u)
#define RCAN_RSCAN0CFSTS4_CFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0CFSTS4_CFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0CFSTS5_CFEMP                                                (0x00000001u)
#define RCAN_RSCAN0CFSTS5_CFEMP_SHIFT                                          (0u)
#define RCAN_RSCAN0CFSTS5_CFFLL                                                (0x00000002u)
#define RCAN_RSCAN0CFSTS5_CFFLL_SHIFT                                          (1u)
#define RCAN_RSCAN0CFSTS5_CFMLT                                                (0x00000004u)
#define RCAN_RSCAN0CFSTS5_CFMLT_SHIFT                                          (2u)
#define RCAN_RSCAN0CFSTS5_CFRXIF                                               (0x00000008u)
#define RCAN_RSCAN0CFSTS5_CFRXIF_SHIFT                                         (3u)
#define RCAN_RSCAN0CFSTS5_CFTXIF                                               (0x00000010u)
#define RCAN_RSCAN0CFSTS5_CFTXIF_SHIFT                                         (4u)
#define RCAN_RSCAN0CFSTS5_CFMC                                                 (0x0000FF00u)
#define RCAN_RSCAN0CFSTS5_CFMC_SHIFT                                           (8u)
#define RCAN_RSCAN0CFPCTR0_CFPC                                                (0x000000FFu)
#define RCAN_RSCAN0CFPCTR0_CFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0CFPCTR1_CFPC                                                (0x000000FFu)
#define RCAN_RSCAN0CFPCTR1_CFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0CFPCTR2_CFPC                                                (0x000000FFu)
#define RCAN_RSCAN0CFPCTR2_CFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0CFPCTR3_CFPC                                                (0x000000FFu)
#define RCAN_RSCAN0CFPCTR3_CFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0CFPCTR4_CFPC                                                (0x000000FFu)
#define RCAN_RSCAN0CFPCTR4_CFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0CFPCTR5_CFPC                                                (0x000000FFu)
#define RCAN_RSCAN0CFPCTR5_CFPC_SHIFT                                          (0u)
#define RCAN_RSCAN0FESTS_RF0EMP                                                (0x00000001u)
#define RCAN_RSCAN0FESTS_RF0EMP_SHIFT                                          (0u)
#define RCAN_RSCAN0FESTS_RF1EMP                                                (0x00000002u)
#define RCAN_RSCAN0FESTS_RF1EMP_SHIFT                                          (1u)
#define RCAN_RSCAN0FESTS_RF2EMP                                                (0x00000004u)
#define RCAN_RSCAN0FESTS_RF2EMP_SHIFT                                          (2u)
#define RCAN_RSCAN0FESTS_RF3EMP                                                (0x00000008u)
#define RCAN_RSCAN0FESTS_RF3EMP_SHIFT                                          (3u)
#define RCAN_RSCAN0FESTS_RF4EMP                                                (0x00000010u)
#define RCAN_RSCAN0FESTS_RF4EMP_SHIFT                                          (4u)
#define RCAN_RSCAN0FESTS_RF5EMP                                                (0x00000020u)
#define RCAN_RSCAN0FESTS_RF5EMP_SHIFT                                          (5u)
#define RCAN_RSCAN0FESTS_RF6EMP                                                (0x00000040u)
#define RCAN_RSCAN0FESTS_RF6EMP_SHIFT                                          (6u)
#define RCAN_RSCAN0FESTS_RF7EMP                                                (0x00000080u)
#define RCAN_RSCAN0FESTS_RF7EMP_SHIFT                                          (7u)
#define RCAN_RSCAN0FESTS_CF0EMP                                                (0x00000100u)
#define RCAN_RSCAN0FESTS_CF0EMP_SHIFT                                          (8u)
#define RCAN_RSCAN0FESTS_CF1EMP                                                (0x00000200u)
#define RCAN_RSCAN0FESTS_CF1EMP_SHIFT                                          (9u)
#define RCAN_RSCAN0FESTS_CF2EMP                                                (0x00000400u)
#define RCAN_RSCAN0FESTS_CF2EMP_SHIFT                                          (10u)
#define RCAN_RSCAN0FESTS_CF3EMP                                                (0x00000800u)
#define RCAN_RSCAN0FESTS_CF3EMP_SHIFT                                          (11u)
#define RCAN_RSCAN0FESTS_CF4EMP                                                (0x00001000u)
#define RCAN_RSCAN0FESTS_CF4EMP_SHIFT                                          (12u)
#define RCAN_RSCAN0FESTS_CF5EMP                                                (0x00002000u)
#define RCAN_RSCAN0FESTS_CF5EMP_SHIFT                                          (13u)
#define RCAN_RSCAN0FFSTS_RF0FLL                                                (0x00000001u)
#define RCAN_RSCAN0FFSTS_RF0FLL_SHIFT                                          (0u)
#define RCAN_RSCAN0FFSTS_RF1FLL                                                (0x00000002u)
#define RCAN_RSCAN0FFSTS_RF1FLL_SHIFT                                          (1u)
#define RCAN_RSCAN0FFSTS_RF2FLL                                                (0x00000004u)
#define RCAN_RSCAN0FFSTS_RF2FLL_SHIFT                                          (2u)
#define RCAN_RSCAN0FFSTS_RF3FLL                                                (0x00000008u)
#define RCAN_RSCAN0FFSTS_RF3FLL_SHIFT                                          (3u)
#define RCAN_RSCAN0FFSTS_RF4FLL                                                (0x00000010u)
#define RCAN_RSCAN0FFSTS_RF4FLL_SHIFT                                          (4u)
#define RCAN_RSCAN0FFSTS_RF5FLL                                                (0x00000020u)
#define RCAN_RSCAN0FFSTS_RF5FLL_SHIFT                                          (5u)
#define RCAN_RSCAN0FFSTS_RF6FLL                                                (0x00000040u)
#define RCAN_RSCAN0FFSTS_RF6FLL_SHIFT                                          (6u)
#define RCAN_RSCAN0FFSTS_RF7FLL                                                (0x00000080u)
#define RCAN_RSCAN0FFSTS_RF7FLL_SHIFT                                          (7u)
#define RCAN_RSCAN0FFSTS_CF0FLL                                                (0x00000100u)
#define RCAN_RSCAN0FFSTS_CF0FLL_SHIFT                                          (8u)
#define RCAN_RSCAN0FFSTS_CF1FLL                                                (0x00000200u)
#define RCAN_RSCAN0FFSTS_CF1FLL_SHIFT                                          (9u)
#define RCAN_RSCAN0FFSTS_CF2FLL                                                (0x00000400u)
#define RCAN_RSCAN0FFSTS_CF2FLL_SHIFT                                          (10u)
#define RCAN_RSCAN0FFSTS_CF3FLL                                                (0x00000800u)
#define RCAN_RSCAN0FFSTS_CF3FLL_SHIFT                                          (11u)
#define RCAN_RSCAN0FFSTS_CF4FLL                                                (0x00001000u)
#define RCAN_RSCAN0FFSTS_CF4FLL_SHIFT                                          (12u)
#define RCAN_RSCAN0FFSTS_CF5FLL                                                (0x00002000u)
#define RCAN_RSCAN0FFSTS_CF5FLL_SHIFT                                          (13u)
#define RCAN_RSCAN0FMSTS_RF0MLT                                                (0x00000001u)
#define RCAN_RSCAN0FMSTS_RF0MLT_SHIFT                                          (0u)
#define RCAN_RSCAN0FMSTS_RF1MLT                                                (0x00000002u)
#define RCAN_RSCAN0FMSTS_RF1MLT_SHIFT                                          (1u)
#define RCAN_RSCAN0FMSTS_RF2MLT                                                (0x00000004u)
#define RCAN_RSCAN0FMSTS_RF2MLT_SHIFT                                          (2u)
#define RCAN_RSCAN0FMSTS_RF3MLT                                                (0x00000008u)
#define RCAN_RSCAN0FMSTS_RF3MLT_SHIFT                                          (3u)
#define RCAN_RSCAN0FMSTS_RF4MLT                                                (0x00000010u)
#define RCAN_RSCAN0FMSTS_RF4MLT_SHIFT                                          (4u)
#define RCAN_RSCAN0FMSTS_RF5MLT                                                (0x00000020u)
#define RCAN_RSCAN0FMSTS_RF5MLT_SHIFT                                          (5u)
#define RCAN_RSCAN0FMSTS_RF6MLT                                                (0x00000040u)
#define RCAN_RSCAN0FMSTS_RF6MLT_SHIFT                                          (6u)
#define RCAN_RSCAN0FMSTS_RF7MLT                                                (0x00000080u)
#define RCAN_RSCAN0FMSTS_RF7MLT_SHIFT                                          (7u)
#define RCAN_RSCAN0FMSTS_CF0MLT                                                (0x00000100u)
#define RCAN_RSCAN0FMSTS_CF0MLT_SHIFT                                          (8u)
#define RCAN_RSCAN0FMSTS_CF1MLT                                                (0x00000200u)
#define RCAN_RSCAN0FMSTS_CF1MLT_SHIFT                                          (9u)
#define RCAN_RSCAN0FMSTS_CF2MLT                                                (0x00000400u)
#define RCAN_RSCAN0FMSTS_CF2MLT_SHIFT                                          (10u)
#define RCAN_RSCAN0FMSTS_CF3MLT                                                (0x00000800u)
#define RCAN_RSCAN0FMSTS_CF3MLT_SHIFT                                          (11u)
#define RCAN_RSCAN0FMSTS_CF4MLT                                                (0x00001000u)
#define RCAN_RSCAN0FMSTS_CF4MLT_SHIFT                                          (12u)
#define RCAN_RSCAN0FMSTS_CF5MLT                                                (0x00002000u)
#define RCAN_RSCAN0FMSTS_CF5MLT_SHIFT                                          (13u)
#define RCAN_RSCAN0RFISTS_RF0IF                                                (0x00000001u)
#define RCAN_RSCAN0RFISTS_RF0IF_SHIFT                                          (0u)
#define RCAN_RSCAN0RFISTS_RF1IF                                                (0x00000002u)
#define RCAN_RSCAN0RFISTS_RF1IF_SHIFT                                          (1u)
#define RCAN_RSCAN0RFISTS_RF2IF                                                (0x00000004u)
#define RCAN_RSCAN0RFISTS_RF2IF_SHIFT                                          (2u)
#define RCAN_RSCAN0RFISTS_RF3IF                                                (0x00000008u)
#define RCAN_RSCAN0RFISTS_RF3IF_SHIFT                                          (3u)
#define RCAN_RSCAN0RFISTS_RF4IF                                                (0x00000010u)
#define RCAN_RSCAN0RFISTS_RF4IF_SHIFT                                          (4u)
#define RCAN_RSCAN0RFISTS_RF5IF                                                (0x00000020u)
#define RCAN_RSCAN0RFISTS_RF5IF_SHIFT                                          (5u)
#define RCAN_RSCAN0RFISTS_RF6IF                                                (0x00000040u)
#define RCAN_RSCAN0RFISTS_RF6IF_SHIFT                                          (6u)
#define RCAN_RSCAN0RFISTS_RF7IF                                                (0x00000080u)
#define RCAN_RSCAN0RFISTS_RF7IF_SHIFT                                          (7u)
#define RCAN_RSCAN0CFRISTS_CF0RXIF                                             (0x00000001u)
#define RCAN_RSCAN0CFRISTS_CF0RXIF_SHIFT                                       (0u)
#define RCAN_RSCAN0CFRISTS_CF1RXIF                                             (0x00000002u)
#define RCAN_RSCAN0CFRISTS_CF1RXIF_SHIFT                                       (1u)
#define RCAN_RSCAN0CFRISTS_CF2RXIF                                             (0x00000004u)
#define RCAN_RSCAN0CFRISTS_CF2RXIF_SHIFT                                       (2u)
#define RCAN_RSCAN0CFRISTS_CF3RXIF                                             (0x00000008u)
#define RCAN_RSCAN0CFRISTS_CF3RXIF_SHIFT                                       (3u)
#define RCAN_RSCAN0CFRISTS_CF4RXIF                                             (0x00000010u)
#define RCAN_RSCAN0CFRISTS_CF4RXIF_SHIFT                                       (4u)
#define RCAN_RSCAN0CFRISTS_CF5RXIF                                             (0x00000020u)
#define RCAN_RSCAN0CFRISTS_CF5RXIF_SHIFT                                       (5u)
#define RCAN_RSCAN0CFTISTS_CF0TXIF                                             (0x00000001u)
#define RCAN_RSCAN0CFTISTS_CF0TXIF_SHIFT                                       (0u)
#define RCAN_RSCAN0CFTISTS_CF1TXIF                                             (0x00000002u)
#define RCAN_RSCAN0CFTISTS_CF1TXIF_SHIFT                                       (1u)
#define RCAN_RSCAN0CFTISTS_CF2TXIF                                             (0x00000004u)
#define RCAN_RSCAN0CFTISTS_CF2TXIF_SHIFT                                       (2u)
#define RCAN_RSCAN0CFTISTS_CF3TXIF                                             (0x00000008u)
#define RCAN_RSCAN0CFTISTS_CF3TXIF_SHIFT                                       (3u)
#define RCAN_RSCAN0CFTISTS_CF4TXIF                                             (0x00000010u)
#define RCAN_RSCAN0CFTISTS_CF4TXIF_SHIFT                                       (4u)
#define RCAN_RSCAN0CFTISTS_CF5TXIF                                             (0x00000020u)
#define RCAN_RSCAN0CFTISTS_CF5TXIF_SHIFT                                       (5u)
#define RCAN_RSCAN0TMC0_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC0_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC0_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC0_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC0_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC0_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC1_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC1_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC1_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC1_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC1_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC1_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC2_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC2_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC2_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC2_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC2_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC2_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC3_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC3_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC3_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC3_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC3_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC3_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC4_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC4_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC4_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC4_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC4_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC4_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC5_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC5_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC5_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC5_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC5_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC5_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC6_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC6_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC6_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC6_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC6_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC6_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC7_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC7_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC7_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC7_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC7_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC7_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC8_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC8_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC8_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC8_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC8_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC8_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC9_TMTR                                                   (0x01u)
#define RCAN_RSCAN0TMC9_TMTR_SHIFT                                             (0u)
#define RCAN_RSCAN0TMC9_TMTAR                                                  (0x02u)
#define RCAN_RSCAN0TMC9_TMTAR_SHIFT                                            (1u)
#define RCAN_RSCAN0TMC9_TMOM                                                   (0x04u)
#define RCAN_RSCAN0TMC9_TMOM_SHIFT                                             (2u)
#define RCAN_RSCAN0TMC10_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC10_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC10_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC10_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC10_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC10_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC11_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC11_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC11_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC11_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC11_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC11_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC12_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC12_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC12_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC12_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC12_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC12_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC13_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC13_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC13_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC13_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC13_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC13_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC14_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC14_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC14_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC14_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC14_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC14_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC15_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC15_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC15_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC15_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC15_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC15_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC16_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC16_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC16_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC16_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC16_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC16_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC17_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC17_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC17_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC17_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC17_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC17_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC18_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC18_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC18_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC18_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC18_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC18_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC19_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC19_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC19_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC19_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC19_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC19_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC20_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC20_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC20_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC20_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC20_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC20_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC21_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC21_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC21_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC21_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC21_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC21_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC22_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC22_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC22_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC22_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC22_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC22_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC23_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC23_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC23_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC23_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC23_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC23_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC24_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC24_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC24_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC24_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC24_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC24_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC25_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC25_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC25_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC25_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC25_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC25_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC26_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC26_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC26_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC26_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC26_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC26_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC27_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC27_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC27_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC27_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC27_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC27_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC28_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC28_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC28_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC28_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC28_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC28_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC29_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC29_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC29_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC29_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC29_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC29_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC30_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC30_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC30_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC30_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC30_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC30_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMC31_TMTR                                                  (0x01u)
#define RCAN_RSCAN0TMC31_TMTR_SHIFT                                            (0u)
#define RCAN_RSCAN0TMC31_TMTAR                                                 (0x02u)
#define RCAN_RSCAN0TMC31_TMTAR_SHIFT                                           (1u)
#define RCAN_RSCAN0TMC31_TMOM                                                  (0x04u)
#define RCAN_RSCAN0TMC31_TMOM_SHIFT                                            (2u)
#define RCAN_RSCAN0TMSTS0_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS0_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS0_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS0_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS0_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS0_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS0_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS0_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS1_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS1_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS1_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS1_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS1_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS1_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS1_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS1_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS2_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS2_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS2_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS2_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS2_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS2_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS2_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS2_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS3_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS3_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS3_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS3_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS3_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS3_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS3_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS3_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS4_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS4_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS4_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS4_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS4_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS4_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS4_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS4_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS5_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS5_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS5_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS5_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS5_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS5_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS5_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS5_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS6_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS6_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS6_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS6_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS6_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS6_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS6_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS6_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS7_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS7_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS7_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS7_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS7_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS7_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS7_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS7_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS8_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS8_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS8_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS8_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS8_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS8_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS8_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS8_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS9_TMTSTS                                               (0x01u)
#define RCAN_RSCAN0TMSTS9_TMTSTS_SHIFT                                         (0u)
#define RCAN_RSCAN0TMSTS9_TMTRF                                                (0x06u)
#define RCAN_RSCAN0TMSTS9_TMTRF_SHIFT                                          (1u)
#define RCAN_RSCAN0TMSTS9_TMTRM                                                (0x08u)
#define RCAN_RSCAN0TMSTS9_TMTRM_SHIFT                                          (3u)
#define RCAN_RSCAN0TMSTS9_TMTARM                                               (0x10u)
#define RCAN_RSCAN0TMSTS9_TMTARM_SHIFT                                         (4u)
#define RCAN_RSCAN0TMSTS10_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS10_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS10_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS10_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS10_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS10_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS10_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS10_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS11_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS11_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS11_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS11_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS11_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS11_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS11_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS11_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS12_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS12_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS12_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS12_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS12_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS12_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS12_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS12_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS13_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS13_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS13_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS13_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS13_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS13_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS13_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS13_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS14_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS14_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS14_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS14_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS14_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS14_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS14_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS14_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS15_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS15_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS15_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS15_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS15_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS15_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS15_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS15_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS16_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS16_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS16_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS16_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS16_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS16_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS16_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS16_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS17_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS17_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS17_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS17_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS17_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS17_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS17_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS17_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS18_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS18_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS18_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS18_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS18_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS18_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS18_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS18_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS19_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS19_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS19_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS19_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS19_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS19_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS19_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS19_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS20_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS20_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS20_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS20_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS20_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS20_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS20_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS20_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS21_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS21_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS21_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS21_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS21_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS21_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS21_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS21_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS22_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS22_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS22_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS22_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS22_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS22_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS22_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS22_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS23_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS23_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS23_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS23_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS23_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS23_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS23_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS23_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS24_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS24_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS24_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS24_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS24_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS24_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS24_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS24_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS25_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS25_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS25_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS25_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS25_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS25_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS25_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS25_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS26_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS26_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS26_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS26_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS26_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS26_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS26_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS26_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS27_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS27_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS27_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS27_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS27_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS27_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS27_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS27_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS28_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS28_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS28_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS28_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS28_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS28_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS28_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS28_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS29_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS29_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS29_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS29_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS29_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS29_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS29_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS29_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS30_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS30_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS30_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS30_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS30_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS30_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS30_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS30_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMSTS31_TMTSTS                                              (0x01u)
#define RCAN_RSCAN0TMSTS31_TMTSTS_SHIFT                                        (0u)
#define RCAN_RSCAN0TMSTS31_TMTRF                                               (0x06u)
#define RCAN_RSCAN0TMSTS31_TMTRF_SHIFT                                         (1u)
#define RCAN_RSCAN0TMSTS31_TMTRM                                               (0x08u)
#define RCAN_RSCAN0TMSTS31_TMTRM_SHIFT                                         (3u)
#define RCAN_RSCAN0TMSTS31_TMTARM                                              (0x10u)
#define RCAN_RSCAN0TMSTS31_TMTARM_SHIFT                                        (4u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS0                                           (0x00000001u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS0_SHIFT                                     (0u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS1                                           (0x00000002u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS1_SHIFT                                     (1u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS2                                           (0x00000004u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS2_SHIFT                                     (2u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS3                                           (0x00000008u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS3_SHIFT                                     (3u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS4                                           (0x00000010u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS4_SHIFT                                     (4u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS5                                           (0x00000020u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS5_SHIFT                                     (5u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS6                                           (0x00000040u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS6_SHIFT                                     (6u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS7                                           (0x00000080u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS7_SHIFT                                     (7u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS8                                           (0x00000100u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS8_SHIFT                                     (8u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS9                                           (0x00000200u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS9_SHIFT                                     (9u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS10                                          (0x00000400u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS10_SHIFT                                    (10u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS11                                          (0x00000800u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS11_SHIFT                                    (11u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS12                                          (0x00001000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS12_SHIFT                                    (12u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS13                                          (0x00002000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS13_SHIFT                                    (13u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS14                                          (0x00004000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS14_SHIFT                                    (14u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS15                                          (0x00008000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS15_SHIFT                                    (15u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS16                                          (0x00010000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS16_SHIFT                                    (16u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS17                                          (0x00020000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS17_SHIFT                                    (17u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS18                                          (0x00040000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS18_SHIFT                                    (18u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS19                                          (0x00080000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS19_SHIFT                                    (19u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS20                                          (0x00100000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS20_SHIFT                                    (20u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS21                                          (0x00200000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS21_SHIFT                                    (21u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS22                                          (0x00400000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS22_SHIFT                                    (22u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS23                                          (0x00800000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS23_SHIFT                                    (23u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS24                                          (0x01000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS24_SHIFT                                    (24u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS25                                          (0x02000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS25_SHIFT                                    (25u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS26                                          (0x04000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS26_SHIFT                                    (26u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS27                                          (0x08000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS27_SHIFT                                    (27u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS28                                          (0x10000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS28_SHIFT                                    (28u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS29                                          (0x20000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS29_SHIFT                                    (29u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS30                                          (0x40000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS30_SHIFT                                    (30u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS31                                          (0x80000000u)
#define RCAN_RSCAN0TMTRSTS0_TMTRSTS31_SHIFT                                    (31u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS0                                         (0x00000001u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS0_SHIFT                                   (0u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS1                                         (0x00000002u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS1_SHIFT                                   (1u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS2                                         (0x00000004u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS2_SHIFT                                   (2u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS3                                         (0x00000008u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS3_SHIFT                                   (3u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS4                                         (0x00000010u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS4_SHIFT                                   (4u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS5                                         (0x00000020u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS5_SHIFT                                   (5u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS6                                         (0x00000040u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS6_SHIFT                                   (6u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS7                                         (0x00000080u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS7_SHIFT                                   (7u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS8                                         (0x00000100u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS8_SHIFT                                   (8u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS9                                         (0x00000200u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS9_SHIFT                                   (9u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS10                                        (0x00000400u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS10_SHIFT                                  (10u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS11                                        (0x00000800u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS11_SHIFT                                  (11u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS12                                        (0x00001000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS12_SHIFT                                  (12u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS13                                        (0x00002000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS13_SHIFT                                  (13u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS14                                        (0x00004000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS14_SHIFT                                  (14u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS15                                        (0x00008000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS15_SHIFT                                  (15u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS16                                        (0x00010000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS16_SHIFT                                  (16u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS17                                        (0x00020000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS17_SHIFT                                  (17u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS18                                        (0x00040000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS18_SHIFT                                  (18u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS19                                        (0x00080000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS19_SHIFT                                  (19u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS20                                        (0x00100000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS20_SHIFT                                  (20u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS21                                        (0x00200000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS21_SHIFT                                  (21u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS22                                        (0x00400000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS22_SHIFT                                  (22u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS23                                        (0x00800000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS23_SHIFT                                  (23u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS24                                        (0x01000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS24_SHIFT                                  (24u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS25                                        (0x02000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS25_SHIFT                                  (25u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS26                                        (0x04000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS26_SHIFT                                  (26u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS27                                        (0x08000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS27_SHIFT                                  (27u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS28                                        (0x10000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS28_SHIFT                                  (28u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS29                                        (0x20000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS29_SHIFT                                  (29u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS30                                        (0x40000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS30_SHIFT                                  (30u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS31                                        (0x80000000u)
#define RCAN_RSCAN0TMTARSTS0_TMTARSTS31_SHIFT                                  (31u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS0                                           (0x00000001u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS0_SHIFT                                     (0u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS1                                           (0x00000002u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS1_SHIFT                                     (1u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS2                                           (0x00000004u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS2_SHIFT                                     (2u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS3                                           (0x00000008u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS3_SHIFT                                     (3u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS4                                           (0x00000010u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS4_SHIFT                                     (4u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS5                                           (0x00000020u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS5_SHIFT                                     (5u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS6                                           (0x00000040u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS6_SHIFT                                     (6u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS7                                           (0x00000080u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS7_SHIFT                                     (7u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS8                                           (0x00000100u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS8_SHIFT                                     (8u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS9                                           (0x00000200u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS9_SHIFT                                     (9u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS10                                          (0x00000400u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS10_SHIFT                                    (10u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS11                                          (0x00000800u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS11_SHIFT                                    (11u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS12                                          (0x00001000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS12_SHIFT                                    (12u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS13                                          (0x00002000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS13_SHIFT                                    (13u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS14                                          (0x00004000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS14_SHIFT                                    (14u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS15                                          (0x00008000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS15_SHIFT                                    (15u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS16                                          (0x00010000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS16_SHIFT                                    (16u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS17                                          (0x00020000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS17_SHIFT                                    (17u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS18                                          (0x00040000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS18_SHIFT                                    (18u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS19                                          (0x00080000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS19_SHIFT                                    (19u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS20                                          (0x00100000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS20_SHIFT                                    (20u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS21                                          (0x00200000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS21_SHIFT                                    (21u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS22                                          (0x00400000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS22_SHIFT                                    (22u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS23                                          (0x00800000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS23_SHIFT                                    (23u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS24                                          (0x01000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS24_SHIFT                                    (24u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS25                                          (0x02000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS25_SHIFT                                    (25u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS26                                          (0x04000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS26_SHIFT                                    (26u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS27                                          (0x08000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS27_SHIFT                                    (27u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS28                                          (0x10000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS28_SHIFT                                    (28u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS29                                          (0x20000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS29_SHIFT                                    (29u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS30                                          (0x40000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS30_SHIFT                                    (30u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS31                                          (0x80000000u)
#define RCAN_RSCAN0TMTCSTS0_TMTCSTS31_SHIFT                                    (31u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS0                                           (0x00000001u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS0_SHIFT                                     (0u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS1                                           (0x00000002u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS1_SHIFT                                     (1u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS2                                           (0x00000004u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS2_SHIFT                                     (2u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS3                                           (0x00000008u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS3_SHIFT                                     (3u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS4                                           (0x00000010u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS4_SHIFT                                     (4u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS5                                           (0x00000020u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS5_SHIFT                                     (5u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS6                                           (0x00000040u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS6_SHIFT                                     (6u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS7                                           (0x00000080u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS7_SHIFT                                     (7u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS8                                           (0x00000100u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS8_SHIFT                                     (8u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS9                                           (0x00000200u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS9_SHIFT                                     (9u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS10                                          (0x00000400u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS10_SHIFT                                    (10u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS11                                          (0x00000800u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS11_SHIFT                                    (11u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS12                                          (0x00001000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS12_SHIFT                                    (12u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS13                                          (0x00002000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS13_SHIFT                                    (13u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS14                                          (0x00004000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS14_SHIFT                                    (14u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS15                                          (0x00008000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS15_SHIFT                                    (15u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS16                                          (0x00010000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS16_SHIFT                                    (16u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS17                                          (0x00020000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS17_SHIFT                                    (17u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS18                                          (0x00040000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS18_SHIFT                                    (18u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS19                                          (0x00080000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS19_SHIFT                                    (19u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS20                                          (0x00100000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS20_SHIFT                                    (20u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS21                                          (0x00200000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS21_SHIFT                                    (21u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS22                                          (0x00400000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS22_SHIFT                                    (22u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS23                                          (0x00800000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS23_SHIFT                                    (23u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS24                                          (0x01000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS24_SHIFT                                    (24u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS25                                          (0x02000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS25_SHIFT                                    (25u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS26                                          (0x04000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS26_SHIFT                                    (26u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS27                                          (0x08000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS27_SHIFT                                    (27u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS28                                          (0x10000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS28_SHIFT                                    (28u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS29                                          (0x20000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS29_SHIFT                                    (29u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS30                                          (0x40000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS30_SHIFT                                    (30u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS31                                          (0x80000000u)
#define RCAN_RSCAN0TMTASTS0_TMTASTS31_SHIFT                                    (31u)
#define RCAN_RSCAN0TMIEC0_TMIE0                                                (0x00000001u)
#define RCAN_RSCAN0TMIEC0_TMIE0_SHIFT                                          (0u)
#define RCAN_RSCAN0TMIEC0_TMIE1                                                (0x00000002u)
#define RCAN_RSCAN0TMIEC0_TMIE1_SHIFT                                          (1u)
#define RCAN_RSCAN0TMIEC0_TMIE2                                                (0x00000004u)
#define RCAN_RSCAN0TMIEC0_TMIE2_SHIFT                                          (2u)
#define RCAN_RSCAN0TMIEC0_TMIE3                                                (0x00000008u)
#define RCAN_RSCAN0TMIEC0_TMIE3_SHIFT                                          (3u)
#define RCAN_RSCAN0TMIEC0_TMIE4                                                (0x00000010u)
#define RCAN_RSCAN0TMIEC0_TMIE4_SHIFT                                          (4u)
#define RCAN_RSCAN0TMIEC0_TMIE5                                                (0x00000020u)
#define RCAN_RSCAN0TMIEC0_TMIE5_SHIFT                                          (5u)
#define RCAN_RSCAN0TMIEC0_TMIE6                                                (0x00000040u)
#define RCAN_RSCAN0TMIEC0_TMIE6_SHIFT                                          (6u)
#define RCAN_RSCAN0TMIEC0_TMIE7                                                (0x00000080u)
#define RCAN_RSCAN0TMIEC0_TMIE7_SHIFT                                          (7u)
#define RCAN_RSCAN0TMIEC0_TMIE8                                                (0x00000100u)
#define RCAN_RSCAN0TMIEC0_TMIE8_SHIFT                                          (8u)
#define RCAN_RSCAN0TMIEC0_TMIE9                                                (0x00000200u)
#define RCAN_RSCAN0TMIEC0_TMIE9_SHIFT                                          (9u)
#define RCAN_RSCAN0TMIEC0_TMIE10                                               (0x00000400u)
#define RCAN_RSCAN0TMIEC0_TMIE10_SHIFT                                         (10u)
#define RCAN_RSCAN0TMIEC0_TMIE11                                               (0x00000800u)
#define RCAN_RSCAN0TMIEC0_TMIE11_SHIFT                                         (11u)
#define RCAN_RSCAN0TMIEC0_TMIE12                                               (0x00001000u)
#define RCAN_RSCAN0TMIEC0_TMIE12_SHIFT                                         (12u)
#define RCAN_RSCAN0TMIEC0_TMIE13                                               (0x00002000u)
#define RCAN_RSCAN0TMIEC0_TMIE13_SHIFT                                         (13u)
#define RCAN_RSCAN0TMIEC0_TMIE14                                               (0x00004000u)
#define RCAN_RSCAN0TMIEC0_TMIE14_SHIFT                                         (14u)
#define RCAN_RSCAN0TMIEC0_TMIE15                                               (0x00008000u)
#define RCAN_RSCAN0TMIEC0_TMIE15_SHIFT                                         (15u)
#define RCAN_RSCAN0TMIEC0_TMIE16                                               (0x00010000u)
#define RCAN_RSCAN0TMIEC0_TMIE16_SHIFT                                         (16u)
#define RCAN_RSCAN0TMIEC0_TMIE17                                               (0x00020000u)
#define RCAN_RSCAN0TMIEC0_TMIE17_SHIFT                                         (17u)
#define RCAN_RSCAN0TMIEC0_TMIE18                                               (0x00040000u)
#define RCAN_RSCAN0TMIEC0_TMIE18_SHIFT                                         (18u)
#define RCAN_RSCAN0TMIEC0_TMIE19                                               (0x00080000u)
#define RCAN_RSCAN0TMIEC0_TMIE19_SHIFT                                         (19u)
#define RCAN_RSCAN0TMIEC0_TMIE20                                               (0x00100000u)
#define RCAN_RSCAN0TMIEC0_TMIE20_SHIFT                                         (20u)
#define RCAN_RSCAN0TMIEC0_TMIE21                                               (0x00200000u)
#define RCAN_RSCAN0TMIEC0_TMIE21_SHIFT                                         (21u)
#define RCAN_RSCAN0TMIEC0_TMIE22                                               (0x00400000u)
#define RCAN_RSCAN0TMIEC0_TMIE22_SHIFT                                         (22u)
#define RCAN_RSCAN0TMIEC0_TMIE23                                               (0x00800000u)
#define RCAN_RSCAN0TMIEC0_TMIE23_SHIFT                                         (23u)
#define RCAN_RSCAN0TMIEC0_TMIE24                                               (0x01000000u)
#define RCAN_RSCAN0TMIEC0_TMIE24_SHIFT                                         (24u)
#define RCAN_RSCAN0TMIEC0_TMIE25                                               (0x02000000u)
#define RCAN_RSCAN0TMIEC0_TMIE25_SHIFT                                         (25u)
#define RCAN_RSCAN0TMIEC0_TMIE26                                               (0x04000000u)
#define RCAN_RSCAN0TMIEC0_TMIE26_SHIFT                                         (26u)
#define RCAN_RSCAN0TMIEC0_TMIE27                                               (0x08000000u)
#define RCAN_RSCAN0TMIEC0_TMIE27_SHIFT                                         (27u)
#define RCAN_RSCAN0TMIEC0_TMIE28                                               (0x10000000u)
#define RCAN_RSCAN0TMIEC0_TMIE28_SHIFT                                         (28u)
#define RCAN_RSCAN0TMIEC0_TMIE29                                               (0x20000000u)
#define RCAN_RSCAN0TMIEC0_TMIE29_SHIFT                                         (29u)
#define RCAN_RSCAN0TMIEC0_TMIE30                                               (0x40000000u)
#define RCAN_RSCAN0TMIEC0_TMIE30_SHIFT                                         (30u)
#define RCAN_RSCAN0TMIEC0_TMIE31                                               (0x80000000u)
#define RCAN_RSCAN0TMIEC0_TMIE31_SHIFT                                         (31u)
#define RCAN_RSCAN0TXQCC0_TXQE                                                 (0x00000001u)
#define RCAN_RSCAN0TXQCC0_TXQE_SHIFT                                           (0u)
#define RCAN_RSCAN0TXQCC0_TXQDC                                                (0x00000F00u)
#define RCAN_RSCAN0TXQCC0_TXQDC_SHIFT                                          (8u)
#define RCAN_RSCAN0TXQCC0_TXQIE                                                (0x00001000u)
#define RCAN_RSCAN0TXQCC0_TXQIE_SHIFT                                          (12u)
#define RCAN_RSCAN0TXQCC0_TXQIM                                                (0x00002000u)
#define RCAN_RSCAN0TXQCC0_TXQIM_SHIFT                                          (13u)
#define RCAN_RSCAN0TXQCC1_TXQE                                                 (0x00000001u)
#define RCAN_RSCAN0TXQCC1_TXQE_SHIFT                                           (0u)
#define RCAN_RSCAN0TXQCC1_TXQDC                                                (0x00000F00u)
#define RCAN_RSCAN0TXQCC1_TXQDC_SHIFT                                          (8u)
#define RCAN_RSCAN0TXQCC1_TXQIE                                                (0x00001000u)
#define RCAN_RSCAN0TXQCC1_TXQIE_SHIFT                                          (12u)
#define RCAN_RSCAN0TXQCC1_TXQIM                                                (0x00002000u)
#define RCAN_RSCAN0TXQCC1_TXQIM_SHIFT                                          (13u)
#define RCAN_RSCAN0TXQSTS0_TXQEMP                                              (0x00000001u)
#define RCAN_RSCAN0TXQSTS0_TXQEMP_SHIFT                                        (0u)
#define RCAN_RSCAN0TXQSTS0_TXQFLL                                              (0x00000002u)
#define RCAN_RSCAN0TXQSTS0_TXQFLL_SHIFT                                        (1u)
#define RCAN_RSCAN0TXQSTS0_TXQIF                                               (0x00000004u)
#define RCAN_RSCAN0TXQSTS0_TXQIF_SHIFT                                         (2u)
#define RCAN_RSCAN0TXQSTS1_TXQEMP                                              (0x00000001u)
#define RCAN_RSCAN0TXQSTS1_TXQEMP_SHIFT                                        (0u)
#define RCAN_RSCAN0TXQSTS1_TXQFLL                                              (0x00000002u)
#define RCAN_RSCAN0TXQSTS1_TXQFLL_SHIFT                                        (1u)
#define RCAN_RSCAN0TXQSTS1_TXQIF                                               (0x00000004u)
#define RCAN_RSCAN0TXQSTS1_TXQIF_SHIFT                                         (2u)
#define RCAN_RSCAN0TXQPCTR0_TXQPC                                              (0x000000FFu)
#define RCAN_RSCAN0TXQPCTR0_TXQPC_SHIFT                                        (0u)
#define RCAN_RSCAN0TXQPCTR1_TXQPC                                              (0x000000FFu)
#define RCAN_RSCAN0TXQPCTR1_TXQPC_SHIFT                                        (0u)
#define RCAN_RSCAN0THLCC0_THLE                                                 (0x00000001u)
#define RCAN_RSCAN0THLCC0_THLE_SHIFT                                           (0u)
#define RCAN_RSCAN0THLCC0_THLIE                                                (0x00000100u)
#define RCAN_RSCAN0THLCC0_THLIE_SHIFT                                          (8u)
#define RCAN_RSCAN0THLCC0_THLIM                                                (0x00000200u)
#define RCAN_RSCAN0THLCC0_THLIM_SHIFT                                          (9u)
#define RCAN_RSCAN0THLCC0_THLDTE                                               (0x00000400u)
#define RCAN_RSCAN0THLCC0_THLDTE_SHIFT                                         (10u)
#define RCAN_RSCAN0THLCC1_THLE                                                 (0x00000001u)
#define RCAN_RSCAN0THLCC1_THLE_SHIFT                                           (0u)
#define RCAN_RSCAN0THLCC1_THLIE                                                (0x00000100u)
#define RCAN_RSCAN0THLCC1_THLIE_SHIFT                                          (8u)
#define RCAN_RSCAN0THLCC1_THLIM                                                (0x00000200u)
#define RCAN_RSCAN0THLCC1_THLIM_SHIFT                                          (9u)
#define RCAN_RSCAN0THLCC1_THLDTE                                               (0x00000400u)
#define RCAN_RSCAN0THLCC1_THLDTE_SHIFT                                         (10u)
#define RCAN_RSCAN0THLSTS0_THLEMP                                              (0x00000001u)
#define RCAN_RSCAN0THLSTS0_THLEMP_SHIFT                                        (0u)
#define RCAN_RSCAN0THLSTS0_THLFLL                                              (0x00000002u)
#define RCAN_RSCAN0THLSTS0_THLFLL_SHIFT                                        (1u)
#define RCAN_RSCAN0THLSTS0_THLELT                                              (0x00000004u)
#define RCAN_RSCAN0THLSTS0_THLELT_SHIFT                                        (2u)
#define RCAN_RSCAN0THLSTS0_THLIF                                               (0x00000008u)
#define RCAN_RSCAN0THLSTS0_THLIF_SHIFT                                         (3u)
#define RCAN_RSCAN0THLSTS0_THLMC                                               (0x00001F00u)
#define RCAN_RSCAN0THLSTS0_THLMC_SHIFT                                         (8u)
#define RCAN_RSCAN0THLSTS1_THLEMP                                              (0x00000001u)
#define RCAN_RSCAN0THLSTS1_THLEMP_SHIFT                                        (0u)
#define RCAN_RSCAN0THLSTS1_THLFLL                                              (0x00000002u)
#define RCAN_RSCAN0THLSTS1_THLFLL_SHIFT                                        (1u)
#define RCAN_RSCAN0THLSTS1_THLELT                                              (0x00000004u)
#define RCAN_RSCAN0THLSTS1_THLELT_SHIFT                                        (2u)
#define RCAN_RSCAN0THLSTS1_THLIF                                               (0x00000008u)
#define RCAN_RSCAN0THLSTS1_THLIF_SHIFT                                         (3u)
#define RCAN_RSCAN0THLSTS1_THLMC                                               (0x00001F00u)
#define RCAN_RSCAN0THLSTS1_THLMC_SHIFT                                         (8u)
#define RCAN_RSCAN0THLPCTR0_THLPC                                              (0x000000FFu)
#define RCAN_RSCAN0THLPCTR0_THLPC_SHIFT                                        (0u)
#define RCAN_RSCAN0THLPCTR1_THLPC                                              (0x000000FFu)
#define RCAN_RSCAN0THLPCTR1_THLPC_SHIFT                                        (0u)
#define RCAN_RSCAN0GTINTSTS0_TSIF0                                             (0x00000001u)
#define RCAN_RSCAN0GTINTSTS0_TSIF0_SHIFT                                       (0u)
#define RCAN_RSCAN0GTINTSTS0_TAIF0                                             (0x00000002u)
#define RCAN_RSCAN0GTINTSTS0_TAIF0_SHIFT                                       (1u)
#define RCAN_RSCAN0GTINTSTS0_TQIF0                                             (0x00000004u)
#define RCAN_RSCAN0GTINTSTS0_TQIF0_SHIFT                                       (2u)
#define RCAN_RSCAN0GTINTSTS0_CFTIF0                                            (0x00000008u)
#define RCAN_RSCAN0GTINTSTS0_CFTIF0_SHIFT                                      (3u)
#define RCAN_RSCAN0GTINTSTS0_THIF0                                             (0x00000010u)
#define RCAN_RSCAN0GTINTSTS0_THIF0_SHIFT                                       (4u)
#define RCAN_RSCAN0GTINTSTS0_TSIF1                                             (0x00000100u)
#define RCAN_RSCAN0GTINTSTS0_TSIF1_SHIFT                                       (8u)
#define RCAN_RSCAN0GTINTSTS0_TAIF1                                             (0x00000200u)
#define RCAN_RSCAN0GTINTSTS0_TAIF1_SHIFT                                       (9u)
#define RCAN_RSCAN0GTINTSTS0_TQIF1                                             (0x00000400u)
#define RCAN_RSCAN0GTINTSTS0_TQIF1_SHIFT                                       (10u)
#define RCAN_RSCAN0GTINTSTS0_CFTIF1                                            (0x00000800u)
#define RCAN_RSCAN0GTINTSTS0_CFTIF1_SHIFT                                      (11u)
#define RCAN_RSCAN0GTINTSTS0_THIF1                                             (0x00001000u)
#define RCAN_RSCAN0GTINTSTS0_THIF1_SHIFT                                       (12u)
#define RCAN_RSCAN0GTSTCFG_C0ICBCE                                             (0x00000001u)
#define RCAN_RSCAN0GTSTCFG_C0ICBCE_SHIFT                                       (0u)
#define RCAN_RSCAN0GTSTCFG_C1ICBCE                                             (0x00000002u)
#define RCAN_RSCAN0GTSTCFG_C1ICBCE_SHIFT                                       (1u)
#define RCAN_RSCAN0GTSTCFG_RTMPS                                               (0x007F0000u)
#define RCAN_RSCAN0GTSTCFG_RTMPS_SHIFT                                         (16u)
#define RCAN_RSCAN0GTSTCTR_ICBCTME                                             (0x00000001u)
#define RCAN_RSCAN0GTSTCTR_ICBCTME_SHIFT                                       (0u)
#define RCAN_RSCAN0GTSTCTR_RTME                                                (0x00000004u)
#define RCAN_RSCAN0GTSTCTR_RTME_SHIFT                                          (2u)
#define RCAN_RSCAN0GFDCFG_TSCCFG                                               (0x00000300u)
#define RCAN_RSCAN0GFDCFG_TSCCFG_SHIFT                                         (8u)
#define RCAN_RSCAN0GLOCKK_LOCK                                                 (0x0000FFFFu)
#define RCAN_RSCAN0GLOCKK_LOCK_SHIFT                                           (0u)
#define RCAN_RSCAN0GRMCFG_RCMC                                                 (0x00000001u)
#define RCAN_RSCAN0GRMCFG_RCMC_SHIFT                                           (0u)
#define RCAN_RSCAN0GAFLID0_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID0_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID0_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID0_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID0_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID0_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID0_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID0_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM0_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM0_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM0_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM0_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM0_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM0_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_0_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_0_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_0_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_0_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_0_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_0_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_0_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_0_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_0_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_0_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID1_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID1_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID1_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID1_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID1_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID1_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID1_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID1_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM1_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM1_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM1_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM1_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM1_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM1_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_1_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_1_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_1_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_1_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_1_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_1_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_1_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_1_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_1_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_1_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID2_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID2_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID2_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID2_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID2_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID2_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID2_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID2_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM2_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM2_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM2_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM2_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM2_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM2_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_2_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_2_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_2_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_2_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_2_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_2_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_2_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_2_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_2_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_2_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID3_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID3_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID3_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID3_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID3_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID3_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID3_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID3_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM3_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM3_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM3_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM3_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM3_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM3_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_3_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_3_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_3_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_3_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_3_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_3_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_3_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_3_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_3_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_3_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID4_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID4_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID4_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID4_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID4_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID4_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID4_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID4_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM4_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM4_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM4_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM4_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM4_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM4_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_4_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_4_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_4_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_4_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_4_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_4_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_4_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_4_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_4_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_4_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID5_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID5_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID5_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID5_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID5_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID5_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID5_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID5_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM5_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM5_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM5_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM5_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM5_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM5_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_5_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_5_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_5_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_5_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_5_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_5_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_5_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_5_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_5_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_5_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID6_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID6_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID6_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID6_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID6_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID6_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID6_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID6_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM6_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM6_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM6_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM6_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM6_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM6_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_6_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_6_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_6_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_6_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_6_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_6_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_6_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_6_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_6_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_6_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID7_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID7_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID7_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID7_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID7_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID7_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID7_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID7_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM7_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM7_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM7_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM7_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM7_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM7_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_7_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_7_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_7_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_7_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_7_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_7_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_7_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_7_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_7_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_7_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID8_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID8_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID8_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID8_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID8_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID8_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID8_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID8_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM8_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM8_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM8_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM8_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM8_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM8_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_8_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_8_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_8_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_8_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_8_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_8_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_8_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_8_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_8_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_8_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID9_GAFLID                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID9_GAFLID_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLID9_GAFLLB                                              (0x20000000u)
#define RCAN_RSCAN0GAFLID9_GAFLLB_SHIFT                                        (29u)
#define RCAN_RSCAN0GAFLID9_GAFLRTR                                             (0x40000000u)
#define RCAN_RSCAN0GAFLID9_GAFLRTR_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLID9_GAFLIDE                                             (0x80000000u)
#define RCAN_RSCAN0GAFLID9_GAFLIDE_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLM9_GAFLIDM                                              (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM9_GAFLIDM_SHIFT                                        (0u)
#define RCAN_RSCAN0GAFLM9_GAFLRTRM                                             (0x40000000u)
#define RCAN_RSCAN0GAFLM9_GAFLRTRM_SHIFT                                       (30u)
#define RCAN_RSCAN0GAFLM9_GAFLIDEM                                             (0x80000000u)
#define RCAN_RSCAN0GAFLM9_GAFLIDEM_SHIFT                                       (31u)
#define RCAN_RSCAN0GAFLP0_9_GAFLRMDP                                           (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_9_GAFLRMDP_SHIFT                                     (8u)
#define RCAN_RSCAN0GAFLP0_9_GAFLRMV                                            (0x00008000u)
#define RCAN_RSCAN0GAFLP0_9_GAFLRMV_SHIFT                                      (15u)
#define RCAN_RSCAN0GAFLP0_9_GAFLPTR                                            (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_9_GAFLPTR_SHIFT                                      (16u)
#define RCAN_RSCAN0GAFLP0_9_GAFLDLC                                            (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_9_GAFLDLC_SHIFT                                      (28u)
#define RCAN_RSCAN0GAFLP1_9_GAFLFDP                                            (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_9_GAFLFDP_SHIFT                                      (0u)
#define RCAN_RSCAN0GAFLID10_GAFLID                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID10_GAFLID_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLID10_GAFLLB                                             (0x20000000u)
#define RCAN_RSCAN0GAFLID10_GAFLLB_SHIFT                                       (29u)
#define RCAN_RSCAN0GAFLID10_GAFLRTR                                            (0x40000000u)
#define RCAN_RSCAN0GAFLID10_GAFLRTR_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLID10_GAFLIDE                                            (0x80000000u)
#define RCAN_RSCAN0GAFLID10_GAFLIDE_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLM10_GAFLIDM                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM10_GAFLIDM_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLM10_GAFLRTRM                                            (0x40000000u)
#define RCAN_RSCAN0GAFLM10_GAFLRTRM_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLM10_GAFLIDEM                                            (0x80000000u)
#define RCAN_RSCAN0GAFLM10_GAFLIDEM_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLP0_10_GAFLRMDP                                          (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_10_GAFLRMDP_SHIFT                                    (8u)
#define RCAN_RSCAN0GAFLP0_10_GAFLRMV                                           (0x00008000u)
#define RCAN_RSCAN0GAFLP0_10_GAFLRMV_SHIFT                                     (15u)
#define RCAN_RSCAN0GAFLP0_10_GAFLPTR                                           (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_10_GAFLPTR_SHIFT                                     (16u)
#define RCAN_RSCAN0GAFLP0_10_GAFLDLC                                           (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_10_GAFLDLC_SHIFT                                     (28u)
#define RCAN_RSCAN0GAFLP1_10_GAFLFDP                                           (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_10_GAFLFDP_SHIFT                                     (0u)
#define RCAN_RSCAN0GAFLID11_GAFLID                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID11_GAFLID_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLID11_GAFLLB                                             (0x20000000u)
#define RCAN_RSCAN0GAFLID11_GAFLLB_SHIFT                                       (29u)
#define RCAN_RSCAN0GAFLID11_GAFLRTR                                            (0x40000000u)
#define RCAN_RSCAN0GAFLID11_GAFLRTR_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLID11_GAFLIDE                                            (0x80000000u)
#define RCAN_RSCAN0GAFLID11_GAFLIDE_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLM11_GAFLIDM                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM11_GAFLIDM_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLM11_GAFLRTRM                                            (0x40000000u)
#define RCAN_RSCAN0GAFLM11_GAFLRTRM_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLM11_GAFLIDEM                                            (0x80000000u)
#define RCAN_RSCAN0GAFLM11_GAFLIDEM_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLP0_11_GAFLRMDP                                          (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_11_GAFLRMDP_SHIFT                                    (8u)
#define RCAN_RSCAN0GAFLP0_11_GAFLRMV                                           (0x00008000u)
#define RCAN_RSCAN0GAFLP0_11_GAFLRMV_SHIFT                                     (15u)
#define RCAN_RSCAN0GAFLP0_11_GAFLPTR                                           (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_11_GAFLPTR_SHIFT                                     (16u)
#define RCAN_RSCAN0GAFLP0_11_GAFLDLC                                           (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_11_GAFLDLC_SHIFT                                     (28u)
#define RCAN_RSCAN0GAFLP1_11_GAFLFDP                                           (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_11_GAFLFDP_SHIFT                                     (0u)
#define RCAN_RSCAN0GAFLID12_GAFLID                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID12_GAFLID_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLID12_GAFLLB                                             (0x20000000u)
#define RCAN_RSCAN0GAFLID12_GAFLLB_SHIFT                                       (29u)
#define RCAN_RSCAN0GAFLID12_GAFLRTR                                            (0x40000000u)
#define RCAN_RSCAN0GAFLID12_GAFLRTR_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLID12_GAFLIDE                                            (0x80000000u)
#define RCAN_RSCAN0GAFLID12_GAFLIDE_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLM12_GAFLIDM                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM12_GAFLIDM_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLM12_GAFLRTRM                                            (0x40000000u)
#define RCAN_RSCAN0GAFLM12_GAFLRTRM_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLM12_GAFLIDEM                                            (0x80000000u)
#define RCAN_RSCAN0GAFLM12_GAFLIDEM_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLP0_12_GAFLRMDP                                          (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_12_GAFLRMDP_SHIFT                                    (8u)
#define RCAN_RSCAN0GAFLP0_12_GAFLRMV                                           (0x00008000u)
#define RCAN_RSCAN0GAFLP0_12_GAFLRMV_SHIFT                                     (15u)
#define RCAN_RSCAN0GAFLP0_12_GAFLPTR                                           (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_12_GAFLPTR_SHIFT                                     (16u)
#define RCAN_RSCAN0GAFLP0_12_GAFLDLC                                           (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_12_GAFLDLC_SHIFT                                     (28u)
#define RCAN_RSCAN0GAFLP1_12_GAFLFDP                                           (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_12_GAFLFDP_SHIFT                                     (0u)
#define RCAN_RSCAN0GAFLID13_GAFLID                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID13_GAFLID_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLID13_GAFLLB                                             (0x20000000u)
#define RCAN_RSCAN0GAFLID13_GAFLLB_SHIFT                                       (29u)
#define RCAN_RSCAN0GAFLID13_GAFLRTR                                            (0x40000000u)
#define RCAN_RSCAN0GAFLID13_GAFLRTR_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLID13_GAFLIDE                                            (0x80000000u)
#define RCAN_RSCAN0GAFLID13_GAFLIDE_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLM13_GAFLIDM                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM13_GAFLIDM_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLM13_GAFLRTRM                                            (0x40000000u)
#define RCAN_RSCAN0GAFLM13_GAFLRTRM_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLM13_GAFLIDEM                                            (0x80000000u)
#define RCAN_RSCAN0GAFLM13_GAFLIDEM_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLP0_13_GAFLRMDP                                          (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_13_GAFLRMDP_SHIFT                                    (8u)
#define RCAN_RSCAN0GAFLP0_13_GAFLRMV                                           (0x00008000u)
#define RCAN_RSCAN0GAFLP0_13_GAFLRMV_SHIFT                                     (15u)
#define RCAN_RSCAN0GAFLP0_13_GAFLPTR                                           (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_13_GAFLPTR_SHIFT                                     (16u)
#define RCAN_RSCAN0GAFLP0_13_GAFLDLC                                           (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_13_GAFLDLC_SHIFT                                     (28u)
#define RCAN_RSCAN0GAFLP1_13_GAFLFDP                                           (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_13_GAFLFDP_SHIFT                                     (0u)
#define RCAN_RSCAN0GAFLID14_GAFLID                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID14_GAFLID_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLID14_GAFLLB                                             (0x20000000u)
#define RCAN_RSCAN0GAFLID14_GAFLLB_SHIFT                                       (29u)
#define RCAN_RSCAN0GAFLID14_GAFLRTR                                            (0x40000000u)
#define RCAN_RSCAN0GAFLID14_GAFLRTR_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLID14_GAFLIDE                                            (0x80000000u)
#define RCAN_RSCAN0GAFLID14_GAFLIDE_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLM14_GAFLIDM                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM14_GAFLIDM_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLM14_GAFLRTRM                                            (0x40000000u)
#define RCAN_RSCAN0GAFLM14_GAFLRTRM_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLM14_GAFLIDEM                                            (0x80000000u)
#define RCAN_RSCAN0GAFLM14_GAFLIDEM_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLP0_14_GAFLRMDP                                          (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_14_GAFLRMDP_SHIFT                                    (8u)
#define RCAN_RSCAN0GAFLP0_14_GAFLRMV                                           (0x00008000u)
#define RCAN_RSCAN0GAFLP0_14_GAFLRMV_SHIFT                                     (15u)
#define RCAN_RSCAN0GAFLP0_14_GAFLPTR                                           (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_14_GAFLPTR_SHIFT                                     (16u)
#define RCAN_RSCAN0GAFLP0_14_GAFLDLC                                           (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_14_GAFLDLC_SHIFT                                     (28u)
#define RCAN_RSCAN0GAFLP1_14_GAFLFDP                                           (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_14_GAFLFDP_SHIFT                                     (0u)
#define RCAN_RSCAN0GAFLID15_GAFLID                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLID15_GAFLID_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLID15_GAFLLB                                             (0x20000000u)
#define RCAN_RSCAN0GAFLID15_GAFLLB_SHIFT                                       (29u)
#define RCAN_RSCAN0GAFLID15_GAFLRTR                                            (0x40000000u)
#define RCAN_RSCAN0GAFLID15_GAFLRTR_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLID15_GAFLIDE                                            (0x80000000u)
#define RCAN_RSCAN0GAFLID15_GAFLIDE_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLM15_GAFLIDM                                             (0x1FFFFFFFu)
#define RCAN_RSCAN0GAFLM15_GAFLIDM_SHIFT                                       (0u)
#define RCAN_RSCAN0GAFLM15_GAFLRTRM                                            (0x40000000u)
#define RCAN_RSCAN0GAFLM15_GAFLRTRM_SHIFT                                      (30u)
#define RCAN_RSCAN0GAFLM15_GAFLIDEM                                            (0x80000000u)
#define RCAN_RSCAN0GAFLM15_GAFLIDEM_SHIFT                                      (31u)
#define RCAN_RSCAN0GAFLP0_15_GAFLRMDP                                          (0x00007F00u)
#define RCAN_RSCAN0GAFLP0_15_GAFLRMDP_SHIFT                                    (8u)
#define RCAN_RSCAN0GAFLP0_15_GAFLRMV                                           (0x00008000u)
#define RCAN_RSCAN0GAFLP0_15_GAFLRMV_SHIFT                                     (15u)
#define RCAN_RSCAN0GAFLP0_15_GAFLPTR                                           (0x0FFF0000u)
#define RCAN_RSCAN0GAFLP0_15_GAFLPTR_SHIFT                                     (16u)
#define RCAN_RSCAN0GAFLP0_15_GAFLDLC                                           (0xF0000000u)
#define RCAN_RSCAN0GAFLP0_15_GAFLDLC_SHIFT                                     (28u)
#define RCAN_RSCAN0GAFLP1_15_GAFLFDP                                           (0x00003FFFu)
#define RCAN_RSCAN0GAFLP1_15_GAFLFDP_SHIFT                                     (0u)
#define RCAN_RSCAN0RMID0_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID0_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID0_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID0_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID0_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID0_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR0_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR0_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR0_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR0_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR0_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR0_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_0_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_0_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_0_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_0_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_0_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_0_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_0_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_0_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_0_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_0_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_0_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_0_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_0_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_0_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_0_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_0_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID1_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID1_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID1_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID1_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID1_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID1_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR1_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR1_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR1_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR1_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR1_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR1_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_1_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_1_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_1_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_1_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_1_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_1_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_1_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_1_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_1_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_1_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_1_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_1_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_1_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_1_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_1_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_1_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID2_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID2_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID2_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID2_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID2_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID2_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR2_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR2_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR2_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR2_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR2_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR2_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_2_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_2_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_2_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_2_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_2_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_2_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_2_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_2_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_2_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_2_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_2_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_2_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_2_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_2_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_2_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_2_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID3_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID3_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID3_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID3_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID3_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID3_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR3_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR3_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR3_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR3_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR3_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR3_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_3_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_3_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_3_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_3_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_3_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_3_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_3_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_3_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_3_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_3_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_3_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_3_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_3_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_3_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_3_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_3_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID4_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID4_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID4_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID4_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID4_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID4_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR4_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR4_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR4_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR4_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR4_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR4_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_4_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_4_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_4_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_4_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_4_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_4_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_4_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_4_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_4_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_4_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_4_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_4_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_4_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_4_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_4_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_4_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID5_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID5_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID5_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID5_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID5_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID5_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR5_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR5_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR5_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR5_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR5_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR5_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_5_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_5_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_5_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_5_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_5_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_5_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_5_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_5_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_5_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_5_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_5_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_5_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_5_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_5_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_5_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_5_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID6_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID6_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID6_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID6_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID6_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID6_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR6_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR6_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR6_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR6_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR6_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR6_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_6_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_6_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_6_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_6_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_6_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_6_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_6_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_6_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_6_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_6_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_6_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_6_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_6_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_6_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_6_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_6_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID7_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID7_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID7_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID7_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID7_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID7_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR7_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR7_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR7_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR7_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR7_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR7_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_7_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_7_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_7_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_7_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_7_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_7_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_7_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_7_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_7_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_7_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_7_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_7_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_7_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_7_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_7_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_7_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID8_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID8_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID8_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID8_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID8_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID8_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR8_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR8_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR8_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR8_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR8_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR8_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_8_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_8_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_8_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_8_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_8_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_8_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_8_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_8_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_8_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_8_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_8_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_8_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_8_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_8_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_8_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_8_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID9_RMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID9_RMID_SHIFT                                            (0u)
#define RCAN_RSCAN0RMID9_RMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RMID9_RMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RMID9_RMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RMID9_RMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RMPTR9_RMTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR9_RMTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RMPTR9_RMPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR9_RMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RMPTR9_RMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RMPTR9_RMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RMDF0_9_RMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF0_9_RMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF0_9_RMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_9_RMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF0_9_RMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_9_RMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF0_9_RMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF0_9_RMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RMDF1_9_RMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RMDF1_9_RMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RMDF1_9_RMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_9_RMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RMDF1_9_RMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_9_RMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RMDF1_9_RMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RMDF1_9_RMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RMID10_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID10_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID10_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID10_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID10_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID10_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR10_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR10_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR10_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR10_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR10_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR10_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_10_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_10_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_10_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_10_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_10_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_10_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_10_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_10_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_10_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_10_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_10_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_10_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_10_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_10_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_10_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_10_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID11_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID11_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID11_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID11_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID11_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID11_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR11_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR11_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR11_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR11_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR11_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR11_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_11_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_11_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_11_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_11_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_11_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_11_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_11_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_11_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_11_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_11_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_11_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_11_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_11_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_11_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_11_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_11_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID12_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID12_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID12_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID12_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID12_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID12_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR12_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR12_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR12_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR12_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR12_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR12_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_12_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_12_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_12_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_12_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_12_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_12_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_12_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_12_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_12_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_12_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_12_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_12_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_12_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_12_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_12_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_12_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID13_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID13_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID13_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID13_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID13_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID13_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR13_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR13_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR13_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR13_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR13_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR13_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_13_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_13_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_13_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_13_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_13_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_13_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_13_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_13_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_13_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_13_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_13_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_13_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_13_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_13_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_13_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_13_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID14_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID14_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID14_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID14_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID14_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID14_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR14_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR14_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR14_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR14_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR14_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR14_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_14_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_14_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_14_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_14_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_14_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_14_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_14_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_14_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_14_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_14_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_14_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_14_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_14_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_14_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_14_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_14_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID15_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID15_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID15_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID15_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID15_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID15_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR15_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR15_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR15_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR15_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR15_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR15_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_15_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_15_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_15_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_15_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_15_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_15_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_15_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_15_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_15_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_15_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_15_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_15_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_15_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_15_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_15_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_15_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID16_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID16_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID16_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID16_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID16_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID16_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR16_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR16_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR16_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR16_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR16_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR16_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_16_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_16_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_16_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_16_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_16_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_16_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_16_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_16_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_16_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_16_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_16_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_16_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_16_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_16_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_16_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_16_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID17_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID17_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID17_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID17_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID17_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID17_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR17_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR17_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR17_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR17_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR17_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR17_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_17_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_17_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_17_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_17_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_17_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_17_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_17_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_17_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_17_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_17_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_17_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_17_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_17_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_17_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_17_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_17_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID18_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID18_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID18_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID18_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID18_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID18_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR18_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR18_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR18_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR18_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR18_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR18_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_18_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_18_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_18_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_18_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_18_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_18_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_18_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_18_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_18_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_18_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_18_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_18_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_18_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_18_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_18_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_18_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID19_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID19_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID19_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID19_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID19_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID19_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR19_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR19_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR19_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR19_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR19_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR19_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_19_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_19_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_19_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_19_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_19_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_19_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_19_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_19_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_19_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_19_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_19_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_19_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_19_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_19_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_19_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_19_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID20_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID20_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID20_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID20_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID20_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID20_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR20_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR20_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR20_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR20_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR20_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR20_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_20_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_20_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_20_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_20_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_20_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_20_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_20_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_20_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_20_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_20_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_20_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_20_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_20_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_20_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_20_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_20_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID21_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID21_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID21_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID21_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID21_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID21_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR21_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR21_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR21_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR21_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR21_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR21_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_21_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_21_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_21_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_21_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_21_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_21_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_21_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_21_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_21_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_21_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_21_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_21_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_21_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_21_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_21_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_21_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID22_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID22_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID22_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID22_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID22_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID22_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR22_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR22_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR22_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR22_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR22_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR22_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_22_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_22_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_22_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_22_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_22_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_22_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_22_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_22_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_22_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_22_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_22_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_22_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_22_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_22_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_22_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_22_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID23_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID23_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID23_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID23_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID23_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID23_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR23_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR23_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR23_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR23_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR23_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR23_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_23_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_23_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_23_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_23_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_23_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_23_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_23_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_23_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_23_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_23_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_23_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_23_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_23_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_23_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_23_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_23_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID24_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID24_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID24_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID24_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID24_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID24_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR24_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR24_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR24_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR24_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR24_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR24_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_24_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_24_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_24_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_24_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_24_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_24_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_24_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_24_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_24_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_24_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_24_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_24_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_24_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_24_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_24_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_24_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID25_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID25_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID25_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID25_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID25_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID25_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR25_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR25_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR25_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR25_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR25_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR25_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_25_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_25_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_25_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_25_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_25_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_25_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_25_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_25_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_25_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_25_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_25_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_25_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_25_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_25_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_25_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_25_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID26_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID26_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID26_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID26_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID26_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID26_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR26_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR26_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR26_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR26_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR26_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR26_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_26_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_26_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_26_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_26_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_26_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_26_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_26_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_26_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_26_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_26_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_26_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_26_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_26_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_26_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_26_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_26_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID27_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID27_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID27_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID27_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID27_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID27_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR27_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR27_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR27_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR27_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR27_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR27_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_27_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_27_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_27_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_27_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_27_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_27_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_27_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_27_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_27_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_27_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_27_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_27_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_27_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_27_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_27_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_27_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID28_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID28_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID28_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID28_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID28_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID28_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR28_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR28_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR28_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR28_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR28_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR28_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_28_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_28_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_28_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_28_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_28_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_28_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_28_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_28_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_28_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_28_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_28_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_28_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_28_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_28_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_28_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_28_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID29_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID29_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID29_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID29_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID29_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID29_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR29_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR29_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR29_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR29_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR29_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR29_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_29_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_29_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_29_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_29_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_29_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_29_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_29_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_29_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_29_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_29_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_29_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_29_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_29_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_29_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_29_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_29_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID30_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID30_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID30_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID30_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID30_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID30_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR30_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR30_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR30_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR30_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR30_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR30_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_30_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_30_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_30_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_30_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_30_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_30_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_30_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_30_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_30_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_30_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_30_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_30_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_30_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_30_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_30_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_30_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RMID31_RMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0RMID31_RMID_SHIFT                                           (0u)
#define RCAN_RSCAN0RMID31_RMRTR                                                (0x40000000u)
#define RCAN_RSCAN0RMID31_RMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0RMID31_RMIDE                                                (0x80000000u)
#define RCAN_RSCAN0RMID31_RMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0RMPTR31_RMTS                                                (0x0000FFFFu)
#define RCAN_RSCAN0RMPTR31_RMTS_SHIFT                                          (0u)
#define RCAN_RSCAN0RMPTR31_RMPTR                                               (0x0FFF0000u)
#define RCAN_RSCAN0RMPTR31_RMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0RMPTR31_RMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0RMPTR31_RMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0RMDF0_31_RMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF0_31_RMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF0_31_RMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF0_31_RMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF0_31_RMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF0_31_RMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF0_31_RMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF0_31_RMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0RMDF1_31_RMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0RMDF1_31_RMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0RMDF1_31_RMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0RMDF1_31_RMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0RMDF1_31_RMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0RMDF1_31_RMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0RMDF1_31_RMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0RMDF1_31_RMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0RFID0_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID0_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID0_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID0_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID0_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID0_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR0_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR0_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR0_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR0_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR0_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR0_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_0_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_0_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_0_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_0_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_0_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_0_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_0_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_0_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_0_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_0_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_0_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_0_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_0_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_0_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_0_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_0_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RFID1_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID1_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID1_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID1_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID1_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID1_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR1_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR1_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR1_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR1_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR1_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR1_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_1_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_1_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_1_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_1_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_1_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_1_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_1_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_1_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_1_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_1_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_1_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_1_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_1_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_1_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_1_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_1_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RFID2_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID2_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID2_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID2_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID2_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID2_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR2_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR2_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR2_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR2_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR2_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR2_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_2_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_2_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_2_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_2_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_2_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_2_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_2_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_2_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_2_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_2_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_2_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_2_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_2_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_2_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_2_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_2_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RFID3_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID3_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID3_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID3_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID3_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID3_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR3_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR3_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR3_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR3_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR3_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR3_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_3_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_3_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_3_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_3_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_3_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_3_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_3_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_3_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_3_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_3_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_3_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_3_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_3_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_3_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_3_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_3_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RFID4_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID4_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID4_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID4_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID4_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID4_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR4_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR4_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR4_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR4_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR4_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR4_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_4_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_4_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_4_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_4_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_4_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_4_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_4_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_4_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_4_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_4_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_4_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_4_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_4_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_4_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_4_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_4_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RFID5_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID5_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID5_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID5_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID5_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID5_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR5_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR5_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR5_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR5_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR5_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR5_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_5_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_5_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_5_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_5_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_5_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_5_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_5_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_5_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_5_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_5_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_5_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_5_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_5_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_5_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_5_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_5_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RFID6_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID6_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID6_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID6_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID6_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID6_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR6_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR6_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR6_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR6_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR6_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR6_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_6_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_6_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_6_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_6_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_6_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_6_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_6_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_6_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_6_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_6_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_6_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_6_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_6_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_6_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_6_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_6_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0RFID7_RFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0RFID7_RFID_SHIFT                                            (0u)
#define RCAN_RSCAN0RFID7_RFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0RFID7_RFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0RFID7_RFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0RFID7_RFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0RFPTR7_RFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0RFPTR7_RFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0RFPTR7_RFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0RFPTR7_RFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0RFPTR7_RFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0RFPTR7_RFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0RFDF0_7_RFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF0_7_RFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF0_7_RFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF0_7_RFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF0_7_RFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF0_7_RFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF0_7_RFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF0_7_RFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0RFDF1_7_RFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0RFDF1_7_RFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0RFDF1_7_RFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0RFDF1_7_RFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0RFDF1_7_RFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0RFDF1_7_RFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0RFDF1_7_RFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0RFDF1_7_RFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0CFID0_CFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0CFID0_CFID_SHIFT                                            (0u)
#define RCAN_RSCAN0CFID0_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0CFID0_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0CFID0_CFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0CFID0_CFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0CFID0_CFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0CFID0_CFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0CFPTR0_CFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0CFPTR0_CFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0CFPTR0_CFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0CFPTR0_CFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0CFPTR0_CFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0CFPTR0_CFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0CFDF0_0_CFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF0_0_CFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF0_0_CFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF0_0_CFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF0_0_CFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF0_0_CFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF0_0_CFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF0_0_CFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0CFDF1_0_CFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF1_0_CFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF1_0_CFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF1_0_CFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF1_0_CFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF1_0_CFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF1_0_CFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF1_0_CFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0CFID1_CFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0CFID1_CFID_SHIFT                                            (0u)
#define RCAN_RSCAN0CFID1_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0CFID1_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0CFID1_CFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0CFID1_CFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0CFID1_CFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0CFID1_CFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0CFPTR1_CFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0CFPTR1_CFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0CFPTR1_CFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0CFPTR1_CFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0CFPTR1_CFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0CFPTR1_CFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0CFDF0_1_CFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF0_1_CFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF0_1_CFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF0_1_CFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF0_1_CFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF0_1_CFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF0_1_CFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF0_1_CFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0CFDF1_1_CFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF1_1_CFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF1_1_CFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF1_1_CFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF1_1_CFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF1_1_CFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF1_1_CFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF1_1_CFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0CFID2_CFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0CFID2_CFID_SHIFT                                            (0u)
#define RCAN_RSCAN0CFID2_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0CFID2_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0CFID2_CFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0CFID2_CFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0CFID2_CFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0CFID2_CFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0CFPTR2_CFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0CFPTR2_CFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0CFPTR2_CFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0CFPTR2_CFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0CFPTR2_CFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0CFPTR2_CFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0CFDF0_2_CFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF0_2_CFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF0_2_CFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF0_2_CFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF0_2_CFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF0_2_CFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF0_2_CFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF0_2_CFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0CFDF1_2_CFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF1_2_CFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF1_2_CFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF1_2_CFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF1_2_CFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF1_2_CFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF1_2_CFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF1_2_CFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0CFID3_CFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0CFID3_CFID_SHIFT                                            (0u)
#define RCAN_RSCAN0CFID3_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0CFID3_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0CFID3_CFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0CFID3_CFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0CFID3_CFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0CFID3_CFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0CFPTR3_CFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0CFPTR3_CFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0CFPTR3_CFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0CFPTR3_CFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0CFPTR3_CFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0CFPTR3_CFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0CFDF0_3_CFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF0_3_CFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF0_3_CFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF0_3_CFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF0_3_CFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF0_3_CFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF0_3_CFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF0_3_CFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0CFDF1_3_CFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF1_3_CFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF1_3_CFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF1_3_CFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF1_3_CFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF1_3_CFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF1_3_CFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF1_3_CFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0CFID4_CFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0CFID4_CFID_SHIFT                                            (0u)
#define RCAN_RSCAN0CFID4_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0CFID4_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0CFID4_CFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0CFID4_CFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0CFID4_CFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0CFID4_CFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0CFPTR4_CFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0CFPTR4_CFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0CFPTR4_CFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0CFPTR4_CFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0CFPTR4_CFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0CFPTR4_CFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0CFDF0_4_CFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF0_4_CFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF0_4_CFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF0_4_CFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF0_4_CFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF0_4_CFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF0_4_CFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF0_4_CFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0CFDF1_4_CFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF1_4_CFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF1_4_CFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF1_4_CFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF1_4_CFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF1_4_CFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF1_4_CFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF1_4_CFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0CFID5_CFID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0CFID5_CFID_SHIFT                                            (0u)
#define RCAN_RSCAN0CFID5_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0CFID5_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0CFID5_CFRTR                                                 (0x40000000u)
#define RCAN_RSCAN0CFID5_CFRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0CFID5_CFIDE                                                 (0x80000000u)
#define RCAN_RSCAN0CFID5_CFIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0CFPTR5_CFTS                                                 (0x0000FFFFu)
#define RCAN_RSCAN0CFPTR5_CFTS_SHIFT                                           (0u)
#define RCAN_RSCAN0CFPTR5_CFPTR                                                (0x0FFF0000u)
#define RCAN_RSCAN0CFPTR5_CFPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0CFPTR5_CFDLC                                                (0xF0000000u)
#define RCAN_RSCAN0CFPTR5_CFDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0CFDF0_5_CFDB0                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF0_5_CFDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF0_5_CFDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF0_5_CFDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF0_5_CFDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF0_5_CFDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF0_5_CFDB3                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF0_5_CFDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0CFDF1_5_CFDB4                                               (0x000000FFu)
#define RCAN_RSCAN0CFDF1_5_CFDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0CFDF1_5_CFDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0CFDF1_5_CFDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0CFDF1_5_CFDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0CFDF1_5_CFDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0CFDF1_5_CFDB7                                               (0xFF000000u)
#define RCAN_RSCAN0CFDF1_5_CFDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID0_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID0_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID0_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID0_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID0_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID0_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID0_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID0_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR0_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR0_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR0_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR0_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_0_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_0_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_0_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_0_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_0_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_0_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_0_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_0_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_0_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_0_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_0_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_0_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_0_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_0_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_0_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_0_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID1_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID1_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID1_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID1_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID1_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID1_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID1_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID1_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR1_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR1_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR1_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR1_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_1_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_1_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_1_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_1_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_1_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_1_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_1_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_1_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_1_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_1_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_1_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_1_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_1_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_1_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_1_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_1_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID2_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID2_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID2_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID2_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID2_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID2_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID2_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID2_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR2_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR2_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR2_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR2_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_2_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_2_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_2_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_2_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_2_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_2_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_2_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_2_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_2_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_2_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_2_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_2_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_2_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_2_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_2_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_2_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID3_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID3_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID3_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID3_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID3_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID3_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID3_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID3_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR3_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR3_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR3_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR3_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_3_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_3_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_3_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_3_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_3_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_3_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_3_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_3_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_3_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_3_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_3_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_3_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_3_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_3_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_3_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_3_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID4_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID4_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID4_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID4_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID4_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID4_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID4_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID4_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR4_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR4_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR4_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR4_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_4_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_4_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_4_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_4_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_4_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_4_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_4_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_4_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_4_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_4_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_4_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_4_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_4_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_4_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_4_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_4_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID5_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID5_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID5_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID5_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID5_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID5_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID5_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID5_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR5_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR5_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR5_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR5_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_5_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_5_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_5_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_5_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_5_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_5_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_5_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_5_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_5_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_5_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_5_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_5_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_5_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_5_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_5_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_5_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID6_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID6_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID6_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID6_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID6_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID6_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID6_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID6_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR6_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR6_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR6_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR6_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_6_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_6_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_6_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_6_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_6_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_6_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_6_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_6_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_6_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_6_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_6_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_6_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_6_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_6_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_6_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_6_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID7_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID7_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID7_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID7_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID7_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID7_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID7_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID7_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR7_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR7_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR7_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR7_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_7_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_7_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_7_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_7_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_7_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_7_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_7_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_7_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_7_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_7_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_7_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_7_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_7_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_7_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_7_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_7_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID8_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID8_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID8_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID8_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID8_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID8_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID8_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID8_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR8_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR8_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR8_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR8_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_8_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_8_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_8_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_8_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_8_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_8_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_8_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_8_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_8_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_8_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_8_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_8_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_8_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_8_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_8_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_8_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID9_TMID                                                  (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID9_TMID_SHIFT                                            (0u)
#define RCAN_RSCAN0TMID9_THLEN                                                 (0x20000000u)
#define RCAN_RSCAN0TMID9_THLEN_SHIFT                                           (29u)
#define RCAN_RSCAN0TMID9_TMRTR                                                 (0x40000000u)
#define RCAN_RSCAN0TMID9_TMRTR_SHIFT                                           (30u)
#define RCAN_RSCAN0TMID9_TMIDE                                                 (0x80000000u)
#define RCAN_RSCAN0TMID9_TMIDE_SHIFT                                           (31u)
#define RCAN_RSCAN0TMPTR9_TMPTR                                                (0x00FF0000u)
#define RCAN_RSCAN0TMPTR9_TMPTR_SHIFT                                          (16u)
#define RCAN_RSCAN0TMPTR9_TMDLC                                                (0xF0000000u)
#define RCAN_RSCAN0TMPTR9_TMDLC_SHIFT                                          (28u)
#define RCAN_RSCAN0TMDF0_9_TMDB0                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF0_9_TMDB0_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF0_9_TMDB1                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_9_TMDB1_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF0_9_TMDB2                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_9_TMDB2_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF0_9_TMDB3                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF0_9_TMDB3_SHIFT                                         (24u)
#define RCAN_RSCAN0TMDF1_9_TMDB4                                               (0x000000FFu)
#define RCAN_RSCAN0TMDF1_9_TMDB4_SHIFT                                         (0u)
#define RCAN_RSCAN0TMDF1_9_TMDB5                                               (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_9_TMDB5_SHIFT                                         (8u)
#define RCAN_RSCAN0TMDF1_9_TMDB6                                               (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_9_TMDB6_SHIFT                                         (16u)
#define RCAN_RSCAN0TMDF1_9_TMDB7                                               (0xFF000000u)
#define RCAN_RSCAN0TMDF1_9_TMDB7_SHIFT                                         (24u)
#define RCAN_RSCAN0TMID10_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID10_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID10_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID10_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID10_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID10_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID10_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID10_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR10_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR10_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR10_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR10_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_10_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_10_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_10_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_10_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_10_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_10_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_10_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_10_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_10_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_10_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_10_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_10_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_10_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_10_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_10_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_10_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID11_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID11_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID11_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID11_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID11_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID11_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID11_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID11_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR11_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR11_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR11_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR11_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_11_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_11_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_11_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_11_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_11_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_11_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_11_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_11_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_11_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_11_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_11_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_11_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_11_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_11_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_11_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_11_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID12_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID12_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID12_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID12_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID12_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID12_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID12_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID12_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR12_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR12_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR12_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR12_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_12_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_12_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_12_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_12_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_12_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_12_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_12_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_12_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_12_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_12_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_12_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_12_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_12_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_12_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_12_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_12_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID13_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID13_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID13_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID13_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID13_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID13_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID13_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID13_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR13_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR13_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR13_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR13_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_13_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_13_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_13_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_13_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_13_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_13_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_13_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_13_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_13_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_13_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_13_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_13_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_13_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_13_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_13_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_13_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID14_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID14_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID14_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID14_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID14_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID14_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID14_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID14_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR14_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR14_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR14_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR14_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_14_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_14_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_14_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_14_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_14_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_14_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_14_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_14_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_14_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_14_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_14_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_14_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_14_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_14_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_14_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_14_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID15_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID15_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID15_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID15_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID15_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID15_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID15_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID15_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR15_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR15_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR15_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR15_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_15_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_15_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_15_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_15_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_15_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_15_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_15_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_15_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_15_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_15_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_15_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_15_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_15_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_15_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_15_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_15_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID16_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID16_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID16_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID16_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID16_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID16_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID16_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID16_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR16_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR16_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR16_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR16_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_16_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_16_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_16_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_16_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_16_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_16_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_16_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_16_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_16_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_16_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_16_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_16_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_16_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_16_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_16_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_16_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID17_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID17_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID17_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID17_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID17_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID17_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID17_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID17_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR17_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR17_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR17_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR17_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_17_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_17_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_17_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_17_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_17_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_17_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_17_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_17_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_17_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_17_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_17_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_17_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_17_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_17_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_17_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_17_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID18_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID18_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID18_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID18_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID18_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID18_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID18_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID18_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR18_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR18_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR18_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR18_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_18_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_18_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_18_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_18_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_18_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_18_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_18_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_18_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_18_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_18_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_18_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_18_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_18_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_18_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_18_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_18_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID19_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID19_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID19_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID19_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID19_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID19_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID19_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID19_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR19_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR19_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR19_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR19_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_19_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_19_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_19_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_19_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_19_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_19_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_19_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_19_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_19_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_19_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_19_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_19_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_19_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_19_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_19_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_19_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID20_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID20_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID20_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID20_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID20_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID20_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID20_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID20_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR20_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR20_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR20_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR20_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_20_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_20_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_20_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_20_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_20_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_20_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_20_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_20_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_20_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_20_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_20_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_20_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_20_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_20_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_20_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_20_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID21_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID21_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID21_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID21_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID21_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID21_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID21_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID21_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR21_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR21_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR21_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR21_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_21_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_21_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_21_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_21_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_21_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_21_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_21_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_21_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_21_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_21_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_21_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_21_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_21_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_21_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_21_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_21_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID22_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID22_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID22_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID22_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID22_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID22_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID22_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID22_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR22_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR22_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR22_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR22_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_22_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_22_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_22_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_22_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_22_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_22_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_22_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_22_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_22_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_22_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_22_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_22_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_22_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_22_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_22_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_22_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID23_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID23_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID23_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID23_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID23_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID23_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID23_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID23_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR23_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR23_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR23_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR23_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_23_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_23_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_23_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_23_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_23_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_23_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_23_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_23_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_23_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_23_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_23_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_23_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_23_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_23_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_23_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_23_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID24_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID24_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID24_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID24_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID24_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID24_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID24_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID24_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR24_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR24_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR24_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR24_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_24_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_24_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_24_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_24_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_24_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_24_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_24_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_24_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_24_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_24_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_24_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_24_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_24_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_24_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_24_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_24_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID25_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID25_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID25_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID25_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID25_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID25_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID25_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID25_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR25_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR25_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR25_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR25_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_25_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_25_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_25_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_25_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_25_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_25_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_25_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_25_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_25_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_25_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_25_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_25_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_25_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_25_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_25_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_25_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID26_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID26_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID26_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID26_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID26_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID26_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID26_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID26_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR26_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR26_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR26_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR26_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_26_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_26_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_26_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_26_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_26_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_26_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_26_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_26_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_26_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_26_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_26_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_26_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_26_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_26_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_26_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_26_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID27_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID27_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID27_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID27_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID27_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID27_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID27_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID27_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR27_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR27_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR27_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR27_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_27_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_27_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_27_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_27_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_27_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_27_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_27_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_27_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_27_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_27_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_27_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_27_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_27_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_27_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_27_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_27_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID28_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID28_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID28_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID28_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID28_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID28_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID28_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID28_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR28_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR28_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR28_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR28_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_28_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_28_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_28_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_28_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_28_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_28_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_28_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_28_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_28_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_28_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_28_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_28_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_28_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_28_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_28_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_28_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID29_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID29_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID29_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID29_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID29_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID29_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID29_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID29_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR29_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR29_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR29_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR29_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_29_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_29_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_29_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_29_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_29_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_29_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_29_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_29_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_29_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_29_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_29_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_29_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_29_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_29_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_29_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_29_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID30_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID30_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID30_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID30_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID30_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID30_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID30_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID30_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR30_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR30_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR30_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR30_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_30_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_30_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_30_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_30_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_30_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_30_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_30_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_30_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_30_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_30_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_30_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_30_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_30_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_30_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_30_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_30_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0TMID31_TMID                                                 (0x1FFFFFFFu)
#define RCAN_RSCAN0TMID31_TMID_SHIFT                                           (0u)
#define RCAN_RSCAN0TMID31_THLEN                                                (0x20000000u)
#define RCAN_RSCAN0TMID31_THLEN_SHIFT                                          (29u)
#define RCAN_RSCAN0TMID31_TMRTR                                                (0x40000000u)
#define RCAN_RSCAN0TMID31_TMRTR_SHIFT                                          (30u)
#define RCAN_RSCAN0TMID31_TMIDE                                                (0x80000000u)
#define RCAN_RSCAN0TMID31_TMIDE_SHIFT                                          (31u)
#define RCAN_RSCAN0TMPTR31_TMPTR                                               (0x00FF0000u)
#define RCAN_RSCAN0TMPTR31_TMPTR_SHIFT                                         (16u)
#define RCAN_RSCAN0TMPTR31_TMDLC                                               (0xF0000000u)
#define RCAN_RSCAN0TMPTR31_TMDLC_SHIFT                                         (28u)
#define RCAN_RSCAN0TMDF0_31_TMDB0                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF0_31_TMDB0_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF0_31_TMDB1                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF0_31_TMDB1_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF0_31_TMDB2                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF0_31_TMDB2_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF0_31_TMDB3                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF0_31_TMDB3_SHIFT                                        (24u)
#define RCAN_RSCAN0TMDF1_31_TMDB4                                              (0x000000FFu)
#define RCAN_RSCAN0TMDF1_31_TMDB4_SHIFT                                        (0u)
#define RCAN_RSCAN0TMDF1_31_TMDB5                                              (0x0000FF00u)
#define RCAN_RSCAN0TMDF1_31_TMDB5_SHIFT                                        (8u)
#define RCAN_RSCAN0TMDF1_31_TMDB6                                              (0x00FF0000u)
#define RCAN_RSCAN0TMDF1_31_TMDB6_SHIFT                                        (16u)
#define RCAN_RSCAN0TMDF1_31_TMDB7                                              (0xFF000000u)
#define RCAN_RSCAN0TMDF1_31_TMDB7_SHIFT                                        (24u)
#define RCAN_RSCAN0THLACC0_BT                                                  (0x00000007u)
#define RCAN_RSCAN0THLACC0_BT_SHIFT                                            (0u)
#define RCAN_RSCAN0THLACC0_BN                                                  (0x00000078u)
#define RCAN_RSCAN0THLACC0_BN_SHIFT                                            (3u)
#define RCAN_RSCAN0THLACC0_TID                                                 (0x0000FF00u)
#define RCAN_RSCAN0THLACC0_TID_SHIFT                                           (8u)
#define RCAN_RSCAN0THLACC0_TMTS                                                (0xFFFF0000u)
#define RCAN_RSCAN0THLACC0_TMTS_SHIFT                                          (16u)
#define RCAN_RSCAN0THLACC1_BT                                                  (0x00000007u)
#define RCAN_RSCAN0THLACC1_BT_SHIFT                                            (0u)
#define RCAN_RSCAN0THLACC1_BN                                                  (0x00000078u)
#define RCAN_RSCAN0THLACC1_BN_SHIFT                                            (3u)
#define RCAN_RSCAN0THLACC1_TID                                                 (0x0000FF00u)
#define RCAN_RSCAN0THLACC1_TID_SHIFT                                           (8u)
#define RCAN_RSCAN0THLACC1_TMTS                                                (0xFFFF0000u)
#define RCAN_RSCAN0THLACC1_TMTS_SHIFT                                          (16u)
#define RCAN_RSCAN0RPGACC0_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC0_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC1_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC1_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC2_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC2_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC3_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC3_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC4_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC4_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC5_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC5_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC6_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC6_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC7_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC7_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC8_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC8_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC9_RDTA                                                (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC9_RDTA_SHIFT                                          (0u)
#define RCAN_RSCAN0RPGACC10_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC10_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC11_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC11_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC12_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC12_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC13_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC13_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC14_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC14_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC15_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC15_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC16_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC16_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC17_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC17_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC18_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC18_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC19_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC19_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC20_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC20_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC21_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC21_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC22_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC22_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC23_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC23_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC24_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC24_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC25_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC25_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC26_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC26_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC27_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC27_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC28_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC28_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC29_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC29_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC30_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC30_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC31_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC31_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC32_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC32_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC33_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC33_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC34_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC34_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC35_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC35_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC36_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC36_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC37_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC37_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC38_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC38_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC39_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC39_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC40_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC40_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC41_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC41_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC42_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC42_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC43_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC43_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC44_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC44_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC45_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC45_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC46_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC46_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC47_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC47_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC48_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC48_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC49_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC49_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC50_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC50_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC51_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC51_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC52_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC52_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC53_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC53_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC54_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC54_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC55_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC55_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC56_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC56_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC57_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC57_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC58_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC58_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC59_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC59_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC60_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC60_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC61_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC61_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC62_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC62_RDTA_SHIFT                                         (0u)
#define RCAN_RSCAN0RPGACC63_RDTA                                               (0xFFFFFFFFu)
#define RCAN_RSCAN0RPGACC63_RDTA_SHIFT                                         (0u)

#endif
