/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef RCANFD_IOBITMASK_H
#define RCANFD_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define RCANFD_RSCFD0CFDC0NCFG_NBRP                                            (0x000003FFu)
#define RCANFD_RSCFD0CFDC0NCFG_NBRP_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDC0NCFG_NSJW                                            (0x0000F800u)
#define RCANFD_RSCFD0CFDC0NCFG_NSJW_SHIFT                                      (11u)
#define RCANFD_RSCFD0CFDC0NCFG_NTSEG1                                          (0x007F0000u)
#define RCANFD_RSCFD0CFDC0NCFG_NTSEG1_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDC0NCFG_NTSEG2                                          (0x1F000000u)
#define RCANFD_RSCFD0CFDC0NCFG_NTSEG2_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDC0CTR_CHMDC                                            (0x00000003u)
#define RCANFD_RSCFD0CFDC0CTR_CHMDC_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDC0CTR_CSLPR                                            (0x00000004u)
#define RCANFD_RSCFD0CFDC0CTR_CSLPR_SHIFT                                      (2u)
#define RCANFD_RSCFD0CFDC0CTR_RTBO                                             (0x00000008u)
#define RCANFD_RSCFD0CFDC0CTR_RTBO_SHIFT                                       (3u)
#define RCANFD_RSCFD0CFDC0CTR_BEIE                                             (0x00000100u)
#define RCANFD_RSCFD0CFDC0CTR_BEIE_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDC0CTR_EWIE                                             (0x00000200u)
#define RCANFD_RSCFD0CFDC0CTR_EWIE_SHIFT                                       (9u)
#define RCANFD_RSCFD0CFDC0CTR_EPIE                                             (0x00000400u)
#define RCANFD_RSCFD0CFDC0CTR_EPIE_SHIFT                                       (10u)
#define RCANFD_RSCFD0CFDC0CTR_BOEIE                                            (0x00000800u)
#define RCANFD_RSCFD0CFDC0CTR_BOEIE_SHIFT                                      (11u)
#define RCANFD_RSCFD0CFDC0CTR_BORIE                                            (0x00001000u)
#define RCANFD_RSCFD0CFDC0CTR_BORIE_SHIFT                                      (12u)
#define RCANFD_RSCFD0CFDC0CTR_OLIE                                             (0x00002000u)
#define RCANFD_RSCFD0CFDC0CTR_OLIE_SHIFT                                       (13u)
#define RCANFD_RSCFD0CFDC0CTR_BLIE                                             (0x00004000u)
#define RCANFD_RSCFD0CFDC0CTR_BLIE_SHIFT                                       (14u)
#define RCANFD_RSCFD0CFDC0CTR_ALIE                                             (0x00008000u)
#define RCANFD_RSCFD0CFDC0CTR_ALIE_SHIFT                                       (15u)
#define RCANFD_RSCFD0CFDC0CTR_TAIE                                             (0x00010000u)
#define RCANFD_RSCFD0CFDC0CTR_TAIE_SHIFT                                       (16u)
#define RCANFD_RSCFD0CFDC0CTR_EOCOIE                                           (0x00020000u)
#define RCANFD_RSCFD0CFDC0CTR_EOCOIE_SHIFT                                     (17u)
#define RCANFD_RSCFD0CFDC0CTR_SOCOIE                                           (0x00040000u)
#define RCANFD_RSCFD0CFDC0CTR_SOCOIE_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDC0CTR_TDCVFIE                                          (0x00080000u)
#define RCANFD_RSCFD0CFDC0CTR_TDCVFIE_SHIFT                                    (19u)
#define RCANFD_RSCFD0CFDC0CTR_BOM                                              (0x00600000u)
#define RCANFD_RSCFD0CFDC0CTR_BOM_SHIFT                                        (21u)
#define RCANFD_RSCFD0CFDC0CTR_ERRD                                             (0x00800000u)
#define RCANFD_RSCFD0CFDC0CTR_ERRD_SHIFT                                       (23u)
#define RCANFD_RSCFD0CFDC0CTR_CTME                                             (0x01000000u)
#define RCANFD_RSCFD0CFDC0CTR_CTME_SHIFT                                       (24u)
#define RCANFD_RSCFD0CFDC0CTR_CTMS                                             (0x06000000u)
#define RCANFD_RSCFD0CFDC0CTR_CTMS_SHIFT                                       (25u)
#define RCANFD_RSCFD0CFDC0CTR_CRCT                                             (0x40000000u)
#define RCANFD_RSCFD0CFDC0CTR_CRCT_SHIFT                                       (30u)
#define RCANFD_RSCFD0CFDC0CTR_ROM                                              (0x80000000u)
#define RCANFD_RSCFD0CFDC0CTR_ROM_SHIFT                                        (31u)
#define RCANFD_RSCFD0CFDC0STS_CRSTSTS                                          (0x00000001u)
#define RCANFD_RSCFD0CFDC0STS_CRSTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDC0STS_CHLTSTS                                          (0x00000002u)
#define RCANFD_RSCFD0CFDC0STS_CHLTSTS_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDC0STS_CSLPSTS                                          (0x00000004u)
#define RCANFD_RSCFD0CFDC0STS_CSLPSTS_SHIFT                                    (2u)
#define RCANFD_RSCFD0CFDC0STS_EPSTS                                            (0x00000008u)
#define RCANFD_RSCFD0CFDC0STS_EPSTS_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDC0STS_BOSTS                                            (0x00000010u)
#define RCANFD_RSCFD0CFDC0STS_BOSTS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDC0STS_TRMSTS                                           (0x00000020u)
#define RCANFD_RSCFD0CFDC0STS_TRMSTS_SHIFT                                     (5u)
#define RCANFD_RSCFD0CFDC0STS_RECSTS                                           (0x00000040u)
#define RCANFD_RSCFD0CFDC0STS_RECSTS_SHIFT                                     (6u)
#define RCANFD_RSCFD0CFDC0STS_COMSTS                                           (0x00000080u)
#define RCANFD_RSCFD0CFDC0STS_COMSTS_SHIFT                                     (7u)
#define RCANFD_RSCFD0CFDC0STS_ESIF                                             (0x00000100u)
#define RCANFD_RSCFD0CFDC0STS_ESIF_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDC0STS_REC                                              (0x00FF0000u)
#define RCANFD_RSCFD0CFDC0STS_REC_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDC0STS_TEC                                              (0xFF000000u)
#define RCANFD_RSCFD0CFDC0STS_TEC_SHIFT                                        (24u)
#define RCANFD_RSCFD0CFDC0ERFL_BEF                                             (0x00000001u)
#define RCANFD_RSCFD0CFDC0ERFL_BEF_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDC0ERFL_EWF                                             (0x00000002u)
#define RCANFD_RSCFD0CFDC0ERFL_EWF_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDC0ERFL_EPF                                             (0x00000004u)
#define RCANFD_RSCFD0CFDC0ERFL_EPF_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDC0ERFL_BOEF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDC0ERFL_BOEF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDC0ERFL_BORF                                            (0x00000010u)
#define RCANFD_RSCFD0CFDC0ERFL_BORF_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDC0ERFL_OVLF                                            (0x00000020u)
#define RCANFD_RSCFD0CFDC0ERFL_OVLF_SHIFT                                      (5u)
#define RCANFD_RSCFD0CFDC0ERFL_BLF                                             (0x00000040u)
#define RCANFD_RSCFD0CFDC0ERFL_BLF_SHIFT                                       (6u)
#define RCANFD_RSCFD0CFDC0ERFL_ALF                                             (0x00000080u)
#define RCANFD_RSCFD0CFDC0ERFL_ALF_SHIFT                                       (7u)
#define RCANFD_RSCFD0CFDC0ERFL_SERR                                            (0x00000100u)
#define RCANFD_RSCFD0CFDC0ERFL_SERR_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDC0ERFL_FERR                                            (0x00000200u)
#define RCANFD_RSCFD0CFDC0ERFL_FERR_SHIFT                                      (9u)
#define RCANFD_RSCFD0CFDC0ERFL_AERR                                            (0x00000400u)
#define RCANFD_RSCFD0CFDC0ERFL_AERR_SHIFT                                      (10u)
#define RCANFD_RSCFD0CFDC0ERFL_CERR                                            (0x00000800u)
#define RCANFD_RSCFD0CFDC0ERFL_CERR_SHIFT                                      (11u)
#define RCANFD_RSCFD0CFDC0ERFL_B1ERR                                           (0x00001000u)
#define RCANFD_RSCFD0CFDC0ERFL_B1ERR_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDC0ERFL_B0ERR                                           (0x00002000u)
#define RCANFD_RSCFD0CFDC0ERFL_B0ERR_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDC0ERFL_ADERR                                           (0x00004000u)
#define RCANFD_RSCFD0CFDC0ERFL_ADERR_SHIFT                                     (14u)
#define RCANFD_RSCFD0CFDC0ERFL_CRCREG                                          (0x7FFF0000u)
#define RCANFD_RSCFD0CFDC0ERFL_CRCREG_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDC1NCFG_NBRP                                            (0x000003FFu)
#define RCANFD_RSCFD0CFDC1NCFG_NBRP_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDC1NCFG_NSJW                                            (0x0000F800u)
#define RCANFD_RSCFD0CFDC1NCFG_NSJW_SHIFT                                      (11u)
#define RCANFD_RSCFD0CFDC1NCFG_NTSEG1                                          (0x007F0000u)
#define RCANFD_RSCFD0CFDC1NCFG_NTSEG1_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDC1NCFG_NTSEG2                                          (0x1F000000u)
#define RCANFD_RSCFD0CFDC1NCFG_NTSEG2_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDC1CTR_CHMDC                                            (0x00000003u)
#define RCANFD_RSCFD0CFDC1CTR_CHMDC_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDC1CTR_CSLPR                                            (0x00000004u)
#define RCANFD_RSCFD0CFDC1CTR_CSLPR_SHIFT                                      (2u)
#define RCANFD_RSCFD0CFDC1CTR_RTBO                                             (0x00000008u)
#define RCANFD_RSCFD0CFDC1CTR_RTBO_SHIFT                                       (3u)
#define RCANFD_RSCFD0CFDC1CTR_BEIE                                             (0x00000100u)
#define RCANFD_RSCFD0CFDC1CTR_BEIE_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDC1CTR_EWIE                                             (0x00000200u)
#define RCANFD_RSCFD0CFDC1CTR_EWIE_SHIFT                                       (9u)
#define RCANFD_RSCFD0CFDC1CTR_EPIE                                             (0x00000400u)
#define RCANFD_RSCFD0CFDC1CTR_EPIE_SHIFT                                       (10u)
#define RCANFD_RSCFD0CFDC1CTR_BOEIE                                            (0x00000800u)
#define RCANFD_RSCFD0CFDC1CTR_BOEIE_SHIFT                                      (11u)
#define RCANFD_RSCFD0CFDC1CTR_BORIE                                            (0x00001000u)
#define RCANFD_RSCFD0CFDC1CTR_BORIE_SHIFT                                      (12u)
#define RCANFD_RSCFD0CFDC1CTR_OLIE                                             (0x00002000u)
#define RCANFD_RSCFD0CFDC1CTR_OLIE_SHIFT                                       (13u)
#define RCANFD_RSCFD0CFDC1CTR_BLIE                                             (0x00004000u)
#define RCANFD_RSCFD0CFDC1CTR_BLIE_SHIFT                                       (14u)
#define RCANFD_RSCFD0CFDC1CTR_ALIE                                             (0x00008000u)
#define RCANFD_RSCFD0CFDC1CTR_ALIE_SHIFT                                       (15u)
#define RCANFD_RSCFD0CFDC1CTR_TAIE                                             (0x00010000u)
#define RCANFD_RSCFD0CFDC1CTR_TAIE_SHIFT                                       (16u)
#define RCANFD_RSCFD0CFDC1CTR_EOCOIE                                           (0x00020000u)
#define RCANFD_RSCFD0CFDC1CTR_EOCOIE_SHIFT                                     (17u)
#define RCANFD_RSCFD0CFDC1CTR_SOCOIE                                           (0x00040000u)
#define RCANFD_RSCFD0CFDC1CTR_SOCOIE_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDC1CTR_TDCVFIE                                          (0x00080000u)
#define RCANFD_RSCFD0CFDC1CTR_TDCVFIE_SHIFT                                    (19u)
#define RCANFD_RSCFD0CFDC1CTR_BOM                                              (0x00600000u)
#define RCANFD_RSCFD0CFDC1CTR_BOM_SHIFT                                        (21u)
#define RCANFD_RSCFD0CFDC1CTR_ERRD                                             (0x00800000u)
#define RCANFD_RSCFD0CFDC1CTR_ERRD_SHIFT                                       (23u)
#define RCANFD_RSCFD0CFDC1CTR_CTME                                             (0x01000000u)
#define RCANFD_RSCFD0CFDC1CTR_CTME_SHIFT                                       (24u)
#define RCANFD_RSCFD0CFDC1CTR_CTMS                                             (0x06000000u)
#define RCANFD_RSCFD0CFDC1CTR_CTMS_SHIFT                                       (25u)
#define RCANFD_RSCFD0CFDC1CTR_CRCT                                             (0x40000000u)
#define RCANFD_RSCFD0CFDC1CTR_CRCT_SHIFT                                       (30u)
#define RCANFD_RSCFD0CFDC1CTR_ROM                                              (0x80000000u)
#define RCANFD_RSCFD0CFDC1CTR_ROM_SHIFT                                        (31u)
#define RCANFD_RSCFD0CFDC1STS_CRSTSTS                                          (0x00000001u)
#define RCANFD_RSCFD0CFDC1STS_CRSTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDC1STS_CHLTSTS                                          (0x00000002u)
#define RCANFD_RSCFD0CFDC1STS_CHLTSTS_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDC1STS_CSLPSTS                                          (0x00000004u)
#define RCANFD_RSCFD0CFDC1STS_CSLPSTS_SHIFT                                    (2u)
#define RCANFD_RSCFD0CFDC1STS_EPSTS                                            (0x00000008u)
#define RCANFD_RSCFD0CFDC1STS_EPSTS_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDC1STS_BOSTS                                            (0x00000010u)
#define RCANFD_RSCFD0CFDC1STS_BOSTS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDC1STS_TRMSTS                                           (0x00000020u)
#define RCANFD_RSCFD0CFDC1STS_TRMSTS_SHIFT                                     (5u)
#define RCANFD_RSCFD0CFDC1STS_RECSTS                                           (0x00000040u)
#define RCANFD_RSCFD0CFDC1STS_RECSTS_SHIFT                                     (6u)
#define RCANFD_RSCFD0CFDC1STS_COMSTS                                           (0x00000080u)
#define RCANFD_RSCFD0CFDC1STS_COMSTS_SHIFT                                     (7u)
#define RCANFD_RSCFD0CFDC1STS_ESIF                                             (0x00000100u)
#define RCANFD_RSCFD0CFDC1STS_ESIF_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDC1STS_REC                                              (0x00FF0000u)
#define RCANFD_RSCFD0CFDC1STS_REC_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDC1STS_TEC                                              (0xFF000000u)
#define RCANFD_RSCFD0CFDC1STS_TEC_SHIFT                                        (24u)
#define RCANFD_RSCFD0CFDC1ERFL_BEF                                             (0x00000001u)
#define RCANFD_RSCFD0CFDC1ERFL_BEF_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDC1ERFL_EWF                                             (0x00000002u)
#define RCANFD_RSCFD0CFDC1ERFL_EWF_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDC1ERFL_EPF                                             (0x00000004u)
#define RCANFD_RSCFD0CFDC1ERFL_EPF_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDC1ERFL_BOEF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDC1ERFL_BOEF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDC1ERFL_BORF                                            (0x00000010u)
#define RCANFD_RSCFD0CFDC1ERFL_BORF_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDC1ERFL_OVLF                                            (0x00000020u)
#define RCANFD_RSCFD0CFDC1ERFL_OVLF_SHIFT                                      (5u)
#define RCANFD_RSCFD0CFDC1ERFL_BLF                                             (0x00000040u)
#define RCANFD_RSCFD0CFDC1ERFL_BLF_SHIFT                                       (6u)
#define RCANFD_RSCFD0CFDC1ERFL_ALF                                             (0x00000080u)
#define RCANFD_RSCFD0CFDC1ERFL_ALF_SHIFT                                       (7u)
#define RCANFD_RSCFD0CFDC1ERFL_SERR                                            (0x00000100u)
#define RCANFD_RSCFD0CFDC1ERFL_SERR_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDC1ERFL_FERR                                            (0x00000200u)
#define RCANFD_RSCFD0CFDC1ERFL_FERR_SHIFT                                      (9u)
#define RCANFD_RSCFD0CFDC1ERFL_AERR                                            (0x00000400u)
#define RCANFD_RSCFD0CFDC1ERFL_AERR_SHIFT                                      (10u)
#define RCANFD_RSCFD0CFDC1ERFL_CERR                                            (0x00000800u)
#define RCANFD_RSCFD0CFDC1ERFL_CERR_SHIFT                                      (11u)
#define RCANFD_RSCFD0CFDC1ERFL_B1ERR                                           (0x00001000u)
#define RCANFD_RSCFD0CFDC1ERFL_B1ERR_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDC1ERFL_B0ERR                                           (0x00002000u)
#define RCANFD_RSCFD0CFDC1ERFL_B0ERR_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDC1ERFL_ADERR                                           (0x00004000u)
#define RCANFD_RSCFD0CFDC1ERFL_ADERR_SHIFT                                     (14u)
#define RCANFD_RSCFD0CFDC1ERFL_CRCREG                                          (0x7FFF0000u)
#define RCANFD_RSCFD0CFDC1ERFL_CRCREG_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDGCFG_TPRI                                              (0x00000001u)
#define RCANFD_RSCFD0CFDGCFG_TPRI_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDGCFG_DCE                                               (0x00000002u)
#define RCANFD_RSCFD0CFDGCFG_DCE_SHIFT                                         (1u)
#define RCANFD_RSCFD0CFDGCFG_DRE                                               (0x00000004u)
#define RCANFD_RSCFD0CFDGCFG_DRE_SHIFT                                         (2u)
#define RCANFD_RSCFD0CFDGCFG_MME                                               (0x00000008u)
#define RCANFD_RSCFD0CFDGCFG_MME_SHIFT                                         (3u)
#define RCANFD_RSCFD0CFDGCFG_DCS                                               (0x00000010u)
#define RCANFD_RSCFD0CFDGCFG_DCS_SHIFT                                         (4u)
#define RCANFD_RSCFD0CFDGCFG_CMPOC                                             (0x00000020u)
#define RCANFD_RSCFD0CFDGCFG_CMPOC_SHIFT                                       (5u)
#define RCANFD_RSCFD0CFDGCFG_TSP                                               (0x00000F00u)
#define RCANFD_RSCFD0CFDGCFG_TSP_SHIFT                                         (8u)
#define RCANFD_RSCFD0CFDGCFG_TSSS                                              (0x00001000u)
#define RCANFD_RSCFD0CFDGCFG_TSSS_SHIFT                                        (12u)
#define RCANFD_RSCFD0CFDGCFG_TSBTCS                                            (0x0000E000u)
#define RCANFD_RSCFD0CFDGCFG_TSBTCS_SHIFT                                      (13u)
#define RCANFD_RSCFD0CFDGCFG_ITRCP                                             (0xFFFF0000u)
#define RCANFD_RSCFD0CFDGCFG_ITRCP_SHIFT                                       (16u)
#define RCANFD_RSCFD0CFDGCTR_GMDC                                              (0x00000003u)
#define RCANFD_RSCFD0CFDGCTR_GMDC_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDGCTR_GSLPR                                             (0x00000004u)
#define RCANFD_RSCFD0CFDGCTR_GSLPR_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDGCTR_DEIE                                              (0x00000100u)
#define RCANFD_RSCFD0CFDGCTR_DEIE_SHIFT                                        (8u)
#define RCANFD_RSCFD0CFDGCTR_MEIE                                              (0x00000200u)
#define RCANFD_RSCFD0CFDGCTR_MEIE_SHIFT                                        (9u)
#define RCANFD_RSCFD0CFDGCTR_THLEIE                                            (0x00000400u)
#define RCANFD_RSCFD0CFDGCTR_THLEIE_SHIFT                                      (10u)
#define RCANFD_RSCFD0CFDGCTR_CMPOFIE                                           (0x00000800u)
#define RCANFD_RSCFD0CFDGCTR_CMPOFIE_SHIFT                                     (11u)
#define RCANFD_RSCFD0CFDGCTR_TSRST                                             (0x00010000u)
#define RCANFD_RSCFD0CFDGCTR_TSRST_SHIFT                                       (16u)
#define RCANFD_RSCFD0CFDGSTS_GRSTSTS                                           (0x00000001u)
#define RCANFD_RSCFD0CFDGSTS_GRSTSTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDGSTS_GHLTSTS                                           (0x00000002u)
#define RCANFD_RSCFD0CFDGSTS_GHLTSTS_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDGSTS_GSLPSTS                                           (0x00000004u)
#define RCANFD_RSCFD0CFDGSTS_GSLPSTS_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDGSTS_GRAMINIT                                          (0x00000008u)
#define RCANFD_RSCFD0CFDGSTS_GRAMINIT_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDGERFL_DEF                                              (0x00000001u)
#define RCANFD_RSCFD0CFDGERFL_DEF_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDGERFL_MES                                              (0x00000002u)
#define RCANFD_RSCFD0CFDGERFL_MES_SHIFT                                        (1u)
#define RCANFD_RSCFD0CFDGERFL_THLES                                            (0x00000004u)
#define RCANFD_RSCFD0CFDGERFL_THLES_SHIFT                                      (2u)
#define RCANFD_RSCFD0CFDGERFL_CMPOF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDGERFL_CMPOF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDGTSC_TS                                                (0x0000FFFFu)
#define RCANFD_RSCFD0CFDGTSC_TS_SHIFT                                          (0u)
#define RCANFD_RSCFD0CFDGAFLECTR_AFLPN                                         (0x0000001Fu)
#define RCANFD_RSCFD0CFDGAFLECTR_AFLPN_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLECTR_AFLDAE                                        (0x00000100u)
#define RCANFD_RSCFD0CFDGAFLECTR_AFLDAE_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDGAFLCFG0_RNC1                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDGAFLCFG0_RNC1_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDGAFLCFG0_RNC0                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDGAFLCFG0_RNC0_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMNB_NRXMB                                             (0x000000FFu)
#define RCANFD_RSCFD0CFDRMNB_NRXMB_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMNB_RMPLS                                             (0x00000300u)
#define RCANFD_RSCFD0CFDRMNB_RMPLS_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRMND0_RMNS0                                            (0x00000001u)
#define RCANFD_RSCFD0CFDRMND0_RMNS0_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMND0_RMNS1                                            (0x00000002u)
#define RCANFD_RSCFD0CFDRMND0_RMNS1_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDRMND0_RMNS2                                            (0x00000004u)
#define RCANFD_RSCFD0CFDRMND0_RMNS2_SHIFT                                      (2u)
#define RCANFD_RSCFD0CFDRMND0_RMNS3                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRMND0_RMNS3_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRMND0_RMNS4                                            (0x00000010u)
#define RCANFD_RSCFD0CFDRMND0_RMNS4_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRMND0_RMNS5                                            (0x00000020u)
#define RCANFD_RSCFD0CFDRMND0_RMNS5_SHIFT                                      (5u)
#define RCANFD_RSCFD0CFDRMND0_RMNS6                                            (0x00000040u)
#define RCANFD_RSCFD0CFDRMND0_RMNS6_SHIFT                                      (6u)
#define RCANFD_RSCFD0CFDRMND0_RMNS7                                            (0x00000080u)
#define RCANFD_RSCFD0CFDRMND0_RMNS7_SHIFT                                      (7u)
#define RCANFD_RSCFD0CFDRMND0_RMNS8                                            (0x00000100u)
#define RCANFD_RSCFD0CFDRMND0_RMNS8_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRMND0_RMNS9                                            (0x00000200u)
#define RCANFD_RSCFD0CFDRMND0_RMNS9_SHIFT                                      (9u)
#define RCANFD_RSCFD0CFDRMND0_RMNS10                                           (0x00000400u)
#define RCANFD_RSCFD0CFDRMND0_RMNS10_SHIFT                                     (10u)
#define RCANFD_RSCFD0CFDRMND0_RMNS11                                           (0x00000800u)
#define RCANFD_RSCFD0CFDRMND0_RMNS11_SHIFT                                     (11u)
#define RCANFD_RSCFD0CFDRMND0_RMNS12                                           (0x00001000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS12_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDRMND0_RMNS13                                           (0x00002000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS13_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRMND0_RMNS14                                           (0x00004000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS14_SHIFT                                     (14u)
#define RCANFD_RSCFD0CFDRMND0_RMNS15                                           (0x00008000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS15_SHIFT                                     (15u)
#define RCANFD_RSCFD0CFDRMND0_RMNS16                                           (0x00010000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS16_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMND0_RMNS17                                           (0x00020000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS17_SHIFT                                     (17u)
#define RCANFD_RSCFD0CFDRMND0_RMNS18                                           (0x00040000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS18_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDRMND0_RMNS19                                           (0x00080000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS19_SHIFT                                     (19u)
#define RCANFD_RSCFD0CFDRMND0_RMNS20                                           (0x00100000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS20_SHIFT                                     (20u)
#define RCANFD_RSCFD0CFDRMND0_RMNS21                                           (0x00200000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS21_SHIFT                                     (21u)
#define RCANFD_RSCFD0CFDRMND0_RMNS22                                           (0x00400000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS22_SHIFT                                     (22u)
#define RCANFD_RSCFD0CFDRMND0_RMNS23                                           (0x00800000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS23_SHIFT                                     (23u)
#define RCANFD_RSCFD0CFDRMND0_RMNS24                                           (0x01000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS24_SHIFT                                     (24u)
#define RCANFD_RSCFD0CFDRMND0_RMNS25                                           (0x02000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS25_SHIFT                                     (25u)
#define RCANFD_RSCFD0CFDRMND0_RMNS26                                           (0x04000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS26_SHIFT                                     (26u)
#define RCANFD_RSCFD0CFDRMND0_RMNS27                                           (0x08000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS27_SHIFT                                     (27u)
#define RCANFD_RSCFD0CFDRMND0_RMNS28                                           (0x10000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS28_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMND0_RMNS29                                           (0x20000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS29_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDRMND0_RMNS30                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS30_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMND0_RMNS31                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMND0_RMNS31_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRFCC0_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC0_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC0_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC0_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC0_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC0_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC0_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC0_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC0_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC0_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC0_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC0_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFCC1_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC1_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC1_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC1_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC1_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC1_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC1_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC1_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC1_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC1_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC1_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC1_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFCC2_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC2_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC2_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC2_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC2_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC2_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC2_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC2_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC2_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC2_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC2_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC2_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFCC3_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC3_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC3_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC3_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC3_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC3_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC3_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC3_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC3_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC3_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC3_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC3_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFCC4_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC4_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC4_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC4_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC4_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC4_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC4_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC4_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC4_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC4_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC4_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC4_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFCC5_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC5_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC5_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC5_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC5_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC5_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC5_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC5_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC5_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC5_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC5_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC5_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFCC6_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC6_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC6_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC6_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC6_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC6_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC6_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC6_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC6_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC6_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC6_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC6_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFCC7_RFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDRFCC7_RFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDRFCC7_RFIE                                             (0x00000002u)
#define RCANFD_RSCFD0CFDRFCC7_RFIE_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDRFCC7_RFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDRFCC7_RFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDRFCC7_RFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDRFCC7_RFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDRFCC7_RFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDRFCC7_RFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDRFCC7_RFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDRFCC7_RFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFSTS0_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS0_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS0_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS0_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS0_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS0_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS0_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS0_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS0_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS0_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFSTS1_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS1_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS1_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS1_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS1_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS1_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS1_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS1_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS1_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS1_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFSTS2_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS2_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS2_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS2_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS2_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS2_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS2_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS2_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS2_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS2_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFSTS3_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS3_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS3_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS3_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS3_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS3_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS3_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS3_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS3_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS3_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFSTS4_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS4_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS4_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS4_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS4_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS4_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS4_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS4_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS4_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS4_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFSTS5_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS5_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS5_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS5_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS5_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS5_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS5_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS5_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS5_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS5_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFSTS6_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS6_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS6_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS6_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS6_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS6_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS6_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS6_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS6_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS6_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFSTS7_RFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFSTS7_RFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFSTS7_RFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFSTS7_RFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFSTS7_RFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFSTS7_RFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFSTS7_RFIF                                            (0x00000008u)
#define RCANFD_RSCFD0CFDRFSTS7_RFIF_SHIFT                                      (3u)
#define RCANFD_RSCFD0CFDRFSTS7_RFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFSTS7_RFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDRFPCTR0_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR0_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFPCTR1_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR1_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFPCTR2_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR2_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFPCTR3_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR3_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFPCTR4_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR4_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFPCTR5_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR5_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFPCTR6_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR6_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFPCTR7_RFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDRFPCTR7_RFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFCC0_CFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDCFCC0_CFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDCFCC0_CFRXIE                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFCC0_CFRXIE_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFCC0_CFTXIE                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFCC0_CFTXIE_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFCC0_CFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDCFCC0_CFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDCFCC0_CFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDCFCC0_CFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDCFCC0_CFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDCFCC0_CFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDCFCC0_CFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDCFCC0_CFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDCFCC0_CFM                                              (0x00030000u)
#define RCANFD_RSCFD0CFDCFCC0_CFM_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDCFCC0_CFITSS                                           (0x00040000u)
#define RCANFD_RSCFD0CFDCFCC0_CFITSS_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDCFCC0_CFITR                                            (0x00080000u)
#define RCANFD_RSCFD0CFDCFCC0_CFITR_SHIFT                                      (19u)
#define RCANFD_RSCFD0CFDCFCC0_CFTML                                            (0x00F00000u)
#define RCANFD_RSCFD0CFDCFCC0_CFTML_SHIFT                                      (20u)
#define RCANFD_RSCFD0CFDCFCC0_CFITT                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDCFCC0_CFITT_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDCFCC1_CFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDCFCC1_CFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDCFCC1_CFRXIE                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFCC1_CFRXIE_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFCC1_CFTXIE                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFCC1_CFTXIE_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFCC1_CFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDCFCC1_CFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDCFCC1_CFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDCFCC1_CFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDCFCC1_CFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDCFCC1_CFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDCFCC1_CFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDCFCC1_CFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDCFCC1_CFM                                              (0x00030000u)
#define RCANFD_RSCFD0CFDCFCC1_CFM_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDCFCC1_CFITSS                                           (0x00040000u)
#define RCANFD_RSCFD0CFDCFCC1_CFITSS_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDCFCC1_CFITR                                            (0x00080000u)
#define RCANFD_RSCFD0CFDCFCC1_CFITR_SHIFT                                      (19u)
#define RCANFD_RSCFD0CFDCFCC1_CFTML                                            (0x00F00000u)
#define RCANFD_RSCFD0CFDCFCC1_CFTML_SHIFT                                      (20u)
#define RCANFD_RSCFD0CFDCFCC1_CFITT                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDCFCC1_CFITT_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDCFCC2_CFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDCFCC2_CFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDCFCC2_CFRXIE                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFCC2_CFRXIE_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFCC2_CFTXIE                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFCC2_CFTXIE_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFCC2_CFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDCFCC2_CFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDCFCC2_CFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDCFCC2_CFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDCFCC2_CFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDCFCC2_CFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDCFCC2_CFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDCFCC2_CFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDCFCC2_CFM                                              (0x00030000u)
#define RCANFD_RSCFD0CFDCFCC2_CFM_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDCFCC2_CFITSS                                           (0x00040000u)
#define RCANFD_RSCFD0CFDCFCC2_CFITSS_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDCFCC2_CFITR                                            (0x00080000u)
#define RCANFD_RSCFD0CFDCFCC2_CFITR_SHIFT                                      (19u)
#define RCANFD_RSCFD0CFDCFCC2_CFTML                                            (0x00F00000u)
#define RCANFD_RSCFD0CFDCFCC2_CFTML_SHIFT                                      (20u)
#define RCANFD_RSCFD0CFDCFCC2_CFITT                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDCFCC2_CFITT_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDCFCC3_CFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDCFCC3_CFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDCFCC3_CFRXIE                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFCC3_CFRXIE_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFCC3_CFTXIE                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFCC3_CFTXIE_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFCC3_CFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDCFCC3_CFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDCFCC3_CFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDCFCC3_CFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDCFCC3_CFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDCFCC3_CFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDCFCC3_CFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDCFCC3_CFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDCFCC3_CFM                                              (0x00030000u)
#define RCANFD_RSCFD0CFDCFCC3_CFM_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDCFCC3_CFITSS                                           (0x00040000u)
#define RCANFD_RSCFD0CFDCFCC3_CFITSS_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDCFCC3_CFITR                                            (0x00080000u)
#define RCANFD_RSCFD0CFDCFCC3_CFITR_SHIFT                                      (19u)
#define RCANFD_RSCFD0CFDCFCC3_CFTML                                            (0x00F00000u)
#define RCANFD_RSCFD0CFDCFCC3_CFTML_SHIFT                                      (20u)
#define RCANFD_RSCFD0CFDCFCC3_CFITT                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDCFCC3_CFITT_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDCFCC4_CFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDCFCC4_CFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDCFCC4_CFRXIE                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFCC4_CFRXIE_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFCC4_CFTXIE                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFCC4_CFTXIE_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFCC4_CFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDCFCC4_CFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDCFCC4_CFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDCFCC4_CFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDCFCC4_CFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDCFCC4_CFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDCFCC4_CFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDCFCC4_CFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDCFCC4_CFM                                              (0x00030000u)
#define RCANFD_RSCFD0CFDCFCC4_CFM_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDCFCC4_CFITSS                                           (0x00040000u)
#define RCANFD_RSCFD0CFDCFCC4_CFITSS_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDCFCC4_CFITR                                            (0x00080000u)
#define RCANFD_RSCFD0CFDCFCC4_CFITR_SHIFT                                      (19u)
#define RCANFD_RSCFD0CFDCFCC4_CFTML                                            (0x00F00000u)
#define RCANFD_RSCFD0CFDCFCC4_CFTML_SHIFT                                      (20u)
#define RCANFD_RSCFD0CFDCFCC4_CFITT                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDCFCC4_CFITT_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDCFCC5_CFE                                              (0x00000001u)
#define RCANFD_RSCFD0CFDCFCC5_CFE_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDCFCC5_CFRXIE                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFCC5_CFRXIE_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFCC5_CFTXIE                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFCC5_CFTXIE_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFCC5_CFPLS                                            (0x00000070u)
#define RCANFD_RSCFD0CFDCFCC5_CFPLS_SHIFT                                      (4u)
#define RCANFD_RSCFD0CFDCFCC5_CFDC                                             (0x00000700u)
#define RCANFD_RSCFD0CFDCFCC5_CFDC_SHIFT                                       (8u)
#define RCANFD_RSCFD0CFDCFCC5_CFIM                                             (0x00001000u)
#define RCANFD_RSCFD0CFDCFCC5_CFIM_SHIFT                                       (12u)
#define RCANFD_RSCFD0CFDCFCC5_CFIGCV                                           (0x0000E000u)
#define RCANFD_RSCFD0CFDCFCC5_CFIGCV_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDCFCC5_CFM                                              (0x00030000u)
#define RCANFD_RSCFD0CFDCFCC5_CFM_SHIFT                                        (16u)
#define RCANFD_RSCFD0CFDCFCC5_CFITSS                                           (0x00040000u)
#define RCANFD_RSCFD0CFDCFCC5_CFITSS_SHIFT                                     (18u)
#define RCANFD_RSCFD0CFDCFCC5_CFITR                                            (0x00080000u)
#define RCANFD_RSCFD0CFDCFCC5_CFITR_SHIFT                                      (19u)
#define RCANFD_RSCFD0CFDCFCC5_CFTML                                            (0x00F00000u)
#define RCANFD_RSCFD0CFDCFCC5_CFTML_SHIFT                                      (20u)
#define RCANFD_RSCFD0CFDCFCC5_CFITT                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDCFCC5_CFITT_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDCFSTS0_CFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDCFSTS0_CFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFSTS0_CFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFSTS0_CFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFSTS0_CFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFSTS0_CFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFSTS0_CFRXIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDCFSTS0_CFRXIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDCFSTS0_CFTXIF                                          (0x00000010u)
#define RCANFD_RSCFD0CFDCFSTS0_CFTXIF_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDCFSTS0_CFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFSTS0_CFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDCFSTS1_CFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDCFSTS1_CFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFSTS1_CFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFSTS1_CFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFSTS1_CFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFSTS1_CFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFSTS1_CFRXIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDCFSTS1_CFRXIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDCFSTS1_CFTXIF                                          (0x00000010u)
#define RCANFD_RSCFD0CFDCFSTS1_CFTXIF_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDCFSTS1_CFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFSTS1_CFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDCFSTS2_CFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDCFSTS2_CFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFSTS2_CFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFSTS2_CFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFSTS2_CFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFSTS2_CFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFSTS2_CFRXIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDCFSTS2_CFRXIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDCFSTS2_CFTXIF                                          (0x00000010u)
#define RCANFD_RSCFD0CFDCFSTS2_CFTXIF_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDCFSTS2_CFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFSTS2_CFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDCFSTS3_CFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDCFSTS3_CFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFSTS3_CFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFSTS3_CFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFSTS3_CFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFSTS3_CFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFSTS3_CFRXIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDCFSTS3_CFRXIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDCFSTS3_CFTXIF                                          (0x00000010u)
#define RCANFD_RSCFD0CFDCFSTS3_CFTXIF_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDCFSTS3_CFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFSTS3_CFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDCFSTS4_CFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDCFSTS4_CFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFSTS4_CFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFSTS4_CFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFSTS4_CFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFSTS4_CFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFSTS4_CFRXIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDCFSTS4_CFRXIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDCFSTS4_CFTXIF                                          (0x00000010u)
#define RCANFD_RSCFD0CFDCFSTS4_CFTXIF_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDCFSTS4_CFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFSTS4_CFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDCFSTS5_CFEMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDCFSTS5_CFEMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFSTS5_CFFLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDCFSTS5_CFFLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDCFSTS5_CFMLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDCFSTS5_CFMLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDCFSTS5_CFRXIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDCFSTS5_CFRXIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDCFSTS5_CFTXIF                                          (0x00000010u)
#define RCANFD_RSCFD0CFDCFSTS5_CFTXIF_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDCFSTS5_CFMC                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFSTS5_CFMC_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDCFPCTR0_CFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDCFPCTR0_CFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFPCTR1_CFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDCFPCTR1_CFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFPCTR2_CFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDCFPCTR2_CFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFPCTR3_CFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDCFPCTR3_CFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFPCTR4_CFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDCFPCTR4_CFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDCFPCTR5_CFPC                                           (0x000000FFu)
#define RCANFD_RSCFD0CFDCFPCTR5_CFPC_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDFESTS_RF0EMP                                           (0x00000001u)
#define RCANFD_RSCFD0CFDFESTS_RF0EMP_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDFESTS_RF1EMP                                           (0x00000002u)
#define RCANFD_RSCFD0CFDFESTS_RF1EMP_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDFESTS_RF2EMP                                           (0x00000004u)
#define RCANFD_RSCFD0CFDFESTS_RF2EMP_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDFESTS_RF3EMP                                           (0x00000008u)
#define RCANFD_RSCFD0CFDFESTS_RF3EMP_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDFESTS_RF4EMP                                           (0x00000010u)
#define RCANFD_RSCFD0CFDFESTS_RF4EMP_SHIFT                                     (4u)
#define RCANFD_RSCFD0CFDFESTS_RF5EMP                                           (0x00000020u)
#define RCANFD_RSCFD0CFDFESTS_RF5EMP_SHIFT                                     (5u)
#define RCANFD_RSCFD0CFDFESTS_RF6EMP                                           (0x00000040u)
#define RCANFD_RSCFD0CFDFESTS_RF6EMP_SHIFT                                     (6u)
#define RCANFD_RSCFD0CFDFESTS_RF7EMP                                           (0x00000080u)
#define RCANFD_RSCFD0CFDFESTS_RF7EMP_SHIFT                                     (7u)
#define RCANFD_RSCFD0CFDFESTS_CF0EMP                                           (0x00000100u)
#define RCANFD_RSCFD0CFDFESTS_CF0EMP_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDFESTS_CF1EMP                                           (0x00000200u)
#define RCANFD_RSCFD0CFDFESTS_CF1EMP_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDFESTS_CF2EMP                                           (0x00000400u)
#define RCANFD_RSCFD0CFDFESTS_CF2EMP_SHIFT                                     (10u)
#define RCANFD_RSCFD0CFDFESTS_CF3EMP                                           (0x00000800u)
#define RCANFD_RSCFD0CFDFESTS_CF3EMP_SHIFT                                     (11u)
#define RCANFD_RSCFD0CFDFESTS_CF4EMP                                           (0x00001000u)
#define RCANFD_RSCFD0CFDFESTS_CF4EMP_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDFESTS_CF5EMP                                           (0x00002000u)
#define RCANFD_RSCFD0CFDFESTS_CF5EMP_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDFFSTS_RF0FLL                                           (0x00000001u)
#define RCANFD_RSCFD0CFDFFSTS_RF0FLL_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDFFSTS_RF1FLL                                           (0x00000002u)
#define RCANFD_RSCFD0CFDFFSTS_RF1FLL_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDFFSTS_RF2FLL                                           (0x00000004u)
#define RCANFD_RSCFD0CFDFFSTS_RF2FLL_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDFFSTS_RF3FLL                                           (0x00000008u)
#define RCANFD_RSCFD0CFDFFSTS_RF3FLL_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDFFSTS_RF4FLL                                           (0x00000010u)
#define RCANFD_RSCFD0CFDFFSTS_RF4FLL_SHIFT                                     (4u)
#define RCANFD_RSCFD0CFDFFSTS_RF5FLL                                           (0x00000020u)
#define RCANFD_RSCFD0CFDFFSTS_RF5FLL_SHIFT                                     (5u)
#define RCANFD_RSCFD0CFDFFSTS_RF6FLL                                           (0x00000040u)
#define RCANFD_RSCFD0CFDFFSTS_RF6FLL_SHIFT                                     (6u)
#define RCANFD_RSCFD0CFDFFSTS_RF7FLL                                           (0x00000080u)
#define RCANFD_RSCFD0CFDFFSTS_RF7FLL_SHIFT                                     (7u)
#define RCANFD_RSCFD0CFDFFSTS_CF0FLL                                           (0x00000100u)
#define RCANFD_RSCFD0CFDFFSTS_CF0FLL_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDFFSTS_CF1FLL                                           (0x00000200u)
#define RCANFD_RSCFD0CFDFFSTS_CF1FLL_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDFFSTS_CF2FLL                                           (0x00000400u)
#define RCANFD_RSCFD0CFDFFSTS_CF2FLL_SHIFT                                     (10u)
#define RCANFD_RSCFD0CFDFFSTS_CF3FLL                                           (0x00000800u)
#define RCANFD_RSCFD0CFDFFSTS_CF3FLL_SHIFT                                     (11u)
#define RCANFD_RSCFD0CFDFFSTS_CF4FLL                                           (0x00001000u)
#define RCANFD_RSCFD0CFDFFSTS_CF4FLL_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDFFSTS_CF5FLL                                           (0x00002000u)
#define RCANFD_RSCFD0CFDFFSTS_CF5FLL_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDFMSTS_RF0MLT                                           (0x00000001u)
#define RCANFD_RSCFD0CFDFMSTS_RF0MLT_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDFMSTS_RF1MLT                                           (0x00000002u)
#define RCANFD_RSCFD0CFDFMSTS_RF1MLT_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDFMSTS_RF2MLT                                           (0x00000004u)
#define RCANFD_RSCFD0CFDFMSTS_RF2MLT_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDFMSTS_RF3MLT                                           (0x00000008u)
#define RCANFD_RSCFD0CFDFMSTS_RF3MLT_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDFMSTS_RF4MLT                                           (0x00000010u)
#define RCANFD_RSCFD0CFDFMSTS_RF4MLT_SHIFT                                     (4u)
#define RCANFD_RSCFD0CFDFMSTS_RF5MLT                                           (0x00000020u)
#define RCANFD_RSCFD0CFDFMSTS_RF5MLT_SHIFT                                     (5u)
#define RCANFD_RSCFD0CFDFMSTS_RF6MLT                                           (0x00000040u)
#define RCANFD_RSCFD0CFDFMSTS_RF6MLT_SHIFT                                     (6u)
#define RCANFD_RSCFD0CFDFMSTS_RF7MLT                                           (0x00000080u)
#define RCANFD_RSCFD0CFDFMSTS_RF7MLT_SHIFT                                     (7u)
#define RCANFD_RSCFD0CFDFMSTS_CF0MLT                                           (0x00000100u)
#define RCANFD_RSCFD0CFDFMSTS_CF0MLT_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDFMSTS_CF1MLT                                           (0x00000200u)
#define RCANFD_RSCFD0CFDFMSTS_CF1MLT_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDFMSTS_CF2MLT                                           (0x00000400u)
#define RCANFD_RSCFD0CFDFMSTS_CF2MLT_SHIFT                                     (10u)
#define RCANFD_RSCFD0CFDFMSTS_CF3MLT                                           (0x00000800u)
#define RCANFD_RSCFD0CFDFMSTS_CF3MLT_SHIFT                                     (11u)
#define RCANFD_RSCFD0CFDFMSTS_CF4MLT                                           (0x00001000u)
#define RCANFD_RSCFD0CFDFMSTS_CF4MLT_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDFMSTS_CF5MLT                                           (0x00002000u)
#define RCANFD_RSCFD0CFDFMSTS_CF5MLT_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDRFISTS_RF0IF                                           (0x00000001u)
#define RCANFD_RSCFD0CFDRFISTS_RF0IF_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRFISTS_RF1IF                                           (0x00000002u)
#define RCANFD_RSCFD0CFDRFISTS_RF1IF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDRFISTS_RF2IF                                           (0x00000004u)
#define RCANFD_RSCFD0CFDRFISTS_RF2IF_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDRFISTS_RF3IF                                           (0x00000008u)
#define RCANFD_RSCFD0CFDRFISTS_RF3IF_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDRFISTS_RF4IF                                           (0x00000010u)
#define RCANFD_RSCFD0CFDRFISTS_RF4IF_SHIFT                                     (4u)
#define RCANFD_RSCFD0CFDRFISTS_RF5IF                                           (0x00000020u)
#define RCANFD_RSCFD0CFDRFISTS_RF5IF_SHIFT                                     (5u)
#define RCANFD_RSCFD0CFDRFISTS_RF6IF                                           (0x00000040u)
#define RCANFD_RSCFD0CFDRFISTS_RF6IF_SHIFT                                     (6u)
#define RCANFD_RSCFD0CFDRFISTS_RF7IF                                           (0x00000080u)
#define RCANFD_RSCFD0CFDRFISTS_RF7IF_SHIFT                                     (7u)
#define RCANFD_RSCFD0CFDCFRISTS_CF0RXIF                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFRISTS_CF0RXIF_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFRISTS_CF1RXIF                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFRISTS_CF1RXIF_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFRISTS_CF2RXIF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFRISTS_CF2RXIF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFRISTS_CF3RXIF                                        (0x00000008u)
#define RCANFD_RSCFD0CFDCFRISTS_CF3RXIF_SHIFT                                  (3u)
#define RCANFD_RSCFD0CFDCFRISTS_CF4RXIF                                        (0x00000010u)
#define RCANFD_RSCFD0CFDCFRISTS_CF4RXIF_SHIFT                                  (4u)
#define RCANFD_RSCFD0CFDCFRISTS_CF5RXIF                                        (0x00000020u)
#define RCANFD_RSCFD0CFDCFRISTS_CF5RXIF_SHIFT                                  (5u)
#define RCANFD_RSCFD0CFDCFTISTS_CF0TXIF                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFTISTS_CF0TXIF_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFTISTS_CF1TXIF                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFTISTS_CF1TXIF_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFTISTS_CF2TXIF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFTISTS_CF2TXIF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFTISTS_CF3TXIF                                        (0x00000008u)
#define RCANFD_RSCFD0CFDCFTISTS_CF3TXIF_SHIFT                                  (3u)
#define RCANFD_RSCFD0CFDCFTISTS_CF4TXIF                                        (0x00000010u)
#define RCANFD_RSCFD0CFDCFTISTS_CF4TXIF_SHIFT                                  (4u)
#define RCANFD_RSCFD0CFDCFTISTS_CF5TXIF                                        (0x00000020u)
#define RCANFD_RSCFD0CFDCFTISTS_CF5TXIF_SHIFT                                  (5u)
#define RCANFD_RSCFD0CFDTMC0_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC0_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC0_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC0_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC0_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC0_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC1_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC1_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC1_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC1_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC1_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC1_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC2_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC2_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC2_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC2_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC2_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC2_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC3_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC3_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC3_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC3_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC3_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC3_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC4_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC4_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC4_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC4_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC4_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC4_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC5_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC5_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC5_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC5_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC5_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC5_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC6_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC6_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC6_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC6_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC6_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC6_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC7_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC7_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC7_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC7_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC7_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC7_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC8_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC8_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC8_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC8_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC8_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC8_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC9_TMTR                                              (0x01u)
#define RCANFD_RSCFD0CFDTMC9_TMTR_SHIFT                                        (0u)
#define RCANFD_RSCFD0CFDTMC9_TMTAR                                             (0x02u)
#define RCANFD_RSCFD0CFDTMC9_TMTAR_SHIFT                                       (1u)
#define RCANFD_RSCFD0CFDTMC9_TMOM                                              (0x04u)
#define RCANFD_RSCFD0CFDTMC9_TMOM_SHIFT                                        (2u)
#define RCANFD_RSCFD0CFDTMC10_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC10_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC10_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC10_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC10_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC10_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC11_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC11_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC11_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC11_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC11_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC11_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC12_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC12_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC12_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC12_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC12_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC12_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC13_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC13_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC13_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC13_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC13_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC13_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC14_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC14_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC14_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC14_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC14_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC14_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC15_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC15_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC15_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC15_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC15_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC15_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC16_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC16_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC16_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC16_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC16_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC16_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC17_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC17_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC17_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC17_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC17_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC17_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC18_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC18_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC18_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC18_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC18_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC18_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC19_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC19_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC19_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC19_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC19_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC19_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC20_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC20_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC20_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC20_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC20_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC20_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC21_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC21_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC21_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC21_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC21_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC21_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC22_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC22_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC22_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC22_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC22_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC22_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC23_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC23_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC23_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC23_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC23_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC23_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC24_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC24_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC24_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC24_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC24_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC24_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC25_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC25_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC25_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC25_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC25_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC25_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC26_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC26_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC26_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC26_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC26_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC26_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC27_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC27_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC27_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC27_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC27_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC27_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC28_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC28_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC28_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC28_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC28_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC28_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC29_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC29_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC29_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC29_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC29_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC29_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC30_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC30_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC30_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC30_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC30_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC30_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMC31_TMTR                                             (0x01u)
#define RCANFD_RSCFD0CFDTMC31_TMTR_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMC31_TMTAR                                            (0x02u)
#define RCANFD_RSCFD0CFDTMC31_TMTAR_SHIFT                                      (1u)
#define RCANFD_RSCFD0CFDTMC31_TMOM                                             (0x04u)
#define RCANFD_RSCFD0CFDTMC31_TMOM_SHIFT                                       (2u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS0_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS1_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS2_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS3_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS4_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS5_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS6_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS7_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS8_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTSTS                                          (0x01u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTSTS_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTRF                                           (0x06u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTRF_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTRM                                           (0x08u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTRM_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTARM                                          (0x10u)
#define RCANFD_RSCFD0CFDTMSTS9_TMTARM_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS10_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS11_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS12_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS13_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS14_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS15_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS16_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS17_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS18_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS19_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS20_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS21_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS22_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS23_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS24_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS25_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS26_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS27_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS28_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS29_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS30_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTSTS                                         (0x01u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTSTS_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTRF                                          (0x06u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTRF_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTRM                                          (0x08u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTRM_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTARM                                         (0x10u)
#define RCANFD_RSCFD0CFDTMSTS31_TMTARM_SHIFT                                   (4u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS0                                      (0x00000001u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS0_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS1                                      (0x00000002u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS1_SHIFT                                (1u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS2                                      (0x00000004u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS2_SHIFT                                (2u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS3                                      (0x00000008u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS3_SHIFT                                (3u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS4                                      (0x00000010u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS4_SHIFT                                (4u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS5                                      (0x00000020u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS5_SHIFT                                (5u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS6                                      (0x00000040u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS6_SHIFT                                (6u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS7                                      (0x00000080u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS7_SHIFT                                (7u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS8                                      (0x00000100u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS8_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS9                                      (0x00000200u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS9_SHIFT                                (9u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS10                                     (0x00000400u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS10_SHIFT                               (10u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS11                                     (0x00000800u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS11_SHIFT                               (11u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS12                                     (0x00001000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS12_SHIFT                               (12u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS13                                     (0x00002000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS13_SHIFT                               (13u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS14                                     (0x00004000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS14_SHIFT                               (14u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS15                                     (0x00008000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS15_SHIFT                               (15u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS16                                     (0x00010000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS16_SHIFT                               (16u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS17                                     (0x00020000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS17_SHIFT                               (17u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS18                                     (0x00040000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS18_SHIFT                               (18u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS19                                     (0x00080000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS19_SHIFT                               (19u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS20                                     (0x00100000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS20_SHIFT                               (20u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS21                                     (0x00200000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS21_SHIFT                               (21u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS22                                     (0x00400000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS22_SHIFT                               (22u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS23                                     (0x00800000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS23_SHIFT                               (23u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS24                                     (0x01000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS24_SHIFT                               (24u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS25                                     (0x02000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS25_SHIFT                               (25u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS26                                     (0x04000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS26_SHIFT                               (26u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS27                                     (0x08000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS27_SHIFT                               (27u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS28                                     (0x10000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS28_SHIFT                               (28u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS29                                     (0x20000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS29_SHIFT                               (29u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS30                                     (0x40000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS30_SHIFT                               (30u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS31                                     (0x80000000u)
#define RCANFD_RSCFD0CFDTMTRSTS0_TMTRSTS31_SHIFT                               (31u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS0                                    (0x00000001u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS0_SHIFT                              (0u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS1                                    (0x00000002u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS1_SHIFT                              (1u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS2                                    (0x00000004u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS2_SHIFT                              (2u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS3                                    (0x00000008u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS3_SHIFT                              (3u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS4                                    (0x00000010u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS4_SHIFT                              (4u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS5                                    (0x00000020u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS5_SHIFT                              (5u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS6                                    (0x00000040u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS6_SHIFT                              (6u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS7                                    (0x00000080u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS7_SHIFT                              (7u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS8                                    (0x00000100u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS8_SHIFT                              (8u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS9                                    (0x00000200u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS9_SHIFT                              (9u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS10                                   (0x00000400u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS10_SHIFT                             (10u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS11                                   (0x00000800u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS11_SHIFT                             (11u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS12                                   (0x00001000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS12_SHIFT                             (12u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS13                                   (0x00002000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS13_SHIFT                             (13u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS14                                   (0x00004000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS14_SHIFT                             (14u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS15                                   (0x00008000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS15_SHIFT                             (15u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS16                                   (0x00010000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS16_SHIFT                             (16u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS17                                   (0x00020000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS17_SHIFT                             (17u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS18                                   (0x00040000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS18_SHIFT                             (18u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS19                                   (0x00080000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS19_SHIFT                             (19u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS20                                   (0x00100000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS20_SHIFT                             (20u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS21                                   (0x00200000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS21_SHIFT                             (21u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS22                                   (0x00400000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS22_SHIFT                             (22u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS23                                   (0x00800000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS23_SHIFT                             (23u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS24                                   (0x01000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS24_SHIFT                             (24u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS25                                   (0x02000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS25_SHIFT                             (25u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS26                                   (0x04000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS26_SHIFT                             (26u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS27                                   (0x08000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS27_SHIFT                             (27u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS28                                   (0x10000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS28_SHIFT                             (28u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS29                                   (0x20000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS29_SHIFT                             (29u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS30                                   (0x40000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS30_SHIFT                             (30u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS31                                   (0x80000000u)
#define RCANFD_RSCFD0CFDTMTARSTS0_TMTARSTS31_SHIFT                             (31u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS0                                      (0x00000001u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS0_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS1                                      (0x00000002u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS1_SHIFT                                (1u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS2                                      (0x00000004u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS2_SHIFT                                (2u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS3                                      (0x00000008u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS3_SHIFT                                (3u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS4                                      (0x00000010u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS4_SHIFT                                (4u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS5                                      (0x00000020u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS5_SHIFT                                (5u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS6                                      (0x00000040u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS6_SHIFT                                (6u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS7                                      (0x00000080u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS7_SHIFT                                (7u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS8                                      (0x00000100u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS8_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS9                                      (0x00000200u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS9_SHIFT                                (9u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS10                                     (0x00000400u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS10_SHIFT                               (10u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS11                                     (0x00000800u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS11_SHIFT                               (11u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS12                                     (0x00001000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS12_SHIFT                               (12u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS13                                     (0x00002000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS13_SHIFT                               (13u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS14                                     (0x00004000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS14_SHIFT                               (14u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS15                                     (0x00008000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS15_SHIFT                               (15u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS16                                     (0x00010000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS16_SHIFT                               (16u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS17                                     (0x00020000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS17_SHIFT                               (17u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS18                                     (0x00040000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS18_SHIFT                               (18u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS19                                     (0x00080000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS19_SHIFT                               (19u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS20                                     (0x00100000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS20_SHIFT                               (20u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS21                                     (0x00200000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS21_SHIFT                               (21u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS22                                     (0x00400000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS22_SHIFT                               (22u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS23                                     (0x00800000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS23_SHIFT                               (23u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS24                                     (0x01000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS24_SHIFT                               (24u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS25                                     (0x02000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS25_SHIFT                               (25u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS26                                     (0x04000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS26_SHIFT                               (26u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS27                                     (0x08000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS27_SHIFT                               (27u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS28                                     (0x10000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS28_SHIFT                               (28u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS29                                     (0x20000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS29_SHIFT                               (29u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS30                                     (0x40000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS30_SHIFT                               (30u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS31                                     (0x80000000u)
#define RCANFD_RSCFD0CFDTMTCSTS0_TMTCSTS31_SHIFT                               (31u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS0                                      (0x00000001u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS0_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS1                                      (0x00000002u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS1_SHIFT                                (1u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS2                                      (0x00000004u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS2_SHIFT                                (2u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS3                                      (0x00000008u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS3_SHIFT                                (3u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS4                                      (0x00000010u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS4_SHIFT                                (4u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS5                                      (0x00000020u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS5_SHIFT                                (5u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS6                                      (0x00000040u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS6_SHIFT                                (6u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS7                                      (0x00000080u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS7_SHIFT                                (7u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS8                                      (0x00000100u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS8_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS9                                      (0x00000200u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS9_SHIFT                                (9u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS10                                     (0x00000400u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS10_SHIFT                               (10u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS11                                     (0x00000800u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS11_SHIFT                               (11u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS12                                     (0x00001000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS12_SHIFT                               (12u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS13                                     (0x00002000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS13_SHIFT                               (13u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS14                                     (0x00004000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS14_SHIFT                               (14u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS15                                     (0x00008000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS15_SHIFT                               (15u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS16                                     (0x00010000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS16_SHIFT                               (16u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS17                                     (0x00020000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS17_SHIFT                               (17u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS18                                     (0x00040000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS18_SHIFT                               (18u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS19                                     (0x00080000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS19_SHIFT                               (19u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS20                                     (0x00100000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS20_SHIFT                               (20u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS21                                     (0x00200000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS21_SHIFT                               (21u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS22                                     (0x00400000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS22_SHIFT                               (22u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS23                                     (0x00800000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS23_SHIFT                               (23u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS24                                     (0x01000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS24_SHIFT                               (24u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS25                                     (0x02000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS25_SHIFT                               (25u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS26                                     (0x04000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS26_SHIFT                               (26u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS27                                     (0x08000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS27_SHIFT                               (27u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS28                                     (0x10000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS28_SHIFT                               (28u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS29                                     (0x20000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS29_SHIFT                               (29u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS30                                     (0x40000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS30_SHIFT                               (30u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS31                                     (0x80000000u)
#define RCANFD_RSCFD0CFDTMTASTS0_TMTASTS31_SHIFT                               (31u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE0                                           (0x00000001u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE0_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE1                                           (0x00000002u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE1_SHIFT                                     (1u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE2                                           (0x00000004u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE2_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE3                                           (0x00000008u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE3_SHIFT                                     (3u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE4                                           (0x00000010u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE4_SHIFT                                     (4u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE5                                           (0x00000020u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE5_SHIFT                                     (5u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE6                                           (0x00000040u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE6_SHIFT                                     (6u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE7                                           (0x00000080u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE7_SHIFT                                     (7u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE8                                           (0x00000100u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE8_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE9                                           (0x00000200u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE9_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE10                                          (0x00000400u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE10_SHIFT                                    (10u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE11                                          (0x00000800u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE11_SHIFT                                    (11u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE12                                          (0x00001000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE12_SHIFT                                    (12u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE13                                          (0x00002000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE13_SHIFT                                    (13u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE14                                          (0x00004000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE14_SHIFT                                    (14u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE15                                          (0x00008000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE15_SHIFT                                    (15u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE16                                          (0x00010000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE16_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE17                                          (0x00020000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE17_SHIFT                                    (17u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE18                                          (0x00040000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE18_SHIFT                                    (18u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE19                                          (0x00080000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE19_SHIFT                                    (19u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE20                                          (0x00100000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE20_SHIFT                                    (20u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE21                                          (0x00200000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE21_SHIFT                                    (21u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE22                                          (0x00400000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE22_SHIFT                                    (22u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE23                                          (0x00800000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE23_SHIFT                                    (23u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE24                                          (0x01000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE24_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE25                                          (0x02000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE25_SHIFT                                    (25u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE26                                          (0x04000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE26_SHIFT                                    (26u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE27                                          (0x08000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE27_SHIFT                                    (27u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE28                                          (0x10000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE28_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE29                                          (0x20000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE29_SHIFT                                    (29u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE30                                          (0x40000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE30_SHIFT                                    (30u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE31                                          (0x80000000u)
#define RCANFD_RSCFD0CFDTMIEC0_TMIE31_SHIFT                                    (31u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQE                                            (0x00000001u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQE_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQDC                                           (0x00000F00u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQDC_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQIE                                           (0x00001000u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQIE_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQIM                                           (0x00002000u)
#define RCANFD_RSCFD0CFDTXQCC0_TXQIM_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQE                                            (0x00000001u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQE_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQDC                                           (0x00000F00u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQDC_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQIE                                           (0x00001000u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQIE_SHIFT                                     (12u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQIM                                           (0x00002000u)
#define RCANFD_RSCFD0CFDTXQCC1_TXQIM_SHIFT                                     (13u)
#define RCANFD_RSCFD0CFDTXQSTS0_TXQEMP                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTXQSTS0_TXQEMP_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTXQSTS0_TXQFLL                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTXQSTS0_TXQFLL_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTXQSTS0_TXQIF                                          (0x00000004u)
#define RCANFD_RSCFD0CFDTXQSTS0_TXQIF_SHIFT                                    (2u)
#define RCANFD_RSCFD0CFDTXQSTS1_TXQEMP                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTXQSTS1_TXQEMP_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTXQSTS1_TXQFLL                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTXQSTS1_TXQFLL_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTXQSTS1_TXQIF                                          (0x00000004u)
#define RCANFD_RSCFD0CFDTXQSTS1_TXQIF_SHIFT                                    (2u)
#define RCANFD_RSCFD0CFDTXQPCTR0_TXQPC                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTXQPCTR0_TXQPC_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTXQPCTR1_TXQPC                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTXQPCTR1_TXQPC_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTHLCC0_THLE                                            (0x00000001u)
#define RCANFD_RSCFD0CFDTHLCC0_THLE_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTHLCC0_THLIE                                           (0x00000100u)
#define RCANFD_RSCFD0CFDTHLCC0_THLIE_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDTHLCC0_THLIM                                           (0x00000200u)
#define RCANFD_RSCFD0CFDTHLCC0_THLIM_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDTHLCC0_THLDTE                                          (0x00000400u)
#define RCANFD_RSCFD0CFDTHLCC0_THLDTE_SHIFT                                    (10u)
#define RCANFD_RSCFD0CFDTHLCC1_THLE                                            (0x00000001u)
#define RCANFD_RSCFD0CFDTHLCC1_THLE_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTHLCC1_THLIE                                           (0x00000100u)
#define RCANFD_RSCFD0CFDTHLCC1_THLIE_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDTHLCC1_THLIM                                           (0x00000200u)
#define RCANFD_RSCFD0CFDTHLCC1_THLIM_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDTHLCC1_THLDTE                                          (0x00000400u)
#define RCANFD_RSCFD0CFDTHLCC1_THLDTE_SHIFT                                    (10u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLEMP                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLEMP_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLFLL                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLFLL_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLELT                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLELT_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLMC                                          (0x00001F00u)
#define RCANFD_RSCFD0CFDTHLSTS0_THLMC_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLEMP                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLEMP_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLFLL                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLFLL_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLELT                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLELT_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLIF                                          (0x00000008u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLIF_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLMC                                          (0x00001F00u)
#define RCANFD_RSCFD0CFDTHLSTS1_THLMC_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTHLPCTR0_THLPC                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTHLPCTR0_THLPC_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTHLPCTR1_THLPC                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTHLPCTR1_THLPC_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TSIF0                                        (0x00000001u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TSIF0_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TAIF0                                        (0x00000002u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TAIF0_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TQIF0                                        (0x00000004u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TQIF0_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDGTINTSTS0_CFTIF0                                       (0x00000008u)
#define RCANFD_RSCFD0CFDGTINTSTS0_CFTIF0_SHIFT                                 (3u)
#define RCANFD_RSCFD0CFDGTINTSTS0_THIF0                                        (0x00000010u)
#define RCANFD_RSCFD0CFDGTINTSTS0_THIF0_SHIFT                                  (4u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TSIF1                                        (0x00000100u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TSIF1_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TAIF1                                        (0x00000200u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TAIF1_SHIFT                                  (9u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TQIF1                                        (0x00000400u)
#define RCANFD_RSCFD0CFDGTINTSTS0_TQIF1_SHIFT                                  (10u)
#define RCANFD_RSCFD0CFDGTINTSTS0_CFTIF1                                       (0x00000800u)
#define RCANFD_RSCFD0CFDGTINTSTS0_CFTIF1_SHIFT                                 (11u)
#define RCANFD_RSCFD0CFDGTINTSTS0_THIF1                                        (0x00001000u)
#define RCANFD_RSCFD0CFDGTINTSTS0_THIF1_SHIFT                                  (12u)
#define RCANFD_RSCFD0CFDGTSTCFG_C0ICBCE                                        (0x00000001u)
#define RCANFD_RSCFD0CFDGTSTCFG_C0ICBCE_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGTSTCFG_C1ICBCE                                        (0x00000002u)
#define RCANFD_RSCFD0CFDGTSTCFG_C1ICBCE_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDGTSTCFG_RTMPS                                          (0x007F0000u)
#define RCANFD_RSCFD0CFDGTSTCFG_RTMPS_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDGTSTCTR_ICBCTME                                        (0x00000001u)
#define RCANFD_RSCFD0CFDGTSTCTR_ICBCTME_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGTSTCTR_RTME                                           (0x00000004u)
#define RCANFD_RSCFD0CFDGTSTCTR_RTME_SHIFT                                     (2u)
#define RCANFD_RSCFD0CFDGFDCFG_RPED                                            (0x00000001u)
#define RCANFD_RSCFD0CFDGFDCFG_RPED_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDGFDCFG_TSCCFG                                          (0x00000300u)
#define RCANFD_RSCFD0CFDGFDCFG_TSCCFG_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDGLOCKK_LOCK                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDGLOCKK_LOCK_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE0                                          (0x00000001u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE1                                          (0x00000002u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE1_SHIFT                                    (1u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE2                                          (0x00000004u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE2_SHIFT                                    (2u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE3                                          (0x00000008u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE3_SHIFT                                    (3u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE4                                          (0x00000010u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE4_SHIFT                                    (4u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE5                                          (0x00000020u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE5_SHIFT                                    (5u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE6                                          (0x00000040u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE6_SHIFT                                    (6u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE7                                          (0x00000080u)
#define RCANFD_RSCFD0CFDCDTCT_RFDMAE7_SHIFT                                    (7u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE0                                          (0x00000100u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE0_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE1                                          (0x00000200u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE1_SHIFT                                    (9u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE2                                          (0x00000400u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE2_SHIFT                                    (10u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE3                                          (0x00000800u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE3_SHIFT                                    (11u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE4                                          (0x00001000u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE4_SHIFT                                    (12u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE5                                          (0x00002000u)
#define RCANFD_RSCFD0CFDCDTCT_CFDMAE5_SHIFT                                    (13u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS0                                       (0x00000001u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS0_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS1                                       (0x00000002u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS1_SHIFT                                 (1u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS2                                       (0x00000004u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS2_SHIFT                                 (2u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS3                                       (0x00000008u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS3_SHIFT                                 (3u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS4                                       (0x00000010u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS4_SHIFT                                 (4u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS5                                       (0x00000020u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS5_SHIFT                                 (5u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS6                                       (0x00000040u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS6_SHIFT                                 (6u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS7                                       (0x00000080u)
#define RCANFD_RSCFD0CFDCDTSTS_RFDMASTS7_SHIFT                                 (7u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS0                                       (0x00000100u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS0_SHIFT                                 (8u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS1                                       (0x00000200u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS1_SHIFT                                 (9u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS2                                       (0x00000400u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS2_SHIFT                                 (10u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS3                                       (0x00000800u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS3_SHIFT                                 (11u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS4                                       (0x00001000u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS4_SHIFT                                 (12u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS5                                       (0x00002000u)
#define RCANFD_RSCFD0CFDCDTSTS_CFDMASTS5_SHIFT                                 (13u)
#define RCANFD_RSCFD0CFDGRMCFG_RCMC                                            (0x00000001u)
#define RCANFD_RSCFD0CFDGRMCFG_RCMC_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDC0DCFG_DBRP                                            (0x000000FFu)
#define RCANFD_RSCFD0CFDC0DCFG_DBRP_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDC0DCFG_DTSEG1                                          (0x000F0000u)
#define RCANFD_RSCFD0CFDC0DCFG_DTSEG1_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDC0DCFG_DTSEG2                                          (0x00700000u)
#define RCANFD_RSCFD0CFDC0DCFG_DTSEG2_SHIFT                                    (20u)
#define RCANFD_RSCFD0CFDC0DCFG_DSJW                                            (0x07000000u)
#define RCANFD_RSCFD0CFDC0DCFG_DSJW_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDC0FDCFG_EOCCFG                                         (0x00000007u)
#define RCANFD_RSCFD0CFDC0FDCFG_EOCCFG_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDC0FDCFG_TDCOC                                          (0x00000100u)
#define RCANFD_RSCFD0CFDC0FDCFG_TDCOC_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDC0FDCFG_TDCE                                           (0x00000200u)
#define RCANFD_RSCFD0CFDC0FDCFG_TDCE_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDC0FDCFG_ESIC                                           (0x00000400u)
#define RCANFD_RSCFD0CFDC0FDCFG_ESIC_SHIFT                                     (10u)
#define RCANFD_RSCFD0CFDC0FDCFG_TDCO                                           (0x007F0000u)
#define RCANFD_RSCFD0CFDC0FDCFG_TDCO_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDC0FDCFG_GWEN                                           (0x01000000u)
#define RCANFD_RSCFD0CFDC0FDCFG_GWEN_SHIFT                                     (24u)
#define RCANFD_RSCFD0CFDC0FDCFG_GWFDF                                          (0x02000000u)
#define RCANFD_RSCFD0CFDC0FDCFG_GWFDF_SHIFT                                    (25u)
#define RCANFD_RSCFD0CFDC0FDCFG_GWBRS                                          (0x04000000u)
#define RCANFD_RSCFD0CFDC0FDCFG_GWBRS_SHIFT                                    (26u)
#define RCANFD_RSCFD0CFDC0FDCFG_TMME                                           (0x08000000u)
#define RCANFD_RSCFD0CFDC0FDCFG_TMME_SHIFT                                     (27u)
#define RCANFD_RSCFD0CFDC0FDCFG_FDOE                                           (0x10000000u)
#define RCANFD_RSCFD0CFDC0FDCFG_FDOE_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDC0FDCFG_REFE                                           (0x20000000u)
#define RCANFD_RSCFD0CFDC0FDCFG_REFE_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDC0FDCTR_EOCCLR                                         (0x00000001u)
#define RCANFD_RSCFD0CFDC0FDCTR_EOCCLR_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDC0FDCTR_SOCCLR                                         (0x00000002u)
#define RCANFD_RSCFD0CFDC0FDCTR_SOCCLR_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDC0FDSTS_TDCR                                           (0x0000007Fu)
#define RCANFD_RSCFD0CFDC0FDSTS_TDCR_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDC0FDSTS_TDCVF                                          (0x00000080u)
#define RCANFD_RSCFD0CFDC0FDSTS_TDCVF_SHIFT                                    (7u)
#define RCANFD_RSCFD0CFDC0FDSTS_EOCO                                           (0x00000100u)
#define RCANFD_RSCFD0CFDC0FDSTS_EOCO_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDC0FDSTS_SOCO                                           (0x00000200u)
#define RCANFD_RSCFD0CFDC0FDSTS_SOCO_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDC0FDSTS_EOC                                            (0x00FF0000u)
#define RCANFD_RSCFD0CFDC0FDSTS_EOC_SHIFT                                      (16u)
#define RCANFD_RSCFD0CFDC0FDSTS_SOC                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDC0FDSTS_SOC_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDC0FDCRC_CRCREG                                         (0x001FFFFFu)
#define RCANFD_RSCFD0CFDC0FDCRC_CRCREG_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDC0FDCRC_SCNT                                           (0x0F000000u)
#define RCANFD_RSCFD0CFDC0FDCRC_SCNT_SHIFT                                     (24u)
#define RCANFD_RSCFD0CFDC1DCFG_DBRP                                            (0x000000FFu)
#define RCANFD_RSCFD0CFDC1DCFG_DBRP_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDC1DCFG_DTSEG1                                          (0x000F0000u)
#define RCANFD_RSCFD0CFDC1DCFG_DTSEG1_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDC1DCFG_DTSEG2                                          (0x00700000u)
#define RCANFD_RSCFD0CFDC1DCFG_DTSEG2_SHIFT                                    (20u)
#define RCANFD_RSCFD0CFDC1DCFG_DSJW                                            (0x07000000u)
#define RCANFD_RSCFD0CFDC1DCFG_DSJW_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDC1FDCFG_EOCCFG                                         (0x00000007u)
#define RCANFD_RSCFD0CFDC1FDCFG_EOCCFG_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDC1FDCFG_TDCOC                                          (0x00000100u)
#define RCANFD_RSCFD0CFDC1FDCFG_TDCOC_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDC1FDCFG_TDCE                                           (0x00000200u)
#define RCANFD_RSCFD0CFDC1FDCFG_TDCE_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDC1FDCFG_ESIC                                           (0x00000400u)
#define RCANFD_RSCFD0CFDC1FDCFG_ESIC_SHIFT                                     (10u)
#define RCANFD_RSCFD0CFDC1FDCFG_TDCO                                           (0x007F0000u)
#define RCANFD_RSCFD0CFDC1FDCFG_TDCO_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDC1FDCFG_GWEN                                           (0x01000000u)
#define RCANFD_RSCFD0CFDC1FDCFG_GWEN_SHIFT                                     (24u)
#define RCANFD_RSCFD0CFDC1FDCFG_GWFDF                                          (0x02000000u)
#define RCANFD_RSCFD0CFDC1FDCFG_GWFDF_SHIFT                                    (25u)
#define RCANFD_RSCFD0CFDC1FDCFG_GWBRS                                          (0x04000000u)
#define RCANFD_RSCFD0CFDC1FDCFG_GWBRS_SHIFT                                    (26u)
#define RCANFD_RSCFD0CFDC1FDCFG_TMME                                           (0x08000000u)
#define RCANFD_RSCFD0CFDC1FDCFG_TMME_SHIFT                                     (27u)
#define RCANFD_RSCFD0CFDC1FDCFG_FDOE                                           (0x10000000u)
#define RCANFD_RSCFD0CFDC1FDCFG_FDOE_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDC1FDCFG_REFE                                           (0x20000000u)
#define RCANFD_RSCFD0CFDC1FDCFG_REFE_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDC1FDCTR_EOCCLR                                         (0x00000001u)
#define RCANFD_RSCFD0CFDC1FDCTR_EOCCLR_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDC1FDCTR_SOCCLR                                         (0x00000002u)
#define RCANFD_RSCFD0CFDC1FDCTR_SOCCLR_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDC1FDSTS_TDCR                                           (0x0000007Fu)
#define RCANFD_RSCFD0CFDC1FDSTS_TDCR_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDC1FDSTS_TDCVF                                          (0x00000080u)
#define RCANFD_RSCFD0CFDC1FDSTS_TDCVF_SHIFT                                    (7u)
#define RCANFD_RSCFD0CFDC1FDSTS_EOCO                                           (0x00000100u)
#define RCANFD_RSCFD0CFDC1FDSTS_EOCO_SHIFT                                     (8u)
#define RCANFD_RSCFD0CFDC1FDSTS_SOCO                                           (0x00000200u)
#define RCANFD_RSCFD0CFDC1FDSTS_SOCO_SHIFT                                     (9u)
#define RCANFD_RSCFD0CFDC1FDSTS_EOC                                            (0x00FF0000u)
#define RCANFD_RSCFD0CFDC1FDSTS_EOC_SHIFT                                      (16u)
#define RCANFD_RSCFD0CFDC1FDSTS_SOC                                            (0xFF000000u)
#define RCANFD_RSCFD0CFDC1FDSTS_SOC_SHIFT                                      (24u)
#define RCANFD_RSCFD0CFDC1FDCRC_CRCREG                                         (0x001FFFFFu)
#define RCANFD_RSCFD0CFDC1FDCRC_CRCREG_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDC1FDCRC_SCNT                                           (0x0F000000u)
#define RCANFD_RSCFD0CFDC1FDCRC_SCNT_SHIFT                                     (24u)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID0_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM0_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM0_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM0_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM0_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM0_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM0_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_0_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_0_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_0_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID1_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM1_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM1_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM1_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM1_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM1_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM1_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_1_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_1_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_1_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID2_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM2_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM2_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM2_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM2_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM2_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM2_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_2_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_2_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_2_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID3_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM3_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM3_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM3_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM3_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM3_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM3_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_3_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_3_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_3_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID4_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM4_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM4_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM4_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM4_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM4_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM4_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_4_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_4_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_4_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID5_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM5_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM5_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM5_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM5_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM5_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM5_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_5_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_5_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_5_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID6_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM6_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM6_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM6_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM6_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM6_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM6_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_6_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_6_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_6_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID7_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM7_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM7_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM7_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM7_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM7_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM7_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_7_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_7_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_7_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID8_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM8_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM8_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM8_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM8_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM8_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM8_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_8_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_8_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_8_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLID                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLID_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLLB                                         (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLLB_SHIFT                                   (29u)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLRTR                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLRTR_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLIDE                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID9_GAFLIDE_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLM9_GAFLIDM                                         (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM9_GAFLIDM_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDGAFLM9_GAFLRTRM                                        (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM9_GAFLRTRM_SHIFT                                  (30u)
#define RCANFD_RSCFD0CFDGAFLM9_GAFLIDEM                                        (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM9_GAFLIDEM_SHIFT                                  (31u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLRMDP                                      (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLRMDP_SHIFT                                (8u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLRMV                                       (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLRMV_SHIFT                                 (15u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLPTR                                       (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLPTR_SHIFT                                 (16u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLDLC                                       (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_9_GAFLDLC_SHIFT                                 (28u)
#define RCANFD_RSCFD0CFDGAFLP1_9_GAFLFDP                                       (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_9_GAFLFDP_SHIFT                                 (0u)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLID                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLID_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLLB                                        (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLLB_SHIFT                                  (29u)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLRTR                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLRTR_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLIDE                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID10_GAFLIDE_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLM10_GAFLIDM                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM10_GAFLIDM_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLM10_GAFLRTRM                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM10_GAFLRTRM_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLM10_GAFLIDEM                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM10_GAFLIDEM_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLRMDP                                     (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLRMDP_SHIFT                               (8u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLRMV                                      (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLRMV_SHIFT                                (15u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLPTR                                      (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLPTR_SHIFT                                (16u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLDLC                                      (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_10_GAFLDLC_SHIFT                                (28u)
#define RCANFD_RSCFD0CFDGAFLP1_10_GAFLFDP                                      (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_10_GAFLFDP_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLID                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLID_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLLB                                        (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLLB_SHIFT                                  (29u)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLRTR                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLRTR_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLIDE                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID11_GAFLIDE_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLM11_GAFLIDM                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM11_GAFLIDM_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLM11_GAFLRTRM                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM11_GAFLRTRM_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLM11_GAFLIDEM                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM11_GAFLIDEM_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLRMDP                                     (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLRMDP_SHIFT                               (8u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLRMV                                      (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLRMV_SHIFT                                (15u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLPTR                                      (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLPTR_SHIFT                                (16u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLDLC                                      (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_11_GAFLDLC_SHIFT                                (28u)
#define RCANFD_RSCFD0CFDGAFLP1_11_GAFLFDP                                      (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_11_GAFLFDP_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLID                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLID_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLLB                                        (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLLB_SHIFT                                  (29u)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLRTR                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLRTR_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLIDE                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID12_GAFLIDE_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLM12_GAFLIDM                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM12_GAFLIDM_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLM12_GAFLRTRM                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM12_GAFLRTRM_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLM12_GAFLIDEM                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM12_GAFLIDEM_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLRMDP                                     (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLRMDP_SHIFT                               (8u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLRMV                                      (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLRMV_SHIFT                                (15u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLPTR                                      (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLPTR_SHIFT                                (16u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLDLC                                      (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_12_GAFLDLC_SHIFT                                (28u)
#define RCANFD_RSCFD0CFDGAFLP1_12_GAFLFDP                                      (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_12_GAFLFDP_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLID                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLID_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLLB                                        (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLLB_SHIFT                                  (29u)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLRTR                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLRTR_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLIDE                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID13_GAFLIDE_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLM13_GAFLIDM                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM13_GAFLIDM_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLM13_GAFLRTRM                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM13_GAFLRTRM_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLM13_GAFLIDEM                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM13_GAFLIDEM_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLRMDP                                     (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLRMDP_SHIFT                               (8u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLRMV                                      (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLRMV_SHIFT                                (15u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLPTR                                      (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLPTR_SHIFT                                (16u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLDLC                                      (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_13_GAFLDLC_SHIFT                                (28u)
#define RCANFD_RSCFD0CFDGAFLP1_13_GAFLFDP                                      (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_13_GAFLFDP_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLID                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLID_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLLB                                        (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLLB_SHIFT                                  (29u)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLRTR                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLRTR_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLIDE                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID14_GAFLIDE_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLM14_GAFLIDM                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM14_GAFLIDM_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLM14_GAFLRTRM                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM14_GAFLRTRM_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLM14_GAFLIDEM                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM14_GAFLIDEM_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLRMDP                                     (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLRMDP_SHIFT                               (8u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLRMV                                      (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLRMV_SHIFT                                (15u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLPTR                                      (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLPTR_SHIFT                                (16u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLDLC                                      (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_14_GAFLDLC_SHIFT                                (28u)
#define RCANFD_RSCFD0CFDGAFLP1_14_GAFLFDP                                      (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_14_GAFLFDP_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLID                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLID_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLLB                                        (0x20000000u)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLLB_SHIFT                                  (29u)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLRTR                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLRTR_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLIDE                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLID15_GAFLIDE_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLM15_GAFLIDM                                        (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDGAFLM15_GAFLIDM_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDGAFLM15_GAFLRTRM                                       (0x40000000u)
#define RCANFD_RSCFD0CFDGAFLM15_GAFLRTRM_SHIFT                                 (30u)
#define RCANFD_RSCFD0CFDGAFLM15_GAFLIDEM                                       (0x80000000u)
#define RCANFD_RSCFD0CFDGAFLM15_GAFLIDEM_SHIFT                                 (31u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLRMDP                                     (0x00007F00u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLRMDP_SHIFT                               (8u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLRMV                                      (0x00008000u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLRMV_SHIFT                                (15u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLPTR                                      (0x0FFF0000u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLPTR_SHIFT                                (16u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLDLC                                      (0xF0000000u)
#define RCANFD_RSCFD0CFDGAFLP0_15_GAFLDLC_SHIFT                                (28u)
#define RCANFD_RSCFD0CFDGAFLP1_15_GAFLFDP                                      (0x00003FFFu)
#define RCANFD_RSCFD0CFDGAFLP1_15_GAFLFDP_SHIFT                                (0u)
#define RCANFD_RSCFD0CFDRMID0_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID0_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID0_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID0_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID0_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID0_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR0_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR0_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR0_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR0_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR0_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR0_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS0_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS0_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS0_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS0_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS0_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS0_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_0_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_0_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_0_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_0_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_0_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID1_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID1_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID1_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID1_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID1_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID1_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR1_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR1_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR1_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR1_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR1_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR1_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS1_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS1_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS1_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS1_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS1_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS1_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_1_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_1_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_1_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_1_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_1_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID2_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID2_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID2_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID2_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID2_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID2_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR2_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR2_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR2_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR2_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR2_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR2_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS2_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS2_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS2_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS2_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS2_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS2_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_2_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_2_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_2_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_2_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_2_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID3_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID3_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID3_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID3_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID3_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID3_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR3_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR3_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR3_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR3_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR3_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR3_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS3_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS3_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS3_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS3_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS3_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS3_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_3_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_3_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_3_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_3_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_3_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID4_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID4_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID4_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID4_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID4_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID4_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR4_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR4_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR4_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR4_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR4_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR4_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS4_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS4_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS4_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS4_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS4_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS4_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_4_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_4_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_4_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_4_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_4_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID5_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID5_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID5_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID5_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID5_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID5_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR5_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR5_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR5_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR5_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR5_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR5_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS5_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS5_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS5_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS5_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS5_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS5_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_5_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_5_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_5_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_5_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_5_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID6_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID6_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID6_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID6_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID6_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID6_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR6_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR6_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR6_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR6_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR6_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR6_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS6_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS6_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS6_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS6_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS6_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS6_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_6_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_6_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_6_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_6_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_6_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID7_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID7_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID7_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID7_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID7_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID7_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR7_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR7_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR7_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR7_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR7_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR7_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS7_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS7_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS7_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS7_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS7_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS7_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_7_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_7_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_7_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_7_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_7_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID8_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID8_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID8_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID8_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID8_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID8_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR8_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR8_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR8_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR8_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR8_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR8_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS8_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS8_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS8_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS8_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS8_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS8_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_8_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_8_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_8_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_8_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_8_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID9_RMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID9_RMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRMID9_RMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRMID9_RMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRMID9_RMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRMID9_RMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRMPTR9_RMTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR9_RMTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMPTR9_RMPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR9_RMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRMPTR9_RMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR9_RMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRMFDSTS9_RMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS9_RMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMFDSTS9_RMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS9_RMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRMFDSTS9_RMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS9_RMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_9_RMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_9_RMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_9_RMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_9_RMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_9_RMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMID10_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID10_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID10_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID10_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID10_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID10_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR10_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR10_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR10_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR10_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR10_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR10_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS10_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS10_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS10_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS10_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS10_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS10_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_10_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_10_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_10_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_10_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_10_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID11_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID11_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID11_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID11_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID11_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID11_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR11_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR11_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR11_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR11_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR11_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR11_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS11_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS11_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS11_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS11_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS11_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS11_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_11_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_11_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_11_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_11_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_11_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID12_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID12_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID12_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID12_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID12_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID12_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR12_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR12_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR12_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR12_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR12_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR12_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS12_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS12_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS12_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS12_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS12_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS12_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_12_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_12_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_12_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_12_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_12_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID13_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID13_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID13_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID13_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID13_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID13_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR13_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR13_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR13_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR13_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR13_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR13_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS13_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS13_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS13_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS13_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS13_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS13_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_13_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_13_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_13_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_13_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_13_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID14_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID14_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID14_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID14_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID14_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID14_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR14_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR14_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR14_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR14_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR14_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR14_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS14_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS14_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS14_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS14_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS14_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS14_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_14_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_14_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_14_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_14_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_14_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID15_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID15_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID15_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID15_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID15_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID15_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR15_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR15_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR15_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR15_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR15_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR15_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS15_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS15_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS15_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS15_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS15_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS15_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_15_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_15_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_15_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_15_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_15_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID16_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID16_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID16_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID16_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID16_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID16_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR16_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR16_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR16_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR16_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR16_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR16_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS16_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS16_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS16_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS16_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS16_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS16_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_16_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_16_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_16_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_16_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_16_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID17_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID17_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID17_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID17_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID17_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID17_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR17_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR17_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR17_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR17_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR17_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR17_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS17_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS17_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS17_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS17_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS17_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS17_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_17_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_17_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_17_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_17_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_17_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID18_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID18_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID18_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID18_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID18_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID18_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR18_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR18_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR18_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR18_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR18_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR18_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS18_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS18_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS18_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS18_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS18_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS18_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_18_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_18_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_18_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_18_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_18_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID19_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID19_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID19_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID19_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID19_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID19_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR19_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR19_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR19_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR19_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR19_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR19_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS19_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS19_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS19_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS19_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS19_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS19_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_19_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_19_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_19_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_19_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_19_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID20_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID20_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID20_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID20_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID20_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID20_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR20_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR20_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR20_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR20_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR20_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR20_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS20_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS20_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS20_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS20_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS20_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS20_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_20_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_20_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_20_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_20_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_20_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID21_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID21_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID21_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID21_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID21_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID21_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR21_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR21_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR21_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR21_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR21_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR21_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS21_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS21_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS21_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS21_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS21_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS21_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_21_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_21_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_21_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_21_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_21_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID22_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID22_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID22_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID22_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID22_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID22_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR22_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR22_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR22_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR22_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR22_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR22_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS22_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS22_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS22_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS22_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS22_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS22_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_22_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_22_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_22_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_22_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_22_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID23_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID23_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID23_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID23_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID23_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID23_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR23_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR23_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR23_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR23_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR23_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR23_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS23_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS23_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS23_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS23_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS23_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS23_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_23_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_23_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_23_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_23_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_23_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID24_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID24_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID24_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID24_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID24_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID24_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR24_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR24_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR24_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR24_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR24_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR24_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS24_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS24_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS24_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS24_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS24_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS24_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_24_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_24_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_24_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_24_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_24_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID25_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID25_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID25_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID25_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID25_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID25_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR25_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR25_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR25_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR25_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR25_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR25_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS25_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS25_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS25_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS25_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS25_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS25_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_25_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_25_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_25_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_25_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_25_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID26_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID26_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID26_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID26_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID26_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID26_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR26_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR26_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR26_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR26_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR26_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR26_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS26_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS26_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS26_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS26_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS26_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS26_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_26_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_26_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_26_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_26_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_26_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID27_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID27_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID27_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID27_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID27_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID27_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR27_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR27_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR27_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR27_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR27_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR27_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS27_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS27_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS27_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS27_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS27_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS27_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_27_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_27_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_27_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_27_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_27_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID28_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID28_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID28_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID28_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID28_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID28_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR28_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR28_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR28_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR28_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR28_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR28_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS28_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS28_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS28_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS28_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS28_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS28_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_28_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_28_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_28_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_28_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_28_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID29_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID29_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID29_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID29_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID29_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID29_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR29_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR29_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR29_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR29_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR29_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR29_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS29_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS29_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS29_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS29_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS29_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS29_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_29_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_29_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_29_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_29_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_29_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID30_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID30_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID30_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID30_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID30_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID30_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR30_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR30_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR30_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR30_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR30_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR30_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS30_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS30_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS30_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS30_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS30_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS30_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_30_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_30_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_30_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_30_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_30_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMID31_RMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRMID31_RMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRMID31_RMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDRMID31_RMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDRMID31_RMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDRMID31_RMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDRMPTR31_RMTS                                           (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRMPTR31_RMTS_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRMPTR31_RMPTR                                          (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRMPTR31_RMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRMPTR31_RMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDRMPTR31_RMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDRMFDSTS31_RMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDRMFDSTS31_RMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMFDSTS31_RMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDRMFDSTS31_RMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDRMFDSTS31_RMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDRMFDSTS31_RMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF0_31_RMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF1_31_RMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF2_31_RMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF3_31_RMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRMDF4_31_RMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID0_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID0_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID0_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID0_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID0_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID0_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR0_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR0_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR0_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR0_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR0_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR0_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS0_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS0_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS0_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS0_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS0_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS0_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_0_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_0_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_0_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_0_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_0_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_0_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_0_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_0_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_0_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_0_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_0_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_0_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_0_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_0_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_0_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_0_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID1_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID1_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID1_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID1_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID1_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID1_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR1_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR1_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR1_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR1_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR1_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR1_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS1_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS1_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS1_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS1_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS1_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS1_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_1_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_1_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_1_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_1_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_1_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_1_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_1_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_1_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_1_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_1_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_1_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_1_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_1_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_1_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_1_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_1_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID2_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID2_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID2_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID2_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID2_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID2_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR2_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR2_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR2_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR2_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR2_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR2_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS2_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS2_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS2_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS2_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS2_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS2_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_2_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_2_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_2_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_2_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_2_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_2_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_2_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_2_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_2_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_2_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_2_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_2_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_2_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_2_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_2_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_2_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID3_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID3_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID3_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID3_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID3_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID3_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR3_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR3_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR3_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR3_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR3_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR3_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS3_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS3_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS3_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS3_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS3_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS3_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_3_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_3_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_3_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_3_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_3_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_3_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_3_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_3_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_3_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_3_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_3_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_3_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_3_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_3_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_3_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_3_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID4_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID4_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID4_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID4_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID4_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID4_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR4_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR4_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR4_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR4_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR4_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR4_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS4_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS4_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS4_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS4_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS4_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS4_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_4_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_4_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_4_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_4_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_4_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_4_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_4_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_4_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_4_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_4_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_4_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_4_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_4_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_4_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_4_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_4_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID5_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID5_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID5_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID5_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID5_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID5_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR5_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR5_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR5_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR5_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR5_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR5_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS5_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS5_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS5_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS5_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS5_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS5_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_5_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_5_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_5_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_5_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_5_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_5_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_5_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_5_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_5_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_5_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_5_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_5_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_5_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_5_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_5_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_5_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID6_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID6_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID6_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID6_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID6_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID6_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR6_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR6_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR6_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR6_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR6_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR6_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS6_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS6_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS6_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS6_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS6_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS6_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_6_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_6_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_6_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_6_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_6_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_6_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_6_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_6_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_6_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_6_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_6_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_6_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_6_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_6_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_6_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_6_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFID7_RFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDRFID7_RFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDRFID7_RFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDRFID7_RFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDRFID7_RFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDRFID7_RFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDRFPTR7_RFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDRFPTR7_RFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDRFPTR7_RFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDRFPTR7_RFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRFPTR7_RFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDRFPTR7_RFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDRFFDSTS7_RFESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDRFFDSTS7_RFESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFFDSTS7_RFBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDRFFDSTS7_RFBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDRFFDSTS7_RFFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDRFFDSTS7_RFFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF0_7_RFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF1_7_RFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF2_7_RFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF3_7_RFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF4_7_RFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF5_7_RFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF6_7_RFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF7_7_RFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF8_7_RFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF9_7_RFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF10_7_RFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF11_7_RFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF12_7_RFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF13_7_RFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF14_7_RFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDRFDF15_7_RFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFID0_CFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDCFID0_CFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDCFID0_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDCFID0_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDCFID0_CFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDCFID0_CFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDCFID0_CFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDCFID0_CFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDCFPTR0_CFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDCFPTR0_CFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDCFPTR0_CFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDCFPTR0_CFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDCFPTR0_CFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDCFPTR0_CFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDCFFDCSTS0_CFESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFFDCSTS0_CFESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFFDCSTS0_CFBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFFDCSTS0_CFBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFFDCSTS0_CFFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFFDCSTS0_CFFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF0_0_CFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF1_0_CFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF2_0_CFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF3_0_CFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF4_0_CFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF5_0_CFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF6_0_CFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF7_0_CFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF8_0_CFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF9_0_CFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF10_0_CFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF11_0_CFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF12_0_CFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF13_0_CFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF14_0_CFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF15_0_CFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFID1_CFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDCFID1_CFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDCFID1_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDCFID1_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDCFID1_CFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDCFID1_CFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDCFID1_CFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDCFID1_CFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDCFPTR1_CFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDCFPTR1_CFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDCFPTR1_CFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDCFPTR1_CFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDCFPTR1_CFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDCFPTR1_CFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDCFFDCSTS1_CFESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFFDCSTS1_CFESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFFDCSTS1_CFBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFFDCSTS1_CFBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFFDCSTS1_CFFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFFDCSTS1_CFFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF0_1_CFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF1_1_CFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF2_1_CFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF3_1_CFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF4_1_CFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF5_1_CFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF6_1_CFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF7_1_CFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF8_1_CFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF9_1_CFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF10_1_CFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF11_1_CFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF12_1_CFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF13_1_CFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF14_1_CFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF15_1_CFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFID2_CFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDCFID2_CFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDCFID2_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDCFID2_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDCFID2_CFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDCFID2_CFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDCFID2_CFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDCFID2_CFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDCFPTR2_CFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDCFPTR2_CFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDCFPTR2_CFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDCFPTR2_CFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDCFPTR2_CFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDCFPTR2_CFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDCFFDCSTS2_CFESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFFDCSTS2_CFESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFFDCSTS2_CFBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFFDCSTS2_CFBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFFDCSTS2_CFFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFFDCSTS2_CFFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF0_2_CFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF1_2_CFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF2_2_CFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF3_2_CFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF4_2_CFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF5_2_CFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF6_2_CFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF7_2_CFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF8_2_CFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF9_2_CFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF10_2_CFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF11_2_CFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF12_2_CFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF13_2_CFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF14_2_CFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF15_2_CFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFID3_CFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDCFID3_CFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDCFID3_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDCFID3_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDCFID3_CFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDCFID3_CFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDCFID3_CFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDCFID3_CFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDCFPTR3_CFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDCFPTR3_CFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDCFPTR3_CFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDCFPTR3_CFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDCFPTR3_CFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDCFPTR3_CFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDCFFDCSTS3_CFESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFFDCSTS3_CFESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFFDCSTS3_CFBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFFDCSTS3_CFBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFFDCSTS3_CFFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFFDCSTS3_CFFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF0_3_CFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF1_3_CFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF2_3_CFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF3_3_CFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF4_3_CFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF5_3_CFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF6_3_CFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF7_3_CFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF8_3_CFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF9_3_CFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF10_3_CFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF11_3_CFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF12_3_CFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF13_3_CFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF14_3_CFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF15_3_CFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFID4_CFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDCFID4_CFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDCFID4_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDCFID4_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDCFID4_CFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDCFID4_CFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDCFID4_CFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDCFID4_CFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDCFPTR4_CFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDCFPTR4_CFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDCFPTR4_CFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDCFPTR4_CFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDCFPTR4_CFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDCFPTR4_CFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDCFFDCSTS4_CFESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFFDCSTS4_CFESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFFDCSTS4_CFBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFFDCSTS4_CFBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFFDCSTS4_CFFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFFDCSTS4_CFFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF0_4_CFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF1_4_CFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF2_4_CFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF3_4_CFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF4_4_CFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF5_4_CFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF6_4_CFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF7_4_CFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF8_4_CFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF9_4_CFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF10_4_CFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF11_4_CFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF12_4_CFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF13_4_CFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF14_4_CFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF15_4_CFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFID5_CFID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDCFID5_CFID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDCFID5_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDCFID5_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDCFID5_CFRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDCFID5_CFRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDCFID5_CFIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDCFID5_CFIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDCFPTR5_CFTS                                            (0x0000FFFFu)
#define RCANFD_RSCFD0CFDCFPTR5_CFTS_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDCFPTR5_CFPTR                                           (0x0FFF0000u)
#define RCANFD_RSCFD0CFDCFPTR5_CFPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDCFPTR5_CFDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDCFPTR5_CFDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDCFFDCSTS5_CFESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDCFFDCSTS5_CFESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFFDCSTS5_CFBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDCFFDCSTS5_CFBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDCFFDCSTS5_CFFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDCFFDCSTS5_CFFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF0_5_CFDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF1_5_CFDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF2_5_CFDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF3_5_CFDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF4_5_CFDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB20                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB20_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB21                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB21_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB22                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB22_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB23                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF5_5_CFDB23_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB24                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB24_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB25                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB25_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB26                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB26_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB27                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF6_5_CFDB27_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB28                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB28_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB29                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB29_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB30                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB30_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB31                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF7_5_CFDB31_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB32                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB32_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB33                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB33_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB34                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB34_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB35                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF8_5_CFDB35_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB36                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB36_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB37                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB37_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB38                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB38_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB39                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF9_5_CFDB39_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB40                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB40_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB41                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB41_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB42                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB42_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB43                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF10_5_CFDB43_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB44                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB44_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB45                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB45_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB46                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB46_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB47                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF11_5_CFDB47_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB48                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB48_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB49                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB49_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB50                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB50_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB51                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF12_5_CFDB51_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB52                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB52_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB53                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB53_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB54                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB54_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB55                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF13_5_CFDB55_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB56                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB56_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB57                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB57_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB58                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB58_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB59                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF14_5_CFDB59_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB60                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB60_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB61                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB61_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB62                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB62_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB63                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDCFDF15_5_CFDB63_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID0_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID0_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID0_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID0_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID0_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID0_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID0_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID0_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR0_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR0_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR0_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR0_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR0_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR0_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR0_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR0_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR0_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR0_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_0_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_0_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_0_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_0_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_0_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID1_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID1_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID1_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID1_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID1_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID1_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID1_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID1_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR1_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR1_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR1_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR1_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR1_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR1_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR1_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR1_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR1_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR1_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_1_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_1_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_1_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_1_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_1_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID2_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID2_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID2_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID2_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID2_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID2_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID2_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID2_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR2_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR2_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR2_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR2_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR2_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR2_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR2_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR2_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR2_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR2_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_2_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_2_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_2_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_2_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_2_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID3_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID3_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID3_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID3_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID3_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID3_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID3_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID3_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR3_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR3_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR3_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR3_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR3_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR3_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR3_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR3_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR3_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR3_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_3_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_3_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_3_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_3_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_3_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID4_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID4_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID4_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID4_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID4_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID4_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID4_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID4_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR4_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR4_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR4_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR4_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR4_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR4_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR4_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR4_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR4_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR4_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_4_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_4_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_4_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_4_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_4_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID5_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID5_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID5_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID5_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID5_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID5_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID5_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID5_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR5_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR5_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR5_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR5_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR5_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR5_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR5_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR5_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR5_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR5_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_5_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_5_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_5_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_5_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_5_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID6_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID6_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID6_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID6_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID6_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID6_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID6_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID6_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR6_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR6_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR6_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR6_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR6_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR6_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR6_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR6_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR6_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR6_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_6_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_6_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_6_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_6_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_6_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID7_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID7_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID7_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID7_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID7_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID7_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID7_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID7_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR7_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR7_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR7_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR7_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR7_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR7_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR7_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR7_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR7_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR7_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_7_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_7_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_7_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_7_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_7_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID8_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID8_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID8_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID8_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID8_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID8_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID8_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID8_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR8_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR8_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR8_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR8_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR8_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR8_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR8_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR8_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR8_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR8_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_8_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_8_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_8_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_8_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_8_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID9_TMID                                             (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID9_TMID_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTMID9_THLEN                                            (0x20000000u)
#define RCANFD_RSCFD0CFDTMID9_THLEN_SHIFT                                      (29u)
#define RCANFD_RSCFD0CFDTMID9_TMRTR                                            (0x40000000u)
#define RCANFD_RSCFD0CFDTMID9_TMRTR_SHIFT                                      (30u)
#define RCANFD_RSCFD0CFDTMID9_TMIDE                                            (0x80000000u)
#define RCANFD_RSCFD0CFDTMID9_TMIDE_SHIFT                                      (31u)
#define RCANFD_RSCFD0CFDTMPTR9_TMPTR                                           (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR9_TMPTR_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTMPTR9_TMDLC                                           (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR9_TMDLC_SHIFT                                     (28u)
#define RCANFD_RSCFD0CFDTMFDCTR9_TMESI                                         (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR9_TMESI_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMFDCTR9_TMBRS                                         (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR9_TMBRS_SHIFT                                   (1u)
#define RCANFD_RSCFD0CFDTMFDCTR9_TMFDF                                         (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR9_TMFDF_SHIFT                                   (2u)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB0                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB0_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB1                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB1_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB2                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB2_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB3                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_9_TMDB3_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB4                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB4_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB5                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB5_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB6                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB6_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB7                                          (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_9_TMDB7_SHIFT                                    (24u)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB8                                          (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB8_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB9                                          (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB9_SHIFT                                    (8u)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB10                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB10_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB11                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_9_TMDB11_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB12                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB12_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB13                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB13_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB14                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB14_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB15                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_9_TMDB15_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB16                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB16_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB17                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB17_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB18                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB18_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB19                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_9_TMDB19_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMID10_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID10_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID10_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID10_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID10_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID10_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID10_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID10_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR10_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR10_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR10_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR10_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR10_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR10_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR10_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR10_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR10_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR10_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_10_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_10_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_10_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_10_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_10_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID11_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID11_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID11_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID11_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID11_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID11_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID11_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID11_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR11_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR11_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR11_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR11_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR11_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR11_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR11_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR11_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR11_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR11_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_11_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_11_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_11_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_11_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_11_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID12_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID12_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID12_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID12_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID12_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID12_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID12_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID12_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR12_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR12_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR12_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR12_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR12_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR12_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR12_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR12_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR12_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR12_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_12_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_12_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_12_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_12_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_12_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID13_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID13_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID13_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID13_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID13_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID13_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID13_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID13_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR13_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR13_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR13_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR13_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR13_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR13_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR13_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR13_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR13_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR13_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_13_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_13_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_13_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_13_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_13_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID14_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID14_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID14_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID14_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID14_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID14_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID14_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID14_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR14_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR14_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR14_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR14_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR14_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR14_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR14_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR14_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR14_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR14_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_14_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_14_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_14_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_14_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_14_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID15_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID15_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID15_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID15_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID15_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID15_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID15_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID15_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR15_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR15_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR15_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR15_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR15_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR15_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR15_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR15_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR15_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR15_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_15_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_15_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_15_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_15_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_15_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID16_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID16_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID16_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID16_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID16_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID16_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID16_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID16_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR16_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR16_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR16_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR16_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR16_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR16_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR16_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR16_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR16_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR16_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_16_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_16_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_16_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_16_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_16_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID17_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID17_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID17_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID17_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID17_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID17_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID17_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID17_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR17_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR17_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR17_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR17_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR17_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR17_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR17_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR17_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR17_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR17_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_17_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_17_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_17_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_17_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_17_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID18_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID18_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID18_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID18_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID18_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID18_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID18_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID18_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR18_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR18_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR18_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR18_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR18_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR18_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR18_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR18_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR18_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR18_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_18_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_18_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_18_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_18_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_18_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID19_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID19_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID19_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID19_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID19_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID19_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID19_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID19_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR19_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR19_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR19_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR19_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR19_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR19_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR19_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR19_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR19_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR19_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_19_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_19_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_19_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_19_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_19_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID20_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID20_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID20_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID20_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID20_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID20_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID20_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID20_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR20_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR20_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR20_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR20_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR20_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR20_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR20_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR20_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR20_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR20_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_20_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_20_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_20_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_20_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_20_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID21_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID21_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID21_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID21_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID21_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID21_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID21_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID21_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR21_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR21_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR21_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR21_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR21_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR21_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR21_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR21_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR21_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR21_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_21_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_21_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_21_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_21_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_21_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID22_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID22_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID22_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID22_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID22_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID22_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID22_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID22_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR22_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR22_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR22_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR22_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR22_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR22_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR22_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR22_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR22_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR22_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_22_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_22_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_22_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_22_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_22_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID23_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID23_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID23_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID23_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID23_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID23_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID23_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID23_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR23_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR23_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR23_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR23_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR23_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR23_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR23_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR23_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR23_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR23_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_23_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_23_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_23_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_23_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_23_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID24_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID24_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID24_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID24_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID24_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID24_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID24_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID24_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR24_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR24_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR24_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR24_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR24_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR24_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR24_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR24_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR24_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR24_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_24_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_24_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_24_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_24_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_24_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID25_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID25_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID25_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID25_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID25_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID25_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID25_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID25_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR25_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR25_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR25_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR25_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR25_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR25_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR25_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR25_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR25_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR25_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_25_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_25_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_25_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_25_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_25_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID26_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID26_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID26_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID26_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID26_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID26_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID26_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID26_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR26_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR26_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR26_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR26_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR26_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR26_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR26_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR26_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR26_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR26_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_26_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_26_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_26_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_26_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_26_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID27_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID27_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID27_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID27_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID27_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID27_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID27_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID27_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR27_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR27_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR27_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR27_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR27_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR27_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR27_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR27_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR27_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR27_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_27_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_27_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_27_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_27_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_27_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID28_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID28_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID28_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID28_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID28_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID28_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID28_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID28_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR28_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR28_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR28_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR28_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR28_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR28_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR28_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR28_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR28_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR28_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_28_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_28_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_28_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_28_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_28_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID29_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID29_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID29_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID29_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID29_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID29_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID29_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID29_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR29_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR29_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR29_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR29_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR29_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR29_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR29_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR29_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR29_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR29_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_29_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_29_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_29_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_29_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_29_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID30_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID30_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID30_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID30_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID30_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID30_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID30_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID30_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR30_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR30_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR30_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR30_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR30_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR30_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR30_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR30_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR30_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR30_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_30_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_30_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_30_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_30_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_30_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMID31_TMID                                            (0x1FFFFFFFu)
#define RCANFD_RSCFD0CFDTMID31_TMID_SHIFT                                      (0u)
#define RCANFD_RSCFD0CFDTMID31_THLEN                                           (0x20000000u)
#define RCANFD_RSCFD0CFDTMID31_THLEN_SHIFT                                     (29u)
#define RCANFD_RSCFD0CFDTMID31_TMRTR                                           (0x40000000u)
#define RCANFD_RSCFD0CFDTMID31_TMRTR_SHIFT                                     (30u)
#define RCANFD_RSCFD0CFDTMID31_TMIDE                                           (0x80000000u)
#define RCANFD_RSCFD0CFDTMID31_TMIDE_SHIFT                                     (31u)
#define RCANFD_RSCFD0CFDTMPTR31_TMPTR                                          (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMPTR31_TMPTR_SHIFT                                    (16u)
#define RCANFD_RSCFD0CFDTMPTR31_TMDLC                                          (0xF0000000u)
#define RCANFD_RSCFD0CFDTMPTR31_TMDLC_SHIFT                                    (28u)
#define RCANFD_RSCFD0CFDTMFDCTR31_TMESI                                        (0x00000001u)
#define RCANFD_RSCFD0CFDTMFDCTR31_TMESI_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMFDCTR31_TMBRS                                        (0x00000002u)
#define RCANFD_RSCFD0CFDTMFDCTR31_TMBRS_SHIFT                                  (1u)
#define RCANFD_RSCFD0CFDTMFDCTR31_TMFDF                                        (0x00000004u)
#define RCANFD_RSCFD0CFDTMFDCTR31_TMFDF_SHIFT                                  (2u)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB0                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB0_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB1                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB1_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB2                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB2_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB3                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF0_31_TMDB3_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB4                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB4_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB5                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB5_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB6                                         (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB6_SHIFT                                   (16u)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB7                                         (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF1_31_TMDB7_SHIFT                                   (24u)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB8                                         (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB8_SHIFT                                   (0u)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB9                                         (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB9_SHIFT                                   (8u)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB10                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB10_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB11                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF2_31_TMDB11_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB12                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB12_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB13                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB13_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB14                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB14_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB15                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF3_31_TMDB15_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB16                                        (0x000000FFu)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB16_SHIFT                                  (0u)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB17                                        (0x0000FF00u)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB17_SHIFT                                  (8u)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB18                                        (0x00FF0000u)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB18_SHIFT                                  (16u)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB19                                        (0xFF000000u)
#define RCANFD_RSCFD0CFDTMDF4_31_TMDB19_SHIFT                                  (24u)
#define RCANFD_RSCFD0CFDTHLACC0_BT                                             (0x00000007u)
#define RCANFD_RSCFD0CFDTHLACC0_BT_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTHLACC0_BN                                             (0x00000078u)
#define RCANFD_RSCFD0CFDTHLACC0_BN_SHIFT                                       (3u)
#define RCANFD_RSCFD0CFDTHLACC0_TID                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDTHLACC0_TID_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDTHLACC0_TMTS                                           (0xFFFF0000u)
#define RCANFD_RSCFD0CFDTHLACC0_TMTS_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDTHLACC1_BT                                             (0x00000007u)
#define RCANFD_RSCFD0CFDTHLACC1_BT_SHIFT                                       (0u)
#define RCANFD_RSCFD0CFDTHLACC1_BN                                             (0x00000078u)
#define RCANFD_RSCFD0CFDTHLACC1_BN_SHIFT                                       (3u)
#define RCANFD_RSCFD0CFDTHLACC1_TID                                            (0x0000FF00u)
#define RCANFD_RSCFD0CFDTHLACC1_TID_SHIFT                                      (8u)
#define RCANFD_RSCFD0CFDTHLACC1_TMTS                                           (0xFFFF0000u)
#define RCANFD_RSCFD0CFDTHLACC1_TMTS_SHIFT                                     (16u)
#define RCANFD_RSCFD0CFDRPGACC0_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC0_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC1_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC1_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC2_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC2_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC3_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC3_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC4_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC4_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC5_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC5_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC6_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC6_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC7_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC7_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC8_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC8_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC9_RDTA                                           (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC9_RDTA_SHIFT                                     (0u)
#define RCANFD_RSCFD0CFDRPGACC10_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC10_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC11_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC11_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC12_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC12_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC13_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC13_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC14_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC14_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC15_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC15_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC16_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC16_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC17_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC17_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC18_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC18_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC19_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC19_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC20_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC20_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC21_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC21_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC22_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC22_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC23_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC23_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC24_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC24_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC25_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC25_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC26_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC26_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC27_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC27_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC28_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC28_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC29_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC29_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC30_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC30_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC31_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC31_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC32_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC32_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC33_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC33_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC34_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC34_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC35_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC35_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC36_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC36_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC37_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC37_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC38_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC38_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC39_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC39_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC40_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC40_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC41_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC41_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC42_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC42_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC43_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC43_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC44_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC44_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC45_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC45_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC46_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC46_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC47_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC47_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC48_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC48_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC49_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC49_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC50_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC50_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC51_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC51_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC52_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC52_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC53_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC53_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC54_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC54_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC55_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC55_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC56_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC56_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC57_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC57_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC58_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC58_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC59_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC59_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC60_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC60_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC61_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC61_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC62_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC62_RDTA_SHIFT                                    (0u)
#define RCANFD_RSCFD0CFDRPGACC63_RDTA                                          (0xFFFFFFFFu)
#define RCANFD_RSCFD0CFDRPGACC63_RDTA_SHIFT                                    (0u)

#endif
