/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef USB_IOBITMASK_H
#define USB_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define USB_HCCONTROL_CBSR                                                     (0x00000003u)
#define USB_HCCONTROL_CBSR_SHIFT                                               (0u)
#define USB_HCCONTROL_PLE                                                      (0x00000004u)
#define USB_HCCONTROL_PLE_SHIFT                                                (2u)
#define USB_HCCONTROL_IE                                                       (0x00000008u)
#define USB_HCCONTROL_IE_SHIFT                                                 (3u)
#define USB_HCCONTROL_CLE                                                      (0x00000010u)
#define USB_HCCONTROL_CLE_SHIFT                                                (4u)
#define USB_HCCONTROL_BLE                                                      (0x00000020u)
#define USB_HCCONTROL_BLE_SHIFT                                                (5u)
#define USB_HCCONTROL_HCFS                                                     (0x000000C0u)
#define USB_HCCONTROL_HCFS_SHIFT                                               (6u)
#define USB_HCCONTROL_RWC                                                      (0x00000200u)
#define USB_HCCONTROL_RWC_SHIFT                                                (9u)
#define USB_HCCOMMANDSTATUS_HCR                                                (0x00000001u)
#define USB_HCCOMMANDSTATUS_HCR_SHIFT                                          (0u)
#define USB_HCCOMMANDSTATUS_CLF                                                (0x00000002u)
#define USB_HCCOMMANDSTATUS_CLF_SHIFT                                          (1u)
#define USB_HCCOMMANDSTATUS_BLF                                                (0x00000004u)
#define USB_HCCOMMANDSTATUS_BLF_SHIFT                                          (2u)
#define USB_HCCOMMANDSTATUS_SOC                                                (0x00030000u)
#define USB_HCCOMMANDSTATUS_SOC_SHIFT                                          (16u)
#define USB_HCINTERRUPTSTATUS_SO                                               (0x00000001u)
#define USB_HCINTERRUPTSTATUS_SO_SHIFT                                         (0u)
#define USB_HCINTERRUPTSTATUS_WDH                                              (0x00000002u)
#define USB_HCINTERRUPTSTATUS_WDH_SHIFT                                        (1u)
#define USB_HCINTERRUPTSTATUS_SF                                               (0x00000004u)
#define USB_HCINTERRUPTSTATUS_SF_SHIFT                                         (2u)
#define USB_HCINTERRUPTSTATUS_RD                                               (0x00000008u)
#define USB_HCINTERRUPTSTATUS_RD_SHIFT                                         (3u)
#define USB_HCINTERRUPTSTATUS_UE                                               (0x00000010u)
#define USB_HCINTERRUPTSTATUS_UE_SHIFT                                         (4u)
#define USB_HCINTERRUPTSTATUS_FNO                                              (0x00000020u)
#define USB_HCINTERRUPTSTATUS_FNO_SHIFT                                        (5u)
#define USB_HCINTERRUPTSTATUS_RHSC                                             (0x00000040u)
#define USB_HCINTERRUPTSTATUS_RHSC_SHIFT                                       (6u)
#define USB_HCINTERRUPTENABLE_SOE                                              (0x00000001u)
#define USB_HCINTERRUPTENABLE_SOE_SHIFT                                        (0u)
#define USB_HCINTERRUPTENABLE_WDHE                                             (0x00000002u)
#define USB_HCINTERRUPTENABLE_WDHE_SHIFT                                       (1u)
#define USB_HCINTERRUPTENABLE_SFE                                              (0x00000004u)
#define USB_HCINTERRUPTENABLE_SFE_SHIFT                                        (2u)
#define USB_HCINTERRUPTENABLE_RDE                                              (0x00000008u)
#define USB_HCINTERRUPTENABLE_RDE_SHIFT                                        (3u)
#define USB_HCINTERRUPTENABLE_UEE                                              (0x00000010u)
#define USB_HCINTERRUPTENABLE_UEE_SHIFT                                        (4u)
#define USB_HCINTERRUPTENABLE_FNOE                                             (0x00000020u)
#define USB_HCINTERRUPTENABLE_FNOE_SHIFT                                       (5u)
#define USB_HCINTERRUPTENABLE_RHSCE                                            (0x00000040u)
#define USB_HCINTERRUPTENABLE_RHSCE_SHIFT                                      (6u)
#define USB_HCINTERRUPTENABLE_OCE                                              (0x40000000u)
#define USB_HCINTERRUPTENABLE_OCE_SHIFT                                        (30u)
#define USB_HCINTERRUPTENABLE_MIE                                              (0x80000000u)
#define USB_HCINTERRUPTENABLE_MIE_SHIFT                                        (31u)
#define USB_HCINTERRUPTDISABLE_SOD                                             (0x00000001u)
#define USB_HCINTERRUPTDISABLE_SOD_SHIFT                                       (0u)
#define USB_HCINTERRUPTDISABLE_WDHD                                            (0x00000002u)
#define USB_HCINTERRUPTDISABLE_WDHD_SHIFT                                      (1u)
#define USB_HCINTERRUPTDISABLE_SFD                                             (0x00000004u)
#define USB_HCINTERRUPTDISABLE_SFD_SHIFT                                       (2u)
#define USB_HCINTERRUPTDISABLE_RDD                                             (0x00000008u)
#define USB_HCINTERRUPTDISABLE_RDD_SHIFT                                       (3u)
#define USB_HCINTERRUPTDISABLE_UED                                             (0x00000010u)
#define USB_HCINTERRUPTDISABLE_UED_SHIFT                                       (4u)
#define USB_HCINTERRUPTDISABLE_FNOD                                            (0x00000020u)
#define USB_HCINTERRUPTDISABLE_FNOD_SHIFT                                      (5u)
#define USB_HCINTERRUPTDISABLE_RHSCD                                           (0x00000040u)
#define USB_HCINTERRUPTDISABLE_RHSCD_SHIFT                                     (6u)
#define USB_HCINTERRUPTDISABLE_OCD                                             (0x40000000u)
#define USB_HCINTERRUPTDISABLE_OCD_SHIFT                                       (30u)
#define USB_HCINTERRUPTDISABLE_MID                                             (0x80000000u)
#define USB_HCINTERRUPTDISABLE_MID_SHIFT                                       (31u)
#define USB_HCHCCA_HcHCCA                                                      (0xFFFFFF00u)
#define USB_HCHCCA_HcHCCA_SHIFT                                                (8u)
#define USB_HCPERIODCURRENTED_PECD                                             (0xFFFFFFF0u)
#define USB_HCPERIODCURRENTED_PECD_SHIFT                                       (4u)
#define USB_HCCONTROLHEADED_CHED                                               (0xFFFFFFF0u)
#define USB_HCCONTROLHEADED_CHED_SHIFT                                         (4u)
#define USB_HCCONTROLCURRENTED_CCED                                            (0xFFFFFFF0u)
#define USB_HCCONTROLCURRENTED_CCED_SHIFT                                      (4u)
#define USB_HCBULKHEADED_BHED                                                  (0xFFFFFFF0u)
#define USB_HCBULKHEADED_BHED_SHIFT                                            (4u)
#define USB_HCBULKCURRENTED_BCED                                               (0xFFFFFFF0u)
#define USB_HCBULKCURRENTED_BCED_SHIFT                                         (4u)
#define USB_HCDONEHEAD_DH                                                      (0xFFFFFFF0u)
#define USB_HCDONEHEAD_DH_SHIFT                                                (4u)
#define USB_HCFMINTERVAL_FI                                                    (0x00003FFFu)
#define USB_HCFMINTERVAL_FI_SHIFT                                              (0u)
#define USB_HCFMINTERVAL_FSMPS                                                 (0x7FFF0000u)
#define USB_HCFMINTERVAL_FSMPS_SHIFT                                           (16u)
#define USB_HCFMINTERVAL_FIT                                                   (0x80000000u)
#define USB_HCFMINTERVAL_FIT_SHIFT                                             (31u)
#define USB_HCFMREMAINING_FR                                                   (0x00003FFFu)
#define USB_HCFMREMAINING_FR_SHIFT                                             (0u)
#define USB_HCFMREMAINING_FRT                                                  (0x80000000u)
#define USB_HCFMREMAINING_FRT_SHIFT                                            (31u)
#define USB_HCFMNUMBER_FN                                                      (0x0000FFFFu)
#define USB_HCFMNUMBER_FN_SHIFT                                                (0u)
#define USB_HCPERIODICSTART_PS                                                 (0x00003FFFu)
#define USB_HCPERIODICSTART_PS_SHIFT                                           (0u)
#define USB_HCLSTHRESHOLD_LST                                                  (0x00000FFFu)
#define USB_HCLSTHRESHOLD_LST_SHIFT                                            (0u)
#define USB_HCRHDESCRIPTORA_NDP                                                (0x000000FFu)
#define USB_HCRHDESCRIPTORA_NDP_SHIFT                                          (0u)
#define USB_HCRHDESCRIPTORA_PSM                                                (0x00000100u)
#define USB_HCRHDESCRIPTORA_PSM_SHIFT                                          (8u)
#define USB_HCRHDESCRIPTORA_NPS                                                (0x00000200u)
#define USB_HCRHDESCRIPTORA_NPS_SHIFT                                          (9u)
#define USB_HCRHDESCRIPTORA_DT                                                 (0x00000400u)
#define USB_HCRHDESCRIPTORA_DT_SHIFT                                           (10u)
#define USB_HCRHDESCRIPTORA_OCPM                                               (0x00000800u)
#define USB_HCRHDESCRIPTORA_OCPM_SHIFT                                         (11u)
#define USB_HCRHDESCRIPTORA_NOCP                                               (0x00001000u)
#define USB_HCRHDESCRIPTORA_NOCP_SHIFT                                         (12u)
#define USB_HCRHDESCRIPTORA_POTPGT                                             (0xFF000000u)
#define USB_HCRHDESCRIPTORA_POTPGT_SHIFT                                       (24u)
#define USB_HCRHDESCRIPTORB_DR                                                 (0x00000002u)
#define USB_HCRHDESCRIPTORB_DR_SHIFT                                           (1u)
#define USB_HCRHDESCRIPTORB_PPCM                                               (0x00020000u)
#define USB_HCRHDESCRIPTORB_PPCM_SHIFT                                         (17u)
#define USB_HCRHSTATUS_LPS                                                     (0x00000001u)
#define USB_HCRHSTATUS_LPS_SHIFT                                               (0u)
#define USB_HCRHSTATUS_OCI                                                     (0x00000002u)
#define USB_HCRHSTATUS_OCI_SHIFT                                               (1u)
#define USB_HCRHSTATUS_DRWE                                                    (0x00008000u)
#define USB_HCRHSTATUS_DRWE_SHIFT                                              (15u)
#define USB_HCRHSTATUS_LPSC                                                    (0x00010000u)
#define USB_HCRHSTATUS_LPSC_SHIFT                                              (16u)
#define USB_HCRHSTATUS_OCIC                                                    (0x00020000u)
#define USB_HCRHSTATUS_OCIC_SHIFT                                              (17u)
#define USB_HCRHSTATUS_CRWE                                                    (0x80000000u)
#define USB_HCRHSTATUS_CRWE_SHIFT                                              (31u)
#define USB_HCRHPORTSTATUS1_CCS                                                (0x00000001u)
#define USB_HCRHPORTSTATUS1_CCS_SHIFT                                          (0u)
#define USB_HCRHPORTSTATUS1_PES                                                (0x00000002u)
#define USB_HCRHPORTSTATUS1_PES_SHIFT                                          (1u)
#define USB_HCRHPORTSTATUS1_PSS                                                (0x00000004u)
#define USB_HCRHPORTSTATUS1_PSS_SHIFT                                          (2u)
#define USB_HCRHPORTSTATUS1_POCI                                               (0x00000008u)
#define USB_HCRHPORTSTATUS1_POCI_SHIFT                                         (3u)
#define USB_HCRHPORTSTATUS1_PRS                                                (0x00000010u)
#define USB_HCRHPORTSTATUS1_PRS_SHIFT                                          (4u)
#define USB_HCRHPORTSTATUS1_PPS                                                (0x00000100u)
#define USB_HCRHPORTSTATUS1_PPS_SHIFT                                          (8u)
#define USB_HCRHPORTSTATUS1_LSDA                                               (0x00000200u)
#define USB_HCRHPORTSTATUS1_LSDA_SHIFT                                         (9u)
#define USB_HCRHPORTSTATUS1_CSC                                                (0x00010000u)
#define USB_HCRHPORTSTATUS1_CSC_SHIFT                                          (16u)
#define USB_HCRHPORTSTATUS1_PESC                                               (0x00020000u)
#define USB_HCRHPORTSTATUS1_PESC_SHIFT                                         (17u)
#define USB_HCRHPORTSTATUS1_PSSC                                               (0x00040000u)
#define USB_HCRHPORTSTATUS1_PSSC_SHIFT                                         (18u)
#define USB_HCRHPORTSTATUS1_OCIC                                               (0x00080000u)
#define USB_HCRHPORTSTATUS1_OCIC_SHIFT                                         (19u)
#define USB_HCRHPORTSTATUS1_PRSC                                               (0x00100000u)
#define USB_HCRHPORTSTATUS1_PRSC_SHIFT                                         (20u)
#define USB_CAPL_VERSION_CapabilityRegistersLength                             (0x000000FFu)
#define USB_CAPL_VERSION_CapabilityRegistersLength_SHIFT                       (0u)
#define USB_CAPL_VERSION_InterfaceVersionNumber                                (0xFFFF0000u)
#define USB_CAPL_VERSION_InterfaceVersionNumber_SHIFT                          (16u)
#define USB_HCSPARAMS_N_PORTS                                                  (0x0000000Fu)
#define USB_HCSPARAMS_N_PORTS_SHIFT                                            (0u)
#define USB_HCSPARAMS_PPC                                                      (0x00000010u)
#define USB_HCSPARAMS_PPC_SHIFT                                                (4u)
#define USB_HCSPARAMS_PortRoutingRules                                         (0x00000080u)
#define USB_HCSPARAMS_PortRoutingRules_SHIFT                                   (7u)
#define USB_HCSPARAMS_N_PCC                                                    (0x00000F00u)
#define USB_HCSPARAMS_N_PCC_SHIFT                                              (8u)
#define USB_HCSPARAMS_N_CC                                                     (0x0000F000u)
#define USB_HCSPARAMS_N_CC_SHIFT                                               (12u)
#define USB_HCSPARAMS_P_INDICATOR                                              (0x00010000u)
#define USB_HCSPARAMS_P_INDICATOR_SHIFT                                        (16u)
#define USB_HCSPARAMS_DebugPortNumber                                          (0x00F00000u)
#define USB_HCSPARAMS_DebugPortNumber_SHIFT                                    (20u)
#define USB_HCCPARAMS_AddressingCapability                                     (0x00000001u)
#define USB_HCCPARAMS_AddressingCapability_SHIFT                               (0u)
#define USB_HCCPARAMS_ProgramableFrameListFlag                                 (0x00000002u)
#define USB_HCCPARAMS_ProgramableFrameListFlag_SHIFT                           (1u)
#define USB_HCCPARAMS_AsynchronousScheduleParkCapability                       (0x00000004u)
#define USB_HCCPARAMS_AsynchronousScheduleParkCapability_SHIFT                 (2u)
#define USB_HCCPARAMS_IsochronousSchedulingThreshold                           (0x000000F0u)
#define USB_HCCPARAMS_IsochronousSchedulingThreshold_SHIFT                     (4u)
#define USB_HCCPARAMS_EECP                                                     (0x0000FF00u)
#define USB_HCCPARAMS_EECP_SHIFT                                               (8u)
#define USB_HCCPARAMS_HardwarePrefetch                                         (0x00010000u)
#define USB_HCCPARAMS_HardwarePrefetch_SHIFT                                   (16u)
#define USB_HCCPARAMS_LinkPowerManagementCapability                            (0x00020000u)
#define USB_HCCPARAMS_LinkPowerManagementCapability_SHIFT                      (17u)
#define USB_HCCPARAMS_PerPortChangeEventCapability                             (0x00040000u)
#define USB_HCCPARAMS_PerPortChangeEventCapability_SHIFT                       (18u)
#define USB_HCCPARAMS_FramePeriodicListCapability                              (0x00080000u)
#define USB_HCCPARAMS_FramePeriodicListCapability_SHIFT                        (19u)
#define USB_HCSP_PORTROUTE_CompanionPortRoute                                  (0xFFFFFFFFu)
#define USB_HCSP_PORTROUTE_CompanionPortRoute_SHIFT                            (0u)
#define USB_USBCMD_RS                                                          (0x00000001u)
#define USB_USBCMD_RS_SHIFT                                                    (0u)
#define USB_USBCMD_HCRESET                                                     (0x00000002u)
#define USB_USBCMD_HCRESET_SHIFT                                               (1u)
#define USB_USBCMD_FrameListSize                                               (0x0000000Cu)
#define USB_USBCMD_FrameListSize_SHIFT                                         (2u)
#define USB_USBCMD_PeriodicScheduleEnable                                      (0x00000010u)
#define USB_USBCMD_PeriodicScheduleEnable_SHIFT                                (4u)
#define USB_USBCMD_AsynchronousScheduleEnable                                  (0x00000020u)
#define USB_USBCMD_AsynchronousScheduleEnable_SHIFT                            (5u)
#define USB_USBCMD_InterruptonAsyncAdvanceDoorbell                             (0x00000040u)
#define USB_USBCMD_InterruptonAsyncAdvanceDoorbell_SHIFT                       (6u)
#define USB_USBCMD_AsynchronousScheduleParkModeCount                           (0x00000300u)
#define USB_USBCMD_AsynchronousScheduleParkModeCount_SHIFT                     (8u)
#define USB_USBCMD_AsynchronousScheduleParkModeEnable                          (0x00000800u)
#define USB_USBCMD_AsynchronousScheduleParkModeEnable_SHIFT                    (11u)
#define USB_USBCMD_PerPortChangeEventsEnable                                   (0x00008000u)
#define USB_USBCMD_PerPortChangeEventsEnable_SHIFT                             (15u)
#define USB_USBCMD_InterruptThresholdControl                                   (0x00FF0000u)
#define USB_USBCMD_InterruptThresholdControl_SHIFT                             (16u)
#define USB_USBCMD_HostInitiatedResumeDuration                                 (0x0F000000u)
#define USB_USBCMD_HostInitiatedResumeDuration_SHIFT                           (24u)
#define USB_USBSTS_USBINT                                                      (0x00000001u)
#define USB_USBSTS_USBINT_SHIFT                                                (0u)
#define USB_USBSTS_USBERRINT                                                   (0x00000002u)
#define USB_USBSTS_USBERRINT_SHIFT                                             (1u)
#define USB_USBSTS_PortChangeDetect                                            (0x00000004u)
#define USB_USBSTS_PortChangeDetect_SHIFT                                      (2u)
#define USB_USBSTS_FrameListRollover                                           (0x00000008u)
#define USB_USBSTS_FrameListRollover_SHIFT                                     (3u)
#define USB_USBSTS_HostSystemError                                             (0x00000010u)
#define USB_USBSTS_HostSystemError_SHIFT                                       (4u)
#define USB_USBSTS_InterruptonAsyncAdvance                                     (0x00000020u)
#define USB_USBSTS_InterruptonAsyncAdvance_SHIFT                               (5u)
#define USB_USBSTS_HCHalted                                                    (0x00001000u)
#define USB_USBSTS_HCHalted_SHIFT                                              (12u)
#define USB_USBSTS_Reclamation                                                 (0x00002000u)
#define USB_USBSTS_Reclamation_SHIFT                                           (13u)
#define USB_USBSTS_PeriodicScheduleStatus                                      (0x00004000u)
#define USB_USBSTS_PeriodicScheduleStatus_SHIFT                                (14u)
#define USB_USBSTS_AsynchronousScheduleStatus                                  (0x00008000u)
#define USB_USBSTS_AsynchronousScheduleStatus_SHIFT                            (15u)
#define USB_USBSTS_Port1ChangeDetect                                           (0x00010000u)
#define USB_USBSTS_Port1ChangeDetect_SHIFT                                     (16u)
#define USB_USBINTR_USBInterruptEnable                                         (0x00000001u)
#define USB_USBINTR_USBInterruptEnable_SHIFT                                   (0u)
#define USB_USBINTR_USBErrorInterruptEnable                                    (0x00000002u)
#define USB_USBINTR_USBErrorInterruptEnable_SHIFT                              (1u)
#define USB_USBINTR_PortChangeDetectEnable                                     (0x00000004u)
#define USB_USBINTR_PortChangeDetectEnable_SHIFT                               (2u)
#define USB_USBINTR_FrameListRolloverEnable                                    (0x00000008u)
#define USB_USBINTR_FrameListRolloverEnable_SHIFT                              (3u)
#define USB_USBINTR_HostSystemErrorEnable                                      (0x00000010u)
#define USB_USBINTR_HostSystemErrorEnable_SHIFT                                (4u)
#define USB_USBINTR_InterruptonAsyncAdvanceEnable                              (0x00000020u)
#define USB_USBINTR_InterruptonAsyncAdvanceEnable_SHIFT                        (5u)
#define USB_USBINTR_Port1ChangeEventEnable                                     (0x00010000u)
#define USB_USBINTR_Port1ChangeEventEnable_SHIFT                               (16u)
#define USB_FRINDEX_FrameIndex                                                 (0x00003FFFu)
#define USB_FRINDEX_FrameIndex_SHIFT                                           (0u)
#define USB_CTRLDSSEGMENT_CTRLDSSEGMENT                                        (0xFFFFFFFFu)
#define USB_CTRLDSSEGMENT_CTRLDSSEGMENT_SHIFT                                  (0u)
#define USB_PERIODICLISTBASE_BaseAddress                                       (0xFFFFF000u)
#define USB_PERIODICLISTBASE_BaseAddress_SHIFT                                 (12u)
#define USB_ASYNCLISTADDR_LPL                                                  (0xFFFFFFE0u)
#define USB_ASYNCLISTADDR_LPL_SHIFT                                            (5u)
#define USB_CONFIGFLAG_CF                                                      (0x00000001u)
#define USB_CONFIGFLAG_CF_SHIFT                                                (0u)
#define USB_PORTSC1_CurrentConnectStatus                                       (0x00000001u)
#define USB_PORTSC1_CurrentConnectStatus_SHIFT                                 (0u)
#define USB_PORTSC1_ConnectStatusChange                                        (0x00000002u)
#define USB_PORTSC1_ConnectStatusChange_SHIFT                                  (1u)
#define USB_PORTSC1_PortEnabled_Disabled                                       (0x00000004u)
#define USB_PORTSC1_PortEnabled_Disabled_SHIFT                                 (2u)
#define USB_PORTSC1_PortEnable_DisableChange                                   (0x00000008u)
#define USB_PORTSC1_PortEnable_DisableChange_SHIFT                             (3u)
#define USB_PORTSC1_OvercurrentActive                                          (0x00000010u)
#define USB_PORTSC1_OvercurrentActive_SHIFT                                    (4u)
#define USB_PORTSC1_OvercurrentChange                                          (0x00000020u)
#define USB_PORTSC1_OvercurrentChange_SHIFT                                    (5u)
#define USB_PORTSC1_ForcePortResume                                            (0x00000040u)
#define USB_PORTSC1_ForcePortResume_SHIFT                                      (6u)
#define USB_PORTSC1_Suspend                                                    (0x00000080u)
#define USB_PORTSC1_Suspend_SHIFT                                              (7u)
#define USB_PORTSC1_PortReset                                                  (0x00000100u)
#define USB_PORTSC1_PortReset_SHIFT                                            (8u)
#define USB_PORTSC1_SuspendusingL1                                             (0x00000200u)
#define USB_PORTSC1_SuspendusingL1_SHIFT                                       (9u)
#define USB_PORTSC1_LineStatus                                                 (0x00000C00u)
#define USB_PORTSC1_LineStatus_SHIFT                                           (10u)
#define USB_PORTSC1_PP                                                         (0x00001000u)
#define USB_PORTSC1_PP_SHIFT                                                   (12u)
#define USB_PORTSC1_PortOwner                                                  (0x00002000u)
#define USB_PORTSC1_PortOwner_SHIFT                                            (13u)
#define USB_PORTSC1_PortTestControl                                            (0x000F0000u)
#define USB_PORTSC1_PortTestControl_SHIFT                                      (16u)
#define USB_PORTSC1_WKCNNT_E                                                   (0x00100000u)
#define USB_PORTSC1_WKCNNT_E_SHIFT                                             (20u)
#define USB_PORTSC1_WKDSCNNT_E                                                 (0x00200000u)
#define USB_PORTSC1_WKDSCNNT_E_SHIFT                                           (21u)
#define USB_PORTSC1_WKOC_E                                                     (0x00400000u)
#define USB_PORTSC1_WKOC_E_SHIFT                                               (22u)
#define USB_PORTSC1_SuspendStatus                                              (0x01800000u)
#define USB_PORTSC1_SuspendStatus_SHIFT                                        (23u)
#define USB_PORTSC1_DeviceAddress                                              (0xFE000000u)
#define USB_PORTSC1_DeviceAddress_SHIFT                                        (25u)
#define USB_INT_ENABLE_AHB_INTEN                                               (0x00000001u)
#define USB_INT_ENABLE_AHB_INTEN_SHIFT                                         (0u)
#define USB_INT_ENABLE_USBH_INTAEN                                             (0x00000002u)
#define USB_INT_ENABLE_USBH_INTAEN_SHIFT                                       (1u)
#define USB_INT_ENABLE_USBH_INTBEN                                             (0x00000004u)
#define USB_INT_ENABLE_USBH_INTBEN_SHIFT                                       (2u)
#define USB_INT_ENABLE_UCOM_INTEN                                              (0x00000008u)
#define USB_INT_ENABLE_UCOM_INTEN_SHIFT                                        (3u)
#define USB_INT_ENABLE_WAKEON_INTEN                                            (0x00000010u)
#define USB_INT_ENABLE_WAKEON_INTEN_SHIFT                                      (4u)
#define USB_INT_STATUS_AHB_INT                                                 (0x00000001u)
#define USB_INT_STATUS_AHB_INT_SHIFT                                           (0u)
#define USB_INT_STATUS_USBH_INTA                                               (0x00000002u)
#define USB_INT_STATUS_USBH_INTA_SHIFT                                         (1u)
#define USB_INT_STATUS_USBH_INTB                                               (0x00000004u)
#define USB_INT_STATUS_USBH_INTB_SHIFT                                         (2u)
#define USB_INT_STATUS_UCOM_INT                                                (0x00000008u)
#define USB_INT_STATUS_UCOM_INT_SHIFT                                          (3u)
#define USB_INT_STATUS_WAKEON_INT                                              (0x00000010u)
#define USB_INT_STATUS_WAKEON_INT_SHIFT                                        (4u)
#define USB_AHB_BUS_CTR_MAX_BURST_LEN                                          (0x00000003u)
#define USB_AHB_BUS_CTR_MAX_BURST_LEN_SHIFT                                    (0u)
#define USB_AHB_BUS_CTR_ALIGN_ADDRESS                                          (0x00000030u)
#define USB_AHB_BUS_CTR_ALIGN_ADDRESS_SHIFT                                    (4u)
#define USB_AHB_BUS_CTR_PROT_MODE                                              (0x00000100u)
#define USB_AHB_BUS_CTR_PROT_MODE_SHIFT                                        (8u)
#define USB_AHB_BUS_CTR_PROT_TYPE                                              (0x0000F000u)
#define USB_AHB_BUS_CTR_PROT_TYPE_SHIFT                                        (12u)
#define USB_USBCTR_USBH_RST                                                    (0x00000001u)
#define USB_USBCTR_USBH_RST_SHIFT                                              (0u)
#define USB_USBCTR_PLL_RST                                                     (0x00000002u)
#define USB_USBCTR_PLL_RST_SHIFT                                               (1u)
#define USB_USBCTR_DIRPD                                                       (0x00000004u)
#define USB_USBCTR_DIRPD_SHIFT                                                 (2u)
#define USB_REGEN_CG_CTRL_RPB_WEN                                              (0x01000000u)
#define USB_REGEN_CG_CTRL_RPB_WEN_SHIFT                                        (24u)
#define USB_REGEN_CG_CTRL_PERI_CLK_MSK                                         (0x10000000u)
#define USB_REGEN_CG_CTRL_PERI_CLK_MSK_SHIFT                                   (28u)
#define USB_REGEN_CG_CTRL_HOST_CLK_MSK                                         (0x20000000u)
#define USB_REGEN_CG_CTRL_HOST_CLK_MSK_SHIFT                                   (29u)
#define USB_REGEN_CG_CTRL_NONUSE_CLK_MSK                                       (0x80000000u)
#define USB_REGEN_CG_CTRL_NONUSE_CLK_MSK_SHIFT                                 (31u)
#define USB_SPD_CTRL_GLOBAL_SUSPENDM_P1                                        (0x00000001u)
#define USB_SPD_CTRL_GLOBAL_SUSPENDM_P1_SHIFT                                  (0u)
#define USB_SPD_CTRL_WKCNNT_ENABLE                                             (0x00800000u)
#define USB_SPD_CTRL_WKCNNT_ENABLE_SHIFT                                       (23u)
#define USB_SPD_CTRL_SLEEPM_ENABLE                                             (0x40000000u)
#define USB_SPD_CTRL_SLEEPM_ENABLE_SHIFT                                       (30u)
#define USB_SPD_CTRL_SUSPENDM_ENABLE                                           (0x80000000u)
#define USB_SPD_CTRL_SUSPENDM_ENABLE_SHIFT                                     (31u)
#define USB_SPD_RSM_TIMSET_TIMER_RESUME                                        (0x0000FFFFu)
#define USB_SPD_RSM_TIMSET_TIMER_RESUME_SHIFT                                  (0u)
#define USB_SPD_RSM_TIMSET_TIMER_CONNECT                                       (0xFFFF0000u)
#define USB_SPD_RSM_TIMSET_TIMER_CONNECT_SHIFT                                 (16u)
#define USB_OC_SLP_TIMSET_TIMER_OC                                             (0x000FFFFFu)
#define USB_OC_SLP_TIMSET_TIMER_OC_SHIFT                                       (0u)
#define USB_OC_SLP_TIMSET_TIMER_SLEEP                                          (0x1FF00000u)
#define USB_OC_SLP_TIMSET_TIMER_SLEEP_SHIFT                                    (20u)
#define USB_SBRN_FLADJ_PW_SBRN                                                 (0x000000FFu)
#define USB_SBRN_FLADJ_PW_SBRN_SHIFT                                           (0u)
#define USB_SBRN_FLADJ_PW_FLADJ                                                (0x0000FF00u)
#define USB_SBRN_FLADJ_PW_FLADJ_SHIFT                                          (8u)
#define USB_SBRN_FLADJ_PW_PORTWAKECAP                                          (0xFFFF0000u)
#define USB_SBRN_FLADJ_PW_PORTWAKECAP_SHIFT                                    (16u)
#define USB_PORT_LPM_CTRL1_HIRD_SEL_P1                                         (0x00000001u)
#define USB_PORT_LPM_CTRL1_HIRD_SEL_P1_SHIFT                                   (0u)
#define USB_PORT_LPM_CTRL1_RETRY_ENABLE_NYET_P1                                (0x00000002u)
#define USB_PORT_LPM_CTRL1_RETRY_ENABLE_NYET_P1_SHIFT                          (1u)
#define USB_PORT_LPM_CTRL1_SLEEP_INT_EN_P1                                     (0x00000004u)
#define USB_PORT_LPM_CTRL1_SLEEP_INT_EN_P1_SHIFT                               (2u)
#define USB_PORT_LPM_CTRL1_REMOTEWAKE_EN_P1                                    (0x00000008u)
#define USB_PORT_LPM_CTRL1_REMOTEWAKE_EN_P1_SHIFT                              (3u)
#define USB_PORT_LPM_CTRL1_NYET_RETRY_CNT_P1                                   (0x000000F0u)
#define USB_PORT_LPM_CTRL1_NYET_RETRY_CNT_P1_SHIFT                             (4u)
#define USB_U2HC_EXT2_DUR_CTRL                                                 (0x00000200u)
#define USB_U2HC_EXT2_DUR_CTRL_SHIFT                                           (9u)
#define USB_COMMCTRL_OTG_PERI                                                  (0x80000000u)
#define USB_COMMCTRL_OTG_PERI_SHIFT                                            (31u)
#define USB_OBINTSTA_IDCHG_STA                                                 (0x00000001u)
#define USB_OBINTSTA_IDCHG_STA_SHIFT                                           (0u)
#define USB_OBINTSTA_OCINT_STA                                                 (0x00000002u)
#define USB_OBINTSTA_OCINT_STA_SHIFT                                           (1u)
#define USB_OBINTSTA_VBSTACHG_STA                                              (0x00000004u)
#define USB_OBINTSTA_VBSTACHG_STA_SHIFT                                        (2u)
#define USB_OBINTSTA_VBSTAINT_STA                                              (0x00000008u)
#define USB_OBINTSTA_VBSTAINT_STA_SHIFT                                        (3u)
#define USB_OBINTSTA_PDDETCHG1_STA                                             (0x00000010u)
#define USB_OBINTSTA_PDDETCHG1_STA_SHIFT                                       (4u)
#define USB_OBINTSTA_CHGDETCHG1_STA                                            (0x00000040u)
#define USB_OBINTSTA_CHGDETCHG1_STA_SHIFT                                      (6u)
#define USB_OBINTSTA_DMMONCHG_STA                                              (0x00010000u)
#define USB_OBINTSTA_DMMONCHG_STA_SHIFT                                        (16u)
#define USB_OBINTSTA_DPMONCHG_STA                                              (0x00020000u)
#define USB_OBINTSTA_DPMONCHG_STA_SHIFT                                        (17u)
#define USB_OBINTEN_IDCHG_EN                                                   (0x00000001u)
#define USB_OBINTEN_IDCHG_EN_SHIFT                                             (0u)
#define USB_OBINTEN_OCINT_EN                                                   (0x00000002u)
#define USB_OBINTEN_OCINT_EN_SHIFT                                             (1u)
#define USB_OBINTEN_VBSTACHG_EN                                                (0x00000004u)
#define USB_OBINTEN_VBSTACHG_EN_SHIFT                                          (2u)
#define USB_OBINTEN_VBSTAINT_EN                                                (0x00000008u)
#define USB_OBINTEN_VBSTAINT_EN_SHIFT                                          (3u)
#define USB_OBINTEN_PDDETCHG1_EN                                               (0x00000010u)
#define USB_OBINTEN_PDDETCHG1_EN_SHIFT                                         (4u)
#define USB_OBINTEN_CHGDETCHG1_EN                                              (0x00000040u)
#define USB_OBINTEN_CHGDETCHG1_EN_SHIFT                                        (6u)
#define USB_OBINTEN_DMMONCHG_EN                                                (0x00010000u)
#define USB_OBINTEN_DMMONCHG_EN_SHIFT                                          (16u)
#define USB_OBINTEN_DPMONCHG_EN                                                (0x00020000u)
#define USB_OBINTEN_DPMONCHG_EN_SHIFT                                          (17u)
#define USB_VBCTRL_VBOUT                                                       (0x00000001u)
#define USB_VBCTRL_VBOUT_SHIFT                                                 (0u)
#define USB_VBCTRL_VGPUO                                                       (0x00000010u)
#define USB_VBCTRL_VGPUO_SHIFT                                                 (4u)
#define USB_VBCTRL_VBLVL                                                       (0x00200000u)
#define USB_VBCTRL_VBLVL_SHIFT                                                 (21u)
#define USB_VBCTRL_VBSTA                                                       (0x20000000u)
#define USB_VBCTRL_VBSTA_SHIFT                                                 (29u)
#define USB_LINECTRL1_IDMON                                                    (0x00000001u)
#define USB_LINECTRL1_IDMON_SHIFT                                              (0u)
#define USB_LINECTRL1_DMMON                                                    (0x00000004u)
#define USB_LINECTRL1_DMMON_SHIFT                                              (2u)
#define USB_LINECTRL1_DPMON                                                    (0x00000008u)
#define USB_LINECTRL1_DPMON_SHIFT                                              (3u)
#define USB_LINECTRL1_DM_RPD                                                   (0x00010000u)
#define USB_LINECTRL1_DM_RPD_SHIFT                                             (16u)
#define USB_LINECTRL1_DMRPD_EN                                                 (0x00020000u)
#define USB_LINECTRL1_DMRPD_EN_SHIFT                                           (17u)
#define USB_LINECTRL1_DP_RPD                                                   (0x00040000u)
#define USB_LINECTRL1_DP_RPD_SHIFT                                             (18u)
#define USB_LINECTRL1_DPRPD_EN                                                 (0x00080000u)
#define USB_LINECTRL1_DPRPD_EN_SHIFT                                           (19u)
#define USB_LINECTRL1_DSDP                                                     (0x00300000u)
#define USB_LINECTRL1_DSDP_SHIFT                                               (20u)
#define USB_BCCTRL1_IDPSRCE                                                    (0x00000001u)
#define USB_BCCTRL1_IDPSRCE_SHIFT                                              (0u)
#define USB_BCCTRL1_IDMSINKE                                                   (0x00000002u)
#define USB_BCCTRL1_IDMSINKE_SHIFT                                             (1u)
#define USB_BCCTRL1_VDPSRCE                                                    (0x00000004u)
#define USB_BCCTRL1_VDPSRCE_SHIFT                                              (2u)
#define USB_BCCTRL1_IDPSINKE                                                   (0x00000008u)
#define USB_BCCTRL1_IDPSINKE_SHIFT                                             (3u)
#define USB_BCCTRL1_VDMSRCE                                                    (0x00000010u)
#define USB_BCCTRL1_VDMSRCE_SHIFT                                              (4u)
#define USB_BCCTRL1_DCPMODE                                                    (0x00000020u)
#define USB_BCCTRL1_DCPMODE_SHIFT                                              (5u)
#define USB_BCCTRL1_CHGDETSTS                                                  (0x00000100u)
#define USB_BCCTRL1_CHGDETSTS_SHIFT                                            (8u)
#define USB_BCCTRL1_PDDETSTS                                                   (0x00000200u)
#define USB_BCCTRL1_PDDETSTS_SHIFT                                             (9u)
#define USB_CC_STATUS_CC2_RA                                                   (0x00000001u)
#define USB_CC_STATUS_CC2_RA_SHIFT                                             (0u)
#define USB_CC_STATUS_CC2_RD                                                   (0x00000002u)
#define USB_CC_STATUS_CC2_RD_SHIFT                                             (1u)
#define USB_CC_STATUS_CC1_RA                                                   (0x00000004u)
#define USB_CC_STATUS_CC1_RA_SHIFT                                             (2u)
#define USB_CC_STATUS_CC1_RD                                                   (0x00000008u)
#define USB_CC_STATUS_CC1_RD_SHIFT                                             (3u)
#define USB_CC_STATUS_CC_LVL_STA                                               (0x00000010u)
#define USB_CC_STATUS_CC_LVL_STA_SHIFT                                         (4u)
#define USB_CC_STATUS_CC_PERI_STA                                              (0x00000020u)
#define USB_CC_STATUS_CC_PERI_STA_SHIFT                                        (5u)
#define USB_CC_STATUS_CC_LVL_EN                                                (0x01000000u)
#define USB_CC_STATUS_CC_LVL_EN_SHIFT                                          (24u)
#define USB_CC_STATUS_CC_LVL                                                   (0x1E000000u)
#define USB_CC_STATUS_CC_LVL_SHIFT                                             (25u)
#define USB_CC_STATUS_CC_LVL_CLR                                               (0x20000000u)
#define USB_CC_STATUS_CC_LVL_CLR_SHIFT                                         (29u)
#define USB_CC_STATUS_CC_INT_SEL                                               (0x80000000u)
#define USB_CC_STATUS_CC_INT_SEL_SHIFT                                         (31u)
#define USB_PHYCLK_CTRL_UCLKSEL                                                (0x00000001u)
#define USB_PHYCLK_CTRL_UCLKSEL_SHIFT                                          (0u)
#define USB_PHYIF_CTRL_FIXPHY                                                  (0x00000001u)
#define USB_PHYIF_CTRL_FIXPHY_SHIFT                                            (0u)
#define USB_SYSCFG0_USBE                                                       (0x0001u)
#define USB_SYSCFG0_USBE_SHIFT                                                 (0u)
#define USB_SYSCFG0_DPRPU                                                      (0x0010u)
#define USB_SYSCFG0_DPRPU_SHIFT                                                (4u)
#define USB_SYSCFG0_DRPD                                                       (0x0020u)
#define USB_SYSCFG0_DRPD_SHIFT                                                 (5u)
#define USB_SYSCFG0_HSE                                                        (0x0080u)
#define USB_SYSCFG0_HSE_SHIFT                                                  (7u)
#define USB_SYSCFG0_CNEN                                                       (0x0100u)
#define USB_SYSCFG0_CNEN_SHIFT                                                 (8u)
#define USB_SYSCFG1_BWAIT                                                      (0x003Fu)
#define USB_SYSCFG1_BWAIT_SHIFT                                                (0u)
#define USB_SYSSTS0_LNST                                                       (0x0003u)
#define USB_SYSSTS0_LNST_SHIFT                                                 (0u)
#define USB_DVSTCTR0_RHST                                                      (0x0007u)
#define USB_DVSTCTR0_RHST_SHIFT                                                (0u)
#define USB_DVSTCTR0_WKUP                                                      (0x0100u)
#define USB_DVSTCTR0_WKUP_SHIFT                                                (8u)
#define USB_DVSTCTR0_BRST1                                                     (0x8000u)
#define USB_DVSTCTR0_BRST1_SHIFT                                               (15u)
#define USB_TESTMODE_UTST                                                      (0x000Fu)
#define USB_TESTMODE_UTST_SHIFT                                                (0u)
#define USB_TESTMODE_BRST3                                                     (0x0800u)
#define USB_TESTMODE_BRST3_SHIFT                                               (11u)
#define USB_TESTMODE_BRST2                                                     (0x4000u)
#define USB_TESTMODE_BRST2_SHIFT                                               (14u)
#define USB_CFIFO_FIFOPORT                                                     (0xFFFFFFFFu)
#define USB_CFIFO_FIFOPORT_SHIFT                                               (0u)
#define USB_CFIFOSEL_CURPIPE                                                   (0x000Fu)
#define USB_CFIFOSEL_CURPIPE_SHIFT                                             (0u)
#define USB_CFIFOSEL_ISEL                                                      (0x0020u)
#define USB_CFIFOSEL_ISEL_SHIFT                                                (5u)
#define USB_CFIFOSEL_BIGEND                                                    (0x0100u)
#define USB_CFIFOSEL_BIGEND_SHIFT                                              (8u)
#define USB_CFIFOSEL_MBW                                                       (0x0C00u)
#define USB_CFIFOSEL_MBW_SHIFT                                                 (10u)
#define USB_CFIFOSEL_REW                                                       (0x4000u)
#define USB_CFIFOSEL_REW_SHIFT                                                 (14u)
#define USB_CFIFOSEL_RCNT                                                      (0x8000u)
#define USB_CFIFOSEL_RCNT_SHIFT                                                (15u)
#define USB_CFIFOCTR_DTLN                                                      (0x0FFFu)
#define USB_CFIFOCTR_DTLN_SHIFT                                                (0u)
#define USB_CFIFOCTR_FRDY                                                      (0x2000u)
#define USB_CFIFOCTR_FRDY_SHIFT                                                (13u)
#define USB_CFIFOCTR_BCLR                                                      (0x4000u)
#define USB_CFIFOCTR_BCLR_SHIFT                                                (14u)
#define USB_CFIFOCTR_BVAL                                                      (0x8000u)
#define USB_CFIFOCTR_BVAL_SHIFT                                                (15u)
#define USB_D0FIFOSEL_CURPIPE                                                  (0x000Fu)
#define USB_D0FIFOSEL_CURPIPE_SHIFT                                            (0u)
#define USB_D0FIFOSEL_MBW                                                      (0x0C00u)
#define USB_D0FIFOSEL_MBW_SHIFT                                                (10u)
#define USB_D0FIFOSEL_DREQE                                                    (0x1000u)
#define USB_D0FIFOSEL_DREQE_SHIFT                                              (12u)
#define USB_D0FIFOSEL_DCLRM                                                    (0x2000u)
#define USB_D0FIFOSEL_DCLRM_SHIFT                                              (13u)
#define USB_D0FIFOSEL_REW                                                      (0x4000u)
#define USB_D0FIFOSEL_REW_SHIFT                                                (14u)
#define USB_D0FIFOSEL_RCNT                                                     (0x8000u)
#define USB_D0FIFOSEL_RCNT_SHIFT                                               (15u)
#define USB_D0FIFOCTR_DTLN                                                     (0x0FFFu)
#define USB_D0FIFOCTR_DTLN_SHIFT                                               (0u)
#define USB_D0FIFOCTR_FRDY                                                     (0x2000u)
#define USB_D0FIFOCTR_FRDY_SHIFT                                               (13u)
#define USB_D0FIFOCTR_BCLR                                                     (0x4000u)
#define USB_D0FIFOCTR_BCLR_SHIFT                                               (14u)
#define USB_D0FIFOCTR_BVAL                                                     (0x8000u)
#define USB_D0FIFOCTR_BVAL_SHIFT                                               (15u)
#define USB_D1FIFOSEL_CURPIPE                                                  (0x000Fu)
#define USB_D1FIFOSEL_CURPIPE_SHIFT                                            (0u)
#define USB_D1FIFOSEL_MBW                                                      (0x0C00u)
#define USB_D1FIFOSEL_MBW_SHIFT                                                (10u)
#define USB_D1FIFOSEL_DREQE                                                    (0x1000u)
#define USB_D1FIFOSEL_DREQE_SHIFT                                              (12u)
#define USB_D1FIFOSEL_DCLRM                                                    (0x2000u)
#define USB_D1FIFOSEL_DCLRM_SHIFT                                              (13u)
#define USB_D1FIFOSEL_REW                                                      (0x4000u)
#define USB_D1FIFOSEL_REW_SHIFT                                                (14u)
#define USB_D1FIFOSEL_RCNT                                                     (0x8000u)
#define USB_D1FIFOSEL_RCNT_SHIFT                                               (15u)
#define USB_D1FIFOCTR_DTLN                                                     (0x0FFFu)
#define USB_D1FIFOCTR_DTLN_SHIFT                                               (0u)
#define USB_D1FIFOCTR_FRDY                                                     (0x2000u)
#define USB_D1FIFOCTR_FRDY_SHIFT                                               (13u)
#define USB_D1FIFOCTR_BCLR                                                     (0x4000u)
#define USB_D1FIFOCTR_BCLR_SHIFT                                               (14u)
#define USB_D1FIFOCTR_BVAL                                                     (0x8000u)
#define USB_D1FIFOCTR_BVAL_SHIFT                                               (15u)
#define USB_INTENB0_BRDYE                                                      (0x0100u)
#define USB_INTENB0_BRDYE_SHIFT                                                (8u)
#define USB_INTENB0_NRDYE                                                      (0x0200u)
#define USB_INTENB0_NRDYE_SHIFT                                                (9u)
#define USB_INTENB0_BEMPE                                                      (0x0400u)
#define USB_INTENB0_BEMPE_SHIFT                                                (10u)
#define USB_INTENB0_CTRE                                                       (0x0800u)
#define USB_INTENB0_CTRE_SHIFT                                                 (11u)
#define USB_INTENB0_DVSE                                                       (0x1000u)
#define USB_INTENB0_DVSE_SHIFT                                                 (12u)
#define USB_INTENB0_SOFE                                                       (0x2000u)
#define USB_INTENB0_SOFE_SHIFT                                                 (13u)
#define USB_INTENB0_RSME                                                       (0x4000u)
#define USB_INTENB0_RSME_SHIFT                                                 (14u)
#define USB_INTENB0_VBSE                                                       (0x8000u)
#define USB_INTENB0_VBSE_SHIFT                                                 (15u)
#define USB_BRDYENB_PIPEBRDYE                                                  (0xFFFFu)
#define USB_BRDYENB_PIPEBRDYE_SHIFT                                            (0u)
#define USB_NRDYENB_PIPENRDYE                                                  (0xFFFFu)
#define USB_NRDYENB_PIPENRDYE_SHIFT                                            (0u)
#define USB_BEMPENB_PIPEBEMPE                                                  (0xFFFFu)
#define USB_BEMPENB_PIPEBEMPE_SHIFT                                            (0u)
#define USB_SOFCFG_SOFM                                                        (0x000Cu)
#define USB_SOFCFG_SOFM_SHIFT                                                  (2u)
#define USB_SOFCFG_BRDYM                                                       (0x0040u)
#define USB_SOFCFG_BRDYM_SHIFT                                                 (6u)
#define USB_INTSTS0_CTSQ                                                       (0x0007u)
#define USB_INTSTS0_CTSQ_SHIFT                                                 (0u)
#define USB_INTSTS0_VALID                                                      (0x0008u)
#define USB_INTSTS0_VALID_SHIFT                                                (3u)
#define USB_INTSTS0_DVSQ                                                       (0x0070u)
#define USB_INTSTS0_DVSQ_SHIFT                                                 (4u)
#define USB_INTSTS0_VBSTS                                                      (0x0080u)
#define USB_INTSTS0_VBSTS_SHIFT                                                (7u)
#define USB_INTSTS0_BRDY                                                       (0x0100u)
#define USB_INTSTS0_BRDY_SHIFT                                                 (8u)
#define USB_INTSTS0_NRDY                                                       (0x0200u)
#define USB_INTSTS0_NRDY_SHIFT                                                 (9u)
#define USB_INTSTS0_BEMP                                                       (0x0400u)
#define USB_INTSTS0_BEMP_SHIFT                                                 (10u)
#define USB_INTSTS0_CTRT                                                       (0x0800u)
#define USB_INTSTS0_CTRT_SHIFT                                                 (11u)
#define USB_INTSTS0_DVST                                                       (0x1000u)
#define USB_INTSTS0_DVST_SHIFT                                                 (12u)
#define USB_INTSTS0_SOFR                                                       (0x2000u)
#define USB_INTSTS0_SOFR_SHIFT                                                 (13u)
#define USB_INTSTS0_RESM                                                       (0x4000u)
#define USB_INTSTS0_RESM_SHIFT                                                 (14u)
#define USB_INTSTS0_VBINT                                                      (0x8000u)
#define USB_INTSTS0_VBINT_SHIFT                                                (15u)
#define USB_BRDYSTS_PIPEBRDY                                                   (0xFFFFu)
#define USB_BRDYSTS_PIPEBRDY_SHIFT                                             (0u)
#define USB_NRDYSTS_PIPENRDY                                                   (0xFFFFu)
#define USB_NRDYSTS_PIPENRDY_SHIFT                                             (0u)
#define USB_BEMPSTS_PIPEBEMP                                                   (0xFFFFu)
#define USB_BEMPSTS_PIPEBEMP_SHIFT                                             (0u)
#define USB_FRMNUM_FRNM                                                        (0x07FFu)
#define USB_FRMNUM_FRNM_SHIFT                                                  (0u)
#define USB_FRMNUM_CRCE                                                        (0x4000u)
#define USB_FRMNUM_CRCE_SHIFT                                                  (14u)
#define USB_FRMNUM_OVRN                                                        (0x8000u)
#define USB_FRMNUM_OVRN_SHIFT                                                  (15u)
#define USB_UFRMNUM_UFRNM                                                      (0x0007u)
#define USB_UFRMNUM_UFRNM_SHIFT                                                (0u)
#define USB_UFRMNUM_DVCHG                                                      (0x8000u)
#define USB_UFRMNUM_DVCHG_SHIFT                                                (15u)
#define USB_USBADDR_USBADDR                                                    (0x007Fu)
#define USB_USBADDR_USBADDR_SHIFT                                              (0u)
#define USB_USBADDR_STSRECOV0                                                  (0x0700u)
#define USB_USBADDR_STSRECOV0_SHIFT                                            (8u)
#define USB_USBREQ_bmRequestType                                               (0x00FFu)
#define USB_USBREQ_bmRequestType_SHIFT                                         (0u)
#define USB_USBREQ_bRequest                                                    (0xFF00u)
#define USB_USBREQ_bRequest_SHIFT                                              (8u)
#define USB_USBVAL_wValue                                                      (0xFFFFu)
#define USB_USBVAL_wValue_SHIFT                                                (0u)
#define USB_USBINDX_wIndex                                                     (0xFFFFu)
#define USB_USBINDX_wIndex_SHIFT                                               (0u)
#define USB_USBLENG_wLength                                                    (0xFFFFu)
#define USB_USBLENG_wLength_SHIFT                                              (0u)
#define USB_DCPCFG_SHTNAK                                                      (0x0080u)
#define USB_DCPCFG_SHTNAK_SHIFT                                                (7u)
#define USB_DCPCFG_CNTMD                                                       (0x0100u)
#define USB_DCPCFG_CNTMD_SHIFT                                                 (8u)
#define USB_DCPMAXP_MXPS                                                       (0x007Fu)
#define USB_DCPMAXP_MXPS_SHIFT                                                 (0u)
#define USB_DCPCTR_PID                                                         (0x0003u)
#define USB_DCPCTR_PID_SHIFT                                                   (0u)
#define USB_DCPCTR_CCPL                                                        (0x0004u)
#define USB_DCPCTR_CCPL_SHIFT                                                  (2u)
#define USB_DCPCTR_PBUSY                                                       (0x0020u)
#define USB_DCPCTR_PBUSY_SHIFT                                                 (5u)
#define USB_DCPCTR_SQMON                                                       (0x0040u)
#define USB_DCPCTR_SQMON_SHIFT                                                 (6u)
#define USB_DCPCTR_SQSET                                                       (0x0080u)
#define USB_DCPCTR_SQSET_SHIFT                                                 (7u)
#define USB_DCPCTR_SQCLR                                                       (0x0100u)
#define USB_DCPCTR_SQCLR_SHIFT                                                 (8u)
#define USB_DCPCTR_BSTS                                                        (0x8000u)
#define USB_DCPCTR_BSTS_SHIFT                                                  (15u)
#define USB_PIPESEL_PIPESEL                                                    (0x000Fu)
#define USB_PIPESEL_PIPESEL_SHIFT                                              (0u)
#define USB_PIPECFG_EPNUM                                                      (0x000Fu)
#define USB_PIPECFG_EPNUM_SHIFT                                                (0u)
#define USB_PIPECFG_DIR                                                        (0x0010u)
#define USB_PIPECFG_DIR_SHIFT                                                  (4u)
#define USB_PIPECFG_SHTNAK                                                     (0x0080u)
#define USB_PIPECFG_SHTNAK_SHIFT                                               (7u)
#define USB_PIPECFG_CNTMD                                                      (0x0100u)
#define USB_PIPECFG_CNTMD_SHIFT                                                (8u)
#define USB_PIPECFG_DBLB                                                       (0x0200u)
#define USB_PIPECFG_DBLB_SHIFT                                                 (9u)
#define USB_PIPECFG_BFRE                                                       (0x0400u)
#define USB_PIPECFG_BFRE_SHIFT                                                 (10u)
#define USB_PIPECFG_TYPE                                                       (0xC000u)
#define USB_PIPECFG_TYPE_SHIFT                                                 (14u)
#define USB_PIPEBUF_BUFNMB                                                     (0x00FFu)
#define USB_PIPEBUF_BUFNMB_SHIFT                                               (0u)
#define USB_PIPEBUF_BUFSIZE                                                    (0x7C00u)
#define USB_PIPEBUF_BUFSIZE_SHIFT                                              (10u)
#define USB_PIPEMAXP_MXPS                                                      (0x07FFu)
#define USB_PIPEMAXP_MXPS_SHIFT                                                (0u)
#define USB_PIPEPERI_IITV                                                      (0x0007u)
#define USB_PIPEPERI_IITV_SHIFT                                                (0u)
#define USB_PIPEPERI_IFIS                                                      (0x1000u)
#define USB_PIPEPERI_IFIS_SHIFT                                                (12u)
#define USB_PIPE1CTR_PID                                                       (0x0003u)
#define USB_PIPE1CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE1CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE1CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE1CTR_SQMON                                                     (0x0040u)
#define USB_PIPE1CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE1CTR_SQSET                                                     (0x0080u)
#define USB_PIPE1CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE1CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE1CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE1CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE1CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE1CTR_ATREPM                                                    (0x0400u)
#define USB_PIPE1CTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPE1CTR_INBUFM                                                    (0x4000u)
#define USB_PIPE1CTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPE1CTR_BSTS                                                      (0x8000u)
#define USB_PIPE1CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE2CTR_PID                                                       (0x0003u)
#define USB_PIPE2CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE2CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE2CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE2CTR_SQMON                                                     (0x0040u)
#define USB_PIPE2CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE2CTR_SQSET                                                     (0x0080u)
#define USB_PIPE2CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE2CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE2CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE2CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE2CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE2CTR_ATREPM                                                    (0x0400u)
#define USB_PIPE2CTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPE2CTR_INBUFM                                                    (0x4000u)
#define USB_PIPE2CTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPE2CTR_BSTS                                                      (0x8000u)
#define USB_PIPE2CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE3CTR_PID                                                       (0x0003u)
#define USB_PIPE3CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE3CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE3CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE3CTR_SQMON                                                     (0x0040u)
#define USB_PIPE3CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE3CTR_SQSET                                                     (0x0080u)
#define USB_PIPE3CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE3CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE3CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE3CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE3CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE3CTR_ATREPM                                                    (0x0400u)
#define USB_PIPE3CTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPE3CTR_INBUFM                                                    (0x4000u)
#define USB_PIPE3CTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPE3CTR_BSTS                                                      (0x8000u)
#define USB_PIPE3CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE4CTR_PID                                                       (0x0003u)
#define USB_PIPE4CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE4CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE4CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE4CTR_SQMON                                                     (0x0040u)
#define USB_PIPE4CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE4CTR_SQSET                                                     (0x0080u)
#define USB_PIPE4CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE4CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE4CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE4CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE4CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE4CTR_ATREPM                                                    (0x0400u)
#define USB_PIPE4CTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPE4CTR_INBUFM                                                    (0x4000u)
#define USB_PIPE4CTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPE4CTR_BSTS                                                      (0x8000u)
#define USB_PIPE4CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE5CTR_PID                                                       (0x0003u)
#define USB_PIPE5CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE5CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE5CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE5CTR_SQMON                                                     (0x0040u)
#define USB_PIPE5CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE5CTR_SQSET                                                     (0x0080u)
#define USB_PIPE5CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE5CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE5CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE5CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE5CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE5CTR_ATREPM                                                    (0x0400u)
#define USB_PIPE5CTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPE5CTR_INBUFM                                                    (0x4000u)
#define USB_PIPE5CTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPE5CTR_BSTS                                                      (0x8000u)
#define USB_PIPE5CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE6CTR_PID                                                       (0x0003u)
#define USB_PIPE6CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE6CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE6CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE6CTR_SQMON                                                     (0x0040u)
#define USB_PIPE6CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE6CTR_SQSET                                                     (0x0080u)
#define USB_PIPE6CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE6CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE6CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE6CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE6CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE6CTR_BSTS                                                      (0x8000u)
#define USB_PIPE6CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE7CTR_PID                                                       (0x0003u)
#define USB_PIPE7CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE7CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE7CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE7CTR_SQMON                                                     (0x0040u)
#define USB_PIPE7CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE7CTR_SQSET                                                     (0x0080u)
#define USB_PIPE7CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE7CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE7CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE7CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE7CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE7CTR_BSTS                                                      (0x8000u)
#define USB_PIPE7CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE8CTR_PID                                                       (0x0003u)
#define USB_PIPE8CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE8CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE8CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE8CTR_SQMON                                                     (0x0040u)
#define USB_PIPE8CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE8CTR_SQSET                                                     (0x0080u)
#define USB_PIPE8CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE8CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE8CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE8CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE8CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE8CTR_BSTS                                                      (0x8000u)
#define USB_PIPE8CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE9CTR_PID                                                       (0x0003u)
#define USB_PIPE9CTR_PID_SHIFT                                                 (0u)
#define USB_PIPE9CTR_PBUSY                                                     (0x0020u)
#define USB_PIPE9CTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPE9CTR_SQMON                                                     (0x0040u)
#define USB_PIPE9CTR_SQMON_SHIFT                                               (6u)
#define USB_PIPE9CTR_SQSET                                                     (0x0080u)
#define USB_PIPE9CTR_SQSET_SHIFT                                               (7u)
#define USB_PIPE9CTR_SQCLR                                                     (0x0100u)
#define USB_PIPE9CTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPE9CTR_ACLRM                                                     (0x0200u)
#define USB_PIPE9CTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPE9CTR_ATREPM                                                    (0x0400u)
#define USB_PIPE9CTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPE9CTR_INBUFM                                                    (0x4000u)
#define USB_PIPE9CTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPE9CTR_BSTS                                                      (0x8000u)
#define USB_PIPE9CTR_BSTS_SHIFT                                                (15u)
#define USB_PIPEACTR_PID                                                       (0x0003u)
#define USB_PIPEACTR_PID_SHIFT                                                 (0u)
#define USB_PIPEACTR_PBUSY                                                     (0x0020u)
#define USB_PIPEACTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPEACTR_SQMON                                                     (0x0040u)
#define USB_PIPEACTR_SQMON_SHIFT                                               (6u)
#define USB_PIPEACTR_SQSET                                                     (0x0080u)
#define USB_PIPEACTR_SQSET_SHIFT                                               (7u)
#define USB_PIPEACTR_SQCLR                                                     (0x0100u)
#define USB_PIPEACTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPEACTR_ACLRM                                                     (0x0200u)
#define USB_PIPEACTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPEACTR_ATREPM                                                    (0x0400u)
#define USB_PIPEACTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPEACTR_INBUFM                                                    (0x4000u)
#define USB_PIPEACTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPEACTR_BSTS                                                      (0x8000u)
#define USB_PIPEACTR_BSTS_SHIFT                                                (15u)
#define USB_PIPEBCTR_PID                                                       (0x0003u)
#define USB_PIPEBCTR_PID_SHIFT                                                 (0u)
#define USB_PIPEBCTR_PBUSY                                                     (0x0020u)
#define USB_PIPEBCTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPEBCTR_SQMON                                                     (0x0040u)
#define USB_PIPEBCTR_SQMON_SHIFT                                               (6u)
#define USB_PIPEBCTR_SQSET                                                     (0x0080u)
#define USB_PIPEBCTR_SQSET_SHIFT                                               (7u)
#define USB_PIPEBCTR_SQCLR                                                     (0x0100u)
#define USB_PIPEBCTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPEBCTR_ACLRM                                                     (0x0200u)
#define USB_PIPEBCTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPEBCTR_ATREPM                                                    (0x0400u)
#define USB_PIPEBCTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPEBCTR_INBUFM                                                    (0x4000u)
#define USB_PIPEBCTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPEBCTR_BSTS                                                      (0x8000u)
#define USB_PIPEBCTR_BSTS_SHIFT                                                (15u)
#define USB_PIPECCTR_PID                                                       (0x0003u)
#define USB_PIPECCTR_PID_SHIFT                                                 (0u)
#define USB_PIPECCTR_PBUSY                                                     (0x0020u)
#define USB_PIPECCTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPECCTR_SQMON                                                     (0x0040u)
#define USB_PIPECCTR_SQMON_SHIFT                                               (6u)
#define USB_PIPECCTR_SQSET                                                     (0x0080u)
#define USB_PIPECCTR_SQSET_SHIFT                                               (7u)
#define USB_PIPECCTR_SQCLR                                                     (0x0100u)
#define USB_PIPECCTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPECCTR_ACLRM                                                     (0x0200u)
#define USB_PIPECCTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPECCTR_ATREPM                                                    (0x0400u)
#define USB_PIPECCTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPECCTR_INBUFM                                                    (0x4000u)
#define USB_PIPECCTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPECCTR_BSTS                                                      (0x8000u)
#define USB_PIPECCTR_BSTS_SHIFT                                                (15u)
#define USB_PIPEDCTR_PID                                                       (0x0003u)
#define USB_PIPEDCTR_PID_SHIFT                                                 (0u)
#define USB_PIPEDCTR_PBUSY                                                     (0x0020u)
#define USB_PIPEDCTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPEDCTR_SQMON                                                     (0x0040u)
#define USB_PIPEDCTR_SQMON_SHIFT                                               (6u)
#define USB_PIPEDCTR_SQSET                                                     (0x0080u)
#define USB_PIPEDCTR_SQSET_SHIFT                                               (7u)
#define USB_PIPEDCTR_SQCLR                                                     (0x0100u)
#define USB_PIPEDCTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPEDCTR_ACLRM                                                     (0x0200u)
#define USB_PIPEDCTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPEDCTR_ATREPM                                                    (0x0400u)
#define USB_PIPEDCTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPEDCTR_INBUFM                                                    (0x4000u)
#define USB_PIPEDCTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPEDCTR_BSTS                                                      (0x8000u)
#define USB_PIPEDCTR_BSTS_SHIFT                                                (15u)
#define USB_PIPEECTR_PID                                                       (0x0003u)
#define USB_PIPEECTR_PID_SHIFT                                                 (0u)
#define USB_PIPEECTR_PBUSY                                                     (0x0020u)
#define USB_PIPEECTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPEECTR_SQMON                                                     (0x0040u)
#define USB_PIPEECTR_SQMON_SHIFT                                               (6u)
#define USB_PIPEECTR_SQSET                                                     (0x0080u)
#define USB_PIPEECTR_SQSET_SHIFT                                               (7u)
#define USB_PIPEECTR_SQCLR                                                     (0x0100u)
#define USB_PIPEECTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPEECTR_ACLRM                                                     (0x0200u)
#define USB_PIPEECTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPEECTR_ATREPM                                                    (0x0400u)
#define USB_PIPEECTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPEECTR_INBUFM                                                    (0x4000u)
#define USB_PIPEECTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPEECTR_BSTS                                                      (0x8000u)
#define USB_PIPEECTR_BSTS_SHIFT                                                (15u)
#define USB_PIPEFCTR_PID                                                       (0x0003u)
#define USB_PIPEFCTR_PID_SHIFT                                                 (0u)
#define USB_PIPEFCTR_PBUSY                                                     (0x0020u)
#define USB_PIPEFCTR_PBUSY_SHIFT                                               (5u)
#define USB_PIPEFCTR_SQMON                                                     (0x0040u)
#define USB_PIPEFCTR_SQMON_SHIFT                                               (6u)
#define USB_PIPEFCTR_SQSET                                                     (0x0080u)
#define USB_PIPEFCTR_SQSET_SHIFT                                               (7u)
#define USB_PIPEFCTR_SQCLR                                                     (0x0100u)
#define USB_PIPEFCTR_SQCLR_SHIFT                                               (8u)
#define USB_PIPEFCTR_ACLRM                                                     (0x0200u)
#define USB_PIPEFCTR_ACLRM_SHIFT                                               (9u)
#define USB_PIPEFCTR_ATREPM                                                    (0x0400u)
#define USB_PIPEFCTR_ATREPM_SHIFT                                              (10u)
#define USB_PIPEFCTR_INBUFM                                                    (0x4000u)
#define USB_PIPEFCTR_INBUFM_SHIFT                                              (14u)
#define USB_PIPEFCTR_BSTS                                                      (0x8000u)
#define USB_PIPEFCTR_BSTS_SHIFT                                                (15u)
#define USB_PIPE1TRE_TRCLR                                                     (0x0100u)
#define USB_PIPE1TRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPE1TRE_TRENB                                                     (0x0200u)
#define USB_PIPE1TRE_TRENB_SHIFT                                               (9u)
#define USB_PIPE1TRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPE1TRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPE2TRE_TRCLR                                                     (0x0100u)
#define USB_PIPE2TRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPE2TRE_TRENB                                                     (0x0200u)
#define USB_PIPE2TRE_TRENB_SHIFT                                               (9u)
#define USB_PIPE2TRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPE2TRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPE3TRE_TRCLR                                                     (0x0100u)
#define USB_PIPE3TRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPE3TRE_TRENB                                                     (0x0200u)
#define USB_PIPE3TRE_TRENB_SHIFT                                               (9u)
#define USB_PIPE3TRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPE3TRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPE4TRE_TRCLR                                                     (0x0100u)
#define USB_PIPE4TRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPE4TRE_TRENB                                                     (0x0200u)
#define USB_PIPE4TRE_TRENB_SHIFT                                               (9u)
#define USB_PIPE4TRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPE4TRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPE5TRE_TRCLR                                                     (0x0100u)
#define USB_PIPE5TRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPE5TRE_TRENB                                                     (0x0200u)
#define USB_PIPE5TRE_TRENB_SHIFT                                               (9u)
#define USB_PIPE5TRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPE5TRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPEBTRE_TRCLR                                                     (0x0100u)
#define USB_PIPEBTRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPEBTRE_TRENB                                                     (0x0200u)
#define USB_PIPEBTRE_TRENB_SHIFT                                               (9u)
#define USB_PIPEBTRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPEBTRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPECTRE_TRCLR                                                     (0x0100u)
#define USB_PIPECTRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPECTRE_TRENB                                                     (0x0200u)
#define USB_PIPECTRE_TRENB_SHIFT                                               (9u)
#define USB_PIPECTRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPECTRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPEDTRE_TRCLR                                                     (0x0100u)
#define USB_PIPEDTRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPEDTRE_TRENB                                                     (0x0200u)
#define USB_PIPEDTRE_TRENB_SHIFT                                               (9u)
#define USB_PIPEDTRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPEDTRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPEETRE_TRCLR                                                     (0x0100u)
#define USB_PIPEETRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPEETRE_TRENB                                                     (0x0200u)
#define USB_PIPEETRE_TRENB_SHIFT                                               (9u)
#define USB_PIPEETRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPEETRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPEFTRE_TRCLR                                                     (0x0100u)
#define USB_PIPEFTRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPEFTRE_TRENB                                                     (0x0200u)
#define USB_PIPEFTRE_TRENB_SHIFT                                               (9u)
#define USB_PIPEFTRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPEFTRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPE9TRE_TRCLR                                                     (0x0100u)
#define USB_PIPE9TRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPE9TRE_TRENB                                                     (0x0200u)
#define USB_PIPE9TRE_TRENB_SHIFT                                               (9u)
#define USB_PIPE9TRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPE9TRN_TRNCNT_SHIFT                                              (0u)
#define USB_PIPEATRE_TRCLR                                                     (0x0100u)
#define USB_PIPEATRE_TRCLR_SHIFT                                               (8u)
#define USB_PIPEATRE_TRENB                                                     (0x0200u)
#define USB_PIPEATRE_TRENB_SHIFT                                               (9u)
#define USB_PIPEATRN_TRNCNT                                                    (0xFFFFu)
#define USB_PIPEATRN_TRNCNT_SHIFT                                              (0u)
#define USB_LPCTRL_HWUPM                                                       (0x0080u)
#define USB_LPCTRL_HWUPM_SHIFT                                                 (7u)
#define USB_LPSTS_SUSPM                                                        (0x4000u)
#define USB_LPSTS_SUSPM_SHIFT                                                  (14u)
#define USB_PHYFUNCTR_SusMon                                                   (0x4000u)
#define USB_PHYFUNCTR_SusMon_SHIFT                                             (14u)
#define USB_PHYOTGCTR_DpPuDwn                                                  (0x0200u)
#define USB_PHYOTGCTR_DpPuDwn_SHIFT                                            (9u)
#define USB_PHYOTGCTR_DmPuDwn                                                  (0x0400u)
#define USB_PHYOTGCTR_DmPuDwn_SHIFT                                            (10u)
#define USB_PL1CTRL1_L1RESPEN                                                  (0x0001u)
#define USB_PL1CTRL1_L1RESPEN_SHIFT                                            (0u)
#define USB_PL1CTRL1_L1RESPMD                                                  (0x0006u)
#define USB_PL1CTRL1_L1RESPMD_SHIFT                                            (1u)
#define USB_PL1CTRL1_L1NEGOMD                                                  (0x0008u)
#define USB_PL1CTRL1_L1NEGOMD_SHIFT                                            (3u)
#define USB_PL1CTRL1_DVSQ                                                      (0x00F0u)
#define USB_PL1CTRL1_DVSQ_SHIFT                                                (4u)
#define USB_PL1CTRL1_HIRDTHR                                                   (0x0F00u)
#define USB_PL1CTRL1_HIRDTHR_SHIFT                                             (8u)
#define USB_PL1CTRL1_L1EXTMD                                                   (0x4000u)
#define USB_PL1CTRL1_L1EXTMD_SHIFT                                             (14u)
#define USB_PL1CTRL2_HIRDMON                                                   (0x0F00u)
#define USB_PL1CTRL2_HIRDMON_SHIFT                                             (8u)
#define USB_PL1CTRL2_RWEMON                                                    (0x1000u)
#define USB_PL1CTRL2_RWEMON_SHIFT                                              (12u)
#define USB_N0SA_0_SA_WD                                                       (0xFFFFFFFFu)
#define USB_N0SA_0_SA_WD_SHIFT                                                 (0u)
#define USB_N0DA_0_DA                                                          (0xFFFFFFFFu)
#define USB_N0DA_0_DA_SHIFT                                                    (0u)
#define USB_N0TB_0_TB                                                          (0xFFFFFFFFu)
#define USB_N0TB_0_TB_SHIFT                                                    (0u)
#define USB_N1SA_0_SA_WD                                                       (0xFFFFFFFFu)
#define USB_N1SA_0_SA_WD_SHIFT                                                 (0u)
#define USB_N1DA_0_DA                                                          (0xFFFFFFFFu)
#define USB_N1DA_0_DA_SHIFT                                                    (0u)
#define USB_N1TB_0_TB                                                          (0xFFFFFFFFu)
#define USB_N1TB_0_TB_SHIFT                                                    (0u)
#define USB_CRSA_0_CRSA                                                        (0xFFFFFFFFu)
#define USB_CRSA_0_CRSA_SHIFT                                                  (0u)
#define USB_CRDA_0_CRDA                                                        (0xFFFFFFFFu)
#define USB_CRDA_0_CRDA_SHIFT                                                  (0u)
#define USB_CRTB_0_CRTB                                                        (0xFFFFFFFFu)
#define USB_CRTB_0_CRTB_SHIFT                                                  (0u)
#define USB_CHSTAT_0_EN                                                        (0x00000001u)
#define USB_CHSTAT_0_EN_SHIFT                                                  (0u)
#define USB_CHSTAT_0_RQST                                                      (0x00000002u)
#define USB_CHSTAT_0_RQST_SHIFT                                                (1u)
#define USB_CHSTAT_0_TACT                                                      (0x00000004u)
#define USB_CHSTAT_0_TACT_SHIFT                                                (2u)
#define USB_CHSTAT_0_SUS                                                       (0x00000008u)
#define USB_CHSTAT_0_SUS_SHIFT                                                 (3u)
#define USB_CHSTAT_0_ER                                                        (0x00000010u)
#define USB_CHSTAT_0_ER_SHIFT                                                  (4u)
#define USB_CHSTAT_0_END                                                       (0x00000020u)
#define USB_CHSTAT_0_END_SHIFT                                                 (5u)
#define USB_CHSTAT_0_TC                                                        (0x00000040u)
#define USB_CHSTAT_0_TC_SHIFT                                                  (6u)
#define USB_CHSTAT_0_SR                                                        (0x00000080u)
#define USB_CHSTAT_0_SR_SHIFT                                                  (7u)
#define USB_CHSTAT_0_DL                                                        (0x00000100u)
#define USB_CHSTAT_0_DL_SHIFT                                                  (8u)
#define USB_CHSTAT_0_DW                                                        (0x00000200u)
#define USB_CHSTAT_0_DW_SHIFT                                                  (9u)
#define USB_CHSTAT_0_DER                                                       (0x00000400u)
#define USB_CHSTAT_0_DER_SHIFT                                                 (10u)
#define USB_CHSTAT_0_MODE                                                      (0x00000800u)
#define USB_CHSTAT_0_MODE_SHIFT                                                (11u)
#define USB_CHSTAT_0_INTM                                                      (0x00010000u)
#define USB_CHSTAT_0_INTM_SHIFT                                                (16u)
#define USB_CHSTAT_0_DMARQM                                                    (0x00020000u)
#define USB_CHSTAT_0_DMARQM_SHIFT                                              (17u)
#define USB_CHSTAT_0_SWPRQ                                                     (0x00040000u)
#define USB_CHSTAT_0_SWPRQ_SHIFT                                               (18u)
#define USB_CHSTAT_0_DNUM                                                      (0xFF000000u)
#define USB_CHSTAT_0_DNUM_SHIFT                                                (24u)
#define USB_CHCTRL_0_SETEN                                                     (0x00000001u)
#define USB_CHCTRL_0_SETEN_SHIFT                                               (0u)
#define USB_CHCTRL_0_CLREN                                                     (0x00000002u)
#define USB_CHCTRL_0_CLREN_SHIFT                                               (1u)
#define USB_CHCTRL_0_STG                                                       (0x00000004u)
#define USB_CHCTRL_0_STG_SHIFT                                                 (2u)
#define USB_CHCTRL_0_SWRST                                                     (0x00000008u)
#define USB_CHCTRL_0_SWRST_SHIFT                                               (3u)
#define USB_CHCTRL_0_CLRRQ                                                     (0x00000010u)
#define USB_CHCTRL_0_CLRRQ_SHIFT                                               (4u)
#define USB_CHCTRL_0_CLREND                                                    (0x00000020u)
#define USB_CHCTRL_0_CLREND_SHIFT                                              (5u)
#define USB_CHCTRL_0_CLRTC                                                     (0x00000040u)
#define USB_CHCTRL_0_CLRTC_SHIFT                                               (6u)
#define USB_CHCTRL_0_CLRDER                                                    (0x00000080u)
#define USB_CHCTRL_0_CLRDER_SHIFT                                              (7u)
#define USB_CHCTRL_0_SETSUS                                                    (0x00000100u)
#define USB_CHCTRL_0_SETSUS_SHIFT                                              (8u)
#define USB_CHCTRL_0_CLRSUS                                                    (0x00000200u)
#define USB_CHCTRL_0_CLRSUS_SHIFT                                              (9u)
#define USB_CHCTRL_0_SETREN                                                    (0x00001000u)
#define USB_CHCTRL_0_SETREN_SHIFT                                              (12u)
#define USB_CHCTRL_0_SETSSWPRQ                                                 (0x00004000u)
#define USB_CHCTRL_0_SETSSWPRQ_SHIFT                                           (14u)
#define USB_CHCTRL_0_SETINTM                                                   (0x00010000u)
#define USB_CHCTRL_0_SETINTM_SHIFT                                             (16u)
#define USB_CHCTRL_0_CLRINTM                                                   (0x00020000u)
#define USB_CHCTRL_0_CLRINTM_SHIFT                                             (17u)
#define USB_CHCTRL_0_SETDMARQM                                                 (0x00040000u)
#define USB_CHCTRL_0_SETDMARQM_SHIFT                                           (18u)
#define USB_CHCTRL_0_CLRDMARQM                                                 (0x00080000u)
#define USB_CHCTRL_0_CLRDMARQM_SHIFT                                           (19u)
#define USB_CHCFG_0_SEL                                                        (0x00000001u)
#define USB_CHCFG_0_SEL_SHIFT                                                  (0u)
#define USB_CHCFG_0_REQD                                                       (0x00000008u)
#define USB_CHCFG_0_REQD_SHIFT                                                 (3u)
#define USB_CHCFG_0_DRRP                                                       (0x00000800u)
#define USB_CHCFG_0_DRRP_SHIFT                                                 (11u)
#define USB_CHCFG_0_SDS                                                        (0x0000F000u)
#define USB_CHCFG_0_SDS_SHIFT                                                  (12u)
#define USB_CHCFG_0_DDS                                                        (0x000F0000u)
#define USB_CHCFG_0_DDS_SHIFT                                                  (16u)
#define USB_CHCFG_0_SAD                                                        (0x00100000u)
#define USB_CHCFG_0_SAD_SHIFT                                                  (20u)
#define USB_CHCFG_0_DAD                                                        (0x00200000u)
#define USB_CHCFG_0_DAD_SHIFT                                                  (21u)
#define USB_CHCFG_0_WONLY                                                      (0x00800000u)
#define USB_CHCFG_0_WONLY_SHIFT                                                (23u)
#define USB_CHCFG_0_DEM                                                        (0x01000000u)
#define USB_CHCFG_0_DEM_SHIFT                                                  (24u)
#define USB_CHCFG_0_TCM                                                        (0x02000000u)
#define USB_CHCFG_0_TCM_SHIFT                                                  (25u)
#define USB_CHCFG_0_DIM                                                        (0x04000000u)
#define USB_CHCFG_0_DIM_SHIFT                                                  (26u)
#define USB_CHCFG_0_SBE                                                        (0x08000000u)
#define USB_CHCFG_0_SBE_SHIFT                                                  (27u)
#define USB_CHCFG_0_RSEL                                                       (0x10000000u)
#define USB_CHCFG_0_RSEL_SHIFT                                                 (28u)
#define USB_CHCFG_0_RSW                                                        (0x20000000u)
#define USB_CHCFG_0_RSW_SHIFT                                                  (29u)
#define USB_CHCFG_0_REN                                                        (0x40000000u)
#define USB_CHCFG_0_REN_SHIFT                                                  (30u)
#define USB_CHCFG_0_DMS                                                        (0x80000000u)
#define USB_CHCFG_0_DMS_SHIFT                                                  (31u)
#define USB_CHITVL_0_ITVL                                                      (0x0000FFFFu)
#define USB_CHITVL_0_ITVL_SHIFT                                                (0u)
#define USB_CHEXT_0_SPR                                                        (0x0000000Fu)
#define USB_CHEXT_0_SPR_SHIFT                                                  (0u)
#define USB_CHEXT_0_DPR                                                        (0x00000F00u)
#define USB_CHEXT_0_DPR_SHIFT                                                  (8u)
#define USB_NXLA_0_NXLA                                                        (0xFFFFFFFFu)
#define USB_NXLA_0_NXLA_SHIFT                                                  (0u)
#define USB_CRLA_0_CRLA                                                        (0xFFFFFFFFu)
#define USB_CRLA_0_CRLA_SHIFT                                                  (0u)
#define USB_N0SA_1_SA_WD                                                       (0xFFFFFFFFu)
#define USB_N0SA_1_SA_WD_SHIFT                                                 (0u)
#define USB_N0DA_1_DA                                                          (0xFFFFFFFFu)
#define USB_N0DA_1_DA_SHIFT                                                    (0u)
#define USB_N0TB_1_TB                                                          (0xFFFFFFFFu)
#define USB_N0TB_1_TB_SHIFT                                                    (0u)
#define USB_N1SA_1_SA_WD                                                       (0xFFFFFFFFu)
#define USB_N1SA_1_SA_WD_SHIFT                                                 (0u)
#define USB_N1DA_1_DA                                                          (0xFFFFFFFFu)
#define USB_N1DA_1_DA_SHIFT                                                    (0u)
#define USB_N1TB_1_TB                                                          (0xFFFFFFFFu)
#define USB_N1TB_1_TB_SHIFT                                                    (0u)
#define USB_CRSA_1_CRSA                                                        (0xFFFFFFFFu)
#define USB_CRSA_1_CRSA_SHIFT                                                  (0u)
#define USB_CRDA_1_CRDA                                                        (0xFFFFFFFFu)
#define USB_CRDA_1_CRDA_SHIFT                                                  (0u)
#define USB_CRTB_1_CRTB                                                        (0xFFFFFFFFu)
#define USB_CRTB_1_CRTB_SHIFT                                                  (0u)
#define USB_CHSTAT_1_EN                                                        (0x00000001u)
#define USB_CHSTAT_1_EN_SHIFT                                                  (0u)
#define USB_CHSTAT_1_RQST                                                      (0x00000002u)
#define USB_CHSTAT_1_RQST_SHIFT                                                (1u)
#define USB_CHSTAT_1_TACT                                                      (0x00000004u)
#define USB_CHSTAT_1_TACT_SHIFT                                                (2u)
#define USB_CHSTAT_1_SUS                                                       (0x00000008u)
#define USB_CHSTAT_1_SUS_SHIFT                                                 (3u)
#define USB_CHSTAT_1_ER                                                        (0x00000010u)
#define USB_CHSTAT_1_ER_SHIFT                                                  (4u)
#define USB_CHSTAT_1_END                                                       (0x00000020u)
#define USB_CHSTAT_1_END_SHIFT                                                 (5u)
#define USB_CHSTAT_1_TC                                                        (0x00000040u)
#define USB_CHSTAT_1_TC_SHIFT                                                  (6u)
#define USB_CHSTAT_1_SR                                                        (0x00000080u)
#define USB_CHSTAT_1_SR_SHIFT                                                  (7u)
#define USB_CHSTAT_1_DL                                                        (0x00000100u)
#define USB_CHSTAT_1_DL_SHIFT                                                  (8u)
#define USB_CHSTAT_1_DW                                                        (0x00000200u)
#define USB_CHSTAT_1_DW_SHIFT                                                  (9u)
#define USB_CHSTAT_1_DER                                                       (0x00000400u)
#define USB_CHSTAT_1_DER_SHIFT                                                 (10u)
#define USB_CHSTAT_1_MODE                                                      (0x00000800u)
#define USB_CHSTAT_1_MODE_SHIFT                                                (11u)
#define USB_CHSTAT_1_INTM                                                      (0x00010000u)
#define USB_CHSTAT_1_INTM_SHIFT                                                (16u)
#define USB_CHSTAT_1_DMARQM                                                    (0x00020000u)
#define USB_CHSTAT_1_DMARQM_SHIFT                                              (17u)
#define USB_CHSTAT_1_SWPRQ                                                     (0x00040000u)
#define USB_CHSTAT_1_SWPRQ_SHIFT                                               (18u)
#define USB_CHSTAT_1_DNUM                                                      (0xFF000000u)
#define USB_CHSTAT_1_DNUM_SHIFT                                                (24u)
#define USB_CHCTRL_1_SETEN                                                     (0x00000001u)
#define USB_CHCTRL_1_SETEN_SHIFT                                               (0u)
#define USB_CHCTRL_1_CLREN                                                     (0x00000002u)
#define USB_CHCTRL_1_CLREN_SHIFT                                               (1u)
#define USB_CHCTRL_1_STG                                                       (0x00000004u)
#define USB_CHCTRL_1_STG_SHIFT                                                 (2u)
#define USB_CHCTRL_1_SWRST                                                     (0x00000008u)
#define USB_CHCTRL_1_SWRST_SHIFT                                               (3u)
#define USB_CHCTRL_1_CLRRQ                                                     (0x00000010u)
#define USB_CHCTRL_1_CLRRQ_SHIFT                                               (4u)
#define USB_CHCTRL_1_CLREND                                                    (0x00000020u)
#define USB_CHCTRL_1_CLREND_SHIFT                                              (5u)
#define USB_CHCTRL_1_CLRTC                                                     (0x00000040u)
#define USB_CHCTRL_1_CLRTC_SHIFT                                               (6u)
#define USB_CHCTRL_1_CLRDER                                                    (0x00000080u)
#define USB_CHCTRL_1_CLRDER_SHIFT                                              (7u)
#define USB_CHCTRL_1_SETSUS                                                    (0x00000100u)
#define USB_CHCTRL_1_SETSUS_SHIFT                                              (8u)
#define USB_CHCTRL_1_CLRSUS                                                    (0x00000200u)
#define USB_CHCTRL_1_CLRSUS_SHIFT                                              (9u)
#define USB_CHCTRL_1_SETREN                                                    (0x00001000u)
#define USB_CHCTRL_1_SETREN_SHIFT                                              (12u)
#define USB_CHCTRL_1_SETSSWPRQ                                                 (0x00004000u)
#define USB_CHCTRL_1_SETSSWPRQ_SHIFT                                           (14u)
#define USB_CHCTRL_1_SETINTM                                                   (0x00010000u)
#define USB_CHCTRL_1_SETINTM_SHIFT                                             (16u)
#define USB_CHCTRL_1_CLRINTM                                                   (0x00020000u)
#define USB_CHCTRL_1_CLRINTM_SHIFT                                             (17u)
#define USB_CHCTRL_1_SETDMARQM                                                 (0x00040000u)
#define USB_CHCTRL_1_SETDMARQM_SHIFT                                           (18u)
#define USB_CHCTRL_1_CLRDMARQM                                                 (0x00080000u)
#define USB_CHCTRL_1_CLRDMARQM_SHIFT                                           (19u)
#define USB_CHCFG_1_SEL                                                        (0x00000001u)
#define USB_CHCFG_1_SEL_SHIFT                                                  (0u)
#define USB_CHCFG_1_REQD                                                       (0x00000008u)
#define USB_CHCFG_1_REQD_SHIFT                                                 (3u)
#define USB_CHCFG_1_DRRP                                                       (0x00000800u)
#define USB_CHCFG_1_DRRP_SHIFT                                                 (11u)
#define USB_CHCFG_1_SDS                                                        (0x0000F000u)
#define USB_CHCFG_1_SDS_SHIFT                                                  (12u)
#define USB_CHCFG_1_DDS                                                        (0x000F0000u)
#define USB_CHCFG_1_DDS_SHIFT                                                  (16u)
#define USB_CHCFG_1_SAD                                                        (0x00100000u)
#define USB_CHCFG_1_SAD_SHIFT                                                  (20u)
#define USB_CHCFG_1_DAD                                                        (0x00200000u)
#define USB_CHCFG_1_DAD_SHIFT                                                  (21u)
#define USB_CHCFG_1_WONLY                                                      (0x00800000u)
#define USB_CHCFG_1_WONLY_SHIFT                                                (23u)
#define USB_CHCFG_1_DEM                                                        (0x01000000u)
#define USB_CHCFG_1_DEM_SHIFT                                                  (24u)
#define USB_CHCFG_1_TCM                                                        (0x02000000u)
#define USB_CHCFG_1_TCM_SHIFT                                                  (25u)
#define USB_CHCFG_1_DIM                                                        (0x04000000u)
#define USB_CHCFG_1_DIM_SHIFT                                                  (26u)
#define USB_CHCFG_1_SBE                                                        (0x08000000u)
#define USB_CHCFG_1_SBE_SHIFT                                                  (27u)
#define USB_CHCFG_1_RSEL                                                       (0x10000000u)
#define USB_CHCFG_1_RSEL_SHIFT                                                 (28u)
#define USB_CHCFG_1_RSW                                                        (0x20000000u)
#define USB_CHCFG_1_RSW_SHIFT                                                  (29u)
#define USB_CHCFG_1_REN                                                        (0x40000000u)
#define USB_CHCFG_1_REN_SHIFT                                                  (30u)
#define USB_CHCFG_1_DMS                                                        (0x80000000u)
#define USB_CHCFG_1_DMS_SHIFT                                                  (31u)
#define USB_CHITVL_1_ITVL                                                      (0x0000FFFFu)
#define USB_CHITVL_1_ITVL_SHIFT                                                (0u)
#define USB_CHEXT_1_SPR                                                        (0x0000000Fu)
#define USB_CHEXT_1_SPR_SHIFT                                                  (0u)
#define USB_CHEXT_1_DPR                                                        (0x00000F00u)
#define USB_CHEXT_1_DPR_SHIFT                                                  (8u)
#define USB_NXLA_1_NXLA                                                        (0xFFFFFFFFu)
#define USB_NXLA_1_NXLA_SHIFT                                                  (0u)
#define USB_CRLA_1_CRLA                                                        (0xFFFFFFFFu)
#define USB_CRLA_1_CRLA_SHIFT                                                  (0u)
#define USB_SCNT_0_SCNT                                                        (0xFFFFFFFFu)
#define USB_SCNT_0_SCNT_SHIFT                                                  (0u)
#define USB_SSKP_0_SSKP                                                        (0xFFFFFFFFu)
#define USB_SSKP_0_SSKP_SHIFT                                                  (0u)
#define USB_DCNT_0_DCNT                                                        (0xFFFFFFFFu)
#define USB_DCNT_0_DCNT_SHIFT                                                  (0u)
#define USB_DSKP_0_DSKP                                                        (0xFFFFFFFFu)
#define USB_DSKP_0_DSKP_SHIFT                                                  (0u)
#define USB_SCNT_1_SCNT                                                        (0xFFFFFFFFu)
#define USB_SCNT_1_SCNT_SHIFT                                                  (0u)
#define USB_SSKP_1_SSKP                                                        (0xFFFFFFFFu)
#define USB_SSKP_1_SSKP_SHIFT                                                  (0u)
#define USB_DCNT_1_DCNT                                                        (0xFFFFFFFFu)
#define USB_DCNT_1_DCNT_SHIFT                                                  (0u)
#define USB_DSKP_1_DSKP                                                        (0xFFFFFFFFu)
#define USB_DSKP_1_DSKP_SHIFT                                                  (0u)
#define USB_DCTRL_PR                                                           (0x00000001u)
#define USB_DCTRL_PR_SHIFT                                                     (0u)
#define USB_DCTRL_LVINT                                                        (0x00000002u)
#define USB_DCTRL_LVINT_SHIFT                                                  (1u)
#define USB_DCTRL_LDPR                                                         (0x000F0000u)
#define USB_DCTRL_LDPR_SHIFT                                                   (16u)
#define USB_DCTRL_LWPR                                                         (0x0F000000u)
#define USB_DCTRL_LWPR_SHIFT                                                   (24u)
#define USB_DSCITVL_DITVL                                                      (0x0000FF00u)
#define USB_DSCITVL_DITVL_SHIFT                                                (8u)
#define USB_DST_EN_EN0                                                         (0x00000001u)
#define USB_DST_EN_EN0_SHIFT                                                   (0u)
#define USB_DST_EN_EN1                                                         (0x00000002u)
#define USB_DST_EN_EN1_SHIFT                                                   (1u)
#define USB_DST_ER_ER0                                                         (0x00000001u)
#define USB_DST_ER_ER0_SHIFT                                                   (0u)
#define USB_DST_ER_ER1                                                         (0x00000002u)
#define USB_DST_ER_ER1_SHIFT                                                   (1u)
#define USB_DST_END_END0                                                       (0x00000001u)
#define USB_DST_END_END0_SHIFT                                                 (0u)
#define USB_DST_END_END1                                                       (0x00000002u)
#define USB_DST_END_END1_SHIFT                                                 (1u)
#define USB_DST_TC_TC0                                                         (0x00000001u)
#define USB_DST_TC_TC0_SHIFT                                                   (0u)
#define USB_DST_TC_TC1                                                         (0x00000002u)
#define USB_DST_TC_TC1_SHIFT                                                   (1u)
#define USB_DST_SUS_SUS0                                                       (0x00000001u)
#define USB_DST_SUS_SUS0_SHIFT                                                 (0u)
#define USB_DST_SUS_SUS1                                                       (0x00000002u)
#define USB_DST_SUS_SUS1_SHIFT                                                 (1u)

#endif
