/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2018-2020 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/* Copyright (c) 2018-2020 Renesas Electronics Corporation.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
* Rev: 2.00
* Description : IO bitmask header
*******************************************************************************/

#ifndef VDC6_IOBITMASK_H
#define VDC6_IOBITMASK_H


/* ==== Mask values for IO registers ==== */

#define VDC6_INP_UPDATE_INP_IMG_UPDATE                                         (0x00000001u)
#define VDC6_INP_UPDATE_INP_IMG_UPDATE_SHIFT                                   (0u)
#define VDC6_INP_UPDATE_INP_EXT_UPDATE                                         (0x00000010u)
#define VDC6_INP_UPDATE_INP_EXT_UPDATE_SHIFT                                   (4u)
#define VDC6_INP_SEL_CNT_INP_HS_EDGE                                           (0x00000001u)
#define VDC6_INP_SEL_CNT_INP_HS_EDGE_SHIFT                                     (0u)
#define VDC6_INP_SEL_CNT_INP_VS_EDGE                                           (0x00000010u)
#define VDC6_INP_SEL_CNT_INP_VS_EDGE_SHIFT                                     (4u)
#define VDC6_INP_SEL_CNT_INP_PXD_EDGE                                          (0x00000100u)
#define VDC6_INP_SEL_CNT_INP_PXD_EDGE_SHIFT                                    (8u)
#define VDC6_INP_SEL_CNT_INP_FORMAT                                            (0x00007000u)
#define VDC6_INP_SEL_CNT_INP_FORMAT_SHIFT                                      (12u)
#define VDC6_INP_SEL_CNT_INP_SEL                                               (0x00100000u)
#define VDC6_INP_SEL_CNT_INP_SEL_SHIFT                                         (20u)
#define VDC6_INP_EXT_SYNC_CNT_INP_H_POS                                        (0x00000003u)
#define VDC6_INP_EXT_SYNC_CNT_INP_H_POS_SHIFT                                  (0u)
#define VDC6_INP_EXT_SYNC_CNT_INP_F525_625                                     (0x00000010u)
#define VDC6_INP_EXT_SYNC_CNT_INP_F525_625_SHIFT                               (4u)
#define VDC6_INP_EXT_SYNC_CNT_INP_H_EDGE_SEL                                   (0x00000100u)
#define VDC6_INP_EXT_SYNC_CNT_INP_H_EDGE_SEL_SHIFT                             (8u)
#define VDC6_INP_EXT_SYNC_CNT_INP_HS_INV                                       (0x00010000u)
#define VDC6_INP_EXT_SYNC_CNT_INP_HS_INV_SHIFT                                 (16u)
#define VDC6_INP_EXT_SYNC_CNT_INP_VS_INV                                       (0x00100000u)
#define VDC6_INP_EXT_SYNC_CNT_INP_VS_INV_SHIFT                                 (20u)
#define VDC6_INP_EXT_SYNC_CNT_INP_SWAP_ON                                      (0x01000000u)
#define VDC6_INP_EXT_SYNC_CNT_INP_SWAP_ON_SHIFT                                (24u)
#define VDC6_INP_EXT_SYNC_CNT_INP_ENDIAN_ON                                    (0x10000000u)
#define VDC6_INP_EXT_SYNC_CNT_INP_ENDIAN_ON_SHIFT                              (28u)
#define VDC6_INP_VSYNC_PH_ADJ_INP_FH25                                         (0x00000FFFu)
#define VDC6_INP_VSYNC_PH_ADJ_INP_FH25_SHIFT                                   (0u)
#define VDC6_INP_VSYNC_PH_ADJ_INP_FH50                                         (0x0FFF0000u)
#define VDC6_INP_VSYNC_PH_ADJ_INP_FH50_SHIFT                                   (16u)
#define VDC6_INP_DLY_ADJ_INP_HS_DLY                                            (0x000000FFu)
#define VDC6_INP_DLY_ADJ_INP_HS_DLY_SHIFT                                      (0u)
#define VDC6_INP_DLY_ADJ_INP_VS_DLY                                            (0x0000FF00u)
#define VDC6_INP_DLY_ADJ_INP_VS_DLY_SHIFT                                      (8u)
#define VDC6_INP_DLY_ADJ_INP_FLD_DLY                                           (0x00FF0000u)
#define VDC6_INP_DLY_ADJ_INP_FLD_DLY_SHIFT                                     (16u)
#define VDC6_INP_DLY_ADJ_INP_VS_DLY_L                                          (0x07000000u)
#define VDC6_INP_DLY_ADJ_INP_VS_DLY_L_SHIFT                                    (24u)
#define VDC6_IMGCNT_UPDATE_IMGCNT_VEN                                          (0x00000001u)
#define VDC6_IMGCNT_UPDATE_IMGCNT_VEN_SHIFT                                    (0u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_Y_GAIN                                        (0x00000003u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_Y_GAIN_SHIFT                                  (0u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_Y_TAP                                         (0x00000030u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_Y_TAP_SHIFT                                   (4u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_Y_TH                                          (0x00007F00u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_Y_TH_SHIFT                                    (8u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_ON                                            (0x00010000u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_ON_SHIFT                                      (16u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_MD                                            (0x00100000u)
#define VDC6_IMGCNT_NR_CNT0_NR1D_MD_SHIFT                                      (20u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CR_GAIN                                       (0x00000003u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CR_GAIN_SHIFT                                 (0u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CR_TAP                                        (0x00000030u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CR_TAP_SHIFT                                  (4u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CR_TH                                         (0x00007F00u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CR_TH_SHIFT                                   (8u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CB_GAIN                                       (0x00030000u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CB_GAIN_SHIFT                                 (16u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CB_TAP                                        (0x00300000u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CB_TAP_SHIFT                                  (20u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CB_TH                                         (0x7F000000u)
#define VDC6_IMGCNT_NR_CNT1_NR1D_CB_TH_SHIFT                                   (24u)
#define VDC6_IMGCNT_MTX_MODE_IMGCNT_MTX_MD                                     (0x00000003u)
#define VDC6_IMGCNT_MTX_MODE_IMGCNT_MTX_MD_SHIFT                               (0u)
#define VDC6_IMGCNT_MTX_YG_ADJ0_IMGCNT_MTX_GG                                  (0x000007FFu)
#define VDC6_IMGCNT_MTX_YG_ADJ0_IMGCNT_MTX_GG_SHIFT                            (0u)
#define VDC6_IMGCNT_MTX_YG_ADJ0_IMGCNT_MTX_YG                                  (0x00FF0000u)
#define VDC6_IMGCNT_MTX_YG_ADJ0_IMGCNT_MTX_YG_SHIFT                            (16u)
#define VDC6_IMGCNT_MTX_YG_ADJ1_IMGCNT_MTX_GR                                  (0x000007FFu)
#define VDC6_IMGCNT_MTX_YG_ADJ1_IMGCNT_MTX_GR_SHIFT                            (0u)
#define VDC6_IMGCNT_MTX_YG_ADJ1_IMGCNT_MTX_GB                                  (0x07FF0000u)
#define VDC6_IMGCNT_MTX_YG_ADJ1_IMGCNT_MTX_GB_SHIFT                            (16u)
#define VDC6_IMGCNT_MTX_CBB_ADJ0_IMGCNT_MTX_BG                                 (0x000007FFu)
#define VDC6_IMGCNT_MTX_CBB_ADJ0_IMGCNT_MTX_BG_SHIFT                           (0u)
#define VDC6_IMGCNT_MTX_CBB_ADJ0_IMGCNT_MTX_B                                  (0x00FF0000u)
#define VDC6_IMGCNT_MTX_CBB_ADJ0_IMGCNT_MTX_B_SHIFT                            (16u)
#define VDC6_IMGCNT_MTX_CBB_ADJ1_IMGCNT_MTX_BR                                 (0x000007FFu)
#define VDC6_IMGCNT_MTX_CBB_ADJ1_IMGCNT_MTX_BR_SHIFT                           (0u)
#define VDC6_IMGCNT_MTX_CBB_ADJ1_IMGCNT_MTX_BB                                 (0x07FF0000u)
#define VDC6_IMGCNT_MTX_CBB_ADJ1_IMGCNT_MTX_BB_SHIFT                           (16u)
#define VDC6_IMGCNT_MTX_CRR_ADJ0_IMGCNT_MTX_RG                                 (0x000007FFu)
#define VDC6_IMGCNT_MTX_CRR_ADJ0_IMGCNT_MTX_RG_SHIFT                           (0u)
#define VDC6_IMGCNT_MTX_CRR_ADJ0_IMGCNT_MTX_R                                  (0x00FF0000u)
#define VDC6_IMGCNT_MTX_CRR_ADJ0_IMGCNT_MTX_R_SHIFT                            (16u)
#define VDC6_IMGCNT_MTX_CRR_ADJ1_IMGCNT_MTX_RR                                 (0x000007FFu)
#define VDC6_IMGCNT_MTX_CRR_ADJ1_IMGCNT_MTX_RR_SHIFT                           (0u)
#define VDC6_IMGCNT_MTX_CRR_ADJ1_IMGCNT_MTX_RB                                 (0x07FF0000u)
#define VDC6_IMGCNT_MTX_CRR_ADJ1_IMGCNT_MTX_RB_SHIFT                           (16u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_A                                    (0x00000001u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_A_SHIFT                              (0u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_B                                    (0x00000010u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_B_SHIFT                              (4u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_UPDATE                                   (0x00000100u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_UPDATE_SHIFT                             (8u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_C                                    (0x00001000u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_C_SHIFT                              (12u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_D                                    (0x00002000u)
#define VDC6_SC0_SCL0_UPDATE_SC0_SCL0_VEN_D_SHIFT                              (13u)
#define VDC6_SC0_SCL0_FRC1_SC0_RES_VMASK_ON                                    (0x00000001u)
#define VDC6_SC0_SCL0_FRC1_SC0_RES_VMASK_ON_SHIFT                              (0u)
#define VDC6_SC0_SCL0_FRC1_SC0_RES_VMASK                                       (0xFFFF0000u)
#define VDC6_SC0_SCL0_FRC1_SC0_RES_VMASK_SHIFT                                 (16u)
#define VDC6_SC0_SCL0_FRC2_SC0_RES_VLACK_ON                                    (0x00000001u)
#define VDC6_SC0_SCL0_FRC2_SC0_RES_VLACK_ON_SHIFT                              (0u)
#define VDC6_SC0_SCL0_FRC2_SC0_RES_VLACK                                       (0xFFFF0000u)
#define VDC6_SC0_SCL0_FRC2_SC0_RES_VLACK_SHIFT                                 (16u)
#define VDC6_SC0_SCL0_FRC3_SC0_RES_VS_SEL                                      (0x00000001u)
#define VDC6_SC0_SCL0_FRC3_SC0_RES_VS_SEL_SHIFT                                (0u)
#define VDC6_SC0_SCL0_FRC4_SC0_RES_FH                                          (0x000007FFu)
#define VDC6_SC0_SCL0_FRC4_SC0_RES_FH_SHIFT                                    (0u)
#define VDC6_SC0_SCL0_FRC4_SC0_RES_FV                                          (0x07FF0000u)
#define VDC6_SC0_SCL0_FRC4_SC0_RES_FV_SHIFT                                    (16u)
#define VDC6_SC0_SCL0_FRC5_SC0_RES_VSDLY                                       (0x000000FFu)
#define VDC6_SC0_SCL0_FRC5_SC0_RES_VSDLY_SHIFT                                 (0u)
#define VDC6_SC0_SCL0_FRC5_SC0_RES_FLD_DLY_SEL                                 (0x00000100u)
#define VDC6_SC0_SCL0_FRC5_SC0_RES_FLD_DLY_SEL_SHIFT                           (8u)
#define VDC6_SC0_SCL0_FRC6_SC0_RES_F_VW                                        (0x000007FFu)
#define VDC6_SC0_SCL0_FRC6_SC0_RES_F_VW_SHIFT                                  (0u)
#define VDC6_SC0_SCL0_FRC6_SC0_RES_F_VS                                        (0x07FF0000u)
#define VDC6_SC0_SCL0_FRC6_SC0_RES_F_VS_SHIFT                                  (16u)
#define VDC6_SC0_SCL0_FRC7_SC0_RES_F_HW                                        (0x000007FFu)
#define VDC6_SC0_SCL0_FRC7_SC0_RES_F_HW_SHIFT                                  (0u)
#define VDC6_SC0_SCL0_FRC7_SC0_RES_F_HS                                        (0x07FF0000u)
#define VDC6_SC0_SCL0_FRC7_SC0_RES_F_HS_SHIFT                                  (16u)
#define VDC6_SC0_SCL0_FRC9_SC0_RES_QVLACK                                      (0x00000001u)
#define VDC6_SC0_SCL0_FRC9_SC0_RES_QVLACK_SHIFT                                (0u)
#define VDC6_SC0_SCL0_FRC9_SC0_RES_QVLOCK                                      (0x00000010u)
#define VDC6_SC0_SCL0_FRC9_SC0_RES_QVLOCK_SHIFT                                (4u)
#define VDC6_SC0_SCL0_MON0_SC0_RES_LIN_STAT                                    (0x07FFu)
#define VDC6_SC0_SCL0_MON0_SC0_RES_LIN_STAT_SHIFT                              (0u)
#define VDC6_SC0_SCL0_INT_SC0_RES_LINE                                         (0x07FFu)
#define VDC6_SC0_SCL0_INT_SC0_RES_LINE_SHIFT                                   (0u)
#define VDC6_SC0_SCL0_DS1_SC0_RES_DS_H_ON                                      (0x00000001u)
#define VDC6_SC0_SCL0_DS1_SC0_RES_DS_H_ON_SHIFT                                (0u)
#define VDC6_SC0_SCL0_DS1_SC0_RES_DS_V_ON                                      (0x00000010u)
#define VDC6_SC0_SCL0_DS1_SC0_RES_DS_V_ON_SHIFT                                (4u)
#define VDC6_SC0_SCL0_DS2_SC0_RES_VW                                           (0x000007FFu)
#define VDC6_SC0_SCL0_DS2_SC0_RES_VW_SHIFT                                     (0u)
#define VDC6_SC0_SCL0_DS2_SC0_RES_VS                                           (0x07FF0000u)
#define VDC6_SC0_SCL0_DS2_SC0_RES_VS_SHIFT                                     (16u)
#define VDC6_SC0_SCL0_DS3_SC0_RES_HW                                           (0x00000FFFu)
#define VDC6_SC0_SCL0_DS3_SC0_RES_HW_SHIFT                                     (0u)
#define VDC6_SC0_SCL0_DS3_SC0_RES_HS                                           (0x07FF0000u)
#define VDC6_SC0_SCL0_DS3_SC0_RES_HS_SHIFT                                     (16u)
#define VDC6_SC0_SCL0_DS4_SC0_RES_DS_H_RATIO                                   (0x0000FFFFu)
#define VDC6_SC0_SCL0_DS4_SC0_RES_DS_H_RATIO_SHIFT                             (0u)
#define VDC6_SC0_SCL0_DS4_SC0_RES_DS_H_INTERPOTYP                              (0x10000000u)
#define VDC6_SC0_SCL0_DS4_SC0_RES_DS_H_INTERPOTYP_SHIFT                        (28u)
#define VDC6_SC0_SCL0_DS4_SC0_RES_PFIL_SEL                                     (0x20000000u)
#define VDC6_SC0_SCL0_DS4_SC0_RES_PFIL_SEL_SHIFT                               (29u)
#define VDC6_SC0_SCL0_DS5_SC0_RES_BTM_INIPHASE                                 (0x00000FFFu)
#define VDC6_SC0_SCL0_DS5_SC0_RES_BTM_INIPHASE_SHIFT                           (0u)
#define VDC6_SC0_SCL0_DS5_SC0_RES_TOP_INIPHASE                                 (0x0FFF0000u)
#define VDC6_SC0_SCL0_DS5_SC0_RES_TOP_INIPHASE_SHIFT                           (16u)
#define VDC6_SC0_SCL0_DS5_SC0_RES_V_INTERPOTYP                                 (0x10000000u)
#define VDC6_SC0_SCL0_DS5_SC0_RES_V_INTERPOTYP_SHIFT                           (28u)
#define VDC6_SC0_SCL0_DS6_SC0_RES_V_RATIO                                      (0x0000FFFFu)
#define VDC6_SC0_SCL0_DS6_SC0_RES_V_RATIO_SHIFT                                (0u)
#define VDC6_SC0_SCL0_DS7_SC0_RES_OUT_HW                                       (0x000007FFu)
#define VDC6_SC0_SCL0_DS7_SC0_RES_OUT_HW_SHIFT                                 (0u)
#define VDC6_SC0_SCL0_DS7_SC0_RES_OUT_VW                                       (0x07FF0000u)
#define VDC6_SC0_SCL0_DS7_SC0_RES_OUT_VW_SHIFT                                 (16u)
#define VDC6_SC0_SCL0_US1_SC0_RES_US_H_ON                                      (0x00000001u)
#define VDC6_SC0_SCL0_US1_SC0_RES_US_H_ON_SHIFT                                (0u)
#define VDC6_SC0_SCL0_US1_SC0_RES_US_V_ON                                      (0x00000010u)
#define VDC6_SC0_SCL0_US1_SC0_RES_US_V_ON_SHIFT                                (4u)
#define VDC6_SC0_SCL0_US2_SC0_RES_P_VW                                         (0x000007FFu)
#define VDC6_SC0_SCL0_US2_SC0_RES_P_VW_SHIFT                                   (0u)
#define VDC6_SC0_SCL0_US2_SC0_RES_P_VS                                         (0x07FF0000u)
#define VDC6_SC0_SCL0_US2_SC0_RES_P_VS_SHIFT                                   (16u)
#define VDC6_SC0_SCL0_US3_SC0_RES_P_HW                                         (0x000007FFu)
#define VDC6_SC0_SCL0_US3_SC0_RES_P_HW_SHIFT                                   (0u)
#define VDC6_SC0_SCL0_US3_SC0_RES_P_HS                                         (0x07FF0000u)
#define VDC6_SC0_SCL0_US3_SC0_RES_P_HS_SHIFT                                   (16u)
#define VDC6_SC0_SCL0_US4_SC0_RES_IN_HW                                        (0x000007FFu)
#define VDC6_SC0_SCL0_US4_SC0_RES_IN_HW_SHIFT                                  (0u)
#define VDC6_SC0_SCL0_US4_SC0_RES_IN_VW                                        (0x07FF0000u)
#define VDC6_SC0_SCL0_US4_SC0_RES_IN_VW_SHIFT                                  (16u)
#define VDC6_SC0_SCL0_US5_SC0_RES_US_H_RATIO                                   (0x0000FFFFu)
#define VDC6_SC0_SCL0_US5_SC0_RES_US_H_RATIO_SHIFT                             (0u)
#define VDC6_SC0_SCL0_US6_SC0_RES_US_HB_INIPHASE                               (0x00000FFFu)
#define VDC6_SC0_SCL0_US6_SC0_RES_US_HB_INIPHASE_SHIFT                         (0u)
#define VDC6_SC0_SCL0_US6_SC0_RES_US_HT_INIPHASE                               (0x0FFF0000u)
#define VDC6_SC0_SCL0_US6_SC0_RES_US_HT_INIPHASE_SHIFT                         (16u)
#define VDC6_SC0_SCL0_US6_SC0_RES_US_H_INTERPOTYP                              (0x10000000u)
#define VDC6_SC0_SCL0_US6_SC0_RES_US_H_INTERPOTYP_SHIFT                        (28u)
#define VDC6_SC0_SCL0_US7_SC0_RES_VCUT                                         (0x000000FFu)
#define VDC6_SC0_SCL0_US7_SC0_RES_VCUT_SHIFT                                   (0u)
#define VDC6_SC0_SCL0_US7_SC0_RES_HCUT                                         (0x0000FF00u)
#define VDC6_SC0_SCL0_US7_SC0_RES_HCUT_SHIFT                                   (8u)
#define VDC6_SC0_SCL0_US8_SC0_RES_DISP_ON                                      (0x00000001u)
#define VDC6_SC0_SCL0_US8_SC0_RES_DISP_ON_SHIFT                                (0u)
#define VDC6_SC0_SCL0_US8_SC0_RES_IBUS_SYNC_SEL                                (0x00000010u)
#define VDC6_SC0_SCL0_US8_SC0_RES_IBUS_SYNC_SEL_SHIFT                          (4u)
#define VDC6_SC0_SCL0_OVR1_SC0_RES_BK_COL_B                                    (0x000000FFu)
#define VDC6_SC0_SCL0_OVR1_SC0_RES_BK_COL_B_SHIFT                              (0u)
#define VDC6_SC0_SCL0_OVR1_SC0_RES_BK_COL_G                                    (0x0000FF00u)
#define VDC6_SC0_SCL0_OVR1_SC0_RES_BK_COL_G_SHIFT                              (8u)
#define VDC6_SC0_SCL0_OVR1_SC0_RES_BK_COL_R                                    (0x00FF0000u)
#define VDC6_SC0_SCL0_OVR1_SC0_RES_BK_COL_R_SHIFT                              (16u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_VEN_A                                    (0x00000001u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_VEN_A_SHIFT                              (0u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_VEN_B                                    (0x00000010u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_VEN_B_SHIFT                              (4u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_UPDATE_A                                 (0x00010000u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_UPDATE_A_SHIFT                           (16u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_UPDATE_B                                 (0x00100000u)
#define VDC6_SC0_SCL1_UPDATE_SC0_SCL1_UPDATE_B_SHIFT                           (20u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_BST_MD                                       (0x00000001u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_BST_MD_SHIFT                                 (0u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_LOOP                                         (0x00000002u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_LOOP_SHIFT                                   (1u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_MD                                           (0x0000000Cu)
#define VDC6_SC0_SCL1_WR1_SC0_RES_MD_SHIFT                                     (2u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_DS_WR_MD                                     (0x00000070u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_DS_WR_MD_SHIFT                               (4u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_TB_ADD_MOD                                   (0x00000080u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_TB_ADD_MOD_SHIFT                             (7u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_WRSWA                                        (0x00070000u)
#define VDC6_SC0_SCL1_WR1_SC0_RES_WRSWA_SHIFT                                  (16u)
#define VDC6_SC0_SCL1_WR2_SC0_RES_BASE                                         (0xFFFFFFFFu)
#define VDC6_SC0_SCL1_WR2_SC0_RES_BASE_SHIFT                                   (0u)
#define VDC6_SC0_SCL1_WR3_SC0_RES_FLM_NUM                                      (0x000003FFu)
#define VDC6_SC0_SCL1_WR3_SC0_RES_FLM_NUM_SHIFT                                (0u)
#define VDC6_SC0_SCL1_WR3_SC0_RES_LN_OFF                                       (0x7FFF0000u)
#define VDC6_SC0_SCL1_WR3_SC0_RES_LN_OFF_SHIFT                                 (16u)
#define VDC6_SC0_SCL1_WR4_SC0_RES_FLM_OFF                                      (0x007FFFFFu)
#define VDC6_SC0_SCL1_WR4_SC0_RES_FLM_OFF_SHIFT                                (0u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_WENB                                         (0x00000001u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_WENB_SHIFT                                   (0u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_FLD_SEL                                      (0x00000010u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_FLD_SEL_SHIFT                                (4u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_FS_RATE                                      (0x00000300u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_FS_RATE_SHIFT                                (8u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_INTER                                        (0x00001000u)
#define VDC6_SC0_SCL1_WR5_SC0_RES_INTER_SHIFT                                  (12u)
#define VDC6_SC0_SCL1_WR6_SC0_RES_BITDEC_ON                                    (0x00000001u)
#define VDC6_SC0_SCL1_WR6_SC0_RES_BITDEC_ON_SHIFT                              (0u)
#define VDC6_SC0_SCL1_WR6_SC0_RES_DTH_ON                                       (0x00000010u)
#define VDC6_SC0_SCL1_WR6_SC0_RES_DTH_ON_SHIFT                                 (4u)
#define VDC6_SC0_SCL1_WR7_SC0_RES_FLM_CNT                                      (0x000003FFu)
#define VDC6_SC0_SCL1_WR7_SC0_RES_FLM_CNT_SHIFT                                (0u)
#define VDC6_SC0_SCL1_WR7_SC0_RES_OVERFLOW                                     (0x00010000u)
#define VDC6_SC0_SCL1_WR7_SC0_RES_OVERFLOW_SHIFT                               (16u)
#define VDC6_SC0_SCL1_WR8_SC0_RES_BASE_B                                       (0xFFFFFFFFu)
#define VDC6_SC0_SCL1_WR8_SC0_RES_BASE_B_SHIFT                                 (0u)
#define VDC6_SC0_SCL1_WR9_SC0_RES_FLM_NUM_B                                    (0x000003FFu)
#define VDC6_SC0_SCL1_WR9_SC0_RES_FLM_NUM_B_SHIFT                              (0u)
#define VDC6_SC0_SCL1_WR9_SC0_RES_LN_OFF_B                                     (0x7FFF0000u)
#define VDC6_SC0_SCL1_WR9_SC0_RES_LN_OFF_B_SHIFT                               (16u)
#define VDC6_SC0_SCL1_WR10_SC0_RES_FLM_OFF_B                                   (0x007FFFFFu)
#define VDC6_SC0_SCL1_WR10_SC0_RES_FLM_OFF_B_SHIFT                             (0u)
#define VDC6_SC0_SCL1_WR11_SC0_RES_FLM_CNT_B                                   (0x000003FFu)
#define VDC6_SC0_SCL1_WR11_SC0_RES_FLM_CNT_B_SHIFT                             (0u)
#define VDC6_SC0_SCL1_MON1_SC0_PBUF_NUM                                        (0x00000300u)
#define VDC6_SC0_SCL1_MON1_SC0_PBUF_NUM_SHIFT                                  (8u)
#define VDC6_SC0_SCL1_PBUF0_SC0_PBUF0_ADD                                      (0xFFFFFFFFu)
#define VDC6_SC0_SCL1_PBUF0_SC0_PBUF0_ADD_SHIFT                                (0u)
#define VDC6_SC0_SCL1_PBUF1_SC0_PBUF1_ADD                                      (0xFFFFFFFFu)
#define VDC6_SC0_SCL1_PBUF1_SC0_PBUF1_ADD_SHIFT                                (0u)
#define VDC6_SC0_SCL1_PBUF2_SC0_PBUF2_ADD                                      (0xFFFFFFFFu)
#define VDC6_SC0_SCL1_PBUF2_SC0_PBUF2_ADD_SHIFT                                (0u)
#define VDC6_SC0_SCL1_PBUF3_SC0_PBUF3_ADD                                      (0xFFFFFFFFu)
#define VDC6_SC0_SCL1_PBUF3_SC0_PBUF3_ADD_SHIFT                                (0u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF0                                    (0x00000001u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF0_SHIFT                              (0u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF1                                    (0x00000100u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF1_SHIFT                              (8u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF2                                    (0x00010000u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF2_SHIFT                              (16u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF3                                    (0x01000000u)
#define VDC6_SC0_SCL1_PBUF_FLD_SC0_FLD_INF3_SHIFT                              (24u)
#define VDC6_SC0_SCL1_PBUF_CNT_SC0_PBUF_RST                                    (0x00010000u)
#define VDC6_SC0_SCL1_PBUF_CNT_SC0_PBUF_RST_SHIFT                              (16u)
#define VDC6_GR0_UPDATE_GR0_IBUS_VEN                                           (0x00000001u)
#define VDC6_GR0_UPDATE_GR0_IBUS_VEN_SHIFT                                     (0u)
#define VDC6_GR0_UPDATE_GR0_P_VEN                                              (0x00000010u)
#define VDC6_GR0_UPDATE_GR0_P_VEN_SHIFT                                        (4u)
#define VDC6_GR0_UPDATE_GR0_UPDATE                                             (0x00000100u)
#define VDC6_GR0_UPDATE_GR0_UPDATE_SHIFT                                       (8u)
#define VDC6_GR0_FLM_RD_GR0_R_ENB                                              (0x00000001u)
#define VDC6_GR0_FLM_RD_GR0_R_ENB_SHIFT                                        (0u)
#define VDC6_GR0_FLM1_GR0_BST_MD                                               (0x00000001u)
#define VDC6_GR0_FLM1_GR0_BST_MD_SHIFT                                         (0u)
#define VDC6_GR0_FLM1_GR0_IMR_FLM_INV                                          (0x00000010u)
#define VDC6_GR0_FLM1_GR0_IMR_FLM_INV_SHIFT                                    (4u)
#define VDC6_GR0_FLM1_GR0_FLM_SEL                                              (0x00000300u)
#define VDC6_GR0_FLM1_GR0_FLM_SEL_SHIFT                                        (8u)
#define VDC6_GR0_FLM1_GR0_LN_OFF_DIR                                           (0x00010000u)
#define VDC6_GR0_FLM1_GR0_LN_OFF_DIR_SHIFT                                     (16u)
#define VDC6_GR0_FLM1_GR0_FLD_SEL                                              (0x80000000u)
#define VDC6_GR0_FLM1_GR0_FLD_SEL_SHIFT                                        (31u)
#define VDC6_GR0_FLM2_GR0_BASE                                                 (0xFFFFFFFFu)
#define VDC6_GR0_FLM2_GR0_BASE_SHIFT                                           (0u)
#define VDC6_GR0_FLM3_GR0_FLM_NUM                                              (0x000003FFu)
#define VDC6_GR0_FLM3_GR0_FLM_NUM_SHIFT                                        (0u)
#define VDC6_GR0_FLM3_GR0_LN_OFF                                               (0x7FFF0000u)
#define VDC6_GR0_FLM3_GR0_LN_OFF_SHIFT                                         (16u)
#define VDC6_GR0_FLM3_GR0_FLD_NXT                                              (0x80000000u)
#define VDC6_GR0_FLM3_GR0_FLD_NXT_SHIFT                                        (31u)
#define VDC6_GR0_FLM4_GR0_FLM_OFF                                              (0x007FFFFFu)
#define VDC6_GR0_FLM4_GR0_FLM_OFF_SHIFT                                        (0u)
#define VDC6_GR0_FLM5_GR0_FLM_LOOP                                             (0x000007FFu)
#define VDC6_GR0_FLM5_GR0_FLM_LOOP_SHIFT                                       (0u)
#define VDC6_GR0_FLM5_GR0_FLM_LNUM                                             (0x07FF0000u)
#define VDC6_GR0_FLM5_GR0_FLM_LNUM_SHIFT                                       (16u)
#define VDC6_GR0_FLM6_GR0_STA_POS                                              (0x0000003Fu)
#define VDC6_GR0_FLM6_GR0_STA_POS_SHIFT                                        (0u)
#define VDC6_GR0_FLM6_GR0_CNV444_MD                                            (0x00000100u)
#define VDC6_GR0_FLM6_GR0_CNV444_MD_SHIFT                                      (8u)
#define VDC6_GR0_FLM6_GR0_RDSWA                                                (0x00001C00u)
#define VDC6_GR0_FLM6_GR0_RDSWA_SHIFT                                          (10u)
#define VDC6_GR0_FLM6_GR0_YCC_SWAP                                             (0x0000E000u)
#define VDC6_GR0_FLM6_GR0_YCC_SWAP_SHIFT                                       (13u)
#define VDC6_GR0_FLM6_GR0_HW                                                   (0x07FF0000u)
#define VDC6_GR0_FLM6_GR0_HW_SHIFT                                             (16u)
#define VDC6_GR0_FLM6_GR0_FORMAT                                               (0xF0000000u)
#define VDC6_GR0_FLM6_GR0_FORMAT_SHIFT                                         (28u)
#define VDC6_GR0_AB1_GR0_DISP_SEL                                              (0x00000003u)
#define VDC6_GR0_AB1_GR0_DISP_SEL_SHIFT                                        (0u)
#define VDC6_GR0_AB1_GR0_GRC_DISP_ON                                           (0x00000010u)
#define VDC6_GR0_AB1_GR0_GRC_DISP_ON_SHIFT                                     (4u)
#define VDC6_GR0_AB2_GR0_GRC_VW                                                (0x000007FFu)
#define VDC6_GR0_AB2_GR0_GRC_VW_SHIFT                                          (0u)
#define VDC6_GR0_AB2_GR0_GRC_VS                                                (0x07FF0000u)
#define VDC6_GR0_AB2_GR0_GRC_VS_SHIFT                                          (16u)
#define VDC6_GR0_AB3_GR0_GRC_HW                                                (0x000007FFu)
#define VDC6_GR0_AB3_GR0_GRC_HW_SHIFT                                          (0u)
#define VDC6_GR0_AB3_GR0_GRC_HS                                                (0x07FF0000u)
#define VDC6_GR0_AB3_GR0_GRC_HS_SHIFT                                          (16u)
#define VDC6_GR0_AB7_GR0_CK_ON                                                 (0x00000001u)
#define VDC6_GR0_AB7_GR0_CK_ON_SHIFT                                           (0u)
#define VDC6_GR0_AB8_GR0_CK_KR                                                 (0x000000FFu)
#define VDC6_GR0_AB8_GR0_CK_KR_SHIFT                                           (0u)
#define VDC6_GR0_AB8_GR0_CK_KB                                                 (0x0000FF00u)
#define VDC6_GR0_AB8_GR0_CK_KB_SHIFT                                           (8u)
#define VDC6_GR0_AB8_GR0_CK_KG                                                 (0x00FF0000u)
#define VDC6_GR0_AB8_GR0_CK_KG_SHIFT                                           (16u)
#define VDC6_GR0_AB8_GR0_CK_KCLUT                                              (0xFF000000u)
#define VDC6_GR0_AB8_GR0_CK_KCLUT_SHIFT                                        (24u)
#define VDC6_GR0_AB9_GR0_CK_R                                                  (0x000000FFu)
#define VDC6_GR0_AB9_GR0_CK_R_SHIFT                                            (0u)
#define VDC6_GR0_AB9_GR0_CK_B                                                  (0x0000FF00u)
#define VDC6_GR0_AB9_GR0_CK_B_SHIFT                                            (8u)
#define VDC6_GR0_AB9_GR0_CK_G                                                  (0x00FF0000u)
#define VDC6_GR0_AB9_GR0_CK_G_SHIFT                                            (16u)
#define VDC6_GR0_AB9_GR0_CK_A                                                  (0xFF000000u)
#define VDC6_GR0_AB9_GR0_CK_A_SHIFT                                            (24u)
#define VDC6_GR0_AB10_GR0_R0                                                   (0x000000FFu)
#define VDC6_GR0_AB10_GR0_R0_SHIFT                                             (0u)
#define VDC6_GR0_AB10_GR0_B0                                                   (0x0000FF00u)
#define VDC6_GR0_AB10_GR0_B0_SHIFT                                             (8u)
#define VDC6_GR0_AB10_GR0_G0                                                   (0x00FF0000u)
#define VDC6_GR0_AB10_GR0_G0_SHIFT                                             (16u)
#define VDC6_GR0_AB10_GR0_A0                                                   (0xFF000000u)
#define VDC6_GR0_AB10_GR0_A0_SHIFT                                             (24u)
#define VDC6_GR0_AB11_GR0_R1                                                   (0x000000FFu)
#define VDC6_GR0_AB11_GR0_R1_SHIFT                                             (0u)
#define VDC6_GR0_AB11_GR0_B1                                                   (0x0000FF00u)
#define VDC6_GR0_AB11_GR0_B1_SHIFT                                             (8u)
#define VDC6_GR0_AB11_GR0_G1                                                   (0x00FF0000u)
#define VDC6_GR0_AB11_GR0_G1_SHIFT                                             (16u)
#define VDC6_GR0_AB11_GR0_A1                                                   (0xFF000000u)
#define VDC6_GR0_AB11_GR0_A1_SHIFT                                             (24u)
#define VDC6_GR0_BASE_GR0_BASE_R                                               (0x000000FFu)
#define VDC6_GR0_BASE_GR0_BASE_R_SHIFT                                         (0u)
#define VDC6_GR0_BASE_GR0_BASE_B                                               (0x0000FF00u)
#define VDC6_GR0_BASE_GR0_BASE_B_SHIFT                                         (8u)
#define VDC6_GR0_BASE_GR0_BASE_G                                               (0x00FF0000u)
#define VDC6_GR0_BASE_GR0_BASE_G_SHIFT                                         (16u)
#define VDC6_GR0_CLUT_GR0_CLT_SEL                                              (0x00010000u)
#define VDC6_GR0_CLUT_GR0_CLT_SEL_SHIFT                                        (16u)
#define VDC6_ADJ0_UPDATE_ADJ0_VEN                                              (0x00000001u)
#define VDC6_ADJ0_UPDATE_ADJ0_VEN_SHIFT                                        (0u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_T2                                           (0x0000001Fu)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_T2_SHIFT                                     (0u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_T1                                           (0x00001F00u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_T1_SHIFT                                     (8u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_D                                            (0x000F0000u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_D_SHIFT                                      (16u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_ST                                           (0x00F00000u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_ST_SHIFT                                     (20u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_ON                                           (0x01000000u)
#define VDC6_ADJ0_BKSTR_SET_BKSTR_ON_SHIFT                                     (24u)
#define VDC6_ADJ0_ENH_TIM1_ENH_DISP_ON                                         (0x00000001u)
#define VDC6_ADJ0_ENH_TIM1_ENH_DISP_ON_SHIFT                                   (0u)
#define VDC6_ADJ0_ENH_TIM1_ENH_MD                                              (0x00000010u)
#define VDC6_ADJ0_ENH_TIM1_ENH_MD_SHIFT                                        (4u)
#define VDC6_ADJ0_ENH_TIM2_ENH_VW                                              (0x000007FFu)
#define VDC6_ADJ0_ENH_TIM2_ENH_VW_SHIFT                                        (0u)
#define VDC6_ADJ0_ENH_TIM2_ENH_VS                                              (0x07FF0000u)
#define VDC6_ADJ0_ENH_TIM2_ENH_VS_SHIFT                                        (16u)
#define VDC6_ADJ0_ENH_TIM3_ENH_HW                                              (0x000007FFu)
#define VDC6_ADJ0_ENH_TIM3_ENH_HW_SHIFT                                        (0u)
#define VDC6_ADJ0_ENH_TIM3_ENH_HS                                              (0x07FF0000u)
#define VDC6_ADJ0_ENH_TIM3_ENH_HS_SHIFT                                        (16u)
#define VDC6_ADJ0_ENH_SHP1_SHP_H1_CORE                                         (0x0000007Fu)
#define VDC6_ADJ0_ENH_SHP1_SHP_H1_CORE_SHIFT                                   (0u)
#define VDC6_ADJ0_ENH_SHP1_SHP_H_ON                                            (0x00010000u)
#define VDC6_ADJ0_ENH_SHP1_SHP_H_ON_SHIFT                                      (16u)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_GAIN_U                                       (0x000000FFu)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_GAIN_U_SHIFT                                 (0u)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_GAIN_O                                       (0x0000FF00u)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_GAIN_O_SHIFT                                 (8u)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_CLIP_U                                       (0x00FF0000u)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_CLIP_U_SHIFT                                 (16u)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_CLIP_O                                       (0xFF000000u)
#define VDC6_ADJ0_ENH_SHP2_SHP_H1_CLIP_O_SHIFT                                 (24u)
#define VDC6_ADJ0_ENH_SHP3_SHP_H2_CORE                                         (0x0000007Fu)
#define VDC6_ADJ0_ENH_SHP3_SHP_H2_CORE_SHIFT                                   (0u)
#define VDC6_ADJ0_ENH_SHP3_SHP_H2_LPF_SEL                                      (0x00010000u)
#define VDC6_ADJ0_ENH_SHP3_SHP_H2_LPF_SEL_SHIFT                                (16u)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_GAIN_U                                       (0x000000FFu)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_GAIN_U_SHIFT                                 (0u)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_GAIN_O                                       (0x0000FF00u)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_GAIN_O_SHIFT                                 (8u)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_CLIP_U                                       (0x00FF0000u)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_CLIP_U_SHIFT                                 (16u)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_CLIP_O                                       (0xFF000000u)
#define VDC6_ADJ0_ENH_SHP4_SHP_H2_CLIP_O_SHIFT                                 (24u)
#define VDC6_ADJ0_ENH_SHP5_SHP_H3_CORE                                         (0x0000007Fu)
#define VDC6_ADJ0_ENH_SHP5_SHP_H3_CORE_SHIFT                                   (0u)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_GAIN_U                                       (0x000000FFu)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_GAIN_U_SHIFT                                 (0u)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_GAIN_O                                       (0x0000FF00u)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_GAIN_O_SHIFT                                 (8u)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_CLIP_U                                       (0x00FF0000u)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_CLIP_U_SHIFT                                 (16u)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_CLIP_O                                       (0xFF000000u)
#define VDC6_ADJ0_ENH_SHP6_SHP_H3_CLIP_O_SHIFT                                 (24u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_CORE                                         (0x000000FFu)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_CORE_SHIFT                                   (0u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_GAIN                                         (0x0000FF00u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_GAIN_SHIFT                                   (8u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_INC_ZERO                                     (0x00FF0000u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_INC_ZERO_SHIFT                               (16u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_LPF_SEL                                      (0x01000000u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H2_LPF_SEL_SHIFT                                (24u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H_ON                                            (0x80000000u)
#define VDC6_ADJ0_ENH_LTI1_LTI_H_ON_SHIFT                                      (31u)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_CORE                                         (0x000000FFu)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_CORE_SHIFT                                   (0u)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_GAIN                                         (0x0000FF00u)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_GAIN_SHIFT                                   (8u)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_INC_ZERO                                     (0x00FF0000u)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_INC_ZERO_SHIFT                               (16u)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_MEDIAN_TAP_SEL                               (0x01000000u)
#define VDC6_ADJ0_ENH_LTI2_LTI_H4_MEDIAN_TAP_SEL_SHIFT                         (24u)
#define VDC6_ADJ0_MTX_MODE_ADJ0_MTX_MD                                         (0x00000003u)
#define VDC6_ADJ0_MTX_MODE_ADJ0_MTX_MD_SHIFT                                   (0u)
#define VDC6_ADJ0_MTX_YG_ADJ0_ADJ0_MTX_GG                                      (0x000007FFu)
#define VDC6_ADJ0_MTX_YG_ADJ0_ADJ0_MTX_GG_SHIFT                                (0u)
#define VDC6_ADJ0_MTX_YG_ADJ0_ADJ0_MTX_YG                                      (0x00FF0000u)
#define VDC6_ADJ0_MTX_YG_ADJ0_ADJ0_MTX_YG_SHIFT                                (16u)
#define VDC6_ADJ0_MTX_YG_ADJ1_ADJ0_MTX_GR                                      (0x000007FFu)
#define VDC6_ADJ0_MTX_YG_ADJ1_ADJ0_MTX_GR_SHIFT                                (0u)
#define VDC6_ADJ0_MTX_YG_ADJ1_ADJ0_MTX_GB                                      (0x07FF0000u)
#define VDC6_ADJ0_MTX_YG_ADJ1_ADJ0_MTX_GB_SHIFT                                (16u)
#define VDC6_ADJ0_MTX_CBB_ADJ0_ADJ0_MTX_BG                                     (0x000007FFu)
#define VDC6_ADJ0_MTX_CBB_ADJ0_ADJ0_MTX_BG_SHIFT                               (0u)
#define VDC6_ADJ0_MTX_CBB_ADJ0_ADJ0_MTX_B                                      (0x00FF0000u)
#define VDC6_ADJ0_MTX_CBB_ADJ0_ADJ0_MTX_B_SHIFT                                (16u)
#define VDC6_ADJ0_MTX_CBB_ADJ1_ADJ0_MTX_BR                                     (0x000007FFu)
#define VDC6_ADJ0_MTX_CBB_ADJ1_ADJ0_MTX_BR_SHIFT                               (0u)
#define VDC6_ADJ0_MTX_CBB_ADJ1_ADJ0_MTX_BB                                     (0x07FF0000u)
#define VDC6_ADJ0_MTX_CBB_ADJ1_ADJ0_MTX_BB_SHIFT                               (16u)
#define VDC6_ADJ0_MTX_CRR_ADJ0_ADJ0_MTX_RG                                     (0x000007FFu)
#define VDC6_ADJ0_MTX_CRR_ADJ0_ADJ0_MTX_RG_SHIFT                               (0u)
#define VDC6_ADJ0_MTX_CRR_ADJ0_ADJ0_MTX_R                                      (0x00FF0000u)
#define VDC6_ADJ0_MTX_CRR_ADJ0_ADJ0_MTX_R_SHIFT                                (16u)
#define VDC6_ADJ0_MTX_CRR_ADJ1_ADJ0_MTX_RR                                     (0x000007FFu)
#define VDC6_ADJ0_MTX_CRR_ADJ1_ADJ0_MTX_RR_SHIFT                               (0u)
#define VDC6_ADJ0_MTX_CRR_ADJ1_ADJ0_MTX_RB                                     (0x07FF0000u)
#define VDC6_ADJ0_MTX_CRR_ADJ1_ADJ0_MTX_RB_SHIFT                               (16u)
#define VDC6_GR2_UPDATE_GR2_IBUS_VEN                                           (0x00000001u)
#define VDC6_GR2_UPDATE_GR2_IBUS_VEN_SHIFT                                     (0u)
#define VDC6_GR2_UPDATE_GR2_P_VEN                                              (0x00000010u)
#define VDC6_GR2_UPDATE_GR2_P_VEN_SHIFT                                        (4u)
#define VDC6_GR2_UPDATE_GR2_UPDATE                                             (0x00000100u)
#define VDC6_GR2_UPDATE_GR2_UPDATE_SHIFT                                       (8u)
#define VDC6_GR2_FLM_RD_GR2_R_ENB                                              (0x00000001u)
#define VDC6_GR2_FLM_RD_GR2_R_ENB_SHIFT                                        (0u)
#define VDC6_GR2_FLM1_GR2_BST_MD                                               (0x00000001u)
#define VDC6_GR2_FLM1_GR2_BST_MD_SHIFT                                         (0u)
#define VDC6_GR2_FLM1_GR2_FLM_SEL                                              (0x00000300u)
#define VDC6_GR2_FLM1_GR2_FLM_SEL_SHIFT                                        (8u)
#define VDC6_GR2_FLM1_GR2_LN_OFF_DIR                                           (0x00010000u)
#define VDC6_GR2_FLM1_GR2_LN_OFF_DIR_SHIFT                                     (16u)
#define VDC6_GR2_FLM2_GR2_BASE                                                 (0xFFFFFFFFu)
#define VDC6_GR2_FLM2_GR2_BASE_SHIFT                                           (0u)
#define VDC6_GR2_FLM3_GR2_FLM_NUM                                              (0x000003FFu)
#define VDC6_GR2_FLM3_GR2_FLM_NUM_SHIFT                                        (0u)
#define VDC6_GR2_FLM3_GR2_LN_OFF                                               (0x7FFF0000u)
#define VDC6_GR2_FLM3_GR2_LN_OFF_SHIFT                                         (16u)
#define VDC6_GR2_FLM4_GR2_FLM_OFF                                              (0x007FFFFFu)
#define VDC6_GR2_FLM4_GR2_FLM_OFF_SHIFT                                        (0u)
#define VDC6_GR2_FLM5_GR2_FLM_LOOP                                             (0x000007FFu)
#define VDC6_GR2_FLM5_GR2_FLM_LOOP_SHIFT                                       (0u)
#define VDC6_GR2_FLM5_GR2_FLM_LNUM                                             (0x07FF0000u)
#define VDC6_GR2_FLM5_GR2_FLM_LNUM_SHIFT                                       (16u)
#define VDC6_GR2_FLM6_GR2_STA_POS                                              (0x0000003Fu)
#define VDC6_GR2_FLM6_GR2_STA_POS_SHIFT                                        (0u)
#define VDC6_GR2_FLM6_GR2_RDSWA                                                (0x00001C00u)
#define VDC6_GR2_FLM6_GR2_RDSWA_SHIFT                                          (10u)
#define VDC6_GR2_FLM6_GR2_HW                                                   (0x07FF0000u)
#define VDC6_GR2_FLM6_GR2_HW_SHIFT                                             (16u)
#define VDC6_GR2_FLM6_GR2_FORMAT                                               (0xF0000000u)
#define VDC6_GR2_FLM6_GR2_FORMAT_SHIFT                                         (28u)
#define VDC6_GR2_AB1_GR2_DISP_SEL                                              (0x00000003u)
#define VDC6_GR2_AB1_GR2_DISP_SEL_SHIFT                                        (0u)
#define VDC6_GR2_AB1_GR2_GRC_DISP_ON                                           (0x00000010u)
#define VDC6_GR2_AB1_GR2_GRC_DISP_ON_SHIFT                                     (4u)
#define VDC6_GR2_AB1_GR2_ARC_DISP_ON                                           (0x00000100u)
#define VDC6_GR2_AB1_GR2_ARC_DISP_ON_SHIFT                                     (8u)
#define VDC6_GR2_AB1_GR2_ARC_ON                                                (0x00001000u)
#define VDC6_GR2_AB1_GR2_ARC_ON_SHIFT                                          (12u)
#define VDC6_GR2_AB1_GR2_ACALC_MD                                              (0x00004000u)
#define VDC6_GR2_AB1_GR2_ACALC_MD_SHIFT                                        (14u)
#define VDC6_GR2_AB1_GR2_ARC_MUL                                               (0x00008000u)
#define VDC6_GR2_AB1_GR2_ARC_MUL_SHIFT                                         (15u)
#define VDC6_GR2_AB2_GR2_GRC_VW                                                (0x000007FFu)
#define VDC6_GR2_AB2_GR2_GRC_VW_SHIFT                                          (0u)
#define VDC6_GR2_AB2_GR2_GRC_VS                                                (0x07FF0000u)
#define VDC6_GR2_AB2_GR2_GRC_VS_SHIFT                                          (16u)
#define VDC6_GR2_AB3_GR2_GRC_HW                                                (0x000007FFu)
#define VDC6_GR2_AB3_GR2_GRC_HW_SHIFT                                          (0u)
#define VDC6_GR2_AB3_GR2_GRC_HS                                                (0x07FF0000u)
#define VDC6_GR2_AB3_GR2_GRC_HS_SHIFT                                          (16u)
#define VDC6_GR2_AB4_GR2_ARC_VW                                                (0x000007FFu)
#define VDC6_GR2_AB4_GR2_ARC_VW_SHIFT                                          (0u)
#define VDC6_GR2_AB4_GR2_ARC_VS                                                (0x07FF0000u)
#define VDC6_GR2_AB4_GR2_ARC_VS_SHIFT                                          (16u)
#define VDC6_GR2_AB5_GR2_ARC_HW                                                (0x000007FFu)
#define VDC6_GR2_AB5_GR2_ARC_HW_SHIFT                                          (0u)
#define VDC6_GR2_AB5_GR2_ARC_HS                                                (0x07FF0000u)
#define VDC6_GR2_AB5_GR2_ARC_HS_SHIFT                                          (16u)
#define VDC6_GR2_AB6_GR2_ARC_RATE                                              (0x000000FFu)
#define VDC6_GR2_AB6_GR2_ARC_RATE_SHIFT                                        (0u)
#define VDC6_GR2_AB6_GR2_ARC_COEF                                              (0x00FF0000u)
#define VDC6_GR2_AB6_GR2_ARC_COEF_SHIFT                                        (16u)
#define VDC6_GR2_AB6_GR2_ARC_MODE                                              (0x01000000u)
#define VDC6_GR2_AB6_GR2_ARC_MODE_SHIFT                                        (24u)
#define VDC6_GR2_AB7_GR2_CK_ON                                                 (0x00000001u)
#define VDC6_GR2_AB7_GR2_CK_ON_SHIFT                                           (0u)
#define VDC6_GR2_AB7_GR2_ARC_DEF                                               (0x00FF0000u)
#define VDC6_GR2_AB7_GR2_ARC_DEF_SHIFT                                         (16u)
#define VDC6_GR2_AB8_GR2_CK_KR                                                 (0x000000FFu)
#define VDC6_GR2_AB8_GR2_CK_KR_SHIFT                                           (0u)
#define VDC6_GR2_AB8_GR2_CK_KB                                                 (0x0000FF00u)
#define VDC6_GR2_AB8_GR2_CK_KB_SHIFT                                           (8u)
#define VDC6_GR2_AB8_GR2_CK_KG                                                 (0x00FF0000u)
#define VDC6_GR2_AB8_GR2_CK_KG_SHIFT                                           (16u)
#define VDC6_GR2_AB8_GR2_CK_KCLUT                                              (0xFF000000u)
#define VDC6_GR2_AB8_GR2_CK_KCLUT_SHIFT                                        (24u)
#define VDC6_GR2_AB9_GR2_CK_R                                                  (0x000000FFu)
#define VDC6_GR2_AB9_GR2_CK_R_SHIFT                                            (0u)
#define VDC6_GR2_AB9_GR2_CK_B                                                  (0x0000FF00u)
#define VDC6_GR2_AB9_GR2_CK_B_SHIFT                                            (8u)
#define VDC6_GR2_AB9_GR2_CK_G                                                  (0x00FF0000u)
#define VDC6_GR2_AB9_GR2_CK_G_SHIFT                                            (16u)
#define VDC6_GR2_AB9_GR2_CK_A                                                  (0xFF000000u)
#define VDC6_GR2_AB9_GR2_CK_A_SHIFT                                            (24u)
#define VDC6_GR2_AB10_GR2_R0                                                   (0x000000FFu)
#define VDC6_GR2_AB10_GR2_R0_SHIFT                                             (0u)
#define VDC6_GR2_AB10_GR2_B0                                                   (0x0000FF00u)
#define VDC6_GR2_AB10_GR2_B0_SHIFT                                             (8u)
#define VDC6_GR2_AB10_GR2_G0                                                   (0x00FF0000u)
#define VDC6_GR2_AB10_GR2_G0_SHIFT                                             (16u)
#define VDC6_GR2_AB10_GR2_A0                                                   (0xFF000000u)
#define VDC6_GR2_AB10_GR2_A0_SHIFT                                             (24u)
#define VDC6_GR2_AB11_GR2_R1                                                   (0x000000FFu)
#define VDC6_GR2_AB11_GR2_R1_SHIFT                                             (0u)
#define VDC6_GR2_AB11_GR2_B1                                                   (0x0000FF00u)
#define VDC6_GR2_AB11_GR2_B1_SHIFT                                             (8u)
#define VDC6_GR2_AB11_GR2_G1                                                   (0x00FF0000u)
#define VDC6_GR2_AB11_GR2_G1_SHIFT                                             (16u)
#define VDC6_GR2_AB11_GR2_A1                                                   (0xFF000000u)
#define VDC6_GR2_AB11_GR2_A1_SHIFT                                             (24u)
#define VDC6_GR2_BASE_GR2_BASE_R                                               (0x000000FFu)
#define VDC6_GR2_BASE_GR2_BASE_R_SHIFT                                         (0u)
#define VDC6_GR2_BASE_GR2_BASE_B                                               (0x0000FF00u)
#define VDC6_GR2_BASE_GR2_BASE_B_SHIFT                                         (8u)
#define VDC6_GR2_BASE_GR2_BASE_G                                               (0x00FF0000u)
#define VDC6_GR2_BASE_GR2_BASE_G_SHIFT                                         (16u)
#define VDC6_GR2_CLUT_GR2_CLT_SEL                                              (0x00010000u)
#define VDC6_GR2_CLUT_GR2_CLT_SEL_SHIFT                                        (16u)
#define VDC6_GR2_MON_GR2_ARC_ST                                                (0x00000001u)
#define VDC6_GR2_MON_GR2_ARC_ST_SHIFT                                          (0u)
#define VDC6_GR3_UPDATE_GR3_IBUS_VEN                                           (0x00000001u)
#define VDC6_GR3_UPDATE_GR3_IBUS_VEN_SHIFT                                     (0u)
#define VDC6_GR3_UPDATE_GR3_P_VEN                                              (0x00000010u)
#define VDC6_GR3_UPDATE_GR3_P_VEN_SHIFT                                        (4u)
#define VDC6_GR3_UPDATE_GR3_UPDATE                                             (0x00000100u)
#define VDC6_GR3_UPDATE_GR3_UPDATE_SHIFT                                       (8u)
#define VDC6_GR3_FLM_RD_GR3_R_ENB                                              (0x00000001u)
#define VDC6_GR3_FLM_RD_GR3_R_ENB_SHIFT                                        (0u)
#define VDC6_GR3_FLM1_GR3_BST_MD                                               (0x00000001u)
#define VDC6_GR3_FLM1_GR3_BST_MD_SHIFT                                         (0u)
#define VDC6_GR3_FLM1_GR3_FLM_SEL                                              (0x00000300u)
#define VDC6_GR3_FLM1_GR3_FLM_SEL_SHIFT                                        (8u)
#define VDC6_GR3_FLM1_GR3_LN_OFF_DIR                                           (0x00010000u)
#define VDC6_GR3_FLM1_GR3_LN_OFF_DIR_SHIFT                                     (16u)
#define VDC6_GR3_FLM2_GR3_BASE                                                 (0xFFFFFFFFu)
#define VDC6_GR3_FLM2_GR3_BASE_SHIFT                                           (0u)
#define VDC6_GR3_FLM3_GR3_FLM_NUM                                              (0x000003FFu)
#define VDC6_GR3_FLM3_GR3_FLM_NUM_SHIFT                                        (0u)
#define VDC6_GR3_FLM3_GR3_LN_OFF                                               (0x7FFF0000u)
#define VDC6_GR3_FLM3_GR3_LN_OFF_SHIFT                                         (16u)
#define VDC6_GR3_FLM4_GR3_FLM_OFF                                              (0x007FFFFFu)
#define VDC6_GR3_FLM4_GR3_FLM_OFF_SHIFT                                        (0u)
#define VDC6_GR3_FLM5_GR3_FLM_LOOP                                             (0x000007FFu)
#define VDC6_GR3_FLM5_GR3_FLM_LOOP_SHIFT                                       (0u)
#define VDC6_GR3_FLM5_GR3_FLM_LNUM                                             (0x07FF0000u)
#define VDC6_GR3_FLM5_GR3_FLM_LNUM_SHIFT                                       (16u)
#define VDC6_GR3_FLM6_GR3_STA_POS                                              (0x0000003Fu)
#define VDC6_GR3_FLM6_GR3_STA_POS_SHIFT                                        (0u)
#define VDC6_GR3_FLM6_GR3_RDSWA                                                (0x00001C00u)
#define VDC6_GR3_FLM6_GR3_RDSWA_SHIFT                                          (10u)
#define VDC6_GR3_FLM6_GR3_HW                                                   (0x07FF0000u)
#define VDC6_GR3_FLM6_GR3_HW_SHIFT                                             (16u)
#define VDC6_GR3_FLM6_GR3_FORMAT                                               (0xF0000000u)
#define VDC6_GR3_FLM6_GR3_FORMAT_SHIFT                                         (28u)
#define VDC6_GR3_AB1_GR3_DISP_SEL                                              (0x00000003u)
#define VDC6_GR3_AB1_GR3_DISP_SEL_SHIFT                                        (0u)
#define VDC6_GR3_AB1_GR3_GRC_DISP_ON                                           (0x00000010u)
#define VDC6_GR3_AB1_GR3_GRC_DISP_ON_SHIFT                                     (4u)
#define VDC6_GR3_AB1_GR3_ARC_DISP_ON                                           (0x00000100u)
#define VDC6_GR3_AB1_GR3_ARC_DISP_ON_SHIFT                                     (8u)
#define VDC6_GR3_AB1_GR3_ARC_ON                                                (0x00001000u)
#define VDC6_GR3_AB1_GR3_ARC_ON_SHIFT                                          (12u)
#define VDC6_GR3_AB1_GR3_ACALC_MD                                              (0x00004000u)
#define VDC6_GR3_AB1_GR3_ACALC_MD_SHIFT                                        (14u)
#define VDC6_GR3_AB1_GR3_ARC_MUL                                               (0x00008000u)
#define VDC6_GR3_AB1_GR3_ARC_MUL_SHIFT                                         (15u)
#define VDC6_GR3_AB2_GR3_GRC_VW                                                (0x000007FFu)
#define VDC6_GR3_AB2_GR3_GRC_VW_SHIFT                                          (0u)
#define VDC6_GR3_AB2_GR3_GRC_VS                                                (0x07FF0000u)
#define VDC6_GR3_AB2_GR3_GRC_VS_SHIFT                                          (16u)
#define VDC6_GR3_AB3_GR3_GRC_HW                                                (0x000007FFu)
#define VDC6_GR3_AB3_GR3_GRC_HW_SHIFT                                          (0u)
#define VDC6_GR3_AB3_GR3_GRC_HS                                                (0x07FF0000u)
#define VDC6_GR3_AB3_GR3_GRC_HS_SHIFT                                          (16u)
#define VDC6_GR3_AB4_GR3_ARC_VW                                                (0x000007FFu)
#define VDC6_GR3_AB4_GR3_ARC_VW_SHIFT                                          (0u)
#define VDC6_GR3_AB4_GR3_ARC_VS                                                (0x07FF0000u)
#define VDC6_GR3_AB4_GR3_ARC_VS_SHIFT                                          (16u)
#define VDC6_GR3_AB5_GR3_ARC_HW                                                (0x000007FFu)
#define VDC6_GR3_AB5_GR3_ARC_HW_SHIFT                                          (0u)
#define VDC6_GR3_AB5_GR3_ARC_HS                                                (0x07FF0000u)
#define VDC6_GR3_AB5_GR3_ARC_HS_SHIFT                                          (16u)
#define VDC6_GR3_AB6_GR3_ARC_RATE                                              (0x000000FFu)
#define VDC6_GR3_AB6_GR3_ARC_RATE_SHIFT                                        (0u)
#define VDC6_GR3_AB6_GR3_ARC_COEF                                              (0x00FF0000u)
#define VDC6_GR3_AB6_GR3_ARC_COEF_SHIFT                                        (16u)
#define VDC6_GR3_AB6_GR3_ARC_MODE                                              (0x01000000u)
#define VDC6_GR3_AB6_GR3_ARC_MODE_SHIFT                                        (24u)
#define VDC6_GR3_AB7_GR3_CK_ON                                                 (0x00000001u)
#define VDC6_GR3_AB7_GR3_CK_ON_SHIFT                                           (0u)
#define VDC6_GR3_AB7_GR3_ARC_DEF                                               (0x00FF0000u)
#define VDC6_GR3_AB7_GR3_ARC_DEF_SHIFT                                         (16u)
#define VDC6_GR3_AB8_GR3_CK_KR                                                 (0x000000FFu)
#define VDC6_GR3_AB8_GR3_CK_KR_SHIFT                                           (0u)
#define VDC6_GR3_AB8_GR3_CK_KB                                                 (0x0000FF00u)
#define VDC6_GR3_AB8_GR3_CK_KB_SHIFT                                           (8u)
#define VDC6_GR3_AB8_GR3_CK_KG                                                 (0x00FF0000u)
#define VDC6_GR3_AB8_GR3_CK_KG_SHIFT                                           (16u)
#define VDC6_GR3_AB8_GR3_CK_KCLUT                                              (0xFF000000u)
#define VDC6_GR3_AB8_GR3_CK_KCLUT_SHIFT                                        (24u)
#define VDC6_GR3_AB9_GR3_CK_R                                                  (0x000000FFu)
#define VDC6_GR3_AB9_GR3_CK_R_SHIFT                                            (0u)
#define VDC6_GR3_AB9_GR3_CK_B                                                  (0x0000FF00u)
#define VDC6_GR3_AB9_GR3_CK_B_SHIFT                                            (8u)
#define VDC6_GR3_AB9_GR3_CK_G                                                  (0x00FF0000u)
#define VDC6_GR3_AB9_GR3_CK_G_SHIFT                                            (16u)
#define VDC6_GR3_AB9_GR3_CK_A                                                  (0xFF000000u)
#define VDC6_GR3_AB9_GR3_CK_A_SHIFT                                            (24u)
#define VDC6_GR3_AB10_GR3_R0                                                   (0x000000FFu)
#define VDC6_GR3_AB10_GR3_R0_SHIFT                                             (0u)
#define VDC6_GR3_AB10_GR3_B0                                                   (0x0000FF00u)
#define VDC6_GR3_AB10_GR3_B0_SHIFT                                             (8u)
#define VDC6_GR3_AB10_GR3_G0                                                   (0x00FF0000u)
#define VDC6_GR3_AB10_GR3_G0_SHIFT                                             (16u)
#define VDC6_GR3_AB10_GR3_A0                                                   (0xFF000000u)
#define VDC6_GR3_AB10_GR3_A0_SHIFT                                             (24u)
#define VDC6_GR3_AB11_GR3_R1                                                   (0x000000FFu)
#define VDC6_GR3_AB11_GR3_R1_SHIFT                                             (0u)
#define VDC6_GR3_AB11_GR3_B1                                                   (0x0000FF00u)
#define VDC6_GR3_AB11_GR3_B1_SHIFT                                             (8u)
#define VDC6_GR3_AB11_GR3_G1                                                   (0x00FF0000u)
#define VDC6_GR3_AB11_GR3_G1_SHIFT                                             (16u)
#define VDC6_GR3_AB11_GR3_A1                                                   (0xFF000000u)
#define VDC6_GR3_AB11_GR3_A1_SHIFT                                             (24u)
#define VDC6_GR3_BASE_GR3_BASE_R                                               (0x000000FFu)
#define VDC6_GR3_BASE_GR3_BASE_R_SHIFT                                         (0u)
#define VDC6_GR3_BASE_GR3_BASE_B                                               (0x0000FF00u)
#define VDC6_GR3_BASE_GR3_BASE_B_SHIFT                                         (8u)
#define VDC6_GR3_BASE_GR3_BASE_G                                               (0x00FF0000u)
#define VDC6_GR3_BASE_GR3_BASE_G_SHIFT                                         (16u)
#define VDC6_GR3_CLUT_INT_GR3_LINE                                             (0x000007FFu)
#define VDC6_GR3_CLUT_INT_GR3_LINE_SHIFT                                       (0u)
#define VDC6_GR3_CLUT_INT_GR3_CLT_SEL                                          (0x00010000u)
#define VDC6_GR3_CLUT_INT_GR3_CLT_SEL_SHIFT                                    (16u)
#define VDC6_GR3_MON_GR3_ARC_ST                                                (0x00000001u)
#define VDC6_GR3_MON_GR3_ARC_ST_SHIFT                                          (0u)
#define VDC6_GR3_MON_GR3_LIN_STAT                                              (0x07FF0000u)
#define VDC6_GR3_MON_GR3_LIN_STAT_SHIFT                                        (16u)
#define VDC6_GAM_G_UPDATE_GAM_G_VEN                                            (0x00000001u)
#define VDC6_GAM_G_UPDATE_GAM_G_VEN_SHIFT                                      (0u)
#define VDC6_GAM_SW_GAM_ON                                                     (0x00000001u)
#define VDC6_GAM_SW_GAM_ON_SHIFT                                               (0u)
#define VDC6_GAM_G_LUT1_GAM_G_GAIN_01                                          (0x000007FFu)
#define VDC6_GAM_G_LUT1_GAM_G_GAIN_01_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT1_GAM_G_GAIN_00                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT1_GAM_G_GAIN_00_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT2_GAM_G_GAIN_03                                          (0x000007FFu)
#define VDC6_GAM_G_LUT2_GAM_G_GAIN_03_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT2_GAM_G_GAIN_02                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT2_GAM_G_GAIN_02_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT3_GAM_G_GAIN_05                                          (0x000007FFu)
#define VDC6_GAM_G_LUT3_GAM_G_GAIN_05_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT3_GAM_G_GAIN_04                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT3_GAM_G_GAIN_04_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT4_GAM_G_GAIN_07                                          (0x000007FFu)
#define VDC6_GAM_G_LUT4_GAM_G_GAIN_07_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT4_GAM_G_GAIN_06                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT4_GAM_G_GAIN_06_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT5_GAM_G_GAIN_09                                          (0x000007FFu)
#define VDC6_GAM_G_LUT5_GAM_G_GAIN_09_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT5_GAM_G_GAIN_08                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT5_GAM_G_GAIN_08_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT6_GAM_G_GAIN_11                                          (0x000007FFu)
#define VDC6_GAM_G_LUT6_GAM_G_GAIN_11_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT6_GAM_G_GAIN_10                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT6_GAM_G_GAIN_10_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT7_GAM_G_GAIN_13                                          (0x000007FFu)
#define VDC6_GAM_G_LUT7_GAM_G_GAIN_13_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT7_GAM_G_GAIN_12                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT7_GAM_G_GAIN_12_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT8_GAM_G_GAIN_15                                          (0x000007FFu)
#define VDC6_GAM_G_LUT8_GAM_G_GAIN_15_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT8_GAM_G_GAIN_14                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT8_GAM_G_GAIN_14_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT9_GAM_G_GAIN_17                                          (0x000007FFu)
#define VDC6_GAM_G_LUT9_GAM_G_GAIN_17_SHIFT                                    (0u)
#define VDC6_GAM_G_LUT9_GAM_G_GAIN_16                                          (0x07FF0000u)
#define VDC6_GAM_G_LUT9_GAM_G_GAIN_16_SHIFT                                    (16u)
#define VDC6_GAM_G_LUT10_GAM_G_GAIN_19                                         (0x000007FFu)
#define VDC6_GAM_G_LUT10_GAM_G_GAIN_19_SHIFT                                   (0u)
#define VDC6_GAM_G_LUT10_GAM_G_GAIN_18                                         (0x07FF0000u)
#define VDC6_GAM_G_LUT10_GAM_G_GAIN_18_SHIFT                                   (16u)
#define VDC6_GAM_G_LUT11_GAM_G_GAIN_21                                         (0x000007FFu)
#define VDC6_GAM_G_LUT11_GAM_G_GAIN_21_SHIFT                                   (0u)
#define VDC6_GAM_G_LUT11_GAM_G_GAIN_20                                         (0x07FF0000u)
#define VDC6_GAM_G_LUT11_GAM_G_GAIN_20_SHIFT                                   (16u)
#define VDC6_GAM_G_LUT12_GAM_G_GAIN_23                                         (0x000007FFu)
#define VDC6_GAM_G_LUT12_GAM_G_GAIN_23_SHIFT                                   (0u)
#define VDC6_GAM_G_LUT12_GAM_G_GAIN_22                                         (0x07FF0000u)
#define VDC6_GAM_G_LUT12_GAM_G_GAIN_22_SHIFT                                   (16u)
#define VDC6_GAM_G_LUT13_GAM_G_GAIN_25                                         (0x000007FFu)
#define VDC6_GAM_G_LUT13_GAM_G_GAIN_25_SHIFT                                   (0u)
#define VDC6_GAM_G_LUT13_GAM_G_GAIN_24                                         (0x07FF0000u)
#define VDC6_GAM_G_LUT13_GAM_G_GAIN_24_SHIFT                                   (16u)
#define VDC6_GAM_G_LUT14_GAM_G_GAIN_27                                         (0x000007FFu)
#define VDC6_GAM_G_LUT14_GAM_G_GAIN_27_SHIFT                                   (0u)
#define VDC6_GAM_G_LUT14_GAM_G_GAIN_26                                         (0x07FF0000u)
#define VDC6_GAM_G_LUT14_GAM_G_GAIN_26_SHIFT                                   (16u)
#define VDC6_GAM_G_LUT15_GAM_G_GAIN_29                                         (0x000007FFu)
#define VDC6_GAM_G_LUT15_GAM_G_GAIN_29_SHIFT                                   (0u)
#define VDC6_GAM_G_LUT15_GAM_G_GAIN_28                                         (0x07FF0000u)
#define VDC6_GAM_G_LUT15_GAM_G_GAIN_28_SHIFT                                   (16u)
#define VDC6_GAM_G_LUT16_GAM_G_GAIN_31                                         (0x000007FFu)
#define VDC6_GAM_G_LUT16_GAM_G_GAIN_31_SHIFT                                   (0u)
#define VDC6_GAM_G_LUT16_GAM_G_GAIN_30                                         (0x07FF0000u)
#define VDC6_GAM_G_LUT16_GAM_G_GAIN_30_SHIFT                                   (16u)
#define VDC6_GAM_G_AREA1_GAM_G_TH_03                                           (0x000000FFu)
#define VDC6_GAM_G_AREA1_GAM_G_TH_03_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA1_GAM_G_TH_02                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA1_GAM_G_TH_02_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA1_GAM_G_TH_01                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA1_GAM_G_TH_01_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA2_GAM_G_TH_07                                           (0x000000FFu)
#define VDC6_GAM_G_AREA2_GAM_G_TH_07_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA2_GAM_G_TH_06                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA2_GAM_G_TH_06_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA2_GAM_G_TH_05                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA2_GAM_G_TH_05_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA2_GAM_G_TH_04                                           (0xFF000000u)
#define VDC6_GAM_G_AREA2_GAM_G_TH_04_SHIFT                                     (24u)
#define VDC6_GAM_G_AREA3_GAM_G_TH_11                                           (0x000000FFu)
#define VDC6_GAM_G_AREA3_GAM_G_TH_11_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA3_GAM_G_TH_10                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA3_GAM_G_TH_10_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA3_GAM_G_TH_09                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA3_GAM_G_TH_09_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA3_GAM_G_TH_08                                           (0xFF000000u)
#define VDC6_GAM_G_AREA3_GAM_G_TH_08_SHIFT                                     (24u)
#define VDC6_GAM_G_AREA4_GAM_G_TH_15                                           (0x000000FFu)
#define VDC6_GAM_G_AREA4_GAM_G_TH_15_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA4_GAM_G_TH_14                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA4_GAM_G_TH_14_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA4_GAM_G_TH_13                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA4_GAM_G_TH_13_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA4_GAM_G_TH_12                                           (0xFF000000u)
#define VDC6_GAM_G_AREA4_GAM_G_TH_12_SHIFT                                     (24u)
#define VDC6_GAM_G_AREA5_GAM_G_TH_19                                           (0x000000FFu)
#define VDC6_GAM_G_AREA5_GAM_G_TH_19_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA5_GAM_G_TH_18                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA5_GAM_G_TH_18_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA5_GAM_G_TH_17                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA5_GAM_G_TH_17_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA5_GAM_G_TH_16                                           (0xFF000000u)
#define VDC6_GAM_G_AREA5_GAM_G_TH_16_SHIFT                                     (24u)
#define VDC6_GAM_G_AREA6_GAM_G_TH_23                                           (0x000000FFu)
#define VDC6_GAM_G_AREA6_GAM_G_TH_23_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA6_GAM_G_TH_22                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA6_GAM_G_TH_22_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA6_GAM_G_TH_21                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA6_GAM_G_TH_21_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA6_GAM_G_TH_20                                           (0xFF000000u)
#define VDC6_GAM_G_AREA6_GAM_G_TH_20_SHIFT                                     (24u)
#define VDC6_GAM_G_AREA7_GAM_G_TH_27                                           (0x000000FFu)
#define VDC6_GAM_G_AREA7_GAM_G_TH_27_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA7_GAM_G_TH_26                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA7_GAM_G_TH_26_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA7_GAM_G_TH_25                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA7_GAM_G_TH_25_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA7_GAM_G_TH_24                                           (0xFF000000u)
#define VDC6_GAM_G_AREA7_GAM_G_TH_24_SHIFT                                     (24u)
#define VDC6_GAM_G_AREA8_GAM_G_TH_31                                           (0x000000FFu)
#define VDC6_GAM_G_AREA8_GAM_G_TH_31_SHIFT                                     (0u)
#define VDC6_GAM_G_AREA8_GAM_G_TH_30                                           (0x0000FF00u)
#define VDC6_GAM_G_AREA8_GAM_G_TH_30_SHIFT                                     (8u)
#define VDC6_GAM_G_AREA8_GAM_G_TH_29                                           (0x00FF0000u)
#define VDC6_GAM_G_AREA8_GAM_G_TH_29_SHIFT                                     (16u)
#define VDC6_GAM_G_AREA8_GAM_G_TH_28                                           (0xFF000000u)
#define VDC6_GAM_G_AREA8_GAM_G_TH_28_SHIFT                                     (24u)
#define VDC6_GAM_B_UPDATE_GAM_B_VEN                                            (0x00000001u)
#define VDC6_GAM_B_UPDATE_GAM_B_VEN_SHIFT                                      (0u)
#define VDC6_GAM_B_LUT1_GAM_B_GAIN_01                                          (0x000007FFu)
#define VDC6_GAM_B_LUT1_GAM_B_GAIN_01_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT1_GAM_B_GAIN_00                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT1_GAM_B_GAIN_00_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT2_GAM_B_GAIN_03                                          (0x000007FFu)
#define VDC6_GAM_B_LUT2_GAM_B_GAIN_03_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT2_GAM_B_GAIN_02                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT2_GAM_B_GAIN_02_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT3_GAM_B_GAIN_05                                          (0x000007FFu)
#define VDC6_GAM_B_LUT3_GAM_B_GAIN_05_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT3_GAM_B_GAIN_04                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT3_GAM_B_GAIN_04_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT4_GAM_B_GAIN_07                                          (0x000007FFu)
#define VDC6_GAM_B_LUT4_GAM_B_GAIN_07_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT4_GAM_B_GAIN_06                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT4_GAM_B_GAIN_06_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT5_GAM_B_GAIN_09                                          (0x000007FFu)
#define VDC6_GAM_B_LUT5_GAM_B_GAIN_09_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT5_GAM_B_GAIN_08                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT5_GAM_B_GAIN_08_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT6_GAM_B_GAIN_11                                          (0x000007FFu)
#define VDC6_GAM_B_LUT6_GAM_B_GAIN_11_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT6_GAM_B_GAIN_10                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT6_GAM_B_GAIN_10_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT7_GAM_B_GAIN_13                                          (0x000007FFu)
#define VDC6_GAM_B_LUT7_GAM_B_GAIN_13_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT7_GAM_B_GAIN_12                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT7_GAM_B_GAIN_12_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT8_GAM_B_GAIN_15                                          (0x000007FFu)
#define VDC6_GAM_B_LUT8_GAM_B_GAIN_15_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT8_GAM_B_GAIN_14                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT8_GAM_B_GAIN_14_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT9_GAM_B_GAIN_17                                          (0x000007FFu)
#define VDC6_GAM_B_LUT9_GAM_B_GAIN_17_SHIFT                                    (0u)
#define VDC6_GAM_B_LUT9_GAM_B_GAIN_16                                          (0x07FF0000u)
#define VDC6_GAM_B_LUT9_GAM_B_GAIN_16_SHIFT                                    (16u)
#define VDC6_GAM_B_LUT10_GAM_B_GAIN_19                                         (0x000007FFu)
#define VDC6_GAM_B_LUT10_GAM_B_GAIN_19_SHIFT                                   (0u)
#define VDC6_GAM_B_LUT10_GAM_B_GAIN_18                                         (0x07FF0000u)
#define VDC6_GAM_B_LUT10_GAM_B_GAIN_18_SHIFT                                   (16u)
#define VDC6_GAM_B_LUT11_GAM_B_GAIN_21                                         (0x000007FFu)
#define VDC6_GAM_B_LUT11_GAM_B_GAIN_21_SHIFT                                   (0u)
#define VDC6_GAM_B_LUT11_GAM_B_GAIN_20                                         (0x07FF0000u)
#define VDC6_GAM_B_LUT11_GAM_B_GAIN_20_SHIFT                                   (16u)
#define VDC6_GAM_B_LUT12_GAM_B_GAIN_23                                         (0x000007FFu)
#define VDC6_GAM_B_LUT12_GAM_B_GAIN_23_SHIFT                                   (0u)
#define VDC6_GAM_B_LUT12_GAM_B_GAIN_22                                         (0x07FF0000u)
#define VDC6_GAM_B_LUT12_GAM_B_GAIN_22_SHIFT                                   (16u)
#define VDC6_GAM_B_LUT13_GAM_B_GAIN_25                                         (0x000007FFu)
#define VDC6_GAM_B_LUT13_GAM_B_GAIN_25_SHIFT                                   (0u)
#define VDC6_GAM_B_LUT13_GAM_B_GAIN_24                                         (0x07FF0000u)
#define VDC6_GAM_B_LUT13_GAM_B_GAIN_24_SHIFT                                   (16u)
#define VDC6_GAM_B_LUT14_GAM_B_GAIN_27                                         (0x000007FFu)
#define VDC6_GAM_B_LUT14_GAM_B_GAIN_27_SHIFT                                   (0u)
#define VDC6_GAM_B_LUT14_GAM_B_GAIN_26                                         (0x07FF0000u)
#define VDC6_GAM_B_LUT14_GAM_B_GAIN_26_SHIFT                                   (16u)
#define VDC6_GAM_B_LUT15_GAM_B_GAIN_29                                         (0x000007FFu)
#define VDC6_GAM_B_LUT15_GAM_B_GAIN_29_SHIFT                                   (0u)
#define VDC6_GAM_B_LUT15_GAM_B_GAIN_28                                         (0x07FF0000u)
#define VDC6_GAM_B_LUT15_GAM_B_GAIN_28_SHIFT                                   (16u)
#define VDC6_GAM_B_LUT16_GAM_B_GAIN_31                                         (0x000007FFu)
#define VDC6_GAM_B_LUT16_GAM_B_GAIN_31_SHIFT                                   (0u)
#define VDC6_GAM_B_LUT16_GAM_B_GAIN_30                                         (0x07FF0000u)
#define VDC6_GAM_B_LUT16_GAM_B_GAIN_30_SHIFT                                   (16u)
#define VDC6_GAM_B_AREA1_GAM_B_TH_03                                           (0x000000FFu)
#define VDC6_GAM_B_AREA1_GAM_B_TH_03_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA1_GAM_B_TH_02                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA1_GAM_B_TH_02_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA1_GAM_B_TH_01                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA1_GAM_B_TH_01_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA2_GAM_B_TH_07                                           (0x000000FFu)
#define VDC6_GAM_B_AREA2_GAM_B_TH_07_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA2_GAM_B_TH_06                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA2_GAM_B_TH_06_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA2_GAM_B_TH_05                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA2_GAM_B_TH_05_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA2_GAM_B_TH_04                                           (0xFF000000u)
#define VDC6_GAM_B_AREA2_GAM_B_TH_04_SHIFT                                     (24u)
#define VDC6_GAM_B_AREA3_GAM_B_TH_11                                           (0x000000FFu)
#define VDC6_GAM_B_AREA3_GAM_B_TH_11_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA3_GAM_B_TH_10                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA3_GAM_B_TH_10_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA3_GAM_B_TH_09                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA3_GAM_B_TH_09_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA3_GAM_B_TH_08                                           (0xFF000000u)
#define VDC6_GAM_B_AREA3_GAM_B_TH_08_SHIFT                                     (24u)
#define VDC6_GAM_B_AREA4_GAM_B_TH_15                                           (0x000000FFu)
#define VDC6_GAM_B_AREA4_GAM_B_TH_15_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA4_GAM_B_TH_14                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA4_GAM_B_TH_14_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA4_GAM_B_TH_13                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA4_GAM_B_TH_13_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA4_GAM_B_TH_12                                           (0xFF000000u)
#define VDC6_GAM_B_AREA4_GAM_B_TH_12_SHIFT                                     (24u)
#define VDC6_GAM_B_AREA5_GAM_B_TH_19                                           (0x000000FFu)
#define VDC6_GAM_B_AREA5_GAM_B_TH_19_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA5_GAM_B_TH_18                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA5_GAM_B_TH_18_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA5_GAM_B_TH_17                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA5_GAM_B_TH_17_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA5_GAM_B_TH_16                                           (0xFF000000u)
#define VDC6_GAM_B_AREA5_GAM_B_TH_16_SHIFT                                     (24u)
#define VDC6_GAM_B_AREA6_GAM_B_TH_23                                           (0x000000FFu)
#define VDC6_GAM_B_AREA6_GAM_B_TH_23_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA6_GAM_B_TH_22                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA6_GAM_B_TH_22_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA6_GAM_B_TH_21                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA6_GAM_B_TH_21_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA6_GAM_B_TH_20                                           (0xFF000000u)
#define VDC6_GAM_B_AREA6_GAM_B_TH_20_SHIFT                                     (24u)
#define VDC6_GAM_B_AREA7_GAM_B_TH_27                                           (0x000000FFu)
#define VDC6_GAM_B_AREA7_GAM_B_TH_27_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA7_GAM_B_TH_26                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA7_GAM_B_TH_26_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA7_GAM_B_TH_25                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA7_GAM_B_TH_25_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA7_GAM_B_TH_24                                           (0xFF000000u)
#define VDC6_GAM_B_AREA7_GAM_B_TH_24_SHIFT                                     (24u)
#define VDC6_GAM_B_AREA8_GAM_B_TH_31                                           (0x000000FFu)
#define VDC6_GAM_B_AREA8_GAM_B_TH_31_SHIFT                                     (0u)
#define VDC6_GAM_B_AREA8_GAM_B_TH_30                                           (0x0000FF00u)
#define VDC6_GAM_B_AREA8_GAM_B_TH_30_SHIFT                                     (8u)
#define VDC6_GAM_B_AREA8_GAM_B_TH_29                                           (0x00FF0000u)
#define VDC6_GAM_B_AREA8_GAM_B_TH_29_SHIFT                                     (16u)
#define VDC6_GAM_B_AREA8_GAM_B_TH_28                                           (0xFF000000u)
#define VDC6_GAM_B_AREA8_GAM_B_TH_28_SHIFT                                     (24u)
#define VDC6_GAM_R_UPDATE_GAM_R_VEN                                            (0x00000001u)
#define VDC6_GAM_R_UPDATE_GAM_R_VEN_SHIFT                                      (0u)
#define VDC6_GAM_R_LUT1_GAM_R_GAIN_01                                          (0x000007FFu)
#define VDC6_GAM_R_LUT1_GAM_R_GAIN_01_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT1_GAM_R_GAIN_00                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT1_GAM_R_GAIN_00_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT2_GAM_R_GAIN_03                                          (0x000007FFu)
#define VDC6_GAM_R_LUT2_GAM_R_GAIN_03_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT2_GAM_R_GAIN_02                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT2_GAM_R_GAIN_02_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT3_GAM_R_GAIN_05                                          (0x000007FFu)
#define VDC6_GAM_R_LUT3_GAM_R_GAIN_05_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT3_GAM_R_GAIN_04                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT3_GAM_R_GAIN_04_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT4_GAM_R_GAIN_07                                          (0x000007FFu)
#define VDC6_GAM_R_LUT4_GAM_R_GAIN_07_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT4_GAM_R_GAIN_06                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT4_GAM_R_GAIN_06_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT5_GAM_R_GAIN_09                                          (0x000007FFu)
#define VDC6_GAM_R_LUT5_GAM_R_GAIN_09_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT5_GAM_R_GAIN_08                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT5_GAM_R_GAIN_08_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT6_GAM_R_GAIN_11                                          (0x000007FFu)
#define VDC6_GAM_R_LUT6_GAM_R_GAIN_11_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT6_GAM_R_GAIN_10                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT6_GAM_R_GAIN_10_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT7_GAM_R_GAIN_13                                          (0x000007FFu)
#define VDC6_GAM_R_LUT7_GAM_R_GAIN_13_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT7_GAM_R_GAIN_12                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT7_GAM_R_GAIN_12_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT8_GAM_R_GAIN_15                                          (0x000007FFu)
#define VDC6_GAM_R_LUT8_GAM_R_GAIN_15_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT8_GAM_R_GAIN_14                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT8_GAM_R_GAIN_14_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT9_GAM_R_GAIN_17                                          (0x000007FFu)
#define VDC6_GAM_R_LUT9_GAM_R_GAIN_17_SHIFT                                    (0u)
#define VDC6_GAM_R_LUT9_GAM_R_GAIN_16                                          (0x07FF0000u)
#define VDC6_GAM_R_LUT9_GAM_R_GAIN_16_SHIFT                                    (16u)
#define VDC6_GAM_R_LUT10_GAM_R_GAIN_19                                         (0x000007FFu)
#define VDC6_GAM_R_LUT10_GAM_R_GAIN_19_SHIFT                                   (0u)
#define VDC6_GAM_R_LUT10_GAM_R_GAIN_18                                         (0x07FF0000u)
#define VDC6_GAM_R_LUT10_GAM_R_GAIN_18_SHIFT                                   (16u)
#define VDC6_GAM_R_LUT11_GAM_R_GAIN_21                                         (0x000007FFu)
#define VDC6_GAM_R_LUT11_GAM_R_GAIN_21_SHIFT                                   (0u)
#define VDC6_GAM_R_LUT11_GAM_R_GAIN_20                                         (0x07FF0000u)
#define VDC6_GAM_R_LUT11_GAM_R_GAIN_20_SHIFT                                   (16u)
#define VDC6_GAM_R_LUT12_GAM_R_GAIN_23                                         (0x000007FFu)
#define VDC6_GAM_R_LUT12_GAM_R_GAIN_23_SHIFT                                   (0u)
#define VDC6_GAM_R_LUT12_GAM_R_GAIN_22                                         (0x07FF0000u)
#define VDC6_GAM_R_LUT12_GAM_R_GAIN_22_SHIFT                                   (16u)
#define VDC6_GAM_R_LUT13_GAM_R_GAIN_25                                         (0x000007FFu)
#define VDC6_GAM_R_LUT13_GAM_R_GAIN_25_SHIFT                                   (0u)
#define VDC6_GAM_R_LUT13_GAM_R_GAIN_24                                         (0x07FF0000u)
#define VDC6_GAM_R_LUT13_GAM_R_GAIN_24_SHIFT                                   (16u)
#define VDC6_GAM_R_LUT14_GAM_R_GAIN_27                                         (0x000007FFu)
#define VDC6_GAM_R_LUT14_GAM_R_GAIN_27_SHIFT                                   (0u)
#define VDC6_GAM_R_LUT14_GAM_R_GAIN_26                                         (0x07FF0000u)
#define VDC6_GAM_R_LUT14_GAM_R_GAIN_26_SHIFT                                   (16u)
#define VDC6_GAM_R_LUT15_GAM_R_GAIN_29                                         (0x000007FFu)
#define VDC6_GAM_R_LUT15_GAM_R_GAIN_29_SHIFT                                   (0u)
#define VDC6_GAM_R_LUT15_GAM_R_GAIN_28                                         (0x07FF0000u)
#define VDC6_GAM_R_LUT15_GAM_R_GAIN_28_SHIFT                                   (16u)
#define VDC6_GAM_R_LUT16_GAM_R_GAIN_31                                         (0x000007FFu)
#define VDC6_GAM_R_LUT16_GAM_R_GAIN_31_SHIFT                                   (0u)
#define VDC6_GAM_R_LUT16_GAM_R_GAIN_30                                         (0x07FF0000u)
#define VDC6_GAM_R_LUT16_GAM_R_GAIN_30_SHIFT                                   (16u)
#define VDC6_GAM_R_AREA1_GAM_R_TH_03                                           (0x000000FFu)
#define VDC6_GAM_R_AREA1_GAM_R_TH_03_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA1_GAM_R_TH_02                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA1_GAM_R_TH_02_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA1_GAM_R_TH_01                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA1_GAM_R_TH_01_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA2_GAM_R_TH_07                                           (0x000000FFu)
#define VDC6_GAM_R_AREA2_GAM_R_TH_07_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA2_GAM_R_TH_06                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA2_GAM_R_TH_06_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA2_GAM_R_TH_05                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA2_GAM_R_TH_05_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA2_GAM_R_TH_04                                           (0xFF000000u)
#define VDC6_GAM_R_AREA2_GAM_R_TH_04_SHIFT                                     (24u)
#define VDC6_GAM_R_AREA3_GAM_R_TH_11                                           (0x000000FFu)
#define VDC6_GAM_R_AREA3_GAM_R_TH_11_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA3_GAM_R_TH_10                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA3_GAM_R_TH_10_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA3_GAM_R_TH_09                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA3_GAM_R_TH_09_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA3_GAM_R_TH_08                                           (0xFF000000u)
#define VDC6_GAM_R_AREA3_GAM_R_TH_08_SHIFT                                     (24u)
#define VDC6_GAM_R_AREA4_GAM_R_TH_15                                           (0x000000FFu)
#define VDC6_GAM_R_AREA4_GAM_R_TH_15_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA4_GAM_R_TH_14                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA4_GAM_R_TH_14_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA4_GAM_R_TH_13                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA4_GAM_R_TH_13_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA4_GAM_R_TH_12                                           (0xFF000000u)
#define VDC6_GAM_R_AREA4_GAM_R_TH_12_SHIFT                                     (24u)
#define VDC6_GAM_R_AREA5_GAM_R_TH_19                                           (0x000000FFu)
#define VDC6_GAM_R_AREA5_GAM_R_TH_19_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA5_GAM_R_TH_18                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA5_GAM_R_TH_18_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA5_GAM_R_TH_17                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA5_GAM_R_TH_17_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA5_GAM_R_TH_16                                           (0xFF000000u)
#define VDC6_GAM_R_AREA5_GAM_R_TH_16_SHIFT                                     (24u)
#define VDC6_GAM_R_AREA6_GAM_R_TH_23                                           (0x000000FFu)
#define VDC6_GAM_R_AREA6_GAM_R_TH_23_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA6_GAM_R_TH_22                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA6_GAM_R_TH_22_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA6_GAM_R_TH_21                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA6_GAM_R_TH_21_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA6_GAM_R_TH_20                                           (0xFF000000u)
#define VDC6_GAM_R_AREA6_GAM_R_TH_20_SHIFT                                     (24u)
#define VDC6_GAM_R_AREA7_GAM_R_TH_27                                           (0x000000FFu)
#define VDC6_GAM_R_AREA7_GAM_R_TH_27_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA7_GAM_R_TH_26                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA7_GAM_R_TH_26_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA7_GAM_R_TH_25                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA7_GAM_R_TH_25_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA7_GAM_R_TH_24                                           (0xFF000000u)
#define VDC6_GAM_R_AREA7_GAM_R_TH_24_SHIFT                                     (24u)
#define VDC6_GAM_R_AREA8_GAM_R_TH_31                                           (0x000000FFu)
#define VDC6_GAM_R_AREA8_GAM_R_TH_31_SHIFT                                     (0u)
#define VDC6_GAM_R_AREA8_GAM_R_TH_30                                           (0x0000FF00u)
#define VDC6_GAM_R_AREA8_GAM_R_TH_30_SHIFT                                     (8u)
#define VDC6_GAM_R_AREA8_GAM_R_TH_29                                           (0x00FF0000u)
#define VDC6_GAM_R_AREA8_GAM_R_TH_29_SHIFT                                     (16u)
#define VDC6_GAM_R_AREA8_GAM_R_TH_28                                           (0xFF000000u)
#define VDC6_GAM_R_AREA8_GAM_R_TH_28_SHIFT                                     (24u)
#define VDC6_TCON_UPDATE_TCON_VEN                                              (0x00000001u)
#define VDC6_TCON_UPDATE_TCON_VEN_SHIFT                                        (0u)
#define VDC6_TCON_TIM_TCON_OFFSET                                              (0x000007FFu)
#define VDC6_TCON_TIM_TCON_OFFSET_SHIFT                                        (0u)
#define VDC6_TCON_TIM_TCON_HALF                                                (0x07FF0000u)
#define VDC6_TCON_TIM_TCON_HALF_SHIFT                                          (16u)
#define VDC6_TCON_TIM_STVA1_TCON_STVA_VW                                       (0x000007FFu)
#define VDC6_TCON_TIM_STVA1_TCON_STVA_VW_SHIFT                                 (0u)
#define VDC6_TCON_TIM_STVA1_TCON_STVA_VS                                       (0x07FF0000u)
#define VDC6_TCON_TIM_STVA1_TCON_STVA_VS_SHIFT                                 (16u)
#define VDC6_TCON_TIM_STVA2_TCON_STVA_SEL                                      (0x00000007u)
#define VDC6_TCON_TIM_STVA2_TCON_STVA_SEL_SHIFT                                (0u)
#define VDC6_TCON_TIM_STVA2_TCON_STVA_INV                                      (0x00000010u)
#define VDC6_TCON_TIM_STVA2_TCON_STVA_INV_SHIFT                                (4u)
#define VDC6_TCON_TIM_STVB1_TCON_STVB_VW                                       (0x000007FFu)
#define VDC6_TCON_TIM_STVB1_TCON_STVB_VW_SHIFT                                 (0u)
#define VDC6_TCON_TIM_STVB1_TCON_STVB_VS                                       (0x07FF0000u)
#define VDC6_TCON_TIM_STVB1_TCON_STVB_VS_SHIFT                                 (16u)
#define VDC6_TCON_TIM_STVB2_TCON_STVB_SEL                                      (0x00000007u)
#define VDC6_TCON_TIM_STVB2_TCON_STVB_SEL_SHIFT                                (0u)
#define VDC6_TCON_TIM_STVB2_TCON_STVB_INV                                      (0x00000010u)
#define VDC6_TCON_TIM_STVB2_TCON_STVB_INV_SHIFT                                (4u)
#define VDC6_TCON_TIM_STH1_TCON_STH_HW                                         (0x000007FFu)
#define VDC6_TCON_TIM_STH1_TCON_STH_HW_SHIFT                                   (0u)
#define VDC6_TCON_TIM_STH1_TCON_STH_HS                                         (0x07FF0000u)
#define VDC6_TCON_TIM_STH1_TCON_STH_HS_SHIFT                                   (16u)
#define VDC6_TCON_TIM_STH2_TCON_STH_SEL                                        (0x00000007u)
#define VDC6_TCON_TIM_STH2_TCON_STH_SEL_SHIFT                                  (0u)
#define VDC6_TCON_TIM_STH2_TCON_STH_INV                                        (0x00000010u)
#define VDC6_TCON_TIM_STH2_TCON_STH_INV_SHIFT                                  (4u)
#define VDC6_TCON_TIM_STH2_TCON_STH_HS_SEL                                     (0x00000100u)
#define VDC6_TCON_TIM_STH2_TCON_STH_HS_SEL_SHIFT                               (8u)
#define VDC6_TCON_TIM_STB1_TCON_STB_HW                                         (0x000007FFu)
#define VDC6_TCON_TIM_STB1_TCON_STB_HW_SHIFT                                   (0u)
#define VDC6_TCON_TIM_STB1_TCON_STB_HS                                         (0x07FF0000u)
#define VDC6_TCON_TIM_STB1_TCON_STB_HS_SHIFT                                   (16u)
#define VDC6_TCON_TIM_STB2_TCON_STB_SEL                                        (0x00000007u)
#define VDC6_TCON_TIM_STB2_TCON_STB_SEL_SHIFT                                  (0u)
#define VDC6_TCON_TIM_STB2_TCON_STB_INV                                        (0x00000010u)
#define VDC6_TCON_TIM_STB2_TCON_STB_INV_SHIFT                                  (4u)
#define VDC6_TCON_TIM_STB2_TCON_STB_HS_SEL                                     (0x00000100u)
#define VDC6_TCON_TIM_STB2_TCON_STB_HS_SEL_SHIFT                               (8u)
#define VDC6_TCON_TIM_CPV1_TCON_CPV_HW                                         (0x000007FFu)
#define VDC6_TCON_TIM_CPV1_TCON_CPV_HW_SHIFT                                   (0u)
#define VDC6_TCON_TIM_CPV1_TCON_CPV_HS                                         (0x07FF0000u)
#define VDC6_TCON_TIM_CPV1_TCON_CPV_HS_SHIFT                                   (16u)
#define VDC6_TCON_TIM_CPV2_TCON_CPV_SEL                                        (0x00000007u)
#define VDC6_TCON_TIM_CPV2_TCON_CPV_SEL_SHIFT                                  (0u)
#define VDC6_TCON_TIM_CPV2_TCON_CPV_INV                                        (0x00000010u)
#define VDC6_TCON_TIM_CPV2_TCON_CPV_INV_SHIFT                                  (4u)
#define VDC6_TCON_TIM_CPV2_TCON_CPV_HS_SEL                                     (0x00000100u)
#define VDC6_TCON_TIM_CPV2_TCON_CPV_HS_SEL_SHIFT                               (8u)
#define VDC6_TCON_TIM_POLA1_TCON_POLA_HW                                       (0x000007FFu)
#define VDC6_TCON_TIM_POLA1_TCON_POLA_HW_SHIFT                                 (0u)
#define VDC6_TCON_TIM_POLA1_TCON_POLA_HS                                       (0x07FF0000u)
#define VDC6_TCON_TIM_POLA1_TCON_POLA_HS_SHIFT                                 (16u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_SEL                                      (0x00000007u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_SEL_SHIFT                                (0u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_INV                                      (0x00000010u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_INV_SHIFT                                (4u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_HS_SEL                                   (0x00000100u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_HS_SEL_SHIFT                             (8u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_MD                                       (0x00003000u)
#define VDC6_TCON_TIM_POLA2_TCON_POLA_MD_SHIFT                                 (12u)
#define VDC6_TCON_TIM_POLB1_TCON_POLB_HW                                       (0x000007FFu)
#define VDC6_TCON_TIM_POLB1_TCON_POLB_HW_SHIFT                                 (0u)
#define VDC6_TCON_TIM_POLB1_TCON_POLB_HS                                       (0x07FF0000u)
#define VDC6_TCON_TIM_POLB1_TCON_POLB_HS_SHIFT                                 (16u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_SEL                                      (0x00000007u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_SEL_SHIFT                                (0u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_INV                                      (0x00000010u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_INV_SHIFT                                (4u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_HS_SEL                                   (0x00000100u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_HS_SEL_SHIFT                             (8u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_MD                                       (0x00003000u)
#define VDC6_TCON_TIM_POLB2_TCON_POLB_MD_SHIFT                                 (12u)
#define VDC6_TCON_TIM_DE_TCON_DE_INV                                           (0x00000001u)
#define VDC6_TCON_TIM_DE_TCON_DE_INV_SHIFT                                     (0u)
#define VDC6_OUT_UPDATE_OUTCNT_VEN                                             (0x00000001u)
#define VDC6_OUT_UPDATE_OUTCNT_VEN_SHIFT                                       (0u)
#define VDC6_OUT_SET_OUT_PHASE                                                 (0x00000003u)
#define VDC6_OUT_SET_OUT_PHASE_SHIFT                                           (0u)
#define VDC6_OUT_SET_OUT_DIR_SEL                                               (0x00000010u)
#define VDC6_OUT_SET_OUT_DIR_SEL_SHIFT                                         (4u)
#define VDC6_OUT_SET_OUT_FRQ_SEL                                               (0x00000300u)
#define VDC6_OUT_SET_OUT_FRQ_SEL_SHIFT                                         (8u)
#define VDC6_OUT_SET_OUT_FORMAT                                                (0x00003000u)
#define VDC6_OUT_SET_OUT_FORMAT_SHIFT                                          (12u)
#define VDC6_OUT_SET_OUT_SWAP_ON                                               (0x01000000u)
#define VDC6_OUT_SET_OUT_SWAP_ON_SHIFT                                         (24u)
#define VDC6_OUT_SET_OUT_ENDIAN_ON                                             (0x10000000u)
#define VDC6_OUT_SET_OUT_ENDIAN_ON_SHIFT                                       (28u)
#define VDC6_OUT_BRIGHT1_PBRT_G                                                (0x000003FFu)
#define VDC6_OUT_BRIGHT1_PBRT_G_SHIFT                                          (0u)
#define VDC6_OUT_BRIGHT2_PBRT_R                                                (0x000003FFu)
#define VDC6_OUT_BRIGHT2_PBRT_R_SHIFT                                          (0u)
#define VDC6_OUT_BRIGHT2_PBRT_B                                                (0x03FF0000u)
#define VDC6_OUT_BRIGHT2_PBRT_B_SHIFT                                          (16u)
#define VDC6_OUT_CONTRAST_CONT_R                                               (0x000000FFu)
#define VDC6_OUT_CONTRAST_CONT_R_SHIFT                                         (0u)
#define VDC6_OUT_CONTRAST_CONT_B                                               (0x0000FF00u)
#define VDC6_OUT_CONTRAST_CONT_B_SHIFT                                         (8u)
#define VDC6_OUT_CONTRAST_CONT_G                                               (0x00FF0000u)
#define VDC6_OUT_CONTRAST_CONT_G_SHIFT                                         (16u)
#define VDC6_OUT_PDTHA_PDTH_PD                                                 (0x00000003u)
#define VDC6_OUT_PDTHA_PDTH_PD_SHIFT                                           (0u)
#define VDC6_OUT_PDTHA_PDTH_PC                                                 (0x00000030u)
#define VDC6_OUT_PDTHA_PDTH_PC_SHIFT                                           (4u)
#define VDC6_OUT_PDTHA_PDTH_PB                                                 (0x00000300u)
#define VDC6_OUT_PDTHA_PDTH_PB_SHIFT                                           (8u)
#define VDC6_OUT_PDTHA_PDTH_PA                                                 (0x00003000u)
#define VDC6_OUT_PDTHA_PDTH_PA_SHIFT                                           (12u)
#define VDC6_OUT_PDTHA_PDTH_FORMAT                                             (0x00030000u)
#define VDC6_OUT_PDTHA_PDTH_FORMAT_SHIFT                                       (16u)
#define VDC6_OUT_PDTHA_PDTH_SEL                                                (0x00300000u)
#define VDC6_OUT_PDTHA_PDTH_SEL_SHIFT                                          (20u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_POLB_EDGE                                    (0x00000001u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_POLB_EDGE_SHIFT                              (0u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_POLA_EDGE                                    (0x00000002u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_POLA_EDGE_SHIFT                              (1u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_CPV_EDGE                                     (0x00000004u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_CPV_EDGE_SHIFT                               (2u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STB_EDGE                                     (0x00000008u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STB_EDGE_SHIFT                               (3u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STH_EDGE                                     (0x00000010u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STH_EDGE_SHIFT                               (4u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STVB_EDGE                                    (0x00000020u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STVB_EDGE_SHIFT                              (5u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STVA_EDGE                                    (0x00000040u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_STVA_EDGE_SHIFT                              (6u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_LCD_EDGE                                     (0x00000100u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_LCD_EDGE_SHIFT                               (8u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_FRONT_GAM                                    (0x00001000u)
#define VDC6_OUT_CLK_PHASE_OUTCNT_FRONT_GAM_SHIFT                              (12u)
#define VDC6_SYSCNT_INT1_INT_STA0                                              (0x00000001u)
#define VDC6_SYSCNT_INT1_INT_STA0_SHIFT                                        (0u)
#define VDC6_SYSCNT_INT1_INT_STA1                                              (0x00000010u)
#define VDC6_SYSCNT_INT1_INT_STA1_SHIFT                                        (4u)
#define VDC6_SYSCNT_INT1_INT_STA2                                              (0x00000100u)
#define VDC6_SYSCNT_INT1_INT_STA2_SHIFT                                        (8u)
#define VDC6_SYSCNT_INT1_INT_STA3                                              (0x00001000u)
#define VDC6_SYSCNT_INT1_INT_STA3_SHIFT                                        (12u)
#define VDC6_SYSCNT_INT1_INT_STA4                                              (0x00010000u)
#define VDC6_SYSCNT_INT1_INT_STA4_SHIFT                                        (16u)
#define VDC6_SYSCNT_INT1_INT_STA5                                              (0x00100000u)
#define VDC6_SYSCNT_INT1_INT_STA5_SHIFT                                        (20u)
#define VDC6_SYSCNT_INT1_INT_STA6                                              (0x01000000u)
#define VDC6_SYSCNT_INT1_INT_STA6_SHIFT                                        (24u)
#define VDC6_SYSCNT_INT1_INT_STA7                                              (0x10000000u)
#define VDC6_SYSCNT_INT1_INT_STA7_SHIFT                                        (28u)
#define VDC6_SYSCNT_INT2_INT_STA8                                              (0x00000001u)
#define VDC6_SYSCNT_INT2_INT_STA8_SHIFT                                        (0u)
#define VDC6_SYSCNT_INT2_INT_STA9                                              (0x00000010u)
#define VDC6_SYSCNT_INT2_INT_STA9_SHIFT                                        (4u)
#define VDC6_SYSCNT_INT4_INT_OUT0_ON                                           (0x00000001u)
#define VDC6_SYSCNT_INT4_INT_OUT0_ON_SHIFT                                     (0u)
#define VDC6_SYSCNT_INT4_INT_OUT1_ON                                           (0x00000010u)
#define VDC6_SYSCNT_INT4_INT_OUT1_ON_SHIFT                                     (4u)
#define VDC6_SYSCNT_INT4_INT_OUT2_ON                                           (0x00000100u)
#define VDC6_SYSCNT_INT4_INT_OUT2_ON_SHIFT                                     (8u)
#define VDC6_SYSCNT_INT4_INT_OUT3_ON                                           (0x00001000u)
#define VDC6_SYSCNT_INT4_INT_OUT3_ON_SHIFT                                     (12u)
#define VDC6_SYSCNT_INT4_INT_OUT4_ON                                           (0x00010000u)
#define VDC6_SYSCNT_INT4_INT_OUT4_ON_SHIFT                                     (16u)
#define VDC6_SYSCNT_INT4_INT_OUT5_ON                                           (0x00100000u)
#define VDC6_SYSCNT_INT4_INT_OUT5_ON_SHIFT                                     (20u)
#define VDC6_SYSCNT_INT4_INT_OUT6_ON                                           (0x01000000u)
#define VDC6_SYSCNT_INT4_INT_OUT6_ON_SHIFT                                     (24u)
#define VDC6_SYSCNT_INT4_INT_OUT7_ON                                           (0x10000000u)
#define VDC6_SYSCNT_INT4_INT_OUT7_ON_SHIFT                                     (28u)
#define VDC6_SYSCNT_INT5_INT_OUT8_ON                                           (0x00000001u)
#define VDC6_SYSCNT_INT5_INT_OUT8_ON_SHIFT                                     (0u)
#define VDC6_SYSCNT_INT5_INT_OUT9_ON                                           (0x00000010u)
#define VDC6_SYSCNT_INT5_INT_OUT9_ON_SHIFT                                     (4u)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_DCDR                                       (0x003Fu)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_DCDR_SHIFT                                 (0u)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_ICKEN                                      (0x0100u)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_ICKEN_SHIFT                                (8u)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_OCKSEL                                     (0x0C00u)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_OCKSEL_SHIFT                               (10u)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_ICKSEL                                     (0x3000u)
#define VDC6_SYSCNT_PANEL_CLK_PANEL_ICKSEL_SHIFT                               (12u)
#define VDC6_SYSCNT_CLUT_GR0_CLT_SEL_ST                                        (0x0001u)
#define VDC6_SYSCNT_CLUT_GR0_CLT_SEL_ST_SHIFT                                  (0u)
#define VDC6_SYSCNT_CLUT_GR2_CLT_SEL_ST                                        (0x0100u)
#define VDC6_SYSCNT_CLUT_GR2_CLT_SEL_ST_SHIFT                                  (8u)
#define VDC6_SYSCNT_CLUT_GR3_CLT_SEL_ST                                        (0x1000u)
#define VDC6_SYSCNT_CLUT_GR3_CLT_SEL_ST_SHIFT                                  (12u)
#define VDC6_GR_VIN_UPDATE_GR_VIN_P_VEN                                        (0x00000010u)
#define VDC6_GR_VIN_UPDATE_GR_VIN_P_VEN_SHIFT                                  (4u)
#define VDC6_GR_VIN_UPDATE_GR_VIN_UPDATE                                       (0x00000100u)
#define VDC6_GR_VIN_UPDATE_GR_VIN_UPDATE_SHIFT                                 (8u)
#define VDC6_GR_VIN_AB1_GR_VIN_DISP_SEL                                        (0x00000003u)
#define VDC6_GR_VIN_AB1_GR_VIN_DISP_SEL_SHIFT                                  (0u)
#define VDC6_GR_VIN_AB1_GR_VIN_SCL_UND_SEL                                     (0x00000004u)
#define VDC6_GR_VIN_AB1_GR_VIN_SCL_UND_SEL_SHIFT                               (2u)

#endif
