/**
  ******************************************************************************
  * @file    stm32l552xx.h
  * @author  MCD Application Team
  * @brief   CMSIS STM32L552xx Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripheral’s registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under Apache License, Version 2.0,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/Apache-2.0
  *
  ******************************************************************************
  */

#ifndef STM32L552xx_H
#define STM32L552xx_H

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup ST
  * @{
  */


/** @addtogroup STM32L552xx
  * @{
  */


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum
{
/* =======================================  ARM Cortex-M33 Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,    /*!< -15 Reset Vector, invoked on Power up and warm reset             */
  NonMaskableInt_IRQn       = -14,    /*!< -14 Non maskable Interrupt, cannot be stopped or preempted       */
  HardFault_IRQn            = -13,    /*!< -13 Hard Fault, all classes of Fault                             */
  MemoryManagement_IRQn     = -12,    /*!< -12 Memory Management, MPU mismatch, including Access Violation
                                               and No Match                                                  */
  BusFault_IRQn             = -11,    /*!< -11 Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                               related Fault                                                 */
  UsageFault_IRQn           = -10,    /*!< -10 Usage Fault, i.e. Undef Instruction, Illegal State Transition */
  SecureFault_IRQn          =  -9,    /*!< -9  Secure Fault                                                  */
  SVCall_IRQn               =  -5,    /*!< -5  System Service Call via SVC instruction                       */
  DebugMonitor_IRQn         =  -4,    /*!< -4  Debug Monitor                                                 */
  PendSV_IRQn               =  -2,    /*!< -2  Pendable request for system service                           */
  SysTick_IRQn              =  -1,    /*!< -1  System Tick Timer                                             */

/* ===========================================  STM32L552xx Specific Interrupt Numbers  ========================================= */
  WWDG_IRQn                 = 0,      /*!< Window WatchDog interrupt                                         */
  PVD_PVM_IRQn              = 1,      /*!< PVD/PVM1/PVM2/PVM3/PVM4 through EXTI Line detection interrupts    */
  RTC_IRQn                  = 2,      /*!< RTC non-secure interrupts through the EXTI line 17                */
  RTC_S_IRQn                = 3,      /*!< RTC secure interrupts through the EXTI line 18                    */
  TAMP_IRQn                 = 4,      /*!< Tamper non-secure interrupts through the EXTI line 19             */
  TAMP_S_IRQn               = 5,      /*!< Tamper and TimeStamp interrupts through the EXTI line 20          */
  FLASH_IRQn                = 6,      /*!< FLASH non-secure global interrupt                                 */
  FLASH_S_IRQn              = 7,      /*!< FLASH secure global interrupt                                     */
  GTZC_IRQn                 = 8,      /*!< Global TrustZone controller global interrupt                      */
  RCC_IRQn                  = 9,      /*!< RCC non secure global interrupt                                   */
  RCC_S_IRQn                = 10,     /*!< RCC secure global interrupt                                       */
  EXTI0_IRQn                = 11,     /*!< EXTI Line0 interrupt                                              */
  EXTI1_IRQn                = 12,     /*!< EXTI Line1 interrupt                                              */
  EXTI2_IRQn                = 13,     /*!< EXTI Line2 interrupt                                              */
  EXTI3_IRQn                = 14,     /*!< EXTI Line3 interrupt                                              */
  EXTI4_IRQn                = 15,     /*!< EXTI Line4 interrupt                                              */
  EXTI5_IRQn                = 16,     /*!< EXTI Line5 interrupt                                              */
  EXTI6_IRQn                = 17,     /*!< EXTI Line6 interrupt                                              */
  EXTI7_IRQn                = 18,     /*!< EXTI Line7 interrupt                                              */
  EXTI8_IRQn                = 19,     /*!< EXTI Line8 interrupt                                              */
  EXTI9_IRQn                = 20,     /*!< EXTI Line9 interrupt                                              */
  EXTI10_IRQn               = 21,     /*!< EXTI Line10 interrupt                                             */
  EXTI11_IRQn               = 22,     /*!< EXTI Line11 interrupt                                             */
  EXTI12_IRQn               = 23,     /*!< EXTI Line12 interrupt                                             */
  EXTI13_IRQn               = 24,     /*!< EXTI Line13 interrupt                                             */
  EXTI14_IRQn               = 25,     /*!< EXTI Line14 interrupt                                             */
  EXTI15_IRQn               = 26,     /*!< EXTI Line15 interrupt                                             */
  DMAMUX1_IRQn              = 27,     /*!< DMAMUX1 non-secure interrupt                                      */
  DMAMUX1_S_IRQn            = 28,     /*!< DMAMUX1 secure interrupt                                          */
  DMA1_Channel1_IRQn        = 29,     /*!< DMA1 Channel 1 global interrupt                                   */
  DMA1_Channel2_IRQn        = 30,     /*!< DMA1 Channel 2 global interrupt                                   */
  DMA1_Channel3_IRQn        = 31,     /*!< DMA1 Channel 3 global interrupt                                   */
  DMA1_Channel4_IRQn        = 32,     /*!< DMA1 Channel 4 global interrupt                                   */
  DMA1_Channel5_IRQn        = 33,     /*!< DMA1 Channel 5 global interrupt                                   */
  DMA1_Channel6_IRQn        = 34,     /*!< DMA1 Channel 6 global interrupt                                   */
  DMA1_Channel7_IRQn        = 35,     /*!< DMA1 Channel 7 global interrupt                                   */
  DMA1_Channel8_IRQn        = 36,     /*!< DMA1 Channel 8 global interrupt                                   */
  ADC1_2_IRQn               = 37,     /*!< ADC1 & ADC2 global interrupts                                     */
  DAC_IRQn                  = 38,     /*!< DAC global interrupts                                             */
  FDCAN1_IT0_IRQn           = 39,     /*!< FDCAN1 interrupt 0                                                */
  FDCAN1_IT1_IRQn           = 40,     /*!< FDCAN1 interrupt 1                                                */
  TIM1_BRK_IRQn             = 41,     /*!< TIM1 Break interrupt                                              */
  TIM1_UP_IRQn              = 42,     /*!< TIM1 Update interrupt                                             */
  TIM1_TRG_COM_IRQn         = 43,     /*!< TIM1 Trigger and Commutation interrupt                            */
  TIM1_CC_IRQn              = 44,     /*!< TIM1 Capture Compare interrupt                                    */
  TIM2_IRQn                 = 45,     /*!< TIM2 global interrupt                                             */
  TIM3_IRQn                 = 46,     /*!< TIM3 global interrupt                                             */
  TIM4_IRQn                 = 47,     /*!< TIM4 global interrupt                                             */
  TIM5_IRQn                 = 48,     /*!< TIM5 global interrupt                                             */
  TIM6_IRQn                 = 49,     /*!< TIM6 global interrupt                                             */
  TIM7_IRQn                 = 50,     /*!< TIM7 global interrupt                                             */
  TIM8_BRK_IRQn             = 51,     /*!< TIM8 Break interrupt                                              */
  TIM8_UP_IRQn              = 52,     /*!< TIM8 Update interrupt                                             */
  TIM8_TRG_COM_IRQn         = 53,     /*!< TIM8 Trigger and Commutation interrupt                            */
  TIM8_CC_IRQn              = 54,     /*!< TIM8 Capture Compare interrupt                                    */
  I2C1_EV_IRQn              = 55,     /*!< I2C1 Event interrupt                                              */
  I2C1_ER_IRQn              = 56,     /*!< I2C1 Error interrupt                                              */
  I2C2_EV_IRQn              = 57,     /*!< I2C2 Event interrupt                                              */
  I2C2_ER_IRQn              = 58,     /*!< I2C2 Error interrupt                                              */
  SPI1_IRQn                 = 59,     /*!< SPI1 global interrupt                                             */
  SPI2_IRQn                 = 60,     /*!< SPI2 global interrupt                                             */
  USART1_IRQn               = 61,     /*!< USART1 global interrupt                                           */
  USART2_IRQn               = 62,     /*!< USART2 global interrupt                                           */
  USART3_IRQn               = 63,     /*!< USART3 global interrupt                                           */
  UART4_IRQn                = 64,     /*!< UART4 global interrupt                                            */
  UART5_IRQn                = 65,     /*!< UART5 global interrupt                                            */
  LPUART1_IRQn              = 66,     /*!< LPUART1 global interrupt                                          */
  LPTIM1_IRQn               = 67,     /*!< LPTIM1 global interrupt                                           */
  LPTIM2_IRQn               = 68,     /*!< LPTIM2 global interrupt                                           */
  TIM15_IRQn                = 69,     /*!< TIM15 global interrupt                                            */
  TIM16_IRQn                = 70,     /*!< TIM16 global interrupt                                            */
  TIM17_IRQn                = 71,     /*!< TIM17 global interrupt                                            */
  COMP_IRQn                 = 72,     /*!< COMP1 and COMP2 through EXTI Lines interrupts                     */
  USB_FS_IRQn               = 73,     /*!< USB FS global interrupt                                           */
  CRS_IRQn                  = 74,     /*!< CRS global interrupt                                              */
  FMC_IRQn                  = 75,     /*!< FMC global interrupt                                              */
  OCTOSPI1_IRQn             = 76,     /*!< OctoSPI1 global interrupt                                         */
  SDMMC1_IRQn               = 78,     /*!< SDMMC1 global interrupt                                           */
  DMA2_Channel1_IRQn        = 80,     /*!< DMA2 Channel 1 global interrupt                                   */
  DMA2_Channel2_IRQn        = 81,     /*!< DMA2 Channel 2 global interrupt                                   */
  DMA2_Channel3_IRQn        = 82,     /*!< DMA2 Channel 3 global interrupt                                   */
  DMA2_Channel4_IRQn        = 83,     /*!< DMA2 Channel 4 global interrupt                                   */
  DMA2_Channel5_IRQn        = 84,     /*!< DMA2 Channel 5 global interrupt                                   */
  DMA2_Channel6_IRQn        = 85,     /*!< DMA2 Channel 6 global interrupt                                   */
  DMA2_Channel7_IRQn        = 86,     /*!< DMA2 Channel 7 global interrupt                                   */
  DMA2_Channel8_IRQn        = 87,     /*!< DMA2 Channel 8 global interrupt                                   */
  I2C3_EV_IRQn              = 88,     /*!< I2C3 event interrupt                                              */
  I2C3_ER_IRQn              = 89,     /*!< I2C3 error interrupt                                              */
  SAI1_IRQn                 = 90,     /*!< Serial Audio Interface 1 global interrupt                         */
  SAI2_IRQn                 = 91,     /*!< Serial Audio Interface 2 global interrupt                         */
  TSC_IRQn                  = 92,     /*!< Touch Sense Controller global interrupt                           */
  RNG_IRQn                  = 94,     /*!< RNG global interrupt                                              */
  FPU_IRQn                  = 95,     /*!< FPU global interrupt                                              */
  HASH_IRQn                 = 96,     /*!< HASH global interrupt                                             */
  LPTIM3_IRQn               = 98,     /*!< LPTIM3 global interrupt                                           */
  SPI3_IRQn                 = 99,     /*!< SPI3 global interrupt                                             */
  I2C4_EV_IRQn              = 100,    /*!< I2C4 Event interrupt                                              */
  I2C4_ER_IRQn              = 101,    /*!< I2C4 Error interrupt                                              */
  DFSDM1_FLT0_IRQn          = 102,    /*!< DFSDM1 Filter 0 global interrupt                                  */
  DFSDM1_FLT1_IRQn          = 103,    /*!< DFSDM1 Filter 1 global interrupt                                  */
  DFSDM1_FLT2_IRQn          = 104,    /*!< DFSDM1 Filter 2 global interrupt                                  */
  DFSDM1_FLT3_IRQn          = 105,    /*!< DFSDM1 Filter 3 global interrupt                                  */
  UCPD1_IRQn                = 106,    /*!< UCPD1 global interrupt                                            */
  ICACHE_IRQn               = 107,    /*!< Instruction cache global interrupt                                */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif

/* --------  Configuration of the Cortex-M33 Processor and Core Peripherals  ------ */
#define __CM33_REV                0x0000U   /* Core revision r0p1 */
#define __SAUREGION_PRESENT       1U        /* SAU regions present */
#define __MPU_PRESENT             1U        /* MPU present */
#define __VTOR_PRESENT            1U        /* VTOR present */
#define __NVIC_PRIO_BITS          3U        /* Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig    0U        /* Set to 1 if different SysTick Config is used */
#define __FPU_PRESENT             1U        /* FPU present */
#define __DSP_PRESENT             1U        /* DSP extension present */

/** @} */ /* End of group Configuration_of_CMSIS */


#include <core_cm33.h>                       /*!< ARM Cortex-M33 processor and core peripherals */
#include "system_stm32l5xx.h"                /*!< STM32L5xx System */


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32L5xx_peripherals
  * @{
  */

/**
  * @brief Analog to Digital Converter
  */
typedef struct
{
  __IO uint32_t ISR;          /*!< ADC interrupt and status register,             Address offset: 0x00 */
  __IO uint32_t IER;          /*!< ADC interrupt enable register,                 Address offset: 0x04 */
  __IO uint32_t CR;           /*!< ADC control register,                          Address offset: 0x08 */
  __IO uint32_t CFGR;         /*!< ADC configuration register 1,                  Address offset: 0x0C */
  __IO uint32_t CFGR2;        /*!< ADC configuration register 2,                  Address offset: 0x10 */
  __IO uint32_t SMPR1;        /*!< ADC sampling time register 1,                  Address offset: 0x14 */
  __IO uint32_t SMPR2;        /*!< ADC sampling time register 2,                  Address offset: 0x18 */
       uint32_t RESERVED1;    /*!< Reserved,                                                      0x1C */
  __IO uint32_t TR1;          /*!< ADC analog watchdog 1 threshold register,      Address offset: 0x20 */
  __IO uint32_t TR2;          /*!< ADC analog watchdog 2 threshold register,      Address offset: 0x24 */
  __IO uint32_t TR3;          /*!< ADC analog watchdog 3 threshold register,      Address offset: 0x28 */
       uint32_t RESERVED2;    /*!< Reserved,                                                      0x2C */
  __IO uint32_t SQR1;         /*!< ADC group regular sequencer register 1,        Address offset: 0x30 */
  __IO uint32_t SQR2;         /*!< ADC group regular sequencer register 2,        Address offset: 0x34 */
  __IO uint32_t SQR3;         /*!< ADC group regular sequencer register 3,        Address offset: 0x38 */
  __IO uint32_t SQR4;         /*!< ADC group regular sequencer register 4,        Address offset: 0x3C */
  __IO uint32_t DR;           /*!< ADC group regular data register,               Address offset: 0x40 */
       uint32_t RESERVED3;    /*!< Reserved,                                                      0x44 */
       uint32_t RESERVED4;    /*!< Reserved,                                                      0x48 */
  __IO uint32_t JSQR;         /*!< ADC group injected sequencer register,         Address offset: 0x4C */
       uint32_t RESERVED5[4]; /*!< Reserved,                                               0x50 - 0x5C */
  __IO uint32_t OFR1;         /*!< ADC offset register 1,                         Address offset: 0x60 */
  __IO uint32_t OFR2;         /*!< ADC offset register 2,                         Address offset: 0x64 */
  __IO uint32_t OFR3;         /*!< ADC offset register 3,                         Address offset: 0x68 */
  __IO uint32_t OFR4;         /*!< ADC offset register 4,                         Address offset: 0x6C */
       uint32_t RESERVED6[4]; /*!< Reserved,                                               0x70 - 0x7C */
  __IO uint32_t JDR1;         /*!< ADC group injected rank 1 data register,       Address offset: 0x80 */
  __IO uint32_t JDR2;         /*!< ADC group injected rank 2 data register,       Address offset: 0x84 */
  __IO uint32_t JDR3;         /*!< ADC group injected rank 3 data register,       Address offset: 0x88 */
  __IO uint32_t JDR4;         /*!< ADC group injected rank 4 data register,       Address offset: 0x8C */
       uint32_t RESERVED7[4]; /*!< Reserved,                                             0x090 - 0x09C */
  __IO uint32_t AWD2CR;       /*!< ADC analog watchdog 1 configuration register,  Address offset: 0xA0 */
  __IO uint32_t AWD3CR;       /*!< ADC analog watchdog 3 Configuration Register,  Address offset: 0xA4 */
       uint32_t RESERVED8;    /*!< Reserved,                                                     0x0A8 */
       uint32_t RESERVED9;    /*!< Reserved,                                                     0x0AC */
  __IO uint32_t DIFSEL;       /*!< ADC differential mode selection register,      Address offset: 0xB0 */
  __IO uint32_t CALFACT;      /*!< ADC calibration factors,                       Address offset: 0xB4 */
} ADC_TypeDef;

typedef struct
{
  __IO uint32_t CSR;          /*!< ADC common status register,                    Address offset: ADC1 base address + 0x300 */
  uint32_t      RESERVED;     /*!< Reserved,                                      Address offset: ADC1 base address + 0x304 */
  __IO uint32_t CCR;          /*!< ADC common configuration register,             Address offset: ADC1 base address + 0x308 */
  __IO uint32_t CDR;          /*!< ADC common group regular data register         Address offset: ADC1 base address + 0x30C */
} ADC_Common_TypeDef;

/**
  * @brief FD Controller Area Network
  */

typedef struct
{
  __IO uint32_t CREL;         /*!< FDCAN Core Release register,                                     Address offset: 0x000 */
  __IO uint32_t ENDN;         /*!< FDCAN Endian register,                                           Address offset: 0x004 */
       uint32_t RESERVED1;    /*!< Reserved,                                                                        0x008 */
  __IO uint32_t DBTP;         /*!< FDCAN Data Bit Timing & Prescaler register,                      Address offset: 0x00C */
  __IO uint32_t TEST;         /*!< FDCAN Test register,                                             Address offset: 0x010 */
  __IO uint32_t RWD;          /*!< FDCAN RAM Watchdog register,                                     Address offset: 0x014 */
  __IO uint32_t CCCR;         /*!< FDCAN CC Control register,                                       Address offset: 0x018 */
  __IO uint32_t NBTP;         /*!< FDCAN Nominal Bit Timing & Prescaler register,                   Address offset: 0x01C */
  __IO uint32_t TSCC;         /*!< FDCAN Timestamp Counter Configuration register,                  Address offset: 0x020 */
  __IO uint32_t TSCV;         /*!< FDCAN Timestamp Counter Value register,                          Address offset: 0x024 */
  __IO uint32_t TOCC;         /*!< FDCAN Timeout Counter Configuration register,                    Address offset: 0x028 */
  __IO uint32_t TOCV;         /*!< FDCAN Timeout Counter Value register,                            Address offset: 0x02C */
       uint32_t RESERVED2[4]; /*!< Reserved,                                                                0x030 - 0x03C */
  __IO uint32_t ECR;          /*!< FDCAN Error Counter register,                                    Address offset: 0x040 */
  __IO uint32_t PSR;          /*!< FDCAN Protocol Status register,                                  Address offset: 0x044 */
  __IO uint32_t TDCR;         /*!< FDCAN Transmitter Delay Compensation register,                   Address offset: 0x048 */
       uint32_t RESERVED3;    /*!< Reserved,                                                                        0x04C */
  __IO uint32_t IR;           /*!< FDCAN Interrupt register,                                        Address offset: 0x050 */
  __IO uint32_t IE;           /*!< FDCAN Interrupt Enable register,                                 Address offset: 0x054 */
  __IO uint32_t ILS;          /*!< FDCAN Interrupt Line Select register,                            Address offset: 0x058 */
  __IO uint32_t ILE;          /*!< FDCAN Interrupt Line Enable register,                            Address offset: 0x05C */
       uint32_t RESERVED4[8]; /*!< Reserved,                                                                0x060 - 0x07C */
  __IO uint32_t RXGFC;        /*!< FDCAN Global Filter Configuration register,                      Address offset: 0x080 */
  __IO uint32_t XIDAM;        /*!< FDCAN Extended ID AND Mask register,                             Address offset: 0x084 */
  __IO uint32_t HPMS;         /*!< FDCAN High Priority Message Status register,                     Address offset: 0x088 */
       uint32_t RESERVED5;    /*!< Reserved,                                                                        0x08C */
  __IO uint32_t RXF0S;        /*!< FDCAN Rx FIFO 0 Status register,                                 Address offset: 0x090 */
  __IO uint32_t RXF0A;        /*!< FDCAN Rx FIFO 0 Acknowledge register,                            Address offset: 0x094 */
  __IO uint32_t RXF1S;        /*!< FDCAN Rx FIFO 1 Status register,                                 Address offset: 0x098 */
  __IO uint32_t RXF1A;        /*!< FDCAN Rx FIFO 1 Acknowledge register,                            Address offset: 0x09C */
       uint32_t RESERVED6[8]; /*!< Reserved,                                                                0x0A0 - 0x0BC */
  __IO uint32_t TXBC;         /*!< FDCAN Tx Buffer Configuration register,                          Address offset: 0x0C0 */
  __IO uint32_t TXFQS;        /*!< FDCAN Tx FIFO/Queue Status register,                             Address offset: 0x0C4 */
  __IO uint32_t TXBRP;        /*!< FDCAN Tx Buffer Request Pending register,                        Address offset: 0x0C8 */
  __IO uint32_t TXBAR;        /*!< FDCAN Tx Buffer Add Request register,                            Address offset: 0x0CC */
  __IO uint32_t TXBCR;        /*!< FDCAN Tx Buffer Cancellation Request register,                   Address offset: 0x0D0 */
  __IO uint32_t TXBTO;        /*!< FDCAN Tx Buffer Transmission Occurred register,                  Address offset: 0x0D4 */
  __IO uint32_t TXBCF;        /*!< FDCAN Tx Buffer Cancellation Finished register,                  Address offset: 0x0D8 */
  __IO uint32_t TXBTIE;       /*!< FDCAN Tx Buffer Transmission Interrupt Enable register,          Address offset: 0x0DC */
  __IO uint32_t TXBCIE;       /*!< FDCAN Tx Buffer Cancellation Finished Interrupt Enable register, Address offset: 0x0E0 */
  __IO uint32_t TXEFS;        /*!< FDCAN Tx Event FIFO Status register,                             Address offset: 0x0E4 */
  __IO uint32_t TXEFA;        /*!< FDCAN Tx Event FIFO Acknowledge register,                        Address offset: 0x0E8 */
} FDCAN_GlobalTypeDef;

/**
  * @brief FD Controller Area Network Configuration
  */

typedef struct
{
  __IO uint32_t CKDIV;        /*!< FDCAN clock divider register,                            Address offset: 0x100 + 0x000 */
       uint32_t RESERVED1[128];/*!< Reserved,                                               0x100 + 0x004 - 0x100 + 0x200 */
  __IO uint32_t OPTR;         /*!< FDCAN option register,                                   Address offset: 0x100 + 0x204 */
} FDCAN_Config_TypeDef;

/**
  * @brief CRC calculation unit
  */
typedef struct
{
  __IO uint32_t DR;          /*!< CRC Data register,                           Address offset: 0x00 */
  __IO uint32_t IDR;         /*!< CRC Independent data register,               Address offset: 0x04 */
  __IO uint32_t CR;          /*!< CRC Control register,                        Address offset: 0x08 */
       uint32_t RESERVED2;   /*!< Reserved,                                                    0x0C */
  __IO uint32_t INIT;        /*!< Initial CRC value register,                  Address offset: 0x10 */
  __IO uint32_t POL;         /*!< CRC polynomial register,                     Address offset: 0x14 */
} CRC_TypeDef;

/**
  * @brief Clock Recovery System
  */
typedef struct
{
__IO uint32_t CR;            /*!< CRS ccontrol register,              Address offset: 0x00 */
__IO uint32_t CFGR;          /*!< CRS configuration register,         Address offset: 0x04 */
__IO uint32_t ISR;           /*!< CRS interrupt and status register,  Address offset: 0x08 */
__IO uint32_t ICR;           /*!< CRS interrupt flag clear register,  Address offset: 0x0C */
} CRS_TypeDef;

/**
  * @brief Comparator
  */

typedef struct
{
  __IO uint32_t CSR;         /*!< COMP control and status register, Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR;         /*!< COMP control and status register, used for bits common to several COMP instances, Address offset: 0x00 */
} COMP_Common_TypeDef;

/**
  * @brief Digital to Analog Converter
  */

typedef struct
{
  __IO uint32_t CR;          /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;     /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;     /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;     /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;      /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;     /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;     /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;      /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;     /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;     /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;      /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;        /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;        /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;          /*!< DAC status register,                                     Address offset: 0x34 */
  __IO uint32_t CCR;         /*!< DAC calibration control register,                        Address offset: 0x38 */
  __IO uint32_t MCR;         /*!< DAC mode control register,                               Address offset: 0x3C */
  __IO uint32_t SHSR1;       /*!< DAC Sample and Hold sample time register 1,              Address offset: 0x40 */
  __IO uint32_t SHSR2;       /*!< DAC Sample and Hold sample time register 2,              Address offset: 0x44 */
  __IO uint32_t SHHR;        /*!< DAC Sample and Hold hold time register,                  Address offset: 0x48 */
  __IO uint32_t SHRR;        /*!< DAC Sample and Hold refresh time register,               Address offset: 0x4C */
} DAC_TypeDef;

/**
  * @brief DFSDM module registers
  */
typedef struct
{
  __IO uint32_t FLTCR1;      /*!< DFSDM control register1,                          Address offset: 0x100 */
  __IO uint32_t FLTCR2;      /*!< DFSDM control register2,                          Address offset: 0x104 */
  __IO uint32_t FLTISR;      /*!< DFSDM interrupt and status register,              Address offset: 0x108 */
  __IO uint32_t FLTICR;      /*!< DFSDM interrupt flag clear register,              Address offset: 0x10C */
  __IO uint32_t FLTJCHGR;    /*!< DFSDM injected channel group selection register,  Address offset: 0x110 */
  __IO uint32_t FLTFCR;      /*!< DFSDM filter control register,                    Address offset: 0x114 */
  __IO uint32_t FLTJDATAR;   /*!< DFSDM data register for injected group,           Address offset: 0x118 */
  __IO uint32_t FLTRDATAR;   /*!< DFSDM data register for regular group,            Address offset: 0x11C */
  __IO uint32_t FLTAWHTR;    /*!< DFSDM analog watchdog high threshold register,    Address offset: 0x120 */
  __IO uint32_t FLTAWLTR;    /*!< DFSDM analog watchdog low threshold register,     Address offset: 0x124 */
  __IO uint32_t FLTAWSR;     /*!< DFSDM analog watchdog status register             Address offset: 0x128 */
  __IO uint32_t FLTAWCFR;    /*!< DFSDM analog watchdog clear flag register         Address offset: 0x12C */
  __IO uint32_t FLTEXMAX;    /*!< DFSDM extreme detector maximum register,          Address offset: 0x130 */
  __IO uint32_t FLTEXMIN;    /*!< DFSDM extreme detector minimum register           Address offset: 0x134 */
  __IO uint32_t FLTCNVTIMR;  /*!< DFSDM conversion timer,                           Address offset: 0x138 */
} DFSDM_Filter_TypeDef;

/**
  * @brief DFSDM channel configuration registers
  */
typedef struct
{
  __IO uint32_t CHCFGR1;     /*!< DFSDM channel configuration register1,            Address offset: 0x00 */
  __IO uint32_t CHCFGR2;     /*!< DFSDM channel configuration register2,            Address offset: 0x04 */
  __IO uint32_t CHAWSCDR;    /*!< DFSDM channel analog watchdog and
                                  short circuit detector register,                  Address offset: 0x08 */
  __IO uint32_t CHWDATAR;    /*!< DFSDM channel watchdog filter data register,      Address offset: 0x0C */
  __IO uint32_t CHDATINR;    /*!< DFSDM channel data input register,                Address offset: 0x10 */
  __IO uint32_t CHDLYR;      /*!< DFSDM channel delay register,                     Address offset: 0x14 */
} DFSDM_Channel_TypeDef;

/**
  * @brief Debug MCU
  */
typedef struct
{
  __IO uint32_t IDCODE;      /*!< MCU device ID code,                 Address offset: 0x00 */
  __IO uint32_t CR;          /*!< Debug MCU configuration register,   Address offset: 0x04 */
  __IO uint32_t APB1FZR1;    /*!< Debug MCU APB1 freeze register 1,   Address offset: 0x08 */
  __IO uint32_t APB1FZR2;    /*!< Debug MCU APB1 freeze register 2,   Address offset: 0x0C */
  __IO uint32_t APB2FZR;     /*!< Debug MCU APB2 freeze register,     Address offset: 0x10 */
} DBGMCU_TypeDef;

/**
  * @brief DMA Controller
  */

typedef struct
{
  __IO uint32_t ISR;         /*!< DMA interrupt status register,                 Address offset: 0x00 */
  __IO uint32_t IFCR;        /*!< DMA interrupt flag clear register,             Address offset: 0x04 */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t CCR;         /*!< DMA channel x configuration register,          Address offset: 0x08 + (x * 0x14) */
  __IO uint32_t CNDTR;       /*!< DMA channel x number of data register,         Address offset: 0x0C + (x * 0x14) */
  __IO uint32_t CPAR;        /*!< DMA channel x peripheral address register,     Address offset: 0x10 + (x * 0x14) */
  __IO uint32_t CM0AR;       /*!< DMA channel x memory 0 address register,       Address offset: 0x14 + (x * 0x14) */
  __IO uint32_t CM1AR;       /*!< DMA channel x memory 1 address register,       Address offset: 0x18 + (x * 0x14) */
} DMA_Channel_TypeDef;

/**
  * @brief DMA Multiplexer
  */

typedef struct
{
  __IO uint32_t   CCR;      /*!< DMA Multiplexer Channel x Control Register    Address offset: 0x0004 * (channel x) */
} DMAMUX_Channel_TypeDef;

typedef struct
{
  __IO uint32_t   CSR;      /*!< DMA Channel Status Register                    Address offset: 0x0080   */
  __IO uint32_t   CFR;      /*!< DMA Channel Clear Flag Register                Address offset: 0x0084   */
} DMAMUX_ChannelStatus_TypeDef;

typedef struct
{
  __IO uint32_t   RGCR;        /*!< DMA Request Generator x Control Register     Address offset: 0x0100 + 0x0004 * (Req Gen x) */
} DMAMUX_RequestGen_TypeDef;

typedef struct
{
  __IO uint32_t   RGSR;        /*!< DMA Request Generator Status Register        Address offset: 0x0140   */
  __IO uint32_t   RGCFR;       /*!< DMA Request Generator Clear Flag Register    Address offset: 0x0144   */
} DMAMUX_RequestGenStatus_TypeDef;

/**
  * @brief Asynch Interrupt/Event Controller (EXTI)
  */
typedef struct
{
  __IO uint32_t RTSR1;          /*!< EXTI Rising Trigger Selection Register 1,        Address offset:   0x00 */
  __IO uint32_t FTSR1;          /*!< EXTI Falling Trigger Selection Register 1,       Address offset:   0x04 */
  __IO uint32_t SWIER1;         /*!< EXTI Software Interrupt event Register 1,        Address offset:   0x08 */
  __IO uint32_t RPR1;           /*!< EXTI Rising Pending Register 1,                  Address offset:   0x0C */
  __IO uint32_t FPR1;           /*!< EXTI Falling Pending Register 1,                 Address offset:   0x10 */
  __IO uint32_t SECCFGR1;       /*!< EXTI Security Configuration Register 1,          Address offset:   0x14 */
  __IO uint32_t PRIVCFGR1;      /*!< EXTI Privilege Configuration Register 1,         Address offset:   0x18 */
       uint32_t RESERVED1;      /*!< Reserved 1,                                                        0x1C */
  __IO uint32_t RTSR2;          /*!< EXTI Rising Trigger Selection Register 2,        Address offset:   0x20 */
  __IO uint32_t FTSR2;          /*!< EXTI Falling Trigger Selection Register 2,       Address offset:   0x24 */
  __IO uint32_t SWIER2;         /*!< EXTI Software Interrupt event Register 2,        Address offset:   0x28 */
  __IO uint32_t RPR2;           /*!< EXTI Rising Pending Register 2,                  Address offset:   0x2C */
  __IO uint32_t FPR2;           /*!< EXTI Falling Pending Register 2,                 Address offset:   0x30 */
  __IO uint32_t SECCFGR2;       /*!< EXTI Security Configuration Register 2,          Address offset:   0x34 */
  __IO uint32_t PRIVCFGR2;      /*!< EXTI Privilege Configuration Register 2,         Address offset:   0x38 */
       uint32_t RESERVED2[9];   /*!< Reserved 2,                                                0x3C -- 0x5C */
  __IO uint32_t EXTICR[4];      /*!< EXTI External Interrupt Configuration Register,            0x60 -- 0x6C */
  __IO uint32_t LOCKR;          /*!< EXTI Lock Register,                              Address offset:   0x70 */
       uint32_t RESERVED3[3];   /*!< Reserved 3,                                                0x74 -- 0x7C */
  __IO uint32_t IMR1;           /*!< EXTI Interrupt Mask Register 1,                  Address offset:   0x80 */
  __IO uint32_t EMR1;           /*!< EXTI Event Mask Register 1,                      Address offset:   0x84 */
       uint32_t RESERVED4[2];   /*!< Reserved 4,                                                0x88 -- 0x8C */
  __IO uint32_t IMR2;           /*!< EXTI Interrupt Mask Register 2,                  Address offset:   0x90 */
  __IO uint32_t EMR2;           /*!< EXTI Event Mask Register 2,                      Address offset:   0x94 */
} EXTI_TypeDef;

/**
  * @brief FLASH Registers
  */

typedef struct
{
  __IO uint32_t ACR;              /*!< FLASH access control register,                  Address offset: 0x00 */
  __IO uint32_t PDKEYR;           /*!< FLASH power down key register,                  Address offset: 0x04 */
  __IO uint32_t NSKEYR;           /*!< FLASH non-secure key register,                  Address offset: 0x08 */
  __IO uint32_t SECKEYR;          /*!< FLASH secure key register,                      Address offset: 0x0C */
  __IO uint32_t OPTKEYR;          /*!< FLASH option key register,                      Address offset: 0x10 */
  __IO uint32_t LVEKEYR;          /*!< FLASH LVE key register,                         Address offset: 0x14 */
  __IO uint32_t RESERVED1[2];     /*!< Reserved1,                                      Address offset: 0x18-0x1C */
  __IO uint32_t NSSR;             /*!< FLASH non-secure status register,               Address offset: 0x20 */
  __IO uint32_t SECSR;            /*!< FLASH secure status register,                   Address offset: 0x24 */
  __IO uint32_t NSCR;             /*!< FLASH non-secure control register,              Address offset: 0x28 */
  __IO uint32_t SECCR;            /*!< FLASH secure control register,                  Address offset: 0x2C */
  __IO uint32_t ECCR;             /*!< FLASH ECC register,                             Address offset: 0x30 */
  __IO uint32_t RESERVED2[3];     /*!< Reserved2,                                      Address offset: 0x34-0x3C */
  __IO uint32_t OPTR;             /*!< FLASH option control register,                  Address offset: 0x40 */
  __IO uint32_t NSBOOTADD0R;      /*!< FLASH non-secure boot address 0 register,       Address offset: 0x44 */
  __IO uint32_t NSBOOTADD1R;      /*!< FLASH non-secure boot address 1 register,       Address offset: 0x48 */
  __IO uint32_t SECBOOTADD0R;     /*!< FLASH secure boot address 0 register,           Address offset: 0x4C */
  __IO uint32_t SECWM1R1;         /*!< FLASH watermark-based secure register 1 bank 1, Address offset: 0x50 */
  __IO uint32_t SECWM1R2;         /*!< FLASH watermark-based secure register 2 bank 1, Address offset: 0x54 */
  __IO uint32_t WRP1AR;           /*!< FLASH WRP area A register bank 1,               Address offset: 0x58 */
  __IO uint32_t WRP1BR;           /*!< FLASH WRP area B register bank 1,               Address offset: 0x5C */
  __IO uint32_t SECWM2R1;         /*!< FLASH watermark-based secure register 1 bank 2, Address offset: 0x60 */
  __IO uint32_t SECWM2R2;         /*!< FLASH watermark-based secure register 2 bank 2, Address offset: 0x64 */
  __IO uint32_t WRP2AR;           /*!< FLASH WRP area A register bank 2,               Address offset: 0x68 */
  __IO uint32_t WRP2BR;           /*!< FLASH WRP area B register bank 2,               Address offset: 0x6C */
  __IO uint32_t RESERVED3[4];     /*!< Reserved3,                                      Address offset: 0x70-0x7C */
  __IO uint32_t SECBB1R1;         /*!< FLASH block-based secure bank 1,                Address offset: 0x80 */
  __IO uint32_t SECBB1R2;         /*!< FLASH block-based secure bank 1,                Address offset: 0x84 */
  __IO uint32_t SECBB1R3;         /*!< FLASH block-based secure bank 1,                Address offset: 0x88 */
  __IO uint32_t SECBB1R4;         /*!< FLASH block-based secure bank 1,                Address offset: 0x8C */
  __IO uint32_t RESERVED4[4];     /*!< Reserved4,                                      Address offset: 0x90-0x9C */
  __IO uint32_t SECBB2R1;         /*!< FLASH block-based secure bank 2,                Address offset: 0xA0 */
  __IO uint32_t SECBB2R2;         /*!< FLASH block-based secure bank 2,                Address offset: 0xA4 */
  __IO uint32_t SECBB2R3;         /*!< FLASH block-based secure bank 2,                Address offset: 0xA8 */
  __IO uint32_t SECBB2R4;         /*!< FLASH block-based secure bank 2,                Address offset: 0xAC */
  __IO uint32_t RESERVED5[4];     /*!< Reserved5,                                      Address offset: 0xB0-0xBC */
  __IO uint32_t SECHDPCR;         /*!< FLASH secure HDP control register,              Address offset: 0xC0 */
  __IO uint32_t PRIVCFGR;         /*!< FLASH privilege configuration register,         Address offset: 0xC4 */
} FLASH_TypeDef;

/**
  * @brief Flexible Memory Controller
  */

typedef struct
{
  __IO uint32_t BTCR[8];     /*!< NOR/PSRAM chip-select control register(BCR) and chip-select timing register(BTR), Address offset: 0x00-1C */
  __IO uint32_t PCSCNTR;     /*!< PSRAM chip-select counter register,                                               Address offset:    0x20 */
} FMC_Bank1_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1E
  */

typedef struct
{
  __IO uint32_t BWTR[7];     /*!< NOR/PSRAM write timing registers, Address offset: 0x104-0x11C */
} FMC_Bank1E_TypeDef;

/**
  * @brief Flexible Memory Controller Bank3
  */

typedef struct
{
  __IO uint32_t PCR;        /*!< NAND Flash control register,                       Address offset: 0x80 */
  __IO uint32_t SR;         /*!< NAND Flash FIFO status and interrupt register,     Address offset: 0x84 */
  __IO uint32_t PMEM;       /*!< NAND Flash Common memory space timing register,    Address offset: 0x88 */
  __IO uint32_t PATT;       /*!< NAND Flash Attribute memory space timing register, Address offset: 0x8C */
  uint32_t      RESERVED0;  /*!< Reserved, 0x90                                                            */
  __IO uint32_t ECCR;       /*!< NAND Flash ECC result registers,                   Address offset: 0x94 */
} FMC_Bank3_TypeDef;

/**
  * @brief General Purpose I/O
  */

typedef struct
{
  __IO uint32_t MODER;       /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;      /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;     /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;       /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;         /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;         /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;        /*!< GPIO port bit set/reset  register,     Address offset: 0x18      */
  __IO uint32_t LCKR;        /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];      /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
  __IO uint32_t BRR;         /*!< GPIO Bit Reset register,               Address offset: 0x28      */
       uint32_t RESERVED;    /*!< Reserved,                              Address offset: 0x2C */
  __IO uint32_t SECCFGR;     /*!< GPIO Security configuration register,  Address offset: 0x30      */
} GPIO_TypeDef;

/**
  * @brief Global TrustZone Controller
  */

typedef struct{
  __IO uint32_t CR;             /*!< TZSC control register,                                   Address offset: 0x00      */
  uint32_t RESERVED1[3];        /*!< Reserved1,                                               Address offset: 0x04-0x0C */
  __IO uint32_t SECCFGR1;       /*!< TZSC secure configuration register 1,                    Address offset: 0x10      */
  __IO uint32_t SECCFGR2;       /*!< TZSC secure configuration register 2,                    Address offset: 0x14      */
  uint32_t RESERVED2[2];        /*!< Reserved2,                                               Address offset: 0x18-0x1C */
  __IO uint32_t PRIVCFGR1;      /*!< TZSC privilege configuration register 1,                 Address offset: 0x20      */
  __IO uint32_t PRIVCFGR2;      /*!< TZSC privilege configuration register 2,                 Address offset: 0x24      */
  uint32_t RESERVED3[2];        /*!< Reserved3,                                               Address offset: 0x28-0x2C */
  __IO uint32_t MPCWM1_NSWMR1;  /*!< TZSC external memory 1, non-secure watermark register 1, Address offset: 0x30      */
  __IO uint32_t MPCWM1_NSWMR2;  /*!< TZSC external memory 1, non-secure watermark register 2, Address offset: 0x34      */
  __IO uint32_t MPCWM2_NSWMR1;  /*!< TZSC external memory 2, non-secure watermark register 1, Address offset: 0x38      */
  __IO uint32_t MPCWM2_NSWMR2;  /*!< TZSC external memory 2, non-secure watermark register 2, Address offset: 0x3c      */
  __IO uint32_t MPCWM3_NSWMR1;  /*!< TZSC external memory 3, non-secure watermark register 1, Address offset: 0x40      */
} GTZC_TZSC_TypeDef;

typedef struct{
  __IO uint32_t CR;             /*!< MPCBBx control register, Address offset: 0x00        */
  uint32_t RESERVED1[3];        /*!< Reserved1,               Address offset: 0x04-0x0C   */
  __IO uint32_t LCKVTR1;        /*!< MPCBBx lock register 1,  Address offset: 0x10        */
  __IO uint32_t LCKVTR2;        /*!< MPCBBx lock register 2,  Address offset: 0x14        */
  uint32_t RESERVED2[58];       /*!< Reserved2,               Address offset: 0x18-0xFC   */
  __IO uint32_t VCTR[24];       /*!< MPCBBx vector registers, Address offset: 0x100-0x120 */
} GTZC_MPCBB_TypeDef;

typedef struct{
  __IO uint32_t IER1;           /*!< TZIC interrupt enable register 1, Address offset: 0x00 */
  __IO uint32_t IER2;           /*!< TZIC interrupt enable register 2, Address offset: 0x04 */
  __IO uint32_t IER3;           /*!< TZIC interrupt enable register 3, Address offset: 0x08 */
  uint32_t RESERVED1;           /*!< Reserved1,                        Address offset: 0x0C */
  __IO uint32_t SR1;            /*!< TZIC status register 1,           Address offset: 0x10 */
  __IO uint32_t SR2;            /*!< TZIC status register 2,           Address offset: 0x14 */
  __IO uint32_t SR3;            /*!< TZIC status register 3,           Address offset: 0x18 */
  uint32_t RESERVED2;           /*!< Reserved2,                        Address offset: 0x1C */
  __IO uint32_t FCR1;           /*!< TZIC flag clear register 1,       Address offset: 0x20 */
  __IO uint32_t FCR2;           /*!< TZIC flag clear register 2,       Address offset: 0x24 */
  __IO uint32_t FCR3;           /*!< TZIC flag clear register 3,       Address offset: 0x28 */
} GTZC_TZIC_TypeDef;

/**
  * @brief HASH
  */

typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED[52];     /*!< Reserved, 0x28-0xF4                                         */
  __IO uint32_t CSR[54];          /*!< HASH context swap registers,    Address offset: 0x0F8-0x1CC */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */

typedef struct
{
  __IO uint32_t HR[8];     /*!< HASH digest registers,          Address offset: 0x310-0x32C */
} HASH_DIGEST_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */

typedef struct
{
  __IO uint32_t CR1;         /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;        /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;        /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;     /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR;    /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;         /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;         /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;        /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;        /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;        /*!< I2C Transmit data register,        Address offset: 0x28 */
} I2C_TypeDef;

/**
  * @brief Instruction Cache
  */

typedef struct
{
  __IO uint32_t CR;             /*!< ICACHE control register,                Address offset: 0x00 */
  __IO uint32_t SR;             /*!< ICACHE status register,                 Address offset: 0x04 */
  __IO uint32_t IER;            /*!< ICACHE interrupt enable register,       Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< ICACHE flag clear register,             Address offset: 0x0C */
  __IO uint32_t HMONR;          /*!< ICACHE hit monitor register,            Address offset: 0x10 */
  __IO uint32_t MMONR;          /*!< ICACHE miss monitor register,           Address offset: 0x14 */
       uint32_t RESERVED1[2];   /*!< Reserved,                               Address offset: 0x018-0x01C */
  __IO uint32_t CRR0;           /*!< ICACHE region 0 configuration register, Address offset: 0x20 */
  __IO uint32_t CRR1;           /*!< ICACHE region 1 configuration register, Address offset: 0x24 */
  __IO uint32_t CRR2;           /*!< ICACHE region 2 configuration register, Address offset: 0x28 */
  __IO uint32_t CRR3;           /*!< ICACHE region 3 configuration register, Address offset: 0x2C */
} ICACHE_TypeDef;

/**
  * @brief Independent WATCHDOG
  */
typedef struct
{
  __IO uint32_t KR;             /*!< IWDG Key register,       Address offset: 0x00 */
  __IO uint32_t PR;             /*!< IWDG Prescaler register, Address offset: 0x04 */
  __IO uint32_t RLR;            /*!< IWDG Reload register,    Address offset: 0x08 */
  __IO uint32_t SR;             /*!< IWDG Status register,    Address offset: 0x0C */
  __IO uint32_t WINR;           /*!< IWDG Window register,    Address offset: 0x10 */
} IWDG_TypeDef;

/**
  * @brief LPTIMER
  */

typedef struct
{
  __IO uint32_t ISR;            /*!< LPTIM Interrupt and Status register,    Address offset: 0x00 */
  __IO uint32_t ICR;            /*!< LPTIM Interrupt Clear register,         Address offset: 0x04 */
  __IO uint32_t IER;            /*!< LPTIM Interrupt Enable register,        Address offset: 0x08 */
  __IO uint32_t CFGR;           /*!< LPTIM Configuration register,           Address offset: 0x0C */
  __IO uint32_t CR;             /*!< LPTIM Control register,                 Address offset: 0x10 */
  __IO uint32_t CMP;            /*!< LPTIM Compare register,                 Address offset: 0x14 */
  __IO uint32_t ARR;            /*!< LPTIM Autoreload register,              Address offset: 0x18 */
  __IO uint32_t CNT;            /*!< LPTIM Counter register,                 Address offset: 0x1C */
  __IO uint32_t OR;             /*!< LPTIM Option register,                  Address offset: 0x20 */
  __IO uint32_t RESERVED;       /*!< Reserved,                               Address offset: 0x24 */
  __IO uint32_t RCR;            /*!< LPTIM Repetition counter register,      Address offset: 0x28 */
} LPTIM_TypeDef;

/**
  * @brief OCTO Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR;          /*!< OCTOSPI Control register,                           Address offset: 0x000 */
  uint32_t RESERVED;         /*!< Reserved,                                           Address offset: 0x004 */
  __IO uint32_t DCR1;        /*!< OCTOSPI Device Configuration register 1,            Address offset: 0x008 */
  __IO uint32_t DCR2;        /*!< OCTOSPI Device Configuration register 2,            Address offset: 0x00C */
  __IO uint32_t DCR3;        /*!< OCTOSPI Device Configuration register 3,            Address offset: 0x010 */
  __IO uint32_t DCR4;        /*!< OCTOSPI Device Configuration register 4,            Address offset: 0x014 */
  uint32_t RESERVED1[2];     /*!< Reserved,                                           Address offset: 0x018-0x01C */
  __IO uint32_t SR;          /*!< OCTOSPI Status register,                            Address offset: 0x020 */
  __IO uint32_t FCR;         /*!< OCTOSPI Flag Clear register,                        Address offset: 0x024 */
  uint32_t RESERVED2[6];     /*!< Reserved,                                           Address offset: 0x028-0x03C */
  __IO uint32_t DLR;         /*!< OCTOSPI Data Length register,                       Address offset: 0x040 */
  uint32_t RESERVED3;        /*!< Reserved,                                           Address offset: 0x044 */
  __IO uint32_t AR;          /*!< OCTOSPI Address register,                           Address offset: 0x048 */
  uint32_t RESERVED4;        /*!< Reserved,                                           Address offset: 0x04C */
  __IO uint32_t DR;          /*!< OCTOPSI Data register,                              Address offset: 0x050 */
  uint32_t RESERVED5[11];    /*!< Reserved,                                           Address offset: 0x054-0x07C */
  __IO uint32_t PSMKR;       /*!< OCTOSPI Polling Status Mask register,               Address offset: 0x080 */
  uint32_t RESERVED6;        /*!< Reserved,                                           Address offset: 0x084 */
  __IO uint32_t PSMAR;       /*!< OCTOSPI Polling Status Match register,              Address offset: 0x088 */
  uint32_t RESERVED7;        /*!< Reserved,                                           Address offset: 0x08C */
  __IO uint32_t PIR;         /*!< OCTOSPI Polling Interval register,                  Address offset: 0x090 */
  uint32_t RESERVED8[27];    /*!< Reserved,                                           Address offset: 0x094-0x0FC */
  __IO uint32_t CCR;         /*!< OCTOSPI Communication Configuration register,       Address offset: 0x100 */
  uint32_t RESERVED9;        /*!< Reserved,                                           Address offset: 0x104 */
  __IO uint32_t TCR;         /*!< OCTOSPI Timing Configuration register,              Address offset: 0x108 */
  uint32_t RESERVED10;       /*!< Reserved,                                           Address offset: 0x10C */
  __IO uint32_t IR;          /*!< OCTOSPI Instruction register,                       Address offset: 0x110 */
  uint32_t RESERVED11[3];    /*!< Reserved,                                           Address offset: 0x114-0x11C */
  __IO uint32_t ABR;         /*!< OCTOSPI Alternate Bytes register,                   Address offset: 0x120 */
  uint32_t RESERVED12[3];    /*!< Reserved,                                           Address offset: 0x124-0x12C */
  __IO uint32_t LPTR;        /*!< OCTOSPI Low Power Timeout register,                 Address offset: 0x130 */
  uint32_t RESERVED13[3];    /*!< Reserved,                                           Address offset: 0x134-0x13C */
  __IO uint32_t WPCCR;       /*!< OCTOSPI Wrap Communication Configuration register,  Address offset: 0x140 */
  uint32_t RESERVED14;       /*!< Reserved,                                           Address offset: 0x144 */
  __IO uint32_t WPTCR;       /*!< OCTOSPI Wrap Timing Configuration register,         Address offset: 0x148 */
  uint32_t RESERVED15;       /*!< Reserved,                                           Address offset: 0x14C */
  __IO uint32_t WPIR;        /*!< OCTOSPI Wrap Instruction register,                  Address offset: 0x150 */
  uint32_t RESERVED16[3];    /*!< Reserved,                                           Address offset: 0x154-0x15C */
  __IO uint32_t WPABR;       /*!< OCTOSPI Wrap Alternate Bytes register,              Address offset: 0x160 */
  uint32_t RESERVED17[7];    /*!< Reserved,                                           Address offset: 0x164-0x17C */
  __IO uint32_t WCCR;        /*!< OCTOSPI Write Communication Configuration register, Address offset: 0x180 */
  uint32_t RESERVED18;       /*!< Reserved,                                           Address offset: 0x184 */
  __IO uint32_t WTCR;        /*!< OCTOSPI Write Timing Configuration register,        Address offset: 0x188 */
  uint32_t RESERVED19;       /*!< Reserved,                                           Address offset: 0x18C */
  __IO uint32_t WIR;         /*!< OCTOSPI Write Instruction register,                 Address offset: 0x190 */
  uint32_t RESERVED20[3];    /*!< Reserved,                                           Address offset: 0x194-0x19C */
  __IO uint32_t WABR;        /*!< OCTOSPI Write Alternate Bytes register,             Address offset: 0x1A0 */
  uint32_t RESERVED21[23];   /*!< Reserved,                                           Address offset: 0x1A4-0x1FC */
  __IO uint32_t HLCR;        /*!< OCTOSPI Hyperbus Latency Configuration register,    Address offset: 0x200 */
} OCTOSPI_TypeDef;

/**
  * @brief Operational Amplifier (OPAMP)
  */

typedef struct
{
  __IO uint32_t CSR;         /*!< OPAMP control/status register,                     Address offset: 0x00 */
  __IO uint32_t OTR;         /*!< OPAMP offset trimming register for normal mode,    Address offset: 0x04 */
  __IO uint32_t LPOTR;       /*!< OPAMP offset trimming register for low power mode, Address offset: 0x08 */
} OPAMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR;         /*!< OPAMP control/status register, used for bits common to several OPAMP instances, Address offset: 0x00 */
} OPAMP_Common_TypeDef;

/**
  * @brief Power Control
  */

typedef struct
{
  __IO uint32_t CR1;      /*!< PWR power control register 1,               Address offset: 0x00 */
  __IO uint32_t CR2;      /*!< PWR power control register 2,               Address offset: 0x04 */
  __IO uint32_t CR3;      /*!< PWR power control register 3,               Address offset: 0x08 */
  __IO uint32_t CR4;      /*!< PWR power control register 4,               Address offset: 0x0C */
  __IO uint32_t SR1;      /*!< PWR power status register 1,                Address offset: 0x10 */
  __IO uint32_t SR2;      /*!< PWR power status register 2,                Address offset: 0x14 */
  __IO uint32_t SCR;      /*!< PWR power status clear register,            Address offset: 0x18 */
  uint32_t RESERVED1;     /*!< Reserved1,                                  Address offset: 0x1C */
  __IO uint32_t PUCRA;    /*!< Pull_up control register of portA,          Address offset: 0x20 */
  __IO uint32_t PDCRA;    /*!< Pull_Down control register of portA,        Address offset: 0x24 */
  __IO uint32_t PUCRB;    /*!< Pull_up control register of portB,          Address offset: 0x28 */
  __IO uint32_t PDCRB;    /*!< Pull_Down control register of portB,        Address offset: 0x2C */
  __IO uint32_t PUCRC;    /*!< Pull_up control register of portC,          Address offset: 0x30 */
  __IO uint32_t PDCRC;    /*!< Pull_Down control register of portC,        Address offset: 0x34 */
  __IO uint32_t PUCRD;    /*!< Pull_up control register of portD,          Address offset: 0x38 */
  __IO uint32_t PDCRD;    /*!< Pull_Down control register of portD,        Address offset: 0x3C */
  __IO uint32_t PUCRE;    /*!< Pull_up control register of portE,          Address offset: 0x40 */
  __IO uint32_t PDCRE;    /*!< Pull_Down control register of portE,        Address offset: 0x44 */
  __IO uint32_t PUCRF;    /*!< Pull_up control register of portF,          Address offset: 0x48 */
  __IO uint32_t PDCRF;    /*!< Pull_Down control register of portF,        Address offset: 0x4C */
  __IO uint32_t PUCRG;    /*!< Pull_up control register of portG,          Address offset: 0x50 */
  __IO uint32_t PDCRG;    /*!< Pull_Down control register of portG,        Address offset: 0x54 */
  __IO uint32_t PUCRH;    /*!< Pull_up control register of portH,          Address offset: 0x58 */
  __IO uint32_t PDCRH;    /*!< Pull_Down control register of portH,        Address offset: 0x5C */
  uint32_t RESERVED2[6];  /*!< Reserved2,                                  Address offset: 0x60-0x74 */
  __IO uint32_t SECCFGR;  /*!< PWR secure configuration register,          Address offset: 0x78 */
  uint32_t RESERVED3;     /*!< Reserved3,                                  Address offset: 0x7C */
  __IO uint32_t PRIVCFGR; /*!< PWR privilege configuration register,       Address offset: 0x80 */
} PWR_TypeDef;

/**
  * @brief Reset and Clock Control
  */

typedef struct
{
  __IO uint32_t CR;            /*!< RCC clock control register,                                              Address offset: 0x00 */
  __IO uint32_t ICSCR;         /*!< RCC internal clock sources calibration register,                         Address offset: 0x04 */
  __IO uint32_t CFGR;          /*!< RCC clock configuration register,                                        Address offset: 0x08 */
  __IO uint32_t PLLCFGR;       /*!< RCC system PLL configuration register,                                   Address offset: 0x0C */
  __IO uint32_t PLLSAI1CFGR;   /*!< RCC PLL SAI1 configuration register,                                     Address offset: 0x10 */
  __IO uint32_t PLLSAI2CFGR;   /*!< RCC PLL SAI2 configuration register,                                     Address offset: 0x14 */
  __IO uint32_t CIER;          /*!< RCC clock interrupt enable register,                                     Address offset: 0x18 */
  __IO uint32_t CIFR;          /*!< RCC clock interrupt flag register,                                       Address offset: 0x1C */
  __IO uint32_t CICR;          /*!< RCC clock interrupt clear register,                                      Address offset: 0x20 */
  uint32_t      RESERVED0;     /*!< Reserved,                                                                Address offset: 0x24 */
  __IO uint32_t AHB1RSTR;      /*!< RCC AHB1 peripheral reset register,                                      Address offset: 0x28 */
  __IO uint32_t AHB2RSTR;      /*!< RCC AHB2 peripheral reset register,                                      Address offset: 0x2C */
  __IO uint32_t AHB3RSTR;      /*!< RCC AHB3 peripheral reset register,                                      Address offset: 0x30 */
  uint32_t      RESERVED1;     /*!< Reserved,                                                                Address offset: 0x34 */
  __IO uint32_t APB1RSTR1;     /*!< RCC APB1 peripheral reset register 1,                                    Address offset: 0x38 */
  __IO uint32_t APB1RSTR2;     /*!< RCC APB1 peripheral reset register 2,                                    Address offset: 0x3C */
  __IO uint32_t APB2RSTR;      /*!< RCC APB2 peripheral reset register,                                      Address offset: 0x40 */
  uint32_t      RESERVED2;     /*!< Reserved,                                                                Address offset: 0x44 */
  __IO uint32_t AHB1ENR;       /*!< RCC AHB1 peripheral clocks enable register,                              Address offset: 0x48 */
  __IO uint32_t AHB2ENR;       /*!< RCC AHB2 peripheral clocks enable register,                              Address offset: 0x4C */
  __IO uint32_t AHB3ENR;       /*!< RCC AHB3 peripheral clocks enable register,                              Address offset: 0x50 */
  uint32_t      RESERVED3;     /*!< Reserved,                                                                Address offset: 0x54 */
  __IO uint32_t APB1ENR1;      /*!< RCC APB1 peripheral clocks enable register 1,                            Address offset: 0x58 */
  __IO uint32_t APB1ENR2;      /*!< RCC APB1 peripheral clocks enable register 2,                            Address offset: 0x5C */
  __IO uint32_t APB2ENR;       /*!< RCC APB2 peripheral clocks enable register,                              Address offset: 0x60 */
  uint32_t      RESERVED4;     /*!< Reserved,                                                                Address offset: 0x64 */
  __IO uint32_t AHB1SMENR;     /*!< RCC AHB1 peripheral clocks enable in sleep and stop modes register,      Address offset: 0x68 */
  __IO uint32_t AHB2SMENR;     /*!< RCC AHB2 peripheral clocks enable in sleep and stop modes register,      Address offset: 0x6C */
  __IO uint32_t AHB3SMENR;     /*!< RCC AHB3 peripheral clocks enable in sleep and stop modes register,      Address offset: 0x70 */
  uint32_t      RESERVED5;     /*!< Reserved,                                                                Address offset: 0x74 */
  __IO uint32_t APB1SMENR1;    /*!< RCC APB1 peripheral clocks enable in sleep mode and stop modes register 1, Address offset: 0x78 */
  __IO uint32_t APB1SMENR2;    /*!< RCC APB1 peripheral clocks enable in sleep mode and stop modes register 2, Address offset: 0x7C */
  __IO uint32_t APB2SMENR;     /*!< RCC APB2 peripheral clocks enable in sleep mode and stop modes register, Address offset: 0x80 */
  uint32_t      RESERVED6;     /*!< Reserved,                                                                Address offset: 0x84 */
  __IO uint32_t CCIPR1;        /*!< RCC peripherals independent clock configuration register 1,              Address offset: 0x88 */
  uint32_t      RESERVED7;     /*!< Reserved,                                                                Address offset: 0x8C */
  __IO uint32_t BDCR;          /*!< RCC backup domain control register,                                      Address offset: 0x90 */
  __IO uint32_t CSR;           /*!< RCC clock control & status register,                                     Address offset: 0x94 */
  __IO uint32_t CRRCR;         /*!< RCC clock recovery RC register,                                          Address offset: 0x98 */
  __IO uint32_t CCIPR2;        /*!< RCC peripherals independent clock configuration register 2,              Address offset: 0x9C */
  uint32_t      RESERVED8[6];  /*!< Reserved,                                                                Address offset: 0xA0-0xB4 */
  __IO uint32_t SECCFGR;       /*!< RCC secure configuration register,                                       Address offset: 0xB8 */
  __IO uint32_t SECSR;         /*!< RCC secure status register,                                              Address offset: 0xBC */
  uint32_t      RESERVED9[10]; /*!< Reserved,                                                                Address offset: 0xC0-0xE4 */
  __IO uint32_t AHB1SECSR;     /*!< RCC AHB1 security status register,                                       Address offset: 0xE8 */
  __IO uint32_t AHB2SECSR;     /*!< RCC AHB2 security status register,                                       Address offset: 0xEC */
  __IO uint32_t AHB3SECSR;     /*!< RCC AHB3 security status register,                                       Address offset: 0xF0 */
  uint32_t      RESERVED10;    /*!< Reserved,                                                                Address offset: 0xF4 */
  __IO uint32_t APB1SECSR1;    /*!< RCC APB1 security status register 1,                                     Address offset: 0xF8 */
  __IO uint32_t APB1SECSR2;    /*!< RCC APB1 security status register 2,                                     Address offset: 0xFC */
  __IO uint32_t APB2SECSR;     /*!< RCC APB2 security status register,                                       Address offset: 0x100 */
} RCC_TypeDef;

/**
  * @brief RNG
  */
typedef struct
{
  __IO uint32_t CR;        /*!< RNG control register,                       Address offset: 0x00 */
  __IO uint32_t SR;        /*!< RNG status register,                        Address offset: 0x04 */
  __IO uint32_t DR;        /*!< RNG data register,                          Address offset: 0x08 */
  uint32_t      RESERVED0; /*!< Reserved,                                   Address offset: 0x0C */
  __IO uint32_t HTCR;      /*!< RNG health test control register,           Address offset: 0x10 */
} RNG_TypeDef;



/**
  * @brief RTC Specific device feature definitions
  */
#define RTC_BACKUP_NB       32u
#define RTC_TAMP_NB         8u

/**
  * @brief Real-Time Clock
  */
typedef struct
{
  __IO uint32_t TR;          /*!< RTC time register,                              Address offset: 0x00 */
  __IO uint32_t DR;          /*!< RTC date register,                              Address offset: 0x04 */
  __IO uint32_t SSR;         /*!< RTC sub second register,                        Address offset: 0x08 */
  __IO uint32_t ICSR;        /*!< RTC initialization control and status register, Address offset: 0x0C */
  __IO uint32_t PRER;        /*!< RTC prescaler register,                         Address offset: 0x10 */
  __IO uint32_t WUTR;        /*!< RTC wakeup timer register,                      Address offset: 0x14 */
  __IO uint32_t CR;          /*!< RTC control register,                           Address offset: 0x18 */
  __IO uint32_t PRIVCR;      /*!< RTC privilege mode control register,            Address offset: 0x1C */
  __IO uint32_t SMCR;        /*!< RTC Secure mode control register,               Address offset: 0x20 */
  __IO uint32_t WPR;         /*!< RTC write protection register,                  Address offset: 0x24 */
  __IO uint32_t CALR;        /*!< RTC calibration register,                       Address offset: 0x28 */
  __IO uint32_t SHIFTR;      /*!< RTC shift control register,                     Address offset: 0x2C */
  __IO uint32_t TSTR;        /*!< RTC time stamp time register,                   Address offset: 0x30 */
  __IO uint32_t TSDR;        /*!< RTC time stamp date register,                   Address offset: 0x34 */
  __IO uint32_t TSSSR;       /*!< RTC time-stamp sub second register,             Address offset: 0x38 */
       uint32_t RESERVED0;   /*!< Reserved,                                       Address offset: 0x3C */
  __IO uint32_t ALRMAR;      /*!< RTC alarm A register,                           Address offset: 0x40 */
  __IO uint32_t ALRMASSR;    /*!< RTC alarm A sub second register,                Address offset: 0x44 */
  __IO uint32_t ALRMBR;      /*!< RTC alarm B register,                           Address offset: 0x48 */
  __IO uint32_t ALRMBSSR;    /*!< RTC alarm B sub second register,                Address offset: 0x4C */
  __IO uint32_t SR;          /*!< RTC Status register,                            Address offset: 0x50 */
  __IO uint32_t MISR;        /*!< RTC masked interrupt status register,           Address offset: 0x54 */
  __IO uint32_t SMISR;       /*!< RTC secure masked interrupt status register,    Address offset: 0x58 */
  __IO uint32_t SCR;         /*!< RTC status Clear register,                      Address offset: 0x5C */
} RTC_TypeDef;

/**
  * @brief Serial Peripheral Interface
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< SPI Control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< SPI Control register 2,                   Address offset: 0x04 */
  __IO uint32_t SR;          /*!< SPI Status register,                      Address offset: 0x08 */
  __IO uint32_t DR;          /*!< SPI data register,                        Address offset: 0x0C */
  __IO uint32_t CRCPR;       /*!< SPI CRC polynomial register,              Address offset: 0x10 */
  __IO uint32_t RXCRCR;      /*!< SPI Rx CRC register,                      Address offset: 0x14 */
  __IO uint32_t TXCRCR;      /*!< SPI Tx CRC register,                      Address offset: 0x18 */
} SPI_TypeDef;

/**
  * @brief Tamper and backup registers
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TAMP configuration register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TAMP configuration register 2,            Address offset: 0x04 */
  __IO uint32_t CR3;         /*!< TAMP configuration register 3,            Address offset: 0x08 */
  __IO uint32_t FLTCR;       /*!< TAMP filter control register,             Address offset: 0x0C */
  __IO uint32_t ATCR1;       /*!< TAMP active tamper control register 1     Address offset: 0x10 */
  __IO uint32_t ATSEEDR;     /*!< TAMP active tamper seed register,         Address offset: 0x14 */
  __IO uint32_t ATOR;        /*!< TAMP active tamper output register,       Address offset: 0x18 */
  __IO uint32_t ATCR2;       /*!< TAMP active tamper control register 2,    Address offset: 0x1C */
  __IO uint32_t SMCR;        /*!< TAMP secure mode control register,        Address offset: 0x20 */
  __IO uint32_t PRIVCR;      /*!< TAMP privilege mode control register,     Address offset: 0x24 */
       uint32_t RESERVED0;   /*!< Reserved,                                 Address offset: 0x28 */
  __IO uint32_t IER;         /*!< TAMP interrupt enable register,           Address offset: 0x2C */
  __IO uint32_t SR;          /*!< TAMP status register,                     Address offset: 0x30 */
  __IO uint32_t MISR;        /*!< TAMP masked interrupt status register,    Address offset: 0x34 */
  __IO uint32_t SMISR;       /*!< TAMP secure masked interrupt status register, Address offset: 0x38 */
  __IO uint32_t SCR;         /*!< TAMP status clear register,               Address offset: 0x3C */
  __IO uint32_t COUNTR;      /*!< TAMP monotonic counter register,          Address offset: 0x40 */
       uint32_t RESERVED1[47];/*!< Reserved,                                Address offset: 0x54 -- 0xFC */
  __IO uint32_t BKP0R;       /*!< TAMP backup register 0,                   Address offset: 0x100 */
  __IO uint32_t BKP1R;       /*!< TAMP backup register 1,                   Address offset: 0x104 */
  __IO uint32_t BKP2R;       /*!< TAMP backup register 2,                   Address offset: 0x108 */
  __IO uint32_t BKP3R;       /*!< TAMP backup register 3,                   Address offset: 0x10C */
  __IO uint32_t BKP4R;       /*!< TAMP backup register 4,                   Address offset: 0x110 */
  __IO uint32_t BKP5R;       /*!< TAMP backup register 5,                   Address offset: 0x114 */
  __IO uint32_t BKP6R;       /*!< TAMP backup register 6,                   Address offset: 0x118 */
  __IO uint32_t BKP7R;       /*!< TAMP backup register 7,                   Address offset: 0x11C */
  __IO uint32_t BKP8R;       /*!< TAMP backup register 8,                   Address offset: 0x120 */
  __IO uint32_t BKP9R;       /*!< TAMP backup register 9,                   Address offset: 0x124 */
  __IO uint32_t BKP10R;      /*!< TAMP backup register 10,                  Address offset: 0x128 */
  __IO uint32_t BKP11R;      /*!< TAMP backup register 11,                  Address offset: 0x12C */
  __IO uint32_t BKP12R;      /*!< TAMP backup register 12,                  Address offset: 0x130 */
  __IO uint32_t BKP13R;      /*!< TAMP backup register 13,                  Address offset: 0x134 */
  __IO uint32_t BKP14R;      /*!< TAMP backup register 14,                  Address offset: 0x138 */
  __IO uint32_t BKP15R;      /*!< TAMP backup register 15,                  Address offset: 0x13C */
  __IO uint32_t BKP16R;      /*!< TAMP backup register 16,                  Address offset: 0x140 */
  __IO uint32_t BKP17R;      /*!< TAMP backup register 17,                  Address offset: 0x144 */
  __IO uint32_t BKP18R;      /*!< TAMP backup register 18,                  Address offset: 0x148 */
  __IO uint32_t BKP19R;      /*!< TAMP backup register 19,                  Address offset: 0x14C */
  __IO uint32_t BKP20R;      /*!< TAMP backup register 20,                  Address offset: 0x150 */
  __IO uint32_t BKP21R;      /*!< TAMP backup register 21,                  Address offset: 0x154 */
  __IO uint32_t BKP22R;      /*!< TAMP backup register 22,                  Address offset: 0x158 */
  __IO uint32_t BKP23R;      /*!< TAMP backup register 23,                  Address offset: 0x15C */
  __IO uint32_t BKP24R;      /*!< TAMP backup register 24,                  Address offset: 0x160 */
  __IO uint32_t BKP25R;      /*!< TAMP backup register 25,                  Address offset: 0x164 */
  __IO uint32_t BKP26R;      /*!< TAMP backup register 26,                  Address offset: 0x168 */
  __IO uint32_t BKP27R;      /*!< TAMP backup register 27,                  Address offset: 0x16C */
  __IO uint32_t BKP28R;      /*!< TAMP backup register 28,                  Address offset: 0x170 */
  __IO uint32_t BKP29R;      /*!< TAMP backup register 29,                  Address offset: 0x174 */
  __IO uint32_t BKP30R;      /*!< TAMP backup register 30,                  Address offset: 0x178 */
  __IO uint32_t BKP31R;      /*!< TAMP backup register 31,                  Address offset: 0x17C */
} TAMP_TypeDef;

/**
  * @brief TIM
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TIM control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint32_t PSC;         /*!< TIM prescaler register,                   Address offset: 0x28 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint32_t RCR;         /*!< TIM repetition counter register,          Address offset: 0x30 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint32_t DCR;         /*!< TIM DMA control register,                 Address offset: 0x48 */
  __IO uint32_t DMAR;        /*!< TIM DMA address for full transfer,        Address offset: 0x4C */
  __IO uint32_t OR1;         /*!< TIM option register 1,                    Address offset: 0x50 */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3,      Address offset: 0x54 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register5,            Address offset: 0x58 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register6,            Address offset: 0x5C */
  __IO uint32_t OR2;         /*!< TIM option register 2,                    Address offset: 0x60 */
  __IO uint32_t OR3;         /*!< TIM option register 3,                    Address offset: 0x64 */
} TIM_TypeDef;

/**
  * @brief Touch Sensing Controller (TSC)
  */

typedef struct
{
  __IO uint32_t CR;          /*!< TSC control register,                                     Address offset: 0x00 */
  __IO uint32_t IER;         /*!< TSC interrupt enable register,                            Address offset: 0x04 */
  __IO uint32_t ICR;         /*!< TSC interrupt clear register,                             Address offset: 0x08 */
  __IO uint32_t ISR;         /*!< TSC interrupt status register,                            Address offset: 0x0C */
  __IO uint32_t IOHCR;       /*!< TSC I/O hysteresis control register,                      Address offset: 0x10 */
  uint32_t      RESERVED1;   /*!< Reserved,                                                 Address offset: 0x14 */
  __IO uint32_t IOASCR;      /*!< TSC I/O analog switch control register,                   Address offset: 0x18 */
  uint32_t      RESERVED2;   /*!< Reserved,                                                 Address offset: 0x1C */
  __IO uint32_t IOSCR;       /*!< TSC I/O sampling control register,                        Address offset: 0x20 */
  uint32_t      RESERVED3;   /*!< Reserved,                                                 Address offset: 0x24 */
  __IO uint32_t IOCCR;       /*!< TSC I/O channel control register,                         Address offset: 0x28 */
  uint32_t      RESERVED4;   /*!< Reserved,                                                 Address offset: 0x2C */
  __IO uint32_t IOGCSR;      /*!< TSC I/O group control status register,                    Address offset: 0x30 */
  __IO uint32_t IOGXCR[8];   /*!< TSC I/O group x counter register,                         Address offset: 0x34-50 */
} TSC_TypeDef;

/**
  * @brief Serial Audio Interface
  */

typedef struct
{
  __IO uint32_t GCR;          /*!< SAI global configuration register,        Address offset: 0x00 */
  uint32_t      RESERVED[16]; /*!< Reserved,                         Address offset: 0x04 to 0x40 */
  __IO uint32_t PDMCR;        /*!< SAI PDM control register,                 Address offset: 0x44 */
  __IO uint32_t PDMDLY;       /*!< SAI PDM delay register,                   Address offset: 0x48 */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;         /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;         /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;        /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;       /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;         /*!< SAI block x interrupt mask register,      Address offset: 0x14 */
  __IO uint32_t SR;          /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;       /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;          /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;

/**
  * @brief System configuration controller
  */

typedef struct
{
  __IO uint32_t SECCFGR;     /*!< SYSCFG secure configuration register,     Address offset: 0x00 */
  __IO uint32_t CFGR1;       /*!< SYSCFG configuration register 1,          Address offset: 0x04 */
  __IO uint32_t FPUIMR;      /*!< SYSCFG FPU interrupt mask register,       Address offset: 0x08 */
  __IO uint32_t CNSLCKR;     /*!< SYSCFG CPU non-secure lock register,      Address offset: 0x0C */
  __IO uint32_t CSLCKR;      /*!< SYSCFG CPU secure lock register,          Address offset: 0x10 */
  __IO uint32_t CFGR2;       /*!< SYSCFG configuration register 2,          Address offset: 0x14 */
  __IO uint32_t SCSR;        /*!< SYSCFG SRAM2 control and status register, Address offset: 0x18 */
  __IO uint32_t SKR;         /*!< SYSCFG SRAM2 key register,                Address offset: 0x1C */
  __IO uint32_t SWPR;        /*!< SYSCFG SRAM2 write protection register 1, Address offset: 0x20 */
  __IO uint32_t SWPR2;       /*!< SYSCFG SRAM2 write protection register 2, Address offset: 0x24 */
  uint32_t      RESERVED;    /*!< Reserved,                                 Address offset: 0x28 */
  __IO uint32_t RSSCMDR;     /*!< SYSCFG RSS command register,              Address offset: 0x2C */
} SYSCFG_TypeDef;

/**
  * @brief Secure digital input/output Interface
  */

typedef struct
{
  __IO uint32_t POWER;          /*!< SDMMC power control register,             Address offset: 0x00  */
  __IO uint32_t CLKCR;          /*!< SDMMC clock control register,             Address offset: 0x04  */
  __IO uint32_t ARG;            /*!< SDMMC argument register,                  Address offset: 0x08  */
  __IO uint32_t CMD;            /*!< SDMMC command register,                   Address offset: 0x0C  */
  __I uint32_t  RESPCMD;        /*!< SDMMC command response register,          Address offset: 0x10  */
  __I uint32_t  RESP1;          /*!< SDMMC response 1 register,                Address offset: 0x14  */
  __I uint32_t  RESP2;          /*!< SDMMC response 2 register,                Address offset: 0x18  */
  __I uint32_t  RESP3;          /*!< SDMMC response 3 register,                Address offset: 0x1C  */
  __I uint32_t  RESP4;          /*!< SDMMC response 4 register,                Address offset: 0x20  */
  __IO uint32_t DTIMER;         /*!< SDMMC data timer register,                Address offset: 0x24  */
  __IO uint32_t DLEN;           /*!< SDMMC data length register,               Address offset: 0x28  */
  __IO uint32_t DCTRL;          /*!< SDMMC data control register,              Address offset: 0x2C  */
  __I uint32_t  DCOUNT;         /*!< SDMMC data counter register,              Address offset: 0x30  */
  __I uint32_t  STA;            /*!< SDMMC status register,                    Address offset: 0x34  */
  __IO uint32_t ICR;            /*!< SDMMC interrupt clear register,           Address offset: 0x38  */
  __IO uint32_t MASK;           /*!< SDMMC mask register,                      Address offset: 0x3C  */
  __IO uint32_t ACKTIME;        /*!< SDMMC Acknowledgement timer register,     Address offset: 0x40  */
  uint32_t      RESERVED0[3];   /*!< Reserved, 0x44 - 0x4C - 0x4C                                    */
  __IO uint32_t IDMACTRL;       /*!< SDMMC DMA control register,               Address offset: 0x50  */
  __IO uint32_t IDMABSIZE;      /*!< SDMMC DMA buffer size register,           Address offset: 0x54  */
  __IO uint32_t IDMABASE0;      /*!< SDMMC DMA buffer 0 base address register, Address offset: 0x58  */
  __IO uint32_t IDMABASE1;      /*!< SDMMC DMA buffer 1 base address register, Address offset: 0x5C  */
  uint32_t      RESERVED1[8];   /*!< Reserved, 0x60-0x7C                                             */
  __IO uint32_t FIFO;           /*!< SDMMC data FIFO register,                 Address offset: 0x80  */
  uint32_t      RESERVED2[220]; /*!< Reserved, 0x84-0x3F0                                            */
  __IO uint32_t VER;            /*!< SDMMC IP version register,                Address offset: 0x3F4 */
  __IO uint32_t ID;             /*!< SDMMC IP identification register,         Address offset: 0x3F8 */
  __IO uint32_t SID;            /*!< SDMMC size ID register,                   Address offset: 0x3FC */
} SDMMC_TypeDef;

/**
  * @brief UCPD
  */
typedef struct
{
  __IO uint32_t CFG1;         /*!< UCPD configuration register 1,             Address offset: 0x00 */
  __IO uint32_t CFG2;         /*!< UCPD configuration register 2,             Address offset: 0x04 */
  __IO uint32_t CFG3;         /*!< UCPD configuration register 3,             Address offset: 0x08 */
  __IO uint32_t CR;           /*!< UCPD control register,                     Address offset: 0x0C */
  __IO uint32_t IMR;          /*!< UCPD interrupt mask register,              Address offset: 0x10 */
  __IO uint32_t SR;           /*!< UCPD status register,                      Address offset: 0x14 */
  __IO uint32_t ICR;          /*!< UCPD interrupt flag clear register         Address offset: 0x18 */
  __IO uint32_t TX_ORDSET;    /*!< UCPD Tx ordered set type register,         Address offset: 0x1C */
  __IO uint32_t TX_PAYSZ;     /*!< UCPD Tx payload size register,             Address offset: 0x20 */
  __IO uint32_t TXDR;         /*!< UCPD Tx data register,                     Address offset: 0x24 */
  __IO uint32_t RX_ORDSET;    /*!< UCPD Rx ordered set type register,         Address offset: 0x28 */
  __IO uint32_t RX_PAYSZ;     /*!< UCPD Rx payload size register,             Address offset: 0x2C */
  __IO uint32_t RXDR;         /*!< UCPD Rx data register,                     Address offset: 0x30 */
  __IO uint32_t RX_ORDEXT1;   /*!< UCPD Rx ordered set extension 1 register,  Address offset: 0x34 */
  __IO uint32_t RX_ORDEXT2;   /*!< UCPD Rx ordered set extension 2 register,  Address offset: 0x38 */
} UCPD_TypeDef;

/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< USART Control register 1,                    Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< USART Control register 2,                    Address offset: 0x04 */
  __IO uint32_t CR3;         /*!< USART Control register 3,                    Address offset: 0x08 */
  __IO uint32_t BRR;         /*!< USART Baud rate register,                    Address offset: 0x0C */
  __IO uint32_t GTPR;        /*!< USART Guard time and prescaler register,     Address offset: 0x10 */
  __IO uint32_t RTOR;        /*!< USART Receiver Time Out register,            Address offset: 0x14 */
  __IO uint32_t RQR;         /*!< USART Request register,                      Address offset: 0x18 */
  __IO uint32_t ISR;         /*!< USART Interrupt and status register,         Address offset: 0x1C */
  __IO uint32_t ICR;         /*!< USART Interrupt flag Clear register,         Address offset: 0x20 */
  __IO uint32_t RDR;         /*!< USART Receive Data register,                 Address offset: 0x24 */
  __IO uint32_t TDR;         /*!< USART Transmit Data register,                Address offset: 0x28 */
  __IO uint32_t PRESC;       /*!< USART Prescaler register,                    Address offset: 0x2C */
} USART_TypeDef;

/**
  * @brief Universal Serial Bus Full Speed Device
  */
typedef struct
{
  __IO uint16_t EP0R;            /*!< USB Endpoint 0 register,                Address offset: 0x00 */
  __IO uint16_t RESERVED0;       /*!< Reserved */
  __IO uint16_t EP1R;            /*!< USB Endpoint 1 register,                Address offset: 0x04 */
  __IO uint16_t RESERVED1;       /*!< Reserved */
  __IO uint16_t EP2R;            /*!< USB Endpoint 2 register,                Address offset: 0x08 */
  __IO uint16_t RESERVED2;       /*!< Reserved */
  __IO uint16_t EP3R;            /*!< USB Endpoint 3 register,                Address offset: 0x0C */
  __IO uint16_t RESERVED3;       /*!< Reserved */
  __IO uint16_t EP4R;            /*!< USB Endpoint 4 register,                Address offset: 0x10 */
  __IO uint16_t RESERVED4;       /*!< Reserved */
  __IO uint16_t EP5R;            /*!< USB Endpoint 5 register,                Address offset: 0x14 */
  __IO uint16_t RESERVED5;       /*!< Reserved */
  __IO uint16_t EP6R;            /*!< USB Endpoint 6 register,                Address offset: 0x18 */
  __IO uint16_t RESERVED6;       /*!< Reserved */
  __IO uint16_t EP7R;            /*!< USB Endpoint 7 register,                Address offset: 0x1C */
  __IO uint16_t RESERVED7[17];   /*!< Reserved */
  __IO uint16_t CNTR;            /*!< Control register,                       Address offset: 0x40 */
  __IO uint16_t RESERVED8;       /*!< Reserved */
  __IO uint16_t ISTR;            /*!< Interrupt status register,              Address offset: 0x44 */
  __IO uint16_t RESERVED9;       /*!< Reserved */
  __IO uint16_t FNR;             /*!< Frame number register,                  Address offset: 0x48 */
  __IO uint16_t RESERVEDA;       /*!< Reserved */
  __IO uint16_t DADDR;           /*!< Device address register,                Address offset: 0x4C */
  __IO uint16_t RESERVEDB;       /*!< Reserved */
  __IO uint16_t BTABLE;          /*!< Buffer Table address register,          Address offset: 0x50 */
  __IO uint16_t RESERVEDC;       /*!< Reserved */
  __IO uint16_t LPMCSR;          /*!< LPM Control and Status register,        Address offset: 0x54 */
  __IO uint16_t RESERVEDD;       /*!< Reserved */
  __IO uint16_t BCDR;            /*!< Battery Charging detector register,     Address offset: 0x58 */
  __IO uint16_t RESERVEDE;       /*!< Reserved */
} USB_TypeDef;

/**
  * @brief VREFBUF
  */
typedef struct
{
  __IO uint32_t CSR;         /*!< VREFBUF control and status register,         Address offset: 0x00 */
  __IO uint32_t CCR;         /*!< VREFBUF calibration and control register,    Address offset: 0x04 */
} VREFBUF_TypeDef;

/**
  * @brief Window WATCHDOG
  */
typedef struct
{
  __IO uint32_t CR;          /*!< WWDG Control register,       Address offset: 0x00 */
  __IO uint32_t CFR;         /*!< WWDG Configuration register, Address offset: 0x04 */
  __IO uint32_t SR;          /*!< WWDG Status register,        Address offset: 0x08 */
} WWDG_TypeDef;


/*@}*/ /* end of group STM32L5xx_peripherals */


/* --------  End of section using anonymous unions and disabling warnings  -------- */
#if   defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32L5xx_Peripheral_peripheralAddr
  * @{
  */

/* Internal SRAMs size */
#define SRAM1_SIZE            0x30000UL  /*!< SRAM1=192k*/
#define SRAM2_SIZE            0x10000UL  /*!< SRAM2=64k*/

/* External memories base addresses - Not aliased */
#define FMC_BASE              (0x60000000UL) /*!< FMC base address */
#define OCTOSPI1_BASE         (0x90000000UL) /*!< OCTOSPI1 memories accessible over AHB base address */

#define FMC_BANK1             FMC_BASE
#define FMC_BANK1_1           FMC_BANK1
#define FMC_BANK1_2           (FMC_BANK1 + 0x04000000UL)
#define FMC_BANK1_3           (FMC_BANK1 + 0x08000000UL)
#define FMC_BANK1_4           (FMC_BANK1 + 0x0C000000UL)
#define FMC_BANK3             (FMC_BASE  + 0x20000000UL)

/* Flash, Peripheral and internal SRAMs base addresses - Non secure aliased */
#define FLASH_BASE_NS         (0x08000000UL) /*!< FLASH(up to 512 KB) base address */
#define SRAM1_BASE_NS         (0x20000000UL) /*!< SRAM1(up to 192 KB) base address */
#define SRAM2_BASE_NS         (0x20030000UL) /*!< SRAM2(64 KB) base address */
#define SRAM_BASE_NS          SRAM1_BASE
#define PERIPH_BASE_NS        (0x40000000UL) /*!< Peripheral non secure base address */

/* Peripheral memory map - Non secure */
#define APB1PERIPH_BASE_NS    PERIPH_BASE_NS
#define APB2PERIPH_BASE_NS    (PERIPH_BASE_NS + 0x00010000UL)
#define AHB1PERIPH_BASE_NS    (PERIPH_BASE_NS + 0x00020000UL)
#define AHB2PERIPH_BASE_NS    (PERIPH_BASE_NS + 0x02020000UL)
#define AHB3PERIPH_BASE_NS    (PERIPH_BASE_NS + 0x04020000UL)

/*!< APB1 Non secure peripherals */
#define TIM2_BASE_NS          (APB1PERIPH_BASE_NS + 0x0000UL)
#define TIM3_BASE_NS          (APB1PERIPH_BASE_NS + 0x0400UL)
#define TIM4_BASE_NS          (APB1PERIPH_BASE_NS + 0x0800UL)
#define TIM5_BASE_NS          (APB1PERIPH_BASE_NS + 0x0C00UL)
#define TIM6_BASE_NS          (APB1PERIPH_BASE_NS + 0x1000UL)
#define TIM7_BASE_NS          (APB1PERIPH_BASE_NS + 0x1400UL)
#define RTC_BASE_NS           (APB1PERIPH_BASE_NS + 0x2800UL)
#define WWDG_BASE_NS          (APB1PERIPH_BASE_NS + 0x2C00UL)
#define IWDG_BASE_NS          (APB1PERIPH_BASE_NS + 0x3000UL)
#define TAMP_BASE_NS          (APB1PERIPH_BASE_NS + 0x3400UL)
#define SPI2_BASE_NS          (APB1PERIPH_BASE_NS + 0x3800UL)
#define SPI3_BASE_NS          (APB1PERIPH_BASE_NS + 0x3C00UL)
#define USART2_BASE_NS        (APB1PERIPH_BASE_NS + 0x4400UL)
#define USART3_BASE_NS        (APB1PERIPH_BASE_NS + 0x4800UL)
#define UART4_BASE_NS         (APB1PERIPH_BASE_NS + 0x4C00UL)
#define UART5_BASE_NS         (APB1PERIPH_BASE_NS + 0x5000UL)
#define I2C1_BASE_NS          (APB1PERIPH_BASE_NS + 0x5400UL)
#define I2C2_BASE_NS          (APB1PERIPH_BASE_NS + 0x5800UL)
#define I2C3_BASE_NS          (APB1PERIPH_BASE_NS + 0x5C00UL)
#define CRS_BASE_NS           (APB1PERIPH_BASE_NS + 0x6000UL)
#define PWR_BASE_NS           (APB1PERIPH_BASE_NS + 0x7000UL)
#define DAC_BASE_NS           (APB1PERIPH_BASE_NS + 0x7400UL)
#define DAC1_BASE_NS          (APB1PERIPH_BASE_NS + 0x7400UL)
#define OPAMP_BASE_NS         (APB1PERIPH_BASE_NS + 0x7800UL)
#define OPAMP1_BASE_NS        (APB1PERIPH_BASE_NS + 0x7800UL)
#define OPAMP2_BASE_NS        (APB1PERIPH_BASE_NS + 0x7810UL)
#define LPTIM1_BASE_NS        (APB1PERIPH_BASE_NS + 0x7C00UL)
#define LPUART1_BASE_NS       (APB1PERIPH_BASE_NS + 0x8000UL)
#define I2C4_BASE_NS          (APB1PERIPH_BASE_NS + 0x8400UL)
#define LPTIM2_BASE_NS        (APB1PERIPH_BASE_NS + 0x9400UL)
#define LPTIM3_BASE_NS        (APB1PERIPH_BASE_NS + 0x9800UL)
#define FDCAN1_BASE_NS        (APB1PERIPH_BASE_NS + 0xA400UL)
#define FDCAN_CONFIG_BASE_NS  (APB1PERIPH_BASE_NS + 0xA500UL)  /*!< FDCAN configuration registers base address */
#define SRAMCAN_BASE_NS       (APB1PERIPH_BASE_NS + 0xAC00UL)
#define USB_BASE_NS           (APB1PERIPH_BASE_NS + 0xD400UL)  /*!< USB_IP Peripheral Registers base address */
#define USB_PMAADDR_NS        (APB1PERIPH_BASE_NS + 0xD800UL)  /*!< USB_IP Packet Memory Area base address */
#define UCPD1_BASE_NS         (APB1PERIPH_BASE_NS + 0xDC00UL)

/*!< APB2 Non secure peripherals */
#define SYSCFG_BASE_NS        (APB2PERIPH_BASE_NS + 0x0000UL)
#define VREFBUF_BASE_NS       (APB2PERIPH_BASE_NS + 0x0100UL)
#define COMP1_BASE_NS         (APB2PERIPH_BASE_NS + 0x0200UL)
#define COMP2_BASE_NS         (APB2PERIPH_BASE_NS + 0x0204UL)
#define TIM1_BASE_NS          (APB2PERIPH_BASE_NS + 0x2C00UL)
#define SPI1_BASE_NS          (APB2PERIPH_BASE_NS + 0x3000UL)
#define TIM8_BASE_NS          (APB2PERIPH_BASE_NS + 0x3400UL)
#define USART1_BASE_NS        (APB2PERIPH_BASE_NS + 0x3800UL)
#define TIM15_BASE_NS         (APB2PERIPH_BASE_NS + 0x4000UL)
#define TIM16_BASE_NS         (APB2PERIPH_BASE_NS + 0x4400UL)
#define TIM17_BASE_NS         (APB2PERIPH_BASE_NS + 0x4800UL)
#define SAI1_BASE_NS          (APB2PERIPH_BASE_NS + 0x5400UL)
#define SAI1_Block_A_BASE_NS  (SAI1_BASE_NS + 0x0004UL)
#define SAI1_Block_B_BASE_NS  (SAI1_BASE_NS + 0x0024UL)
#define SAI2_BASE_NS          (APB2PERIPH_BASE_NS + 0x5800UL)
#define SAI2_Block_A_BASE_NS  (SAI2_BASE_NS + 0x0004UL)
#define SAI2_Block_B_BASE_NS  (SAI2_BASE_NS + 0x0024UL)
#define DFSDM1_BASE_NS        (APB2PERIPH_BASE_NS + 0x6000UL)
#define DFSDM1_Channel0_BASE_NS (DFSDM1_BASE_NS + 0x0000UL)
#define DFSDM1_Channel1_BASE_NS (DFSDM1_BASE_NS + 0x0020UL)
#define DFSDM1_Channel2_BASE_NS (DFSDM1_BASE_NS + 0x0040UL)
#define DFSDM1_Channel3_BASE_NS (DFSDM1_BASE_NS + 0x0060UL)
#define DFSDM1_Filter0_BASE_NS  (DFSDM1_BASE_NS + 0x0100UL)
#define DFSDM1_Filter1_BASE_NS  (DFSDM1_BASE_NS + 0x0180UL)
#define DFSDM1_Filter2_BASE_NS  (DFSDM1_BASE_NS + 0x0200UL)
#define DFSDM1_Filter3_BASE_NS  (DFSDM1_BASE_NS + 0x0280UL)

/*!< AHB1 Non secure peripherals */
#define DMA1_BASE_NS          (AHB1PERIPH_BASE_NS)
#define DMA2_BASE_NS          (AHB1PERIPH_BASE_NS + 0x0400UL)
#define DMAMUX1_BASE_NS       (AHB1PERIPH_BASE_NS + 0x0800UL)
#define RCC_BASE_NS           (AHB1PERIPH_BASE_NS + 0x1000UL)
#define FLASH_R_BASE_NS       (AHB1PERIPH_BASE_NS + 0x2000UL)
#define CRC_BASE_NS           (AHB1PERIPH_BASE_NS + 0x3000UL)
#define TSC_BASE_NS           (AHB1PERIPH_BASE_NS + 0x4000UL)
#define EXTI_BASE_NS          (AHB1PERIPH_BASE_NS + 0xF400UL)
#define ICACHE_BASE_NS        (AHB1PERIPH_BASE_NS + 0x10400UL)
#define GTZC_TZSC_BASE_NS     (AHB1PERIPH_BASE_NS + 0x12400UL)
#define GTZC_TZIC_BASE_NS     (AHB1PERIPH_BASE_NS + 0x12800UL)
#define GTZC_MPCBB1_BASE_NS   (AHB1PERIPH_BASE_NS + 0x12C00UL)
#define GTZC_MPCBB2_BASE_NS   (AHB1PERIPH_BASE_NS + 0x13000UL)

#define DMA1_Channel1_BASE_NS (DMA1_BASE_NS + 0x0008UL)
#define DMA1_Channel2_BASE_NS (DMA1_BASE_NS + 0x001CUL)
#define DMA1_Channel3_BASE_NS (DMA1_BASE_NS + 0x0030UL)
#define DMA1_Channel4_BASE_NS (DMA1_BASE_NS + 0x0044UL)
#define DMA1_Channel5_BASE_NS (DMA1_BASE_NS + 0x0058UL)
#define DMA1_Channel6_BASE_NS (DMA1_BASE_NS + 0x006CUL)
#define DMA1_Channel7_BASE_NS (DMA1_BASE_NS + 0x0080UL)
#define DMA1_Channel8_BASE_NS (DMA1_BASE_NS + 0x0094UL)

#define DMA2_Channel1_BASE_NS (DMA2_BASE_NS + 0x0008UL)
#define DMA2_Channel2_BASE_NS (DMA2_BASE_NS + 0x001CUL)
#define DMA2_Channel3_BASE_NS (DMA2_BASE_NS + 0x0030UL)
#define DMA2_Channel4_BASE_NS (DMA2_BASE_NS + 0x0044UL)
#define DMA2_Channel5_BASE_NS (DMA2_BASE_NS + 0x0058UL)
#define DMA2_Channel6_BASE_NS (DMA2_BASE_NS + 0x006CUL)
#define DMA2_Channel7_BASE_NS (DMA2_BASE_NS + 0x0080UL)
#define DMA2_Channel8_BASE_NS (DMA2_BASE_NS + 0x0094UL)

#define DMAMUX1_Channel0_BASE_NS  (DMAMUX1_BASE_NS)
#define DMAMUX1_Channel1_BASE_NS  (DMAMUX1_BASE_NS + 0x00000004UL)
#define DMAMUX1_Channel2_BASE_NS  (DMAMUX1_BASE_NS + 0x00000008UL)
#define DMAMUX1_Channel3_BASE_NS  (DMAMUX1_BASE_NS + 0x0000000CUL)
#define DMAMUX1_Channel4_BASE_NS  (DMAMUX1_BASE_NS + 0x00000010UL)
#define DMAMUX1_Channel5_BASE_NS  (DMAMUX1_BASE_NS + 0x00000014UL)
#define DMAMUX1_Channel6_BASE_NS  (DMAMUX1_BASE_NS + 0x00000018UL)
#define DMAMUX1_Channel7_BASE_NS  (DMAMUX1_BASE_NS + 0x0000001CUL)
#define DMAMUX1_Channel8_BASE_NS  (DMAMUX1_BASE_NS + 0x00000020UL)
#define DMAMUX1_Channel9_BASE_NS  (DMAMUX1_BASE_NS + 0x00000024UL)
#define DMAMUX1_Channel10_BASE_NS (DMAMUX1_BASE_NS + 0x00000028UL)
#define DMAMUX1_Channel11_BASE_NS (DMAMUX1_BASE_NS + 0x0000002CUL)
#define DMAMUX1_Channel12_BASE_NS (DMAMUX1_BASE_NS + 0x00000030UL)
#define DMAMUX1_Channel13_BASE_NS (DMAMUX1_BASE_NS + 0x00000034UL)
#define DMAMUX1_Channel14_BASE_NS (DMAMUX1_BASE_NS + 0x00000038UL)
#define DMAMUX1_Channel15_BASE_NS (DMAMUX1_BASE_NS + 0x0000003CUL)

#define DMAMUX1_RequestGenerator0_BASE_NS  (DMAMUX1_BASE_NS + 0x00000100UL)
#define DMAMUX1_RequestGenerator1_BASE_NS  (DMAMUX1_BASE_NS + 0x00000104UL)
#define DMAMUX1_RequestGenerator2_BASE_NS  (DMAMUX1_BASE_NS + 0x00000108UL)
#define DMAMUX1_RequestGenerator3_BASE_NS  (DMAMUX1_BASE_NS + 0x0000010CUL)

#define DMAMUX1_ChannelStatus_BASE_NS      (DMAMUX1_BASE_NS + 0x00000080UL)
#define DMAMUX1_RequestGenStatus_BASE_NS   (DMAMUX1_BASE_NS + 0x00000140UL)

/*!< AHB2 Non secure peripherals */
#define GPIOA_BASE_NS         (AHB2PERIPH_BASE_NS + 0x0000UL)
#define GPIOB_BASE_NS         (AHB2PERIPH_BASE_NS + 0x0400UL)
#define GPIOC_BASE_NS         (AHB2PERIPH_BASE_NS + 0x0800UL)
#define GPIOD_BASE_NS         (AHB2PERIPH_BASE_NS + 0x0C00UL)
#define GPIOE_BASE_NS         (AHB2PERIPH_BASE_NS + 0x1000UL)
#define GPIOF_BASE_NS         (AHB2PERIPH_BASE_NS + 0x1400UL)
#define GPIOG_BASE_NS         (AHB2PERIPH_BASE_NS + 0x1800UL)
#define GPIOH_BASE_NS         (AHB2PERIPH_BASE_NS + 0x1C00UL)
#define ADC1_BASE_NS          (AHB2PERIPH_BASE_NS + 0x8000UL)
#define ADC2_BASE_NS          (AHB2PERIPH_BASE_NS + 0x8100UL)
#define ADC12_COMMON_BASE_NS  (AHB2PERIPH_BASE_NS + 0x8300UL)

#define HASH_BASE_NS          (AHB2PERIPH_BASE_NS + 0xA0400UL)
#define HASH_DIGEST_BASE_NS   (AHB2PERIPH_BASE_NS + 0xA0710UL)
#define RNG_BASE_NS           (AHB2PERIPH_BASE_NS + 0xA0800UL)
#define SDMMC1_BASE_NS        (AHB2PERIPH_BASE_NS + 0xA8000UL)

/*!< AHB3 Non secure peripherals */
#define FMC_R_BASE_NS         (AHB3PERIPH_BASE_NS + 0x0000UL) /*!< FMC  control registers base address */
#define OCTOSPI1_R_BASE_NS    (AHB3PERIPH_BASE_NS + 0x1000UL) /*!< OCTOSPI1 control registers base address */

/*!< FMC Banks Non secure registers base  address */
#define FMC_Bank1_R_BASE_NS   (FMC_R_BASE_NS + 0x0000UL)
#define FMC_Bank1E_R_BASE_NS  (FMC_R_BASE_NS + 0x0104UL)
#define FMC_Bank3_R_BASE_NS   (FMC_R_BASE_NS + 0x0080UL)

/* Flash, Peripheral and internal SRAMs base addresses - Secure aliased */
#define FLASH_BASE_S          (0x0C000000UL) /*!< FLASH(up to 512 KB) base address */
#define SRAM1_BASE_S          (0x30000000UL) /*!< SRAM1(up to 192 KB) base address */
#define SRAM2_BASE_S          (0x30030000UL) /*!< SRAM2(64 KB) base address */
#define SRAM_BASE_S           SRAM1_BASE_S
#define PERIPH_BASE_S         (0x50000000UL) /*!< Peripheral secure base address */

/* Peripheral memory map - Secure */
#define APB1PERIPH_BASE_S     PERIPH_BASE_S
#define APB2PERIPH_BASE_S     (PERIPH_BASE_S + 0x00010000UL)
#define AHB1PERIPH_BASE_S     (PERIPH_BASE_S + 0x00020000UL)
#define AHB2PERIPH_BASE_S     (PERIPH_BASE_S + 0x02020000UL)
#define AHB3PERIPH_BASE_S     (PERIPH_BASE_S + 0x04020000UL)

/*!< APB1 Secure peripherals */
#define TIM2_BASE_S           (APB1PERIPH_BASE_S + 0x0000UL)
#define TIM3_BASE_S           (APB1PERIPH_BASE_S + 0x0400UL)
#define TIM4_BASE_S           (APB1PERIPH_BASE_S + 0x0800UL)
#define TIM5_BASE_S           (APB1PERIPH_BASE_S + 0x0C00UL)
#define TIM6_BASE_S           (APB1PERIPH_BASE_S + 0x1000UL)
#define TIM7_BASE_S           (APB1PERIPH_BASE_S + 0x1400UL)
#define RTC_BASE_S            (APB1PERIPH_BASE_S + 0x2800UL)
#define WWDG_BASE_S           (APB1PERIPH_BASE_S + 0x2C00UL)
#define IWDG_BASE_S           (APB1PERIPH_BASE_S + 0x3000UL)
#define TAMP_BASE_S           (APB1PERIPH_BASE_S + 0x3400UL)
#define SPI2_BASE_S           (APB1PERIPH_BASE_S + 0x3800UL)
#define SPI3_BASE_S           (APB1PERIPH_BASE_S + 0x3C00UL)
#define USART2_BASE_S         (APB1PERIPH_BASE_S + 0x4400UL)
#define USART3_BASE_S         (APB1PERIPH_BASE_S + 0x4800UL)
#define UART4_BASE_S          (APB1PERIPH_BASE_S + 0x4C00UL)
#define UART5_BASE_S          (APB1PERIPH_BASE_S + 0x5000UL)
#define I2C1_BASE_S           (APB1PERIPH_BASE_S + 0x5400UL)
#define I2C2_BASE_S           (APB1PERIPH_BASE_S + 0x5800UL)
#define I2C3_BASE_S           (APB1PERIPH_BASE_S + 0x5C00UL)
#define CRS_BASE_S            (APB1PERIPH_BASE_S + 0x6000UL)
#define PWR_BASE_S            (APB1PERIPH_BASE_S + 0x7000UL)
#define DAC_BASE_S            (APB1PERIPH_BASE_S + 0x7400UL)
#define DAC1_BASE_S           (APB1PERIPH_BASE_S + 0x7400UL)
#define OPAMP_BASE_S          (APB1PERIPH_BASE_S + 0x7800UL)
#define OPAMP1_BASE_S         (APB1PERIPH_BASE_S + 0x7800UL)
#define OPAMP2_BASE_S         (APB1PERIPH_BASE_S + 0x7810UL)
#define LPTIM1_BASE_S         (APB1PERIPH_BASE_S + 0x7C00UL)
#define LPUART1_BASE_S        (APB1PERIPH_BASE_S + 0x8000UL)
#define I2C4_BASE_S           (APB1PERIPH_BASE_S + 0x8400UL)
#define LPTIM2_BASE_S         (APB1PERIPH_BASE_S + 0x9400UL)
#define LPTIM3_BASE_S         (APB1PERIPH_BASE_S + 0x9800UL)
#define FDCAN1_BASE_S         (APB1PERIPH_BASE_S + 0xA400UL)
#define FDCAN_CONFIG_BASE_S   (APB1PERIPH_BASE_S + 0xA500UL)
#define SRAMCAN_BASE_S        (APB1PERIPH_BASE_S + 0xAC00UL)
#define USB_BASE_S            (APB1PERIPH_BASE_S + 0xD400UL)  /*!< USB_IP Peripheral Registers base address */
#define USB_PMAADDR_S         (APB1PERIPH_BASE_S + 0xD800UL)  /*!< USB_IP Packet Memory Area base address */
#define UCPD1_BASE_S          (APB1PERIPH_BASE_S + 0xDC00UL)

/*!< APB2 Secure peripherals */
#define SYSCFG_BASE_S         (APB2PERIPH_BASE_S + 0x0000UL)
#define VREFBUF_BASE_S        (APB2PERIPH_BASE_S + 0x0100UL)
#define COMP1_BASE_S          (APB2PERIPH_BASE_S + 0x0200UL)
#define COMP2_BASE_S          (APB2PERIPH_BASE_S + 0x0204UL)
#define TIM1_BASE_S           (APB2PERIPH_BASE_S + 0x2C00UL)
#define SPI1_BASE_S           (APB2PERIPH_BASE_S + 0x3000UL)
#define TIM8_BASE_S           (APB2PERIPH_BASE_S + 0x3400UL)
#define USART1_BASE_S         (APB2PERIPH_BASE_S + 0x3800UL)
#define TIM15_BASE_S          (APB2PERIPH_BASE_S + 0x4000UL)
#define TIM16_BASE_S          (APB2PERIPH_BASE_S + 0x4400UL)
#define TIM17_BASE_S          (APB2PERIPH_BASE_S + 0x4800UL)
#define SAI1_BASE_S           (APB2PERIPH_BASE_S + 0x5400UL)
#define SAI1_Block_A_BASE_S   (SAI1_BASE_S + 0x0004UL)
#define SAI1_Block_B_BASE_S   (SAI1_BASE_S + 0x0024UL)
#define SAI2_BASE_S           (APB2PERIPH_BASE_S + 0x5800UL)
#define SAI2_Block_A_BASE_S   (SAI2_BASE_S + 0x0004UL)
#define SAI2_Block_B_BASE_S   (SAI2_BASE_S + 0x0024UL)
#define DFSDM1_BASE_S         (APB2PERIPH_BASE_S + 0x6000UL)
#define DFSDM1_Channel0_BASE_S (DFSDM1_BASE_S + 0x0000UL)
#define DFSDM1_Channel1_BASE_S (DFSDM1_BASE_S + 0x0020UL)
#define DFSDM1_Channel2_BASE_S (DFSDM1_BASE_S + 0x0040UL)
#define DFSDM1_Channel3_BASE_S (DFSDM1_BASE_S + 0x0060UL)
#define DFSDM1_Filter0_BASE_S  (DFSDM1_BASE_S + 0x0100UL)
#define DFSDM1_Filter1_BASE_S  (DFSDM1_BASE_S + 0x0180UL)
#define DFSDM1_Filter2_BASE_S  (DFSDM1_BASE_S + 0x0200UL)
#define DFSDM1_Filter3_BASE_S  (DFSDM1_BASE_S + 0x0280UL)

/*!< AHB1 Secure peripherals */
#define DMA1_BASE_S           (AHB1PERIPH_BASE_S)
#define DMA2_BASE_S           (AHB1PERIPH_BASE_S + 0x0400UL)
#define DMAMUX1_BASE_S        (AHB1PERIPH_BASE_S + 0x0800UL)
#define RCC_BASE_S            (AHB1PERIPH_BASE_S + 0x1000UL)
#define FLASH_R_BASE_S        (AHB1PERIPH_BASE_S + 0x2000UL)
#define CRC_BASE_S            (AHB1PERIPH_BASE_S + 0x3000UL)
#define TSC_BASE_S            (AHB1PERIPH_BASE_S + 0x4000UL)
#define EXTI_BASE_S           (AHB1PERIPH_BASE_S + 0xF400UL)
#define ICACHE_BASE_S         (AHB1PERIPH_BASE_S + 0x10400UL)
#define GTZC_TZSC_BASE_S      (AHB1PERIPH_BASE_S + 0x12400UL)
#define GTZC_TZIC_BASE_S      (AHB1PERIPH_BASE_S + 0x12800UL)
#define GTZC_MPCBB1_BASE_S    (AHB1PERIPH_BASE_S + 0x12C00UL)
#define GTZC_MPCBB2_BASE_S    (AHB1PERIPH_BASE_S + 0x13000UL)

#define DMA1_Channel1_BASE_S  (DMA1_BASE_S + 0x0008UL)
#define DMA1_Channel2_BASE_S  (DMA1_BASE_S + 0x001CUL)
#define DMA1_Channel3_BASE_S  (DMA1_BASE_S + 0x0030UL)
#define DMA1_Channel4_BASE_S  (DMA1_BASE_S + 0x0044UL)
#define DMA1_Channel5_BASE_S  (DMA1_BASE_S + 0x0058UL)
#define DMA1_Channel6_BASE_S  (DMA1_BASE_S + 0x006CUL)
#define DMA1_Channel7_BASE_S  (DMA1_BASE_S + 0x0080UL)
#define DMA1_Channel8_BASE_S  (DMA1_BASE_S + 0x0094UL)

#define DMA2_Channel1_BASE_S  (DMA2_BASE_S + 0x0008UL)
#define DMA2_Channel2_BASE_S  (DMA2_BASE_S + 0x001CUL)
#define DMA2_Channel3_BASE_S  (DMA2_BASE_S + 0x0030UL)
#define DMA2_Channel4_BASE_S  (DMA2_BASE_S + 0x0044UL)
#define DMA2_Channel5_BASE_S  (DMA2_BASE_S + 0x0058UL)
#define DMA2_Channel6_BASE_S  (DMA2_BASE_S + 0x006CUL)
#define DMA2_Channel7_BASE_S  (DMA2_BASE_S + 0x0080UL)
#define DMA2_Channel8_BASE_S  (DMA2_BASE_S + 0x0094UL)

#define DMAMUX1_Channel0_BASE_S  (DMAMUX1_BASE_S)
#define DMAMUX1_Channel1_BASE_S  (DMAMUX1_BASE_S + 0x00000004UL)
#define DMAMUX1_Channel2_BASE_S  (DMAMUX1_BASE_S + 0x00000008UL)
#define DMAMUX1_Channel3_BASE_S  (DMAMUX1_BASE_S + 0x0000000CUL)
#define DMAMUX1_Channel4_BASE_S  (DMAMUX1_BASE_S + 0x00000010UL)
#define DMAMUX1_Channel5_BASE_S  (DMAMUX1_BASE_S + 0x00000014UL)
#define DMAMUX1_Channel6_BASE_S  (DMAMUX1_BASE_S + 0x00000018UL)
#define DMAMUX1_Channel7_BASE_S  (DMAMUX1_BASE_S + 0x0000001CUL)
#define DMAMUX1_Channel8_BASE_S  (DMAMUX1_BASE_S + 0x00000020UL)
#define DMAMUX1_Channel9_BASE_S  (DMAMUX1_BASE_S + 0x00000024UL)
#define DMAMUX1_Channel10_BASE_S (DMAMUX1_BASE_S + 0x00000028UL)
#define DMAMUX1_Channel11_BASE_S (DMAMUX1_BASE_S + 0x0000002CUL)
#define DMAMUX1_Channel12_BASE_S (DMAMUX1_BASE_S + 0x00000030UL)
#define DMAMUX1_Channel13_BASE_S (DMAMUX1_BASE_S + 0x00000034UL)
#define DMAMUX1_Channel14_BASE_S (DMAMUX1_BASE_S + 0x00000038UL)
#define DMAMUX1_Channel15_BASE_S (DMAMUX1_BASE_S + 0x0000003CUL)

#define DMAMUX1_RequestGenerator0_BASE_S (DMAMUX1_BASE_S + 0x00000100UL)
#define DMAMUX1_RequestGenerator1_BASE_S (DMAMUX1_BASE_S + 0x00000104UL)
#define DMAMUX1_RequestGenerator2_BASE_S (DMAMUX1_BASE_S + 0x00000108UL)
#define DMAMUX1_RequestGenerator3_BASE_S (DMAMUX1_BASE_S + 0x0000010CUL)

#define DMAMUX1_ChannelStatus_BASE_S     (DMAMUX1_BASE_S + 0x00000080UL)
#define DMAMUX1_RequestGenStatus_BASE_S  (DMAMUX1_BASE_S + 0x00000140UL)

/*!< AHB2 Secure peripherals */
#define GPIOA_BASE_S          (AHB2PERIPH_BASE_S + 0x0000UL)
#define GPIOB_BASE_S          (AHB2PERIPH_BASE_S + 0x0400UL)
#define GPIOC_BASE_S          (AHB2PERIPH_BASE_S + 0x0800UL)
#define GPIOD_BASE_S          (AHB2PERIPH_BASE_S + 0x0C00UL)
#define GPIOE_BASE_S          (AHB2PERIPH_BASE_S + 0x1000UL)
#define GPIOF_BASE_S          (AHB2PERIPH_BASE_S + 0x1400UL)
#define GPIOG_BASE_S          (AHB2PERIPH_BASE_S + 0x1800UL)
#define GPIOH_BASE_S          (AHB2PERIPH_BASE_S + 0x1C00UL)
#define ADC1_BASE_S           (AHB2PERIPH_BASE_S + 0x8000UL)
#define ADC2_BASE_S           (AHB2PERIPH_BASE_S + 0x8100UL)
#define ADC12_COMMON_BASE_S   (AHB2PERIPH_BASE_S + 0x8300UL)

#define HASH_BASE_S            (AHB2PERIPH_BASE_S + 0xA0400UL)
#define HASH_DIGEST_BASE_S     (AHB2PERIPH_BASE_S + 0xA0710UL)
#define RNG_BASE_S             (AHB2PERIPH_BASE_S + 0xA0800UL)
#define SDMMC1_BASE_S          (AHB2PERIPH_BASE_S + 0xA8000UL)

/*!< AHB3 Secure peripherals */
#define FMC_R_BASE_S          (AHB3PERIPH_BASE_S + 0x0000UL) /*!< FMC  control registers base address */
#define OCTOSPI1_R_BASE_S     (AHB3PERIPH_BASE_S + 0x1000UL) /*!< OCTOSPI1 control registers base address */

/*!< FMC Banks Secure registers base address */
#define FMC_Bank1_R_BASE_S    (FMC_R_BASE_S + 0x0000UL)
#define FMC_Bank1E_R_BASE_S   (FMC_R_BASE_S + 0x0104UL)
#define FMC_Bank3_R_BASE_S    (FMC_R_BASE_S + 0x0080UL)

/*!< Debug MCU registers base address */
#define DBGMCU_BASE           (0xE0044000UL)

#define PACKAGE_BASE          (0x0BFA0500UL)        /*!< Package data register base address     */
#define UID_BASE              (0x0BFA0590UL)        /*!< Unique device ID register base address */
#define FLASHSIZE_BASE        (0x0BFA05E0UL)        /*!< Flash size data register base address  */

/*!< Internal Flash size */
#define FLASH_SIZE            ((((*((uint16_t *)FLASHSIZE_BASE)) == 0xFFFFU)) ? 0x80000U : \
                               ((((*((uint16_t *)FLASHSIZE_BASE)) == 0x0000U)) ? 0x80000U : \
                                (((uint32_t)(*((uint16_t *)FLASHSIZE_BASE)) & (0x0FFFU)) << 10U)))

/*!< OTP Area */
#define OTP_BASE              (0x0BFA0000UL)
#define OTP_SIZE              (0x200U)

/*!< Bootloader Area */
#define BL_ID_ADDR            (0x0BF97FFEUL)          /*!< Bootloader ID address */
#define BL_ID                 (*(uint8_t*)BL_ID_ADDR) /*!< Bootloader ID */

/*!< Root Secure Service Library */
/************ RSSLIB SAU system Flash region definition constants *************/
#define RSSLIB_SYS_FLASH_NS_PFUNC_START   (0x0BF97F40UL)
#define RSSLIB_SYS_FLASH_NS_PFUNC_END     (0x0BF97FFFUL)

/************ RSSLIB function return constants ********************************/
#define RSSLIB_ERROR   (0xF5F5F5F5UL)
#define RSSLIB_SUCCESS (0xEAEAEAEAUL)

/*!< RSSLIB  pointer function structure address definition */
#define RSSLIB_PFUNC_BASE (0x0BF97F40UL)
#define RSSLIB_PFUNC      ((RSSLIB_pFunc_TypeDef *)RSSLIB_PFUNC_BASE)

/*!< HDP Area constant definition */
#define RSSLIB_HDP_AREA_Pos  (0U)
#define RSSLIB_HDP_AREA_Msk  (0x3UL << RSSLIB_HDP_AREA_Pos )
#define RSSLIB_HDP_AREA1_Pos (0U)
#define RSSLIB_HDP_AREA1_Msk (0x1UL << RSSLIB_HDP_AREA1_Pos )
#define RSSLIB_HDP_AREA2_Pos (1U)
#define RSSLIB_HDP_AREA2_Msk (0x1UL << RSSLIB_HDP_AREA2_Pos )

/**
  * @brief  Prototype of RSSLIB Close and exit HDP Function
  * @detail This function close the requested hdp area passed in input
  *         parameter and jump to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  HdpArea notifies which hdp area to close, can be a combination of
  *         hdpa area 1 and hdp area 2
  * @param  pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t ( *RSSLIB_S_CloseExitHDP_TypeDef)( uint32_t HdpArea, uint32_t VectorTableAddr );


/**
  * @brief RSSLib non-secure callable function pointer structure
  */
typedef struct
{
  __IM uint32_t Reserved[8];
}NSC_pFuncTypeDef;

/**
  * @brief RSSLib secure callable function pointer structure
  */
typedef struct
{
  __IM RSSLIB_S_CloseExitHDP_TypeDef CloseExitHDP_BL90;        /*!< RSSLIB Bootloader ID90 Close and exit HDP  Address offset: 0x20 */
  __IM uint32_t Reserved2;
  __IM RSSLIB_S_CloseExitHDP_TypeDef CloseExitHDP_BL91;        /*!< RSSLIB Bootloader ID91 Close and exit HDP  Address offset: 0x28 */
}S_pFuncTypeDef;

/**
  * @brief RSSLib function pointer structure
  */
typedef struct
{
  NSC_pFuncTypeDef NSC;
  S_pFuncTypeDef S;
}RSSLIB_pFunc_TypeDef;

/** @} */ /* End of group STM32L5xx_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32L5xx_Peripheral_declaration
  * @{
  */

/*!< APB1 Non secure peripherals */
#define TIM2_NS             ((TIM_TypeDef *) TIM2_BASE_NS)
#define TIM3_NS             ((TIM_TypeDef *) TIM3_BASE_NS)
#define TIM4_NS             ((TIM_TypeDef *) TIM4_BASE_NS)
#define TIM5_NS             ((TIM_TypeDef *) TIM5_BASE_NS)
#define TIM6_NS             ((TIM_TypeDef *) TIM6_BASE_NS)
#define TIM7_NS             ((TIM_TypeDef *) TIM7_BASE_NS)
#define RTC_NS              ((RTC_TypeDef *) RTC_BASE_NS)
#define WWDG_NS             ((WWDG_TypeDef *) WWDG_BASE_NS)
#define IWDG_NS             ((IWDG_TypeDef *) IWDG_BASE_NS)
#define TAMP_NS             ((TAMP_TypeDef *) TAMP_BASE_NS)
#define SPI2_NS             ((SPI_TypeDef *) SPI2_BASE_NS)
#define SPI3_NS             ((SPI_TypeDef *) SPI3_BASE_NS)
#define USART2_NS           ((USART_TypeDef *) USART2_BASE_NS)
#define USART3_NS           ((USART_TypeDef *) USART3_BASE_NS)
#define UART4_NS            ((USART_TypeDef *) UART4_BASE_NS)
#define UART5_NS            ((USART_TypeDef *) UART5_BASE_NS)
#define I2C1_NS             ((I2C_TypeDef *) I2C1_BASE_NS)
#define I2C2_NS             ((I2C_TypeDef *) I2C2_BASE_NS)
#define I2C3_NS             ((I2C_TypeDef *) I2C3_BASE_NS)
#define CRS_NS              ((CRS_TypeDef *) CRS_BASE_NS)
#define FDCAN1_NS           ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_NS)
#define FDCAN_CONFIG_NS     ((FDCAN_Config_TypeDef *) FDCAN_CONFIG_BASE_NS)
#define I2C4_NS             ((I2C_TypeDef *) I2C4_BASE_NS)
#define PWR_NS              ((PWR_TypeDef *) PWR_BASE_NS)
#define DAC_NS              ((DAC_TypeDef *) DAC1_BASE_NS)
#define DAC1_NS             ((DAC_TypeDef *) DAC1_BASE_NS)
#define OPAMP_NS            ((OPAMP_TypeDef *) OPAMP_BASE_NS)
#define OPAMP1_NS           ((OPAMP_TypeDef *) OPAMP1_BASE_NS)
#define OPAMP2_NS           ((OPAMP_TypeDef *) OPAMP2_BASE_NS)
#define OPAMP12_COMMON_NS   ((OPAMP_Common_TypeDef *) OPAMP1_BASE_NS)
#define LPTIM1_NS           ((LPTIM_TypeDef *) LPTIM1_BASE_NS)
#define LPUART1_NS          ((USART_TypeDef *) LPUART1_BASE_NS)
#define LPTIM2_NS           ((LPTIM_TypeDef *) LPTIM2_BASE_NS)
#define LPTIM3_NS           ((LPTIM_TypeDef *) LPTIM3_BASE_NS)
#define USB_NS              ((USB_TypeDef *) USB_BASE_NS)
#define UCPD1_NS            ((UCPD_TypeDef *) UCPD1_BASE_NS)

/*!< APB2 Non secure peripherals */
#define SYSCFG_NS           ((SYSCFG_TypeDef *) SYSCFG_BASE_NS)
#define VREFBUF_NS          ((VREFBUF_TypeDef *) VREFBUF_BASE_NS)
#define COMP1_NS            ((COMP_TypeDef *) COMP1_BASE_NS)
#define COMP2_NS            ((COMP_TypeDef *) COMP2_BASE_NS)
#define COMP12_COMMON_NS    ((COMP_Common_TypeDef *) COMP2_BASE_NS)
#define TIM1_NS             ((TIM_TypeDef *) TIM1_BASE_NS)
#define SPI1_NS             ((SPI_TypeDef *) SPI1_BASE_NS)
#define TIM8_NS             ((TIM_TypeDef *) TIM8_BASE_NS)
#define USART1_NS           ((USART_TypeDef *) USART1_BASE_NS)
#define TIM15_NS            ((TIM_TypeDef *) TIM15_BASE_NS)
#define TIM16_NS            ((TIM_TypeDef *) TIM16_BASE_NS)
#define TIM17_NS            ((TIM_TypeDef *) TIM17_BASE_NS)
#define SAI1_NS             ((SAI_TypeDef *) SAI1_BASE_NS)
#define SAI1_Block_A_NS     ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_NS)
#define SAI1_Block_B_NS     ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_NS)
#define SAI2_NS             ((SAI_TypeDef *) SAI2_BASE_NS)
#define SAI2_Block_A_NS     ((SAI_Block_TypeDef *)SAI2_Block_A_BASE_NS)
#define SAI2_Block_B_NS     ((SAI_Block_TypeDef *)SAI2_Block_B_BASE_NS)
#define DFSDM1_Channel0_NS  ((DFSDM_Channel_TypeDef *) DFSDM1_Channel0_BASE_NS)
#define DFSDM1_Channel1_NS  ((DFSDM_Channel_TypeDef *) DFSDM1_Channel1_BASE_NS)
#define DFSDM1_Channel2_NS  ((DFSDM_Channel_TypeDef *) DFSDM1_Channel2_BASE_NS)
#define DFSDM1_Channel3_NS  ((DFSDM_Channel_TypeDef *) DFSDM1_Channel3_BASE_NS)
#define DFSDM1_Filter0_NS   ((DFSDM_Filter_TypeDef *) DFSDM1_Filter0_BASE_NS)
#define DFSDM1_Filter1_NS   ((DFSDM_Filter_TypeDef *) DFSDM1_Filter1_BASE_NS)
#define DFSDM1_Filter2_NS   ((DFSDM_Filter_TypeDef *) DFSDM1_Filter2_BASE_NS)
#define DFSDM1_Filter3_NS   ((DFSDM_Filter_TypeDef *) DFSDM1_Filter3_BASE_NS)

/*!< AHB1 Non secure peripherals */
#define DMA1_NS             ((DMA_TypeDef *) DMA1_BASE_NS)
#define DMA2_NS             ((DMA_TypeDef *) DMA2_BASE_NS)
#define DMAMUX1_NS          ((DMAMUX_Channel_TypeDef *) DMAMUX1_BASE_NS)
#define RCC_NS              ((RCC_TypeDef *) RCC_BASE_NS)
#define FLASH_NS            ((FLASH_TypeDef *) FLASH_R_BASE_NS)
#define CRC_NS              ((CRC_TypeDef *) CRC_BASE_NS)
#define TSC_NS              ((TSC_TypeDef *) TSC_BASE_NS)
#define EXTI_NS             ((EXTI_TypeDef *) EXTI_BASE_NS)
#define ICACHE_NS           ((ICACHE_TypeDef *) ICACHE_BASE_NS)
#define GTZC_TZSC_NS        ((GTZC_TZSC_TypeDef *) GTZC_TZSC_BASE_NS)
#define GTZC_TZIC_NS        ((GTZC_TZIC_TypeDef *) GTZC_TZIC_BASE_NS)
#define GTZC_MPCBB2_NS      ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_NS)
#define GTZC_MPCBB1_NS      ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_NS)

#define DMA1_Channel1_NS    ((DMA_Channel_TypeDef *) DMA1_Channel1_BASE_NS)
#define DMA1_Channel2_NS    ((DMA_Channel_TypeDef *) DMA1_Channel2_BASE_NS)
#define DMA1_Channel3_NS    ((DMA_Channel_TypeDef *) DMA1_Channel3_BASE_NS)
#define DMA1_Channel4_NS    ((DMA_Channel_TypeDef *) DMA1_Channel4_BASE_NS)
#define DMA1_Channel5_NS    ((DMA_Channel_TypeDef *) DMA1_Channel5_BASE_NS)
#define DMA1_Channel6_NS    ((DMA_Channel_TypeDef *) DMA1_Channel6_BASE_NS)
#define DMA1_Channel7_NS    ((DMA_Channel_TypeDef *) DMA1_Channel7_BASE_NS)
#define DMA1_Channel8_NS    ((DMA_Channel_TypeDef *) DMA1_Channel8_BASE_NS)

#define DMA2_Channel1_NS    ((DMA_Channel_TypeDef *) DMA2_Channel1_BASE_NS)
#define DMA2_Channel2_NS    ((DMA_Channel_TypeDef *) DMA2_Channel2_BASE_NS)
#define DMA2_Channel3_NS    ((DMA_Channel_TypeDef *) DMA2_Channel3_BASE_NS)
#define DMA2_Channel4_NS    ((DMA_Channel_TypeDef *) DMA2_Channel4_BASE_NS)
#define DMA2_Channel5_NS    ((DMA_Channel_TypeDef *) DMA2_Channel5_BASE_NS)
#define DMA2_Channel6_NS    ((DMA_Channel_TypeDef *) DMA2_Channel6_BASE_NS)
#define DMA2_Channel7_NS    ((DMA_Channel_TypeDef *) DMA2_Channel7_BASE_NS)
#define DMA2_Channel8_NS    ((DMA_Channel_TypeDef *) DMA2_Channel8_BASE_NS)

#define DMAMUX1_Channel0_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel0_BASE_NS)
#define DMAMUX1_Channel1_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel1_BASE_NS)
#define DMAMUX1_Channel2_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel2_BASE_NS)
#define DMAMUX1_Channel3_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel3_BASE_NS)
#define DMAMUX1_Channel4_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel4_BASE_NS)
#define DMAMUX1_Channel5_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel5_BASE_NS)
#define DMAMUX1_Channel6_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel6_BASE_NS)
#define DMAMUX1_Channel7_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel7_BASE_NS)
#define DMAMUX1_Channel8_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel8_BASE_NS)
#define DMAMUX1_Channel9_NS  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel9_BASE_NS)
#define DMAMUX1_Channel10_NS ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel10_BASE_NS)
#define DMAMUX1_Channel11_NS ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel11_BASE_NS)
#define DMAMUX1_Channel12_NS ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel12_BASE_NS)
#define DMAMUX1_Channel13_NS ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel13_BASE_NS)
#define DMAMUX1_Channel14_NS ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel14_BASE_NS)
#define DMAMUX1_Channel15_NS ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel15_BASE_NS)

#define DMAMUX1_RequestGenerator0_NS ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator0_BASE_NS)
#define DMAMUX1_RequestGenerator1_NS ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator1_BASE_NS)
#define DMAMUX1_RequestGenerator2_NS ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator2_BASE_NS)
#define DMAMUX1_RequestGenerator3_NS ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator3_BASE_NS)

#define DMAMUX1_ChannelStatus_NS     ((DMAMUX_ChannelStatus_TypeDef *) DMAMUX1_ChannelStatus_BASE_NS)
#define DMAMUX1_RequestGenStatus_NS  ((DMAMUX_RequestGenStatus_TypeDef *) DMAMUX1_RequestGenStatus_BASE_NS)

/*!< AHB2 Non secure peripherals */
#define GPIOA_NS            ((GPIO_TypeDef *) GPIOA_BASE_NS)
#define GPIOB_NS            ((GPIO_TypeDef *) GPIOB_BASE_NS)
#define GPIOC_NS            ((GPIO_TypeDef *) GPIOC_BASE_NS)
#define GPIOD_NS            ((GPIO_TypeDef *) GPIOD_BASE_NS)
#define GPIOE_NS            ((GPIO_TypeDef *) GPIOE_BASE_NS)
#define GPIOF_NS            ((GPIO_TypeDef *) GPIOF_BASE_NS)
#define GPIOG_NS            ((GPIO_TypeDef *) GPIOG_BASE_NS)
#define GPIOH_NS            ((GPIO_TypeDef *) GPIOH_BASE_NS)
#define ADC1_NS             ((ADC_TypeDef *) ADC1_BASE_NS)
#define ADC2_NS             ((ADC_TypeDef *) ADC2_BASE_NS)
#define ADC12_COMMON_NS     ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_NS)
#define HASH_NS             ((HASH_TypeDef *) HASH_BASE_NS)
#define HASH_DIGEST_NS      ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_NS)
#define RNG_NS              ((RNG_TypeDef *) RNG_BASE_NS)
#define SDMMC1_NS           ((SDMMC_TypeDef *) SDMMC1_BASE_NS)

/*!< AHB3 Non secure peripherals */
#define FMC_Bank1_R_NS      ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_NS)
#define FMC_Bank1E_R_NS     ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_NS)
#define FMC_Bank3_R_NS      ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_NS)

#define OCTOSPI1_NS         ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_NS)

/*!< APB1 Secure peripherals */
#define TIM2_S              ((TIM_TypeDef *) TIM2_BASE_S)
#define TIM3_S              ((TIM_TypeDef *) TIM3_BASE_S)
#define TIM4_S              ((TIM_TypeDef *) TIM4_BASE_S)
#define TIM5_S              ((TIM_TypeDef *) TIM5_BASE_S)
#define TIM6_S              ((TIM_TypeDef *) TIM6_BASE_S)
#define TIM7_S              ((TIM_TypeDef *) TIM7_BASE_S)
#define RTC_S               ((RTC_TypeDef *) RTC_BASE_S)
#define WWDG_S              ((WWDG_TypeDef *) WWDG_BASE_S)
#define IWDG_S              ((IWDG_TypeDef *) IWDG_BASE_S)
#define TAMP_S              ((TAMP_TypeDef *) TAMP_BASE_S)
#define SPI2_S              ((SPI_TypeDef *) SPI2_BASE_S)
#define SPI3_S              ((SPI_TypeDef *) SPI3_BASE_S)
#define USART2_S            ((USART_TypeDef *) USART2_BASE_S)
#define USART3_S            ((USART_TypeDef *) USART3_BASE_S)
#define UART4_S             ((USART_TypeDef *) UART4_BASE_S)
#define UART5_S             ((USART_TypeDef *) UART5_BASE_S)
#define I2C1_S              ((I2C_TypeDef *) I2C1_BASE_S)
#define I2C2_S              ((I2C_TypeDef *) I2C2_BASE_S)
#define I2C3_S              ((I2C_TypeDef *) I2C3_BASE_S)
#define CRS_S               ((CRS_TypeDef *) CRS_BASE_S)
#define FDCAN1_S            ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_S)
#define FDCAN_CONFIG_S      ((FDCAN_Config_TypeDef *) FDCAN_CONFIG_BASE_S)
#define I2C4_S              ((I2C_TypeDef *) I2C4_BASE_S)
#define PWR_S               ((PWR_TypeDef *) PWR_BASE_S)
#define DAC_S               ((DAC_TypeDef *) DAC1_BASE_S)
#define DAC1_S              ((DAC_TypeDef *) DAC1_BASE_S)
#define OPAMP_S             ((OPAMP_TypeDef *) OPAMP_BASE_S)
#define OPAMP1_S            ((OPAMP_TypeDef *) OPAMP1_BASE_S)
#define OPAMP2_S            ((OPAMP_TypeDef *) OPAMP2_BASE_S)
#define OPAMP12_COMMON_S    ((OPAMP_Common_TypeDef *) OPAMP1_BASE_S)
#define LPTIM1_S            ((LPTIM_TypeDef *) LPTIM1_BASE_S)
#define LPUART1_S           ((USART_TypeDef *) LPUART1_BASE_S)
#define LPTIM2_S            ((LPTIM_TypeDef *) LPTIM2_BASE_S)
#define LPTIM3_S            ((LPTIM_TypeDef *) LPTIM3_BASE_S)
#define USB_S               ((USB_TypeDef *) USB_BASE_S)
#define UCPD1_S             ((UCPD_TypeDef *) UCPD1_BASE_S)

/*!< APB2 Secure peripherals */
#define SYSCFG_S            ((SYSCFG_TypeDef *) SYSCFG_BASE_S)
#define VREFBUF_S           ((VREFBUF_TypeDef *) VREFBUF_BASE_S)
#define COMP1_S             ((COMP_TypeDef *) COMP1_BASE_S)
#define COMP2_S             ((COMP_TypeDef *) COMP2_BASE_S)
#define COMP12_COMMON_S     ((COMP_Common_TypeDef *) COMP2_BASE_S)
#define TIM1_S              ((TIM_TypeDef *) TIM1_BASE_S)
#define SPI1_S              ((SPI_TypeDef *) SPI1_BASE_S)
#define TIM8_S              ((TIM_TypeDef *) TIM8_BASE_S)
#define USART1_S            ((USART_TypeDef *) USART1_BASE_S)
#define TIM15_S             ((TIM_TypeDef *) TIM15_BASE_S)
#define TIM16_S             ((TIM_TypeDef *) TIM16_BASE_S)
#define TIM17_S             ((TIM_TypeDef *) TIM17_BASE_S)
#define SAI1_S              ((SAI_TypeDef *) SAI1_BASE_S)
#define SAI1_Block_A_S      ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_S)
#define SAI1_Block_B_S      ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_S)
#define SAI2_S              ((SAI_TypeDef *) SAI2_BASE_S)
#define SAI2_Block_A_S      ((SAI_Block_TypeDef *)SAI2_Block_A_BASE_S)
#define SAI2_Block_B_S      ((SAI_Block_TypeDef *)SAI2_Block_B_BASE_S)
#define DFSDM1_Channel0_S   ((DFSDM_Channel_TypeDef *) DFSDM1_Channel0_BASE_S)
#define DFSDM1_Channel1_S   ((DFSDM_Channel_TypeDef *) DFSDM1_Channel1_BASE_S)
#define DFSDM1_Channel2_S   ((DFSDM_Channel_TypeDef *) DFSDM1_Channel2_BASE_S)
#define DFSDM1_Channel3_S   ((DFSDM_Channel_TypeDef *) DFSDM1_Channel3_BASE_S)
#define DFSDM1_Filter0_S    ((DFSDM_Filter_TypeDef *) DFSDM1_Filter0_BASE_S)
#define DFSDM1_Filter1_S    ((DFSDM_Filter_TypeDef *) DFSDM1_Filter1_BASE_S)
#define DFSDM1_Filter2_S    ((DFSDM_Filter_TypeDef *) DFSDM1_Filter2_BASE_S)
#define DFSDM1_Filter3_S    ((DFSDM_Filter_TypeDef *) DFSDM1_Filter3_BASE_S)

/*!< AHB1 Secure peripherals */
#define DMA1_S              ((DMA_TypeDef *) DMA1_BASE_S)
#define DMA2_S              ((DMA_TypeDef *) DMA2_BASE_S)
#define DMAMUX1_S           ((DMAMUX_Channel_TypeDef *) DMAMUX1_BASE_S)
#define RCC_S               ((RCC_TypeDef *) RCC_BASE_S)
#define FLASH_S             ((FLASH_TypeDef *) FLASH_R_BASE_S)
#define CRC_S               ((CRC_TypeDef *) CRC_BASE_S)
#define TSC_S               ((TSC_TypeDef *) TSC_BASE_S)
#define EXTI_S              ((EXTI_TypeDef *) EXTI_BASE_S)
#define ICACHE_S            ((ICACHE_TypeDef *) ICACHE_BASE_S)
#define GTZC_TZSC_S         ((GTZC_TZSC_TypeDef *) GTZC_TZSC_BASE_S)
#define GTZC_TZIC_S         ((GTZC_TZIC_TypeDef *) GTZC_TZIC_BASE_S)
#define GTZC_MPCBB2_S       ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_S)
#define GTZC_MPCBB1_S       ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_S)

#define DMA1_Channel1_S     ((DMA_Channel_TypeDef *) DMA1_Channel1_BASE_S)
#define DMA1_Channel2_S     ((DMA_Channel_TypeDef *) DMA1_Channel2_BASE_S)
#define DMA1_Channel3_S     ((DMA_Channel_TypeDef *) DMA1_Channel3_BASE_S)
#define DMA1_Channel4_S     ((DMA_Channel_TypeDef *) DMA1_Channel4_BASE_S)
#define DMA1_Channel5_S     ((DMA_Channel_TypeDef *) DMA1_Channel5_BASE_S)
#define DMA1_Channel6_S     ((DMA_Channel_TypeDef *) DMA1_Channel6_BASE_S)
#define DMA1_Channel7_S     ((DMA_Channel_TypeDef *) DMA1_Channel7_BASE_S)
#define DMA1_Channel8_S     ((DMA_Channel_TypeDef *) DMA1_Channel8_BASE_S)

#define DMA2_Channel1_S     ((DMA_Channel_TypeDef *) DMA2_Channel1_BASE_S)
#define DMA2_Channel2_S     ((DMA_Channel_TypeDef *) DMA2_Channel2_BASE_S)
#define DMA2_Channel3_S     ((DMA_Channel_TypeDef *) DMA2_Channel3_BASE_S)
#define DMA2_Channel4_S     ((DMA_Channel_TypeDef *) DMA2_Channel4_BASE_S)
#define DMA2_Channel5_S     ((DMA_Channel_TypeDef *) DMA2_Channel5_BASE_S)
#define DMA2_Channel6_S     ((DMA_Channel_TypeDef *) DMA2_Channel6_BASE_S)
#define DMA2_Channel7_S     ((DMA_Channel_TypeDef *) DMA2_Channel7_BASE_S)
#define DMA2_Channel8_S     ((DMA_Channel_TypeDef *) DMA2_Channel8_BASE_S)

#define DMAMUX1_Channel0_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel0_BASE_S)
#define DMAMUX1_Channel1_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel1_BASE_S)
#define DMAMUX1_Channel2_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel2_BASE_S)
#define DMAMUX1_Channel3_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel3_BASE_S)
#define DMAMUX1_Channel4_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel4_BASE_S)
#define DMAMUX1_Channel5_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel5_BASE_S)
#define DMAMUX1_Channel6_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel6_BASE_S)
#define DMAMUX1_Channel7_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel7_BASE_S)
#define DMAMUX1_Channel8_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel8_BASE_S)
#define DMAMUX1_Channel9_S  ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel9_BASE_S)
#define DMAMUX1_Channel10_S ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel10_BASE_S)
#define DMAMUX1_Channel11_S ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel11_BASE_S)
#define DMAMUX1_Channel12_S ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel12_BASE_S)
#define DMAMUX1_Channel13_S ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel13_BASE_S)
#define DMAMUX1_Channel14_S ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel14_BASE_S)
#define DMAMUX1_Channel15_S ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel15_BASE_S)

#define DMAMUX1_RequestGenerator0_S  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator0_BASE_S)
#define DMAMUX1_RequestGenerator1_S  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator1_BASE_S)
#define DMAMUX1_RequestGenerator2_S  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator2_BASE_S)
#define DMAMUX1_RequestGenerator3_S  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator3_BASE_S)

#define DMAMUX1_ChannelStatus_S      ((DMAMUX_ChannelStatus_TypeDef *) DMAMUX1_ChannelStatus_BASE_S)
#define DMAMUX1_RequestGenStatus_S   ((DMAMUX_RequestGenStatus_TypeDef *) DMAMUX1_RequestGenStatus_BASE_S)

/*!< AHB2 Secure peripherals */
#define GPIOA_S             ((GPIO_TypeDef *) GPIOA_BASE_S)
#define GPIOB_S             ((GPIO_TypeDef *) GPIOB_BASE_S)
#define GPIOC_S             ((GPIO_TypeDef *) GPIOC_BASE_S)
#define GPIOD_S             ((GPIO_TypeDef *) GPIOD_BASE_S)
#define GPIOE_S             ((GPIO_TypeDef *) GPIOE_BASE_S)
#define GPIOF_S             ((GPIO_TypeDef *) GPIOF_BASE_S)
#define GPIOG_S             ((GPIO_TypeDef *) GPIOG_BASE_S)
#define GPIOH_S             ((GPIO_TypeDef *) GPIOH_BASE_S)
#define ADC1_S              ((ADC_TypeDef *) ADC1_BASE_S)
#define ADC2_S              ((ADC_TypeDef *) ADC2_BASE_S)
#define ADC12_COMMON_S      ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_S)
#define HASH_S              ((HASH_TypeDef *) HASH_BASE_S)
#define HASH_DIGEST_S       ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_S)
#define RNG_S               ((RNG_TypeDef *) RNG_BASE_S)
#define SDMMC1_S            ((SDMMC_TypeDef *) SDMMC1_BASE_S)

/*!< AHB3 Secure peripherals */
#define FMC_Bank1_R_S       ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_S)
#define FMC_Bank1E_R_S      ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_S)
#define FMC_Bank3_R_S       ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_S)

#define OCTOSPI1_S          ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_S)


#define DBGMCU              ((DBGMCU_TypeDef *) DBGMCU_BASE)

/*!< Memory & Instance aliases and base addresses for Non-Secure/Secure peripherals */

#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)

/*!< Memory base addresses for Secure peripherals */
#define FLASH_BASE                     FLASH_BASE_S
#define SRAM1_BASE                     SRAM1_BASE_S
#define SRAM2_BASE                     SRAM2_BASE_S
#define SRAM_BASE                      SRAM1_BASE_S
#define PERIPH_BASE                    PERIPH_BASE_S
#define APB1PERIPH_BASE                APB1PERIPH_BASE_S
#define APB2PERIPH_BASE                APB2PERIPH_BASE_S
#define AHB1PERIPH_BASE                AHB1PERIPH_BASE_S
#define AHB2PERIPH_BASE                AHB2PERIPH_BASE_S
#define AHB3PERIPH_BASE                AHB3PERIPH_BASE_S

/*!< Instance aliases and base addresses for Secure peripherals */
#define RCC                            RCC_S
#define RCC_BASE                       RCC_BASE_S

#define FLASH                          FLASH_S
#define FLASH_R_BASE                   FLASH_R_BASE_S

#define DMA1                           DMA1_S
#define DMA1_BASE                      DMA1_BASE_S

#define DMA1_Channel1                  DMA1_Channel1_S
#define DMA1_Channel1_BASE             DMA1_Channel1_BASE_S

#define DMA1_Channel2                  DMA1_Channel2_S
#define DMA1_Channel2_BASE             DMA1_Channel2_BASE_S

#define DMA1_Channel3                  DMA1_Channel3_S
#define DMA1_Channel3_BASE             DMA1_Channel3_BASE_S

#define DMA1_Channel4                  DMA1_Channel4_S
#define DMA1_Channel4_BASE             DMA1_Channel4_BASE_S

#define DMA1_Channel5                  DMA1_Channel5_S
#define DMA1_Channel5_BASE             DMA1_Channel5_BASE_S

#define DMA1_Channel6                  DMA1_Channel6_S
#define DMA1_Channel6_BASE             DMA1_Channel6_BASE_S

#define DMA1_Channel7                  DMA1_Channel7_S
#define DMA1_Channel7_BASE             DMA1_Channel7_BASE_S

#define DMA1_Channel8                  DMA1_Channel8_S
#define DMA1_Channel8_BASE             DMA1_Channel8_BASE_S

#define DMA2                           DMA2_S
#define DMA2_BASE                      DMA2_BASE_S

#define DMA2_Channel1                  DMA2_Channel1_S
#define DMA2_Channel1_BASE             DMA2_Channel1_BASE_S

#define DMA2_Channel2                  DMA2_Channel2_S
#define DMA2_Channel2_BASE             DMA2_Channel2_BASE_S

#define DMA2_Channel3                  DMA2_Channel3_S
#define DMA2_Channel3_BASE             DMA2_Channel3_BASE_S

#define DMA2_Channel4                  DMA2_Channel4_S
#define DMA2_Channel4_BASE             DMA2_Channel4_BASE_S

#define DMA2_Channel5                  DMA2_Channel5_S
#define DMA2_Channel5_BASE             DMA2_Channel5_BASE_S

#define DMA2_Channel6                  DMA2_Channel6_S
#define DMA2_Channel6_BASE             DMA2_Channel6_BASE_S

#define DMA2_Channel7                  DMA2_Channel7_S
#define DMA2_Channel7_BASE             DMA2_Channel7_BASE_S

#define DMA2_Channel8                  DMA2_Channel8_S
#define DMA2_Channel8_BASE             DMA2_Channel8_BASE_S

#define DMAMUX1                        DMAMUX1_S
#define DMAMUX1_BASE                   DMAMUX1_BASE_S

#define DMAMUX1_Channel0               DMAMUX1_Channel0_S
#define DMAMUX1_Channel0_BASE          DMAMUX1_Channel0_BASE_S

#define DMAMUX1_Channel1               DMAMUX1_Channel1_S
#define DMAMUX1_Channel1_BASE          DMAMUX1_Channel1_BASE_S

#define DMAMUX1_Channel2               DMAMUX1_Channel2_S
#define DMAMUX1_Channel2_BASE          DMAMUX1_Channel2_BASE_S

#define DMAMUX1_Channel3               DMAMUX1_Channel3_S
#define DMAMUX1_Channel3_BASE          DMAMUX1_Channel3_BASE_S

#define DMAMUX1_Channel4               DMAMUX1_Channel4_S
#define DMAMUX1_Channel4_BASE          DMAMUX1_Channel4_BASE_S

#define DMAMUX1_Channel5               DMAMUX1_Channel5_S
#define DMAMUX1_Channel5_BASE          DMAMUX1_Channel5_BASE_S

#define DMAMUX1_Channel6               DMAMUX1_Channel6_S
#define DMAMUX1_Channel6_BASE          DMAMUX1_Channel6_BASE_S

#define DMAMUX1_Channel7               DMAMUX1_Channel7_S
#define DMAMUX1_Channel7_BASE          DMAMUX1_Channel7_BASE_S

#define DMAMUX1_Channel8               DMAMUX1_Channel8_S
#define DMAMUX1_Channel8_BASE          DMAMUX1_Channel8_BASE_S

#define DMAMUX1_Channel9               DMAMUX1_Channel9_S
#define DMAMUX1_Channel9_BASE          DMAMUX1_Channel9_BASE_S

#define DMAMUX1_Channel10              DMAMUX1_Channel10_S
#define DMAMUX1_Channel10_BASE         DMAMUX1_Channel10_BASE_S

#define DMAMUX1_Channel11              DMAMUX1_Channel11_S
#define DMAMUX1_Channel11_BASE         DMAMUX1_Channel11_BASE_S

#define DMAMUX1_Channel12              DMAMUX1_Channel12_S
#define DMAMUX1_Channel12_BASE         DMAMUX1_Channel12_BASE_S

#define DMAMUX1_Channel13              DMAMUX1_Channel13_S
#define DMAMUX1_Channel13_BASE         DMAMUX1_Channel13_BASE_S

#define DMAMUX1_Channel14              DMAMUX1_Channel14_S
#define DMAMUX1_Channel14_BASE         DMAMUX1_Channel14_BASE_S

#define DMAMUX1_Channel15              DMAMUX1_Channel15_S
#define DMAMUX1_Channel15_BASE         DMAMUX1_Channel15_BASE_S

#define DMAMUX1_RequestGenerator0      DMAMUX1_RequestGenerator0_S
#define DMAMUX1_RequestGenerator0_BASE DMAMUX1_RequestGenerator0_BASE_S

#define DMAMUX1_RequestGenerator1      DMAMUX1_RequestGenerator1_S
#define DMAMUX1_RequestGenerator1_BASE DMAMUX1_RequestGenerator1_BASE_S

#define DMAMUX1_RequestGenerator2      DMAMUX1_RequestGenerator2_S
#define DMAMUX1_RequestGenerator2_BASE DMAMUX1_RequestGenerator2_BASE_S

#define DMAMUX1_RequestGenerator3      DMAMUX1_RequestGenerator3_S
#define DMAMUX1_RequestGenerator3_BASE DMAMUX1_RequestGenerator3_BASE_S

#define DMAMUX1_ChannelStatus          DMAMUX1_ChannelStatus_S
#define DMAMUX1_ChannelStatus_BASE     DMAMUX1_ChannelStatus_BASE_S

#define DMAMUX1_RequestGenStatus       DMAMUX1_RequestGenStatus_S
#define DMAMUX1_RequestGenStatus_BASE  DMAMUX1_RequestGenStatus_BASE_S

#define GPIOA                          GPIOA_S
#define GPIOA_BASE                     GPIOA_BASE_S

#define GPIOB                          GPIOB_S
#define GPIOB_BASE                     GPIOB_BASE_S

#define GPIOC                          GPIOC_S
#define GPIOC_BASE                     GPIOC_BASE_S

#define GPIOD                          GPIOD_S
#define GPIOD_BASE                     GPIOD_BASE_S

#define GPIOE                          GPIOE_S
#define GPIOE_BASE                     GPIOE_BASE_S

#define GPIOF                          GPIOF_S
#define GPIOF_BASE                     GPIOF_BASE_S

#define GPIOG                          GPIOG_S
#define GPIOG_BASE                     GPIOG_BASE_S

#define GPIOH                          GPIOH_S
#define GPIOH_BASE                     GPIOH_BASE_S

#define PWR                            PWR_S
#define PWR_BASE                       PWR_BASE_S

#define EXTI                           EXTI_S
#define EXTI_BASE                      EXTI_BASE_S

#define ICACHE                         ICACHE_S
#define ICACHE_BASE                    ICACHE_BASE_S

#define GTZC_TZSC                      GTZC_TZSC_S
#define GTZC_TZSC_BASE                 GTZC_TZSC_BASE_S

#define GTZC_TZIC                      GTZC_TZIC_S
#define GTZC_TZIC_BASE                 GTZC_TZIC_BASE_S

#define GTZC_MPCBB2                    GTZC_MPCBB2_S
#define GTZC_MPCBB2_BASE               GTZC_MPCBB2_BASE_S

#define GTZC_MPCBB1                    GTZC_MPCBB1_S
#define GTZC_MPCBB1_BASE               GTZC_MPCBB1_BASE_S

#define RTC                            RTC_S
#define RTC_BASE                       RTC_BASE_S

#define TAMP                           TAMP_S
#define TAMP_BASE                      TAMP_BASE_S

#define TIM1                           TIM1_S
#define TIM1_BASE                      TIM1_BASE_S

#define TIM2                           TIM2_S
#define TIM2_BASE                      TIM2_BASE_S

#define TIM3                           TIM3_S
#define TIM3_BASE                      TIM3_BASE_S

#define TIM4                           TIM4_S
#define TIM4_BASE                      TIM4_BASE_S

#define TIM5                           TIM5_S
#define TIM5_BASE                      TIM5_BASE_S

#define TIM6                           TIM6_S
#define TIM6_BASE                      TIM6_BASE_S

#define TIM7                           TIM7_S
#define TIM7_BASE                      TIM7_BASE_S

#define TIM8                           TIM8_S
#define TIM8_BASE                      TIM8_BASE_S

#define TIM15                          TIM15_S
#define TIM15_BASE                     TIM15_BASE_S

#define TIM16                          TIM16_S
#define TIM16_BASE                     TIM16_BASE_S

#define TIM17                          TIM17_S
#define TIM17_BASE                     TIM17_BASE_S

#define WWDG                           WWDG_S
#define WWDG_BASE                      WWDG_BASE_S

#define IWDG                           IWDG_S
#define IWDG_BASE                      IWDG_BASE_S

#define SPI1                           SPI1_S
#define SPI1_BASE                      SPI1_BASE_S

#define SPI2                           SPI2_S
#define SPI2_BASE                      SPI2_BASE_S

#define SPI3                           SPI3_S
#define SPI3_BASE                      SPI3_BASE_S

#define USART1                         USART1_S
#define USART1_BASE                    USART1_BASE_S

#define USART2                         USART2_S
#define USART2_BASE                    USART2_BASE_S

#define USART3                         USART3_S
#define USART3_BASE                    USART3_BASE_S

#define UART4                          UART4_S
#define UART4_BASE                     UART4_BASE_S

#define UART5                          UART5_S
#define UART5_BASE                     UART5_BASE_S

#define I2C1                           I2C1_S
#define I2C1_BASE                      I2C1_BASE_S

#define I2C2                           I2C2_S
#define I2C2_BASE                      I2C2_BASE_S

#define I2C3                           I2C3_S
#define I2C3_BASE                      I2C3_BASE_S

#define I2C4                           I2C4_S
#define I2C4_BASE                      I2C4_BASE_S

#define CRS                            CRS_S
#define CRS_BASE                       CRS_BASE_S

#define FDCAN1                         FDCAN1_S
#define FDCAN1_BASE                    FDCAN1_BASE_S

#define FDCAN_CONFIG                   FDCAN_CONFIG_S
#define FDCAN_CONFIG_BASE              FDCAN_CONFIG_BASE_S
#define SRAMCAN_BASE                   SRAMCAN_BASE_S

#define DAC                            DAC_S
#define DAC_BASE                       DAC_BASE_S

#define DAC1                           DAC1_S
#define DAC1_BASE                      DAC1_BASE_S

#define OPAMP                          OPAMP_S
#define OPAMP_BASE                     OPAMP_BASE_S

#define OPAMP1                         OPAMP1_S
#define OPAMP1_BASE                    OPAMP1_BASE_S

#define OPAMP2                         OPAMP2_S
#define OPAMP2_BASE                    OPAMP2_BASE_S

#define OPAMP12_COMMON                 OPAMP12_COMMON_S
#define OPAMP12_COMMON_BASE            OPAMP12_COMMON_BASE_S

#define LPTIM1                         LPTIM1_S
#define LPTIM1_BASE                    LPTIM1_BASE_S

#define LPTIM2                         LPTIM2_S
#define LPTIM2_BASE                    LPTIM2_BASE_S

#define LPTIM3                         LPTIM3_S
#define LPTIM3_BASE                    LPTIM3_BASE_S

#define LPUART1                        LPUART1_S
#define LPUART1_BASE                   LPUART1_BASE_S

#define USB                            USB_S
#define USB_BASE                       USB_BASE_S

#define UCPD1                          UCPD1_S
#define UCPD1_BASE                     UCPD1_BASE_S

#define SYSCFG                         SYSCFG_S
#define SYSCFG_BASE                    SYSCFG_BASE_S

#define VREFBUF                        VREFBUF_S
#define VREFBUF_BASE                   VREFBUF_BASE_S

#define COMP1                          COMP1_S
#define COMP1_BASE                     COMP1_BASE_S

#define COMP2                          COMP2_S
#define COMP2_BASE                     COMP2_BASE_S

#define COMP12_COMMON                  COMP12_COMMON_S
#define COMP12_COMMON_BASE             COMP12_COMMON_BASE_S

#define SAI1                           SAI1_S
#define SAI1_BASE                      SAI1_BASE_S

#define SAI1_Block_A                   SAI1_Block_A_S
#define SAI1_Block_A_BASE              SAI1_Block_A_BASE_S

#define SAI1_Block_B                   SAI1_Block_B_S
#define SAI1_Block_B_BASE              SAI1_Block_B_BASE_S

#define SAI2                           SAI2_S
#define SAI2_BASE                      SAI2_BASE_S

#define SAI2_Block_A                   SAI2_Block_A_S
#define SAI2_Block_A_BASE              SAI2_Block_A_BASE_S

#define SAI2_Block_B                   SAI2_Block_B_S
#define SAI2_Block_B_BASE              SAI2_Block_B_BASE_S

#define DFSDM1_Channel0                DFSDM1_Channel0_S
#define DFSDM1_Channel0_BASE           DFSDM1_Channel0_BASE_S

#define DFSDM1_Channel1                DFSDM1_Channel1_S
#define DFSDM1_Channel1_BASE           DFSDM1_Channel1_BASE_S

#define DFSDM1_Channel2                DFSDM1_Channel2_S
#define DFSDM1_Channel2_BASE           DFSDM1_Channel2_BASE_S

#define DFSDM1_Channel3                DFSDM1_Channel3_S
#define DFSDM1_Channel3_BASE           DFSDM1_Channel3_BASE_S

#define DFSDM1_Filter0                 DFSDM1_Filter0_S
#define DFSDM1_Filter0_BASE            DFSDM1_Filter0_BASE_S

#define DFSDM1_Filter1                 DFSDM1_Filter1_S
#define DFSDM1_Filter1_BASE            DFSDM1_Filter1_BASE_S

#define DFSDM1_Filter2                 DFSDM1_Filter2_S
#define DFSDM1_Filter2_BASE            DFSDM1_Filter2_BASE_S

#define DFSDM1_Filter3                 DFSDM1_Filter3_S
#define DFSDM1_Filter3_BASE            DFSDM1_Filter3_BASE_S

#define CRC                            CRC_S
#define CRC_BASE                       CRC_BASE_S

#define TSC                            TSC_S
#define TSC_BASE                       TSC_BASE_S

#define ADC1                           ADC1_S
#define ADC1_BASE                      ADC1_BASE_S

#define ADC2                           ADC2_S
#define ADC2_BASE                      ADC2_BASE_S

#define ADC12_COMMON                   ADC12_COMMON_S
#define ADC12_COMMON_BASE              ADC12_COMMON_BASE_S

#define HASH                           HASH_S
#define HASH_BASE                      HASH_BASE_S

#define HASH_DIGEST                    HASH_DIGEST_S
#define HASH_DIGEST_BASE               HASH_DIGEST_BASE_S

#define RNG                            RNG_S
#define RNG_BASE                       RNG_BASE_S

#define SDMMC1                         SDMMC1_S
#define SDMMC1_BASE                    SDMMC1_BASE_S

#define FMC_R_BASE                     FMC_R_BASE_S

#define FMC_Bank1_R                    FMC_Bank1_R_S
#define FMC_Bank1_R_BASE               FMC_Bank1_R_BASE_S

#define FMC_Bank1E_R                   FMC_Bank1E_R_S
#define FMC_Bank1E_R_BASE              FMC_Bank1E_R_BASE_S

#define FMC_Bank3_R                    FMC_Bank3_R_S
#define FMC_Bank3_R_BASE               FMC_Bank3_R_BASE_S

#define OCTOSPI1                       OCTOSPI1_S
#define OCTOSPI1_R_BASE                OCTOSPI1_R_BASE_S

#else

/*!< Memory base addresses for Non secure peripherals */
#define FLASH_BASE                     FLASH_BASE_NS
#define SRAM1_BASE                     SRAM1_BASE_NS
#define SRAM2_BASE                     SRAM2_BASE_NS
#define SRAM_BASE                      SRAM1_BASE_NS
#define PERIPH_BASE                    PERIPH_BASE_NS
#define APB1PERIPH_BASE                APB1PERIPH_BASE_NS
#define APB2PERIPH_BASE                APB2PERIPH_BASE_NS
#define AHB1PERIPH_BASE                AHB1PERIPH_BASE_NS
#define AHB2PERIPH_BASE                AHB2PERIPH_BASE_NS
#define AHB3PERIPH_BASE                AHB3PERIPH_BASE_NS

/*!< Instance aliases and base addresses for Non secure peripherals */
#define RCC                            RCC_NS
#define RCC_BASE                       RCC_BASE_NS

#define FLASH                          FLASH_NS
#define FLASH_R_BASE                   FLASH_R_BASE_NS

#define DMA1                           DMA1_NS
#define DMA1_BASE                      DMA1_BASE_NS

#define DMA1_Channel1                  DMA1_Channel1_NS
#define DMA1_Channel1_BASE             DMA1_Channel1_BASE_NS

#define DMA1_Channel2                  DMA1_Channel2_NS
#define DMA1_Channel2_BASE             DMA1_Channel2_BASE_NS

#define DMA1_Channel3                  DMA1_Channel3_NS
#define DMA1_Channel3_BASE             DMA1_Channel3_BASE_NS

#define DMA1_Channel4                  DMA1_Channel4_NS
#define DMA1_Channel4_BASE             DMA1_Channel4_BASE_NS

#define DMA1_Channel5                  DMA1_Channel5_NS
#define DMA1_Channel5_BASE             DMA1_Channel5_BASE_NS

#define DMA1_Channel6                  DMA1_Channel6_NS
#define DMA1_Channel6_BASE             DMA1_Channel6_BASE_NS

#define DMA1_Channel7                  DMA1_Channel7_NS
#define DMA1_Channel7_BASE             DMA1_Channel7_BASE_NS

#define DMA1_Channel8                  DMA1_Channel8_NS
#define DMA1_Channel8_BASE             DMA1_Channel8_BASE_NS

#define DMA2                           DMA2_NS
#define DMA2_BASE                      DMA2_BASE_NS

#define DMA2_Channel1                  DMA2_Channel1_NS
#define DMA2_Channel1_BASE             DMA2_Channel1_BASE_NS

#define DMA2_Channel2                  DMA2_Channel2_NS
#define DMA2_Channel2_BASE             DMA2_Channel2_BASE_NS

#define DMA2_Channel3                  DMA2_Channel3_NS
#define DMA2_Channel3_BASE             DMA2_Channel3_BASE_NS

#define DMA2_Channel4                  DMA2_Channel4_NS
#define DMA2_Channel4_BASE             DMA2_Channel4_BASE_NS

#define DMA2_Channel5                  DMA2_Channel5_NS
#define DMA2_Channel5_BASE             DMA2_Channel5_BASE_NS

#define DMA2_Channel6                  DMA2_Channel6_NS
#define DMA2_Channel6_BASE             DMA2_Channel6_BASE_NS

#define DMA2_Channel7                  DMA2_Channel7_NS
#define DMA2_Channel7_BASE             DMA2_Channel7_BASE_NS

#define DMA2_Channel8                  DMA2_Channel8_NS
#define DMA2_Channel8_BASE             DMA2_Channel8_BASE_NS

#define DMAMUX1                        DMAMUX1_NS
#define DMAMUX1_BASE                   DMAMUX1_BASE_NS

#define DMAMUX1_Channel0               DMAMUX1_Channel0_NS
#define DMAMUX1_Channel0_BASE          DMAMUX1_Channel0_BASE_NS

#define DMAMUX1_Channel1               DMAMUX1_Channel1_NS
#define DMAMUX1_Channel1_BASE          DMAMUX1_Channel1_BASE_NS

#define DMAMUX1_Channel2               DMAMUX1_Channel2_NS
#define DMAMUX1_Channel2_BASE          DMAMUX1_Channel2_BASE_NS

#define DMAMUX1_Channel3               DMAMUX1_Channel3_NS
#define DMAMUX1_Channel3_BASE          DMAMUX1_Channel3_BASE_NS

#define DMAMUX1_Channel4               DMAMUX1_Channel4_NS
#define DMAMUX1_Channel4_BASE          DMAMUX1_Channel4_BASE_NS

#define DMAMUX1_Channel5               DMAMUX1_Channel5_NS
#define DMAMUX1_Channel5_BASE          DMAMUX1_Channel5_BASE_NS

#define DMAMUX1_Channel6               DMAMUX1_Channel6_NS
#define DMAMUX1_Channel6_BASE          DMAMUX1_Channel6_BASE_NS

#define DMAMUX1_Channel7               DMAMUX1_Channel7_NS
#define DMAMUX1_Channel7_BASE          DMAMUX1_Channel7_BASE_NS

#define DMAMUX1_Channel8               DMAMUX1_Channel8_NS
#define DMAMUX1_Channel8_BASE          DMAMUX1_Channel8_BASE_NS

#define DMAMUX1_Channel9               DMAMUX1_Channel9_NS
#define DMAMUX1_Channel9_BASE          DMAMUX1_Channel9_BASE_NS

#define DMAMUX1_Channel10              DMAMUX1_Channel10_NS
#define DMAMUX1_Channel10_BASE         DMAMUX1_Channel10_BASE_NS

#define DMAMUX1_Channel11              DMAMUX1_Channel11_NS
#define DMAMUX1_Channel11_BASE         DMAMUX1_Channel11_BASE_NS

#define DMAMUX1_Channel12              DMAMUX1_Channel12_NS
#define DMAMUX1_Channel12_BASE         DMAMUX1_Channel12_BASE_NS

#define DMAMUX1_Channel13              DMAMUX1_Channel13_NS
#define DMAMUX1_Channel13_BASE         DMAMUX1_Channel13_BASE_NS

#define DMAMUX1_Channel14              DMAMUX1_Channel14_NS
#define DMAMUX1_Channel14_BASE         DMAMUX1_Channel14_BASE_NS

#define DMAMUX1_Channel15              DMAMUX1_Channel15_NS
#define DMAMUX1_Channel15_BASE         DMAMUX1_Channel15_BASE_NS

#define DMAMUX1_RequestGenerator0      DMAMUX1_RequestGenerator0_NS
#define DMAMUX1_RequestGenerator0_BASE DMAMUX1_RequestGenerator0_BASE_NS

#define DMAMUX1_RequestGenerator1      DMAMUX1_RequestGenerator1_NS
#define DMAMUX1_RequestGenerator1_BASE DMAMUX1_RequestGenerator1_BASE_NS

#define DMAMUX1_RequestGenerator2      DMAMUX1_RequestGenerator2_NS
#define DMAMUX1_RequestGenerator2_BASE DMAMUX1_RequestGenerator2_BASE_NS

#define DMAMUX1_RequestGenerator3      DMAMUX1_RequestGenerator3_NS
#define DMAMUX1_RequestGenerator3_BASE DMAMUX1_RequestGenerator3_BASE_NS

#define DMAMUX1_ChannelStatus          DMAMUX1_ChannelStatus_NS
#define DMAMUX1_ChannelStatus_BASE     DMAMUX1_ChannelStatus_BASE_NS

#define DMAMUX1_RequestGenStatus       DMAMUX1_RequestGenStatus_NS
#define DMAMUX1_RequestGenStatus_BASE  DMAMUX1_RequestGenStatus_BASE_NS

#define GPIOA                          GPIOA_NS
#define GPIOA_BASE                     GPIOA_BASE_NS

#define GPIOB                          GPIOB_NS
#define GPIOB_BASE                     GPIOB_BASE_NS

#define GPIOC                          GPIOC_NS
#define GPIOC_BASE                     GPIOC_BASE_NS

#define GPIOD                          GPIOD_NS
#define GPIOD_BASE                     GPIOD_BASE_NS

#define GPIOE                          GPIOE_NS
#define GPIOE_BASE                     GPIOE_BASE_NS

#define GPIOF                          GPIOF_NS
#define GPIOF_BASE                     GPIOF_BASE_NS

#define GPIOG                          GPIOG_NS
#define GPIOG_BASE                     GPIOG_BASE_NS

#define GPIOH                          GPIOH_NS
#define GPIOH_BASE                     GPIOH_BASE_NS

#define PWR                            PWR_NS
#define PWR_BASE                       PWR_BASE_NS

#define EXTI                           EXTI_NS
#define EXTI_BASE                      EXTI_BASE_NS

#define ICACHE                         ICACHE_NS
#define ICACHE_BASE                    ICACHE_BASE_NS

#define GTZC_TZSC                      GTZC_TZSC_NS
#define GTZC_TZSC_BASE                 GTZC_TZSC_BASE_NS

#define GTZC_TZIC                      GTZC_TZIC_NS
#define GTZC_TZIC_BASE                 GTZC_TZIC_BASE_NS

#define GTZC_MPCBB2                    GTZC_MPCBB2_NS
#define GTZC_MPCBB2_BASE               GTZC_MPCBB2_BASE_NS

#define GTZC_MPCBB1                    GTZC_MPCBB1_NS
#define GTZC_MPCBB1_BASE               GTZC_MPCBB1_BASE_NS

#define RTC                            RTC_NS
#define RTC_BASE                       RTC_BASE_NS

#define TAMP                           TAMP_NS
#define TAMP_BASE                      TAMP_BASE_NS

#define TIM1                           TIM1_NS
#define TIM1_BASE                      TIM1_BASE_NS

#define TIM2                           TIM2_NS
#define TIM2_BASE                      TIM2_BASE_NS

#define TIM3                           TIM3_NS
#define TIM3_BASE                      TIM3_BASE_NS

#define TIM4                           TIM4_NS
#define TIM4_BASE                      TIM4_BASE_NS

#define TIM5                           TIM5_NS
#define TIM5_BASE                      TIM5_BASE_NS

#define TIM6                           TIM6_NS
#define TIM6_BASE                      TIM6_BASE_NS

#define TIM7                           TIM7_NS
#define TIM7_BASE                      TIM7_BASE_NS

#define TIM8                           TIM8_NS
#define TIM8_BASE                      TIM8_BASE_NS

#define TIM15                          TIM15_NS
#define TIM15_BASE                     TIM15_BASE_NS

#define TIM16                          TIM16_NS
#define TIM16_BASE                     TIM16_BASE_NS

#define TIM17                          TIM17_NS
#define TIM17_BASE                     TIM17_BASE_NS

#define WWDG                           WWDG_NS
#define WWDG_BASE                      WWDG_BASE_NS

#define IWDG                           IWDG_NS
#define IWDG_BASE                      IWDG_BASE_NS

#define SPI1                           SPI1_NS
#define SPI1_BASE                      SPI1_BASE_NS

#define SPI2                           SPI2_NS
#define SPI2_BASE                      SPI2_BASE_NS

#define SPI3                           SPI3_NS
#define SPI3_BASE                      SPI3_BASE_NS

#define USART1                         USART1_NS
#define USART1_BASE                    USART1_BASE_NS

#define USART2                         USART2_NS
#define USART2_BASE                    USART2_BASE_NS

#define USART3                         USART3_NS
#define USART3_BASE                    USART3_BASE_NS

#define UART4                          UART4_NS
#define UART4_BASE                     UART4_BASE_NS

#define UART5                          UART5_NS
#define UART5_BASE                     UART5_BASE_NS

#define I2C1                           I2C1_NS
#define I2C1_BASE                      I2C1_BASE_NS

#define I2C2                           I2C2_NS
#define I2C2_BASE                      I2C2_BASE_NS

#define I2C3                           I2C3_NS
#define I2C3_BASE                      I2C3_BASE_NS

#define I2C4                           I2C4_NS
#define I2C4_BASE                      I2C4_BASE_NS

#define CRS                            CRS_NS
#define CRS_BASE                       CRS_BASE_NS

#define FDCAN1                         FDCAN1_NS
#define FDCAN1_BASE                    FDCAN1_BASE_NS

#define FDCAN_CONFIG                   FDCAN_CONFIG_NS
#define FDCAN_CONFIG_BASE              FDCAN_CONFIG_BASE_NS
#define SRAMCAN_BASE                   SRAMCAN_BASE_NS

#define DAC                            DAC_NS
#define DAC_BASE                       DAC_BASE_NS

#define DAC1                           DAC1_NS
#define DAC1_BASE                      DAC1_BASE_NS

#define OPAMP                          OPAMP_NS
#define OPAMP_BASE                     OPAMP_BASE_NS

#define OPAMP1                         OPAMP1_NS
#define OPAMP1_BASE                    OPAMP1_BASE_NS

#define OPAMP2                         OPAMP2_NS
#define OPAMP2_BASE                    OPAMP2_BASE_NS

#define OPAMP12_COMMON                 OPAMP12_COMMON_NS
#define OPAMP12_COMMON_BASE            OPAMP12_COMMON_BASE_NS

#define LPTIM1                         LPTIM1_NS
#define LPTIM1_BASE                    LPTIM1_BASE_NS

#define LPTIM2                         LPTIM2_NS
#define LPTIM2_BASE                    LPTIM2_BASE_NS

#define LPTIM3                         LPTIM3_NS
#define LPTIM3_BASE                    LPTIM3_BASE_NS

#define LPUART1                        LPUART1_NS
#define LPUART1_BASE                   LPUART1_BASE_NS

#define USB                            USB_NS
#define USB_BASE                       USB_BASE_NS

#define UCPD1                          UCPD1_NS
#define UCPD1_BASE                     UCPD1_BASE_NS

#define SYSCFG                         SYSCFG_NS
#define SYSCFG_BASE                    SYSCFG_BASE_NS

#define VREFBUF                        VREFBUF_NS
#define VREFBUF_BASE                   VREFBUF_BASE_NS

#define COMP1                          COMP1_NS
#define COMP1_BASE                     COMP1_BASE_NS

#define COMP2                          COMP2_NS
#define COMP2_BASE                     COMP2_BASE_NS

#define COMP12_COMMON                  COMP12_COMMON_NS
#define COMP12_COMMON_BASE             COMP12_COMMON_BASE_NS

#define SAI1                           SAI1_NS
#define SAI1_BASE                      SAI1_BASE_NS

#define SAI1_Block_A                   SAI1_Block_A_NS
#define SAI1_Block_A_BASE              SAI1_Block_A_BASE_NS

#define SAI1_Block_B                   SAI1_Block_B_NS
#define SAI1_Block_B_BASE              SAI1_Block_B_BASE_NS

#define SAI2                           SAI2_NS
#define SAI2_BASE                      SAI2_BASE_NS

#define SAI2_Block_A                   SAI2_Block_A_NS
#define SAI2_Block_A_BASE              SAI2_Block_A_BASE_NS

#define SAI2_Block_B                   SAI2_Block_B_NS
#define SAI2_Block_B_BASE              SAI2_Block_B_BASE_NS

#define DFSDM1_Channel0                DFSDM1_Channel0_NS
#define DFSDM1_Channel0_BASE           DFSDM1_Channel0_BASE_NS

#define DFSDM1_Channel1                DFSDM1_Channel1_NS
#define DFSDM1_Channel1_BASE           DFSDM1_Channel1_BASE_NS

#define DFSDM1_Channel2                DFSDM1_Channel2_NS
#define DFSDM1_Channel2_BASE           DFSDM1_Channel2_BASE_NS

#define DFSDM1_Channel3                DFSDM1_Channel3_NS
#define DFSDM1_Channel3_BASE           DFSDM1_Channel3_BASE_NS

#define DFSDM1_Filter0                 DFSDM1_Filter0_NS
#define DFSDM1_Filter0_BASE            DFSDM1_Filter0_BASE_NS

#define DFSDM1_Filter1                 DFSDM1_Filter1_NS
#define DFSDM1_Filter1_BASE            DFSDM1_Filter1_BASE_NS

#define DFSDM1_Filter2                 DFSDM1_Filter2_NS
#define DFSDM1_Filter2_BASE            DFSDM1_Filter2_BASE_NS

#define DFSDM1_Filter3                 DFSDM1_Filter3_NS
#define DFSDM1_Filter3_BASE            DFSDM1_Filter3_BASE_NS

#define CRC                            CRC_NS
#define CRC_BASE                       CRC_BASE_NS

#define TSC                            TSC_NS
#define TSC_BASE                       TSC_BASE_NS

#define ADC1                           ADC1_NS
#define ADC1_BASE                      ADC1_BASE_NS

#define ADC2                           ADC2_NS
#define ADC2_BASE                      ADC2_BASE_NS

#define ADC12_COMMON                   ADC12_COMMON_NS
#define ADC12_COMMON_BASE              ADC12_COMMON_BASE_NS

#define HASH                           HASH_NS
#define HASH_BASE                      HASH_BASE_NS

#define HASH_DIGEST                    HASH_DIGEST_NS
#define HASH_DIGEST_BASE               HASH_DIGEST_BASE_NS

#define RNG                            RNG_NS
#define RNG_BASE                       RNG_BASE_NS

#define SDMMC1                         SDMMC1_NS
#define SDMMC1_BASE                    SDMMC1_BASE_NS

#define FMC_R_BASE                     FMC_R_BASE_NS

#define FMC_Bank1_R                    FMC_Bank1_R_NS
#define FMC_Bank1_R_BASE               FMC_Bank1_R_BASE_NS

#define FMC_Bank1E_R                   FMC_Bank1E_R_NS
#define FMC_Bank1E_R_BASE              FMC_Bank1E_R_BASE_NS

#define FMC_Bank3_R                    FMC_Bank3_R_NS
#define FMC_Bank3_R_BASE               FMC_Bank3_R_BASE_NS

#define OCTOSPI1                       OCTOSPI1_NS
#define OCTOSPI1_R_BASE                OCTOSPI1_R_BASE_NS

#endif /* defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U) */


/******************************************************************************/
/*                                                                            */
/*                      Analog Comparators (COMP)                             */
/*                                                                            */
/******************************************************************************/
/**********************  Bit definition for COMP_CSR register  ****************/
#define COMP_CSR_EN_Pos            (0U)
#define COMP_CSR_EN_Msk            (0x1UL << COMP_CSR_EN_Pos)                  /*!< 0x00000001 */
#define COMP_CSR_EN                COMP_CSR_EN_Msk                             /*!< Comparator enable */

#define COMP_CSR_PWRMODE_Pos       (2U)
#define COMP_CSR_PWRMODE_Msk       (0x3UL << COMP_CSR_PWRMODE_Pos)             /*!< 0x0000000C */
#define COMP_CSR_PWRMODE           COMP_CSR_PWRMODE_Msk                        /*!< Comparator power mode */
#define COMP_CSR_PWRMODE_0         (0x1UL << COMP_CSR_PWRMODE_Pos)             /*!< 0x00000004 */
#define COMP_CSR_PWRMODE_1         (0x2UL << COMP_CSR_PWRMODE_Pos)             /*!< 0x00000008 */

#define COMP_CSR_INMSEL_Pos        (4U)
#define COMP_CSR_INMSEL_Msk        (0x7UL << COMP_CSR_INMSEL_Pos)              /*!< 0x00000070 */
#define COMP_CSR_INMSEL            COMP_CSR_INMSEL_Msk                         /*!< Comparator input minus selection */
#define COMP_CSR_INMSEL_0          (0x1UL << COMP_CSR_INMSEL_Pos)              /*!< 0x00000010 */
#define COMP_CSR_INMSEL_1          (0x2UL << COMP_CSR_INMSEL_Pos)              /*!< 0x00000020 */
#define COMP_CSR_INMSEL_2          (0x4UL << COMP_CSR_INMSEL_Pos)              /*!< 0x00000040 */

#define COMP_CSR_INPSEL_Pos        (7U)
#define COMP_CSR_INPSEL_Msk        (0x3UL << COMP_CSR_INPSEL_Pos)              /*!< 0x00000180 */
#define COMP_CSR_INPSEL            COMP_CSR_INPSEL_Msk                         /*!< Comparator input plus selection */
#define COMP_CSR_INPSEL_0          (0x1UL << COMP_CSR_INPSEL_Pos)              /*!< 0x00000080 */
#define COMP_CSR_INPSEL_1          (0x2UL << COMP_CSR_INPSEL_Pos)              /*!< 0x00000100 */

#define COMP_CSR_WINMODE_Pos       (9U)
#define COMP_CSR_WINMODE_Msk       (0x1UL << COMP_CSR_WINMODE_Pos)             /*!< 0x00000200 */
#define COMP_CSR_WINMODE           COMP_CSR_WINMODE_Msk                        /*!< Pair of comparators window mode. Bit intended to be used with COMP common instance (COMP_Common_TypeDef)  */

#define COMP_CSR_POLARITY_Pos      (15U)
#define COMP_CSR_POLARITY_Msk      (0x1UL << COMP_CSR_POLARITY_Pos)            /*!< 0x00008000 */
#define COMP_CSR_POLARITY          COMP_CSR_POLARITY_Msk                       /*!< Comparator output polarity */

#define COMP_CSR_HYST_Pos          (16U)
#define COMP_CSR_HYST_Msk          (0x3UL << COMP_CSR_HYST_Pos)                /*!< 0x00030000 */
#define COMP_CSR_HYST              COMP_CSR_HYST_Msk                           /*!< Comparator hysteresis */
#define COMP_CSR_HYST_0            (0x1UL << COMP_CSR_HYST_Pos)                /*!< 0x00010000 */
#define COMP_CSR_HYST_1            (0x2UL << COMP_CSR_HYST_Pos)                /*!< 0x00020000 */

#define COMP_CSR_BLANKING_Pos      (18U)
#define COMP_CSR_BLANKING_Msk      (0x7UL << COMP_CSR_BLANKING_Pos)            /*!< 0x001C0000 */
#define COMP_CSR_BLANKING          COMP_CSR_BLANKING_Msk                       /*!< Comparator blanking source */
#define COMP_CSR_BLANKING_0        (0x1UL << COMP_CSR_BLANKING_Pos)            /*!< 0x00040000 */
#define COMP_CSR_BLANKING_1        (0x2UL << COMP_CSR_BLANKING_Pos)            /*!< 0x00080000 */
#define COMP_CSR_BLANKING_2        (0x4UL << COMP_CSR_BLANKING_Pos)            /*!< 0x00100000 */

#define COMP_CSR_BRGEN_Pos         (22U)
#define COMP_CSR_BRGEN_Msk         (0x1UL << COMP_CSR_BRGEN_Pos)               /*!< 0x00400000 */
#define COMP_CSR_BRGEN             COMP_CSR_BRGEN_Msk                          /*!< Comparator voltage scaler enable */
#define COMP_CSR_SCALEN_Pos        (23U)
#define COMP_CSR_SCALEN_Msk        (0x1UL << COMP_CSR_SCALEN_Pos)              /*!< 0x00800000 */
#define COMP_CSR_SCALEN            COMP_CSR_SCALEN_Msk                         /*!< Comparator scaler bridge enable */

#define COMP_CSR_VALUE_Pos         (30U)
#define COMP_CSR_VALUE_Msk         (0x1UL << COMP_CSR_VALUE_Pos)               /*!< 0x40000000 */
#define COMP_CSR_VALUE             COMP_CSR_VALUE_Msk                          /*!< Comparator output level */

#define COMP_CSR_LOCK_Pos          (31U)
#define COMP_CSR_LOCK_Msk          (0x1UL << COMP_CSR_LOCK_Pos)                /*!< 0x80000000 */
#define COMP_CSR_LOCK              COMP_CSR_LOCK_Msk                           /*!< Comparator lock */

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter                         */
/*                                                                            */
/******************************************************************************/

/*
 * @brief Specific device feature definitions
 */
#define ADC_MULTIMODE_SUPPORT                          /*!< ADC feature available only on specific devices: multimode available on devices with several ADC instances */

/********************  Bit definition for ADC_ISR register  *******************/
#define ADC_ISR_ADRDY_Pos              (0U)
#define ADC_ISR_ADRDY_Msk              (0x1UL << ADC_ISR_ADRDY_Pos)            /*!< 0x00000001 */
#define ADC_ISR_ADRDY                  ADC_ISR_ADRDY_Msk                       /*!< ADC ready flag */
#define ADC_ISR_EOSMP_Pos              (1U)
#define ADC_ISR_EOSMP_Msk              (0x1UL << ADC_ISR_EOSMP_Pos)            /*!< 0x00000002 */
#define ADC_ISR_EOSMP                  ADC_ISR_EOSMP_Msk                       /*!< ADC group regular end of sampling flag */
#define ADC_ISR_EOC_Pos                (2U)
#define ADC_ISR_EOC_Msk                (0x1UL << ADC_ISR_EOC_Pos)              /*!< 0x00000004 */
#define ADC_ISR_EOC                    ADC_ISR_EOC_Msk                         /*!< ADC group regular end of unitary conversion flag */
#define ADC_ISR_EOS_Pos                (3U)
#define ADC_ISR_EOS_Msk                (0x1UL << ADC_ISR_EOS_Pos)              /*!< 0x00000008 */
#define ADC_ISR_EOS                    ADC_ISR_EOS_Msk                         /*!< ADC group regular end of sequence conversions flag */
#define ADC_ISR_OVR_Pos                (4U)
#define ADC_ISR_OVR_Msk               (0x1UL << ADC_ISR_OVR_Pos)               /*!< 0x00000010 */
#define ADC_ISR_OVR                    ADC_ISR_OVR_Msk                         /*!< ADC group regular overrun flag */
#define ADC_ISR_JEOC_Pos               (5U)
#define ADC_ISR_JEOC_Msk               (0x1UL << ADC_ISR_JEOC_Pos)             /*!< 0x00000020 */
#define ADC_ISR_JEOC                   ADC_ISR_JEOC_Msk                        /*!< ADC group injected end of unitary conversion flag */
#define ADC_ISR_JEOS_Pos               (6U)
#define ADC_ISR_JEOS_Msk               (0x1UL << ADC_ISR_JEOS_Pos)             /*!< 0x00000040 */
#define ADC_ISR_JEOS                   ADC_ISR_JEOS_Msk                        /*!< ADC group injected end of sequence conversions flag */
#define ADC_ISR_AWD1_Pos               (7U)
#define ADC_ISR_AWD1_Msk               (0x1UL << ADC_ISR_AWD1_Pos)             /*!< 0x00000080 */
#define ADC_ISR_AWD1                   ADC_ISR_AWD1_Msk                        /*!< ADC analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos               (8U)
#define ADC_ISR_AWD2_Msk               (0x1UL << ADC_ISR_AWD2_Pos)             /*!< 0x00000100 */
#define ADC_ISR_AWD2                   ADC_ISR_AWD2_Msk                        /*!< ADC analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos               (9U)
#define ADC_ISR_AWD3_Msk               (0x1UL << ADC_ISR_AWD3_Pos)             /*!< 0x00000200 */
#define ADC_ISR_AWD3                   ADC_ISR_AWD3_Msk                        /*!< ADC analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos              (10U)
#define ADC_ISR_JQOVF_Msk              (0x1UL << ADC_ISR_JQOVF_Pos)            /*!< 0x00000400 */
#define ADC_ISR_JQOVF                  ADC_ISR_JQOVF_Msk                       /*!< ADC group injected contexts queue overflow flag */

/********************  Bit definition for ADC_IER register  *******************/
#define ADC_IER_ADRDYIE_Pos            (0U)
#define ADC_IER_ADRDYIE_Msk            (0x1UL << ADC_IER_ADRDYIE_Pos)          /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                ADC_IER_ADRDYIE_Msk                     /*!< ADC ready interrupt */
#define ADC_IER_EOSMPIE_Pos            (1U)
#define ADC_IER_EOSMPIE_Msk            (0x1UL << ADC_IER_EOSMPIE_Pos)          /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                ADC_IER_EOSMPIE_Msk                     /*!< ADC group regular end of sampling interrupt */
#define ADC_IER_EOCIE_Pos              (2U)
#define ADC_IER_EOCIE_Msk              (0x1UL << ADC_IER_EOCIE_Pos)            /*!< 0x00000004 */
#define ADC_IER_EOCIE                  ADC_IER_EOCIE_Msk                       /*!< ADC group regular end of unitary conversion interrupt */
#define ADC_IER_EOSIE_Pos              (3U)
#define ADC_IER_EOSIE_Msk              (0x1UL << ADC_IER_EOSIE_Pos)            /*!< 0x00000008 */
#define ADC_IER_EOSIE                  ADC_IER_EOSIE_Msk                       /*!< ADC group regular end of sequence conversions interrupt */
#define ADC_IER_OVRIE_Pos              (4U)
#define ADC_IER_OVRIE_Msk              (0x1UL << ADC_IER_OVRIE_Pos)            /*!< 0x00000010 */
#define ADC_IER_OVRIE                  ADC_IER_OVRIE_Msk                       /*!< ADC group regular overrun interrupt */
#define ADC_IER_JEOCIE_Pos             (5U)
#define ADC_IER_JEOCIE_Msk             (0x1UL << ADC_IER_JEOCIE_Pos)           /*!< 0x00000020 */
#define ADC_IER_JEOCIE                 ADC_IER_JEOCIE_Msk                      /*!< ADC group injected end of unitary conversion interrupt */
#define ADC_IER_JEOSIE_Pos             (6U)
#define ADC_IER_JEOSIE_Msk             (0x1UL << ADC_IER_JEOSIE_Pos)           /*!< 0x00000040 */
#define ADC_IER_JEOSIE                 ADC_IER_JEOSIE_Msk                      /*!< ADC group injected end of sequence conversions interrupt */
#define ADC_IER_AWD1IE_Pos             (7U)
#define ADC_IER_AWD1IE_Msk             (0x1UL << ADC_IER_AWD1IE_Pos)           /*!< 0x00000080 */
#define ADC_IER_AWD1IE                 ADC_IER_AWD1IE_Msk                      /*!< ADC analog watchdog 1 interrupt */
#define ADC_IER_AWD2IE_Pos             (8U)
#define ADC_IER_AWD2IE_Msk             (0x1UL << ADC_IER_AWD2IE_Pos)           /*!< 0x00000100 */
#define ADC_IER_AWD2IE                 ADC_IER_AWD2IE_Msk                      /*!< ADC analog watchdog 2 interrupt */
#define ADC_IER_AWD3IE_Pos             (9U)
#define ADC_IER_AWD3IE_Msk             (0x1UL << ADC_IER_AWD3IE_Pos)           /*!< 0x00000200 */
#define ADC_IER_AWD3IE                 ADC_IER_AWD3IE_Msk                      /*!< ADC analog watchdog 3 interrupt */
#define ADC_IER_JQOVFIE_Pos            (10U)
#define ADC_IER_JQOVFIE_Msk            (0x1UL << ADC_IER_JQOVFIE_Pos)          /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                ADC_IER_JQOVFIE_Msk                     /*!< ADC group injected contexts queue overflow interrupt */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                (0U)
#define ADC_CR_ADEN_Msk                (0x1UL << ADC_CR_ADEN_Pos)              /*!< 0x00000001 */
#define ADC_CR_ADEN                    ADC_CR_ADEN_Msk                         /*!< ADC enable */
#define ADC_CR_ADDIS_Pos               (1U)
#define ADC_CR_ADDIS_Msk               (0x1UL << ADC_CR_ADDIS_Pos)             /*!< 0x00000002 */
#define ADC_CR_ADDIS                   ADC_CR_ADDIS_Msk                        /*!< ADC disable */
#define ADC_CR_ADSTART_Pos             (2U)
#define ADC_CR_ADSTART_Msk             (0x1UL << ADC_CR_ADSTART_Pos)           /*!< 0x00000004 */
#define ADC_CR_ADSTART                 ADC_CR_ADSTART_Msk                      /*!< ADC group regular conversion start */
#define ADC_CR_JADSTART_Pos            (3U)
#define ADC_CR_JADSTART_Msk            (0x1UL << ADC_CR_JADSTART_Pos)          /*!< 0x00000008 */
#define ADC_CR_JADSTART                ADC_CR_JADSTART_Msk                     /*!< ADC group injected conversion start */
#define ADC_CR_ADSTP_Pos               (4U)
#define ADC_CR_ADSTP_Msk               (0x1UL << ADC_CR_ADSTP_Pos)             /*!< 0x00000010 */
#define ADC_CR_ADSTP                   ADC_CR_ADSTP_Msk                        /*!< ADC group regular conversion stop */
#define ADC_CR_JADSTP_Pos              (5U)
#define ADC_CR_JADSTP_Msk              (0x1UL << ADC_CR_JADSTP_Pos)            /*!< 0x00000020 */
#define ADC_CR_JADSTP                  ADC_CR_JADSTP_Msk                       /*!< ADC group injected conversion stop */
#define ADC_CR_ADVREGEN_Pos            (28U)
#define ADC_CR_ADVREGEN_Msk            (0x1UL << ADC_CR_ADVREGEN_Pos)          /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                ADC_CR_ADVREGEN_Msk                     /*!< ADC voltage regulator enable */
#define ADC_CR_DEEPPWD_Pos             (29U)
#define ADC_CR_DEEPPWD_Msk             (0x1UL << ADC_CR_DEEPPWD_Pos)           /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                 ADC_CR_DEEPPWD_Msk                      /*!< ADC deep power down enable */
#define ADC_CR_ADCALDIF_Pos            (30U)
#define ADC_CR_ADCALDIF_Msk            (0x1UL << ADC_CR_ADCALDIF_Pos)          /*!< 0x40000000 */
#define ADC_CR_ADCALDIF                ADC_CR_ADCALDIF_Msk                     /*!< ADC differential mode for calibration */
#define ADC_CR_ADCAL_Pos               (31U)
#define ADC_CR_ADCAL_Msk               (0x1UL << ADC_CR_ADCAL_Pos)             /*!< 0x80000000 */
#define ADC_CR_ADCAL                   ADC_CR_ADCAL_Msk                        /*!< ADC calibration */

/********************  Bit definition for ADC_CFGR register  ******************/
#define ADC_CFGR_DMAEN_Pos             (0U)
#define ADC_CFGR_DMAEN_Msk             (0x1UL << ADC_CFGR_DMAEN_Pos)           /*!< 0x00000001 */
#define ADC_CFGR_DMAEN                 ADC_CFGR_DMAEN_Msk                      /*!< ADC DMA transfer enable */
#define ADC_CFGR_DMACFG_Pos            (1U)
#define ADC_CFGR_DMACFG_Msk            (0x1UL << ADC_CFGR_DMACFG_Pos)          /*!< 0x00000002 */
#define ADC_CFGR_DMACFG                ADC_CFGR_DMACFG_Msk                     /*!< ADC DMA transfer configuration */

#define ADC_CFGR_DFSDMCFG_Pos          (2U)
#define ADC_CFGR_DFSDMCFG_Msk          (0x1UL << ADC_CFGR_DFSDMCFG_Pos)        /*!< 0x00000004 */
#define ADC_CFGR_DFSDMCFG              ADC_CFGR_DFSDMCFG_Msk                   /*!< ADC DFSDM mode configuration */

#define ADC_CFGR_RES_Pos               (3U)
#define ADC_CFGR_RES_Msk               (0x3UL << ADC_CFGR_RES_Pos)             /*!< 0x00000018 */
#define ADC_CFGR_RES                   ADC_CFGR_RES_Msk                        /*!< ADC data resolution */
#define ADC_CFGR_RES_0                 (0x1UL << ADC_CFGR_RES_Pos)             /*!< 0x00000008 */
#define ADC_CFGR_RES_1                 (0x2UL << ADC_CFGR_RES_Pos)             /*!< 0x00000010 */

#define ADC_CFGR_ALIGN_Pos             (5U)
#define ADC_CFGR_ALIGN_Msk             (0x1UL << ADC_CFGR_ALIGN_Pos)           /*!< 0x00000020 */
#define ADC_CFGR_ALIGN                 ADC_CFGR_ALIGN_Msk                      /*!< ADC data alignment */

#define ADC_CFGR_EXTSEL_Pos            (6U)
#define ADC_CFGR_EXTSEL_Msk            (0xFUL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x000003C0 */
#define ADC_CFGR_EXTSEL                ADC_CFGR_EXTSEL_Msk                     /*!< ADC group regular external trigger source */
#define ADC_CFGR_EXTSEL_0              (0x1UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000040 */
#define ADC_CFGR_EXTSEL_1              (0x2UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000080 */
#define ADC_CFGR_EXTSEL_2              (0x4UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000100 */
#define ADC_CFGR_EXTSEL_3              (0x8UL << ADC_CFGR_EXTSEL_Pos)          /*!< 0x00000200 */

#define ADC_CFGR_EXTEN_Pos             (10U)
#define ADC_CFGR_EXTEN_Msk             (0x3UL << ADC_CFGR_EXTEN_Pos)           /*!< 0x00000C00 */
#define ADC_CFGR_EXTEN                 ADC_CFGR_EXTEN_Msk                      /*!< ADC group regular external trigger polarity */
#define ADC_CFGR_EXTEN_0               (0x1UL << ADC_CFGR_EXTEN_Pos)           /*!< 0x00000400 */
#define ADC_CFGR_EXTEN_1               (0x2UL << ADC_CFGR_EXTEN_Pos)           /*!< 0x00000800 */

#define ADC_CFGR_OVRMOD_Pos            (12U)
#define ADC_CFGR_OVRMOD_Msk            (0x1UL << ADC_CFGR_OVRMOD_Pos)          /*!< 0x00001000 */
#define ADC_CFGR_OVRMOD                ADC_CFGR_OVRMOD_Msk                     /*!< ADC group regular overrun configuration */
#define ADC_CFGR_CONT_Pos              (13U)
#define ADC_CFGR_CONT_Msk              (0x1UL << ADC_CFGR_CONT_Pos)            /*!< 0x00002000 */
#define ADC_CFGR_CONT                  ADC_CFGR_CONT_Msk                       /*!< ADC group regular continuous conversion mode */
#define ADC_CFGR_AUTDLY_Pos            (14U)
#define ADC_CFGR_AUTDLY_Msk            (0x1UL << ADC_CFGR_AUTDLY_Pos)          /*!< 0x00004000 */
#define ADC_CFGR_AUTDLY                ADC_CFGR_AUTDLY_Msk                     /*!< ADC low power auto wait */

#define ADC_CFGR_DISCEN_Pos            (16U)
#define ADC_CFGR_DISCEN_Msk            (0x1UL << ADC_CFGR_DISCEN_Pos)          /*!< 0x00010000 */
#define ADC_CFGR_DISCEN                ADC_CFGR_DISCEN_Msk                     /*!< ADC group regular sequencer discontinuous mode */

#define ADC_CFGR_DISCNUM_Pos           (17U)
#define ADC_CFGR_DISCNUM_Msk           (0x7UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x000E0000 */
#define ADC_CFGR_DISCNUM               ADC_CFGR_DISCNUM_Msk                    /*!< ADC group regular sequencer discontinuous number of ranks */
#define ADC_CFGR_DISCNUM_0             (0x1UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x00020000 */
#define ADC_CFGR_DISCNUM_1             (0x2UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x00040000 */
#define ADC_CFGR_DISCNUM_2             (0x4UL << ADC_CFGR_DISCNUM_Pos)         /*!< 0x00080000 */

#define ADC_CFGR_JDISCEN_Pos           (20U)
#define ADC_CFGR_JDISCEN_Msk           (0x1UL << ADC_CFGR_JDISCEN_Pos)         /*!< 0x00100000 */
#define ADC_CFGR_JDISCEN               ADC_CFGR_JDISCEN_Msk                    /*!< ADC group injected sequencer discontinuous mode */
#define ADC_CFGR_JQM_Pos               (21U)
#define ADC_CFGR_JQM_Msk               (0x1UL << ADC_CFGR_JQM_Pos)             /*!< 0x00200000 */
#define ADC_CFGR_JQM                   ADC_CFGR_JQM_Msk                        /*!< ADC group injected contexts queue mode */
#define ADC_CFGR_AWD1SGL_Pos           (22U)
#define ADC_CFGR_AWD1SGL_Msk           (0x1UL << ADC_CFGR_AWD1SGL_Pos)         /*!< 0x00400000 */
#define ADC_CFGR_AWD1SGL               ADC_CFGR_AWD1SGL_Msk                    /*!< ADC analog watchdog 1 monitoring a single channel or all channels */
#define ADC_CFGR_AWD1EN_Pos            (23U)
#define ADC_CFGR_AWD1EN_Msk            (0x1UL << ADC_CFGR_AWD1EN_Pos)          /*!< 0x00800000 */
#define ADC_CFGR_AWD1EN                ADC_CFGR_AWD1EN_Msk                     /*!< ADC analog watchdog 1 enable on scope ADC group regular */
#define ADC_CFGR_JAWD1EN_Pos           (24U)
#define ADC_CFGR_JAWD1EN_Msk           (0x1UL << ADC_CFGR_JAWD1EN_Pos)         /*!< 0x01000000 */
#define ADC_CFGR_JAWD1EN               ADC_CFGR_JAWD1EN_Msk                    /*!< ADC analog watchdog 1 enable on scope ADC group injected */
#define ADC_CFGR_JAUTO_Pos             (25U)
#define ADC_CFGR_JAUTO_Msk             (0x1UL << ADC_CFGR_JAUTO_Pos)           /*!< 0x02000000 */
#define ADC_CFGR_JAUTO                 ADC_CFGR_JAUTO_Msk                      /*!< ADC group injected automatic trigger mode */

#define ADC_CFGR_AWD1CH_Pos            (26U)
#define ADC_CFGR_AWD1CH_Msk            (0x1FUL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x7C000000 */
#define ADC_CFGR_AWD1CH                ADC_CFGR_AWD1CH_Msk                     /*!< ADC analog watchdog 1 monitored channel selection */
#define ADC_CFGR_AWD1CH_0              (0x01UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x04000000 */
#define ADC_CFGR_AWD1CH_1              (0x02UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x08000000 */
#define ADC_CFGR_AWD1CH_2              (0x04UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x10000000 */
#define ADC_CFGR_AWD1CH_3              (0x08UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x20000000 */
#define ADC_CFGR_AWD1CH_4              (0x10UL << ADC_CFGR_AWD1CH_Pos)         /*!< 0x40000000 */

#define ADC_CFGR_JQDIS_Pos             (31U)
#define ADC_CFGR_JQDIS_Msk             (0x1UL << ADC_CFGR_JQDIS_Pos)           /*!< 0x80000000 */
#define ADC_CFGR_JQDIS                 ADC_CFGR_JQDIS_Msk                      /*!< ADC group injected contexts queue disable */

/********************  Bit definition for ADC_CFGR2 register  *****************/
#define ADC_CFGR2_ROVSE_Pos            (0U)
#define ADC_CFGR2_ROVSE_Msk            (0x1UL << ADC_CFGR2_ROVSE_Pos)          /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                ADC_CFGR2_ROVSE_Msk                     /*!< ADC oversampler enable on scope ADC group regular */
#define ADC_CFGR2_JOVSE_Pos            (1U)
#define ADC_CFGR2_JOVSE_Msk            (0x1UL << ADC_CFGR2_JOVSE_Pos)          /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                ADC_CFGR2_JOVSE_Msk                     /*!< ADC oversampler enable on scope ADC group injected */

#define ADC_CFGR2_OVSR_Pos             (2U)
#define ADC_CFGR2_OVSR_Msk             (0x7UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x0000001C */
#define ADC_CFGR2_OVSR                 ADC_CFGR2_OVSR_Msk                      /*!< ADC oversampling ratio */
#define ADC_CFGR2_OVSR_0               (0x1UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000004 */
#define ADC_CFGR2_OVSR_1               (0x2UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000008 */
#define ADC_CFGR2_OVSR_2               (0x4UL << ADC_CFGR2_OVSR_Pos)           /*!< 0x00000010 */

#define ADC_CFGR2_OVSS_Pos             (5U)
#define ADC_CFGR2_OVSS_Msk             (0xFUL << ADC_CFGR2_OVSS_Pos)           /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                 ADC_CFGR2_OVSS_Msk                      /*!< ADC oversampling shift */
#define ADC_CFGR2_OVSS_0               (0x1UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1               (0x2UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2               (0x4UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3               (0x8UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos            (9U)
#define ADC_CFGR2_TROVS_Msk            (0x1UL << ADC_CFGR2_TROVS_Pos)          /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                ADC_CFGR2_TROVS_Msk                     /*!< ADC oversampling discontinuous mode (triggered mode) for ADC group regular */
#define ADC_CFGR2_ROVSM_Pos            (10U)
#define ADC_CFGR2_ROVSM_Msk            (0x1UL << ADC_CFGR2_ROVSM_Pos)          /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                ADC_CFGR2_ROVSM_Msk                     /*!< ADC oversampling mode managing interlaced conversions of ADC group regular and group injected */

/********************  Bit definition for ADC_SMPR1 register  *****************/
#define ADC_SMPR1_SMP0_Pos             (0U)
#define ADC_SMPR1_SMP0_Msk             (0x7UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                 ADC_SMPR1_SMP0_Msk                      /*!< ADC channel 0 sampling time selection  */
#define ADC_SMPR1_SMP0_0               (0x1UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1               (0x2UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2               (0x4UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos             (3U)
#define ADC_SMPR1_SMP1_Msk             (0x7UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                 ADC_SMPR1_SMP1_Msk                      /*!< ADC channel 1 sampling time selection  */
#define ADC_SMPR1_SMP1_0               (0x1UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1               (0x2UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2               (0x4UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos             (6U)
#define ADC_SMPR1_SMP2_Msk             (0x7UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                 ADC_SMPR1_SMP2_Msk                      /*!< ADC channel 2 sampling time selection  */
#define ADC_SMPR1_SMP2_0               (0x1UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1               (0x2UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2               (0x4UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos             (9U)
#define ADC_SMPR1_SMP3_Msk             (0x7UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                 ADC_SMPR1_SMP3_Msk                      /*!< ADC channel 3 sampling time selection  */
#define ADC_SMPR1_SMP3_0               (0x1UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1               (0x2UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2               (0x4UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos             (12U)
#define ADC_SMPR1_SMP4_Msk             (0x7UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                 ADC_SMPR1_SMP4_Msk                      /*!< ADC channel 4 sampling time selection  */
#define ADC_SMPR1_SMP4_0               (0x1UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1               (0x2UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2               (0x4UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos             (15U)
#define ADC_SMPR1_SMP5_Msk             (0x7UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                 ADC_SMPR1_SMP5_Msk                      /*!< ADC channel 5 sampling time selection  */
#define ADC_SMPR1_SMP5_0               (0x1UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1               (0x2UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2               (0x4UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos             (18U)
#define ADC_SMPR1_SMP6_Msk             (0x7UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                 ADC_SMPR1_SMP6_Msk                      /*!< ADC channel 6 sampling time selection  */
#define ADC_SMPR1_SMP6_0               (0x1UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1               (0x2UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2               (0x4UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos             (21U)
#define ADC_SMPR1_SMP7_Msk             (0x7UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                 ADC_SMPR1_SMP7_Msk                      /*!< ADC channel 7 sampling time selection  */
#define ADC_SMPR1_SMP7_0               (0x1UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1               (0x2UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2               (0x4UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos             (24U)
#define ADC_SMPR1_SMP8_Msk             (0x7UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                 ADC_SMPR1_SMP8_Msk                      /*!< ADC channel 8 sampling time selection  */
#define ADC_SMPR1_SMP8_0               (0x1UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1               (0x2UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2               (0x4UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos             (27U)
#define ADC_SMPR1_SMP9_Msk             (0x7UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                 ADC_SMPR1_SMP9_Msk                      /*!< ADC channel 9 sampling time selection  */
#define ADC_SMPR1_SMP9_0               (0x1UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1               (0x2UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2               (0x4UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x20000000 */

#define ADC_SMPR1_SMPPLUS_Pos          (31U)
#define ADC_SMPR1_SMPPLUS_Msk          (0x1UL << ADC_SMPR1_SMPPLUS_Pos)        /*!< 0x80000000 */
#define ADC_SMPR1_SMPPLUS              ADC_SMPR1_SMPPLUS_Msk                   /*!< ADC channels sampling time additional setting */

/********************  Bit definition for ADC_SMPR2 register  *****************/
#define ADC_SMPR2_SMP10_Pos            (0U)
#define ADC_SMPR2_SMP10_Msk            (0x7UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                ADC_SMPR2_SMP10_Msk                     /*!< ADC channel 10 sampling time selection  */
#define ADC_SMPR2_SMP10_0              (0x1UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1              (0x2UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2              (0x4UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos            (3U)
#define ADC_SMPR2_SMP11_Msk            (0x7UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                ADC_SMPR2_SMP11_Msk                     /*!< ADC channel 11 sampling time selection  */
#define ADC_SMPR2_SMP11_0              (0x1UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1              (0x2UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2              (0x4UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos            (6U)
#define ADC_SMPR2_SMP12_Msk            (0x7UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                ADC_SMPR2_SMP12_Msk                     /*!< ADC channel 12 sampling time selection  */
#define ADC_SMPR2_SMP12_0              (0x1UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1              (0x2UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2              (0x4UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos            (9U)
#define ADC_SMPR2_SMP13_Msk            (0x7UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                ADC_SMPR2_SMP13_Msk                     /*!< ADC channel 13 sampling time selection  */
#define ADC_SMPR2_SMP13_0              (0x1UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1              (0x2UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2              (0x4UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos            (12U)
#define ADC_SMPR2_SMP14_Msk            (0x7UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                ADC_SMPR2_SMP14_Msk                     /*!< ADC channel 14 sampling time selection  */
#define ADC_SMPR2_SMP14_0              (0x1UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1              (0x2UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2              (0x4UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos            (15U)
#define ADC_SMPR2_SMP15_Msk            (0x7UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                ADC_SMPR2_SMP15_Msk                     /*!< ADC channel 15 sampling time selection  */
#define ADC_SMPR2_SMP15_0              (0x1UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1              (0x2UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2              (0x4UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos            (18U)
#define ADC_SMPR2_SMP16_Msk            (0x7UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                ADC_SMPR2_SMP16_Msk                     /*!< ADC channel 16 sampling time selection  */
#define ADC_SMPR2_SMP16_0              (0x1UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1              (0x2UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2              (0x4UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos            (21U)
#define ADC_SMPR2_SMP17_Msk            (0x7UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                ADC_SMPR2_SMP17_Msk                     /*!< ADC channel 17 sampling time selection  */
#define ADC_SMPR2_SMP17_0              (0x1UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1              (0x2UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2              (0x4UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos            (24U)
#define ADC_SMPR2_SMP18_Msk            (0x7UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                ADC_SMPR2_SMP18_Msk                     /*!< ADC channel 18 sampling time selection  */
#define ADC_SMPR2_SMP18_0              (0x1UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1              (0x2UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2              (0x4UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x04000000 */

/********************  Bit definition for ADC_TR1 register  *******************/
#define ADC_TR1_LT1_Pos                (0U)
#define ADC_TR1_LT1_Msk                (0xFFFUL << ADC_TR1_LT1_Pos)            /*!< 0x00000FFF */
#define ADC_TR1_LT1                    ADC_TR1_LT1_Msk                         /*!< ADC analog watchdog 1 threshold low */
#define ADC_TR1_LT1_0                  (0x001UL << ADC_TR1_LT1_Pos)            /*!< 0x00000001 */
#define ADC_TR1_LT1_1                  (0x002UL << ADC_TR1_LT1_Pos)            /*!< 0x00000002 */
#define ADC_TR1_LT1_2                  (0x004UL << ADC_TR1_LT1_Pos)            /*!< 0x00000004 */
#define ADC_TR1_LT1_3                  (0x008UL << ADC_TR1_LT1_Pos)            /*!< 0x00000008 */
#define ADC_TR1_LT1_4                  (0x010UL << ADC_TR1_LT1_Pos)            /*!< 0x00000010 */
#define ADC_TR1_LT1_5                  (0x020UL << ADC_TR1_LT1_Pos)            /*!< 0x00000020 */
#define ADC_TR1_LT1_6                  (0x040UL << ADC_TR1_LT1_Pos)            /*!< 0x00000040 */
#define ADC_TR1_LT1_7                  (0x080UL << ADC_TR1_LT1_Pos)            /*!< 0x00000080 */
#define ADC_TR1_LT1_8                  (0x100UL << ADC_TR1_LT1_Pos)            /*!< 0x00000100 */
#define ADC_TR1_LT1_9                  (0x200UL << ADC_TR1_LT1_Pos)            /*!< 0x00000200 */
#define ADC_TR1_LT1_10                 (0x400UL << ADC_TR1_LT1_Pos)            /*!< 0x00000400 */
#define ADC_TR1_LT1_11                 (0x800UL << ADC_TR1_LT1_Pos)            /*!< 0x00000800 */

#define ADC_TR1_HT1_Pos                (16U)
#define ADC_TR1_HT1_Msk                (0xFFFUL << ADC_TR1_HT1_Pos)            /*!< 0x0FFF0000 */
#define ADC_TR1_HT1                    ADC_TR1_HT1_Msk                         /*!< ADC Analog watchdog 1 threshold high */
#define ADC_TR1_HT1_0                  (0x001UL << ADC_TR1_HT1_Pos)            /*!< 0x00010000 */
#define ADC_TR1_HT1_1                  (0x002UL << ADC_TR1_HT1_Pos)            /*!< 0x00020000 */
#define ADC_TR1_HT1_2                  (0x004UL << ADC_TR1_HT1_Pos)            /*!< 0x00040000 */
#define ADC_TR1_HT1_3                  (0x008UL << ADC_TR1_HT1_Pos)            /*!< 0x00080000 */
#define ADC_TR1_HT1_4                  (0x010UL << ADC_TR1_HT1_Pos)            /*!< 0x00100000 */
#define ADC_TR1_HT1_5                  (0x020UL << ADC_TR1_HT1_Pos)            /*!< 0x00200000 */
#define ADC_TR1_HT1_6                  (0x040UL << ADC_TR1_HT1_Pos)            /*!< 0x00400000 */
#define ADC_TR1_HT1_7                  (0x080UL << ADC_TR1_HT1_Pos)            /*!< 0x00800000 */
#define ADC_TR1_HT1_8                  (0x100UL << ADC_TR1_HT1_Pos)            /*!< 0x01000000 */
#define ADC_TR1_HT1_9                  (0x200UL << ADC_TR1_HT1_Pos)            /*!< 0x02000000 */
#define ADC_TR1_HT1_10                 (0x400UL << ADC_TR1_HT1_Pos)            /*!< 0x04000000 */
#define ADC_TR1_HT1_11                 (0x800UL << ADC_TR1_HT1_Pos)            /*!< 0x08000000 */

/********************  Bit definition for ADC_TR2 register  *******************/
#define ADC_TR2_LT2_Pos                (0U)
#define ADC_TR2_LT2_Msk                (0xFFUL << ADC_TR2_LT2_Pos)             /*!< 0x000000FF */
#define ADC_TR2_LT2                    ADC_TR2_LT2_Msk                         /*!< ADC analog watchdog 2 threshold low */
#define ADC_TR2_LT2_0                  (0x01UL << ADC_TR2_LT2_Pos)             /*!< 0x00000001 */
#define ADC_TR2_LT2_1                  (0x02UL << ADC_TR2_LT2_Pos)             /*!< 0x00000002 */
#define ADC_TR2_LT2_2                  (0x04UL << ADC_TR2_LT2_Pos)             /*!< 0x00000004 */
#define ADC_TR2_LT2_3                  (0x08UL << ADC_TR2_LT2_Pos)             /*!< 0x00000008 */
#define ADC_TR2_LT2_4                  (0x10UL << ADC_TR2_LT2_Pos)             /*!< 0x00000010 */
#define ADC_TR2_LT2_5                  (0x20UL << ADC_TR2_LT2_Pos)             /*!< 0x00000020 */
#define ADC_TR2_LT2_6                  (0x40UL << ADC_TR2_LT2_Pos)             /*!< 0x00000040 */
#define ADC_TR2_LT2_7                  (0x80UL << ADC_TR2_LT2_Pos)             /*!< 0x00000080 */

#define ADC_TR2_HT2_Pos                (16U)
#define ADC_TR2_HT2_Msk                (0xFFUL << ADC_TR2_HT2_Pos)             /*!< 0x00FF0000 */
#define ADC_TR2_HT2                    ADC_TR2_HT2_Msk                         /*!< ADC analog watchdog 2 threshold high */
#define ADC_TR2_HT2_0                  (0x01UL << ADC_TR2_HT2_Pos)             /*!< 0x00010000 */
#define ADC_TR2_HT2_1                  (0x02UL << ADC_TR2_HT2_Pos)             /*!< 0x00020000 */
#define ADC_TR2_HT2_2                  (0x04UL << ADC_TR2_HT2_Pos)             /*!< 0x00040000 */
#define ADC_TR2_HT2_3                  (0x08UL << ADC_TR2_HT2_Pos)             /*!< 0x00080000 */
#define ADC_TR2_HT2_4                  (0x10UL << ADC_TR2_HT2_Pos)             /*!< 0x00100000 */
#define ADC_TR2_HT2_5                  (0x20UL << ADC_TR2_HT2_Pos)             /*!< 0x00200000 */
#define ADC_TR2_HT2_6                  (0x40UL << ADC_TR2_HT2_Pos)             /*!< 0x00400000 */
#define ADC_TR2_HT2_7                  (0x80UL << ADC_TR2_HT2_Pos)             /*!< 0x00800000 */

/********************  Bit definition for ADC_TR3 register  *******************/
#define ADC_TR3_LT3_Pos                (0U)
#define ADC_TR3_LT3_Msk                (0xFFUL << ADC_TR3_LT3_Pos)             /*!< 0x000000FF */
#define ADC_TR3_LT3                    ADC_TR3_LT3_Msk                         /*!< ADC analog watchdog 3 threshold low */
#define ADC_TR3_LT3_0                  (0x01UL << ADC_TR3_LT3_Pos)             /*!< 0x00000001 */
#define ADC_TR3_LT3_1                  (0x02UL << ADC_TR3_LT3_Pos)             /*!< 0x00000002 */
#define ADC_TR3_LT3_2                  (0x04UL << ADC_TR3_LT3_Pos)             /*!< 0x00000004 */
#define ADC_TR3_LT3_3                  (0x08UL << ADC_TR3_LT3_Pos)             /*!< 0x00000008 */
#define ADC_TR3_LT3_4                  (0x10UL << ADC_TR3_LT3_Pos)             /*!< 0x00000010 */
#define ADC_TR3_LT3_5                  (0x20UL << ADC_TR3_LT3_Pos)             /*!< 0x00000020 */
#define ADC_TR3_LT3_6                  (0x40UL << ADC_TR3_LT3_Pos)             /*!< 0x00000040 */
#define ADC_TR3_LT3_7                  (0x80UL << ADC_TR3_LT3_Pos)             /*!< 0x00000080 */

#define ADC_TR3_HT3_Pos                (16U)
#define ADC_TR3_HT3_Msk                (0xFFUL << ADC_TR3_HT3_Pos)             /*!< 0x00FF0000 */
#define ADC_TR3_HT3                    ADC_TR3_HT3_Msk                         /*!< ADC analog watchdog 3 threshold high */
#define ADC_TR3_HT3_0                  (0x01UL << ADC_TR3_HT3_Pos)             /*!< 0x00010000 */
#define ADC_TR3_HT3_1                  (0x02UL << ADC_TR3_HT3_Pos)             /*!< 0x00020000 */
#define ADC_TR3_HT3_2                  (0x04UL << ADC_TR3_HT3_Pos)             /*!< 0x00040000 */
#define ADC_TR3_HT3_3                  (0x08UL << ADC_TR3_HT3_Pos)             /*!< 0x00080000 */
#define ADC_TR3_HT3_4                  (0x10UL << ADC_TR3_HT3_Pos)             /*!< 0x00100000 */
#define ADC_TR3_HT3_5                  (0x20UL << ADC_TR3_HT3_Pos)             /*!< 0x00200000 */
#define ADC_TR3_HT3_6                  (0x40UL << ADC_TR3_HT3_Pos)             /*!< 0x00400000 */
#define ADC_TR3_HT3_7                  (0x80UL << ADC_TR3_HT3_Pos)             /*!< 0x00800000 */

/********************  Bit definition for ADC_SQR1 register  ******************/
#define ADC_SQR1_L_Pos                 (0U)
#define ADC_SQR1_L_Msk                 (0xFUL << ADC_SQR1_L_Pos)               /*!< 0x0000000F */
#define ADC_SQR1_L                     ADC_SQR1_L_Msk                          /*!< ADC group regular sequencer scan length */
#define ADC_SQR1_L_0                   (0x1UL << ADC_SQR1_L_Pos)               /*!< 0x00000001 */
#define ADC_SQR1_L_1                   (0x2UL << ADC_SQR1_L_Pos)               /*!< 0x00000002 */
#define ADC_SQR1_L_2                   (0x4UL << ADC_SQR1_L_Pos)               /*!< 0x00000004 */
#define ADC_SQR1_L_3                   (0x8UL << ADC_SQR1_L_Pos)               /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos               (6U)
#define ADC_SQR1_SQ1_Msk               (0x1FUL << ADC_SQR1_SQ1_Pos)            /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                   ADC_SQR1_SQ1_Msk                        /*!< ADC group regular sequencer rank 1 */
#define ADC_SQR1_SQ1_0                 (0x01UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                 (0x02UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                 (0x04UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                 (0x08UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                 (0x10UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos               (12U)
#define ADC_SQR1_SQ2_Msk               (0x1FUL << ADC_SQR1_SQ2_Pos)            /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                   ADC_SQR1_SQ2_Msk                        /*!< ADC group regular sequencer rank 2 */
#define ADC_SQR1_SQ2_0                 (0x01UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                 (0x02UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                 (0x04UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                 (0x08UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                 (0x10UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos               (18U)
#define ADC_SQR1_SQ3_Msk               (0x1FUL << ADC_SQR1_SQ3_Pos)            /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                   ADC_SQR1_SQ3_Msk                        /*!< ADC group regular sequencer rank 3 */
#define ADC_SQR1_SQ3_0                 (0x01UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                 (0x02UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                 (0x04UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                 (0x08UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                 (0x10UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos               (24U)
#define ADC_SQR1_SQ4_Msk               (0x1FUL << ADC_SQR1_SQ4_Pos)            /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                   ADC_SQR1_SQ4_Msk                        /*!< ADC group regular sequencer rank 4 */
#define ADC_SQR1_SQ4_0                 (0x01UL << ADC_SQR1_SQ4_Pos)            /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                 (0x02UL << ADC_SQR1_SQ4_Pos)            /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                 (0x04UL << ADC_SQR1_SQ4_Pos)            /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                 (0x08UL << ADC_SQR1_SQ4_Pos)            /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                 (0x10UL << ADC_SQR1_SQ4_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ******************/
#define ADC_SQR2_SQ5_Pos               (0U)
#define ADC_SQR2_SQ5_Msk               (0x1FUL << ADC_SQR2_SQ5_Pos)            /*!< 0x0000001F */
#define ADC_SQR2_SQ5                   ADC_SQR2_SQ5_Msk                        /*!< ADC group regular sequencer rank 5 */
#define ADC_SQR2_SQ5_0                 (0x01UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                 (0x02UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                 (0x04UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                 (0x08UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                 (0x10UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos               (6U)
#define ADC_SQR2_SQ6_Msk               (0x1FUL << ADC_SQR2_SQ6_Pos)            /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                   ADC_SQR2_SQ6_Msk                        /*!< ADC group regular sequencer rank 6 */
#define ADC_SQR2_SQ6_0                 (0x01UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                 (0x02UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                 (0x04UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                 (0x08UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                 (0x10UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos               (12U)
#define ADC_SQR2_SQ7_Msk               (0x1FUL << ADC_SQR2_SQ7_Pos)            /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                   ADC_SQR2_SQ7_Msk                        /*!< ADC group regular sequencer rank 7 */
#define ADC_SQR2_SQ7_0                 (0x01UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                 (0x02UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                 (0x04UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                 (0x08UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                 (0x10UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos               (18U)
#define ADC_SQR2_SQ8_Msk               (0x1FUL << ADC_SQR2_SQ8_Pos)            /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                   ADC_SQR2_SQ8_Msk                        /*!< ADC group regular sequencer rank 8 */
#define ADC_SQR2_SQ8_0                 (0x01UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                 (0x02UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                 (0x04UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                 (0x08UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                 (0x10UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos               (24U)
#define ADC_SQR2_SQ9_Msk               (0x1FUL << ADC_SQR2_SQ9_Pos)            /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                   ADC_SQR2_SQ9_Msk                        /*!< ADC group regular sequencer rank 9 */
#define ADC_SQR2_SQ9_0                 (0x01UL << ADC_SQR2_SQ9_Pos)            /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                 (0x02UL << ADC_SQR2_SQ9_Pos)            /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                 (0x04UL << ADC_SQR2_SQ9_Pos)            /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                 (0x08UL << ADC_SQR2_SQ9_Pos)            /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                 (0x10UL << ADC_SQR2_SQ9_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ******************/
#define ADC_SQR3_SQ10_Pos              (0U)
#define ADC_SQR3_SQ10_Msk              (0x1FUL << ADC_SQR3_SQ10_Pos)           /*!< 0x0000001F */
#define ADC_SQR3_SQ10                  ADC_SQR3_SQ10_Msk                       /*!< ADC group regular sequencer rank 10 */
#define ADC_SQR3_SQ10_0                (0x01UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                (0x02UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                (0x04UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                (0x08UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                (0x10UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos              (6U)
#define ADC_SQR3_SQ11_Msk              (0x1FUL << ADC_SQR3_SQ11_Pos)           /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                  ADC_SQR3_SQ11_Msk                       /*!< ADC group regular sequencer rank 11 */
#define ADC_SQR3_SQ11_0                (0x01UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                (0x02UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                (0x04UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                (0x08UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                (0x10UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos              (12U)
#define ADC_SQR3_SQ12_Msk              (0x1FUL << ADC_SQR3_SQ12_Pos)           /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                  ADC_SQR3_SQ12_Msk                       /*!< ADC group regular sequencer rank 12 */
#define ADC_SQR3_SQ12_0                (0x01UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                (0x02UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                (0x04UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                (0x08UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                (0x10UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos              (18U)
#define ADC_SQR3_SQ13_Msk              (0x1FUL << ADC_SQR3_SQ13_Pos)           /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                  ADC_SQR3_SQ13_Msk                       /*!< ADC group regular sequencer rank 13 */
#define ADC_SQR3_SQ13_0                (0x01UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                (0x02UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                (0x04UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                (0x08UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                (0x10UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos              (24U)
#define ADC_SQR3_SQ14_Msk              (0x1FUL << ADC_SQR3_SQ14_Pos)           /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                  ADC_SQR3_SQ14_Msk                       /*!< ADC group regular sequencer rank 14 */
#define ADC_SQR3_SQ14_0                (0x01UL << ADC_SQR3_SQ14_Pos)           /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                (0x02UL << ADC_SQR3_SQ14_Pos)           /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                (0x04UL << ADC_SQR3_SQ14_Pos)           /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                (0x08UL << ADC_SQR3_SQ14_Pos)           /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                (0x10UL << ADC_SQR3_SQ14_Pos)           /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ******************/
#define ADC_SQR4_SQ15_Pos              (0U)
#define ADC_SQR4_SQ15_Msk              (0x1FUL << ADC_SQR4_SQ15_Pos)           /*!< 0x0000001F */
#define ADC_SQR4_SQ15                  ADC_SQR4_SQ15_Msk                       /*!< ADC group regular sequencer rank 15 */
#define ADC_SQR4_SQ15_0                (0x01UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                (0x02UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                (0x04UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                (0x08UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                (0x10UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos              (6U)
#define ADC_SQR4_SQ16_Msk              (0x1FUL << ADC_SQR4_SQ16_Pos)           /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                  ADC_SQR4_SQ16_Msk                       /*!< ADC group regular sequencer rank 16 */
#define ADC_SQR4_SQ16_0                (0x01UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                (0x02UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                (0x04UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                (0x08UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                (0x10UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000400 */

/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos               (0U)
#define ADC_DR_RDATA_Msk               (0xFFFFUL << ADC_DR_RDATA_Pos)          /*!< 0x0000FFFF */
#define ADC_DR_RDATA                   ADC_DR_RDATA_Msk                        /*!< ADC group regular conversion data */
#define ADC_DR_RDATA_0                 (0x0001UL << ADC_DR_RDATA_Pos)          /*!< 0x00000001 */
#define ADC_DR_RDATA_1                 (0x0002UL << ADC_DR_RDATA_Pos)          /*!< 0x00000002 */
#define ADC_DR_RDATA_2                 (0x0004UL << ADC_DR_RDATA_Pos)          /*!< 0x00000004 */
#define ADC_DR_RDATA_3                 (0x0008UL << ADC_DR_RDATA_Pos)          /*!< 0x00000008 */
#define ADC_DR_RDATA_4                 (0x0010UL << ADC_DR_RDATA_Pos)          /*!< 0x00000010 */
#define ADC_DR_RDATA_5                 (0x0020UL << ADC_DR_RDATA_Pos)          /*!< 0x00000020 */
#define ADC_DR_RDATA_6                 (0x0040UL << ADC_DR_RDATA_Pos)          /*!< 0x00000040 */
#define ADC_DR_RDATA_7                 (0x0080UL << ADC_DR_RDATA_Pos)          /*!< 0x00000080 */
#define ADC_DR_RDATA_8                 (0x0100UL << ADC_DR_RDATA_Pos)          /*!< 0x00000100 */
#define ADC_DR_RDATA_9                 (0x0200UL << ADC_DR_RDATA_Pos)          /*!< 0x00000200 */
#define ADC_DR_RDATA_10                (0x0400UL << ADC_DR_RDATA_Pos)          /*!< 0x00000400 */
#define ADC_DR_RDATA_11                (0x0800UL << ADC_DR_RDATA_Pos)          /*!< 0x00000800 */
#define ADC_DR_RDATA_12                (0x1000UL << ADC_DR_RDATA_Pos)          /*!< 0x00001000 */
#define ADC_DR_RDATA_13                (0x2000UL << ADC_DR_RDATA_Pos)          /*!< 0x00002000 */
#define ADC_DR_RDATA_14                (0x4000UL << ADC_DR_RDATA_Pos)          /*!< 0x00004000 */
#define ADC_DR_RDATA_15                (0x8000UL << ADC_DR_RDATA_Pos)          /*!< 0x00008000 */

/********************  Bit definition for ADC_JSQR register  ******************/
#define ADC_JSQR_JL_Pos                (0U)
#define ADC_JSQR_JL_Msk                (0x3UL << ADC_JSQR_JL_Pos)              /*!< 0x00000003 */
#define ADC_JSQR_JL                    ADC_JSQR_JL_Msk                         /*!< ADC group injected sequencer scan length */
#define ADC_JSQR_JL_0                  (0x1UL << ADC_JSQR_JL_Pos)              /*!< 0x00000001 */
#define ADC_JSQR_JL_1                  (0x2UL << ADC_JSQR_JL_Pos)              /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos           (2U)
#define ADC_JSQR_JEXTSEL_Msk           (0xFUL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x0000003C */
#define ADC_JSQR_JEXTSEL               ADC_JSQR_JEXTSEL_Msk                    /*!< ADC group injected external trigger source */
#define ADC_JSQR_JEXTSEL_0             (0x1UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1             (0x2UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2             (0x4UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3             (0x8UL << ADC_JSQR_JEXTSEL_Pos)         /*!< 0x00000020 */

#define ADC_JSQR_JEXTEN_Pos            (6U)
#define ADC_JSQR_JEXTEN_Msk            (0x3UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x000000C0 */
#define ADC_JSQR_JEXTEN                ADC_JSQR_JEXTEN_Msk                     /*!< ADC group injected external trigger polarity */
#define ADC_JSQR_JEXTEN_0              (0x1UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000040 */
#define ADC_JSQR_JEXTEN_1              (0x2UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000080 */

#define ADC_JSQR_JSQ1_Pos              (8U)
#define ADC_JSQR_JSQ1_Msk              (0x1FUL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00001F00 */
#define ADC_JSQR_JSQ1                  ADC_JSQR_JSQ1_Msk                       /*!< ADC group injected sequencer rank 1 */
#define ADC_JSQR_JSQ1_0                (0x01UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000100 */
#define ADC_JSQR_JSQ1_1                (0x02UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_2                (0x04UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_3                (0x08UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_4                (0x10UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00001000 */

#define ADC_JSQR_JSQ2_Pos              (14U)
#define ADC_JSQR_JSQ2_Msk              (0x1FUL << ADC_JSQR_JSQ2_Pos)           /*!< 0x0007C000 */
#define ADC_JSQR_JSQ2                  ADC_JSQR_JSQ2_Msk                       /*!< ADC group injected sequencer rank 2 */
#define ADC_JSQR_JSQ2_0                (0x01UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00004000 */
#define ADC_JSQR_JSQ2_1                (0x02UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_2                (0x04UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_3                (0x08UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_4                (0x10UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00040000 */

#define ADC_JSQR_JSQ3_Pos              (20U)
#define ADC_JSQR_JSQ3_Msk              (0x1FUL << ADC_JSQR_JSQ3_Pos)           /*!< 0x01F00000 */
#define ADC_JSQR_JSQ3                  ADC_JSQR_JSQ3_Msk                       /*!< ADC group injected sequencer rank 3 */
#define ADC_JSQR_JSQ3_0                (0x01UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00100000 */
#define ADC_JSQR_JSQ3_1                (0x02UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_2                (0x04UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_3                (0x08UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_4                (0x10UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x01000000 */

#define ADC_JSQR_JSQ4_Pos              (26U)
#define ADC_JSQR_JSQ4_Msk              (0x1FUL << ADC_JSQR_JSQ4_Pos)           /*!< 0x7C000000 */
#define ADC_JSQR_JSQ4                  ADC_JSQR_JSQ4_Msk                       /*!< ADC group injected sequencer rank 4 */
#define ADC_JSQR_JSQ4_0                (0x01UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x04000000 */
#define ADC_JSQR_JSQ4_1                (0x02UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_2                (0x04UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_3                (0x08UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_4                (0x10UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x40000000 */

/********************  Bit definition for ADC_OFR1 register  ******************/
#define ADC_OFR1_OFFSET1_Pos           (0U)
#define ADC_OFR1_OFFSET1_Msk           (0xFFFUL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000FFF */
#define ADC_OFR1_OFFSET1               ADC_OFR1_OFFSET1_Msk                    /*!< ADC offset number 1 offset level */
#define ADC_OFR1_OFFSET1_0             (0x001UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000001 */
#define ADC_OFR1_OFFSET1_1             (0x002UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000002 */
#define ADC_OFR1_OFFSET1_2             (0x004UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000004 */
#define ADC_OFR1_OFFSET1_3             (0x008UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000008 */
#define ADC_OFR1_OFFSET1_4             (0x010UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000010 */
#define ADC_OFR1_OFFSET1_5             (0x020UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000020 */
#define ADC_OFR1_OFFSET1_6             (0x040UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000040 */
#define ADC_OFR1_OFFSET1_7             (0x080UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000080 */
#define ADC_OFR1_OFFSET1_8             (0x100UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000100 */
#define ADC_OFR1_OFFSET1_9             (0x200UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000200 */
#define ADC_OFR1_OFFSET1_10            (0x400UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000400 */
#define ADC_OFR1_OFFSET1_11            (0x800UL << ADC_OFR1_OFFSET1_Pos)       /*!< 0x00000800 */

#define ADC_OFR1_OFFSET1_CH_Pos        (26U)
#define ADC_OFR1_OFFSET1_CH_Msk        (0x1FUL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR1_OFFSET1_CH            ADC_OFR1_OFFSET1_CH_Msk                 /*!< ADC offset number 1 channel selection */
#define ADC_OFR1_OFFSET1_CH_0          (0x01UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR1_OFFSET1_CH_1          (0x02UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR1_OFFSET1_CH_2          (0x04UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR1_OFFSET1_CH_3          (0x08UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR1_OFFSET1_CH_4          (0x10UL << ADC_OFR1_OFFSET1_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR1_OFFSET1_EN_Pos        (31U)
#define ADC_OFR1_OFFSET1_EN_Msk        (0x1UL << ADC_OFR1_OFFSET1_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR1_OFFSET1_EN            ADC_OFR1_OFFSET1_EN_Msk                 /*!< ADC offset number 1 enable */

/********************  Bit definition for ADC_OFR2 register  ******************/
#define ADC_OFR2_OFFSET2_Pos           (0U)
#define ADC_OFR2_OFFSET2_Msk           (0xFFFUL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000FFF */
#define ADC_OFR2_OFFSET2               ADC_OFR2_OFFSET2_Msk                    /*!< ADC offset number 2 offset level */
#define ADC_OFR2_OFFSET2_0             (0x001UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000001 */
#define ADC_OFR2_OFFSET2_1             (0x002UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000002 */
#define ADC_OFR2_OFFSET2_2             (0x004UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000004 */
#define ADC_OFR2_OFFSET2_3             (0x008UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000008 */
#define ADC_OFR2_OFFSET2_4             (0x010UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000010 */
#define ADC_OFR2_OFFSET2_5             (0x020UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000020 */
#define ADC_OFR2_OFFSET2_6             (0x040UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000040 */
#define ADC_OFR2_OFFSET2_7             (0x080UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000080 */
#define ADC_OFR2_OFFSET2_8             (0x100UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000100 */
#define ADC_OFR2_OFFSET2_9             (0x200UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000200 */
#define ADC_OFR2_OFFSET2_10            (0x400UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000400 */
#define ADC_OFR2_OFFSET2_11            (0x800UL << ADC_OFR2_OFFSET2_Pos)       /*!< 0x00000800 */

#define ADC_OFR2_OFFSET2_CH_Pos        (26U)
#define ADC_OFR2_OFFSET2_CH_Msk        (0x1FUL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR2_OFFSET2_CH            ADC_OFR2_OFFSET2_CH_Msk                 /*!< ADC offset number 2 channel selection */
#define ADC_OFR2_OFFSET2_CH_0          (0x01UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR2_OFFSET2_CH_1          (0x02UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR2_OFFSET2_CH_2          (0x04UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR2_OFFSET2_CH_3          (0x08UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR2_OFFSET2_CH_4          (0x10UL << ADC_OFR2_OFFSET2_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR2_OFFSET2_EN_Pos        (31U)
#define ADC_OFR2_OFFSET2_EN_Msk        (0x1UL << ADC_OFR2_OFFSET2_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR2_OFFSET2_EN            ADC_OFR2_OFFSET2_EN_Msk                 /*!< ADC offset number 2 enable */

/********************  Bit definition for ADC_OFR3 register  ******************/
#define ADC_OFR3_OFFSET3_Pos           (0U)
#define ADC_OFR3_OFFSET3_Msk           (0xFFFUL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000FFF */
#define ADC_OFR3_OFFSET3               ADC_OFR3_OFFSET3_Msk                    /*!< ADC offset number 3 offset level */
#define ADC_OFR3_OFFSET3_0             (0x001UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000001 */
#define ADC_OFR3_OFFSET3_1             (0x002UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000002 */
#define ADC_OFR3_OFFSET3_2             (0x004UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000004 */
#define ADC_OFR3_OFFSET3_3             (0x008UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000008 */
#define ADC_OFR3_OFFSET3_4             (0x010UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000010 */
#define ADC_OFR3_OFFSET3_5             (0x020UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000020 */
#define ADC_OFR3_OFFSET3_6             (0x040UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000040 */
#define ADC_OFR3_OFFSET3_7             (0x080UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000080 */
#define ADC_OFR3_OFFSET3_8             (0x100UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000100 */
#define ADC_OFR3_OFFSET3_9             (0x200UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000200 */
#define ADC_OFR3_OFFSET3_10            (0x400UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000400 */
#define ADC_OFR3_OFFSET3_11            (0x800UL << ADC_OFR3_OFFSET3_Pos)       /*!< 0x00000800 */

#define ADC_OFR3_OFFSET3_CH_Pos        (26U)
#define ADC_OFR3_OFFSET3_CH_Msk        (0x1FUL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR3_OFFSET3_CH            ADC_OFR3_OFFSET3_CH_Msk                 /*!< ADC offset number 3 channel selection */
#define ADC_OFR3_OFFSET3_CH_0          (0x01UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR3_OFFSET3_CH_1          (0x02UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR3_OFFSET3_CH_2          (0x04UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR3_OFFSET3_CH_3          (0x08UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR3_OFFSET3_CH_4          (0x10UL << ADC_OFR3_OFFSET3_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR3_OFFSET3_EN_Pos        (31U)
#define ADC_OFR3_OFFSET3_EN_Msk        (0x1UL << ADC_OFR3_OFFSET3_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR3_OFFSET3_EN            ADC_OFR3_OFFSET3_EN_Msk                 /*!< ADC offset number 3 enable */

/********************  Bit definition for ADC_OFR4 register  ******************/
#define ADC_OFR4_OFFSET4_Pos           (0U)
#define ADC_OFR4_OFFSET4_Msk           (0xFFFUL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000FFF */
#define ADC_OFR4_OFFSET4               ADC_OFR4_OFFSET4_Msk                    /*!< ADC offset number 4 offset level */
#define ADC_OFR4_OFFSET4_0             (0x001UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000001 */
#define ADC_OFR4_OFFSET4_1             (0x002UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000002 */
#define ADC_OFR4_OFFSET4_2             (0x004UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000004 */
#define ADC_OFR4_OFFSET4_3             (0x008UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000008 */
#define ADC_OFR4_OFFSET4_4             (0x010UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000010 */
#define ADC_OFR4_OFFSET4_5             (0x020UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000020 */
#define ADC_OFR4_OFFSET4_6             (0x040UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000040 */
#define ADC_OFR4_OFFSET4_7             (0x080UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000080 */
#define ADC_OFR4_OFFSET4_8             (0x100UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000100 */
#define ADC_OFR4_OFFSET4_9             (0x200UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000200 */
#define ADC_OFR4_OFFSET4_10            (0x400UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000400 */
#define ADC_OFR4_OFFSET4_11            (0x800UL << ADC_OFR4_OFFSET4_Pos)       /*!< 0x00000800 */

#define ADC_OFR4_OFFSET4_CH_Pos        (26U)
#define ADC_OFR4_OFFSET4_CH_Msk        (0x1FUL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x7C000000 */
#define ADC_OFR4_OFFSET4_CH            ADC_OFR4_OFFSET4_CH_Msk                 /*!< ADC offset number 4 channel selection */
#define ADC_OFR4_OFFSET4_CH_0          (0x01UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x04000000 */
#define ADC_OFR4_OFFSET4_CH_1          (0x02UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x08000000 */
#define ADC_OFR4_OFFSET4_CH_2          (0x04UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x10000000 */
#define ADC_OFR4_OFFSET4_CH_3          (0x08UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x20000000 */
#define ADC_OFR4_OFFSET4_CH_4          (0x10UL << ADC_OFR4_OFFSET4_CH_Pos)     /*!< 0x40000000 */

#define ADC_OFR4_OFFSET4_EN_Pos        (31U)
#define ADC_OFR4_OFFSET4_EN_Msk        (0x1UL << ADC_OFR4_OFFSET4_EN_Pos)      /*!< 0x80000000 */
#define ADC_OFR4_OFFSET4_EN            ADC_OFR4_OFFSET4_EN_Msk                 /*!< ADC offset number 4 enable */

/********************  Bit definition for ADC_JDR1 register  ******************/
#define ADC_JDR1_JDATA_Pos             (0U)
#define ADC_JDR1_JDATA_Msk             (0xFFFFUL << ADC_JDR1_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR1_JDATA                 ADC_JDR1_JDATA_Msk                      /*!< ADC group injected sequencer rank 1 conversion data */
#define ADC_JDR1_JDATA_0               (0x0001UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1               (0x0002UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2               (0x0004UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3               (0x0008UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4               (0x0010UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5               (0x0020UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6               (0x0040UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7               (0x0080UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8               (0x0100UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9               (0x0200UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10              (0x0400UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11              (0x0800UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12              (0x1000UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13              (0x2000UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14              (0x4000UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15              (0x8000UL << ADC_JDR1_JDATA_Pos)        /*!< 0x00008000 */

/********************  Bit definition for ADC_JDR2 register  ******************/
#define ADC_JDR2_JDATA_Pos             (0U)
#define ADC_JDR2_JDATA_Msk             (0xFFFFUL << ADC_JDR2_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR2_JDATA                 ADC_JDR2_JDATA_Msk                      /*!< ADC group injected sequencer rank 2 conversion data */
#define ADC_JDR2_JDATA_0               (0x0001UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1               (0x0002UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2               (0x0004UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3               (0x0008UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4               (0x0010UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5               (0x0020UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6               (0x0040UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7               (0x0080UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8               (0x0100UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9               (0x0200UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10              (0x0400UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11              (0x0800UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12              (0x1000UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13              (0x2000UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14              (0x4000UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15              (0x8000UL << ADC_JDR2_JDATA_Pos)        /*!< 0x00008000 */

/********************  Bit definition for ADC_JDR3 register  ******************/
#define ADC_JDR3_JDATA_Pos             (0U)
#define ADC_JDR3_JDATA_Msk             (0xFFFFUL << ADC_JDR3_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR3_JDATA                 ADC_JDR3_JDATA_Msk                      /*!< ADC group injected sequencer rank 3 conversion data */
#define ADC_JDR3_JDATA_0               (0x0001UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1               (0x0002UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2               (0x0004UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3               (0x0008UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4               (0x0010UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5               (0x0020UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6               (0x0040UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7               (0x0080UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8               (0x0100UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9               (0x0200UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10              (0x0400UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11              (0x0800UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12              (0x1000UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13              (0x2000UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14              (0x4000UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15              (0x8000UL << ADC_JDR3_JDATA_Pos)        /*!< 0x00008000 */

/********************  Bit definition for ADC_JDR4 register  ******************/
#define ADC_JDR4_JDATA_Pos             (0U)
#define ADC_JDR4_JDATA_Msk             (0xFFFFUL << ADC_JDR4_JDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_JDR4_JDATA                 ADC_JDR4_JDATA_Msk                      /*!< ADC group injected sequencer rank 4 conversion data */
#define ADC_JDR4_JDATA_0               (0x0001UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1               (0x0002UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2               (0x0004UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3               (0x0008UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4               (0x0010UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5               (0x0020UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6               (0x0040UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7               (0x0080UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8               (0x0100UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9               (0x0200UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10              (0x0400UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11              (0x0800UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12              (0x1000UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13              (0x2000UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14              (0x4000UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15              (0x8000UL << ADC_JDR4_JDATA_Pos)        /*!< 0x00008000 */

/********************  Bit definition for ADC_AWD2CR register  ****************/
#define ADC_AWD2CR_AWD2CH_Pos          (0U)
#define ADC_AWD2CR_AWD2CH_Msk          (0x7FFFFUL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x0007FFFF */
#define ADC_AWD2CR_AWD2CH              ADC_AWD2CR_AWD2CH_Msk                   /*!< ADC analog watchdog 2 monitored channel selection */
#define ADC_AWD2CR_AWD2CH_0            (0x00001UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1            (0x00002UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2            (0x00004UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3            (0x00008UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4            (0x00010UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5            (0x00020UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6            (0x00040UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7            (0x00080UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8            (0x00100UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9            (0x00200UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10           (0x00400UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11           (0x00800UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12           (0x01000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13           (0x02000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14           (0x04000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15           (0x08000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16           (0x10000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17           (0x20000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18           (0x40000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00040000 */

/********************  Bit definition for ADC_AWD3CR register  ****************/
#define ADC_AWD3CR_AWD3CH_Pos          (0U)
#define ADC_AWD3CR_AWD3CH_Msk          (0x7FFFFUL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x0007FFFF */
#define ADC_AWD3CR_AWD3CH              ADC_AWD3CR_AWD3CH_Msk                   /*!< ADC analog watchdog 3 monitored channel selection */
#define ADC_AWD3CR_AWD3CH_0            (0x00001UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1            (0x00002UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2            (0x00004UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3            (0x00008UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4            (0x00010UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5            (0x00020UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6            (0x00040UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7            (0x00080UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8            (0x00100UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9            (0x00200UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10           (0x00400UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11           (0x00800UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12           (0x01000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13           (0x02000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14           (0x04000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15           (0x08000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16           (0x10000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17           (0x20000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18           (0x40000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00040000 */

/********************  Bit definition for ADC_DIFSEL register  ****************/
#define ADC_DIFSEL_DIFSEL_Pos          (0U)
#define ADC_DIFSEL_DIFSEL_Msk          (0x7FFFFUL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x0007FFFF */
#define ADC_DIFSEL_DIFSEL              ADC_DIFSEL_DIFSEL_Msk                   /*!< ADC channel differential or single-ended mode */
#define ADC_DIFSEL_DIFSEL_0            (0x00001UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1            (0x00002UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2            (0x00004UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3            (0x00008UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4            (0x00010UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5            (0x00020UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6            (0x00040UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7            (0x00080UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8            (0x00100UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9            (0x00200UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10           (0x00400UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11           (0x00800UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12           (0x01000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13           (0x02000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14           (0x04000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15           (0x08000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16           (0x10000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17           (0x20000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18           (0x40000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00040000 */

/********************  Bit definition for ADC_CALFACT register  ***************/
#define ADC_CALFACT_CALFACT_S_Pos      (0U)
#define ADC_CALFACT_CALFACT_S_Msk      (0x7FUL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x0000007F */
#define ADC_CALFACT_CALFACT_S          ADC_CALFACT_CALFACT_S_Msk               /*!< ADC calibration factor in single-ended mode */
#define ADC_CALFACT_CALFACT_S_0        (0x01UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_S_1        (0x02UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_S_2        (0x04UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_S_3        (0x08UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_S_4        (0x10UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_S_5        (0x20UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_S_6        (0x40UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000040 */

#define ADC_CALFACT_CALFACT_D_Pos      (16U)
#define ADC_CALFACT_CALFACT_D_Msk      (0x7FUL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x007F0000 */
#define ADC_CALFACT_CALFACT_D          ADC_CALFACT_CALFACT_D_Msk               /*!< ADC calibration factor in differential mode */
#define ADC_CALFACT_CALFACT_D_0        (0x01UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00010000 */
#define ADC_CALFACT_CALFACT_D_1        (0x02UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00020000 */
#define ADC_CALFACT_CALFACT_D_2        (0x04UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00040000 */
#define ADC_CALFACT_CALFACT_D_3        (0x08UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00080000 */
#define ADC_CALFACT_CALFACT_D_4        (0x10UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00100000 */
#define ADC_CALFACT_CALFACT_D_5        (0x20UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00200000 */
#define ADC_CALFACT_CALFACT_D_6        (0x40UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00400000 */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  *******************/
#define ADC_CSR_ADRDY_MST_Pos          (0U)
#define ADC_CSR_ADRDY_MST_Msk          (0x1UL << ADC_CSR_ADRDY_MST_Pos)        /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST              ADC_CSR_ADRDY_MST_Msk                   /*!< ADC multimode master ready flag */
#define ADC_CSR_EOSMP_MST_Pos          (1U)
#define ADC_CSR_EOSMP_MST_Msk          (0x1UL << ADC_CSR_EOSMP_MST_Pos)        /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST              ADC_CSR_EOSMP_MST_Msk                   /*!< ADC multimode master group regular end of sampling flag */
#define ADC_CSR_EOC_MST_Pos            (2U)
#define ADC_CSR_EOC_MST_Msk            (0x1UL << ADC_CSR_EOC_MST_Pos)          /*!< 0x00000004 */
#define ADC_CSR_EOC_MST                ADC_CSR_EOC_MST_Msk                     /*!< ADC multimode master group regular end of unitary conversion flag */
#define ADC_CSR_EOS_MST_Pos            (3U)
#define ADC_CSR_EOS_MST_Msk            (0x1UL << ADC_CSR_EOS_MST_Pos)          /*!< 0x00000008 */
#define ADC_CSR_EOS_MST                ADC_CSR_EOS_MST_Msk                     /*!< ADC multimode master group regular end of sequence conversions flag */
#define ADC_CSR_OVR_MST_Pos            (4U)
#define ADC_CSR_OVR_MST_Msk            (0x1UL << ADC_CSR_OVR_MST_Pos)          /*!< 0x00000010 */
#define ADC_CSR_OVR_MST                ADC_CSR_OVR_MST_Msk                     /*!< ADC multimode master group regular overrun flag */
#define ADC_CSR_JEOC_MST_Pos           (5U)
#define ADC_CSR_JEOC_MST_Msk           (0x1UL << ADC_CSR_JEOC_MST_Pos)         /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST               ADC_CSR_JEOC_MST_Msk                    /*!< ADC multimode master group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_MST_Pos           (6U)
#define ADC_CSR_JEOS_MST_Msk           (0x1UL << ADC_CSR_JEOS_MST_Pos)         /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST               ADC_CSR_JEOS_MST_Msk                    /*!< ADC multimode master group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_MST_Pos           (7U)
#define ADC_CSR_AWD1_MST_Msk           (0x1UL << ADC_CSR_AWD1_MST_Pos)         /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST               ADC_CSR_AWD1_MST_Msk                    /*!< ADC multimode master analog watchdog 1 flag */
#define ADC_CSR_AWD2_MST_Pos           (8U)
#define ADC_CSR_AWD2_MST_Msk           (0x1UL << ADC_CSR_AWD2_MST_Pos)         /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST               ADC_CSR_AWD2_MST_Msk                    /*!< ADC multimode master analog watchdog 2 flag */
#define ADC_CSR_AWD3_MST_Pos           (9U)
#define ADC_CSR_AWD3_MST_Msk           (0x1UL << ADC_CSR_AWD3_MST_Pos)         /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST               ADC_CSR_AWD3_MST_Msk                    /*!< ADC multimode master analog watchdog 3 flag */
#define ADC_CSR_JQOVF_MST_Pos          (10U)
#define ADC_CSR_JQOVF_MST_Msk          (0x1UL << ADC_CSR_JQOVF_MST_Pos)        /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST              ADC_CSR_JQOVF_MST_Msk                   /*!< ADC multimode master group injected contexts queue overflow flag */

#define ADC_CSR_ADRDY_SLV_Pos          (16U)
#define ADC_CSR_ADRDY_SLV_Msk          (0x1UL << ADC_CSR_ADRDY_SLV_Pos)        /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV              ADC_CSR_ADRDY_SLV_Msk                   /*!< ADC multimode slave ready flag */
#define ADC_CSR_EOSMP_SLV_Pos          (17U)
#define ADC_CSR_EOSMP_SLV_Msk          (0x1UL << ADC_CSR_EOSMP_SLV_Pos)        /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV              ADC_CSR_EOSMP_SLV_Msk                   /*!< ADC multimode slave group regular end of sampling flag */
#define ADC_CSR_EOC_SLV_Pos            (18U)
#define ADC_CSR_EOC_SLV_Msk            (0x1UL << ADC_CSR_EOC_SLV_Pos)          /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV                ADC_CSR_EOC_SLV_Msk                     /*!< ADC multimode slave group regular end of unitary conversion flag */
#define ADC_CSR_EOS_SLV_Pos            (19U)
#define ADC_CSR_EOS_SLV_Msk            (0x1UL << ADC_CSR_EOS_SLV_Pos)          /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV                ADC_CSR_EOS_SLV_Msk                     /*!< ADC multimode slave group regular end of sequence conversions flag */
#define ADC_CSR_OVR_SLV_Pos            (20U)
#define ADC_CSR_OVR_SLV_Msk            (0x1UL << ADC_CSR_OVR_SLV_Pos)          /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV                ADC_CSR_OVR_SLV_Msk                     /*!< ADC multimode slave group regular overrun flag */
#define ADC_CSR_JEOC_SLV_Pos           (21U)
#define ADC_CSR_JEOC_SLV_Msk           (0x1UL << ADC_CSR_JEOC_SLV_Pos)         /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV               ADC_CSR_JEOC_SLV_Msk                    /*!< ADC multimode slave group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_SLV_Pos           (22U)
#define ADC_CSR_JEOS_SLV_Msk           (0x1UL << ADC_CSR_JEOS_SLV_Pos)         /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV               ADC_CSR_JEOS_SLV_Msk                    /*!< ADC multimode slave group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_SLV_Pos           (23U)
#define ADC_CSR_AWD1_SLV_Msk           (0x1UL << ADC_CSR_AWD1_SLV_Pos)         /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV               ADC_CSR_AWD1_SLV_Msk                    /*!< ADC multimode slave analog watchdog 1 flag */
#define ADC_CSR_AWD2_SLV_Pos           (24U)
#define ADC_CSR_AWD2_SLV_Msk           (0x1UL << ADC_CSR_AWD2_SLV_Pos)         /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV               ADC_CSR_AWD2_SLV_Msk                    /*!< ADC multimode slave analog watchdog 2 flag */
#define ADC_CSR_AWD3_SLV_Pos           (25U)
#define ADC_CSR_AWD3_SLV_Msk           (0x1UL << ADC_CSR_AWD3_SLV_Pos)         /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV               ADC_CSR_AWD3_SLV_Msk                    /*!< ADC multimode slave analog watchdog 3 flag */
#define ADC_CSR_JQOVF_SLV_Pos          (26U)
#define ADC_CSR_JQOVF_SLV_Msk          (0x1UL << ADC_CSR_JQOVF_SLV_Pos)        /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV              ADC_CSR_JQOVF_SLV_Msk                   /*!< ADC multimode slave group injected contexts queue overflow flag */

/********************  Bit definition for ADC_CCR register  *******************/
#define ADC_CCR_DUAL_Pos               (0U)
#define ADC_CCR_DUAL_Msk               (0x1FUL << ADC_CCR_DUAL_Pos)            /*!< 0x0000001F */
#define ADC_CCR_DUAL                   ADC_CCR_DUAL_Msk                        /*!< ADC multimode mode selection */
#define ADC_CCR_DUAL_0                 (0x01UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                 (0x02UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                 (0x04UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                 (0x08UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                 (0x10UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos              (8U)
#define ADC_CCR_DELAY_Msk              (0xFUL << ADC_CCR_DELAY_Pos)            /*!< 0x00000F00 */
#define ADC_CCR_DELAY                  ADC_CCR_DELAY_Msk                       /*!< ADC multimode delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                (0x1UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                (0x2UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                (0x4UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                (0x8UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000800 */

#define ADC_CCR_DMACFG_Pos             (13U)
#define ADC_CCR_DMACFG_Msk             (0x1UL << ADC_CCR_DMACFG_Pos)           /*!< 0x00002000 */
#define ADC_CCR_DMACFG                 ADC_CCR_DMACFG_Msk                      /*!< ADC multimode DMA transfer configuration */

#define ADC_CCR_MDMA_Pos               (14U)
#define ADC_CCR_MDMA_Msk               (0x3UL << ADC_CCR_MDMA_Pos)             /*!< 0x0000C000 */
#define ADC_CCR_MDMA                   ADC_CCR_MDMA_Msk                        /*!< ADC multimode DMA transfer enable */
#define ADC_CCR_MDMA_0                 (0x1UL << ADC_CCR_MDMA_Pos)             /*!< 0x00004000 */
#define ADC_CCR_MDMA_1                 (0x2UL << ADC_CCR_MDMA_Pos)             /*!< 0x00008000 */

#define ADC_CCR_CKMODE_Pos             (16U)
#define ADC_CCR_CKMODE_Msk             (0x3UL << ADC_CCR_CKMODE_Pos)           /*!< 0x00030000 */
#define ADC_CCR_CKMODE                 ADC_CCR_CKMODE_Msk                      /*!< ADC common clock source and prescaler (prescaler only for clock source synchronous) */
#define ADC_CCR_CKMODE_0               (0x1UL << ADC_CCR_CKMODE_Pos)           /*!< 0x00010000 */
#define ADC_CCR_CKMODE_1               (0x2UL << ADC_CCR_CKMODE_Pos)           /*!< 0x00020000 */

#define ADC_CCR_PRESC_Pos              (18U)
#define ADC_CCR_PRESC_Msk              (0xFUL << ADC_CCR_PRESC_Pos)            /*!< 0x003C0000 */
#define ADC_CCR_PRESC                  ADC_CCR_PRESC_Msk                       /*!< ADC common clock prescaler, only for clock source asynchronous */
#define ADC_CCR_PRESC_0                (0x1UL << ADC_CCR_PRESC_Pos)            /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                (0x2UL << ADC_CCR_PRESC_Pos)            /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                (0x4UL << ADC_CCR_PRESC_Pos)            /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                (0x8UL << ADC_CCR_PRESC_Pos)            /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos             (22U)
#define ADC_CCR_VREFEN_Msk             (0x1UL << ADC_CCR_VREFEN_Pos)           /*!< 0x00400000 */
#define ADC_CCR_VREFEN                 ADC_CCR_VREFEN_Msk                      /*!< ADC internal path to VrefInt enable */
#define ADC_CCR_TSEN_Pos               (23U)
#define ADC_CCR_TSEN_Msk               (0x1UL << ADC_CCR_TSEN_Pos)             /*!< 0x00800000 */
#define ADC_CCR_TSEN                   ADC_CCR_TSEN_Msk                        /*!< ADC internal path to temperature sensor enable */
#define ADC_CCR_VBATEN_Pos             (24U)
#define ADC_CCR_VBATEN_Msk             (0x1UL << ADC_CCR_VBATEN_Pos)           /*!< 0x01000000 */
#define ADC_CCR_VBATEN                 ADC_CCR_VBATEN_Msk                      /*!< ADC internal path to battery voltage enable */

/********************  Bit definition for ADC_CDR register  *******************/
#define ADC_CDR_RDATA_MST_Pos          (0U)
#define ADC_CDR_RDATA_MST_Msk          (0xFFFFUL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST              ADC_CDR_RDATA_MST_Msk                   /*!< ADC multimode master group regular conversion data */
#define ADC_CDR_RDATA_MST_0            (0x0001UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000001 */
#define ADC_CDR_RDATA_MST_1            (0x0002UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000002 */
#define ADC_CDR_RDATA_MST_2            (0x0004UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000004 */
#define ADC_CDR_RDATA_MST_3            (0x0008UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000008 */
#define ADC_CDR_RDATA_MST_4            (0x0010UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000010 */
#define ADC_CDR_RDATA_MST_5            (0x0020UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000020 */
#define ADC_CDR_RDATA_MST_6            (0x0040UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000040 */
#define ADC_CDR_RDATA_MST_7            (0x0080UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000080 */
#define ADC_CDR_RDATA_MST_8            (0x0100UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000100 */
#define ADC_CDR_RDATA_MST_9            (0x0200UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000200 */
#define ADC_CDR_RDATA_MST_10           (0x0400UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000400 */
#define ADC_CDR_RDATA_MST_11           (0x0800UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00000800 */
#define ADC_CDR_RDATA_MST_12           (0x1000UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00001000 */
#define ADC_CDR_RDATA_MST_13           (0x2000UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00002000 */
#define ADC_CDR_RDATA_MST_14           (0x4000UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00004000 */
#define ADC_CDR_RDATA_MST_15           (0x8000UL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x00008000 */

#define ADC_CDR_RDATA_SLV_Pos          (16U)
#define ADC_CDR_RDATA_SLV_Msk          (0xFFFFUL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV              ADC_CDR_RDATA_SLV_Msk                   /*!< ADC multimode slave group regular conversion data */
#define ADC_CDR_RDATA_SLV_0            (0x0001UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00010000 */
#define ADC_CDR_RDATA_SLV_1            (0x0002UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00020000 */
#define ADC_CDR_RDATA_SLV_2            (0x0004UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00040000 */
#define ADC_CDR_RDATA_SLV_3            (0x0008UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00080000 */
#define ADC_CDR_RDATA_SLV_4            (0x0010UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00100000 */
#define ADC_CDR_RDATA_SLV_5            (0x0020UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00200000 */
#define ADC_CDR_RDATA_SLV_6            (0x0040UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00400000 */
#define ADC_CDR_RDATA_SLV_7            (0x0080UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x00800000 */
#define ADC_CDR_RDATA_SLV_8            (0x0100UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x01000000 */
#define ADC_CDR_RDATA_SLV_9            (0x0200UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x02000000 */
#define ADC_CDR_RDATA_SLV_10           (0x0400UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x04000000 */
#define ADC_CDR_RDATA_SLV_11           (0x0800UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x08000000 */
#define ADC_CDR_RDATA_SLV_12           (0x1000UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x10000000 */
#define ADC_CDR_RDATA_SLV_13           (0x2000UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x20000000 */
#define ADC_CDR_RDATA_SLV_14           (0x4000UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x40000000 */
#define ADC_CDR_RDATA_SLV_15           (0x8000UL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0x80000000 */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos            (0U)
#define CRC_DR_DR_Msk            (0xFFFFFFFFUL << CRC_DR_DR_Pos)               /*!< 0xFFFFFFFF */
#define CRC_DR_DR                CRC_DR_DR_Msk                                 /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos          (0U)
#define CRC_IDR_IDR_Msk          (0xFFFFFFFFUL << CRC_IDR_IDR_Pos)             /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR              CRC_IDR_IDR_Msk                               /*!< General-purpose 32-bits data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos         (0U)
#define CRC_CR_RESET_Msk         (0x1UL << CRC_CR_RESET_Pos)                   /*!< 0x00000001 */
#define CRC_CR_RESET             CRC_CR_RESET_Msk                              /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos      (3U)
#define CRC_CR_POLYSIZE_Msk      (0x3UL << CRC_CR_POLYSIZE_Pos)                /*!< 0x00000018 */
#define CRC_CR_POLYSIZE          CRC_CR_POLYSIZE_Msk                           /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0        (0x1UL << CRC_CR_POLYSIZE_Pos)                /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1        (0x2UL << CRC_CR_POLYSIZE_Pos)                /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos        (5U)
#define CRC_CR_REV_IN_Msk        (0x3UL << CRC_CR_REV_IN_Pos)                  /*!< 0x00000060 */
#define CRC_CR_REV_IN            CRC_CR_REV_IN_Msk                             /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0          (0x1UL << CRC_CR_REV_IN_Pos)                  /*!< 0x00000020 */
#define CRC_CR_REV_IN_1          (0x2UL << CRC_CR_REV_IN_Pos)                  /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos       (7U)
#define CRC_CR_REV_OUT_Msk       (0x1UL << CRC_CR_REV_OUT_Pos)                 /*!< 0x00000080 */
#define CRC_CR_REV_OUT           CRC_CR_REV_OUT_Msk                            /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos        (0U)
#define CRC_INIT_INIT_Msk        (0xFFFFFFFFUL << CRC_INIT_INIT_Pos)           /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT            CRC_INIT_INIT_Msk                             /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos          (0U)
#define CRC_POL_POL_Msk          (0xFFFFFFFFUL << CRC_POL_POL_Pos)             /*!< 0xFFFFFFFF */
#define CRC_POL_POL              CRC_POL_POL_Msk                               /*!< Coefficients of the polynomial */

/******************************************************************************/
/*                                                                            */
/*                          CRS Clock Recovery System                         */
/******************************************************************************/
/*******************  Bit definition for CRS_CR register  *********************/
#define CRS_CR_SYNCOKIE_Pos       (0U)
#define CRS_CR_SYNCOKIE_Msk       (0x1UL << CRS_CR_SYNCOKIE_Pos)               /*!< 0x00000001 */
#define CRS_CR_SYNCOKIE           CRS_CR_SYNCOKIE_Msk                          /*!< SYNC event OK interrupt enable */
#define CRS_CR_SYNCWARNIE_Pos     (1U)
#define CRS_CR_SYNCWARNIE_Msk     (0x1UL << CRS_CR_SYNCWARNIE_Pos)             /*!< 0x00000002 */
#define CRS_CR_SYNCWARNIE         CRS_CR_SYNCWARNIE_Msk                        /*!< SYNC warning interrupt enable */
#define CRS_CR_ERRIE_Pos          (2U)
#define CRS_CR_ERRIE_Msk          (0x1UL << CRS_CR_ERRIE_Pos)                  /*!< 0x00000004 */
#define CRS_CR_ERRIE              CRS_CR_ERRIE_Msk                             /*!< SYNC error or trimming error interrupt enable */
#define CRS_CR_ESYNCIE_Pos        (3U)
#define CRS_CR_ESYNCIE_Msk        (0x1UL << CRS_CR_ESYNCIE_Pos)                /*!< 0x00000008 */
#define CRS_CR_ESYNCIE            CRS_CR_ESYNCIE_Msk                           /*!< Expected SYNC interrupt enable */
#define CRS_CR_CEN_Pos            (5U)
#define CRS_CR_CEN_Msk            (0x1UL << CRS_CR_CEN_Pos)                    /*!< 0x00000020 */
#define CRS_CR_CEN                CRS_CR_CEN_Msk                               /*!< Frequency error counter enable */
#define CRS_CR_AUTOTRIMEN_Pos     (6U)
#define CRS_CR_AUTOTRIMEN_Msk     (0x1UL << CRS_CR_AUTOTRIMEN_Pos)             /*!< 0x00000040 */
#define CRS_CR_AUTOTRIMEN         CRS_CR_AUTOTRIMEN_Msk                        /*!< Automatic trimming enable */
#define CRS_CR_SWSYNC_Pos         (7U)
#define CRS_CR_SWSYNC_Msk         (0x1UL << CRS_CR_SWSYNC_Pos)                 /*!< 0x00000080 */
#define CRS_CR_SWSYNC             CRS_CR_SWSYNC_Msk                            /*!< Generate software SYNC event */
#define CRS_CR_TRIM_Pos           (8U)
#define CRS_CR_TRIM_Msk           (0x7FUL << CRS_CR_TRIM_Pos)                  /*!< 0x00007F00 */
#define CRS_CR_TRIM               CRS_CR_TRIM_Msk                              /*!< HSI48 oscillator smooth trimming */

/*******************  Bit definition for CRS_CFGR register  *********************/
#define CRS_CFGR_RELOAD_Pos       (0U)
#define CRS_CFGR_RELOAD_Msk       (0xFFFFUL << CRS_CFGR_RELOAD_Pos)            /*!< 0x0000FFFF */
#define CRS_CFGR_RELOAD           CRS_CFGR_RELOAD_Msk                          /*!< Counter reload value */
#define CRS_CFGR_FELIM_Pos        (16U)
#define CRS_CFGR_FELIM_Msk        (0xFFUL << CRS_CFGR_FELIM_Pos)               /*!< 0x00FF0000 */
#define CRS_CFGR_FELIM            CRS_CFGR_FELIM_Msk                           /*!< Frequency error limit */

#define CRS_CFGR_SYNCDIV_Pos      (24U)
#define CRS_CFGR_SYNCDIV_Msk      (0x7UL << CRS_CFGR_SYNCDIV_Pos)              /*!< 0x07000000 */
#define CRS_CFGR_SYNCDIV          CRS_CFGR_SYNCDIV_Msk                         /*!< SYNC divider */
#define CRS_CFGR_SYNCDIV_0        (0x1UL << CRS_CFGR_SYNCDIV_Pos)              /*!< 0x01000000 */
#define CRS_CFGR_SYNCDIV_1        (0x2UL << CRS_CFGR_SYNCDIV_Pos)              /*!< 0x02000000 */
#define CRS_CFGR_SYNCDIV_2        (0x4UL << CRS_CFGR_SYNCDIV_Pos)              /*!< 0x04000000 */

#define CRS_CFGR_SYNCSRC_Pos      (28U)
#define CRS_CFGR_SYNCSRC_Msk      (0x3UL << CRS_CFGR_SYNCSRC_Pos)              /*!< 0x30000000 */
#define CRS_CFGR_SYNCSRC          CRS_CFGR_SYNCSRC_Msk                         /*!< SYNC signal source selection */
#define CRS_CFGR_SYNCSRC_0        (0x1UL << CRS_CFGR_SYNCSRC_Pos)              /*!< 0x10000000 */
#define CRS_CFGR_SYNCSRC_1        (0x2UL << CRS_CFGR_SYNCSRC_Pos)              /*!< 0x20000000 */

#define CRS_CFGR_SYNCPOL_Pos      (31U)
#define CRS_CFGR_SYNCPOL_Msk      (0x1UL << CRS_CFGR_SYNCPOL_Pos)              /*!< 0x80000000 */
#define CRS_CFGR_SYNCPOL          CRS_CFGR_SYNCPOL_Msk                         /*!< SYNC polarity selection */

/*******************  Bit definition for CRS_ISR register  *********************/
#define CRS_ISR_SYNCOKF_Pos       (0U)
#define CRS_ISR_SYNCOKF_Msk       (0x1UL << CRS_ISR_SYNCOKF_Pos)               /*!< 0x00000001 */
#define CRS_ISR_SYNCOKF           CRS_ISR_SYNCOKF_Msk                          /*!< SYNC event OK flag */
#define CRS_ISR_SYNCWARNF_Pos     (1U)
#define CRS_ISR_SYNCWARNF_Msk     (0x1UL << CRS_ISR_SYNCWARNF_Pos)             /*!< 0x00000002 */
#define CRS_ISR_SYNCWARNF         CRS_ISR_SYNCWARNF_Msk                        /*!< SYNC warning flag */
#define CRS_ISR_ERRF_Pos          (2U)
#define CRS_ISR_ERRF_Msk          (0x1UL << CRS_ISR_ERRF_Pos)                  /*!< 0x00000004 */
#define CRS_ISR_ERRF              CRS_ISR_ERRF_Msk                             /*!< Error flag */
#define CRS_ISR_ESYNCF_Pos        (3U)
#define CRS_ISR_ESYNCF_Msk        (0x1UL << CRS_ISR_ESYNCF_Pos)                /*!< 0x00000008 */
#define CRS_ISR_ESYNCF            CRS_ISR_ESYNCF_Msk                           /*!< Expected SYNC flag */
#define CRS_ISR_SYNCERR_Pos       (8U)
#define CRS_ISR_SYNCERR_Msk       (0x1UL << CRS_ISR_SYNCERR_Pos)               /*!< 0x00000100 */
#define CRS_ISR_SYNCERR           CRS_ISR_SYNCERR_Msk                          /*!< SYNC error */
#define CRS_ISR_SYNCMISS_Pos      (9U)
#define CRS_ISR_SYNCMISS_Msk      (0x1UL << CRS_ISR_SYNCMISS_Pos)              /*!< 0x00000200 */
#define CRS_ISR_SYNCMISS          CRS_ISR_SYNCMISS_Msk                         /*!< SYNC missed */
#define CRS_ISR_TRIMOVF_Pos       (10U)
#define CRS_ISR_TRIMOVF_Msk       (0x1UL << CRS_ISR_TRIMOVF_Pos)               /*!< 0x00000400 */
#define CRS_ISR_TRIMOVF           CRS_ISR_TRIMOVF_Msk                          /*!< Trimming overflow or underflow */
#define CRS_ISR_FEDIR_Pos         (15U)
#define CRS_ISR_FEDIR_Msk         (0x1UL << CRS_ISR_FEDIR_Pos)                 /*!< 0x00008000 */
#define CRS_ISR_FEDIR             CRS_ISR_FEDIR_Msk                            /*!< Frequency error direction */
#define CRS_ISR_FECAP_Pos         (16U)
#define CRS_ISR_FECAP_Msk         (0xFFFFUL << CRS_ISR_FECAP_Pos)              /*!< 0xFFFF0000 */
#define CRS_ISR_FECAP             CRS_ISR_FECAP_Msk                            /*!< Frequency error capture */

/*******************  Bit definition for CRS_ICR register  *********************/
#define CRS_ICR_SYNCOKC_Pos       (0U)
#define CRS_ICR_SYNCOKC_Msk       (0x1UL << CRS_ICR_SYNCOKC_Pos)               /*!< 0x00000001 */
#define CRS_ICR_SYNCOKC           CRS_ICR_SYNCOKC_Msk                          /*!< SYNC event OK clear flag */
#define CRS_ICR_SYNCWARNC_Pos     (1U)
#define CRS_ICR_SYNCWARNC_Msk     (0x1UL << CRS_ICR_SYNCWARNC_Pos)             /*!< 0x00000002 */
#define CRS_ICR_SYNCWARNC         CRS_ICR_SYNCWARNC_Msk                        /*!< SYNC warning clear flag */
#define CRS_ICR_ERRC_Pos          (2U)
#define CRS_ICR_ERRC_Msk          (0x1UL << CRS_ICR_ERRC_Pos)                  /*!< 0x00000004 */
#define CRS_ICR_ERRC              CRS_ICR_ERRC_Msk                             /*!< Error clear flag */
#define CRS_ICR_ESYNCC_Pos        (3U)
#define CRS_ICR_ESYNCC_Msk        (0x1UL << CRS_ICR_ESYNCC_Pos)                /*!< 0x00000008 */
#define CRS_ICR_ESYNCC            CRS_ICR_ESYNCC_Msk                           /*!< Expected SYNC clear flag */


/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/
/*
 * @brief Specific device feature definitions
 */
#define DAC_CHANNEL2_SUPPORT                           /*!< DAC feature available only on specific devices: DAC channel 2 available */

/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos              (0U)
#define DAC_CR_EN1_Msk              (0x1UL << DAC_CR_EN1_Pos)                  /*!< 0x00000001 */
#define DAC_CR_EN1                  DAC_CR_EN1_Msk                             /*!<DAC channel1 enable */
#define DAC_CR_TEN1_Pos             (1U)
#define DAC_CR_TEN1_Msk             (0x1UL << DAC_CR_TEN1_Pos)                 /*!< 0x00000002 */
#define DAC_CR_TEN1                 DAC_CR_TEN1_Msk                            /*!<DAC channel1 Trigger enable */

#define DAC_CR_TSEL1_Pos            (2U)
#define DAC_CR_TSEL1_Msk            (0xFUL << DAC_CR_TSEL1_Pos)                /*!< 0x0000003C */
#define DAC_CR_TSEL1                DAC_CR_TSEL1_Msk                           /*!<TSEL1[3:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0              (0x1UL << DAC_CR_TSEL1_Pos)                /*!< 0x00000004 */
#define DAC_CR_TSEL1_1              (0x2UL << DAC_CR_TSEL1_Pos)                /*!< 0x00000008 */
#define DAC_CR_TSEL1_2              (0x4UL << DAC_CR_TSEL1_Pos)                /*!< 0x00000010 */
#define DAC_CR_TSEL1_3              (0x8UL << DAC_CR_TSEL1_Pos)                /*!< 0x00000020 */

#define DAC_CR_WAVE1_Pos            (6U)
#define DAC_CR_WAVE1_Msk            (0x3UL << DAC_CR_WAVE1_Pos)                /*!< 0x000000C0 */
#define DAC_CR_WAVE1                DAC_CR_WAVE1_Msk                           /*!<WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0              (0x1UL << DAC_CR_WAVE1_Pos)                /*!< 0x00000040 */
#define DAC_CR_WAVE1_1              (0x2UL << DAC_CR_WAVE1_Pos)                /*!< 0x00000080 */

#define DAC_CR_MAMP1_Pos            (8U)
#define DAC_CR_MAMP1_Msk            (0xFUL << DAC_CR_MAMP1_Pos)                /*!< 0x00000F00 */
#define DAC_CR_MAMP1                DAC_CR_MAMP1_Msk                           /*!<MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0              (0x1UL << DAC_CR_MAMP1_Pos)                /*!< 0x00000100 */
#define DAC_CR_MAMP1_1              (0x2UL << DAC_CR_MAMP1_Pos)                /*!< 0x00000200 */
#define DAC_CR_MAMP1_2              (0x4UL << DAC_CR_MAMP1_Pos)                /*!< 0x00000400 */
#define DAC_CR_MAMP1_3              (0x8UL << DAC_CR_MAMP1_Pos)                /*!< 0x00000800 */

#define DAC_CR_DMAEN1_Pos           (12U)
#define DAC_CR_DMAEN1_Msk           (0x1UL << DAC_CR_DMAEN1_Pos)               /*!< 0x00001000 */
#define DAC_CR_DMAEN1               DAC_CR_DMAEN1_Msk                          /*!<DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos        (13U)
#define DAC_CR_DMAUDRIE1_Msk        (0x1UL << DAC_CR_DMAUDRIE1_Pos)            /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1            DAC_CR_DMAUDRIE1_Msk                       /*!<DAC channel 1 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN1_Pos             (14U)
#define DAC_CR_CEN1_Msk             (0x1UL << DAC_CR_CEN1_Pos)                 /*!< 0x00004000 */
#define DAC_CR_CEN1                 DAC_CR_CEN1_Msk                            /*!<DAC channel 1 calibration enable >*/

#define DAC_CR_HFSEL_Pos            (15U)
#define DAC_CR_HFSEL_Msk            (0x1UL << DAC_CR_HFSEL_Pos)                /*!< 0x00008000 */
#define DAC_CR_HFSEL                DAC_CR_HFSEL_Msk                           /*!<DAC channel 1 and 2 high frequency mode enable >*/

#define DAC_CR_EN2_Pos              (16U)
#define DAC_CR_EN2_Msk              (0x1UL << DAC_CR_EN2_Pos)                  /*!< 0x00010000 */
#define DAC_CR_EN2                  DAC_CR_EN2_Msk                             /*!<DAC channel2 enable */
#define DAC_CR_TEN2_Pos             (17U)
#define DAC_CR_TEN2_Msk             (0x1UL << DAC_CR_TEN2_Pos)                 /*!< 0x00020000 */
#define DAC_CR_TEN2                 DAC_CR_TEN2_Msk                            /*!<DAC channel2 Trigger enable */

#define DAC_CR_TSEL2_Pos            (18U)
#define DAC_CR_TSEL2_Msk            (0xFUL << DAC_CR_TSEL2_Pos)                /*!< 0x003C0000 */
#define DAC_CR_TSEL2                DAC_CR_TSEL2_Msk                           /*!<TSEL2[3:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0              (0x1UL << DAC_CR_TSEL2_Pos)                /*!< 0x00040000 */
#define DAC_CR_TSEL2_1              (0x2UL << DAC_CR_TSEL2_Pos)                /*!< 0x00080000 */
#define DAC_CR_TSEL2_2              (0x4UL << DAC_CR_TSEL2_Pos)                /*!< 0x00100000 */
#define DAC_CR_TSEL2_3              (0x8UL << DAC_CR_TSEL2_Pos)                /*!< 0x00200000 */

#define DAC_CR_WAVE2_Pos            (22U)
#define DAC_CR_WAVE2_Msk            (0x3UL << DAC_CR_WAVE2_Pos)                /*!< 0x00C00000 */
#define DAC_CR_WAVE2                DAC_CR_WAVE2_Msk                           /*!<WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0              (0x1UL << DAC_CR_WAVE2_Pos)                /*!< 0x00400000 */
#define DAC_CR_WAVE2_1              (0x2UL << DAC_CR_WAVE2_Pos)                /*!< 0x00800000 */

#define DAC_CR_MAMP2_Pos            (24U)
#define DAC_CR_MAMP2_Msk            (0xFUL << DAC_CR_MAMP2_Pos)                /*!< 0x0F000000 */
#define DAC_CR_MAMP2                DAC_CR_MAMP2_Msk                           /*!<MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0              (0x1UL << DAC_CR_MAMP2_Pos)                /*!< 0x01000000 */
#define DAC_CR_MAMP2_1              (0x2UL << DAC_CR_MAMP2_Pos)                /*!< 0x02000000 */
#define DAC_CR_MAMP2_2              (0x4UL << DAC_CR_MAMP2_Pos)                /*!< 0x04000000 */
#define DAC_CR_MAMP2_3              (0x8UL << DAC_CR_MAMP2_Pos)                /*!< 0x08000000 */

#define DAC_CR_DMAEN2_Pos           (28U)
#define DAC_CR_DMAEN2_Msk           (0x1UL << DAC_CR_DMAEN2_Pos)               /*!< 0x10000000 */
#define DAC_CR_DMAEN2               DAC_CR_DMAEN2_Msk                          /*!<DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos        (29U)
#define DAC_CR_DMAUDRIE2_Msk        (0x1UL << DAC_CR_DMAUDRIE2_Pos)            /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2            DAC_CR_DMAUDRIE2_Msk                       /*!<DAC channel2 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN2_Pos             (30U)
#define DAC_CR_CEN2_Msk             (0x1UL << DAC_CR_CEN2_Pos)                 /*!< 0x40000000 */
#define DAC_CR_CEN2                 DAC_CR_CEN2_Msk                            /*!<DAC channel2 calibration enable >*/

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1_Pos     (0U)
#define DAC_SWTRIGR_SWTRIG1_Msk     (0x1UL << DAC_SWTRIGR_SWTRIG1_Pos)         /*!< 0x00000001 */
#define DAC_SWTRIGR_SWTRIG1         DAC_SWTRIGR_SWTRIG1_Msk                    /*!<DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2_Pos     (1U)
#define DAC_SWTRIGR_SWTRIG2_Msk     (0x1UL << DAC_SWTRIGR_SWTRIG2_Pos)         /*!< 0x00000002 */
#define DAC_SWTRIGR_SWTRIG2         DAC_SWTRIGR_SWTRIG2_Msk                    /*!<DAC channel2 software trigger */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR_Pos    (0U)
#define DAC_DHR12R1_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12R1_DACC1DHR_Pos)      /*!< 0x00000FFF */
#define DAC_DHR12R1_DACC1DHR        DAC_DHR12R1_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR_Pos    (4U)
#define DAC_DHR12L1_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12L1_DACC1DHR_Pos)      /*!< 0x0000FFF0 */
#define DAC_DHR12L1_DACC1DHR        DAC_DHR12L1_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR_Pos     (0U)
#define DAC_DHR8R1_DACC1DHR_Msk     (0xFFUL << DAC_DHR8R1_DACC1DHR_Pos)        /*!< 0x000000FF */
#define DAC_DHR8R1_DACC1DHR         DAC_DHR8R1_DACC1DHR_Msk                    /*!<DAC channel1 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR_Pos    (0U)
#define DAC_DHR12R2_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12R2_DACC2DHR_Pos)      /*!< 0x00000FFF */
#define DAC_DHR12R2_DACC2DHR        DAC_DHR12R2_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR_Pos    (4U)
#define DAC_DHR12L2_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12L2_DACC2DHR_Pos)      /*!< 0x0000FFF0 */
#define DAC_DHR12L2_DACC2DHR        DAC_DHR12L2_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR_Pos     (0U)
#define DAC_DHR8R2_DACC2DHR_Msk     (0xFFUL << DAC_DHR8R2_DACC2DHR_Pos)        /*!< 0x000000FF */
#define DAC_DHR8R2_DACC2DHR         DAC_DHR8R2_DACC2DHR_Msk                    /*!<DAC channel2 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos    (0U)
#define DAC_DHR12RD_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12RD_DACC1DHR_Pos)      /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR        DAC_DHR12RD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos    (16U)
#define DAC_DHR12RD_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12RD_DACC2DHR_Pos)      /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR        DAC_DHR12RD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos    (4U)
#define DAC_DHR12LD_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12LD_DACC1DHR_Pos)      /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR        DAC_DHR12LD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos    (20U)
#define DAC_DHR12LD_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12LD_DACC2DHR_Pos)      /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR        DAC_DHR12LD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos     (0U)
#define DAC_DHR8RD_DACC1DHR_Msk     (0xFFUL << DAC_DHR8RD_DACC1DHR_Pos)        /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR         DAC_DHR8RD_DACC1DHR_Msk                    /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos     (8U)
#define DAC_DHR8RD_DACC2DHR_Msk     (0xFFUL << DAC_DHR8RD_DACC2DHR_Pos)        /*!< 0x0000FF00 */
#define DAC_DHR8RD_DACC2DHR         DAC_DHR8RD_DACC2DHR_Msk                    /*!<DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR_Pos       (0U)
#define DAC_DOR1_DACC1DOR_Msk       (0xFFFUL << DAC_DOR1_DACC1DOR_Pos)         /*!< 0x00000FFF */
#define DAC_DOR1_DACC1DOR           DAC_DOR1_DACC1DOR_Msk                      /*!<DAC channel1 data output */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR_Pos       (0U)
#define DAC_DOR2_DACC2DOR_Msk       (0xFFFUL << DAC_DOR2_DACC2DOR_Pos)         /*!< 0x00000FFF */
#define DAC_DOR2_DACC2DOR           DAC_DOR2_DACC2DOR_Msk                      /*!<DAC channel2 data output */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DMAUDR1_Pos          (13U)
#define DAC_SR_DMAUDR1_Msk          (0x1UL << DAC_SR_DMAUDR1_Pos)              /*!< 0x00002000 */
#define DAC_SR_DMAUDR1              DAC_SR_DMAUDR1_Msk                         /*!<DAC channel1 DMA underrun flag */
#define DAC_SR_CAL_FLAG1_Pos        (14U)
#define DAC_SR_CAL_FLAG1_Msk        (0x1UL << DAC_SR_CAL_FLAG1_Pos)            /*!< 0x00004000 */
#define DAC_SR_CAL_FLAG1            DAC_SR_CAL_FLAG1_Msk                       /*!<DAC channel1 calibration offset status */
#define DAC_SR_BWST1_Pos            (15U)
#define DAC_SR_BWST1_Msk            (0x1UL << DAC_SR_BWST1_Pos)                /*!< 0x00008000 */
#define DAC_SR_BWST1                DAC_SR_BWST1_Msk                           /*!<DAC channel1 busy writing sample time flag */

#define DAC_SR_DMAUDR2_Pos          (29U)
#define DAC_SR_DMAUDR2_Msk          (0x1UL << DAC_SR_DMAUDR2_Pos)              /*!< 0x20000000 */
#define DAC_SR_DMAUDR2              DAC_SR_DMAUDR2_Msk                         /*!<DAC channel2 DMA underrun flag */
#define DAC_SR_CAL_FLAG2_Pos        (30U)
#define DAC_SR_CAL_FLAG2_Msk        (0x1UL << DAC_SR_CAL_FLAG2_Pos)            /*!< 0x40000000 */
#define DAC_SR_CAL_FLAG2            DAC_SR_CAL_FLAG2_Msk                       /*!<DAC channel2 calibration offset status */
#define DAC_SR_BWST2_Pos            (31U)
#define DAC_SR_BWST2_Msk            (0x1UL << DAC_SR_BWST2_Pos)                /*!< 0x80000000 */
#define DAC_SR_BWST2                DAC_SR_BWST2_Msk                           /*!<DAC channel2 busy writing sample time flag */

/*******************  Bit definition for DAC_CCR register  ********************/
#define DAC_CCR_OTRIM1_Pos          (0U)
#define DAC_CCR_OTRIM1_Msk          (0x1FUL << DAC_CCR_OTRIM1_Pos)             /*!< 0x0000001F */
#define DAC_CCR_OTRIM1              DAC_CCR_OTRIM1_Msk                         /*!<DAC channel1 offset trimming value */
#define DAC_CCR_OTRIM2_Pos          (16U)
#define DAC_CCR_OTRIM2_Msk          (0x1FUL << DAC_CCR_OTRIM2_Pos)             /*!< 0x001F0000 */
#define DAC_CCR_OTRIM2              DAC_CCR_OTRIM2_Msk                         /*!<DAC channel2 offset trimming value */

/*******************  Bit definition for DAC_MCR register  *******************/
#define DAC_MCR_MODE1_Pos           (0U)
#define DAC_MCR_MODE1_Msk           (0x7UL << DAC_MCR_MODE1_Pos)               /*!< 0x00000007 */
#define DAC_MCR_MODE1               DAC_MCR_MODE1_Msk                          /*!<MODE1[2:0] (DAC channel1 mode) */
#define DAC_MCR_MODE1_0             (0x1UL << DAC_MCR_MODE1_Pos)               /*!< 0x00000001 */
#define DAC_MCR_MODE1_1             (0x2UL << DAC_MCR_MODE1_Pos)               /*!< 0x00000002 */
#define DAC_MCR_MODE1_2             (0x4UL << DAC_MCR_MODE1_Pos)               /*!< 0x00000004 */

#define DAC_MCR_MODE2_Pos           (16U)
#define DAC_MCR_MODE2_Msk           (0x7UL << DAC_MCR_MODE2_Pos)               /*!< 0x00070000 */
#define DAC_MCR_MODE2               DAC_MCR_MODE2_Msk                          /*!<MODE2[2:0] (DAC channel2 mode) */
#define DAC_MCR_MODE2_0             (0x1UL << DAC_MCR_MODE2_Pos)               /*!< 0x00010000 */
#define DAC_MCR_MODE2_1             (0x2UL << DAC_MCR_MODE2_Pos)               /*!< 0x00020000 */
#define DAC_MCR_MODE2_2             (0x4UL << DAC_MCR_MODE2_Pos)               /*!< 0x00040000 */

/******************  Bit definition for DAC_SHSR1 register  ******************/
#define DAC_SHSR1_TSAMPLE1_Pos      (0U)
#define DAC_SHSR1_TSAMPLE1_Msk      (0x3FFUL << DAC_SHSR1_TSAMPLE1_Pos)        /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE1          DAC_SHSR1_TSAMPLE1_Msk                     /*!<DAC channel1 sample time */

/******************  Bit definition for DAC_SHSR2 register  ******************/
#define DAC_SHSR2_TSAMPLE2_Pos      (0U)
#define DAC_SHSR2_TSAMPLE2_Msk      (0x3FFUL << DAC_SHSR2_TSAMPLE2_Pos)        /*!< 0x000003FF */
#define DAC_SHSR2_TSAMPLE2          DAC_SHSR2_TSAMPLE2_Msk                     /*!<DAC channel2 sample time */

/******************  Bit definition for DAC_SHHR register  ******************/
#define DAC_SHHR_THOLD1_Pos         (0U)
#define DAC_SHHR_THOLD1_Msk         (0x3FFUL << DAC_SHHR_THOLD1_Pos)           /*!< 0x000003FF */
#define DAC_SHHR_THOLD1             DAC_SHHR_THOLD1_Msk                        /*!<DAC channel1 hold time */
#define DAC_SHHR_THOLD2_Pos         (16U)
#define DAC_SHHR_THOLD2_Msk         (0x3FFUL << DAC_SHHR_THOLD2_Pos)           /*!< 0x03FF0000 */
#define DAC_SHHR_THOLD2             DAC_SHHR_THOLD2_Msk                        /*!<DAC channel2 hold time */

/******************  Bit definition for DAC_SHRR register  ******************/
#define DAC_SHRR_TREFRESH1_Pos      (0U)
#define DAC_SHRR_TREFRESH1_Msk      (0xFFUL << DAC_SHRR_TREFRESH1_Pos)         /*!< 0x000000FF */
#define DAC_SHRR_TREFRESH1          DAC_SHRR_TREFRESH1_Msk                     /*!<DAC channel1 refresh time */
#define DAC_SHRR_TREFRESH2_Pos      (16U)
#define DAC_SHRR_TREFRESH2_Msk      (0xFFUL << DAC_SHRR_TREFRESH2_Pos)         /*!< 0x00FF0000 */
#define DAC_SHRR_TREFRESH2          DAC_SHRR_TREFRESH2_Msk                     /*!<DAC channel2 refresh time */

/******************************************************************************/
/*                                                                            */
/*                                 Debug MCU                                  */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos               (0U)
#define DBGMCU_IDCODE_DEV_ID_Msk               (0xFFFUL << DBGMCU_IDCODE_DEV_ID_Pos)/*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                   DBGMCU_IDCODE_DEV_ID_Msk
#define DBGMCU_IDCODE_REV_ID_Pos               (16U)
#define DBGMCU_IDCODE_REV_ID_Msk               (0xFFFFUL << DBGMCU_IDCODE_REV_ID_Pos)/*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                   DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_CR register  *****************/
#define DBGMCU_CR_DBG_STOP_Pos                 (1U)
#define DBGMCU_CR_DBG_STOP_Msk                 (0x1UL << DBGMCU_CR_DBG_STOP_Pos)/*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                     DBGMCU_CR_DBG_STOP_Msk
#define DBGMCU_CR_DBG_STANDBY_Pos              (2U)
#define DBGMCU_CR_DBG_STANDBY_Msk              (0x1UL << DBGMCU_CR_DBG_STANDBY_Pos)/*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY                  DBGMCU_CR_DBG_STANDBY_Msk
#define DBGMCU_CR_TRACE_IOEN_Pos               (4U)
#define DBGMCU_CR_TRACE_IOEN_Msk               (0x1UL << DBGMCU_CR_TRACE_IOEN_Pos)/*!< 0x00000010 */
#define DBGMCU_CR_TRACE_IOEN                   DBGMCU_CR_TRACE_IOEN_Msk
#define DBGMCU_CR_TRACE_EN_Pos                 (5U)
#define DBGMCU_CR_TRACE_EN_Msk                 (0x1UL << DBGMCU_CR_TRACE_EN_Pos)/*!< 0x00000020 */
#define DBGMCU_CR_TRACE_EN                     DBGMCU_CR_TRACE_EN_Msk

#define DBGMCU_CR_TRACE_MODE_Pos               (6U)
#define DBGMCU_CR_TRACE_MODE_Msk               (0x3UL << DBGMCU_CR_TRACE_MODE_Pos)/*!< 0x000000C0 */
#define DBGMCU_CR_TRACE_MODE                   DBGMCU_CR_TRACE_MODE_Msk
#define DBGMCU_CR_TRACE_MODE_0                 (0x1UL << DBGMCU_CR_TRACE_MODE_Pos)/*!< 0x00000040 */
#define DBGMCU_CR_TRACE_MODE_1                 (0x2UL << DBGMCU_CR_TRACE_MODE_Pos)/*!< 0x00000080 */

/********************  Bit definition for DBGMCU_APB1FZR1 register  ***********/
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos      (0U)
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos)/*!< 0x00000001 */
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP          DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos      (1U)
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos)/*!< 0x00000002 */
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP          DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos      (2U)
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos)/*!< 0x00000004 */
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP          DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP_Pos      (3U)
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_TIM5_STOP_Pos)/*!< 0x00000008 */
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP          DBGMCU_APB1FZR1_DBG_TIM5_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos      (4U)
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos)/*!< 0x00000010 */
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP          DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos      (5U)
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos)/*!< 0x00000020 */
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP          DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_RTC_STOP_Pos       (10U)
#define DBGMCU_APB1FZR1_DBG_RTC_STOP_Msk       (0x1UL << DBGMCU_APB1FZR1_DBG_RTC_STOP_Pos)/*!< 0x00000400 */
#define DBGMCU_APB1FZR1_DBG_RTC_STOP           DBGMCU_APB1FZR1_DBG_RTC_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos      (11U)
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos)/*!< 0x00000800 */
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP          DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos      (12U)
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos)/*!< 0x00001000 */
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP          DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos      (21U)
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos)/*!< 0x00200000 */
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP          DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos      (22U)
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos)/*!< 0x00400000 */
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP          DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C3_STOP_Pos      (23U)
#define DBGMCU_APB1FZR1_DBG_I2C3_STOP_Msk      (0x1UL << DBGMCU_APB1FZR1_DBG_I2C3_STOP_Pos)/*!< 0x00800000 */
#define DBGMCU_APB1FZR1_DBG_I2C3_STOP          DBGMCU_APB1FZR1_DBG_I2C3_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_FDCAN1_STOP_Pos    (25U)
#define DBGMCU_APB1FZR1_DBG_FDCAN1_STOP_Msk    (0x1UL << DBGMCU_APB1FZR1_DBG_FDCAN1_STOP_Pos)/*!< 0x02000000 */
#define DBGMCU_APB1FZR1_DBG_FDCAN1_STOP        DBGMCU_APB1FZR1_DBG_FDCAN1_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_LPTIM1_STOP_Pos    (31U)
#define DBGMCU_APB1FZR1_DBG_LPTIM1_STOP_Msk    (0x1UL << DBGMCU_APB1FZR1_DBG_LPTIM1_STOP_Pos)/*!< 0x80000000 */
#define DBGMCU_APB1FZR1_DBG_LPTIM1_STOP        DBGMCU_APB1FZR1_DBG_LPTIM1_STOP_Msk

/********************  Bit definition for DBGMCU_APB1FZR2 register  **********/
#define DBGMCU_APB1FZR2_DBG_I2C4_STOP_Pos      (1U)
#define DBGMCU_APB1FZR2_DBG_I2C4_STOP_Msk      (0x1UL << DBGMCU_APB1FZR2_DBG_I2C4_STOP_Pos)/*!< 0x00000002 */
#define DBGMCU_APB1FZR2_DBG_I2C4_STOP          DBGMCU_APB1FZR2_DBG_I2C4_STOP_Msk
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos    (5U)
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk    (0x1UL << DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos)/*!< 0x00000020 */
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP        DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk
#define DBGMCU_APB1FZR2_DBG_LPTIM3_STOP_Pos    (6U)
#define DBGMCU_APB1FZR2_DBG_LPTIM3_STOP_Msk    (0x1UL << DBGMCU_APB1FZR2_DBG_LPTIM3_STOP_Pos)/*!< 0x00000040 */
#define DBGMCU_APB1FZR2_DBG_LPTIM3_STOP        DBGMCU_APB1FZR2_DBG_LPTIM3_STOP_Msk

/********************  Bit definition for DBGMCU_APB2FZ register  ************/
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos       (11U)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk       (0x1UL << DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos)/*!< 0x00000800 */
#define DBGMCU_APB2FZR_DBG_TIM1_STOP           DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM8_STOP_Pos       (13U)
#define DBGMCU_APB2FZR_DBG_TIM8_STOP_Msk       (0x1UL << DBGMCU_APB2FZR_DBG_TIM8_STOP_Pos)/*!< 0x00002000 */
#define DBGMCU_APB2FZR_DBG_TIM8_STOP           DBGMCU_APB2FZR_DBG_TIM8_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos      (16U)
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk      (0x1UL << DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos)/*!< 0x00010000 */
#define DBGMCU_APB2FZR_DBG_TIM15_STOP          DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos      (17U)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk      (0x1UL << DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos)/*!< 0x00020000 */
#define DBGMCU_APB2FZR_DBG_TIM16_STOP          DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos      (18U)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk      (0x1UL << DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos)/*!< 0x00040000 */
#define DBGMCU_APB2FZR_DBG_TIM17_STOP          DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk

/******************************************************************************/
/*                                                                            */
/*                 Digital Filter for Sigma Delta Modulators                  */
/*                                                                            */
/******************************************************************************/

/****************   DFSDM channel configuration registers  ********************/

/***************  Bit definition for DFSDM_CHCFGR1 register  ******************/
#define DFSDM_CHCFGR1_DFSDMEN_Pos       (31U)
#define DFSDM_CHCFGR1_DFSDMEN_Msk       (0x1UL << DFSDM_CHCFGR1_DFSDMEN_Pos)   /*!< 0x80000000 */
#define DFSDM_CHCFGR1_DFSDMEN           DFSDM_CHCFGR1_DFSDMEN_Msk              /*!< Global enable for DFSDM interface */
#define DFSDM_CHCFGR1_CKOUTSRC_Pos      (30U)
#define DFSDM_CHCFGR1_CKOUTSRC_Msk      (0x1UL << DFSDM_CHCFGR1_CKOUTSRC_Pos)  /*!< 0x40000000 */
#define DFSDM_CHCFGR1_CKOUTSRC          DFSDM_CHCFGR1_CKOUTSRC_Msk             /*!< Output serial clock source selection */
#define DFSDM_CHCFGR1_CKOUTDIV_Pos      (16U)
#define DFSDM_CHCFGR1_CKOUTDIV_Msk      (0xFFUL << DFSDM_CHCFGR1_CKOUTDIV_Pos) /*!< 0x00FF0000 */
#define DFSDM_CHCFGR1_CKOUTDIV          DFSDM_CHCFGR1_CKOUTDIV_Msk             /*!< CKOUTDIV[7:0] output serial clock divider */
#define DFSDM_CHCFGR1_DATPACK_Pos       (14U)
#define DFSDM_CHCFGR1_DATPACK_Msk       (0x3UL << DFSDM_CHCFGR1_DATPACK_Pos)   /*!< 0x0000C000 */
#define DFSDM_CHCFGR1_DATPACK           DFSDM_CHCFGR1_DATPACK_Msk              /*!< DATPACK[1:0] Data packing mode */
#define DFSDM_CHCFGR1_DATPACK_1         (0x2UL << DFSDM_CHCFGR1_DATPACK_Pos)   /*!< 0x00008000 */
#define DFSDM_CHCFGR1_DATPACK_0         (0x1UL << DFSDM_CHCFGR1_DATPACK_Pos)   /*!< 0x00004000 */
#define DFSDM_CHCFGR1_DATMPX_Pos        (12U)
#define DFSDM_CHCFGR1_DATMPX_Msk        (0x3UL << DFSDM_CHCFGR1_DATMPX_Pos)    /*!< 0x00003000 */
#define DFSDM_CHCFGR1_DATMPX            DFSDM_CHCFGR1_DATMPX_Msk               /*!< DATMPX[1:0] Input data multiplexer for channel y */
#define DFSDM_CHCFGR1_DATMPX_1          (0x2UL << DFSDM_CHCFGR1_DATMPX_Pos)    /*!< 0x00002000 */
#define DFSDM_CHCFGR1_DATMPX_0          (0x1UL << DFSDM_CHCFGR1_DATMPX_Pos)    /*!< 0x00001000 */
#define DFSDM_CHCFGR1_CHINSEL_Pos       (8U)
#define DFSDM_CHCFGR1_CHINSEL_Msk       (0x1UL << DFSDM_CHCFGR1_CHINSEL_Pos)   /*!< 0x00000100 */
#define DFSDM_CHCFGR1_CHINSEL           DFSDM_CHCFGR1_CHINSEL_Msk              /*!< Serial inputs selection for channel y */
#define DFSDM_CHCFGR1_CHEN_Pos          (7U)
#define DFSDM_CHCFGR1_CHEN_Msk          (0x1UL << DFSDM_CHCFGR1_CHEN_Pos)      /*!< 0x00000080 */
#define DFSDM_CHCFGR1_CHEN              DFSDM_CHCFGR1_CHEN_Msk                 /*!< Channel y enable */
#define DFSDM_CHCFGR1_CKABEN_Pos        (6U)
#define DFSDM_CHCFGR1_CKABEN_Msk        (0x1UL << DFSDM_CHCFGR1_CKABEN_Pos)    /*!< 0x00000040 */
#define DFSDM_CHCFGR1_CKABEN            DFSDM_CHCFGR1_CKABEN_Msk               /*!< Clock absence detector enable on channel y */
#define DFSDM_CHCFGR1_SCDEN_Pos         (5U)
#define DFSDM_CHCFGR1_SCDEN_Msk         (0x1UL << DFSDM_CHCFGR1_SCDEN_Pos)     /*!< 0x00000020 */
#define DFSDM_CHCFGR1_SCDEN             DFSDM_CHCFGR1_SCDEN_Msk                /*!< Short circuit detector enable on channel y */
#define DFSDM_CHCFGR1_SPICKSEL_Pos      (2U)
#define DFSDM_CHCFGR1_SPICKSEL_Msk      (0x3UL << DFSDM_CHCFGR1_SPICKSEL_Pos)  /*!< 0x0000000C */
#define DFSDM_CHCFGR1_SPICKSEL          DFSDM_CHCFGR1_SPICKSEL_Msk             /*!< SPICKSEL[1:0] SPI clock select for channel y */
#define DFSDM_CHCFGR1_SPICKSEL_1        (0x2UL << DFSDM_CHCFGR1_SPICKSEL_Pos)  /*!< 0x00000008 */
#define DFSDM_CHCFGR1_SPICKSEL_0        (0x1UL << DFSDM_CHCFGR1_SPICKSEL_Pos)  /*!< 0x00000004 */
#define DFSDM_CHCFGR1_SITP_Pos          (0U)
#define DFSDM_CHCFGR1_SITP_Msk          (0x3UL << DFSDM_CHCFGR1_SITP_Pos)      /*!< 0x00000003 */
#define DFSDM_CHCFGR1_SITP              DFSDM_CHCFGR1_SITP_Msk                 /*!< SITP[1:0] Serial interface type for channel y */
#define DFSDM_CHCFGR1_SITP_1            (0x2UL << DFSDM_CHCFGR1_SITP_Pos)      /*!< 0x00000002 */
#define DFSDM_CHCFGR1_SITP_0            (0x1UL << DFSDM_CHCFGR1_SITP_Pos)      /*!< 0x00000001 */

/***************  Bit definition for DFSDM_CHCFGR2 register  ******************/
#define DFSDM_CHCFGR2_OFFSET_Pos        (8U)
#define DFSDM_CHCFGR2_OFFSET_Msk        (0xFFFFFFUL << DFSDM_CHCFGR2_OFFSET_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_CHCFGR2_OFFSET            DFSDM_CHCFGR2_OFFSET_Msk               /*!< OFFSET[23:0] 24-bit calibration offset for channel y */
#define DFSDM_CHCFGR2_DTRBS_Pos         (3U)
#define DFSDM_CHCFGR2_DTRBS_Msk         (0x1FUL << DFSDM_CHCFGR2_DTRBS_Pos)    /*!< 0x000000F8 */
#define DFSDM_CHCFGR2_DTRBS             DFSDM_CHCFGR2_DTRBS_Msk                /*!< DTRBS[4:0] Data right bit-shift for channel y */

/****************  Bit definition for DFSDM_CHAWSCDR register *****************/
#define DFSDM_CHAWSCDR_AWFORD_Pos       (22U)
#define DFSDM_CHAWSCDR_AWFORD_Msk       (0x3UL << DFSDM_CHAWSCDR_AWFORD_Pos)   /*!< 0x00C00000 */
#define DFSDM_CHAWSCDR_AWFORD           DFSDM_CHAWSCDR_AWFORD_Msk              /*!< AWFORD[1:0] Analog watchdog Sinc filter order on channel y */
#define DFSDM_CHAWSCDR_AWFORD_1         (0x2UL << DFSDM_CHAWSCDR_AWFORD_Pos)   /*!< 0x00800000 */
#define DFSDM_CHAWSCDR_AWFORD_0         (0x1UL << DFSDM_CHAWSCDR_AWFORD_Pos)   /*!< 0x00400000 */
#define DFSDM_CHAWSCDR_AWFOSR_Pos       (16U)
#define DFSDM_CHAWSCDR_AWFOSR_Msk       (0x1FUL << DFSDM_CHAWSCDR_AWFOSR_Pos)  /*!< 0x001F0000 */
#define DFSDM_CHAWSCDR_AWFOSR           DFSDM_CHAWSCDR_AWFOSR_Msk              /*!< AWFOSR[4:0] Analog watchdog filter oversampling ratio on channel y */
#define DFSDM_CHAWSCDR_BKSCD_Pos        (12U)
#define DFSDM_CHAWSCDR_BKSCD_Msk        (0xFUL << DFSDM_CHAWSCDR_BKSCD_Pos)    /*!< 0x0000F000 */
#define DFSDM_CHAWSCDR_BKSCD            DFSDM_CHAWSCDR_BKSCD_Msk               /*!< BKSCD[3:0] Break signal assignment for short circuit detector on channel y */
#define DFSDM_CHAWSCDR_SCDT_Pos         (0U)
#define DFSDM_CHAWSCDR_SCDT_Msk         (0xFFUL << DFSDM_CHAWSCDR_SCDT_Pos)    /*!< 0x000000FF */
#define DFSDM_CHAWSCDR_SCDT             DFSDM_CHAWSCDR_SCDT_Msk                /*!< SCDT[7:0] Short circuit detector threshold for channel y */

/****************  Bit definition for DFSDM_CHWDATR register *******************/
#define DFSDM_CHWDATR_WDATA_Pos         (0U)
#define DFSDM_CHWDATR_WDATA_Msk         (0xFFFFUL << DFSDM_CHWDATR_WDATA_Pos)  /*!< 0x0000FFFF */
#define DFSDM_CHWDATR_WDATA             DFSDM_CHWDATR_WDATA_Msk                /*!< WDATA[15:0] Input channel y watchdog data */

/****************  Bit definition for DFSDM_CHDATINR register *****************/
#define DFSDM_CHDATINR_INDAT0_Pos       (0U)
#define DFSDM_CHDATINR_INDAT0_Msk       (0xFFFFUL << DFSDM_CHDATINR_INDAT0_Pos)/*!< 0x0000FFFF */
#define DFSDM_CHDATINR_INDAT0           DFSDM_CHDATINR_INDAT0_Msk              /*!< INDAT0[31:16] Input data for channel y or channel (y+1) */
#define DFSDM_CHDATINR_INDAT1_Pos       (16U)
#define DFSDM_CHDATINR_INDAT1_Msk       (0xFFFFUL << DFSDM_CHDATINR_INDAT1_Pos)/*!< 0xFFFF0000 */
#define DFSDM_CHDATINR_INDAT1           DFSDM_CHDATINR_INDAT1_Msk              /*!< INDAT0[15:0] Input data for channel y */

/****************  Bit definition for DFSDM_CHDLYR register *******************/
#define DFSDM_CHDLYR_PLSSKP_Pos         (0U)
#define DFSDM_CHDLYR_PLSSKP_Msk         (0x3FUL << DFSDM_CHDLYR_PLSSKP_Pos)    /*!< 0x0000003F */
#define DFSDM_CHDLYR_PLSSKP             DFSDM_CHDLYR_PLSSKP_Msk                /*!< PLSSKP[5:0] Number of input serial samples that will be skipped */

/************************   DFSDM module registers  ****************************/

/*****************  Bit definition for DFSDM_FLTCR1 register *******************/
#define DFSDM_FLTCR1_AWFSEL_Pos         (30U)
#define DFSDM_FLTCR1_AWFSEL_Msk         (0x1UL << DFSDM_FLTCR1_AWFSEL_Pos)     /*!< 0x40000000 */
#define DFSDM_FLTCR1_AWFSEL             DFSDM_FLTCR1_AWFSEL_Msk                /*!< Analog watchdog fast mode select */
#define DFSDM_FLTCR1_FAST_Pos           (29U)
#define DFSDM_FLTCR1_FAST_Msk           (0x1UL << DFSDM_FLTCR1_FAST_Pos)       /*!< 0x20000000 */
#define DFSDM_FLTCR1_FAST               DFSDM_FLTCR1_FAST_Msk                  /*!< Fast conversion mode selection */
#define DFSDM_FLTCR1_RCH_Pos            (24U)
#define DFSDM_FLTCR1_RCH_Msk            (0x7UL << DFSDM_FLTCR1_RCH_Pos)        /*!< 0x07000000 */
#define DFSDM_FLTCR1_RCH                DFSDM_FLTCR1_RCH_Msk                   /*!< RCH[2:0] Regular channel selection */
#define DFSDM_FLTCR1_RDMAEN_Pos         (21U)
#define DFSDM_FLTCR1_RDMAEN_Msk         (0x1UL << DFSDM_FLTCR1_RDMAEN_Pos)     /*!< 0x00200000 */
#define DFSDM_FLTCR1_RDMAEN             DFSDM_FLTCR1_RDMAEN_Msk                /*!< DMA channel enabled to read data for the regular conversion */
#define DFSDM_FLTCR1_RSYNC_Pos          (19U)
#define DFSDM_FLTCR1_RSYNC_Msk          (0x1UL << DFSDM_FLTCR1_RSYNC_Pos)      /*!< 0x00080000 */
#define DFSDM_FLTCR1_RSYNC              DFSDM_FLTCR1_RSYNC_Msk                 /*!< Launch regular conversion synchronously with DFSDMx */
#define DFSDM_FLTCR1_RCONT_Pos          (18U)
#define DFSDM_FLTCR1_RCONT_Msk          (0x1UL << DFSDM_FLTCR1_RCONT_Pos)      /*!< 0x00040000 */
#define DFSDM_FLTCR1_RCONT              DFSDM_FLTCR1_RCONT_Msk                 /*!< Continuous mode selection for regular conversions */
#define DFSDM_FLTCR1_RSWSTART_Pos       (17U)
#define DFSDM_FLTCR1_RSWSTART_Msk       (0x1UL << DFSDM_FLTCR1_RSWSTART_Pos)   /*!< 0x00020000 */
#define DFSDM_FLTCR1_RSWSTART           DFSDM_FLTCR1_RSWSTART_Msk              /*!< Software start of a conversion on the regular channel */
#define DFSDM_FLTCR1_JEXTEN_Pos         (13U)
#define DFSDM_FLTCR1_JEXTEN_Msk         (0x3UL << DFSDM_FLTCR1_JEXTEN_Pos)     /*!< 0x00006000 */
#define DFSDM_FLTCR1_JEXTEN             DFSDM_FLTCR1_JEXTEN_Msk                /*!< JEXTEN[1:0] Trigger enable and trigger edge selection for injected conversions */
#define DFSDM_FLTCR1_JEXTEN_1           (0x2UL << DFSDM_FLTCR1_JEXTEN_Pos)     /*!< 0x00004000 */
#define DFSDM_FLTCR1_JEXTEN_0           (0x1UL << DFSDM_FLTCR1_JEXTEN_Pos)     /*!< 0x00002000 */
#define DFSDM_FLTCR1_JEXTSEL_Pos        (8U)
#define DFSDM_FLTCR1_JEXTSEL_Msk        (0x1FUL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00001F00 */
#define DFSDM_FLTCR1_JEXTSEL            DFSDM_FLTCR1_JEXTSEL_Msk               /*!< JEXTSEL[4:0]Trigger signal selection for launching injected conversions */
#define DFSDM_FLTCR1_JEXTSEL_4          (0x10UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00001000 */
#define DFSDM_FLTCR1_JEXTSEL_3          (0x08UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000800 */
#define DFSDM_FLTCR1_JEXTSEL_2          (0x04UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000400 */
#define DFSDM_FLTCR1_JEXTSEL_1          (0x02UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000200 */
#define DFSDM_FLTCR1_JEXTSEL_0          (0x01UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000100 */
#define DFSDM_FLTCR1_JDMAEN_Pos         (5U)
#define DFSDM_FLTCR1_JDMAEN_Msk         (0x1UL << DFSDM_FLTCR1_JDMAEN_Pos)     /*!< 0x00000020 */
#define DFSDM_FLTCR1_JDMAEN             DFSDM_FLTCR1_JDMAEN_Msk                /*!< DMA channel enabled to read data for the injected channel group */
#define DFSDM_FLTCR1_JSCAN_Pos          (4U)
#define DFSDM_FLTCR1_JSCAN_Msk          (0x1UL << DFSDM_FLTCR1_JSCAN_Pos)      /*!< 0x00000010 */
#define DFSDM_FLTCR1_JSCAN              DFSDM_FLTCR1_JSCAN_Msk                 /*!< Scanning conversion in continuous mode selection for injected conversions */
#define DFSDM_FLTCR1_JSYNC_Pos          (3U)
#define DFSDM_FLTCR1_JSYNC_Msk          (0x1UL << DFSDM_FLTCR1_JSYNC_Pos)      /*!< 0x00000008 */
#define DFSDM_FLTCR1_JSYNC              DFSDM_FLTCR1_JSYNC_Msk                 /*!< Launch an injected conversion synchronously with DFSDMx JSWSTART trigger  */
#define DFSDM_FLTCR1_JSWSTART_Pos       (1U)
#define DFSDM_FLTCR1_JSWSTART_Msk       (0x1UL << DFSDM_FLTCR1_JSWSTART_Pos)   /*!< 0x00000002 */
#define DFSDM_FLTCR1_JSWSTART           DFSDM_FLTCR1_JSWSTART_Msk              /*!< Start the conversion of the injected group of channels */
#define DFSDM_FLTCR1_DFEN_Pos           (0U)
#define DFSDM_FLTCR1_DFEN_Msk           (0x1UL << DFSDM_FLTCR1_DFEN_Pos)       /*!< 0x00000001 */
#define DFSDM_FLTCR1_DFEN               DFSDM_FLTCR1_DFEN_Msk                  /*!< DFSDM enable */

/*****************  Bit definition for DFSDM_FLTCR2 register *******************/
#define DFSDM_FLTCR2_AWDCH_Pos          (16U)
#define DFSDM_FLTCR2_AWDCH_Msk          (0xFFUL << DFSDM_FLTCR2_AWDCH_Pos)     /*!< 0x00FF0000 */
#define DFSDM_FLTCR2_AWDCH              DFSDM_FLTCR2_AWDCH_Msk                 /*!< AWDCH[7:0] Analog watchdog channel selection */
#define DFSDM_FLTCR2_EXCH_Pos           (8U)
#define DFSDM_FLTCR2_EXCH_Msk           (0xFFUL << DFSDM_FLTCR2_EXCH_Pos)      /*!< 0x0000FF00 */
#define DFSDM_FLTCR2_EXCH               DFSDM_FLTCR2_EXCH_Msk                  /*!< EXCH[7:0] Extreme detector channel selection */
#define DFSDM_FLTCR2_CKABIE_Pos         (6U)
#define DFSDM_FLTCR2_CKABIE_Msk         (0x1UL << DFSDM_FLTCR2_CKABIE_Pos)     /*!< 0x00000040 */
#define DFSDM_FLTCR2_CKABIE             DFSDM_FLTCR2_CKABIE_Msk                /*!< Clock absence interrupt enable */
#define DFSDM_FLTCR2_SCDIE_Pos          (5U)
#define DFSDM_FLTCR2_SCDIE_Msk          (0x1UL << DFSDM_FLTCR2_SCDIE_Pos)      /*!< 0x00000020 */
#define DFSDM_FLTCR2_SCDIE              DFSDM_FLTCR2_SCDIE_Msk                 /*!< Short circuit detector interrupt enable */
#define DFSDM_FLTCR2_AWDIE_Pos          (4U)
#define DFSDM_FLTCR2_AWDIE_Msk          (0x1UL << DFSDM_FLTCR2_AWDIE_Pos)      /*!< 0x00000010 */
#define DFSDM_FLTCR2_AWDIE              DFSDM_FLTCR2_AWDIE_Msk                 /*!< Analog watchdog interrupt enable */
#define DFSDM_FLTCR2_ROVRIE_Pos         (3U)
#define DFSDM_FLTCR2_ROVRIE_Msk         (0x1UL << DFSDM_FLTCR2_ROVRIE_Pos)     /*!< 0x00000008 */
#define DFSDM_FLTCR2_ROVRIE             DFSDM_FLTCR2_ROVRIE_Msk                /*!< Regular data overrun interrupt enable */
#define DFSDM_FLTCR2_JOVRIE_Pos         (2U)
#define DFSDM_FLTCR2_JOVRIE_Msk         (0x1UL << DFSDM_FLTCR2_JOVRIE_Pos)     /*!< 0x00000004 */
#define DFSDM_FLTCR2_JOVRIE             DFSDM_FLTCR2_JOVRIE_Msk                /*!< Injected data overrun interrupt enable */
#define DFSDM_FLTCR2_REOCIE_Pos         (1U)
#define DFSDM_FLTCR2_REOCIE_Msk         (0x1UL << DFSDM_FLTCR2_REOCIE_Pos)     /*!< 0x00000002 */
#define DFSDM_FLTCR2_REOCIE             DFSDM_FLTCR2_REOCIE_Msk                /*!< Regular end of conversion interrupt enable */
#define DFSDM_FLTCR2_JEOCIE_Pos         (0U)
#define DFSDM_FLTCR2_JEOCIE_Msk         (0x1UL << DFSDM_FLTCR2_JEOCIE_Pos)     /*!< 0x00000001 */
#define DFSDM_FLTCR2_JEOCIE             DFSDM_FLTCR2_JEOCIE_Msk                /*!< Injected end of conversion interrupt enable */

/*****************  Bit definition for DFSDM_FLTISR register *******************/
#define DFSDM_FLTISR_SCDF_Pos           (24U)
#define DFSDM_FLTISR_SCDF_Msk           (0xFFUL << DFSDM_FLTISR_SCDF_Pos)      /*!< 0xFF000000 */
#define DFSDM_FLTISR_SCDF               DFSDM_FLTISR_SCDF_Msk                  /*!< SCDF[7:0] Short circuit detector flag */
#define DFSDM_FLTISR_CKABF_Pos          (16U)
#define DFSDM_FLTISR_CKABF_Msk          (0xFFUL << DFSDM_FLTISR_CKABF_Pos)     /*!< 0x00FF0000 */
#define DFSDM_FLTISR_CKABF              DFSDM_FLTISR_CKABF_Msk                 /*!< CKABF[7:0] Clock absence flag */
#define DFSDM_FLTISR_RCIP_Pos           (14U)
#define DFSDM_FLTISR_RCIP_Msk           (0x1UL << DFSDM_FLTISR_RCIP_Pos)       /*!< 0x00004000 */
#define DFSDM_FLTISR_RCIP               DFSDM_FLTISR_RCIP_Msk                  /*!< Regular conversion in progress status */
#define DFSDM_FLTISR_JCIP_Pos           (13U)
#define DFSDM_FLTISR_JCIP_Msk           (0x1UL << DFSDM_FLTISR_JCIP_Pos)       /*!< 0x00002000 */
#define DFSDM_FLTISR_JCIP               DFSDM_FLTISR_JCIP_Msk                  /*!< Injected conversion in progress status */
#define DFSDM_FLTISR_AWDF_Pos           (4U)
#define DFSDM_FLTISR_AWDF_Msk           (0x1UL << DFSDM_FLTISR_AWDF_Pos)       /*!< 0x00000010 */
#define DFSDM_FLTISR_AWDF               DFSDM_FLTISR_AWDF_Msk                  /*!< Analog watchdog */
#define DFSDM_FLTISR_ROVRF_Pos          (3U)
#define DFSDM_FLTISR_ROVRF_Msk          (0x1UL << DFSDM_FLTISR_ROVRF_Pos)      /*!< 0x00000008 */
#define DFSDM_FLTISR_ROVRF              DFSDM_FLTISR_ROVRF_Msk                 /*!< Regular conversion overrun flag */
#define DFSDM_FLTISR_JOVRF_Pos          (2U)
#define DFSDM_FLTISR_JOVRF_Msk          (0x1UL << DFSDM_FLTISR_JOVRF_Pos)      /*!< 0x00000004 */
#define DFSDM_FLTISR_JOVRF              DFSDM_FLTISR_JOVRF_Msk                 /*!< Injected conversion overrun flag */
#define DFSDM_FLTISR_REOCF_Pos          (1U)
#define DFSDM_FLTISR_REOCF_Msk          (0x1UL << DFSDM_FLTISR_REOCF_Pos)      /*!< 0x00000002 */
#define DFSDM_FLTISR_REOCF              DFSDM_FLTISR_REOCF_Msk                 /*!< End of regular conversion flag */
#define DFSDM_FLTISR_JEOCF_Pos          (0U)
#define DFSDM_FLTISR_JEOCF_Msk          (0x1UL << DFSDM_FLTISR_JEOCF_Pos)      /*!< 0x00000001 */
#define DFSDM_FLTISR_JEOCF              DFSDM_FLTISR_JEOCF_Msk                 /*!< End of injected conversion flag */

/*****************  Bit definition for DFSDM_FLTICR register *******************/
#define DFSDM_FLTICR_CLRSCDF_Pos        (24U)
#define DFSDM_FLTICR_CLRSCDF_Msk        (0xFFUL << DFSDM_FLTICR_CLRSCDF_Pos)   /*!< 0xFF000000 */
#define DFSDM_FLTICR_CLRSCDF            DFSDM_FLTICR_CLRSCDF_Msk               /*!< CLRSCDF[7:0] Clear the short circuit detector flag */
#define DFSDM_FLTICR_CLRCKABF_Pos       (16U)
#define DFSDM_FLTICR_CLRCKABF_Msk       (0xFFUL << DFSDM_FLTICR_CLRCKABF_Pos)  /*!< 0x00FF0000 */
#define DFSDM_FLTICR_CLRCKABF           DFSDM_FLTICR_CLRCKABF_Msk              /*!< CLRCKABF[7:0] Clear the clock absence flag */
#define DFSDM_FLTICR_CLRROVRF_Pos       (3U)
#define DFSDM_FLTICR_CLRROVRF_Msk       (0x1UL << DFSDM_FLTICR_CLRROVRF_Pos)   /*!< 0x00000008 */
#define DFSDM_FLTICR_CLRROVRF           DFSDM_FLTICR_CLRROVRF_Msk              /*!< Clear the regular conversion overrun flag */
#define DFSDM_FLTICR_CLRJOVRF_Pos       (2U)
#define DFSDM_FLTICR_CLRJOVRF_Msk       (0x1UL << DFSDM_FLTICR_CLRJOVRF_Pos)   /*!< 0x00000004 */
#define DFSDM_FLTICR_CLRJOVRF           DFSDM_FLTICR_CLRJOVRF_Msk              /*!< Clear the injected conversion overrun flag */

/****************  Bit definition for DFSDM_FLTJCHGR register ******************/
#define DFSDM_FLTJCHGR_JCHG_Pos         (0U)
#define DFSDM_FLTJCHGR_JCHG_Msk         (0xFFUL << DFSDM_FLTJCHGR_JCHG_Pos)    /*!< 0x000000FF */
#define DFSDM_FLTJCHGR_JCHG             DFSDM_FLTJCHGR_JCHG_Msk                /*!< JCHG[7:0] Injected channel group selection */

/*****************  Bit definition for DFSDM_FLTFCR register *******************/
#define DFSDM_FLTFCR_FORD_Pos           (29U)
#define DFSDM_FLTFCR_FORD_Msk           (0x7UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0xE0000000 */
#define DFSDM_FLTFCR_FORD               DFSDM_FLTFCR_FORD_Msk                  /*!< FORD[2:0] Sinc filter order */
#define DFSDM_FLTFCR_FORD_2             (0x4UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0x80000000 */
#define DFSDM_FLTFCR_FORD_1             (0x2UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0x40000000 */
#define DFSDM_FLTFCR_FORD_0             (0x1UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0x20000000 */
#define DFSDM_FLTFCR_FOSR_Pos           (16U)
#define DFSDM_FLTFCR_FOSR_Msk           (0x3FFUL << DFSDM_FLTFCR_FOSR_Pos)     /*!< 0x03FF0000 */
#define DFSDM_FLTFCR_FOSR               DFSDM_FLTFCR_FOSR_Msk                  /*!< FOSR[9:0] Sinc filter oversampling ratio (decimation rate) */
#define DFSDM_FLTFCR_IOSR_Pos           (0U)
#define DFSDM_FLTFCR_IOSR_Msk           (0xFFUL << DFSDM_FLTFCR_IOSR_Pos)      /*!< 0x000000FF */
#define DFSDM_FLTFCR_IOSR               DFSDM_FLTFCR_IOSR_Msk                  /*!< IOSR[7:0] Integrator oversampling ratio (averaging length) */

/***************  Bit definition for DFSDM_FLTJDATAR register *****************/
#define DFSDM_FLTJDATAR_JDATA_Pos       (8U)
#define DFSDM_FLTJDATAR_JDATA_Msk       (0xFFFFFFUL << DFSDM_FLTJDATAR_JDATA_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTJDATAR_JDATA           DFSDM_FLTJDATAR_JDATA_Msk              /*!< JDATA[23:0] Injected group conversion data */
#define DFSDM_FLTJDATAR_JDATACH_Pos     (0U)
#define DFSDM_FLTJDATAR_JDATACH_Msk     (0x7UL << DFSDM_FLTJDATAR_JDATACH_Pos) /*!< 0x00000007 */
#define DFSDM_FLTJDATAR_JDATACH         DFSDM_FLTJDATAR_JDATACH_Msk            /*!< JDATACH[2:0] Injected channel most recently converted */

/***************  Bit definition for DFSDM_FLTRDATAR register *****************/
#define DFSDM_FLTRDATAR_RDATA_Pos       (8U)
#define DFSDM_FLTRDATAR_RDATA_Msk       (0xFFFFFFUL << DFSDM_FLTRDATAR_RDATA_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTRDATAR_RDATA           DFSDM_FLTRDATAR_RDATA_Msk              /*!< RDATA[23:0] Regular channel conversion data */
#define DFSDM_FLTRDATAR_RPEND_Pos       (4U)
#define DFSDM_FLTRDATAR_RPEND_Msk       (0x1UL << DFSDM_FLTRDATAR_RPEND_Pos)   /*!< 0x00000010 */
#define DFSDM_FLTRDATAR_RPEND           DFSDM_FLTRDATAR_RPEND_Msk              /*!< RPEND Regular channel pending data */
#define DFSDM_FLTRDATAR_RDATACH_Pos     (0U)
#define DFSDM_FLTRDATAR_RDATACH_Msk     (0x7UL << DFSDM_FLTRDATAR_RDATACH_Pos) /*!< 0x00000007 */
#define DFSDM_FLTRDATAR_RDATACH         DFSDM_FLTRDATAR_RDATACH_Msk            /*!< RDATACH[2:0] Regular channel most recently converted */

/***************  Bit definition for DFSDM_FLTAWHTR register ******************/
#define DFSDM_FLTAWHTR_AWHT_Pos         (8U)
#define DFSDM_FLTAWHTR_AWHT_Msk         (0xFFFFFFUL << DFSDM_FLTAWHTR_AWHT_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTAWHTR_AWHT             DFSDM_FLTAWHTR_AWHT_Msk                /*!< AWHT[23:0] Analog watchdog high threshold */
#define DFSDM_FLTAWHTR_BKAWH_Pos        (0U)
#define DFSDM_FLTAWHTR_BKAWH_Msk        (0xFUL << DFSDM_FLTAWHTR_BKAWH_Pos)    /*!< 0x0000000F */
#define DFSDM_FLTAWHTR_BKAWH            DFSDM_FLTAWHTR_BKAWH_Msk               /*!< BKAWH[3:0] Break signal assignment to analog watchdog high threshold event */

/***************  Bit definition for DFSDM_FLTAWLTR register ******************/
#define DFSDM_FLTAWLTR_AWLT_Pos         (8U)
#define DFSDM_FLTAWLTR_AWLT_Msk         (0xFFFFFFUL << DFSDM_FLTAWLTR_AWLT_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTAWLTR_AWLT             DFSDM_FLTAWLTR_AWLT_Msk                /*!< AWLT[23:0] Analog watchdog low threshold */
#define DFSDM_FLTAWLTR_BKAWL_Pos        (0U)
#define DFSDM_FLTAWLTR_BKAWL_Msk        (0xFUL << DFSDM_FLTAWLTR_BKAWL_Pos)    /*!< 0x0000000F */
#define DFSDM_FLTAWLTR_BKAWL            DFSDM_FLTAWLTR_BKAWL_Msk               /*!< BKAWL[3:0] Break signal assignment to analog watchdog low threshold event */

/***************  Bit definition for DFSDM_FLTAWSR register *******************/
#define DFSDM_FLTAWSR_AWHTF_Pos         (8U)
#define DFSDM_FLTAWSR_AWHTF_Msk         (0xFFUL << DFSDM_FLTAWSR_AWHTF_Pos)    /*!< 0x0000FF00 */
#define DFSDM_FLTAWSR_AWHTF             DFSDM_FLTAWSR_AWHTF_Msk                /*!< AWHTF[15:8] Analog watchdog high threshold error on given channels */
#define DFSDM_FLTAWSR_AWLTF_Pos         (0U)
#define DFSDM_FLTAWSR_AWLTF_Msk         (0xFFUL << DFSDM_FLTAWSR_AWLTF_Pos)    /*!< 0x000000FF */
#define DFSDM_FLTAWSR_AWLTF             DFSDM_FLTAWSR_AWLTF_Msk                /*!< AWLTF[7:0] Analog watchdog low threshold error on given channels */

/***************  Bit definition for DFSDM_FLTAWCFR register ******************/
#define DFSDM_FLTAWCFR_CLRAWHTF_Pos     (8U)
#define DFSDM_FLTAWCFR_CLRAWHTF_Msk     (0xFFUL << DFSDM_FLTAWCFR_CLRAWHTF_Pos)/*!< 0x0000FF00 */
#define DFSDM_FLTAWCFR_CLRAWHTF         DFSDM_FLTAWCFR_CLRAWHTF_Msk            /*!< CLRAWHTF[15:8] Clear the Analog watchdog high threshold flag */
#define DFSDM_FLTAWCFR_CLRAWLTF_Pos     (0U)
#define DFSDM_FLTAWCFR_CLRAWLTF_Msk     (0xFFUL << DFSDM_FLTAWCFR_CLRAWLTF_Pos)/*!< 0x000000FF */
#define DFSDM_FLTAWCFR_CLRAWLTF         DFSDM_FLTAWCFR_CLRAWLTF_Msk            /*!< CLRAWLTF[7:0] Clear the Analog watchdog low threshold flag */

/***************  Bit definition for DFSDM_FLTEXMAX register ******************/
#define DFSDM_FLTEXMAX_EXMAX_Pos        (8U)
#define DFSDM_FLTEXMAX_EXMAX_Msk        (0xFFFFFFUL << DFSDM_FLTEXMAX_EXMAX_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTEXMAX_EXMAX            DFSDM_FLTEXMAX_EXMAX_Msk               /*!< EXMAX[23:0] Extreme detector maximum value */
#define DFSDM_FLTEXMAX_EXMAXCH_Pos      (0U)
#define DFSDM_FLTEXMAX_EXMAXCH_Msk      (0x7UL << DFSDM_FLTEXMAX_EXMAXCH_Pos)  /*!< 0x00000007 */
#define DFSDM_FLTEXMAX_EXMAXCH          DFSDM_FLTEXMAX_EXMAXCH_Msk             /*!< EXMAXCH[2:0] Extreme detector maximum data channel */

/***************  Bit definition for DFSDM_FLTEXMIN register ******************/
#define DFSDM_FLTEXMIN_EXMIN_Pos        (8U)
#define DFSDM_FLTEXMIN_EXMIN_Msk        (0xFFFFFFUL << DFSDM_FLTEXMIN_EXMIN_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTEXMIN_EXMIN            DFSDM_FLTEXMIN_EXMIN_Msk               /*!< EXMIN[23:0] Extreme detector minimum value */
#define DFSDM_FLTEXMIN_EXMINCH_Pos      (0U)
#define DFSDM_FLTEXMIN_EXMINCH_Msk      (0x7UL << DFSDM_FLTEXMIN_EXMINCH_Pos)  /*!< 0x00000007 */
#define DFSDM_FLTEXMIN_EXMINCH          DFSDM_FLTEXMIN_EXMINCH_Msk             /*!< EXMINCH[2:0] Extreme detector minimum data channel */

/***************  Bit definition for DFSDM_FLTCNVTIMR register ****************/
#define DFSDM_FLTCNVTIMR_CNVCNT_Pos     (4U)
#define DFSDM_FLTCNVTIMR_CNVCNT_Msk     (0xFFFFFFFUL << DFSDM_FLTCNVTIMR_CNVCNT_Pos)/*!< 0xFFFFFFF0 */
#define DFSDM_FLTCNVTIMR_CNVCNT         DFSDM_FLTCNVTIMR_CNVCNT_Msk            /*!< CNVCNT[27:0]: 28-bit timer counting conversion time */

/******************************************************************************/
/*                                                                            */
/*                           DMA Controller (DMA)                             */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DMA_ISR register  ********************/
#define DMA_ISR_GIF1_Pos       (0U)
#define DMA_ISR_GIF1_Msk       (0x1UL << DMA_ISR_GIF1_Pos)                     /*!< 0x00000001 */
#define DMA_ISR_GIF1           DMA_ISR_GIF1_Msk                                /*!< Channel 1 Global interrupt flag */
#define DMA_ISR_TCIF1_Pos      (1U)
#define DMA_ISR_TCIF1_Msk      (0x1UL << DMA_ISR_TCIF1_Pos)                    /*!< 0x00000002 */
#define DMA_ISR_TCIF1          DMA_ISR_TCIF1_Msk                               /*!< Channel 1 Transfer Complete flag */
#define DMA_ISR_HTIF1_Pos      (2U)
#define DMA_ISR_HTIF1_Msk      (0x1UL << DMA_ISR_HTIF1_Pos)                    /*!< 0x00000004 */
#define DMA_ISR_HTIF1          DMA_ISR_HTIF1_Msk                               /*!< Channel 1 Half Transfer flag */
#define DMA_ISR_TEIF1_Pos      (3U)
#define DMA_ISR_TEIF1_Msk      (0x1UL << DMA_ISR_TEIF1_Pos)                    /*!< 0x00000008 */
#define DMA_ISR_TEIF1          DMA_ISR_TEIF1_Msk                               /*!< Channel 1 Transfer Error flag */
#define DMA_ISR_GIF2_Pos       (4U)
#define DMA_ISR_GIF2_Msk       (0x1UL << DMA_ISR_GIF2_Pos)                     /*!< 0x00000010 */
#define DMA_ISR_GIF2           DMA_ISR_GIF2_Msk                                /*!< Channel 2 Global interrupt flag */
#define DMA_ISR_TCIF2_Pos      (5U)
#define DMA_ISR_TCIF2_Msk      (0x1UL << DMA_ISR_TCIF2_Pos)                    /*!< 0x00000020 */
#define DMA_ISR_TCIF2          DMA_ISR_TCIF2_Msk                               /*!< Channel 2 Transfer Complete flag */
#define DMA_ISR_HTIF2_Pos      (6U)
#define DMA_ISR_HTIF2_Msk      (0x1UL << DMA_ISR_HTIF2_Pos)                    /*!< 0x00000040 */
#define DMA_ISR_HTIF2          DMA_ISR_HTIF2_Msk                               /*!< Channel 2 Half Transfer flag */
#define DMA_ISR_TEIF2_Pos      (7U)
#define DMA_ISR_TEIF2_Msk      (0x1UL << DMA_ISR_TEIF2_Pos)                    /*!< 0x00000080 */
#define DMA_ISR_TEIF2          DMA_ISR_TEIF2_Msk                               /*!< Channel 2 Transfer Error flag */
#define DMA_ISR_GIF3_Pos       (8U)
#define DMA_ISR_GIF3_Msk       (0x1UL << DMA_ISR_GIF3_Pos)                     /*!< 0x00000100 */
#define DMA_ISR_GIF3           DMA_ISR_GIF3_Msk                                /*!< Channel 3 Global interrupt flag */
#define DMA_ISR_TCIF3_Pos      (9U)
#define DMA_ISR_TCIF3_Msk      (0x1UL << DMA_ISR_TCIF3_Pos)                    /*!< 0x00000200 */
#define DMA_ISR_TCIF3          DMA_ISR_TCIF3_Msk                               /*!< Channel 3 Transfer Complete flag */
#define DMA_ISR_HTIF3_Pos      (10U)
#define DMA_ISR_HTIF3_Msk      (0x1UL << DMA_ISR_HTIF3_Pos)                    /*!< 0x00000400 */
#define DMA_ISR_HTIF3          DMA_ISR_HTIF3_Msk                               /*!< Channel 3 Half Transfer flag */
#define DMA_ISR_TEIF3_Pos      (11U)
#define DMA_ISR_TEIF3_Msk      (0x1UL << DMA_ISR_TEIF3_Pos)                    /*!< 0x00000800 */
#define DMA_ISR_TEIF3          DMA_ISR_TEIF3_Msk                               /*!< Channel 3 Transfer Error flag */
#define DMA_ISR_GIF4_Pos       (12U)
#define DMA_ISR_GIF4_Msk       (0x1UL << DMA_ISR_GIF4_Pos)                     /*!< 0x00001000 */
#define DMA_ISR_GIF4           DMA_ISR_GIF4_Msk                                /*!< Channel 4 Global interrupt flag */
#define DMA_ISR_TCIF4_Pos      (13U)
#define DMA_ISR_TCIF4_Msk      (0x1UL << DMA_ISR_TCIF4_Pos)                    /*!< 0x00002000 */
#define DMA_ISR_TCIF4          DMA_ISR_TCIF4_Msk                               /*!< Channel 4 Transfer Complete flag */
#define DMA_ISR_HTIF4_Pos      (14U)
#define DMA_ISR_HTIF4_Msk      (0x1UL << DMA_ISR_HTIF4_Pos)                    /*!< 0x00004000 */
#define DMA_ISR_HTIF4          DMA_ISR_HTIF4_Msk                               /*!< Channel 4 Half Transfer flag */
#define DMA_ISR_TEIF4_Pos      (15U)
#define DMA_ISR_TEIF4_Msk      (0x1UL << DMA_ISR_TEIF4_Pos)                    /*!< 0x00008000 */
#define DMA_ISR_TEIF4          DMA_ISR_TEIF4_Msk                               /*!< Channel 4 Transfer Error flag */
#define DMA_ISR_GIF5_Pos       (16U)
#define DMA_ISR_GIF5_Msk       (0x1UL << DMA_ISR_GIF5_Pos)                     /*!< 0x00010000 */
#define DMA_ISR_GIF5           DMA_ISR_GIF5_Msk                                /*!< Channel 5 Global interrupt flag */
#define DMA_ISR_TCIF5_Pos      (17U)
#define DMA_ISR_TCIF5_Msk      (0x1UL << DMA_ISR_TCIF5_Pos)                    /*!< 0x00020000 */
#define DMA_ISR_TCIF5          DMA_ISR_TCIF5_Msk                               /*!< Channel 5 Transfer Complete flag */
#define DMA_ISR_HTIF5_Pos      (18U)
#define DMA_ISR_HTIF5_Msk      (0x1UL << DMA_ISR_HTIF5_Pos)                    /*!< 0x00040000 */
#define DMA_ISR_HTIF5          DMA_ISR_HTIF5_Msk                               /*!< Channel 5 Half Transfer flag */
#define DMA_ISR_TEIF5_Pos      (19U)
#define DMA_ISR_TEIF5_Msk      (0x1UL << DMA_ISR_TEIF5_Pos)                    /*!< 0x00080000 */
#define DMA_ISR_TEIF5          DMA_ISR_TEIF5_Msk                               /*!< Channel 5 Transfer Error flag */
#define DMA_ISR_GIF6_Pos       (20U)
#define DMA_ISR_GIF6_Msk       (0x1UL << DMA_ISR_GIF6_Pos)                     /*!< 0x00100000 */
#define DMA_ISR_GIF6           DMA_ISR_GIF6_Msk                                /*!< Channel 6 Global interrupt flag */
#define DMA_ISR_TCIF6_Pos      (21U)
#define DMA_ISR_TCIF6_Msk      (0x1UL << DMA_ISR_TCIF6_Pos)                    /*!< 0x00200000 */
#define DMA_ISR_TCIF6          DMA_ISR_TCIF6_Msk                               /*!< Channel 6 Transfer Complete flag */
#define DMA_ISR_HTIF6_Pos      (22U)
#define DMA_ISR_HTIF6_Msk      (0x1UL << DMA_ISR_HTIF6_Pos)                    /*!< 0x00400000 */
#define DMA_ISR_HTIF6          DMA_ISR_HTIF6_Msk                               /*!< Channel 6 Half Transfer flag */
#define DMA_ISR_TEIF6_Pos      (23U)
#define DMA_ISR_TEIF6_Msk      (0x1UL << DMA_ISR_TEIF6_Pos)                    /*!< 0x00800000 */
#define DMA_ISR_TEIF6          DMA_ISR_TEIF6_Msk                               /*!< Channel 6 Transfer Error flag */
#define DMA_ISR_GIF7_Pos       (24U)
#define DMA_ISR_GIF7_Msk       (0x1UL << DMA_ISR_GIF7_Pos)                     /*!< 0x01000000 */
#define DMA_ISR_GIF7           DMA_ISR_GIF7_Msk                                /*!< Channel 7 Global interrupt flag */
#define DMA_ISR_TCIF7_Pos      (25U)
#define DMA_ISR_TCIF7_Msk      (0x1UL << DMA_ISR_TCIF7_Pos)                    /*!< 0x02000000 */
#define DMA_ISR_TCIF7          DMA_ISR_TCIF7_Msk                               /*!< Channel 7 Transfer Complete flag */
#define DMA_ISR_HTIF7_Pos      (26U)
#define DMA_ISR_HTIF7_Msk      (0x1UL << DMA_ISR_HTIF7_Pos)                    /*!< 0x04000000 */
#define DMA_ISR_HTIF7          DMA_ISR_HTIF7_Msk                               /*!< Channel 7 Half Transfer flag */
#define DMA_ISR_TEIF7_Pos      (27U)
#define DMA_ISR_TEIF7_Msk      (0x1UL << DMA_ISR_TEIF7_Pos)                    /*!< 0x08000000 */
#define DMA_ISR_TEIF7          DMA_ISR_TEIF7_Msk                               /*!< Channel 7 Transfer Error flag */
#define DMA_ISR_GIF8_Pos       (28U)
#define DMA_ISR_GIF8_Msk       (0x1UL << DMA_ISR_GIF8_Pos)                     /*!< 0x10000000 */
#define DMA_ISR_GIF8           DMA_ISR_GIF8_Msk                                /*!< Channel 8 Global interrupt flag */
#define DMA_ISR_TCIF8_Pos      (29U)
#define DMA_ISR_TCIF8_Msk      (0x1UL << DMA_ISR_TCIF8_Pos)                    /*!< 0x20000000 */
#define DMA_ISR_TCIF8          DMA_ISR_TCIF8_Msk                               /*!< Channel 8 Transfer Complete flag */
#define DMA_ISR_HTIF8_Pos      (30U)
#define DMA_ISR_HTIF8_Msk      (0x1UL << DMA_ISR_HTIF8_Pos)                    /*!< 0x40000000 */
#define DMA_ISR_HTIF8          DMA_ISR_HTIF8_Msk                               /*!< Channel 8 Half Transfer flag */
#define DMA_ISR_TEIF8_Pos      (31U)
#define DMA_ISR_TEIF8_Msk      (0x1UL << DMA_ISR_TEIF8_Pos)                    /*!< 0x80000000 */
#define DMA_ISR_TEIF8          DMA_ISR_TEIF8_Msk                               /*!< Channel 8 Transfer Error flag */

/*******************  Bit definition for DMA_IFCR register  *******************/
#define DMA_IFCR_CGIF1_Pos     (0U)
#define DMA_IFCR_CGIF1_Msk     (0x1UL << DMA_IFCR_CGIF1_Pos)                   /*!< 0x00000001 */
#define DMA_IFCR_CGIF1         DMA_IFCR_CGIF1_Msk                              /*!< Channel 1 Global interrupt clearr */
#define DMA_IFCR_CTCIF1_Pos    (1U)
#define DMA_IFCR_CTCIF1_Msk    (0x1UL << DMA_IFCR_CTCIF1_Pos)                  /*!< 0x00000002 */
#define DMA_IFCR_CTCIF1        DMA_IFCR_CTCIF1_Msk                             /*!< Channel 1 Transfer Complete clear */
#define DMA_IFCR_CHTIF1_Pos    (2U)
#define DMA_IFCR_CHTIF1_Msk    (0x1UL << DMA_IFCR_CHTIF1_Pos)                  /*!< 0x00000004 */
#define DMA_IFCR_CHTIF1        DMA_IFCR_CHTIF1_Msk                             /*!< Channel 1 Half Transfer clear */
#define DMA_IFCR_CTEIF1_Pos    (3U)
#define DMA_IFCR_CTEIF1_Msk    (0x1UL << DMA_IFCR_CTEIF1_Pos)                  /*!< 0x00000008 */
#define DMA_IFCR_CTEIF1        DMA_IFCR_CTEIF1_Msk                             /*!< Channel 1 Transfer Error clear */
#define DMA_IFCR_CGIF2_Pos     (4U)
#define DMA_IFCR_CGIF2_Msk     (0x1UL << DMA_IFCR_CGIF2_Pos)                   /*!< 0x00000010 */
#define DMA_IFCR_CGIF2         DMA_IFCR_CGIF2_Msk                              /*!< Channel 2 Global interrupt clear */
#define DMA_IFCR_CTCIF2_Pos    (5U)
#define DMA_IFCR_CTCIF2_Msk    (0x1UL << DMA_IFCR_CTCIF2_Pos)                  /*!< 0x00000020 */
#define DMA_IFCR_CTCIF2        DMA_IFCR_CTCIF2_Msk                             /*!< Channel 2 Transfer Complete clear */
#define DMA_IFCR_CHTIF2_Pos    (6U)
#define DMA_IFCR_CHTIF2_Msk    (0x1UL << DMA_IFCR_CHTIF2_Pos)                  /*!< 0x00000040 */
#define DMA_IFCR_CHTIF2        DMA_IFCR_CHTIF2_Msk                             /*!< Channel 2 Half Transfer clear */
#define DMA_IFCR_CTEIF2_Pos    (7U)
#define DMA_IFCR_CTEIF2_Msk    (0x1UL << DMA_IFCR_CTEIF2_Pos)                  /*!< 0x00000080 */
#define DMA_IFCR_CTEIF2        DMA_IFCR_CTEIF2_Msk                             /*!< Channel 2 Transfer Error clear */
#define DMA_IFCR_CGIF3_Pos     (8U)
#define DMA_IFCR_CGIF3_Msk     (0x1UL << DMA_IFCR_CGIF3_Pos)                   /*!< 0x00000100 */
#define DMA_IFCR_CGIF3         DMA_IFCR_CGIF3_Msk                              /*!< Channel 3 Global interrupt clear */
#define DMA_IFCR_CTCIF3_Pos    (9U)
#define DMA_IFCR_CTCIF3_Msk    (0x1UL << DMA_IFCR_CTCIF3_Pos)                  /*!< 0x00000200 */
#define DMA_IFCR_CTCIF3        DMA_IFCR_CTCIF3_Msk                             /*!< Channel 3 Transfer Complete clear */
#define DMA_IFCR_CHTIF3_Pos    (10U)
#define DMA_IFCR_CHTIF3_Msk    (0x1UL << DMA_IFCR_CHTIF3_Pos)                  /*!< 0x00000400 */
#define DMA_IFCR_CHTIF3        DMA_IFCR_CHTIF3_Msk                             /*!< Channel 3 Half Transfer clear */
#define DMA_IFCR_CTEIF3_Pos    (11U)
#define DMA_IFCR_CTEIF3_Msk    (0x1UL << DMA_IFCR_CTEIF3_Pos)                  /*!< 0x00000800 */
#define DMA_IFCR_CTEIF3        DMA_IFCR_CTEIF3_Msk                             /*!< Channel 3 Transfer Error clear */
#define DMA_IFCR_CGIF4_Pos     (12U)
#define DMA_IFCR_CGIF4_Msk     (0x1UL << DMA_IFCR_CGIF4_Pos)                   /*!< 0x00001000 */
#define DMA_IFCR_CGIF4         DMA_IFCR_CGIF4_Msk                              /*!< Channel 4 Global interrupt clear */
#define DMA_IFCR_CTCIF4_Pos    (13U)
#define DMA_IFCR_CTCIF4_Msk    (0x1UL << DMA_IFCR_CTCIF4_Pos)                  /*!< 0x00002000 */
#define DMA_IFCR_CTCIF4        DMA_IFCR_CTCIF4_Msk                             /*!< Channel 4 Transfer Complete clear */
#define DMA_IFCR_CHTIF4_Pos    (14U)
#define DMA_IFCR_CHTIF4_Msk    (0x1UL << DMA_IFCR_CHTIF4_Pos)                  /*!< 0x00004000 */
#define DMA_IFCR_CHTIF4        DMA_IFCR_CHTIF4_Msk                             /*!< Channel 4 Half Transfer clear */
#define DMA_IFCR_CTEIF4_Pos    (15U)
#define DMA_IFCR_CTEIF4_Msk    (0x1UL << DMA_IFCR_CTEIF4_Pos)                  /*!< 0x00008000 */
#define DMA_IFCR_CTEIF4        DMA_IFCR_CTEIF4_Msk                             /*!< Channel 4 Transfer Error clear */
#define DMA_IFCR_CGIF5_Pos     (16U)
#define DMA_IFCR_CGIF5_Msk     (0x1UL << DMA_IFCR_CGIF5_Pos)                   /*!< 0x00010000 */
#define DMA_IFCR_CGIF5         DMA_IFCR_CGIF5_Msk                              /*!< Channel 5 Global interrupt clear */
#define DMA_IFCR_CTCIF5_Pos    (17U)
#define DMA_IFCR_CTCIF5_Msk    (0x1UL << DMA_IFCR_CTCIF5_Pos)                  /*!< 0x00020000 */
#define DMA_IFCR_CTCIF5        DMA_IFCR_CTCIF5_Msk                             /*!< Channel 5 Transfer Complete clear */
#define DMA_IFCR_CHTIF5_Pos    (18U)
#define DMA_IFCR_CHTIF5_Msk    (0x1UL << DMA_IFCR_CHTIF5_Pos)                  /*!< 0x00040000 */
#define DMA_IFCR_CHTIF5        DMA_IFCR_CHTIF5_Msk                             /*!< Channel 5 Half Transfer clear */
#define DMA_IFCR_CTEIF5_Pos    (19U)
#define DMA_IFCR_CTEIF5_Msk    (0x1UL << DMA_IFCR_CTEIF5_Pos)                  /*!< 0x00080000 */
#define DMA_IFCR_CTEIF5        DMA_IFCR_CTEIF5_Msk                             /*!< Channel 5 Transfer Error clear */
#define DMA_IFCR_CGIF6_Pos     (20U)
#define DMA_IFCR_CGIF6_Msk     (0x1UL << DMA_IFCR_CGIF6_Pos)                   /*!< 0x00100000 */
#define DMA_IFCR_CGIF6         DMA_IFCR_CGIF6_Msk                              /*!< Channel 6 Global interrupt clear */
#define DMA_IFCR_CTCIF6_Pos    (21U)
#define DMA_IFCR_CTCIF6_Msk    (0x1UL << DMA_IFCR_CTCIF6_Pos)                  /*!< 0x00200000 */
#define DMA_IFCR_CTCIF6        DMA_IFCR_CTCIF6_Msk                             /*!< Channel 6 Transfer Complete clear */
#define DMA_IFCR_CHTIF6_Pos    (22U)
#define DMA_IFCR_CHTIF6_Msk    (0x1UL << DMA_IFCR_CHTIF6_Pos)                  /*!< 0x00400000 */
#define DMA_IFCR_CHTIF6        DMA_IFCR_CHTIF6_Msk                             /*!< Channel 6 Half Transfer clear */
#define DMA_IFCR_CTEIF6_Pos    (23U)
#define DMA_IFCR_CTEIF6_Msk    (0x1UL << DMA_IFCR_CTEIF6_Pos)                  /*!< 0x00800000 */
#define DMA_IFCR_CTEIF6        DMA_IFCR_CTEIF6_Msk                             /*!< Channel 6 Transfer Error clear */
#define DMA_IFCR_CGIF7_Pos     (24U)
#define DMA_IFCR_CGIF7_Msk     (0x1UL << DMA_IFCR_CGIF7_Pos)                   /*!< 0x01000000 */
#define DMA_IFCR_CGIF7         DMA_IFCR_CGIF7_Msk                              /*!< Channel 7 Global interrupt clear */
#define DMA_IFCR_CTCIF7_Pos    (25U)
#define DMA_IFCR_CTCIF7_Msk    (0x1UL << DMA_IFCR_CTCIF7_Pos)                  /*!< 0x02000000 */
#define DMA_IFCR_CTCIF7        DMA_IFCR_CTCIF7_Msk                             /*!< Channel 7 Transfer Complete clear */
#define DMA_IFCR_CHTIF7_Pos    (26U)
#define DMA_IFCR_CHTIF7_Msk    (0x1UL << DMA_IFCR_CHTIF7_Pos)                  /*!< 0x04000000 */
#define DMA_IFCR_CHTIF7        DMA_IFCR_CHTIF7_Msk                             /*!< Channel 7 Half Transfer clear */
#define DMA_IFCR_CTEIF7_Pos    (27U)
#define DMA_IFCR_CTEIF7_Msk    (0x1UL << DMA_IFCR_CTEIF7_Pos)                  /*!< 0x08000000 */
#define DMA_IFCR_CTEIF7        DMA_IFCR_CTEIF7_Msk                             /*!< Channel 7 Transfer Error clear */
#define DMA_IFCR_CGIF8_Pos     (28U)
#define DMA_IFCR_CGIF8_Msk     (0x1UL << DMA_IFCR_CGIF8_Pos)                   /*!< 0x10000000 */
#define DMA_IFCR_CGIF8         DMA_IFCR_CGIF8_Msk                              /*!< Channel 8 Global interrupt clear */
#define DMA_IFCR_CTCIF8_Pos    (29U)
#define DMA_IFCR_CTCIF8_Msk    (0x1UL << DMA_IFCR_CTCIF8_Pos)                  /*!< 0x20000000 */
#define DMA_IFCR_CTCIF8        DMA_IFCR_CTCIF8_Msk                             /*!< Channel 8 Transfer Complete clear */
#define DMA_IFCR_CHTIF8_Pos    (30U)
#define DMA_IFCR_CHTIF8_Msk    (0x1UL << DMA_IFCR_CHTIF8_Pos)                  /*!< 0x40000000 */
#define DMA_IFCR_CHTIF8        DMA_IFCR_CHTIF8_Msk                             /*!< Channel 8 Half Transfer clear */
#define DMA_IFCR_CTEIF8_Pos    (31U)
#define DMA_IFCR_CTEIF8_Msk    (0x1UL << DMA_IFCR_CTEIF8_Pos)                  /*!< 0x80000000 */
#define DMA_IFCR_CTEIF8        DMA_IFCR_CTEIF8_Msk                             /*!< Channel 8 Transfer Error clear */

/*******************  Bit definition for DMA_CCR register  ********************/
#define DMA_CCR_EN_Pos         (0U)
#define DMA_CCR_EN_Msk         (0x1UL << DMA_CCR_EN_Pos)                       /*!< 0x00000001 */
#define DMA_CCR_EN             DMA_CCR_EN_Msk                                  /*!< Channel enable                      */
#define DMA_CCR_TCIE_Pos       (1U)
#define DMA_CCR_TCIE_Msk       (0x1UL << DMA_CCR_TCIE_Pos)                     /*!< 0x00000002 */
#define DMA_CCR_TCIE           DMA_CCR_TCIE_Msk                                /*!< Transfer complete interrupt enable  */
#define DMA_CCR_HTIE_Pos       (2U)
#define DMA_CCR_HTIE_Msk       (0x1UL << DMA_CCR_HTIE_Pos)                     /*!< 0x00000004 */
#define DMA_CCR_HTIE           DMA_CCR_HTIE_Msk                                /*!< Half Transfer interrupt enable      */
#define DMA_CCR_TEIE_Pos       (3U)
#define DMA_CCR_TEIE_Msk       (0x1UL << DMA_CCR_TEIE_Pos)                     /*!< 0x00000008 */
#define DMA_CCR_TEIE           DMA_CCR_TEIE_Msk                                /*!< Transfer error interrupt enable     */
#define DMA_CCR_DIR_Pos        (4U)
#define DMA_CCR_DIR_Msk        (0x1UL << DMA_CCR_DIR_Pos)                      /*!< 0x00000010 */
#define DMA_CCR_DIR            DMA_CCR_DIR_Msk                                 /*!< Data transfer direction             */
#define DMA_CCR_CIRC_Pos       (5U)
#define DMA_CCR_CIRC_Msk       (0x1UL << DMA_CCR_CIRC_Pos)                     /*!< 0x00000020 */
#define DMA_CCR_CIRC           DMA_CCR_CIRC_Msk                                /*!< Circular mode                       */
#define DMA_CCR_PINC_Pos       (6U)
#define DMA_CCR_PINC_Msk       (0x1UL << DMA_CCR_PINC_Pos)                     /*!< 0x00000040 */
#define DMA_CCR_PINC           DMA_CCR_PINC_Msk                                /*!< Peripheral increment mode           */
#define DMA_CCR_MINC_Pos       (7U)
#define DMA_CCR_MINC_Msk       (0x1UL << DMA_CCR_MINC_Pos)                     /*!< 0x00000080 */
#define DMA_CCR_MINC           DMA_CCR_MINC_Msk                                /*!< Memory increment mode               */

#define DMA_CCR_PSIZE_Pos      (8U)
#define DMA_CCR_PSIZE_Msk      (0x3UL << DMA_CCR_PSIZE_Pos)                    /*!< 0x00000300 */
#define DMA_CCR_PSIZE          DMA_CCR_PSIZE_Msk                               /*!< PSIZE[1:0] bits (Peripheral size)   */
#define DMA_CCR_PSIZE_0        (0x1UL << DMA_CCR_PSIZE_Pos)                    /*!< 0x00000100 */
#define DMA_CCR_PSIZE_1        (0x2UL << DMA_CCR_PSIZE_Pos)                    /*!< 0x00000200 */

#define DMA_CCR_MSIZE_Pos      (10U)
#define DMA_CCR_MSIZE_Msk      (0x3UL << DMA_CCR_MSIZE_Pos)                    /*!< 0x00000C00 */
#define DMA_CCR_MSIZE          DMA_CCR_MSIZE_Msk                               /*!< MSIZE[1:0] bits (Memory size)       */
#define DMA_CCR_MSIZE_0        (0x1UL << DMA_CCR_MSIZE_Pos)                    /*!< 0x00000400 */
#define DMA_CCR_MSIZE_1        (0x2UL << DMA_CCR_MSIZE_Pos)                    /*!< 0x00000800 */

#define DMA_CCR_PL_Pos         (12U)
#define DMA_CCR_PL_Msk         (0x3UL << DMA_CCR_PL_Pos)                       /*!< 0x00003000 */
#define DMA_CCR_PL             DMA_CCR_PL_Msk                                  /*!< PL[1:0] bits(Channel Priority level)*/
#define DMA_CCR_PL_0           (0x1UL << DMA_CCR_PL_Pos)                       /*!< 0x00001000 */
#define DMA_CCR_PL_1           (0x2UL << DMA_CCR_PL_Pos)                       /*!< 0x00002000 */

#define DMA_CCR_MEM2MEM_Pos    (14U)
#define DMA_CCR_MEM2MEM_Msk    (0x1UL << DMA_CCR_MEM2MEM_Pos)                  /*!< 0x00004000 */
#define DMA_CCR_MEM2MEM        DMA_CCR_MEM2MEM_Msk                             /*!< Memory to memory mode               */
#define DMA_CCR_DBM_Pos        (15U)
#define DMA_CCR_DBM_Msk        (0x1UL << DMA_CCR_DBM_Pos)                      /*!< 0x00008000 */
#define DMA_CCR_DBM            DMA_CCR_DBM_Msk                                 /*!< Double-buffer mode                  */
#define DMA_CCR_CT_Pos         (16U)
#define DMA_CCR_CT_Msk         (0x1UL << DMA_CCR_CT_Pos)                       /*!< 0x00010000 */
#define DMA_CCR_CT             DMA_CCR_CT_Msk                                  /*!< Current target of DMA transfer in double-buffer mode */
#define DMA_CCR_SECM_Pos       (17U)
#define DMA_CCR_SECM_Msk       (0x1UL << DMA_CCR_SECM_Pos)                     /*!< 0x00020000 */
#define DMA_CCR_SECM           DMA_CCR_SECM_Msk                                /*!< Secure mode                         */
#define DMA_CCR_SSEC_Pos       (18U)
#define DMA_CCR_SSEC_Msk       (0x1UL << DMA_CCR_SSEC_Pos)                     /*!< 0x00040000 */
#define DMA_CCR_SSEC           DMA_CCR_SSEC_Msk                                /*!< Security of the DMA transfer from the source */
#define DMA_CCR_DSEC_Pos       (19U)
#define DMA_CCR_DSEC_Msk       (0x1UL << DMA_CCR_DSEC_Pos)                     /*!< 0x00080000 */
#define DMA_CCR_DSEC           DMA_CCR_DSEC_Msk                                /*!< Security of the DMA transfer to the destination */
#define DMA_CCR_PRIV_Pos       (20U)
#define DMA_CCR_PRIV_Msk       (0x1UL << DMA_CCR_PRIV_Pos)                     /*!< 0x00100000 */
#define DMA_CCR_PRIV           DMA_CCR_PRIV_Msk                                /*!< Privileged mode */

/******************  Bit definition for DMA_CNDTR register  *******************/
#define DMA_CNDTR_NDT_Pos      (0U)
#define DMA_CNDTR_NDT_Msk      (0x3FFFFUL << DMA_CNDTR_NDT_Pos)                /*!< 0x0000FFFF */
#define DMA_CNDTR_NDT          DMA_CNDTR_NDT_Msk                               /*!< Number of data to Transfer          */

/******************  Bit definition for DMA_CPAR register  ********************/
#define DMA_CPAR_PA_Pos        (0U)
#define DMA_CPAR_PA_Msk        (0xFFFFFFFFUL << DMA_CPAR_PA_Pos)               /*!< 0xFFFFFFFF */
#define DMA_CPAR_PA            DMA_CPAR_PA_Msk                                 /*!< Peripheral Address                  */

/******************  Bit definition for DMA_CM0AR register  *******************/
#define DMA_CM0AR_MA_Pos       (0U)
#define DMA_CM0AR_MA_Msk       (0xFFFFFFFFUL << DMA_CM0AR_MA_Pos)              /*!< 0xFFFFFFFF */
#define DMA_CM0AR_MA           DMA_CM0AR_MA_Msk                                /*!< Memory 0 Address                      */

/******************  Bit definition for DMA_CM1AR register  *******************/
#define DMA_CM1AR_MA_Pos       (0U)
#define DMA_CM1AR_MA_Msk       (0xFFFFFFFFUL << DMA_CM1AR_MA_Pos)              /*!< 0xFFFFFFFF */
#define DMA_CM1AR_MA           DMA_CM1AR_MA_Msk                                /*!< Memory 1 Address                      */

/******************************************************************************/
/*                                                                            */
/*                             DMAMUX Controller                              */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DMAMUX_CxCR register  **************/
#define DMAMUX_CxCR_DMAREQ_ID_Pos                    (0U)
#define DMAMUX_CxCR_DMAREQ_ID_Msk                    (0xFFUL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x000000FF */
#define DMAMUX_CxCR_DMAREQ_ID                        DMAMUX_CxCR_DMAREQ_ID_Msk
#define DMAMUX_CxCR_DMAREQ_ID_0                      (0x01UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000001 */
#define DMAMUX_CxCR_DMAREQ_ID_1                      (0x02UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000002 */
#define DMAMUX_CxCR_DMAREQ_ID_2                      (0x04UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000004 */
#define DMAMUX_CxCR_DMAREQ_ID_3                      (0x08UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000008 */
#define DMAMUX_CxCR_DMAREQ_ID_4                      (0x10UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000010 */
#define DMAMUX_CxCR_DMAREQ_ID_5                      (0x20UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000020 */
#define DMAMUX_CxCR_DMAREQ_ID_6                      (0x40UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000040 */
#define DMAMUX_CxCR_DMAREQ_ID_7                      (0x80UL << DMAMUX_CxCR_DMAREQ_ID_Pos)/*!< 0x00000080 */

#define DMAMUX_CxCR_SOIE_Pos                         (8U)
#define DMAMUX_CxCR_SOIE_Msk                         (0x1UL << DMAMUX_CxCR_SOIE_Pos)/*!< 0x00000100 */
#define DMAMUX_CxCR_SOIE                             DMAMUX_CxCR_SOIE_Msk

#define DMAMUX_CxCR_EGE_Pos                          (9U)
#define DMAMUX_CxCR_EGE_Msk                          (0x1UL << DMAMUX_CxCR_EGE_Pos)/*!< 0x00000200 */
#define DMAMUX_CxCR_EGE                              DMAMUX_CxCR_EGE_Msk

#define DMAMUX_CxCR_SE_Pos                           (16U)
#define DMAMUX_CxCR_SE_Msk                           (0x1UL << DMAMUX_CxCR_SE_Pos)/*!< 0x00010000 */
#define DMAMUX_CxCR_SE                               DMAMUX_CxCR_SE_Msk

#define DMAMUX_CxCR_SPOL_Pos                         (17U)
#define DMAMUX_CxCR_SPOL_Msk                         (0x3UL << DMAMUX_CxCR_SPOL_Pos)/*!< 0x00060000 */
#define DMAMUX_CxCR_SPOL                             DMAMUX_CxCR_SPOL_Msk
#define DMAMUX_CxCR_SPOL_0                           (0x1UL << DMAMUX_CxCR_SPOL_Pos)/*!< 0x00020000 */
#define DMAMUX_CxCR_SPOL_1                           (0x2UL << DMAMUX_CxCR_SPOL_Pos)/*!< 0x00040000 */

#define DMAMUX_CxCR_NBREQ_Pos                        (19U)
#define DMAMUX_CxCR_NBREQ_Msk                        (0x1FUL << DMAMUX_CxCR_NBREQ_Pos)/*!< 0x00F80000 */
#define DMAMUX_CxCR_NBREQ                            DMAMUX_CxCR_NBREQ_Msk
#define DMAMUX_CxCR_NBREQ_0                          (0x01UL << DMAMUX_CxCR_NBREQ_Pos)/*!< 0x00080000 */
#define DMAMUX_CxCR_NBREQ_1                          (0x02UL << DMAMUX_CxCR_NBREQ_Pos)/*!< 0x00100000 */
#define DMAMUX_CxCR_NBREQ_2                          (0x04UL << DMAMUX_CxCR_NBREQ_Pos)/*!< 0x00200000 */
#define DMAMUX_CxCR_NBREQ_3                          (0x08UL << DMAMUX_CxCR_NBREQ_Pos)/*!< 0x00400000 */
#define DMAMUX_CxCR_NBREQ_4                          (0x10UL << DMAMUX_CxCR_NBREQ_Pos)/*!< 0x00800000 */

#define DMAMUX_CxCR_SYNC_ID_Pos                      (24U)
#define DMAMUX_CxCR_SYNC_ID_Msk                      (0x1FUL << DMAMUX_CxCR_SYNC_ID_Pos)/*!< 0x1F000000 */
#define DMAMUX_CxCR_SYNC_ID                          DMAMUX_CxCR_SYNC_ID_Msk
#define DMAMUX_CxCR_SYNC_ID_0                        (0x01UL << DMAMUX_CxCR_SYNC_ID_Pos)/*!< 0x01000000 */
#define DMAMUX_CxCR_SYNC_ID_1                        (0x02UL << DMAMUX_CxCR_SYNC_ID_Pos)/*!< 0x02000000 */
#define DMAMUX_CxCR_SYNC_ID_2                        (0x04UL << DMAMUX_CxCR_SYNC_ID_Pos)/*!< 0x04000000 */
#define DMAMUX_CxCR_SYNC_ID_3                        (0x08UL << DMAMUX_CxCR_SYNC_ID_Pos)/*!< 0x08000000 */
#define DMAMUX_CxCR_SYNC_ID_4                        (0x10UL << DMAMUX_CxCR_SYNC_ID_Pos)/*!< 0x10000000 */

/********************  Bits definition for DMAMUX_CSR register  ****************/
#define DMAMUX_CSR_SOF0_Pos                          (0U)
#define DMAMUX_CSR_SOF0_Msk                          (0x1UL << DMAMUX_CSR_SOF0_Pos)/*!< 0x00000001 */
#define DMAMUX_CSR_SOF0                              DMAMUX_CSR_SOF0_Msk
#define DMAMUX_CSR_SOF1_Pos                          (1U)
#define DMAMUX_CSR_SOF1_Msk                          (0x1UL << DMAMUX_CSR_SOF1_Pos)/*!< 0x00000002 */
#define DMAMUX_CSR_SOF1                              DMAMUX_CSR_SOF1_Msk
#define DMAMUX_CSR_SOF2_Pos                          (2U)
#define DMAMUX_CSR_SOF2_Msk                          (0x1UL << DMAMUX_CSR_SOF2_Pos)/*!< 0x00000004 */
#define DMAMUX_CSR_SOF2                              DMAMUX_CSR_SOF2_Msk
#define DMAMUX_CSR_SOF3_Pos                          (3U)
#define DMAMUX_CSR_SOF3_Msk                          (0x1UL << DMAMUX_CSR_SOF3_Pos)/*!< 0x00000008 */
#define DMAMUX_CSR_SOF3                              DMAMUX_CSR_SOF3_Msk
#define DMAMUX_CSR_SOF4_Pos                          (4U)
#define DMAMUX_CSR_SOF4_Msk                          (0x1UL << DMAMUX_CSR_SOF4_Pos)/*!< 0x00000010 */
#define DMAMUX_CSR_SOF4                              DMAMUX_CSR_SOF4_Msk
#define DMAMUX_CSR_SOF5_Pos                          (5U)
#define DMAMUX_CSR_SOF5_Msk                          (0x1UL << DMAMUX_CSR_SOF5_Pos)/*!< 0x00000020 */
#define DMAMUX_CSR_SOF5                              DMAMUX_CSR_SOF5_Msk
#define DMAMUX_CSR_SOF6_Pos                          (6U)
#define DMAMUX_CSR_SOF6_Msk                          (0x1UL << DMAMUX_CSR_SOF6_Pos)/*!< 0x00000040 */
#define DMAMUX_CSR_SOF6                              DMAMUX_CSR_SOF6_Msk
#define DMAMUX_CSR_SOF7_Pos                          (7U)
#define DMAMUX_CSR_SOF7_Msk                          (0x1UL << DMAMUX_CSR_SOF7_Pos)/*!< 0x00000080 */
#define DMAMUX_CSR_SOF7                              DMAMUX_CSR_SOF7_Msk
#define DMAMUX_CSR_SOF8_Pos                          (8U)
#define DMAMUX_CSR_SOF8_Msk                          (0x1UL << DMAMUX_CSR_SOF8_Pos)/*!< 0x00000100 */
#define DMAMUX_CSR_SOF8                              DMAMUX_CSR_SOF8_Msk
#define DMAMUX_CSR_SOF9_Pos                          (9U)
#define DMAMUX_CSR_SOF9_Msk                          (0x1UL << DMAMUX_CSR_SOF9_Pos)/*!< 0x00000200 */
#define DMAMUX_CSR_SOF9                              DMAMUX_CSR_SOF9_Msk
#define DMAMUX_CSR_SOF10_Pos                         (10U)
#define DMAMUX_CSR_SOF10_Msk                         (0x1UL << DMAMUX_CSR_SOF10_Pos)/*!< 0x00000400 */
#define DMAMUX_CSR_SOF10                             DMAMUX_CSR_SOF10_Msk
#define DMAMUX_CSR_SOF11_Pos                         (11U)
#define DMAMUX_CSR_SOF11_Msk                         (0x1UL << DMAMUX_CSR_SOF11_Pos)/*!< 0x00000800 */
#define DMAMUX_CSR_SOF11                              DMAMUX_CSR_SOF11_Msk
#define DMAMUX_CSR_SOF12_Pos                         (12U)
#define DMAMUX_CSR_SOF12_Msk                         (0x1UL << DMAMUX_CSR_SOF12_Pos)/*!< 0x00001000 */
#define DMAMUX_CSR_SOF12                             DMAMUX_CSR_SOF12_Msk
#define DMAMUX_CSR_SOF13_Pos                         (13U)
#define DMAMUX_CSR_SOF13_Msk                         (0x1UL << DMAMUX_CSR_SOF13_Pos)/*!< 0x00002000 */
#define DMAMUX_CSR_SOF13                             DMAMUX_CSR_SOF13_Msk
#define DMAMUX_CSR_SOF14_Pos                         (14U)
#define DMAMUX_CSR_SOF14_Msk                         (0x1UL << DMAMUX_CSR_SOF14_Pos)/*!< 0x00004000 */
#define DMAMUX_CSR_SOF14                             DMAMUX_CSR_SOF14_Msk
#define DMAMUX_CSR_SOF15_Pos                         (15U)
#define DMAMUX_CSR_SOF15_Msk                         (0x1UL << DMAMUX_CSR_SOF15_Pos)/*!< 0x00008000 */
#define DMAMUX_CSR_SOF15                             DMAMUX_CSR_SOF15_Msk

/********************  Bits definition for DMAMUX_CFR register  ****************/
#define DMAMUX_CFR_CSOF0_Pos                         (0U)
#define DMAMUX_CFR_CSOF0_Msk                         (0x1UL << DMAMUX_CFR_CSOF0_Pos)/*!< 0x00000001 */
#define DMAMUX_CFR_CSOF0                             DMAMUX_CFR_CSOF0_Msk
#define DMAMUX_CFR_CSOF1_Pos                         (1U)
#define DMAMUX_CFR_CSOF1_Msk                         (0x1UL << DMAMUX_CFR_CSOF1_Pos)/*!< 0x00000002 */
#define DMAMUX_CFR_CSOF1                             DMAMUX_CFR_CSOF1_Msk
#define DMAMUX_CFR_CSOF2_Pos                         (2U)
#define DMAMUX_CFR_CSOF2_Msk                         (0x1UL << DMAMUX_CFR_CSOF2_Pos)/*!< 0x00000004 */
#define DMAMUX_CFR_CSOF2                             DMAMUX_CFR_CSOF2_Msk
#define DMAMUX_CFR_CSOF3_Pos                         (3U)
#define DMAMUX_CFR_CSOF3_Msk                         (0x1UL << DMAMUX_CFR_CSOF3_Pos)/*!< 0x00000008 */
#define DMAMUX_CFR_CSOF3                             DMAMUX_CFR_CSOF3_Msk
#define DMAMUX_CFR_CSOF4_Pos                         (4U)
#define DMAMUX_CFR_CSOF4_Msk                         (0x1UL << DMAMUX_CFR_CSOF4_Pos)/*!< 0x00000010 */
#define DMAMUX_CFR_CSOF4                             DMAMUX_CFR_CSOF4_Msk
#define DMAMUX_CFR_CSOF5_Pos                         (5U)
#define DMAMUX_CFR_CSOF5_Msk                         (0x1UL << DMAMUX_CFR_CSOF5_Pos)/*!< 0x00000020 */
#define DMAMUX_CFR_CSOF5                             DMAMUX_CFR_CSOF5_Msk
#define DMAMUX_CFR_CSOF6_Pos                         (6U)
#define DMAMUX_CFR_CSOF6_Msk                         (0x1UL << DMAMUX_CFR_CSOF6_Pos)/*!< 0x00000040 */
#define DMAMUX_CFR_CSOF6                             DMAMUX_CFR_CSOF6_Msk
#define DMAMUX_CFR_CSOF7_Pos                         (7U)
#define DMAMUX_CFR_CSOF7_Msk                         (0x1UL << DMAMUX_CFR_CSOF7_Pos)/*!< 0x00000080 */
#define DMAMUX_CFR_CSOF7                             DMAMUX_CFR_CSOF7_Msk
#define DMAMUX_CFR_CSOF8_Pos                         (8U)
#define DMAMUX_CFR_CSOF8_Msk                         (0x1UL << DMAMUX_CFR_CSOF8_Pos)/*!< 0x00000100 */
#define DMAMUX_CFR_CSOF8                             DMAMUX_CFR_CSOF8_Msk
#define DMAMUX_CFR_CSOF9_Pos                         (9U)
#define DMAMUX_CFR_CSOF9_Msk                         (0x1UL << DMAMUX_CFR_CSOF9_Pos)/*!< 0x00000200 */
#define DMAMUX_CFR_CSOF9                             DMAMUX_CFR_CSOF9_Msk
#define DMAMUX_CFR_CSOF10_Pos                        (10U)
#define DMAMUX_CFR_CSOF10_Msk                        (0x1UL << DMAMUX_CFR_CSOF10_Pos)/*!< 0x00000400 */
#define DMAMUX_CFR_CSOF10                            DMAMUX_CFR_CSOF10_Msk
#define DMAMUX_CFR_CSOF11_Pos                        (11U)
#define DMAMUX_CFR_CSOF11_Msk                        (0x1UL << DMAMUX_CFR_CSOF11_Pos)/*!< 0x00000800 */
#define DMAMUX_CFR_CSOF11                            DMAMUX_CFR_CSOF11_Msk
#define DMAMUX_CFR_CSOF12_Pos                        (12U)
#define DMAMUX_CFR_CSOF12_Msk                        (0x1UL << DMAMUX_CFR_CSOF12_Pos)/*!< 0x00001000 */
#define DMAMUX_CFR_CSOF12                            DMAMUX_CFR_CSOF12_Msk
#define DMAMUX_CFR_CSOF13_Pos                        (13U)
#define DMAMUX_CFR_CSOF13_Msk                        (0x1UL << DMAMUX_CFR_CSOF13_Pos)/*!< 0x00002000 */
#define DMAMUX_CFR_CSOF13                            DMAMUX_CFR_CSOF13_Msk
#define DMAMUX_CFR_CSOF14_Pos                        (14U)
#define DMAMUX_CFR_CSOF14_Msk                        (0x1UL << DMAMUX_CFR_CSOF14_Pos)/*!< 0x00004000 */
#define DMAMUX_CFR_CSOF14                            DMAMUX_CFR_CSOF14_Msk
#define DMAMUX_CFR_CSOF15_Pos                        (15U)
#define DMAMUX_CFR_CSOF15_Msk                        (0x1UL << DMAMUX_CFR_CSOF15_Pos)/*!< 0x00008000 */
#define DMAMUX_CFR_CSOF15                            DMAMUX_CFR_CSOF15_Msk

/********************  Bits definition for DMAMUX_RGxCR register  ************/
#define DMAMUX_RGxCR_SIG_ID_Pos                      (0U)
#define DMAMUX_RGxCR_SIG_ID_Msk                      (0x1FUL << DMAMUX_RGxCR_SIG_ID_Pos)/*!< 0x0000001F */
#define DMAMUX_RGxCR_SIG_ID                          DMAMUX_RGxCR_SIG_ID_Msk
#define DMAMUX_RGxCR_SIG_ID_0                        (0x01UL << DMAMUX_RGxCR_SIG_ID_Pos)/*!< 0x00000001 */
#define DMAMUX_RGxCR_SIG_ID_1                        (0x02UL << DMAMUX_RGxCR_SIG_ID_Pos)/*!< 0x00000002 */
#define DMAMUX_RGxCR_SIG_ID_2                        (0x04UL << DMAMUX_RGxCR_SIG_ID_Pos)/*!< 0x00000004 */
#define DMAMUX_RGxCR_SIG_ID_3                        (0x08UL << DMAMUX_RGxCR_SIG_ID_Pos)/*!< 0x00000008 */
#define DMAMUX_RGxCR_SIG_ID_4                        (0x10UL << DMAMUX_RGxCR_SIG_ID_Pos)/*!< 0x00000010 */

#define DMAMUX_RGxCR_OIE_Pos                         (8U)
#define DMAMUX_RGxCR_OIE_Msk                         (0x1UL << DMAMUX_RGxCR_OIE_Pos)/*!< 0x00000100 */
#define DMAMUX_RGxCR_OIE                             DMAMUX_RGxCR_OIE_Msk

#define DMAMUX_RGxCR_GE_Pos                          (16U)
#define DMAMUX_RGxCR_GE_Msk                          (0x1UL << DMAMUX_RGxCR_GE_Pos)/*!< 0x00010000 */
#define DMAMUX_RGxCR_GE                              DMAMUX_RGxCR_GE_Msk

#define DMAMUX_RGxCR_GPOL_Pos                        (17U)
#define DMAMUX_RGxCR_GPOL_Msk                        (0x3UL << DMAMUX_RGxCR_GPOL_Pos)/*!< 0x00060000 */
#define DMAMUX_RGxCR_GPOL                            DMAMUX_RGxCR_GPOL_Msk
#define DMAMUX_RGxCR_GPOL_0                          (0x1UL << DMAMUX_RGxCR_GPOL_Pos)/*!< 0x00020000 */
#define DMAMUX_RGxCR_GPOL_1                          (0x2UL << DMAMUX_RGxCR_GPOL_Pos)/*!< 0x00040000 */

#define DMAMUX_RGxCR_GNBREQ_Pos                      (19U)
#define DMAMUX_RGxCR_GNBREQ_Msk                      (0x1FUL << DMAMUX_RGxCR_GNBREQ_Pos)/*!< 0x00F80000 */
#define DMAMUX_RGxCR_GNBREQ                          DMAMUX_RGxCR_GNBREQ_Msk
#define DMAMUX_RGxCR_GNBREQ_0                        (0x01UL << DMAMUX_RGxCR_GNBREQ_Pos)/*!< 0x00080000 */
#define DMAMUX_RGxCR_GNBREQ_1                        (0x02UL << DMAMUX_RGxCR_GNBREQ_Pos)/*!< 0x00100000 */
#define DMAMUX_RGxCR_GNBREQ_2                        (0x04UL << DMAMUX_RGxCR_GNBREQ_Pos)/*!< 0x00200000 */
#define DMAMUX_RGxCR_GNBREQ_3                        (0x08UL << DMAMUX_RGxCR_GNBREQ_Pos)/*!< 0x00400000 */
#define DMAMUX_RGxCR_GNBREQ_4                        (0x10UL << DMAMUX_RGxCR_GNBREQ_Pos)/*!< 0x00800000 */

/********************  Bits definition for DMAMUX_RGSR register  **************/
#define DMAMUX_RGSR_OF0_Pos                          (0U)
#define DMAMUX_RGSR_OF0_Msk                          (0x1UL << DMAMUX_RGSR_OF0_Pos)/*!< 0x00000001 */
#define DMAMUX_RGSR_OF0                              DMAMUX_RGSR_OF0_Msk
#define DMAMUX_RGSR_OF1_Pos                          (1U)
#define DMAMUX_RGSR_OF1_Msk                          (0x1UL << DMAMUX_RGSR_OF1_Pos)/*!< 0x00000002 */
#define DMAMUX_RGSR_OF1                              DMAMUX_RGSR_OF1_Msk
#define DMAMUX_RGSR_OF2_Pos                          (2U)
#define DMAMUX_RGSR_OF2_Msk                          (0x1UL << DMAMUX_RGSR_OF2_Pos)/*!< 0x00000004 */
#define DMAMUX_RGSR_OF2                              DMAMUX_RGSR_OF2_Msk
#define DMAMUX_RGSR_OF3_Pos                          (3U)
#define DMAMUX_RGSR_OF3_Msk                          (0x1UL << DMAMUX_RGSR_OF3_Pos)/*!< 0x00000008 */
#define DMAMUX_RGSR_OF3                              DMAMUX_RGSR_OF3_Msk

/********************  Bits definition for DMAMUX_RGCFR register  ************/
#define DMAMUX_RGCFR_COF0_Pos                        (0U)
#define DMAMUX_RGCFR_COF0_Msk                        (0x1UL << DMAMUX_RGCFR_COF0_Pos)/*!< 0x00000001 */
#define DMAMUX_RGCFR_COF0                            DMAMUX_RGCFR_COF0_Msk
#define DMAMUX_RGCFR_COF1_Pos                        (1U)
#define DMAMUX_RGCFR_COF1_Msk                        (0x1UL << DMAMUX_RGCFR_COF1_Pos)/*!< 0x00000002 */
#define DMAMUX_RGCFR_COF1                            DMAMUX_RGCFR_COF1_Msk
#define DMAMUX_RGCFR_COF2_Pos                        (2U)
#define DMAMUX_RGCFR_COF2_Msk                        (0x1UL << DMAMUX_RGCFR_COF2_Pos)/*!< 0x00000004 */
#define DMAMUX_RGCFR_COF2                            DMAMUX_RGCFR_COF2_Msk
#define DMAMUX_RGCFR_COF3_Pos                        (3U)
#define DMAMUX_RGCFR_COF3_Msk                        (0x1UL << DMAMUX_RGCFR_COF3_Pos)/*!< 0x00000008 */
#define DMAMUX_RGCFR_COF3                            DMAMUX_RGCFR_COF3_Msk

/*****************************************************************************/
/*                                                                           */
/*                    External Interrupt/Event Controller                    */
/*                                                                           */
/*****************************************************************************/
/*******************  Bit definition for EXTI_RTSR1 register  ****************/
#define EXTI_RTSR1_RT0_Pos           (0U)
#define EXTI_RTSR1_RT0_Msk           (0x1UL << EXTI_RTSR1_RT0_Pos)             /*!< 0x00000001 */
#define EXTI_RTSR1_RT0               EXTI_RTSR1_RT0_Msk                        /*!< Rising trigger configuration for input line 0 */
#define EXTI_RTSR1_RT1_Pos           (1U)
#define EXTI_RTSR1_RT1_Msk           (0x1UL << EXTI_RTSR1_RT1_Pos)             /*!< 0x00000002 */
#define EXTI_RTSR1_RT1               EXTI_RTSR1_RT1_Msk                        /*!< Rising trigger configuration for input line 1 */
#define EXTI_RTSR1_RT2_Pos           (2U)
#define EXTI_RTSR1_RT2_Msk           (0x1UL << EXTI_RTSR1_RT2_Pos)             /*!< 0x00000004 */
#define EXTI_RTSR1_RT2               EXTI_RTSR1_RT2_Msk                        /*!< Rising trigger configuration for input line 2 */
#define EXTI_RTSR1_RT3_Pos           (3U)
#define EXTI_RTSR1_RT3_Msk           (0x1UL << EXTI_RTSR1_RT3_Pos)             /*!< 0x00000008 */
#define EXTI_RTSR1_RT3               EXTI_RTSR1_RT3_Msk                        /*!< Rising trigger configuration for input line 3 */
#define EXTI_RTSR1_RT4_Pos           (4U)
#define EXTI_RTSR1_RT4_Msk           (0x1UL << EXTI_RTSR1_RT4_Pos)             /*!< 0x00000010 */
#define EXTI_RTSR1_RT4               EXTI_RTSR1_RT4_Msk                        /*!< Rising trigger configuration for input line 4 */
#define EXTI_RTSR1_RT5_Pos           (5U)
#define EXTI_RTSR1_RT5_Msk           (0x1UL << EXTI_RTSR1_RT5_Pos)             /*!< 0x00000020 */
#define EXTI_RTSR1_RT5               EXTI_RTSR1_RT5_Msk                        /*!< Rising trigger configuration for input line 5 */
#define EXTI_RTSR1_RT6_Pos           (6U)
#define EXTI_RTSR1_RT6_Msk           (0x1UL << EXTI_RTSR1_RT6_Pos)             /*!< 0x00000040 */
#define EXTI_RTSR1_RT6               EXTI_RTSR1_RT6_Msk                        /*!< Rising trigger configuration for input line 6 */
#define EXTI_RTSR1_RT7_Pos           (7U)
#define EXTI_RTSR1_RT7_Msk           (0x1UL << EXTI_RTSR1_RT7_Pos)             /*!< 0x00000080 */
#define EXTI_RTSR1_RT7               EXTI_RTSR1_RT7_Msk                        /*!< Rising trigger configuration for input line 7 */
#define EXTI_RTSR1_RT8_Pos           (8U)
#define EXTI_RTSR1_RT8_Msk           (0x1UL << EXTI_RTSR1_RT8_Pos)             /*!< 0x00000100 */
#define EXTI_RTSR1_RT8               EXTI_RTSR1_RT8_Msk                        /*!< Rising trigger configuration for input line 8 */
#define EXTI_RTSR1_RT9_Pos           (9U)
#define EXTI_RTSR1_RT9_Msk           (0x1UL << EXTI_RTSR1_RT9_Pos)             /*!< 0x00000200 */
#define EXTI_RTSR1_RT9               EXTI_RTSR1_RT9_Msk                        /*!< Rising trigger configuration for input line 9 */
#define EXTI_RTSR1_RT10_Pos          (10U)
#define EXTI_RTSR1_RT10_Msk          (0x1UL << EXTI_RTSR1_RT10_Pos)            /*!< 0x00000400 */
#define EXTI_RTSR1_RT10              EXTI_RTSR1_RT10_Msk                       /*!< Rising trigger configuration for input line 10 */
#define EXTI_RTSR1_RT11_Pos          (11U)
#define EXTI_RTSR1_RT11_Msk          (0x1UL << EXTI_RTSR1_RT11_Pos)            /*!< 0x00000800 */
#define EXTI_RTSR1_RT11              EXTI_RTSR1_RT11_Msk                       /*!< Rising trigger configuration for input line 11 */
#define EXTI_RTSR1_RT12_Pos          (12U)
#define EXTI_RTSR1_RT12_Msk          (0x1UL << EXTI_RTSR1_RT12_Pos)            /*!< 0x00001000 */
#define EXTI_RTSR1_RT12              EXTI_RTSR1_RT12_Msk                       /*!< Rising trigger configuration for input line 12 */
#define EXTI_RTSR1_RT13_Pos          (13U)
#define EXTI_RTSR1_RT13_Msk          (0x1UL << EXTI_RTSR1_RT13_Pos)            /*!< 0x00002000 */
#define EXTI_RTSR1_RT13              EXTI_RTSR1_RT13_Msk                       /*!< Rising trigger configuration for input line 13 */
#define EXTI_RTSR1_RT14_Pos          (14U)
#define EXTI_RTSR1_RT14_Msk          (0x1UL << EXTI_RTSR1_RT14_Pos)            /*!< 0x00004000 */
#define EXTI_RTSR1_RT14              EXTI_RTSR1_RT14_Msk                       /*!< Rising trigger configuration for input line 14 */
#define EXTI_RTSR1_RT15_Pos          (15U)
#define EXTI_RTSR1_RT15_Msk          (0x1UL << EXTI_RTSR1_RT15_Pos)            /*!< 0x00008000 */
#define EXTI_RTSR1_RT15              EXTI_RTSR1_RT15_Msk                       /*!< Rising trigger configuration for input line 15 */
#define EXTI_RTSR1_RT16_Pos          (16U)
#define EXTI_RTSR1_RT16_Msk          (0x1UL << EXTI_RTSR1_RT16_Pos)            /*!< 0x00010000 */
#define EXTI_RTSR1_RT16              EXTI_RTSR1_RT16_Msk                       /*!< Rising trigger configuration for input line 16 */
#define EXTI_RTSR1_RT21_Pos          (21U)
#define EXTI_RTSR1_RT21_Msk          (0x1UL << EXTI_RTSR1_RT21_Pos)            /*!< 0x00200000 */
#define EXTI_RTSR1_RT21              EXTI_RTSR1_RT21_Msk                       /*!< Rising trigger configuration for input line 21 */
#define EXTI_RTSR1_RT22_Pos          (22U)
#define EXTI_RTSR1_RT22_Msk          (0x1UL << EXTI_RTSR1_RT22_Pos)            /*!< 0x00400000 */
#define EXTI_RTSR1_RT22              EXTI_RTSR1_RT22_Msk                       /*!< Rising trigger configuration for input line 22 */
#define EXTI_RTSR1_RT23_Pos          (23U)
#define EXTI_RTSR1_RT23_Msk          (0x1UL << EXTI_RTSR1_RT23_Pos)            /*!< 0x00800000 */
#define EXTI_RTSR1_RT23              EXTI_RTSR1_RT23_Msk                       /*!< Rising trigger configuration for input line 23 */
#define EXTI_RTSR1_RT24_Pos          (24U)
#define EXTI_RTSR1_RT24_Msk          (0x1UL << EXTI_RTSR1_RT24_Pos)            /*!< 0x01000000 */
#define EXTI_RTSR1_RT24              EXTI_RTSR1_RT24_Msk                       /*!< Rising trigger configuration for input line 24 */
#define EXTI_RTSR1_RT25_Pos          (25U)
#define EXTI_RTSR1_RT25_Msk          (0x1UL << EXTI_RTSR1_RT25_Pos)            /*!< 0x02000000 */
#define EXTI_RTSR1_RT25              EXTI_RTSR1_RT25_Msk                       /*!< Rising trigger configuration for input line 25 */
#define EXTI_RTSR1_RT26_Pos          (26U)
#define EXTI_RTSR1_RT26_Msk          (0x1UL << EXTI_RTSR1_RT26_Pos)            /*!< 0x04000000 */
#define EXTI_RTSR1_RT26              EXTI_RTSR1_RT26_Msk                       /*!< Rising trigger configuration for input line 26 */
#define EXTI_RTSR1_RT27_Pos          (27U)
#define EXTI_RTSR1_RT27_Msk          (0x1UL << EXTI_RTSR1_RT27_Pos)            /*!< 0x08000000 */
#define EXTI_RTSR1_RT27              EXTI_RTSR1_RT27_Msk                       /*!< Rising trigger configuration for input line 27 */
#define EXTI_RTSR1_RT28_Pos          (28U)
#define EXTI_RTSR1_RT28_Msk          (0x1UL << EXTI_RTSR1_RT28_Pos)            /*!< 0x10000000 */
#define EXTI_RTSR1_RT28              EXTI_RTSR1_RT28_Msk                       /*!< Rising trigger configuration for input line 28 */
#define EXTI_RTSR1_RT29_Pos          (29U)
#define EXTI_RTSR1_RT29_Msk          (0x1UL << EXTI_RTSR1_RT29_Pos)            /*!< 0x20000000 */
#define EXTI_RTSR1_RT29              EXTI_RTSR1_RT29_Msk                       /*!< Rising trigger configuration for input line 29 */
#define EXTI_RTSR1_RT30_Pos          (30U)
#define EXTI_RTSR1_RT30_Msk          (0x1UL << EXTI_RTSR1_RT30_Pos)            /*!< 0x40000000 */
#define EXTI_RTSR1_RT30              EXTI_RTSR1_RT30_Msk                       /*!< Rising trigger configuration for input line 30 */
#define EXTI_RTSR1_RT31_Pos          (31U)
#define EXTI_RTSR1_RT31_Msk          (0x1UL << EXTI_RTSR1_RT31_Pos)            /*!< 0x80000000 */
#define EXTI_RTSR1_RT31              EXTI_RTSR1_RT31_Msk                       /*!< Rising trigger configuration for input line 31 */

/*******************  Bit definition for EXTI_RTSR2 register  ****************/
#define EXTI_RTSR2_RT32_Pos          (0U)
#define EXTI_RTSR2_RT32_Msk          (0x1UL << EXTI_RTSR2_RT32_Pos)            /*!< 0x00000001 */
#define EXTI_RTSR2_RT32              EXTI_RTSR2_RT32_Msk                       /*!< Rising trigger configuration for input line 32 */
#define EXTI_RTSR2_RT33_Pos          (1U)
#define EXTI_RTSR2_RT33_Msk          (0x1UL << EXTI_RTSR2_RT33_Pos)            /*!< 0x00000002 */
#define EXTI_RTSR2_RT33              EXTI_RTSR2_RT33_Msk                       /*!< Rising trigger configuration for input line 33 */
#define EXTI_RTSR2_RT34_Pos          (2U)
#define EXTI_RTSR2_RT34_Msk          (0x1UL << EXTI_RTSR2_RT34_Pos)             /*!< 0x00000004 */
#define EXTI_RTSR2_RT34              EXTI_RTSR2_RT34_Msk                        /*!< Rising trigger configuration for input line 34 */
#define EXTI_RTSR2_RT35_Pos          (3U)
#define EXTI_RTSR2_RT35_Msk          (0x1UL << EXTI_RTSR2_RT35_Pos)             /*!< 0x00000008 */
#define EXTI_RTSR2_RT35              EXTI_RTSR2_RT35_Msk                        /*!< Rising trigger configuration for input line 35 */
#define EXTI_RTSR2_RT36_Pos          (4U)
#define EXTI_RTSR2_RT36_Msk          (0x1UL << EXTI_RTSR2_RT36_Pos)             /*!< 0x00000010 */
#define EXTI_RTSR2_RT36              EXTI_RTSR2_RT36_Msk                        /*!< Rising trigger configuration for input line 36 */
#define EXTI_RTSR2_RT37_Pos          (5U)
#define EXTI_RTSR2_RT37_Msk          (0x1UL << EXTI_RTSR2_RT37_Pos)             /*!< 0x00000020 */
#define EXTI_RTSR2_RT37              EXTI_RTSR2_RT37_Msk                        /*!< Rising trigger configuration for input line 37 */
#define EXTI_RTSR2_RT38_Pos          (6U)
#define EXTI_RTSR2_RT38_Msk          (0x1UL << EXTI_RTSR2_RT38_Pos)             /*!< 0x00000040 */
#define EXTI_RTSR2_RT38              EXTI_RTSR2_RT38_Msk                        /*!< Rising trigger configuration for input line 38 */
#define EXTI_RTSR2_RT39_Pos          (7U)
#define EXTI_RTSR2_RT39_Msk          (0x1UL << EXTI_RTSR2_RT39_Pos)             /*!< 0x00000080 */
#define EXTI_RTSR2_RT39              EXTI_RTSR2_RT39_Msk                        /*!< Rising trigger configuration for input line 39 */
#define EXTI_RTSR2_RT40_Pos          (8U)
#define EXTI_RTSR2_RT40_Msk          (0x1UL << EXTI_RTSR2_RT40_Pos)             /*!< 0x00000100 */
#define EXTI_RTSR2_RT40              EXTI_RTSR2_RT40_Msk                        /*!< Rising trigger configuration for input line 40 */
#define EXTI_RTSR2_RT41_Pos          (9U)
#define EXTI_RTSR2_RT41_Msk          (0x1UL << EXTI_RTSR2_RT41_Pos)             /*!< 0x00000200 */
#define EXTI_RTSR2_RT41              EXTI_RTSR2_RT41_Msk                        /*!< Rising trigger configuration for input line 41 */
#define EXTI_RTSR2_RT42_Pos          (10U)
#define EXTI_RTSR2_RT42_Msk          (0x1UL << EXTI_RTSR2_RT42_Pos)             /*!< 0x00000400 */
#define EXTI_RTSR2_RT42              EXTI_RTSR2_RT42_Msk                        /*!< Rising trigger configuration for input line 42 */

/*******************  Bit definition for EXTI_FTSR1 register  ****************/
#define EXTI_FTSR1_FT0_Pos           (0U)
#define EXTI_FTSR1_FT0_Msk           (0x1UL << EXTI_FTSR1_FT0_Pos)             /*!< 0x00000001 */
#define EXTI_FTSR1_FT0               EXTI_FTSR1_FT0_Msk                        /*!< Falling trigger configuration for input line 0 */
#define EXTI_FTSR1_FT1_Pos           (1U)
#define EXTI_FTSR1_FT1_Msk           (0x1UL << EXTI_FTSR1_FT1_Pos)             /*!< 0x00000002 */
#define EXTI_FTSR1_FT1               EXTI_FTSR1_FT1_Msk                        /*!< Falling trigger configuration for input line 1 */
#define EXTI_FTSR1_FT2_Pos           (2U)
#define EXTI_FTSR1_FT2_Msk           (0x1UL << EXTI_FTSR1_FT2_Pos)             /*!< 0x00000004 */
#define EXTI_FTSR1_FT2               EXTI_FTSR1_FT2_Msk                        /*!< Falling trigger configuration for input line 2 */
#define EXTI_FTSR1_FT3_Pos           (3U)
#define EXTI_FTSR1_FT3_Msk           (0x1UL << EXTI_FTSR1_FT3_Pos)             /*!< 0x00000008 */
#define EXTI_FTSR1_FT3               EXTI_FTSR1_FT3_Msk                        /*!< Falling trigger configuration for input line 3 */
#define EXTI_FTSR1_FT4_Pos           (4U)
#define EXTI_FTSR1_FT4_Msk           (0x1UL << EXTI_FTSR1_FT4_Pos)             /*!< 0x00000010 */
#define EXTI_FTSR1_FT4               EXTI_FTSR1_FT4_Msk                        /*!< Falling trigger configuration for input line 4 */
#define EXTI_FTSR1_FT5_Pos           (5U)
#define EXTI_FTSR1_FT5_Msk           (0x1UL << EXTI_FTSR1_FT5_Pos)             /*!< 0x00000020 */
#define EXTI_FTSR1_FT5               EXTI_FTSR1_FT5_Msk                        /*!< Falling trigger configuration for input line 5 */
#define EXTI_FTSR1_FT6_Pos           (6U)
#define EXTI_FTSR1_FT6_Msk           (0x1UL << EXTI_FTSR1_FT6_Pos)             /*!< 0x00000040 */
#define EXTI_FTSR1_FT6               EXTI_FTSR1_FT6_Msk                        /*!< Falling trigger configuration for input line 6 */
#define EXTI_FTSR1_FT7_Pos           (7U)
#define EXTI_FTSR1_FT7_Msk           (0x1UL << EXTI_FTSR1_FT7_Pos)             /*!< 0x00000080 */
#define EXTI_FTSR1_FT7               EXTI_FTSR1_FT7_Msk                        /*!< Falling trigger configuration for input line 7 */
#define EXTI_FTSR1_FT8_Pos           (8U)
#define EXTI_FTSR1_FT8_Msk           (0x1UL << EXTI_FTSR1_FT8_Pos)             /*!< 0x00000100 */
#define EXTI_FTSR1_FT8               EXTI_FTSR1_FT8_Msk                        /*!< Falling trigger configuration for input line 8 */
#define EXTI_FTSR1_FT9_Pos           (9U)
#define EXTI_FTSR1_FT9_Msk           (0x1UL << EXTI_FTSR1_FT9_Pos)             /*!< 0x00000200 */
#define EXTI_FTSR1_FT9               EXTI_FTSR1_FT9_Msk                        /*!< Falling trigger configuration for input line 9 */
#define EXTI_FTSR1_FT10_Pos          (10U)
#define EXTI_FTSR1_FT10_Msk          (0x1UL << EXTI_FTSR1_FT10_Pos)            /*!< 0x00000400 */
#define EXTI_FTSR1_FT10              EXTI_FTSR1_FT10_Msk                       /*!< Falling trigger configuration for input line 10 */
#define EXTI_FTSR1_FT11_Pos          (11U)
#define EXTI_FTSR1_FT11_Msk          (0x1UL << EXTI_FTSR1_FT11_Pos)            /*!< 0x00000800 */
#define EXTI_FTSR1_FT11              EXTI_FTSR1_FT11_Msk                       /*!< Falling trigger configuration for input line 11 */
#define EXTI_FTSR1_FT12_Pos          (12U)
#define EXTI_FTSR1_FT12_Msk          (0x1UL << EXTI_FTSR1_FT12_Pos)            /*!< 0x00001000 */
#define EXTI_FTSR1_FT12              EXTI_FTSR1_FT12_Msk                       /*!< Falling trigger configuration for input line 12 */
#define EXTI_FTSR1_FT13_Pos          (13U)
#define EXTI_FTSR1_FT13_Msk          (0x1UL << EXTI_FTSR1_FT13_Pos)            /*!< 0x00002000 */
#define EXTI_FTSR1_FT13              EXTI_FTSR1_FT13_Msk                       /*!< Falling trigger configuration for input line 13 */
#define EXTI_FTSR1_FT14_Pos          (14U)
#define EXTI_FTSR1_FT14_Msk          (0x1UL << EXTI_FTSR1_FT14_Pos)            /*!< 0x00004000 */
#define EXTI_FTSR1_FT14              EXTI_FTSR1_FT14_Msk                       /*!< Falling trigger configuration for input line 14 */
#define EXTI_FTSR1_FT15_Pos          (15U)
#define EXTI_FTSR1_FT15_Msk          (0x1UL << EXTI_FTSR1_FT15_Pos)            /*!< 0x00008000 */
#define EXTI_FTSR1_FT15              EXTI_FTSR1_FT15_Msk                       /*!< Falling trigger configuration for input line 15 */
#define EXTI_FTSR1_FT16_Pos          (16U)
#define EXTI_FTSR1_FT16_Msk          (0x1UL << EXTI_FTSR1_FT16_Pos)            /*!< 0x00010000 */
#define EXTI_FTSR1_FT16              EXTI_FTSR1_FT16_Msk                       /*!< Falling trigger configuration for input line 16 */
#define EXTI_FTSR1_FT21_Pos          (21U)
#define EXTI_FTSR1_FT21_Msk          (0x1UL << EXTI_FTSR1_FT21_Pos)            /*!< 0x00200000 */
#define EXTI_FTSR1_FT21              EXTI_FTSR1_FT21_Msk                       /*!< Falling trigger configuration for input line 21 */
#define EXTI_FTSR1_FT22_Pos          (22U)
#define EXTI_FTSR1_FT22_Msk          (0x1UL << EXTI_FTSR1_FT22_Pos)            /*!< 0x00400000 */
#define EXTI_FTSR1_FT22              EXTI_FTSR1_FT22_Msk                       /*!< Falling trigger configuration for input line 22 */
#define EXTI_FTSR1_FT23_Pos          (23U)
#define EXTI_FTSR1_FT23_Msk          (0x1UL << EXTI_FTSR1_FT23_Pos)            /*!< 0x00800000 */
#define EXTI_FTSR1_FT23              EXTI_FTSR1_FT23_Msk                       /*!< Falling trigger configuration for input line 23 */
#define EXTI_FTSR1_FT24_Pos          (24U)
#define EXTI_FTSR1_FT24_Msk          (0x1UL << EXTI_FTSR1_FT24_Pos)            /*!< 0x01000000 */
#define EXTI_FTSR1_FT24              EXTI_FTSR1_FT24_Msk                       /*!< Falling trigger configuration for input line 24 */
#define EXTI_FTSR1_FT25_Pos          (25U)
#define EXTI_FTSR1_FT25_Msk          (0x1UL << EXTI_FTSR1_FT25_Pos)            /*!< 0x02000000 */
#define EXTI_FTSR1_FT25              EXTI_FTSR1_FT25_Msk                       /*!< Falling trigger configuration for input line 25 */
#define EXTI_FTSR1_FT26_Pos          (26U)
#define EXTI_FTSR1_FT26_Msk          (0x1UL << EXTI_FTSR1_FT26_Pos)            /*!< 0x04000000 */
#define EXTI_FTSR1_FT26              EXTI_FTSR1_FT26_Msk                       /*!< Falling trigger configuration for input line 26 */
#define EXTI_FTSR1_FT27_Pos          (27U)
#define EXTI_FTSR1_FT27_Msk          (0x1UL << EXTI_FTSR1_FT27_Pos)            /*!< 0x08000000 */
#define EXTI_FTSR1_FT27              EXTI_FTSR1_FT27_Msk                       /*!< Falling trigger configuration for input line 27 */
#define EXTI_FTSR1_FT28_Pos          (28U)
#define EXTI_FTSR1_FT28_Msk          (0x1UL << EXTI_FTSR1_FT28_Pos)            /*!< 0x10000000 */
#define EXTI_FTSR1_FT28              EXTI_FTSR1_FT28_Msk                       /*!< Falling trigger configuration for input line 28 */
#define EXTI_FTSR1_FT29_Pos          (29U)
#define EXTI_FTSR1_FT29_Msk          (0x1UL << EXTI_FTSR1_FT29_Pos)            /*!< 0x20000000 */
#define EXTI_FTSR1_FT29              EXTI_FTSR1_FT29_Msk                       /*!< Falling trigger configuration for input line 29 */
#define EXTI_FTSR1_FT30_Pos          (30U)
#define EXTI_FTSR1_FT30_Msk          (0x1UL << EXTI_FTSR1_FT30_Pos)            /*!< 0x40000000 */
#define EXTI_FTSR1_FT30              EXTI_FTSR1_FT30_Msk                       /*!< Falling trigger configuration for input line 30 */
#define EXTI_FTSR1_FT31_Pos          (31U)
#define EXTI_FTSR1_FT31_Msk          (0x1UL << EXTI_FTSR1_FT31_Pos)            /*!< 0x80000000 */
#define EXTI_FTSR1_FT31              EXTI_FTSR1_FT31_Msk                       /*!< Falling trigger configuration for input line 31 */

/*******************  Bit definition for EXTI_FTSR2 register  ****************/
#define EXTI_FTSR2_FT32_Pos          (0U)
#define EXTI_FTSR2_FT32_Msk          (0x1UL << EXTI_FTSR2_FT32_Pos)            /*!< 0x00000001 */
#define EXTI_FTSR2_FT32              EXTI_FTSR2_FT32_Msk                       /*!< Falling trigger configuration for input line 32 */
#define EXTI_FTSR2_FT33_Pos          (1U)
#define EXTI_FTSR2_FT33_Msk          (0x1UL << EXTI_FTSR2_FT33_Pos)            /*!< 0x00000002 */
#define EXTI_FTSR2_FT33              EXTI_FTSR2_FT33_Msk                       /*!< Falling trigger configuration for input line 33 */
#define EXTI_FTSR2_FT34_Pos          (2U)
#define EXTI_FTSR2_FT34_Msk          (0x1UL << EXTI_FTSR2_FT34_Pos)             /*!< 0x00000004 */
#define EXTI_FTSR2_FT34              EXTI_FTSR2_FT34_Msk                        /*!< Falling trigger configuration for input line 34 */
#define EXTI_FTSR2_FT35_Pos          (3U)
#define EXTI_FTSR2_FT35_Msk          (0x1UL << EXTI_FTSR2_FT35_Pos)             /*!< 0x00000008 */
#define EXTI_FTSR2_FT35              EXTI_FTSR2_FT35_Msk                        /*!< Falling trigger configuration for input line 35 */
#define EXTI_FTSR2_FT36_Pos          (4U)
#define EXTI_FTSR2_FT36_Msk          (0x1UL << EXTI_FTSR2_FT36_Pos)             /*!< 0x00000010 */
#define EXTI_FTSR2_FT36              EXTI_FTSR2_FT36_Msk                        /*!< Falling trigger configuration for input line 36 */
#define EXTI_FTSR2_FT37_Pos          (5U)
#define EXTI_FTSR2_FT37_Msk          (0x1UL << EXTI_FTSR2_FT37_Pos)             /*!< 0x00000020 */
#define EXTI_FTSR2_FT37              EXTI_FTSR2_FT37_Msk                        /*!< Falling trigger configuration for input line 37 */
#define EXTI_FTSR2_FT38_Pos          (6U)
#define EXTI_FTSR2_FT38_Msk          (0x1UL << EXTI_FTSR2_FT38_Pos)             /*!< 0x00000040 */
#define EXTI_FTSR2_FT38              EXTI_FTSR2_FT38_Msk                        /*!< Falling trigger configuration for input line 38 */
#define EXTI_FTSR2_FT39_Pos          (7U)
#define EXTI_FTSR2_FT39_Msk          (0x1UL << EXTI_FTSR2_FT39_Pos)             /*!< 0x00000080 */
#define EXTI_FTSR2_FT39              EXTI_FTSR2_FT39_Msk                        /*!< Falling trigger configuration for input line 39 */
#define EXTI_FTSR2_FT40_Pos          (8U)
#define EXTI_FTSR2_FT40_Msk          (0x1UL << EXTI_FTSR2_FT40_Pos)             /*!< 0x00000100 */
#define EXTI_FTSR2_FT40              EXTI_FTSR2_FT40_Msk                        /*!< Falling trigger configuration for input line 40 */
#define EXTI_FTSR2_FT41_Pos          (9U)
#define EXTI_FTSR2_FT41_Msk          (0x1UL << EXTI_FTSR2_FT41_Pos)             /*!< 0x00000200 */
#define EXTI_FTSR2_FT41              EXTI_FTSR2_FT41_Msk                        /*!< Falling trigger configuration for input line 41 */
#define EXTI_FTSR2_FT42_Pos          (10U)
#define EXTI_FTSR2_FT42_Msk          (0x1UL << EXTI_FTSR2_FT42_Pos)             /*!< 0x00000400 */
#define EXTI_FTSR2_FT42              EXTI_FTSR2_FT42_Msk                        /*!< Falling trigger configuration for input line 42 */

/*******************  Bit definition for EXTI_SWIER1 register  ***************/
#define EXTI_SWIER1_SWI0_Pos         (0U)
#define EXTI_SWIER1_SWI0_Msk         (0x1UL << EXTI_SWIER1_SWI0_Pos)           /*!< 0x00000001 */
#define EXTI_SWIER1_SWI0             EXTI_SWIER1_SWI0_Msk                      /*!< Software Interrupt on line 0 */
#define EXTI_SWIER1_SWI1_Pos         (1U)
#define EXTI_SWIER1_SWI1_Msk         (0x1UL << EXTI_SWIER1_SWI1_Pos)           /*!< 0x00000002 */
#define EXTI_SWIER1_SWI1             EXTI_SWIER1_SWI1_Msk                      /*!< Software Interrupt on line 1 */
#define EXTI_SWIER1_SWI2_Pos         (2U)
#define EXTI_SWIER1_SWI2_Msk         (0x1UL << EXTI_SWIER1_SWI2_Pos)           /*!< 0x00000004 */
#define EXTI_SWIER1_SWI2             EXTI_SWIER1_SWI2_Msk                      /*!< Software Interrupt on line 2 */
#define EXTI_SWIER1_SWI3_Pos         (3U)
#define EXTI_SWIER1_SWI3_Msk         (0x1UL << EXTI_SWIER1_SWI3_Pos)           /*!< 0x00000008 */
#define EXTI_SWIER1_SWI3             EXTI_SWIER1_SWI3_Msk                      /*!< Software Interrupt on line 3 */
#define EXTI_SWIER1_SWI4_Pos         (4U)
#define EXTI_SWIER1_SWI4_Msk         (0x1UL << EXTI_SWIER1_SWI4_Pos)           /*!< 0x00000010 */
#define EXTI_SWIER1_SWI4             EXTI_SWIER1_SWI4_Msk                      /*!< Software Interrupt on line 4 */
#define EXTI_SWIER1_SWI5_Pos         (5U)
#define EXTI_SWIER1_SWI5_Msk         (0x1UL << EXTI_SWIER1_SWI5_Pos)           /*!< 0x00000020 */
#define EXTI_SWIER1_SWI5             EXTI_SWIER1_SWI5_Msk                      /*!< Software Interrupt on line 5 */
#define EXTI_SWIER1_SWI6_Pos         (6U)
#define EXTI_SWIER1_SWI6_Msk         (0x1UL << EXTI_SWIER1_SWI6_Pos)           /*!< 0x00000040 */
#define EXTI_SWIER1_SWI6             EXTI_SWIER1_SWI6_Msk                      /*!< Software Interrupt on line 6 */
#define EXTI_SWIER1_SWI7_Pos         (7U)
#define EXTI_SWIER1_SWI7_Msk         (0x1UL << EXTI_SWIER1_SWI7_Pos)           /*!< 0x00000080 */
#define EXTI_SWIER1_SWI7             EXTI_SWIER1_SWI7_Msk                      /*!< Software Interrupt on line 7 */
#define EXTI_SWIER1_SWI8_Pos         (8U)
#define EXTI_SWIER1_SWI8_Msk         (0x1UL << EXTI_SWIER1_SWI8_Pos)           /*!< 0x00000100 */
#define EXTI_SWIER1_SWI8             EXTI_SWIER1_SWI8_Msk                      /*!< Software Interrupt on line 8 */
#define EXTI_SWIER1_SWI9_Pos         (9U)
#define EXTI_SWIER1_SWI9_Msk         (0x1UL << EXTI_SWIER1_SWI9_Pos)           /*!< 0x00000200 */
#define EXTI_SWIER1_SWI9             EXTI_SWIER1_SWI9_Msk                      /*!< Software Interrupt on line 9 */
#define EXTI_SWIER1_SWI10_Pos        (10U)
#define EXTI_SWIER1_SWI10_Msk        (0x1UL << EXTI_SWIER1_SWI10_Pos)          /*!< 0x00000400 */
#define EXTI_SWIER1_SWI10            EXTI_SWIER1_SWI10_Msk                     /*!< Software Interrupt on line 10 */
#define EXTI_SWIER1_SWI11_Pos        (11U)
#define EXTI_SWIER1_SWI11_Msk        (0x1UL << EXTI_SWIER1_SWI11_Pos)          /*!< 0x00000800 */
#define EXTI_SWIER1_SWI11            EXTI_SWIER1_SWI11_Msk                     /*!< Software Interrupt on line 11 */
#define EXTI_SWIER1_SWI12_Pos        (12U)
#define EXTI_SWIER1_SWI12_Msk        (0x1UL << EXTI_SWIER1_SWI12_Pos)          /*!< 0x00001000 */
#define EXTI_SWIER1_SWI12            EXTI_SWIER1_SWI12_Msk                     /*!< Software Interrupt on line 12 */
#define EXTI_SWIER1_SWI13_Pos        (13U)
#define EXTI_SWIER1_SWI13_Msk        (0x1UL << EXTI_SWIER1_SWI13_Pos)          /*!< 0x00002000 */
#define EXTI_SWIER1_SWI13            EXTI_SWIER1_SWI13_Msk                     /*!< Software Interrupt on line 13 */
#define EXTI_SWIER1_SWI14_Pos        (14U)
#define EXTI_SWIER1_SWI14_Msk        (0x1UL << EXTI_SWIER1_SWI14_Pos)          /*!< 0x00004000 */
#define EXTI_SWIER1_SWI14            EXTI_SWIER1_SWI14_Msk                     /*!< Software Interrupt on line 14 */
#define EXTI_SWIER1_SWI15_Pos        (15U)
#define EXTI_SWIER1_SWI15_Msk        (0x1UL << EXTI_SWIER1_SWI15_Pos)          /*!< 0x00008000 */
#define EXTI_SWIER1_SWI15            EXTI_SWIER1_SWI15_Msk                     /*!< Software Interrupt on line 15 */
#define EXTI_SWIER1_SWI16_Pos        (16U)
#define EXTI_SWIER1_SWI16_Msk        (0x1UL << EXTI_SWIER1_SWI16_Pos)          /*!< 0x00010000 */
#define EXTI_SWIER1_SWI16            EXTI_SWIER1_SWI16_Msk                     /*!< Software Interrupt on line 16 */
#define EXTI_SWIER1_SWI21_Pos        (21U)
#define EXTI_SWIER1_SWI21_Msk        (0x1UL << EXTI_SWIER1_SWI21_Pos)          /*!< 0x00200000 */
#define EXTI_SWIER1_SWI21            EXTI_SWIER1_SWI21_Msk                     /*!< Software Interrupt on line 21 */
#define EXTI_SWIER1_SWI22_Pos        (22U)
#define EXTI_SWIER1_SWI22_Msk        (0x1UL << EXTI_SWIER1_SWI22_Pos)          /*!< 0x00400000 */
#define EXTI_SWIER1_SWI22            EXTI_SWIER1_SWI22_Msk                     /*!< Software Interrupt on line 22 */
#define EXTI_SWIER1_SWI23_Pos        (23U)
#define EXTI_SWIER1_SWI23_Msk        (0x1UL << EXTI_SWIER1_SWI23_Pos)          /*!< 0x00800000 */
#define EXTI_SWIER1_SWI23            EXTI_SWIER1_SWI23_Msk                     /*!< Software Interrupt on line 23 */
#define EXTI_SWIER1_SWI24_Pos        (24U)
#define EXTI_SWIER1_SWI24_Msk        (0x1UL << EXTI_SWIER1_SWI24_Pos)          /*!< 0x01000000 */
#define EXTI_SWIER1_SWI24            EXTI_SWIER1_SWI24_Msk                     /*!< Software Interrupt on line 24 */
#define EXTI_SWIER1_SWI25_Pos        (25U)
#define EXTI_SWIER1_SWI25_Msk        (0x1UL << EXTI_SWIER1_SWI25_Pos)          /*!< 0x02000000 */
#define EXTI_SWIER1_SWI25            EXTI_SWIER1_SWI25_Msk                     /*!< Software Interrupt on line 25 */
#define EXTI_SWIER1_SWI26_Pos        (26U)
#define EXTI_SWIER1_SWI26_Msk        (0x1UL << EXTI_SWIER1_SWI26_Pos)          /*!< 0x04000000 */
#define EXTI_SWIER1_SWI26            EXTI_SWIER1_SWI26_Msk                     /*!< Software Interrupt on line 26 */
#define EXTI_SWIER1_SWI27_Pos        (27U)
#define EXTI_SWIER1_SWI27_Msk        (0x1UL << EXTI_SWIER1_SWI27_Pos)          /*!< 0x08000000 */
#define EXTI_SWIER1_SWI27            EXTI_SWIER1_SWI27_Msk                     /*!< Software Interrupt on line 27 */
#define EXTI_SWIER1_SWI28_Pos        (28U)
#define EXTI_SWIER1_SWI28_Msk        (0x1UL << EXTI_SWIER1_SWI28_Pos)          /*!< 0x10000000 */
#define EXTI_SWIER1_SWI28            EXTI_SWIER1_SWI28_Msk                     /*!< Software Interrupt on line 28 */
#define EXTI_SWIER1_SWI29_Pos        (29U)
#define EXTI_SWIER1_SWI29_Msk        (0x1UL << EXTI_SWIER1_SWI29_Pos)          /*!< 0x20000000 */
#define EXTI_SWIER1_SWI29            EXTI_SWIER1_SWI29_Msk                     /*!< Software Interrupt on line 29 */
#define EXTI_SWIER1_SWI30_Pos        (30U)
#define EXTI_SWIER1_SWI30_Msk        (0x1UL << EXTI_SWIER1_SWI30_Pos)          /*!< 0x40000000 */
#define EXTI_SWIER1_SWI30            EXTI_SWIER1_SWI30_Msk                     /*!< Software Interrupt on line 30 */
#define EXTI_SWIER1_SWI31_Pos        (31U)
#define EXTI_SWIER1_SWI31_Msk        (0x1UL << EXTI_SWIER1_SWI31_Pos)          /*!< 0x80000000 */
#define EXTI_SWIER1_SWI31            EXTI_SWIER1_SWI31_Msk                     /*!< Software Interrupt on line 31 */

/*******************  Bit definition for EXTI_SWIER2 register  ***************/
#define EXTI_SWIER2_SWI32_Pos        (0U)
#define EXTI_SWIER2_SWI32_Msk        (0x1UL << EXTI_SWIER2_SWI32_Pos)          /*!< 0x00000001 */
#define EXTI_SWIER2_SWI32            EXTI_SWIER2_SWI32_Msk                     /*!< Software Interrupt on line 32 */
#define EXTI_SWIER2_SWI33_Pos        (1U)
#define EXTI_SWIER2_SWI33_Msk        (0x1UL << EXTI_SWIER2_SWI33_Pos)          /*!< 0x00000002 */
#define EXTI_SWIER2_SWI33            EXTI_SWIER2_SWI33_Msk                     /*!< Software Interrupt on line 33 */
#define EXTI_SWIER2_SWI34_Pos        (2U)
#define EXTI_SWIER2_SWI34_Msk        (0x1UL << EXTI_SWIER2_SWI34_Pos)          /*!< 0x00000004 */
#define EXTI_SWIER2_SWI34            EXTI_SWIER2_SWI34_Msk                     /*!< Software Interrupt on line 34 */
#define EXTI_SWIER2_SWI35_Pos        (3U)
#define EXTI_SWIER2_SWI35_Msk        (0x1UL << EXTI_SWIER2_SWI35_Pos)          /*!< 0x00000008 */
#define EXTI_SWIER2_SWI35            EXTI_SWIER2_SWI35_Msk                     /*!< Software Interrupt on line 35 */
#define EXTI_SWIER2_SWI36_Pos        (4U)
#define EXTI_SWIER2_SWI36_Msk        (0x1UL << EXTI_SWIER2_SWI36_Pos)          /*!< 0x00000010 */
#define EXTI_SWIER2_SWI36            EXTI_SWIER2_SWI36_Msk                     /*!< Software Interrupt on line 36 */
#define EXTI_SWIER2_SWI37_Pos        (5U)
#define EXTI_SWIER2_SWI37_Msk        (0x1UL << EXTI_SWIER2_SWI37_Pos)          /*!< 0x00000020 */
#define EXTI_SWIER2_SWI37            EXTI_SWIER2_SWI37_Msk                     /*!< Software Interrupt on line 37 */
#define EXTI_SWIER2_SWI38_Pos        (6U)
#define EXTI_SWIER2_SWI38_Msk        (0x1UL << EXTI_SWIER2_SWI38_Pos)          /*!< 0x00000040 */
#define EXTI_SWIER2_SWI38            EXTI_SWIER2_SWI38_Msk                     /*!< Software Interrupt on line 38 */
#define EXTI_SWIER2_SWI39_Pos        (7U)
#define EXTI_SWIER2_SWI39_Msk        (0x1UL << EXTI_SWIER2_SWI39_Pos)          /*!< 0x00000080 */
#define EXTI_SWIER2_SWI39            EXTI_SWIER2_SWI39_Msk                     /*!< Software Interrupt on line 39 */
#define EXTI_SWIER2_SWI40_Pos        (8U)
#define EXTI_SWIER2_SWI40_Msk        (0x1UL << EXTI_SWIER2_SWI40_Pos)          /*!< 0x00000100 */
#define EXTI_SWIER2_SWI40            EXTI_SWIER2_SWI40_Msk                     /*!< Software Interrupt on line 40 */
#define EXTI_SWIER2_SWI41_Pos        (9U)
#define EXTI_SWIER2_SWI41_Msk        (0x1UL << EXTI_SWIER2_SWI41_Pos)          /*!< 0x00000200 */
#define EXTI_SWIER2_SWI41            EXTI_SWIER2_SWI41_Msk                     /*!< Software Interrupt on line 41 */
#define EXTI_SWIER2_SWI42_Pos        (10U)
#define EXTI_SWIER2_SWI42_Msk        (0x1UL << EXTI_SWIER2_SWI42_Pos)          /*!< 0x00000400 */
#define EXTI_SWIER2_SWI42            EXTI_SWIER2_SWI42_Msk                     /*!< Software Interrupt on line 42 */

/*******************  Bit definition for EXTI_RPR1 register  *****************/
#define EXTI_RPR1_RPIF0_Pos          (0U)
#define EXTI_RPR1_RPIF0_Msk          (0x1UL << EXTI_RPR1_RPIF0_Pos)            /*!< 0x00000001 */
#define EXTI_RPR1_RPIF0              EXTI_RPR1_RPIF0_Msk                       /*!< Rising Pending Interrupt Flag on line 0 */
#define EXTI_RPR1_RPIF1_Pos          (1U)
#define EXTI_RPR1_RPIF1_Msk          (0x1UL << EXTI_RPR1_RPIF1_Pos)            /*!< 0x00000002 */
#define EXTI_RPR1_RPIF1              EXTI_RPR1_RPIF1_Msk                       /*!< Rising Pending Interrupt Flag on line 1 */
#define EXTI_RPR1_RPIF2_Pos          (2U)
#define EXTI_RPR1_RPIF2_Msk          (0x1UL << EXTI_RPR1_RPIF2_Pos)            /*!< 0x00000004 */
#define EXTI_RPR1_RPIF2              EXTI_RPR1_RPIF2_Msk                       /*!< Rising Pending Interrupt Flag on line 2 */
#define EXTI_RPR1_RPIF3_Pos          (3U)
#define EXTI_RPR1_RPIF3_Msk          (0x1UL << EXTI_RPR1_RPIF3_Pos)            /*!< 0x00000008 */
#define EXTI_RPR1_RPIF3              EXTI_RPR1_RPIF3_Msk                       /*!< Rising Pending Interrupt Flag on line 3 */
#define EXTI_RPR1_RPIF4_Pos          (4U)
#define EXTI_RPR1_RPIF4_Msk          (0x1UL << EXTI_RPR1_RPIF4_Pos)            /*!< 0x00000010 */
#define EXTI_RPR1_RPIF4              EXTI_RPR1_RPIF4_Msk                       /*!< Rising Pending Interrupt Flag on line 4 */
#define EXTI_RPR1_RPIF5_Pos          (5U)
#define EXTI_RPR1_RPIF5_Msk          (0x1UL << EXTI_RPR1_RPIF5_Pos)            /*!< 0x00000020 */
#define EXTI_RPR1_RPIF5              EXTI_RPR1_RPIF5_Msk                       /*!< Rising Pending Interrupt Flag on line 5 */
#define EXTI_RPR1_RPIF6_Pos          (6U)
#define EXTI_RPR1_RPIF6_Msk          (0x1UL << EXTI_RPR1_RPIF6_Pos)            /*!< 0x00000040 */
#define EXTI_RPR1_RPIF6              EXTI_RPR1_RPIF6_Msk                       /*!< Rising Pending Interrupt Flag on line 6 */
#define EXTI_RPR1_RPIF7_Pos          (7U)
#define EXTI_RPR1_RPIF7_Msk          (0x1UL << EXTI_RPR1_RPIF7_Pos)            /*!< 0x00000080 */
#define EXTI_RPR1_RPIF7              EXTI_RPR1_RPIF7_Msk                       /*!< Rising Pending Interrupt Flag on line 7 */
#define EXTI_RPR1_RPIF8_Pos          (8U)
#define EXTI_RPR1_RPIF8_Msk          (0x1UL << EXTI_RPR1_RPIF8_Pos)            /*!< 0x00000100 */
#define EXTI_RPR1_RPIF8              EXTI_RPR1_RPIF8_Msk                       /*!< Rising Pending Interrupt Flag on line 8 */
#define EXTI_RPR1_RPIF9_Pos          (9U)
#define EXTI_RPR1_RPIF9_Msk          (0x1UL << EXTI_RPR1_RPIF9_Pos)            /*!< 0x00000200 */
#define EXTI_RPR1_RPIF9              EXTI_RPR1_RPIF9_Msk                       /*!< Rising Pending Interrupt Flag on line 9 */
#define EXTI_RPR1_RPIF10_Pos         (10U)
#define EXTI_RPR1_RPIF10_Msk         (0x1UL << EXTI_RPR1_RPIF10_Pos)           /*!< 0x00000400 */
#define EXTI_RPR1_RPIF10             EXTI_RPR1_RPIF10_Msk                      /*!< Rising Pending Interrupt Flag on line 10 */
#define EXTI_RPR1_RPIF11_Pos         (11U)
#define EXTI_RPR1_RPIF11_Msk         (0x1UL << EXTI_RPR1_RPIF11_Pos)           /*!< 0x00000800 */
#define EXTI_RPR1_RPIF11             EXTI_RPR1_RPIF11_Msk                      /*!< Rising Pending Interrupt Flag on line 11 */
#define EXTI_RPR1_RPIF12_Pos         (12U)
#define EXTI_RPR1_RPIF12_Msk         (0x1UL << EXTI_RPR1_RPIF12_Pos)           /*!< 0x00001000 */
#define EXTI_RPR1_RPIF12             EXTI_RPR1_RPIF12_Msk                      /*!< Rising Pending Interrupt Flag on line 12 */
#define EXTI_RPR1_RPIF13_Pos         (13U)
#define EXTI_RPR1_RPIF13_Msk         (0x1UL << EXTI_RPR1_RPIF13_Pos)           /*!< 0x00002000 */
#define EXTI_RPR1_RPIF13             EXTI_RPR1_RPIF13_Msk                      /*!< Rising Pending Interrupt Flag on line 13 */
#define EXTI_RPR1_RPIF14_Pos         (14U)
#define EXTI_RPR1_RPIF14_Msk         (0x1UL << EXTI_RPR1_RPIF14_Pos)           /*!< 0x00004000 */
#define EXTI_RPR1_RPIF14             EXTI_RPR1_RPIF14_Msk                      /*!< Rising Pending Interrupt Flag on line 14 */
#define EXTI_RPR1_RPIF15_Pos         (15U)
#define EXTI_RPR1_RPIF15_Msk         (0x1UL << EXTI_RPR1_RPIF15_Pos)           /*!< 0x00008000 */
#define EXTI_RPR1_RPIF15             EXTI_RPR1_RPIF15_Msk                      /*!< Rising Pending Interrupt Flag on line 15 */
#define EXTI_RPR1_RPIF16_Pos         (16U)
#define EXTI_RPR1_RPIF16_Msk         (0x1UL << EXTI_RPR1_RPIF16_Pos)           /*!< 0x00010000 */
#define EXTI_RPR1_RPIF16             EXTI_RPR1_RPIF16_Msk                      /*!< Rising Pending Interrupt Flag on line 16 */
#define EXTI_RPR1_RPIF21_Pos         (21U)
#define EXTI_RPR1_RPIF21_Msk         (0x1UL << EXTI_RPR1_RPIF21_Pos)           /*!< 0x00200000 */
#define EXTI_RPR1_RPIF21             EXTI_RPR1_RPIF21_Msk                      /*!< Rising Pending Interrupt Flag on line 21 */
#define EXTI_RPR1_RPIF22_Pos         (22U)
#define EXTI_RPR1_RPIF22_Msk         (0x1UL << EXTI_RPR1_RPIF22_Pos)           /*!< 0x00400000 */
#define EXTI_RPR1_RPIF22             EXTI_RPR1_RPIF22_Msk                      /*!< Rising Pending Interrupt Flag on line 22 */
#define EXTI_RPR1_RPIF23_Pos         (23U)
#define EXTI_RPR1_RPIF23_Msk         (0x1UL << EXTI_RPR1_RPIF23_Pos)           /*!< 0x00800000 */
#define EXTI_RPR1_RPIF23             EXTI_RPR1_RPIF23_Msk                      /*!< Rising Pending Interrupt Flag on line 23 */
#define EXTI_RPR1_RPIF24_Pos         (24U)
#define EXTI_RPR1_RPIF24_Msk         (0x1UL << EXTI_RPR1_RPIF24_Pos)           /*!< 0x01000000 */
#define EXTI_RPR1_RPIF24             EXTI_RPR1_RPIF24_Msk                      /*!< Rising Pending Interrupt Flag on line 24 */
#define EXTI_RPR1_RPIF25_Pos         (25U)
#define EXTI_RPR1_RPIF25_Msk         (0x1UL << EXTI_RPR1_RPIF25_Pos)           /*!< 0x02000000 */
#define EXTI_RPR1_RPIF25             EXTI_RPR1_RPIF25_Msk                      /*!< Rising Pending Interrupt Flag on line 25 */
#define EXTI_RPR1_RPIF26_Pos         (26U)
#define EXTI_RPR1_RPIF26_Msk         (0x1UL << EXTI_RPR1_RPIF26_Pos)           /*!< 0x04000000 */
#define EXTI_RPR1_RPIF26             EXTI_RPR1_RPIF26_Msk                      /*!< Rising Pending Interrupt Flag on line 26 */
#define EXTI_RPR1_RPIF27_Pos         (27U)
#define EXTI_RPR1_RPIF27_Msk         (0x1UL << EXTI_RPR1_RPIF27_Pos)           /*!< 0x08000000 */
#define EXTI_RPR1_RPIF27             EXTI_RPR1_RPIF27_Msk                      /*!< Rising Pending Interrupt Flag on line 27 */
#define EXTI_RPR1_RPIF28_Pos         (28U)
#define EXTI_RPR1_RPIF28_Msk         (0x1UL << EXTI_RPR1_RPIF28_Pos)           /*!< 0x10000000 */
#define EXTI_RPR1_RPIF28             EXTI_RPR1_RPIF28_Msk                      /*!< Rising Pending Interrupt Flag on line 28 */
#define EXTI_RPR1_RPIF29_Pos         (29U)
#define EXTI_RPR1_RPIF29_Msk         (0x1UL << EXTI_RPR1_RPIF29_Pos)           /*!< 0x20000000 */
#define EXTI_RPR1_RPIF29             EXTI_RPR1_RPIF29_Msk                      /*!< Rising Pending Interrupt Flag on line 29 */
#define EXTI_RPR1_RPIF30_Pos         (30U)
#define EXTI_RPR1_RPIF30_Msk         (0x1UL << EXTI_RPR1_RPIF30_Pos)           /*!< 0x40000000 */
#define EXTI_RPR1_RPIF30             EXTI_RPR1_RPIF30_Msk                      /*!< Rising Pending Interrupt Flag on line 30 */
#define EXTI_RPR1_RPIF31_Pos         (31U)
#define EXTI_RPR1_RPIF31_Msk         (0x1UL << EXTI_RPR1_RPIF31_Pos)           /*!< 0x80000000 */
#define EXTI_RPR1_RPIF31             EXTI_RPR1_RPIF31_Msk                      /*!< Rising Pending Interrupt Flag on line 31 */

/*******************  Bit definition for EXTI_RPR2 register  *****************/
#define EXTI_RPR2_RPIF32_Pos         (0U)
#define EXTI_RPR2_RPIF32_Msk         (0x1UL << EXTI_RPR2_RPIF32_Pos)           /*!< 0x00000001 */
#define EXTI_RPR2_RPIF32             EXTI_RPR2_RPIF32_Msk                      /*!< Rising Pending Interrupt Flag on line 32 */
#define EXTI_RPR2_RPIF33_Pos         (1U)
#define EXTI_RPR2_RPIF33_Msk         (0x1UL << EXTI_RPR2_RPIF33_Pos)           /*!< 0x00000002 */
#define EXTI_RPR2_RPIF33             EXTI_RPR2_RPIF33_Msk                      /*!< Rising Pending Interrupt Flag on line 33 */
#define EXTI_RPR2_RPIF34_Pos         (2U)
#define EXTI_RPR2_RPIF34_Msk         (0x1UL << EXTI_RPR2_RPIF34_Pos)           /*!< 0x00000004 */
#define EXTI_RPR2_RPIF34             EXTI_RPR2_RPIF34_Msk                      /*!< Rising Pending Interrupt Flag on line 34 */
#define EXTI_RPR2_RPIF35_Pos         (3U)
#define EXTI_RPR2_RPIF35_Msk         (0x1UL << EXTI_RPR2_RPIF35_Pos)           /*!< 0x00000008 */
#define EXTI_RPR2_RPIF35             EXTI_RPR2_RPIF35_Msk                      /*!< Rising Pending Interrupt Flag on line 35 */
#define EXTI_RPR2_RPIF36_Pos         (4U)
#define EXTI_RPR2_RPIF36_Msk         (0x1UL << EXTI_RPR2_RPIF36_Pos)           /*!< 0x00000010 */
#define EXTI_RPR2_RPIF36             EXTI_RPR2_RPIF36_Msk                      /*!< Rising Pending Interrupt Flag on line 36 */
#define EXTI_RPR2_RPIF37_Pos         (5U)
#define EXTI_RPR2_RPIF37_Msk         (0x1UL << EXTI_RPR2_RPIF37_Pos)           /*!< 0x00000020 */
#define EXTI_RPR2_RPIF37             EXTI_RPR2_RPIF37_Msk                      /*!< Rising Pending Interrupt Flag on line 37 */
#define EXTI_RPR2_RPIF38_Pos         (6U)
#define EXTI_RPR2_RPIF38_Msk         (0x1UL << EXTI_RPR2_RPIF38_Pos)           /*!< 0x00000040 */
#define EXTI_RPR2_RPIF38             EXTI_RPR2_RPIF38_Msk                      /*!< Rising Pending Interrupt Flag on line 38 */
#define EXTI_RPR2_RPIF39_Pos         (7U)
#define EXTI_RPR2_RPIF39_Msk         (0x1UL << EXTI_RPR2_RPIF39_Pos)           /*!< 0x00000080 */
#define EXTI_RPR2_RPIF39             EXTI_RPR2_RPIF39_Msk                      /*!< Rising Pending Interrupt Flag on line 39 */
#define EXTI_RPR2_RPIF40_Pos         (8U)
#define EXTI_RPR2_RPIF40_Msk         (0x1UL << EXTI_RPR2_RPIF40_Pos)           /*!< 0x00000100 */
#define EXTI_RPR2_RPIF40             EXTI_RPR2_RPIF40_Msk                      /*!< Rising Pending Interrupt Flag on line 40 */
#define EXTI_RPR2_RPIF41_Pos         (9U)
#define EXTI_RPR2_RPIF41_Msk         (0x1UL << EXTI_RPR2_RPIF41_Pos)           /*!< 0x00000200 */
#define EXTI_RPR2_RPIF41             EXTI_RPR2_RPIF41_Msk                      /*!< Rising Pending Interrupt Flag on line 41 */
#define EXTI_RPR2_RPIF42_Pos         (10U)
#define EXTI_RPR2_RPIF42_Msk         (0x1UL << EXTI_RPR2_RPIF42_Pos)           /*!< 0x00000400 */
#define EXTI_RPR2_RPIF42             EXTI_RPR2_RPIF42_Msk                      /*!< Rising Pending Interrupt Flag on line 42 */

/*******************  Bit definition for EXTI_FPR1 register  *****************/
#define EXTI_FPR1_FPIF0_Pos          (0U)
#define EXTI_FPR1_FPIF0_Msk          (0x1UL << EXTI_FPR1_FPIF0_Pos)            /*!< 0x00000001 */
#define EXTI_FPR1_FPIF0              EXTI_FPR1_FPIF0_Msk                       /*!< Falling Pending Interrupt Flag on line 0 */
#define EXTI_FPR1_FPIF1_Pos          (1U)
#define EXTI_FPR1_FPIF1_Msk          (0x1UL << EXTI_FPR1_FPIF1_Pos)            /*!< 0x00000002 */
#define EXTI_FPR1_FPIF1              EXTI_FPR1_FPIF1_Msk                       /*!< Falling Pending Interrupt Flag on line 1 */
#define EXTI_FPR1_FPIF2_Pos          (2U)
#define EXTI_FPR1_FPIF2_Msk          (0x1UL << EXTI_FPR1_FPIF2_Pos)            /*!< 0x00000004 */
#define EXTI_FPR1_FPIF2              EXTI_FPR1_FPIF2_Msk                       /*!< Falling Pending Interrupt Flag on line 2 */
#define EXTI_FPR1_FPIF3_Pos          (3U)
#define EXTI_FPR1_FPIF3_Msk          (0x1UL << EXTI_FPR1_FPIF3_Pos)            /*!< 0x00000008 */
#define EXTI_FPR1_FPIF3              EXTI_FPR1_FPIF3_Msk                       /*!< Falling Pending Interrupt Flag on line 3 */
#define EXTI_FPR1_FPIF4_Pos          (4U)
#define EXTI_FPR1_FPIF4_Msk          (0x1UL << EXTI_FPR1_FPIF4_Pos)            /*!< 0x00000010 */
#define EXTI_FPR1_FPIF4              EXTI_FPR1_FPIF4_Msk                       /*!< Falling Pending Interrupt Flag on line 4 */
#define EXTI_FPR1_FPIF5_Pos          (5U)
#define EXTI_FPR1_FPIF5_Msk          (0x1UL << EXTI_FPR1_FPIF5_Pos)            /*!< 0x00000020 */
#define EXTI_FPR1_FPIF5              EXTI_FPR1_FPIF5_Msk                       /*!< Falling Pending Interrupt Flag on line 5 */
#define EXTI_FPR1_FPIF6_Pos          (6U)
#define EXTI_FPR1_FPIF6_Msk          (0x1UL << EXTI_FPR1_FPIF6_Pos)            /*!< 0x00000040 */
#define EXTI_FPR1_FPIF6              EXTI_FPR1_FPIF6_Msk                       /*!< Falling Pending Interrupt Flag on line 6 */
#define EXTI_FPR1_FPIF7_Pos          (7U)
#define EXTI_FPR1_FPIF7_Msk          (0x1UL << EXTI_FPR1_FPIF7_Pos)            /*!< 0x00000080 */
#define EXTI_FPR1_FPIF7              EXTI_FPR1_FPIF7_Msk                       /*!< Falling Pending Interrupt Flag on line 7 */
#define EXTI_FPR1_FPIF8_Pos          (8U)
#define EXTI_FPR1_FPIF8_Msk          (0x1UL << EXTI_FPR1_FPIF8_Pos)            /*!< 0x00000100 */
#define EXTI_FPR1_FPIF8              EXTI_FPR1_FPIF8_Msk                       /*!< Falling Pending Interrupt Flag on line 8 */
#define EXTI_FPR1_FPIF9_Pos          (9U)
#define EXTI_FPR1_FPIF9_Msk          (0x1UL << EXTI_FPR1_FPIF9_Pos)            /*!< 0x00000200 */
#define EXTI_FPR1_FPIF9              EXTI_FPR1_FPIF9_Msk                       /*!< Falling Pending Interrupt Flag on line 9 */
#define EXTI_FPR1_FPIF10_Pos         (10U)
#define EXTI_FPR1_FPIF10_Msk         (0x1UL << EXTI_FPR1_FPIF10_Pos)           /*!< 0x00000400 */
#define EXTI_FPR1_FPIF10             EXTI_FPR1_FPIF10_Msk                      /*!< Falling Pending Interrupt Flag on line 10 */
#define EXTI_FPR1_FPIF11_Pos         (11U)
#define EXTI_FPR1_FPIF11_Msk         (0x1UL << EXTI_FPR1_FPIF11_Pos)           /*!< 0x00000800 */
#define EXTI_FPR1_FPIF11             EXTI_FPR1_FPIF11_Msk                      /*!< Falling Pending Interrupt Flag on line 11 */
#define EXTI_FPR1_FPIF12_Pos         (12U)
#define EXTI_FPR1_FPIF12_Msk         (0x1UL << EXTI_FPR1_FPIF12_Pos)           /*!< 0x00001000 */
#define EXTI_FPR1_FPIF12             EXTI_FPR1_FPIF12_Msk                      /*!< Falling Pending Interrupt Flag on line 12 */
#define EXTI_FPR1_FPIF13_Pos         (13U)
#define EXTI_FPR1_FPIF13_Msk         (0x1UL << EXTI_FPR1_FPIF13_Pos)           /*!< 0x00002000 */
#define EXTI_FPR1_FPIF13             EXTI_FPR1_FPIF13_Msk                      /*!< Falling Pending Interrupt Flag on line 13 */
#define EXTI_FPR1_FPIF14_Pos         (14U)
#define EXTI_FPR1_FPIF14_Msk         (0x1UL << EXTI_FPR1_FPIF14_Pos)           /*!< 0x00004000 */
#define EXTI_FPR1_FPIF14             EXTI_FPR1_FPIF14_Msk                      /*!< Falling Pending Interrupt Flag on line 14 */
#define EXTI_FPR1_FPIF15_Pos         (15U)
#define EXTI_FPR1_FPIF15_Msk         (0x1UL << EXTI_FPR1_FPIF15_Pos)           /*!< 0x00008000 */
#define EXTI_FPR1_FPIF15             EXTI_FPR1_FPIF15_Msk                      /*!< Falling Pending Interrupt Flag on line 15 */
#define EXTI_FPR1_FPIF16_Pos         (16U)
#define EXTI_FPR1_FPIF16_Msk         (0x1UL << EXTI_FPR1_FPIF16_Pos)           /*!< 0x00010000 */
#define EXTI_FPR1_FPIF16             EXTI_FPR1_FPIF16_Msk                      /*!< Falling Pending Interrupt Flag on line 16 */
#define EXTI_FPR1_FPIF21_Pos         (21U)
#define EXTI_FPR1_FPIF21_Msk         (0x1UL << EXTI_FPR1_FPIF21_Pos)           /*!< 0x00200000 */
#define EXTI_FPR1_FPIF21             EXTI_FPR1_FPIF21_Msk                      /*!< Falling Pending Interrupt Flag on line 21 */
#define EXTI_FPR1_FPIF22_Pos         (22U)
#define EXTI_FPR1_FPIF22_Msk         (0x1UL << EXTI_FPR1_FPIF22_Pos)           /*!< 0x00400000 */
#define EXTI_FPR1_FPIF22             EXTI_FPR1_FPIF22_Msk                      /*!< Falling Pending Interrupt Flag on line 22 */
#define EXTI_FPR1_FPIF23_Pos         (23U)
#define EXTI_FPR1_FPIF23_Msk         (0x1UL << EXTI_FPR1_FPIF23_Pos)           /*!< 0x00800000 */
#define EXTI_FPR1_FPIF23             EXTI_FPR1_FPIF23_Msk                      /*!< Falling Pending Interrupt Flag on line 23 */
#define EXTI_FPR1_FPIF24_Pos         (24U)
#define EXTI_FPR1_FPIF24_Msk         (0x1UL << EXTI_FPR1_FPIF24_Pos)           /*!< 0x01000000 */
#define EXTI_FPR1_FPIF24             EXTI_FPR1_FPIF24_Msk                      /*!< Falling Pending Interrupt Flag on line 24 */
#define EXTI_FPR1_FPIF25_Pos         (25U)
#define EXTI_FPR1_FPIF25_Msk         (0x1UL << EXTI_FPR1_FPIF25_Pos)           /*!< 0x02000000 */
#define EXTI_FPR1_FPIF25             EXTI_FPR1_FPIF25_Msk                      /*!< Falling Pending Interrupt Flag on line 25 */
#define EXTI_FPR1_FPIF26_Pos         (26U)
#define EXTI_FPR1_FPIF26_Msk         (0x1UL << EXTI_FPR1_FPIF26_Pos)           /*!< 0x04000000 */
#define EXTI_FPR1_FPIF26             EXTI_FPR1_FPIF26_Msk                      /*!< Falling Pending Interrupt Flag on line 26 */
#define EXTI_FPR1_FPIF27_Pos         (27U)
#define EXTI_FPR1_FPIF27_Msk         (0x1UL << EXTI_FPR1_FPIF27_Pos)           /*!< 0x08000000 */
#define EXTI_FPR1_FPIF27             EXTI_FPR1_FPIF27_Msk                      /*!< Falling Pending Interrupt Flag on line 27 */
#define EXTI_FPR1_FPIF28_Pos         (28U)
#define EXTI_FPR1_FPIF28_Msk         (0x1UL << EXTI_FPR1_FPIF28_Pos)           /*!< 0x10000000 */
#define EXTI_FPR1_FPIF28             EXTI_FPR1_FPIF28_Msk                      /*!< Falling Pending Interrupt Flag on line 28 */
#define EXTI_FPR1_FPIF29_Pos         (29U)
#define EXTI_FPR1_FPIF29_Msk         (0x1UL << EXTI_FPR1_FPIF29_Pos)           /*!< 0x20000000 */
#define EXTI_FPR1_FPIF29             EXTI_FPR1_FPIF29_Msk                      /*!< Falling Pending Interrupt Flag on line 29 */
#define EXTI_FPR1_FPIF30_Pos         (30U)
#define EXTI_FPR1_FPIF30_Msk         (0x1UL << EXTI_FPR1_FPIF30_Pos)           /*!< 0x40000000 */
#define EXTI_FPR1_FPIF30             EXTI_FPR1_FPIF30_Msk                      /*!< Falling Pending Interrupt Flag on line 30 */
#define EXTI_FPR1_FPIF31_Pos         (31U)
#define EXTI_FPR1_FPIF31_Msk         (0x1UL << EXTI_FPR1_FPIF31_Pos)           /*!< 0x80000000 */
#define EXTI_FPR1_FPIF31             EXTI_FPR1_FPIF31_Msk                      /*!< Falling Pending Interrupt Flag on line 31 */

/*******************  Bit definition for EXTI_FPR2 register  *****************/
#define EXTI_FPR2_FPIF32_Pos         (0U)
#define EXTI_FPR2_FPIF32_Msk         (0x1UL << EXTI_FPR2_FPIF32_Pos)           /*!< 0x00000001 */
#define EXTI_FPR2_FPIF32             EXTI_FPR2_FPIF32_Msk                      /*!< Falling Pending Interrupt Flag on line 32 */
#define EXTI_FPR2_FPIF33_Pos         (1U)
#define EXTI_FPR2_FPIF33_Msk         (0x1UL << EXTI_FPR2_FPIF33_Pos)           /*!< 0x00000002 */
#define EXTI_FPR2_FPIF33             EXTI_FPR2_FPIF33_Msk                      /*!< Falling Pending Interrupt Flag on line 33 */
#define EXTI_FPR2_FPIF34_Pos         (2U)
#define EXTI_FPR2_FPIF34_Msk         (0x1UL << EXTI_FPR2_FPIF34_Pos)           /*!< 0x00000004 */
#define EXTI_FPR2_FPIF34             EXTI_FPR2_FPIF34_Msk                      /*!< Falling Pending Interrupt Flag on line 34 */
#define EXTI_FPR2_FPIF35_Pos         (3U)
#define EXTI_FPR2_FPIF35_Msk         (0x1UL << EXTI_FPR2_FPIF35_Pos)           /*!< 0x00000008 */
#define EXTI_FPR2_FPIF35             EXTI_FPR2_FPIF35_Msk                      /*!< Falling Pending Interrupt Flag on line 35 */
#define EXTI_FPR2_FPIF36_Pos         (4U)
#define EXTI_FPR2_FPIF36_Msk         (0x1UL << EXTI_FPR2_FPIF36_Pos)           /*!< 0x00000010 */
#define EXTI_FPR2_FPIF36             EXTI_FPR2_FPIF36_Msk                      /*!< Falling Pending Interrupt Flag on line 36 */
#define EXTI_FPR2_FPIF37_Pos         (5U)
#define EXTI_FPR2_FPIF37_Msk         (0x1UL << EXTI_FPR2_FPIF37_Pos)           /*!< 0x00000020 */
#define EXTI_FPR2_FPIF37             EXTI_FPR2_FPIF37_Msk                      /*!< Falling Pending Interrupt Flag on line 37 */
#define EXTI_FPR2_FPIF38_Pos         (6U)
#define EXTI_FPR2_FPIF38_Msk         (0x1UL << EXTI_FPR2_FPIF38_Pos)           /*!< 0x00000040 */
#define EXTI_FPR2_FPIF38             EXTI_FPR2_FPIF38_Msk                      /*!< Falling Pending Interrupt Flag on line 38 */
#define EXTI_FPR2_FPIF39_Pos         (7U)
#define EXTI_FPR2_FPIF39_Msk         (0x1UL << EXTI_FPR2_FPIF39_Pos)           /*!< 0x00000080 */
#define EXTI_FPR2_FPIF39             EXTI_FPR2_FPIF39_Msk                      /*!< Falling Pending Interrupt Flag on line 39 */
#define EXTI_FPR2_FPIF40_Pos         (8U)
#define EXTI_FPR2_FPIF40_Msk         (0x1UL << EXTI_FPR2_FPIF40_Pos)           /*!< 0x00000100 */
#define EXTI_FPR2_FPIF40             EXTI_FPR2_FPIF40_Msk                      /*!< Falling Pending Interrupt Flag on line 40 */
#define EXTI_FPR2_FPIF41_Pos         (9U)
#define EXTI_FPR2_FPIF41_Msk         (0x1UL << EXTI_FPR2_FPIF41_Pos)           /*!< 0x00000200 */
#define EXTI_FPR2_FPIF41             EXTI_FPR2_FPIF41_Msk                      /*!< Falling Pending Interrupt Flag on line 41 */
#define EXTI_FPR2_FPIF42_Pos         (10U)
#define EXTI_FPR2_FPIF42_Msk         (0x1UL << EXTI_FPR2_FPIF42_Pos)           /*!< 0x00000400 */
#define EXTI_FPR2_FPIF42             EXTI_FPR2_FPIF42_Msk                      /*!< Falling Pending Interrupt Flag on line 42 */

/*******************  Bit definition for EXTI_SECCFGR1 register  *************/
#define EXTI_SECCFGR1_SEC0_Pos       (0U)
#define EXTI_SECCFGR1_SEC0_Msk       (0x1UL << EXTI_SECCFGR1_SEC0_Pos)         /*!< 0x00000001 */
#define EXTI_SECCFGR1_SEC0           EXTI_SECCFGR1_SEC0_Msk                    /*!< Security enable on Event input 0 */
#define EXTI_SECCFGR1_SEC1_Pos       (1U)
#define EXTI_SECCFGR1_SEC1_Msk       (0x1UL << EXTI_SECCFGR1_SEC1_Pos)         /*!< 0x00000002 */
#define EXTI_SECCFGR1_SEC1           EXTI_SECCFGR1_SEC1_Msk                    /*!< Security enable on Event input 1 */
#define EXTI_SECCFGR1_SEC2_Pos       (2U)
#define EXTI_SECCFGR1_SEC2_Msk       (0x1UL << EXTI_SECCFGR1_SEC2_Pos)         /*!< 0x00000004 */
#define EXTI_SECCFGR1_SEC2           EXTI_SECCFGR1_SEC2_Msk                    /*!< Security enable on Event input 2 */
#define EXTI_SECCFGR1_SEC3_Pos       (3U)
#define EXTI_SECCFGR1_SEC3_Msk       (0x1UL << EXTI_SECCFGR1_SEC3_Pos)         /*!< 0x00000008 */
#define EXTI_SECCFGR1_SEC3           EXTI_SECCFGR1_SEC3_Msk                    /*!< Security enable on Event input 3 */
#define EXTI_SECCFGR1_SEC4_Pos       (4U)
#define EXTI_SECCFGR1_SEC4_Msk       (0x1UL << EXTI_SECCFGR1_SEC4_Pos)         /*!< 0x00000010 */
#define EXTI_SECCFGR1_SEC4           EXTI_SECCFGR1_SEC4_Msk                    /*!< Security enable on Event input 4 */
#define EXTI_SECCFGR1_SEC5_Pos       (5U)
#define EXTI_SECCFGR1_SEC5_Msk       (0x1UL << EXTI_SECCFGR1_SEC5_Pos)         /*!< 0x00000020 */
#define EXTI_SECCFGR1_SEC5           EXTI_SECCFGR1_SEC5_Msk                    /*!< Security enable on Event input 5 */
#define EXTI_SECCFGR1_SEC6_Pos       (6U)
#define EXTI_SECCFGR1_SEC6_Msk       (0x1UL << EXTI_SECCFGR1_SEC6_Pos)         /*!< 0x00000040 */
#define EXTI_SECCFGR1_SEC6           EXTI_SECCFGR1_SEC6_Msk                    /*!< Security enable on Event input 6 */
#define EXTI_SECCFGR1_SEC7_Pos       (7U)
#define EXTI_SECCFGR1_SEC7_Msk       (0x1UL << EXTI_SECCFGR1_SEC7_Pos)         /*!< 0x00000080 */
#define EXTI_SECCFGR1_SEC7           EXTI_SECCFGR1_SEC7_Msk                    /*!< Security enable on Event input 7 */
#define EXTI_SECCFGR1_SEC8_Pos       (8U)
#define EXTI_SECCFGR1_SEC8_Msk       (0x1UL << EXTI_SECCFGR1_SEC8_Pos)         /*!< 0x00000100 */
#define EXTI_SECCFGR1_SEC8           EXTI_SECCFGR1_SEC8_Msk                    /*!< Security enable on Event input 8 */
#define EXTI_SECCFGR1_SEC9_Pos       (9U)
#define EXTI_SECCFGR1_SEC9_Msk       (0x1UL << EXTI_SECCFGR1_SEC9_Pos)         /*!< 0x00000200 */
#define EXTI_SECCFGR1_SEC9           EXTI_SECCFGR1_SEC9_Msk                    /*!< Security enable on Event input 9 */
#define EXTI_SECCFGR1_SEC10_Pos      (10U)
#define EXTI_SECCFGR1_SEC10_Msk      (0x1UL << EXTI_SECCFGR1_SEC10_Pos)        /*!< 0x00000400 */
#define EXTI_SECCFGR1_SEC10          EXTI_SECCFGR1_SEC10_Msk                   /*!< Security enable on Event input 10 */
#define EXTI_SECCFGR1_SEC11_Pos      (11U)
#define EXTI_SECCFGR1_SEC11_Msk      (0x1UL << EXTI_SECCFGR1_SEC11_Pos)        /*!< 0x00000800 */
#define EXTI_SECCFGR1_SEC11          EXTI_SECCFGR1_SEC11_Msk                   /*!< Security enable on Event input 11 */
#define EXTI_SECCFGR1_SEC12_Pos      (12U)
#define EXTI_SECCFGR1_SEC12_Msk      (0x1UL << EXTI_SECCFGR1_SEC12_Pos)        /*!< 0x00001000 */
#define EXTI_SECCFGR1_SEC12          EXTI_SECCFGR1_SEC12_Msk                   /*!< Security enable on Event input 12 */
#define EXTI_SECCFGR1_SEC13_Pos      (13U)
#define EXTI_SECCFGR1_SEC13_Msk      (0x1UL << EXTI_SECCFGR1_SEC13_Pos)        /*!< 0x00002000 */
#define EXTI_SECCFGR1_SEC13          EXTI_SECCFGR1_SEC13_Msk                   /*!< Security enable on Event input 13 */
#define EXTI_SECCFGR1_SEC14_Pos      (14U)
#define EXTI_SECCFGR1_SEC14_Msk      (0x1UL << EXTI_SECCFGR1_SEC14_Pos)        /*!< 0x00004000 */
#define EXTI_SECCFGR1_SEC14          EXTI_SECCFGR1_SEC14_Msk                   /*!< Security enable on Event input 14 */
#define EXTI_SECCFGR1_SEC15_Pos      (15U)
#define EXTI_SECCFGR1_SEC15_Msk      (0x1UL << EXTI_SECCFGR1_SEC15_Pos)        /*!< 0x00008000 */
#define EXTI_SECCFGR1_SEC15          EXTI_SECCFGR1_SEC15_Msk                   /*!< Security enable on Event input 15 */
#define EXTI_SECCFGR1_SEC16_Pos      (16U)
#define EXTI_SECCFGR1_SEC16_Msk      (0x1UL << EXTI_SECCFGR1_SEC16_Pos)        /*!< 0x00010000 */
#define EXTI_SECCFGR1_SEC16          EXTI_SECCFGR1_SEC16_Msk                   /*!< Security enable on Event input 16 */
#define EXTI_SECCFGR1_SEC17_Pos      (17U)
#define EXTI_SECCFGR1_SEC17_Msk      (0x1UL << EXTI_SECCFGR1_SEC17_Pos)        /*!< 0x00020000 */
#define EXTI_SECCFGR1_SEC17          EXTI_SECCFGR1_SEC17_Msk                   /*!< Security enable on Event input 17 */
#define EXTI_SECCFGR1_SEC18_Pos      (18U)
#define EXTI_SECCFGR1_SEC18_Msk      (0x1UL << EXTI_SECCFGR1_SEC18_Pos)        /*!< 0x00040000 */
#define EXTI_SECCFGR1_SEC18          EXTI_SECCFGR1_SEC18_Msk                   /*!< Security enable on Event input 18 */
#define EXTI_SECCFGR1_SEC19_Pos      (19U)
#define EXTI_SECCFGR1_SEC19_Msk      (0x1UL << EXTI_SECCFGR1_SEC19_Pos)        /*!< 0x00080000 */
#define EXTI_SECCFGR1_SEC19          EXTI_SECCFGR1_SEC19_Msk                   /*!< Security enable on Event input 19 */
#define EXTI_SECCFGR1_SEC20_Pos      (20U)
#define EXTI_SECCFGR1_SEC20_Msk      (0x1UL << EXTI_SECCFGR1_SEC20_Pos)        /*!< 0x00100000 */
#define EXTI_SECCFGR1_SEC20          EXTI_SECCFGR1_SEC20_Msk                   /*!< Security enable on Event input 20 */
#define EXTI_SECCFGR1_SEC21_Pos      (21U)
#define EXTI_SECCFGR1_SEC21_Msk      (0x1UL << EXTI_SECCFGR1_SEC21_Pos)        /*!< 0x00200000 */
#define EXTI_SECCFGR1_SEC21          EXTI_SECCFGR1_SEC21_Msk                   /*!< Security enable on Event input 21 */
#define EXTI_SECCFGR1_SEC22_Pos      (22U)
#define EXTI_SECCFGR1_SEC22_Msk      (0x1UL << EXTI_SECCFGR1_SEC22_Pos)        /*!< 0x00400000 */
#define EXTI_SECCFGR1_SEC22          EXTI_SECCFGR1_SEC22_Msk                   /*!< Security enable on Event input 22 */
#define EXTI_SECCFGR1_SEC23_Pos      (23U)
#define EXTI_SECCFGR1_SEC23_Msk      (0x1UL << EXTI_SECCFGR1_SEC23_Pos)        /*!< 0x00800000 */
#define EXTI_SECCFGR1_SEC23          EXTI_SECCFGR1_SEC23_Msk                   /*!< Security enable on Event input 23 */
#define EXTI_SECCFGR1_SEC24_Pos      (24U)
#define EXTI_SECCFGR1_SEC24_Msk      (0x1UL << EXTI_SECCFGR1_SEC24_Pos)        /*!< 0x01000000 */
#define EXTI_SECCFGR1_SEC24          EXTI_SECCFGR1_SEC24_Msk                   /*!< Security enable on Event input 24 */
#define EXTI_SECCFGR1_SEC25_Pos      (25U)
#define EXTI_SECCFGR1_SEC25_Msk      (0x1UL << EXTI_SECCFGR1_SEC25_Pos)        /*!< 0x02000000 */
#define EXTI_SECCFGR1_SEC25          EXTI_SECCFGR1_SEC25_Msk                   /*!< Security enable on Event input 25 */
#define EXTI_SECCFGR1_SEC26_Pos      (26U)
#define EXTI_SECCFGR1_SEC26_Msk      (0x1UL << EXTI_SECCFGR1_SEC26_Pos)        /*!< 0x04000000 */
#define EXTI_SECCFGR1_SEC26          EXTI_SECCFGR1_SEC26_Msk                   /*!< Security enable on Event input 26 */
#define EXTI_SECCFGR1_SEC27_Pos      (27U)
#define EXTI_SECCFGR1_SEC27_Msk      (0x1UL << EXTI_SECCFGR1_SEC27_Pos)        /*!< 0x08000000 */
#define EXTI_SECCFGR1_SEC27          EXTI_SECCFGR1_SEC27_Msk                   /*!< Security enable on Event input 27 */
#define EXTI_SECCFGR1_SEC28_Pos      (28U)
#define EXTI_SECCFGR1_SEC28_Msk      (0x1UL << EXTI_SECCFGR1_SEC28_Pos)        /*!< 0x10000000 */
#define EXTI_SECCFGR1_SEC28          EXTI_SECCFGR1_SEC28_Msk                   /*!< Security enable on Event input 28 */
#define EXTI_SECCFGR1_SEC29_Pos      (29U)
#define EXTI_SECCFGR1_SEC29_Msk      (0x1UL << EXTI_SECCFGR1_SEC29_Pos)        /*!< 0x20000000 */
#define EXTI_SECCFGR1_SEC29          EXTI_SECCFGR1_SEC29_Msk                   /*!< Security enable on Event input 29 */
#define EXTI_SECCFGR1_SEC30_Pos      (30U)
#define EXTI_SECCFGR1_SEC30_Msk      (0x1UL << EXTI_SECCFGR1_SEC30_Pos)        /*!< 0x40000000 */
#define EXTI_SECCFGR1_SEC30          EXTI_SECCFGR1_SEC30_Msk                   /*!< Security enable on Event input 30 */
#define EXTI_SECCFGR1_SEC31_Pos      (31U)
#define EXTI_SECCFGR1_SEC31_Msk      (0x1UL << EXTI_SECCFGR1_SEC31_Pos)        /*!< 0x80000000 */
#define EXTI_SECCFGR1_SEC31          EXTI_SECCFGR1_SEC31_Msk                   /*!< Security enable on Event input 31 */

/*******************  Bit definition for EXTI_SECCFGR2 register  *************/
#define EXTI_SECCFGR2_SEC32_Pos      (0U)
#define EXTI_SECCFGR2_SEC32_Msk      (0x1UL << EXTI_SECCFGR2_SEC32_Pos)        /*!< 0x00000001 */
#define EXTI_SECCFGR2_SEC32          EXTI_SECCFGR2_SEC32_Msk                   /*!< Security enable on Event input 32 */
#define EXTI_SECCFGR2_SEC33_Pos      (1U)
#define EXTI_SECCFGR2_SEC33_Msk      (0x1UL << EXTI_SECCFGR2_SEC33_Pos)        /*!< 0x00000002 */
#define EXTI_SECCFGR2_SEC33          EXTI_SECCFGR2_SEC33_Msk                   /*!< Security enable on Event input 33 */
#define EXTI_SECCFGR2_SEC34_Pos      (2U)
#define EXTI_SECCFGR2_SEC34_Msk      (0x1UL << EXTI_SECCFGR2_SEC34_Pos)        /*!< 0x00000004 */
#define EXTI_SECCFGR2_SEC34          EXTI_SECCFGR2_SEC34_Msk                   /*!< Security enable on Event input 34 */
#define EXTI_SECCFGR2_SEC35_Pos      (3U)
#define EXTI_SECCFGR2_SEC35_Msk      (0x1UL << EXTI_SECCFGR2_SEC35_Pos)        /*!< 0x00000008 */
#define EXTI_SECCFGR2_SEC35          EXTI_SECCFGR2_SEC35_Msk                   /*!< Security enable on Event input 35 */
#define EXTI_SECCFGR2_SEC36_Pos      (4U)
#define EXTI_SECCFGR2_SEC36_Msk      (0x1UL << EXTI_SECCFGR2_SEC36_Pos)        /*!< 0x00000010 */
#define EXTI_SECCFGR2_SEC36          EXTI_SECCFGR2_SEC36_Msk                   /*!< Security enable on Event input 36 */
#define EXTI_SECCFGR2_SEC37_Pos      (5U)
#define EXTI_SECCFGR2_SEC37_Msk      (0x1UL << EXTI_SECCFGR2_SEC37_Pos)        /*!< 0x00000020 */
#define EXTI_SECCFGR2_SEC37          EXTI_SECCFGR2_SEC37_Msk                   /*!< Security enable on Event input 37 */
#define EXTI_SECCFGR2_SEC38_Pos      (6U)
#define EXTI_SECCFGR2_SEC38_Msk      (0x1UL << EXTI_SECCFGR2_SEC38_Pos)        /*!< 0x00000040 */
#define EXTI_SECCFGR2_SEC38          EXTI_SECCFGR2_SEC38_Msk                   /*!< Security enable on Event input 38 */
#define EXTI_SECCFGR2_SEC39_Pos      (7U)
#define EXTI_SECCFGR2_SEC39_Msk      (0x1UL << EXTI_SECCFGR2_SEC39_Pos)        /*!< 0x00000080 */
#define EXTI_SECCFGR2_SEC39          EXTI_SECCFGR2_SEC39_Msk                   /*!< Security enable on Event input 39 */
#define EXTI_SECCFGR2_SEC40_Pos      (8U)
#define EXTI_SECCFGR2_SEC40_Msk      (0x1UL << EXTI_SECCFGR2_SEC40_Pos)        /*!< 0x00000100 */
#define EXTI_SECCFGR2_SEC40          EXTI_SECCFGR2_SEC40_Msk                   /*!< Security enable on Event input 40 */
#define EXTI_SECCFGR2_SEC41_Pos      (9U)
#define EXTI_SECCFGR2_SEC41_Msk      (0x1UL << EXTI_SECCFGR2_SEC41_Pos)        /*!< 0x00000200 */
#define EXTI_SECCFGR2_SEC41          EXTI_SECCFGR2_SEC41_Msk                   /*!< Security enable on Event input 41 */
#define EXTI_SECCFGR2_SEC42_Pos      (10U)
#define EXTI_SECCFGR2_SEC42_Msk      (0x1UL << EXTI_SECCFGR2_SEC42_Pos)        /*!< 0x00000400 */
#define EXTI_SECCFGR2_SEC42          EXTI_SECCFGR2_SEC42_Msk                   /*!< Security enable on Event input 42 */

/*******************  Bit definition for EXTI_PRIVCFGR1 register  ************/
#define EXTI_PRIVCFGR1_PRIV0_Pos     (0U)
#define EXTI_PRIVCFGR1_PRIV0_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV0_Pos)       /*!< 0x00000001 */
#define EXTI_PRIVCFGR1_PRIV0         EXTI_PRIVCFGR1_PRIV0_Msk                  /*!< Privilege enable on Event input 0 */
#define EXTI_PRIVCFGR1_PRIV1_Pos     (1U)
#define EXTI_PRIVCFGR1_PRIV1_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV1_Pos)       /*!< 0x00000002 */
#define EXTI_PRIVCFGR1_PRIV1         EXTI_PRIVCFGR1_PRIV1_Msk                  /*!< Privilege enable on Event input 1 */
#define EXTI_PRIVCFGR1_PRIV2_Pos     (2U)
#define EXTI_PRIVCFGR1_PRIV2_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV2_Pos)       /*!< 0x00000004 */
#define EXTI_PRIVCFGR1_PRIV2         EXTI_PRIVCFGR1_PRIV2_Msk                  /*!< Privilege enable on Event input 2 */
#define EXTI_PRIVCFGR1_PRIV3_Pos     (3U)
#define EXTI_PRIVCFGR1_PRIV3_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV3_Pos)       /*!< 0x00000008 */
#define EXTI_PRIVCFGR1_PRIV3         EXTI_PRIVCFGR1_PRIV3_Msk                  /*!< Privilege enable on Event input 3 */
#define EXTI_PRIVCFGR1_PRIV4_Pos     (4U)
#define EXTI_PRIVCFGR1_PRIV4_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV4_Pos)       /*!< 0x00000010 */
#define EXTI_PRIVCFGR1_PRIV4         EXTI_PRIVCFGR1_PRIV4_Msk                  /*!< Privilege enable on Event input 4 */
#define EXTI_PRIVCFGR1_PRIV5_Pos     (5U)
#define EXTI_PRIVCFGR1_PRIV5_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV5_Pos)       /*!< 0x00000020 */
#define EXTI_PRIVCFGR1_PRIV5         EXTI_PRIVCFGR1_PRIV5_Msk                  /*!< Privilege enable on Event input 5 */
#define EXTI_PRIVCFGR1_PRIV6_Pos     (6U)
#define EXTI_PRIVCFGR1_PRIV6_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV6_Pos)       /*!< 0x00000040 */
#define EXTI_PRIVCFGR1_PRIV6         EXTI_PRIVCFGR1_PRIV6_Msk                  /*!< Privilege enable on Event input 6 */
#define EXTI_PRIVCFGR1_PRIV7_Pos     (7U)
#define EXTI_PRIVCFGR1_PRIV7_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV7_Pos)       /*!< 0x00000080 */
#define EXTI_PRIVCFGR1_PRIV7         EXTI_PRIVCFGR1_PRIV7_Msk                  /*!< Privilege enable on Event input 7 */
#define EXTI_PRIVCFGR1_PRIV8_Pos     (8U)
#define EXTI_PRIVCFGR1_PRIV8_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV8_Pos)       /*!< 0x00000100 */
#define EXTI_PRIVCFGR1_PRIV8         EXTI_PRIVCFGR1_PRIV8_Msk                  /*!< Privilege enable on Event input 8 */
#define EXTI_PRIVCFGR1_PRIV9_Pos     (9U)
#define EXTI_PRIVCFGR1_PRIV9_Msk     (0x1UL << EXTI_PRIVCFGR1_PRIV9_Pos)       /*!< 0x00000200 */
#define EXTI_PRIVCFGR1_PRIV9         EXTI_PRIVCFGR1_PRIV9_Msk                  /*!< Privilege enable on Event input 9 */
#define EXTI_PRIVCFGR1_PRIV10_Pos    (10U)
#define EXTI_PRIVCFGR1_PRIV10_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV10_Pos)      /*!< 0x00000400 */
#define EXTI_PRIVCFGR1_PRIV10        EXTI_PRIVCFGR1_PRIV10_Msk                 /*!< Privilege enable on Event input 10 */
#define EXTI_PRIVCFGR1_PRIV11_Pos    (11U)
#define EXTI_PRIVCFGR1_PRIV11_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV11_Pos)      /*!< 0x00000800 */
#define EXTI_PRIVCFGR1_PRIV11        EXTI_PRIVCFGR1_PRIV11_Msk                 /*!< Privilege enable on Event input 11 */
#define EXTI_PRIVCFGR1_PRIV12_Pos    (12U)
#define EXTI_PRIVCFGR1_PRIV12_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV12_Pos)      /*!< 0x00001000 */
#define EXTI_PRIVCFGR1_PRIV12        EXTI_PRIVCFGR1_PRIV12_Msk                 /*!< Privilege enable on Event input 12 */
#define EXTI_PRIVCFGR1_PRIV13_Pos    (13U)
#define EXTI_PRIVCFGR1_PRIV13_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV13_Pos)      /*!< 0x00002000 */
#define EXTI_PRIVCFGR1_PRIV13        EXTI_PRIVCFGR1_PRIV13_Msk                 /*!< Privilege enable on Event input 13 */
#define EXTI_PRIVCFGR1_PRIV14_Pos    (14U)
#define EXTI_PRIVCFGR1_PRIV14_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV14_Pos)      /*!< 0x00004000 */
#define EXTI_PRIVCFGR1_PRIV14        EXTI_PRIVCFGR1_PRIV14_Msk                 /*!< Privilege enable on Event input 14 */
#define EXTI_PRIVCFGR1_PRIV15_Pos    (15U)
#define EXTI_PRIVCFGR1_PRIV15_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV15_Pos)      /*!< 0x00008000 */
#define EXTI_PRIVCFGR1_PRIV15        EXTI_PRIVCFGR1_PRIV15_Msk                 /*!< Privilege enable on Event input 15 */
#define EXTI_PRIVCFGR1_PRIV16_Pos    (16U)
#define EXTI_PRIVCFGR1_PRIV16_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV16_Pos)      /*!< 0x00010000 */
#define EXTI_PRIVCFGR1_PRIV16        EXTI_PRIVCFGR1_PRIV16_Msk                 /*!< Privilege enable on Event input 16 */
#define EXTI_PRIVCFGR1_PRIV17_Pos    (17U)
#define EXTI_PRIVCFGR1_PRIV17_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV17_Pos)      /*!< 0x00020000 */
#define EXTI_PRIVCFGR1_PRIV17        EXTI_PRIVCFGR1_PRIV17_Msk                 /*!< Privilege enable on Event input 17 */
#define EXTI_PRIVCFGR1_PRIV18_Pos    (18U)
#define EXTI_PRIVCFGR1_PRIV18_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV18_Pos)      /*!< 0x00040000 */
#define EXTI_PRIVCFGR1_PRIV18        EXTI_PRIVCFGR1_PRIV18_Msk                 /*!< Privilege enable on Event input 18 */
#define EXTI_PRIVCFGR1_PRIV19_Pos    (19U)
#define EXTI_PRIVCFGR1_PRIV19_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV19_Pos)      /*!< 0x00080000 */
#define EXTI_PRIVCFGR1_PRIV19        EXTI_PRIVCFGR1_PRIV19_Msk                 /*!< Privilege enable on Event input 19 */
#define EXTI_PRIVCFGR1_PRIV20_Pos    (20U)
#define EXTI_PRIVCFGR1_PRIV20_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV20_Pos)      /*!< 0x00100000 */
#define EXTI_PRIVCFGR1_PRIV20        EXTI_PRIVCFGR1_PRIV20_Msk                 /*!< Privilege enable on Event input 20 */
#define EXTI_PRIVCFGR1_PRIV21_Pos    (21U)
#define EXTI_PRIVCFGR1_PRIV21_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV21_Pos)      /*!< 0x00200000 */
#define EXTI_PRIVCFGR1_PRIV21        EXTI_PRIVCFGR1_PRIV21_Msk                 /*!< Privilege enable on Event input 21 */
#define EXTI_PRIVCFGR1_PRIV22_Pos    (22U)
#define EXTI_PRIVCFGR1_PRIV22_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV22_Pos)      /*!< 0x00400000 */
#define EXTI_PRIVCFGR1_PRIV22        EXTI_PRIVCFGR1_PRIV22_Msk                 /*!< Privilege enable on Event input 22 */
#define EXTI_PRIVCFGR1_PRIV23_Pos    (23U)
#define EXTI_PRIVCFGR1_PRIV23_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV23_Pos)      /*!< 0x00800000 */
#define EXTI_PRIVCFGR1_PRIV23        EXTI_PRIVCFGR1_PRIV23_Msk                 /*!< Privilege enable on Event input 23 */
#define EXTI_PRIVCFGR1_PRIV24_Pos    (24U)
#define EXTI_PRIVCFGR1_PRIV24_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV24_Pos)      /*!< 0x01000000 */
#define EXTI_PRIVCFGR1_PRIV24        EXTI_PRIVCFGR1_PRIV24_Msk                 /*!< Privilege enable on Event input 24 */
#define EXTI_PRIVCFGR1_PRIV25_Pos    (25U)
#define EXTI_PRIVCFGR1_PRIV25_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV25_Pos)      /*!< 0x02000000 */
#define EXTI_PRIVCFGR1_PRIV25        EXTI_PRIVCFGR1_PRIV25_Msk                 /*!< Privilege enable on Event input 25 */
#define EXTI_PRIVCFGR1_PRIV26_Pos    (26U)
#define EXTI_PRIVCFGR1_PRIV26_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV26_Pos)      /*!< 0x04000000 */
#define EXTI_PRIVCFGR1_PRIV26        EXTI_PRIVCFGR1_PRIV26_Msk                 /*!< Privilege enable on Event input 26 */
#define EXTI_PRIVCFGR1_PRIV27_Pos    (27U)
#define EXTI_PRIVCFGR1_PRIV27_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV27_Pos)      /*!< 0x08000000 */
#define EXTI_PRIVCFGR1_PRIV27        EXTI_PRIVCFGR1_PRIV27_Msk                 /*!< Privilege enable on Event input 27 */
#define EXTI_PRIVCFGR1_PRIV28_Pos    (28U)
#define EXTI_PRIVCFGR1_PRIV28_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV28_Pos)      /*!< 0x10000000 */
#define EXTI_PRIVCFGR1_PRIV28        EXTI_PRIVCFGR1_PRIV28_Msk                 /*!< Privilege enable on Event input 28 */
#define EXTI_PRIVCFGR1_PRIV29_Pos    (29U)
#define EXTI_PRIVCFGR1_PRIV29_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV29_Pos)      /*!< 0x20000000 */
#define EXTI_PRIVCFGR1_PRIV29        EXTI_PRIVCFGR1_PRIV29_Msk                 /*!< Privilege enable on Event input 29 */
#define EXTI_PRIVCFGR1_PRIV30_Pos    (30U)
#define EXTI_PRIVCFGR1_PRIV30_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV30_Pos)      /*!< 0x40000000 */
#define EXTI_PRIVCFGR1_PRIV30        EXTI_PRIVCFGR1_PRIV30_Msk                 /*!< Privilege enable on Event input 30 */
#define EXTI_PRIVCFGR1_PRIV31_Pos    (31U)
#define EXTI_PRIVCFGR1_PRIV31_Msk    (0x1UL << EXTI_PRIVCFGR1_PRIV31_Pos)      /*!< 0x80000000 */
#define EXTI_PRIVCFGR1_PRIV31        EXTI_PRIVCFGR1_PRIV31_Msk                 /*!< Privilege enable on Event input 31 */

/*******************  Bit definition for EXTI_PRIVCFGR2 register  ************/
#define EXTI_PRIVCFGR2_PRIV32_Pos     (0U)
#define EXTI_PRIVCFGR2_PRIV32_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV32_Pos)      /*!< 0x00000001 */
#define EXTI_PRIVCFGR2_PRIV32         EXTI_PRIVCFGR2_PRIV32_Msk                 /*!< Privilege enable on Event input 32 */
#define EXTI_PRIVCFGR2_PRIV33_Pos     (1U)
#define EXTI_PRIVCFGR2_PRIV33_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV33_Pos)      /*!< 0x00000002 */
#define EXTI_PRIVCFGR2_PRIV33         EXTI_PRIVCFGR2_PRIV33_Msk                 /*!< Privilege enable on Event input 33 */
#define EXTI_PRIVCFGR2_PRIV34_Pos     (2U)
#define EXTI_PRIVCFGR2_PRIV34_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV34_Pos)      /*!< 0x00000004 */
#define EXTI_PRIVCFGR2_PRIV34         EXTI_PRIVCFGR2_PRIV34_Msk                 /*!< Privilege enable on Event input 34 */
#define EXTI_PRIVCFGR2_PRIV35_Pos     (3U)
#define EXTI_PRIVCFGR2_PRIV35_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV35_Pos)      /*!< 0x00000008 */
#define EXTI_PRIVCFGR2_PRIV35         EXTI_PRIVCFGR2_PRIV35_Msk                 /*!< Privilege enable on Event input 35 */
#define EXTI_PRIVCFGR2_PRIV36_Pos     (4U)
#define EXTI_PRIVCFGR2_PRIV36_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV36_Pos)      /*!< 0x00000010 */
#define EXTI_PRIVCFGR2_PRIV36         EXTI_PRIVCFGR2_PRIV36_Msk                 /*!< Privilege enable on Event input 36 */
#define EXTI_PRIVCFGR2_PRIV37_Pos     (5U)
#define EXTI_PRIVCFGR2_PRIV37_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV37_Pos)      /*!< 0x00000020 */
#define EXTI_PRIVCFGR2_PRIV37         EXTI_PRIVCFGR2_PRIV37_Msk                 /*!< Privilege enable on Event input 37 */
#define EXTI_PRIVCFGR2_PRIV38_Pos     (6U)
#define EXTI_PRIVCFGR2_PRIV38_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV38_Pos)      /*!< 0x00000040 */
#define EXTI_PRIVCFGR2_PRIV38         EXTI_PRIVCFGR2_PRIV38_Msk                 /*!< Privilege enable on Event input 38 */
#define EXTI_PRIVCFGR2_PRIV39_Pos     (7U)
#define EXTI_PRIVCFGR2_PRIV39_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV39_Pos)      /*!< 0x00000080 */
#define EXTI_PRIVCFGR2_PRIV39         EXTI_PRIVCFGR2_PRIV39_Msk                 /*!< Privilege enable on Event input 39 */
#define EXTI_PRIVCFGR2_PRIV40_Pos     (8U)
#define EXTI_PRIVCFGR2_PRIV40_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV40_Pos)      /*!< 0x00000100 */
#define EXTI_PRIVCFGR2_PRIV40         EXTI_PRIVCFGR2_PRIV40_Msk                 /*!< Privilege enable on Event input 40 */
#define EXTI_PRIVCFGR2_PRIV41_Pos     (9U)
#define EXTI_PRIVCFGR2_PRIV41_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV41_Pos)      /*!< 0x00000200 */
#define EXTI_PRIVCFGR2_PRIV41         EXTI_PRIVCFGR2_PRIV41_Msk                 /*!< Privilege enable on Event input 41 */
#define EXTI_PRIVCFGR2_PRIV42_Pos     (10U)
#define EXTI_PRIVCFGR2_PRIV42_Msk     (0x1UL << EXTI_PRIVCFGR2_PRIV42_Pos)      /*!< 0x00000400 */
#define EXTI_PRIVCFGR2_PRIV42         EXTI_PRIVCFGR2_PRIV42_Msk                 /*!< Privilege enable on Event input 42 */

/*****************  Bit definition for EXTI_EXTICR1 register  **************/
#define EXTI_EXTICR1_EXTI0_Pos       (0U)
#define EXTI_EXTICR1_EXTI0_Msk       (0x7UL << EXTI_EXTICR1_EXTI0_Pos)         /*!< 0x00000007 */
#define EXTI_EXTICR1_EXTI0           EXTI_EXTICR1_EXTI0_Msk                    /*!< EXTI 0 configuration */
#define EXTI_EXTICR1_EXTI0_0         (0x1UL << EXTI_EXTICR1_EXTI0_Pos)         /*!< 0x00000001 */
#define EXTI_EXTICR1_EXTI0_1         (0x2UL << EXTI_EXTICR1_EXTI0_Pos)         /*!< 0x00000002 */
#define EXTI_EXTICR1_EXTI0_2         (0x4UL << EXTI_EXTICR1_EXTI0_Pos)         /*!< 0x00000004 */
#define EXTI_EXTICR1_EXTI1_Pos       (8U)
#define EXTI_EXTICR1_EXTI1_Msk       (0x7UL << EXTI_EXTICR1_EXTI1_Pos)         /*!< 0x00000700 */
#define EXTI_EXTICR1_EXTI1           EXTI_EXTICR1_EXTI1_Msk                    /*!< EXTI 1 configuration */
#define EXTI_EXTICR1_EXTI1_0         (0x1UL << EXTI_EXTICR1_EXTI1_Pos)         /*!< 0x00000100 */
#define EXTI_EXTICR1_EXTI1_1         (0x2UL << EXTI_EXTICR1_EXTI1_Pos)         /*!< 0x00000200 */
#define EXTI_EXTICR1_EXTI1_2         (0x4UL << EXTI_EXTICR1_EXTI1_Pos)         /*!< 0x00000400 */
#define EXTI_EXTICR1_EXTI2_Pos       (16U)
#define EXTI_EXTICR1_EXTI2_Msk       (0x7UL << EXTI_EXTICR1_EXTI2_Pos)         /*!< 0x00070000 */
#define EXTI_EXTICR1_EXTI2           EXTI_EXTICR1_EXTI2_Msk                    /*!< EXTI 2 configuration */
#define EXTI_EXTICR1_EXTI2_0         (0x1UL << EXTI_EXTICR1_EXTI2_Pos)         /*!< 0x00010000 */
#define EXTI_EXTICR1_EXTI2_1         (0x2UL << EXTI_EXTICR1_EXTI2_Pos)         /*!< 0x00020000 */
#define EXTI_EXTICR1_EXTI2_2         (0x4UL << EXTI_EXTICR1_EXTI2_Pos)         /*!< 0x00040000 */
#define EXTI_EXTICR1_EXTI3_Pos       (24U)
#define EXTI_EXTICR1_EXTI3_Msk       (0x7UL << EXTI_EXTICR1_EXTI3_Pos)         /*!< 0x07000000 */
#define EXTI_EXTICR1_EXTI3           EXTI_EXTICR1_EXTI3_Msk                    /*!< EXTI 3 configuration */
#define EXTI_EXTICR1_EXTI3_0         (0x1UL << EXTI_EXTICR1_EXTI3_Pos)         /*!< 0x01000000 */
#define EXTI_EXTICR1_EXTI3_1         (0x2UL << EXTI_EXTICR1_EXTI3_Pos)         /*!< 0x02000000 */
#define EXTI_EXTICR1_EXTI3_2         (0x4UL << EXTI_EXTICR1_EXTI3_Pos)         /*!< 0x04000000 */

/*****************  Bit definition for EXTI_EXTICR2 register  **************/
#define EXTI_EXTICR2_EXTI4_Pos       (0U)
#define EXTI_EXTICR2_EXTI4_Msk       (0x7UL << EXTI_EXTICR2_EXTI4_Pos)         /*!< 0x00000007 */
#define EXTI_EXTICR2_EXTI4           EXTI_EXTICR2_EXTI4_Msk                    /*!< EXTI 4 configuration */
#define EXTI_EXTICR2_EXTI4_0         (0x1UL << EXTI_EXTICR2_EXTI4_Pos)         /*!< 0x00000001 */
#define EXTI_EXTICR2_EXTI4_1         (0x2UL << EXTI_EXTICR2_EXTI4_Pos)         /*!< 0x00000002 */
#define EXTI_EXTICR2_EXTI4_2         (0x4UL << EXTI_EXTICR2_EXTI4_Pos)         /*!< 0x00000004 */
#define EXTI_EXTICR2_EXTI5_Pos       (8U)
#define EXTI_EXTICR2_EXTI5_Msk       (0x7UL << EXTI_EXTICR2_EXTI5_Pos)         /*!< 0x00000700 */
#define EXTI_EXTICR2_EXTI5           EXTI_EXTICR2_EXTI5_Msk                    /*!< EXTI 5 configuration */
#define EXTI_EXTICR2_EXTI5_0         (0x1UL << EXTI_EXTICR2_EXTI5_Pos)         /*!< 0x00000100 */
#define EXTI_EXTICR2_EXTI5_1         (0x2UL << EXTI_EXTICR2_EXTI5_Pos)         /*!< 0x00000200 */
#define EXTI_EXTICR2_EXTI5_2         (0x4UL << EXTI_EXTICR2_EXTI5_Pos)         /*!< 0x00000400 */
#define EXTI_EXTICR2_EXTI6_Pos       (16U)
#define EXTI_EXTICR2_EXTI6_Msk       (0x7UL << EXTI_EXTICR2_EXTI6_Pos)         /*!< 0x00070000 */
#define EXTI_EXTICR2_EXTI6           EXTI_EXTICR2_EXTI6_Msk                    /*!< EXTI 6 configuration */
#define EXTI_EXTICR2_EXTI6_0         (0x1UL << EXTI_EXTICR2_EXTI6_Pos)         /*!< 0x00010000 */
#define EXTI_EXTICR2_EXTI6_1         (0x2UL << EXTI_EXTICR2_EXTI6_Pos)         /*!< 0x00020000 */
#define EXTI_EXTICR2_EXTI6_2         (0x4UL << EXTI_EXTICR2_EXTI6_Pos)         /*!< 0x00040000 */
#define EXTI_EXTICR2_EXTI7_Pos       (24U)
#define EXTI_EXTICR2_EXTI7_Msk       (0x7UL << EXTI_EXTICR2_EXTI7_Pos)         /*!< 0x07000000 */
#define EXTI_EXTICR2_EXTI7           EXTI_EXTICR2_EXTI7_Msk                    /*!< EXTI 7 configuration */
#define EXTI_EXTICR2_EXTI7_0         (0x1UL << EXTI_EXTICR2_EXTI7_Pos)         /*!< 0x01000000 */
#define EXTI_EXTICR2_EXTI7_1         (0x2UL << EXTI_EXTICR2_EXTI7_Pos)         /*!< 0x02000000 */
#define EXTI_EXTICR2_EXTI7_2         (0x4UL << EXTI_EXTICR2_EXTI7_Pos)         /*!< 0x04000000 */

/*****************  Bit definition for EXTI_EXTICR3 register  **************/
#define EXTI_EXTICR3_EXTI8_Pos       (0U)
#define EXTI_EXTICR3_EXTI8_Msk       (0x7UL << EXTI_EXTICR3_EXTI8_Pos)         /*!< 0x00000007 */
#define EXTI_EXTICR3_EXTI8           EXTI_EXTICR3_EXTI8_Msk                    /*!< EXTI 8 configuration */
#define EXTI_EXTICR3_EXTI8_0         (0x1UL << EXTI_EXTICR3_EXTI8_Pos)         /*!< 0x00000001 */
#define EXTI_EXTICR3_EXTI8_1         (0x2UL << EXTI_EXTICR3_EXTI8_Pos)         /*!< 0x00000002 */
#define EXTI_EXTICR3_EXTI8_2         (0x4UL << EXTI_EXTICR3_EXTI8_Pos)         /*!< 0x00000004 */
#define EXTI_EXTICR3_EXTI9_Pos       (8U)
#define EXTI_EXTICR3_EXTI9_Msk       (0x7UL << EXTI_EXTICR3_EXTI9_Pos)         /*!< 0x00000700 */
#define EXTI_EXTICR3_EXTI9           EXTI_EXTICR3_EXTI9_Msk                    /*!< EXTI 9 configuration */
#define EXTI_EXTICR3_EXTI9_0         (0x1UL << EXTI_EXTICR3_EXTI9_Pos)         /*!< 0x00000100 */
#define EXTI_EXTICR3_EXTI9_1         (0x2UL << EXTI_EXTICR3_EXTI9_Pos)         /*!< 0x00000200 */
#define EXTI_EXTICR3_EXTI9_2         (0x4UL << EXTI_EXTICR3_EXTI9_Pos)         /*!< 0x00000400 */
#define EXTI_EXTICR3_EXTI10_Pos      (16U)
#define EXTI_EXTICR3_EXTI10_Msk      (0x7UL << EXTI_EXTICR3_EXTI10_Pos)        /*!< 0x00070000 */
#define EXTI_EXTICR3_EXTI10          EXTI_EXTICR3_EXTI10_Msk                   /*!< EXTI 10 configuration */
#define EXTI_EXTICR3_EXTI10_0        (0x1UL << EXTI_EXTICR3_EXTI10_Pos)        /*!< 0x00010000 */
#define EXTI_EXTICR3_EXTI10_1        (0x2UL << EXTI_EXTICR3_EXTI10_Pos)        /*!< 0x00020000 */
#define EXTI_EXTICR3_EXTI10_2        (0x4UL << EXTI_EXTICR3_EXTI10_Pos)        /*!< 0x00040000 */
#define EXTI_EXTICR3_EXTI11_Pos      (24U)
#define EXTI_EXTICR3_EXTI11_Msk      (0x7UL << EXTI_EXTICR3_EXTI11_Pos)        /*!< 0x07000000 */
#define EXTI_EXTICR3_EXTI11          EXTI_EXTICR3_EXTI11_Msk                   /*!< EXTI 11 configuration */
#define EXTI_EXTICR3_EXTI11_0        (0x1UL << EXTI_EXTICR3_EXTI11_Pos)        /*!< 0x01000000 */
#define EXTI_EXTICR3_EXTI11_1        (0x2UL << EXTI_EXTICR3_EXTI11_Pos)        /*!< 0x02000000 */
#define EXTI_EXTICR3_EXTI11_2        (0x4UL << EXTI_EXTICR3_EXTI11_Pos)        /*!< 0x04000000 */

/*****************  Bit definition for EXTI_EXTICR4 register  **************/
#define EXTI_EXTICR4_EXTI12_Pos      (0U)
#define EXTI_EXTICR4_EXTI12_Msk      (0x7UL << EXTI_EXTICR4_EXTI12_Pos)        /*!< 0x00000007 */
#define EXTI_EXTICR4_EXTI12          EXTI_EXTICR4_EXTI12_Msk                   /*!< EXTI 12 configuration */
#define EXTI_EXTICR4_EXTI12_0        (0x1UL << EXTI_EXTICR4_EXTI12_Pos)        /*!< 0x00000001 */
#define EXTI_EXTICR4_EXTI12_1        (0x2UL << EXTI_EXTICR4_EXTI12_Pos)        /*!< 0x00000002 */
#define EXTI_EXTICR4_EXTI12_2        (0x4UL << EXTI_EXTICR4_EXTI12_Pos)        /*!< 0x00000004 */
#define EXTI_EXTICR4_EXTI13_Pos      (8U)
#define EXTI_EXTICR4_EXTI13_Msk      (0x7UL << EXTI_EXTICR4_EXTI13_Pos)        /*!< 0x00000700 */
#define EXTI_EXTICR4_EXTI13          EXTI_EXTICR4_EXTI13_Msk                   /*!< EXTI 13 configuration */
#define EXTI_EXTICR4_EXTI13_0        (0x1UL << EXTI_EXTICR4_EXTI13_Pos)        /*!< 0x00000100 */
#define EXTI_EXTICR4_EXTI13_1        (0x2UL << EXTI_EXTICR4_EXTI13_Pos)        /*!< 0x00000200 */
#define EXTI_EXTICR4_EXTI13_2        (0x4UL << EXTI_EXTICR4_EXTI13_Pos)        /*!< 0x00000400 */
#define EXTI_EXTICR4_EXTI14_Pos      (16U)
#define EXTI_EXTICR4_EXTI14_Msk      (0x7UL << EXTI_EXTICR4_EXTI14_Pos)        /*!< 0x00070000 */
#define EXTI_EXTICR4_EXTI14          EXTI_EXTICR4_EXTI14_Msk                   /*!< EXTI 14 configuration */
#define EXTI_EXTICR4_EXTI14_0        (0x1UL << EXTI_EXTICR4_EXTI14_Pos)        /*!< 0x00010000 */
#define EXTI_EXTICR4_EXTI14_1        (0x2UL << EXTI_EXTICR4_EXTI14_Pos)        /*!< 0x00020000 */
#define EXTI_EXTICR4_EXTI14_2        (0x4UL << EXTI_EXTICR4_EXTI14_Pos)        /*!< 0x00040000 */
#define EXTI_EXTICR4_EXTI15_Pos      (24U)
#define EXTI_EXTICR4_EXTI15_Msk      (0x7UL << EXTI_EXTICR4_EXTI15_Pos)        /*!< 0x07000000 */
#define EXTI_EXTICR4_EXTI15          EXTI_EXTICR4_EXTI15_Msk                   /*!< EXTI 15 configuration */
#define EXTI_EXTICR4_EXTI15_0        (0x1UL << EXTI_EXTICR4_EXTI15_Pos)        /*!< 0x01000000 */
#define EXTI_EXTICR4_EXTI15_1        (0x2UL << EXTI_EXTICR4_EXTI15_Pos)        /*!< 0x02000000 */
#define EXTI_EXTICR4_EXTI15_2        (0x4UL << EXTI_EXTICR4_EXTI15_Pos)        /*!< 0x04000000 */

/*******************  Bit definition for EXTI_LOCKR register  ****************/
#define EXTI_LOCKR_LOCK_Pos          (0U)
#define EXTI_LOCKR_LOCK_Msk          (0x1UL << EXTI_LOCKR_LOCK_Pos)            /*!< 0x00000001 */
#define EXTI_LOCKR_LOCK              EXTI_LOCKR_LOCK_Msk                       /*!< Global security and privilege configuration lock */

/*******************  Bit definition for EXTI_IMR1 register  *****************/
#define EXTI_IMR1_IM0_Pos            (0U)
#define EXTI_IMR1_IM0_Msk            (0x1UL << EXTI_IMR1_IM0_Pos)              /*!< 0x00000001 */
#define EXTI_IMR1_IM0                EXTI_IMR1_IM0_Msk                         /*!< Interrupt Mask on line 0 */
#define EXTI_IMR1_IM1_Pos            (1U)
#define EXTI_IMR1_IM1_Msk            (0x1UL << EXTI_IMR1_IM1_Pos)              /*!< 0x00000002 */
#define EXTI_IMR1_IM1                EXTI_IMR1_IM1_Msk                         /*!< Interrupt Mask on line 1 */
#define EXTI_IMR1_IM2_Pos            (2U)
#define EXTI_IMR1_IM2_Msk            (0x1UL << EXTI_IMR1_IM2_Pos)              /*!< 0x00000004 */
#define EXTI_IMR1_IM2                EXTI_IMR1_IM2_Msk                         /*!< Interrupt Mask on line 2 */
#define EXTI_IMR1_IM3_Pos            (3U)
#define EXTI_IMR1_IM3_Msk            (0x1UL << EXTI_IMR1_IM3_Pos)              /*!< 0x00000008 */
#define EXTI_IMR1_IM3                EXTI_IMR1_IM3_Msk                         /*!< Interrupt Mask on line 3 */
#define EXTI_IMR1_IM4_Pos            (4U)
#define EXTI_IMR1_IM4_Msk            (0x1UL << EXTI_IMR1_IM4_Pos)              /*!< 0x00000010 */
#define EXTI_IMR1_IM4                EXTI_IMR1_IM4_Msk                         /*!< Interrupt Mask on line 4 */
#define EXTI_IMR1_IM5_Pos            (5U)
#define EXTI_IMR1_IM5_Msk            (0x1UL << EXTI_IMR1_IM5_Pos)              /*!< 0x00000020 */
#define EXTI_IMR1_IM5                EXTI_IMR1_IM5_Msk                         /*!< Interrupt Mask on line 5 */
#define EXTI_IMR1_IM6_Pos            (6U)
#define EXTI_IMR1_IM6_Msk            (0x1UL << EXTI_IMR1_IM6_Pos)              /*!< 0x00000040 */
#define EXTI_IMR1_IM6                EXTI_IMR1_IM6_Msk                         /*!< Interrupt Mask on line 6 */
#define EXTI_IMR1_IM7_Pos            (7U)
#define EXTI_IMR1_IM7_Msk            (0x1UL << EXTI_IMR1_IM7_Pos)              /*!< 0x00000080 */
#define EXTI_IMR1_IM7                EXTI_IMR1_IM7_Msk                         /*!< Interrupt Mask on line 7 */
#define EXTI_IMR1_IM8_Pos            (8U)
#define EXTI_IMR1_IM8_Msk            (0x1UL << EXTI_IMR1_IM8_Pos)              /*!< 0x00000100 */
#define EXTI_IMR1_IM8                EXTI_IMR1_IM8_Msk                         /*!< Interrupt Mask on line 8 */
#define EXTI_IMR1_IM9_Pos            (9U)
#define EXTI_IMR1_IM9_Msk            (0x1UL << EXTI_IMR1_IM9_Pos)              /*!< 0x00000200 */
#define EXTI_IMR1_IM9                EXTI_IMR1_IM9_Msk                         /*!< Interrupt Mask on line 9 */
#define EXTI_IMR1_IM10_Pos           (10U)
#define EXTI_IMR1_IM10_Msk           (0x1UL << EXTI_IMR1_IM10_Pos)             /*!< 0x00000400 */
#define EXTI_IMR1_IM10               EXTI_IMR1_IM10_Msk                        /*!< Interrupt Mask on line 10 */
#define EXTI_IMR1_IM11_Pos           (11U)
#define EXTI_IMR1_IM11_Msk           (0x1UL << EXTI_IMR1_IM11_Pos)             /*!< 0x00000800 */
#define EXTI_IMR1_IM11               EXTI_IMR1_IM11_Msk                        /*!< Interrupt Mask on line 11 */
#define EXTI_IMR1_IM12_Pos           (12U)
#define EXTI_IMR1_IM12_Msk           (0x1UL << EXTI_IMR1_IM12_Pos)             /*!< 0x00001000 */
#define EXTI_IMR1_IM12               EXTI_IMR1_IM12_Msk                        /*!< Interrupt Mask on line 12 */
#define EXTI_IMR1_IM13_Pos           (13U)
#define EXTI_IMR1_IM13_Msk           (0x1UL << EXTI_IMR1_IM13_Pos)             /*!< 0x00002000 */
#define EXTI_IMR1_IM13               EXTI_IMR1_IM13_Msk                        /*!< Interrupt Mask on line 13 */
#define EXTI_IMR1_IM14_Pos           (14U)
#define EXTI_IMR1_IM14_Msk           (0x1UL << EXTI_IMR1_IM14_Pos)             /*!< 0x00004000 */
#define EXTI_IMR1_IM14               EXTI_IMR1_IM14_Msk                        /*!< Interrupt Mask on line 14 */
#define EXTI_IMR1_IM15_Pos           (15U)
#define EXTI_IMR1_IM15_Msk           (0x1UL << EXTI_IMR1_IM15_Pos)             /*!< 0x00008000 */
#define EXTI_IMR1_IM15               EXTI_IMR1_IM15_Msk                        /*!< Interrupt Mask on line 15 */
#define EXTI_IMR1_IM16_Pos           (16U)
#define EXTI_IMR1_IM16_Msk           (0x1UL << EXTI_IMR1_IM16_Pos)             /*!< 0x00010000 */
#define EXTI_IMR1_IM16               EXTI_IMR1_IM16_Msk                        /*!< Interrupt Mask on line 16 */
#define EXTI_IMR1_IM17_Pos           (17U)
#define EXTI_IMR1_IM17_Msk           (0x1UL << EXTI_IMR1_IM17_Pos)             /*!< 0x00020000 */
#define EXTI_IMR1_IM17               EXTI_IMR1_IM17_Msk                        /*!< Interrupt Mask on line 17 */
#define EXTI_IMR1_IM18_Pos           (18U)
#define EXTI_IMR1_IM18_Msk           (0x1UL << EXTI_IMR1_IM18_Pos)             /*!< 0x00040000 */
#define EXTI_IMR1_IM18               EXTI_IMR1_IM18_Msk                        /*!< Interrupt Mask on line 18 */
#define EXTI_IMR1_IM19_Pos           (19U)
#define EXTI_IMR1_IM19_Msk           (0x1UL << EXTI_IMR1_IM19_Pos)             /*!< 0x00080000 */
#define EXTI_IMR1_IM19               EXTI_IMR1_IM19_Msk                        /*!< Interrupt Mask on line 19 */
#define EXTI_IMR1_IM20_Pos           (20U)
#define EXTI_IMR1_IM20_Msk           (0x1UL << EXTI_IMR1_IM20_Pos)             /*!< 0x00100000 */
#define EXTI_IMR1_IM20               EXTI_IMR1_IM20_Msk                        /*!< Interrupt Mask on line 20 */
#define EXTI_IMR1_IM21_Pos           (21U)
#define EXTI_IMR1_IM21_Msk           (0x1UL << EXTI_IMR1_IM21_Pos)             /*!< 0x00200000 */
#define EXTI_IMR1_IM21               EXTI_IMR1_IM21_Msk                        /*!< Interrupt Mask on line 21 */
#define EXTI_IMR1_IM22_Pos           (22U)
#define EXTI_IMR1_IM22_Msk           (0x1UL << EXTI_IMR1_IM22_Pos)             /*!< 0x00400000 */
#define EXTI_IMR1_IM22               EXTI_IMR1_IM22_Msk                        /*!< Interrupt Mask on line 22 */
#define EXTI_IMR1_IM23_Pos           (23U)
#define EXTI_IMR1_IM23_Msk           (0x1UL << EXTI_IMR1_IM23_Pos)             /*!< 0x00800000 */
#define EXTI_IMR1_IM23               EXTI_IMR1_IM23_Msk                        /*!< Interrupt Mask on line 23 */
#define EXTI_IMR1_IM24_Pos           (24U)
#define EXTI_IMR1_IM24_Msk           (0x1UL << EXTI_IMR1_IM24_Pos)             /*!< 0x01000000 */
#define EXTI_IMR1_IM24               EXTI_IMR1_IM24_Msk                        /*!< Interrupt Mask on line 24 */
#define EXTI_IMR1_IM25_Pos           (25U)
#define EXTI_IMR1_IM25_Msk           (0x1UL << EXTI_IMR1_IM25_Pos)             /*!< 0x02000000 */
#define EXTI_IMR1_IM25               EXTI_IMR1_IM25_Msk                        /*!< Interrupt Mask on line 25 */
#define EXTI_IMR1_IM26_Pos           (26U)
#define EXTI_IMR1_IM26_Msk           (0x1UL << EXTI_IMR1_IM26_Pos)             /*!< 0x04000000 */
#define EXTI_IMR1_IM26               EXTI_IMR1_IM26_Msk                        /*!< Interrupt Mask on line 26 */
#define EXTI_IMR1_IM27_Pos           (27U)
#define EXTI_IMR1_IM27_Msk           (0x1UL << EXTI_IMR1_IM27_Pos)             /*!< 0x08000000 */
#define EXTI_IMR1_IM27               EXTI_IMR1_IM27_Msk                        /*!< Interrupt Mask on line 27 */
#define EXTI_IMR1_IM28_Pos           (28U)
#define EXTI_IMR1_IM28_Msk           (0x1UL << EXTI_IMR1_IM28_Pos)             /*!< 0x10000000 */
#define EXTI_IMR1_IM28               EXTI_IMR1_IM28_Msk                        /*!< Interrupt Mask on line 28 */
#define EXTI_IMR1_IM29_Pos           (29U)
#define EXTI_IMR1_IM29_Msk           (0x1UL << EXTI_IMR1_IM29_Pos)             /*!< 0x20000000 */
#define EXTI_IMR1_IM29               EXTI_IMR1_IM29_Msk                        /*!< Interrupt Mask on line 29 */
#define EXTI_IMR1_IM30_Pos           (30U)
#define EXTI_IMR1_IM30_Msk           (0x1UL << EXTI_IMR1_IM30_Pos)             /*!< 0x40000000 */
#define EXTI_IMR1_IM30               EXTI_IMR1_IM30_Msk                        /*!< Interrupt Mask on line 30 */
#define EXTI_IMR1_IM31_Pos           (31U)
#define EXTI_IMR1_IM31_Msk           (0x1UL << EXTI_IMR1_IM31_Pos)             /*!< 0x80000000 */
#define EXTI_IMR1_IM31               EXTI_IMR1_IM31_Msk                        /*!< Interrupt Mask on line 31 */
#define EXTI_IMR1_IM_Pos             (0U)
#define EXTI_IMR1_IM_Msk             (0xFFFFFFFFUL << EXTI_IMR1_IM_Pos)        /*!< 0xFFFFFFFF */
#define EXTI_IMR1_IM                 EXTI_IMR1_IM_Msk                          /*!< Interrupt Mask All */

/*******************  Bit definition for EXTI_IMR2 register  *****************/
#define EXTI_IMR2_IM32_Pos           (0U)
#define EXTI_IMR2_IM32_Msk           (0x1UL << EXTI_IMR2_IM32_Pos)             /*!< 0x00000001 */
#define EXTI_IMR2_IM32               EXTI_IMR2_IM32_Msk                        /*!< Interrupt Mask on line 32 */
#define EXTI_IMR2_IM33_Pos           (1U)
#define EXTI_IMR2_IM33_Msk           (0x1UL << EXTI_IMR2_IM33_Pos)             /*!< 0x00000002 */
#define EXTI_IMR2_IM33               EXTI_IMR2_IM33_Msk                        /*!< Interrupt Mask on line 33 */
#define EXTI_IMR2_IM34_Pos           (2U)
#define EXTI_IMR2_IM34_Msk           (0x1UL << EXTI_IMR2_IM34_Pos)             /*!< 0x00000004 */
#define EXTI_IMR2_IM34               EXTI_IMR2_IM34_Msk                        /*!< Interrupt Mask on line 34 */
#define EXTI_IMR2_IM35_Pos           (3U)
#define EXTI_IMR2_IM35_Msk           (0x1UL << EXTI_IMR2_IM35_Pos)             /*!< 0x00000008 */
#define EXTI_IMR2_IM35               EXTI_IMR2_IM35_Msk                        /*!< Interrupt Mask on line 35 */
#define EXTI_IMR2_IM36_Pos           (4U)
#define EXTI_IMR2_IM36_Msk           (0x1UL << EXTI_IMR2_IM36_Pos)             /*!< 0x00000010 */
#define EXTI_IMR2_IM36               EXTI_IMR2_IM36_Msk                        /*!< Interrupt Mask on line 36 */
#define EXTI_IMR2_IM37_Pos           (5U)
#define EXTI_IMR2_IM37_Msk           (0x1UL << EXTI_IMR2_IM37_Pos)             /*!< 0x00000020 */
#define EXTI_IMR2_IM37               EXTI_IMR2_IM37_Msk                        /*!< Interrupt Mask on line 37 */
#define EXTI_IMR2_IM38_Pos           (6U)
#define EXTI_IMR2_IM38_Msk           (0x1UL << EXTI_IMR2_IM38_Pos)             /*!< 0x00000040 */
#define EXTI_IMR2_IM38               EXTI_IMR2_IM38_Msk                        /*!< Interrupt Mask on line 38 */
#define EXTI_IMR2_IM40_Pos           (8U)
#define EXTI_IMR2_IM40_Msk           (0x1UL << EXTI_IMR2_IM40_Pos)             /*!< 0x00000100 */
#define EXTI_IMR2_IM40               EXTI_IMR2_IM40_Msk                        /*!< Interrupt Mask on line 40 */
#define EXTI_IMR2_IM41_Pos           (9U)
#define EXTI_IMR2_IM41_Msk           (0x1UL << EXTI_IMR2_IM41_Pos)             /*!< 0x00000200 */
#define EXTI_IMR2_IM41               EXTI_IMR2_IM41_Msk                        /*!< Interrupt Mask on line 41 */
#define EXTI_IMR2_IM42_Pos           (10U)
#define EXTI_IMR2_IM42_Msk           (0x1UL << EXTI_IMR2_IM42_Pos)             /*!< 0x00000400 */
#define EXTI_IMR2_IM42               EXTI_IMR2_IM42_Msk                        /*!< Interrupt Mask on line 42 */
#define EXTI_IMR2_IM_Pos             (0U)
#define EXTI_IMR2_IM_Msk             (0x77FUL << EXTI_IMR2_IM_Pos)             /*!< 0x0000077F */
#define EXTI_IMR2_IM                 EXTI_IMR2_IM_Msk                          /*!< Interrupt Mask All */

/*******************  Bit definition for EXTI_EMR1 register  *****************/
#define EXTI_EMR1_EM0_Pos            (0U)
#define EXTI_EMR1_EM0_Msk            (0x1UL << EXTI_EMR1_EM0_Pos)              /*!< 0x00000001 */
#define EXTI_EMR1_EM0                EXTI_EMR1_EM0_Msk                         /*!< Event Mask on line 0 */
#define EXTI_EMR1_EM1_Pos            (1U)
#define EXTI_EMR1_EM1_Msk            (0x1UL << EXTI_EMR1_EM1_Pos)              /*!< 0x00000002 */
#define EXTI_EMR1_EM1                EXTI_EMR1_EM1_Msk                         /*!< Event Mask on line 1 */
#define EXTI_EMR1_EM2_Pos            (2U)
#define EXTI_EMR1_EM2_Msk            (0x1UL << EXTI_EMR1_EM2_Pos)              /*!< 0x00000004 */
#define EXTI_EMR1_EM2                EXTI_EMR1_EM2_Msk                         /*!< Event Mask on line 2 */
#define EXTI_EMR1_EM3_Pos            (3U)
#define EXTI_EMR1_EM3_Msk            (0x1UL << EXTI_EMR1_EM3_Pos)              /*!< 0x00000008 */
#define EXTI_EMR1_EM3                EXTI_EMR1_EM3_Msk                         /*!< Event Mask on line 3 */
#define EXTI_EMR1_EM4_Pos            (4U)
#define EXTI_EMR1_EM4_Msk            (0x1UL << EXTI_EMR1_EM4_Pos)              /*!< 0x00000010 */
#define EXTI_EMR1_EM4                EXTI_EMR1_EM4_Msk                         /*!< Event Mask on line 4 */
#define EXTI_EMR1_EM5_Pos            (5U)
#define EXTI_EMR1_EM5_Msk            (0x1UL << EXTI_EMR1_EM5_Pos)              /*!< 0x00000020 */
#define EXTI_EMR1_EM5                EXTI_EMR1_EM5_Msk                         /*!< Event Mask on line 5 */
#define EXTI_EMR1_EM6_Pos            (6U)
#define EXTI_EMR1_EM6_Msk            (0x1UL << EXTI_EMR1_EM6_Pos)              /*!< 0x00000040 */
#define EXTI_EMR1_EM6                EXTI_EMR1_EM6_Msk                         /*!< Event Mask on line 6 */
#define EXTI_EMR1_EM7_Pos            (7U)
#define EXTI_EMR1_EM7_Msk            (0x1UL << EXTI_EMR1_EM7_Pos)              /*!< 0x00000080 */
#define EXTI_EMR1_EM7                EXTI_EMR1_EM7_Msk                         /*!< Event Mask on line 7 */
#define EXTI_EMR1_EM8_Pos            (8U)
#define EXTI_EMR1_EM8_Msk            (0x1UL << EXTI_EMR1_EM8_Pos)              /*!< 0x00000100 */
#define EXTI_EMR1_EM8                EXTI_EMR1_EM8_Msk                         /*!< Event Mask on line 8 */
#define EXTI_EMR1_EM9_Pos            (9U)
#define EXTI_EMR1_EM9_Msk            (0x1UL << EXTI_EMR1_EM9_Pos)              /*!< 0x00000200 */
#define EXTI_EMR1_EM9                EXTI_EMR1_EM9_Msk                         /*!< Event Mask on line 9 */
#define EXTI_EMR1_EM10_Pos           (10U)
#define EXTI_EMR1_EM10_Msk           (0x1UL << EXTI_EMR1_EM10_Pos)             /*!< 0x00000400 */
#define EXTI_EMR1_EM10               EXTI_EMR1_EM10_Msk                        /*!< Event Mask on line 10 */
#define EXTI_EMR1_EM11_Pos           (11U)
#define EXTI_EMR1_EM11_Msk           (0x1UL << EXTI_EMR1_EM11_Pos)             /*!< 0x00000800 */
#define EXTI_EMR1_EM11               EXTI_EMR1_EM11_Msk                        /*!< Event Mask on line 11 */
#define EXTI_EMR1_EM12_Pos           (12U)
#define EXTI_EMR1_EM12_Msk           (0x1UL << EXTI_EMR1_EM12_Pos)             /*!< 0x00001000 */
#define EXTI_EMR1_EM12               EXTI_EMR1_EM12_Msk                        /*!< Event Mask on line 12 */
#define EXTI_EMR1_EM13_Pos           (13U)
#define EXTI_EMR1_EM13_Msk           (0x1UL << EXTI_EMR1_EM13_Pos)             /*!< 0x00002000 */
#define EXTI_EMR1_EM13               EXTI_EMR1_EM13_Msk                        /*!< Event Mask on line 13 */
#define EXTI_EMR1_EM14_Pos           (14U)
#define EXTI_EMR1_EM14_Msk           (0x1UL << EXTI_EMR1_EM14_Pos)             /*!< 0x00004000 */
#define EXTI_EMR1_EM14               EXTI_EMR1_EM14_Msk                        /*!< Event Mask on line 14 */
#define EXTI_EMR1_EM15_Pos           (15U)
#define EXTI_EMR1_EM15_Msk           (0x1UL << EXTI_EMR1_EM15_Pos)             /*!< 0x00008000 */
#define EXTI_EMR1_EM15               EXTI_EMR1_EM15_Msk                        /*!< Event Mask on line 15 */
#define EXTI_EMR1_EM16_Pos           (16U)
#define EXTI_EMR1_EM16_Msk           (0x1UL << EXTI_EMR1_EM16_Pos)             /*!< 0x00010000 */
#define EXTI_EMR1_EM16               EXTI_EMR1_EM16_Msk                        /*!< Event Mask on line 16 */
#define EXTI_EMR1_EM17_Pos           (17U)
#define EXTI_EMR1_EM17_Msk           (0x1UL << EXTI_EMR1_EM17_Pos)             /*!< 0x00020000 */
#define EXTI_EMR1_EM17               EXTI_EMR1_EM17_Msk                        /*!< Event Mask on line 17 */
#define EXTI_EMR1_EM18_Pos           (18U)
#define EXTI_EMR1_EM18_Msk           (0x1UL << EXTI_EMR1_EM18_Pos)             /*!< 0x00040000 */
#define EXTI_EMR1_EM18               EXTI_EMR1_EM18_Msk                        /*!< Event Mask on line 18 */
#define EXTI_EMR1_EM19_Pos           (19U)
#define EXTI_EMR1_EM19_Msk           (0x1UL << EXTI_EMR1_EM19_Pos)             /*!< 0x00080000 */
#define EXTI_EMR1_EM19               EXTI_EMR1_EM19_Msk                        /*!< Event Mask on line 19 */
#define EXTI_EMR1_EM20_Pos           (20U)
#define EXTI_EMR1_EM20_Msk           (0x1UL << EXTI_EMR1_EM20_Pos)             /*!< 0x00100000 */
#define EXTI_EMR1_EM20               EXTI_EMR1_EM20_Msk                        /*!< Event Mask on line 20 */
#define EXTI_EMR1_EM21_Pos           (21U)
#define EXTI_EMR1_EM21_Msk           (0x1UL << EXTI_EMR1_EM21_Pos)             /*!< 0x00200000 */
#define EXTI_EMR1_EM21               EXTI_EMR1_EM21_Msk                        /*!< Event Mask on line 21 */
#define EXTI_EMR1_EM22_Pos           (22U)
#define EXTI_EMR1_EM22_Msk           (0x1UL << EXTI_EMR1_EM22_Pos)             /*!< 0x00400000 */
#define EXTI_EMR1_EM22               EXTI_EMR1_EM22_Msk                        /*!< Event Mask on line 22 */
#define EXTI_EMR1_EM23_Pos           (23U)
#define EXTI_EMR1_EM23_Msk           (0x1UL << EXTI_EMR1_EM23_Pos)             /*!< 0x00800000 */
#define EXTI_EMR1_EM23               EXTI_EMR1_EM23_Msk                        /*!< Event Mask on line 23 */
#define EXTI_EMR1_EM24_Pos           (24U)
#define EXTI_EMR1_EM24_Msk           (0x1UL << EXTI_EMR1_EM24_Pos)             /*!< 0x01000000 */
#define EXTI_EMR1_EM24               EXTI_EMR1_EM24_Msk                        /*!< Event Mask on line 24 */
#define EXTI_EMR1_EM25_Pos           (25U)
#define EXTI_EMR1_EM25_Msk           (0x1UL << EXTI_EMR1_EM25_Pos)             /*!< 0x02000000 */
#define EXTI_EMR1_EM25               EXTI_EMR1_EM25_Msk                        /*!< Event Mask on line 25 */
#define EXTI_EMR1_EM26_Pos           (26U)
#define EXTI_EMR1_EM26_Msk           (0x1UL << EXTI_EMR1_EM26_Pos)             /*!< 0x04000000 */
#define EXTI_EMR1_EM26               EXTI_EMR1_EM26_Msk                        /*!< Event Mask on line 26 */
#define EXTI_EMR1_EM27_Pos           (27U)
#define EXTI_EMR1_EM27_Msk           (0x1UL << EXTI_EMR1_EM27_Pos)             /*!< 0x08000000 */
#define EXTI_EMR1_EM27               EXTI_EMR1_EM27_Msk                        /*!< Event Mask on line 27 */
#define EXTI_EMR1_EM28_Pos           (28U)
#define EXTI_EMR1_EM28_Msk           (0x1UL << EXTI_EMR1_EM28_Pos)             /*!< 0x10000000 */
#define EXTI_EMR1_EM28               EXTI_EMR1_EM28_Msk                        /*!< Event Mask on line 28 */
#define EXTI_EMR1_EM29_Pos           (29U)
#define EXTI_EMR1_EM29_Msk           (0x1UL << EXTI_EMR1_EM29_Pos)             /*!< 0x20000000 */
#define EXTI_EMR1_EM29               EXTI_EMR1_EM29_Msk                        /*!< Event Mask on line 29 */
#define EXTI_EMR1_EM30_Pos           (30U)
#define EXTI_EMR1_EM30_Msk           (0x1UL << EXTI_EMR1_EM30_Pos)             /*!< 0x40000000 */
#define EXTI_EMR1_EM30               EXTI_EMR1_EM30_Msk                        /*!< Event Mask on line 30 */
#define EXTI_EMR1_EM31_Pos           (31U)
#define EXTI_EMR1_EM31_Msk           (0x1UL << EXTI_EMR1_EM31_Pos)             /*!< 0x80000000 */
#define EXTI_EMR1_EM31               EXTI_EMR1_EM31_Msk                        /*!< Event Mask on line 31 */
#define EXTI_EMR1_EM_Pos             (0U)
#define EXTI_EMR1_EM_Msk             (0xFFFFFFFFUL << EXTI_EMR1_EM_Pos)        /*!< 0xFFFFFFFF */
#define EXTI_EMR1_EM                 EXTI_EMR1_EM_Msk                          /*!< Event Mask All */

/*******************  Bit definition for EXTI_EMR2 register  *****************/
#define EXTI_EMR2_EM32_Pos           (0U)
#define EXTI_EMR2_EM32_Msk           (0x1UL << EXTI_EMR2_EM32_Pos)             /*!< 0x00000001 */
#define EXTI_EMR2_EM32               EXTI_EMR2_EM32_Msk                        /*!< Event Mask on line 32 */
#define EXTI_EMR2_EM33_Pos           (1U)
#define EXTI_EMR2_EM33_Msk           (0x1UL << EXTI_EMR2_EM33_Pos)             /*!< 0x00000002 */
#define EXTI_EMR2_EM33               EXTI_EMR2_EM33_Msk                        /*!< Event Mask on line 33 */
#define EXTI_EMR2_EM34_Pos           (2U)
#define EXTI_EMR2_EM34_Msk           (0x1UL << EXTI_EMR2_EM34_Pos)             /*!< 0x00000004 */
#define EXTI_EMR2_EM34               EXTI_EMR2_EM34_Msk                        /*!< Event Mask on line 34 */
#define EXTI_EMR2_EM35_Pos           (3U)
#define EXTI_EMR2_EM35_Msk           (0x1UL << EXTI_EMR2_EM35_Pos)             /*!< 0x00000008 */
#define EXTI_EMR2_EM35               EXTI_EMR2_EM35_Msk                        /*!< Event Mask on line 35 */
#define EXTI_EMR2_EM36_Pos           (4U)
#define EXTI_EMR2_EM36_Msk           (0x1UL << EXTI_EMR2_EM36_Pos)             /*!< 0x00000010 */
#define EXTI_EMR2_EM36               EXTI_EMR2_EM36_Msk                        /*!< Event Mask on line 36 */
#define EXTI_EMR2_EM37_Pos           (5U)
#define EXTI_EMR2_EM37_Msk           (0x1UL << EXTI_EMR2_EM37_Pos)             /*!< 0x00000020 */
#define EXTI_EMR2_EM37               EXTI_EMR2_EM37_Msk                        /*!< Event Mask on line 37 */
#define EXTI_EMR2_EM38_Pos           (6U)
#define EXTI_EMR2_EM38_Msk           (0x1UL << EXTI_EMR2_EM38_Pos)             /*!< 0x00000040 */
#define EXTI_EMR2_EM38               EXTI_EMR2_EM38_Msk                        /*!< Event Mask on line 38 */
#define EXTI_EMR2_EM40_Pos           (8U)
#define EXTI_EMR2_EM40_Msk           (0x1UL << EXTI_EMR2_EM40_Pos)             /*!< 0x00000100 */
#define EXTI_EMR2_EM40               EXTI_EMR2_EM40_Msk                        /*!< Event Mask on line 40 */
#define EXTI_EMR2_EM41_Pos           (9U)
#define EXTI_EMR2_EM41_Msk           (0x1UL << EXTI_EMR2_EM41_Pos)             /*!< 0x00000200 */
#define EXTI_EMR2_EM41               EXTI_EMR2_EM41_Msk                        /*!< Event Mask on line 41 */
#define EXTI_EMR2_EM42_Pos           (10U)
#define EXTI_EMR2_EM42_Msk           (0x1UL << EXTI_EMR2_EM42_Pos)             /*!< 0x00000400 */
#define EXTI_EMR2_EM42               EXTI_EMR2_EM42_Msk                        /*!< Event Mask on line 42 */
#define EXTI_EMR2_EM_Pos             (0U)
#define EXTI_EMR2_EM_Msk             (0x77FUL << EXTI_EMR2_EM_Pos)             /*!< 0x0000077F */
#define EXTI_EMR2_EM                 EXTI_EMR2_EM_Msk                          /*!< Event Mask All */

/******************************************************************************/
/*                                                                            */
/*                 Flexible Datarate Controller Area Network                  */
/*                                                                            */
/******************************************************************************/
/*!<FDCAN control and status registers */
/*****************  Bit definition for FDCAN_CREL register  *******************/
#define FDCAN_CREL_DAY_Pos        (0U)
#define FDCAN_CREL_DAY_Msk        (0xFFUL << FDCAN_CREL_DAY_Pos)               /*!< 0x000000FF */
#define FDCAN_CREL_DAY            FDCAN_CREL_DAY_Msk                           /*!<Timestamp Day                           */
#define FDCAN_CREL_MON_Pos        (8U)
#define FDCAN_CREL_MON_Msk        (0xFFUL << FDCAN_CREL_MON_Pos)               /*!< 0x0000FF00 */
#define FDCAN_CREL_MON            FDCAN_CREL_MON_Msk                           /*!<Timestamp Month                         */
#define FDCAN_CREL_YEAR_Pos       (16U)
#define FDCAN_CREL_YEAR_Msk       (0xFUL << FDCAN_CREL_YEAR_Pos)               /*!< 0x000F0000 */
#define FDCAN_CREL_YEAR           FDCAN_CREL_YEAR_Msk                          /*!<Timestamp Year                          */
#define FDCAN_CREL_SUBSTEP_Pos    (20U)
#define FDCAN_CREL_SUBSTEP_Msk    (0xFUL << FDCAN_CREL_SUBSTEP_Pos)            /*!< 0x00F00000 */
#define FDCAN_CREL_SUBSTEP        FDCAN_CREL_SUBSTEP_Msk                       /*!<Sub-step of Core release                */
#define FDCAN_CREL_STEP_Pos       (24U)
#define FDCAN_CREL_STEP_Msk       (0xFUL << FDCAN_CREL_STEP_Pos)               /*!< 0x0F000000 */
#define FDCAN_CREL_STEP           FDCAN_CREL_STEP_Msk                          /*!<Step of Core release                    */
#define FDCAN_CREL_REL_Pos        (28U)
#define FDCAN_CREL_REL_Msk        (0xFUL << FDCAN_CREL_REL_Pos)                /*!< 0xF0000000 */
#define FDCAN_CREL_REL            FDCAN_CREL_REL_Msk                           /*!<Core release                            */

/*****************  Bit definition for FDCAN_ENDN register  *******************/
#define FDCAN_ENDN_ETV_Pos        (0U)
#define FDCAN_ENDN_ETV_Msk        (0xFFFFFFFFUL << FDCAN_ENDN_ETV_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_ENDN_ETV            FDCAN_ENDN_ETV_Msk                           /*!<Endianness Test Value                   */

/*****************  Bit definition for FDCAN_DBTP register  *******************/
#define FDCAN_DBTP_DSJW_Pos       (0U)
#define FDCAN_DBTP_DSJW_Msk       (0xFUL << FDCAN_DBTP_DSJW_Pos)               /*!< 0x0000000F */
#define FDCAN_DBTP_DSJW           FDCAN_DBTP_DSJW_Msk                          /*!<Synchronization Jump Width              */
#define FDCAN_DBTP_DTSEG2_Pos     (4U)
#define FDCAN_DBTP_DTSEG2_Msk     (0xFUL << FDCAN_DBTP_DTSEG2_Pos)             /*!< 0x000000F0 */
#define FDCAN_DBTP_DTSEG2         FDCAN_DBTP_DTSEG2_Msk                        /*!<Data time segment after sample point    */
#define FDCAN_DBTP_DTSEG1_Pos     (8U)
#define FDCAN_DBTP_DTSEG1_Msk     (0x1FUL << FDCAN_DBTP_DTSEG1_Pos)            /*!< 0x00001F00 */
#define FDCAN_DBTP_DTSEG1         FDCAN_DBTP_DTSEG1_Msk                        /*!<Data time segment before sample point   */
#define FDCAN_DBTP_DBRP_Pos       (16U)
#define FDCAN_DBTP_DBRP_Msk       (0x1FUL << FDCAN_DBTP_DBRP_Pos)              /*!< 0x001F0000 */
#define FDCAN_DBTP_DBRP           FDCAN_DBTP_DBRP_Msk                          /*!<Data BIt Rate Prescaler                 */
#define FDCAN_DBTP_TDC_Pos        (23U)
#define FDCAN_DBTP_TDC_Msk        (0x1UL << FDCAN_DBTP_TDC_Pos)                /*!< 0x00800000 */
#define FDCAN_DBTP_TDC            FDCAN_DBTP_TDC_Msk                           /*!<Transceiver Delay Compensation          */

/*****************  Bit definition for FDCAN_TEST register  *******************/
#define FDCAN_TEST_LBCK_Pos       (4U)
#define FDCAN_TEST_LBCK_Msk       (0x1UL << FDCAN_TEST_LBCK_Pos)               /*!< 0x00000010 */
#define FDCAN_TEST_LBCK           FDCAN_TEST_LBCK_Msk                          /*!<Loop Back mode                           */
#define FDCAN_TEST_TX_Pos         (5U)
#define FDCAN_TEST_TX_Msk         (0x3UL << FDCAN_TEST_TX_Pos)                 /*!< 0x00000060 */
#define FDCAN_TEST_TX             FDCAN_TEST_TX_Msk                            /*!<Control of Transmit Pin                  */
#define FDCAN_TEST_RX_Pos         (7U)
#define FDCAN_TEST_RX_Msk         (0x1UL << FDCAN_TEST_RX_Pos)                 /*!< 0x00000080 */
#define FDCAN_TEST_RX             FDCAN_TEST_RX_Msk                            /*!<Receive Pin                              */

/*****************  Bit definition for FDCAN_RWD register  ********************/
#define FDCAN_RWD_WDC_Pos         (0U)
#define FDCAN_RWD_WDC_Msk         (0xFFUL << FDCAN_RWD_WDC_Pos)                /*!< 0x000000FF */
#define FDCAN_RWD_WDC             FDCAN_RWD_WDC_Msk                            /*!<Watchdog configuration                   */
#define FDCAN_RWD_WDV_Pos         (8U)
#define FDCAN_RWD_WDV_Msk         (0xFFUL << FDCAN_RWD_WDV_Pos)                /*!< 0x0000FF00 */
#define FDCAN_RWD_WDV             FDCAN_RWD_WDV_Msk                            /*!<Watchdog value                           */

/*****************  Bit definition for FDCAN_CCCR register  ********************/
#define FDCAN_CCCR_INIT_Pos       (0U)
#define FDCAN_CCCR_INIT_Msk       (0x1UL << FDCAN_CCCR_INIT_Pos)               /*!< 0x00000001 */
#define FDCAN_CCCR_INIT           FDCAN_CCCR_INIT_Msk                          /*!<Initialization                           */
#define FDCAN_CCCR_CCE_Pos        (1U)
#define FDCAN_CCCR_CCE_Msk        (0x1UL << FDCAN_CCCR_CCE_Pos)                /*!< 0x00000002 */
#define FDCAN_CCCR_CCE            FDCAN_CCCR_CCE_Msk                           /*!<Configuration Change Enable              */
#define FDCAN_CCCR_ASM_Pos        (2U)
#define FDCAN_CCCR_ASM_Msk        (0x1UL << FDCAN_CCCR_ASM_Pos)                /*!< 0x00000004 */
#define FDCAN_CCCR_ASM            FDCAN_CCCR_ASM_Msk                           /*!<ASM Restricted Operation Mode            */
#define FDCAN_CCCR_CSA_Pos        (3U)
#define FDCAN_CCCR_CSA_Msk        (0x1UL << FDCAN_CCCR_CSA_Pos)                /*!< 0x00000008 */
#define FDCAN_CCCR_CSA            FDCAN_CCCR_CSA_Msk                           /*!<Clock Stop Acknowledge                   */
#define FDCAN_CCCR_CSR_Pos        (4U)
#define FDCAN_CCCR_CSR_Msk        (0x1UL << FDCAN_CCCR_CSR_Pos)                /*!< 0x00000010 */
#define FDCAN_CCCR_CSR            FDCAN_CCCR_CSR_Msk                           /*!<Clock Stop Request                       */
#define FDCAN_CCCR_MON_Pos        (5U)
#define FDCAN_CCCR_MON_Msk        (0x1UL << FDCAN_CCCR_MON_Pos)                /*!< 0x00000020 */
#define FDCAN_CCCR_MON            FDCAN_CCCR_MON_Msk                           /*!<Bus Monitoring Mode                      */
#define FDCAN_CCCR_DAR_Pos        (6U)
#define FDCAN_CCCR_DAR_Msk        (0x1UL << FDCAN_CCCR_DAR_Pos)                /*!< 0x00000040 */
#define FDCAN_CCCR_DAR            FDCAN_CCCR_DAR_Msk                           /*!<Disable Automatic Retransmission         */
#define FDCAN_CCCR_TEST_Pos       (7U)
#define FDCAN_CCCR_TEST_Msk       (0x1UL << FDCAN_CCCR_TEST_Pos)               /*!< 0x00000080 */
#define FDCAN_CCCR_TEST           FDCAN_CCCR_TEST_Msk                          /*!<Test Mode Enable                         */
#define FDCAN_CCCR_FDOE_Pos       (8U)
#define FDCAN_CCCR_FDOE_Msk       (0x1UL << FDCAN_CCCR_FDOE_Pos)               /*!< 0x00000100 */
#define FDCAN_CCCR_FDOE           FDCAN_CCCR_FDOE_Msk                          /*!<FD Operation Enable                      */
#define FDCAN_CCCR_BRSE_Pos       (9U)
#define FDCAN_CCCR_BRSE_Msk       (0x1UL << FDCAN_CCCR_BRSE_Pos)               /*!< 0x00000200 */
#define FDCAN_CCCR_BRSE           FDCAN_CCCR_BRSE_Msk                          /*!<FDCAN Bit Rate Switching                 */
#define FDCAN_CCCR_PXHD_Pos       (12U)
#define FDCAN_CCCR_PXHD_Msk       (0x1UL << FDCAN_CCCR_PXHD_Pos)               /*!< 0x00001000 */
#define FDCAN_CCCR_PXHD           FDCAN_CCCR_PXHD_Msk                          /*!<Protocol Exception Handling Disable      */
#define FDCAN_CCCR_EFBI_Pos       (13U)
#define FDCAN_CCCR_EFBI_Msk       (0x1UL << FDCAN_CCCR_EFBI_Pos)               /*!< 0x00002000 */
#define FDCAN_CCCR_EFBI           FDCAN_CCCR_EFBI_Msk                          /*!<Edge Filtering during Bus Integration    */
#define FDCAN_CCCR_TXP_Pos        (14U)
#define FDCAN_CCCR_TXP_Msk        (0x1UL << FDCAN_CCCR_TXP_Pos)                /*!< 0x00004000 */
#define FDCAN_CCCR_TXP            FDCAN_CCCR_TXP_Msk                           /*!<Two CAN bit times Pause                  */
#define FDCAN_CCCR_NISO_Pos       (15U)
#define FDCAN_CCCR_NISO_Msk       (0x1UL << FDCAN_CCCR_NISO_Pos)               /*!< 0x00008000 */
#define FDCAN_CCCR_NISO           FDCAN_CCCR_NISO_Msk                          /*!<Non ISO Operation                        */

/*****************  Bit definition for FDCAN_NBTP register  ********************/
#define FDCAN_NBTP_NTSEG2_Pos     (0U)
#define FDCAN_NBTP_NTSEG2_Msk     (0x7FUL << FDCAN_NBTP_NTSEG2_Pos)            /*!< 0x0000007F */
#define FDCAN_NBTP_NTSEG2         FDCAN_NBTP_NTSEG2_Msk                        /*!<Nominal Time segment after sample point  */
#define FDCAN_NBTP_NTSEG1_Pos     (8U)
#define FDCAN_NBTP_NTSEG1_Msk     (0xFFUL << FDCAN_NBTP_NTSEG1_Pos)            /*!< 0x0000FF00 */
#define FDCAN_NBTP_NTSEG1         FDCAN_NBTP_NTSEG1_Msk                        /*!<Nominal Time segment before sample point */
#define FDCAN_NBTP_NBRP_Pos       (16U)
#define FDCAN_NBTP_NBRP_Msk       (0x1FFUL << FDCAN_NBTP_NBRP_Pos)             /*!< 0x01FF0000 */
#define FDCAN_NBTP_NBRP           FDCAN_NBTP_NBRP_Msk                          /*!<Bit Rate Prescaler                       */
#define FDCAN_NBTP_NSJW_Pos       (25U)
#define FDCAN_NBTP_NSJW_Msk       (0x7FUL << FDCAN_NBTP_NSJW_Pos)              /*!< 0xFE000000 */
#define FDCAN_NBTP_NSJW           FDCAN_NBTP_NSJW_Msk                          /*!<Nominal (Re)Synchronization Jump Width   */

/*****************  Bit definition for FDCAN_TSCC register  ********************/
#define FDCAN_TSCC_TSS_Pos        (0U)
#define FDCAN_TSCC_TSS_Msk        (0x3UL << FDCAN_TSCC_TSS_Pos)                /*!< 0x00000003 */
#define FDCAN_TSCC_TSS            FDCAN_TSCC_TSS_Msk                           /*!<Timestamp Select                         */
#define FDCAN_TSCC_TCP_Pos        (16U)
#define FDCAN_TSCC_TCP_Msk        (0xFUL << FDCAN_TSCC_TCP_Pos)                /*!< 0x000F0000 */
#define FDCAN_TSCC_TCP            FDCAN_TSCC_TCP_Msk                           /*!<Timestamp Counter Prescaler              */

/*****************  Bit definition for FDCAN_TSCV register  ********************/
#define FDCAN_TSCV_TSC_Pos        (0U)
#define FDCAN_TSCV_TSC_Msk        (0xFFFFUL << FDCAN_TSCV_TSC_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TSCV_TSC            FDCAN_TSCV_TSC_Msk                           /*!<Timestamp Counter                        */

/*****************  Bit definition for FDCAN_TOCC register  ********************/
#define FDCAN_TOCC_ETOC_Pos       (0U)
#define FDCAN_TOCC_ETOC_Msk       (0x1UL << FDCAN_TOCC_ETOC_Pos)               /*!< 0x00000001 */
#define FDCAN_TOCC_ETOC           FDCAN_TOCC_ETOC_Msk                          /*!<Enable Timeout Counter                   */
#define FDCAN_TOCC_TOS_Pos        (1U)
#define FDCAN_TOCC_TOS_Msk        (0x3UL << FDCAN_TOCC_TOS_Pos)                /*!< 0x00000006 */
#define FDCAN_TOCC_TOS            FDCAN_TOCC_TOS_Msk                           /*!<Timeout Select                           */
#define FDCAN_TOCC_TOP_Pos        (16U)
#define FDCAN_TOCC_TOP_Msk        (0xFFFFUL << FDCAN_TOCC_TOP_Pos)             /*!< 0xFFFF0000 */
#define FDCAN_TOCC_TOP            FDCAN_TOCC_TOP_Msk                           /*!<Timeout Period                           */

/*****************  Bit definition for FDCAN_TOCV register  ********************/
#define FDCAN_TOCV_TOC_Pos        (0U)
#define FDCAN_TOCV_TOC_Msk        (0xFFFFUL << FDCAN_TOCV_TOC_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TOCV_TOC            FDCAN_TOCV_TOC_Msk                           /*!<Timeout Counter                          */

/*****************  Bit definition for FDCAN_ECR register  *********************/
#define FDCAN_ECR_TEC_Pos         (0U)
#define FDCAN_ECR_TEC_Msk         (0xFFUL << FDCAN_ECR_TEC_Pos)                /*!< 0x000000FF */
#define FDCAN_ECR_TEC             FDCAN_ECR_TEC_Msk                            /*!<Transmit Error Counter                   */
#define FDCAN_ECR_REC_Pos         (8U)
#define FDCAN_ECR_REC_Msk         (0x7FUL << FDCAN_ECR_REC_Pos)                /*!< 0x00007F00 */
#define FDCAN_ECR_REC             FDCAN_ECR_REC_Msk                            /*!<Receive Error Counter                    */
#define FDCAN_ECR_RP_Pos          (15U)
#define FDCAN_ECR_RP_Msk          (0x1UL << FDCAN_ECR_RP_Pos)                  /*!< 0x00008000 */
#define FDCAN_ECR_RP              FDCAN_ECR_RP_Msk                             /*!<Receive Error Passive                    */
#define FDCAN_ECR_CEL_Pos         (16U)
#define FDCAN_ECR_CEL_Msk         (0xFFUL << FDCAN_ECR_CEL_Pos)                /*!< 0x00FF0000 */
#define FDCAN_ECR_CEL             FDCAN_ECR_CEL_Msk                            /*!<CAN Error Logging                        */

/*****************  Bit definition for FDCAN_PSR register  *********************/
#define FDCAN_PSR_LEC_Pos         (0U)
#define FDCAN_PSR_LEC_Msk         (0x7UL << FDCAN_PSR_LEC_Pos)                 /*!< 0x00000007 */
#define FDCAN_PSR_LEC             FDCAN_PSR_LEC_Msk                            /*!<Last Error Code                          */
#define FDCAN_PSR_ACT_Pos         (3U)
#define FDCAN_PSR_ACT_Msk         (0x3UL << FDCAN_PSR_ACT_Pos)                 /*!< 0x00000018 */
#define FDCAN_PSR_ACT             FDCAN_PSR_ACT_Msk                            /*!<Activity                                 */
#define FDCAN_PSR_EP_Pos          (5U)
#define FDCAN_PSR_EP_Msk          (0x1UL << FDCAN_PSR_EP_Pos)                  /*!< 0x00000020 */
#define FDCAN_PSR_EP              FDCAN_PSR_EP_Msk                             /*!<Error Passive                            */
#define FDCAN_PSR_EW_Pos          (6U)
#define FDCAN_PSR_EW_Msk          (0x1UL << FDCAN_PSR_EW_Pos)                  /*!< 0x00000040 */
#define FDCAN_PSR_EW              FDCAN_PSR_EW_Msk                             /*!<Warning Status                           */
#define FDCAN_PSR_BO_Pos          (7U)
#define FDCAN_PSR_BO_Msk          (0x1UL << FDCAN_PSR_BO_Pos)                  /*!< 0x00000080 */
#define FDCAN_PSR_BO              FDCAN_PSR_BO_Msk                             /*!<Bus_Off Status                           */
#define FDCAN_PSR_DLEC_Pos        (8U)
#define FDCAN_PSR_DLEC_Msk        (0x7UL << FDCAN_PSR_DLEC_Pos)                /*!< 0x00000700 */
#define FDCAN_PSR_DLEC            FDCAN_PSR_DLEC_Msk                           /*!<Data Last Error Code                     */
#define FDCAN_PSR_RESI_Pos        (11U)
#define FDCAN_PSR_RESI_Msk        (0x1UL << FDCAN_PSR_RESI_Pos)                /*!< 0x00000800 */
#define FDCAN_PSR_RESI            FDCAN_PSR_RESI_Msk                           /*!<ESI flag of last received FDCAN Message  */
#define FDCAN_PSR_RBRS_Pos        (12U)
#define FDCAN_PSR_RBRS_Msk        (0x1UL << FDCAN_PSR_RBRS_Pos)                /*!< 0x00001000 */
#define FDCAN_PSR_RBRS            FDCAN_PSR_RBRS_Msk                           /*!<BRS flag of last received FDCAN Message  */
#define FDCAN_PSR_REDL_Pos        (13U)
#define FDCAN_PSR_REDL_Msk        (0x1UL << FDCAN_PSR_REDL_Pos)                /*!< 0x00002000 */
#define FDCAN_PSR_REDL            FDCAN_PSR_REDL_Msk                           /*!<Received FDCAN Message                   */
#define FDCAN_PSR_PXE_Pos         (14U)
#define FDCAN_PSR_PXE_Msk         (0x1UL << FDCAN_PSR_PXE_Pos)                 /*!< 0x00004000 */
#define FDCAN_PSR_PXE             FDCAN_PSR_PXE_Msk                            /*!<Protocol Exception Event                 */
#define FDCAN_PSR_TDCV_Pos        (16U)
#define FDCAN_PSR_TDCV_Msk        (0x7FUL << FDCAN_PSR_TDCV_Pos)               /*!< 0x007F0000 */
#define FDCAN_PSR_TDCV            FDCAN_PSR_TDCV_Msk                           /*!<Transmitter Delay Compensation Value     */

/*****************  Bit definition for FDCAN_TDCR register  ********************/
#define FDCAN_TDCR_TDCF_Pos       (0U)
#define FDCAN_TDCR_TDCF_Msk       (0x7FUL << FDCAN_TDCR_TDCF_Pos)              /*!< 0x0000007F */
#define FDCAN_TDCR_TDCF           FDCAN_TDCR_TDCF_Msk                          /*!<Transmitter Delay Compensation Filter    */
#define FDCAN_TDCR_TDCO_Pos       (8U)
#define FDCAN_TDCR_TDCO_Msk       (0x7FUL << FDCAN_TDCR_TDCO_Pos)              /*!< 0x00007F00 */
#define FDCAN_TDCR_TDCO           FDCAN_TDCR_TDCO_Msk                          /*!<Transmitter Delay Compensation Offset    */

/*****************  Bit definition for FDCAN_IR register  **********************/
#define FDCAN_IR_RF0N_Pos         (0U)
#define FDCAN_IR_RF0N_Msk         (0x1UL << FDCAN_IR_RF0N_Pos)                 /*!< 0x00000001 */
#define FDCAN_IR_RF0N             FDCAN_IR_RF0N_Msk                            /*!<Rx FIFO 0 New Message                    */
#define FDCAN_IR_RF0F_Pos         (1U)
#define FDCAN_IR_RF0F_Msk         (0x1UL << FDCAN_IR_RF0F_Pos)                 /*!< 0x00000002 */
#define FDCAN_IR_RF0F             FDCAN_IR_RF0F_Msk                            /*!<Rx FIFO 0 Full                           */
#define FDCAN_IR_RF0L_Pos         (2U)
#define FDCAN_IR_RF0L_Msk         (0x1UL << FDCAN_IR_RF0L_Pos)                 /*!< 0x00000004 */
#define FDCAN_IR_RF0L             FDCAN_IR_RF0L_Msk                            /*!<Rx FIFO 0 Message Lost                   */
#define FDCAN_IR_RF1N_Pos         (3U)
#define FDCAN_IR_RF1N_Msk         (0x1UL << FDCAN_IR_RF1N_Pos)                 /*!< 0x00000008 */
#define FDCAN_IR_RF1N             FDCAN_IR_RF1N_Msk                            /*!<Rx FIFO 1 New Message                    */
#define FDCAN_IR_RF1F_Pos         (4U)
#define FDCAN_IR_RF1F_Msk         (0x1UL << FDCAN_IR_RF1F_Pos)                 /*!< 0x00000010 */
#define FDCAN_IR_RF1F             FDCAN_IR_RF1F_Msk                            /*!<Rx FIFO 1 Full                           */
#define FDCAN_IR_RF1L_Pos         (5U)
#define FDCAN_IR_RF1L_Msk         (0x1UL << FDCAN_IR_RF1L_Pos)                 /*!< 0x00000020 */
#define FDCAN_IR_RF1L             FDCAN_IR_RF1L_Msk                            /*!<Rx FIFO 1 Message Lost                   */
#define FDCAN_IR_HPM_Pos          (6U)
#define FDCAN_IR_HPM_Msk          (0x1UL << FDCAN_IR_HPM_Pos)                  /*!< 0x00000040 */
#define FDCAN_IR_HPM              FDCAN_IR_HPM_Msk                             /*!<High Priority Message                    */
#define FDCAN_IR_TC_Pos           (7U)
#define FDCAN_IR_TC_Msk           (0x1UL << FDCAN_IR_TC_Pos)                   /*!< 0x00000080 */
#define FDCAN_IR_TC               FDCAN_IR_TC_Msk                              /*!<Transmission Completed                   */
#define FDCAN_IR_TCF_Pos          (8U)
#define FDCAN_IR_TCF_Msk          (0x1UL << FDCAN_IR_TCF_Pos)                  /*!< 0x00000100 */
#define FDCAN_IR_TCF              FDCAN_IR_TCF_Msk                             /*!<Transmission Cancellation Finished       */
#define FDCAN_IR_TFE_Pos          (9U)
#define FDCAN_IR_TFE_Msk          (0x1UL << FDCAN_IR_TFE_Pos)                  /*!< 0x00000200 */
#define FDCAN_IR_TFE              FDCAN_IR_TFE_Msk                             /*!<Tx FIFO Empty                            */
#define FDCAN_IR_TEFN_Pos         (10U)
#define FDCAN_IR_TEFN_Msk         (0x1UL << FDCAN_IR_TEFN_Pos)                 /*!< 0x00000400 */
#define FDCAN_IR_TEFN             FDCAN_IR_TEFN_Msk                            /*!<Tx Event FIFO New Entry                  */
#define FDCAN_IR_TEFF_Pos         (11U)
#define FDCAN_IR_TEFF_Msk         (0x1UL << FDCAN_IR_TEFF_Pos)                 /*!< 0x00000800 */
#define FDCAN_IR_TEFF             FDCAN_IR_TEFF_Msk                            /*!<Tx Event FIFO Full                       */
#define FDCAN_IR_TEFL_Pos         (12U)
#define FDCAN_IR_TEFL_Msk         (0x1UL << FDCAN_IR_TEFL_Pos)                 /*!< 0x00001000 */
#define FDCAN_IR_TEFL             FDCAN_IR_TEFL_Msk                            /*!<Tx Event FIFO Element Lost               */
#define FDCAN_IR_TSW_Pos          (13U)
#define FDCAN_IR_TSW_Msk          (0x1UL << FDCAN_IR_TSW_Pos)                  /*!< 0x00002000 */
#define FDCAN_IR_TSW              FDCAN_IR_TSW_Msk                             /*!<Timestamp Wraparound                     */
#define FDCAN_IR_MRAF_Pos         (14U)
#define FDCAN_IR_MRAF_Msk         (0x1UL << FDCAN_IR_MRAF_Pos)                 /*!< 0x00004000 */
#define FDCAN_IR_MRAF             FDCAN_IR_MRAF_Msk                            /*!<Message RAM Access Failure               */
#define FDCAN_IR_TOO_Pos          (15U)
#define FDCAN_IR_TOO_Msk          (0x1UL << FDCAN_IR_TOO_Pos)                  /*!< 0x00008000 */
#define FDCAN_IR_TOO              FDCAN_IR_TOO_Msk                             /*!<Timeout Occurred                         */
#define FDCAN_IR_ELO_Pos          (16U)
#define FDCAN_IR_ELO_Msk          (0x1UL << FDCAN_IR_ELO_Pos)                  /*!< 0x00010000 */
#define FDCAN_IR_ELO              FDCAN_IR_ELO_Msk                             /*!<Error Logging Overflow                   */
#define FDCAN_IR_EP_Pos           (17U)
#define FDCAN_IR_EP_Msk           (0x1UL << FDCAN_IR_EP_Pos)                   /*!< 0x00020000 */
#define FDCAN_IR_EP               FDCAN_IR_EP_Msk                              /*!<Error Passive                            */
#define FDCAN_IR_EW_Pos           (18U)
#define FDCAN_IR_EW_Msk           (0x1UL << FDCAN_IR_EW_Pos)                   /*!< 0x00040000 */
#define FDCAN_IR_EW               FDCAN_IR_EW_Msk                              /*!<Warning Status                           */
#define FDCAN_IR_BO_Pos           (19U)
#define FDCAN_IR_BO_Msk           (0x1UL << FDCAN_IR_BO_Pos)                   /*!< 0x00080000 */
#define FDCAN_IR_BO               FDCAN_IR_BO_Msk                              /*!<Bus_Off Status                           */
#define FDCAN_IR_WDI_Pos          (20U)
#define FDCAN_IR_WDI_Msk          (0x1UL << FDCAN_IR_WDI_Pos)                  /*!< 0x00100000 */
#define FDCAN_IR_WDI              FDCAN_IR_WDI_Msk                             /*!<Watchdog Interrupt                       */
#define FDCAN_IR_PEA_Pos          (21U)
#define FDCAN_IR_PEA_Msk          (0x1UL << FDCAN_IR_PEA_Pos)                  /*!< 0x00200000 */
#define FDCAN_IR_PEA              FDCAN_IR_PEA_Msk                             /*!<Protocol Error in Arbitration Phase      */
#define FDCAN_IR_PED_Pos          (22U)
#define FDCAN_IR_PED_Msk          (0x1UL << FDCAN_IR_PED_Pos)                  /*!< 0x00400000 */
#define FDCAN_IR_PED              FDCAN_IR_PED_Msk                             /*!<Protocol Error in Data Phase             */
#define FDCAN_IR_ARA_Pos          (23U)
#define FDCAN_IR_ARA_Msk          (0x1UL << FDCAN_IR_ARA_Pos)                  /*!< 0x00800000 */
#define FDCAN_IR_ARA              FDCAN_IR_ARA_Msk                             /*!<Access to Reserved Address               */

/*****************  Bit definition for FDCAN_IE register  **********************/
#define FDCAN_IE_RF0NE_Pos        (0U)
#define FDCAN_IE_RF0NE_Msk        (0x1UL << FDCAN_IE_RF0NE_Pos)                /*!< 0x00000001 */
#define FDCAN_IE_RF0NE            FDCAN_IE_RF0NE_Msk                           /*!<Rx FIFO 0 New Message Enable             */
#define FDCAN_IE_RF0FE_Pos        (1U)
#define FDCAN_IE_RF0FE_Msk        (0x1UL << FDCAN_IE_RF0FE_Pos)                /*!< 0x00000002 */
#define FDCAN_IE_RF0FE            FDCAN_IE_RF0FE_Msk                           /*!<Rx FIFO 0 Full Enable                    */
#define FDCAN_IE_RF0LE_Pos        (2U)
#define FDCAN_IE_RF0LE_Msk        (0x1UL << FDCAN_IE_RF0LE_Pos)                /*!< 0x00000004 */
#define FDCAN_IE_RF0LE            FDCAN_IE_RF0LE_Msk                           /*!<Rx FIFO 0 Message Lost Enable            */
#define FDCAN_IE_RF1NE_Pos        (3U)
#define FDCAN_IE_RF1NE_Msk        (0x1UL << FDCAN_IE_RF1NE_Pos)                /*!< 0x00000008 */
#define FDCAN_IE_RF1NE            FDCAN_IE_RF1NE_Msk                           /*!<Rx FIFO 1 New Message Enable             */
#define FDCAN_IE_RF1FE_Pos        (4U)
#define FDCAN_IE_RF1FE_Msk        (0x1UL << FDCAN_IE_RF1FE_Pos)                /*!< 0x00000010 */
#define FDCAN_IE_RF1FE            FDCAN_IE_RF1FE_Msk                           /*!<Rx FIFO 1 Full Enable                    */
#define FDCAN_IE_RF1LE_Pos        (5U)
#define FDCAN_IE_RF1LE_Msk        (0x1UL << FDCAN_IE_RF1LE_Pos)                /*!< 0x00000020 */
#define FDCAN_IE_RF1LE            FDCAN_IE_RF1LE_Msk                           /*!<Rx FIFO 1 Message Lost Enable            */
#define FDCAN_IE_HPME_Pos         (6U)
#define FDCAN_IE_HPME_Msk         (0x1UL << FDCAN_IE_HPME_Pos)                 /*!< 0x00000040 */
#define FDCAN_IE_HPME             FDCAN_IE_HPME_Msk                            /*!<High Priority Message Enable             */
#define FDCAN_IE_TCE_Pos          (7U)
#define FDCAN_IE_TCE_Msk          (0x1UL << FDCAN_IE_TCE_Pos)                  /*!< 0x00000080 */
#define FDCAN_IE_TCE              FDCAN_IE_TCE_Msk                             /*!<Transmission Completed Enable            */
#define FDCAN_IE_TCFE_Pos         (8U)
#define FDCAN_IE_TCFE_Msk         (0x1UL << FDCAN_IE_TCFE_Pos)                 /*!< 0x00000100 */
#define FDCAN_IE_TCFE             FDCAN_IE_TCFE_Msk                            /*!<Transmission Cancellation Finished Enable*/
#define FDCAN_IE_TFEE_Pos         (9U)
#define FDCAN_IE_TFEE_Msk         (0x1UL << FDCAN_IE_TFEE_Pos)                 /*!< 0x00000200 */
#define FDCAN_IE_TFEE             FDCAN_IE_TFEE_Msk                            /*!<Tx FIFO Empty Enable                     */
#define FDCAN_IE_TEFNE_Pos        (10U)
#define FDCAN_IE_TEFNE_Msk        (0x1UL << FDCAN_IE_TEFNE_Pos)                /*!< 0x00000400 */
#define FDCAN_IE_TEFNE            FDCAN_IE_TEFNE_Msk                           /*!<Tx Event FIFO New Entry Enable           */
#define FDCAN_IE_TEFFE_Pos        (11U)
#define FDCAN_IE_TEFFE_Msk        (0x1UL << FDCAN_IE_TEFFE_Pos)                /*!< 0x00000800 */
#define FDCAN_IE_TEFFE            FDCAN_IE_TEFFE_Msk                           /*!<Tx Event FIFO Full Enable                */
#define FDCAN_IE_TEFLE_Pos        (12U)
#define FDCAN_IE_TEFLE_Msk        (0x1UL << FDCAN_IE_TEFLE_Pos)                /*!< 0x00001000 */
#define FDCAN_IE_TEFLE            FDCAN_IE_TEFLE_Msk                           /*!<Tx Event FIFO Element Lost Enable        */
#define FDCAN_IE_TSWE_Pos         (13U)
#define FDCAN_IE_TSWE_Msk         (0x1UL << FDCAN_IE_TSWE_Pos)                 /*!< 0x00002000 */
#define FDCAN_IE_TSWE             FDCAN_IE_TSWE_Msk                            /*!<Timestamp Wraparound Enable              */
#define FDCAN_IE_MRAFE_Pos        (14U)
#define FDCAN_IE_MRAFE_Msk        (0x1UL << FDCAN_IE_MRAFE_Pos)                /*!< 0x00004000 */
#define FDCAN_IE_MRAFE            FDCAN_IE_MRAFE_Msk                           /*!<Message RAM Access Failure Enable        */
#define FDCAN_IE_TOOE_Pos         (15U)
#define FDCAN_IE_TOOE_Msk         (0x1UL << FDCAN_IE_TOOE_Pos)                 /*!< 0x00008000 */
#define FDCAN_IE_TOOE             FDCAN_IE_TOOE_Msk                            /*!<Timeout Occurred Enable                  */
#define FDCAN_IE_ELOE_Pos         (16U)
#define FDCAN_IE_ELOE_Msk         (0x1UL << FDCAN_IE_ELOE_Pos)                 /*!< 0x00010000 */
#define FDCAN_IE_ELOE             FDCAN_IE_ELOE_Msk                            /*!<Error Logging Overflow Enable            */
#define FDCAN_IE_EPE_Pos          (17U)
#define FDCAN_IE_EPE_Msk          (0x1UL << FDCAN_IE_EPE_Pos)                  /*!< 0x00020000 */
#define FDCAN_IE_EPE              FDCAN_IE_EPE_Msk                             /*!<Error Passive Enable                     */
#define FDCAN_IE_EWE_Pos          (18U)
#define FDCAN_IE_EWE_Msk          (0x1UL << FDCAN_IE_EWE_Pos)                  /*!< 0x00040000 */
#define FDCAN_IE_EWE              FDCAN_IE_EWE_Msk                             /*!<Warning Status Enable                    */
#define FDCAN_IE_BOE_Pos          (19U)
#define FDCAN_IE_BOE_Msk          (0x1UL << FDCAN_IE_BOE_Pos)                  /*!< 0x00080000 */
#define FDCAN_IE_BOE              FDCAN_IE_BOE_Msk                             /*!<Bus_Off Status Enable                    */
#define FDCAN_IE_WDIE_Pos         (20U)
#define FDCAN_IE_WDIE_Msk         (0x1UL << FDCAN_IE_WDIE_Pos)                 /*!< 0x00100000 */
#define FDCAN_IE_WDIE             FDCAN_IE_WDIE_Msk                            /*!<Watchdog Interrupt Enable                */
#define FDCAN_IE_PEAE_Pos         (21U)
#define FDCAN_IE_PEAE_Msk         (0x1UL << FDCAN_IE_PEAE_Pos)                 /*!< 0x00200000 */
#define FDCAN_IE_PEAE             FDCAN_IE_PEAE_Msk                            /*!<Protocol Error in Arbitration Phase Enable*/
#define FDCAN_IE_PEDE_Pos         (22U)
#define FDCAN_IE_PEDE_Msk         (0x1UL << FDCAN_IE_PEDE_Pos)                 /*!< 0x00400000 */
#define FDCAN_IE_PEDE             FDCAN_IE_PEDE_Msk                            /*!<Protocol Error in Data Phase Enable      */
#define FDCAN_IE_ARAE_Pos         (23U)
#define FDCAN_IE_ARAE_Msk         (0x1UL << FDCAN_IE_ARAE_Pos)                 /*!< 0x00800000 */
#define FDCAN_IE_ARAE             FDCAN_IE_ARAE_Msk                            /*!<Access to Reserved Address Enable        */

/*****************  Bit definition for FDCAN_ILS register  **********************/
#define FDCAN_ILS_RXFIFO0_Pos     (0U)
#define FDCAN_ILS_RXFIFO0_Msk     (0x1UL << FDCAN_ILS_RXFIFO0_Pos)             /*!< 0x00000001 */
#define FDCAN_ILS_RXFIFO0         FDCAN_ILS_RXFIFO0_Msk                        /*!<Rx FIFO 0 Message Lost
                                                                                   Rx FIFO 0 is Full
                                                                                   Rx FIFO 0 Has New Message                */
#define FDCAN_ILS_RXFIFO1_Pos     (1U)
#define FDCAN_ILS_RXFIFO1_Msk     (0x1UL << FDCAN_ILS_RXFIFO1_Pos)             /*!< 0x00000002 */
#define FDCAN_ILS_RXFIFO1         FDCAN_ILS_RXFIFO1_Msk                        /*!<Rx FIFO 1 Message Lost
                                                                                   Rx FIFO 1 is Full
                                                                                   Rx FIFO 1 Has New Message                */
#define FDCAN_ILS_SMSG_Pos        (2U)
#define FDCAN_ILS_SMSG_Msk        (0x1UL << FDCAN_ILS_SMSG_Pos)                /*!< 0x00000004 */
#define FDCAN_ILS_SMSG            FDCAN_ILS_SMSG_Msk                           /*!<Transmission Cancellation Finished
                                                                                   Transmission Completed
                                                                                   High Priority Message                    */
#define FDCAN_ILS_TFERR_Pos       (3U)
#define FDCAN_ILS_TFERR_Msk       (0x1UL << FDCAN_ILS_TFERR_Pos)               /*!< 0x00000008 */
#define FDCAN_ILS_TFERR           FDCAN_ILS_TFERR_Msk                          /*!<Tx Event FIFO Element Lost
                                                                                   Tx Event FIFO Full
                                                                                   Tx Event FIFO New Entry
                                                                                   Tx FIFO Empty Interrupt Line             */
#define FDCAN_ILS_MISC_Pos        (4U)
#define FDCAN_ILS_MISC_Msk        (0x1UL << FDCAN_ILS_MISC_Pos)                /*!< 0x00000010 */
#define FDCAN_ILS_MISC            FDCAN_ILS_MISC_Msk                           /*!<Timeout Occurred
                                                                                    Message RAM Access Failure
                                                                                    Timestamp Wraparound                    */
#define FDCAN_ILS_BERR_Pos        (5U)
#define FDCAN_ILS_BERR_Msk        (0x1UL << FDCAN_ILS_BERR_Pos)                /*!< 0x00000020 */
#define FDCAN_ILS_BERR            FDCAN_ILS_BERR_Msk                           /*!<Error Passive
                                                                                   Error Logging Overflow                   */
#define FDCAN_ILS_PERR_Pos        (6U)
#define FDCAN_ILS_PERR_Msk        (0x1UL << FDCAN_ILS_PERR_Pos)                /*!< 0x00000040 */
#define FDCAN_ILS_PERR            FDCAN_ILS_PERR_Msk                           /*!<Access to Reserved Address Line
                                                                                   Protocol Error in Data Phase Line
                                                                                   Protocol Error in Arbitration Phase Line
                                                                                   Watchdog Interrupt Line
                                                                                   Bus_Off Status
                                                                                   Warning Status                           */

/*****************  Bit definition for FDCAN_ILE register  **********************/
#define FDCAN_ILE_EINT0_Pos       (0U)
#define FDCAN_ILE_EINT0_Msk       (0x1UL << FDCAN_ILE_EINT0_Pos)               /*!< 0x00000001 */
#define FDCAN_ILE_EINT0           FDCAN_ILE_EINT0_Msk                          /*!<Enable Interrupt Line 0                  */
#define FDCAN_ILE_EINT1_Pos       (1U)
#define FDCAN_ILE_EINT1_Msk       (0x1UL << FDCAN_ILE_EINT1_Pos)               /*!< 0x00000002 */
#define FDCAN_ILE_EINT1           FDCAN_ILE_EINT1_Msk                          /*!<Enable Interrupt Line 1                  */

/*****************  Bit definition for FDCAN_RXGFC register  ********************/
#define FDCAN_RXGFC_RRFE_Pos      (0U)
#define FDCAN_RXGFC_RRFE_Msk      (0x1UL << FDCAN_RXGFC_RRFE_Pos)              /*!< 0x00000001 */
#define FDCAN_RXGFC_RRFE          FDCAN_RXGFC_RRFE_Msk                         /*!<Reject Remote Frames Extended            */
#define FDCAN_RXGFC_RRFS_Pos      (1U)
#define FDCAN_RXGFC_RRFS_Msk      (0x1UL << FDCAN_RXGFC_RRFS_Pos)              /*!< 0x00000002 */
#define FDCAN_RXGFC_RRFS          FDCAN_RXGFC_RRFS_Msk                         /*!<Reject Remote Frames Standard            */
#define FDCAN_RXGFC_ANFE_Pos      (2U)
#define FDCAN_RXGFC_ANFE_Msk      (0x3UL << FDCAN_RXGFC_ANFE_Pos)              /*!< 0x0000000C */
#define FDCAN_RXGFC_ANFE          FDCAN_RXGFC_ANFE_Msk                         /*!<Accept Non-matching Frames Extended      */
#define FDCAN_RXGFC_ANFS_Pos      (4U)
#define FDCAN_RXGFC_ANFS_Msk      (0x3UL << FDCAN_RXGFC_ANFS_Pos)              /*!< 0x00000030 */
#define FDCAN_RXGFC_ANFS          FDCAN_RXGFC_ANFS_Msk                         /*!<Accept Non-matching Frames Standard      */
#define FDCAN_RXGFC_F1OM_Pos      (8U)
#define FDCAN_RXGFC_F1OM_Msk      (0x1UL << FDCAN_RXGFC_F1OM_Pos)              /*!< 0x00000100 */
#define FDCAN_RXGFC_F1OM          FDCAN_RXGFC_F1OM_Msk                         /*!<FIFO 1 operation mode                    */
#define FDCAN_RXGFC_F0OM_Pos      (9U)
#define FDCAN_RXGFC_F0OM_Msk      (0x1UL << FDCAN_RXGFC_F0OM_Pos)              /*!< 0x00000200 */
#define FDCAN_RXGFC_F0OM          FDCAN_RXGFC_F0OM_Msk                         /*!<FIFO 0 operation mode                    */
#define FDCAN_RXGFC_LSS_Pos       (16U)
#define FDCAN_RXGFC_LSS_Msk       (0x1FUL << FDCAN_RXGFC_LSS_Pos)              /*!< 0x001F0000 */
#define FDCAN_RXGFC_LSS           FDCAN_RXGFC_LSS_Msk                          /*!<List Size Standard                       */
#define FDCAN_RXGFC_LSE_Pos       (24U)
#define FDCAN_RXGFC_LSE_Msk       (0xFUL << FDCAN_RXGFC_LSE_Pos)               /*!< 0x0F000000 */
#define FDCAN_RXGFC_LSE           FDCAN_RXGFC_LSE_Msk                          /*!<List Size Extended                       */

/*****************  Bit definition for FDCAN_XIDAM register  ********************/
#define FDCAN_XIDAM_EIDM_Pos      (0U)
#define FDCAN_XIDAM_EIDM_Msk      (0x1FFFFFFFUL << FDCAN_XIDAM_EIDM_Pos)       /*!< 0x1FFFFFFF */
#define FDCAN_XIDAM_EIDM          FDCAN_XIDAM_EIDM_Msk                         /*!<Extended ID Mask                         */

/*****************  Bit definition for FDCAN_HPMS register  *********************/
#define FDCAN_HPMS_BIDX_Pos       (0U)
#define FDCAN_HPMS_BIDX_Msk       (0x7UL << FDCAN_HPMS_BIDX_Pos)               /*!< 0x00000007 */
#define FDCAN_HPMS_BIDX           FDCAN_HPMS_BIDX_Msk                          /*!<Buffer Index                             */
#define FDCAN_HPMS_MSI_Pos        (6U)
#define FDCAN_HPMS_MSI_Msk        (0x3UL << FDCAN_HPMS_MSI_Pos)                /*!< 0x000000C0 */
#define FDCAN_HPMS_MSI            FDCAN_HPMS_MSI_Msk                           /*!<Message Storage Indicator                */
#define FDCAN_HPMS_FIDX_Pos       (8U)
#define FDCAN_HPMS_FIDX_Msk       (0x1FUL << FDCAN_HPMS_FIDX_Pos)              /*!< 0x00001F00 */
#define FDCAN_HPMS_FIDX           FDCAN_HPMS_FIDX_Msk                          /*!<Filter Index                             */
#define FDCAN_HPMS_FLST_Pos       (15U)
#define FDCAN_HPMS_FLST_Msk       (0x1UL << FDCAN_HPMS_FLST_Pos)               /*!< 0x00008000 */
#define FDCAN_HPMS_FLST           FDCAN_HPMS_FLST_Msk                          /*!<Filter List                              */

/*****************  Bit definition for FDCAN_RXF0S register  ********************/
#define FDCAN_RXF0S_F0FL_Pos      (0U)
#define FDCAN_RXF0S_F0FL_Msk      (0xFUL << FDCAN_RXF0S_F0FL_Pos)              /*!< 0x0000000F */
#define FDCAN_RXF0S_F0FL          FDCAN_RXF0S_F0FL_Msk                         /*!<Rx FIFO 0 Fill Level                     */
#define FDCAN_RXF0S_F0GI_Pos      (8U)
#define FDCAN_RXF0S_F0GI_Msk      (0x3UL << FDCAN_RXF0S_F0GI_Pos)              /*!< 0x00000300 */
#define FDCAN_RXF0S_F0GI          FDCAN_RXF0S_F0GI_Msk                         /*!<Rx FIFO 0 Get Index                      */
#define FDCAN_RXF0S_F0PI_Pos      (16U)
#define FDCAN_RXF0S_F0PI_Msk      (0x3UL << FDCAN_RXF0S_F0PI_Pos)              /*!< 0x00030000 */
#define FDCAN_RXF0S_F0PI          FDCAN_RXF0S_F0PI_Msk                         /*!<Rx FIFO 0 Put Index                      */
#define FDCAN_RXF0S_F0F_Pos       (24U)
#define FDCAN_RXF0S_F0F_Msk       (0x1UL << FDCAN_RXF0S_F0F_Pos)               /*!< 0x01000000 */
#define FDCAN_RXF0S_F0F           FDCAN_RXF0S_F0F_Msk                          /*!<Rx FIFO 0 Full                           */
#define FDCAN_RXF0S_RF0L_Pos      (25U)
#define FDCAN_RXF0S_RF0L_Msk      (0x1UL << FDCAN_RXF0S_RF0L_Pos)              /*!< 0x02000000 */
#define FDCAN_RXF0S_RF0L          FDCAN_RXF0S_RF0L_Msk                         /*!<Rx FIFO 0 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF0A register  ********************/
#define FDCAN_RXF0A_F0AI_Pos      (0U)
#define FDCAN_RXF0A_F0AI_Msk      (0x7UL << FDCAN_RXF0A_F0AI_Pos)              /*!< 0x00000007 */
#define FDCAN_RXF0A_F0AI          FDCAN_RXF0A_F0AI_Msk                         /*!<Rx FIFO 0 Acknowledge Index              */

/*****************  Bit definition for FDCAN_RXF1S register  ********************/
#define FDCAN_RXF1S_F1FL_Pos      (0U)
#define FDCAN_RXF1S_F1FL_Msk      (0xFUL << FDCAN_RXF1S_F1FL_Pos)              /*!< 0x0000000F */
#define FDCAN_RXF1S_F1FL          FDCAN_RXF1S_F1FL_Msk                         /*!<Rx FIFO 1 Fill Level                     */
#define FDCAN_RXF1S_F1GI_Pos      (8U)
#define FDCAN_RXF1S_F1GI_Msk      (0x3UL << FDCAN_RXF1S_F1GI_Pos)              /*!< 0x00000300 */
#define FDCAN_RXF1S_F1GI          FDCAN_RXF1S_F1GI_Msk                         /*!<Rx FIFO 1 Get Index                      */
#define FDCAN_RXF1S_F1PI_Pos      (16U)
#define FDCAN_RXF1S_F1PI_Msk      (0x3UL << FDCAN_RXF1S_F1PI_Pos)              /*!< 0x00030000 */
#define FDCAN_RXF1S_F1PI          FDCAN_RXF1S_F1PI_Msk                         /*!<Rx FIFO 1 Put Index                      */
#define FDCAN_RXF1S_F1F_Pos       (24U)
#define FDCAN_RXF1S_F1F_Msk       (0x1UL << FDCAN_RXF1S_F1F_Pos)               /*!< 0x01000000 */
#define FDCAN_RXF1S_F1F           FDCAN_RXF1S_F1F_Msk                          /*!<Rx FIFO 1 Full                           */
#define FDCAN_RXF1S_RF1L_Pos      (25U)
#define FDCAN_RXF1S_RF1L_Msk      (0x1UL << FDCAN_RXF1S_RF1L_Pos)              /*!< 0x02000000 */
#define FDCAN_RXF1S_RF1L          FDCAN_RXF1S_RF1L_Msk                         /*!<Rx FIFO 1 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF1A register  ********************/
#define FDCAN_RXF1A_F1AI_Pos      (0U)
#define FDCAN_RXF1A_F1AI_Msk      (0x7UL << FDCAN_RXF1A_F1AI_Pos)              /*!< 0x00000007 */
#define FDCAN_RXF1A_F1AI          FDCAN_RXF1A_F1AI_Msk                         /*!<Rx FIFO 1 Acknowledge Index              */

/*****************  Bit definition for FDCAN_TXBC register  *********************/
#define FDCAN_TXBC_TFQM_Pos       (24U)
#define FDCAN_TXBC_TFQM_Msk       (0x1UL << FDCAN_TXBC_TFQM_Pos)               /*!< 0x01000000 */
#define FDCAN_TXBC_TFQM           FDCAN_TXBC_TFQM_Msk                          /*!<Tx FIFO/Queue Mode                       */

/*****************  Bit definition for FDCAN_TXFQS register  *********************/
#define FDCAN_TXFQS_TFFL_Pos      (0U)
#define FDCAN_TXFQS_TFFL_Msk      (0x7UL << FDCAN_TXFQS_TFFL_Pos)              /*!< 0x00000007 */
#define FDCAN_TXFQS_TFFL          FDCAN_TXFQS_TFFL_Msk                         /*!<Tx FIFO Free Level                       */
#define FDCAN_TXFQS_TFGI_Pos      (8U)
#define FDCAN_TXFQS_TFGI_Msk      (0x3UL << FDCAN_TXFQS_TFGI_Pos)              /*!< 0x00000300 */
#define FDCAN_TXFQS_TFGI          FDCAN_TXFQS_TFGI_Msk                         /*!<Tx FIFO Get Index                        */
#define FDCAN_TXFQS_TFQPI_Pos     (16U)
#define FDCAN_TXFQS_TFQPI_Msk     (0x3UL << FDCAN_TXFQS_TFQPI_Pos)             /*!< 0x00030000 */
#define FDCAN_TXFQS_TFQPI         FDCAN_TXFQS_TFQPI_Msk                        /*!<Tx FIFO/Queue Put Index                  */
#define FDCAN_TXFQS_TFQF_Pos      (21U)
#define FDCAN_TXFQS_TFQF_Msk      (0x1UL << FDCAN_TXFQS_TFQF_Pos)              /*!< 0x00200000 */
#define FDCAN_TXFQS_TFQF          FDCAN_TXFQS_TFQF_Msk                         /*!<Tx FIFO/Queue Full                       */

/*****************  Bit definition for FDCAN_TXBRP register  *********************/
#define FDCAN_TXBRP_TRP_Pos       (0U)
#define FDCAN_TXBRP_TRP_Msk       (0x7UL << FDCAN_TXBRP_TRP_Pos)               /*!< 0x00000007 */
#define FDCAN_TXBRP_TRP           FDCAN_TXBRP_TRP_Msk                          /*!<Transmission Request Pending             */

/*****************  Bit definition for FDCAN_TXBAR register  *********************/
#define FDCAN_TXBAR_AR_Pos        (0U)
#define FDCAN_TXBAR_AR_Msk        (0x7UL << FDCAN_TXBAR_AR_Pos)                /*!< 0x00000007 */
#define FDCAN_TXBAR_AR            FDCAN_TXBAR_AR_Msk                           /*!<Add Request                              */

/*****************  Bit definition for FDCAN_TXBCR register  *********************/
#define FDCAN_TXBCR_CR_Pos        (0U)
#define FDCAN_TXBCR_CR_Msk        (0x7UL << FDCAN_TXBCR_CR_Pos)                /*!< 0x00000007 */
#define FDCAN_TXBCR_CR            FDCAN_TXBCR_CR_Msk                           /*!<Cancellation Request                     */

/*****************  Bit definition for FDCAN_TXBTO register  *********************/
#define FDCAN_TXBTO_TO_Pos        (0U)
#define FDCAN_TXBTO_TO_Msk        (0x7UL << FDCAN_TXBTO_TO_Pos)                /*!< 0x00000007 */
#define FDCAN_TXBTO_TO            FDCAN_TXBTO_TO_Msk                           /*!<Transmission Occurred                    */

/*****************  Bit definition for FDCAN_TXBCF register  *********************/
#define FDCAN_TXBCF_CF_Pos        (0U)
#define FDCAN_TXBCF_CF_Msk        (0x7UL << FDCAN_TXBCF_CF_Pos)                /*!< 0x00000007 */
#define FDCAN_TXBCF_CF            FDCAN_TXBCF_CF_Msk                           /*!<Cancellation Finished                    */

/*****************  Bit definition for FDCAN_TXBTIE register  ********************/
#define FDCAN_TXBTIE_TIE_Pos      (0U)
#define FDCAN_TXBTIE_TIE_Msk      (0x7UL << FDCAN_TXBTIE_TIE_Pos)              /*!< 0x00000007 */
#define FDCAN_TXBTIE_TIE          FDCAN_TXBTIE_TIE_Msk                         /*!<Transmission Interrupt Enable            */

/*****************  Bit definition for FDCAN_ TXBCIE register  *******************/
#define FDCAN_TXBCIE_CFIE_Pos     (0U)
#define FDCAN_TXBCIE_CFIE_Msk     (0x7UL << FDCAN_TXBCIE_CFIE_Pos)             /*!< 0x00000007 */
#define FDCAN_TXBCIE_CFIE         FDCAN_TXBCIE_CFIE_Msk                        /*!<Cancellation Finished Interrupt Enable   */

/*****************  Bit definition for FDCAN_TXEFS register  *********************/
#define FDCAN_TXEFS_EFFL_Pos      (0U)
#define FDCAN_TXEFS_EFFL_Msk      (0x7UL << FDCAN_TXEFS_EFFL_Pos)              /*!< 0x00000007 */
#define FDCAN_TXEFS_EFFL          FDCAN_TXEFS_EFFL_Msk                         /*!<Event FIFO Fill Level                    */
#define FDCAN_TXEFS_EFGI_Pos      (8U)
#define FDCAN_TXEFS_EFGI_Msk      (0x3UL << FDCAN_TXEFS_EFGI_Pos)              /*!< 0x00000300 */
#define FDCAN_TXEFS_EFGI          FDCAN_TXEFS_EFGI_Msk                         /*!<Event FIFO Get Index                     */
#define FDCAN_TXEFS_EFPI_Pos      (16U)
#define FDCAN_TXEFS_EFPI_Msk      (0x3UL << FDCAN_TXEFS_EFPI_Pos)              /*!< 0x00030000 */
#define FDCAN_TXEFS_EFPI          FDCAN_TXEFS_EFPI_Msk                         /*!<Event FIFO Put Index                     */
#define FDCAN_TXEFS_EFF_Pos       (24U)
#define FDCAN_TXEFS_EFF_Msk       (0x1UL << FDCAN_TXEFS_EFF_Pos)               /*!< 0x01000000 */
#define FDCAN_TXEFS_EFF           FDCAN_TXEFS_EFF_Msk                          /*!<Event FIFO Full                          */
#define FDCAN_TXEFS_TEFL_Pos      (25U)
#define FDCAN_TXEFS_TEFL_Msk      (0x1UL << FDCAN_TXEFS_TEFL_Pos)              /*!< 0x02000000 */
#define FDCAN_TXEFS_TEFL          FDCAN_TXEFS_TEFL_Msk                         /*!<Tx Event FIFO Element Lost               */

/*****************  Bit definition for FDCAN_TXEFA register  *********************/
#define FDCAN_TXEFA_EFAI_Pos      (0U)
#define FDCAN_TXEFA_EFAI_Msk      (0x3UL << FDCAN_TXEFA_EFAI_Pos)              /*!< 0x00000003 */
#define FDCAN_TXEFA_EFAI          FDCAN_TXEFA_EFAI_Msk                         /*!<Event FIFO Acknowledge Index             */


/*!<FDCAN config registers */
/*****************  Bit definition for FDCAN_CKDIV register  *********************/
#define FDCAN_CKDIV_PDIV_Pos      (0U)
#define FDCAN_CKDIV_PDIV_Msk      (0xFUL << FDCAN_CKDIV_PDIV_Pos)              /*!< 0x0000000F */
#define FDCAN_CKDIV_PDIV          FDCAN_CKDIV_PDIV_Msk                         /*!<Input Clock Divider                      */

/*****************  Bit definition for FDCAN_OPTR register   *********************/
#define FDCAN_OPTR_OPTR_Pos       (0U)
#define FDCAN_OPTR_OPTR_Msk       (0xFFFFFFFFUL << FDCAN_OPTR_OPTR_Pos)        /*!< 0xFFFFFFFF */
#define FDCAN_OPTR_OPTR           FDCAN_OPTR_OPTR_Msk                          /*!<Option Register                          */


/******************************************************************************/
/*                                                                            */
/*                                    FLASH                                   */
/*                                                                            */
/******************************************************************************/
/*******************  Bits definition for FLASH_ACR register  *****************/
#define FLASH_ACR_LATENCY_Pos             (0U)
#define FLASH_ACR_LATENCY_Msk             (0xFUL << FLASH_ACR_LATENCY_Pos)     /*!< 0x0000000F */
#define FLASH_ACR_LATENCY                 FLASH_ACR_LATENCY_Msk
#define FLASH_ACR_LATENCY_0WS             (0x00000000UL)
#define FLASH_ACR_LATENCY_1WS             (0x00000001UL)
#define FLASH_ACR_LATENCY_2WS             (0x00000002UL)
#define FLASH_ACR_LATENCY_3WS             (0x00000003UL)
#define FLASH_ACR_LATENCY_4WS             (0x00000004UL)
#define FLASH_ACR_LATENCY_5WS             (0x00000005UL)
#define FLASH_ACR_LATENCY_6WS             (0x00000006UL)
#define FLASH_ACR_LATENCY_7WS             (0x00000007UL)
#define FLASH_ACR_LATENCY_8WS             (0x00000008UL)
#define FLASH_ACR_LATENCY_9WS             (0x00000009UL)
#define FLASH_ACR_LATENCY_10WS            (0x0000000AUL)
#define FLASH_ACR_LATENCY_11WS            (0x0000000BUL)
#define FLASH_ACR_LATENCY_12WS            (0x0000000CUL)
#define FLASH_ACR_LATENCY_13WS            (0x0000000DUL)
#define FLASH_ACR_LATENCY_14WS            (0x0000000EUL)
#define FLASH_ACR_LATENCY_15WS            (0x0000000FUL)
#define FLASH_ACR_RUN_PD_Pos              (13U)
#define FLASH_ACR_RUN_PD_Msk              (0x1UL << FLASH_ACR_RUN_PD_Pos)      /*!< 0x00002000 */
#define FLASH_ACR_RUN_PD                  FLASH_ACR_RUN_PD_Msk                 /*!< Flash power down mode during run */
#define FLASH_ACR_SLEEP_PD_Pos            (14U)
#define FLASH_ACR_SLEEP_PD_Msk            (0x1UL << FLASH_ACR_SLEEP_PD_Pos)    /*!< 0x00004000 */
#define FLASH_ACR_SLEEP_PD                FLASH_ACR_SLEEP_PD_Msk               /*!< Flash power down mode during sleep */
#define FLASH_ACR_LVEN_Pos                (15U)
#define FLASH_ACR_LVEN_Msk                (0x1UL << FLASH_ACR_LVEN_Pos)        /*!< 0x00008000 */
#define FLASH_ACR_LVEN                    FLASH_ACR_LVEN_Msk                   /*!< LVE A/B Flash pin low */

/******************  Bits definition for FLASH_NSSR register  *****************/
#define FLASH_NSSR_NSEOP_Pos              (0U)
#define FLASH_NSSR_NSEOP_Msk              (0x1UL << FLASH_NSSR_NSEOP_Pos)      /*!< 0x00000001 */
#define FLASH_NSSR_NSEOP                  FLASH_NSSR_NSEOP_Msk
#define FLASH_NSSR_NSOPERR_Pos            (1U)
#define FLASH_NSSR_NSOPERR_Msk            (0x1UL << FLASH_NSSR_NSOPERR_Pos)    /*!< 0x00000002 */
#define FLASH_NSSR_NSOPERR                FLASH_NSSR_NSOPERR_Msk
#define FLASH_NSSR_NSPROGERR_Pos          (3U)
#define FLASH_NSSR_NSPROGERR_Msk          (0x1UL << FLASH_NSSR_NSPROGERR_Pos)  /*!< 0x00000008 */
#define FLASH_NSSR_NSPROGERR              FLASH_NSSR_NSPROGERR_Msk
#define FLASH_NSSR_NSWRPERR_Pos           (4U)
#define FLASH_NSSR_NSWRPERR_Msk           (0x1UL << FLASH_NSSR_NSWRPERR_Pos)   /*!< 0x00000010 */
#define FLASH_NSSR_NSWRPERR               FLASH_NSSR_NSWRPERR_Msk
#define FLASH_NSSR_NSPGAERR_Pos           (5U)
#define FLASH_NSSR_NSPGAERR_Msk           (0x1UL << FLASH_NSSR_NSPGAERR_Pos)   /*!< 0x00000020 */
#define FLASH_NSSR_NSPGAERR               FLASH_NSSR_NSPGAERR_Msk
#define FLASH_NSSR_NSSIZERR_Pos           (6U)
#define FLASH_NSSR_NSSIZERR_Msk           (0x1UL << FLASH_NSSR_NSSIZERR_Pos)   /*!< 0x00000040 */
#define FLASH_NSSR_NSSIZERR               FLASH_NSSR_NSSIZERR_Msk
#define FLASH_NSSR_NSPGSERR_Pos           (7U)
#define FLASH_NSSR_NSPGSERR_Msk           (0x1UL << FLASH_NSSR_NSPGSERR_Pos)   /*!< 0x00000080 */
#define FLASH_NSSR_NSPGSERR               FLASH_NSSR_NSPGSERR_Msk
#define FLASH_NSSR_OPTWERR_Pos            (13U)
#define FLASH_NSSR_OPTWERR_Msk            (0x1UL << FLASH_NSSR_OPTWERR_Pos)    /*!< 0x00002000 */
#define FLASH_NSSR_OPTWERR                FLASH_NSSR_OPTWERR_Msk
#define FLASH_NSSR_NSBSY_Pos              (16U)
#define FLASH_NSSR_NSBSY_Msk              (0x1UL << FLASH_NSSR_NSBSY_Pos)      /*!< 0x00010000 */
#define FLASH_NSSR_NSBSY                  FLASH_NSSR_NSBSY_Msk

/******************  Bits definition for FLASH_SECSR register  ****************/
#define FLASH_SECSR_SECEOP_Pos            (0U)
#define FLASH_SECSR_SECEOP_Msk            (0x1UL << FLASH_SECSR_SECEOP_Pos)    /*!< 0x00000001 */
#define FLASH_SECSR_SECEOP                FLASH_SECSR_SECEOP_Msk
#define FLASH_SECSR_SECOPERR_Pos          (1U)
#define FLASH_SECSR_SECOPERR_Msk          (0x1UL << FLASH_SECSR_SECOPERR_Pos)  /*!< 0x00000002 */
#define FLASH_SECSR_SECOPERR              FLASH_SECSR_SECOPERR_Msk
#define FLASH_SECSR_SECPROGERR_Pos        (3U)
#define FLASH_SECSR_SECPROGERR_Msk        (0x1UL << FLASH_SECSR_SECPROGERR_Pos)/*!< 0x00000008 */
#define FLASH_SECSR_SECPROGERR            FLASH_SECSR_SECPROGERR_Msk
#define FLASH_SECSR_SECWRPERR_Pos         (4U)
#define FLASH_SECSR_SECWRPERR_Msk         (0x1UL << FLASH_SECSR_SECWRPERR_Pos) /*!< 0x00000010 */
#define FLASH_SECSR_SECWRPERR             FLASH_SECSR_SECWRPERR_Msk
#define FLASH_SECSR_SECPGAERR_Pos         (5U)
#define FLASH_SECSR_SECPGAERR_Msk         (0x1UL << FLASH_SECSR_SECPGAERR_Pos) /*!< 0x00000020 */
#define FLASH_SECSR_SECPGAERR             FLASH_SECSR_SECPGAERR_Msk
#define FLASH_SECSR_SECSIZERR_Pos         (6U)
#define FLASH_SECSR_SECSIZERR_Msk         (0x1UL << FLASH_SECSR_SECSIZERR_Pos) /*!< 0x00000040 */
#define FLASH_SECSR_SECSIZERR             FLASH_SECSR_SECSIZERR_Msk
#define FLASH_SECSR_SECPGSERR_Pos         (7U)
#define FLASH_SECSR_SECPGSERR_Msk         (0x1UL << FLASH_SECSR_SECPGSERR_Pos) /*!< 0x00000080 */
#define FLASH_SECSR_SECPGSERR             FLASH_SECSR_SECPGSERR_Msk
#define FLASH_SECSR_SECBSY_Pos            (16U)
#define FLASH_SECSR_SECBSY_Msk            (0x1UL << FLASH_SECSR_SECBSY_Pos)    /*!< 0x00010000 */
#define FLASH_SECSR_SECBSY                FLASH_SECSR_SECBSY_Msk

/******************  Bits definition for FLASH_NSCR register  *****************/
#define FLASH_NSCR_NSPG_Pos               (0U)
#define FLASH_NSCR_NSPG_Msk               (0x1UL << FLASH_NSCR_NSPG_Pos)       /*!< 0x00000001 */
#define FLASH_NSCR_NSPG                   FLASH_NSCR_NSPG_Msk
#define FLASH_NSCR_NSPER_Pos              (1U)
#define FLASH_NSCR_NSPER_Msk              (0x1UL << FLASH_NSCR_NSPER_Pos)      /*!< 0x00000002 */
#define FLASH_NSCR_NSPER                  FLASH_NSCR_NSPER_Msk
#define FLASH_NSCR_NSMER1_Pos             (2U)
#define FLASH_NSCR_NSMER1_Msk             (0x1UL << FLASH_NSCR_NSMER1_Pos)     /*!< 0x00000004 */
#define FLASH_NSCR_NSMER1                 FLASH_NSCR_NSMER1_Msk
#define FLASH_NSCR_NSPNB_Pos              (3U)
#define FLASH_NSCR_NSPNB_Msk              (0x7FUL << FLASH_NSCR_NSPNB_Pos)     /*!< 0x000003F8 */
#define FLASH_NSCR_NSPNB                  FLASH_NSCR_NSPNB_Msk
#define FLASH_NSCR_NSBKER_Pos             (11U)
#define FLASH_NSCR_NSBKER_Msk             (0x1UL << FLASH_NSCR_NSBKER_Pos)     /*!< 0x00000800 */
#define FLASH_NSCR_NSBKER                 FLASH_NSCR_NSBKER_Msk
#define FLASH_NSCR_NSMER2_Pos             (15U)
#define FLASH_NSCR_NSMER2_Msk             (0x1UL << FLASH_NSCR_NSMER2_Pos)     /*!< 0x00008000 */
#define FLASH_NSCR_NSMER2                 FLASH_NSCR_NSMER2_Msk
#define FLASH_NSCR_NSSTRT_Pos             (16U)
#define FLASH_NSCR_NSSTRT_Msk             (0x1UL << FLASH_NSCR_NSSTRT_Pos)     /*!< 0x00010000 */
#define FLASH_NSCR_NSSTRT                 FLASH_NSCR_NSSTRT_Msk
#define FLASH_NSCR_OPTSTRT_Pos            (17U)
#define FLASH_NSCR_OPTSTRT_Msk            (0x1UL << FLASH_NSCR_OPTSTRT_Pos)    /*!< 0x00020000 */
#define FLASH_NSCR_OPTSTRT                FLASH_NSCR_OPTSTRT_Msk
#define FLASH_NSCR_NSEOPIE_Pos            (24U)
#define FLASH_NSCR_NSEOPIE_Msk            (0x1UL << FLASH_NSCR_NSEOPIE_Pos)    /*!< 0x01000000 */
#define FLASH_NSCR_NSEOPIE                FLASH_NSCR_NSEOPIE_Msk
#define FLASH_NSCR_NSERRIE_Pos            (25U)
#define FLASH_NSCR_NSERRIE_Msk            (0x1UL << FLASH_NSCR_NSERRIE_Pos)    /*!< 0x02000000 */
#define FLASH_NSCR_NSERRIE                FLASH_NSCR_NSERRIE_Msk
#define FLASH_NSCR_OBL_LAUNCH_Pos         (27U)
#define FLASH_NSCR_OBL_LAUNCH_Msk         (0x1UL << FLASH_NSCR_OBL_LAUNCH_Pos) /*!< 0x08000000 */
#define FLASH_NSCR_OBL_LAUNCH             FLASH_NSCR_OBL_LAUNCH_Msk
#define FLASH_NSCR_OPTLOCK_Pos            (30U)
#define FLASH_NSCR_OPTLOCK_Msk            (0x1UL << FLASH_NSCR_OPTLOCK_Pos)    /*!< 0x40000000 */
#define FLASH_NSCR_OPTLOCK                FLASH_NSCR_OPTLOCK_Msk
#define FLASH_NSCR_NSLOCK_Pos             (31U)
#define FLASH_NSCR_NSLOCK_Msk             (0x1UL << FLASH_NSCR_NSLOCK_Pos)     /*!< 0x80000000 */
#define FLASH_NSCR_NSLOCK                 FLASH_NSCR_NSLOCK_Msk

/******************  Bits definition for FLASH_SECCR register  ****************/
#define FLASH_SECCR_SECPG_Pos             (0U)
#define FLASH_SECCR_SECPG_Msk             (0x1UL << FLASH_SECCR_SECPG_Pos)     /*!< 0x00000001 */
#define FLASH_SECCR_SECPG                 FLASH_SECCR_SECPG_Msk
#define FLASH_SECCR_SECPER_Pos            (1U)
#define FLASH_SECCR_SECPER_Msk            (0x1UL << FLASH_SECCR_SECPER_Pos)    /*!< 0x00000002 */
#define FLASH_SECCR_SECPER                FLASH_SECCR_SECPER_Msk
#define FLASH_SECCR_SECMER1_Pos           (2U)
#define FLASH_SECCR_SECMER1_Msk           (0x1UL << FLASH_SECCR_SECMER1_Pos)   /*!< 0x00000004 */
#define FLASH_SECCR_SECMER1               FLASH_SECCR_SECMER1_Msk
#define FLASH_SECCR_SECPNB_Pos            (3U)
#define FLASH_SECCR_SECPNB_Msk            (0x7FUL << FLASH_SECCR_SECPNB_Pos)   /*!< 0x000003F8 */
#define FLASH_SECCR_SECPNB                FLASH_SECCR_SECPNB_Msk
#define FLASH_SECCR_SECBKER_Pos           (11U)
#define FLASH_SECCR_SECBKER_Msk           (0x1UL << FLASH_SECCR_SECBKER_Pos)   /*!< 0x00000800 */
#define FLASH_SECCR_SECBKER               FLASH_SECCR_SECBKER_Msk
#define FLASH_SECCR_SECMER2_Pos           (15U)
#define FLASH_SECCR_SECMER2_Msk           (0x1UL << FLASH_SECCR_SECMER2_Pos)   /*!< 0x00008000 */
#define FLASH_SECCR_SECMER2               FLASH_SECCR_SECMER2_Msk
#define FLASH_SECCR_SECSTRT_Pos           (16U)
#define FLASH_SECCR_SECSTRT_Msk           (0x1UL << FLASH_SECCR_SECSTRT_Pos)   /*!< 0x00010000 */
#define FLASH_SECCR_SECSTRT               FLASH_SECCR_SECSTRT_Msk
#define FLASH_SECCR_SECEOPIE_Pos          (24U)
#define FLASH_SECCR_SECEOPIE_Msk          (0x1UL << FLASH_SECCR_SECEOPIE_Pos)  /*!< 0x01000000 */
#define FLASH_SECCR_SECEOPIE              FLASH_SECCR_SECEOPIE_Msk
#define FLASH_SECCR_SECERRIE_Pos          (25U)
#define FLASH_SECCR_SECERRIE_Msk          (0x1UL << FLASH_SECCR_SECERRIE_Pos)  /*!< 0x02000000 */
#define FLASH_SECCR_SECERRIE              FLASH_SECCR_SECERRIE_Msk
#define FLASH_SECCR_SECINV_Pos            (29U)
#define FLASH_SECCR_SECINV_Msk            (0x1UL << FLASH_SECCR_SECINV_Pos)    /*!< 0x20000000 */
#define FLASH_SECCR_SECINV                FLASH_SECCR_SECINV_Msk
#define FLASH_SECCR_SECLOCK_Pos           (31U)
#define FLASH_SECCR_SECLOCK_Msk           (0x1UL << FLASH_SECCR_SECLOCK_Pos)   /*!< 0x80000000 */
#define FLASH_SECCR_SECLOCK               FLASH_SECCR_SECLOCK_Msk

/*******************  Bits definition for FLASH_ECCR register  ***************/
#define FLASH_ECCR_ADDR_ECC_Pos           (0U)
#define FLASH_ECCR_ADDR_ECC_Msk           (0x7FFFFUL << FLASH_ECCR_ADDR_ECC_Pos)/*!< 0x0007FFFF */
#define FLASH_ECCR_ADDR_ECC               FLASH_ECCR_ADDR_ECC_Msk
#define FLASH_ECCR_BK_ECC_Pos             (21U)
#define FLASH_ECCR_BK_ECC_Msk             (0x1UL << FLASH_ECCR_BK_ECC_Pos)      /*!< 0x00200000 */
#define FLASH_ECCR_BK_ECC                 FLASH_ECCR_BK_ECC_Msk
#define FLASH_ECCR_SYSF_ECC_Pos           (22U)
#define FLASH_ECCR_SYSF_ECC_Msk           (0x1UL << FLASH_ECCR_SYSF_ECC_Pos)    /*!< 0x00400000 */
#define FLASH_ECCR_SYSF_ECC               FLASH_ECCR_SYSF_ECC_Msk
#define FLASH_ECCR_ECCIE_Pos              (24U)
#define FLASH_ECCR_ECCIE_Msk              (0x1UL << FLASH_ECCR_ECCIE_Pos)       /*!< 0x01000000 */
#define FLASH_ECCR_ECCIE                  FLASH_ECCR_ECCIE_Msk
#define FLASH_ECCR_ECCC2_Pos              (28U)
#define FLASH_ECCR_ECCC2_Msk              (0x1UL << FLASH_ECCR_ECCC2_Pos)       /*!< 0x10000000 */
#define FLASH_ECCR_ECCC2                  FLASH_ECCR_ECCC2_Msk
#define FLASH_ECCR_ECCD2_Pos              (29U)
#define FLASH_ECCR_ECCD2_Msk              (0x1UL << FLASH_ECCR_ECCD2_Pos)       /*!< 0x20000000 */
#define FLASH_ECCR_ECCD2                  FLASH_ECCR_ECCD2_Msk
#define FLASH_ECCR_ECCC_Pos               (30U)
#define FLASH_ECCR_ECCC_Msk               (0x1UL << FLASH_ECCR_ECCC_Pos)        /*!< 0x40000000 */
#define FLASH_ECCR_ECCC                   FLASH_ECCR_ECCC_Msk
#define FLASH_ECCR_ECCD_Pos               (31U)
#define FLASH_ECCR_ECCD_Msk               (0x1UL << FLASH_ECCR_ECCD_Pos)        /*!< 0x80000000 */
#define FLASH_ECCR_ECCD                   FLASH_ECCR_ECCD_Msk

/*******************  Bits definition for FLASH_OPTR register  ***************/
#define FLASH_OPTR_RDP_Pos                (0U)
#define FLASH_OPTR_RDP_Msk                (0xFFUL << FLASH_OPTR_RDP_Pos)       /*!< 0x000000FF */
#define FLASH_OPTR_RDP                    FLASH_OPTR_RDP_Msk
#define FLASH_OPTR_BOR_LEV_Pos            (8U)
#define FLASH_OPTR_BOR_LEV_Msk            (0x7UL << FLASH_OPTR_BOR_LEV_Pos)    /*!< 0x00000700 */
#define FLASH_OPTR_BOR_LEV                FLASH_OPTR_BOR_LEV_Msk
#define FLASH_OPTR_BOR_LEV_0              (0x0UL << FLASH_OPTR_BOR_LEV_Pos)    /*!< 0x00000000 */
#define FLASH_OPTR_BOR_LEV_1              (0x1UL << FLASH_OPTR_BOR_LEV_Pos)    /*!< 0x00000100 */
#define FLASH_OPTR_BOR_LEV_2              (0x2UL << FLASH_OPTR_BOR_LEV_Pos)    /*!< 0x00000200 */
#define FLASH_OPTR_BOR_LEV_3              (0x3UL << FLASH_OPTR_BOR_LEV_Pos)    /*!< 0x00000300 */
#define FLASH_OPTR_BOR_LEV_4              (0x4UL << FLASH_OPTR_BOR_LEV_Pos)    /*!< 0x00000400 */
#define FLASH_OPTR_nRST_STOP_Pos          (12U)
#define FLASH_OPTR_nRST_STOP_Msk          (0x1UL << FLASH_OPTR_nRST_STOP_Pos)  /*!< 0x00001000 */
#define FLASH_OPTR_nRST_STOP              FLASH_OPTR_nRST_STOP_Msk
#define FLASH_OPTR_nRST_STDBY_Pos         (13U)
#define FLASH_OPTR_nRST_STDBY_Msk         (0x1UL << FLASH_OPTR_nRST_STDBY_Pos) /*!< 0x00002000 */
#define FLASH_OPTR_nRST_STDBY             FLASH_OPTR_nRST_STDBY_Msk
#define FLASH_OPTR_nRST_SHDW_Pos          (14U)
#define FLASH_OPTR_nRST_SHDW_Msk          (0x1UL << FLASH_OPTR_nRST_SHDW_Pos)  /*!< 0x00004000 */
#define FLASH_OPTR_nRST_SHDW              FLASH_OPTR_nRST_SHDW_Msk
#define FLASH_OPTR_IWDG_SW_Pos            (16U)
#define FLASH_OPTR_IWDG_SW_Msk            (0x1UL << FLASH_OPTR_IWDG_SW_Pos)    /*!< 0x00010000 */
#define FLASH_OPTR_IWDG_SW                FLASH_OPTR_IWDG_SW_Msk
#define FLASH_OPTR_IWDG_STOP_Pos          (17U)
#define FLASH_OPTR_IWDG_STOP_Msk          (0x1UL << FLASH_OPTR_IWDG_STOP_Pos)  /*!< 0x00020000 */
#define FLASH_OPTR_IWDG_STOP              FLASH_OPTR_IWDG_STOP_Msk
#define FLASH_OPTR_IWDG_STDBY_Pos         (18U)
#define FLASH_OPTR_IWDG_STDBY_Msk         (0x1UL << FLASH_OPTR_IWDG_STDBY_Pos) /*!< 0x00040000 */
#define FLASH_OPTR_IWDG_STDBY             FLASH_OPTR_IWDG_STDBY_Msk
#define FLASH_OPTR_WWDG_SW_Pos            (19U)
#define FLASH_OPTR_WWDG_SW_Msk            (0x1UL << FLASH_OPTR_WWDG_SW_Pos)    /*!< 0x00080000 */
#define FLASH_OPTR_WWDG_SW                FLASH_OPTR_WWDG_SW_Msk
#define FLASH_OPTR_SWAP_BANK_Pos          (20U)
#define FLASH_OPTR_SWAP_BANK_Msk          (0x1UL << FLASH_OPTR_SWAP_BANK_Pos)  /*!< 0x00100000 */
#define FLASH_OPTR_SWAP_BANK              FLASH_OPTR_SWAP_BANK_Msk
#define FLASH_OPTR_DB256K_Pos             (21U)
#define FLASH_OPTR_DB256K_Msk             (0x1UL << FLASH_OPTR_DB256K_Pos)     /*!< 0x00200000 */
#define FLASH_OPTR_DB256K                 FLASH_OPTR_DB256K_Msk
#define FLASH_OPTR_DBANK_Pos              (22U)
#define FLASH_OPTR_DBANK_Msk              (0x1UL << FLASH_OPTR_DBANK_Pos)      /*!< 0x00400000 */
#define FLASH_OPTR_DBANK                  FLASH_OPTR_DBANK_Msk
#define FLASH_OPTR_SRAM2_PE_Pos           (24U)
#define FLASH_OPTR_SRAM2_PE_Msk           (0x1UL << FLASH_OPTR_SRAM2_PE_Pos)   /*!< 0x01000000 */
#define FLASH_OPTR_SRAM2_PE               FLASH_OPTR_SRAM2_PE_Msk
#define FLASH_OPTR_SRAM2_RST_Pos          (25U)
#define FLASH_OPTR_SRAM2_RST_Msk          (0x1UL << FLASH_OPTR_SRAM2_RST_Pos)  /*!< 0x02000000 */
#define FLASH_OPTR_SRAM2_RST              FLASH_OPTR_SRAM2_RST_Msk
#define FLASH_OPTR_nSWBOOT0_Pos           (26U)
#define FLASH_OPTR_nSWBOOT0_Msk           (0x1UL << FLASH_OPTR_nSWBOOT0_Pos)   /*!< 0x04000000 */
#define FLASH_OPTR_nSWBOOT0               FLASH_OPTR_nSWBOOT0_Msk
#define FLASH_OPTR_nBOOT0_Pos             (27U)
#define FLASH_OPTR_nBOOT0_Msk             (0x1UL << FLASH_OPTR_nBOOT0_Pos)     /*!< 0x08000000 */
#define FLASH_OPTR_nBOOT0                 FLASH_OPTR_nBOOT0_Msk
#define FLASH_OPTR_PA15_PUPEN_Pos         (28U)
#define FLASH_OPTR_PA15_PUPEN_Msk         (0x1UL << FLASH_OPTR_PA15_PUPEN_Pos) /*!< 0x10000000 */
#define FLASH_OPTR_PA15_PUPEN             FLASH_OPTR_PA15_PUPEN_Msk
#define FLASH_OPTR_TZEN_Pos               (31U)
#define FLASH_OPTR_TZEN_Msk               (0x1UL << FLASH_OPTR_TZEN_Pos)       /*!< 0x80000000 */
#define FLASH_OPTR_TZEN                   FLASH_OPTR_TZEN_Msk

/****************  Bits definition for FLASH_NSBOOTADD0R register  ************/
#define FLASH_NSBOOTADD0R_NSBOOTADD0_Pos  (7U)
#define FLASH_NSBOOTADD0R_NSBOOTADD0_Msk  (0x1FFFFFFUL << FLASH_NSBOOTADD0R_NSBOOTADD0_Pos)/*!< 0xFFFFFF80 */
#define FLASH_NSBOOTADD0R_NSBOOTADD0      FLASH_NSBOOTADD0R_NSBOOTADD0_Msk

/****************  Bits definition for FLASH_NSBOOTADD1R register  ************/
#define FLASH_NSBOOTADD1R_NSBOOTADD1_Pos  (7U)
#define FLASH_NSBOOTADD1R_NSBOOTADD1_Msk  (0x1FFFFFFUL << FLASH_NSBOOTADD1R_NSBOOTADD1_Pos)/*!< 0xFFFFFF80 */
#define FLASH_NSBOOTADD1R_NSBOOTADD1      FLASH_NSBOOTADD1R_NSBOOTADD1_Msk

/****************  Bits definition for FLASH_SECBOOTADD0R register  ***********/
#define FLASH_SECBOOTADD0R_BOOT_LOCK_Pos   (0U)
#define FLASH_SECBOOTADD0R_BOOT_LOCK_Msk   (0x1UL << FLASH_SECBOOTADD0R_BOOT_LOCK_Pos)        /*!< 0x00000001 */
#define FLASH_SECBOOTADD0R_BOOT_LOCK       FLASH_SECBOOTADD0R_BOOT_LOCK_Msk
#define FLASH_SECBOOTADD0R_SECBOOTADD0_Pos (7U)
#define FLASH_SECBOOTADD0R_SECBOOTADD0_Msk (0x1FFFFFFUL << FLASH_SECBOOTADD0R_SECBOOTADD0_Pos)/*!< 0xFFFFFF80 */
#define FLASH_SECBOOTADD0R_SECBOOTADD0     FLASH_SECBOOTADD0R_SECBOOTADD0_Msk

/*****************  Bits definition for FLASH_SECWM1R1 register  **************/
#define FLASH_SECWM1R1_SECWM1_PSTRT_Pos   (0U)
#define FLASH_SECWM1R1_SECWM1_PSTRT_Msk   (0x7FUL << FLASH_SECWM1R1_SECWM1_PSTRT_Pos)/*!< 0x0000007F */
#define FLASH_SECWM1R1_SECWM1_PSTRT       FLASH_SECWM1R1_SECWM1_PSTRT_Msk
#define FLASH_SECWM1R1_SECWM1_PEND_Pos    (16U)
#define FLASH_SECWM1R1_SECWM1_PEND_Msk    (0x7FUL << FLASH_SECWM1R1_SECWM1_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_SECWM1R1_SECWM1_PEND        FLASH_SECWM1R1_SECWM1_PEND_Msk

/*****************  Bits definition for FLASH_SECWM1R2 register  **************/
#define FLASH_SECWM1R2_HDP1_PEND_Pos      (16U)
#define FLASH_SECWM1R2_HDP1_PEND_Msk      (0x7FUL << FLASH_SECWM1R2_HDP1_PEND_Pos)   /*!< 0x007F0000 */
#define FLASH_SECWM1R2_HDP1_PEND          FLASH_SECWM1R2_HDP1_PEND_Msk
#define FLASH_SECWM1R2_HDP1EN_Pos         (31U)
#define FLASH_SECWM1R2_HDP1EN_Msk         (0x1UL << FLASH_SECWM1R2_HDP1EN_Pos)       /*!< 0x80000000 */
#define FLASH_SECWM1R2_HDP1EN             FLASH_SECWM1R2_HDP1EN_Msk

/******************  Bits definition for FLASH_WRP1AR register  ***************/
#define FLASH_WRP1AR_WRP1A_PSTRT_Pos      (0U)
#define FLASH_WRP1AR_WRP1A_PSTRT_Msk      (0x7FUL << FLASH_WRP1AR_WRP1A_PSTRT_Pos)/*!< 0x0000007F */
#define FLASH_WRP1AR_WRP1A_PSTRT          FLASH_WRP1AR_WRP1A_PSTRT_Msk
#define FLASH_WRP1AR_WRP1A_PEND_Pos       (16U)
#define FLASH_WRP1AR_WRP1A_PEND_Msk       (0x7FUL << FLASH_WRP1AR_WRP1A_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_WRP1AR_WRP1A_PEND           FLASH_WRP1AR_WRP1A_PEND_Msk

/******************  Bits definition for FLASH_WRP1BR register  ***************/
#define FLASH_WRP1BR_WRP1B_PSTRT_Pos      (0U)
#define FLASH_WRP1BR_WRP1B_PSTRT_Msk      (0x7FUL << FLASH_WRP1BR_WRP1B_PSTRT_Pos)/*!< 0x0000007F */
#define FLASH_WRP1BR_WRP1B_PSTRT          FLASH_WRP1BR_WRP1B_PSTRT_Msk
#define FLASH_WRP1BR_WRP1B_PEND_Pos       (16U)
#define FLASH_WRP1BR_WRP1B_PEND_Msk       (0x7FUL << FLASH_WRP1BR_WRP1B_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_WRP1BR_WRP1B_PEND           FLASH_WRP1BR_WRP1B_PEND_Msk

/*****************  Bits definition for FLASH_SECWM2R1 register  **************/
#define FLASH_SECWM2R1_SECWM2_PSTRT_Pos   (0U)
#define FLASH_SECWM2R1_SECWM2_PSTRT_Msk   (0x7FUL << FLASH_SECWM2R1_SECWM2_PSTRT_Pos)/*!< 0x0000007F */
#define FLASH_SECWM2R1_SECWM2_PSTRT       FLASH_SECWM2R1_SECWM2_PSTRT_Msk
#define FLASH_SECWM2R1_SECWM2_PEND_Pos    (16U)
#define FLASH_SECWM2R1_SECWM2_PEND_Msk    (0x7FUL << FLASH_SECWM2R1_SECWM2_PEND_Pos)/*!< 0x007F0000 */
#define FLASH_SECWM2R1_SECWM2_PEND        FLASH_SECWM2R1_SECWM2_PEND_Msk

/*****************  Bits definition for FLASH_SECWM2R2 register  **************/
#define FLASH_SECWM2R2_HDP2_PEND_Pos      (16U)
#define FLASH_SECWM2R2_HDP2_PEND_Msk      (0x7FUL << FLASH_SECWM2R2_HDP2_PEND_Pos)   /*!< 0x007F0000 */
#define FLASH_SECWM2R2_HDP2_PEND          FLASH_SECWM2R2_HDP2_PEND_Msk
#define FLASH_SECWM2R2_HDP2EN_Pos         (31U)
#define FLASH_SECWM2R2_HDP2EN_Msk         (0x1UL << FLASH_SECWM2R2_HDP2EN_Pos)       /*!< 0x80000000 */
#define FLASH_SECWM2R2_HDP2EN             FLASH_SECWM2R2_HDP2EN_Msk

/******************  Bits definition for FLASH_WRP2AR register  ***************/
#define FLASH_WRP2AR_WRP2A_PSTRT_Pos      (0U)
#define FLASH_WRP2AR_WRP2A_PSTRT_Msk      (0x7FUL << FLASH_WRP2AR_WRP2A_PSTRT_Pos)/*!< 0x0000007F */
#define FLASH_WRP2AR_WRP2A_PSTRT          FLASH_WRP2AR_WRP2A_PSTRT_Msk
#define FLASH_WRP2AR_WRP2A_PEND_Pos       (16U)
#define FLASH_WRP2AR_WRP2A_PEND_Msk       (0x7FUL << FLASH_WRP2AR_WRP2A_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_WRP2AR_WRP2A_PEND           FLASH_WRP2AR_WRP2A_PEND_Msk

/******************  Bits definition for FLASH_WRPB2R register  ***************/
#define FLASH_WRP2BR_WRP2B_PSTRT_Pos      (0U)
#define FLASH_WRP2BR_WRP2B_PSTRT_Msk      (0x7FUL << FLASH_WRP2BR_WRP2B_PSTRT_Pos)/*!< 0x0000007F */
#define FLASH_WRP2BR_WRP2B_PSTRT          FLASH_WRP2BR_WRP2B_PSTRT_Msk
#define FLASH_WRP2BR_WRP2B_PEND_Pos       (16U)
#define FLASH_WRP2BR_WRP2B_PEND_Msk       (0x7FUL << FLASH_WRP2BR_WRP2B_PEND_Pos) /*!< 0x007F0000 */
#define FLASH_WRP2BR_WRP2B_PEND           FLASH_WRP2BR_WRP2B_PEND_Msk

/******************  Bits definition for FLASH_SECHDPCR register  ***********/
#define FLASH_SECHDPCR_HDP1_ACCDIS_Pos    (0U)
#define FLASH_SECHDPCR_HDP1_ACCDIS_Msk    (0x1UL << FLASH_SECHDPCR_HDP1_ACCDIS_Pos)/*!< 0x00000001 */
#define FLASH_SECHDPCR_HDP1_ACCDIS        FLASH_SECHDPCR_HDP1_ACCDIS_Msk
#define FLASH_SECHDPCR_HDP2_ACCDIS_Pos    (1U)
#define FLASH_SECHDPCR_HDP2_ACCDIS_Msk    (0x1UL << FLASH_SECHDPCR_HDP2_ACCDIS_Pos)/*!< 0x00000002 */
#define FLASH_SECHDPCR_HDP2_ACCDIS        FLASH_SECHDPCR_HDP2_ACCDIS_Msk

/******************  Bits definition for FLASH_PRIVCFGR register  ***********/
#define FLASH_PRIVCFGR_PRIV_Pos           (0U)
#define FLASH_PRIVCFGR_PRIV_Msk           (0x1UL << FLASH_PRIVCFGR_PRIV_Pos)/*!< 0x00000001 */
#define FLASH_PRIVCFGR_PRIV               FLASH_PRIVCFGR_PRIV_Msk

/******************************************************************************/
/*                                                                            */
/*                          Flexible Memory Controller                        */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for FMC_BCR1 register  *******************/
#define FMC_BCR1_CCLKEN_Pos        (20U)
#define FMC_BCR1_CCLKEN_Msk        (0x1UL << FMC_BCR1_CCLKEN_Pos)              /*!< 0x00100000 */
#define FMC_BCR1_CCLKEN            FMC_BCR1_CCLKEN_Msk                         /*!<Continuous clock enable    */
#define FMC_BCR1_WFDIS_Pos         (21U)
#define FMC_BCR1_WFDIS_Msk         (0x1UL << FMC_BCR1_WFDIS_Pos)               /*!< 0x00200000 */
#define FMC_BCR1_WFDIS             FMC_BCR1_WFDIS_Msk                          /*!<Write FIFO Disable         */

/******************  Bit definition for FMC_BCRx registers (x=1..4)  *********/
#define FMC_BCRx_MBKEN_Pos         (0U)
#define FMC_BCRx_MBKEN_Msk         (0x1UL << FMC_BCRx_MBKEN_Pos)               /*!< 0x00000001 */
#define FMC_BCRx_MBKEN             FMC_BCRx_MBKEN_Msk                          /*!<Memory bank enable bit                 */
#define FMC_BCRx_MUXEN_Pos         (1U)
#define FMC_BCRx_MUXEN_Msk         (0x1UL << FMC_BCRx_MUXEN_Pos)               /*!< 0x00000002 */
#define FMC_BCRx_MUXEN             FMC_BCRx_MUXEN_Msk                          /*!<Address/data multiplexing enable bit   */

#define FMC_BCRx_MTYP_Pos          (2U)
#define FMC_BCRx_MTYP_Msk          (0x3UL << FMC_BCRx_MTYP_Pos)                /*!< 0x0000000C */
#define FMC_BCRx_MTYP              FMC_BCRx_MTYP_Msk                           /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCRx_MTYP_0            (0x1UL << FMC_BCRx_MTYP_Pos)                /*!< 0x00000004 */
#define FMC_BCRx_MTYP_1            (0x2UL << FMC_BCRx_MTYP_Pos)                /*!< 0x00000008 */

#define FMC_BCRx_MWID_Pos          (4U)
#define FMC_BCRx_MWID_Msk          (0x3UL << FMC_BCRx_MWID_Pos)                /*!< 0x00000030 */
#define FMC_BCRx_MWID              FMC_BCRx_MWID_Msk                           /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCRx_MWID_0            (0x1UL << FMC_BCRx_MWID_Pos)                /*!< 0x00000010 */
#define FMC_BCRx_MWID_1            (0x2UL << FMC_BCRx_MWID_Pos)                /*!< 0x00000020 */

#define FMC_BCRx_FACCEN_Pos        (6U)
#define FMC_BCRx_FACCEN_Msk        (0x1UL << FMC_BCRx_FACCEN_Pos)              /*!< 0x00000040 */
#define FMC_BCRx_FACCEN            FMC_BCRx_FACCEN_Msk                         /*!<Flash access enable        */
#define FMC_BCRx_BURSTEN_Pos       (8U)
#define FMC_BCRx_BURSTEN_Msk       (0x1UL << FMC_BCRx_BURSTEN_Pos)             /*!< 0x00000100 */
#define FMC_BCRx_BURSTEN           FMC_BCRx_BURSTEN_Msk                        /*!<Burst enable bit           */
#define FMC_BCRx_WAITPOL_Pos       (9U)
#define FMC_BCRx_WAITPOL_Msk       (0x1UL << FMC_BCRx_WAITPOL_Pos)             /*!< 0x00000200 */
#define FMC_BCRx_WAITPOL           FMC_BCRx_WAITPOL_Msk                        /*!<Wait signal polarity bit   */
#define FMC_BCRx_WAITCFG_Pos       (11U)
#define FMC_BCRx_WAITCFG_Msk       (0x1UL << FMC_BCRx_WAITCFG_Pos)             /*!< 0x00000800 */
#define FMC_BCRx_WAITCFG           FMC_BCRx_WAITCFG_Msk                        /*!<Wait timing configuration  */
#define FMC_BCRx_WREN_Pos          (12U)
#define FMC_BCRx_WREN_Msk          (0x1UL << FMC_BCRx_WREN_Pos)                /*!< 0x00001000 */
#define FMC_BCRx_WREN              FMC_BCRx_WREN_Msk                           /*!<Write enable bit           */
#define FMC_BCRx_WAITEN_Pos        (13U)
#define FMC_BCRx_WAITEN_Msk        (0x1UL << FMC_BCRx_WAITEN_Pos)              /*!< 0x00002000 */
#define FMC_BCRx_WAITEN            FMC_BCRx_WAITEN_Msk                         /*!<Wait enable bit            */
#define FMC_BCRx_EXTMOD_Pos        (14U)
#define FMC_BCRx_EXTMOD_Msk        (0x1UL << FMC_BCRx_EXTMOD_Pos)              /*!< 0x00004000 */
#define FMC_BCRx_EXTMOD            FMC_BCRx_EXTMOD_Msk                         /*!<Extended mode enable       */
#define FMC_BCRx_ASYNCWAIT_Pos     (15U)
#define FMC_BCRx_ASYNCWAIT_Msk     (0x1UL << FMC_BCRx_ASYNCWAIT_Pos)           /*!< 0x00008000 */
#define FMC_BCRx_ASYNCWAIT         FMC_BCRx_ASYNCWAIT_Msk                      /*!<Asynchronous wait          */

#define FMC_BCRx_CPSIZE_Pos        (16U)
#define FMC_BCRx_CPSIZE_Msk        (0x7UL << FMC_BCRx_CPSIZE_Pos)              /*!< 0x00070000 */
#define FMC_BCRx_CPSIZE            FMC_BCRx_CPSIZE_Msk                         /*!<CRAM page size             */
#define FMC_BCRx_CPSIZE_0          (0x1UL << FMC_BCRx_CPSIZE_Pos)              /*!< 0x00010000 */
#define FMC_BCRx_CPSIZE_1          (0x2UL << FMC_BCRx_CPSIZE_Pos)              /*!< 0x00020000 */
#define FMC_BCRx_CPSIZE_2          (0x4UL << FMC_BCRx_CPSIZE_Pos)              /*!< 0x00040000 */

#define FMC_BCRx_CBURSTRW_Pos      (19U)
#define FMC_BCRx_CBURSTRW_Msk      (0x1UL << FMC_BCRx_CBURSTRW_Pos)            /*!< 0x00080000 */
#define FMC_BCRx_CBURSTRW          FMC_BCRx_CBURSTRW_Msk                       /*!<Write burst enable         */

#define FMC_BCRx_NBLSET_Pos        (22U)
#define FMC_BCRx_NBLSET_Msk        (0x3UL << FMC_BCRx_NBLSET_Pos)              /*!< 0x00C00000 */
#define FMC_BCRx_NBLSET            FMC_BCRx_NBLSET_Msk                         /*!<Byte lane (NBL) setup      */
#define FMC_BCRx_NBLSET_0          (0x1UL << FMC_BCRx_NBLSET_Pos)              /*!< 0x00400000 */
#define FMC_BCRx_NBLSET_1          (0x2UL << FMC_BCRx_NBLSET_Pos)              /*!< 0x00800000 */

/******************  Bit definition for FMC_BTRx registers (x=1..4)  *********/
#define FMC_BTRx_ADDSET_Pos        (0U)
#define FMC_BTRx_ADDSET_Msk        (0xFUL << FMC_BTRx_ADDSET_Pos)              /*!< 0x0000000F */
#define FMC_BTRx_ADDSET            FMC_BTRx_ADDSET_Msk                         /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTRx_ADDSET_0          (0x1UL << FMC_BTRx_ADDSET_Pos)              /*!< 0x00000001 */
#define FMC_BTRx_ADDSET_1          (0x2UL << FMC_BTRx_ADDSET_Pos)              /*!< 0x00000002 */
#define FMC_BTRx_ADDSET_2          (0x4UL << FMC_BTRx_ADDSET_Pos)              /*!< 0x00000004 */
#define FMC_BTRx_ADDSET_3          (0x8UL << FMC_BTRx_ADDSET_Pos)              /*!< 0x00000008 */

#define FMC_BTRx_ADDHLD_Pos        (4U)
#define FMC_BTRx_ADDHLD_Msk        (0xFUL << FMC_BTRx_ADDHLD_Pos)              /*!< 0x000000F0 */
#define FMC_BTRx_ADDHLD            FMC_BTRx_ADDHLD_Msk                         /*!<ADDHLD[3:0] bits (Address-hold phase duration)  */
#define FMC_BTRx_ADDHLD_0          (0x1UL << FMC_BTRx_ADDHLD_Pos)              /*!< 0x00000010 */
#define FMC_BTRx_ADDHLD_1          (0x2UL << FMC_BTRx_ADDHLD_Pos)              /*!< 0x00000020 */
#define FMC_BTRx_ADDHLD_2          (0x4UL << FMC_BTRx_ADDHLD_Pos)              /*!< 0x00000040 */
#define FMC_BTRx_ADDHLD_3          (0x8UL << FMC_BTRx_ADDHLD_Pos)              /*!< 0x00000080 */

#define FMC_BTRx_DATAST_Pos        (8U)
#define FMC_BTRx_DATAST_Msk        (0xFFUL << FMC_BTRx_DATAST_Pos)             /*!< 0x0000FF00 */
#define FMC_BTRx_DATAST            FMC_BTRx_DATAST_Msk                         /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTRx_DATAST_0          (0x01UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00000100 */
#define FMC_BTRx_DATAST_1          (0x02UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00000200 */
#define FMC_BTRx_DATAST_2          (0x04UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00000400 */
#define FMC_BTRx_DATAST_3          (0x08UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00000800 */
#define FMC_BTRx_DATAST_4          (0x10UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00001000 */
#define FMC_BTRx_DATAST_5          (0x20UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00002000 */
#define FMC_BTRx_DATAST_6          (0x40UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00004000 */
#define FMC_BTRx_DATAST_7          (0x80UL << FMC_BTRx_DATAST_Pos)             /*!< 0x00008000 */

#define FMC_BTRx_BUSTURN_Pos       (16U)
#define FMC_BTRx_BUSTURN_Msk       (0xFUL << FMC_BTRx_BUSTURN_Pos)             /*!< 0x000F0000 */
#define FMC_BTRx_BUSTURN           FMC_BTRx_BUSTURN_Msk                        /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTRx_BUSTURN_0         (0x1UL << FMC_BTRx_BUSTURN_Pos)             /*!< 0x00010000 */
#define FMC_BTRx_BUSTURN_1         (0x2UL << FMC_BTRx_BUSTURN_Pos)             /*!< 0x00020000 */
#define FMC_BTRx_BUSTURN_2         (0x4UL << FMC_BTRx_BUSTURN_Pos)             /*!< 0x00040000 */
#define FMC_BTRx_BUSTURN_3         (0x8UL << FMC_BTRx_BUSTURN_Pos)             /*!< 0x00080000 */

#define FMC_BTRx_CLKDIV_Pos        (20U)
#define FMC_BTRx_CLKDIV_Msk        (0xFUL << FMC_BTRx_CLKDIV_Pos)              /*!< 0x00F00000 */
#define FMC_BTRx_CLKDIV            FMC_BTRx_CLKDIV_Msk                         /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTRx_CLKDIV_0          (0x1UL << FMC_BTRx_CLKDIV_Pos)              /*!< 0x00100000 */
#define FMC_BTRx_CLKDIV_1          (0x2UL << FMC_BTRx_CLKDIV_Pos)              /*!< 0x00200000 */
#define FMC_BTRx_CLKDIV_2          (0x4UL << FMC_BTRx_CLKDIV_Pos)              /*!< 0x00400000 */
#define FMC_BTRx_CLKDIV_3          (0x8UL << FMC_BTRx_CLKDIV_Pos)              /*!< 0x00800000 */

#define FMC_BTRx_DATLAT_Pos        (24U)
#define FMC_BTRx_DATLAT_Msk        (0xFUL << FMC_BTRx_DATLAT_Pos)              /*!< 0x0F000000 */
#define FMC_BTRx_DATLAT            FMC_BTRx_DATLAT_Msk                         /*!<DATLAT[3:0] bits (Data latency) */
#define FMC_BTRx_DATLAT_0          (0x1UL << FMC_BTRx_DATLAT_Pos)              /*!< 0x01000000 */
#define FMC_BTRx_DATLAT_1          (0x2UL << FMC_BTRx_DATLAT_Pos)              /*!< 0x02000000 */
#define FMC_BTRx_DATLAT_2          (0x4UL << FMC_BTRx_DATLAT_Pos)              /*!< 0x04000000 */
#define FMC_BTRx_DATLAT_3          (0x8UL << FMC_BTRx_DATLAT_Pos)              /*!< 0x08000000 */

#define FMC_BTRx_ACCMOD_Pos        (28U)
#define FMC_BTRx_ACCMOD_Msk        (0x3UL << FMC_BTRx_ACCMOD_Pos)              /*!< 0x30000000 */
#define FMC_BTRx_ACCMOD            FMC_BTRx_ACCMOD_Msk                         /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTRx_ACCMOD_0          (0x1UL << FMC_BTRx_ACCMOD_Pos)              /*!< 0x10000000 */
#define FMC_BTRx_ACCMOD_1          (0x2UL << FMC_BTRx_ACCMOD_Pos)              /*!< 0x20000000 */

#define FMC_BTRx_DATAHLD_Pos       (30U)
#define FMC_BTRx_DATAHLD_Msk       (0x3UL << FMC_BTRx_DATAHLD_Pos)             /*!< 0xC0000000 */
#define FMC_BTRx_DATAHLD           FMC_BTRx_DATAHLD_Msk                        /*!<DATAHLD[1:0] bits (Data hold phase duration) */
#define FMC_BTRx_DATAHLD_0         (0x1UL << FMC_BTRx_DATAHLD_Pos)             /*!< 0x40000000 */
#define FMC_BTRx_DATAHLD_1         (0x2UL << FMC_BTRx_DATAHLD_Pos)             /*!< 0x80000000 */

/******************  Bit definition for FMC_BWTRx registers (x=1..4)  *********/
#define FMC_BWTRx_ADDSET_Pos       (0U)
#define FMC_BWTRx_ADDSET_Msk       (0xFUL << FMC_BWTRx_ADDSET_Pos)             /*!< 0x0000000F */
#define FMC_BWTRx_ADDSET           FMC_BWTRx_ADDSET_Msk                        /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTRx_ADDSET_0         (0x1UL << FMC_BWTRx_ADDSET_Pos)             /*!< 0x00000001 */
#define FMC_BWTRx_ADDSET_1         (0x2UL << FMC_BWTRx_ADDSET_Pos)             /*!< 0x00000002 */
#define FMC_BWTRx_ADDSET_2         (0x4UL << FMC_BWTRx_ADDSET_Pos)             /*!< 0x00000004 */
#define FMC_BWTRx_ADDSET_3         (0x8UL << FMC_BWTRx_ADDSET_Pos)             /*!< 0x00000008 */

#define FMC_BWTRx_ADDHLD_Pos       (4U)
#define FMC_BWTRx_ADDHLD_Msk       (0xFUL << FMC_BWTRx_ADDHLD_Pos)             /*!< 0x000000F0 */
#define FMC_BWTRx_ADDHLD           FMC_BWTRx_ADDHLD_Msk                        /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTRx_ADDHLD_0         (0x1UL << FMC_BWTRx_ADDHLD_Pos)             /*!< 0x00000010 */
#define FMC_BWTRx_ADDHLD_1         (0x2UL << FMC_BWTRx_ADDHLD_Pos)             /*!< 0x00000020 */
#define FMC_BWTRx_ADDHLD_2         (0x4UL << FMC_BWTRx_ADDHLD_Pos)             /*!< 0x00000040 */
#define FMC_BWTRx_ADDHLD_3         (0x8UL << FMC_BWTRx_ADDHLD_Pos)             /*!< 0x00000080 */

#define FMC_BWTRx_DATAST_Pos       (8U)
#define FMC_BWTRx_DATAST_Msk       (0xFFUL << FMC_BWTRx_DATAST_Pos)            /*!< 0x0000FF00 */
#define FMC_BWTRx_DATAST           FMC_BWTRx_DATAST_Msk                        /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTRx_DATAST_0         (0x01UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00000100 */
#define FMC_BWTRx_DATAST_1         (0x02UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00000200 */
#define FMC_BWTRx_DATAST_2         (0x04UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00000400 */
#define FMC_BWTRx_DATAST_3         (0x08UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00000800 */
#define FMC_BWTRx_DATAST_4         (0x10UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00001000 */
#define FMC_BWTRx_DATAST_5         (0x20UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00002000 */
#define FMC_BWTRx_DATAST_6         (0x40UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00004000 */
#define FMC_BWTRx_DATAST_7         (0x80UL << FMC_BWTRx_DATAST_Pos)            /*!< 0x00008000 */

#define FMC_BWTRx_BUSTURN_Pos      (16U)
#define FMC_BWTRx_BUSTURN_Msk      (0xFUL << FMC_BWTRx_BUSTURN_Pos)            /*!< 0x000F0000 */
#define FMC_BWTRx_BUSTURN          FMC_BWTRx_BUSTURN_Msk                       /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BWTRx_BUSTURN_0        (0x1UL << FMC_BWTRx_BUSTURN_Pos)            /*!< 0x00010000 */
#define FMC_BWTRx_BUSTURN_1        (0x2UL << FMC_BWTRx_BUSTURN_Pos)            /*!< 0x00020000 */
#define FMC_BWTRx_BUSTURN_2        (0x4UL << FMC_BWTRx_BUSTURN_Pos)            /*!< 0x00040000 */
#define FMC_BWTRx_BUSTURN_3        (0x8UL << FMC_BWTRx_BUSTURN_Pos)            /*!< 0x00080000 */

#define FMC_BWTRx_ACCMOD_Pos       (28U)
#define FMC_BWTRx_ACCMOD_Msk       (0x3UL << FMC_BWTRx_ACCMOD_Pos)             /*!< 0x30000000 */
#define FMC_BWTRx_ACCMOD           FMC_BWTRx_ACCMOD_Msk                        /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTRx_ACCMOD_0         (0x1UL << FMC_BWTRx_ACCMOD_Pos)             /*!< 0x10000000 */
#define FMC_BWTRx_ACCMOD_1         (0x2UL << FMC_BWTRx_ACCMOD_Pos)             /*!< 0x20000000 */

#define FMC_BWTRx_DATAHLD_Pos      (30U)
#define FMC_BWTRx_DATAHLD_Msk      (0x3UL << FMC_BWTRx_DATAHLD_Pos)            /*!< 0xC0000000 */
#define FMC_BWTRx_DATAHLD          FMC_BWTRx_DATAHLD_Msk                       /*!<DATAHLD[1:0] bits (Data hold phase duration) */
#define FMC_BWTRx_DATAHLD_0        (0x1UL << FMC_BWTRx_DATAHLD_Pos)            /*!< 0x40000000 */
#define FMC_BWTRx_DATAHLD_1        (0x2UL << FMC_BWTRx_DATAHLD_Pos)            /*!< 0x80000000 */

/******************  Bit definition for FMC_PCSCNTR register ******************/
#define FMC_PCSCNTR_CSCOUNT_Pos    (0U)
#define FMC_PCSCNTR_CSCOUNT_Msk    (0xFFFFUL << FMC_PCSCNTR_CSCOUNT_Pos)       /*!< 0x0000FFFF */
#define FMC_PCSCNTR_CSCOUNT        FMC_PCSCNTR_CSCOUNT_Msk                     /*!<CSCOUNT[15:0] bits (Chip select counter) */

#define FMC_PCSCNTR_CNTB1EN_Pos    (16U)
#define FMC_PCSCNTR_CNTB1EN_Msk    (0x1UL << FMC_PCSCNTR_CNTB1EN_Pos)          /*!< 0x00010000 */
#define FMC_PCSCNTR_CNTB1EN        FMC_PCSCNTR_CNTB1EN_Msk                     /*!<Counter PSRAM/NOR Bank1_1 enable */

#define FMC_PCSCNTR_CNTB2EN_Pos    (17U)
#define FMC_PCSCNTR_CNTB2EN_Msk    (0x1UL << FMC_PCSCNTR_CNTB2EN_Pos)          /*!< 0x00020000 */
#define FMC_PCSCNTR_CNTB2EN        FMC_PCSCNTR_CNTB2EN_Msk                     /*!<Counter PSRAM/NOR Bank1_2 enable */

#define FMC_PCSCNTR_CNTB3EN_Pos    (18U)
#define FMC_PCSCNTR_CNTB3EN_Msk    (0x1UL << FMC_PCSCNTR_CNTB3EN_Pos)          /*!< 0x00040000 */
#define FMC_PCSCNTR_CNTB3EN        FMC_PCSCNTR_CNTB3EN_Msk                     /*!<Counter PSRAM/NOR Bank1_3 enable */

#define FMC_PCSCNTR_CNTB4EN_Pos    (19U)
#define FMC_PCSCNTR_CNTB4EN_Msk    (0x1UL << FMC_PCSCNTR_CNTB4EN_Pos)          /*!< 0x00080000 */
#define FMC_PCSCNTR_CNTB4EN        FMC_PCSCNTR_CNTB4EN_Msk                     /*!<Counter PSRAM/NOR Bank1_4 enable */

/******************  Bit definition for FMC_PCR register  ********************/
#define FMC_PCR_PWAITEN_Pos        (1U)
#define FMC_PCR_PWAITEN_Msk        (0x1UL << FMC_PCR_PWAITEN_Pos)              /*!< 0x00000002 */
#define FMC_PCR_PWAITEN            FMC_PCR_PWAITEN_Msk                         /*!<Wait feature enable bit                   */
#define FMC_PCR_PBKEN_Pos          (2U)
#define FMC_PCR_PBKEN_Msk          (0x1UL << FMC_PCR_PBKEN_Pos)                /*!< 0x00000004 */
#define FMC_PCR_PBKEN              FMC_PCR_PBKEN_Msk                           /*!<NAND Flash memory bank enable bit */
#define FMC_PCR_PTYP_Pos           (3U)
#define FMC_PCR_PTYP_Msk           (0x1UL << FMC_PCR_PTYP_Pos)                 /*!< 0x00000008 */
#define FMC_PCR_PTYP               FMC_PCR_PTYP_Msk                            /*!<Memory type                               */

#define FMC_PCR_PWID_Pos           (4U)
#define FMC_PCR_PWID_Msk           (0x3UL << FMC_PCR_PWID_Pos)                 /*!< 0x00000030 */
#define FMC_PCR_PWID               FMC_PCR_PWID_Msk                            /*!<PWID[1:0] bits (NAND Flash databus width) */
#define FMC_PCR_PWID_0             (0x1UL << FMC_PCR_PWID_Pos)                 /*!< 0x00000010 */
#define FMC_PCR_PWID_1             (0x2UL << FMC_PCR_PWID_Pos)                 /*!< 0x00000020 */

#define FMC_PCR_ECCEN_Pos          (6U)
#define FMC_PCR_ECCEN_Msk          (0x1UL << FMC_PCR_ECCEN_Pos)                /*!< 0x00000040 */
#define FMC_PCR_ECCEN              FMC_PCR_ECCEN_Msk                           /*!<ECC computation logic enable bit          */

#define FMC_PCR_TCLR_Pos           (9U)
#define FMC_PCR_TCLR_Msk           (0xFUL << FMC_PCR_TCLR_Pos)                 /*!< 0x00001E00 */
#define FMC_PCR_TCLR               FMC_PCR_TCLR_Msk                            /*!<TCLR[3:0] bits (CLE to RE delay)          */
#define FMC_PCR_TCLR_0             (0x1UL << FMC_PCR_TCLR_Pos)                 /*!< 0x00000200 */
#define FMC_PCR_TCLR_1             (0x2UL << FMC_PCR_TCLR_Pos)                 /*!< 0x00000400 */
#define FMC_PCR_TCLR_2             (0x4UL << FMC_PCR_TCLR_Pos)                 /*!< 0x00000800 */
#define FMC_PCR_TCLR_3             (0x8UL << FMC_PCR_TCLR_Pos)                 /*!< 0x00001000 */

#define FMC_PCR_TAR_Pos            (13U)
#define FMC_PCR_TAR_Msk            (0xFUL << FMC_PCR_TAR_Pos)                  /*!< 0x0001E000 */
#define FMC_PCR_TAR                FMC_PCR_TAR_Msk                             /*!<TAR[3:0] bits (ALE to RE delay)           */
#define FMC_PCR_TAR_0              (0x1UL << FMC_PCR_TAR_Pos)                  /*!< 0x00002000 */
#define FMC_PCR_TAR_1              (0x2UL << FMC_PCR_TAR_Pos)                  /*!< 0x00004000 */
#define FMC_PCR_TAR_2              (0x4UL << FMC_PCR_TAR_Pos)                  /*!< 0x00008000 */
#define FMC_PCR_TAR_3              (0x8UL << FMC_PCR_TAR_Pos)                  /*!< 0x00010000 */

#define FMC_PCR_ECCPS_Pos          (17U)
#define FMC_PCR_ECCPS_Msk          (0x7UL << FMC_PCR_ECCPS_Pos)                /*!< 0x000E0000 */
#define FMC_PCR_ECCPS              FMC_PCR_ECCPS_Msk                           /*!<ECCPS[1:0] bits (ECC page size)           */
#define FMC_PCR_ECCPS_0            (0x1UL << FMC_PCR_ECCPS_Pos)                /*!< 0x00020000 */
#define FMC_PCR_ECCPS_1            (0x2UL << FMC_PCR_ECCPS_Pos)                /*!< 0x00040000 */
#define FMC_PCR_ECCPS_2            (0x4UL << FMC_PCR_ECCPS_Pos)                /*!< 0x00080000 */

/*******************  Bit definition for FMC_SR register  ********************/
#define FMC_SR_IRS_Pos             (0U)
#define FMC_SR_IRS_Msk             (0x1UL << FMC_SR_IRS_Pos)                   /*!< 0x00000001 */
#define FMC_SR_IRS                 FMC_SR_IRS_Msk                              /*!<Interrupt Rising Edge status                */
#define FMC_SR_ILS_Pos             (1U)
#define FMC_SR_ILS_Msk             (0x1UL << FMC_SR_ILS_Pos)                   /*!< 0x00000002 */
#define FMC_SR_ILS                 FMC_SR_ILS_Msk                              /*!<Interrupt Level status                      */
#define FMC_SR_IFS_Pos             (2U)
#define FMC_SR_IFS_Msk             (0x1UL << FMC_SR_IFS_Pos)                   /*!< 0x00000004 */
#define FMC_SR_IFS                 FMC_SR_IFS_Msk                              /*!<Interrupt Falling Edge status               */
#define FMC_SR_IREN_Pos            (3U)
#define FMC_SR_IREN_Msk            (0x1UL << FMC_SR_IREN_Pos)                  /*!< 0x00000008 */
#define FMC_SR_IREN                FMC_SR_IREN_Msk                             /*!<Interrupt Rising Edge detection Enable bit  */
#define FMC_SR_ILEN_Pos            (4U)
#define FMC_SR_ILEN_Msk            (0x1UL << FMC_SR_ILEN_Pos)                  /*!< 0x00000010 */
#define FMC_SR_ILEN                FMC_SR_ILEN_Msk                             /*!<Interrupt Level detection Enable bit        */
#define FMC_SR_IFEN_Pos            (5U)
#define FMC_SR_IFEN_Msk            (0x1UL << FMC_SR_IFEN_Pos)                  /*!< 0x00000020 */
#define FMC_SR_IFEN                FMC_SR_IFEN_Msk                             /*!<Interrupt Falling Edge detection Enable bit */
#define FMC_SR_FEMPT_Pos           (6U)
#define FMC_SR_FEMPT_Msk           (0x1UL << FMC_SR_FEMPT_Pos)                 /*!< 0x00000040 */
#define FMC_SR_FEMPT               FMC_SR_FEMPT_Msk                            /*!<FIFO empty                                  */

/******************  Bit definition for FMC_PMEM register  ******************/
#define FMC_PMEM_MEMSET_Pos        (0U)
#define FMC_PMEM_MEMSET_Msk        (0xFFUL << FMC_PMEM_MEMSET_Pos)             /*!< 0x000000FF */
#define FMC_PMEM_MEMSET            FMC_PMEM_MEMSET_Msk                         /*!<MEMSET[7:0] bits (Common memory setup time) */
#define FMC_PMEM_MEMSET_0          (0x01UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000001 */
#define FMC_PMEM_MEMSET_1          (0x02UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000002 */
#define FMC_PMEM_MEMSET_2          (0x04UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000004 */
#define FMC_PMEM_MEMSET_3          (0x08UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000008 */
#define FMC_PMEM_MEMSET_4          (0x10UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000010 */
#define FMC_PMEM_MEMSET_5          (0x20UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000020 */
#define FMC_PMEM_MEMSET_6          (0x40UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000040 */
#define FMC_PMEM_MEMSET_7          (0x80UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000080 */

#define FMC_PMEM_MEMWAIT_Pos       (8U)
#define FMC_PMEM_MEMWAIT_Msk       (0xFFUL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x0000FF00 */
#define FMC_PMEM_MEMWAIT           FMC_PMEM_MEMWAIT_Msk                        /*!<MEMWAIT[7:0] bits (Common memory wait time) */
#define FMC_PMEM_MEMWAIT_0         (0x01UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000100 */
#define FMC_PMEM_MEMWAIT_1         (0x02UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000200 */
#define FMC_PMEM_MEMWAIT_2         (0x04UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000400 */
#define FMC_PMEM_MEMWAIT_3         (0x08UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000800 */
#define FMC_PMEM_MEMWAIT_4         (0x10UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00001000 */
#define FMC_PMEM_MEMWAIT_5         (0x20UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00002000 */
#define FMC_PMEM_MEMWAIT_6         (0x40UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00004000 */
#define FMC_PMEM_MEMWAIT_7         (0x80UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00008000 */

#define FMC_PMEM_MEMHOLD_Pos       (16U)
#define FMC_PMEM_MEMHOLD_Msk       (0xFFUL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00FF0000 */
#define FMC_PMEM_MEMHOLD           FMC_PMEM_MEMHOLD_Msk                        /*!<MEMHOLD[7:0] bits (Common memory hold time) */
#define FMC_PMEM_MEMHOLD_0         (0x01UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00010000 */
#define FMC_PMEM_MEMHOLD_1         (0x02UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00020000 */
#define FMC_PMEM_MEMHOLD_2         (0x04UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00040000 */
#define FMC_PMEM_MEMHOLD_3         (0x08UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00080000 */
#define FMC_PMEM_MEMHOLD_4         (0x10UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00100000 */
#define FMC_PMEM_MEMHOLD_5         (0x20UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00200000 */
#define FMC_PMEM_MEMHOLD_6         (0x40UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00400000 */
#define FMC_PMEM_MEMHOLD_7         (0x80UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00800000 */

#define FMC_PMEM_MEMHIZ_Pos        (24U)
#define FMC_PMEM_MEMHIZ_Msk        (0xFFUL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0xFF000000 */
#define FMC_PMEM_MEMHIZ            FMC_PMEM_MEMHIZ_Msk                         /*!<MEMHIZ[7:0] bits (Common memory databus HiZ time) */
#define FMC_PMEM_MEMHIZ_0          (0x01UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x01000000 */
#define FMC_PMEM_MEMHIZ_1          (0x02UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x02000000 */
#define FMC_PMEM_MEMHIZ_2          (0x04UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x04000000 */
#define FMC_PMEM_MEMHIZ_3          (0x08UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x08000000 */
#define FMC_PMEM_MEMHIZ_4          (0x10UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x10000000 */
#define FMC_PMEM_MEMHIZ_5          (0x20UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x20000000 */
#define FMC_PMEM_MEMHIZ_6          (0x40UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x40000000 */
#define FMC_PMEM_MEMHIZ_7          (0x80UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x80000000 */

/******************  Bit definition for FMC_PATT register  *******************/
#define FMC_PATT_ATTSET_Pos        (0U)
#define FMC_PATT_ATTSET_Msk        (0xFFUL << FMC_PATT_ATTSET_Pos)             /*!< 0x000000FF */
#define FMC_PATT_ATTSET            FMC_PATT_ATTSET_Msk                         /*!<ATTSET[7:0] bits (Attribute memory setup time) */
#define FMC_PATT_ATTSET_0          (0x01UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000001 */
#define FMC_PATT_ATTSET_1          (0x02UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000002 */
#define FMC_PATT_ATTSET_2          (0x04UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000004 */
#define FMC_PATT_ATTSET_3          (0x08UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000008 */
#define FMC_PATT_ATTSET_4          (0x10UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000010 */
#define FMC_PATT_ATTSET_5          (0x20UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000020 */
#define FMC_PATT_ATTSET_6          (0x40UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000040 */
#define FMC_PATT_ATTSET_7          (0x80UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000080 */

#define FMC_PATT_ATTWAIT_Pos       (8U)
#define FMC_PATT_ATTWAIT_Msk       (0xFFUL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x0000FF00 */
#define FMC_PATT_ATTWAIT           FMC_PATT_ATTWAIT_Msk                        /*!<ATTWAIT[7:0] bits (Attribute memory wait time) */
#define FMC_PATT_ATTWAIT_0         (0x01UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000100 */
#define FMC_PATT_ATTWAIT_1         (0x02UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000200 */
#define FMC_PATT_ATTWAIT_2         (0x04UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000400 */
#define FMC_PATT_ATTWAIT_3         (0x08UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000800 */
#define FMC_PATT_ATTWAIT_4         (0x10UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00001000 */
#define FMC_PATT_ATTWAIT_5         (0x20UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00002000 */
#define FMC_PATT_ATTWAIT_6         (0x40UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00004000 */
#define FMC_PATT_ATTWAIT_7         (0x80UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00008000 */

#define FMC_PATT_ATTHOLD_Pos       (16U)
#define FMC_PATT_ATTHOLD_Msk       (0xFFUL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00FF0000 */
#define FMC_PATT_ATTHOLD           FMC_PATT_ATTHOLD_Msk                        /*!<ATTHOLD[7:0] bits (Attribute memory hold time) */
#define FMC_PATT_ATTHOLD_0         (0x01UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00010000 */
#define FMC_PATT_ATTHOLD_1         (0x02UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00020000 */
#define FMC_PATT_ATTHOLD_2         (0x04UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00040000 */
#define FMC_PATT_ATTHOLD_3         (0x08UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00080000 */
#define FMC_PATT_ATTHOLD_4         (0x10UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00100000 */
#define FMC_PATT_ATTHOLD_5         (0x20UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00200000 */
#define FMC_PATT_ATTHOLD_6         (0x40UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00400000 */
#define FMC_PATT_ATTHOLD_7         (0x80UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00800000 */

#define FMC_PATT_ATTHIZ_Pos        (24U)
#define FMC_PATT_ATTHIZ_Msk        (0xFFUL << FMC_PATT_ATTHIZ_Pos)             /*!< 0xFF000000 */
#define FMC_PATT_ATTHIZ            FMC_PATT_ATTHIZ_Msk                         /*!<ATTHIZ[7:0] bits (Attribute memory databus HiZ time) */
#define FMC_PATT_ATTHIZ_0          (0x01UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x01000000 */
#define FMC_PATT_ATTHIZ_1          (0x02UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x02000000 */
#define FMC_PATT_ATTHIZ_2          (0x04UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x04000000 */
#define FMC_PATT_ATTHIZ_3          (0x08UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x08000000 */
#define FMC_PATT_ATTHIZ_4          (0x10UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x10000000 */
#define FMC_PATT_ATTHIZ_5          (0x20UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x20000000 */
#define FMC_PATT_ATTHIZ_6          (0x40UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x40000000 */
#define FMC_PATT_ATTHIZ_7          (0x80UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x80000000 */

/******************  Bit definition for FMC_ECCR register  *******************/
#define FMC_ECCR_ECC_Pos           (0U)
#define FMC_ECCR_ECC_Msk           (0xFFFFFFFFUL << FMC_ECCR_ECC_Pos)          /*!< 0xFFFFFFFF */
#define FMC_ECCR_ECC               FMC_ECCR_ECC_Msk                            /*!<ECC result */

/******************************************************************************/
/*                                                                            */
/*                       General Purpose IOs (GPIO)                           */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODE0_Pos           (0U)
#define GPIO_MODER_MODE0_Msk           (0x3UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000003 */
#define GPIO_MODER_MODE0               GPIO_MODER_MODE0_Msk
#define GPIO_MODER_MODE0_0             (0x1UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000001 */
#define GPIO_MODER_MODE0_1             (0x2UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000002 */
#define GPIO_MODER_MODE1_Pos           (2U)
#define GPIO_MODER_MODE1_Msk           (0x3UL << GPIO_MODER_MODE1_Pos)         /*!< 0x0000000C */
#define GPIO_MODER_MODE1               GPIO_MODER_MODE1_Msk
#define GPIO_MODER_MODE1_0             (0x1UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000004 */
#define GPIO_MODER_MODE1_1             (0x2UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000008 */
#define GPIO_MODER_MODE2_Pos           (4U)
#define GPIO_MODER_MODE2_Msk           (0x3UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000030 */
#define GPIO_MODER_MODE2               GPIO_MODER_MODE2_Msk
#define GPIO_MODER_MODE2_0             (0x1UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000010 */
#define GPIO_MODER_MODE2_1             (0x2UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000020 */
#define GPIO_MODER_MODE3_Pos           (6U)
#define GPIO_MODER_MODE3_Msk           (0x3UL << GPIO_MODER_MODE3_Pos)         /*!< 0x000000C0 */
#define GPIO_MODER_MODE3               GPIO_MODER_MODE3_Msk
#define GPIO_MODER_MODE3_0             (0x1UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000040 */
#define GPIO_MODER_MODE3_1             (0x2UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000080 */
#define GPIO_MODER_MODE4_Pos           (8U)
#define GPIO_MODER_MODE4_Msk           (0x3UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000300 */
#define GPIO_MODER_MODE4               GPIO_MODER_MODE4_Msk
#define GPIO_MODER_MODE4_0             (0x1UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000100 */
#define GPIO_MODER_MODE4_1             (0x2UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000200 */
#define GPIO_MODER_MODE5_Pos           (10U)
#define GPIO_MODER_MODE5_Msk           (0x3UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000C00 */
#define GPIO_MODER_MODE5               GPIO_MODER_MODE5_Msk
#define GPIO_MODER_MODE5_0             (0x1UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000400 */
#define GPIO_MODER_MODE5_1             (0x2UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000800 */
#define GPIO_MODER_MODE6_Pos           (12U)
#define GPIO_MODER_MODE6_Msk           (0x3UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00003000 */
#define GPIO_MODER_MODE6               GPIO_MODER_MODE6_Msk
#define GPIO_MODER_MODE6_0             (0x1UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00001000 */
#define GPIO_MODER_MODE6_1             (0x2UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00002000 */
#define GPIO_MODER_MODE7_Pos           (14U)
#define GPIO_MODER_MODE7_Msk           (0x3UL << GPIO_MODER_MODE7_Pos)         /*!< 0x0000C000 */
#define GPIO_MODER_MODE7               GPIO_MODER_MODE7_Msk
#define GPIO_MODER_MODE7_0             (0x1UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00004000 */
#define GPIO_MODER_MODE7_1             (0x2UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00008000 */
#define GPIO_MODER_MODE8_Pos           (16U)
#define GPIO_MODER_MODE8_Msk           (0x3UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00030000 */
#define GPIO_MODER_MODE8               GPIO_MODER_MODE8_Msk
#define GPIO_MODER_MODE8_0             (0x1UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00010000 */
#define GPIO_MODER_MODE8_1             (0x2UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00020000 */
#define GPIO_MODER_MODE9_Pos           (18U)
#define GPIO_MODER_MODE9_Msk           (0x3UL << GPIO_MODER_MODE9_Pos)         /*!< 0x000C0000 */
#define GPIO_MODER_MODE9               GPIO_MODER_MODE9_Msk
#define GPIO_MODER_MODE9_0             (0x1UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00040000 */
#define GPIO_MODER_MODE9_1             (0x2UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00080000 */
#define GPIO_MODER_MODE10_Pos          (20U)
#define GPIO_MODER_MODE10_Msk          (0x3UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00300000 */
#define GPIO_MODER_MODE10              GPIO_MODER_MODE10_Msk
#define GPIO_MODER_MODE10_0            (0x1UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00100000 */
#define GPIO_MODER_MODE10_1            (0x2UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00200000 */
#define GPIO_MODER_MODE11_Pos          (22U)
#define GPIO_MODER_MODE11_Msk          (0x3UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00C00000 */
#define GPIO_MODER_MODE11              GPIO_MODER_MODE11_Msk
#define GPIO_MODER_MODE11_0            (0x1UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00400000 */
#define GPIO_MODER_MODE11_1            (0x2UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00800000 */
#define GPIO_MODER_MODE12_Pos          (24U)
#define GPIO_MODER_MODE12_Msk          (0x3UL << GPIO_MODER_MODE12_Pos)        /*!< 0x03000000 */
#define GPIO_MODER_MODE12              GPIO_MODER_MODE12_Msk
#define GPIO_MODER_MODE12_0            (0x1UL << GPIO_MODER_MODE12_Pos)        /*!< 0x01000000 */
#define GPIO_MODER_MODE12_1            (0x2UL << GPIO_MODER_MODE12_Pos)        /*!< 0x02000000 */
#define GPIO_MODER_MODE13_Pos          (26U)
#define GPIO_MODER_MODE13_Msk          (0x3UL << GPIO_MODER_MODE13_Pos)        /*!< 0x0C000000 */
#define GPIO_MODER_MODE13              GPIO_MODER_MODE13_Msk
#define GPIO_MODER_MODE13_0            (0x1UL << GPIO_MODER_MODE13_Pos)        /*!< 0x04000000 */
#define GPIO_MODER_MODE13_1            (0x2UL << GPIO_MODER_MODE13_Pos)        /*!< 0x08000000 */
#define GPIO_MODER_MODE14_Pos          (28U)
#define GPIO_MODER_MODE14_Msk          (0x3UL << GPIO_MODER_MODE14_Pos)        /*!< 0x30000000 */
#define GPIO_MODER_MODE14              GPIO_MODER_MODE14_Msk
#define GPIO_MODER_MODE14_0            (0x1UL << GPIO_MODER_MODE14_Pos)        /*!< 0x10000000 */
#define GPIO_MODER_MODE14_1            (0x2UL << GPIO_MODER_MODE14_Pos)        /*!< 0x20000000 */
#define GPIO_MODER_MODE15_Pos          (30U)
#define GPIO_MODER_MODE15_Msk          (0x3UL << GPIO_MODER_MODE15_Pos)        /*!< 0xC0000000 */
#define GPIO_MODER_MODE15              GPIO_MODER_MODE15_Msk
#define GPIO_MODER_MODE15_0            (0x1UL << GPIO_MODER_MODE15_Pos)        /*!< 0x40000000 */
#define GPIO_MODER_MODE15_1            (0x2UL << GPIO_MODER_MODE15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
#define GPIO_OTYPER_OT0_Pos            (0U)
#define GPIO_OTYPER_OT0_Msk            (0x1UL << GPIO_OTYPER_OT0_Pos)          /*!< 0x00000001 */
#define GPIO_OTYPER_OT0                GPIO_OTYPER_OT0_Msk
#define GPIO_OTYPER_OT1_Pos            (1U)
#define GPIO_OTYPER_OT1_Msk            (0x1UL << GPIO_OTYPER_OT1_Pos)          /*!< 0x00000002 */
#define GPIO_OTYPER_OT1                GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT2_Pos            (2U)
#define GPIO_OTYPER_OT2_Msk            (0x1UL << GPIO_OTYPER_OT2_Pos)          /*!< 0x00000004 */
#define GPIO_OTYPER_OT2                GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT3_Pos            (3U)
#define GPIO_OTYPER_OT3_Msk            (0x1UL << GPIO_OTYPER_OT3_Pos)          /*!< 0x00000008 */
#define GPIO_OTYPER_OT3                GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT4_Pos            (4U)
#define GPIO_OTYPER_OT4_Msk            (0x1UL << GPIO_OTYPER_OT4_Pos)          /*!< 0x00000010 */
#define GPIO_OTYPER_OT4                GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT5_Pos            (5U)
#define GPIO_OTYPER_OT5_Msk            (0x1UL << GPIO_OTYPER_OT5_Pos)          /*!< 0x00000020 */
#define GPIO_OTYPER_OT5                GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT6_Pos            (6U)
#define GPIO_OTYPER_OT6_Msk            (0x1UL << GPIO_OTYPER_OT6_Pos)          /*!< 0x00000040 */
#define GPIO_OTYPER_OT6                GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT7_Pos            (7U)
#define GPIO_OTYPER_OT7_Msk            (0x1UL << GPIO_OTYPER_OT7_Pos)          /*!< 0x00000080 */
#define GPIO_OTYPER_OT7                GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT8_Pos            (8U)
#define GPIO_OTYPER_OT8_Msk            (0x1UL << GPIO_OTYPER_OT8_Pos)          /*!< 0x00000100 */
#define GPIO_OTYPER_OT8                GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT9_Pos            (9U)
#define GPIO_OTYPER_OT9_Msk            (0x1UL << GPIO_OTYPER_OT9_Pos)          /*!< 0x00000200 */
#define GPIO_OTYPER_OT9                GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT10_Pos           (10U)
#define GPIO_OTYPER_OT10_Msk           (0x1UL << GPIO_OTYPER_OT10_Pos)         /*!< 0x00000400 */
#define GPIO_OTYPER_OT10               GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT11_Pos           (11U)
#define GPIO_OTYPER_OT11_Msk           (0x1UL << GPIO_OTYPER_OT11_Pos)         /*!< 0x00000800 */
#define GPIO_OTYPER_OT11               GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT12_Pos           (12U)
#define GPIO_OTYPER_OT12_Msk           (0x1UL << GPIO_OTYPER_OT12_Pos)         /*!< 0x00001000 */
#define GPIO_OTYPER_OT12               GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT13_Pos           (13U)
#define GPIO_OTYPER_OT13_Msk           (0x1UL << GPIO_OTYPER_OT13_Pos)         /*!< 0x00002000 */
#define GPIO_OTYPER_OT13               GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT14_Pos           (14U)
#define GPIO_OTYPER_OT14_Msk           (0x1UL << GPIO_OTYPER_OT14_Pos)         /*!< 0x00004000 */
#define GPIO_OTYPER_OT14               GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT15_Pos           (15U)
#define GPIO_OTYPER_OT15_Msk           (0x1UL << GPIO_OTYPER_OT15_Pos)         /*!< 0x00008000 */
#define GPIO_OTYPER_OT15               GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
#define GPIO_OSPEEDR_OSPEED0_Pos       (0U)
#define GPIO_OSPEEDR_OSPEED0_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000003 */
#define GPIO_OSPEEDR_OSPEED0           GPIO_OSPEEDR_OSPEED0_Msk
#define GPIO_OSPEEDR_OSPEED0_0         (0x1UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000001 */
#define GPIO_OSPEEDR_OSPEED0_1         (0x2UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000002 */
#define GPIO_OSPEEDR_OSPEED1_Pos       (2U)
#define GPIO_OSPEEDR_OSPEED1_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x0000000C */
#define GPIO_OSPEEDR_OSPEED1           GPIO_OSPEEDR_OSPEED1_Msk
#define GPIO_OSPEEDR_OSPEED1_0         (0x1UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000004 */
#define GPIO_OSPEEDR_OSPEED1_1         (0x2UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000008 */
#define GPIO_OSPEEDR_OSPEED2_Pos       (4U)
#define GPIO_OSPEEDR_OSPEED2_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000030 */
#define GPIO_OSPEEDR_OSPEED2           GPIO_OSPEEDR_OSPEED2_Msk
#define GPIO_OSPEEDR_OSPEED2_0         (0x1UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000010 */
#define GPIO_OSPEEDR_OSPEED2_1         (0x2UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000020 */
#define GPIO_OSPEEDR_OSPEED3_Pos       (6U)
#define GPIO_OSPEEDR_OSPEED3_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x000000C0 */
#define GPIO_OSPEEDR_OSPEED3           GPIO_OSPEEDR_OSPEED3_Msk
#define GPIO_OSPEEDR_OSPEED3_0         (0x1UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000040 */
#define GPIO_OSPEEDR_OSPEED3_1         (0x2UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000080 */
#define GPIO_OSPEEDR_OSPEED4_Pos       (8U)
#define GPIO_OSPEEDR_OSPEED4_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000300 */
#define GPIO_OSPEEDR_OSPEED4           GPIO_OSPEEDR_OSPEED4_Msk
#define GPIO_OSPEEDR_OSPEED4_0         (0x1UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000100 */
#define GPIO_OSPEEDR_OSPEED4_1         (0x2UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000200 */
#define GPIO_OSPEEDR_OSPEED5_Pos       (10U)
#define GPIO_OSPEEDR_OSPEED5_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000C00 */
#define GPIO_OSPEEDR_OSPEED5           GPIO_OSPEEDR_OSPEED5_Msk
#define GPIO_OSPEEDR_OSPEED5_0         (0x1UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000400 */
#define GPIO_OSPEEDR_OSPEED5_1         (0x2UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000800 */
#define GPIO_OSPEEDR_OSPEED6_Pos       (12U)
#define GPIO_OSPEEDR_OSPEED6_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00003000 */
#define GPIO_OSPEEDR_OSPEED6           GPIO_OSPEEDR_OSPEED6_Msk
#define GPIO_OSPEEDR_OSPEED6_0         (0x1UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00001000 */
#define GPIO_OSPEEDR_OSPEED6_1         (0x2UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00002000 */
#define GPIO_OSPEEDR_OSPEED7_Pos       (14U)
#define GPIO_OSPEEDR_OSPEED7_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x0000C000 */
#define GPIO_OSPEEDR_OSPEED7           GPIO_OSPEEDR_OSPEED7_Msk
#define GPIO_OSPEEDR_OSPEED7_0         (0x1UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00004000 */
#define GPIO_OSPEEDR_OSPEED7_1         (0x2UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00008000 */
#define GPIO_OSPEEDR_OSPEED8_Pos       (16U)
#define GPIO_OSPEEDR_OSPEED8_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00030000 */
#define GPIO_OSPEEDR_OSPEED8           GPIO_OSPEEDR_OSPEED8_Msk
#define GPIO_OSPEEDR_OSPEED8_0         (0x1UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00010000 */
#define GPIO_OSPEEDR_OSPEED8_1         (0x2UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00020000 */
#define GPIO_OSPEEDR_OSPEED9_Pos       (18U)
#define GPIO_OSPEEDR_OSPEED9_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x000C0000 */
#define GPIO_OSPEEDR_OSPEED9           GPIO_OSPEEDR_OSPEED9_Msk
#define GPIO_OSPEEDR_OSPEED9_0         (0x1UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00040000 */
#define GPIO_OSPEEDR_OSPEED9_1         (0x2UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00080000 */
#define GPIO_OSPEEDR_OSPEED10_Pos      (20U)
#define GPIO_OSPEEDR_OSPEED10_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00300000 */
#define GPIO_OSPEEDR_OSPEED10          GPIO_OSPEEDR_OSPEED10_Msk
#define GPIO_OSPEEDR_OSPEED10_0        (0x1UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00100000 */
#define GPIO_OSPEEDR_OSPEED10_1        (0x2UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00200000 */
#define GPIO_OSPEEDR_OSPEED11_Pos      (22U)
#define GPIO_OSPEEDR_OSPEED11_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00C00000 */
#define GPIO_OSPEEDR_OSPEED11          GPIO_OSPEEDR_OSPEED11_Msk
#define GPIO_OSPEEDR_OSPEED11_0        (0x1UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00400000 */
#define GPIO_OSPEEDR_OSPEED11_1        (0x2UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00800000 */
#define GPIO_OSPEEDR_OSPEED12_Pos      (24U)
#define GPIO_OSPEEDR_OSPEED12_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x03000000 */
#define GPIO_OSPEEDR_OSPEED12          GPIO_OSPEEDR_OSPEED12_Msk
#define GPIO_OSPEEDR_OSPEED12_0        (0x1UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x01000000 */
#define GPIO_OSPEEDR_OSPEED12_1        (0x2UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x02000000 */
#define GPIO_OSPEEDR_OSPEED13_Pos      (26U)
#define GPIO_OSPEEDR_OSPEED13_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x0C000000 */
#define GPIO_OSPEEDR_OSPEED13          GPIO_OSPEEDR_OSPEED13_Msk
#define GPIO_OSPEEDR_OSPEED13_0        (0x1UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x04000000 */
#define GPIO_OSPEEDR_OSPEED13_1        (0x2UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x08000000 */
#define GPIO_OSPEEDR_OSPEED14_Pos      (28U)
#define GPIO_OSPEEDR_OSPEED14_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x30000000 */
#define GPIO_OSPEEDR_OSPEED14          GPIO_OSPEEDR_OSPEED14_Msk
#define GPIO_OSPEEDR_OSPEED14_0        (0x1UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x10000000 */
#define GPIO_OSPEEDR_OSPEED14_1        (0x2UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x20000000 */
#define GPIO_OSPEEDR_OSPEED15_Pos      (30U)
#define GPIO_OSPEEDR_OSPEED15_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0xC0000000 */
#define GPIO_OSPEEDR_OSPEED15          GPIO_OSPEEDR_OSPEED15_Msk
#define GPIO_OSPEEDR_OSPEED15_0        (0x1UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x40000000 */
#define GPIO_OSPEEDR_OSPEED15_1        (0x2UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
#define GPIO_PUPDR_PUPD0_Pos           (0U)
#define GPIO_PUPDR_PUPD0_Msk           (0x3UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000003 */
#define GPIO_PUPDR_PUPD0               GPIO_PUPDR_PUPD0_Msk
#define GPIO_PUPDR_PUPD0_0             (0x1UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000001 */
#define GPIO_PUPDR_PUPD0_1             (0x2UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000002 */
#define GPIO_PUPDR_PUPD1_Pos           (2U)
#define GPIO_PUPDR_PUPD1_Msk           (0x3UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x0000000C */
#define GPIO_PUPDR_PUPD1               GPIO_PUPDR_PUPD1_Msk
#define GPIO_PUPDR_PUPD1_0             (0x1UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000004 */
#define GPIO_PUPDR_PUPD1_1             (0x2UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000008 */
#define GPIO_PUPDR_PUPD2_Pos           (4U)
#define GPIO_PUPDR_PUPD2_Msk           (0x3UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000030 */
#define GPIO_PUPDR_PUPD2               GPIO_PUPDR_PUPD2_Msk
#define GPIO_PUPDR_PUPD2_0             (0x1UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000010 */
#define GPIO_PUPDR_PUPD2_1             (0x2UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000020 */
#define GPIO_PUPDR_PUPD3_Pos           (6U)
#define GPIO_PUPDR_PUPD3_Msk           (0x3UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPD3               GPIO_PUPDR_PUPD3_Msk
#define GPIO_PUPDR_PUPD3_0             (0x1UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000040 */
#define GPIO_PUPDR_PUPD3_1             (0x2UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000080 */
#define GPIO_PUPDR_PUPD4_Pos           (8U)
#define GPIO_PUPDR_PUPD4_Msk           (0x3UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000300 */
#define GPIO_PUPDR_PUPD4               GPIO_PUPDR_PUPD4_Msk
#define GPIO_PUPDR_PUPD4_0             (0x1UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000100 */
#define GPIO_PUPDR_PUPD4_1             (0x2UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000200 */
#define GPIO_PUPDR_PUPD5_Pos           (10U)
#define GPIO_PUPDR_PUPD5_Msk           (0x3UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPD5               GPIO_PUPDR_PUPD5_Msk
#define GPIO_PUPDR_PUPD5_0             (0x1UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000400 */
#define GPIO_PUPDR_PUPD5_1             (0x2UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000800 */
#define GPIO_PUPDR_PUPD6_Pos           (12U)
#define GPIO_PUPDR_PUPD6_Msk           (0x3UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00003000 */
#define GPIO_PUPDR_PUPD6               GPIO_PUPDR_PUPD6_Msk
#define GPIO_PUPDR_PUPD6_0             (0x1UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00001000 */
#define GPIO_PUPDR_PUPD6_1             (0x2UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00002000 */
#define GPIO_PUPDR_PUPD7_Pos           (14U)
#define GPIO_PUPDR_PUPD7_Msk           (0x3UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPD7               GPIO_PUPDR_PUPD7_Msk
#define GPIO_PUPDR_PUPD7_0             (0x1UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00004000 */
#define GPIO_PUPDR_PUPD7_1             (0x2UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00008000 */
#define GPIO_PUPDR_PUPD8_Pos           (16U)
#define GPIO_PUPDR_PUPD8_Msk           (0x3UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00030000 */
#define GPIO_PUPDR_PUPD8               GPIO_PUPDR_PUPD8_Msk
#define GPIO_PUPDR_PUPD8_0             (0x1UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00010000 */
#define GPIO_PUPDR_PUPD8_1             (0x2UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00020000 */
#define GPIO_PUPDR_PUPD9_Pos           (18U)
#define GPIO_PUPDR_PUPD9_Msk           (0x3UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPD9               GPIO_PUPDR_PUPD9_Msk
#define GPIO_PUPDR_PUPD9_0             (0x1UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00040000 */
#define GPIO_PUPDR_PUPD9_1             (0x2UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00080000 */
#define GPIO_PUPDR_PUPD10_Pos          (20U)
#define GPIO_PUPDR_PUPD10_Msk          (0x3UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00300000 */
#define GPIO_PUPDR_PUPD10              GPIO_PUPDR_PUPD10_Msk
#define GPIO_PUPDR_PUPD10_0            (0x1UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00100000 */
#define GPIO_PUPDR_PUPD10_1            (0x2UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00200000 */
#define GPIO_PUPDR_PUPD11_Pos          (22U)
#define GPIO_PUPDR_PUPD11_Msk          (0x3UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPD11              GPIO_PUPDR_PUPD11_Msk
#define GPIO_PUPDR_PUPD11_0            (0x1UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00400000 */
#define GPIO_PUPDR_PUPD11_1            (0x2UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00800000 */
#define GPIO_PUPDR_PUPD12_Pos          (24U)
#define GPIO_PUPDR_PUPD12_Msk          (0x3UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x03000000 */
#define GPIO_PUPDR_PUPD12              GPIO_PUPDR_PUPD12_Msk
#define GPIO_PUPDR_PUPD12_0            (0x1UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x01000000 */
#define GPIO_PUPDR_PUPD12_1            (0x2UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x02000000 */
#define GPIO_PUPDR_PUPD13_Pos          (26U)
#define GPIO_PUPDR_PUPD13_Msk          (0x3UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPD13              GPIO_PUPDR_PUPD13_Msk
#define GPIO_PUPDR_PUPD13_0            (0x1UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x04000000 */
#define GPIO_PUPDR_PUPD13_1            (0x2UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x08000000 */
#define GPIO_PUPDR_PUPD14_Pos          (28U)
#define GPIO_PUPDR_PUPD14_Msk          (0x3UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x30000000 */
#define GPIO_PUPDR_PUPD14              GPIO_PUPDR_PUPD14_Msk
#define GPIO_PUPDR_PUPD14_0            (0x1UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x10000000 */
#define GPIO_PUPDR_PUPD14_1            (0x2UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x20000000 */
#define GPIO_PUPDR_PUPD15_Pos          (30U)
#define GPIO_PUPDR_PUPD15_Msk          (0x3UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPD15              GPIO_PUPDR_PUPD15_Msk
#define GPIO_PUPDR_PUPD15_0            (0x1UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x40000000 */
#define GPIO_PUPDR_PUPD15_1            (0x2UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
#define GPIO_IDR_ID0_Pos               (0U)
#define GPIO_IDR_ID0_Msk               (0x1UL << GPIO_IDR_ID0_Pos)             /*!< 0x00000001 */
#define GPIO_IDR_ID0                   GPIO_IDR_ID0_Msk
#define GPIO_IDR_ID1_Pos               (1U)
#define GPIO_IDR_ID1_Msk               (0x1UL << GPIO_IDR_ID1_Pos)             /*!< 0x00000002 */
#define GPIO_IDR_ID1                   GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID2_Pos               (2U)
#define GPIO_IDR_ID2_Msk               (0x1UL << GPIO_IDR_ID2_Pos)             /*!< 0x00000004 */
#define GPIO_IDR_ID2                   GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID3_Pos               (3U)
#define GPIO_IDR_ID3_Msk               (0x1UL << GPIO_IDR_ID3_Pos)             /*!< 0x00000008 */
#define GPIO_IDR_ID3                   GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID4_Pos               (4U)
#define GPIO_IDR_ID4_Msk               (0x1UL << GPIO_IDR_ID4_Pos)             /*!< 0x00000010 */
#define GPIO_IDR_ID4                   GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID5_Pos               (5U)
#define GPIO_IDR_ID5_Msk               (0x1UL << GPIO_IDR_ID5_Pos)             /*!< 0x00000020 */
#define GPIO_IDR_ID5                   GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID6_Pos               (6U)
#define GPIO_IDR_ID6_Msk               (0x1UL << GPIO_IDR_ID6_Pos)             /*!< 0x00000040 */
#define GPIO_IDR_ID6                   GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID7_Pos               (7U)
#define GPIO_IDR_ID7_Msk               (0x1UL << GPIO_IDR_ID7_Pos)             /*!< 0x00000080 */
#define GPIO_IDR_ID7                   GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID8_Pos               (8U)
#define GPIO_IDR_ID8_Msk               (0x1UL << GPIO_IDR_ID8_Pos)             /*!< 0x00000100 */
#define GPIO_IDR_ID8                   GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID9_Pos               (9U)
#define GPIO_IDR_ID9_Msk               (0x1UL << GPIO_IDR_ID9_Pos)             /*!< 0x00000200 */
#define GPIO_IDR_ID9                   GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID10_Pos              (10U)
#define GPIO_IDR_ID10_Msk              (0x1UL << GPIO_IDR_ID10_Pos)            /*!< 0x00000400 */
#define GPIO_IDR_ID10                  GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID11_Pos              (11U)
#define GPIO_IDR_ID11_Msk              (0x1UL << GPIO_IDR_ID11_Pos)            /*!< 0x00000800 */
#define GPIO_IDR_ID11                  GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID12_Pos              (12U)
#define GPIO_IDR_ID12_Msk              (0x1UL << GPIO_IDR_ID12_Pos)            /*!< 0x00001000 */
#define GPIO_IDR_ID12                  GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID13_Pos              (13U)
#define GPIO_IDR_ID13_Msk              (0x1UL << GPIO_IDR_ID13_Pos)            /*!< 0x00002000 */
#define GPIO_IDR_ID13                  GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID14_Pos              (14U)
#define GPIO_IDR_ID14_Msk              (0x1UL << GPIO_IDR_ID14_Pos)            /*!< 0x00004000 */
#define GPIO_IDR_ID14                  GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID15_Pos              (15U)
#define GPIO_IDR_ID15_Msk              (0x1UL << GPIO_IDR_ID15_Pos)            /*!< 0x00008000 */
#define GPIO_IDR_ID15                  GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
#define GPIO_ODR_OD0_Pos               (0U)
#define GPIO_ODR_OD0_Msk               (0x1UL << GPIO_ODR_OD0_Pos)             /*!< 0x00000001 */
#define GPIO_ODR_OD0                   GPIO_ODR_OD0_Msk
#define GPIO_ODR_OD1_Pos               (1U)
#define GPIO_ODR_OD1_Msk               (0x1UL << GPIO_ODR_OD1_Pos)             /*!< 0x00000002 */
#define GPIO_ODR_OD1                   GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD2_Pos               (2U)
#define GPIO_ODR_OD2_Msk               (0x1UL << GPIO_ODR_OD2_Pos)             /*!< 0x00000004 */
#define GPIO_ODR_OD2                   GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD3_Pos               (3U)
#define GPIO_ODR_OD3_Msk               (0x1UL << GPIO_ODR_OD3_Pos)             /*!< 0x00000008 */
#define GPIO_ODR_OD3                   GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD4_Pos               (4U)
#define GPIO_ODR_OD4_Msk               (0x1UL << GPIO_ODR_OD4_Pos)             /*!< 0x00000010 */
#define GPIO_ODR_OD4                   GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD5_Pos               (5U)
#define GPIO_ODR_OD5_Msk               (0x1UL << GPIO_ODR_OD5_Pos)             /*!< 0x00000020 */
#define GPIO_ODR_OD5                   GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD6_Pos               (6U)
#define GPIO_ODR_OD6_Msk               (0x1UL << GPIO_ODR_OD6_Pos)             /*!< 0x00000040 */
#define GPIO_ODR_OD6                   GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD7_Pos               (7U)
#define GPIO_ODR_OD7_Msk               (0x1UL << GPIO_ODR_OD7_Pos)             /*!< 0x00000080 */
#define GPIO_ODR_OD7                   GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD8_Pos               (8U)
#define GPIO_ODR_OD8_Msk               (0x1UL << GPIO_ODR_OD8_Pos)             /*!< 0x00000100 */
#define GPIO_ODR_OD8                   GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD9_Pos               (9U)
#define GPIO_ODR_OD9_Msk               (0x1UL << GPIO_ODR_OD9_Pos)             /*!< 0x00000200 */
#define GPIO_ODR_OD9                   GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD10_Pos              (10U)
#define GPIO_ODR_OD10_Msk              (0x1UL << GPIO_ODR_OD10_Pos)            /*!< 0x00000400 */
#define GPIO_ODR_OD10                  GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD11_Pos              (11U)
#define GPIO_ODR_OD11_Msk              (0x1UL << GPIO_ODR_OD11_Pos)            /*!< 0x00000800 */
#define GPIO_ODR_OD11                  GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD12_Pos              (12U)
#define GPIO_ODR_OD12_Msk              (0x1UL << GPIO_ODR_OD12_Pos)            /*!< 0x00001000 */
#define GPIO_ODR_OD12                  GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD13_Pos              (13U)
#define GPIO_ODR_OD13_Msk              (0x1UL << GPIO_ODR_OD13_Pos)            /*!< 0x00002000 */
#define GPIO_ODR_OD13                  GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD14_Pos              (14U)
#define GPIO_ODR_OD14_Msk              (0x1UL << GPIO_ODR_OD14_Pos)            /*!< 0x00004000 */
#define GPIO_ODR_OD14                  GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD15_Pos              (15U)
#define GPIO_ODR_OD15_Msk              (0x1UL << GPIO_ODR_OD15_Pos)            /*!< 0x00008000 */
#define GPIO_ODR_OD15                  GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
#define GPIO_BSRR_BS0_Pos              (0U)
#define GPIO_BSRR_BS0_Msk              (0x1UL << GPIO_BSRR_BS0_Pos)            /*!< 0x00000001 */
#define GPIO_BSRR_BS0                  GPIO_BSRR_BS0_Msk
#define GPIO_BSRR_BS1_Pos              (1U)
#define GPIO_BSRR_BS1_Msk              (0x1UL << GPIO_BSRR_BS1_Pos)            /*!< 0x00000002 */
#define GPIO_BSRR_BS1                  GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS2_Pos              (2U)
#define GPIO_BSRR_BS2_Msk              (0x1UL << GPIO_BSRR_BS2_Pos)            /*!< 0x00000004 */
#define GPIO_BSRR_BS2                  GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS3_Pos              (3U)
#define GPIO_BSRR_BS3_Msk              (0x1UL << GPIO_BSRR_BS3_Pos)            /*!< 0x00000008 */
#define GPIO_BSRR_BS3                  GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS4_Pos              (4U)
#define GPIO_BSRR_BS4_Msk              (0x1UL << GPIO_BSRR_BS4_Pos)            /*!< 0x00000010 */
#define GPIO_BSRR_BS4                  GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS5_Pos              (5U)
#define GPIO_BSRR_BS5_Msk              (0x1UL << GPIO_BSRR_BS5_Pos)            /*!< 0x00000020 */
#define GPIO_BSRR_BS5                  GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS6_Pos              (6U)
#define GPIO_BSRR_BS6_Msk              (0x1UL << GPIO_BSRR_BS6_Pos)            /*!< 0x00000040 */
#define GPIO_BSRR_BS6                  GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS7_Pos              (7U)
#define GPIO_BSRR_BS7_Msk              (0x1UL << GPIO_BSRR_BS7_Pos)            /*!< 0x00000080 */
#define GPIO_BSRR_BS7                  GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS8_Pos              (8U)
#define GPIO_BSRR_BS8_Msk              (0x1UL << GPIO_BSRR_BS8_Pos)            /*!< 0x00000100 */
#define GPIO_BSRR_BS8                  GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS9_Pos              (9U)
#define GPIO_BSRR_BS9_Msk              (0x1UL << GPIO_BSRR_BS9_Pos)            /*!< 0x00000200 */
#define GPIO_BSRR_BS9                  GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS10_Pos             (10U)
#define GPIO_BSRR_BS10_Msk             (0x1UL << GPIO_BSRR_BS10_Pos)           /*!< 0x00000400 */
#define GPIO_BSRR_BS10                 GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS11_Pos             (11U)
#define GPIO_BSRR_BS11_Msk             (0x1UL << GPIO_BSRR_BS11_Pos)           /*!< 0x00000800 */
#define GPIO_BSRR_BS11                 GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS12_Pos             (12U)
#define GPIO_BSRR_BS12_Msk             (0x1UL << GPIO_BSRR_BS12_Pos)           /*!< 0x00001000 */
#define GPIO_BSRR_BS12                 GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS13_Pos             (13U)
#define GPIO_BSRR_BS13_Msk             (0x1UL << GPIO_BSRR_BS13_Pos)           /*!< 0x00002000 */
#define GPIO_BSRR_BS13                 GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS14_Pos             (14U)
#define GPIO_BSRR_BS14_Msk             (0x1UL << GPIO_BSRR_BS14_Pos)           /*!< 0x00004000 */
#define GPIO_BSRR_BS14                 GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS15_Pos             (15U)
#define GPIO_BSRR_BS15_Msk             (0x1UL << GPIO_BSRR_BS15_Pos)           /*!< 0x00008000 */
#define GPIO_BSRR_BS15                 GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BR0_Pos              (16U)
#define GPIO_BSRR_BR0_Msk              (0x1UL << GPIO_BSRR_BR0_Pos)            /*!< 0x00010000 */
#define GPIO_BSRR_BR0                  GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BR1_Pos              (17U)
#define GPIO_BSRR_BR1_Msk              (0x1UL << GPIO_BSRR_BR1_Pos)            /*!< 0x00020000 */
#define GPIO_BSRR_BR1                  GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR2_Pos              (18U)
#define GPIO_BSRR_BR2_Msk              (0x1UL << GPIO_BSRR_BR2_Pos)            /*!< 0x00040000 */
#define GPIO_BSRR_BR2                  GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR3_Pos              (19U)
#define GPIO_BSRR_BR3_Msk              (0x1UL << GPIO_BSRR_BR3_Pos)            /*!< 0x00080000 */
#define GPIO_BSRR_BR3                  GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR4_Pos              (20U)
#define GPIO_BSRR_BR4_Msk              (0x1UL << GPIO_BSRR_BR4_Pos)            /*!< 0x00100000 */
#define GPIO_BSRR_BR4                  GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR5_Pos              (21U)
#define GPIO_BSRR_BR5_Msk              (0x1UL << GPIO_BSRR_BR5_Pos)            /*!< 0x00200000 */
#define GPIO_BSRR_BR5                  GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR6_Pos              (22U)
#define GPIO_BSRR_BR6_Msk              (0x1UL << GPIO_BSRR_BR6_Pos)            /*!< 0x00400000 */
#define GPIO_BSRR_BR6                  GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR7_Pos              (23U)
#define GPIO_BSRR_BR7_Msk              (0x1UL << GPIO_BSRR_BR7_Pos)            /*!< 0x00800000 */
#define GPIO_BSRR_BR7                  GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR8_Pos              (24U)
#define GPIO_BSRR_BR8_Msk              (0x1UL << GPIO_BSRR_BR8_Pos)            /*!< 0x01000000 */
#define GPIO_BSRR_BR8                  GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR9_Pos              (25U)
#define GPIO_BSRR_BR9_Msk              (0x1UL << GPIO_BSRR_BR9_Pos)            /*!< 0x02000000 */
#define GPIO_BSRR_BR9                  GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR10_Pos             (26U)
#define GPIO_BSRR_BR10_Msk             (0x1UL << GPIO_BSRR_BR10_Pos)           /*!< 0x04000000 */
#define GPIO_BSRR_BR10                 GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR11_Pos             (27U)
#define GPIO_BSRR_BR11_Msk             (0x1UL << GPIO_BSRR_BR11_Pos)           /*!< 0x08000000 */
#define GPIO_BSRR_BR11                 GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR12_Pos             (28U)
#define GPIO_BSRR_BR12_Msk             (0x1UL << GPIO_BSRR_BR12_Pos)           /*!< 0x10000000 */
#define GPIO_BSRR_BR12                 GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR13_Pos             (29U)
#define GPIO_BSRR_BR13_Msk             (0x1UL << GPIO_BSRR_BR13_Pos)           /*!< 0x20000000 */
#define GPIO_BSRR_BR13                 GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR14_Pos             (30U)
#define GPIO_BSRR_BR14_Msk             (0x1UL << GPIO_BSRR_BR14_Pos)           /*!< 0x40000000 */
#define GPIO_BSRR_BR14                 GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR15_Pos             (31U)
#define GPIO_BSRR_BR15_Msk             (0x1UL << GPIO_BSRR_BR15_Pos)           /*!< 0x80000000 */
#define GPIO_BSRR_BR15                 GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
#define GPIO_LCKR_LCK0_Pos             (0U)
#define GPIO_LCKR_LCK0_Msk             (0x1UL << GPIO_LCKR_LCK0_Pos)           /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                 GPIO_LCKR_LCK0_Msk
#define GPIO_LCKR_LCK1_Pos             (1U)
#define GPIO_LCKR_LCK1_Msk             (0x1UL << GPIO_LCKR_LCK1_Pos)           /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                 GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK2_Pos             (2U)
#define GPIO_LCKR_LCK2_Msk             (0x1UL << GPIO_LCKR_LCK2_Pos)           /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                 GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK3_Pos             (3U)
#define GPIO_LCKR_LCK3_Msk             (0x1UL << GPIO_LCKR_LCK3_Pos)           /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                 GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK4_Pos             (4U)
#define GPIO_LCKR_LCK4_Msk             (0x1UL << GPIO_LCKR_LCK4_Pos)           /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                 GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK5_Pos             (5U)
#define GPIO_LCKR_LCK5_Msk             (0x1UL << GPIO_LCKR_LCK5_Pos)           /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                 GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK6_Pos             (6U)
#define GPIO_LCKR_LCK6_Msk             (0x1UL << GPIO_LCKR_LCK6_Pos)           /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                 GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK7_Pos             (7U)
#define GPIO_LCKR_LCK7_Msk             (0x1UL << GPIO_LCKR_LCK7_Pos)           /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                 GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK8_Pos             (8U)
#define GPIO_LCKR_LCK8_Msk             (0x1UL << GPIO_LCKR_LCK8_Pos)           /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                 GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK9_Pos             (9U)
#define GPIO_LCKR_LCK9_Msk             (0x1UL << GPIO_LCKR_LCK9_Pos)           /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                 GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK10_Pos            (10U)
#define GPIO_LCKR_LCK10_Msk            (0x1UL << GPIO_LCKR_LCK10_Pos)          /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK11_Pos            (11U)
#define GPIO_LCKR_LCK11_Msk            (0x1UL << GPIO_LCKR_LCK11_Pos)          /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK12_Pos            (12U)
#define GPIO_LCKR_LCK12_Msk            (0x1UL << GPIO_LCKR_LCK12_Pos)          /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK13_Pos            (13U)
#define GPIO_LCKR_LCK13_Msk            (0x1UL << GPIO_LCKR_LCK13_Pos)          /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK14_Pos            (14U)
#define GPIO_LCKR_LCK14_Msk            (0x1UL << GPIO_LCKR_LCK14_Pos)          /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK15_Pos            (15U)
#define GPIO_LCKR_LCK15_Msk            (0x1UL << GPIO_LCKR_LCK15_Pos)          /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCKK_Pos             (16U)
#define GPIO_LCKR_LCKK_Msk             (0x1UL << GPIO_LCKR_LCKK_Pos)           /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                 GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register *********************/
#define GPIO_AFRL_AFSEL0_Pos           (0U)
#define GPIO_AFRL_AFSEL0_Msk           (0xFUL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRL_AFSEL0               GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0             (0x1UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000001 */
#define GPIO_AFRL_AFSEL0_1             (0x2UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000002 */
#define GPIO_AFRL_AFSEL0_2             (0x4UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000004 */
#define GPIO_AFRL_AFSEL0_3             (0x8UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000008 */
#define GPIO_AFRL_AFSEL1_Pos           (4U)
#define GPIO_AFRL_AFSEL1_Msk           (0xFUL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRL_AFSEL1               GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0             (0x1UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000010 */
#define GPIO_AFRL_AFSEL1_1             (0x2UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000020 */
#define GPIO_AFRL_AFSEL1_2             (0x4UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000040 */
#define GPIO_AFRL_AFSEL1_3             (0x8UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000080 */
#define GPIO_AFRL_AFSEL2_Pos           (8U)
#define GPIO_AFRL_AFSEL2_Msk           (0xFUL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRL_AFSEL2               GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0             (0x1UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000100 */
#define GPIO_AFRL_AFSEL2_1             (0x2UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000200 */
#define GPIO_AFRL_AFSEL2_2             (0x4UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000400 */
#define GPIO_AFRL_AFSEL2_3             (0x8UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000800 */
#define GPIO_AFRL_AFSEL3_Pos           (12U)
#define GPIO_AFRL_AFSEL3_Msk           (0xFUL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRL_AFSEL3               GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0             (0x1UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00001000 */
#define GPIO_AFRL_AFSEL3_1             (0x2UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00002000 */
#define GPIO_AFRL_AFSEL3_2             (0x4UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00004000 */
#define GPIO_AFRL_AFSEL3_3             (0x8UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00008000 */
#define GPIO_AFRL_AFSEL4_Pos           (16U)
#define GPIO_AFRL_AFSEL4_Msk           (0xFUL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRL_AFSEL4               GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0             (0x1UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00010000 */
#define GPIO_AFRL_AFSEL4_1             (0x2UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00020000 */
#define GPIO_AFRL_AFSEL4_2             (0x4UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00040000 */
#define GPIO_AFRL_AFSEL4_3             (0x8UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00080000 */
#define GPIO_AFRL_AFSEL5_Pos           (20U)
#define GPIO_AFRL_AFSEL5_Msk           (0xFUL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRL_AFSEL5               GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0             (0x1UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00100000 */
#define GPIO_AFRL_AFSEL5_1             (0x2UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00200000 */
#define GPIO_AFRL_AFSEL5_2             (0x4UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00400000 */
#define GPIO_AFRL_AFSEL5_3             (0x8UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00800000 */
#define GPIO_AFRL_AFSEL6_Pos           (24U)
#define GPIO_AFRL_AFSEL6_Msk           (0xFUL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRL_AFSEL6               GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0             (0x1UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x01000000 */
#define GPIO_AFRL_AFSEL6_1             (0x2UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x02000000 */
#define GPIO_AFRL_AFSEL6_2             (0x4UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x04000000 */
#define GPIO_AFRL_AFSEL6_3             (0x8UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x08000000 */
#define GPIO_AFRL_AFSEL7_Pos           (28U)
#define GPIO_AFRL_AFSEL7_Msk           (0xFUL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRL_AFSEL7               GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0             (0x1UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x10000000 */
#define GPIO_AFRL_AFSEL7_1             (0x2UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x20000000 */
#define GPIO_AFRL_AFSEL7_2             (0x4UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x40000000 */
#define GPIO_AFRL_AFSEL7_3             (0x8UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x80000000 */

/****************** Bit definition for GPIO_AFRH register *********************/
#define GPIO_AFRH_AFSEL8_Pos           (0U)
#define GPIO_AFRH_AFSEL8_Msk           (0xFUL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x0000000F */
#define GPIO_AFRH_AFSEL8               GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0             (0x1UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000001 */
#define GPIO_AFRH_AFSEL8_1             (0x2UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000002 */
#define GPIO_AFRH_AFSEL8_2             (0x4UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000004 */
#define GPIO_AFRH_AFSEL8_3             (0x8UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000008 */
#define GPIO_AFRH_AFSEL9_Pos           (4U)
#define GPIO_AFRH_AFSEL9_Msk           (0xFUL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRH_AFSEL9               GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0             (0x1UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000010 */
#define GPIO_AFRH_AFSEL9_1             (0x2UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000020 */
#define GPIO_AFRH_AFSEL9_2             (0x4UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000040 */
#define GPIO_AFRH_AFSEL9_3             (0x8UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000080 */
#define GPIO_AFRH_AFSEL10_Pos          (8U)
#define GPIO_AFRH_AFSEL10_Msk          (0xFUL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000F00 */
#define GPIO_AFRH_AFSEL10              GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0            (0x1UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000100 */
#define GPIO_AFRH_AFSEL10_1            (0x2UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000200 */
#define GPIO_AFRH_AFSEL10_2            (0x4UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000400 */
#define GPIO_AFRH_AFSEL10_3            (0x8UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000800 */
#define GPIO_AFRH_AFSEL11_Pos          (12U)
#define GPIO_AFRH_AFSEL11_Msk          (0xFUL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x0000F000 */
#define GPIO_AFRH_AFSEL11              GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0            (0x1UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00001000 */
#define GPIO_AFRH_AFSEL11_1            (0x2UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00002000 */
#define GPIO_AFRH_AFSEL11_2            (0x4UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00004000 */
#define GPIO_AFRH_AFSEL11_3            (0x8UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00008000 */
#define GPIO_AFRH_AFSEL12_Pos          (16U)
#define GPIO_AFRH_AFSEL12_Msk          (0xFUL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x000F0000 */
#define GPIO_AFRH_AFSEL12              GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0            (0x1UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00010000 */
#define GPIO_AFRH_AFSEL12_1            (0x2UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00020000 */
#define GPIO_AFRH_AFSEL12_2            (0x4UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00040000 */
#define GPIO_AFRH_AFSEL12_3            (0x8UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00080000 */
#define GPIO_AFRH_AFSEL13_Pos          (20U)
#define GPIO_AFRH_AFSEL13_Msk          (0xFUL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00F00000 */
#define GPIO_AFRH_AFSEL13              GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0            (0x1UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00100000 */
#define GPIO_AFRH_AFSEL13_1            (0x2UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00200000 */
#define GPIO_AFRH_AFSEL13_2            (0x4UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00400000 */
#define GPIO_AFRH_AFSEL13_3            (0x8UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00800000 */
#define GPIO_AFRH_AFSEL14_Pos          (24U)
#define GPIO_AFRH_AFSEL14_Msk          (0xFUL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x0F000000 */
#define GPIO_AFRH_AFSEL14              GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0            (0x1UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x01000000 */
#define GPIO_AFRH_AFSEL14_1            (0x2UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x02000000 */
#define GPIO_AFRH_AFSEL14_2            (0x4UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x04000000 */
#define GPIO_AFRH_AFSEL14_3            (0x8UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x08000000 */
#define GPIO_AFRH_AFSEL15_Pos          (28U)
#define GPIO_AFRH_AFSEL15_Msk          (0xFUL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0xF0000000 */
#define GPIO_AFRH_AFSEL15              GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0            (0x1UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x10000000 */
#define GPIO_AFRH_AFSEL15_1            (0x2UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x20000000 */
#define GPIO_AFRH_AFSEL15_2            (0x4UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x40000000 */
#define GPIO_AFRH_AFSEL15_3            (0x8UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_BRR register  ******************/
#define GPIO_BRR_BR0_Pos               (0U)
#define GPIO_BRR_BR0_Msk               (0x1UL << GPIO_BRR_BR0_Pos)             /*!< 0x00000001 */
#define GPIO_BRR_BR0                   GPIO_BRR_BR0_Msk
#define GPIO_BRR_BR1_Pos               (1U)
#define GPIO_BRR_BR1_Msk               (0x1UL << GPIO_BRR_BR1_Pos)             /*!< 0x00000002 */
#define GPIO_BRR_BR1                   GPIO_BRR_BR1_Msk
#define GPIO_BRR_BR2_Pos               (2U)
#define GPIO_BRR_BR2_Msk               (0x1UL << GPIO_BRR_BR2_Pos)             /*!< 0x00000004 */
#define GPIO_BRR_BR2                   GPIO_BRR_BR2_Msk
#define GPIO_BRR_BR3_Pos               (3U)
#define GPIO_BRR_BR3_Msk               (0x1UL << GPIO_BRR_BR3_Pos)             /*!< 0x00000008 */
#define GPIO_BRR_BR3                   GPIO_BRR_BR3_Msk
#define GPIO_BRR_BR4_Pos               (4U)
#define GPIO_BRR_BR4_Msk               (0x1UL << GPIO_BRR_BR4_Pos)             /*!< 0x00000010 */
#define GPIO_BRR_BR4                   GPIO_BRR_BR4_Msk
#define GPIO_BRR_BR5_Pos               (5U)
#define GPIO_BRR_BR5_Msk               (0x1UL << GPIO_BRR_BR5_Pos)             /*!< 0x00000020 */
#define GPIO_BRR_BR5                   GPIO_BRR_BR5_Msk
#define GPIO_BRR_BR6_Pos               (6U)
#define GPIO_BRR_BR6_Msk               (0x1UL << GPIO_BRR_BR6_Pos)             /*!< 0x00000040 */
#define GPIO_BRR_BR6                   GPIO_BRR_BR6_Msk
#define GPIO_BRR_BR7_Pos               (7U)
#define GPIO_BRR_BR7_Msk               (0x1UL << GPIO_BRR_BR7_Pos)             /*!< 0x00000080 */
#define GPIO_BRR_BR7                   GPIO_BRR_BR7_Msk
#define GPIO_BRR_BR8_Pos               (8U)
#define GPIO_BRR_BR8_Msk               (0x1UL << GPIO_BRR_BR8_Pos)             /*!< 0x00000100 */
#define GPIO_BRR_BR8                   GPIO_BRR_BR8_Msk
#define GPIO_BRR_BR9_Pos               (9U)
#define GPIO_BRR_BR9_Msk               (0x1UL << GPIO_BRR_BR9_Pos)             /*!< 0x00000200 */
#define GPIO_BRR_BR9                   GPIO_BRR_BR9_Msk
#define GPIO_BRR_BR10_Pos              (10U)
#define GPIO_BRR_BR10_Msk              (0x1UL << GPIO_BRR_BR10_Pos)            /*!< 0x00000400 */
#define GPIO_BRR_BR10                  GPIO_BRR_BR10_Msk
#define GPIO_BRR_BR11_Pos              (11U)
#define GPIO_BRR_BR11_Msk              (0x1UL << GPIO_BRR_BR11_Pos)            /*!< 0x00000800 */
#define GPIO_BRR_BR11                  GPIO_BRR_BR11_Msk
#define GPIO_BRR_BR12_Pos              (12U)
#define GPIO_BRR_BR12_Msk              (0x1UL << GPIO_BRR_BR12_Pos)            /*!< 0x00001000 */
#define GPIO_BRR_BR12                  GPIO_BRR_BR12_Msk
#define GPIO_BRR_BR13_Pos              (13U)
#define GPIO_BRR_BR13_Msk              (0x1UL << GPIO_BRR_BR13_Pos)            /*!< 0x00002000 */
#define GPIO_BRR_BR13                  GPIO_BRR_BR13_Msk
#define GPIO_BRR_BR14_Pos              (14U)
#define GPIO_BRR_BR14_Msk              (0x1UL << GPIO_BRR_BR14_Pos)            /*!< 0x00004000 */
#define GPIO_BRR_BR14                  GPIO_BRR_BR14_Msk
#define GPIO_BRR_BR15_Pos              (15U)
#define GPIO_BRR_BR15_Msk              (0x1UL << GPIO_BRR_BR15_Pos)            /*!< 0x00008000 */
#define GPIO_BRR_BR15                  GPIO_BRR_BR15_Msk

/******************  Bits definition for GPIO_SECCFGR register  ***************/
#define GPIO_SECCFGR_SEC0_Pos          (0U)
#define GPIO_SECCFGR_SEC0_Msk          (0x1UL << GPIO_SECCFGR_SEC0_Pos)        /*!< 0x00000001 */
#define GPIO_SECCFGR_SEC0              GPIO_SECCFGR_SEC0_Msk
#define GPIO_SECCFGR_SEC1_Pos          (1U)
#define GPIO_SECCFGR_SEC1_Msk          (0x1UL << GPIO_SECCFGR_SEC1_Pos)        /*!< 0x00000002 */
#define GPIO_SECCFGR_SEC1              GPIO_SECCFGR_SEC1_Msk
#define GPIO_SECCFGR_SEC2_Pos          (2U)
#define GPIO_SECCFGR_SEC2_Msk          (0x1UL << GPIO_SECCFGR_SEC2_Pos)        /*!< 0x00000004 */
#define GPIO_SECCFGR_SEC2              GPIO_SECCFGR_SEC2_Msk
#define GPIO_SECCFGR_SEC3_Pos          (3U)
#define GPIO_SECCFGR_SEC3_Msk          (0x1UL << GPIO_SECCFGR_SEC3_Pos)        /*!< 0x00000008 */
#define GPIO_SECCFGR_SEC3              GPIO_SECCFGR_SEC3_Msk
#define GPIO_SECCFGR_SEC4_Pos          (4U)
#define GPIO_SECCFGR_SEC4_Msk          (0x1UL << GPIO_SECCFGR_SEC4_Pos)        /*!< 0x00000010 */
#define GPIO_SECCFGR_SEC4              GPIO_SECCFGR_SEC4_Msk
#define GPIO_SECCFGR_SEC5_Pos          (5U)
#define GPIO_SECCFGR_SEC5_Msk          (0x1UL << GPIO_SECCFGR_SEC5_Pos)        /*!< 0x00000020 */
#define GPIO_SECCFGR_SEC5              GPIO_SECCFGR_SEC5_Msk
#define GPIO_SECCFGR_SEC6_Pos          (6U)
#define GPIO_SECCFGR_SEC6_Msk          (0x1UL << GPIO_SECCFGR_SEC6_Pos)        /*!< 0x00000040 */
#define GPIO_SECCFGR_SEC6              GPIO_SECCFGR_SEC6_Msk
#define GPIO_SECCFGR_SEC7_Pos          (7U)
#define GPIO_SECCFGR_SEC7_Msk          (0x1UL << GPIO_SECCFGR_SEC7_Pos)        /*!< 0x00000080 */
#define GPIO_SECCFGR_SEC7              GPIO_SECCFGR_SEC7_Msk
#define GPIO_SECCFGR_SEC8_Pos          (8U)
#define GPIO_SECCFGR_SEC8_Msk          (0x1UL << GPIO_SECCFGR_SEC8_Pos)        /*!< 0x00000100 */
#define GPIO_SECCFGR_SEC8              GPIO_SECCFGR_SEC8_Msk
#define GPIO_SECCFGR_SEC9_Pos          (9U)
#define GPIO_SECCFGR_SEC9_Msk          (0x1UL << GPIO_SECCFGR_SEC9_Pos)        /*!< 0x00000200 */
#define GPIO_SECCFGR_SEC9              GPIO_SECCFGR_SEC9_Msk
#define GPIO_SECCFGR_SEC10_Pos         (10U)
#define GPIO_SECCFGR_SEC10_Msk         (0x1UL << GPIO_SECCFGR_SEC10_Pos)       /*!< 0x00000400 */
#define GPIO_SECCFGR_SEC10             GPIO_SECCFGR_SEC10_Msk
#define GPIO_SECCFGR_SEC11_Pos         (11U)
#define GPIO_SECCFGR_SEC11_Msk         (0x1UL << GPIO_SECCFGR_SEC11_Pos)       /*!< 0x00000800 */
#define GPIO_SECCFGR_SEC11             GPIO_SECCFGR_SEC11_Msk
#define GPIO_SECCFGR_SEC12_Pos         (12U)
#define GPIO_SECCFGR_SEC12_Msk         (0x1UL << GPIO_SECCFGR_SEC12_Pos)       /*!< 0x00001000 */
#define GPIO_SECCFGR_SEC12             GPIO_SECCFGR_SEC12_Msk
#define GPIO_SECCFGR_SEC13_Pos         (13U)
#define GPIO_SECCFGR_SEC13_Msk         (0x1UL << GPIO_SECCFGR_SEC13_Pos)       /*!< 0x00002000 */
#define GPIO_SECCFGR_SEC13             GPIO_SECCFGR_SEC13_Msk
#define GPIO_SECCFGR_SEC14_Pos         (14U)
#define GPIO_SECCFGR_SEC14_Msk         (0x1UL << GPIO_SECCFGR_SEC14_Pos)       /*!< 0x00004000 */
#define GPIO_SECCFGR_SEC14             GPIO_SECCFGR_SEC14_Msk
#define GPIO_SECCFGR_SEC15_Pos         (15U)
#define GPIO_SECCFGR_SEC15_Msk         (0x1UL << GPIO_SECCFGR_SEC15_Pos)       /*!< 0x00008000 */
#define GPIO_SECCFGR_SEC15             GPIO_SECCFGR_SEC15_Msk


/******************************************************************************/
/*                                                                            */
/*                                    HASH                                    */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for HASH_CR register  ********************/
#define HASH_CR_INIT_Pos          (2U)
#define HASH_CR_INIT_Msk          (0x1UL << HASH_CR_INIT_Pos)                  /*!< 0x00000004 */
#define HASH_CR_INIT              HASH_CR_INIT_Msk
#define HASH_CR_DMAE_Pos          (3U)
#define HASH_CR_DMAE_Msk          (0x1UL << HASH_CR_DMAE_Pos)                  /*!< 0x00000008 */
#define HASH_CR_DMAE              HASH_CR_DMAE_Msk
#define HASH_CR_DATATYPE_Pos      (4U)
#define HASH_CR_DATATYPE_Msk      (0x3UL << HASH_CR_DATATYPE_Pos)              /*!< 0x00000030 */
#define HASH_CR_DATATYPE          HASH_CR_DATATYPE_Msk
#define HASH_CR_DATATYPE_0        (0x1UL << HASH_CR_DATATYPE_Pos)              /*!< 0x00000010 */
#define HASH_CR_DATATYPE_1        (0x2UL << HASH_CR_DATATYPE_Pos)              /*!< 0x00000020 */
#define HASH_CR_MODE_Pos          (6U)
#define HASH_CR_MODE_Msk          (0x1UL << HASH_CR_MODE_Pos)                  /*!< 0x00000040 */
#define HASH_CR_MODE              HASH_CR_MODE_Msk
#define HASH_CR_ALGO_Pos          (7U)
#define HASH_CR_ALGO_Msk          (0x801UL << HASH_CR_ALGO_Pos)                /*!< 0x00040080 */
#define HASH_CR_ALGO              HASH_CR_ALGO_Msk
#define HASH_CR_ALGO_0            (0x001UL << HASH_CR_ALGO_Pos)                /*!< 0x00000080 */
#define HASH_CR_ALGO_1            (0x800UL << HASH_CR_ALGO_Pos)                /*!< 0x00040000 */
#define HASH_CR_NBW_Pos           (8U)
#define HASH_CR_NBW_Msk           (0xFUL << HASH_CR_NBW_Pos)                   /*!< 0x00000F00 */
#define HASH_CR_NBW               HASH_CR_NBW_Msk
#define HASH_CR_NBW_0             (0x1UL << HASH_CR_NBW_Pos)                   /*!< 0x00000100 */
#define HASH_CR_NBW_1             (0x2UL << HASH_CR_NBW_Pos)                   /*!< 0x00000200 */
#define HASH_CR_NBW_2             (0x4UL << HASH_CR_NBW_Pos)                   /*!< 0x00000400 */
#define HASH_CR_NBW_3             (0x8UL << HASH_CR_NBW_Pos)                   /*!< 0x00000800 */
#define HASH_CR_DINNE_Pos         (12U)
#define HASH_CR_DINNE_Msk         (0x1UL << HASH_CR_DINNE_Pos)                 /*!< 0x00001000 */
#define HASH_CR_DINNE             HASH_CR_DINNE_Msk
#define HASH_CR_MDMAT_Pos         (13U)
#define HASH_CR_MDMAT_Msk         (0x1UL << HASH_CR_MDMAT_Pos)                 /*!< 0x00002000 */
#define HASH_CR_MDMAT             HASH_CR_MDMAT_Msk
#define HASH_CR_LKEY_Pos          (16U)
#define HASH_CR_LKEY_Msk          (0x1UL << HASH_CR_LKEY_Pos)                  /*!< 0x00010000 */
#define HASH_CR_LKEY              HASH_CR_LKEY_Msk

/******************  Bits definition for HASH_STR register  *******************/
#define HASH_STR_NBLW_Pos         (0U)
#define HASH_STR_NBLW_Msk         (0x1FUL << HASH_STR_NBLW_Pos)                /*!< 0x0000001F */
#define HASH_STR_NBLW             HASH_STR_NBLW_Msk
#define HASH_STR_NBLW_0           (0x01UL << HASH_STR_NBLW_Pos)                /*!< 0x00000001 */
#define HASH_STR_NBLW_1           (0x02UL << HASH_STR_NBLW_Pos)                /*!< 0x00000002 */
#define HASH_STR_NBLW_2           (0x04UL << HASH_STR_NBLW_Pos)                /*!< 0x00000004 */
#define HASH_STR_NBLW_3           (0x08UL << HASH_STR_NBLW_Pos)                /*!< 0x00000008 */
#define HASH_STR_NBLW_4           (0x10UL << HASH_STR_NBLW_Pos)                /*!< 0x00000010 */
#define HASH_STR_DCAL_Pos         (8U)
#define HASH_STR_DCAL_Msk         (0x1UL << HASH_STR_DCAL_Pos)                 /*!< 0x00000100 */
#define HASH_STR_DCAL             HASH_STR_DCAL_Msk

/******************  Bits definition for HASH_IMR register  *******************/
#define HASH_IMR_DINIE_Pos        (0U)
#define HASH_IMR_DINIE_Msk        (0x1UL << HASH_IMR_DINIE_Pos)                /*!< 0x00000001 */
#define HASH_IMR_DINIE            HASH_IMR_DINIE_Msk
#define HASH_IMR_DCIE_Pos         (1U)
#define HASH_IMR_DCIE_Msk         (0x1UL << HASH_IMR_DCIE_Pos)                 /*!< 0x00000002 */
#define HASH_IMR_DCIE             HASH_IMR_DCIE_Msk

/******************  Bits definition for HASH_SR register  ********************/
#define HASH_SR_DINIS_Pos         (0U)
#define HASH_SR_DINIS_Msk         (0x1UL << HASH_SR_DINIS_Pos)                 /*!< 0x00000001 */
#define HASH_SR_DINIS             HASH_SR_DINIS_Msk
#define HASH_SR_DCIS_Pos          (1U)
#define HASH_SR_DCIS_Msk          (0x1UL << HASH_SR_DCIS_Pos)                  /*!< 0x00000002 */
#define HASH_SR_DCIS              HASH_SR_DCIS_Msk
#define HASH_SR_DMAS_Pos          (2U)
#define HASH_SR_DMAS_Msk          (0x1UL << HASH_SR_DMAS_Pos)                  /*!< 0x00000004 */
#define HASH_SR_DMAS              HASH_SR_DMAS_Msk
#define HASH_SR_BUSY_Pos          (3U)
#define HASH_SR_BUSY_Msk          (0x1UL << HASH_SR_BUSY_Pos)                  /*!< 0x00000008 */
#define HASH_SR_BUSY              HASH_SR_BUSY_Msk


/******************************************************************************/
/*                                                                            */
/*                      Inter-integrated Circuit Interface (I2C)              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for I2C_CR1 register  ********************/
#define I2C_CR1_PE_Pos               (0U)
#define I2C_CR1_PE_Msk               (0x1UL << I2C_CR1_PE_Pos)                 /*!< 0x00000001 */
#define I2C_CR1_PE                   I2C_CR1_PE_Msk                            /*!< Peripheral enable */
#define I2C_CR1_TXIE_Pos             (1U)
#define I2C_CR1_TXIE_Msk             (0x1UL << I2C_CR1_TXIE_Pos)               /*!< 0x00000002 */
#define I2C_CR1_TXIE                 I2C_CR1_TXIE_Msk                          /*!< TX interrupt enable */
#define I2C_CR1_RXIE_Pos             (2U)
#define I2C_CR1_RXIE_Msk             (0x1UL << I2C_CR1_RXIE_Pos)               /*!< 0x00000004 */
#define I2C_CR1_RXIE                 I2C_CR1_RXIE_Msk                          /*!< RX interrupt enable */
#define I2C_CR1_ADDRIE_Pos           (3U)
#define I2C_CR1_ADDRIE_Msk           (0x1UL << I2C_CR1_ADDRIE_Pos)             /*!< 0x00000008 */
#define I2C_CR1_ADDRIE               I2C_CR1_ADDRIE_Msk                        /*!< Address match interrupt enable */
#define I2C_CR1_NACKIE_Pos           (4U)
#define I2C_CR1_NACKIE_Msk           (0x1UL << I2C_CR1_NACKIE_Pos)             /*!< 0x00000010 */
#define I2C_CR1_NACKIE               I2C_CR1_NACKIE_Msk                        /*!< NACK received interrupt enable */
#define I2C_CR1_STOPIE_Pos           (5U)
#define I2C_CR1_STOPIE_Msk           (0x1UL << I2C_CR1_STOPIE_Pos)             /*!< 0x00000020 */
#define I2C_CR1_STOPIE               I2C_CR1_STOPIE_Msk                        /*!< STOP detection interrupt enable */
#define I2C_CR1_TCIE_Pos             (6U)
#define I2C_CR1_TCIE_Msk             (0x1UL << I2C_CR1_TCIE_Pos)               /*!< 0x00000040 */
#define I2C_CR1_TCIE                 I2C_CR1_TCIE_Msk                          /*!< Transfer complete interrupt enable */
#define I2C_CR1_ERRIE_Pos            (7U)
#define I2C_CR1_ERRIE_Msk            (0x1UL << I2C_CR1_ERRIE_Pos)              /*!< 0x00000080 */
#define I2C_CR1_ERRIE                I2C_CR1_ERRIE_Msk                         /*!< Errors interrupt enable */
#define I2C_CR1_DNF_Pos              (8U)
#define I2C_CR1_DNF_Msk              (0xFUL << I2C_CR1_DNF_Pos)                /*!< 0x00000F00 */
#define I2C_CR1_DNF                  I2C_CR1_DNF_Msk                           /*!< Digital noise filter */
#define I2C_CR1_ANFOFF_Pos           (12U)
#define I2C_CR1_ANFOFF_Msk           (0x1UL << I2C_CR1_ANFOFF_Pos)             /*!< 0x00001000 */
#define I2C_CR1_ANFOFF               I2C_CR1_ANFOFF_Msk                        /*!< Analog noise filter OFF */
#define I2C_CR1_SWRST_Pos            (13U)
#define I2C_CR1_SWRST_Msk            (0x1UL << I2C_CR1_SWRST_Pos)              /*!< 0x00002000 */
#define I2C_CR1_SWRST                I2C_CR1_SWRST_Msk                         /*!< Software reset */
#define I2C_CR1_TXDMAEN_Pos          (14U)
#define I2C_CR1_TXDMAEN_Msk          (0x1UL << I2C_CR1_TXDMAEN_Pos)            /*!< 0x00004000 */
#define I2C_CR1_TXDMAEN              I2C_CR1_TXDMAEN_Msk                       /*!< DMA transmission requests enable */
#define I2C_CR1_RXDMAEN_Pos          (15U)
#define I2C_CR1_RXDMAEN_Msk          (0x1UL << I2C_CR1_RXDMAEN_Pos)            /*!< 0x00008000 */
#define I2C_CR1_RXDMAEN              I2C_CR1_RXDMAEN_Msk                       /*!< DMA reception requests enable */
#define I2C_CR1_SBC_Pos              (16U)
#define I2C_CR1_SBC_Msk              (0x1UL << I2C_CR1_SBC_Pos)                /*!< 0x00010000 */
#define I2C_CR1_SBC                  I2C_CR1_SBC_Msk                           /*!< Slave byte control */
#define I2C_CR1_NOSTRETCH_Pos        (17U)
#define I2C_CR1_NOSTRETCH_Msk        (0x1UL << I2C_CR1_NOSTRETCH_Pos)          /*!< 0x00020000 */
#define I2C_CR1_NOSTRETCH            I2C_CR1_NOSTRETCH_Msk                     /*!< Clock stretching disable */
#define I2C_CR1_WUPEN_Pos            (18U)
#define I2C_CR1_WUPEN_Msk            (0x1UL << I2C_CR1_WUPEN_Pos)              /*!< 0x00040000 */
#define I2C_CR1_WUPEN                I2C_CR1_WUPEN_Msk                         /*!< Wakeup from STOP enable */
#define I2C_CR1_GCEN_Pos             (19U)
#define I2C_CR1_GCEN_Msk             (0x1UL << I2C_CR1_GCEN_Pos)               /*!< 0x00080000 */
#define I2C_CR1_GCEN                 I2C_CR1_GCEN_Msk                          /*!< General call enable */
#define I2C_CR1_SMBHEN_Pos           (20U)
#define I2C_CR1_SMBHEN_Msk           (0x1UL << I2C_CR1_SMBHEN_Pos)             /*!< 0x00100000 */
#define I2C_CR1_SMBHEN               I2C_CR1_SMBHEN_Msk                        /*!< SMBus host address enable */
#define I2C_CR1_SMBDEN_Pos           (21U)
#define I2C_CR1_SMBDEN_Msk           (0x1UL << I2C_CR1_SMBDEN_Pos)             /*!< 0x00200000 */
#define I2C_CR1_SMBDEN               I2C_CR1_SMBDEN_Msk                        /*!< SMBus device default address enable */
#define I2C_CR1_ALERTEN_Pos          (22U)
#define I2C_CR1_ALERTEN_Msk          (0x1UL << I2C_CR1_ALERTEN_Pos)            /*!< 0x00400000 */
#define I2C_CR1_ALERTEN              I2C_CR1_ALERTEN_Msk                       /*!< SMBus alert enable */
#define I2C_CR1_PECEN_Pos            (23U)
#define I2C_CR1_PECEN_Msk            (0x1UL << I2C_CR1_PECEN_Pos)              /*!< 0x00800000 */
#define I2C_CR1_PECEN                I2C_CR1_PECEN_Msk                         /*!< PEC enable */

/******************  Bit definition for I2C_CR2 register  *********************/
#define I2C_CR2_SADD_Pos             (0U)
#define I2C_CR2_SADD_Msk             (0x3FFUL << I2C_CR2_SADD_Pos)             /*!< 0x000003FF */
#define I2C_CR2_SADD                 I2C_CR2_SADD_Msk                          /*!< Slave address (master mode) */
#define I2C_CR2_RD_WRN_Pos           (10U)
#define I2C_CR2_RD_WRN_Msk           (0x1UL << I2C_CR2_RD_WRN_Pos)             /*!< 0x00000400 */
#define I2C_CR2_RD_WRN               I2C_CR2_RD_WRN_Msk                        /*!< Transfer direction (master mode) */
#define I2C_CR2_ADD10_Pos            (11U)
#define I2C_CR2_ADD10_Msk            (0x1UL << I2C_CR2_ADD10_Pos)              /*!< 0x00000800 */
#define I2C_CR2_ADD10                I2C_CR2_ADD10_Msk                         /*!< 10-bit addressing mode (master mode) */
#define I2C_CR2_HEAD10R_Pos          (12U)
#define I2C_CR2_HEAD10R_Msk          (0x1UL << I2C_CR2_HEAD10R_Pos)            /*!< 0x00001000 */
#define I2C_CR2_HEAD10R              I2C_CR2_HEAD10R_Msk                       /*!< 10-bit address header only read direction (master mode) */
#define I2C_CR2_START_Pos            (13U)
#define I2C_CR2_START_Msk            (0x1UL << I2C_CR2_START_Pos)              /*!< 0x00002000 */
#define I2C_CR2_START                I2C_CR2_START_Msk                         /*!< START generation */
#define I2C_CR2_STOP_Pos             (14U)
#define I2C_CR2_STOP_Msk             (0x1UL << I2C_CR2_STOP_Pos)               /*!< 0x00004000 */
#define I2C_CR2_STOP                 I2C_CR2_STOP_Msk                          /*!< STOP generation (master mode) */
#define I2C_CR2_NACK_Pos             (15U)
#define I2C_CR2_NACK_Msk             (0x1UL << I2C_CR2_NACK_Pos)               /*!< 0x00008000 */
#define I2C_CR2_NACK                 I2C_CR2_NACK_Msk                          /*!< NACK generation (slave mode) */
#define I2C_CR2_NBYTES_Pos           (16U)
#define I2C_CR2_NBYTES_Msk           (0xFFUL << I2C_CR2_NBYTES_Pos)            /*!< 0x00FF0000 */
#define I2C_CR2_NBYTES               I2C_CR2_NBYTES_Msk                        /*!< Number of bytes */
#define I2C_CR2_RELOAD_Pos           (24U)
#define I2C_CR2_RELOAD_Msk           (0x1UL << I2C_CR2_RELOAD_Pos)             /*!< 0x01000000 */
#define I2C_CR2_RELOAD               I2C_CR2_RELOAD_Msk                        /*!< NBYTES reload mode */
#define I2C_CR2_AUTOEND_Pos          (25U)
#define I2C_CR2_AUTOEND_Msk          (0x1UL << I2C_CR2_AUTOEND_Pos)            /*!< 0x02000000 */
#define I2C_CR2_AUTOEND              I2C_CR2_AUTOEND_Msk                       /*!< Automatic end mode (master mode) */
#define I2C_CR2_PECBYTE_Pos          (26U)
#define I2C_CR2_PECBYTE_Msk          (0x1UL << I2C_CR2_PECBYTE_Pos)            /*!< 0x04000000 */
#define I2C_CR2_PECBYTE              I2C_CR2_PECBYTE_Msk                       /*!< Packet error checking byte */

/*******************  Bit definition for I2C_OAR1 register  *******************/
#define I2C_OAR1_OA1_Pos             (0U)
#define I2C_OAR1_OA1_Msk             (0x3FFUL << I2C_OAR1_OA1_Pos)             /*!< 0x000003FF */
#define I2C_OAR1_OA1                 I2C_OAR1_OA1_Msk                          /*!< Interface own address 1 */
#define I2C_OAR1_OA1MODE_Pos         (10U)
#define I2C_OAR1_OA1MODE_Msk         (0x1UL << I2C_OAR1_OA1MODE_Pos)           /*!< 0x00000400 */
#define I2C_OAR1_OA1MODE             I2C_OAR1_OA1MODE_Msk                      /*!< Own address 1 10-bit mode */
#define I2C_OAR1_OA1EN_Pos           (15U)
#define I2C_OAR1_OA1EN_Msk           (0x1UL << I2C_OAR1_OA1EN_Pos)             /*!< 0x00008000 */
#define I2C_OAR1_OA1EN               I2C_OAR1_OA1EN_Msk                        /*!< Own address 1 enable */

/*******************  Bit definition for I2C_OAR2 register  *******************/
#define I2C_OAR2_OA2_Pos             (1U)
#define I2C_OAR2_OA2_Msk             (0x7FUL << I2C_OAR2_OA2_Pos)              /*!< 0x000000FE */
#define I2C_OAR2_OA2                 I2C_OAR2_OA2_Msk                          /*!< Interface own address 2 */
#define I2C_OAR2_OA2MSK_Pos          (8U)
#define I2C_OAR2_OA2MSK_Msk          (0x7UL << I2C_OAR2_OA2MSK_Pos)            /*!< 0x00000700 */
#define I2C_OAR2_OA2MSK              I2C_OAR2_OA2MSK_Msk                       /*!< Own address 2 masks */
#define I2C_OAR2_OA2NOMASK           (0x00000000UL)                            /*!< No mask                                        */
#define I2C_OAR2_OA2MASK01_Pos       (8U)
#define I2C_OAR2_OA2MASK01_Msk       (0x1UL << I2C_OAR2_OA2MASK01_Pos)         /*!< 0x00000100 */
#define I2C_OAR2_OA2MASK01           I2C_OAR2_OA2MASK01_Msk                    /*!< OA2[1] is masked, Only OA2[7:2] are compared   */
#define I2C_OAR2_OA2MASK02_Pos       (9U)
#define I2C_OAR2_OA2MASK02_Msk       (0x1UL << I2C_OAR2_OA2MASK02_Pos)         /*!< 0x00000200 */
#define I2C_OAR2_OA2MASK02           I2C_OAR2_OA2MASK02_Msk                    /*!< OA2[2:1] is masked, Only OA2[7:3] are compared */
#define I2C_OAR2_OA2MASK03_Pos       (8U)
#define I2C_OAR2_OA2MASK03_Msk       (0x3UL << I2C_OAR2_OA2MASK03_Pos)         /*!< 0x00000300 */
#define I2C_OAR2_OA2MASK03           I2C_OAR2_OA2MASK03_Msk                    /*!< OA2[3:1] is masked, Only OA2[7:4] are compared */
#define I2C_OAR2_OA2MASK04_Pos       (10U)
#define I2C_OAR2_OA2MASK04_Msk       (0x1UL << I2C_OAR2_OA2MASK04_Pos)         /*!< 0x00000400 */
#define I2C_OAR2_OA2MASK04           I2C_OAR2_OA2MASK04_Msk                    /*!< OA2[4:1] is masked, Only OA2[7:5] are compared */
#define I2C_OAR2_OA2MASK05_Pos       (8U)
#define I2C_OAR2_OA2MASK05_Msk       (0x5UL << I2C_OAR2_OA2MASK05_Pos)         /*!< 0x00000500 */
#define I2C_OAR2_OA2MASK05           I2C_OAR2_OA2MASK05_Msk                    /*!< OA2[5:1] is masked, Only OA2[7:6] are compared */
#define I2C_OAR2_OA2MASK06_Pos       (9U)
#define I2C_OAR2_OA2MASK06_Msk       (0x3UL << I2C_OAR2_OA2MASK06_Pos)         /*!< 0x00000600 */
#define I2C_OAR2_OA2MASK06           I2C_OAR2_OA2MASK06_Msk                    /*!< OA2[6:1] is masked, Only OA2[7] are compared   */
#define I2C_OAR2_OA2MASK07_Pos       (8U)
#define I2C_OAR2_OA2MASK07_Msk       (0x7UL << I2C_OAR2_OA2MASK07_Pos)         /*!< 0x00000700 */
#define I2C_OAR2_OA2MASK07           I2C_OAR2_OA2MASK07_Msk                    /*!< OA2[7:1] is masked, No comparison is done      */
#define I2C_OAR2_OA2EN_Pos           (15U)
#define I2C_OAR2_OA2EN_Msk           (0x1UL << I2C_OAR2_OA2EN_Pos)             /*!< 0x00008000 */
#define I2C_OAR2_OA2EN               I2C_OAR2_OA2EN_Msk                        /*!< Own address 2 enable */

/*******************  Bit definition for I2C_TIMINGR register *****************/
#define I2C_TIMINGR_SCLL_Pos         (0U)
#define I2C_TIMINGR_SCLL_Msk         (0xFFUL << I2C_TIMINGR_SCLL_Pos)          /*!< 0x000000FF */
#define I2C_TIMINGR_SCLL             I2C_TIMINGR_SCLL_Msk                      /*!< SCL low period (master mode) */
#define I2C_TIMINGR_SCLH_Pos         (8U)
#define I2C_TIMINGR_SCLH_Msk         (0xFFUL << I2C_TIMINGR_SCLH_Pos)          /*!< 0x0000FF00 */
#define I2C_TIMINGR_SCLH             I2C_TIMINGR_SCLH_Msk                      /*!< SCL high period (master mode) */
#define I2C_TIMINGR_SDADEL_Pos       (16U)
#define I2C_TIMINGR_SDADEL_Msk       (0xFUL << I2C_TIMINGR_SDADEL_Pos)         /*!< 0x000F0000 */
#define I2C_TIMINGR_SDADEL           I2C_TIMINGR_SDADEL_Msk                    /*!< Data hold time */
#define I2C_TIMINGR_SCLDEL_Pos       (20U)
#define I2C_TIMINGR_SCLDEL_Msk       (0xFUL << I2C_TIMINGR_SCLDEL_Pos)         /*!< 0x00F00000 */
#define I2C_TIMINGR_SCLDEL           I2C_TIMINGR_SCLDEL_Msk                    /*!< Data setup time */
#define I2C_TIMINGR_PRESC_Pos        (28U)
#define I2C_TIMINGR_PRESC_Msk        (0xFUL << I2C_TIMINGR_PRESC_Pos)          /*!< 0xF0000000 */
#define I2C_TIMINGR_PRESC            I2C_TIMINGR_PRESC_Msk                     /*!< Timings prescaler */

/******************* Bit definition for I2C_TIMEOUTR register *****************/
#define I2C_TIMEOUTR_TIMEOUTA_Pos    (0U)
#define I2C_TIMEOUTR_TIMEOUTA_Msk    (0xFFFUL << I2C_TIMEOUTR_TIMEOUTA_Pos)    /*!< 0x00000FFF */
#define I2C_TIMEOUTR_TIMEOUTA        I2C_TIMEOUTR_TIMEOUTA_Msk                 /*!< Bus timeout A */
#define I2C_TIMEOUTR_TIDLE_Pos       (12U)
#define I2C_TIMEOUTR_TIDLE_Msk       (0x1UL << I2C_TIMEOUTR_TIDLE_Pos)         /*!< 0x00001000 */
#define I2C_TIMEOUTR_TIDLE           I2C_TIMEOUTR_TIDLE_Msk                    /*!< Idle clock timeout detection */
#define I2C_TIMEOUTR_TIMOUTEN_Pos    (15U)
#define I2C_TIMEOUTR_TIMOUTEN_Msk    (0x1UL << I2C_TIMEOUTR_TIMOUTEN_Pos)      /*!< 0x00008000 */
#define I2C_TIMEOUTR_TIMOUTEN        I2C_TIMEOUTR_TIMOUTEN_Msk                 /*!< Clock timeout enable */
#define I2C_TIMEOUTR_TIMEOUTB_Pos    (16U)
#define I2C_TIMEOUTR_TIMEOUTB_Msk    (0xFFFUL << I2C_TIMEOUTR_TIMEOUTB_Pos)    /*!< 0x0FFF0000 */
#define I2C_TIMEOUTR_TIMEOUTB        I2C_TIMEOUTR_TIMEOUTB_Msk                 /*!< Bus timeout B*/
#define I2C_TIMEOUTR_TEXTEN_Pos      (31U)
#define I2C_TIMEOUTR_TEXTEN_Msk      (0x1UL << I2C_TIMEOUTR_TEXTEN_Pos)        /*!< 0x80000000 */
#define I2C_TIMEOUTR_TEXTEN          I2C_TIMEOUTR_TEXTEN_Msk                   /*!< Extended clock timeout enable */

/******************  Bit definition for I2C_ISR register  *********************/
#define I2C_ISR_TXE_Pos              (0U)
#define I2C_ISR_TXE_Msk              (0x1UL << I2C_ISR_TXE_Pos)                /*!< 0x00000001 */
#define I2C_ISR_TXE                  I2C_ISR_TXE_Msk                           /*!< Transmit data register empty */
#define I2C_ISR_TXIS_Pos             (1U)
#define I2C_ISR_TXIS_Msk             (0x1UL << I2C_ISR_TXIS_Pos)               /*!< 0x00000002 */
#define I2C_ISR_TXIS                 I2C_ISR_TXIS_Msk                          /*!< Transmit interrupt status */
#define I2C_ISR_RXNE_Pos             (2U)
#define I2C_ISR_RXNE_Msk             (0x1UL << I2C_ISR_RXNE_Pos)               /*!< 0x00000004 */
#define I2C_ISR_RXNE                 I2C_ISR_RXNE_Msk                          /*!< Receive data register not empty */
#define I2C_ISR_ADDR_Pos             (3U)
#define I2C_ISR_ADDR_Msk             (0x1UL << I2C_ISR_ADDR_Pos)               /*!< 0x00000008 */
#define I2C_ISR_ADDR                 I2C_ISR_ADDR_Msk                          /*!< Address matched (slave mode)*/
#define I2C_ISR_NACKF_Pos            (4U)
#define I2C_ISR_NACKF_Msk            (0x1UL << I2C_ISR_NACKF_Pos)              /*!< 0x00000010 */
#define I2C_ISR_NACKF                I2C_ISR_NACKF_Msk                         /*!< NACK received flag */
#define I2C_ISR_STOPF_Pos            (5U)
#define I2C_ISR_STOPF_Msk            (0x1UL << I2C_ISR_STOPF_Pos)              /*!< 0x00000020 */
#define I2C_ISR_STOPF                I2C_ISR_STOPF_Msk                         /*!< STOP detection flag */
#define I2C_ISR_TC_Pos               (6U)
#define I2C_ISR_TC_Msk               (0x1UL << I2C_ISR_TC_Pos)                 /*!< 0x00000040 */
#define I2C_ISR_TC                   I2C_ISR_TC_Msk                            /*!< Transfer complete (master mode) */
#define I2C_ISR_TCR_Pos              (7U)
#define I2C_ISR_TCR_Msk              (0x1UL << I2C_ISR_TCR_Pos)                /*!< 0x00000080 */
#define I2C_ISR_TCR                  I2C_ISR_TCR_Msk                           /*!< Transfer complete reload */
#define I2C_ISR_BERR_Pos             (8U)
#define I2C_ISR_BERR_Msk             (0x1UL << I2C_ISR_BERR_Pos)               /*!< 0x00000100 */
#define I2C_ISR_BERR                 I2C_ISR_BERR_Msk                          /*!< Bus error */
#define I2C_ISR_ARLO_Pos             (9U)
#define I2C_ISR_ARLO_Msk             (0x1UL << I2C_ISR_ARLO_Pos)               /*!< 0x00000200 */
#define I2C_ISR_ARLO                 I2C_ISR_ARLO_Msk                          /*!< Arbitration lost */
#define I2C_ISR_OVR_Pos              (10U)
#define I2C_ISR_OVR_Msk              (0x1UL << I2C_ISR_OVR_Pos)                /*!< 0x00000400 */
#define I2C_ISR_OVR                  I2C_ISR_OVR_Msk                           /*!< Overrun/Underrun */
#define I2C_ISR_PECERR_Pos           (11U)
#define I2C_ISR_PECERR_Msk           (0x1UL << I2C_ISR_PECERR_Pos)             /*!< 0x00000800 */
#define I2C_ISR_PECERR               I2C_ISR_PECERR_Msk                        /*!< PEC error in reception */
#define I2C_ISR_TIMEOUT_Pos          (12U)
#define I2C_ISR_TIMEOUT_Msk          (0x1UL << I2C_ISR_TIMEOUT_Pos)            /*!< 0x00001000 */
#define I2C_ISR_TIMEOUT              I2C_ISR_TIMEOUT_Msk                       /*!< Timeout or Tlow detection flag */
#define I2C_ISR_ALERT_Pos            (13U)
#define I2C_ISR_ALERT_Msk            (0x1UL << I2C_ISR_ALERT_Pos)              /*!< 0x00002000 */
#define I2C_ISR_ALERT                I2C_ISR_ALERT_Msk                         /*!< SMBus alert */
#define I2C_ISR_BUSY_Pos             (15U)
#define I2C_ISR_BUSY_Msk             (0x1UL << I2C_ISR_BUSY_Pos)               /*!< 0x00008000 */
#define I2C_ISR_BUSY                 I2C_ISR_BUSY_Msk                          /*!< Bus busy */
#define I2C_ISR_DIR_Pos              (16U)
#define I2C_ISR_DIR_Msk              (0x1UL << I2C_ISR_DIR_Pos)                /*!< 0x00010000 */
#define I2C_ISR_DIR                  I2C_ISR_DIR_Msk                           /*!< Transfer direction (slave mode) */
#define I2C_ISR_ADDCODE_Pos          (17U)
#define I2C_ISR_ADDCODE_Msk          (0x7FUL << I2C_ISR_ADDCODE_Pos)           /*!< 0x00FE0000 */
#define I2C_ISR_ADDCODE              I2C_ISR_ADDCODE_Msk                       /*!< Address match code (slave mode) */

/******************  Bit definition for I2C_ICR register  *********************/
#define I2C_ICR_ADDRCF_Pos           (3U)
#define I2C_ICR_ADDRCF_Msk           (0x1UL << I2C_ICR_ADDRCF_Pos)             /*!< 0x00000008 */
#define I2C_ICR_ADDRCF               I2C_ICR_ADDRCF_Msk                        /*!< Address matched clear flag */
#define I2C_ICR_NACKCF_Pos           (4U)
#define I2C_ICR_NACKCF_Msk           (0x1UL << I2C_ICR_NACKCF_Pos)             /*!< 0x00000010 */
#define I2C_ICR_NACKCF               I2C_ICR_NACKCF_Msk                        /*!< NACK clear flag */
#define I2C_ICR_STOPCF_Pos           (5U)
#define I2C_ICR_STOPCF_Msk           (0x1UL << I2C_ICR_STOPCF_Pos)             /*!< 0x00000020 */
#define I2C_ICR_STOPCF               I2C_ICR_STOPCF_Msk                        /*!< STOP detection clear flag */
#define I2C_ICR_BERRCF_Pos           (8U)
#define I2C_ICR_BERRCF_Msk           (0x1UL << I2C_ICR_BERRCF_Pos)             /*!< 0x00000100 */
#define I2C_ICR_BERRCF               I2C_ICR_BERRCF_Msk                        /*!< Bus error clear flag */
#define I2C_ICR_ARLOCF_Pos           (9U)
#define I2C_ICR_ARLOCF_Msk           (0x1UL << I2C_ICR_ARLOCF_Pos)             /*!< 0x00000200 */
#define I2C_ICR_ARLOCF               I2C_ICR_ARLOCF_Msk                        /*!< Arbitration lost clear flag */
#define I2C_ICR_OVRCF_Pos            (10U)
#define I2C_ICR_OVRCF_Msk            (0x1UL << I2C_ICR_OVRCF_Pos)              /*!< 0x00000400 */
#define I2C_ICR_OVRCF                I2C_ICR_OVRCF_Msk                         /*!< Overrun/Underrun clear flag */
#define I2C_ICR_PECCF_Pos            (11U)
#define I2C_ICR_PECCF_Msk            (0x1UL << I2C_ICR_PECCF_Pos)              /*!< 0x00000800 */
#define I2C_ICR_PECCF                I2C_ICR_PECCF_Msk                         /*!< PAC error clear flag */
#define I2C_ICR_TIMOUTCF_Pos         (12U)
#define I2C_ICR_TIMOUTCF_Msk         (0x1UL << I2C_ICR_TIMOUTCF_Pos)           /*!< 0x00001000 */
#define I2C_ICR_TIMOUTCF             I2C_ICR_TIMOUTCF_Msk                      /*!< Timeout clear flag */
#define I2C_ICR_ALERTCF_Pos          (13U)
#define I2C_ICR_ALERTCF_Msk          (0x1UL << I2C_ICR_ALERTCF_Pos)            /*!< 0x00002000 */
#define I2C_ICR_ALERTCF              I2C_ICR_ALERTCF_Msk                       /*!< Alert clear flag */

/******************  Bit definition for I2C_PECR register  ********************/
#define I2C_PECR_PEC_Pos             (0U)
#define I2C_PECR_PEC_Msk             (0xFFUL << I2C_PECR_PEC_Pos)              /*!< 0x000000FF */
#define I2C_PECR_PEC                 I2C_PECR_PEC_Msk                          /*!< PEC register */

/******************  Bit definition for I2C_RXDR register  ********************/
#define I2C_RXDR_RXDATA_Pos          (0U)
#define I2C_RXDR_RXDATA_Msk          (0xFFUL << I2C_RXDR_RXDATA_Pos)           /*!< 0x000000FF */
#define I2C_RXDR_RXDATA              I2C_RXDR_RXDATA_Msk                       /*!< 8-bit receive data */

/******************  Bit definition for I2C_TXDR register  ********************/
#define I2C_TXDR_TXDATA_Pos          (0U)
#define I2C_TXDR_TXDATA_Msk          (0xFFUL << I2C_TXDR_TXDATA_Pos)           /*!< 0x000000FF */
#define I2C_TXDR_TXDATA              I2C_TXDR_TXDATA_Msk                       /*!< 8-bit transmit data */

/******************************************************************************/
/*                                                                            */
/*                                 ICACHE                                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for ICACHE_CR register  *******************/
#define ICACHE_CR_EN_Pos               (0U)
#define ICACHE_CR_EN_Msk               (0x1UL << ICACHE_CR_EN_Pos)             /*!< 0x00000001 */
#define ICACHE_CR_EN                   ICACHE_CR_EN_Msk                        /*!< Enable */
#define ICACHE_CR_CACHEINV_Pos         (1U)
#define ICACHE_CR_CACHEINV_Msk         (0x1UL << ICACHE_CR_CACHEINV_Pos)       /*!< 0x00000002 */
#define ICACHE_CR_CACHEINV             ICACHE_CR_CACHEINV_Msk                  /*!< Cache invalidation */
#define ICACHE_CR_WAYSEL_Pos           (2U)
#define ICACHE_CR_WAYSEL_Msk           (0x1UL << ICACHE_CR_WAYSEL_Pos)         /*!< 0x00000004 */
#define ICACHE_CR_WAYSEL               ICACHE_CR_WAYSEL_Msk                    /*!< Ways selection */
#define ICACHE_CR_HITMEN_Pos           (16U)
#define ICACHE_CR_HITMEN_Msk           (0x1UL << ICACHE_CR_HITMEN_Pos)         /*!< 0x00010000 */
#define ICACHE_CR_HITMEN               ICACHE_CR_HITMEN_Msk                    /*!< Hit monitor enable */
#define ICACHE_CR_MISSMEN_Pos          (17U)
#define ICACHE_CR_MISSMEN_Msk          (0x1UL << ICACHE_CR_MISSMEN_Pos)        /*!< 0x00020000 */
#define ICACHE_CR_MISSMEN              ICACHE_CR_MISSMEN_Msk                   /*!< Miss monitor enable */
#define ICACHE_CR_HITMRST_Pos          (18U)
#define ICACHE_CR_HITMRST_Msk          (0x1UL << ICACHE_CR_HITMRST_Pos)        /*!< 0x00040000 */
#define ICACHE_CR_HITMRST              ICACHE_CR_HITMRST_Msk                   /*!< Hit monitor reset */
#define ICACHE_CR_MISSMRST_Pos         (19U)
#define ICACHE_CR_MISSMRST_Msk         (0x1UL << ICACHE_CR_MISSMRST_Pos)       /*!< 0x00080000 */
#define ICACHE_CR_MISSMRST             ICACHE_CR_MISSMRST_Msk                  /*!< Miss monitor reset */

/******************  Bit definition for ICACHE_SR register  *******************/
#define ICACHE_SR_BUSYF_Pos            (0U)
#define ICACHE_SR_BUSYF_Msk            (0x1UL << ICACHE_SR_BUSYF_Pos)          /*!< 0x00000001 */
#define ICACHE_SR_BUSYF                ICACHE_SR_BUSYF_Msk                     /*!< Busy flag */
#define ICACHE_SR_BSYENDF_Pos          (1U)
#define ICACHE_SR_BSYENDF_Msk          (0x1UL << ICACHE_SR_BSYENDF_Pos)        /*!< 0x00000002 */
#define ICACHE_SR_BSYENDF              ICACHE_SR_BSYENDF_Msk                   /*!< Busy end flag */
#define ICACHE_SR_ERRF_Pos             (2U)
#define ICACHE_SR_ERRF_Msk             (0x1UL << ICACHE_SR_ERRF_Pos)           /*!< 0x00000004 */
#define ICACHE_SR_ERRF                 ICACHE_SR_ERRF_Msk                      /*!< Cache error flag */

/******************  Bit definition for ICACHE_IER register  ******************/
#define ICACHE_IER_BSYENDIE_Pos        (1U)
#define ICACHE_IER_BSYENDIE_Msk        (0x1UL << ICACHE_IER_BSYENDIE_Pos)      /*!< 0x00000002 */
#define ICACHE_IER_BSYENDIE            ICACHE_IER_BSYENDIE_Msk                 /*!< Busy end interrupt enable */
#define ICACHE_IER_ERRIE_Pos           (2U)
#define ICACHE_IER_ERRIE_Msk           (0x1UL << ICACHE_IER_ERRIE_Pos)         /*!< 0x00000004 */
#define ICACHE_IER_ERRIE               ICACHE_IER_ERRIE_Msk                    /*!< Cache error interrupt enable */

/******************  Bit definition for ICACHE_FCR register  ******************/
#define ICACHE_FCR_CBSYENDF_Pos        (1U)
#define ICACHE_FCR_CBSYENDF_Msk        (0x1UL << ICACHE_FCR_CBSYENDF_Pos)      /*!< 0x00000002 */
#define ICACHE_FCR_CBSYENDF            ICACHE_FCR_CBSYENDF_Msk                 /*!< Busy end flag clear */
#define ICACHE_FCR_CERRF_Pos           (2U)
#define ICACHE_FCR_CERRF_Msk           (0x1UL << ICACHE_FCR_CERRF_Pos)         /*!< 0x00000004 */
#define ICACHE_FCR_CERRF               ICACHE_FCR_CERRF_Msk                    /*!< Cache error flag clear */

/******************  Bit definition for ICACHE_HMONR register  ****************/
#define ICACHE_HMONR_HITMON_Pos         (0U)
#define ICACHE_HMONR_HITMON_Msk         (0xFFFFFFFFUL << ICACHE_HMONR_HITMON_Pos)/*!< 0xFFFFFFFF */
#define ICACHE_HMONR_HITMON             ICACHE_HMONR_HITMON_Msk                /*!< Cache hit monitor register */

/******************  Bit definition for ICACHE_MMONR register  ****************/
#define ICACHE_MMONR_MISSMON_Pos        (0U)
#define ICACHE_MMONR_MISSMON_Msk        (0xFFFFUL << ICACHE_MMONR_MISSMON_Pos) /*!< 0x0000FFFF */
#define ICACHE_MMONR_MISSMON            ICACHE_MMONR_MISSMON_Msk               /*!< Cache miss monitor register */

/******************  Bit definition for ICACHE_CRRx register  *****************/
#define ICACHE_CRRx_BASEADDR_Pos        (0U)
#define ICACHE_CRRx_BASEADDR_Msk        (0xFFUL << ICACHE_CRRx_BASEADDR_Pos) /*!< 0x000000FF */
#define ICACHE_CRRx_BASEADDR            ICACHE_CRRx_BASEADDR_Msk               /*!< Base address of region X to remap */
#define ICACHE_CRRx_RSIZE_Pos           (9U)
#define ICACHE_CRRx_RSIZE_Msk           (0x7UL << ICACHE_CRRx_RSIZE_Pos)       /*!< 0x00000E00 */
#define ICACHE_CRRx_RSIZE               ICACHE_CRRx_RSIZE_Msk                  /*!< Region X size */
#define ICACHE_CRRx_RSIZE_0             (0x1UL << ICACHE_CRRx_RSIZE_Pos)       /*!< 0x00000200 */
#define ICACHE_CRRx_RSIZE_1             (0x2UL << ICACHE_CRRx_RSIZE_Pos)       /*!< 0x00000400 */
#define ICACHE_CRRx_RSIZE_2             (0x4UL << ICACHE_CRRx_RSIZE_Pos)       /*!< 0x00000800 */
#define ICACHE_CRRx_REN_Pos             (15U)
#define ICACHE_CRRx_REN_Msk             (0x1UL << ICACHE_CRRx_REN_Pos)         /*!< 0x00008000 */
#define ICACHE_CRRx_REN                 ICACHE_CRRx_REN_Msk                    /*!< Region X enable */
#define ICACHE_CRRx_REMAPADDR_Pos       (16U)
#define ICACHE_CRRx_REMAPADDR_Msk       (0x7FFUL << ICACHE_CRRx_REMAPADDR_Pos) /*!< 0x07FF0000 */
#define ICACHE_CRRx_REMAPADDR           ICACHE_CRRx_REMAPADDR_Msk              /*!< Remap address of Region X to be remapped */
#define ICACHE_CRRx_MSTSEL_Pos          (28U)
#define ICACHE_CRRx_MSTSEL_Msk          (0x1UL << ICACHE_CRRx_MSTSEL_Pos)      /*!< 0x10000000 */
#define ICACHE_CRRx_MSTSEL              ICACHE_CRRx_MSTSEL_Msk                 /*!< Region X AHB cache master selection */
#define ICACHE_CRRx_HBURST_Pos          (31U)
#define ICACHE_CRRx_HBURST_Msk          (0x1UL << ICACHE_CRRx_HBURST_Pos)      /*!< 0x80000000 */
#define ICACHE_CRRx_HBURST              ICACHE_CRRx_HBURST_Msk                 /*!< Region X output burst type */

/******************************************************************************/
/*                                                                            */
/*                        Independent WATCHDOG (IWDG)                         */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_KR_KEY_Pos                (0U)
#define IWDG_KR_KEY_Msk                (0xFFFFUL << IWDG_KR_KEY_Pos)           /*!< 0x0000FFFF */
#define IWDG_KR_KEY                    IWDG_KR_KEY_Msk                         /*!<Key value (write only, read 0000h)  */

/*******************  Bit definition for IWDG_PR register  ********************/
#define IWDG_PR_PR_Pos                 (0U)
#define IWDG_PR_PR_Msk                 (0x7UL << IWDG_PR_PR_Pos)               /*!< 0x00000007 */
#define IWDG_PR_PR                     IWDG_PR_PR_Msk                          /*!<PR[2:0] (Prescaler divider)         */
#define IWDG_PR_PR_0                   (0x1UL << IWDG_PR_PR_Pos)               /*!< 0x00000001 */
#define IWDG_PR_PR_1                   (0x2UL << IWDG_PR_PR_Pos)               /*!< 0x00000002 */
#define IWDG_PR_PR_2                   (0x4UL << IWDG_PR_PR_Pos)               /*!< 0x00000004 */

/*******************  Bit definition for IWDG_RLR register  *******************/
#define IWDG_RLR_RL_Pos                (0U)
#define IWDG_RLR_RL_Msk                (0xFFFUL << IWDG_RLR_RL_Pos)            /*!< 0x00000FFF */
#define IWDG_RLR_RL                    IWDG_RLR_RL_Msk                         /*!<Watchdog counter reload value        */

/*******************  Bit definition for IWDG_SR register  ********************/
#define IWDG_SR_PVU_Pos                (0U)
#define IWDG_SR_PVU_Msk                (0x1UL << IWDG_SR_PVU_Pos)              /*!< 0x00000001 */
#define IWDG_SR_PVU                    IWDG_SR_PVU_Msk                         /*!< Watchdog prescaler value update */
#define IWDG_SR_RVU_Pos                (1U)
#define IWDG_SR_RVU_Msk                (0x1UL << IWDG_SR_RVU_Pos)              /*!< 0x00000002 */
#define IWDG_SR_RVU                    IWDG_SR_RVU_Msk                         /*!< Watchdog counter reload value update */
#define IWDG_SR_WVU_Pos                (2U)
#define IWDG_SR_WVU_Msk                (0x1UL << IWDG_SR_WVU_Pos)              /*!< 0x00000004 */
#define IWDG_SR_WVU                    IWDG_SR_WVU_Msk                         /*!< Watchdog counter window value update */

/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_WINR_WIN_Pos              (0U)
#define IWDG_WINR_WIN_Msk              (0xFFFUL << IWDG_WINR_WIN_Pos)          /*!< 0x00000FFF */
#define IWDG_WINR_WIN                  IWDG_WINR_WIN_Msk                       /*!< Watchdog counter window value */

/******************************************************************************/
/*                                                                            */
/*                         Low Power Timer (LPTIM)                            */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for LPTIM_ISR register  *******************/
#define LPTIM_ISR_CMPM_Pos          (0U)
#define LPTIM_ISR_CMPM_Msk          (0x1UL << LPTIM_ISR_CMPM_Pos)              /*!< 0x00000001 */
#define LPTIM_ISR_CMPM              LPTIM_ISR_CMPM_Msk                         /*!< Compare match */
#define LPTIM_ISR_ARRM_Pos          (1U)
#define LPTIM_ISR_ARRM_Msk          (0x1UL << LPTIM_ISR_ARRM_Pos)              /*!< 0x00000002 */
#define LPTIM_ISR_ARRM              LPTIM_ISR_ARRM_Msk                         /*!< Autoreload match */
#define LPTIM_ISR_EXTTRIG_Pos       (2U)
#define LPTIM_ISR_EXTTRIG_Msk       (0x1UL << LPTIM_ISR_EXTTRIG_Pos)           /*!< 0x00000004 */
#define LPTIM_ISR_EXTTRIG           LPTIM_ISR_EXTTRIG_Msk                      /*!< External trigger edge event */
#define LPTIM_ISR_CMPOK_Pos         (3U)
#define LPTIM_ISR_CMPOK_Msk         (0x1UL << LPTIM_ISR_CMPOK_Pos)             /*!< 0x00000008 */
#define LPTIM_ISR_CMPOK             LPTIM_ISR_CMPOK_Msk                        /*!< Compare register update OK */
#define LPTIM_ISR_ARROK_Pos         (4U)
#define LPTIM_ISR_ARROK_Msk         (0x1UL << LPTIM_ISR_ARROK_Pos)             /*!< 0x00000010 */
#define LPTIM_ISR_ARROK             LPTIM_ISR_ARROK_Msk                        /*!< Autoreload register update OK */
#define LPTIM_ISR_UP_Pos            (5U)
#define LPTIM_ISR_UP_Msk            (0x1UL << LPTIM_ISR_UP_Pos)                /*!< 0x00000020 */
#define LPTIM_ISR_UP                LPTIM_ISR_UP_Msk                           /*!< Counter direction change down to up */
#define LPTIM_ISR_DOWN_Pos          (6U)
#define LPTIM_ISR_DOWN_Msk          (0x1UL << LPTIM_ISR_DOWN_Pos)              /*!< 0x00000040 */
#define LPTIM_ISR_DOWN              LPTIM_ISR_DOWN_Msk                         /*!< Counter direction change up to down */
#define LPTIM_ISR_UE_Pos            (7U)
#define LPTIM_ISR_UE_Msk            (0x1UL << LPTIM_ISR_UE_Pos)                /*!< 0x00000080 */
#define LPTIM_ISR_UE                LPTIM_ISR_UE_Msk                           /*!< Update event occurrence */
#define LPTIM_ISR_REPOK_Pos         (8U)
#define LPTIM_ISR_REPOK_Msk         (0x1UL << LPTIM_ISR_REPOK_Pos)             /*!< 0x00000100 */
#define LPTIM_ISR_REPOK             LPTIM_ISR_REPOK_Msk                        /*!< Repetition register update OK */

/******************  Bit definition for LPTIM_ICR register  *******************/
#define LPTIM_ICR_CMPMCF_Pos        (0U)
#define LPTIM_ICR_CMPMCF_Msk        (0x1UL << LPTIM_ICR_CMPMCF_Pos)            /*!< 0x00000001 */
#define LPTIM_ICR_CMPMCF            LPTIM_ICR_CMPMCF_Msk                       /*!< Compare match Clear Flag */
#define LPTIM_ICR_ARRMCF_Pos        (1U)
#define LPTIM_ICR_ARRMCF_Msk        (0x1UL << LPTIM_ICR_ARRMCF_Pos)            /*!< 0x00000002 */
#define LPTIM_ICR_ARRMCF            LPTIM_ICR_ARRMCF_Msk                       /*!< Autoreload match Clear Flag */
#define LPTIM_ICR_EXTTRIGCF_Pos     (2U)
#define LPTIM_ICR_EXTTRIGCF_Msk     (0x1UL << LPTIM_ICR_EXTTRIGCF_Pos)         /*!< 0x00000004 */
#define LPTIM_ICR_EXTTRIGCF         LPTIM_ICR_EXTTRIGCF_Msk                    /*!< External trigger edge event Clear Flag */
#define LPTIM_ICR_CMPOKCF_Pos       (3U)
#define LPTIM_ICR_CMPOKCF_Msk       (0x1UL << LPTIM_ICR_CMPOKCF_Pos)           /*!< 0x00000008 */
#define LPTIM_ICR_CMPOKCF           LPTIM_ICR_CMPOKCF_Msk                      /*!< Compare register update OK Clear Flag */
#define LPTIM_ICR_ARROKCF_Pos       (4U)
#define LPTIM_ICR_ARROKCF_Msk       (0x1UL << LPTIM_ICR_ARROKCF_Pos)           /*!< 0x00000010 */
#define LPTIM_ICR_ARROKCF           LPTIM_ICR_ARROKCF_Msk                      /*!< Autoreload register update OK Clear Flag */
#define LPTIM_ICR_UPCF_Pos          (5U)
#define LPTIM_ICR_UPCF_Msk          (0x1UL << LPTIM_ICR_UPCF_Pos)              /*!< 0x00000020 */
#define LPTIM_ICR_UPCF              LPTIM_ICR_UPCF_Msk                         /*!< Counter direction change down to up Clear Flag */
#define LPTIM_ICR_DOWNCF_Pos        (6U)
#define LPTIM_ICR_DOWNCF_Msk        (0x1UL << LPTIM_ICR_DOWNCF_Pos)            /*!< 0x00000040 */
#define LPTIM_ICR_DOWNCF            LPTIM_ICR_DOWNCF_Msk                       /*!< Counter direction change up to down Clear Flag */
#define LPTIM_ICR_UECF_Pos          (7U)
#define LPTIM_ICR_UECF_Msk          (0x1UL << LPTIM_ICR_UECF_Pos)              /*!< 0x00000080 */
#define LPTIM_ICR_UECF              LPTIM_ICR_UECF_Msk                         /*!< Update event Clear Flag */
#define LPTIM_ICR_REPOKCF_Pos       (8U)
#define LPTIM_ICR_REPOKCF_Msk       (0x1UL << LPTIM_ICR_REPOKCF_Pos)           /*!< 0x00000100 */
#define LPTIM_ICR_REPOKCF           LPTIM_ICR_REPOKCF_Msk                      /*!< Repetition register update OK Clear Flag */

/******************  Bit definition for LPTIM_IER register ********************/
#define LPTIM_IER_CMPMIE_Pos        (0U)
#define LPTIM_IER_CMPMIE_Msk        (0x1UL << LPTIM_IER_CMPMIE_Pos)            /*!< 0x00000001 */
#define LPTIM_IER_CMPMIE            LPTIM_IER_CMPMIE_Msk                       /*!< Compare match Interrupt Enable */
#define LPTIM_IER_ARRMIE_Pos        (1U)
#define LPTIM_IER_ARRMIE_Msk        (0x1UL << LPTIM_IER_ARRMIE_Pos)            /*!< 0x00000002 */
#define LPTIM_IER_ARRMIE            LPTIM_IER_ARRMIE_Msk                       /*!< Autoreload match Interrupt Enable */
#define LPTIM_IER_EXTTRIGIE_Pos     (2U)
#define LPTIM_IER_EXTTRIGIE_Msk     (0x1UL << LPTIM_IER_EXTTRIGIE_Pos)         /*!< 0x00000004 */
#define LPTIM_IER_EXTTRIGIE         LPTIM_IER_EXTTRIGIE_Msk                    /*!< External trigger edge event Interrupt Enable */
#define LPTIM_IER_CMPOKIE_Pos       (3U)
#define LPTIM_IER_CMPOKIE_Msk       (0x1UL << LPTIM_IER_CMPOKIE_Pos)           /*!< 0x00000008 */
#define LPTIM_IER_CMPOKIE           LPTIM_IER_CMPOKIE_Msk                      /*!< Compare register update OK Interrupt Enable */
#define LPTIM_IER_ARROKIE_Pos       (4U)
#define LPTIM_IER_ARROKIE_Msk       (0x1UL << LPTIM_IER_ARROKIE_Pos)           /*!< 0x00000010 */
#define LPTIM_IER_ARROKIE           LPTIM_IER_ARROKIE_Msk                      /*!< Autoreload register update OK Interrupt Enable */
#define LPTIM_IER_UPIE_Pos          (5U)
#define LPTIM_IER_UPIE_Msk          (0x1UL << LPTIM_IER_UPIE_Pos)              /*!< 0x00000020 */
#define LPTIM_IER_UPIE              LPTIM_IER_UPIE_Msk                         /*!< Counter direction change down to up Interrupt Enable */
#define LPTIM_IER_DOWNIE_Pos        (6U)
#define LPTIM_IER_DOWNIE_Msk        (0x1UL << LPTIM_IER_DOWNIE_Pos)            /*!< 0x00000040 */
#define LPTIM_IER_DOWNIE            LPTIM_IER_DOWNIE_Msk                       /*!< Counter direction change up to down Interrupt Enable */
#define LPTIM_IER_UEIE_Pos          (7U)
#define LPTIM_IER_UEIE_Msk          (0x1UL << LPTIM_IER_UEIE_Pos)              /*!< 0x00000080 */
#define LPTIM_IER_UEIE              LPTIM_IER_UEIE_Msk                         /*!< Update event Interrupt Enable */
#define LPTIM_IER_REPOKIE_Pos       (8U)
#define LPTIM_IER_REPOKIE_Msk       (0x1UL << LPTIM_IER_REPOKIE_Pos)           /*!< 0x00000100 */
#define LPTIM_IER_REPOKIE           LPTIM_IER_REPOKIE_Msk                      /*!< Repetition register update OK Interrupt Enable */

/******************  Bit definition for LPTIM_CFGR register *******************/
#define LPTIM_CFGR_CKSEL_Pos        (0U)
#define LPTIM_CFGR_CKSEL_Msk        (0x1UL << LPTIM_CFGR_CKSEL_Pos)            /*!< 0x00000001 */
#define LPTIM_CFGR_CKSEL            LPTIM_CFGR_CKSEL_Msk                       /*!< Clock selector */

#define LPTIM_CFGR_CKPOL_Pos        (1U)
#define LPTIM_CFGR_CKPOL_Msk        (0x3UL << LPTIM_CFGR_CKPOL_Pos)            /*!< 0x00000006 */
#define LPTIM_CFGR_CKPOL            LPTIM_CFGR_CKPOL_Msk                       /*!< CKPOL[1:0] bits (Clock polarity) */
#define LPTIM_CFGR_CKPOL_0          (0x1UL << LPTIM_CFGR_CKPOL_Pos)            /*!< 0x00000002 */
#define LPTIM_CFGR_CKPOL_1          (0x2UL << LPTIM_CFGR_CKPOL_Pos)            /*!< 0x00000004 */

#define LPTIM_CFGR_CKFLT_Pos        (3U)
#define LPTIM_CFGR_CKFLT_Msk        (0x3UL << LPTIM_CFGR_CKFLT_Pos)            /*!< 0x00000018 */
#define LPTIM_CFGR_CKFLT            LPTIM_CFGR_CKFLT_Msk                       /*!< CKFLT[1:0] bits (Configurable digital filter for external clock) */
#define LPTIM_CFGR_CKFLT_0          (0x1UL << LPTIM_CFGR_CKFLT_Pos)            /*!< 0x00000008 */
#define LPTIM_CFGR_CKFLT_1          (0x2UL << LPTIM_CFGR_CKFLT_Pos)            /*!< 0x00000010 */

#define LPTIM_CFGR_TRGFLT_Pos       (6U)
#define LPTIM_CFGR_TRGFLT_Msk       (0x3UL << LPTIM_CFGR_TRGFLT_Pos)           /*!< 0x000000C0 */
#define LPTIM_CFGR_TRGFLT           LPTIM_CFGR_TRGFLT_Msk                      /*!< TRGFLT[1:0] bits (Configurable digital filter for trigger) */
#define LPTIM_CFGR_TRGFLT_0         (0x1UL << LPTIM_CFGR_TRGFLT_Pos)           /*!< 0x00000040 */
#define LPTIM_CFGR_TRGFLT_1         (0x2UL << LPTIM_CFGR_TRGFLT_Pos)           /*!< 0x00000080 */

#define LPTIM_CFGR_PRESC_Pos        (9U)
#define LPTIM_CFGR_PRESC_Msk        (0x7UL << LPTIM_CFGR_PRESC_Pos)            /*!< 0x00000E00 */
#define LPTIM_CFGR_PRESC            LPTIM_CFGR_PRESC_Msk                       /*!< PRESC[2:0] bits (Clock prescaler) */
#define LPTIM_CFGR_PRESC_0          (0x1UL << LPTIM_CFGR_PRESC_Pos)            /*!< 0x00000200 */
#define LPTIM_CFGR_PRESC_1          (0x2UL << LPTIM_CFGR_PRESC_Pos)            /*!< 0x00000400 */
#define LPTIM_CFGR_PRESC_2          (0x4UL << LPTIM_CFGR_PRESC_Pos)            /*!< 0x00000800 */

#define LPTIM_CFGR_TRIGSEL_Pos      (13U)
#define LPTIM_CFGR_TRIGSEL_Msk      (0x7UL << LPTIM_CFGR_TRIGSEL_Pos)          /*!< 0x0000E000 */
#define LPTIM_CFGR_TRIGSEL          LPTIM_CFGR_TRIGSEL_Msk                     /*!< TRIGSEL[2:0]] bits (Trigger selector) */
#define LPTIM_CFGR_TRIGSEL_0        (0x1UL << LPTIM_CFGR_TRIGSEL_Pos)          /*!< 0x00002000 */
#define LPTIM_CFGR_TRIGSEL_1        (0x2UL << LPTIM_CFGR_TRIGSEL_Pos)          /*!< 0x00004000 */
#define LPTIM_CFGR_TRIGSEL_2        (0x4UL << LPTIM_CFGR_TRIGSEL_Pos)          /*!< 0x00008000 */

#define LPTIM_CFGR_TRIGEN_Pos       (17U)
#define LPTIM_CFGR_TRIGEN_Msk       (0x3UL << LPTIM_CFGR_TRIGEN_Pos)           /*!< 0x00060000 */
#define LPTIM_CFGR_TRIGEN           LPTIM_CFGR_TRIGEN_Msk                      /*!< TRIGEN[1:0] bits (Trigger enable and polarity) */
#define LPTIM_CFGR_TRIGEN_0         (0x1UL << LPTIM_CFGR_TRIGEN_Pos)           /*!< 0x00020000 */
#define LPTIM_CFGR_TRIGEN_1         (0x2UL << LPTIM_CFGR_TRIGEN_Pos)           /*!< 0x00040000 */

#define LPTIM_CFGR_TIMOUT_Pos       (19U)
#define LPTIM_CFGR_TIMOUT_Msk       (0x1UL << LPTIM_CFGR_TIMOUT_Pos)           /*!< 0x00080000 */
#define LPTIM_CFGR_TIMOUT           LPTIM_CFGR_TIMOUT_Msk                      /*!< Timeout enable */
#define LPTIM_CFGR_WAVE_Pos         (20U)
#define LPTIM_CFGR_WAVE_Msk         (0x1UL << LPTIM_CFGR_WAVE_Pos)             /*!< 0x00100000 */
#define LPTIM_CFGR_WAVE             LPTIM_CFGR_WAVE_Msk                        /*!< Waveform shape */
#define LPTIM_CFGR_WAVPOL_Pos       (21U)
#define LPTIM_CFGR_WAVPOL_Msk       (0x1UL << LPTIM_CFGR_WAVPOL_Pos)           /*!< 0x00200000 */
#define LPTIM_CFGR_WAVPOL           LPTIM_CFGR_WAVPOL_Msk                      /*!< Waveform shape polarity */
#define LPTIM_CFGR_PRELOAD_Pos      (22U)
#define LPTIM_CFGR_PRELOAD_Msk      (0x1UL << LPTIM_CFGR_PRELOAD_Pos)          /*!< 0x00400000 */
#define LPTIM_CFGR_PRELOAD          LPTIM_CFGR_PRELOAD_Msk                     /*!< Reg update mode */
#define LPTIM_CFGR_COUNTMODE_Pos    (23U)
#define LPTIM_CFGR_COUNTMODE_Msk    (0x1UL << LPTIM_CFGR_COUNTMODE_Pos)        /*!< 0x00800000 */
#define LPTIM_CFGR_COUNTMODE        LPTIM_CFGR_COUNTMODE_Msk                   /*!< Counter mode enable */
#define LPTIM_CFGR_ENC_Pos          (24U)
#define LPTIM_CFGR_ENC_Msk          (0x1UL << LPTIM_CFGR_ENC_Pos)              /*!< 0x01000000 */
#define LPTIM_CFGR_ENC              LPTIM_CFGR_ENC_Msk                         /*!< Encoder mode enable */

/******************  Bit definition for LPTIM_CR register  ********************/
#define LPTIM_CR_ENABLE_Pos         (0U)
#define LPTIM_CR_ENABLE_Msk         (0x1UL << LPTIM_CR_ENABLE_Pos)             /*!< 0x00000001 */
#define LPTIM_CR_ENABLE             LPTIM_CR_ENABLE_Msk                        /*!< LPTIMer enable */
#define LPTIM_CR_SNGSTRT_Pos        (1U)
#define LPTIM_CR_SNGSTRT_Msk        (0x1UL << LPTIM_CR_SNGSTRT_Pos)            /*!< 0x00000002 */
#define LPTIM_CR_SNGSTRT            LPTIM_CR_SNGSTRT_Msk                       /*!< Timer start in single mode */
#define LPTIM_CR_CNTSTRT_Pos        (2U)
#define LPTIM_CR_CNTSTRT_Msk        (0x1UL << LPTIM_CR_CNTSTRT_Pos)            /*!< 0x00000004 */
#define LPTIM_CR_CNTSTRT            LPTIM_CR_CNTSTRT_Msk                       /*!< Timer start in continuous mode */
#define LPTIM_CR_COUNTRST_Pos       (3U)
#define LPTIM_CR_COUNTRST_Msk       (0x1UL << LPTIM_CR_COUNTRST_Pos)           /*!< 0x00000008 */
#define LPTIM_CR_COUNTRST           LPTIM_CR_COUNTRST_Msk                      /*!< Counter reset */
#define LPTIM_CR_RSTARE_Pos         (4U)
#define LPTIM_CR_RSTARE_Msk         (0x1UL << LPTIM_CR_RSTARE_Pos)             /*!< 0x00000010 */
#define LPTIM_CR_RSTARE             LPTIM_CR_RSTARE_Msk                        /*!< Reset after read enable */

/******************  Bit definition for LPTIM_CMP register  *******************/
#define LPTIM_CMP_CMP_Pos           (0U)
#define LPTIM_CMP_CMP_Msk           (0xFFFFUL << LPTIM_CMP_CMP_Pos)            /*!< 0x0000FFFF */
#define LPTIM_CMP_CMP               LPTIM_CMP_CMP_Msk                          /*!< Compare register */

/******************  Bit definition for LPTIM_ARR register  *******************/
#define LPTIM_ARR_ARR_Pos           (0U)
#define LPTIM_ARR_ARR_Msk           (0xFFFFUL << LPTIM_ARR_ARR_Pos)            /*!< 0x0000FFFF */
#define LPTIM_ARR_ARR               LPTIM_ARR_ARR_Msk                          /*!< Auto reload register */

/******************  Bit definition for LPTIM_CNT register  *******************/
#define LPTIM_CNT_CNT_Pos           (0U)
#define LPTIM_CNT_CNT_Msk           (0xFFFFUL << LPTIM_CNT_CNT_Pos)            /*!< 0x0000FFFF */
#define LPTIM_CNT_CNT               LPTIM_CNT_CNT_Msk                          /*!< Counter register */

/******************  Bit definition for LPTIM_OR register  *******************/
#define LPTIM_OR_OR_Pos             (0U)
#define LPTIM_OR_OR_Msk             (0x3UL << LPTIM_OR_OR_Pos)                 /*!< 0x00000003 */
#define LPTIM_OR_OR                 LPTIM_OR_OR_Msk                            /*!< OR[1:0] bits (Remap selection) */
#define LPTIM_OR_OR_0               (0x1UL << LPTIM_OR_OR_Pos)                 /*!< 0x00000001 */
#define LPTIM_OR_OR_1               (0x2UL << LPTIM_OR_OR_Pos)                 /*!< 0x00000002 */

/******************  Bit definition for LPTIM_RCR register  *******************/
#define LPTIM_RCR_REP_Pos           (0U)
#define LPTIM_RCR_REP_Msk           (0xFFUL << LPTIM_RCR_REP_Pos)              /*!< 0x000000FF */
#define LPTIM_RCR_REP               LPTIM_RCR_REP_Msk                          /*!< Repetition Counter Value */

/******************************************************************************/
/*                                                                            */
/*                                    OCTOSPI                                 */
/*                                                                            */
/******************************************************************************/
/*****************  Bit definition for OCTOSPI_CR register  *******************/
#define OCTOSPI_CR_EN_Pos              (0U)
#define OCTOSPI_CR_EN_Msk              (0x1UL << OCTOSPI_CR_EN_Pos)            /*!< 0x00000001 */
#define OCTOSPI_CR_EN                  OCTOSPI_CR_EN_Msk                       /*!< Enable */
#define OCTOSPI_CR_ABORT_Pos           (1U)
#define OCTOSPI_CR_ABORT_Msk           (0x1UL << OCTOSPI_CR_ABORT_Pos)         /*!< 0x00000002 */
#define OCTOSPI_CR_ABORT               OCTOSPI_CR_ABORT_Msk                    /*!< Abort request */
#define OCTOSPI_CR_DMAEN_Pos           (2U)
#define OCTOSPI_CR_DMAEN_Msk           (0x1UL << OCTOSPI_CR_DMAEN_Pos)         /*!< 0x00000004 */
#define OCTOSPI_CR_DMAEN               OCTOSPI_CR_DMAEN_Msk                    /*!< DMA Enable */
#define OCTOSPI_CR_TCEN_Pos            (3U)
#define OCTOSPI_CR_TCEN_Msk            (0x1UL << OCTOSPI_CR_TCEN_Pos)          /*!< 0x00000008 */
#define OCTOSPI_CR_TCEN                OCTOSPI_CR_TCEN_Msk                     /*!< Timeout Counter Enable */
#define OCTOSPI_CR_DQM_Pos             (6U)
#define OCTOSPI_CR_DQM_Msk             (0x1UL << OCTOSPI_CR_DQM_Pos)           /*!< 0x00000040 */
#define OCTOSPI_CR_DQM                 OCTOSPI_CR_DQM_Msk                      /*!< Dual-Quad Mode */
#define OCTOSPI_CR_FSEL_Pos            (7U)
#define OCTOSPI_CR_FSEL_Msk            (0x1UL << OCTOSPI_CR_FSEL_Pos)          /*!< 0x00000080 */
#define OCTOSPI_CR_FSEL                OCTOSPI_CR_FSEL_Msk                     /*!< Flash Select */
#define OCTOSPI_CR_FTHRES_Pos          (8U)
#define OCTOSPI_CR_FTHRES_Msk          (0x1FUL << OCTOSPI_CR_FTHRES_Pos)       /*!< 0x00001F00 */
#define OCTOSPI_CR_FTHRES              OCTOSPI_CR_FTHRES_Msk                   /*!< FIFO Threshold Level */
#define OCTOSPI_CR_TEIE_Pos            (16U)
#define OCTOSPI_CR_TEIE_Msk            (0x1UL << OCTOSPI_CR_TEIE_Pos)          /*!< 0x00010000 */
#define OCTOSPI_CR_TEIE                OCTOSPI_CR_TEIE_Msk                     /*!< Transfer Error Interrupt Enable */
#define OCTOSPI_CR_TCIE_Pos            (17U)
#define OCTOSPI_CR_TCIE_Msk            (0x1UL << OCTOSPI_CR_TCIE_Pos)          /*!< 0x00020000 */
#define OCTOSPI_CR_TCIE                OCTOSPI_CR_TCIE_Msk                     /*!< Transfer Complete Interrupt Enable */
#define OCTOSPI_CR_FTIE_Pos            (18U)
#define OCTOSPI_CR_FTIE_Msk            (0x1UL << OCTOSPI_CR_FTIE_Pos)          /*!< 0x00040000 */
#define OCTOSPI_CR_FTIE                OCTOSPI_CR_FTIE_Msk                     /*!< FIFO Threshold Interrupt Enable */
#define OCTOSPI_CR_SMIE_Pos            (19U)
#define OCTOSPI_CR_SMIE_Msk            (0x1UL << OCTOSPI_CR_SMIE_Pos)          /*!< 0x00080000 */
#define OCTOSPI_CR_SMIE                OCTOSPI_CR_SMIE_Msk                     /*!< Status Match Interrupt Enable */
#define OCTOSPI_CR_TOIE_Pos            (20U)
#define OCTOSPI_CR_TOIE_Msk            (0x1UL << OCTOSPI_CR_TOIE_Pos)          /*!< 0x00100000 */
#define OCTOSPI_CR_TOIE                OCTOSPI_CR_TOIE_Msk                     /*!< TimeOut Interrupt Enable */
#define OCTOSPI_CR_APMS_Pos            (22U)
#define OCTOSPI_CR_APMS_Msk            (0x1UL << OCTOSPI_CR_APMS_Pos)          /*!< 0x00400000 */
#define OCTOSPI_CR_APMS                OCTOSPI_CR_APMS_Msk                     /*!< Automatic Poll Mode Stop */
#define OCTOSPI_CR_PMM_Pos             (23U)
#define OCTOSPI_CR_PMM_Msk             (0x1UL << OCTOSPI_CR_PMM_Pos)           /*!< 0x00800000 */
#define OCTOSPI_CR_PMM                 OCTOSPI_CR_PMM_Msk                      /*!< Polling Match Mode */
#define OCTOSPI_CR_FMODE_Pos           (28U)
#define OCTOSPI_CR_FMODE_Msk           (0x3UL << OCTOSPI_CR_FMODE_Pos)         /*!< 0x30000000 */
#define OCTOSPI_CR_FMODE               OCTOSPI_CR_FMODE_Msk                    /*!< Functional Mode */
#define OCTOSPI_CR_FMODE_0             (0x1UL << OCTOSPI_CR_FMODE_Pos)         /*!< 0x10000000 */
#define OCTOSPI_CR_FMODE_1             (0x2UL << OCTOSPI_CR_FMODE_Pos)         /*!< 0x20000000 */

/****************  Bit definition for OCTOSPI_DCR1 register  ******************/
#define OCTOSPI_DCR1_CKMODE_Pos        (0U)
#define OCTOSPI_DCR1_CKMODE_Msk        (0x1UL << OCTOSPI_DCR1_CKMODE_Pos)      /*!< 0x00000001 */
#define OCTOSPI_DCR1_CKMODE            OCTOSPI_DCR1_CKMODE_Msk                 /*!< Mode 0 / Mode 3 */
#define OCTOSPI_DCR1_FRCK_Pos          (1U)
#define OCTOSPI_DCR1_FRCK_Msk          (0x1UL << OCTOSPI_DCR1_FRCK_Pos)        /*!< 0x00000002 */
#define OCTOSPI_DCR1_FRCK              OCTOSPI_DCR1_FRCK_Msk                   /*!< Free Running Clock */
#define OCTOSPI_DCR1_DLYBYP_Pos        (3U)
#define OCTOSPI_DCR1_DLYBYP_Msk        (0x1UL << OCTOSPI_DCR1_DLYBYP_Pos)      /*!< 0x00000008 */
#define OCTOSPI_DCR1_DLYBYP            OCTOSPI_DCR1_DLYBYP_Msk                 /*!< Delay Block Bypass */
#define OCTOSPI_DCR1_CSHT_Pos          (8U)
#define OCTOSPI_DCR1_CSHT_Msk          (0x7UL << OCTOSPI_DCR1_CSHT_Pos)        /*!< 0x00000700 */
#define OCTOSPI_DCR1_CSHT              OCTOSPI_DCR1_CSHT_Msk                   /*!< Chip Select High Time */
#define OCTOSPI_DCR1_DEVSIZE_Pos       (16U)
#define OCTOSPI_DCR1_DEVSIZE_Msk       (0x1FUL << OCTOSPI_DCR1_DEVSIZE_Pos)    /*!< 0x001F0000 */
#define OCTOSPI_DCR1_DEVSIZE           OCTOSPI_DCR1_DEVSIZE_Msk                /*!< Device Size */
#define OCTOSPI_DCR1_MTYP_Pos          (24U)
#define OCTOSPI_DCR1_MTYP_Msk          (0x7UL << OCTOSPI_DCR1_MTYP_Pos)        /*!< 0x07000000 */
#define OCTOSPI_DCR1_MTYP              OCTOSPI_DCR1_MTYP_Msk                   /*!< Memory Type */
#define OCTOSPI_DCR1_MTYP_0            (0x1UL << OCTOSPI_DCR1_MTYP_Pos)        /*!< 0x01000000 */
#define OCTOSPI_DCR1_MTYP_1            (0x2UL << OCTOSPI_DCR1_MTYP_Pos)        /*!< 0x02000000 */
#define OCTOSPI_DCR1_MTYP_2            (0x4UL << OCTOSPI_DCR1_MTYP_Pos)        /*!< 0x04000000 */

/****************  Bit definition for OCTOSPI_DCR2 register  ******************/
#define OCTOSPI_DCR2_PRESCALER_Pos     (0U)
#define OCTOSPI_DCR2_PRESCALER_Msk     (0xFFUL << OCTOSPI_DCR2_PRESCALER_Pos)  /*!< 0x000000FF */
#define OCTOSPI_DCR2_PRESCALER         OCTOSPI_DCR2_PRESCALER_Msk              /*!< Clock prescaler */
#define OCTOSPI_DCR2_WRAPSIZE_Pos      (16U)
#define OCTOSPI_DCR2_WRAPSIZE_Msk      (0x7UL << OCTOSPI_DCR2_WRAPSIZE_Pos)    /*!< 0x00070000 */
#define OCTOSPI_DCR2_WRAPSIZE          OCTOSPI_DCR2_WRAPSIZE_Msk               /*!< Wrap Size */
#define OCTOSPI_DCR2_WRAPSIZE_0        (0x1UL << OCTOSPI_DCR2_WRAPSIZE_Pos)    /*!< 0x00010000 */
#define OCTOSPI_DCR2_WRAPSIZE_1        (0x2UL << OCTOSPI_DCR2_WRAPSIZE_Pos)    /*!< 0x00020000 */
#define OCTOSPI_DCR2_WRAPSIZE_2        (0x4UL << OCTOSPI_DCR2_WRAPSIZE_Pos)    /*!< 0x00040000 */

/****************  Bit definition for OCTOSPI_DCR3 register  ******************/
#define OCTOSPI_DCR3_CSBOUND_Pos       (16U)
#define OCTOSPI_DCR3_CSBOUND_Msk       (0x1FUL << OCTOSPI_DCR3_CSBOUND_Pos)    /*!< 0x001F0000 */
#define OCTOSPI_DCR3_CSBOUND           OCTOSPI_DCR3_CSBOUND_Msk                /*!< CS Boundary */

/****************  Bit definition for OCTOSPI_DCR4 register  ******************/
#define OCTOSPI_DCR4_REFRESH_Pos       (0U)
#define OCTOSPI_DCR4_REFRESH_Msk       (0xFFFFFFFFUL << OCTOSPI_DCR4_REFRESH_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_DCR4_REFRESH           OCTOSPI_DCR4_REFRESH_Msk                /*!< Refresh rate */

/*****************  Bit definition for OCTOSPI_SR register  *******************/
#define OCTOSPI_SR_TEF_Pos             (0U)
#define OCTOSPI_SR_TEF_Msk             (0x1UL << OCTOSPI_SR_TEF_Pos)           /*!< 0x00000001 */
#define OCTOSPI_SR_TEF                 OCTOSPI_SR_TEF_Msk                      /*!< Transfer Error Flag */
#define OCTOSPI_SR_TCF_Pos             (1U)
#define OCTOSPI_SR_TCF_Msk             (0x1UL << OCTOSPI_SR_TCF_Pos)           /*!< 0x00000002 */
#define OCTOSPI_SR_TCF                 OCTOSPI_SR_TCF_Msk                      /*!< Transfer Complete Flag */
#define OCTOSPI_SR_FTF_Pos             (2U)
#define OCTOSPI_SR_FTF_Msk             (0x1UL << OCTOSPI_SR_FTF_Pos)           /*!< 0x00000004 */
#define OCTOSPI_SR_FTF                 OCTOSPI_SR_FTF_Msk                      /*!< FIFO Threshold Flag */
#define OCTOSPI_SR_SMF_Pos             (3U)
#define OCTOSPI_SR_SMF_Msk             (0x1UL << OCTOSPI_SR_SMF_Pos)           /*!< 0x00000008 */
#define OCTOSPI_SR_SMF                 OCTOSPI_SR_SMF_Msk                      /*!< Status Match Flag */
#define OCTOSPI_SR_TOF_Pos             (4U)
#define OCTOSPI_SR_TOF_Msk             (0x1UL << OCTOSPI_SR_TOF_Pos)           /*!< 0x00000010 */
#define OCTOSPI_SR_TOF                 OCTOSPI_SR_TOF_Msk                      /*!< Timeout Flag */
#define OCTOSPI_SR_BUSY_Pos            (5U)
#define OCTOSPI_SR_BUSY_Msk            (0x1UL << OCTOSPI_SR_BUSY_Pos)          /*!< 0x00000020 */
#define OCTOSPI_SR_BUSY                OCTOSPI_SR_BUSY_Msk                     /*!< Busy */
#define OCTOSPI_SR_FLEVEL_Pos          (8U)
#define OCTOSPI_SR_FLEVEL_Msk          (0x3FUL << OCTOSPI_SR_FLEVEL_Pos)       /*!< 0x00003F00 */
#define OCTOSPI_SR_FLEVEL              OCTOSPI_SR_FLEVEL_Msk                   /*!< FIFO Level */

/****************  Bit definition for OCTOSPI_FCR register  *******************/
#define OCTOSPI_FCR_CTEF_Pos           (0U)
#define OCTOSPI_FCR_CTEF_Msk           (0x1UL << OCTOSPI_FCR_CTEF_Pos)         /*!< 0x00000001 */
#define OCTOSPI_FCR_CTEF               OCTOSPI_FCR_CTEF_Msk                    /*!< Clear Transfer Error Flag */
#define OCTOSPI_FCR_CTCF_Pos           (1U)
#define OCTOSPI_FCR_CTCF_Msk           (0x1UL << OCTOSPI_FCR_CTCF_Pos)         /*!< 0x00000002 */
#define OCTOSPI_FCR_CTCF               OCTOSPI_FCR_CTCF_Msk                    /*!< Clear Transfer Complete Flag */
#define OCTOSPI_FCR_CSMF_Pos           (3U)
#define OCTOSPI_FCR_CSMF_Msk           (0x1UL << OCTOSPI_FCR_CSMF_Pos)         /*!< 0x00000008 */
#define OCTOSPI_FCR_CSMF               OCTOSPI_FCR_CSMF_Msk                    /*!< Clear Status Match Flag */
#define OCTOSPI_FCR_CTOF_Pos           (4U)
#define OCTOSPI_FCR_CTOF_Msk           (0x1UL << OCTOSPI_FCR_CTOF_Pos)         /*!< 0x00000010 */
#define OCTOSPI_FCR_CTOF               OCTOSPI_FCR_CTOF_Msk                    /*!< Clear Timeout Flag */

/****************  Bit definition for OCTOSPI_DLR register  *******************/
#define OCTOSPI_DLR_DL_Pos             (0U)
#define OCTOSPI_DLR_DL_Msk             (0xFFFFFFFFUL << OCTOSPI_DLR_DL_Pos)    /*!< 0xFFFFFFFF */
#define OCTOSPI_DLR_DL                 OCTOSPI_DLR_DL_Msk                      /*!< Data Length */

/*****************  Bit definition for OCTOSPI_AR register  *******************/
#define OCTOSPI_AR_ADDRESS_Pos         (0U)
#define OCTOSPI_AR_ADDRESS_Msk         (0xFFFFFFFFUL << OCTOSPI_AR_ADDRESS_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_AR_ADDRESS             OCTOSPI_AR_ADDRESS_Msk                  /*!< Address */

/*****************  Bit definition for OCTOSPI_DR register  *******************/
#define OCTOSPI_DR_DATA_Pos            (0U)
#define OCTOSPI_DR_DATA_Msk            (0xFFFFFFFFUL << OCTOSPI_DR_DATA_Pos)   /*!< 0xFFFFFFFF */
#define OCTOSPI_DR_DATA                OCTOSPI_DR_DATA_Msk                     /*!< Data */

/***************  Bit definition for OCTOSPI_PSMKR register  ******************/
#define OCTOSPI_PSMKR_MASK_Pos         (0U)
#define OCTOSPI_PSMKR_MASK_Msk         (0xFFFFFFFFUL << OCTOSPI_PSMKR_MASK_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_PSMKR_MASK             OCTOSPI_PSMKR_MASK_Msk                  /*!< Status mask */

/***************  Bit definition for OCTOSPI_PSMAR register  ******************/
#define OCTOSPI_PSMAR_MATCH_Pos        (0U)
#define OCTOSPI_PSMAR_MATCH_Msk        (0xFFFFFFFFUL << OCTOSPI_PSMAR_MATCH_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_PSMAR_MATCH            OCTOSPI_PSMAR_MATCH_Msk                 /*!< Status match */

/****************  Bit definition for OCTOSPI_PIR register  *******************/
#define OCTOSPI_PIR_INTERVAL_Pos       (0U)
#define OCTOSPI_PIR_INTERVAL_Msk       (0xFFFFUL << OCTOSPI_PIR_INTERVAL_Pos)  /*!< 0x0000FFFF */
#define OCTOSPI_PIR_INTERVAL           OCTOSPI_PIR_INTERVAL_Msk                /*!< Polling Interval */

/****************  Bit definition for OCTOSPI_CCR register  *******************/
#define OCTOSPI_CCR_IMODE_Pos          (0U)
#define OCTOSPI_CCR_IMODE_Msk          (0x7UL << OCTOSPI_CCR_IMODE_Pos)        /*!< 0x00000007 */
#define OCTOSPI_CCR_IMODE              OCTOSPI_CCR_IMODE_Msk                   /*!< Instruction Mode */
#define OCTOSPI_CCR_IMODE_0            (0x1UL << OCTOSPI_CCR_IMODE_Pos)        /*!< 0x00000001 */
#define OCTOSPI_CCR_IMODE_1            (0x2UL << OCTOSPI_CCR_IMODE_Pos)        /*!< 0x00000002 */
#define OCTOSPI_CCR_IMODE_2            (0x4UL << OCTOSPI_CCR_IMODE_Pos)        /*!< 0x00000004 */
#define OCTOSPI_CCR_IDTR_Pos           (3U)
#define OCTOSPI_CCR_IDTR_Msk           (0x1UL << OCTOSPI_CCR_IDTR_Pos)         /*!< 0x00000008 */
#define OCTOSPI_CCR_IDTR               OCTOSPI_CCR_IDTR_Msk                    /*!< Instruction Double Transfer Rate */
#define OCTOSPI_CCR_ISIZE_Pos          (4U)
#define OCTOSPI_CCR_ISIZE_Msk          (0x3UL << OCTOSPI_CCR_ISIZE_Pos)        /*!< 0x00000030 */
#define OCTOSPI_CCR_ISIZE              OCTOSPI_CCR_ISIZE_Msk                   /*!< Instruction Size */
#define OCTOSPI_CCR_ISIZE_0            (0x1UL << OCTOSPI_CCR_ISIZE_Pos)        /*!< 0x00000010 */
#define OCTOSPI_CCR_ISIZE_1            (0x2UL << OCTOSPI_CCR_ISIZE_Pos)        /*!< 0x00000020 */
#define OCTOSPI_CCR_ADMODE_Pos         (8U)
#define OCTOSPI_CCR_ADMODE_Msk         (0x7UL << OCTOSPI_CCR_ADMODE_Pos)       /*!< 0x00000700 */
#define OCTOSPI_CCR_ADMODE             OCTOSPI_CCR_ADMODE_Msk                  /*!< Address Mode */
#define OCTOSPI_CCR_ADMODE_0           (0x1UL << OCTOSPI_CCR_ADMODE_Pos)       /*!< 0x00000100 */
#define OCTOSPI_CCR_ADMODE_1           (0x2UL << OCTOSPI_CCR_ADMODE_Pos)       /*!< 0x00000200 */
#define OCTOSPI_CCR_ADMODE_2           (0x4UL << OCTOSPI_CCR_ADMODE_Pos)       /*!< 0x00000400 */
#define OCTOSPI_CCR_ADDTR_Pos          (11U)
#define OCTOSPI_CCR_ADDTR_Msk          (0x1UL << OCTOSPI_CCR_ADDTR_Pos)        /*!< 0x00000800 */
#define OCTOSPI_CCR_ADDTR              OCTOSPI_CCR_ADDTR_Msk                   /*!< Address Double Transfer Rate */
#define OCTOSPI_CCR_ADSIZE_Pos         (12U)
#define OCTOSPI_CCR_ADSIZE_Msk         (0x3UL << OCTOSPI_CCR_ADSIZE_Pos)       /*!< 0x00003000 */
#define OCTOSPI_CCR_ADSIZE             OCTOSPI_CCR_ADSIZE_Msk                  /*!< Address Size */
#define OCTOSPI_CCR_ADSIZE_0           (0x1UL << OCTOSPI_CCR_ADSIZE_Pos)       /*!< 0x00001000 */
#define OCTOSPI_CCR_ADSIZE_1           (0x2UL << OCTOSPI_CCR_ADSIZE_Pos)       /*!< 0x00002000 */
#define OCTOSPI_CCR_ABMODE_Pos         (16U)
#define OCTOSPI_CCR_ABMODE_Msk         (0x7UL << OCTOSPI_CCR_ABMODE_Pos)       /*!< 0x00070000 */
#define OCTOSPI_CCR_ABMODE             OCTOSPI_CCR_ABMODE_Msk                  /*!< Alternate Bytes Mode */
#define OCTOSPI_CCR_ABMODE_0           (0x1UL << OCTOSPI_CCR_ABMODE_Pos)       /*!< 0x00010000 */
#define OCTOSPI_CCR_ABMODE_1           (0x2UL << OCTOSPI_CCR_ABMODE_Pos)       /*!< 0x00020000 */
#define OCTOSPI_CCR_ABMODE_2           (0x4UL << OCTOSPI_CCR_ABMODE_Pos)       /*!< 0x00040000 */
#define OCTOSPI_CCR_ABDTR_Pos          (19U)
#define OCTOSPI_CCR_ABDTR_Msk          (0x1UL << OCTOSPI_CCR_ABDTR_Pos)        /*!< 0x00080000 */
#define OCTOSPI_CCR_ABDTR              OCTOSPI_CCR_ABDTR_Msk                   /*!< Alternate Bytes Double Transfer Rate */
#define OCTOSPI_CCR_ABSIZE_Pos         (20U)
#define OCTOSPI_CCR_ABSIZE_Msk         (0x3UL << OCTOSPI_CCR_ABSIZE_Pos)       /*!< 0x00300000 */
#define OCTOSPI_CCR_ABSIZE             OCTOSPI_CCR_ABSIZE_Msk                  /*!< Alternate Bytes Size */
#define OCTOSPI_CCR_ABSIZE_0           (0x1UL << OCTOSPI_CCR_ABSIZE_Pos)       /*!< 0x00100000 */
#define OCTOSPI_CCR_ABSIZE_1           (0x2UL << OCTOSPI_CCR_ABSIZE_Pos)       /*!< 0x00200000 */
#define OCTOSPI_CCR_DMODE_Pos          (24U)
#define OCTOSPI_CCR_DMODE_Msk          (0x7UL << OCTOSPI_CCR_DMODE_Pos)        /*!< 0x07000000 */
#define OCTOSPI_CCR_DMODE              OCTOSPI_CCR_DMODE_Msk                   /*!< Data Mode */
#define OCTOSPI_CCR_DMODE_0            (0x1UL << OCTOSPI_CCR_DMODE_Pos)        /*!< 0x01000000 */
#define OCTOSPI_CCR_DMODE_1            (0x2UL << OCTOSPI_CCR_DMODE_Pos)        /*!< 0x02000000 */
#define OCTOSPI_CCR_DMODE_2            (0x4UL << OCTOSPI_CCR_DMODE_Pos)        /*!< 0x04000000 */
#define OCTOSPI_CCR_DDTR_Pos           (27U)
#define OCTOSPI_CCR_DDTR_Msk           (0x1UL << OCTOSPI_CCR_DDTR_Pos)         /*!< 0x08000000 */
#define OCTOSPI_CCR_DDTR               OCTOSPI_CCR_DDTR_Msk                    /*!< Data Double Transfer Rate */
#define OCTOSPI_CCR_DQSE_Pos           (29U)
#define OCTOSPI_CCR_DQSE_Msk           (0x1UL << OCTOSPI_CCR_DQSE_Pos)         /*!< 0x20000000 */
#define OCTOSPI_CCR_DQSE               OCTOSPI_CCR_DQSE_Msk                    /*!< DQS Enable */
#define OCTOSPI_CCR_SIOO_Pos           (31U)
#define OCTOSPI_CCR_SIOO_Msk           (0x1UL << OCTOSPI_CCR_SIOO_Pos)         /*!< 0x80000000 */
#define OCTOSPI_CCR_SIOO               OCTOSPI_CCR_SIOO_Msk                    /*!< Send Instruction Only Once Mode */

/****************  Bit definition for OCTOSPI_TCR register  *******************/
#define OCTOSPI_TCR_DCYC_Pos           (0U)
#define OCTOSPI_TCR_DCYC_Msk           (0x1FUL << OCTOSPI_TCR_DCYC_Pos)        /*!< 0x0000001F */
#define OCTOSPI_TCR_DCYC               OCTOSPI_TCR_DCYC_Msk                    /*!< Number of Dummy Cycles */
#define OCTOSPI_TCR_DHQC_Pos           (28U)
#define OCTOSPI_TCR_DHQC_Msk           (0x1UL << OCTOSPI_TCR_DHQC_Pos)         /*!< 0x10000000 */
#define OCTOSPI_TCR_DHQC               OCTOSPI_TCR_DHQC_Msk                    /*!< Delay Hold Quarter Cycle */
#define OCTOSPI_TCR_SSHIFT_Pos         (30U)
#define OCTOSPI_TCR_SSHIFT_Msk         (0x1UL << OCTOSPI_TCR_SSHIFT_Pos)       /*!< 0x40000000 */
#define OCTOSPI_TCR_SSHIFT             OCTOSPI_TCR_SSHIFT_Msk                  /*!< Sample Shift */

/*****************  Bit definition for OCTOSPI_IR register  *******************/
#define OCTOSPI_IR_INSTRUCTION_Pos     (0U)
#define OCTOSPI_IR_INSTRUCTION_Msk     (0xFFFFFFFFUL << OCTOSPI_IR_INSTRUCTION_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_IR_INSTRUCTION         OCTOSPI_IR_INSTRUCTION_Msk              /*!< Instruction */

/****************  Bit definition for OCTOSPI_ABR register  *******************/
#define OCTOSPI_ABR_ALTERNATE_Pos      (0U)
#define OCTOSPI_ABR_ALTERNATE_Msk      (0xFFFFFFFFUL << OCTOSPI_ABR_ALTERNATE_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_ABR_ALTERNATE          OCTOSPI_ABR_ALTERNATE_Msk               /*!< Alternate Bytes */

/****************  Bit definition for OCTOSPI_LPTR register  ******************/
#define OCTOSPI_LPTR_TIMEOUT_Pos       (0U)
#define OCTOSPI_LPTR_TIMEOUT_Msk       (0xFFFFUL << OCTOSPI_LPTR_TIMEOUT_Pos)  /*!< 0x0000FFFF */
#define OCTOSPI_LPTR_TIMEOUT           OCTOSPI_LPTR_TIMEOUT_Msk                /*!< Timeout period */

/****************  Bit definition for OCTOSPI_WPCCR register  *******************/
#define OCTOSPI_WPCCR_IMODE_Pos        (0U)
#define OCTOSPI_WPCCR_IMODE_Msk        (0x7UL << OCTOSPI_WPCCR_IMODE_Pos)      /*!< 0x00000007 */
#define OCTOSPI_WPCCR_IMODE            OCTOSPI_WPCCR_IMODE_Msk                 /*!< Instruction Mode */
#define OCTOSPI_WPCCR_IMODE_0          (0x1UL << OCTOSPI_WPCCR_IMODE_Pos)      /*!< 0x00000001 */
#define OCTOSPI_WPCCR_IMODE_1          (0x2UL << OCTOSPI_WPCCR_IMODE_Pos)      /*!< 0x00000002 */
#define OCTOSPI_WPCCR_IMODE_2          (0x4UL << OCTOSPI_WPCCR_IMODE_Pos)      /*!< 0x00000004 */
#define OCTOSPI_WPCCR_IDTR_Pos         (3U)
#define OCTOSPI_WPCCR_IDTR_Msk         (0x1UL << OCTOSPI_WPCCR_IDTR_Pos)       /*!< 0x00000008 */
#define OCTOSPI_WPCCR_IDTR             OCTOSPI_WPCCR_IDTR_Msk                  /*!< Instruction Double Transfer Rate */
#define OCTOSPI_WPCCR_ISIZE_Pos        (4U)
#define OCTOSPI_WPCCR_ISIZE_Msk        (0x3UL << OCTOSPI_WPCCR_ISIZE_Pos)      /*!< 0x00000030 */
#define OCTOSPI_WPCCR_ISIZE            OCTOSPI_WPCCR_ISIZE_Msk                 /*!< Instruction Size */
#define OCTOSPI_WPCCR_ISIZE_0          (0x1UL << OCTOSPI_WPCCR_ISIZE_Pos)      /*!< 0x00000010 */
#define OCTOSPI_WPCCR_ISIZE_1          (0x2UL << OCTOSPI_WPCCR_ISIZE_Pos)      /*!< 0x00000020 */
#define OCTOSPI_WPCCR_ADMODE_Pos       (8U)
#define OCTOSPI_WPCCR_ADMODE_Msk       (0x7UL << OCTOSPI_WPCCR_ADMODE_Pos)     /*!< 0x00000700 */
#define OCTOSPI_WPCCR_ADMODE           OCTOSPI_WPCCR_ADMODE_Msk                /*!< Address Mode */
#define OCTOSPI_WPCCR_ADMODE_0         (0x1UL << OCTOSPI_WPCCR_ADMODE_Pos)     /*!< 0x00000100 */
#define OCTOSPI_WPCCR_ADMODE_1         (0x2UL << OCTOSPI_WPCCR_ADMODE_Pos)     /*!< 0x00000200 */
#define OCTOSPI_WPCCR_ADMODE_2         (0x4UL << OCTOSPI_WPCCR_ADMODE_Pos)     /*!< 0x00000400 */
#define OCTOSPI_WPCCR_ADDTR_Pos        (11U)
#define OCTOSPI_WPCCR_ADDTR_Msk        (0x1UL << OCTOSPI_WPCCR_ADDTR_Pos)      /*!< 0x00000800 */
#define OCTOSPI_WPCCR_ADDTR            OCTOSPI_WPCCR_ADDTR_Msk                 /*!< Address Double Transfer Rate */
#define OCTOSPI_WPCCR_ADSIZE_Pos       (12U)
#define OCTOSPI_WPCCR_ADSIZE_Msk       (0x3UL << OCTOSPI_WPCCR_ADSIZE_Pos)     /*!< 0x00003000 */
#define OCTOSPI_WPCCR_ADSIZE           OCTOSPI_WPCCR_ADSIZE_Msk                /*!< Address Size */
#define OCTOSPI_WPCCR_ADSIZE_0         (0x1UL << OCTOSPI_WPCCR_ADSIZE_Pos)     /*!< 0x00001000 */
#define OCTOSPI_WPCCR_ADSIZE_1         (0x2UL << OCTOSPI_WPCCR_ADSIZE_Pos)     /*!< 0x00002000 */
#define OCTOSPI_WPCCR_ABMODE_Pos       (16U)
#define OCTOSPI_WPCCR_ABMODE_Msk       (0x7UL << OCTOSPI_WPCCR_ABMODE_Pos)     /*!< 0x00070000 */
#define OCTOSPI_WPCCR_ABMODE           OCTOSPI_WPCCR_ABMODE_Msk                /*!< Alternate Bytes Mode */
#define OCTOSPI_WPCCR_ABMODE_0         (0x1UL << OCTOSPI_WPCCR_ABMODE_Pos)     /*!< 0x00010000 */
#define OCTOSPI_WPCCR_ABMODE_1         (0x2UL << OCTOSPI_WPCCR_ABMODE_Pos)     /*!< 0x00020000 */
#define OCTOSPI_WPCCR_ABMODE_2         (0x4UL << OCTOSPI_WPCCR_ABMODE_Pos)     /*!< 0x00040000 */
#define OCTOSPI_WPCCR_ABDTR_Pos        (19U)
#define OCTOSPI_WPCCR_ABDTR_Msk        (0x1UL << OCTOSPI_WPCCR_ABDTR_Pos)      /*!< 0x00080000 */
#define OCTOSPI_WPCCR_ABDTR            OCTOSPI_WPCCR_ABDTR_Msk                 /*!< Alternate Bytes Double Transfer Rate */
#define OCTOSPI_WPCCR_ABSIZE_Pos       (20U)
#define OCTOSPI_WPCCR_ABSIZE_Msk       (0x3UL << OCTOSPI_WPCCR_ABSIZE_Pos)     /*!< 0x00300000 */
#define OCTOSPI_WPCCR_ABSIZE           OCTOSPI_WPCCR_ABSIZE_Msk                /*!< Alternate Bytes Size */
#define OCTOSPI_WPCCR_ABSIZE_0         (0x1UL << OCTOSPI_WPCCR_ABSIZE_Pos)     /*!< 0x00100000 */
#define OCTOSPI_WPCCR_ABSIZE_1         (0x2UL << OCTOSPI_WPCCR_ABSIZE_Pos)     /*!< 0x00200000 */
#define OCTOSPI_WPCCR_DMODE_Pos        (24U)
#define OCTOSPI_WPCCR_DMODE_Msk        (0x7UL << OCTOSPI_WPCCR_DMODE_Pos)      /*!< 0x07000000 */
#define OCTOSPI_WPCCR_DMODE            OCTOSPI_WPCCR_DMODE_Msk                 /*!< Data Mode */
#define OCTOSPI_WPCCR_DMODE_0          (0x1UL << OCTOSPI_WPCCR_DMODE_Pos)      /*!< 0x01000000 */
#define OCTOSPI_WPCCR_DMODE_1          (0x2UL << OCTOSPI_WPCCR_DMODE_Pos)      /*!< 0x02000000 */
#define OCTOSPI_WPCCR_DMODE_2          (0x4UL << OCTOSPI_WPCCR_DMODE_Pos)      /*!< 0x04000000 */
#define OCTOSPI_WPCCR_DDTR_Pos         (27U)
#define OCTOSPI_WPCCR_DDTR_Msk         (0x1UL << OCTOSPI_WPCCR_DDTR_Pos)       /*!< 0x08000000 */
#define OCTOSPI_WPCCR_DDTR             OCTOSPI_WPCCR_DDTR_Msk                  /*!< Data Double Transfer Rate */
#define OCTOSPI_WPCCR_DQSE_Pos         (29U)
#define OCTOSPI_WPCCR_DQSE_Msk         (0x1UL << OCTOSPI_WPCCR_DQSE_Pos)       /*!< 0x20000000 */
#define OCTOSPI_WPCCR_DQSE             OCTOSPI_WPCCR_DQSE_Msk                  /*!< DQS Enable */

/****************  Bit definition for OCTOSPI_WPTCR register  *******************/
#define OCTOSPI_WPTCR_DCYC_Pos         (0U)
#define OCTOSPI_WPTCR_DCYC_Msk         (0x1FUL << OCTOSPI_WPTCR_DCYC_Pos)      /*!< 0x0000001F */
#define OCTOSPI_WPTCR_DCYC             OCTOSPI_WPTCR_DCYC_Msk                  /*!< Number of Dummy Cycles */
#define OCTOSPI_WPTCR_DHQC_Pos         (28U)
#define OCTOSPI_WPTCR_DHQC_Msk         (0x1UL << OCTOSPI_WPTCR_DHQC_Pos)       /*!< 0x10000000 */
#define OCTOSPI_WPTCR_DHQC             OCTOSPI_WPTCR_DHQC_Msk                  /*!< Delay Hold Quarter Cycle */
#define OCTOSPI_WPTCR_SSHIFT_Pos       (30U)
#define OCTOSPI_WPTCR_SSHIFT_Msk       (0x1UL << OCTOSPI_WPTCR_SSHIFT_Pos)     /*!< 0x40000000 */
#define OCTOSPI_WPTCR_SSHIFT           OCTOSPI_WPTCR_SSHIFT_Msk                /*!< Sample Shift */

/*****************  Bit definition for OCTOSPI_WPIR register  *******************/
#define OCTOSPI_WPIR_INSTRUCTION_Pos   (0U)
#define OCTOSPI_WPIR_INSTRUCTION_Msk   (0xFFFFFFFFUL << OCTOSPI_WPIR_INSTRUCTION_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_WPIR_INSTRUCTION       OCTOSPI_WPIR_INSTRUCTION_Msk            /*!< Instruction */

/****************  Bit definition for OCTOSPI_WPABR register  *******************/
#define OCTOSPI_WPABR_ALTERNATE_Pos    (0U)
#define OCTOSPI_WPABR_ALTERNATE_Msk    (0xFFFFFFFFUL << OCTOSPI_WPABR_ALTERNATE_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_WPABR_ALTERNATE        OCTOSPI_WPABR_ALTERNATE_Msk             /*!< Alternate Bytes */

/****************  Bit definition for OCTOSPI_WCCR register  ******************/
#define OCTOSPI_WCCR_IMODE_Pos         (0U)
#define OCTOSPI_WCCR_IMODE_Msk         (0x7UL << OCTOSPI_WCCR_IMODE_Pos)       /*!< 0x00000007 */
#define OCTOSPI_WCCR_IMODE             OCTOSPI_WCCR_IMODE_Msk                  /*!< Instruction Mode */
#define OCTOSPI_WCCR_IMODE_0           (0x1UL << OCTOSPI_WCCR_IMODE_Pos)       /*!< 0x00000001 */
#define OCTOSPI_WCCR_IMODE_1           (0x2UL << OCTOSPI_WCCR_IMODE_Pos)       /*!< 0x00000002 */
#define OCTOSPI_WCCR_IMODE_2           (0x4UL << OCTOSPI_WCCR_IMODE_Pos)       /*!< 0x00000004 */
#define OCTOSPI_WCCR_IDTR_Pos          (3U)
#define OCTOSPI_WCCR_IDTR_Msk          (0x1UL << OCTOSPI_WCCR_IDTR_Pos)        /*!< 0x00000008 */
#define OCTOSPI_WCCR_IDTR              OCTOSPI_WCCR_IDTR_Msk                   /*!< Instruction Double Transfer Rate */
#define OCTOSPI_WCCR_ISIZE_Pos         (4U)
#define OCTOSPI_WCCR_ISIZE_Msk         (0x3UL << OCTOSPI_WCCR_ISIZE_Pos)       /*!< 0x00000030 */
#define OCTOSPI_WCCR_ISIZE             OCTOSPI_WCCR_ISIZE_Msk                  /*!< Instruction Size */
#define OCTOSPI_WCCR_ISIZE_0           (0x1UL << OCTOSPI_WCCR_ISIZE_Pos)       /*!< 0x00000010 */
#define OCTOSPI_WCCR_ISIZE_1           (0x2UL << OCTOSPI_WCCR_ISIZE_Pos)       /*!< 0x00000020 */
#define OCTOSPI_WCCR_ADMODE_Pos        (8U)
#define OCTOSPI_WCCR_ADMODE_Msk        (0x7UL << OCTOSPI_WCCR_ADMODE_Pos)      /*!< 0x00000700 */
#define OCTOSPI_WCCR_ADMODE            OCTOSPI_WCCR_ADMODE_Msk                 /*!< Address Mode */
#define OCTOSPI_WCCR_ADMODE_0          (0x1UL << OCTOSPI_WCCR_ADMODE_Pos)      /*!< 0x00000100 */
#define OCTOSPI_WCCR_ADMODE_1          (0x2UL << OCTOSPI_WCCR_ADMODE_Pos)      /*!< 0x00000200 */
#define OCTOSPI_WCCR_ADMODE_2          (0x4UL << OCTOSPI_WCCR_ADMODE_Pos)      /*!< 0x00000400 */
#define OCTOSPI_WCCR_ADDTR_Pos         (11U)
#define OCTOSPI_WCCR_ADDTR_Msk         (0x1UL << OCTOSPI_WCCR_ADDTR_Pos)       /*!< 0x00000800 */
#define OCTOSPI_WCCR_ADDTR             OCTOSPI_WCCR_ADDTR_Msk                  /*!< Address Double Transfer Rate */
#define OCTOSPI_WCCR_ADSIZE_Pos        (12U)
#define OCTOSPI_WCCR_ADSIZE_Msk        (0x3UL << OCTOSPI_WCCR_ADSIZE_Pos)      /*!< 0x00003000 */
#define OCTOSPI_WCCR_ADSIZE            OCTOSPI_WCCR_ADSIZE_Msk                 /*!< Address Size */
#define OCTOSPI_WCCR_ADSIZE_0          (0x1UL << OCTOSPI_WCCR_ADSIZE_Pos)      /*!< 0x00001000 */
#define OCTOSPI_WCCR_ADSIZE_1          (0x2UL << OCTOSPI_WCCR_ADSIZE_Pos)      /*!< 0x00002000 */
#define OCTOSPI_WCCR_ABMODE_Pos        (16U)
#define OCTOSPI_WCCR_ABMODE_Msk        (0x7UL << OCTOSPI_WCCR_ABMODE_Pos)      /*!< 0x00070000 */
#define OCTOSPI_WCCR_ABMODE            OCTOSPI_WCCR_ABMODE_Msk                 /*!< Alternate Bytes Mode */
#define OCTOSPI_WCCR_ABMODE_0          (0x1UL << OCTOSPI_WCCR_ABMODE_Pos)      /*!< 0x00010000 */
#define OCTOSPI_WCCR_ABMODE_1          (0x2UL << OCTOSPI_WCCR_ABMODE_Pos)      /*!< 0x00020000 */
#define OCTOSPI_WCCR_ABMODE_2          (0x4UL << OCTOSPI_WCCR_ABMODE_Pos)      /*!< 0x00040000 */
#define OCTOSPI_WCCR_ABDTR_Pos         (19U)
#define OCTOSPI_WCCR_ABDTR_Msk         (0x1UL << OCTOSPI_WCCR_ABDTR_Pos)       /*!< 0x00080000 */
#define OCTOSPI_WCCR_ABDTR             OCTOSPI_WCCR_ABDTR_Msk                  /*!< Alternate Bytes Double Transfer Rate */
#define OCTOSPI_WCCR_ABSIZE_Pos        (20U)
#define OCTOSPI_WCCR_ABSIZE_Msk        (0x3UL << OCTOSPI_WCCR_ABSIZE_Pos)      /*!< 0x00300000 */
#define OCTOSPI_WCCR_ABSIZE            OCTOSPI_WCCR_ABSIZE_Msk                 /*!< Alternate Bytes Size */
#define OCTOSPI_WCCR_ABSIZE_0          (0x1UL << OCTOSPI_WCCR_ABSIZE_Pos)      /*!< 0x00100000 */
#define OCTOSPI_WCCR_ABSIZE_1          (0x2UL << OCTOSPI_WCCR_ABSIZE_Pos)      /*!< 0x00200000 */
#define OCTOSPI_WCCR_DMODE_Pos         (24U)
#define OCTOSPI_WCCR_DMODE_Msk         (0x7UL << OCTOSPI_WCCR_DMODE_Pos)       /*!< 0x07000000 */
#define OCTOSPI_WCCR_DMODE             OCTOSPI_WCCR_DMODE_Msk                  /*!< Data Mode */
#define OCTOSPI_WCCR_DMODE_0           (0x1UL << OCTOSPI_WCCR_DMODE_Pos)       /*!< 0x01000000 */
#define OCTOSPI_WCCR_DMODE_1           (0x2UL << OCTOSPI_WCCR_DMODE_Pos)       /*!< 0x02000000 */
#define OCTOSPI_WCCR_DMODE_2           (0x4UL << OCTOSPI_WCCR_DMODE_Pos)       /*!< 0x04000000 */
#define OCTOSPI_WCCR_DDTR_Pos          (27U)
#define OCTOSPI_WCCR_DDTR_Msk          (0x1UL << OCTOSPI_WCCR_DDTR_Pos)        /*!< 0x08000000 */
#define OCTOSPI_WCCR_DDTR              OCTOSPI_WCCR_DDTR_Msk                   /*!< Data Double Transfer Rate */
#define OCTOSPI_WCCR_DQSE_Pos          (29U)
#define OCTOSPI_WCCR_DQSE_Msk          (0x1UL << OCTOSPI_WCCR_DQSE_Pos)        /*!< 0x20000000 */
#define OCTOSPI_WCCR_DQSE              OCTOSPI_WCCR_DQSE_Msk                   /*!< DQS Enable */

/****************  Bit definition for OCTOSPI_WTCR register  ******************/
#define OCTOSPI_WTCR_DCYC_Pos          (0U)
#define OCTOSPI_WTCR_DCYC_Msk          (0x1FUL << OCTOSPI_WTCR_DCYC_Pos)       /*!< 0x0000001F */
#define OCTOSPI_WTCR_DCYC              OCTOSPI_WTCR_DCYC_Msk                   /*!< Number of Dummy Cycles */

/****************  Bit definition for OCTOSPI_WIR register  *******************/
#define OCTOSPI_WIR_INSTRUCTION_Pos    (0U)
#define OCTOSPI_WIR_INSTRUCTION_Msk    (0xFFFFFFFFUL << OCTOSPI_WIR_INSTRUCTION_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_WIR_INSTRUCTION        OCTOSPI_WIR_INSTRUCTION_Msk             /*!< Instruction */

/****************  Bit definition for OCTOSPI_WABR register  ******************/
#define OCTOSPI_WABR_ALTERNATE_Pos     (0U)
#define OCTOSPI_WABR_ALTERNATE_Msk     (0xFFFFFFFFUL << OCTOSPI_WABR_ALTERNATE_Pos)/*!< 0xFFFFFFFF */
#define OCTOSPI_WABR_ALTERNATE         OCTOSPI_WABR_ALTERNATE_Msk              /*!< Alternate Bytes */

/****************  Bit definition for OCTOSPI_HLCR register  ******************/
#define OCTOSPI_HLCR_LM_Pos            (0U)
#define OCTOSPI_HLCR_LM_Msk            (0x1UL << OCTOSPI_HLCR_LM_Pos)          /*!< 0x00000001 */
#define OCTOSPI_HLCR_LM                OCTOSPI_HLCR_LM_Msk                     /*!< Latency Mode */
#define OCTOSPI_HLCR_WZL_Pos           (1U)
#define OCTOSPI_HLCR_WZL_Msk           (0x1UL << OCTOSPI_HLCR_WZL_Pos)         /*!< 0x00000002 */
#define OCTOSPI_HLCR_WZL               OCTOSPI_HLCR_WZL_Msk                    /*!< Write Zero Latency */
#define OCTOSPI_HLCR_TACC_Pos          (8U)
#define OCTOSPI_HLCR_TACC_Msk          (0xFFUL << OCTOSPI_HLCR_TACC_Pos)       /*!< 0x0000FF00 */
#define OCTOSPI_HLCR_TACC              OCTOSPI_HLCR_TACC_Msk                   /*!< Access Time */
#define OCTOSPI_HLCR_TRWR_Pos          (16U)
#define OCTOSPI_HLCR_TRWR_Msk          (0xFFUL << OCTOSPI_HLCR_TRWR_Pos)       /*!< 0x00FF0000 */
#define OCTOSPI_HLCR_TRWR              OCTOSPI_HLCR_TRWR_Msk                   /*!< Read Write Recovery Time */

/******************************************************************************/
/*                                                                            */
/*                         Operational Amplifier (OPAMP)                      */
/*                                                                            */
/******************************************************************************/
/*********************  Bit definition for OPAMPx_CSR register  ***************/
#define OPAMP_CSR_OPAMPxEN_Pos           (0U)
#define OPAMP_CSR_OPAMPxEN_Msk           (0x1UL << OPAMP_CSR_OPAMPxEN_Pos)     /*!< 0x00000001 */
#define OPAMP_CSR_OPAMPxEN               OPAMP_CSR_OPAMPxEN_Msk                /*!< OPAMP enable */
#define OPAMP_CSR_OPALPM_Pos             (1U)
#define OPAMP_CSR_OPALPM_Msk             (0x1UL << OPAMP_CSR_OPALPM_Pos)       /*!< 0x00000002 */
#define OPAMP_CSR_OPALPM                 OPAMP_CSR_OPALPM_Msk                  /*!< Operational amplifier Low Power Mode */

#define OPAMP_CSR_OPAMODE_Pos            (2U)
#define OPAMP_CSR_OPAMODE_Msk            (0x3UL << OPAMP_CSR_OPAMODE_Pos)      /*!< 0x0000000C */
#define OPAMP_CSR_OPAMODE                OPAMP_CSR_OPAMODE_Msk                 /*!< Operational amplifier PGA mode */
#define OPAMP_CSR_OPAMODE_0              (0x1UL << OPAMP_CSR_OPAMODE_Pos)      /*!< 0x00000004 */
#define OPAMP_CSR_OPAMODE_1              (0x2UL << OPAMP_CSR_OPAMODE_Pos)      /*!< 0x00000008 */

#define OPAMP_CSR_PGGAIN_Pos             (4U)
#define OPAMP_CSR_PGGAIN_Msk             (0x3UL << OPAMP_CSR_PGGAIN_Pos)       /*!< 0x00000030 */
#define OPAMP_CSR_PGGAIN                 OPAMP_CSR_PGGAIN_Msk                  /*!< Operational amplifier Programmable amplifier gain value */
#define OPAMP_CSR_PGGAIN_0               (0x1UL << OPAMP_CSR_PGGAIN_Pos)       /*!< 0x00000010 */
#define OPAMP_CSR_PGGAIN_1               (0x2UL << OPAMP_CSR_PGGAIN_Pos)       /*!< 0x00000020 */

#define OPAMP_CSR_VMSEL_Pos              (8U)
#define OPAMP_CSR_VMSEL_Msk              (0x3UL << OPAMP_CSR_VMSEL_Pos)        /*!< 0x00000300 */
#define OPAMP_CSR_VMSEL                  OPAMP_CSR_VMSEL_Msk                   /*!< Inverting input selection */
#define OPAMP_CSR_VMSEL_0                (0x1UL << OPAMP_CSR_VMSEL_Pos)        /*!< 0x00000100 */
#define OPAMP_CSR_VMSEL_1                (0x2UL << OPAMP_CSR_VMSEL_Pos)        /*!< 0x00000200 */

#define OPAMP_CSR_VPSEL_Pos              (10U)
#define OPAMP_CSR_VPSEL_Msk              (0x1UL << OPAMP_CSR_VPSEL_Pos)        /*!< 0x00000400 */
#define OPAMP_CSR_VPSEL                  OPAMP_CSR_VPSEL_Msk                   /*!< Non inverted input selection */
#define OPAMP_CSR_CALON_Pos              (12U)
#define OPAMP_CSR_CALON_Msk              (0x1UL << OPAMP_CSR_CALON_Pos)        /*!< 0x00001000 */
#define OPAMP_CSR_CALON                  OPAMP_CSR_CALON_Msk                   /*!< Calibration mode enable */
#define OPAMP_CSR_CALSEL_Pos             (13U)
#define OPAMP_CSR_CALSEL_Msk             (0x1UL << OPAMP_CSR_CALSEL_Pos)       /*!< 0x00002000 */
#define OPAMP_CSR_CALSEL                 OPAMP_CSR_CALSEL_Msk                  /*!< Calibration selection */
#define OPAMP_CSR_USERTRIM_Pos           (14U)
#define OPAMP_CSR_USERTRIM_Msk           (0x1UL << OPAMP_CSR_USERTRIM_Pos)     /*!< 0x00004000 */
#define OPAMP_CSR_USERTRIM               OPAMP_CSR_USERTRIM_Msk                /*!< User trimming enable */
#define OPAMP_CSR_CALOUT_Pos             (15U)
#define OPAMP_CSR_CALOUT_Msk             (0x1UL << OPAMP_CSR_CALOUT_Pos)       /*!< 0x00008000 */
#define OPAMP_CSR_CALOUT                 OPAMP_CSR_CALOUT_Msk                  /*!< Operational amplifier1 calibration output */

/*********************  Bit definition for OPAMP1_CSR register  ***************/
#define OPAMP1_CSR_OPAEN_Pos              (0U)
#define OPAMP1_CSR_OPAEN_Msk              (0x1UL << OPAMP1_CSR_OPAEN_Pos)      /*!< 0x00000001 */
#define OPAMP1_CSR_OPAEN                  OPAMP1_CSR_OPAEN_Msk                 /*!< Operational amplifier1 Enable */
#define OPAMP1_CSR_OPALPM_Pos             (1U)
#define OPAMP1_CSR_OPALPM_Msk             (0x1UL << OPAMP1_CSR_OPALPM_Pos)     /*!< 0x00000002 */
#define OPAMP1_CSR_OPALPM                 OPAMP1_CSR_OPALPM_Msk                /*!< Operational amplifier1 Low Power Mode */

#define OPAMP1_CSR_OPAMODE_Pos            (2U)
#define OPAMP1_CSR_OPAMODE_Msk            (0x3UL << OPAMP1_CSR_OPAMODE_Pos)    /*!< 0x0000000C */
#define OPAMP1_CSR_OPAMODE                OPAMP1_CSR_OPAMODE_Msk               /*!< Operational amplifier1 PGA mode */
#define OPAMP1_CSR_OPAMODE_0              (0x1UL << OPAMP1_CSR_OPAMODE_Pos)    /*!< 0x00000004 */
#define OPAMP1_CSR_OPAMODE_1              (0x2UL << OPAMP1_CSR_OPAMODE_Pos)    /*!< 0x00000008 */

#define OPAMP1_CSR_PGAGAIN_Pos            (4U)
#define OPAMP1_CSR_PGAGAIN_Msk            (0x3UL << OPAMP1_CSR_PGAGAIN_Pos)    /*!< 0x00000030 */
#define OPAMP1_CSR_PGAGAIN                OPAMP1_CSR_PGAGAIN_Msk               /*!< Operational amplifier1 Programmable amplifier gain value */
#define OPAMP1_CSR_PGAGAIN_0              (0x1UL << OPAMP1_CSR_PGAGAIN_Pos)    /*!< 0x00000010 */
#define OPAMP1_CSR_PGAGAIN_1              (0x2UL << OPAMP1_CSR_PGAGAIN_Pos)    /*!< 0x00000020 */

#define OPAMP1_CSR_VMSEL_Pos              (8U)
#define OPAMP1_CSR_VMSEL_Msk              (0x3UL << OPAMP1_CSR_VMSEL_Pos)      /*!< 0x00000300 */
#define OPAMP1_CSR_VMSEL                  OPAMP1_CSR_VMSEL_Msk                 /*!< Inverting input selection */
#define OPAMP1_CSR_VMSEL_0                (0x1UL << OPAMP1_CSR_VMSEL_Pos)      /*!< 0x00000100 */
#define OPAMP1_CSR_VMSEL_1                (0x2UL << OPAMP1_CSR_VMSEL_Pos)      /*!< 0x00000200 */

#define OPAMP1_CSR_VPSEL_Pos              (10U)
#define OPAMP1_CSR_VPSEL_Msk              (0x1UL << OPAMP1_CSR_VPSEL_Pos)      /*!< 0x00000400 */
#define OPAMP1_CSR_VPSEL                  OPAMP1_CSR_VPSEL_Msk                 /*!< Non inverted input selection */
#define OPAMP1_CSR_CALON_Pos              (12U)
#define OPAMP1_CSR_CALON_Msk              (0x1UL << OPAMP1_CSR_CALON_Pos)      /*!< 0x00001000 */
#define OPAMP1_CSR_CALON                  OPAMP1_CSR_CALON_Msk                 /*!< Calibration mode enable */
#define OPAMP1_CSR_CALSEL_Pos             (13U)
#define OPAMP1_CSR_CALSEL_Msk             (0x1UL << OPAMP1_CSR_CALSEL_Pos)     /*!< 0x00002000 */
#define OPAMP1_CSR_CALSEL                 OPAMP1_CSR_CALSEL_Msk                /*!< Calibration selection */
#define OPAMP1_CSR_USERTRIM_Pos           (14U)
#define OPAMP1_CSR_USERTRIM_Msk           (0x1UL << OPAMP1_CSR_USERTRIM_Pos)   /*!< 0x00004000 */
#define OPAMP1_CSR_USERTRIM               OPAMP1_CSR_USERTRIM_Msk              /*!< User trimming enable */
#define OPAMP1_CSR_CALOUT_Pos             (15U)
#define OPAMP1_CSR_CALOUT_Msk             (0x1UL << OPAMP1_CSR_CALOUT_Pos)     /*!< 0x00008000 */
#define OPAMP1_CSR_CALOUT                 OPAMP1_CSR_CALOUT_Msk                /*!< Operational amplifier1 calibration output */

#define OPAMP1_CSR_OPARANGE_Pos           (31U)
#define OPAMP1_CSR_OPARANGE_Msk           (0x1UL << OPAMP1_CSR_OPARANGE_Pos)   /*!< 0x80000000 */
#define OPAMP1_CSR_OPARANGE               OPAMP1_CSR_OPARANGE_Msk              /*!< Common to several OPAMP instances: Operational amplifier voltage supply range. Bit intended to be used with OPAMP common instance (OPAMP_Common_TypeDef) */

/*********************  Bit definition for OPAMP2_CSR register  ***************/
#define OPAMP2_CSR_OPAEN_Pos              (0U)
#define OPAMP2_CSR_OPAEN_Msk              (0x1UL << OPAMP2_CSR_OPAEN_Pos)      /*!< 0x00000001 */
#define OPAMP2_CSR_OPAEN                  OPAMP2_CSR_OPAEN_Msk                 /*!< Operational amplifier2 Enable */
#define OPAMP2_CSR_OPALPM_Pos             (1U)
#define OPAMP2_CSR_OPALPM_Msk             (0x1UL << OPAMP2_CSR_OPALPM_Pos)     /*!< 0x00000002 */
#define OPAMP2_CSR_OPALPM                 OPAMP2_CSR_OPALPM_Msk                /*!< Operational amplifier2 Low Power Mode */

#define OPAMP2_CSR_OPAMODE_Pos            (2U)
#define OPAMP2_CSR_OPAMODE_Msk            (0x3UL << OPAMP2_CSR_OPAMODE_Pos)    /*!< 0x0000000C */
#define OPAMP2_CSR_OPAMODE                OPAMP2_CSR_OPAMODE_Msk               /*!< Operational amplifier2 PGA mode */
#define OPAMP2_CSR_OPAMODE_0              (0x1UL << OPAMP2_CSR_OPAMODE_Pos)    /*!< 0x00000004 */
#define OPAMP2_CSR_OPAMODE_1              (0x2UL << OPAMP2_CSR_OPAMODE_Pos)    /*!< 0x00000008 */

#define OPAMP2_CSR_PGAGAIN_Pos            (4U)
#define OPAMP2_CSR_PGAGAIN_Msk            (0x3UL << OPAMP2_CSR_PGAGAIN_Pos)    /*!< 0x00000030 */
#define OPAMP2_CSR_PGAGAIN                OPAMP2_CSR_PGAGAIN_Msk               /*!< Operational amplifier2 Programmable amplifier gain value */
#define OPAMP2_CSR_PGAGAIN_0              (0x1UL << OPAMP2_CSR_PGAGAIN_Pos)    /*!< 0x00000010 */
#define OPAMP2_CSR_PGAGAIN_1              (0x2UL << OPAMP2_CSR_PGAGAIN_Pos)    /*!< 0x00000020 */

#define OPAMP2_CSR_VMSEL_Pos              (8U)
#define OPAMP2_CSR_VMSEL_Msk              (0x3UL << OPAMP2_CSR_VMSEL_Pos)      /*!< 0x00000300 */
#define OPAMP2_CSR_VMSEL                  OPAMP2_CSR_VMSEL_Msk                 /*!< Inverting input selection */
#define OPAMP2_CSR_VMSEL_0                (0x1UL << OPAMP2_CSR_VMSEL_Pos)      /*!< 0x00000100 */
#define OPAMP2_CSR_VMSEL_1                (0x2UL << OPAMP2_CSR_VMSEL_Pos)      /*!< 0x00000200 */

#define OPAMP2_CSR_VPSEL_Pos              (10U)
#define OPAMP2_CSR_VPSEL_Msk              (0x1UL << OPAMP2_CSR_VPSEL_Pos)      /*!< 0x00000400 */
#define OPAMP2_CSR_VPSEL                  OPAMP2_CSR_VPSEL_Msk                 /*!< Non inverted input selection */
#define OPAMP2_CSR_CALON_Pos              (12U)
#define OPAMP2_CSR_CALON_Msk              (0x1UL << OPAMP2_CSR_CALON_Pos)      /*!< 0x00001000 */
#define OPAMP2_CSR_CALON                  OPAMP2_CSR_CALON_Msk                 /*!< Calibration mode enable */
#define OPAMP2_CSR_CALSEL_Pos             (13U)
#define OPAMP2_CSR_CALSEL_Msk             (0x1UL << OPAMP2_CSR_CALSEL_Pos)     /*!< 0x00002000 */
#define OPAMP2_CSR_CALSEL                 OPAMP2_CSR_CALSEL_Msk                /*!< Calibration selection */
#define OPAMP2_CSR_USERTRIM_Pos           (14U)
#define OPAMP2_CSR_USERTRIM_Msk           (0x1UL << OPAMP2_CSR_USERTRIM_Pos)   /*!< 0x00004000 */
#define OPAMP2_CSR_USERTRIM               OPAMP2_CSR_USERTRIM_Msk              /*!< User trimming enable */
#define OPAMP2_CSR_CALOUT_Pos             (15U)
#define OPAMP2_CSR_CALOUT_Msk             (0x1UL << OPAMP2_CSR_CALOUT_Pos)     /*!< 0x00008000 */
#define OPAMP2_CSR_CALOUT                 OPAMP2_CSR_CALOUT_Msk                /*!< Operational amplifier2 calibration output */

/*******************  Bit definition for OPAMP_OTR register  ******************/
#define OPAMP_OTR_TRIMOFFSETN_Pos        (0U)
#define OPAMP_OTR_TRIMOFFSETN_Msk        (0x1FUL << OPAMP_OTR_TRIMOFFSETN_Pos) /*!< 0x0000001F */
#define OPAMP_OTR_TRIMOFFSETN            OPAMP_OTR_TRIMOFFSETN_Msk             /*!< Trim for NMOS differential pairs */
#define OPAMP_OTR_TRIMOFFSETP_Pos        (8U)
#define OPAMP_OTR_TRIMOFFSETP_Msk        (0x1FUL << OPAMP_OTR_TRIMOFFSETP_Pos) /*!< 0x00001F00 */
#define OPAMP_OTR_TRIMOFFSETP            OPAMP_OTR_TRIMOFFSETP_Msk             /*!< Trim for PMOS differential pairs */

/*******************  Bit definition for OPAMP1_OTR register  ******************/
#define OPAMP1_OTR_TRIMOFFSETN_Pos        (0U)
#define OPAMP1_OTR_TRIMOFFSETN_Msk        (0x1FUL << OPAMP1_OTR_TRIMOFFSETN_Pos)/*!< 0x0000001F */
#define OPAMP1_OTR_TRIMOFFSETN            OPAMP1_OTR_TRIMOFFSETN_Msk           /*!< Trim for NMOS differential pairs */
#define OPAMP1_OTR_TRIMOFFSETP_Pos        (8U)
#define OPAMP1_OTR_TRIMOFFSETP_Msk        (0x1FUL << OPAMP1_OTR_TRIMOFFSETP_Pos)/*!< 0x00001F00 */
#define OPAMP1_OTR_TRIMOFFSETP            OPAMP1_OTR_TRIMOFFSETP_Msk           /*!< Trim for PMOS differential pairs */

/*******************  Bit definition for OPAMP2_OTR register  ******************/
#define OPAMP2_OTR_TRIMOFFSETN_Pos        (0U)
#define OPAMP2_OTR_TRIMOFFSETN_Msk        (0x1FUL << OPAMP2_OTR_TRIMOFFSETN_Pos)/*!< 0x0000001F */
#define OPAMP2_OTR_TRIMOFFSETN            OPAMP2_OTR_TRIMOFFSETN_Msk           /*!< Trim for NMOS differential pairs */
#define OPAMP2_OTR_TRIMOFFSETP_Pos        (8U)
#define OPAMP2_OTR_TRIMOFFSETP_Msk        (0x1FUL << OPAMP2_OTR_TRIMOFFSETP_Pos)/*!< 0x00001F00 */
#define OPAMP2_OTR_TRIMOFFSETP            OPAMP2_OTR_TRIMOFFSETP_Msk           /*!< Trim for PMOS differential pairs */

/*******************  Bit definition for OPAMP_LPOTR register  ****************/
#define OPAMP_LPOTR_TRIMLPOFFSETN_Pos    (0U)
#define OPAMP_LPOTR_TRIMLPOFFSETN_Msk    (0x1FUL << OPAMP_LPOTR_TRIMLPOFFSETN_Pos)/*!< 0x0000001F */
#define OPAMP_LPOTR_TRIMLPOFFSETN        OPAMP_LPOTR_TRIMLPOFFSETN_Msk         /*!< Trim for NMOS differential pairs */
#define OPAMP_LPOTR_TRIMLPOFFSETP_Pos    (8U)
#define OPAMP_LPOTR_TRIMLPOFFSETP_Msk    (0x1FUL << OPAMP_LPOTR_TRIMLPOFFSETP_Pos)/*!< 0x00001F00 */
#define OPAMP_LPOTR_TRIMLPOFFSETP        OPAMP_LPOTR_TRIMLPOFFSETP_Msk         /*!< Trim for PMOS differential pairs */

/*******************  Bit definition for OPAMP1_LPOTR register  ****************/
#define OPAMP1_LPOTR_TRIMLPOFFSETN_Pos    (0U)
#define OPAMP1_LPOTR_TRIMLPOFFSETN_Msk    (0x1FUL << OPAMP1_LPOTR_TRIMLPOFFSETN_Pos)/*!< 0x0000001F */
#define OPAMP1_LPOTR_TRIMLPOFFSETN        OPAMP1_LPOTR_TRIMLPOFFSETN_Msk       /*!< Trim for NMOS differential pairs */
#define OPAMP1_LPOTR_TRIMLPOFFSETP_Pos    (8U)
#define OPAMP1_LPOTR_TRIMLPOFFSETP_Msk    (0x1FUL << OPAMP1_LPOTR_TRIMLPOFFSETP_Pos)/*!< 0x00001F00 */
#define OPAMP1_LPOTR_TRIMLPOFFSETP        OPAMP1_LPOTR_TRIMLPOFFSETP_Msk       /*!< Trim for PMOS differential pairs */

/*******************  Bit definition for OPAMP2_LPOTR register  ****************/
#define OPAMP2_LPOTR_TRIMLPOFFSETN_Pos    (0U)
#define OPAMP2_LPOTR_TRIMLPOFFSETN_Msk    (0x1FUL << OPAMP2_LPOTR_TRIMLPOFFSETN_Pos)/*!< 0x0000001F */
#define OPAMP2_LPOTR_TRIMLPOFFSETN        OPAMP2_LPOTR_TRIMLPOFFSETN_Msk       /*!< Trim for NMOS differential pairs */
#define OPAMP2_LPOTR_TRIMLPOFFSETP_Pos    (8U)
#define OPAMP2_LPOTR_TRIMLPOFFSETP_Msk    (0x1FUL << OPAMP2_LPOTR_TRIMLPOFFSETP_Pos)/*!< 0x00001F00 */
#define OPAMP2_LPOTR_TRIMLPOFFSETP        OPAMP2_LPOTR_TRIMLPOFFSETP_Msk       /*!< Trim for PMOS differential pairs */


/******************************************************************************/
/*                                                                            */
/*                             Power Control                                  */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for PWR_CR1 register  ********************/
#define PWR_CR1_LPMS_Pos             (0U)
#define PWR_CR1_LPMS_Msk             (0x7UL << PWR_CR1_LPMS_Pos)               /*!< 0x00000007 */
#define PWR_CR1_LPMS                 PWR_CR1_LPMS_Msk                          /*!< Low-power mode selection field */
#define PWR_CR1_LPMS_0               (0x1UL << PWR_CR1_LPMS_Pos)               /*!< 0x00000001 */
#define PWR_CR1_LPMS_1               (0x2UL << PWR_CR1_LPMS_Pos)               /*!< 0x00000002 */
#define PWR_CR1_LPMS_2               (0x4UL << PWR_CR1_LPMS_Pos)               /*!< 0x00000004 */

#define PWR_CR1_LPMS_STOP0           (0UL)                                     /*!< Stop 0 mode */
#define PWR_CR1_LPMS_STOP1           PWR_CR1_LPMS_0                            /*!< Stop 1 mode */
#define PWR_CR1_LPMS_STOP2           PWR_CR1_LPMS_1                            /*!< Stop 2 mode */
#define PWR_CR1_LPMS_STANDBY         (PWR_CR1_LPMS_1 | PWR_CR1_LPMS_0)         /*!< Stand-by mode */
#define PWR_CR1_LPMS_SHUTDOWN        PWR_CR1_LPMS_2                            /*!< Shut-down mode */

#define PWR_CR1_DBP_Pos              (8U)
#define PWR_CR1_DBP_Msk              (0x1UL << PWR_CR1_DBP_Pos)                /*!< 0x00000100 */
#define PWR_CR1_DBP                  PWR_CR1_DBP_Msk                           /*!< Disable Back-up domain Protection */

#define PWR_CR1_VOS_Pos              (9U)
#define PWR_CR1_VOS_Msk              (0x3UL << PWR_CR1_VOS_Pos)                /*!< 0x0000C000 */
#define PWR_CR1_VOS                  PWR_CR1_VOS_Msk                           /*!< VOS[1:0] bits (Regulator voltage scaling output selection) */
#define PWR_CR1_VOS_0                (0x1UL << PWR_CR1_VOS_Pos)                /*!< 0x00004000 */
#define PWR_CR1_VOS_1                (0x2UL << PWR_CR1_VOS_Pos)                /*!< 0x00008000 */

#define PWR_CR1_LPR_Pos              (14U)
#define PWR_CR1_LPR_Msk              (0x1UL << PWR_CR1_LPR_Pos)                /*!< 0x00004000 */
#define PWR_CR1_LPR                  PWR_CR1_LPR_Msk                           /*!< Regulator low-power mode */

/********************  Bit definition for PWR_CR2 register  ********************/
#define PWR_CR2_PVDE_Pos             (0U)
#define PWR_CR2_PVDE_Msk             (0x1UL << PWR_CR2_PVDE_Pos)               /*!< 0x00000001 */
#define PWR_CR2_PVDE                 PWR_CR2_PVDE_Msk                          /*!< Power Voltage Detector Enable */
#define PWR_CR2_PLS_Pos              (1U)
#define PWR_CR2_PLS_Msk              (0x7UL << PWR_CR2_PLS_Pos)                /*!< 0x0000000E */
#define PWR_CR2_PLS                  PWR_CR2_PLS_Msk                           /*!< PVD level selection */
#define PWR_CR2_PLS_0                (0x1UL << PWR_CR2_PLS_Pos)                /*!< 0x00000002 */
#define PWR_CR2_PLS_1                (0x2UL << PWR_CR2_PLS_Pos)                /*!< 0x00000004 */
#define PWR_CR2_PLS_2                (0x4UL << PWR_CR2_PLS_Pos)                /*!< 0x00000008 */

#define PWR_CR2_PLS_LEV0             (0UL)                                     /*!< PVD level 0 */
#define PWR_CR2_PLS_LEV1             PWR_CR2_PLS_0                             /*!< PVD level 1 */
#define PWR_CR2_PLS_LEV2             PWR_CR2_PLS_1                             /*!< PVD level 2 */
#define PWR_CR2_PLS_LEV3             (PWR_CR2_PLS_1 | PWR_CR2_PLS_0)           /*!< PVD level 3 */
#define PWR_CR2_PLS_LEV4             PWR_CR2_PLS_2                             /*!< PVD level 4 */
#define PWR_CR2_PLS_LEV5             (PWR_CR2_PLS_2 | PWR_CR2_PLS_0)           /*!< PVD level 5 */
#define PWR_CR2_PLS_LEV6             (PWR_CR2_PLS_2 | PWR_CR2_PLS_1)           /*!< PVD level 6 */
#define PWR_CR2_PLS_LEV7             (PWR_CR2_PLS_2 | PWR_CR2_PLS_1 | PWR_CR2_PLS_0) /*!< PVD level 7 */

#define PWR_CR2_PVME_Pos             (4U)
#define PWR_CR2_PVME_Msk             (0xFUL << PWR_CR2_PVME_Pos)               /*!< 0x000000F0 */
#define PWR_CR2_PVME                 PWR_CR2_PVME_Msk                          /*!< PVM bits field */
#define PWR_CR2_PVME1_Pos            (4U)
#define PWR_CR2_PVME1_Msk            (0x1UL << PWR_CR2_PVME1_Pos)              /*!< 0x00000010 */
#define PWR_CR2_PVME1                PWR_CR2_PVME1_Msk                         /*!< PVM 1 Enable */
#define PWR_CR2_PVME2_Pos            (5U)
#define PWR_CR2_PVME2_Msk            (0x1UL << PWR_CR2_PVME2_Pos)              /*!< 0x00000020 */
#define PWR_CR2_PVME2                PWR_CR2_PVME2_Msk                         /*!< PVM 2 Enable */
#define PWR_CR2_PVME3_Pos            (6U)
#define PWR_CR2_PVME3_Msk            (0x1UL << PWR_CR2_PVME3_Pos)              /*!< 0x00000040 */
#define PWR_CR2_PVME3                PWR_CR2_PVME3_Msk                         /*!< PVM 3 Enable */
#define PWR_CR2_PVME4_Pos            (7U)
#define PWR_CR2_PVME4_Msk            (0x1UL << PWR_CR2_PVME4_Pos)              /*!< 0x00000080 */
#define PWR_CR2_PVME4                PWR_CR2_PVME4_Msk                         /*!< PVM 4 Enable */

#define PWR_CR2_IOSV_Pos             (9U)
#define PWR_CR2_IOSV_Msk             (0x1UL << PWR_CR2_IOSV_Pos)               /*!< 0x00000200 */
#define PWR_CR2_IOSV                 PWR_CR2_IOSV_Msk                          /*!< VDD IO2 independent I/Os Supply Valid */
#define PWR_CR2_USV_Pos              (10U)
#define PWR_CR2_USV_Msk              (0x1UL << PWR_CR2_USV_Pos)                /*!< 0x00000400 */
#define PWR_CR2_USV                  PWR_CR2_USV_Msk                           /*!< VDD USB Supply Valid */

/********************  Bit definition for PWR_CR3 register  ********************/
#define PWR_CR3_EWUP_Pos             (0U)
#define PWR_CR3_EWUP_Msk             (0x1FUL << PWR_CR3_EWUP_Pos)              /*!< 0x0000001F */
#define PWR_CR3_EWUP                 PWR_CR3_EWUP_Msk                          /*!< Enable Wake-Up Pins  */
#define PWR_CR3_EWUP1_Pos            (0U)
#define PWR_CR3_EWUP1_Msk            (0x1UL << PWR_CR3_EWUP1_Pos)              /*!< 0x00000001 */
#define PWR_CR3_EWUP1                PWR_CR3_EWUP1_Msk                         /*!< Enable Wake-Up Pin 1 */
#define PWR_CR3_EWUP2_Pos            (1U)
#define PWR_CR3_EWUP2_Msk            (0x1UL << PWR_CR3_EWUP2_Pos)              /*!< 0x00000002 */
#define PWR_CR3_EWUP2                PWR_CR3_EWUP2_Msk                         /*!< Enable Wake-Up Pin 2 */
#define PWR_CR3_EWUP3_Pos            (2U)
#define PWR_CR3_EWUP3_Msk            (0x1UL << PWR_CR3_EWUP3_Pos)              /*!< 0x00000004 */
#define PWR_CR3_EWUP3                PWR_CR3_EWUP3_Msk                         /*!< Enable Wake-Up Pin 3 */
#define PWR_CR3_EWUP4_Pos            (3U)
#define PWR_CR3_EWUP4_Msk            (0x1UL << PWR_CR3_EWUP4_Pos)              /*!< 0x00000008 */
#define PWR_CR3_EWUP4                PWR_CR3_EWUP4_Msk                         /*!< Enable Wake-Up Pin 4 */
#define PWR_CR3_EWUP5_Pos            (4U)
#define PWR_CR3_EWUP5_Msk            (0x1UL << PWR_CR3_EWUP5_Pos)              /*!< 0x00000010 */
#define PWR_CR3_EWUP5                PWR_CR3_EWUP5_Msk                         /*!< Enable Wake-Up Pin 5 */

#define PWR_CR3_RRS_Pos              (8U)
#define PWR_CR3_RRS_Msk              (0x3UL << PWR_CR3_RRS_Pos)                /*!< 0x00000100 */
#define PWR_CR3_RRS                  PWR_CR3_RRS_Msk                           /*!< RRS[1:0] bits (Ram retention in STANDBY mode)*/
#define PWR_CR3_RRS_0                (0x1UL << PWR_CR3_RRS_Pos)                /*!< 0x00000100 */
#define PWR_CR3_RRS_1                (0x2UL << PWR_CR3_RRS_Pos)                /*!< 0x00000200 */

#define PWR_CR3_APC_Pos              (10U)
#define PWR_CR3_APC_Msk              (0x1UL << PWR_CR3_APC_Pos)                /*!< 0x00000400 */
#define PWR_CR3_APC                  PWR_CR3_APC_Msk                           /*!< Apply pull-up and pull-down configuration */
#define PWR_CR3_ULPMEN_Pos           (11U)
#define PWR_CR3_ULPMEN_Msk           (0x1UL << PWR_CR3_ULPMEN_Pos)             /*!< 0x00000800 */
#define PWR_CR3_ULPMEN               PWR_CR3_ULPMEN_Msk                        /*!< Ultra Low Power Mode Enable */
#define PWR_CR3_UCPD_STDBY_Pos       (13U)
#define PWR_CR3_UCPD_STDBY_Msk       (0x1UL << PWR_CR3_UCPD_STDBY_Pos)         /*!< 0x00002000 */
#define PWR_CR3_UCPD_STDBY           PWR_CR3_UCPD_STDBY_Msk                    /*!< UCPD Configuration memorize when enter in STANDBY */
#define PWR_CR3_UCPD_DBDIS_Pos       (14U)
#define PWR_CR3_UCPD_DBDIS_Msk       (0x1UL << PWR_CR3_UCPD_DBDIS_Pos)         /*!< 0x00004000 */
#define PWR_CR3_UCPD_DBDIS           PWR_CR3_UCPD_DBDIS_Msk                    /*!< Dead Battery Behavior Disable */

/********************  Bit definition for PWR_CR4 register  ********************/
#define PWR_CR4_WUPP1_Pos            (0U)
#define PWR_CR4_WUPP1_Msk            (0x1UL << PWR_CR4_WUPP1_Pos)              /*!< 0x00000001 */
#define PWR_CR4_WUPP1                PWR_CR4_WUPP1_Msk                         /*!< Wake-Up Pin 1 polarity */
#define PWR_CR4_WUPP2_Pos            (1U)
#define PWR_CR4_WUPP2_Msk            (0x1UL << PWR_CR4_WUPP2_Pos)              /*!< 0x00000002 */
#define PWR_CR4_WUPP2                PWR_CR4_WUPP2_Msk                         /*!< Wake-Up Pin 2 polarity */
#define PWR_CR4_WUPP3_Pos            (2U)
#define PWR_CR4_WUPP3_Msk            (0x1UL << PWR_CR4_WUPP3_Pos)              /*!< 0x00000004 */
#define PWR_CR4_WUPP3                PWR_CR4_WUPP3_Msk                         /*!< Wake-Up Pin 3 polarity */
#define PWR_CR4_WUPP4_Pos            (3U)
#define PWR_CR4_WUPP4_Msk            (0x1UL << PWR_CR4_WUPP4_Pos)              /*!< 0x00000008 */
#define PWR_CR4_WUPP4                PWR_CR4_WUPP4_Msk                         /*!< Wake-Up Pin 4 polarity */
#define PWR_CR4_WUPP5_Pos            (4U)
#define PWR_CR4_WUPP5_Msk            (0x1UL << PWR_CR4_WUPP5_Pos)              /*!< 0x00000010 */
#define PWR_CR4_WUPP5                PWR_CR4_WUPP5_Msk                         /*!< Wake-Up Pin 5 polarity */
#define PWR_CR4_VBE_Pos              (8U)
#define PWR_CR4_VBE_Msk              (0x1UL << PWR_CR4_VBE_Pos)                /*!< 0x00000100 */
#define PWR_CR4_VBE                  PWR_CR4_VBE_Msk                           /*!< VBAT Battery charging Enable  */
#define PWR_CR4_VBRS_Pos             (9U)
#define PWR_CR4_VBRS_Msk             (0x1UL << PWR_CR4_VBRS_Pos)               /*!< 0x00000200 */
#define PWR_CR4_VBRS                 PWR_CR4_VBRS_Msk                          /*!< VBAT Battery charging Resistor Selection */
#define PWR_CR4_SMPSBYP_Pos          (12U)
#define PWR_CR4_SMPSBYP_Msk          (0x1UL << PWR_CR4_SMPSBYP_Pos)            /*!< 0x00001000 */
#define PWR_CR4_SMPSBYP              PWR_CR4_SMPSBYP_Msk                       /*!< SMPS Bypass mode */
#define PWR_CR4_EXTSMPSEN_Pos        (13U)
#define PWR_CR4_EXTSMPSEN_Msk        (0x1UL << PWR_CR4_EXTSMPSEN_Pos)          /*!< 0x00002000 */
#define PWR_CR4_EXTSMPSEN            PWR_CR4_EXTSMPSEN_Msk                     /*!< External SMPS mode */
#define PWR_CR4_SMPSFSTEN_Pos        (14U)
#define PWR_CR4_SMPSFSTEN_Msk        (0x1UL << PWR_CR4_SMPSFSTEN_Pos)          /*!< 0x00004000 */
#define PWR_CR4_SMPSFSTEN            PWR_CR4_SMPSFSTEN_Msk                     /*!< SMPS fast soft start */
#define PWR_CR4_SMPSLPEN_Pos         (15U)
#define PWR_CR4_SMPSLPEN_Msk         (0x1UL << PWR_CR4_SMPSLPEN_Pos)           /*!< 0x00008000 */
#define PWR_CR4_SMPSLPEN             PWR_CR4_SMPSLPEN_Msk                      /*!< SMPS low-power mode */

/********************  Bit definition for PWR_SR1 register  ********************/
#define PWR_SR1_WUF_Pos              (0U)
#define PWR_SR1_WUF_Msk              (0x1FUL << PWR_SR1_WUF_Pos)               /*!< 0x0000001F */
#define PWR_SR1_WUF                  PWR_SR1_WUF_Msk                           /*!< Wake-up Flags */
#define PWR_SR1_WUF1_Pos             (0U)
#define PWR_SR1_WUF1_Msk             (0x1UL << PWR_SR1_WUF1_Pos)               /*!< 0x00000001 */
#define PWR_SR1_WUF1                 PWR_SR1_WUF1_Msk                          /*!< Wake-up Flag 1 */
#define PWR_SR1_WUF2_Pos             (1U)
#define PWR_SR1_WUF2_Msk             (0x1UL << PWR_SR1_WUF2_Pos)               /*!< 0x00000002 */
#define PWR_SR1_WUF2                 PWR_SR1_WUF2_Msk                          /*!< Wake-up Flag 2 */
#define PWR_SR1_WUF3_Pos             (2U)
#define PWR_SR1_WUF3_Msk             (0x1UL << PWR_SR1_WUF3_Pos)               /*!< 0x00000004 */
#define PWR_SR1_WUF3                 PWR_SR1_WUF3_Msk                          /*!< Wake-up Flag 3 */
#define PWR_SR1_WUF4_Pos             (3U)
#define PWR_SR1_WUF4_Msk             (0x1UL << PWR_SR1_WUF4_Pos)               /*!< 0x00000008 */
#define PWR_SR1_WUF4                 PWR_SR1_WUF4_Msk                          /*!< Wake-up Flag 4 */
#define PWR_SR1_WUF5_Pos             (4U)
#define PWR_SR1_WUF5_Msk             (0x1UL << PWR_SR1_WUF5_Pos)               /*!< 0x00000010 */
#define PWR_SR1_WUF5                 PWR_SR1_WUF5_Msk                          /*!< Wake-up Flag 5 */
#define PWR_SR1_SBF_Pos              (8U)
#define PWR_SR1_SBF_Msk              (0x1UL << PWR_SR1_SBF_Pos)                /*!< 0x00000100 */
#define PWR_SR1_SBF                  PWR_SR1_SBF_Msk                           /*!< Stand-By Flag */
#define PWR_SR1_SMPSBYPRDY_Pos       (12U)
#define PWR_SR1_SMPSBYPRDY_Msk       (0x1UL << PWR_SR1_SMPSBYPRDY_Pos)         /*!< 0x00001000 */
#define PWR_SR1_SMPSBYPRDY           PWR_SR1_SMPSBYPRDY_Msk                    /*!< SMPS Bypass ready */
#define PWR_SR1_EXTSMPSRDY_Pos       (13U)
#define PWR_SR1_EXTSMPSRDY_Msk       (0x1UL << PWR_SR1_EXTSMPSRDY_Pos)         /*!< 0x00002000 */
#define PWR_SR1_EXTSMPSRDY           PWR_SR1_EXTSMPSRDY_Msk                    /*!< External SMPS mode ready */
#define PWR_SR1_SMPSHPRDY_Pos        (15U)
#define PWR_SR1_SMPSHPRDY_Msk        (0x1UL << PWR_SR1_SMPSHPRDY_Pos)          /*!< 0x00008000 */
#define PWR_SR1_SMPSHPRDY            PWR_SR1_SMPSHPRDY_Msk                     /*!< SMPS High-power mode ready */

/********************  Bit definition for PWR_SR2 register  ********************/
#define PWR_SR2_REGLPS_Pos           (8U)
#define PWR_SR2_REGLPS_Msk           (0x1UL << PWR_SR2_REGLPS_Pos)             /*!< 0x00000100 */
#define PWR_SR2_REGLPS               PWR_SR2_REGLPS_Msk                        /*!< Low-power Regulator Started */
#define PWR_SR2_REGLPF_Pos           (9U)
#define PWR_SR2_REGLPF_Msk           (0x1UL << PWR_SR2_REGLPF_Pos)             /*!< 0x00000200 */
#define PWR_SR2_REGLPF               PWR_SR2_REGLPF_Msk                        /*!< Low-power Regulator Flag */
#define PWR_SR2_VOSF_Pos             (10U)
#define PWR_SR2_VOSF_Msk             (0x1UL << PWR_SR2_VOSF_Pos)               /*!< 0x00000400 */
#define PWR_SR2_VOSF                 PWR_SR2_VOSF_Msk                          /*!< Voltage Scaling Flag */
#define PWR_SR2_PVDO_Pos             (11U)
#define PWR_SR2_PVDO_Msk             (0x1UL << PWR_SR2_PVDO_Pos)               /*!< 0x00000800 */
#define PWR_SR2_PVDO                 PWR_SR2_PVDO_Msk                          /*!< Power Voltage Detector Output */
#define PWR_SR2_PVMO1_Pos            (12U)
#define PWR_SR2_PVMO1_Msk            (0x1UL << PWR_SR2_PVMO1_Pos)              /*!< 0x00001000 */
#define PWR_SR2_PVMO1                PWR_SR2_PVMO1_Msk                         /*!< Peripheral Voltage Monitoring Output 1 */
#define PWR_SR2_PVMO2_Pos            (13U)
#define PWR_SR2_PVMO2_Msk            (0x1UL << PWR_SR2_PVMO2_Pos)              /*!< 0x00002000 */
#define PWR_SR2_PVMO2                PWR_SR2_PVMO2_Msk                         /*!< Peripheral Voltage Monitoring Output 2 */
#define PWR_SR2_PVMO3_Pos            (14U)
#define PWR_SR2_PVMO3_Msk            (0x1UL << PWR_SR2_PVMO3_Pos)              /*!< 0x00004000 */
#define PWR_SR2_PVMO3                PWR_SR2_PVMO3_Msk                         /*!< Peripheral Voltage Monitoring Output 3 */
#define PWR_SR2_PVMO4_Pos            (15U)
#define PWR_SR2_PVMO4_Msk            (0x1UL << PWR_SR2_PVMO4_Pos)              /*!< 0x00008000 */
#define PWR_SR2_PVMO4                PWR_SR2_PVMO4_Msk                         /*!< Peripheral Voltage Monitoring Output 4 */

/********************  Bit definition for PWR_SCR register  ********************/
#define PWR_SCR_CWUF_Pos             (0U)
#define PWR_SCR_CWUF_Msk             (0x1FUL << PWR_SCR_CWUF_Pos)              /*!< 0x0000001F */
#define PWR_SCR_CWUF                 PWR_SCR_CWUF_Msk                          /*!< Clear Wake-up Flags  */
#define PWR_SCR_CWUF1_Pos            (0U)
#define PWR_SCR_CWUF1_Msk            (0x1UL << PWR_SCR_CWUF1_Pos)              /*!< 0x00000001 */
#define PWR_SCR_CWUF1                PWR_SCR_CWUF1_Msk                         /*!< Clear Wake-up Flag 1 */
#define PWR_SCR_CWUF2_Pos            (1U)
#define PWR_SCR_CWUF2_Msk            (0x1UL << PWR_SCR_CWUF2_Pos)              /*!< 0x00000002 */
#define PWR_SCR_CWUF2                PWR_SCR_CWUF2_Msk                         /*!< Clear Wake-up Flag 2 */
#define PWR_SCR_CWUF3_Pos            (2U)
#define PWR_SCR_CWUF3_Msk            (0x1UL << PWR_SCR_CWUF3_Pos)              /*!< 0x00000004 */
#define PWR_SCR_CWUF3                PWR_SCR_CWUF3_Msk                         /*!< Clear Wake-up Flag 3 */
#define PWR_SCR_CWUF4_Pos            (3U)
#define PWR_SCR_CWUF4_Msk            (0x1UL << PWR_SCR_CWUF4_Pos)              /*!< 0x00000008 */
#define PWR_SCR_CWUF4                PWR_SCR_CWUF4_Msk                         /*!< Clear Wake-up Flag 4 */
#define PWR_SCR_CWUF5_Pos            (4U)
#define PWR_SCR_CWUF5_Msk            (0x1UL << PWR_SCR_CWUF5_Pos)              /*!< 0x00000010 */
#define PWR_SCR_CWUF5                PWR_SCR_CWUF5_Msk                         /*!< Clear Wake-up Flag 5 */
#define PWR_SCR_CSBF_Pos             (8U)
#define PWR_SCR_CSBF_Msk             (0x1UL << PWR_SCR_CSBF_Pos)               /*!< 0x00000100 */
#define PWR_SCR_CSBF                 PWR_SCR_CSBF_Msk                          /*!< Clear Stand-By Flag */

/********************  Bit definition for PWR_PUCRA register  ********************/
#define PWR_PUCRA_PU0_Pos            (0U)
#define PWR_PUCRA_PU0_Msk            (0x1UL << PWR_PUCRA_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRA_PU0                PWR_PUCRA_PU0_Msk                         /*!< Port PA0 Pull-Up set  */
#define PWR_PUCRA_PU1_Pos            (1U)
#define PWR_PUCRA_PU1_Msk            (0x1UL << PWR_PUCRA_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRA_PU1                PWR_PUCRA_PU1_Msk                         /*!< Port PA1 Pull-Up set  */
#define PWR_PUCRA_PU2_Pos            (2U)
#define PWR_PUCRA_PU2_Msk            (0x1UL << PWR_PUCRA_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRA_PU2                PWR_PUCRA_PU2_Msk                         /*!< Port PA2 Pull-Up set  */
#define PWR_PUCRA_PU3_Pos            (3U)
#define PWR_PUCRA_PU3_Msk            (0x1UL << PWR_PUCRA_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRA_PU3                PWR_PUCRA_PU3_Msk                         /*!< Port PA3 Pull-Up set  */
#define PWR_PUCRA_PU4_Pos            (4U)
#define PWR_PUCRA_PU4_Msk            (0x1UL << PWR_PUCRA_PU4_Pos)              /*!< 0x00000010 */
#define PWR_PUCRA_PU4                PWR_PUCRA_PU4_Msk                         /*!< Port PA4 Pull-Up set  */
#define PWR_PUCRA_PU5_Pos            (5U)
#define PWR_PUCRA_PU5_Msk            (0x1UL << PWR_PUCRA_PU5_Pos)              /*!< 0x00000020 */
#define PWR_PUCRA_PU5                PWR_PUCRA_PU5_Msk                         /*!< Port PA5 Pull-Up set  */
#define PWR_PUCRA_PU6_Pos            (6U)
#define PWR_PUCRA_PU6_Msk            (0x1UL << PWR_PUCRA_PU6_Pos)              /*!< 0x00000040 */
#define PWR_PUCRA_PU6                PWR_PUCRA_PU6_Msk                         /*!< Port PA6 Pull-Up set  */
#define PWR_PUCRA_PU7_Pos            (7U)
#define PWR_PUCRA_PU7_Msk            (0x1UL << PWR_PUCRA_PU7_Pos)              /*!< 0x00000080 */
#define PWR_PUCRA_PU7                PWR_PUCRA_PU7_Msk                         /*!< Port PA7 Pull-Up set  */
#define PWR_PUCRA_PU8_Pos            (8U)
#define PWR_PUCRA_PU8_Msk            (0x1UL << PWR_PUCRA_PU8_Pos)              /*!< 0x00000100 */
#define PWR_PUCRA_PU8                PWR_PUCRA_PU8_Msk                         /*!< Port PA8 Pull-Up set  */
#define PWR_PUCRA_PU9_Pos            (9U)
#define PWR_PUCRA_PU9_Msk            (0x1UL << PWR_PUCRA_PU9_Pos)              /*!< 0x00000200 */
#define PWR_PUCRA_PU9                PWR_PUCRA_PU9_Msk                         /*!< Port PA9 Pull-Up set  */
#define PWR_PUCRA_PU10_Pos           (10U)
#define PWR_PUCRA_PU10_Msk           (0x1UL << PWR_PUCRA_PU10_Pos)             /*!< 0x00000400 */
#define PWR_PUCRA_PU10               PWR_PUCRA_PU10_Msk                        /*!< Port PA10 Pull-Up set */
#define PWR_PUCRA_PU11_Pos           (11U)
#define PWR_PUCRA_PU11_Msk           (0x1UL << PWR_PUCRA_PU11_Pos)             /*!< 0x00000800 */
#define PWR_PUCRA_PU11               PWR_PUCRA_PU11_Msk                        /*!< Port PA11 Pull-Up set */
#define PWR_PUCRA_PU12_Pos           (12U)
#define PWR_PUCRA_PU12_Msk           (0x1UL << PWR_PUCRA_PU12_Pos)             /*!< 0x00001000 */
#define PWR_PUCRA_PU12               PWR_PUCRA_PU12_Msk                        /*!< Port PA12 Pull-Up set */
#define PWR_PUCRA_PU13_Pos           (13U)
#define PWR_PUCRA_PU13_Msk           (0x1UL << PWR_PUCRA_PU13_Pos)             /*!< 0x00002000 */
#define PWR_PUCRA_PU13               PWR_PUCRA_PU13_Msk                        /*!< Port PA13 Pull-Up set */
#define PWR_PUCRA_PU14_Pos           (14U)
#define PWR_PUCRA_PU14_Msk           (0x1UL << PWR_PUCRA_PU14_Pos)             /*!< 0x00004000 */
#define PWR_PUCRA_PU14               PWR_PUCRA_PU14_Msk                        /*!< Port PA14 Pull-Up set */
#define PWR_PUCRA_PU15_Pos           (15U)
#define PWR_PUCRA_PU15_Msk           (0x1UL << PWR_PUCRA_PU15_Pos)             /*!< 0x00008000 */
#define PWR_PUCRA_PU15               PWR_PUCRA_PU15_Msk                        /*!< Port PA15 Pull-Up set */

/********************  Bit definition for PWR_PDCRA register  ********************/
#define PWR_PDCRA_PD0_Pos            (0U)
#define PWR_PDCRA_PD0_Msk            (0x1UL << PWR_PDCRA_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRA_PD0                PWR_PDCRA_PD0_Msk                         /*!< Port PA0 Pull-Down set  */
#define PWR_PDCRA_PD1_Pos            (1U)
#define PWR_PDCRA_PD1_Msk            (0x1UL << PWR_PDCRA_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRA_PD1                PWR_PDCRA_PD1_Msk                         /*!< Port PA1 Pull-Down set  */
#define PWR_PDCRA_PD2_Pos            (2U)
#define PWR_PDCRA_PD2_Msk            (0x1UL << PWR_PDCRA_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRA_PD2                PWR_PDCRA_PD2_Msk                         /*!< Port PA2 Pull-Down set  */
#define PWR_PDCRA_PD3_Pos            (3U)
#define PWR_PDCRA_PD3_Msk            (0x1UL << PWR_PDCRA_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRA_PD3                PWR_PDCRA_PD3_Msk                         /*!< Port PA3 Pull-Down set  */
#define PWR_PDCRA_PD4_Pos            (4U)
#define PWR_PDCRA_PD4_Msk            (0x1UL << PWR_PDCRA_PD4_Pos)              /*!< 0x00000010 */
#define PWR_PDCRA_PD4                PWR_PDCRA_PD4_Msk                         /*!< Port PA4 Pull-Down set  */
#define PWR_PDCRA_PD5_Pos            (5U)
#define PWR_PDCRA_PD5_Msk            (0x1UL << PWR_PDCRA_PD5_Pos)              /*!< 0x00000020 */
#define PWR_PDCRA_PD5                PWR_PDCRA_PD5_Msk                         /*!< Port PA5 Pull-Down set  */
#define PWR_PDCRA_PD6_Pos            (6U)
#define PWR_PDCRA_PD6_Msk            (0x1UL << PWR_PDCRA_PD6_Pos)              /*!< 0x00000040 */
#define PWR_PDCRA_PD6                PWR_PDCRA_PD6_Msk                         /*!< Port PA6 Pull-Down set  */
#define PWR_PDCRA_PD7_Pos            (7U)
#define PWR_PDCRA_PD7_Msk            (0x1UL << PWR_PDCRA_PD7_Pos)              /*!< 0x00000080 */
#define PWR_PDCRA_PD7                PWR_PDCRA_PD7_Msk                         /*!< Port PA7 Pull-Down set  */
#define PWR_PDCRA_PD8_Pos            (8U)
#define PWR_PDCRA_PD8_Msk            (0x1UL << PWR_PDCRA_PD8_Pos)              /*!< 0x00000100 */
#define PWR_PDCRA_PD8                PWR_PDCRA_PD8_Msk                         /*!< Port PA8 Pull-Down set  */
#define PWR_PDCRA_PD9_Pos            (9U)
#define PWR_PDCRA_PD9_Msk            (0x1UL << PWR_PDCRA_PD9_Pos)              /*!< 0x00000200 */
#define PWR_PDCRA_PD9                PWR_PDCRA_PD9_Msk                         /*!< Port PA9 Pull-Down set  */
#define PWR_PDCRA_PD10_Pos           (10U)
#define PWR_PDCRA_PD10_Msk           (0x1UL << PWR_PDCRA_PD10_Pos)             /*!< 0x00000400 */
#define PWR_PDCRA_PD10               PWR_PDCRA_PD10_Msk                        /*!< Port PA10 Pull-Down set */
#define PWR_PDCRA_PD11_Pos           (11U)
#define PWR_PDCRA_PD11_Msk           (0x1UL << PWR_PDCRA_PD11_Pos)             /*!< 0x00000800 */
#define PWR_PDCRA_PD11               PWR_PDCRA_PD11_Msk                        /*!< Port PA11 Pull-Down set */
#define PWR_PDCRA_PD12_Pos           (12U)
#define PWR_PDCRA_PD12_Msk           (0x1UL << PWR_PDCRA_PD12_Pos)             /*!< 0x00001000 */
#define PWR_PDCRA_PD12               PWR_PDCRA_PD12_Msk                        /*!< Port PA12 Pull-Down set */
#define PWR_PDCRA_PD13_Pos           (13U)
#define PWR_PDCRA_PD13_Msk           (0x1UL << PWR_PDCRA_PD13_Pos)             /*!< 0x00002000 */
#define PWR_PDCRA_PD13               PWR_PDCRA_PD13_Msk                        /*!< Port PA13 Pull-Down set */
#define PWR_PDCRA_PD14_Pos           (14U)
#define PWR_PDCRA_PD14_Msk           (0x1UL << PWR_PDCRA_PD14_Pos)             /*!< 0x00004000 */
#define PWR_PDCRA_PD14               PWR_PDCRA_PD14_Msk                        /*!< Port PA14 Pull-Down set */
#define PWR_PDCRA_PD15_Pos           (15U)
#define PWR_PDCRA_PD15_Msk           (0x1UL << PWR_PDCRA_PD15_Pos)             /*!< 0x00008000 */
#define PWR_PDCRA_PD15               PWR_PDCRA_PD15_Msk                        /*!< Port PA15 Pull-Down set */

/********************  Bit definition for PWR_PUCRB register  ********************/
#define PWR_PUCRB_PU0_Pos            (0U)
#define PWR_PUCRB_PU0_Msk            (0x1UL << PWR_PUCRB_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRB_PU0                PWR_PUCRB_PU0_Msk                         /*!< Port PB0 Pull-Up set  */
#define PWR_PUCRB_PU1_Pos            (1U)
#define PWR_PUCRB_PU1_Msk            (0x1UL << PWR_PUCRB_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRB_PU1                PWR_PUCRB_PU1_Msk                         /*!< Port PB1 Pull-Up set  */
#define PWR_PUCRB_PU2_Pos            (2U)
#define PWR_PUCRB_PU2_Msk            (0x1UL << PWR_PUCRB_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRB_PU2                PWR_PUCRB_PU2_Msk                         /*!< Port PB2 Pull-Up set  */
#define PWR_PUCRB_PU3_Pos            (3U)
#define PWR_PUCRB_PU3_Msk            (0x1UL << PWR_PUCRB_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRB_PU3                PWR_PUCRB_PU3_Msk                         /*!< Port PB3 Pull-Up set  */
#define PWR_PUCRB_PU4_Pos            (4U)
#define PWR_PUCRB_PU4_Msk            (0x1UL << PWR_PUCRB_PU4_Pos)              /*!< 0x00000010 */
#define PWR_PUCRB_PU4                PWR_PUCRB_PU4_Msk                         /*!< Port PB4 Pull-Up set  */
#define PWR_PUCRB_PU5_Pos            (5U)
#define PWR_PUCRB_PU5_Msk            (0x1UL << PWR_PUCRB_PU5_Pos)              /*!< 0x00000020 */
#define PWR_PUCRB_PU5                PWR_PUCRB_PU5_Msk                         /*!< Port PB5 Pull-Up set  */
#define PWR_PUCRB_PU6_Pos            (6U)
#define PWR_PUCRB_PU6_Msk            (0x1UL << PWR_PUCRB_PU6_Pos)              /*!< 0x00000040 */
#define PWR_PUCRB_PU6                PWR_PUCRB_PU6_Msk                         /*!< Port PB6 Pull-Up set  */
#define PWR_PUCRB_PU7_Pos            (7U)
#define PWR_PUCRB_PU7_Msk            (0x1UL << PWR_PUCRB_PU7_Pos)              /*!< 0x00000080 */
#define PWR_PUCRB_PU7                PWR_PUCRB_PU7_Msk                         /*!< Port PB7 Pull-Up set  */
#define PWR_PUCRB_PU8_Pos            (8U)
#define PWR_PUCRB_PU8_Msk            (0x1UL << PWR_PUCRB_PU8_Pos)              /*!< 0x00000100 */
#define PWR_PUCRB_PU8                PWR_PUCRB_PU8_Msk                         /*!< Port PB8 Pull-Up set  */
#define PWR_PUCRB_PU9_Pos            (9U)
#define PWR_PUCRB_PU9_Msk            (0x1UL << PWR_PUCRB_PU9_Pos)              /*!< 0x00000200 */
#define PWR_PUCRB_PU9                PWR_PUCRB_PU9_Msk                         /*!< Port PB9 Pull-Up set  */
#define PWR_PUCRB_PU10_Pos           (10U)
#define PWR_PUCRB_PU10_Msk           (0x1UL << PWR_PUCRB_PU10_Pos)             /*!< 0x00000400 */
#define PWR_PUCRB_PU10               PWR_PUCRB_PU10_Msk                        /*!< Port PB10 Pull-Up set */
#define PWR_PUCRB_PU11_Pos           (11U)
#define PWR_PUCRB_PU11_Msk           (0x1UL << PWR_PUCRB_PU11_Pos)             /*!< 0x00000800 */
#define PWR_PUCRB_PU11               PWR_PUCRB_PU11_Msk                        /*!< Port PB11 Pull-Up set */
#define PWR_PUCRB_PU12_Pos           (12U)
#define PWR_PUCRB_PU12_Msk           (0x1UL << PWR_PUCRB_PU12_Pos)             /*!< 0x00001000 */
#define PWR_PUCRB_PU12               PWR_PUCRB_PU12_Msk                        /*!< Port PB12 Pull-Up set */
#define PWR_PUCRB_PU13_Pos           (13U)
#define PWR_PUCRB_PU13_Msk           (0x1UL << PWR_PUCRB_PU13_Pos)             /*!< 0x00002000 */
#define PWR_PUCRB_PU13               PWR_PUCRB_PU13_Msk                        /*!< Port PB13 Pull-Up set */
#define PWR_PUCRB_PU14_Pos           (14U)
#define PWR_PUCRB_PU14_Msk           (0x1UL << PWR_PUCRB_PU14_Pos)             /*!< 0x00004000 */
#define PWR_PUCRB_PU14               PWR_PUCRB_PU14_Msk                        /*!< Port PB14 Pull-Up set */
#define PWR_PUCRB_PU15_Pos           (15U)
#define PWR_PUCRB_PU15_Msk           (0x1UL << PWR_PUCRB_PU15_Pos)             /*!< 0x00008000 */
#define PWR_PUCRB_PU15               PWR_PUCRB_PU15_Msk                        /*!< Port PB15 Pull-Up set */

/********************  Bit definition for PWR_PDCRB register  ********************/
#define PWR_PDCRB_PD0_Pos            (0U)
#define PWR_PDCRB_PD0_Msk            (0x1UL << PWR_PDCRB_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRB_PD0                PWR_PDCRB_PD0_Msk                         /*!< Port PB0 Pull-Down set  */
#define PWR_PDCRB_PD1_Pos            (1U)
#define PWR_PDCRB_PD1_Msk            (0x1UL << PWR_PDCRB_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRB_PD1                PWR_PDCRB_PD1_Msk                         /*!< Port PB1 Pull-Down set  */
#define PWR_PDCRB_PD2_Pos            (2U)
#define PWR_PDCRB_PD2_Msk            (0x1UL << PWR_PDCRB_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRB_PD2                PWR_PDCRB_PD2_Msk                         /*!< Port PB2 Pull-Down set  */
#define PWR_PDCRB_PD3_Pos            (3U)
#define PWR_PDCRB_PD3_Msk            (0x1UL << PWR_PDCRB_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRB_PD3                PWR_PDCRB_PD3_Msk                         /*!< Port PB3 Pull-Down set  */
#define PWR_PDCRB_PD4_Pos            (4U)
#define PWR_PDCRB_PD4_Msk            (0x1UL << PWR_PDCRB_PD4_Pos)              /*!< 0x00000010 */
#define PWR_PDCRB_PD4                PWR_PDCRB_PD4_Msk                         /*!< Port PB4 Pull-Down set  */
#define PWR_PDCRB_PD5_Pos            (5U)
#define PWR_PDCRB_PD5_Msk            (0x1UL << PWR_PDCRB_PD5_Pos)              /*!< 0x00000020 */
#define PWR_PDCRB_PD5                PWR_PDCRB_PD5_Msk                         /*!< Port PB5 Pull-Down set  */
#define PWR_PDCRB_PD6_Pos            (6U)
#define PWR_PDCRB_PD6_Msk            (0x1UL << PWR_PDCRB_PD6_Pos)              /*!< 0x00000040 */
#define PWR_PDCRB_PD6                PWR_PDCRB_PD6_Msk                         /*!< Port PB6 Pull-Down set  */
#define PWR_PDCRB_PD7_Pos            (7U)
#define PWR_PDCRB_PD7_Msk            (0x1UL << PWR_PDCRB_PD7_Pos)              /*!< 0x00000080 */
#define PWR_PDCRB_PD7                PWR_PDCRB_PD7_Msk                         /*!< Port PB7 Pull-Down set  */
#define PWR_PDCRB_PD8_Pos            (8U)
#define PWR_PDCRB_PD8_Msk            (0x1UL << PWR_PDCRB_PD8_Pos)              /*!< 0x00000100 */
#define PWR_PDCRB_PD8                PWR_PDCRB_PD8_Msk                         /*!< Port PB8 Pull-Down set  */
#define PWR_PDCRB_PD9_Pos            (9U)
#define PWR_PDCRB_PD9_Msk            (0x1UL << PWR_PDCRB_PD9_Pos)              /*!< 0x00000200 */
#define PWR_PDCRB_PD9                PWR_PDCRB_PD9_Msk                         /*!< Port PB9 Pull-Down set  */
#define PWR_PDCRB_PD10_Pos           (10U)
#define PWR_PDCRB_PD10_Msk           (0x1UL << PWR_PDCRB_PD10_Pos)             /*!< 0x00000400 */
#define PWR_PDCRB_PD10               PWR_PDCRB_PD10_Msk                        /*!< Port PB10 Pull-Down set */
#define PWR_PDCRB_PD11_Pos           (11U)
#define PWR_PDCRB_PD11_Msk           (0x1UL << PWR_PDCRB_PD11_Pos)             /*!< 0x00000800 */
#define PWR_PDCRB_PD11               PWR_PDCRB_PD11_Msk                        /*!< Port PB11 Pull-Down set */
#define PWR_PDCRB_PD12_Pos           (12U)
#define PWR_PDCRB_PD12_Msk           (0x1UL << PWR_PDCRB_PD12_Pos)             /*!< 0x00001000 */
#define PWR_PDCRB_PD12               PWR_PDCRB_PD12_Msk                        /*!< Port PB12 Pull-Down set */
#define PWR_PDCRB_PD13_Pos           (13U)
#define PWR_PDCRB_PD13_Msk           (0x1UL << PWR_PDCRB_PD13_Pos)             /*!< 0x00002000 */
#define PWR_PDCRB_PD13               PWR_PDCRB_PD13_Msk                        /*!< Port PB13 Pull-Down set */
#define PWR_PDCRB_PD14_Pos           (14U)
#define PWR_PDCRB_PD14_Msk           (0x1UL << PWR_PDCRB_PD14_Pos)             /*!< 0x00004000 */
#define PWR_PDCRB_PD14               PWR_PDCRB_PD14_Msk                        /*!< Port PB14 Pull-Down set */
#define PWR_PDCRB_PD15_Pos           (15U)
#define PWR_PDCRB_PD15_Msk           (0x1UL << PWR_PDCRB_PD15_Pos)             /*!< 0x00008000 */
#define PWR_PDCRB_PD15               PWR_PDCRB_PD15_Msk                        /*!< Port PB15 Pull-Down set */

/********************  Bit definition for PWR_PUCRC register  ********************/
#define PWR_PUCRC_PU0_Pos            (0U)
#define PWR_PUCRC_PU0_Msk            (0x1UL << PWR_PUCRC_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRC_PU0                PWR_PUCRC_PU0_Msk                         /*!< Port PC0 Pull-Up set  */
#define PWR_PUCRC_PU1_Pos            (1U)
#define PWR_PUCRC_PU1_Msk            (0x1UL << PWR_PUCRC_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRC_PU1                PWR_PUCRC_PU1_Msk                         /*!< Port PC1 Pull-Up set  */
#define PWR_PUCRC_PU2_Pos            (2U)
#define PWR_PUCRC_PU2_Msk            (0x1UL << PWR_PUCRC_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRC_PU2                PWR_PUCRC_PU2_Msk                         /*!< Port PC2 Pull-Up set  */
#define PWR_PUCRC_PU3_Pos            (3U)
#define PWR_PUCRC_PU3_Msk            (0x1UL << PWR_PUCRC_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRC_PU3                PWR_PUCRC_PU3_Msk                         /*!< Port PC3 Pull-Up set  */
#define PWR_PUCRC_PU4_Pos            (4U)
#define PWR_PUCRC_PU4_Msk            (0x1UL << PWR_PUCRC_PU4_Pos)              /*!< 0x00000010 */
#define PWR_PUCRC_PU4                PWR_PUCRC_PU4_Msk                         /*!< Port PC4 Pull-Up set  */
#define PWR_PUCRC_PU5_Pos            (5U)
#define PWR_PUCRC_PU5_Msk            (0x1UL << PWR_PUCRC_PU5_Pos)              /*!< 0x00000020 */
#define PWR_PUCRC_PU5                PWR_PUCRC_PU5_Msk                         /*!< Port PC5 Pull-Up set  */
#define PWR_PUCRC_PU6_Pos            (6U)
#define PWR_PUCRC_PU6_Msk            (0x1UL << PWR_PUCRC_PU6_Pos)              /*!< 0x00000040 */
#define PWR_PUCRC_PU6                PWR_PUCRC_PU6_Msk                         /*!< Port PC6 Pull-Up set  */
#define PWR_PUCRC_PU7_Pos            (7U)
#define PWR_PUCRC_PU7_Msk            (0x1UL << PWR_PUCRC_PU7_Pos)              /*!< 0x00000080 */
#define PWR_PUCRC_PU7                PWR_PUCRC_PU7_Msk                         /*!< Port PC7 Pull-Up set  */
#define PWR_PUCRC_PU8_Pos            (8U)
#define PWR_PUCRC_PU8_Msk            (0x1UL << PWR_PUCRC_PU8_Pos)              /*!< 0x00000100 */
#define PWR_PUCRC_PU8                PWR_PUCRC_PU8_Msk                         /*!< Port PC8 Pull-Up set  */
#define PWR_PUCRC_PU9_Pos            (9U)
#define PWR_PUCRC_PU9_Msk            (0x1UL << PWR_PUCRC_PU9_Pos)              /*!< 0x00000200 */
#define PWR_PUCRC_PU9                PWR_PUCRC_PU9_Msk                         /*!< Port PC9 Pull-Up set  */
#define PWR_PUCRC_PU10_Pos           (10U)
#define PWR_PUCRC_PU10_Msk           (0x1UL << PWR_PUCRC_PU10_Pos)             /*!< 0x00000400 */
#define PWR_PUCRC_PU10               PWR_PUCRC_PU10_Msk                        /*!< Port PC10 Pull-Up set */
#define PWR_PUCRC_PU11_Pos           (11U)
#define PWR_PUCRC_PU11_Msk           (0x1UL << PWR_PUCRC_PU11_Pos)             /*!< 0x00000800 */
#define PWR_PUCRC_PU11               PWR_PUCRC_PU11_Msk                        /*!< Port PC11 Pull-Up set */
#define PWR_PUCRC_PU12_Pos           (12U)
#define PWR_PUCRC_PU12_Msk           (0x1UL << PWR_PUCRC_PU12_Pos)             /*!< 0x00001000 */
#define PWR_PUCRC_PU12               PWR_PUCRC_PU12_Msk                        /*!< Port PC12 Pull-Up set */
#define PWR_PUCRC_PU13_Pos           (13U)
#define PWR_PUCRC_PU13_Msk           (0x1UL << PWR_PUCRC_PU13_Pos)             /*!< 0x00002000 */
#define PWR_PUCRC_PU13               PWR_PUCRC_PU13_Msk                        /*!< Port PC13 Pull-Up set */
#define PWR_PUCRC_PU14_Pos           (14U)
#define PWR_PUCRC_PU14_Msk           (0x1UL << PWR_PUCRC_PU14_Pos)             /*!< 0x00004000 */
#define PWR_PUCRC_PU14               PWR_PUCRC_PU14_Msk                        /*!< Port PC14 Pull-Up set */
#define PWR_PUCRC_PU15_Pos           (15U)
#define PWR_PUCRC_PU15_Msk           (0x1UL << PWR_PUCRC_PU15_Pos)             /*!< 0x00008000 */
#define PWR_PUCRC_PU15               PWR_PUCRC_PU15_Msk                        /*!< Port PC15 Pull-Up set */

/********************  Bit definition for PWR_PDCRC register  ********************/
#define PWR_PDCRC_PD0_Pos            (0U)
#define PWR_PDCRC_PD0_Msk            (0x1UL << PWR_PDCRC_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRC_PD0                PWR_PDCRC_PD0_Msk                         /*!< Port PC0 Pull-Down set  */
#define PWR_PDCRC_PD1_Pos            (1U)
#define PWR_PDCRC_PD1_Msk            (0x1UL << PWR_PDCRC_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRC_PD1                PWR_PDCRC_PD1_Msk                         /*!< Port PC1 Pull-Down set  */
#define PWR_PDCRC_PD2_Pos            (2U)
#define PWR_PDCRC_PD2_Msk            (0x1UL << PWR_PDCRC_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRC_PD2                PWR_PDCRC_PD2_Msk                         /*!< Port PC2 Pull-Down set  */
#define PWR_PDCRC_PD3_Pos            (3U)
#define PWR_PDCRC_PD3_Msk            (0x1UL << PWR_PDCRC_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRC_PD3                PWR_PDCRC_PD3_Msk                         /*!< Port PC3 Pull-Down set  */
#define PWR_PDCRC_PD4_Pos            (4U)
#define PWR_PDCRC_PD4_Msk            (0x1UL << PWR_PDCRC_PD4_Pos)              /*!< 0x00000010 */
#define PWR_PDCRC_PD4                PWR_PDCRC_PD4_Msk                         /*!< Port PC4 Pull-Down set  */
#define PWR_PDCRC_PD5_Pos            (5U)
#define PWR_PDCRC_PD5_Msk            (0x1UL << PWR_PDCRC_PD5_Pos)              /*!< 0x00000020 */
#define PWR_PDCRC_PD5                PWR_PDCRC_PD5_Msk                         /*!< Port PC5 Pull-Down set  */
#define PWR_PDCRC_PD6_Pos            (6U)
#define PWR_PDCRC_PD6_Msk            (0x1UL << PWR_PDCRC_PD6_Pos)              /*!< 0x00000040 */
#define PWR_PDCRC_PD6                PWR_PDCRC_PD6_Msk                         /*!< Port PC6 Pull-Down set  */
#define PWR_PDCRC_PD7_Pos            (7U)
#define PWR_PDCRC_PD7_Msk            (0x1UL << PWR_PDCRC_PD7_Pos)              /*!< 0x00000080 */
#define PWR_PDCRC_PD7                PWR_PDCRC_PD7_Msk                         /*!< Port PC7 Pull-Down set  */
#define PWR_PDCRC_PD8_Pos            (8U)
#define PWR_PDCRC_PD8_Msk            (0x1UL << PWR_PDCRC_PD8_Pos)              /*!< 0x00000100 */
#define PWR_PDCRC_PD8                PWR_PDCRC_PD8_Msk                         /*!< Port PC8 Pull-Down set  */
#define PWR_PDCRC_PD9_Pos            (9U)
#define PWR_PDCRC_PD9_Msk            (0x1UL << PWR_PDCRC_PD9_Pos)              /*!< 0x00000200 */
#define PWR_PDCRC_PD9                PWR_PDCRC_PD9_Msk                         /*!< Port PC9 Pull-Down set  */
#define PWR_PDCRC_PD10_Pos           (10U)
#define PWR_PDCRC_PD10_Msk           (0x1UL << PWR_PDCRC_PD10_Pos)             /*!< 0x00000400 */
#define PWR_PDCRC_PD10               PWR_PDCRC_PD10_Msk                        /*!< Port PC10 Pull-Down set */
#define PWR_PDCRC_PD11_Pos           (11U)
#define PWR_PDCRC_PD11_Msk           (0x1UL << PWR_PDCRC_PD11_Pos)             /*!< 0x00000800 */
#define PWR_PDCRC_PD11               PWR_PDCRC_PD11_Msk                        /*!< Port PC11 Pull-Down set */
#define PWR_PDCRC_PD12_Pos           (12U)
#define PWR_PDCRC_PD12_Msk           (0x1UL << PWR_PDCRC_PD12_Pos)             /*!< 0x00001000 */
#define PWR_PDCRC_PD12               PWR_PDCRC_PD12_Msk                        /*!< Port PC12 Pull-Down set */
#define PWR_PDCRC_PD13_Pos           (13U)
#define PWR_PDCRC_PD13_Msk           (0x1UL << PWR_PDCRC_PD13_Pos)             /*!< 0x00002000 */
#define PWR_PDCRC_PD13               PWR_PDCRC_PD13_Msk                        /*!< Port PC13 Pull-Down set */
#define PWR_PDCRC_PD14_Pos           (14U)
#define PWR_PDCRC_PD14_Msk           (0x1UL << PWR_PDCRC_PD14_Pos)             /*!< 0x00004000 */
#define PWR_PDCRC_PD14               PWR_PDCRC_PD14_Msk                        /*!< Port PC14 Pull-Down set */
#define PWR_PDCRC_PD15_Pos           (15U)
#define PWR_PDCRC_PD15_Msk           (0x1UL << PWR_PDCRC_PD15_Pos)             /*!< 0x00008000 */
#define PWR_PDCRC_PD15               PWR_PDCRC_PD15_Msk                        /*!< Port PC15 Pull-Down set */

/********************  Bit definition for PWR_PUCRD register  ********************/
#define PWR_PUCRD_PU0_Pos            (0U)
#define PWR_PUCRD_PU0_Msk            (0x1UL << PWR_PUCRD_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRD_PU0                PWR_PUCRD_PU0_Msk                         /*!< Port PD0 Pull-Up set  */
#define PWR_PUCRD_PU1_Pos            (1U)
#define PWR_PUCRD_PU1_Msk            (0x1UL << PWR_PUCRD_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRD_PU1                PWR_PUCRD_PU1_Msk                         /*!< Port PD1 Pull-Up set  */
#define PWR_PUCRD_PU2_Pos            (2U)
#define PWR_PUCRD_PU2_Msk            (0x1UL << PWR_PUCRD_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRD_PU2                PWR_PUCRD_PU2_Msk                         /*!< Port PD2 Pull-Up set  */
#define PWR_PUCRD_PU3_Pos            (3U)
#define PWR_PUCRD_PU3_Msk            (0x1UL << PWR_PUCRD_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRD_PU3                PWR_PUCRD_PU3_Msk                         /*!< Port PD3 Pull-Up set  */
#define PWR_PUCRD_PU4_Pos            (4U)
#define PWR_PUCRD_PU4_Msk            (0x1UL << PWR_PUCRD_PU4_Pos)              /*!< 0x00000010 */
#define PWR_PUCRD_PU4                PWR_PUCRD_PU4_Msk                         /*!< Port PD4 Pull-Up set  */
#define PWR_PUCRD_PU5_Pos            (5U)
#define PWR_PUCRD_PU5_Msk            (0x1UL << PWR_PUCRD_PU5_Pos)              /*!< 0x00000020 */
#define PWR_PUCRD_PU5                PWR_PUCRD_PU5_Msk                         /*!< Port PD5 Pull-Up set  */
#define PWR_PUCRD_PU6_Pos            (6U)
#define PWR_PUCRD_PU6_Msk            (0x1UL << PWR_PUCRD_PU6_Pos)              /*!< 0x00000040 */
#define PWR_PUCRD_PU6                PWR_PUCRD_PU6_Msk                         /*!< Port PD6 Pull-Up set  */
#define PWR_PUCRD_PU7_Pos            (7U)
#define PWR_PUCRD_PU7_Msk            (0x1UL << PWR_PUCRD_PU7_Pos)              /*!< 0x00000080 */
#define PWR_PUCRD_PU7                PWR_PUCRD_PU7_Msk                         /*!< Port PD7 Pull-Up set  */
#define PWR_PUCRD_PU8_Pos            (8U)
#define PWR_PUCRD_PU8_Msk            (0x1UL << PWR_PUCRD_PU8_Pos)              /*!< 0x00000100 */
#define PWR_PUCRD_PU8                PWR_PUCRD_PU8_Msk                         /*!< Port PD8 Pull-Up set  */
#define PWR_PUCRD_PU9_Pos            (9U)
#define PWR_PUCRD_PU9_Msk            (0x1UL << PWR_PUCRD_PU9_Pos)              /*!< 0x00000200 */
#define PWR_PUCRD_PU9                PWR_PUCRD_PU9_Msk                         /*!< Port PD9 Pull-Up set  */
#define PWR_PUCRD_PU10_Pos           (10U)
#define PWR_PUCRD_PU10_Msk           (0x1UL << PWR_PUCRD_PU10_Pos)             /*!< 0x00000400 */
#define PWR_PUCRD_PU10               PWR_PUCRD_PU10_Msk                        /*!< Port PD10 Pull-Up set */
#define PWR_PUCRD_PU11_Pos           (11U)
#define PWR_PUCRD_PU11_Msk           (0x1UL << PWR_PUCRD_PU11_Pos)             /*!< 0x00000800 */
#define PWR_PUCRD_PU11               PWR_PUCRD_PU11_Msk                        /*!< Port PD11 Pull-Up set */
#define PWR_PUCRD_PU12_Pos           (12U)
#define PWR_PUCRD_PU12_Msk           (0x1UL << PWR_PUCRD_PU12_Pos)             /*!< 0x00001000 */
#define PWR_PUCRD_PU12               PWR_PUCRD_PU12_Msk                        /*!< Port PD12 Pull-Up set */
#define PWR_PUCRD_PU13_Pos           (13U)
#define PWR_PUCRD_PU13_Msk           (0x1UL << PWR_PUCRD_PU13_Pos)             /*!< 0x00002000 */
#define PWR_PUCRD_PU13               PWR_PUCRD_PU13_Msk                        /*!< Port PD13 Pull-Up set */
#define PWR_PUCRD_PU14_Pos           (14U)
#define PWR_PUCRD_PU14_Msk           (0x1UL << PWR_PUCRD_PU14_Pos)             /*!< 0x00004000 */
#define PWR_PUCRD_PU14               PWR_PUCRD_PU14_Msk                        /*!< Port PD14 Pull-Up set */
#define PWR_PUCRD_PU15_Pos           (15U)
#define PWR_PUCRD_PU15_Msk           (0x1UL << PWR_PUCRD_PU15_Pos)             /*!< 0x00008000 */
#define PWR_PUCRD_PU15               PWR_PUCRD_PU15_Msk                        /*!< Port PD15 Pull-Up set */

/********************  Bit definition for PWR_PDCRD register  ********************/
#define PWR_PDCRD_PD0_Pos            (0U)
#define PWR_PDCRD_PD0_Msk            (0x1UL << PWR_PDCRD_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRD_PD0                PWR_PDCRD_PD0_Msk                         /*!< Port PD0 Pull-Down set  */
#define PWR_PDCRD_PD1_Pos            (1U)
#define PWR_PDCRD_PD1_Msk            (0x1UL << PWR_PDCRD_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRD_PD1                PWR_PDCRD_PD1_Msk                         /*!< Port PD1 Pull-Down set  */
#define PWR_PDCRD_PD2_Pos            (2U)
#define PWR_PDCRD_PD2_Msk            (0x1UL << PWR_PDCRD_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRD_PD2                PWR_PDCRD_PD2_Msk                         /*!< Port PD2 Pull-Down set  */
#define PWR_PDCRD_PD3_Pos            (3U)
#define PWR_PDCRD_PD3_Msk            (0x1UL << PWR_PDCRD_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRD_PD3                PWR_PDCRD_PD3_Msk                         /*!< Port PD3 Pull-Down set  */
#define PWR_PDCRD_PD4_Pos            (4U)
#define PWR_PDCRD_PD4_Msk            (0x1UL << PWR_PDCRD_PD4_Pos)              /*!< 0x00000010 */
#define PWR_PDCRD_PD4                PWR_PDCRD_PD4_Msk                         /*!< Port PD4 Pull-Down set  */
#define PWR_PDCRD_PD5_Pos            (5U)
#define PWR_PDCRD_PD5_Msk            (0x1UL << PWR_PDCRD_PD5_Pos)              /*!< 0x00000020 */
#define PWR_PDCRD_PD5                PWR_PDCRD_PD5_Msk                         /*!< Port PD5 Pull-Down set  */
#define PWR_PDCRD_PD6_Pos            (6U)
#define PWR_PDCRD_PD6_Msk            (0x1UL << PWR_PDCRD_PD6_Pos)              /*!< 0x00000040 */
#define PWR_PDCRD_PD6                PWR_PDCRD_PD6_Msk                         /*!< Port PD6 Pull-Down set  */
#define PWR_PDCRD_PD7_Pos            (7U)
#define PWR_PDCRD_PD7_Msk            (0x1UL << PWR_PDCRD_PD7_Pos)              /*!< 0x00000080 */
#define PWR_PDCRD_PD7                PWR_PDCRD_PD7_Msk                         /*!< Port PD7 Pull-Down set  */
#define PWR_PDCRD_PD8_Pos            (8U)
#define PWR_PDCRD_PD8_Msk            (0x1UL << PWR_PDCRD_PD8_Pos)              /*!< 0x00000100 */
#define PWR_PDCRD_PD8                PWR_PDCRD_PD8_Msk                         /*!< Port PD8 Pull-Down set  */
#define PWR_PDCRD_PD9_Pos            (9U)
#define PWR_PDCRD_PD9_Msk            (0x1UL << PWR_PDCRD_PD9_Pos)              /*!< 0x00000200 */
#define PWR_PDCRD_PD9                PWR_PDCRD_PD9_Msk                         /*!< Port PD9 Pull-Down set  */
#define PWR_PDCRD_PD10_Pos           (10U)
#define PWR_PDCRD_PD10_Msk           (0x1UL << PWR_PDCRD_PD10_Pos)             /*!< 0x00000400 */
#define PWR_PDCRD_PD10               PWR_PDCRD_PD10_Msk                        /*!< Port PD10 Pull-Down set */
#define PWR_PDCRD_PD11_Pos           (11U)
#define PWR_PDCRD_PD11_Msk           (0x1UL << PWR_PDCRD_PD11_Pos)             /*!< 0x00000800 */
#define PWR_PDCRD_PD11               PWR_PDCRD_PD11_Msk                        /*!< Port PD11 Pull-Down set */
#define PWR_PDCRD_PD12_Pos           (12U)
#define PWR_PDCRD_PD12_Msk           (0x1UL << PWR_PDCRD_PD12_Pos)             /*!< 0x00001000 */
#define PWR_PDCRD_PD12               PWR_PDCRD_PD12_Msk                        /*!< Port PD12 Pull-Down set */
#define PWR_PDCRD_PD13_Pos           (13U)
#define PWR_PDCRD_PD13_Msk           (0x1UL << PWR_PDCRD_PD13_Pos)             /*!< 0x00002000 */
#define PWR_PDCRD_PD13               PWR_PDCRD_PD13_Msk                        /*!< Port PD13 Pull-Down set */
#define PWR_PDCRD_PD14_Pos           (14U)
#define PWR_PDCRD_PD14_Msk           (0x1UL << PWR_PDCRD_PD14_Pos)             /*!< 0x00004000 */
#define PWR_PDCRD_PD14               PWR_PDCRD_PD14_Msk                        /*!< Port PD14 Pull-Down set */
#define PWR_PDCRD_PD15_Pos           (15U)
#define PWR_PDCRD_PD15_Msk           (0x1UL << PWR_PDCRD_PD15_Pos)             /*!< 0x00008000 */
#define PWR_PDCRD_PD15               PWR_PDCRD_PD15_Msk                        /*!< Port PD15 Pull-Down set */

/********************  Bit definition for PWR_PUCRE register  ********************/
#define PWR_PUCRE_PU0_Pos            (0U)
#define PWR_PUCRE_PU0_Msk            (0x1UL << PWR_PUCRE_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRE_PU0                PWR_PUCRE_PU0_Msk                         /*!< Port PE0 Pull-Up set  */
#define PWR_PUCRE_PU1_Pos            (1U)
#define PWR_PUCRE_PU1_Msk            (0x1UL << PWR_PUCRE_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRE_PU1                PWR_PUCRE_PU1_Msk                         /*!< Port PE1 Pull-Up set  */
#define PWR_PUCRE_PU2_Pos            (2U)
#define PWR_PUCRE_PU2_Msk            (0x1UL << PWR_PUCRE_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRE_PU2                PWR_PUCRE_PU2_Msk                         /*!< Port PE2 Pull-Up set  */
#define PWR_PUCRE_PU3_Pos            (3U)
#define PWR_PUCRE_PU3_Msk            (0x1UL << PWR_PUCRE_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRE_PU3                PWR_PUCRE_PU3_Msk                         /*!< Port PE3 Pull-Up set  */
#define PWR_PUCRE_PU4_Pos            (4U)
#define PWR_PUCRE_PU4_Msk            (0x1UL << PWR_PUCRE_PU4_Pos)              /*!< 0x00000010 */
#define PWR_PUCRE_PU4                PWR_PUCRE_PU4_Msk                         /*!< Port PE4 Pull-Up set  */
#define PWR_PUCRE_PU5_Pos            (5U)
#define PWR_PUCRE_PU5_Msk            (0x1UL << PWR_PUCRE_PU5_Pos)              /*!< 0x00000020 */
#define PWR_PUCRE_PU5                PWR_PUCRE_PU5_Msk                         /*!< Port PE5 Pull-Up set  */
#define PWR_PUCRE_PU6_Pos            (6U)
#define PWR_PUCRE_PU6_Msk            (0x1UL << PWR_PUCRE_PU6_Pos)              /*!< 0x00000040 */
#define PWR_PUCRE_PU6                PWR_PUCRE_PU6_Msk                         /*!< Port PE6 Pull-Up set  */
#define PWR_PUCRE_PU7_Pos            (7U)
#define PWR_PUCRE_PU7_Msk            (0x1UL << PWR_PUCRE_PU7_Pos)              /*!< 0x00000080 */
#define PWR_PUCRE_PU7                PWR_PUCRE_PU7_Msk                         /*!< Port PE7 Pull-Up set  */
#define PWR_PUCRE_PU8_Pos            (8U)
#define PWR_PUCRE_PU8_Msk            (0x1UL << PWR_PUCRE_PU8_Pos)              /*!< 0x00000100 */
#define PWR_PUCRE_PU8                PWR_PUCRE_PU8_Msk                         /*!< Port PE8 Pull-Up set  */
#define PWR_PUCRE_PU9_Pos            (9U)
#define PWR_PUCRE_PU9_Msk            (0x1UL << PWR_PUCRE_PU9_Pos)              /*!< 0x00000200 */
#define PWR_PUCRE_PU9                PWR_PUCRE_PU9_Msk                         /*!< Port PE9 Pull-Up set  */
#define PWR_PUCRE_PU10_Pos           (10U)
#define PWR_PUCRE_PU10_Msk           (0x1UL << PWR_PUCRE_PU10_Pos)             /*!< 0x00000400 */
#define PWR_PUCRE_PU10               PWR_PUCRE_PU10_Msk                        /*!< Port PE10 Pull-Up set */
#define PWR_PUCRE_PU11_Pos           (11U)
#define PWR_PUCRE_PU11_Msk           (0x1UL << PWR_PUCRE_PU11_Pos)             /*!< 0x00000800 */
#define PWR_PUCRE_PU11               PWR_PUCRE_PU11_Msk                        /*!< Port PE11 Pull-Up set */
#define PWR_PUCRE_PU12_Pos           (12U)
#define PWR_PUCRE_PU12_Msk           (0x1UL << PWR_PUCRE_PU12_Pos)             /*!< 0x00001000 */
#define PWR_PUCRE_PU12               PWR_PUCRE_PU12_Msk                        /*!< Port PE12 Pull-Up set */
#define PWR_PUCRE_PU13_Pos           (13U)
#define PWR_PUCRE_PU13_Msk           (0x1UL << PWR_PUCRE_PU13_Pos)             /*!< 0x00002000 */
#define PWR_PUCRE_PU13               PWR_PUCRE_PU13_Msk                        /*!< Port PE13 Pull-Up set */
#define PWR_PUCRE_PU14_Pos           (14U)
#define PWR_PUCRE_PU14_Msk           (0x1UL << PWR_PUCRE_PU14_Pos)             /*!< 0x00004000 */
#define PWR_PUCRE_PU14               PWR_PUCRE_PU14_Msk                        /*!< Port PE14 Pull-Up set */
#define PWR_PUCRE_PU15_Pos           (15U)
#define PWR_PUCRE_PU15_Msk           (0x1UL << PWR_PUCRE_PU15_Pos)             /*!< 0x00008000 */
#define PWR_PUCRE_PU15               PWR_PUCRE_PU15_Msk                        /*!< Port PE15 Pull-Up set */

/********************  Bit definition for PWR_PDCRE register  ********************/
#define PWR_PDCRE_PD0_Pos            (0U)
#define PWR_PDCRE_PD0_Msk            (0x1UL << PWR_PDCRE_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRE_PD0                PWR_PDCRE_PD0_Msk                         /*!< Port PE0 Pull-Down set  */
#define PWR_PDCRE_PD1_Pos            (1U)
#define PWR_PDCRE_PD1_Msk            (0x1UL << PWR_PDCRE_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRE_PD1                PWR_PDCRE_PD1_Msk                         /*!< Port PE1 Pull-Down set  */
#define PWR_PDCRE_PD2_Pos            (2U)
#define PWR_PDCRE_PD2_Msk            (0x1UL << PWR_PDCRE_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRE_PD2                PWR_PDCRE_PD2_Msk                         /*!< Port PE2 Pull-Down set  */
#define PWR_PDCRE_PD3_Pos            (3U)
#define PWR_PDCRE_PD3_Msk            (0x1UL << PWR_PDCRE_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRE_PD3                PWR_PDCRE_PD3_Msk                         /*!< Port PE3 Pull-Down set  */
#define PWR_PDCRE_PD4_Pos            (4U)
#define PWR_PDCRE_PD4_Msk            (0x1UL << PWR_PDCRE_PD4_Pos)              /*!< 0x00000010 */
#define PWR_PDCRE_PD4                PWR_PDCRE_PD4_Msk                         /*!< Port PE4 Pull-Down set  */
#define PWR_PDCRE_PD5_Pos            (5U)
#define PWR_PDCRE_PD5_Msk            (0x1UL << PWR_PDCRE_PD5_Pos)              /*!< 0x00000020 */
#define PWR_PDCRE_PD5                PWR_PDCRE_PD5_Msk                         /*!< Port PE5 Pull-Down set  */
#define PWR_PDCRE_PD6_Pos            (6U)
#define PWR_PDCRE_PD6_Msk            (0x1UL << PWR_PDCRE_PD6_Pos)              /*!< 0x00000040 */
#define PWR_PDCRE_PD6                PWR_PDCRE_PD6_Msk                         /*!< Port PE6 Pull-Down set  */
#define PWR_PDCRE_PD7_Pos            (7U)
#define PWR_PDCRE_PD7_Msk            (0x1UL << PWR_PDCRE_PD7_Pos)              /*!< 0x00000080 */
#define PWR_PDCRE_PD7                PWR_PDCRE_PD7_Msk                         /*!< Port PE7 Pull-Down set  */
#define PWR_PDCRE_PD8_Pos            (8U)
#define PWR_PDCRE_PD8_Msk            (0x1UL << PWR_PDCRE_PD8_Pos)              /*!< 0x00000100 */
#define PWR_PDCRE_PD8                PWR_PDCRE_PD8_Msk                         /*!< Port PE8 Pull-Down set  */
#define PWR_PDCRE_PD9_Pos            (9U)
#define PWR_PDCRE_PD9_Msk            (0x1UL << PWR_PDCRE_PD9_Pos)              /*!< 0x00000200 */
#define PWR_PDCRE_PD9                PWR_PDCRE_PD9_Msk                         /*!< Port PE9 Pull-Down set  */
#define PWR_PDCRE_PD10_Pos           (10U)
#define PWR_PDCRE_PD10_Msk           (0x1UL << PWR_PDCRE_PD10_Pos)             /*!< 0x00000400 */
#define PWR_PDCRE_PD10               PWR_PDCRE_PD10_Msk                        /*!< Port PE10 Pull-Down set */
#define PWR_PDCRE_PD11_Pos           (11U)
#define PWR_PDCRE_PD11_Msk           (0x1UL << PWR_PDCRE_PD11_Pos)             /*!< 0x00000800 */
#define PWR_PDCRE_PD11               PWR_PDCRE_PD11_Msk                        /*!< Port PE11 Pull-Down set */
#define PWR_PDCRE_PD12_Pos           (12U)
#define PWR_PDCRE_PD12_Msk           (0x1UL << PWR_PDCRE_PD12_Pos)             /*!< 0x00001000 */
#define PWR_PDCRE_PD12               PWR_PDCRE_PD12_Msk                        /*!< Port PE12 Pull-Down set */
#define PWR_PDCRE_PD13_Pos           (13U)
#define PWR_PDCRE_PD13_Msk           (0x1UL << PWR_PDCRE_PD13_Pos)             /*!< 0x00002000 */
#define PWR_PDCRE_PD13               PWR_PDCRE_PD13_Msk                        /*!< Port PE13 Pull-Down set */
#define PWR_PDCRE_PD14_Pos           (14U)
#define PWR_PDCRE_PD14_Msk           (0x1UL << PWR_PDCRE_PD14_Pos)             /*!< 0x00004000 */
#define PWR_PDCRE_PD14               PWR_PDCRE_PD14_Msk                        /*!< Port PE14 Pull-Down set */
#define PWR_PDCRE_PD15_Pos           (15U)
#define PWR_PDCRE_PD15_Msk           (0x1UL << PWR_PDCRE_PD15_Pos)             /*!< 0x00008000 */
#define PWR_PDCRE_PD15               PWR_PDCRE_PD15_Msk                        /*!< Port PE15 Pull-Down set */

/********************  Bit definition for PWR_PUCRF register  ********************/
#define PWR_PUCRF_PU0_Pos            (0U)
#define PWR_PUCRF_PU0_Msk            (0x1UL << PWR_PUCRF_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRF_PU0                PWR_PUCRF_PU0_Msk                         /*!< Port PF0 Pull-Up set  */
#define PWR_PUCRF_PU1_Pos            (1U)
#define PWR_PUCRF_PU1_Msk            (0x1UL << PWR_PUCRF_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRF_PU1                PWR_PUCRF_PU1_Msk                         /*!< Port PF1 Pull-Up set  */
#define PWR_PUCRF_PU2_Pos            (2U)
#define PWR_PUCRF_PU2_Msk            (0x1UL << PWR_PUCRF_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRF_PU2                PWR_PUCRF_PU2_Msk                         /*!< Port PF2 Pull-Up set  */
#define PWR_PUCRF_PU3_Pos            (3U)
#define PWR_PUCRF_PU3_Msk            (0x1UL << PWR_PUCRF_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRF_PU3                PWR_PUCRF_PU3_Msk                         /*!< Port PF3 Pull-Up set  */
#define PWR_PUCRF_PU4_Pos            (4U)
#define PWR_PUCRF_PU4_Msk            (0x1UL << PWR_PUCRF_PU4_Pos)              /*!< 0x00000010 */
#define PWR_PUCRF_PU4                PWR_PUCRF_PU4_Msk                         /*!< Port PF4 Pull-Up set  */
#define PWR_PUCRF_PU5_Pos            (5U)
#define PWR_PUCRF_PU5_Msk            (0x1UL << PWR_PUCRF_PU5_Pos)              /*!< 0x00000020 */
#define PWR_PUCRF_PU5                PWR_PUCRF_PU5_Msk                         /*!< Port PF5 Pull-Up set  */
#define PWR_PUCRF_PU6_Pos            (6U)
#define PWR_PUCRF_PU6_Msk            (0x1UL << PWR_PUCRF_PU6_Pos)              /*!< 0x00000040 */
#define PWR_PUCRF_PU6                PWR_PUCRF_PU6_Msk                         /*!< Port PF6 Pull-Up set  */
#define PWR_PUCRF_PU7_Pos            (7U)
#define PWR_PUCRF_PU7_Msk            (0x1UL << PWR_PUCRF_PU7_Pos)              /*!< 0x00000080 */
#define PWR_PUCRF_PU7                PWR_PUCRF_PU7_Msk                         /*!< Port PF7 Pull-Up set  */
#define PWR_PUCRF_PU8_Pos            (8U)
#define PWR_PUCRF_PU8_Msk            (0x1UL << PWR_PUCRF_PU8_Pos)              /*!< 0x00000100 */
#define PWR_PUCRF_PU8                PWR_PUCRF_PU8_Msk                         /*!< Port PF8 Pull-Up set  */
#define PWR_PUCRF_PU9_Pos            (9U)
#define PWR_PUCRF_PU9_Msk            (0x1UL << PWR_PUCRF_PU9_Pos)              /*!< 0x00000200 */
#define PWR_PUCRF_PU9                PWR_PUCRF_PU9_Msk                         /*!< Port PF9 Pull-Up set  */
#define PWR_PUCRF_PU10_Pos           (10U)
#define PWR_PUCRF_PU10_Msk           (0x1UL << PWR_PUCRF_PU10_Pos)             /*!< 0x00000400 */
#define PWR_PUCRF_PU10               PWR_PUCRF_PU10_Msk                        /*!< Port PF10 Pull-Up set */
#define PWR_PUCRF_PU11_Pos           (11U)
#define PWR_PUCRF_PU11_Msk           (0x1UL << PWR_PUCRF_PU11_Pos)             /*!< 0x00000800 */
#define PWR_PUCRF_PU11               PWR_PUCRF_PU11_Msk                        /*!< Port PF11 Pull-Up set */
#define PWR_PUCRF_PU12_Pos           (12U)
#define PWR_PUCRF_PU12_Msk           (0x1UL << PWR_PUCRF_PU12_Pos)             /*!< 0x00001000 */
#define PWR_PUCRF_PU12               PWR_PUCRF_PU12_Msk                        /*!< Port PF12 Pull-Up set */
#define PWR_PUCRF_PU13_Pos           (13U)
#define PWR_PUCRF_PU13_Msk           (0x1UL << PWR_PUCRF_PU13_Pos)             /*!< 0x00002000 */
#define PWR_PUCRF_PU13               PWR_PUCRF_PU13_Msk                        /*!< Port PF13 Pull-Up set */
#define PWR_PUCRF_PU14_Pos           (14U)
#define PWR_PUCRF_PU14_Msk           (0x1UL << PWR_PUCRF_PU14_Pos)             /*!< 0x00004000 */
#define PWR_PUCRF_PU14               PWR_PUCRF_PU14_Msk                        /*!< Port PF14 Pull-Up set */
#define PWR_PUCRF_PU15_Pos           (15U)
#define PWR_PUCRF_PU15_Msk           (0x1UL << PWR_PUCRF_PU15_Pos)             /*!< 0x00008000 */
#define PWR_PUCRF_PU15               PWR_PUCRF_PU15_Msk                        /*!< Port PF15 Pull-Up set */

/********************  Bit definition for PWR_PDCRF register  ********************/
#define PWR_PDCRF_PD0_Pos            (0U)
#define PWR_PDCRF_PD0_Msk            (0x1UL << PWR_PDCRF_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRF_PD0                PWR_PDCRF_PD0_Msk                         /*!< Port PF0 Pull-Down set  */
#define PWR_PDCRF_PD1_Pos            (1U)
#define PWR_PDCRF_PD1_Msk            (0x1UL << PWR_PDCRF_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRF_PD1                PWR_PDCRF_PD1_Msk                         /*!< Port PF1 Pull-Down set  */
#define PWR_PDCRF_PD2_Pos            (2U)
#define PWR_PDCRF_PD2_Msk            (0x1UL << PWR_PDCRF_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRF_PD2                PWR_PDCRF_PD2_Msk                         /*!< Port PF2 Pull-Down set  */
#define PWR_PDCRF_PD3_Pos            (3U)
#define PWR_PDCRF_PD3_Msk            (0x1UL << PWR_PDCRF_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRF_PD3                PWR_PDCRF_PD3_Msk                         /*!< Port PF3 Pull-Down set  */
#define PWR_PDCRF_PD4_Pos            (4U)
#define PWR_PDCRF_PD4_Msk            (0x1UL << PWR_PDCRF_PD4_Pos)              /*!< 0x00000010 */
#define PWR_PDCRF_PD4                PWR_PDCRF_PD4_Msk                         /*!< Port PF4 Pull-Down set  */
#define PWR_PDCRF_PD5_Pos            (5U)
#define PWR_PDCRF_PD5_Msk            (0x1UL << PWR_PDCRF_PD5_Pos)              /*!< 0x00000020 */
#define PWR_PDCRF_PD5                PWR_PDCRF_PD5_Msk                         /*!< Port PF5 Pull-Down set  */
#define PWR_PDCRF_PD6_Pos            (6U)
#define PWR_PDCRF_PD6_Msk            (0x1UL << PWR_PDCRF_PD6_Pos)              /*!< 0x00000040 */
#define PWR_PDCRF_PD6                PWR_PDCRF_PD6_Msk                         /*!< Port PF6 Pull-Down set  */
#define PWR_PDCRF_PD7_Pos            (7U)
#define PWR_PDCRF_PD7_Msk            (0x1UL << PWR_PDCRF_PD7_Pos)              /*!< 0x00000080 */
#define PWR_PDCRF_PD7                PWR_PDCRF_PD7_Msk                         /*!< Port PF7 Pull-Down set  */
#define PWR_PDCRF_PD8_Pos            (8U)
#define PWR_PDCRF_PD8_Msk            (0x1UL << PWR_PDCRF_PD8_Pos)              /*!< 0x00000100 */
#define PWR_PDCRF_PD8                PWR_PDCRF_PD8_Msk                         /*!< Port PF8 Pull-Down set  */
#define PWR_PDCRF_PD9_Pos            (9U)
#define PWR_PDCRF_PD9_Msk            (0x1UL << PWR_PDCRF_PD9_Pos)              /*!< 0x00000200 */
#define PWR_PDCRF_PD9                PWR_PDCRF_PD9_Msk                         /*!< Port PF9 Pull-Down set  */
#define PWR_PDCRF_PD10_Pos           (10U)
#define PWR_PDCRF_PD10_Msk           (0x1UL << PWR_PDCRF_PD10_Pos)             /*!< 0x00000400 */
#define PWR_PDCRF_PD10               PWR_PDCRF_PD10_Msk                        /*!< Port PF10 Pull-Down set */
#define PWR_PDCRF_PD11_Pos           (11U)
#define PWR_PDCRF_PD11_Msk           (0x1UL << PWR_PDCRF_PD11_Pos)             /*!< 0x00000800 */
#define PWR_PDCRF_PD11               PWR_PDCRF_PD11_Msk                        /*!< Port PF11 Pull-Down set */
#define PWR_PDCRF_PD12_Pos           (12U)
#define PWR_PDCRF_PD12_Msk           (0x1UL << PWR_PDCRF_PD12_Pos)             /*!< 0x00001000 */
#define PWR_PDCRF_PD12               PWR_PDCRF_PD12_Msk                        /*!< Port PF12 Pull-Down set */
#define PWR_PDCRF_PD13_Pos           (13U)
#define PWR_PDCRF_PD13_Msk           (0x1UL << PWR_PDCRF_PD13_Pos)             /*!< 0x00002000 */
#define PWR_PDCRF_PD13               PWR_PDCRF_PD13_Msk                        /*!< Port PF13 Pull-Down set */
#define PWR_PDCRF_PD14_Pos           (14U)
#define PWR_PDCRF_PD14_Msk           (0x1UL << PWR_PDCRF_PD14_Pos)             /*!< 0x00004000 */
#define PWR_PDCRF_PD14               PWR_PDCRF_PD14_Msk                        /*!< Port PF14 Pull-Down set */
#define PWR_PDCRF_PD15_Pos           (15U)
#define PWR_PDCRF_PD15_Msk           (0x1UL << PWR_PDCRF_PD15_Pos)             /*!< 0x00008000 */
#define PWR_PDCRF_PD15               PWR_PDCRF_PD15_Msk                        /*!< Port PF15 Pull-Down set */

/********************  Bit definition for PWR_PUCRG register  ********************/
#define PWR_PUCRG_PU0_Pos            (0U)
#define PWR_PUCRG_PU0_Msk            (0x1UL << PWR_PUCRG_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRG_PU0                PWR_PUCRG_PU0_Msk                         /*!< Port PG0 Pull-Up set  */
#define PWR_PUCRG_PU1_Pos            (1U)
#define PWR_PUCRG_PU1_Msk            (0x1UL << PWR_PUCRG_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRG_PU1                PWR_PUCRG_PU1_Msk                         /*!< Port PG1 Pull-Up set  */
#define PWR_PUCRG_PU2_Pos            (2U)
#define PWR_PUCRG_PU2_Msk            (0x1UL << PWR_PUCRG_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRG_PU2                PWR_PUCRG_PU2_Msk                         /*!< Port PG2 Pull-Up set  */
#define PWR_PUCRG_PU3_Pos            (3U)
#define PWR_PUCRG_PU3_Msk            (0x1UL << PWR_PUCRG_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRG_PU3                PWR_PUCRG_PU3_Msk                         /*!< Port PG3 Pull-Up set  */
#define PWR_PUCRG_PU4_Pos            (4U)
#define PWR_PUCRG_PU4_Msk            (0x1UL << PWR_PUCRG_PU4_Pos)              /*!< 0x00000010 */
#define PWR_PUCRG_PU4                PWR_PUCRG_PU4_Msk                         /*!< Port PG4 Pull-Up set  */
#define PWR_PUCRG_PU5_Pos            (5U)
#define PWR_PUCRG_PU5_Msk            (0x1UL << PWR_PUCRG_PU5_Pos)              /*!< 0x00000020 */
#define PWR_PUCRG_PU5                PWR_PUCRG_PU5_Msk                         /*!< Port PG5 Pull-Up set  */
#define PWR_PUCRG_PU6_Pos            (6U)
#define PWR_PUCRG_PU6_Msk            (0x1UL << PWR_PUCRG_PU6_Pos)              /*!< 0x00000040 */
#define PWR_PUCRG_PU6                PWR_PUCRG_PU6_Msk                         /*!< Port PG6 Pull-Up set  */
#define PWR_PUCRG_PU7_Pos            (7U)
#define PWR_PUCRG_PU7_Msk            (0x1UL << PWR_PUCRG_PU7_Pos)              /*!< 0x00000080 */
#define PWR_PUCRG_PU7                PWR_PUCRG_PU7_Msk                         /*!< Port PG7 Pull-Up set  */
#define PWR_PUCRG_PU8_Pos            (8U)
#define PWR_PUCRG_PU8_Msk            (0x1UL << PWR_PUCRG_PU8_Pos)              /*!< 0x00000100 */
#define PWR_PUCRG_PU8                PWR_PUCRG_PU8_Msk                         /*!< Port PG8 Pull-Up set  */
#define PWR_PUCRG_PU9_Pos            (9U)
#define PWR_PUCRG_PU9_Msk            (0x1UL << PWR_PUCRG_PU9_Pos)              /*!< 0x00000200 */
#define PWR_PUCRG_PU9                PWR_PUCRG_PU9_Msk                         /*!< Port PG9 Pull-Up set  */
#define PWR_PUCRG_PU10_Pos           (10U)
#define PWR_PUCRG_PU10_Msk           (0x1UL << PWR_PUCRG_PU10_Pos)             /*!< 0x00000400 */
#define PWR_PUCRG_PU10               PWR_PUCRG_PU10_Msk                        /*!< Port PG10 Pull-Up set */
#define PWR_PUCRG_PU11_Pos           (11U)
#define PWR_PUCRG_PU11_Msk           (0x1UL << PWR_PUCRG_PU11_Pos)             /*!< 0x00000800 */
#define PWR_PUCRG_PU11               PWR_PUCRG_PU11_Msk                        /*!< Port PG11 Pull-Up set */
#define PWR_PUCRG_PU12_Pos           (12U)
#define PWR_PUCRG_PU12_Msk           (0x1UL << PWR_PUCRG_PU12_Pos)             /*!< 0x00001000 */
#define PWR_PUCRG_PU12               PWR_PUCRG_PU12_Msk                        /*!< Port PG12 Pull-Up set */
#define PWR_PUCRG_PU13_Pos           (13U)
#define PWR_PUCRG_PU13_Msk           (0x1UL << PWR_PUCRG_PU13_Pos)             /*!< 0x00002000 */
#define PWR_PUCRG_PU13               PWR_PUCRG_PU13_Msk                        /*!< Port PG13 Pull-Up set */
#define PWR_PUCRG_PU14_Pos           (14U)
#define PWR_PUCRG_PU14_Msk           (0x1UL << PWR_PUCRG_PU14_Pos)             /*!< 0x00004000 */
#define PWR_PUCRG_PU14               PWR_PUCRG_PU14_Msk                        /*!< Port PG14 Pull-Up set */
#define PWR_PUCRG_PU15_Pos           (15U)
#define PWR_PUCRG_PU15_Msk           (0x1UL << PWR_PUCRG_PU15_Pos)             /*!< 0x00008000 */
#define PWR_PUCRG_PU15               PWR_PUCRG_PU15_Msk                        /*!< Port PG15 Pull-Up set */

/********************  Bit definition for PWR_PDCRG register  ********************/
#define PWR_PDCRG_PD0_Pos            (0U)
#define PWR_PDCRG_PD0_Msk            (0x1UL << PWR_PDCRG_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRG_PD0                PWR_PDCRG_PD0_Msk                         /*!< Port PG0 Pull-Down set  */
#define PWR_PDCRG_PD1_Pos            (1U)
#define PWR_PDCRG_PD1_Msk            (0x1UL << PWR_PDCRG_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRG_PD1                PWR_PDCRG_PD1_Msk                         /*!< Port PG1 Pull-Down set  */
#define PWR_PDCRG_PD2_Pos            (2U)
#define PWR_PDCRG_PD2_Msk            (0x1UL << PWR_PDCRG_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRG_PD2                PWR_PDCRG_PD2_Msk                         /*!< Port PG2 Pull-Down set  */
#define PWR_PDCRG_PD3_Pos            (3U)
#define PWR_PDCRG_PD3_Msk            (0x1UL << PWR_PDCRG_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRG_PD3                PWR_PDCRG_PD3_Msk                         /*!< Port PG3 Pull-Down set  */
#define PWR_PDCRG_PD4_Pos            (4U)
#define PWR_PDCRG_PD4_Msk            (0x1UL << PWR_PDCRG_PD4_Pos)              /*!< 0x00000010 */
#define PWR_PDCRG_PD4                PWR_PDCRG_PD4_Msk                         /*!< Port PG4 Pull-Down set  */
#define PWR_PDCRG_PD5_Pos            (5U)
#define PWR_PDCRG_PD5_Msk            (0x1UL << PWR_PDCRG_PD5_Pos)              /*!< 0x00000020 */
#define PWR_PDCRG_PD5                PWR_PDCRG_PD5_Msk                         /*!< Port PG5 Pull-Down set  */
#define PWR_PDCRG_PD6_Pos            (6U)
#define PWR_PDCRG_PD6_Msk            (0x1UL << PWR_PDCRG_PD6_Pos)              /*!< 0x00000040 */
#define PWR_PDCRG_PD6                PWR_PDCRG_PD6_Msk                         /*!< Port PG6 Pull-Down set  */
#define PWR_PDCRG_PD7_Pos            (7U)
#define PWR_PDCRG_PD7_Msk            (0x1UL << PWR_PDCRG_PD7_Pos)              /*!< 0x00000080 */
#define PWR_PDCRG_PD7                PWR_PDCRG_PD7_Msk                         /*!< Port PG7 Pull-Down set  */
#define PWR_PDCRG_PD8_Pos            (8U)
#define PWR_PDCRG_PD8_Msk            (0x1UL << PWR_PDCRG_PD8_Pos)              /*!< 0x00000100 */
#define PWR_PDCRG_PD8                PWR_PDCRG_PD8_Msk                         /*!< Port PG8 Pull-Down set  */
#define PWR_PDCRG_PD9_Pos            (9U)
#define PWR_PDCRG_PD9_Msk            (0x1UL << PWR_PDCRG_PD9_Pos)              /*!< 0x00000200 */
#define PWR_PDCRG_PD9                PWR_PDCRG_PD9_Msk                         /*!< Port PG9 Pull-Down set  */
#define PWR_PDCRG_PD10_Pos           (10U)
#define PWR_PDCRG_PD10_Msk           (0x1UL << PWR_PDCRG_PD10_Pos)             /*!< 0x00000400 */
#define PWR_PDCRG_PD10               PWR_PDCRG_PD10_Msk                        /*!< Port PG10 Pull-Down set */
#define PWR_PDCRG_PD11_Pos           (11U)
#define PWR_PDCRG_PD11_Msk           (0x1UL << PWR_PDCRG_PD11_Pos)             /*!< 0x00000800 */
#define PWR_PDCRG_PD11               PWR_PDCRG_PD11_Msk                        /*!< Port PG11 Pull-Down set */
#define PWR_PDCRG_PD12_Pos           (12U)
#define PWR_PDCRG_PD12_Msk           (0x1UL << PWR_PDCRG_PD12_Pos)             /*!< 0x00001000 */
#define PWR_PDCRG_PD12               PWR_PDCRG_PD12_Msk                        /*!< Port PG12 Pull-Down set */
#define PWR_PDCRG_PD13_Pos           (13U)
#define PWR_PDCRG_PD13_Msk           (0x1UL << PWR_PDCRG_PD13_Pos)             /*!< 0x00002000 */
#define PWR_PDCRG_PD13               PWR_PDCRG_PD13_Msk                        /*!< Port PG13 Pull-Down set */
#define PWR_PDCRG_PD14_Pos           (14U)
#define PWR_PDCRG_PD14_Msk           (0x1UL << PWR_PDCRG_PD14_Pos)             /*!< 0x00004000 */
#define PWR_PDCRG_PD14               PWR_PDCRG_PD14_Msk                        /*!< Port PG14 Pull-Down set */
#define PWR_PDCRG_PD15_Pos           (15U)
#define PWR_PDCRG_PD15_Msk           (0x1UL << PWR_PDCRG_PD15_Pos)             /*!< 0x00008000 */
#define PWR_PDCRG_PD15               PWR_PDCRG_PD15_Msk                        /*!< Port PG15 Pull-Down set */

/********************  Bit definition for PWR_PUCRH register  ********************/
#define PWR_PUCRH_PU0_Pos            (0U)
#define PWR_PUCRH_PU0_Msk            (0x1UL << PWR_PUCRH_PU0_Pos)              /*!< 0x00000001 */
#define PWR_PUCRH_PU0                PWR_PUCRH_PU0_Msk                         /*!< Port PH0 Pull-Up set  */
#define PWR_PUCRH_PU1_Pos            (1U)
#define PWR_PUCRH_PU1_Msk            (0x1UL << PWR_PUCRH_PU1_Pos)              /*!< 0x00000002 */
#define PWR_PUCRH_PU1                PWR_PUCRH_PU1_Msk                         /*!< Port PH1 Pull-Up set  */
#define PWR_PUCRH_PU2_Pos            (2U)
#define PWR_PUCRH_PU2_Msk            (0x1UL << PWR_PUCRH_PU2_Pos)              /*!< 0x00000004 */
#define PWR_PUCRH_PU2                PWR_PUCRH_PU2_Msk                         /*!< Port PH2 Pull-Up set  */
#define PWR_PUCRH_PU3_Pos            (3U)
#define PWR_PUCRH_PU3_Msk            (0x1UL << PWR_PUCRH_PU3_Pos)              /*!< 0x00000008 */
#define PWR_PUCRH_PU3                PWR_PUCRH_PU3_Msk                         /*!< Port PH3 Pull-Up set  */

/********************  Bit definition for PWR_PDCRH register  ********************/
#define PWR_PDCRH_PD0_Pos            (0U)
#define PWR_PDCRH_PD0_Msk            (0x1UL << PWR_PDCRH_PD0_Pos)              /*!< 0x00000001 */
#define PWR_PDCRH_PD0                PWR_PDCRH_PD0_Msk                         /*!< Port PH0 Pull-Down set  */
#define PWR_PDCRH_PD1_Pos            (1U)
#define PWR_PDCRH_PD1_Msk            (0x1UL << PWR_PDCRH_PD1_Pos)              /*!< 0x00000002 */
#define PWR_PDCRH_PD1                PWR_PDCRH_PD1_Msk                         /*!< Port PH1 Pull-Down set  */
#define PWR_PDCRH_PD2_Pos            (2U)
#define PWR_PDCRH_PD2_Msk            (0x1UL << PWR_PDCRH_PD2_Pos)              /*!< 0x00000004 */
#define PWR_PDCRH_PD2                PWR_PDCRH_PD2_Msk                         /*!< Port PH2 Pull-Down set  */
#define PWR_PDCRH_PD3_Pos            (3U)
#define PWR_PDCRH_PD3_Msk            (0x1UL << PWR_PDCRH_PD3_Pos)              /*!< 0x00000008 */
#define PWR_PDCRH_PD3                PWR_PDCRH_PD3_Msk                         /*!< Port PH3 Pull-Down set  */

/********************  Bit definition for PWR_SECCFGR register  ******************/
#define PWR_SECCFGR_WUPSEC_Pos       (0U)
#define PWR_SECCFGR_WUPSEC_Msk       (0x1FUL << PWR_SECCFGR_WUPSEC_Pos)        /*!< 0x0000001F */
#define PWR_SECCFGR_WUPSEC           PWR_SECCFGR_WUPSEC_Msk                    /*!< Secure Mode Wake-Up Pins  */
#define PWR_SECCFGR_WUP1SEC_Pos      (0U)
#define PWR_SECCFGR_WUP1SEC_Msk      (0x1UL << PWR_SECCFGR_WUP1SEC_Pos)        /*!< 0x00000001 */
#define PWR_SECCFGR_WUP1SEC          PWR_SECCFGR_WUP1SEC_Msk                   /*!< Secure Mode Wake-Up Pin 1 */
#define PWR_SECCFGR_WUP2SEC_Pos      (1U)
#define PWR_SECCFGR_WUP2SEC_Msk      (0x1UL << PWR_SECCFGR_WUP2SEC_Pos)        /*!< 0x00000002 */
#define PWR_SECCFGR_WUP2SEC          PWR_SECCFGR_WUP2SEC_Msk                   /*!< Secure Mode Wake-Up Pin 2 */
#define PWR_SECCFGR_WUP3SEC_Pos      (2U)
#define PWR_SECCFGR_WUP3SEC_Msk      (0x1UL << PWR_SECCFGR_WUP3SEC_Pos)        /*!< 0x00000004 */
#define PWR_SECCFGR_WUP3SEC          PWR_SECCFGR_WUP3SEC_Msk                   /*!< Secure Mode Wake-Up Pin 3 */
#define PWR_SECCFGR_WUP4SEC_Pos      (3U)
#define PWR_SECCFGR_WUP4SEC_Msk      (0x1UL << PWR_SECCFGR_WUP4SEC_Pos)        /*!< 0x00000008 */
#define PWR_SECCFGR_WUP4SEC          PWR_SECCFGR_WUP4SEC_Msk                   /*!< Secure Mode Wake-Up Pin 4 */
#define PWR_SECCFGR_WUP5SEC_Pos      (4U)
#define PWR_SECCFGR_WUP5SEC_Msk      (0x1UL << PWR_SECCFGR_WUP5SEC_Pos)        /*!< 0x00000010 */
#define PWR_SECCFGR_WUP5SEC          PWR_SECCFGR_WUP5SEC_Msk                   /*!< Secure Mode Wake-Up Pin 5 */
#define PWR_SECCFGR_LPMSEC_Pos       (8U)
#define PWR_SECCFGR_LPMSEC_Msk       (0x1UL << PWR_SECCFGR_LPMSEC_Pos)         /*!< 0x00000100 */
#define PWR_SECCFGR_LPMSEC           PWR_SECCFGR_LPMSEC_Msk                    /*!< Secure Mode Low Power Modes */
#define PWR_SECCFGR_VDMSEC_Pos       (9U)
#define PWR_SECCFGR_VDMSEC_Msk       (0x1UL << PWR_SECCFGR_VDMSEC_Pos)         /*!< 0x00000200 */
#define PWR_SECCFGR_VDMSEC           PWR_SECCFGR_VDMSEC_Msk                    /*!< Secure Mode Voltage Detection and Monitoring */
#define PWR_SECCFGR_VBSEC_Pos        (10U)
#define PWR_SECCFGR_VBSEC_Msk        (0x1UL << PWR_SECCFGR_VBSEC_Pos)          /*!< 0x00000400 */
#define PWR_SECCFGR_VBSEC            PWR_SECCFGR_VBSEC_Msk                     /*!< Secure Mode VBAT */
#define PWR_SECCFGR_APCSEC_Pos       (11U)
#define PWR_SECCFGR_APCSEC_Msk       (0x1UL << PWR_SECCFGR_APCSEC_Pos)         /*!< 0x00000800 */
#define PWR_SECCFGR_APCSEC           PWR_SECCFGR_APCSEC_Msk                    /*!< Secure Mode Pull-Up/Down Control */

/********************  Bit definition for PWR_PRIVCFGR register  *****************/
#define PWR_PRIVCFGR_PRIV_Pos        (0U)
#define PWR_PRIVCFGR_PRIV_Msk        (0x1UL << PWR_PRIVCFGR_PRIV_Pos)          /*!< 0x00000001 */
#define PWR_PRIVCFGR_PRIV            PWR_PRIVCFGR_PRIV_Msk                     /*!< Privileged access protection */

/******************************************************************************/
/*                                                                            */
/*                         Reset and Clock Control                            */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for RCC_CR register  ********************/
#define RCC_CR_MSION_Pos                     (0U)
#define RCC_CR_MSION_Msk                     (0x1UL << RCC_CR_MSION_Pos)       /*!< 0x00000001 */
#define RCC_CR_MSION                         RCC_CR_MSION_Msk                  /*!< Internal Multi Speed oscillator (MSI) clock enable */
#define RCC_CR_MSIRDY_Pos                    (1U)
#define RCC_CR_MSIRDY_Msk                    (0x1UL << RCC_CR_MSIRDY_Pos)      /*!< 0x00000002 */
#define RCC_CR_MSIRDY                        RCC_CR_MSIRDY_Msk                 /*!< Internal Multi Speed oscillator (MSI) clock ready flag */
#define RCC_CR_MSIPLLEN_Pos                  (2U)
#define RCC_CR_MSIPLLEN_Msk                  (0x1UL << RCC_CR_MSIPLLEN_Pos)    /*!< 0x00000004 */
#define RCC_CR_MSIPLLEN                      RCC_CR_MSIPLLEN_Msk               /*!< Internal Multi Speed oscillator (MSI) PLL enable */
#define RCC_CR_MSIRGSEL_Pos                  (3U)
#define RCC_CR_MSIRGSEL_Msk                  (0x1UL << RCC_CR_MSIRGSEL_Pos)    /*!< 0x00000008 */
#define RCC_CR_MSIRGSEL                      RCC_CR_MSIRGSEL_Msk               /*!< Internal Multi Speed oscillator (MSI) range selection */

/*!< MSIRANGE configuration : 12 frequency ranges available */
#define RCC_CR_MSIRANGE_Pos                  (4U)
#define RCC_CR_MSIRANGE_Msk                  (0xFUL << RCC_CR_MSIRANGE_Pos)    /*!< 0x000000F0 */
#define RCC_CR_MSIRANGE                      RCC_CR_MSIRANGE_Msk               /*!< Internal Multi Speed oscillator (MSI) clock Range */
#define RCC_CR_MSIRANGE_0                    (0x1UL << RCC_CR_MSIRANGE_Pos)    /*!< 0x00000010 */
#define RCC_CR_MSIRANGE_1                    (0x2UL << RCC_CR_MSIRANGE_Pos)    /*!< 0x00000020 */
#define RCC_CR_MSIRANGE_2                    (0x4UL << RCC_CR_MSIRANGE_Pos)    /*!< 0x00000040 */
#define RCC_CR_MSIRANGE_3                    (0x8UL << RCC_CR_MSIRANGE_Pos)    /*!< 0x00000080 */

#define RCC_CR_HSION_Pos                     (8U)
#define RCC_CR_HSION_Msk                     (0x1UL << RCC_CR_HSION_Pos)       /*!< 0x00000100 */
#define RCC_CR_HSION                         RCC_CR_HSION_Msk                  /*!< Internal High Speed oscillator (HSI16) clock enable */
#define RCC_CR_HSIKERON_Pos                  (9U)
#define RCC_CR_HSIKERON_Msk                  (0x1UL << RCC_CR_HSIKERON_Pos)    /*!< 0x00000200 */
#define RCC_CR_HSIKERON                      RCC_CR_HSIKERON_Msk               /*!< Internal High Speed oscillator (HSI16) clock enable for some IPs Kernel */
#define RCC_CR_HSIRDY_Pos                    (10U)
#define RCC_CR_HSIRDY_Msk                    (0x1UL << RCC_CR_HSIRDY_Pos)      /*!< 0x00000400 */
#define RCC_CR_HSIRDY                        RCC_CR_HSIRDY_Msk                 /*!< Internal High Speed oscillator (HSI16) clock ready flag */
#define RCC_CR_HSIASFS_Pos                   (11U)
#define RCC_CR_HSIASFS_Msk                   (0x1UL << RCC_CR_HSIASFS_Pos)     /*!< 0x00000800 */
#define RCC_CR_HSIASFS                       RCC_CR_HSIASFS_Msk                /*!< HSI16 Automatic Start from Stop */

#define RCC_CR_HSEON_Pos                     (16U)
#define RCC_CR_HSEON_Msk                     (0x1UL << RCC_CR_HSEON_Pos)       /*!< 0x00010000 */
#define RCC_CR_HSEON                         RCC_CR_HSEON_Msk                  /*!< External High Speed oscillator (HSE) clock enable */
#define RCC_CR_HSERDY_Pos                    (17U)
#define RCC_CR_HSERDY_Msk                    (0x1UL << RCC_CR_HSERDY_Pos)      /*!< 0x00020000 */
#define RCC_CR_HSERDY                        RCC_CR_HSERDY_Msk                 /*!< External High Speed oscillator (HSE) clock ready */
#define RCC_CR_HSEBYP_Pos                    (18U)
#define RCC_CR_HSEBYP_Msk                    (0x1UL << RCC_CR_HSEBYP_Pos)      /*!< 0x00040000 */
#define RCC_CR_HSEBYP                        RCC_CR_HSEBYP_Msk                 /*!< External High Speed oscillator (HSE) clock bypass */
#define RCC_CR_CSSON_Pos                     (19U)
#define RCC_CR_CSSON_Msk                     (0x1UL << RCC_CR_CSSON_Pos)       /*!< 0x00080000 */
#define RCC_CR_CSSON                         RCC_CR_CSSON_Msk                  /*!< HSE Clock Security System enable */

#define RCC_CR_PLLON_Pos                     (24U)
#define RCC_CR_PLLON_Msk                     (0x1UL << RCC_CR_PLLON_Pos)       /*!< 0x01000000 */
#define RCC_CR_PLLON                         RCC_CR_PLLON_Msk                  /*!< System PLL clock enable */
#define RCC_CR_PLLRDY_Pos                    (25U)
#define RCC_CR_PLLRDY_Msk                    (0x1UL << RCC_CR_PLLRDY_Pos)      /*!< 0x02000000 */
#define RCC_CR_PLLRDY                        RCC_CR_PLLRDY_Msk                 /*!< System PLL clock ready */
#define RCC_CR_PLLSAI1ON_Pos                 (26U)
#define RCC_CR_PLLSAI1ON_Msk                 (0x1UL << RCC_CR_PLLSAI1ON_Pos)   /*!< 0x04000000 */
#define RCC_CR_PLLSAI1ON                     RCC_CR_PLLSAI1ON_Msk              /*!< SAI1 PLL enable */
#define RCC_CR_PLLSAI1RDY_Pos                (27U)
#define RCC_CR_PLLSAI1RDY_Msk                (0x1UL << RCC_CR_PLLSAI1RDY_Pos)  /*!< 0x08000000 */
#define RCC_CR_PLLSAI1RDY                    RCC_CR_PLLSAI1RDY_Msk             /*!< SAI1 PLL ready */
#define RCC_CR_PLLSAI2ON_Pos                 (28U)
#define RCC_CR_PLLSAI2ON_Msk                 (0x1UL << RCC_CR_PLLSAI2ON_Pos)   /*!< 0x10000000 */
#define RCC_CR_PLLSAI2ON                     RCC_CR_PLLSAI2ON_Msk              /*!< SAI2 PLL enable */
#define RCC_CR_PLLSAI2RDY_Pos                (29U)
#define RCC_CR_PLLSAI2RDY_Msk                (0x1UL << RCC_CR_PLLSAI2RDY_Pos)  /*!< 0x20000000 */
#define RCC_CR_PLLSAI2RDY                    RCC_CR_PLLSAI2RDY_Msk             /*!< SAI2 PLL ready */
#define RCC_CR_PRIV_Pos                      (31U)
#define RCC_CR_PRIV_Msk                      (0x1UL << RCC_CR_PRIV_Pos)        /*!< 0x80000000 */
#define RCC_CR_PRIV                          RCC_CR_PRIV_Msk                   /*!< RCC Privilege enable */

/********************  Bit definition for RCC_ICSCR register  ***************/
/*!< MSICAL configuration */
#define RCC_ICSCR_MSICAL_Pos                 (0U)
#define RCC_ICSCR_MSICAL_Msk                 (0xFFUL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x000000FF */
#define RCC_ICSCR_MSICAL                     RCC_ICSCR_MSICAL_Msk              /*!< MSICAL[7:0] bits */
#define RCC_ICSCR_MSICAL_0                   (0x01UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000001 */
#define RCC_ICSCR_MSICAL_1                   (0x02UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000002 */
#define RCC_ICSCR_MSICAL_2                   (0x04UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000004 */
#define RCC_ICSCR_MSICAL_3                   (0x08UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000008 */
#define RCC_ICSCR_MSICAL_4                   (0x10UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000010 */
#define RCC_ICSCR_MSICAL_5                   (0x20UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000020 */
#define RCC_ICSCR_MSICAL_6                   (0x40UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000040 */
#define RCC_ICSCR_MSICAL_7                   (0x80UL << RCC_ICSCR_MSICAL_Pos)  /*!< 0x00000080 */

/*!< MSITRIM configuration */
#define RCC_ICSCR_MSITRIM_Pos                (8U)
#define RCC_ICSCR_MSITRIM_Msk                (0xFFUL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x0000FF00 */
#define RCC_ICSCR_MSITRIM                    RCC_ICSCR_MSITRIM_Msk             /*!< MSITRIM[7:0] bits */
#define RCC_ICSCR_MSITRIM_0                  (0x01UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00000100 */
#define RCC_ICSCR_MSITRIM_1                  (0x02UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00000200 */
#define RCC_ICSCR_MSITRIM_2                  (0x04UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00000400 */
#define RCC_ICSCR_MSITRIM_3                  (0x08UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00000800 */
#define RCC_ICSCR_MSITRIM_4                  (0x10UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00001000 */
#define RCC_ICSCR_MSITRIM_5                  (0x20UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00002000 */
#define RCC_ICSCR_MSITRIM_6                  (0x40UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00004000 */
#define RCC_ICSCR_MSITRIM_7                  (0x80UL << RCC_ICSCR_MSITRIM_Pos) /*!< 0x00008000 */

/*!< HSICAL configuration */
#define RCC_ICSCR_HSICAL_Pos                 (16U)
#define RCC_ICSCR_HSICAL_Msk                 (0xFFUL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00FF0000 */
#define RCC_ICSCR_HSICAL                     RCC_ICSCR_HSICAL_Msk              /*!< HSICAL[7:0] bits */
#define RCC_ICSCR_HSICAL_0                   (0x01UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00010000 */
#define RCC_ICSCR_HSICAL_1                   (0x02UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00020000 */
#define RCC_ICSCR_HSICAL_2                   (0x04UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00040000 */
#define RCC_ICSCR_HSICAL_3                   (0x08UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00080000 */
#define RCC_ICSCR_HSICAL_4                   (0x10UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00100000 */
#define RCC_ICSCR_HSICAL_5                   (0x20UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00200000 */
#define RCC_ICSCR_HSICAL_6                   (0x40UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00400000 */
#define RCC_ICSCR_HSICAL_7                   (0x80UL << RCC_ICSCR_HSICAL_Pos)  /*!< 0x00800000 */

/*!< HSITRIM configuration */
#define RCC_ICSCR_HSITRIM_Pos                (24U)
#define RCC_ICSCR_HSITRIM_Msk                (0x7FUL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x7F000000 */
#define RCC_ICSCR_HSITRIM                    RCC_ICSCR_HSITRIM_Msk             /*!< HSITRIM[6:0] bits */
#define RCC_ICSCR_HSITRIM_0                  (0x01UL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x01000000 */
#define RCC_ICSCR_HSITRIM_1                  (0x02UL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x02000000 */
#define RCC_ICSCR_HSITRIM_2                  (0x04UL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x04000000 */
#define RCC_ICSCR_HSITRIM_3                  (0x08UL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x08000000 */
#define RCC_ICSCR_HSITRIM_4                  (0x10UL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x10000000 */
#define RCC_ICSCR_HSITRIM_5                  (0x20UL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x20000000 */
#define RCC_ICSCR_HSITRIM_6                  (0x40UL << RCC_ICSCR_HSITRIM_Pos) /*!< 0x40000000 */

/********************  Bit definition for RCC_CFGR register  ******************/
/*!< SW configuration */
#define RCC_CFGR_SW_Pos                      (0U)
#define RCC_CFGR_SW_Msk                      (0x3UL << RCC_CFGR_SW_Pos)        /*!< 0x00000003 */
#define RCC_CFGR_SW                          RCC_CFGR_SW_Msk                   /*!< SW[1:0] bits (System clock Switch) */
#define RCC_CFGR_SW_0                        (0x1UL << RCC_CFGR_SW_Pos)        /*!< 0x00000001 */
#define RCC_CFGR_SW_1                        (0x2UL << RCC_CFGR_SW_Pos)        /*!< 0x00000002 */

/*!< SWS configuration */
#define RCC_CFGR_SWS_Pos                     (2U)
#define RCC_CFGR_SWS_Msk                     (0x3UL << RCC_CFGR_SWS_Pos)       /*!< 0x0000000C */
#define RCC_CFGR_SWS                         RCC_CFGR_SWS_Msk                  /*!< SWS[1:0] bits (System Clock Switch Status) */
#define RCC_CFGR_SWS_0                       (0x1UL << RCC_CFGR_SWS_Pos)       /*!< 0x00000004 */
#define RCC_CFGR_SWS_1                       (0x2UL << RCC_CFGR_SWS_Pos)       /*!< 0x00000008 */

/*!< HPRE configuration */
#define RCC_CFGR_HPRE_Pos                    (4U)
#define RCC_CFGR_HPRE_Msk                    (0xFUL << RCC_CFGR_HPRE_Pos)      /*!< 0x000000F0 */
#define RCC_CFGR_HPRE                        RCC_CFGR_HPRE_Msk                 /*!< HPRE[3:0] bits (AHB prescaler) */
#define RCC_CFGR_HPRE_0                      (0x1UL << RCC_CFGR_HPRE_Pos)      /*!< 0x00000010 */
#define RCC_CFGR_HPRE_1                      (0x2UL << RCC_CFGR_HPRE_Pos)      /*!< 0x00000020 */
#define RCC_CFGR_HPRE_2                      (0x4UL << RCC_CFGR_HPRE_Pos)      /*!< 0x00000040 */
#define RCC_CFGR_HPRE_3                      (0x8UL << RCC_CFGR_HPRE_Pos)      /*!< 0x00000080 */

/*!< PPRE1 configuration */
#define RCC_CFGR_PPRE1_Pos                   (8U)
#define RCC_CFGR_PPRE1_Msk                   (0x7UL << RCC_CFGR_PPRE1_Pos)     /*!< 0x00000700 */
#define RCC_CFGR_PPRE1                       RCC_CFGR_PPRE1_Msk                /*!< PRE1[2:0] bits (APB2 prescaler) */
#define RCC_CFGR_PPRE1_0                     (0x1UL << RCC_CFGR_PPRE1_Pos)     /*!< 0x00000100 */
#define RCC_CFGR_PPRE1_1                     (0x2UL << RCC_CFGR_PPRE1_Pos)     /*!< 0x00000200 */
#define RCC_CFGR_PPRE1_2                     (0x4UL << RCC_CFGR_PPRE1_Pos)     /*!< 0x00000400 */

/*!< PPRE2 configuration */
#define RCC_CFGR_PPRE2_Pos                   (11U)
#define RCC_CFGR_PPRE2_Msk                   (0x7UL << RCC_CFGR_PPRE2_Pos)     /*!< 0x00003800 */
#define RCC_CFGR_PPRE2                       RCC_CFGR_PPRE2_Msk                /*!< PRE2[2:0] bits (APB2 prescaler) */
#define RCC_CFGR_PPRE2_0                     (0x1UL << RCC_CFGR_PPRE2_Pos)     /*!< 0x00000800 */
#define RCC_CFGR_PPRE2_1                     (0x2UL << RCC_CFGR_PPRE2_Pos)     /*!< 0x00001000 */
#define RCC_CFGR_PPRE2_2                     (0x4UL << RCC_CFGR_PPRE2_Pos)     /*!< 0x00002000 */

#define RCC_CFGR_STOPWUCK_Pos                (15U)
#define RCC_CFGR_STOPWUCK_Msk                (0x1UL << RCC_CFGR_STOPWUCK_Pos)  /*!< 0x00008000 */
#define RCC_CFGR_STOPWUCK                    RCC_CFGR_STOPWUCK_Msk             /*!< Wake Up from stop and CSS backup clock selection */

/*!< MCOSEL configuration */
#define RCC_CFGR_MCOSEL_Pos                  (24U)
#define RCC_CFGR_MCOSEL_Msk                  (0xFUL << RCC_CFGR_MCOSEL_Pos)    /*!< 0x0F000000 */
#define RCC_CFGR_MCOSEL                      RCC_CFGR_MCOSEL_Msk               /*!< MCOSEL [3:0] bits (Clock output selection) */
#define RCC_CFGR_MCOSEL_0                    (0x1UL << RCC_CFGR_MCOSEL_Pos)    /*!< 0x01000000 */
#define RCC_CFGR_MCOSEL_1                    (0x2UL << RCC_CFGR_MCOSEL_Pos)    /*!< 0x02000000 */
#define RCC_CFGR_MCOSEL_2                    (0x4UL << RCC_CFGR_MCOSEL_Pos)    /*!< 0x04000000 */
#define RCC_CFGR_MCOSEL_3                    (0x8UL << RCC_CFGR_MCOSEL_Pos)    /*!< 0x08000000 */

#define RCC_CFGR_MCOPRE_Pos                  (28U)
#define RCC_CFGR_MCOPRE_Msk                  (0x7UL << RCC_CFGR_MCOPRE_Pos)    /*!< 0x70000000 */
#define RCC_CFGR_MCOPRE                      RCC_CFGR_MCOPRE_Msk               /*!< MCO prescaler */
#define RCC_CFGR_MCOPRE_0                    (0x1UL << RCC_CFGR_MCOPRE_Pos)    /*!< 0x10000000 */
#define RCC_CFGR_MCOPRE_1                    (0x2UL << RCC_CFGR_MCOPRE_Pos)    /*!< 0x20000000 */
#define RCC_CFGR_MCOPRE_2                    (0x4UL << RCC_CFGR_MCOPRE_Pos)    /*!< 0x40000000 */

/********************  Bit definition for RCC_PLLCFGR register  ***************/
#define RCC_PLLCFGR_PLLSRC_Pos               (0U)
#define RCC_PLLCFGR_PLLSRC_Msk               (0x3UL << RCC_PLLCFGR_PLLSRC_Pos) /*!< 0x00000003 */
#define RCC_PLLCFGR_PLLSRC                   RCC_PLLCFGR_PLLSRC_Msk
#define RCC_PLLCFGR_PLLSRC_0                 (0x1UL << RCC_PLLCFGR_PLLSRC_Pos) /*!< 0x00000001 */
#define RCC_PLLCFGR_PLLSRC_1                 (0x2UL << RCC_PLLCFGR_PLLSRC_Pos) /*!< 0x00000002 */

#define RCC_PLLCFGR_PLLM_Pos                 (4U)
#define RCC_PLLCFGR_PLLM_Msk                 (0xFUL << RCC_PLLCFGR_PLLM_Pos)   /*!< 0x000000F0 */
#define RCC_PLLCFGR_PLLM                     RCC_PLLCFGR_PLLM_Msk
#define RCC_PLLCFGR_PLLM_0                   (0x1UL << RCC_PLLCFGR_PLLM_Pos)   /*!< 0x00000010 */
#define RCC_PLLCFGR_PLLM_1                   (0x2UL << RCC_PLLCFGR_PLLM_Pos)   /*!< 0x00000020 */
#define RCC_PLLCFGR_PLLM_2                   (0x4UL << RCC_PLLCFGR_PLLM_Pos)   /*!< 0x00000040 */
#define RCC_PLLCFGR_PLLM_3                   (0x8UL << RCC_PLLCFGR_PLLM_Pos)   /*!< 0x00000080 */

#define RCC_PLLCFGR_PLLN_Pos                 (8U)
#define RCC_PLLCFGR_PLLN_Msk                 (0x7FUL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00007F00 */
#define RCC_PLLCFGR_PLLN                     RCC_PLLCFGR_PLLN_Msk
#define RCC_PLLCFGR_PLLN_0                   (0x01UL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00000100 */
#define RCC_PLLCFGR_PLLN_1                   (0x02UL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00000200 */
#define RCC_PLLCFGR_PLLN_2                   (0x04UL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00000400 */
#define RCC_PLLCFGR_PLLN_3                   (0x08UL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00000800 */
#define RCC_PLLCFGR_PLLN_4                   (0x10UL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00001000 */
#define RCC_PLLCFGR_PLLN_5                   (0x20UL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00002000 */
#define RCC_PLLCFGR_PLLN_6                   (0x40UL << RCC_PLLCFGR_PLLN_Pos)  /*!< 0x00004000 */

#define RCC_PLLCFGR_PLLPEN_Pos               (16U)
#define RCC_PLLCFGR_PLLPEN_Msk               (0x1UL << RCC_PLLCFGR_PLLPEN_Pos) /*!< 0x00010000 */
#define RCC_PLLCFGR_PLLPEN                   RCC_PLLCFGR_PLLPEN_Msk
#define RCC_PLLCFGR_PLLP_Pos                 (17U)
#define RCC_PLLCFGR_PLLP_Msk                 (0x1UL << RCC_PLLCFGR_PLLP_Pos)   /*!< 0x00020000 */
#define RCC_PLLCFGR_PLLP                     RCC_PLLCFGR_PLLP_Msk
#define RCC_PLLCFGR_PLLQEN_Pos               (20U)
#define RCC_PLLCFGR_PLLQEN_Msk               (0x1UL << RCC_PLLCFGR_PLLQEN_Pos) /*!< 0x00100000 */
#define RCC_PLLCFGR_PLLQEN                   RCC_PLLCFGR_PLLQEN_Msk

#define RCC_PLLCFGR_PLLQ_Pos                 (21U)
#define RCC_PLLCFGR_PLLQ_Msk                 (0x3UL << RCC_PLLCFGR_PLLQ_Pos)   /*!< 0x00600000 */
#define RCC_PLLCFGR_PLLQ                     RCC_PLLCFGR_PLLQ_Msk
#define RCC_PLLCFGR_PLLQ_0                   (0x1UL << RCC_PLLCFGR_PLLQ_Pos)   /*!< 0x00200000 */
#define RCC_PLLCFGR_PLLQ_1                   (0x2UL << RCC_PLLCFGR_PLLQ_Pos)   /*!< 0x00400000 */

#define RCC_PLLCFGR_PLLREN_Pos               (24U)
#define RCC_PLLCFGR_PLLREN_Msk               (0x1UL << RCC_PLLCFGR_PLLREN_Pos) /*!< 0x01000000 */
#define RCC_PLLCFGR_PLLREN                   RCC_PLLCFGR_PLLREN_Msk
#define RCC_PLLCFGR_PLLR_Pos                 (25U)
#define RCC_PLLCFGR_PLLR_Msk                 (0x3UL << RCC_PLLCFGR_PLLR_Pos)   /*!< 0x06000000 */
#define RCC_PLLCFGR_PLLR                     RCC_PLLCFGR_PLLR_Msk
#define RCC_PLLCFGR_PLLR_0                   (0x1UL << RCC_PLLCFGR_PLLR_Pos)   /*!< 0x02000000 */
#define RCC_PLLCFGR_PLLR_1                   (0x2UL << RCC_PLLCFGR_PLLR_Pos)   /*!< 0x04000000 */

#define RCC_PLLCFGR_PLLPDIV_Pos              (27U)
#define RCC_PLLCFGR_PLLPDIV_Msk              (0x1FUL << RCC_PLLCFGR_PLLPDIV_Pos)/*!< 0xF8000000 */
#define RCC_PLLCFGR_PLLPDIV                  RCC_PLLCFGR_PLLPDIV_Msk
#define RCC_PLLCFGR_PLLPDIV_0                (0x01UL << RCC_PLLCFGR_PLLPDIV_Pos)/*!< 0x08000000 */
#define RCC_PLLCFGR_PLLPDIV_1                (0x02UL << RCC_PLLCFGR_PLLPDIV_Pos)/*!< 0x10000000 */
#define RCC_PLLCFGR_PLLPDIV_2                (0x04UL << RCC_PLLCFGR_PLLPDIV_Pos)/*!< 0x20000000 */
#define RCC_PLLCFGR_PLLPDIV_3                (0x08UL << RCC_PLLCFGR_PLLPDIV_Pos)/*!< 0x40000000 */
#define RCC_PLLCFGR_PLLPDIV_4                (0x10UL << RCC_PLLCFGR_PLLPDIV_Pos)/*!< 0x80000000 */

/********************  Bit definition for RCC_PLLSAI1CFGR register  ************/
#define RCC_PLLSAI1CFGR_PLLSAI1SRC_Pos       (0U)
#define RCC_PLLSAI1CFGR_PLLSAI1SRC_Msk       (0x3UL << RCC_PLLSAI1CFGR_PLLSAI1SRC_Pos)/*!< 0x00000003 */
#define RCC_PLLSAI1CFGR_PLLSAI1SRC           RCC_PLLSAI1CFGR_PLLSAI1SRC_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1SRC_0         (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1SRC_Pos)/*!< 0x00000001 */
#define RCC_PLLSAI1CFGR_PLLSAI1SRC_1         (0x2UL << RCC_PLLSAI1CFGR_PLLSAI1SRC_Pos)/*!< 0x00000002 */

#define RCC_PLLSAI1CFGR_PLLSAI1M_Pos         (4U)
#define RCC_PLLSAI1CFGR_PLLSAI1M_Msk         (0xFUL << RCC_PLLSAI1CFGR_PLLSAI1M_Pos)/*!< 0x000000F0 */
#define RCC_PLLSAI1CFGR_PLLSAI1M             RCC_PLLSAI1CFGR_PLLSAI1M_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1M_0           (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1M_Pos)/*!< 0x00000010 */
#define RCC_PLLSAI1CFGR_PLLSAI1M_1           (0x2UL << RCC_PLLSAI1CFGR_PLLSAI1M_Pos)/*!< 0x00000020 */
#define RCC_PLLSAI1CFGR_PLLSAI1M_2           (0x4UL << RCC_PLLSAI1CFGR_PLLSAI1M_Pos)/*!< 0x00000040 */
#define RCC_PLLSAI1CFGR_PLLSAI1M_3           (0x8UL << RCC_PLLSAI1CFGR_PLLSAI1M_Pos)/*!< 0x00000080 */

#define RCC_PLLSAI1CFGR_PLLSAI1N_Pos         (8U)
#define RCC_PLLSAI1CFGR_PLLSAI1N_Msk         (0x7FUL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00007F00 */
#define RCC_PLLSAI1CFGR_PLLSAI1N             RCC_PLLSAI1CFGR_PLLSAI1N_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1N_0           (0x01UL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00000100 */
#define RCC_PLLSAI1CFGR_PLLSAI1N_1           (0x02UL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00000200 */
#define RCC_PLLSAI1CFGR_PLLSAI1N_2           (0x04UL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00000400 */
#define RCC_PLLSAI1CFGR_PLLSAI1N_3           (0x08UL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00000800 */
#define RCC_PLLSAI1CFGR_PLLSAI1N_4           (0x10UL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00001000 */
#define RCC_PLLSAI1CFGR_PLLSAI1N_5           (0x20UL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00002000 */
#define RCC_PLLSAI1CFGR_PLLSAI1N_6           (0x40UL << RCC_PLLSAI1CFGR_PLLSAI1N_Pos)/*!< 0x00004000 */

#define RCC_PLLSAI1CFGR_PLLSAI1PEN_Pos       (16U)
#define RCC_PLLSAI1CFGR_PLLSAI1PEN_Msk       (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1PEN_Pos)/*!< 0x00010000 */
#define RCC_PLLSAI1CFGR_PLLSAI1PEN           RCC_PLLSAI1CFGR_PLLSAI1PEN_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1P_Pos         (17U)
#define RCC_PLLSAI1CFGR_PLLSAI1P_Msk         (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1P_Pos)/*!< 0x00020000 */
#define RCC_PLLSAI1CFGR_PLLSAI1P             RCC_PLLSAI1CFGR_PLLSAI1P_Msk

#define RCC_PLLSAI1CFGR_PLLSAI1QEN_Pos       (20U)
#define RCC_PLLSAI1CFGR_PLLSAI1QEN_Msk       (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1QEN_Pos)/*!< 0x00100000 */
#define RCC_PLLSAI1CFGR_PLLSAI1QEN           RCC_PLLSAI1CFGR_PLLSAI1QEN_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1Q_Pos         (21U)
#define RCC_PLLSAI1CFGR_PLLSAI1Q_Msk         (0x3UL << RCC_PLLSAI1CFGR_PLLSAI1Q_Pos)/*!< 0x00600000 */
#define RCC_PLLSAI1CFGR_PLLSAI1Q             RCC_PLLSAI1CFGR_PLLSAI1Q_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1Q_0           (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1Q_Pos)/*!< 0x00200000 */
#define RCC_PLLSAI1CFGR_PLLSAI1Q_1           (0x2UL << RCC_PLLSAI1CFGR_PLLSAI1Q_Pos)/*!< 0x00400000 */

#define RCC_PLLSAI1CFGR_PLLSAI1REN_Pos       (24U)
#define RCC_PLLSAI1CFGR_PLLSAI1REN_Msk       (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1REN_Pos)/*!< 0x01000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1REN           RCC_PLLSAI1CFGR_PLLSAI1REN_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1R_Pos         (25U)
#define RCC_PLLSAI1CFGR_PLLSAI1R_Msk         (0x3UL << RCC_PLLSAI1CFGR_PLLSAI1R_Pos)/*!< 0x06000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1R             RCC_PLLSAI1CFGR_PLLSAI1R_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1R_0           (0x1UL << RCC_PLLSAI1CFGR_PLLSAI1R_Pos)/*!< 0x02000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1R_1           (0x2UL << RCC_PLLSAI1CFGR_PLLSAI1R_Pos)/*!< 0x04000000 */

#define RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos      (27U)
#define RCC_PLLSAI1CFGR_PLLSAI1PDIV_Msk      (0x1FUL << RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos)/*!< 0xF8000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1PDIV          RCC_PLLSAI1CFGR_PLLSAI1PDIV_Msk
#define RCC_PLLSAI1CFGR_PLLSAI1PDIV_0        (0x01UL << RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos)/*!< 0x08000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1PDIV_1        (0x02UL << RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos)/*!< 0x10000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1PDIV_2        (0x04UL << RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos)/*!< 0x20000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1PDIV_3        (0x08UL << RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos)/*!< 0x40000000 */
#define RCC_PLLSAI1CFGR_PLLSAI1PDIV_4        (0x10UL << RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos)/*!< 0x80000000 */

/********************  Bit definition for RCC_PLLSAI2CFGR register  ************/
#define RCC_PLLSAI2CFGR_PLLSAI2SRC_Pos       (0U)
#define RCC_PLLSAI2CFGR_PLLSAI2SRC_Msk       (0x3UL << RCC_PLLSAI2CFGR_PLLSAI2SRC_Pos)/*!< 0x00000003 */
#define RCC_PLLSAI2CFGR_PLLSAI2SRC           RCC_PLLSAI2CFGR_PLLSAI2SRC_Msk
#define RCC_PLLSAI2CFGR_PLLSAI2SRC_0         (0x1UL << RCC_PLLSAI2CFGR_PLLSAI2SRC_Pos)/*!< 0x00000001 */
#define RCC_PLLSAI2CFGR_PLLSAI2SRC_1         (0x2UL << RCC_PLLSAI2CFGR_PLLSAI2SRC_Pos)/*!< 0x00000002 */

#define RCC_PLLSAI2CFGR_PLLSAI2M_Pos         (4U)
#define RCC_PLLSAI2CFGR_PLLSAI2M_Msk         (0xFUL << RCC_PLLSAI2CFGR_PLLSAI2M_Pos)/*!< 0x000000F0 */
#define RCC_PLLSAI2CFGR_PLLSAI2M             RCC_PLLSAI2CFGR_PLLSAI2M_Msk
#define RCC_PLLSAI2CFGR_PLLSAI2M_0           (0x1UL << RCC_PLLSAI2CFGR_PLLSAI2M_Pos)/*!< 0x00000010 */
#define RCC_PLLSAI2CFGR_PLLSAI2M_1           (0x2UL << RCC_PLLSAI2CFGR_PLLSAI2M_Pos)/*!< 0x00000020 */
#define RCC_PLLSAI2CFGR_PLLSAI2M_2           (0x4UL << RCC_PLLSAI2CFGR_PLLSAI2M_Pos)/*!< 0x00000040 */
#define RCC_PLLSAI2CFGR_PLLSAI2M_3           (0x8UL << RCC_PLLSAI2CFGR_PLLSAI2M_Pos)/*!< 0x00000080 */

#define RCC_PLLSAI2CFGR_PLLSAI2N_Pos         (8U)
#define RCC_PLLSAI2CFGR_PLLSAI2N_Msk         (0x7FUL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00007F00 */
#define RCC_PLLSAI2CFGR_PLLSAI2N             RCC_PLLSAI2CFGR_PLLSAI2N_Msk
#define RCC_PLLSAI2CFGR_PLLSAI2N_0           (0x01UL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00000100 */
#define RCC_PLLSAI2CFGR_PLLSAI2N_1           (0x02UL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00000200 */
#define RCC_PLLSAI2CFGR_PLLSAI2N_2           (0x04UL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00000400 */
#define RCC_PLLSAI2CFGR_PLLSAI2N_3           (0x08UL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00000800 */
#define RCC_PLLSAI2CFGR_PLLSAI2N_4           (0x10UL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00001000 */
#define RCC_PLLSAI2CFGR_PLLSAI2N_5           (0x20UL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00002000 */
#define RCC_PLLSAI2CFGR_PLLSAI2N_6           (0x40UL << RCC_PLLSAI2CFGR_PLLSAI2N_Pos)/*!< 0x00004000 */

#define RCC_PLLSAI2CFGR_PLLSAI2PEN_Pos       (16U)
#define RCC_PLLSAI2CFGR_PLLSAI2PEN_Msk       (0x1UL << RCC_PLLSAI2CFGR_PLLSAI2PEN_Pos)/*!< 0x00010000 */
#define RCC_PLLSAI2CFGR_PLLSAI2PEN           RCC_PLLSAI2CFGR_PLLSAI2PEN_Msk
#define RCC_PLLSAI2CFGR_PLLSAI2P_Pos         (17U)
#define RCC_PLLSAI2CFGR_PLLSAI2P_Msk         (0x1UL << RCC_PLLSAI2CFGR_PLLSAI2P_Pos)/*!< 0x00020000 */
#define RCC_PLLSAI2CFGR_PLLSAI2P             RCC_PLLSAI2CFGR_PLLSAI2P_Msk

#define RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos      (27U)
#define RCC_PLLSAI2CFGR_PLLSAI2PDIV_Msk      (0x1FUL << RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos)/*!< 0xF8000000 */
#define RCC_PLLSAI2CFGR_PLLSAI2PDIV          RCC_PLLSAI2CFGR_PLLSAI2PDIV_Msk
#define RCC_PLLSAI2CFGR_PLLSAI2PDIV_0        (0x01UL << RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos)/*!< 0x08000000 */
#define RCC_PLLSAI2CFGR_PLLSAI2PDIV_1        (0x02UL << RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos)/*!< 0x10000000 */
#define RCC_PLLSAI2CFGR_PLLSAI2PDIV_2        (0x04UL << RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos)/*!< 0x20000000 */
#define RCC_PLLSAI2CFGR_PLLSAI2PDIV_3        (0x08UL << RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos)/*!< 0x40000000 */
#define RCC_PLLSAI2CFGR_PLLSAI2PDIV_4        (0x10UL << RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos)/*!< 0x80000000 */

/********************  Bit definition for RCC_CIER register  ******************/
#define RCC_CIER_LSIRDYIE_Pos                (0U)
#define RCC_CIER_LSIRDYIE_Msk                (0x1UL << RCC_CIER_LSIRDYIE_Pos)  /*!< 0x00000001 */
#define RCC_CIER_LSIRDYIE                    RCC_CIER_LSIRDYIE_Msk
#define RCC_CIER_LSERDYIE_Pos                (1U)
#define RCC_CIER_LSERDYIE_Msk                (0x1UL << RCC_CIER_LSERDYIE_Pos)  /*!< 0x00000002 */
#define RCC_CIER_LSERDYIE                    RCC_CIER_LSERDYIE_Msk
#define RCC_CIER_MSIRDYIE_Pos                (2U)
#define RCC_CIER_MSIRDYIE_Msk                (0x1UL << RCC_CIER_MSIRDYIE_Pos)  /*!< 0x00000004 */
#define RCC_CIER_MSIRDYIE                    RCC_CIER_MSIRDYIE_Msk
#define RCC_CIER_HSIRDYIE_Pos                (3U)
#define RCC_CIER_HSIRDYIE_Msk                (0x1UL << RCC_CIER_HSIRDYIE_Pos)  /*!< 0x00000008 */
#define RCC_CIER_HSIRDYIE                    RCC_CIER_HSIRDYIE_Msk
#define RCC_CIER_HSERDYIE_Pos                (4U)
#define RCC_CIER_HSERDYIE_Msk                (0x1UL << RCC_CIER_HSERDYIE_Pos)  /*!< 0x00000010 */
#define RCC_CIER_HSERDYIE                    RCC_CIER_HSERDYIE_Msk
#define RCC_CIER_PLLRDYIE_Pos                (5U)
#define RCC_CIER_PLLRDYIE_Msk                (0x1UL << RCC_CIER_PLLRDYIE_Pos)  /*!< 0x00000020 */
#define RCC_CIER_PLLRDYIE                    RCC_CIER_PLLRDYIE_Msk
#define RCC_CIER_PLLSAI1RDYIE_Pos            (6U)
#define RCC_CIER_PLLSAI1RDYIE_Msk            (0x1UL << RCC_CIER_PLLSAI1RDYIE_Pos)/*!< 0x00000040 */
#define RCC_CIER_PLLSAI1RDYIE                RCC_CIER_PLLSAI1RDYIE_Msk
#define RCC_CIER_PLLSAI2RDYIE_Pos            (7U)
#define RCC_CIER_PLLSAI2RDYIE_Msk            (0x1UL << RCC_CIER_PLLSAI2RDYIE_Pos)/*!< 0x00000080 */
#define RCC_CIER_PLLSAI2RDYIE                RCC_CIER_PLLSAI2RDYIE_Msk
#define RCC_CIER_HSI48RDYIE_Pos              (10U)
#define RCC_CIER_HSI48RDYIE_Msk              (0x1UL << RCC_CIER_HSI48RDYIE_Pos)/*!< 0x00000400 */
#define RCC_CIER_HSI48RDYIE                  RCC_CIER_HSI48RDYIE_Msk

/********************  Bit definition for RCC_CIFR register  ****************/
#define RCC_CIFR_LSIRDYF_Pos                 (0U)
#define RCC_CIFR_LSIRDYF_Msk                 (0x1UL << RCC_CIFR_LSIRDYF_Pos)   /*!< 0x00000001 */
#define RCC_CIFR_LSIRDYF                     RCC_CIFR_LSIRDYF_Msk
#define RCC_CIFR_LSERDYF_Pos                 (1U)
#define RCC_CIFR_LSERDYF_Msk                 (0x1UL << RCC_CIFR_LSERDYF_Pos)   /*!< 0x00000002 */
#define RCC_CIFR_LSERDYF                     RCC_CIFR_LSERDYF_Msk
#define RCC_CIFR_MSIRDYF_Pos                 (2U)
#define RCC_CIFR_MSIRDYF_Msk                 (0x1UL << RCC_CIFR_MSIRDYF_Pos)   /*!< 0x00000004 */
#define RCC_CIFR_MSIRDYF                     RCC_CIFR_MSIRDYF_Msk
#define RCC_CIFR_HSIRDYF_Pos                 (3U)
#define RCC_CIFR_HSIRDYF_Msk                 (0x1UL << RCC_CIFR_HSIRDYF_Pos)   /*!< 0x00000008 */
#define RCC_CIFR_HSIRDYF                     RCC_CIFR_HSIRDYF_Msk
#define RCC_CIFR_HSERDYF_Pos                 (4U)
#define RCC_CIFR_HSERDYF_Msk                 (0x1UL << RCC_CIFR_HSERDYF_Pos)   /*!< 0x00000010 */
#define RCC_CIFR_HSERDYF                     RCC_CIFR_HSERDYF_Msk
#define RCC_CIFR_PLLRDYF_Pos                 (5U)
#define RCC_CIFR_PLLRDYF_Msk                 (0x1UL << RCC_CIFR_PLLRDYF_Pos)   /*!< 0x00000020 */
#define RCC_CIFR_PLLRDYF                     RCC_CIFR_PLLRDYF_Msk
#define RCC_CIFR_PLLSAI1RDYF_Pos             (6U)
#define RCC_CIFR_PLLSAI1RDYF_Msk             (0x1UL << RCC_CIFR_PLLSAI1RDYF_Pos)/*!< 0x00000040 */
#define RCC_CIFR_PLLSAI1RDYF                 RCC_CIFR_PLLSAI1RDYF_Msk
#define RCC_CIFR_PLLSAI2RDYF_Pos             (7U)
#define RCC_CIFR_PLLSAI2RDYF_Msk             (0x1UL << RCC_CIFR_PLLSAI2RDYF_Pos)/*!< 0x00000080 */
#define RCC_CIFR_PLLSAI2RDYF                 RCC_CIFR_PLLSAI2RDYF_Msk
#define RCC_CIFR_CSSF_Pos                    (8U)
#define RCC_CIFR_CSSF_Msk                    (0x1UL << RCC_CIFR_CSSF_Pos)      /*!< 0x00000100 */
#define RCC_CIFR_CSSF                        RCC_CIFR_CSSF_Msk
#define RCC_CIFR_HSI48RDYF_Pos               (10U)
#define RCC_CIFR_HSI48RDYF_Msk               (0x1UL << RCC_CIFR_HSI48RDYF_Pos) /*!< 0x00000400 */
#define RCC_CIFR_HSI48RDYF                   RCC_CIFR_HSI48RDYF_Msk

/********************  Bit definition for RCC_CICR register  ****************/
#define RCC_CICR_LSIRDYC_Pos                 (0U)
#define RCC_CICR_LSIRDYC_Msk                 (0x1UL << RCC_CICR_LSIRDYC_Pos)   /*!< 0x00000001 */
#define RCC_CICR_LSIRDYC                     RCC_CICR_LSIRDYC_Msk
#define RCC_CICR_LSERDYC_Pos                 (1U)
#define RCC_CICR_LSERDYC_Msk                 (0x1UL << RCC_CICR_LSERDYC_Pos)   /*!< 0x00000002 */
#define RCC_CICR_LSERDYC                     RCC_CICR_LSERDYC_Msk
#define RCC_CICR_MSIRDYC_Pos                 (2U)
#define RCC_CICR_MSIRDYC_Msk                 (0x1UL << RCC_CICR_MSIRDYC_Pos)   /*!< 0x00000004 */
#define RCC_CICR_MSIRDYC                     RCC_CICR_MSIRDYC_Msk
#define RCC_CICR_HSIRDYC_Pos                 (3U)
#define RCC_CICR_HSIRDYC_Msk                 (0x1UL << RCC_CICR_HSIRDYC_Pos)   /*!< 0x00000008 */
#define RCC_CICR_HSIRDYC                     RCC_CICR_HSIRDYC_Msk
#define RCC_CICR_HSERDYC_Pos                 (4U)
#define RCC_CICR_HSERDYC_Msk                 (0x1UL << RCC_CICR_HSERDYC_Pos)   /*!< 0x00000010 */
#define RCC_CICR_HSERDYC                     RCC_CICR_HSERDYC_Msk
#define RCC_CICR_PLLRDYC_Pos                 (5U)
#define RCC_CICR_PLLRDYC_Msk                 (0x1UL << RCC_CICR_PLLRDYC_Pos)   /*!< 0x00000020 */
#define RCC_CICR_PLLRDYC                     RCC_CICR_PLLRDYC_Msk
#define RCC_CICR_PLLSAI1RDYC_Pos             (6U)
#define RCC_CICR_PLLSAI1RDYC_Msk             (0x1UL << RCC_CICR_PLLSAI1RDYC_Pos)/*!< 0x00000040 */
#define RCC_CICR_PLLSAI1RDYC                 RCC_CICR_PLLSAI1RDYC_Msk
#define RCC_CICR_PLLSAI2RDYC_Pos             (7U)
#define RCC_CICR_PLLSAI2RDYC_Msk             (0x1UL << RCC_CICR_PLLSAI2RDYC_Pos)/*!< 0x00000080 */
#define RCC_CICR_PLLSAI2RDYC                 RCC_CICR_PLLSAI2RDYC_Msk
#define RCC_CICR_CSSC_Pos                    (8U)
#define RCC_CICR_CSSC_Msk                    (0x1UL << RCC_CICR_CSSC_Pos)      /*!< 0x00000100 */
#define RCC_CICR_CSSC                        RCC_CICR_CSSC_Msk
#define RCC_CICR_HSI48RDYC_Pos               (10U)
#define RCC_CICR_HSI48RDYC_Msk               (0x1UL << RCC_CICR_HSI48RDYC_Pos) /*!< 0x00000400 */
#define RCC_CICR_HSI48RDYC                   RCC_CICR_HSI48RDYC_Msk

/********************  Bit definition for RCC_AHB1RSTR register  **************/
#define RCC_AHB1RSTR_DMA1RST_Pos             (0U)
#define RCC_AHB1RSTR_DMA1RST_Msk             (0x1UL << RCC_AHB1RSTR_DMA1RST_Pos)/*!< 0x00000001 */
#define RCC_AHB1RSTR_DMA1RST                 RCC_AHB1RSTR_DMA1RST_Msk
#define RCC_AHB1RSTR_DMA2RST_Pos             (1U)
#define RCC_AHB1RSTR_DMA2RST_Msk             (0x1UL << RCC_AHB1RSTR_DMA2RST_Pos)/*!< 0x00000002 */
#define RCC_AHB1RSTR_DMA2RST                 RCC_AHB1RSTR_DMA2RST_Msk
#define RCC_AHB1RSTR_DMAMUX1RST_Pos          (2U)
#define RCC_AHB1RSTR_DMAMUX1RST_Msk          (0x1UL << RCC_AHB1RSTR_DMAMUX1RST_Pos)/*!< 0x00000004 */
#define RCC_AHB1RSTR_DMAMUX1RST              RCC_AHB1RSTR_DMAMUX1RST_Msk
#define RCC_AHB1RSTR_FLASHRST_Pos            (8U)
#define RCC_AHB1RSTR_FLASHRST_Msk            (0x1UL << RCC_AHB1RSTR_FLASHRST_Pos)/*!< 0x00000100 */
#define RCC_AHB1RSTR_FLASHRST                RCC_AHB1RSTR_FLASHRST_Msk
#define RCC_AHB1RSTR_CRCRST_Pos              (12U)
#define RCC_AHB1RSTR_CRCRST_Msk              (0x1UL << RCC_AHB1RSTR_CRCRST_Pos)/*!< 0x00001000 */
#define RCC_AHB1RSTR_CRCRST                  RCC_AHB1RSTR_CRCRST_Msk
#define RCC_AHB1RSTR_TSCRST_Pos              (16U)
#define RCC_AHB1RSTR_TSCRST_Msk              (0x1UL << RCC_AHB1RSTR_TSCRST_Pos)/*!< 0x00010000 */
#define RCC_AHB1RSTR_TSCRST                  RCC_AHB1RSTR_TSCRST_Msk

/********************  Bit definition for RCC_AHB2RSTR register  **************/
#define RCC_AHB2RSTR_GPIOARST_Pos            (0U)
#define RCC_AHB2RSTR_GPIOARST_Msk            (0x1UL << RCC_AHB2RSTR_GPIOARST_Pos)/*!< 0x00000001 */
#define RCC_AHB2RSTR_GPIOARST                RCC_AHB2RSTR_GPIOARST_Msk
#define RCC_AHB2RSTR_GPIOBRST_Pos            (1U)
#define RCC_AHB2RSTR_GPIOBRST_Msk            (0x1UL << RCC_AHB2RSTR_GPIOBRST_Pos)/*!< 0x00000002 */
#define RCC_AHB2RSTR_GPIOBRST                RCC_AHB2RSTR_GPIOBRST_Msk
#define RCC_AHB2RSTR_GPIOCRST_Pos            (2U)
#define RCC_AHB2RSTR_GPIOCRST_Msk            (0x1UL << RCC_AHB2RSTR_GPIOCRST_Pos)/*!< 0x00000004 */
#define RCC_AHB2RSTR_GPIOCRST                RCC_AHB2RSTR_GPIOCRST_Msk
#define RCC_AHB2RSTR_GPIODRST_Pos            (3U)
#define RCC_AHB2RSTR_GPIODRST_Msk            (0x1UL << RCC_AHB2RSTR_GPIODRST_Pos)/*!< 0x00000008 */
#define RCC_AHB2RSTR_GPIODRST                RCC_AHB2RSTR_GPIODRST_Msk
#define RCC_AHB2RSTR_GPIOERST_Pos            (4U)
#define RCC_AHB2RSTR_GPIOERST_Msk            (0x1UL << RCC_AHB2RSTR_GPIOERST_Pos)/*!< 0x00000010 */
#define RCC_AHB2RSTR_GPIOERST                RCC_AHB2RSTR_GPIOERST_Msk
#define RCC_AHB2RSTR_GPIOFRST_Pos            (5U)
#define RCC_AHB2RSTR_GPIOFRST_Msk            (0x1UL << RCC_AHB2RSTR_GPIOFRST_Pos)/*!< 0x00000020 */
#define RCC_AHB2RSTR_GPIOFRST                RCC_AHB2RSTR_GPIOFRST_Msk
#define RCC_AHB2RSTR_GPIOGRST_Pos            (6U)
#define RCC_AHB2RSTR_GPIOGRST_Msk            (0x1UL << RCC_AHB2RSTR_GPIOGRST_Pos)/*!< 0x00000040 */
#define RCC_AHB2RSTR_GPIOGRST                RCC_AHB2RSTR_GPIOGRST_Msk
#define RCC_AHB2RSTR_GPIOHRST_Pos            (7U)
#define RCC_AHB2RSTR_GPIOHRST_Msk            (0x1UL << RCC_AHB2RSTR_GPIOHRST_Pos)/*!< 0x00000080 */
#define RCC_AHB2RSTR_GPIOHRST                RCC_AHB2RSTR_GPIOHRST_Msk
#define RCC_AHB2RSTR_ADCRST_Pos              (13U)
#define RCC_AHB2RSTR_ADCRST_Msk              (0x1UL << RCC_AHB2RSTR_ADCRST_Pos)/*!< 0x00002000 */
#define RCC_AHB2RSTR_ADCRST                  RCC_AHB2RSTR_ADCRST_Msk
#define RCC_AHB2RSTR_HASHRST_Pos             (17U)
#define RCC_AHB2RSTR_HASHRST_Msk             (0x1UL << RCC_AHB2RSTR_HASHRST_Pos)/*!< 0x00020000 */
#define RCC_AHB2RSTR_HASHRST                 RCC_AHB2RSTR_HASHRST_Msk
#define RCC_AHB2RSTR_RNGRST_Pos              (18U)
#define RCC_AHB2RSTR_RNGRST_Msk              (0x1UL << RCC_AHB2RSTR_RNGRST_Pos)/*!< 0x00040000 */
#define RCC_AHB2RSTR_RNGRST                  RCC_AHB2RSTR_RNGRST_Msk
#define RCC_AHB2RSTR_SDMMC1RST_Pos           (22U)
#define RCC_AHB2RSTR_SDMMC1RST_Msk           (0x1UL << RCC_AHB2RSTR_SDMMC1RST_Pos)/*!< 0x00400000 */
#define RCC_AHB2RSTR_SDMMC1RST               RCC_AHB2RSTR_SDMMC1RST_Msk

/********************  Bit definition for RCC_AHB3RSTR register  **************/
#define RCC_AHB3RSTR_FMCRST_Pos              (0U)
#define RCC_AHB3RSTR_FMCRST_Msk              (0x1UL << RCC_AHB3RSTR_FMCRST_Pos)/*!< 0x00000001 */
#define RCC_AHB3RSTR_FMCRST                  RCC_AHB3RSTR_FMCRST_Msk
#define RCC_AHB3RSTR_OSPI1RST_Pos            (8U)
#define RCC_AHB3RSTR_OSPI1RST_Msk            (0x1UL << RCC_AHB3RSTR_OSPI1RST_Pos)/*!< 0x00000100 */
#define RCC_AHB3RSTR_OSPI1RST                RCC_AHB3RSTR_OSPI1RST_Msk

/********************  Bit definition for RCC_APB1RSTR1 register  **************/
#define RCC_APB1RSTR1_TIM2RST_Pos            (0U)
#define RCC_APB1RSTR1_TIM2RST_Msk            (0x1UL << RCC_APB1RSTR1_TIM2RST_Pos)/*!< 0x00000001 */
#define RCC_APB1RSTR1_TIM2RST                RCC_APB1RSTR1_TIM2RST_Msk
#define RCC_APB1RSTR1_TIM3RST_Pos            (1U)
#define RCC_APB1RSTR1_TIM3RST_Msk            (0x1UL << RCC_APB1RSTR1_TIM3RST_Pos)/*!< 0x00000002 */
#define RCC_APB1RSTR1_TIM3RST                RCC_APB1RSTR1_TIM3RST_Msk
#define RCC_APB1RSTR1_TIM4RST_Pos            (2U)
#define RCC_APB1RSTR1_TIM4RST_Msk            (0x1UL << RCC_APB1RSTR1_TIM4RST_Pos)/*!< 0x00000004 */
#define RCC_APB1RSTR1_TIM4RST                RCC_APB1RSTR1_TIM4RST_Msk
#define RCC_APB1RSTR1_TIM5RST_Pos            (3U)
#define RCC_APB1RSTR1_TIM5RST_Msk            (0x1UL << RCC_APB1RSTR1_TIM5RST_Pos)/*!< 0x00000008 */
#define RCC_APB1RSTR1_TIM5RST                RCC_APB1RSTR1_TIM5RST_Msk
#define RCC_APB1RSTR1_TIM6RST_Pos            (4U)
#define RCC_APB1RSTR1_TIM6RST_Msk            (0x1UL << RCC_APB1RSTR1_TIM6RST_Pos)/*!< 0x00000010 */
#define RCC_APB1RSTR1_TIM6RST                RCC_APB1RSTR1_TIM6RST_Msk
#define RCC_APB1RSTR1_TIM7RST_Pos            (5U)
#define RCC_APB1RSTR1_TIM7RST_Msk            (0x1UL << RCC_APB1RSTR1_TIM7RST_Pos)/*!< 0x00000020 */
#define RCC_APB1RSTR1_TIM7RST                RCC_APB1RSTR1_TIM7RST_Msk
#define RCC_APB1RSTR1_SPI2RST_Pos            (14U)
#define RCC_APB1RSTR1_SPI2RST_Msk            (0x1UL << RCC_APB1RSTR1_SPI2RST_Pos)/*!< 0x00004000 */
#define RCC_APB1RSTR1_SPI2RST                RCC_APB1RSTR1_SPI2RST_Msk
#define RCC_APB1RSTR1_SPI3RST_Pos            (15U)
#define RCC_APB1RSTR1_SPI3RST_Msk            (0x1UL << RCC_APB1RSTR1_SPI3RST_Pos)/*!< 0x00008000 */
#define RCC_APB1RSTR1_SPI3RST                RCC_APB1RSTR1_SPI3RST_Msk
#define RCC_APB1RSTR1_USART2RST_Pos          (17U)
#define RCC_APB1RSTR1_USART2RST_Msk          (0x1UL << RCC_APB1RSTR1_USART2RST_Pos)/*!< 0x00020000 */
#define RCC_APB1RSTR1_USART2RST              RCC_APB1RSTR1_USART2RST_Msk
#define RCC_APB1RSTR1_USART3RST_Pos          (18U)
#define RCC_APB1RSTR1_USART3RST_Msk          (0x1UL << RCC_APB1RSTR1_USART3RST_Pos)/*!< 0x00040000 */
#define RCC_APB1RSTR1_USART3RST              RCC_APB1RSTR1_USART3RST_Msk
#define RCC_APB1RSTR1_UART4RST_Pos           (19U)
#define RCC_APB1RSTR1_UART4RST_Msk           (0x1UL << RCC_APB1RSTR1_UART4RST_Pos)/*!< 0x00080000 */
#define RCC_APB1RSTR1_UART4RST               RCC_APB1RSTR1_UART4RST_Msk
#define RCC_APB1RSTR1_UART5RST_Pos           (20U)
#define RCC_APB1RSTR1_UART5RST_Msk           (0x1UL << RCC_APB1RSTR1_UART5RST_Pos)/*!< 0x00100000 */
#define RCC_APB1RSTR1_UART5RST               RCC_APB1RSTR1_UART5RST_Msk
#define RCC_APB1RSTR1_I2C1RST_Pos            (21U)
#define RCC_APB1RSTR1_I2C1RST_Msk            (0x1UL << RCC_APB1RSTR1_I2C1RST_Pos)/*!< 0x00200000 */
#define RCC_APB1RSTR1_I2C1RST                RCC_APB1RSTR1_I2C1RST_Msk
#define RCC_APB1RSTR1_I2C2RST_Pos            (22U)
#define RCC_APB1RSTR1_I2C2RST_Msk            (0x1UL << RCC_APB1RSTR1_I2C2RST_Pos)/*!< 0x00400000 */
#define RCC_APB1RSTR1_I2C2RST                RCC_APB1RSTR1_I2C2RST_Msk
#define RCC_APB1RSTR1_I2C3RST_Pos            (23U)
#define RCC_APB1RSTR1_I2C3RST_Msk            (0x1UL << RCC_APB1RSTR1_I2C3RST_Pos)/*!< 0x00800000 */
#define RCC_APB1RSTR1_I2C3RST                RCC_APB1RSTR1_I2C3RST_Msk
#define RCC_APB1RSTR1_CRSRST_Pos             (24U)
#define RCC_APB1RSTR1_CRSRST_Msk             (0x1UL << RCC_APB1RSTR1_CRSRST_Pos)/*!< 0x01000000 */
#define RCC_APB1RSTR1_CRSRST                 RCC_APB1RSTR1_CRSRST_Msk
#define RCC_APB1RSTR1_PWRRST_Pos             (28U)
#define RCC_APB1RSTR1_PWRRST_Msk             (0x1UL << RCC_APB1RSTR1_PWRRST_Pos)/*!< 0x10000000 */
#define RCC_APB1RSTR1_PWRRST                 RCC_APB1RSTR1_PWRRST_Msk
#define RCC_APB1RSTR1_DAC1RST_Pos            (29U)
#define RCC_APB1RSTR1_DAC1RST_Msk            (0x1UL << RCC_APB1RSTR1_DAC1RST_Pos)/*!< 0x20000000 */
#define RCC_APB1RSTR1_DAC1RST                RCC_APB1RSTR1_DAC1RST_Msk
#define RCC_APB1RSTR1_OPAMPRST_Pos           (30U)
#define RCC_APB1RSTR1_OPAMPRST_Msk           (0x1UL << RCC_APB1RSTR1_OPAMPRST_Pos)/*!< 0x40000000 */
#define RCC_APB1RSTR1_OPAMPRST               RCC_APB1RSTR1_OPAMPRST_Msk
#define RCC_APB1RSTR1_LPTIM1RST_Pos          (31U)
#define RCC_APB1RSTR1_LPTIM1RST_Msk          (0x1UL << RCC_APB1RSTR1_LPTIM1RST_Pos)/*!< 0x80000000 */
#define RCC_APB1RSTR1_LPTIM1RST              RCC_APB1RSTR1_LPTIM1RST_Msk

/********************  Bit definition for RCC_APB1RSTR2 register  **************/
#define RCC_APB1RSTR2_LPUART1RST_Pos         (0U)
#define RCC_APB1RSTR2_LPUART1RST_Msk         (0x1UL << RCC_APB1RSTR2_LPUART1RST_Pos)/*!< 0x00000001 */
#define RCC_APB1RSTR2_LPUART1RST             RCC_APB1RSTR2_LPUART1RST_Msk
#define RCC_APB1RSTR2_I2C4RST_Pos            (1U)
#define RCC_APB1RSTR2_I2C4RST_Msk            (0x1UL << RCC_APB1RSTR2_I2C4RST_Pos)/*!< 0x00000002 */
#define RCC_APB1RSTR2_I2C4RST                RCC_APB1RSTR2_I2C4RST_Msk
#define RCC_APB1RSTR2_LPTIM2RST_Pos          (5U)
#define RCC_APB1RSTR2_LPTIM2RST_Msk          (0x1UL << RCC_APB1RSTR2_LPTIM2RST_Pos)/*!< 0x00000020 */
#define RCC_APB1RSTR2_LPTIM2RST              RCC_APB1RSTR2_LPTIM2RST_Msk
#define RCC_APB1RSTR2_LPTIM3RST_Pos          (6U)
#define RCC_APB1RSTR2_LPTIM3RST_Msk          (0x1UL << RCC_APB1RSTR2_LPTIM3RST_Pos)/*!< 0x00000040 */
#define RCC_APB1RSTR2_LPTIM3RST              RCC_APB1RSTR2_LPTIM3RST_Msk
#define RCC_APB1RSTR2_FDCAN1RST_Pos          (9U)
#define RCC_APB1RSTR2_FDCAN1RST_Msk          (0x1UL << RCC_APB1RSTR2_FDCAN1RST_Pos)/*!< 0x00000200 */
#define RCC_APB1RSTR2_FDCAN1RST              RCC_APB1RSTR2_FDCAN1RST_Msk
#define RCC_APB1RSTR2_USBFSRST_Pos           (21U)
#define RCC_APB1RSTR2_USBFSRST_Msk           (0x1UL << RCC_APB1RSTR2_USBFSRST_Pos)/*!< 0x00200000 */
#define RCC_APB1RSTR2_USBFSRST               RCC_APB1RSTR2_USBFSRST_Msk
#define RCC_APB1RSTR2_UCPD1RST_Pos           (23U)
#define RCC_APB1RSTR2_UCPD1RST_Msk           (0x1UL << RCC_APB1RSTR2_UCPD1RST_Pos)/*!< 0x00800000 */
#define RCC_APB1RSTR2_UCPD1RST               RCC_APB1RSTR2_UCPD1RST_Msk

/********************  Bit definition for RCC_APB2RSTR register  **************/
#define RCC_APB2RSTR_SYSCFGRST_Pos           (0U)
#define RCC_APB2RSTR_SYSCFGRST_Msk           (0x1UL << RCC_APB2RSTR_SYSCFGRST_Pos)/*!< 0x00000001 */
#define RCC_APB2RSTR_SYSCFGRST               RCC_APB2RSTR_SYSCFGRST_Msk
#define RCC_APB2RSTR_TIM1RST_Pos             (11U)
#define RCC_APB2RSTR_TIM1RST_Msk             (0x1UL << RCC_APB2RSTR_TIM1RST_Pos)/*!< 0x00000800 */
#define RCC_APB2RSTR_TIM1RST                 RCC_APB2RSTR_TIM1RST_Msk
#define RCC_APB2RSTR_SPI1RST_Pos             (12U)
#define RCC_APB2RSTR_SPI1RST_Msk             (0x1UL << RCC_APB2RSTR_SPI1RST_Pos)/*!< 0x00001000 */
#define RCC_APB2RSTR_SPI1RST                 RCC_APB2RSTR_SPI1RST_Msk
#define RCC_APB2RSTR_TIM8RST_Pos             (13U)
#define RCC_APB2RSTR_TIM8RST_Msk             (0x1UL << RCC_APB2RSTR_TIM8RST_Pos)/*!< 0x00002000 */
#define RCC_APB2RSTR_TIM8RST                 RCC_APB2RSTR_TIM8RST_Msk
#define RCC_APB2RSTR_USART1RST_Pos           (14U)
#define RCC_APB2RSTR_USART1RST_Msk           (0x1UL << RCC_APB2RSTR_USART1RST_Pos)/*!< 0x00004000 */
#define RCC_APB2RSTR_USART1RST               RCC_APB2RSTR_USART1RST_Msk
#define RCC_APB2RSTR_TIM15RST_Pos            (16U)
#define RCC_APB2RSTR_TIM15RST_Msk            (0x1UL << RCC_APB2RSTR_TIM15RST_Pos)/*!< 0x00010000 */
#define RCC_APB2RSTR_TIM15RST                RCC_APB2RSTR_TIM15RST_Msk
#define RCC_APB2RSTR_TIM16RST_Pos            (17U)
#define RCC_APB2RSTR_TIM16RST_Msk            (0x1UL << RCC_APB2RSTR_TIM16RST_Pos)/*!< 0x00020000 */
#define RCC_APB2RSTR_TIM16RST                RCC_APB2RSTR_TIM16RST_Msk
#define RCC_APB2RSTR_TIM17RST_Pos            (18U)
#define RCC_APB2RSTR_TIM17RST_Msk            (0x1UL << RCC_APB2RSTR_TIM17RST_Pos)/*!< 0x00040000 */
#define RCC_APB2RSTR_TIM17RST                RCC_APB2RSTR_TIM17RST_Msk
#define RCC_APB2RSTR_SAI1RST_Pos             (21U)
#define RCC_APB2RSTR_SAI1RST_Msk             (0x1UL << RCC_APB2RSTR_SAI1RST_Pos)/*!< 0x00200000 */
#define RCC_APB2RSTR_SAI1RST                 RCC_APB2RSTR_SAI1RST_Msk
#define RCC_APB2RSTR_SAI2RST_Pos             (22U)
#define RCC_APB2RSTR_SAI2RST_Msk             (0x1UL << RCC_APB2RSTR_SAI2RST_Pos)/*!< 0x00400000 */
#define RCC_APB2RSTR_SAI2RST                 RCC_APB2RSTR_SAI2RST_Msk
#define RCC_APB2RSTR_DFSDM1RST_Pos           (24U)
#define RCC_APB2RSTR_DFSDM1RST_Msk           (0x1UL << RCC_APB2RSTR_DFSDM1RST_Pos)/*!< 0x01000000 */
#define RCC_APB2RSTR_DFSDM1RST               RCC_APB2RSTR_DFSDM1RST_Msk

/********************  Bit definition for RCC_AHB1ENR register  ***************/
#define RCC_AHB1ENR_DMA1EN_Pos               (0U)
#define RCC_AHB1ENR_DMA1EN_Msk               (0x1UL << RCC_AHB1ENR_DMA1EN_Pos) /*!< 0x00000001 */
#define RCC_AHB1ENR_DMA1EN                   RCC_AHB1ENR_DMA1EN_Msk
#define RCC_AHB1ENR_DMA2EN_Pos               (1U)
#define RCC_AHB1ENR_DMA2EN_Msk               (0x1UL << RCC_AHB1ENR_DMA2EN_Pos) /*!< 0x00000002 */
#define RCC_AHB1ENR_DMA2EN                   RCC_AHB1ENR_DMA2EN_Msk
#define RCC_AHB1ENR_DMAMUX1EN_Pos            (2U)
#define RCC_AHB1ENR_DMAMUX1EN_Msk            (0x1UL << RCC_AHB1ENR_DMAMUX1EN_Pos)/*!< 0x00000004 */
#define RCC_AHB1ENR_DMAMUX1EN                RCC_AHB1ENR_DMAMUX1EN_Msk
#define RCC_AHB1ENR_FLASHEN_Pos              (8U)
#define RCC_AHB1ENR_FLASHEN_Msk              (0x1UL << RCC_AHB1ENR_FLASHEN_Pos)/*!< 0x00000100 */
#define RCC_AHB1ENR_FLASHEN                  RCC_AHB1ENR_FLASHEN_Msk
#define RCC_AHB1ENR_CRCEN_Pos                (12U)
#define RCC_AHB1ENR_CRCEN_Msk                (0x1UL << RCC_AHB1ENR_CRCEN_Pos)  /*!< 0x00001000 */
#define RCC_AHB1ENR_CRCEN                    RCC_AHB1ENR_CRCEN_Msk
#define RCC_AHB1ENR_TSCEN_Pos                (16U)
#define RCC_AHB1ENR_TSCEN_Msk                (0x1UL << RCC_AHB1ENR_TSCEN_Pos)  /*!< 0x00010000 */
#define RCC_AHB1ENR_TSCEN                    RCC_AHB1ENR_TSCEN_Msk
#define RCC_AHB1ENR_GTZCEN_Pos               (22U)
#define RCC_AHB1ENR_GTZCEN_Msk               (0x1UL << RCC_AHB1ENR_GTZCEN_Pos)/*!< 0x00400000 */
#define RCC_AHB1ENR_GTZCEN                   RCC_AHB1ENR_GTZCEN_Msk

/********************  Bit definition for RCC_AHB2ENR register  ***************/
#define RCC_AHB2ENR_GPIOAEN_Pos              (0U)
#define RCC_AHB2ENR_GPIOAEN_Msk              (0x1UL << RCC_AHB2ENR_GPIOAEN_Pos)/*!< 0x00000001 */
#define RCC_AHB2ENR_GPIOAEN                  RCC_AHB2ENR_GPIOAEN_Msk
#define RCC_AHB2ENR_GPIOBEN_Pos              (1U)
#define RCC_AHB2ENR_GPIOBEN_Msk              (0x1UL << RCC_AHB2ENR_GPIOBEN_Pos)/*!< 0x00000002 */
#define RCC_AHB2ENR_GPIOBEN                  RCC_AHB2ENR_GPIOBEN_Msk
#define RCC_AHB2ENR_GPIOCEN_Pos              (2U)
#define RCC_AHB2ENR_GPIOCEN_Msk              (0x1UL << RCC_AHB2ENR_GPIOCEN_Pos)/*!< 0x00000004 */
#define RCC_AHB2ENR_GPIOCEN                  RCC_AHB2ENR_GPIOCEN_Msk
#define RCC_AHB2ENR_GPIODEN_Pos              (3U)
#define RCC_AHB2ENR_GPIODEN_Msk              (0x1UL << RCC_AHB2ENR_GPIODEN_Pos)/*!< 0x00000008 */
#define RCC_AHB2ENR_GPIODEN                  RCC_AHB2ENR_GPIODEN_Msk
#define RCC_AHB2ENR_GPIOEEN_Pos              (4U)
#define RCC_AHB2ENR_GPIOEEN_Msk              (0x1UL << RCC_AHB2ENR_GPIOEEN_Pos)/*!< 0x00000010 */
#define RCC_AHB2ENR_GPIOEEN                  RCC_AHB2ENR_GPIOEEN_Msk
#define RCC_AHB2ENR_GPIOFEN_Pos              (5U)
#define RCC_AHB2ENR_GPIOFEN_Msk              (0x1UL << RCC_AHB2ENR_GPIOFEN_Pos)/*!< 0x00000020 */
#define RCC_AHB2ENR_GPIOFEN                  RCC_AHB2ENR_GPIOFEN_Msk
#define RCC_AHB2ENR_GPIOGEN_Pos              (6U)
#define RCC_AHB2ENR_GPIOGEN_Msk              (0x1UL << RCC_AHB2ENR_GPIOGEN_Pos)/*!< 0x00000040 */
#define RCC_AHB2ENR_GPIOGEN                  RCC_AHB2ENR_GPIOGEN_Msk
#define RCC_AHB2ENR_GPIOHEN_Pos              (7U)
#define RCC_AHB2ENR_GPIOHEN_Msk              (0x1UL << RCC_AHB2ENR_GPIOHEN_Pos)/*!< 0x00000080 */
#define RCC_AHB2ENR_GPIOHEN                  RCC_AHB2ENR_GPIOHEN_Msk
#define RCC_AHB2ENR_ADCEN_Pos                (13U)
#define RCC_AHB2ENR_ADCEN_Msk                (0x1UL << RCC_AHB2ENR_ADCEN_Pos)  /*!< 0x00002000 */
#define RCC_AHB2ENR_ADCEN                    RCC_AHB2ENR_ADCEN_Msk
#define RCC_AHB2ENR_HASHEN_Pos               (17U)
#define RCC_AHB2ENR_HASHEN_Msk               (0x1UL << RCC_AHB2ENR_HASHEN_Pos) /*!< 0x00020000 */
#define RCC_AHB2ENR_HASHEN                   RCC_AHB2ENR_HASHEN_Msk
#define RCC_AHB2ENR_RNGEN_Pos                (18U)
#define RCC_AHB2ENR_RNGEN_Msk                (0x1UL << RCC_AHB2ENR_RNGEN_Pos)  /*!< 0x00040000 */
#define RCC_AHB2ENR_RNGEN                    RCC_AHB2ENR_RNGEN_Msk
#define RCC_AHB2ENR_SDMMC1EN_Pos             (22U)
#define RCC_AHB2ENR_SDMMC1EN_Msk             (0x1UL << RCC_AHB2ENR_SDMMC1EN_Pos)/*!< 0x00400000 */
#define RCC_AHB2ENR_SDMMC1EN                 RCC_AHB2ENR_SDMMC1EN_Msk

/********************  Bit definition for RCC_AHB3ENR register  ***************/
#define RCC_AHB3ENR_FMCEN_Pos                (0U)
#define RCC_AHB3ENR_FMCEN_Msk                (0x1UL << RCC_AHB3ENR_FMCEN_Pos)  /*!< 0x00000001 */
#define RCC_AHB3ENR_FMCEN                    RCC_AHB3ENR_FMCEN_Msk
#define RCC_AHB3ENR_OSPI1EN_Pos              (8U)
#define RCC_AHB3ENR_OSPI1EN_Msk              (0x1UL << RCC_AHB3ENR_OSPI1EN_Pos)/*!< 0x00000100 */
#define RCC_AHB3ENR_OSPI1EN                  RCC_AHB3ENR_OSPI1EN_Msk

/********************  Bit definition for RCC_APB1ENR1 register  ***************/
#define RCC_APB1ENR1_TIM2EN_Pos              (0U)
#define RCC_APB1ENR1_TIM2EN_Msk              (0x1UL << RCC_APB1ENR1_TIM2EN_Pos)/*!< 0x00000001 */
#define RCC_APB1ENR1_TIM2EN                  RCC_APB1ENR1_TIM2EN_Msk
#define RCC_APB1ENR1_TIM3EN_Pos              (1U)
#define RCC_APB1ENR1_TIM3EN_Msk              (0x1UL << RCC_APB1ENR1_TIM3EN_Pos)/*!< 0x00000002 */
#define RCC_APB1ENR1_TIM3EN                  RCC_APB1ENR1_TIM3EN_Msk
#define RCC_APB1ENR1_TIM4EN_Pos              (2U)
#define RCC_APB1ENR1_TIM4EN_Msk              (0x1UL << RCC_APB1ENR1_TIM4EN_Pos)/*!< 0x00000004 */
#define RCC_APB1ENR1_TIM4EN                  RCC_APB1ENR1_TIM4EN_Msk
#define RCC_APB1ENR1_TIM5EN_Pos              (3U)
#define RCC_APB1ENR1_TIM5EN_Msk              (0x1UL << RCC_APB1ENR1_TIM5EN_Pos)/*!< 0x00000008 */
#define RCC_APB1ENR1_TIM5EN                  RCC_APB1ENR1_TIM5EN_Msk
#define RCC_APB1ENR1_TIM6EN_Pos              (4U)
#define RCC_APB1ENR1_TIM6EN_Msk              (0x1UL << RCC_APB1ENR1_TIM6EN_Pos)/*!< 0x00000010 */
#define RCC_APB1ENR1_TIM6EN                  RCC_APB1ENR1_TIM6EN_Msk
#define RCC_APB1ENR1_TIM7EN_Pos              (5U)
#define RCC_APB1ENR1_TIM7EN_Msk              (0x1UL << RCC_APB1ENR1_TIM7EN_Pos)/*!< 0x00000020 */
#define RCC_APB1ENR1_TIM7EN                  RCC_APB1ENR1_TIM7EN_Msk
#define RCC_APB1ENR1_RTCAPBEN_Pos            (10U)
#define RCC_APB1ENR1_RTCAPBEN_Msk            (0x1UL << RCC_APB1ENR1_RTCAPBEN_Pos)/*!< 0x00000400 */
#define RCC_APB1ENR1_RTCAPBEN                RCC_APB1ENR1_RTCAPBEN_Msk
#define RCC_APB1ENR1_WWDGEN_Pos              (11U)
#define RCC_APB1ENR1_WWDGEN_Msk              (0x1UL << RCC_APB1ENR1_WWDGEN_Pos)/*!< 0x00000800 */
#define RCC_APB1ENR1_WWDGEN                  RCC_APB1ENR1_WWDGEN_Msk
#define RCC_APB1ENR1_SPI2EN_Pos              (14U)
#define RCC_APB1ENR1_SPI2EN_Msk              (0x1UL << RCC_APB1ENR1_SPI2EN_Pos)/*!< 0x00004000 */
#define RCC_APB1ENR1_SPI2EN                  RCC_APB1ENR1_SPI2EN_Msk
#define RCC_APB1ENR1_SPI3EN_Pos              (15U)
#define RCC_APB1ENR1_SPI3EN_Msk              (0x1UL << RCC_APB1ENR1_SPI3EN_Pos)/*!< 0x00008000 */
#define RCC_APB1ENR1_SPI3EN                  RCC_APB1ENR1_SPI3EN_Msk
#define RCC_APB1ENR1_USART2EN_Pos            (17U)
#define RCC_APB1ENR1_USART2EN_Msk            (0x1UL << RCC_APB1ENR1_USART2EN_Pos)/*!< 0x00020000 */
#define RCC_APB1ENR1_USART2EN                RCC_APB1ENR1_USART2EN_Msk
#define RCC_APB1ENR1_USART3EN_Pos            (18U)
#define RCC_APB1ENR1_USART3EN_Msk            (0x1UL << RCC_APB1ENR1_USART3EN_Pos)/*!< 0x00040000 */
#define RCC_APB1ENR1_USART3EN                RCC_APB1ENR1_USART3EN_Msk
#define RCC_APB1ENR1_UART4EN_Pos             (19U)
#define RCC_APB1ENR1_UART4EN_Msk             (0x1UL << RCC_APB1ENR1_UART4EN_Pos)/*!< 0x00080000 */
#define RCC_APB1ENR1_UART4EN                 RCC_APB1ENR1_UART4EN_Msk
#define RCC_APB1ENR1_UART5EN_Pos             (20U)
#define RCC_APB1ENR1_UART5EN_Msk             (0x1UL << RCC_APB1ENR1_UART5EN_Pos)/*!< 0x00100000 */
#define RCC_APB1ENR1_UART5EN                 RCC_APB1ENR1_UART5EN_Msk
#define RCC_APB1ENR1_I2C1EN_Pos              (21U)
#define RCC_APB1ENR1_I2C1EN_Msk              (0x1UL << RCC_APB1ENR1_I2C1EN_Pos)/*!< 0x00200000 */
#define RCC_APB1ENR1_I2C1EN                  RCC_APB1ENR1_I2C1EN_Msk
#define RCC_APB1ENR1_I2C2EN_Pos              (22U)
#define RCC_APB1ENR1_I2C2EN_Msk              (0x1UL << RCC_APB1ENR1_I2C2EN_Pos)/*!< 0x00400000 */
#define RCC_APB1ENR1_I2C2EN                  RCC_APB1ENR1_I2C2EN_Msk
#define RCC_APB1ENR1_I2C3EN_Pos              (23U)
#define RCC_APB1ENR1_I2C3EN_Msk              (0x1UL << RCC_APB1ENR1_I2C3EN_Pos)/*!< 0x00800000 */
#define RCC_APB1ENR1_I2C3EN                  RCC_APB1ENR1_I2C3EN_Msk
#define RCC_APB1ENR1_CRSEN_Pos               (24U)
#define RCC_APB1ENR1_CRSEN_Msk               (0x1UL << RCC_APB1ENR1_CRSEN_Pos) /*!< 0x01000000 */
#define RCC_APB1ENR1_CRSEN                   RCC_APB1ENR1_CRSEN_Msk
#define RCC_APB1ENR1_PWREN_Pos               (28U)
#define RCC_APB1ENR1_PWREN_Msk               (0x1UL << RCC_APB1ENR1_PWREN_Pos) /*!< 0x10000000 */
#define RCC_APB1ENR1_PWREN                   RCC_APB1ENR1_PWREN_Msk
#define RCC_APB1ENR1_DAC1EN_Pos              (29U)
#define RCC_APB1ENR1_DAC1EN_Msk              (0x1UL << RCC_APB1ENR1_DAC1EN_Pos)/*!< 0x20000000 */
#define RCC_APB1ENR1_DAC1EN                  RCC_APB1ENR1_DAC1EN_Msk
#define RCC_APB1ENR1_OPAMPEN_Pos             (30U)
#define RCC_APB1ENR1_OPAMPEN_Msk             (0x1UL << RCC_APB1ENR1_OPAMPEN_Pos)/*!< 0x40000000 */
#define RCC_APB1ENR1_OPAMPEN                 RCC_APB1ENR1_OPAMPEN_Msk
#define RCC_APB1ENR1_LPTIM1EN_Pos            (31U)
#define RCC_APB1ENR1_LPTIM1EN_Msk            (0x1UL << RCC_APB1ENR1_LPTIM1EN_Pos)/*!< 0x80000000 */
#define RCC_APB1ENR1_LPTIM1EN                RCC_APB1ENR1_LPTIM1EN_Msk

/********************  Bit definition for RCC_APB1RSTR2 register  **************/
#define RCC_APB1ENR2_LPUART1EN_Pos           (0U)
#define RCC_APB1ENR2_LPUART1EN_Msk           (0x1UL << RCC_APB1ENR2_LPUART1EN_Pos)/*!< 0x00000001 */
#define RCC_APB1ENR2_LPUART1EN               RCC_APB1ENR2_LPUART1EN_Msk
#define RCC_APB1ENR2_I2C4EN_Pos              (1U)
#define RCC_APB1ENR2_I2C4EN_Msk              (0x1UL << RCC_APB1ENR2_I2C4EN_Pos)/*!< 0x00000002 */
#define RCC_APB1ENR2_I2C4EN                  RCC_APB1ENR2_I2C4EN_Msk
#define RCC_APB1ENR2_LPTIM2EN_Pos            (5U)
#define RCC_APB1ENR2_LPTIM2EN_Msk            (0x1UL << RCC_APB1ENR2_LPTIM2EN_Pos)/*!< 0x00000020 */
#define RCC_APB1ENR2_LPTIM2EN                RCC_APB1ENR2_LPTIM2EN_Msk
#define RCC_APB1ENR2_LPTIM3EN_Pos            (6U)
#define RCC_APB1ENR2_LPTIM3EN_Msk            (0x1UL << RCC_APB1ENR2_LPTIM3EN_Pos)/*!< 0x00000040 */
#define RCC_APB1ENR2_LPTIM3EN                RCC_APB1ENR2_LPTIM3EN_Msk
#define RCC_APB1ENR2_FDCAN1EN_Pos            (9U)
#define RCC_APB1ENR2_FDCAN1EN_Msk            (0x1UL << RCC_APB1ENR2_FDCAN1EN_Pos)/*!< 0x00000200 */
#define RCC_APB1ENR2_FDCAN1EN                RCC_APB1ENR2_FDCAN1EN_Msk
#define RCC_APB1ENR2_USBFSEN_Pos             (21U)
#define RCC_APB1ENR2_USBFSEN_Msk             (0x1UL << RCC_APB1ENR2_USBFSEN_Pos)/*!< 0x00200000 */
#define RCC_APB1ENR2_USBFSEN                 RCC_APB1ENR2_USBFSEN_Msk
#define RCC_APB1ENR2_UCPD1EN_Pos             (23U)
#define RCC_APB1ENR2_UCPD1EN_Msk             (0x1UL << RCC_APB1ENR2_UCPD1EN_Pos)/*!< 0x00800000 */
#define RCC_APB1ENR2_UCPD1EN                 RCC_APB1ENR2_UCPD1EN_Msk

/********************  Bit definition for RCC_APB2ENR register  ***************/
#define RCC_APB2ENR_SYSCFGEN_Pos             (0U)
#define RCC_APB2ENR_SYSCFGEN_Msk             (0x1UL << RCC_APB2ENR_SYSCFGEN_Pos)/*!< 0x00000001 */
#define RCC_APB2ENR_SYSCFGEN                 RCC_APB2ENR_SYSCFGEN_Msk
#define RCC_APB2ENR_TIM1EN_Pos               (11U)
#define RCC_APB2ENR_TIM1EN_Msk               (0x1UL << RCC_APB2ENR_TIM1EN_Pos) /*!< 0x00000800 */
#define RCC_APB2ENR_TIM1EN                   RCC_APB2ENR_TIM1EN_Msk
#define RCC_APB2ENR_SPI1EN_Pos               (12U)
#define RCC_APB2ENR_SPI1EN_Msk               (0x1UL << RCC_APB2ENR_SPI1EN_Pos) /*!< 0x00001000 */
#define RCC_APB2ENR_SPI1EN                   RCC_APB2ENR_SPI1EN_Msk
#define RCC_APB2ENR_TIM8EN_Pos               (13U)
#define RCC_APB2ENR_TIM8EN_Msk               (0x1UL << RCC_APB2ENR_TIM8EN_Pos) /*!< 0x00002000 */
#define RCC_APB2ENR_TIM8EN                   RCC_APB2ENR_TIM8EN_Msk
#define RCC_APB2ENR_USART1EN_Pos             (14U)
#define RCC_APB2ENR_USART1EN_Msk             (0x1UL << RCC_APB2ENR_USART1EN_Pos)/*!< 0x00004000 */
#define RCC_APB2ENR_USART1EN                 RCC_APB2ENR_USART1EN_Msk
#define RCC_APB2ENR_TIM15EN_Pos              (16U)
#define RCC_APB2ENR_TIM15EN_Msk              (0x1UL << RCC_APB2ENR_TIM15EN_Pos)/*!< 0x00010000 */
#define RCC_APB2ENR_TIM15EN                  RCC_APB2ENR_TIM15EN_Msk
#define RCC_APB2ENR_TIM16EN_Pos              (17U)
#define RCC_APB2ENR_TIM16EN_Msk              (0x1UL << RCC_APB2ENR_TIM16EN_Pos)/*!< 0x00020000 */
#define RCC_APB2ENR_TIM16EN                  RCC_APB2ENR_TIM16EN_Msk
#define RCC_APB2ENR_TIM17EN_Pos              (18U)
#define RCC_APB2ENR_TIM17EN_Msk              (0x1UL << RCC_APB2ENR_TIM17EN_Pos)/*!< 0x00040000 */
#define RCC_APB2ENR_TIM17EN                  RCC_APB2ENR_TIM17EN_Msk
#define RCC_APB2ENR_SAI1EN_Pos               (21U)
#define RCC_APB2ENR_SAI1EN_Msk               (0x1UL << RCC_APB2ENR_SAI1EN_Pos) /*!< 0x00200000 */
#define RCC_APB2ENR_SAI1EN                   RCC_APB2ENR_SAI1EN_Msk
#define RCC_APB2ENR_SAI2EN_Pos               (22U)
#define RCC_APB2ENR_SAI2EN_Msk               (0x1UL << RCC_APB2ENR_SAI2EN_Pos) /*!< 0x00400000 */
#define RCC_APB2ENR_SAI2EN                   RCC_APB2ENR_SAI2EN_Msk
#define RCC_APB2ENR_DFSDM1EN_Pos             (24U)
#define RCC_APB2ENR_DFSDM1EN_Msk             (0x1UL << RCC_APB2ENR_DFSDM1EN_Pos)/*!< 0x01000000 */
#define RCC_APB2ENR_DFSDM1EN                 RCC_APB2ENR_DFSDM1EN_Msk

/********************  Bit definition for RCC_AHB1SMENR register  ***************/
#define RCC_AHB1SMENR_DMA1SMEN_Pos           (0U)
#define RCC_AHB1SMENR_DMA1SMEN_Msk           (0x1UL << RCC_AHB1SMENR_DMA1SMEN_Pos)/*!< 0x00000001 */
#define RCC_AHB1SMENR_DMA1SMEN               RCC_AHB1SMENR_DMA1SMEN_Msk
#define RCC_AHB1SMENR_DMA2SMEN_Pos           (1U)
#define RCC_AHB1SMENR_DMA2SMEN_Msk           (0x1UL << RCC_AHB1SMENR_DMA2SMEN_Pos)/*!< 0x00000002 */
#define RCC_AHB1SMENR_DMA2SMEN               RCC_AHB1SMENR_DMA2SMEN_Msk
#define RCC_AHB1SMENR_DMAMUX1SMEN_Pos        (2U)
#define RCC_AHB1SMENR_DMAMUX1SMEN_Msk        (0x1UL << RCC_AHB1SMENR_DMAMUX1SMEN_Pos)/*!< 0x00000004 */
#define RCC_AHB1SMENR_DMAMUX1SMEN            RCC_AHB1SMENR_DMAMUX1SMEN_Msk
#define RCC_AHB1SMENR_FLASHSMEN_Pos          (8U)
#define RCC_AHB1SMENR_FLASHSMEN_Msk          (0x1UL << RCC_AHB1SMENR_FLASHSMEN_Pos)/*!< 0x00000100 */
#define RCC_AHB1SMENR_FLASHSMEN              RCC_AHB1SMENR_FLASHSMEN_Msk
#define RCC_AHB1SMENR_SRAM1SMEN_Pos          (9U)
#define RCC_AHB1SMENR_SRAM1SMEN_Msk          (0x1UL << RCC_AHB1SMENR_SRAM1SMEN_Pos)/*!< 0x00000200 */
#define RCC_AHB1SMENR_SRAM1SMEN              RCC_AHB1SMENR_SRAM1SMEN_Msk
#define RCC_AHB1SMENR_CRCSMEN_Pos            (12U)
#define RCC_AHB1SMENR_CRCSMEN_Msk            (0x1UL << RCC_AHB1SMENR_CRCSMEN_Pos)/*!< 0x00001000 */
#define RCC_AHB1SMENR_CRCSMEN                RCC_AHB1SMENR_CRCSMEN_Msk
#define RCC_AHB1SMENR_TSCSMEN_Pos            (16U)
#define RCC_AHB1SMENR_TSCSMEN_Msk            (0x1UL << RCC_AHB1SMENR_TSCSMEN_Pos)/*!< 0x00010000 */
#define RCC_AHB1SMENR_TSCSMEN                RCC_AHB1SMENR_TSCSMEN_Msk
#define RCC_AHB1SMENR_GTZCSMEN_Pos           (22U)
#define RCC_AHB1SMENR_GTZCSMEN_Msk           (0x1UL << RCC_AHB1SMENR_GTZCSMEN_Pos)/*!< 0x00400000 */
#define RCC_AHB1SMENR_GTZCSMEN               RCC_AHB1SMENR_GTZCSMEN_Msk
#define RCC_AHB1SMENR_ICACHESMEN_Pos         (23U)
#define RCC_AHB1SMENR_ICACHESMEN_Msk         (0x1UL << RCC_AHB1SMENR_ICACHESMEN_Pos)/*!< 0x00600000 */
#define RCC_AHB1SMENR_ICACHESMEN             RCC_AHB1SMENR_ICACHESMEN_Msk

/********************  Bit definition for RCC_AHB2SMENR register  *************/
#define RCC_AHB2SMENR_GPIOASMEN_Pos          (0U)
#define RCC_AHB2SMENR_GPIOASMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIOASMEN_Pos)/*!< 0x00000001 */
#define RCC_AHB2SMENR_GPIOASMEN              RCC_AHB2SMENR_GPIOASMEN_Msk
#define RCC_AHB2SMENR_GPIOBSMEN_Pos          (1U)
#define RCC_AHB2SMENR_GPIOBSMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIOBSMEN_Pos)/*!< 0x00000002 */
#define RCC_AHB2SMENR_GPIOBSMEN              RCC_AHB2SMENR_GPIOBSMEN_Msk
#define RCC_AHB2SMENR_GPIOCSMEN_Pos          (2U)
#define RCC_AHB2SMENR_GPIOCSMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIOCSMEN_Pos)/*!< 0x00000004 */
#define RCC_AHB2SMENR_GPIOCSMEN              RCC_AHB2SMENR_GPIOCSMEN_Msk
#define RCC_AHB2SMENR_GPIODSMEN_Pos          (3U)
#define RCC_AHB2SMENR_GPIODSMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIODSMEN_Pos)/*!< 0x00000008 */
#define RCC_AHB2SMENR_GPIODSMEN              RCC_AHB2SMENR_GPIODSMEN_Msk
#define RCC_AHB2SMENR_GPIOESMEN_Pos          (4U)
#define RCC_AHB2SMENR_GPIOESMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIOESMEN_Pos)/*!< 0x00000010 */
#define RCC_AHB2SMENR_GPIOESMEN              RCC_AHB2SMENR_GPIOESMEN_Msk
#define RCC_AHB2SMENR_GPIOFSMEN_Pos          (5U)
#define RCC_AHB2SMENR_GPIOFSMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIOFSMEN_Pos)/*!< 0x00000020 */
#define RCC_AHB2SMENR_GPIOFSMEN              RCC_AHB2SMENR_GPIOFSMEN_Msk
#define RCC_AHB2SMENR_GPIOGSMEN_Pos          (6U)
#define RCC_AHB2SMENR_GPIOGSMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIOGSMEN_Pos)/*!< 0x00000040 */
#define RCC_AHB2SMENR_GPIOGSMEN              RCC_AHB2SMENR_GPIOGSMEN_Msk
#define RCC_AHB2SMENR_GPIOHSMEN_Pos          (7U)
#define RCC_AHB2SMENR_GPIOHSMEN_Msk          (0x1UL << RCC_AHB2SMENR_GPIOHSMEN_Pos)/*!< 0x00000080 */
#define RCC_AHB2SMENR_GPIOHSMEN              RCC_AHB2SMENR_GPIOHSMEN_Msk
#define RCC_AHB2SMENR_SRAM2SMEN_Pos          (9U)
#define RCC_AHB2SMENR_SRAM2SMEN_Msk          (0x1UL << RCC_AHB2SMENR_SRAM2SMEN_Pos)/*!< 0x00000200 */
#define RCC_AHB2SMENR_SRAM2SMEN              RCC_AHB2SMENR_SRAM2SMEN_Msk
#define RCC_AHB2SMENR_ADCSMEN_Pos            (13U)
#define RCC_AHB2SMENR_ADCSMEN_Msk            (0x1UL << RCC_AHB2SMENR_ADCSMEN_Pos)/*!< 0x00002000 */
#define RCC_AHB2SMENR_ADCSMEN                RCC_AHB2SMENR_ADCSMEN_Msk
#define RCC_AHB2SMENR_HASHSMEN_Pos           (17U)
#define RCC_AHB2SMENR_HASHSMEN_Msk           (0x1UL << RCC_AHB2SMENR_HASHSMEN_Pos)/*!< 0x00020000 */
#define RCC_AHB2SMENR_HASHSMEN               RCC_AHB2SMENR_HASHSMEN_Msk
#define RCC_AHB2SMENR_RNGSMEN_Pos            (18U)
#define RCC_AHB2SMENR_RNGSMEN_Msk            (0x1UL << RCC_AHB2SMENR_RNGSMEN_Pos)/*!< 0x00040000 */
#define RCC_AHB2SMENR_RNGSMEN                RCC_AHB2SMENR_RNGSMEN_Msk
#define RCC_AHB2SMENR_SDMMC1SMEN_Pos         (22U)
#define RCC_AHB2SMENR_SDMMC1SMEN_Msk         (0x1UL << RCC_AHB2SMENR_SDMMC1SMEN_Pos)/*!< 0x00400000 */
#define RCC_AHB2SMENR_SDMMC1SMEN             RCC_AHB2SMENR_SDMMC1SMEN_Msk

/********************  Bit definition for RCC_AHB3SMENR register  *************/
#define RCC_AHB3SMENR_FMCSMEN_Pos            (0U)
#define RCC_AHB3SMENR_FMCSMEN_Msk            (0x1UL << RCC_AHB3SMENR_FMCSMEN_Pos)/*!< 0x00000001 */
#define RCC_AHB3SMENR_FMCSMEN                RCC_AHB3SMENR_FMCSMEN_Msk
#define RCC_AHB3SMENR_OSPI1SMEN_Pos          (8U)
#define RCC_AHB3SMENR_OSPI1SMEN_Msk          (0x1UL << RCC_AHB3SMENR_OSPI1SMEN_Pos)/*!< 0x00000100 */
#define RCC_AHB3SMENR_OSPI1SMEN              RCC_AHB3SMENR_OSPI1SMEN_Msk

/********************  Bit definition for RCC_APB1SMENR1 register  *************/
#define RCC_APB1SMENR1_TIM2SMEN_Pos          (0U)
#define RCC_APB1SMENR1_TIM2SMEN_Msk          (0x1UL << RCC_APB1SMENR1_TIM2SMEN_Pos)/*!< 0x00000001 */
#define RCC_APB1SMENR1_TIM2SMEN              RCC_APB1SMENR1_TIM2SMEN_Msk
#define RCC_APB1SMENR1_TIM3SMEN_Pos          (1U)
#define RCC_APB1SMENR1_TIM3SMEN_Msk          (0x1UL << RCC_APB1SMENR1_TIM3SMEN_Pos)/*!< 0x00000002 */
#define RCC_APB1SMENR1_TIM3SMEN              RCC_APB1SMENR1_TIM3SMEN_Msk
#define RCC_APB1SMENR1_TIM4SMEN_Pos          (2U)
#define RCC_APB1SMENR1_TIM4SMEN_Msk          (0x1UL << RCC_APB1SMENR1_TIM4SMEN_Pos)/*!< 0x00000004 */
#define RCC_APB1SMENR1_TIM4SMEN              RCC_APB1SMENR1_TIM4SMEN_Msk
#define RCC_APB1SMENR1_TIM5SMEN_Pos          (3U)
#define RCC_APB1SMENR1_TIM5SMEN_Msk          (0x1UL << RCC_APB1SMENR1_TIM5SMEN_Pos)/*!< 0x00000008 */
#define RCC_APB1SMENR1_TIM5SMEN              RCC_APB1SMENR1_TIM5SMEN_Msk
#define RCC_APB1SMENR1_TIM6SMEN_Pos          (4U)
#define RCC_APB1SMENR1_TIM6SMEN_Msk          (0x1UL << RCC_APB1SMENR1_TIM6SMEN_Pos)/*!< 0x00000010 */
#define RCC_APB1SMENR1_TIM6SMEN              RCC_APB1SMENR1_TIM6SMEN_Msk
#define RCC_APB1SMENR1_TIM7SMEN_Pos          (5U)
#define RCC_APB1SMENR1_TIM7SMEN_Msk          (0x1UL << RCC_APB1SMENR1_TIM7SMEN_Pos)/*!< 0x00000020 */
#define RCC_APB1SMENR1_TIM7SMEN              RCC_APB1SMENR1_TIM7SMEN_Msk
#define RCC_APB1SMENR1_RTCAPBSMEN_Pos        (10U)
#define RCC_APB1SMENR1_RTCAPBSMEN_Msk        (0x1UL << RCC_APB1SMENR1_RTCAPBSMEN_Pos)/*!< 0x00000400 */
#define RCC_APB1SMENR1_RTCAPBSMEN            RCC_APB1SMENR1_RTCAPBSMEN_Msk
#define RCC_APB1SMENR1_WWDGSMEN_Pos          (11U)
#define RCC_APB1SMENR1_WWDGSMEN_Msk          (0x1UL << RCC_APB1SMENR1_WWDGSMEN_Pos)/*!< 0x00000800 */
#define RCC_APB1SMENR1_WWDGSMEN              RCC_APB1SMENR1_WWDGSMEN_Msk
#define RCC_APB1SMENR1_SPI2SMEN_Pos          (14U)
#define RCC_APB1SMENR1_SPI2SMEN_Msk          (0x1UL << RCC_APB1SMENR1_SPI2SMEN_Pos)/*!< 0x00004000 */
#define RCC_APB1SMENR1_SPI2SMEN              RCC_APB1SMENR1_SPI2SMEN_Msk
#define RCC_APB1SMENR1_SPI3SMEN_Pos          (15U)
#define RCC_APB1SMENR1_SPI3SMEN_Msk          (0x1UL << RCC_APB1SMENR1_SPI3SMEN_Pos)/*!< 0x00008000 */
#define RCC_APB1SMENR1_SPI3SMEN              RCC_APB1SMENR1_SPI3SMEN_Msk
#define RCC_APB1SMENR1_USART2SMEN_Pos        (17U)
#define RCC_APB1SMENR1_USART2SMEN_Msk        (0x1UL << RCC_APB1SMENR1_USART2SMEN_Pos)/*!< 0x00020000 */
#define RCC_APB1SMENR1_USART2SMEN            RCC_APB1SMENR1_USART2SMEN_Msk
#define RCC_APB1SMENR1_USART3SMEN_Pos        (18U)
#define RCC_APB1SMENR1_USART3SMEN_Msk        (0x1UL << RCC_APB1SMENR1_USART3SMEN_Pos)/*!< 0x00040000 */
#define RCC_APB1SMENR1_USART3SMEN            RCC_APB1SMENR1_USART3SMEN_Msk
#define RCC_APB1SMENR1_UART4SMEN_Pos         (19U)
#define RCC_APB1SMENR1_UART4SMEN_Msk         (0x1UL << RCC_APB1SMENR1_UART4SMEN_Pos)/*!< 0x00080000 */
#define RCC_APB1SMENR1_UART4SMEN             RCC_APB1SMENR1_UART4SMEN_Msk
#define RCC_APB1SMENR1_UART5SMEN_Pos         (20U)
#define RCC_APB1SMENR1_UART5SMEN_Msk         (0x1UL << RCC_APB1SMENR1_UART5SMEN_Pos)/*!< 0x00100000 */
#define RCC_APB1SMENR1_UART5SMEN             RCC_APB1SMENR1_UART5SMEN_Msk
#define RCC_APB1SMENR1_I2C1SMEN_Pos          (21U)
#define RCC_APB1SMENR1_I2C1SMEN_Msk          (0x1UL << RCC_APB1SMENR1_I2C1SMEN_Pos)/*!< 0x00200000 */
#define RCC_APB1SMENR1_I2C1SMEN              RCC_APB1SMENR1_I2C1SMEN_Msk
#define RCC_APB1SMENR1_I2C2SMEN_Pos          (22U)
#define RCC_APB1SMENR1_I2C2SMEN_Msk          (0x1UL << RCC_APB1SMENR1_I2C2SMEN_Pos)/*!< 0x00400000 */
#define RCC_APB1SMENR1_I2C2SMEN              RCC_APB1SMENR1_I2C2SMEN_Msk
#define RCC_APB1SMENR1_I2C3SMEN_Pos          (23U)
#define RCC_APB1SMENR1_I2C3SMEN_Msk          (0x1UL << RCC_APB1SMENR1_I2C3SMEN_Pos)/*!< 0x00800000 */
#define RCC_APB1SMENR1_I2C3SMEN              RCC_APB1SMENR1_I2C3SMEN_Msk
#define RCC_APB1SMENR1_CRSSMEN_Pos           (24U)
#define RCC_APB1SMENR1_CRSSMEN_Msk           (0x1UL << RCC_APB1SMENR1_CRSSMEN_Pos)/*!< 0x01000000 */
#define RCC_APB1SMENR1_CRSSMEN               RCC_APB1SMENR1_CRSSMEN_Msk
#define RCC_APB1SMENR1_PWRSMEN_Pos           (28U)
#define RCC_APB1SMENR1_PWRSMEN_Msk           (0x1UL << RCC_APB1SMENR1_PWRSMEN_Pos)/*!< 0x10000000 */
#define RCC_APB1SMENR1_PWRSMEN               RCC_APB1SMENR1_PWRSMEN_Msk
#define RCC_APB1SMENR1_DAC1SMEN_Pos          (29U)
#define RCC_APB1SMENR1_DAC1SMEN_Msk          (0x1UL << RCC_APB1SMENR1_DAC1SMEN_Pos)/*!< 0x20000000 */
#define RCC_APB1SMENR1_DAC1SMEN              RCC_APB1SMENR1_DAC1SMEN_Msk
#define RCC_APB1SMENR1_OPAMPSMEN_Pos         (30U)
#define RCC_APB1SMENR1_OPAMPSMEN_Msk         (0x1UL << RCC_APB1SMENR1_OPAMPSMEN_Pos)/*!< 0x40000000 */
#define RCC_APB1SMENR1_OPAMPSMEN             RCC_APB1SMENR1_OPAMPSMEN_Msk
#define RCC_APB1SMENR1_LPTIM1SMEN_Pos        (31U)
#define RCC_APB1SMENR1_LPTIM1SMEN_Msk        (0x1UL << RCC_APB1SMENR1_LPTIM1SMEN_Pos)/*!< 0x80000000 */
#define RCC_APB1SMENR1_LPTIM1SMEN            RCC_APB1SMENR1_LPTIM1SMEN_Msk

/********************  Bit definition for RCC_APB1SMENR2 register  *************/
#define RCC_APB1SMENR2_LPUART1SMEN_Pos       (0U)
#define RCC_APB1SMENR2_LPUART1SMEN_Msk       (0x1UL << RCC_APB1SMENR2_LPUART1SMEN_Pos)/*!< 0x00000001 */
#define RCC_APB1SMENR2_LPUART1SMEN           RCC_APB1SMENR2_LPUART1SMEN_Msk
#define RCC_APB1SMENR2_I2C4SMEN_Pos          (1U)
#define RCC_APB1SMENR2_I2C4SMEN_Msk          (0x1UL << RCC_APB1SMENR2_I2C4SMEN_Pos)/*!< 0x00000002 */
#define RCC_APB1SMENR2_I2C4SMEN              RCC_APB1SMENR2_I2C4SMEN_Msk
#define RCC_APB1SMENR2_LPTIM2SMEN_Pos        (5U)
#define RCC_APB1SMENR2_LPTIM2SMEN_Msk        (0x1UL << RCC_APB1SMENR2_LPTIM2SMEN_Pos)/*!< 0x00000020 */
#define RCC_APB1SMENR2_LPTIM2SMEN            RCC_APB1SMENR2_LPTIM2SMEN_Msk
#define RCC_APB1SMENR2_LPTIM3SMEN_Pos        (6U)
#define RCC_APB1SMENR2_LPTIM3SMEN_Msk        (0x1UL << RCC_APB1SMENR2_LPTIM3SMEN_Pos)/*!< 0x00000040 */
#define RCC_APB1SMENR2_LPTIM3SMEN            RCC_APB1SMENR2_LPTIM3SMEN_Msk
#define RCC_APB1SMENR2_FDCAN1SMEN_Pos        (9U)
#define RCC_APB1SMENR2_FDCAN1SMEN_Msk        (0x1UL << RCC_APB1SMENR2_FDCAN1SMEN_Pos)/*!< 0x00000200 */
#define RCC_APB1SMENR2_FDCAN1SMEN            RCC_APB1SMENR2_FDCAN1SMEN_Msk
#define RCC_APB1SMENR2_USBFSSMEN_Pos         (21U)
#define RCC_APB1SMENR2_USBFSSMEN_Msk         (0x1UL << RCC_APB1SMENR2_USBFSSMEN_Pos)/*!< 0x00200000 */
#define RCC_APB1SMENR2_USBFSSMEN             RCC_APB1SMENR2_USBFSSMEN_Msk
#define RCC_APB1SMENR2_UCPD1SMEN_Pos         (23U)
#define RCC_APB1SMENR2_UCPD1SMEN_Msk         (0x1UL << RCC_APB1SMENR2_UCPD1SMEN_Pos)/*!< 0x00800000 */
#define RCC_APB1SMENR2_UCPD1SMEN             RCC_APB1SMENR2_UCPD1SMEN_Msk

/********************  Bit definition for RCC_APB2SMENR register  *************/
#define RCC_APB2SMENR_SYSCFGSMEN_Pos         (0U)
#define RCC_APB2SMENR_SYSCFGSMEN_Msk         (0x1UL << RCC_APB2SMENR_SYSCFGSMEN_Pos)/*!< 0x00000001 */
#define RCC_APB2SMENR_SYSCFGSMEN             RCC_APB2SMENR_SYSCFGSMEN_Msk
#define RCC_APB2SMENR_TIM1SMEN_Pos           (11U)
#define RCC_APB2SMENR_TIM1SMEN_Msk           (0x1UL << RCC_APB2SMENR_TIM1SMEN_Pos)/*!< 0x00000800 */
#define RCC_APB2SMENR_TIM1SMEN               RCC_APB2SMENR_TIM1SMEN_Msk
#define RCC_APB2SMENR_SPI1SMEN_Pos           (12U)
#define RCC_APB2SMENR_SPI1SMEN_Msk           (0x1UL << RCC_APB2SMENR_SPI1SMEN_Pos)/*!< 0x00001000 */
#define RCC_APB2SMENR_SPI1SMEN               RCC_APB2SMENR_SPI1SMEN_Msk
#define RCC_APB2SMENR_TIM8SMEN_Pos           (13U)
#define RCC_APB2SMENR_TIM8SMEN_Msk           (0x1UL << RCC_APB2SMENR_TIM8SMEN_Pos)/*!< 0x00002000 */
#define RCC_APB2SMENR_TIM8SMEN               RCC_APB2SMENR_TIM8SMEN_Msk
#define RCC_APB2SMENR_USART1SMEN_Pos         (14U)
#define RCC_APB2SMENR_USART1SMEN_Msk         (0x1UL << RCC_APB2SMENR_USART1SMEN_Pos)/*!< 0x00004000 */
#define RCC_APB2SMENR_USART1SMEN             RCC_APB2SMENR_USART1SMEN_Msk
#define RCC_APB2SMENR_TIM15SMEN_Pos          (16U)
#define RCC_APB2SMENR_TIM15SMEN_Msk          (0x1UL << RCC_APB2SMENR_TIM15SMEN_Pos)/*!< 0x00010000 */
#define RCC_APB2SMENR_TIM15SMEN              RCC_APB2SMENR_TIM15SMEN_Msk
#define RCC_APB2SMENR_TIM16SMEN_Pos          (17U)
#define RCC_APB2SMENR_TIM16SMEN_Msk          (0x1UL << RCC_APB2SMENR_TIM16SMEN_Pos)/*!< 0x00020000 */
#define RCC_APB2SMENR_TIM16SMEN              RCC_APB2SMENR_TIM16SMEN_Msk
#define RCC_APB2SMENR_TIM17SMEN_Pos          (18U)
#define RCC_APB2SMENR_TIM17SMEN_Msk          (0x1UL << RCC_APB2SMENR_TIM17SMEN_Pos)/*!< 0x00040000 */
#define RCC_APB2SMENR_TIM17SMEN              RCC_APB2SMENR_TIM17SMEN_Msk
#define RCC_APB2SMENR_SAI1SMEN_Pos           (21U)
#define RCC_APB2SMENR_SAI1SMEN_Msk           (0x1UL << RCC_APB2SMENR_SAI1SMEN_Pos)/*!< 0x00200000 */
#define RCC_APB2SMENR_SAI1SMEN               RCC_APB2SMENR_SAI1SMEN_Msk
#define RCC_APB2SMENR_SAI2SMEN_Pos           (22U)
#define RCC_APB2SMENR_SAI2SMEN_Msk           (0x1UL << RCC_APB2SMENR_SAI2SMEN_Pos)/*!< 0x00400000 */
#define RCC_APB2SMENR_SAI2SMEN               RCC_APB2SMENR_SAI2SMEN_Msk
#define RCC_APB2SMENR_DFSDM1SMEN_Pos         (24U)
#define RCC_APB2SMENR_DFSDM1SMEN_Msk         (0x1UL << RCC_APB2SMENR_DFSDM1SMEN_Pos)/*!< 0x01000000 */
#define RCC_APB2SMENR_DFSDM1SMEN             RCC_APB2SMENR_DFSDM1SMEN_Msk

/********************  Bit definition for RCC_CCIPR1 register  ****************/
#define RCC_CCIPR1_USART1SEL_Pos             (0U)
#define RCC_CCIPR1_USART1SEL_Msk             (0x3UL << RCC_CCIPR1_USART1SEL_Pos)/*!< 0x00000003 */
#define RCC_CCIPR1_USART1SEL                 RCC_CCIPR1_USART1SEL_Msk
#define RCC_CCIPR1_USART1SEL_0               (0x1UL << RCC_CCIPR1_USART1SEL_Pos)/*!< 0x00000001 */
#define RCC_CCIPR1_USART1SEL_1               (0x2UL << RCC_CCIPR1_USART1SEL_Pos)/*!< 0x00000002 */

#define RCC_CCIPR1_USART2SEL_Pos             (2U)
#define RCC_CCIPR1_USART2SEL_Msk             (0x3UL << RCC_CCIPR1_USART2SEL_Pos)/*!< 0x0000000C */
#define RCC_CCIPR1_USART2SEL                 RCC_CCIPR1_USART2SEL_Msk
#define RCC_CCIPR1_USART2SEL_0               (0x1UL << RCC_CCIPR1_USART2SEL_Pos)/*!< 0x00000004 */
#define RCC_CCIPR1_USART2SEL_1               (0x2UL << RCC_CCIPR1_USART2SEL_Pos)/*!< 0x00000008 */

#define RCC_CCIPR1_USART3SEL_Pos             (4U)
#define RCC_CCIPR1_USART3SEL_Msk             (0x3UL << RCC_CCIPR1_USART3SEL_Pos)/*!< 0x00000030 */
#define RCC_CCIPR1_USART3SEL                 RCC_CCIPR1_USART3SEL_Msk
#define RCC_CCIPR1_USART3SEL_0               (0x1UL << RCC_CCIPR1_USART3SEL_Pos)/*!< 0x00000010 */
#define RCC_CCIPR1_USART3SEL_1               (0x2UL << RCC_CCIPR1_USART3SEL_Pos)/*!< 0x00000020 */

#define RCC_CCIPR1_UART4SEL_Pos              (6U)
#define RCC_CCIPR1_UART4SEL_Msk              (0x3UL << RCC_CCIPR1_UART4SEL_Pos) /*!< 0x000000C0 */
#define RCC_CCIPR1_UART4SEL                  RCC_CCIPR1_UART4SEL_Msk
#define RCC_CCIPR1_UART4SEL_0                (0x1UL << RCC_CCIPR1_UART4SEL_Pos) /*!< 0x00000040 */
#define RCC_CCIPR1_UART4SEL_1                (0x2UL << RCC_CCIPR1_UART4SEL_Pos) /*!< 0x00000080 */

#define RCC_CCIPR1_UART5SEL_Pos              (8U)
#define RCC_CCIPR1_UART5SEL_Msk              (0x3UL << RCC_CCIPR1_UART5SEL_Pos) /*!< 0x00000300 */
#define RCC_CCIPR1_UART5SEL                  RCC_CCIPR1_UART5SEL_Msk
#define RCC_CCIPR1_UART5SEL_0                (0x1UL << RCC_CCIPR1_UART5SEL_Pos) /*!< 0x00000100 */
#define RCC_CCIPR1_UART5SEL_1                (0x2UL << RCC_CCIPR1_UART5SEL_Pos) /*!< 0x00000200 */

#define RCC_CCIPR1_LPUART1SEL_Pos            (10U)
#define RCC_CCIPR1_LPUART1SEL_Msk            (0x3UL << RCC_CCIPR1_LPUART1SEL_Pos)/*!< 0x00000C00 */
#define RCC_CCIPR1_LPUART1SEL                RCC_CCIPR1_LPUART1SEL_Msk
#define RCC_CCIPR1_LPUART1SEL_0              (0x1UL << RCC_CCIPR1_LPUART1SEL_Pos)/*!< 0x00000400 */
#define RCC_CCIPR1_LPUART1SEL_1              (0x2UL << RCC_CCIPR1_LPUART1SEL_Pos)/*!< 0x00000800 */

#define RCC_CCIPR1_I2C1SEL_Pos               (12U)
#define RCC_CCIPR1_I2C1SEL_Msk               (0x3UL << RCC_CCIPR1_I2C1SEL_Pos)  /*!< 0x00003000 */
#define RCC_CCIPR1_I2C1SEL                   RCC_CCIPR1_I2C1SEL_Msk
#define RCC_CCIPR1_I2C1SEL_0                 (0x1UL << RCC_CCIPR1_I2C1SEL_Pos)  /*!< 0x00001000 */
#define RCC_CCIPR1_I2C1SEL_1                 (0x2UL << RCC_CCIPR1_I2C1SEL_Pos)  /*!< 0x00002000 */

#define RCC_CCIPR1_I2C2SEL_Pos               (14U)
#define RCC_CCIPR1_I2C2SEL_Msk               (0x3UL << RCC_CCIPR1_I2C2SEL_Pos)  /*!< 0x0000C000 */
#define RCC_CCIPR1_I2C2SEL                   RCC_CCIPR1_I2C2SEL_Msk
#define RCC_CCIPR1_I2C2SEL_0                 (0x1UL << RCC_CCIPR1_I2C2SEL_Pos)  /*!< 0x00004000 */
#define RCC_CCIPR1_I2C2SEL_1                 (0x2UL << RCC_CCIPR1_I2C2SEL_Pos)  /*!< 0x00008000 */

#define RCC_CCIPR1_I2C3SEL_Pos               (16U)
#define RCC_CCIPR1_I2C3SEL_Msk               (0x3UL << RCC_CCIPR1_I2C3SEL_Pos)  /*!< 0x00030000 */
#define RCC_CCIPR1_I2C3SEL                   RCC_CCIPR1_I2C3SEL_Msk
#define RCC_CCIPR1_I2C3SEL_0                 (0x1UL << RCC_CCIPR1_I2C3SEL_Pos)  /*!< 0x00010000 */
#define RCC_CCIPR1_I2C3SEL_1                 (0x2UL << RCC_CCIPR1_I2C3SEL_Pos)  /*!< 0x00020000 */

#define RCC_CCIPR1_LPTIM1SEL_Pos             (18U)
#define RCC_CCIPR1_LPTIM1SEL_Msk             (0x3UL << RCC_CCIPR1_LPTIM1SEL_Pos)/*!< 0x000C0000 */
#define RCC_CCIPR1_LPTIM1SEL                 RCC_CCIPR1_LPTIM1SEL_Msk
#define RCC_CCIPR1_LPTIM1SEL_0               (0x1UL << RCC_CCIPR1_LPTIM1SEL_Pos)/*!< 0x00040000 */
#define RCC_CCIPR1_LPTIM1SEL_1               (0x2UL << RCC_CCIPR1_LPTIM1SEL_Pos)/*!< 0x00080000 */

#define RCC_CCIPR1_LPTIM2SEL_Pos             (20U)
#define RCC_CCIPR1_LPTIM2SEL_Msk             (0x3UL << RCC_CCIPR1_LPTIM2SEL_Pos)/*!< 0x00300000 */
#define RCC_CCIPR1_LPTIM2SEL                 RCC_CCIPR1_LPTIM2SEL_Msk
#define RCC_CCIPR1_LPTIM2SEL_0               (0x1UL << RCC_CCIPR1_LPTIM2SEL_Pos)/*!< 0x00100000 */
#define RCC_CCIPR1_LPTIM2SEL_1               (0x2UL << RCC_CCIPR1_LPTIM2SEL_Pos)/*!< 0x00200000 */

#define RCC_CCIPR1_LPTIM3SEL_Pos             (22U)
#define RCC_CCIPR1_LPTIM3SEL_Msk             (0x3UL << RCC_CCIPR1_LPTIM3SEL_Pos)/*!< 0x00C00000 */
#define RCC_CCIPR1_LPTIM3SEL                 RCC_CCIPR1_LPTIM3SEL_Msk
#define RCC_CCIPR1_LPTIM3SEL_0               (0x1UL << RCC_CCIPR1_LPTIM3SEL_Pos)/*!< 0x00400000 */
#define RCC_CCIPR1_LPTIM3SEL_1               (0x2UL << RCC_CCIPR1_LPTIM3SEL_Pos)/*!< 0x00800000 */

#define RCC_CCIPR1_FDCANSEL_Pos              (24U)
#define RCC_CCIPR1_FDCANSEL_Msk              (0x3UL << RCC_CCIPR1_FDCANSEL_Pos) /*!< 0x03000000 */
#define RCC_CCIPR1_FDCANSEL                  RCC_CCIPR1_FDCANSEL_Msk
#define RCC_CCIPR1_FDCANSEL_0                (0x1UL << RCC_CCIPR1_FDCANSEL_Pos) /*!< 0x01000000 */
#define RCC_CCIPR1_FDCANSEL_1                (0x2UL << RCC_CCIPR1_FDCANSEL_Pos) /*!< 0x02000000 */

#define RCC_CCIPR1_CLK48MSEL_Pos             (26U)
#define RCC_CCIPR1_CLK48MSEL_Msk             (0x3UL << RCC_CCIPR1_CLK48MSEL_Pos) /*!< 0x0C000000 */
#define RCC_CCIPR1_CLK48MSEL                 RCC_CCIPR1_CLK48MSEL_Msk
#define RCC_CCIPR1_CLK48MSEL_0               (0x1UL << RCC_CCIPR1_CLK48MSEL_Pos) /*!< 0x04000000 */
#define RCC_CCIPR1_CLK48MSEL_1               (0x2UL << RCC_CCIPR1_CLK48MSEL_Pos) /*!< 0x08000000 */

#define RCC_CCIPR1_ADCSEL_Pos                (28U)
#define RCC_CCIPR1_ADCSEL_Msk                (0x3UL << RCC_CCIPR1_ADCSEL_Pos)   /*!< 0x30000000 */
#define RCC_CCIPR1_ADCSEL                    RCC_CCIPR1_ADCSEL_Msk
#define RCC_CCIPR1_ADCSEL_0                  (0x1UL << RCC_CCIPR1_ADCSEL_Pos)   /*!< 0x10000000 */
#define RCC_CCIPR1_ADCSEL_1                  (0x2UL << RCC_CCIPR1_ADCSEL_Pos)   /*!< 0x20000000 */

/********************  Bit definition for RCC_BDCR register  ******************/
#define RCC_BDCR_LSEON_Pos                   (0U)
#define RCC_BDCR_LSEON_Msk                   (0x1UL << RCC_BDCR_LSEON_Pos)     /*!< 0x00000001 */
#define RCC_BDCR_LSEON                       RCC_BDCR_LSEON_Msk
#define RCC_BDCR_LSERDY_Pos                  (1U)
#define RCC_BDCR_LSERDY_Msk                  (0x1UL << RCC_BDCR_LSERDY_Pos)    /*!< 0x00000002 */
#define RCC_BDCR_LSERDY                      RCC_BDCR_LSERDY_Msk
#define RCC_BDCR_LSEBYP_Pos                  (2U)
#define RCC_BDCR_LSEBYP_Msk                  (0x1UL << RCC_BDCR_LSEBYP_Pos)    /*!< 0x00000004 */
#define RCC_BDCR_LSEBYP                      RCC_BDCR_LSEBYP_Msk

#define RCC_BDCR_LSEDRV_Pos                  (3U)
#define RCC_BDCR_LSEDRV_Msk                  (0x3UL << RCC_BDCR_LSEDRV_Pos)    /*!< 0x00000018 */
#define RCC_BDCR_LSEDRV                      RCC_BDCR_LSEDRV_Msk
#define RCC_BDCR_LSEDRV_0                    (0x1UL << RCC_BDCR_LSEDRV_Pos)    /*!< 0x00000008 */
#define RCC_BDCR_LSEDRV_1                    (0x2UL << RCC_BDCR_LSEDRV_Pos)    /*!< 0x00000010 */

#define RCC_BDCR_LSECSSON_Pos                (5U)
#define RCC_BDCR_LSECSSON_Msk                (0x1UL << RCC_BDCR_LSECSSON_Pos)  /*!< 0x00000020 */
#define RCC_BDCR_LSECSSON                    RCC_BDCR_LSECSSON_Msk
#define RCC_BDCR_LSECSSD_Pos                 (6U)
#define RCC_BDCR_LSECSSD_Msk                 (0x1UL << RCC_BDCR_LSECSSD_Pos)   /*!< 0x00000040 */
#define RCC_BDCR_LSECSSD                     RCC_BDCR_LSECSSD_Msk
#define RCC_BDCR_LSESYSEN_Pos                (7U)
#define RCC_BDCR_LSESYSEN_Msk                (0x1UL << RCC_BDCR_LSESYSEN_Pos)   /*!< 0x00000080 */
#define RCC_BDCR_LSESYSEN                    RCC_BDCR_LSESYSEN_Msk

#define RCC_BDCR_RTCSEL_Pos                  (8U)
#define RCC_BDCR_RTCSEL_Msk                  (0x3UL << RCC_BDCR_RTCSEL_Pos)    /*!< 0x00000300 */
#define RCC_BDCR_RTCSEL                      RCC_BDCR_RTCSEL_Msk
#define RCC_BDCR_RTCSEL_0                    (0x1UL << RCC_BDCR_RTCSEL_Pos)    /*!< 0x00000100 */
#define RCC_BDCR_RTCSEL_1                    (0x2UL << RCC_BDCR_RTCSEL_Pos)    /*!< 0x00000200 */

#define RCC_BDCR_LSESYSRDY_Pos               (11U)
#define RCC_BDCR_LSESYSRDY_Msk               (0x1UL << RCC_BDCR_LSESYSRDY_Pos) /*!< 0x00000800 */
#define RCC_BDCR_LSESYSRDY                   RCC_BDCR_LSESYSRDY_Msk
#define RCC_BDCR_RTCEN_Pos                   (15U)
#define RCC_BDCR_RTCEN_Msk                   (0x1UL << RCC_BDCR_RTCEN_Pos)     /*!< 0x00008000 */
#define RCC_BDCR_RTCEN                       RCC_BDCR_RTCEN_Msk
#define RCC_BDCR_BDRST_Pos                   (16U)
#define RCC_BDCR_BDRST_Msk                   (0x1UL << RCC_BDCR_BDRST_Pos)     /*!< 0x00010000 */
#define RCC_BDCR_BDRST                       RCC_BDCR_BDRST_Msk
#define RCC_BDCR_LSCOEN_Pos                  (24U)
#define RCC_BDCR_LSCOEN_Msk                  (0x1UL << RCC_BDCR_LSCOEN_Pos)    /*!< 0x01000000 */
#define RCC_BDCR_LSCOEN                      RCC_BDCR_LSCOEN_Msk
#define RCC_BDCR_LSCOSEL_Pos                 (25U)
#define RCC_BDCR_LSCOSEL_Msk                 (0x1UL << RCC_BDCR_LSCOSEL_Pos)   /*!< 0x02000000 */
#define RCC_BDCR_LSCOSEL                     RCC_BDCR_LSCOSEL_Msk

/********************  Bit definition for RCC_CSR register  *******************/
#define RCC_CSR_LSION_Pos                    (0U)
#define RCC_CSR_LSION_Msk                    (0x1UL << RCC_CSR_LSION_Pos)      /*!< 0x00000001 */
#define RCC_CSR_LSION                        RCC_CSR_LSION_Msk
#define RCC_CSR_LSIRDY_Pos                   (1U)
#define RCC_CSR_LSIRDY_Msk                   (0x1UL << RCC_CSR_LSIRDY_Pos)     /*!< 0x00000002 */
#define RCC_CSR_LSIRDY                       RCC_CSR_LSIRDY_Msk
#define RCC_CSR_LSIPRE_Pos                   (4U)
#define RCC_CSR_LSIPRE_Msk                   (0x1UL << RCC_CSR_LSIPRE_Pos)     /*!< 0x00000010 */
#define RCC_CSR_LSIPRE                       RCC_CSR_LSIPRE_Msk

#define RCC_CSR_MSISRANGE_Pos                (8U)
#define RCC_CSR_MSISRANGE_Msk                (0xFUL << RCC_CSR_MSISRANGE_Pos)  /*!< 0x00000F00 */
#define RCC_CSR_MSISRANGE                    RCC_CSR_MSISRANGE_Msk
#define RCC_CSR_MSISRANGE_0                  (0x1UL << RCC_CSR_MSISRANGE_Pos)  /*!< 0x00000100 */
#define RCC_CSR_MSISRANGE_1                  (0x2UL << RCC_CSR_MSISRANGE_Pos)  /*!< 0x00000200 */
#define RCC_CSR_MSISRANGE_2                  (0x4UL << RCC_CSR_MSISRANGE_Pos)  /*!< 0x00000400 */
#define RCC_CSR_MSISRANGE_3                  (0x8UL << RCC_CSR_MSISRANGE_Pos)  /*!< 0x00000800 */

#define RCC_CSR_RMVF_Pos                     (23U)
#define RCC_CSR_RMVF_Msk                     (0x1UL << RCC_CSR_RMVF_Pos)       /*!< 0x00800000 */
#define RCC_CSR_RMVF                         RCC_CSR_RMVF_Msk
#define RCC_CSR_OBLRSTF_Pos                  (25U)
#define RCC_CSR_OBLRSTF_Msk                  (0x1UL << RCC_CSR_OBLRSTF_Pos)    /*!< 0x02000000 */
#define RCC_CSR_OBLRSTF                      RCC_CSR_OBLRSTF_Msk
#define RCC_CSR_PINRSTF_Pos                  (26U)
#define RCC_CSR_PINRSTF_Msk                  (0x1UL << RCC_CSR_PINRSTF_Pos)    /*!< 0x04000000 */
#define RCC_CSR_PINRSTF                      RCC_CSR_PINRSTF_Msk
#define RCC_CSR_BORRSTF_Pos                  (27U)
#define RCC_CSR_BORRSTF_Msk                  (0x1UL << RCC_CSR_BORRSTF_Pos)    /*!< 0x08000000 */
#define RCC_CSR_BORRSTF                      RCC_CSR_BORRSTF_Msk
#define RCC_CSR_SFTRSTF_Pos                  (28U)
#define RCC_CSR_SFTRSTF_Msk                  (0x1UL << RCC_CSR_SFTRSTF_Pos)    /*!< 0x10000000 */
#define RCC_CSR_SFTRSTF                      RCC_CSR_SFTRSTF_Msk
#define RCC_CSR_IWDGRSTF_Pos                 (29U)
#define RCC_CSR_IWDGRSTF_Msk                 (0x1UL << RCC_CSR_IWDGRSTF_Pos)   /*!< 0x20000000 */
#define RCC_CSR_IWDGRSTF                     RCC_CSR_IWDGRSTF_Msk
#define RCC_CSR_WWDGRSTF_Pos                 (30U)
#define RCC_CSR_WWDGRSTF_Msk                 (0x1UL << RCC_CSR_WWDGRSTF_Pos)   /*!< 0x40000000 */
#define RCC_CSR_WWDGRSTF                     RCC_CSR_WWDGRSTF_Msk
#define RCC_CSR_LPWRRSTF_Pos                 (31U)
#define RCC_CSR_LPWRRSTF_Msk                 (0x1UL << RCC_CSR_LPWRRSTF_Pos)   /*!< 0x80000000 */
#define RCC_CSR_LPWRRSTF                     RCC_CSR_LPWRRSTF_Msk

/********************  Bit definition for RCC_CRRCR register  *****************/
#define RCC_CRRCR_HSI48ON_Pos                (0U)
#define RCC_CRRCR_HSI48ON_Msk                (0x1UL << RCC_CRRCR_HSI48ON_Pos)  /*!< 0x00000001 */
#define RCC_CRRCR_HSI48ON                    RCC_CRRCR_HSI48ON_Msk
#define RCC_CRRCR_HSI48RDY_Pos               (1U)
#define RCC_CRRCR_HSI48RDY_Msk               (0x1UL << RCC_CRRCR_HSI48RDY_Pos) /*!< 0x00000002 */
#define RCC_CRRCR_HSI48RDY                   RCC_CRRCR_HSI48RDY_Msk

/*!< HSI48CAL configuration */
#define RCC_CRRCR_HSI48CAL_Pos               (7U)
#define RCC_CRRCR_HSI48CAL_Msk               (0x1FFUL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x0000FF80 */
#define RCC_CRRCR_HSI48CAL                   RCC_CRRCR_HSI48CAL_Msk             /*!< HSI48CAL[8:0] bits */
#define RCC_CRRCR_HSI48CAL_0                 (0x001UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00000080 */
#define RCC_CRRCR_HSI48CAL_1                 (0x002UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00000100 */
#define RCC_CRRCR_HSI48CAL_2                 (0x004UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00000200 */
#define RCC_CRRCR_HSI48CAL_3                 (0x008UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00000400 */
#define RCC_CRRCR_HSI48CAL_4                 (0x010UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00000800 */
#define RCC_CRRCR_HSI48CAL_5                 (0x020UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00001000 */
#define RCC_CRRCR_HSI48CAL_6                 (0x040UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00002000 */
#define RCC_CRRCR_HSI48CAL_7                 (0x080UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00004000 */
#define RCC_CRRCR_HSI48CAL_8                 (0x100UL << RCC_CRRCR_HSI48CAL_Pos)/*!< 0x00008000 */

/********************  Bit definition for RCC_CCIPR2 register  ******************/
#define RCC_CCIPR2_I2C4SEL_Pos               (0U)
#define RCC_CCIPR2_I2C4SEL_Msk               (0x3UL << RCC_CCIPR2_I2C4SEL_Pos) /*!< 0x00000003 */
#define RCC_CCIPR2_I2C4SEL                   RCC_CCIPR2_I2C4SEL_Msk
#define RCC_CCIPR2_I2C4SEL_0                 (0x1UL << RCC_CCIPR2_I2C4SEL_Pos) /*!< 0x00000001 */
#define RCC_CCIPR2_I2C4SEL_1                 (0x2UL << RCC_CCIPR2_I2C4SEL_Pos) /*!< 0x00000002 */

#define RCC_CCIPR2_DFSDMSEL_Pos              (2U)
#define RCC_CCIPR2_DFSDMSEL_Msk              (0x1UL << RCC_CCIPR2_DFSDMSEL_Pos)/*!< 0x00000004 */
#define RCC_CCIPR2_DFSDMSEL                  RCC_CCIPR2_DFSDMSEL_Msk

#define RCC_CCIPR2_ADFSDMSEL_Pos             (3U)
#define RCC_CCIPR2_ADFSDMSEL_Msk             (0x3UL << RCC_CCIPR2_ADFSDMSEL_Pos)/*!< 0x00000018 */
#define RCC_CCIPR2_ADFSDMSEL                 RCC_CCIPR2_ADFSDMSEL_Msk
#define RCC_CCIPR2_ADFSDMSEL_0               (0x1UL << RCC_CCIPR2_ADFSDMSEL_Pos)/*!< 0x00000008 */
#define RCC_CCIPR2_ADFSDMSEL_1               (0x2UL << RCC_CCIPR2_ADFSDMSEL_Pos)/*!< 0x00000010 */

#define RCC_CCIPR2_SAI1SEL_Pos               (5U)
#define RCC_CCIPR2_SAI1SEL_Msk               (0x7UL << RCC_CCIPR2_SAI1SEL_Pos) /*!< 0x000000E0 */
#define RCC_CCIPR2_SAI1SEL                   RCC_CCIPR2_SAI1SEL_Msk
#define RCC_CCIPR2_SAI1SEL_0                 (0x1UL << RCC_CCIPR2_SAI1SEL_Pos) /*!< 0x00000020 */
#define RCC_CCIPR2_SAI1SEL_1                 (0x2UL << RCC_CCIPR2_SAI1SEL_Pos) /*!< 0x00000040 */
#define RCC_CCIPR2_SAI1SEL_2                 (0x4UL << RCC_CCIPR2_SAI1SEL_Pos) /*!< 0x00000080 */

#define RCC_CCIPR2_SAI2SEL_Pos               (8U)
#define RCC_CCIPR2_SAI2SEL_Msk               (0x7UL << RCC_CCIPR2_SAI2SEL_Pos) /*!< 0x00000700 */
#define RCC_CCIPR2_SAI2SEL                   RCC_CCIPR2_SAI2SEL_Msk
#define RCC_CCIPR2_SAI2SEL_0                 (0x1UL << RCC_CCIPR2_SAI2SEL_Pos) /*!< 0x00000100 */
#define RCC_CCIPR2_SAI2SEL_1                 (0x2UL << RCC_CCIPR2_SAI2SEL_Pos) /*!< 0x00000200 */
#define RCC_CCIPR2_SAI2SEL_2                 (0x4UL << RCC_CCIPR2_SAI2SEL_Pos) /*!< 0x00000400 */

#define RCC_CCIPR2_SDMMCSEL_Pos              (14U)
#define RCC_CCIPR2_SDMMCSEL_Msk              (0x1UL << RCC_CCIPR2_SDMMCSEL_Pos)/*!< 0x00004000 */
#define RCC_CCIPR2_SDMMCSEL                  RCC_CCIPR2_SDMMCSEL_Msk

#define RCC_CCIPR2_OSPISEL_Pos               (20U)
#define RCC_CCIPR2_OSPISEL_Msk               (0x3UL << RCC_CCIPR2_OSPISEL_Pos)/*!< 0x00300000 */
#define RCC_CCIPR2_OSPISEL                   RCC_CCIPR2_OSPISEL_Msk
#define RCC_CCIPR2_OSPISEL_0                 (0x1UL << RCC_CCIPR2_OSPISEL_Pos)/*!< 0x00100000 */
#define RCC_CCIPR2_OSPISEL_1                 (0x2UL << RCC_CCIPR2_OSPISEL_Pos)/*!< 0x00200000 */

/********************  Bit definition for RCC_SECCFGR register  ***************/
#define RCC_SECCFGR_HSISEC_Pos               (0U)
#define RCC_SECCFGR_HSISEC_Msk               (0x1UL << RCC_SECCFGR_HSISEC_Pos)  /*!< 0x00000001 */
#define RCC_SECCFGR_HSISEC                   RCC_SECCFGR_HSISEC_Msk
#define RCC_SECCFGR_HSESEC_Pos               (1U)
#define RCC_SECCFGR_HSESEC_Msk               (0x1UL << RCC_SECCFGR_HSESEC_Pos)  /*!< 0x00000002 */
#define RCC_SECCFGR_HSESEC                   RCC_SECCFGR_HSESEC_Msk
#define RCC_SECCFGR_MSISEC_Pos               (2U)
#define RCC_SECCFGR_MSISEC_Msk               (0x1UL << RCC_SECCFGR_MSISEC_Pos)  /*!< 0x00000004 */
#define RCC_SECCFGR_MSISEC                   RCC_SECCFGR_MSISEC_Msk
#define RCC_SECCFGR_LSISEC_Pos               (3U)
#define RCC_SECCFGR_LSISEC_Msk               (0x1UL << RCC_SECCFGR_LSISEC_Pos)  /*!< 0x00000008 */
#define RCC_SECCFGR_LSISEC                   RCC_SECCFGR_LSISEC_Msk
#define RCC_SECCFGR_LSESEC_Pos               (4U)
#define RCC_SECCFGR_LSESEC_Msk               (0x1UL << RCC_SECCFGR_LSESEC_Pos)  /*!< 0x00000010 */
#define RCC_SECCFGR_LSESEC                   RCC_SECCFGR_LSESEC_Msk
#define RCC_SECCFGR_SYSCLKSEC_Pos            (5U)
#define RCC_SECCFGR_SYSCLKSEC_Msk            (0x1UL << RCC_SECCFGR_SYSCLKSEC_Pos)/*!< 0x00000020 */
#define RCC_SECCFGR_SYSCLKSEC                RCC_SECCFGR_SYSCLKSEC_Msk
#define RCC_SECCFGR_PRESCSEC_Pos             (6U)
#define RCC_SECCFGR_PRESCSEC_Msk             (0x1UL << RCC_SECCFGR_PRESCSEC_Pos)/*!< 0x00000040 */
#define RCC_SECCFGR_PRESCSEC                 RCC_SECCFGR_PRESCSEC_Msk
#define RCC_SECCFGR_PLLSEC_Pos               (7U)
#define RCC_SECCFGR_PLLSEC_Msk               (0x1UL << RCC_SECCFGR_PLLSEC_Pos)/*!< 0x00000080 */
#define RCC_SECCFGR_PLLSEC                   RCC_SECCFGR_PLLSEC_Msk
#define RCC_SECCFGR_PLLSAI1SEC_Pos           (8U)
#define RCC_SECCFGR_PLLSAI1SEC_Msk           (0x1UL << RCC_SECCFGR_PLLSAI1SEC_Pos)/*!< 0x00000100 */
#define RCC_SECCFGR_PLLSAI1SEC               RCC_SECCFGR_PLLSAI1SEC_Msk
#define RCC_SECCFGR_PLLSAI2SEC_Pos           (9U)
#define RCC_SECCFGR_PLLSAI2SEC_Msk           (0x1UL << RCC_SECCFGR_PLLSAI2SEC_Pos)/*!< 0x00000200 */
#define RCC_SECCFGR_PLLSAI2SEC               RCC_SECCFGR_PLLSAI2SEC_Msk
#define RCC_SECCFGR_CLK48MSEC_Pos            (10U)
#define RCC_SECCFGR_CLK48MSEC_Msk            (0x1UL << RCC_SECCFGR_CLK48MSEC_Pos) /*!< 0x00000400 */
#define RCC_SECCFGR_CLK48MSEC                RCC_SECCFGR_CLK48MSEC_Msk
#define RCC_SECCFGR_HSI48SEC_Pos             (11U)
#define RCC_SECCFGR_HSI48SEC_Msk             (0x1UL << RCC_SECCFGR_HSI48SEC_Pos)  /*!< 0x00000800 */
#define RCC_SECCFGR_HSI48SEC                 RCC_SECCFGR_HSI48SEC_Msk
#define RCC_SECCFGR_RMVFSEC_Pos              (12U)
#define RCC_SECCFGR_RMVFSEC_Msk              (0x1UL << RCC_SECCFGR_RMVFSEC_Pos)/*!< 0x00001000 */
#define RCC_SECCFGR_RMVFSEC                  RCC_SECCFGR_RMVFSEC_Msk

/********************  Bit definition for RCC_SECSR register  *****************/
#define RCC_SECSR_HSISECF_Pos                (0U)
#define RCC_SECSR_HSISECF_Msk                (0x1UL << RCC_SECSR_HSISECF_Pos)  /*!< 0x00000001 */
#define RCC_SECSR_HSISECF                    RCC_SECSR_HSISECF_Msk
#define RCC_SECSR_HSESECF_Pos                (1U)
#define RCC_SECSR_HSESECF_Msk                (0x1UL << RCC_SECSR_HSESECF_Pos)  /*!< 0x00000002 */
#define RCC_SECSR_HSESECF                    RCC_SECSR_HSESECF_Msk
#define RCC_SECSR_MSISECF_Pos                (2U)
#define RCC_SECSR_MSISECF_Msk                (0x1UL << RCC_SECSR_MSISECF_Pos)  /*!< 0x00000004 */
#define RCC_SECSR_MSISECF                    RCC_SECSR_MSISECF_Msk
#define RCC_SECSR_LSISECF_Pos                (3U)
#define RCC_SECSR_LSISECF_Msk                (0x1UL << RCC_SECSR_LSISECF_Pos)  /*!< 0x00000008 */
#define RCC_SECSR_LSISECF                    RCC_SECSR_LSISECF_Msk
#define RCC_SECSR_LSESECF_Pos                (4U)
#define RCC_SECSR_LSESECF_Msk                (0x1UL << RCC_SECSR_LSESECF_Pos)  /*!< 0x00000010 */
#define RCC_SECSR_LSESECF                    RCC_SECSR_LSESECF_Msk
#define RCC_SECSR_SYSCLKSECF_Pos             (5U)
#define RCC_SECSR_SYSCLKSECF_Msk             (0x1UL << RCC_SECSR_SYSCLKSECF_Pos)/*!< 0x00000020 */
#define RCC_SECSR_SYSCLKSECF                 RCC_SECSR_SYSCLKSECF_Msk
#define RCC_SECSR_PRESCSECF_Pos              (6U)
#define RCC_SECSR_PRESCSECF_Msk              (0x1UL << RCC_SECSR_PRESCSECF_Pos)/*!< 0x00000040 */
#define RCC_SECSR_PRESCSECF                  RCC_SECSR_PRESCSECF_Msk
#define RCC_SECSR_PLLSECF_Pos                (7U)
#define RCC_SECSR_PLLSECF_Msk                (0x1UL << RCC_SECSR_PLLSECF_Pos)  /*!< 0x00000080 */
#define RCC_SECSR_PLLSECF                    RCC_SECSR_PLLSECF_Msk
#define RCC_SECSR_PLLSAI1SECF_Pos            (8U)
#define RCC_SECSR_PLLSAI1SECF_Msk            (0x1UL << RCC_SECSR_PLLSAI1SECF_Pos)/*!< 0x00000100 */
#define RCC_SECSR_PLLSAI1SECF                RCC_SECSR_PLLSAI1SECF_Msk
#define RCC_SECSR_PLLSAI2SECF_Pos            (9U)
#define RCC_SECSR_PLLSAI2SECF_Msk            (0x1UL << RCC_SECSR_PLLSAI2SECF_Pos)/*!< 0x00000200 */
#define RCC_SECSR_PLLSAI2SECF                RCC_SECSR_PLLSAI2SECF_Msk
#define RCC_SECSR_CLK48MSECF_Pos             (10U)
#define RCC_SECSR_CLK48MSECF_Msk             (0x1UL << RCC_SECSR_CLK48MSECF_Pos) /*!< 0x00000400 */
#define RCC_SECSR_CLK48MSECF                 RCC_SECSR_CLK48MSECF_Msk
#define RCC_SECSR_HSI48SECF_Pos              (11U)
#define RCC_SECSR_HSI48SECF_Msk              (0x1UL << RCC_SECSR_HSI48SECF_Pos)  /*!< 0x00000800 */
#define RCC_SECSR_HSI48SECF                  RCC_SECSR_HSI48SECF_Msk
#define RCC_SECSR_RMVFSECF_Pos               (12U)
#define RCC_SECSR_RMVFSECF_Msk               (0x1UL << RCC_SECSR_RMVFSECF_Pos)/*!< 0x00001000 */
#define RCC_SECSR_RMVFSECF                   RCC_SECSR_RMVFSECF_Msk

/********************  Bit definition for RCC_AHB1SECSR register  *************/
#define RCC_AHB1SECSR_DMA1SECF_Pos           (0U)
#define RCC_AHB1SECSR_DMA1SECF_Msk           (0x1UL << RCC_AHB1SECSR_DMA1SECF_Pos)/*!< 0x00000001 */
#define RCC_AHB1SECSR_DMA1SECF               RCC_AHB1SECSR_DMA1SECF_Msk
#define RCC_AHB1SECSR_DMA2SECF_Pos           (1U)
#define RCC_AHB1SECSR_DMA2SECF_Msk           (0x1UL << RCC_AHB1SECSR_DMA2SECF_Pos)/*!< 0x00000002 */
#define RCC_AHB1SECSR_DMA2SECF               RCC_AHB1SECSR_DMA2SECF_Msk
#define RCC_AHB1SECSR_DMAMUX1SECF_Pos        (2U)
#define RCC_AHB1SECSR_DMAMUX1SECF_Msk        (0x1UL << RCC_AHB1SECSR_DMAMUX1SECF_Pos)/*!< 0x00000004 */
#define RCC_AHB1SECSR_DMAMUX1SECF            RCC_AHB1SECSR_DMAMUX1SECF_Msk
#define RCC_AHB1SECSR_FLASHSECF_Pos          (8U)
#define RCC_AHB1SECSR_FLASHSECF_Msk          (0x1UL << RCC_AHB1SECSR_FLASHSECF_Pos)/*!< 0x00000100 */
#define RCC_AHB1SECSR_FLASHSECF              RCC_AHB1SECSR_FLASHSECF_Msk
#define RCC_AHB1SECSR_SRAM1SECF_Pos          (9U)
#define RCC_AHB1SECSR_SRAM1SECF_Msk          (0x1UL << RCC_AHB1SECSR_SRAM1SECF_Pos)/*!< 0x00000200 */
#define RCC_AHB1SECSR_SRAM1SECF              RCC_AHB1SECSR_SRAM1SECF_Msk
#define RCC_AHB1SECSR_CRCSECF_Pos            (12U)
#define RCC_AHB1SECSR_CRCSECF_Msk            (0x1UL << RCC_AHB1SECSR_CRCSECF_Pos)/*!< 0x00001000 */
#define RCC_AHB1SECSR_CRCSECF                RCC_AHB1SECSR_CRCSECF_Msk
#define RCC_AHB1SECSR_TSCSECF_Pos            (16U)
#define RCC_AHB1SECSR_TSCSECF_Msk            (0x1UL << RCC_AHB1SECSR_TSCSECF_Pos)/*!< 0x00010000 */
#define RCC_AHB1SECSR_TSCSECF                RCC_AHB1SECSR_TSCSECF_Msk
#define RCC_AHB1SECSR_GTZCSECF_Pos           (22U)
#define RCC_AHB1SECSR_GTZCSECF_Msk           (0x1UL << RCC_AHB1SECSR_GTZCSECF_Pos)/*!< 0x00400000 */
#define RCC_AHB1SECSR_GTZCSECF               RCC_AHB1SECSR_GTZCSECF_Msk
#define RCC_AHB1SECSR_ICACHESECF_Pos         (23U)
#define RCC_AHB1SECSR_ICACHESECF_Msk         (0x1UL << RCC_AHB1SECSR_ICACHESECF_Pos)/*!< 0x00600000 */
#define RCC_AHB1SECSR_ICACHESECF             RCC_AHB1SECSR_ICACHESECF_Msk

/********************  Bit definition for RCC_AHB2SECSR register  *************/
#define RCC_AHB2SECSR_GPIOASECF_Pos          (0U)
#define RCC_AHB2SECSR_GPIOASECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIOASECF_Pos)/*!< 0x00000001 */
#define RCC_AHB2SECSR_GPIOASECF              RCC_AHB2SECSR_GPIOASECF_Msk
#define RCC_AHB2SECSR_GPIOBSECF_Pos          (1U)
#define RCC_AHB2SECSR_GPIOBSECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIOBSECF_Pos)/*!< 0x00000002 */
#define RCC_AHB2SECSR_GPIOBSECF              RCC_AHB2SECSR_GPIOBSECF_Msk
#define RCC_AHB2SECSR_GPIOCSECF_Pos          (2U)
#define RCC_AHB2SECSR_GPIOCSECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIOCSECF_Pos)/*!< 0x00000004 */
#define RCC_AHB2SECSR_GPIOCSECF              RCC_AHB2SECSR_GPIOCSECF_Msk
#define RCC_AHB2SECSR_GPIODSECF_Pos          (3U)
#define RCC_AHB2SECSR_GPIODSECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIODSECF_Pos)/*!< 0x00000008 */
#define RCC_AHB2SECSR_GPIODSECF              RCC_AHB2SECSR_GPIODSECF_Msk
#define RCC_AHB2SECSR_GPIOESECF_Pos          (4U)
#define RCC_AHB2SECSR_GPIOESECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIOESECF_Pos)/*!< 0x00000010 */
#define RCC_AHB2SECSR_GPIOESECF              RCC_AHB2SECSR_GPIOESECF_Msk
#define RCC_AHB2SECSR_GPIOFSECF_Pos          (5U)
#define RCC_AHB2SECSR_GPIOFSECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIOFSECF_Pos)/*!< 0x00000020 */
#define RCC_AHB2SECSR_GPIOFSECF              RCC_AHB2SECSR_GPIOFSECF_Msk
#define RCC_AHB2SECSR_GPIOGSECF_Pos          (6U)
#define RCC_AHB2SECSR_GPIOGSECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIOGSECF_Pos)/*!< 0x00000040 */
#define RCC_AHB2SECSR_GPIOGSECF              RCC_AHB2SECSR_GPIOGSECF_Msk
#define RCC_AHB2SECSR_GPIOHSECF_Pos          (7U)
#define RCC_AHB2SECSR_GPIOHSECF_Msk          (0x1UL << RCC_AHB2SECSR_GPIOHSECF_Pos)/*!< 0x00000080 */
#define RCC_AHB2SECSR_GPIOHSECF              RCC_AHB2SECSR_GPIOHSECF_Msk
#define RCC_AHB2SECSR_SRAM2SECF_Pos          (9U)
#define RCC_AHB2SECSR_SRAM2SECF_Msk          (0x1UL << RCC_AHB2SECSR_SRAM2SECF_Pos)/*!< 0x00000200 */
#define RCC_AHB2SECSR_SRAM2SECF              RCC_AHB2SECSR_SRAM2SECF_Msk
#define RCC_AHB2SECSR_ADCSECF_Pos            (13U)
#define RCC_AHB2SECSR_ADCSECF_Msk            (0x1UL << RCC_AHB2SECSR_ADCSECF_Pos)/*!< 0x00002000 */
#define RCC_AHB2SECSR_ADCSECF                RCC_AHB2SECSR_ADCSECF_Msk
#define RCC_AHB2SECSR_HASHSECF_Pos           (17U)
#define RCC_AHB2SECSR_HASHSECF_Msk           (0x1UL << RCC_AHB2SECSR_HASHSECF_Pos)/*!< 0x00020000 */
#define RCC_AHB2SECSR_HASHSECF               RCC_AHB2SECSR_HASHSECF_Msk
#define RCC_AHB2SECSR_RNGSECF_Pos            (18U)
#define RCC_AHB2SECSR_RNGSECF_Msk            (0x1UL << RCC_AHB2SECSR_RNGSECF_Pos)/*!< 0x00040000 */
#define RCC_AHB2SECSR_RNGSECF                RCC_AHB2SECSR_RNGSECF_Msk
#define RCC_AHB2SECSR_SDMMC1SECF_Pos         (22U)
#define RCC_AHB2SECSR_SDMMC1SECF_Msk         (0x1UL << RCC_AHB2SECSR_SDMMC1SECF_Pos)/*!< 0x00400000 */
#define RCC_AHB2SECSR_SDMMC1SECF             RCC_AHB2SECSR_SDMMC1SECF_Msk

/********************  Bit definition for RCC_AHB3SECSR register  *************/
#define RCC_AHB3SECSR_FMCSECF_Pos            (0U)
#define RCC_AHB3SECSR_FMCSECF_Msk            (0x1UL << RCC_AHB3SECSR_FMCSECF_Pos)/*!< 0x00000001 */
#define RCC_AHB3SECSR_FMCSECF                RCC_AHB3SECSR_FMCSECF_Msk
#define RCC_AHB3SECSR_OSPI1SECF_Pos          (8U)
#define RCC_AHB3SECSR_OSPI1SECF_Msk          (0x1UL << RCC_AHB3SECSR_OSPI1SECF_Pos)/*!< 0x00000100 */
#define RCC_AHB3SECSR_OSPI1SECF              RCC_AHB3SECSR_OSPI1SECF_Msk

/********************  Bit definition for RCC_APB1SECSR1 register  ************/
#define RCC_APB1SECSR1_TIM2SECF_Pos          (0U)
#define RCC_APB1SECSR1_TIM2SECF_Msk          (0x1UL << RCC_APB1SECSR1_TIM2SECF_Pos)/*!< 0x00000001 */
#define RCC_APB1SECSR1_TIM2SECF              RCC_APB1SECSR1_TIM2SECF_Msk
#define RCC_APB1SECSR1_TIM3SECF_Pos          (1U)
#define RCC_APB1SECSR1_TIM3SECF_Msk          (0x1UL << RCC_APB1SECSR1_TIM3SECF_Pos)/*!< 0x00000002 */
#define RCC_APB1SECSR1_TIM3SECF              RCC_APB1SECSR1_TIM3SECF_Msk
#define RCC_APB1SECSR1_TIM4SECF_Pos          (2U)
#define RCC_APB1SECSR1_TIM4SECF_Msk          (0x1UL << RCC_APB1SECSR1_TIM4SECF_Pos)/*!< 0x00000004 */
#define RCC_APB1SECSR1_TIM4SECF              RCC_APB1SECSR1_TIM4SECF_Msk
#define RCC_APB1SECSR1_TIM5SECF_Pos          (3U)
#define RCC_APB1SECSR1_TIM5SECF_Msk          (0x1UL << RCC_APB1SECSR1_TIM5SECF_Pos)/*!< 0x00000008 */
#define RCC_APB1SECSR1_TIM5SECF              RCC_APB1SECSR1_TIM5SECF_Msk
#define RCC_APB1SECSR1_TIM6SECF_Pos          (4U)
#define RCC_APB1SECSR1_TIM6SECF_Msk          (0x1UL << RCC_APB1SECSR1_TIM6SECF_Pos)/*!< 0x00000010 */
#define RCC_APB1SECSR1_TIM6SECF              RCC_APB1SECSR1_TIM6SECF_Msk
#define RCC_APB1SECSR1_TIM7SECF_Pos          (5U)
#define RCC_APB1SECSR1_TIM7SECF_Msk          (0x1UL << RCC_APB1SECSR1_TIM7SECF_Pos)/*!< 0x00000020 */
#define RCC_APB1SECSR1_TIM7SECF              RCC_APB1SECSR1_TIM7SECF_Msk
#define RCC_APB1SECSR1_RTCAPBSECF_Pos        (10U)
#define RCC_APB1SECSR1_RTCAPBSECF_Msk        (0x1UL << RCC_APB1SECSR1_RTCAPBSECF_Pos)/*!< 0x00000400 */
#define RCC_APB1SECSR1_RTCAPBSECF            RCC_APB1SECSR1_RTCAPBSECF_Msk
#define RCC_APB1SECSR1_WWDGSECF_Pos          (11U)
#define RCC_APB1SECSR1_WWDGSECF_Msk          (0x1UL << RCC_APB1SECSR1_WWDGSECF_Pos)/*!< 0x00000800 */
#define RCC_APB1SECSR1_WWDGSECF              RCC_APB1SECSR1_WWDGSECF_Msk
#define RCC_APB1SECSR1_SPI2SECF_Pos          (14U)
#define RCC_APB1SECSR1_SPI2SECF_Msk          (0x1UL << RCC_APB1SECSR1_SPI2SECF_Pos)/*!< 0x00004000 */
#define RCC_APB1SECSR1_SPI2SECF              RCC_APB1SECSR1_SPI2SECF_Msk
#define RCC_APB1SECSR1_SPI3SECF_Pos          (15U)
#define RCC_APB1SECSR1_SPI3SECF_Msk          (0x1UL << RCC_APB1SECSR1_SPI3SECF_Pos)/*!< 0x00008000 */
#define RCC_APB1SECSR1_SPI3SECF              RCC_APB1SECSR1_SPI3SECF_Msk
#define RCC_APB1SECSR1_USART2SECF_Pos        (17U)
#define RCC_APB1SECSR1_USART2SECF_Msk        (0x1UL << RCC_APB1SECSR1_USART2SECF_Pos)/*!< 0x00020000 */
#define RCC_APB1SECSR1_USART2SECF            RCC_APB1SECSR1_USART2SECF_Msk
#define RCC_APB1SECSR1_USART3SECF_Pos        (18U)
#define RCC_APB1SECSR1_USART3SECF_Msk        (0x1UL << RCC_APB1SECSR1_USART3SECF_Pos)/*!< 0x00040000 */
#define RCC_APB1SECSR1_USART3SECF            RCC_APB1SECSR1_USART3SECF_Msk
#define RCC_APB1SECSR1_UART4SECF_Pos         (19U)
#define RCC_APB1SECSR1_UART4SECF_Msk         (0x1UL << RCC_APB1SECSR1_UART4SECF_Pos)/*!< 0x00080000 */
#define RCC_APB1SECSR1_UART4SECF             RCC_APB1SECSR1_UART4SECF_Msk
#define RCC_APB1SECSR1_UART5SECF_Pos         (20U)
#define RCC_APB1SECSR1_UART5SECF_Msk         (0x1UL << RCC_APB1SECSR1_UART5SECF_Pos)/*!< 0x00100000 */
#define RCC_APB1SECSR1_UART5SECF             RCC_APB1SECSR1_UART5SECF_Msk
#define RCC_APB1SECSR1_I2C1SECF_Pos          (21U)
#define RCC_APB1SECSR1_I2C1SECF_Msk          (0x1UL << RCC_APB1SECSR1_I2C1SECF_Pos)/*!< 0x00200000 */
#define RCC_APB1SECSR1_I2C1SECF              RCC_APB1SECSR1_I2C1SECF_Msk
#define RCC_APB1SECSR1_I2C2SECF_Pos          (22U)
#define RCC_APB1SECSR1_I2C2SECF_Msk          (0x1UL << RCC_APB1SECSR1_I2C2SECF_Pos)/*!< 0x00400000 */
#define RCC_APB1SECSR1_I2C2SECF              RCC_APB1SECSR1_I2C2SECF_Msk
#define RCC_APB1SECSR1_I2C3SECF_Pos          (23U)
#define RCC_APB1SECSR1_I2C3SECF_Msk          (0x1UL << RCC_APB1SECSR1_I2C3SECF_Pos)/*!< 0x00800000 */
#define RCC_APB1SECSR1_I2C3SECF              RCC_APB1SECSR1_I2C3SECF_Msk
#define RCC_APB1SECSR1_CRSSECF_Pos           (24U)
#define RCC_APB1SECSR1_CRSSECF_Msk           (0x1UL << RCC_APB1SECSR1_CRSSECF_Pos)/*!< 0x01000000 */
#define RCC_APB1SECSR1_CRSSECF               RCC_APB1SECSR1_CRSSECF_Msk
#define RCC_APB1SECSR1_PWRSECF_Pos           (28U)
#define RCC_APB1SECSR1_PWRSECF_Msk           (0x1UL << RCC_APB1SECSR1_PWRSECF_Pos)/*!< 0x10000000 */
#define RCC_APB1SECSR1_PWRSECF               RCC_APB1SECSR1_PWRSECF_Msk
#define RCC_APB1SECSR1_DAC1SECF_Pos          (29U)
#define RCC_APB1SECSR1_DAC1SECF_Msk          (0x1UL << RCC_APB1SECSR1_DAC1SECF_Pos)/*!< 0x20000000 */
#define RCC_APB1SECSR1_DAC1SECF              RCC_APB1SECSR1_DAC1SECF_Msk
#define RCC_APB1SECSR1_OPAMPSECF_Pos         (30U)
#define RCC_APB1SECSR1_OPAMPSECF_Msk         (0x1UL << RCC_APB1SECSR1_OPAMPSECF_Pos)/*!< 0x40000000 */
#define RCC_APB1SECSR1_OPAMPSECF             RCC_APB1SECSR1_OPAMPSECF_Msk
#define RCC_APB1SECSR1_LPTIM1SECF_Pos        (31U)
#define RCC_APB1SECSR1_LPTIM1SECF_Msk        (0x1UL << RCC_APB1SECSR1_LPTIM1SECF_Pos)/*!< 0x80000000 */
#define RCC_APB1SECSR1_LPTIM1SECF            RCC_APB1SECSR1_LPTIM1SECF_Msk

/********************  Bit definition for RCC_APB1SECSR2 register  ************/
#define RCC_APB1SECSR2_LPUART1SECF_Pos       (0U)
#define RCC_APB1SECSR2_LPUART1SECF_Msk       (0x1UL << RCC_APB1SECSR2_LPUART1SECF_Pos)/*!< 0x00000001 */
#define RCC_APB1SECSR2_LPUART1SECF           RCC_APB1SECSR2_LPUART1SECF_Msk
#define RCC_APB1SECSR2_I2C4SECF_Pos          (1U)
#define RCC_APB1SECSR2_I2C4SECF_Msk          (0x1UL << RCC_APB1SECSR2_I2C4SECF_Pos)/*!< 0x00000002 */
#define RCC_APB1SECSR2_I2C4SECF              RCC_APB1SECSR2_I2C4SECF_Msk
#define RCC_APB1SECSR2_LPTIM2SECF_Pos        (5U)
#define RCC_APB1SECSR2_LPTIM2SECF_Msk        (0x1UL << RCC_APB1SECSR2_LPTIM2SECF_Pos)/*!< 0x00000020 */
#define RCC_APB1SECSR2_LPTIM2SECF            RCC_APB1SECSR2_LPTIM2SECF_Msk
#define RCC_APB1SECSR2_LPTIM3SECF_Pos        (6U)
#define RCC_APB1SECSR2_LPTIM3SECF_Msk        (0x1UL << RCC_APB1SECSR2_LPTIM3SECF_Pos)/*!< 0x00000040 */
#define RCC_APB1SECSR2_LPTIM3SECF            RCC_APB1SECSR2_LPTIM3SECF_Msk
#define RCC_APB1SECSR2_FDCAN1SECF_Pos        (9U)
#define RCC_APB1SECSR2_FDCAN1SECF_Msk        (0x1UL << RCC_APB1SECSR2_FDCAN1SECF_Pos)/*!< 0x00000200 */
#define RCC_APB1SECSR2_FDCAN1SECF            RCC_APB1SECSR2_FDCAN1SECF_Msk
#define RCC_APB1SECSR2_USBFSSECF_Pos         (21U)
#define RCC_APB1SECSR2_USBFSSECF_Msk         (0x1UL << RCC_APB1SECSR2_USBFSSECF_Pos)/*!< 0x00200000 */
#define RCC_APB1SECSR2_USBFSSECF             RCC_APB1SECSR2_USBFSSECF_Msk
#define RCC_APB1SECSR2_UCPD1SECF_Pos         (23U)
#define RCC_APB1SECSR2_UCPD1SECF_Msk         (0x1UL << RCC_APB1SECSR2_UCPD1SECF_Pos)/*!< 0x00800000 */
#define RCC_APB1SECSR2_UCPD1SECF             RCC_APB1SECSR2_UCPD1SECF_Msk

/********************  Bit definition for RCC_APB2SECSR register  *************/
#define RCC_APB2SECSR_SYSCFGSECF_Pos         (0U)
#define RCC_APB2SECSR_SYSCFGSECF_Msk         (0x1UL << RCC_APB2SECSR_SYSCFGSECF_Pos)/*!< 0x00000001 */
#define RCC_APB2SECSR_SYSCFGSECF             RCC_APB2SECSR_SYSCFGSECF_Msk
#define RCC_APB2SECSR_TIM1SECF_Pos           (11U)
#define RCC_APB2SECSR_TIM1SECF_Msk           (0x1UL << RCC_APB2SECSR_TIM1SECF_Pos)/*!< 0x00000800 */
#define RCC_APB2SECSR_TIM1SECF               RCC_APB2SECSR_TIM1SECF_Msk
#define RCC_APB2SECSR_SPI1SECF_Pos           (12U)
#define RCC_APB2SECSR_SPI1SECF_Msk           (0x1UL << RCC_APB2SECSR_SPI1SECF_Pos)/*!< 0x00001000 */
#define RCC_APB2SECSR_SPI1SECF               RCC_APB2SECSR_SPI1SECF_Msk
#define RCC_APB2SECSR_TIM8SECF_Pos           (13U)
#define RCC_APB2SECSR_TIM8SECF_Msk           (0x1UL << RCC_APB2SECSR_TIM8SECF_Pos)/*!< 0x00002000 */
#define RCC_APB2SECSR_TIM8SECF               RCC_APB2SECSR_TIM8SECF_Msk
#define RCC_APB2SECSR_USART1SECF_Pos         (14U)
#define RCC_APB2SECSR_USART1SECF_Msk         (0x1UL << RCC_APB2SECSR_USART1SECF_Pos)/*!< 0x00004000 */
#define RCC_APB2SECSR_USART1SECF             RCC_APB2SECSR_USART1SECF_Msk
#define RCC_APB2SECSR_TIM15SECF_Pos          (16U)
#define RCC_APB2SECSR_TIM15SECF_Msk          (0x1UL << RCC_APB2SECSR_TIM15SECF_Pos)/*!< 0x00010000 */
#define RCC_APB2SECSR_TIM15SECF              RCC_APB2SECSR_TIM15SECF_Msk
#define RCC_APB2SECSR_TIM16SECF_Pos          (17U)
#define RCC_APB2SECSR_TIM16SECF_Msk          (0x1UL << RCC_APB2SECSR_TIM16SECF_Pos)/*!< 0x00020000 */
#define RCC_APB2SECSR_TIM16SECF              RCC_APB2SECSR_TIM16SECF_Msk
#define RCC_APB2SECSR_TIM17SECF_Pos          (18U)
#define RCC_APB2SECSR_TIM17SECF_Msk          (0x1UL << RCC_APB2SECSR_TIM17SECF_Pos)/*!< 0x00040000 */
#define RCC_APB2SECSR_TIM17SECF              RCC_APB2SECSR_TIM17SECF_Msk
#define RCC_APB2SECSR_SAI1SECF_Pos           (21U)
#define RCC_APB2SECSR_SAI1SECF_Msk           (0x1UL << RCC_APB2SECSR_SAI1SECF_Pos)/*!< 0x00200000 */
#define RCC_APB2SECSR_SAI1SECF               RCC_APB2SECSR_SAI1SECF_Msk
#define RCC_APB2SECSR_SAI2SECF_Pos           (22U)
#define RCC_APB2SECSR_SAI2SECF_Msk           (0x1UL << RCC_APB2SECSR_SAI2SECF_Pos)/*!< 0x00400000 */
#define RCC_APB2SECSR_SAI2SECF               RCC_APB2SECSR_SAI2SECF_Msk
#define RCC_APB2SECSR_DFSDM1SECF_Pos         (24U)
#define RCC_APB2SECSR_DFSDM1SECF_Msk         (0x1UL << RCC_APB2SECSR_DFSDM1SECF_Pos)/*!< 0x01000000 */
#define RCC_APB2SECSR_DFSDM1SECF             RCC_APB2SECSR_DFSDM1SECF_Msk


/******************************************************************************/
/*                                                                            */
/*                                    RNG                                     */
/*                                                                            */
/******************************************************************************/

/*
 * @brief Specific device feature definitions
 */
#define RNG_VER_3_1

/********************  Bits definition for RNG_CR register  *******************/
#define RNG_CR_RNGEN_Pos         (2U)
#define RNG_CR_RNGEN_Msk         (0x1UL << RNG_CR_RNGEN_Pos)               /*!< 0x00000004 */
#define RNG_CR_RNGEN             RNG_CR_RNGEN_Msk
#define RNG_CR_IE_Pos            (3U)
#define RNG_CR_IE_Msk            (0x1UL << RNG_CR_IE_Pos)                  /*!< 0x00000008 */
#define RNG_CR_IE                RNG_CR_IE_Msk
#define RNG_CR_CED_Pos           (5U)
#define RNG_CR_CED_Msk           (0x1UL << RNG_CR_CED_Pos)                 /*!< 0x00000020 */
#define RNG_CR_CED               RNG_CR_CED_Msk
#define RNG_CR_RNG_CONFIG3_Pos   (8U)
#define RNG_CR_RNG_CONFIG3_Msk   (0xFUL << RNG_CR_RNG_CONFIG3_Pos)         /*!< 0x00000F00 */
#define RNG_CR_RNG_CONFIG3       RNG_CR_RNG_CONFIG3_Msk
#define RNG_CR_RNG_CONFIG3_0     (0x01UL << RNG_CR_RNG_CONFIG3_Pos)        /*!< 0x00000100 */
#define RNG_CR_RNG_CONFIG3_1     (0x02UL << RNG_CR_RNG_CONFIG3_Pos)        /*!< 0x00000200 */
#define RNG_CR_RNG_CONFIG3_2     (0x04UL << RNG_CR_RNG_CONFIG3_Pos)        /*!< 0x00000400 */
#define RNG_CR_RNG_CONFIG3_3     (0x08UL << RNG_CR_RNG_CONFIG3_Pos)        /*!< 0x00000800 */
#define RNG_CR_NISTC_Pos         (12U)
#define RNG_CR_NISTC_Msk         (0x1UL << RNG_CR_NISTC_Pos)               /*!< 0x00001000 */
#define RNG_CR_NISTC             RNG_CR_NISTC_Msk
#define RNG_CR_RNG_CONFIG2_Pos   (13U)
#define RNG_CR_RNG_CONFIG2_Msk   (0x7UL << RNG_CR_RNG_CONFIG2_Pos)         /*!< 0x0000E000 */
#define RNG_CR_RNG_CONFIG2       RNG_CR_RNG_CONFIG2_Msk
#define RNG_CR_RNG_CONFIG2_0     (0x01UL << RNG_CR_RNG_CONFIG2_Pos)        /*!< 0x00002000 */
#define RNG_CR_RNG_CONFIG2_1     (0x02UL << RNG_CR_RNG_CONFIG2_Pos)        /*!< 0x00004000 */
#define RNG_CR_RNG_CONFIG2_2     (0x04UL << RNG_CR_RNG_CONFIG2_Pos)        /*!< 0x00008000 */
#define RNG_CR_CLKDIV_Pos        (16U)
#define RNG_CR_CLKDIV_Msk        (0xFUL << RNG_CR_CLKDIV_Pos)              /*!< 0x000F0000 */
#define RNG_CR_CLKDIV            RNG_CR_CLKDIV_Msk
#define RNG_CR_CLKDIV_0          (0x01UL << RNG_CR_CLKDIV_Pos)             /*!< 0x00010000 */
#define RNG_CR_CLKDIV_1          (0x02UL << RNG_CR_CLKDIV_Pos)             /*!< 0x00020000 */
#define RNG_CR_CLKDIV_2          (0x04UL << RNG_CR_CLKDIV_Pos)             /*!< 0x00040000 */
#define RNG_CR_CLKDIV_3          (0x08UL << RNG_CR_CLKDIV_Pos)             /*!< 0x00080000 */
#define RNG_CR_RNG_CONFIG1_Pos   (20U)
#define RNG_CR_RNG_CONFIG1_Msk   (0x3FUL << RNG_CR_RNG_CONFIG1_Pos)        /*!< 0x03F00000 */
#define RNG_CR_RNG_CONFIG1       RNG_CR_RNG_CONFIG1_Msk
#define RNG_CR_RNG_CONFIG1_0     (0x01UL << RNG_CR_RNG_CONFIG1_Pos)        /*!< 0x00100000 */
#define RNG_CR_RNG_CONFIG1_1     (0x02UL << RNG_CR_RNG_CONFIG1_Pos)        /*!< 0x00200000 */
#define RNG_CR_RNG_CONFIG1_2     (0x04UL << RNG_CR_RNG_CONFIG1_Pos)        /*!< 0x00400000 */
#define RNG_CR_RNG_CONFIG1_3     (0x08UL << RNG_CR_RNG_CONFIG1_Pos)        /*!< 0x00800000 */
#define RNG_CR_RNG_CONFIG1_4     (0x08UL << RNG_CR_RNG_CONFIG1_Pos)        /*!< 0x01000000 */
#define RNG_CR_RNG_CONFIG1_5     (0x08UL << RNG_CR_RNG_CONFIG1_Pos)        /*!< 0x02000000 */
#define RNG_CR_CONDRST_Pos       (30U)
#define RNG_CR_CONDRST_Msk       (0x1UL << RNG_CR_CONDRST_Pos)             /*!< 0x40000000 */
#define RNG_CR_CONDRST           RNG_CR_CONDRST_Msk
#define RNG_CR_CONFIGLOCK_Pos    (31U)
#define RNG_CR_CONFIGLOCK_Msk    (0x1UL << RNG_CR_CONFIGLOCK_Pos)          /*!< 0x80000000 */
#define RNG_CR_CONFIGLOCK        RNG_CR_CONFIGLOCK_Msk

/********************  Bits definition for RNG_SR register  *******************/
#define RNG_SR_DRDY_Pos          (0U)
#define RNG_SR_DRDY_Msk          (0x1UL << RNG_SR_DRDY_Pos)                /*!< 0x00000001 */
#define RNG_SR_DRDY              RNG_SR_DRDY_Msk
#define RNG_SR_CECS_Pos          (1U)
#define RNG_SR_CECS_Msk          (0x1UL << RNG_SR_CECS_Pos)                /*!< 0x00000002 */
#define RNG_SR_CECS              RNG_SR_CECS_Msk
#define RNG_SR_SECS_Pos          (2U)
#define RNG_SR_SECS_Msk          (0x1UL << RNG_SR_SECS_Pos)                /*!< 0x00000004 */
#define RNG_SR_SECS              RNG_SR_SECS_Msk
#define RNG_SR_CEIS_Pos          (5U)
#define RNG_SR_CEIS_Msk          (0x1UL << RNG_SR_CEIS_Pos)                /*!< 0x00000020 */
#define RNG_SR_CEIS              RNG_SR_CEIS_Msk
#define RNG_SR_SEIS_Pos          (6U)
#define RNG_SR_SEIS_Msk          (0x1UL << RNG_SR_SEIS_Pos)                /*!< 0x00000040 */
#define RNG_SR_SEIS              RNG_SR_SEIS_Msk

/********************  Bits definition for RNG_DR register  *******************/
#define RNG_DR_RNDATA_Pos        (0U)
#define RNG_DR_RNDATA_Msk        (0xFFFFFFFFUL << RNG_DR_RNDATA_Pos)       /*!< 0xFFFFFFFF */
#define RNG_DR_RNDATA            RNG_DR_RNDATA_Msk

/********************  Bits definition for RNG_HTCR register  *****************/
#define RNG_HTCR_HTCFG_Pos       (0U)
#define RNG_HTCR_HTCFG_Msk       (0xFFFFFFFFUL << RNG_HTCR_HTCFG_Pos)      /*!< 0xFFFFFFFF */
#define RNG_HTCR_HTCFG           RNG_HTCR_HTCFG_Msk


/******************************************************************************/
/*                                                                            */
/*                           Real-Time Clock (RTC)                            */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for RTC_TR register  *******************/
#define RTC_TR_PM_Pos                (22U)
#define RTC_TR_PM_Msk                (0x1UL << RTC_TR_PM_Pos)                  /*!< 0x00400000 */
#define RTC_TR_PM                    RTC_TR_PM_Msk
#define RTC_TR_HT_Pos                (20U)
#define RTC_TR_HT_Msk                (0x3UL << RTC_TR_HT_Pos)                  /*!< 0x00300000 */
#define RTC_TR_HT                    RTC_TR_HT_Msk
#define RTC_TR_HT_0                  (0x1UL << RTC_TR_HT_Pos)                  /*!< 0x00100000 */
#define RTC_TR_HT_1                  (0x2UL << RTC_TR_HT_Pos)                  /*!< 0x00200000 */
#define RTC_TR_HU_Pos                (16U)
#define RTC_TR_HU_Msk                (0xFUL << RTC_TR_HU_Pos)                  /*!< 0x000F0000 */
#define RTC_TR_HU                    RTC_TR_HU_Msk
#define RTC_TR_HU_0                  (0x1UL << RTC_TR_HU_Pos)                  /*!< 0x00010000 */
#define RTC_TR_HU_1                  (0x2UL << RTC_TR_HU_Pos)                  /*!< 0x00020000 */
#define RTC_TR_HU_2                  (0x4UL << RTC_TR_HU_Pos)                  /*!< 0x00040000 */
#define RTC_TR_HU_3                  (0x8UL << RTC_TR_HU_Pos)                  /*!< 0x00080000 */
#define RTC_TR_MNT_Pos               (12U)
#define RTC_TR_MNT_Msk               (0x7UL << RTC_TR_MNT_Pos)                 /*!< 0x00007000 */
#define RTC_TR_MNT                   RTC_TR_MNT_Msk
#define RTC_TR_MNT_0                 (0x1UL << RTC_TR_MNT_Pos)                 /*!< 0x00001000 */
#define RTC_TR_MNT_1                 (0x2UL << RTC_TR_MNT_Pos)                 /*!< 0x00002000 */
#define RTC_TR_MNT_2                 (0x4UL << RTC_TR_MNT_Pos)                 /*!< 0x00004000 */
#define RTC_TR_MNU_Pos               (8U)
#define RTC_TR_MNU_Msk               (0xFUL << RTC_TR_MNU_Pos)                 /*!< 0x00000F00 */
#define RTC_TR_MNU                   RTC_TR_MNU_Msk
#define RTC_TR_MNU_0                 (0x1UL << RTC_TR_MNU_Pos)                 /*!< 0x00000100 */
#define RTC_TR_MNU_1                 (0x2UL << RTC_TR_MNU_Pos)                 /*!< 0x00000200 */
#define RTC_TR_MNU_2                 (0x4UL << RTC_TR_MNU_Pos)                 /*!< 0x00000400 */
#define RTC_TR_MNU_3                 (0x8UL << RTC_TR_MNU_Pos)                 /*!< 0x00000800 */
#define RTC_TR_ST_Pos                (4U)
#define RTC_TR_ST_Msk                (0x7UL << RTC_TR_ST_Pos)                  /*!< 0x00000070 */
#define RTC_TR_ST                    RTC_TR_ST_Msk
#define RTC_TR_ST_0                  (0x1UL << RTC_TR_ST_Pos)                  /*!< 0x00000010 */
#define RTC_TR_ST_1                  (0x2UL << RTC_TR_ST_Pos)                  /*!< 0x00000020 */
#define RTC_TR_ST_2                  (0x4UL << RTC_TR_ST_Pos)                  /*!< 0x00000040 */
#define RTC_TR_SU_Pos                (0U)
#define RTC_TR_SU_Msk                (0xFUL << RTC_TR_SU_Pos)                  /*!< 0x0000000F */
#define RTC_TR_SU                    RTC_TR_SU_Msk
#define RTC_TR_SU_0                  (0x1UL << RTC_TR_SU_Pos)                  /*!< 0x00000001 */
#define RTC_TR_SU_1                  (0x2UL << RTC_TR_SU_Pos)                  /*!< 0x00000002 */
#define RTC_TR_SU_2                  (0x4UL << RTC_TR_SU_Pos)                  /*!< 0x00000004 */
#define RTC_TR_SU_3                  (0x8UL << RTC_TR_SU_Pos)                  /*!< 0x00000008 */

/********************  Bits definition for RTC_DR register  *******************/
#define RTC_DR_YT_Pos                (20U)
#define RTC_DR_YT_Msk                (0xFUL << RTC_DR_YT_Pos)                  /*!< 0x00F00000 */
#define RTC_DR_YT                    RTC_DR_YT_Msk
#define RTC_DR_YT_0                  (0x1UL << RTC_DR_YT_Pos)                  /*!< 0x00100000 */
#define RTC_DR_YT_1                  (0x2UL << RTC_DR_YT_Pos)                  /*!< 0x00200000 */
#define RTC_DR_YT_2                  (0x4UL << RTC_DR_YT_Pos)                  /*!< 0x00400000 */
#define RTC_DR_YT_3                  (0x8UL << RTC_DR_YT_Pos)                  /*!< 0x00800000 */
#define RTC_DR_YU_Pos                (16U)
#define RTC_DR_YU_Msk                (0xFUL << RTC_DR_YU_Pos)                  /*!< 0x000F0000 */
#define RTC_DR_YU                    RTC_DR_YU_Msk
#define RTC_DR_YU_0                  (0x1UL << RTC_DR_YU_Pos)                  /*!< 0x00010000 */
#define RTC_DR_YU_1                  (0x2UL << RTC_DR_YU_Pos)                  /*!< 0x00020000 */
#define RTC_DR_YU_2                  (0x4UL << RTC_DR_YU_Pos)                  /*!< 0x00040000 */
#define RTC_DR_YU_3                  (0x8UL << RTC_DR_YU_Pos)                  /*!< 0x00080000 */
#define RTC_DR_WDU_Pos               (13U)
#define RTC_DR_WDU_Msk               (0x7UL << RTC_DR_WDU_Pos)                 /*!< 0x0000E000 */
#define RTC_DR_WDU                   RTC_DR_WDU_Msk
#define RTC_DR_WDU_0                 (0x1UL << RTC_DR_WDU_Pos)                 /*!< 0x00002000 */
#define RTC_DR_WDU_1                 (0x2UL << RTC_DR_WDU_Pos)                 /*!< 0x00004000 */
#define RTC_DR_WDU_2                 (0x4UL << RTC_DR_WDU_Pos)                 /*!< 0x00008000 */
#define RTC_DR_MT_Pos                (12U)
#define RTC_DR_MT_Msk                (0x1UL << RTC_DR_MT_Pos)                  /*!< 0x00001000 */
#define RTC_DR_MT                    RTC_DR_MT_Msk
#define RTC_DR_MU_Pos                (8U)
#define RTC_DR_MU_Msk                (0xFUL << RTC_DR_MU_Pos)                  /*!< 0x00000F00 */
#define RTC_DR_MU                    RTC_DR_MU_Msk
#define RTC_DR_MU_0                  (0x1UL << RTC_DR_MU_Pos)                  /*!< 0x00000100 */
#define RTC_DR_MU_1                  (0x2UL << RTC_DR_MU_Pos)                  /*!< 0x00000200 */
#define RTC_DR_MU_2                  (0x4UL << RTC_DR_MU_Pos)                  /*!< 0x00000400 */
#define RTC_DR_MU_3                  (0x8UL << RTC_DR_MU_Pos)                  /*!< 0x00000800 */
#define RTC_DR_DT_Pos                (4U)
#define RTC_DR_DT_Msk                (0x3UL << RTC_DR_DT_Pos)                  /*!< 0x00000030 */
#define RTC_DR_DT                    RTC_DR_DT_Msk
#define RTC_DR_DT_0                  (0x1UL << RTC_DR_DT_Pos)                  /*!< 0x00000010 */
#define RTC_DR_DT_1                  (0x2UL << RTC_DR_DT_Pos)                  /*!< 0x00000020 */
#define RTC_DR_DU_Pos                (0U)
#define RTC_DR_DU_Msk                (0xFUL << RTC_DR_DU_Pos)                  /*!< 0x0000000F */
#define RTC_DR_DU                    RTC_DR_DU_Msk
#define RTC_DR_DU_0                  (0x1UL << RTC_DR_DU_Pos)                  /*!< 0x00000001 */
#define RTC_DR_DU_1                  (0x2UL << RTC_DR_DU_Pos)                  /*!< 0x00000002 */
#define RTC_DR_DU_2                  (0x4UL << RTC_DR_DU_Pos)                  /*!< 0x00000004 */
#define RTC_DR_DU_3                  (0x8UL << RTC_DR_DU_Pos)                  /*!< 0x00000008 */

/********************  Bits definition for RTC_SSR register  ******************/
#define RTC_SSR_SS_Pos               (0U)
#define RTC_SSR_SS_Msk               (0xFFFFUL << RTC_SSR_SS_Pos)              /*!< 0x0000FFFF */
#define RTC_SSR_SS                   RTC_SSR_SS_Msk

/********************  Bits definition for RTC_ICSR register  ******************/
#define RTC_ICSR_RECALPF_Pos         (16U)
#define RTC_ICSR_RECALPF_Msk         (0x1UL << RTC_ICSR_RECALPF_Pos)           /*!< 0x00010000 */
#define RTC_ICSR_RECALPF             RTC_ICSR_RECALPF_Msk
#define RTC_ICSR_INIT_Pos            (7U)
#define RTC_ICSR_INIT_Msk            (0x1UL << RTC_ICSR_INIT_Pos)              /*!< 0x00000080 */
#define RTC_ICSR_INIT                RTC_ICSR_INIT_Msk
#define RTC_ICSR_INITF_Pos           (6U)
#define RTC_ICSR_INITF_Msk           (0x1UL << RTC_ICSR_INITF_Pos)             /*!< 0x00000040 */
#define RTC_ICSR_INITF               RTC_ICSR_INITF_Msk
#define RTC_ICSR_RSF_Pos             (5U)
#define RTC_ICSR_RSF_Msk             (0x1UL << RTC_ICSR_RSF_Pos)               /*!< 0x00000020 */
#define RTC_ICSR_RSF                 RTC_ICSR_RSF_Msk
#define RTC_ICSR_INITS_Pos           (4U)
#define RTC_ICSR_INITS_Msk           (0x1UL << RTC_ICSR_INITS_Pos)             /*!< 0x00000010 */
#define RTC_ICSR_INITS               RTC_ICSR_INITS_Msk
#define RTC_ICSR_SHPF_Pos            (3U)
#define RTC_ICSR_SHPF_Msk            (0x1UL << RTC_ICSR_SHPF_Pos)              /*!< 0x00000008 */
#define RTC_ICSR_SHPF                RTC_ICSR_SHPF_Msk
#define RTC_ICSR_WUTWF_Pos           (2U)
#define RTC_ICSR_WUTWF_Msk           (0x1UL << RTC_ICSR_WUTWF_Pos)             /*!< 0x00000004 */
#define RTC_ICSR_WUTWF               RTC_ICSR_WUTWF_Msk

/********************  Bits definition for RTC_PRER register  *****************/
#define RTC_PRER_PREDIV_A_Pos        (16U)
#define RTC_PRER_PREDIV_A_Msk        (0x7FUL << RTC_PRER_PREDIV_A_Pos)         /*!< 0x007F0000 */
#define RTC_PRER_PREDIV_A            RTC_PRER_PREDIV_A_Msk
#define RTC_PRER_PREDIV_S_Pos        (0U)
#define RTC_PRER_PREDIV_S_Msk        (0x7FFFUL << RTC_PRER_PREDIV_S_Pos)       /*!< 0x00007FFF */
#define RTC_PRER_PREDIV_S            RTC_PRER_PREDIV_S_Msk

/********************  Bits definition for RTC_WUTR register  *****************/
#define RTC_WUTR_WUTOCLR_Pos         (16U)
#define RTC_WUTR_WUTOCLR_Msk         (0xFFFFUL << RTC_WUTR_WUTOCLR_Pos)        /*!< 0xFFFF0000 */
#define RTC_WUTR_WUTOCLR             RTC_WUTR_WUTOCLR_Msk
#define RTC_WUTR_WUT_Pos             (0U)
#define RTC_WUTR_WUT_Msk             (0xFFFFUL << RTC_WUTR_WUT_Pos)            /*!< 0x0000FFFF */
#define RTC_WUTR_WUT                 RTC_WUTR_WUT_Msk

/********************  Bits definition for RTC_CR register  *******************/
#define RTC_CR_OUT2EN_Pos            (31U)
#define RTC_CR_OUT2EN_Msk            (0x1UL << RTC_CR_OUT2EN_Pos)              /*!< 0x80000000 */
#define RTC_CR_OUT2EN                RTC_CR_OUT2EN_Msk                         /*!<RTC_OUT2 output enable */
#define RTC_CR_TAMPALRM_TYPE_Pos     (30U)
#define RTC_CR_TAMPALRM_TYPE_Msk     (0x1UL << RTC_CR_TAMPALRM_TYPE_Pos)       /*!< 0x40000000 */
#define RTC_CR_TAMPALRM_TYPE         RTC_CR_TAMPALRM_TYPE_Msk                  /*!<TAMPALARM output type  */
#define RTC_CR_TAMPALRM_PU_Pos       (29U)
#define RTC_CR_TAMPALRM_PU_Msk       (0x1UL << RTC_CR_TAMPALRM_PU_Pos)         /*!< 0x20000000 */
#define RTC_CR_TAMPALRM_PU           RTC_CR_TAMPALRM_PU_Msk                    /*!<TAMPALARM output pull-up config */
#define RTC_CR_TAMPOE_Pos            (26U)
#define RTC_CR_TAMPOE_Msk            (0x1UL << RTC_CR_TAMPOE_Pos)              /*!< 0x04000000 */
#define RTC_CR_TAMPOE                RTC_CR_TAMPOE_Msk                         /*!<Tamper detection output enable on TAMPALARM  */
#define RTC_CR_TAMPTS_Pos            (25U)
#define RTC_CR_TAMPTS_Msk            (0x1UL << RTC_CR_TAMPTS_Pos)              /*!< 0x02000000 */
#define RTC_CR_TAMPTS                RTC_CR_TAMPTS_Msk                         /*!<Activate timestamp on tamper detection event  */
#define RTC_CR_ITSE_Pos              (24U)
#define RTC_CR_ITSE_Msk              (0x1UL << RTC_CR_ITSE_Pos)                /*!< 0x01000000 */
#define RTC_CR_ITSE                  RTC_CR_ITSE_Msk                           /*!<Timestamp on internal event enable  */
#define RTC_CR_COE_Pos               (23U)
#define RTC_CR_COE_Msk               (0x1UL << RTC_CR_COE_Pos)                 /*!< 0x00800000 */
#define RTC_CR_COE                   RTC_CR_COE_Msk
#define RTC_CR_OSEL_Pos              (21U)
#define RTC_CR_OSEL_Msk              (0x3UL << RTC_CR_OSEL_Pos)                /*!< 0x00600000 */
#define RTC_CR_OSEL                  RTC_CR_OSEL_Msk
#define RTC_CR_OSEL_0                (0x1UL << RTC_CR_OSEL_Pos)                /*!< 0x00200000 */
#define RTC_CR_OSEL_1                (0x2UL << RTC_CR_OSEL_Pos)                /*!< 0x00400000 */
#define RTC_CR_POL_Pos               (20U)
#define RTC_CR_POL_Msk               (0x1UL << RTC_CR_POL_Pos)                 /*!< 0x00100000 */
#define RTC_CR_POL                   RTC_CR_POL_Msk
#define RTC_CR_COSEL_Pos             (19U)
#define RTC_CR_COSEL_Msk             (0x1UL << RTC_CR_COSEL_Pos)               /*!< 0x00080000 */
#define RTC_CR_COSEL                 RTC_CR_COSEL_Msk
#define RTC_CR_BKP_Pos               (18U)
#define RTC_CR_BKP_Msk               (0x1UL << RTC_CR_BKP_Pos)                 /*!< 0x00040000 */
#define RTC_CR_BKP                   RTC_CR_BKP_Msk
#define RTC_CR_SUB1H_Pos             (17U)
#define RTC_CR_SUB1H_Msk             (0x1UL << RTC_CR_SUB1H_Pos)               /*!< 0x00020000 */
#define RTC_CR_SUB1H                 RTC_CR_SUB1H_Msk
#define RTC_CR_ADD1H_Pos             (16U)
#define RTC_CR_ADD1H_Msk             (0x1UL << RTC_CR_ADD1H_Pos)               /*!< 0x00010000 */
#define RTC_CR_ADD1H                 RTC_CR_ADD1H_Msk
#define RTC_CR_TSIE_Pos              (15U)
#define RTC_CR_TSIE_Msk              (0x1UL << RTC_CR_TSIE_Pos)                /*!< 0x00008000 */
#define RTC_CR_TSIE                  RTC_CR_TSIE_Msk
#define RTC_CR_WUTIE_Pos             (14U)
#define RTC_CR_WUTIE_Msk             (0x1UL << RTC_CR_WUTIE_Pos)               /*!< 0x00004000 */
#define RTC_CR_WUTIE                 RTC_CR_WUTIE_Msk
#define RTC_CR_ALRBIE_Pos            (13U)
#define RTC_CR_ALRBIE_Msk            (0x1UL << RTC_CR_ALRBIE_Pos)              /*!< 0x00002000 */
#define RTC_CR_ALRBIE                RTC_CR_ALRBIE_Msk
#define RTC_CR_ALRAIE_Pos            (12U)
#define RTC_CR_ALRAIE_Msk            (0x1UL << RTC_CR_ALRAIE_Pos)              /*!< 0x00001000 */
#define RTC_CR_ALRAIE                RTC_CR_ALRAIE_Msk
#define RTC_CR_TSE_Pos               (11U)
#define RTC_CR_TSE_Msk               (0x1UL << RTC_CR_TSE_Pos)                 /*!< 0x00000800 */
#define RTC_CR_TSE                   RTC_CR_TSE_Msk
#define RTC_CR_WUTE_Pos              (10U)
#define RTC_CR_WUTE_Msk              (0x1UL << RTC_CR_WUTE_Pos)                /*!< 0x00000400 */
#define RTC_CR_WUTE                  RTC_CR_WUTE_Msk
#define RTC_CR_ALRBE_Pos             (9U)
#define RTC_CR_ALRBE_Msk             (0x1UL << RTC_CR_ALRBE_Pos)               /*!< 0x00000200 */
#define RTC_CR_ALRBE                 RTC_CR_ALRBE_Msk
#define RTC_CR_ALRAE_Pos             (8U)
#define RTC_CR_ALRAE_Msk             (0x1UL << RTC_CR_ALRAE_Pos)               /*!< 0x00000100 */
#define RTC_CR_ALRAE                 RTC_CR_ALRAE_Msk
#define RTC_CR_FMT_Pos               (6U)
#define RTC_CR_FMT_Msk               (0x1UL << RTC_CR_FMT_Pos)                 /*!< 0x00000040 */
#define RTC_CR_FMT                   RTC_CR_FMT_Msk
#define RTC_CR_BYPSHAD_Pos           (5U)
#define RTC_CR_BYPSHAD_Msk           (0x1UL << RTC_CR_BYPSHAD_Pos)             /*!< 0x00000020 */
#define RTC_CR_BYPSHAD               RTC_CR_BYPSHAD_Msk
#define RTC_CR_REFCKON_Pos           (4U)
#define RTC_CR_REFCKON_Msk           (0x1UL << RTC_CR_REFCKON_Pos)             /*!< 0x00000010 */
#define RTC_CR_REFCKON               RTC_CR_REFCKON_Msk
#define RTC_CR_TSEDGE_Pos            (3U)
#define RTC_CR_TSEDGE_Msk            (0x1UL << RTC_CR_TSEDGE_Pos)              /*!< 0x00000008 */
#define RTC_CR_TSEDGE                RTC_CR_TSEDGE_Msk
#define RTC_CR_WUCKSEL_Pos           (0U)
#define RTC_CR_WUCKSEL_Msk           (0x7UL << RTC_CR_WUCKSEL_Pos)             /*!< 0x00000007 */
#define RTC_CR_WUCKSEL               RTC_CR_WUCKSEL_Msk
#define RTC_CR_WUCKSEL_0             (0x1UL << RTC_CR_WUCKSEL_Pos)             /*!< 0x00000001 */
#define RTC_CR_WUCKSEL_1             (0x2UL << RTC_CR_WUCKSEL_Pos)             /*!< 0x00000002 */
#define RTC_CR_WUCKSEL_2             (0x4UL << RTC_CR_WUCKSEL_Pos)             /*!< 0x00000004 */

/********************  Bits definition for RTC_PRIVCR register  ******************/
#define RTC_PRIVCR_PRIV_Pos          (15U)
#define RTC_PRIVCR_PRIV_Msk          (0x1UL << RTC_PRIVCR_PRIV_Pos)            /*!< 0x00008000 */
#define RTC_PRIVCR_PRIV              RTC_PRIVCR_PRIV_Msk
#define RTC_PRIVCR_INITPRIV_Pos      (14U)
#define RTC_PRIVCR_INITPRIV_Msk      (0x1UL << RTC_PRIVCR_INITPRIV_Pos)        /*!< 0x00004000 */
#define RTC_PRIVCR_INITPRIV          RTC_PRIVCR_INITPRIV_Msk
#define RTC_PRIVCR_CALPRIV_Pos       (13U)
#define RTC_PRIVCR_CALPRIV_Msk       (0x1UL << RTC_PRIVCR_CALPRIV_Pos)         /*!< 0x00002000 */
#define RTC_PRIVCR_CALPRIV           RTC_PRIVCR_CALPRIV_Msk
#define RTC_PRIVCR_TSPRIV_Pos        (3U)
#define RTC_PRIVCR_TSPRIV_Msk        (0x1UL << RTC_PRIVCR_TSPRIV_Pos)          /*!< 0x00000008 */
#define RTC_PRIVCR_TSPRIV            RTC_PRIVCR_TSPRIV_Msk
#define RTC_PRIVCR_WUTPRIV_Pos       (2U)
#define RTC_PRIVCR_WUTPRIV_Msk       (0x1UL << RTC_PRIVCR_WUTPRIV_Pos)         /*!< 0x00000004 */
#define RTC_PRIVCR_WUTPRIV           RTC_PRIVCR_WUTPRIV_Msk
#define RTC_PRIVCR_ALRBPRIV_Pos      (1U)
#define RTC_PRIVCR_ALRBPRIV_Msk      (0x1UL << RTC_PRIVCR_ALRBPRIV_Pos)        /*!< 0x00000002 */
#define RTC_PRIVCR_ALRBPRIV          RTC_PRIVCR_ALRBPRIV_Msk
#define RTC_PRIVCR_ALRAPRIV_Pos      (0U)
#define RTC_PRIVCR_ALRAPRIV_Msk      (0x1UL << RTC_PRIVCR_ALRAPRIV_Pos)        /*!< 0x00000001 */
#define RTC_PRIVCR_ALRAPRIV          RTC_PRIVCR_ALRAPRIV_Msk

/********************  Bits definition for RTC_SMCR register  ******************/
#define RTC_SMCR_DECPROT_Pos         (15U)
#define RTC_SMCR_DECPROT_Msk         (0x1UL << RTC_SMCR_DECPROT_Pos)           /*!< 0x00008000 */
#define RTC_SMCR_DECPROT             RTC_SMCR_DECPROT_Msk
#define RTC_SMCR_INITDPROT_Pos       (14U)
#define RTC_SMCR_INITDPROT_Msk       (0x1UL << RTC_SMCR_INITDPROT_Pos)         /*!< 0x00004000 */
#define RTC_SMCR_INITDPROT           RTC_SMCR_INITDPROT_Msk
#define RTC_SMCR_CALDPROT_Pos        (13U)
#define RTC_SMCR_CALDPROT_Msk        (0x1UL << RTC_SMCR_CALDPROT_Pos)          /*!< 0x00002000 */
#define RTC_SMCR_CALDPROT            RTC_SMCR_CALDPROT_Msk
#define RTC_SMCR_TSDPROT_Pos         (3U)
#define RTC_SMCR_TSDPROT_Msk         (0x1UL << RTC_SMCR_TSDPROT_Pos)           /*!< 0x00000008 */
#define RTC_SMCR_TSDPROT             RTC_SMCR_TSDPROT_Msk
#define RTC_SMCR_WUTDPROT_Pos        (2U)
#define RTC_SMCR_WUTDPROT_Msk        (0x1UL << RTC_SMCR_WUTDPROT_Pos)          /*!< 0x00000004 */
#define RTC_SMCR_WUTDPROT            RTC_SMCR_WUTDPROT_Msk
#define RTC_SMCR_ALRBDPROT_Pos       (1U)
#define RTC_SMCR_ALRBDPROT_Msk       (0x1UL << RTC_SMCR_ALRBDPROT_Pos)         /*!< 0x00000002 */
#define RTC_SMCR_ALRBDPROT           RTC_SMCR_ALRBDPROT_Msk
#define RTC_SMCR_ALRADPROT_Pos       (0U)
#define RTC_SMCR_ALRADPROT_Msk       (0x1UL << RTC_SMCR_ALRADPROT_Pos)         /*!< 0x00000001 */
#define RTC_SMCR_ALRADPROT           RTC_SMCR_ALRADPROT_Msk

/********************  Bits definition for RTC_WPR register  ******************/
#define RTC_WPR_KEY_Pos              (0U)
#define RTC_WPR_KEY_Msk              (0xFFUL << RTC_WPR_KEY_Pos)               /*!< 0x000000FF */
#define RTC_WPR_KEY                  RTC_WPR_KEY_Msk

/********************  Bits definition for RTC_CALR register  *****************/
#define RTC_CALR_CALP_Pos            (15U)
#define RTC_CALR_CALP_Msk            (0x1UL << RTC_CALR_CALP_Pos)              /*!< 0x00008000 */
#define RTC_CALR_CALP                RTC_CALR_CALP_Msk
#define RTC_CALR_CALW8_Pos           (14U)
#define RTC_CALR_CALW8_Msk           (0x1UL << RTC_CALR_CALW8_Pos)             /*!< 0x00004000 */
#define RTC_CALR_CALW8               RTC_CALR_CALW8_Msk
#define RTC_CALR_CALW16_Pos          (13U)
#define RTC_CALR_CALW16_Msk          (0x1UL << RTC_CALR_CALW16_Pos)            /*!< 0x00002000 */
#define RTC_CALR_LPCAL               RTC_CALR_LPCAL_Msk
#define RTC_CALR_LPCAL_Pos           (12U)
#define RTC_CALR_LPCAL_Msk           (0x1UL << RTC_CALR_LPCAL_Pos)             /*!< 0x00001000 */
#define RTC_CALR_CALW16              RTC_CALR_CALW16_Msk
#define RTC_CALR_CALM_Pos            (0U)
#define RTC_CALR_CALM_Msk            (0x1FFUL << RTC_CALR_CALM_Pos)            /*!< 0x000001FF */
#define RTC_CALR_CALM                RTC_CALR_CALM_Msk
#define RTC_CALR_CALM_0              (0x001UL << RTC_CALR_CALM_Pos)            /*!< 0x00000001 */
#define RTC_CALR_CALM_1              (0x002UL << RTC_CALR_CALM_Pos)            /*!< 0x00000002 */
#define RTC_CALR_CALM_2              (0x004UL << RTC_CALR_CALM_Pos)            /*!< 0x00000004 */
#define RTC_CALR_CALM_3              (0x008UL << RTC_CALR_CALM_Pos)            /*!< 0x00000008 */
#define RTC_CALR_CALM_4              (0x010UL << RTC_CALR_CALM_Pos)            /*!< 0x00000010 */
#define RTC_CALR_CALM_5              (0x020UL << RTC_CALR_CALM_Pos)            /*!< 0x00000020 */
#define RTC_CALR_CALM_6              (0x040UL << RTC_CALR_CALM_Pos)            /*!< 0x00000040 */
#define RTC_CALR_CALM_7              (0x080UL << RTC_CALR_CALM_Pos)            /*!< 0x00000080 */
#define RTC_CALR_CALM_8              (0x100UL << RTC_CALR_CALM_Pos)            /*!< 0x00000100 */

/********************  Bits definition for RTC_SHIFTR register  ***************/
#define RTC_SHIFTR_ADD1S_Pos         (31U)
#define RTC_SHIFTR_ADD1S_Msk         (0x1UL << RTC_SHIFTR_ADD1S_Pos)           /*!< 0x80000000 */
#define RTC_SHIFTR_ADD1S             RTC_SHIFTR_ADD1S_Msk
#define RTC_SHIFTR_SUBFS_Pos         (0U)
#define RTC_SHIFTR_SUBFS_Msk         (0x7FFFUL << RTC_SHIFTR_SUBFS_Pos)        /*!< 0x00007FFF */
#define RTC_SHIFTR_SUBFS             RTC_SHIFTR_SUBFS_Msk

/********************  Bits definition for RTC_TSTR register  *****************/
#define RTC_TSTR_PM_Pos              (22U)
#define RTC_TSTR_PM_Msk              (0x1UL << RTC_TSTR_PM_Pos)                /*!< 0x00400000 */
#define RTC_TSTR_PM                  RTC_TSTR_PM_Msk
#define RTC_TSTR_HT_Pos              (20U)
#define RTC_TSTR_HT_Msk              (0x3UL << RTC_TSTR_HT_Pos)                /*!< 0x00300000 */
#define RTC_TSTR_HT                  RTC_TSTR_HT_Msk
#define RTC_TSTR_HT_0                (0x1UL << RTC_TSTR_HT_Pos)                /*!< 0x00100000 */
#define RTC_TSTR_HT_1                (0x2UL << RTC_TSTR_HT_Pos)                /*!< 0x00200000 */
#define RTC_TSTR_HU_Pos              (16U)
#define RTC_TSTR_HU_Msk              (0xFUL << RTC_TSTR_HU_Pos)                /*!< 0x000F0000 */
#define RTC_TSTR_HU                  RTC_TSTR_HU_Msk
#define RTC_TSTR_HU_0                (0x1UL << RTC_TSTR_HU_Pos)                /*!< 0x00010000 */
#define RTC_TSTR_HU_1                (0x2UL << RTC_TSTR_HU_Pos)                /*!< 0x00020000 */
#define RTC_TSTR_HU_2                (0x4UL << RTC_TSTR_HU_Pos)                /*!< 0x00040000 */
#define RTC_TSTR_HU_3                (0x8UL << RTC_TSTR_HU_Pos)                /*!< 0x00080000 */
#define RTC_TSTR_MNT_Pos             (12U)
#define RTC_TSTR_MNT_Msk             (0x7UL << RTC_TSTR_MNT_Pos)               /*!< 0x00007000 */
#define RTC_TSTR_MNT                 RTC_TSTR_MNT_Msk
#define RTC_TSTR_MNT_0               (0x1UL << RTC_TSTR_MNT_Pos)               /*!< 0x00001000 */
#define RTC_TSTR_MNT_1               (0x2UL << RTC_TSTR_MNT_Pos)               /*!< 0x00002000 */
#define RTC_TSTR_MNT_2               (0x4UL << RTC_TSTR_MNT_Pos)               /*!< 0x00004000 */
#define RTC_TSTR_MNU_Pos             (8U)
#define RTC_TSTR_MNU_Msk             (0xFUL << RTC_TSTR_MNU_Pos)               /*!< 0x00000F00 */
#define RTC_TSTR_MNU                 RTC_TSTR_MNU_Msk
#define RTC_TSTR_MNU_0               (0x1UL << RTC_TSTR_MNU_Pos)               /*!< 0x00000100 */
#define RTC_TSTR_MNU_1               (0x2UL << RTC_TSTR_MNU_Pos)               /*!< 0x00000200 */
#define RTC_TSTR_MNU_2               (0x4UL << RTC_TSTR_MNU_Pos)               /*!< 0x00000400 */
#define RTC_TSTR_MNU_3               (0x8UL << RTC_TSTR_MNU_Pos)               /*!< 0x00000800 */
#define RTC_TSTR_ST_Pos              (4U)
#define RTC_TSTR_ST_Msk              (0x7UL << RTC_TSTR_ST_Pos)                /*!< 0x00000070 */
#define RTC_TSTR_ST                  RTC_TSTR_ST_Msk
#define RTC_TSTR_ST_0                (0x1UL << RTC_TSTR_ST_Pos)                /*!< 0x00000010 */
#define RTC_TSTR_ST_1                (0x2UL << RTC_TSTR_ST_Pos)                /*!< 0x00000020 */
#define RTC_TSTR_ST_2                (0x4UL << RTC_TSTR_ST_Pos)                /*!< 0x00000040 */
#define RTC_TSTR_SU_Pos              (0U)
#define RTC_TSTR_SU_Msk              (0xFUL << RTC_TSTR_SU_Pos)                /*!< 0x0000000F */
#define RTC_TSTR_SU                  RTC_TSTR_SU_Msk
#define RTC_TSTR_SU_0                (0x1UL << RTC_TSTR_SU_Pos)                /*!< 0x00000001 */
#define RTC_TSTR_SU_1                (0x2UL << RTC_TSTR_SU_Pos)                /*!< 0x00000002 */
#define RTC_TSTR_SU_2                (0x4UL << RTC_TSTR_SU_Pos)                /*!< 0x00000004 */
#define RTC_TSTR_SU_3                (0x8UL << RTC_TSTR_SU_Pos)                /*!< 0x00000008 */

/********************  Bits definition for RTC_TSDR register  *****************/
#define RTC_TSDR_WDU_Pos             (13U)
#define RTC_TSDR_WDU_Msk             (0x7UL << RTC_TSDR_WDU_Pos)               /*!< 0x0000E000 */
#define RTC_TSDR_WDU                 RTC_TSDR_WDU_Msk
#define RTC_TSDR_WDU_0               (0x1UL << RTC_TSDR_WDU_Pos)               /*!< 0x00002000 */
#define RTC_TSDR_WDU_1               (0x2UL << RTC_TSDR_WDU_Pos)               /*!< 0x00004000 */
#define RTC_TSDR_WDU_2               (0x4UL << RTC_TSDR_WDU_Pos)               /*!< 0x00008000 */
#define RTC_TSDR_MT_Pos              (12U)
#define RTC_TSDR_MT_Msk              (0x1UL << RTC_TSDR_MT_Pos)                /*!< 0x00001000 */
#define RTC_TSDR_MT                  RTC_TSDR_MT_Msk
#define RTC_TSDR_MU_Pos              (8U)
#define RTC_TSDR_MU_Msk              (0xFUL << RTC_TSDR_MU_Pos)                /*!< 0x00000F00 */
#define RTC_TSDR_MU                  RTC_TSDR_MU_Msk
#define RTC_TSDR_MU_0                (0x1UL << RTC_TSDR_MU_Pos)                /*!< 0x00000100 */
#define RTC_TSDR_MU_1                (0x2UL << RTC_TSDR_MU_Pos)                /*!< 0x00000200 */
#define RTC_TSDR_MU_2                (0x4UL << RTC_TSDR_MU_Pos)                /*!< 0x00000400 */
#define RTC_TSDR_MU_3                (0x8UL << RTC_TSDR_MU_Pos)                /*!< 0x00000800 */
#define RTC_TSDR_DT_Pos              (4U)
#define RTC_TSDR_DT_Msk              (0x3UL << RTC_TSDR_DT_Pos)                /*!< 0x00000030 */
#define RTC_TSDR_DT                  RTC_TSDR_DT_Msk
#define RTC_TSDR_DT_0                (0x1UL << RTC_TSDR_DT_Pos)                /*!< 0x00000010 */
#define RTC_TSDR_DT_1                (0x2UL << RTC_TSDR_DT_Pos)                /*!< 0x00000020 */
#define RTC_TSDR_DU_Pos              (0U)
#define RTC_TSDR_DU_Msk              (0xFUL << RTC_TSDR_DU_Pos)                /*!< 0x0000000F */
#define RTC_TSDR_DU                  RTC_TSDR_DU_Msk
#define RTC_TSDR_DU_0                (0x1UL << RTC_TSDR_DU_Pos)                /*!< 0x00000001 */
#define RTC_TSDR_DU_1                (0x2UL << RTC_TSDR_DU_Pos)                /*!< 0x00000002 */
#define RTC_TSDR_DU_2                (0x4UL << RTC_TSDR_DU_Pos)                /*!< 0x00000004 */
#define RTC_TSDR_DU_3                (0x8UL << RTC_TSDR_DU_Pos)                /*!< 0x00000008 */

/********************  Bits definition for RTC_TSSSR register  ****************/
#define RTC_TSSSR_SS_Pos             (0U)
#define RTC_TSSSR_SS_Msk             (0xFFFFUL << RTC_TSSSR_SS_Pos)            /*!< 0x0000FFFF */
#define RTC_TSSSR_SS                 RTC_TSSSR_SS_Msk

/********************  Bits definition for RTC_ALRMAR register  ***************/
#define RTC_ALRMAR_MSK4_Pos          (31U)
#define RTC_ALRMAR_MSK4_Msk          (0x1UL << RTC_ALRMAR_MSK4_Pos)            /*!< 0x80000000 */
#define RTC_ALRMAR_MSK4              RTC_ALRMAR_MSK4_Msk
#define RTC_ALRMAR_WDSEL_Pos         (30U)
#define RTC_ALRMAR_WDSEL_Msk         (0x1UL << RTC_ALRMAR_WDSEL_Pos)           /*!< 0x40000000 */
#define RTC_ALRMAR_WDSEL             RTC_ALRMAR_WDSEL_Msk
#define RTC_ALRMAR_DT_Pos            (28U)
#define RTC_ALRMAR_DT_Msk            (0x3UL << RTC_ALRMAR_DT_Pos)              /*!< 0x30000000 */
#define RTC_ALRMAR_DT                RTC_ALRMAR_DT_Msk
#define RTC_ALRMAR_DT_0              (0x1UL << RTC_ALRMAR_DT_Pos)              /*!< 0x10000000 */
#define RTC_ALRMAR_DT_1              (0x2UL << RTC_ALRMAR_DT_Pos)              /*!< 0x20000000 */
#define RTC_ALRMAR_DU_Pos            (24U)
#define RTC_ALRMAR_DU_Msk            (0xFUL << RTC_ALRMAR_DU_Pos)              /*!< 0x0F000000 */
#define RTC_ALRMAR_DU                RTC_ALRMAR_DU_Msk
#define RTC_ALRMAR_DU_0              (0x1UL << RTC_ALRMAR_DU_Pos)              /*!< 0x01000000 */
#define RTC_ALRMAR_DU_1              (0x2UL << RTC_ALRMAR_DU_Pos)              /*!< 0x02000000 */
#define RTC_ALRMAR_DU_2              (0x4UL << RTC_ALRMAR_DU_Pos)              /*!< 0x04000000 */
#define RTC_ALRMAR_DU_3              (0x8UL << RTC_ALRMAR_DU_Pos)              /*!< 0x08000000 */
#define RTC_ALRMAR_MSK3_Pos          (23U)
#define RTC_ALRMAR_MSK3_Msk          (0x1UL << RTC_ALRMAR_MSK3_Pos)            /*!< 0x00800000 */
#define RTC_ALRMAR_MSK3              RTC_ALRMAR_MSK3_Msk
#define RTC_ALRMAR_PM_Pos            (22U)
#define RTC_ALRMAR_PM_Msk            (0x1UL << RTC_ALRMAR_PM_Pos)              /*!< 0x00400000 */
#define RTC_ALRMAR_PM                RTC_ALRMAR_PM_Msk
#define RTC_ALRMAR_HT_Pos            (20U)
#define RTC_ALRMAR_HT_Msk            (0x3UL << RTC_ALRMAR_HT_Pos)              /*!< 0x00300000 */
#define RTC_ALRMAR_HT                RTC_ALRMAR_HT_Msk
#define RTC_ALRMAR_HT_0              (0x1UL << RTC_ALRMAR_HT_Pos)              /*!< 0x00100000 */
#define RTC_ALRMAR_HT_1              (0x2UL << RTC_ALRMAR_HT_Pos)              /*!< 0x00200000 */
#define RTC_ALRMAR_HU_Pos            (16U)
#define RTC_ALRMAR_HU_Msk            (0xFUL << RTC_ALRMAR_HU_Pos)              /*!< 0x000F0000 */
#define RTC_ALRMAR_HU                RTC_ALRMAR_HU_Msk
#define RTC_ALRMAR_HU_0              (0x1UL << RTC_ALRMAR_HU_Pos)              /*!< 0x00010000 */
#define RTC_ALRMAR_HU_1              (0x2UL << RTC_ALRMAR_HU_Pos)              /*!< 0x00020000 */
#define RTC_ALRMAR_HU_2              (0x4UL << RTC_ALRMAR_HU_Pos)              /*!< 0x00040000 */
#define RTC_ALRMAR_HU_3              (0x8UL << RTC_ALRMAR_HU_Pos)              /*!< 0x00080000 */
#define RTC_ALRMAR_MSK2_Pos          (15U)
#define RTC_ALRMAR_MSK2_Msk          (0x1UL << RTC_ALRMAR_MSK2_Pos)            /*!< 0x00008000 */
#define RTC_ALRMAR_MSK2              RTC_ALRMAR_MSK2_Msk
#define RTC_ALRMAR_MNT_Pos           (12U)
#define RTC_ALRMAR_MNT_Msk           (0x7UL << RTC_ALRMAR_MNT_Pos)             /*!< 0x00007000 */
#define RTC_ALRMAR_MNT               RTC_ALRMAR_MNT_Msk
#define RTC_ALRMAR_MNT_0             (0x1UL << RTC_ALRMAR_MNT_Pos)             /*!< 0x00001000 */
#define RTC_ALRMAR_MNT_1             (0x2UL << RTC_ALRMAR_MNT_Pos)             /*!< 0x00002000 */
#define RTC_ALRMAR_MNT_2             (0x4UL << RTC_ALRMAR_MNT_Pos)             /*!< 0x00004000 */
#define RTC_ALRMAR_MNU_Pos           (8U)
#define RTC_ALRMAR_MNU_Msk           (0xFUL << RTC_ALRMAR_MNU_Pos)             /*!< 0x00000F00 */
#define RTC_ALRMAR_MNU               RTC_ALRMAR_MNU_Msk
#define RTC_ALRMAR_MNU_0             (0x1UL << RTC_ALRMAR_MNU_Pos)             /*!< 0x00000100 */
#define RTC_ALRMAR_MNU_1             (0x2UL << RTC_ALRMAR_MNU_Pos)             /*!< 0x00000200 */
#define RTC_ALRMAR_MNU_2             (0x4UL << RTC_ALRMAR_MNU_Pos)             /*!< 0x00000400 */
#define RTC_ALRMAR_MNU_3             (0x8UL << RTC_ALRMAR_MNU_Pos)             /*!< 0x00000800 */
#define RTC_ALRMAR_MSK1_Pos          (7U)
#define RTC_ALRMAR_MSK1_Msk          (0x1UL << RTC_ALRMAR_MSK1_Pos)            /*!< 0x00000080 */
#define RTC_ALRMAR_MSK1              RTC_ALRMAR_MSK1_Msk
#define RTC_ALRMAR_ST_Pos            (4U)
#define RTC_ALRMAR_ST_Msk            (0x7UL << RTC_ALRMAR_ST_Pos)              /*!< 0x00000070 */
#define RTC_ALRMAR_ST                RTC_ALRMAR_ST_Msk
#define RTC_ALRMAR_ST_0              (0x1UL << RTC_ALRMAR_ST_Pos)              /*!< 0x00000010 */
#define RTC_ALRMAR_ST_1              (0x2UL << RTC_ALRMAR_ST_Pos)              /*!< 0x00000020 */
#define RTC_ALRMAR_ST_2              (0x4UL << RTC_ALRMAR_ST_Pos)              /*!< 0x00000040 */
#define RTC_ALRMAR_SU_Pos            (0U)
#define RTC_ALRMAR_SU_Msk            (0xFUL << RTC_ALRMAR_SU_Pos)              /*!< 0x0000000F */
#define RTC_ALRMAR_SU                RTC_ALRMAR_SU_Msk
#define RTC_ALRMAR_SU_0              (0x1UL << RTC_ALRMAR_SU_Pos)              /*!< 0x00000001 */
#define RTC_ALRMAR_SU_1              (0x2UL << RTC_ALRMAR_SU_Pos)              /*!< 0x00000002 */
#define RTC_ALRMAR_SU_2              (0x4UL << RTC_ALRMAR_SU_Pos)              /*!< 0x00000004 */
#define RTC_ALRMAR_SU_3              (0x8UL << RTC_ALRMAR_SU_Pos)              /*!< 0x00000008 */

/********************  Bits definition for RTC_ALRMASSR register  *************/
#define RTC_ALRMASSR_MASKSS_Pos      (24U)
#define RTC_ALRMASSR_MASKSS_Msk      (0xFUL << RTC_ALRMASSR_MASKSS_Pos)        /*!< 0x0F000000 */
#define RTC_ALRMASSR_MASKSS          RTC_ALRMASSR_MASKSS_Msk
#define RTC_ALRMASSR_MASKSS_0        (0x1UL << RTC_ALRMASSR_MASKSS_Pos)        /*!< 0x01000000 */
#define RTC_ALRMASSR_MASKSS_1        (0x2UL << RTC_ALRMASSR_MASKSS_Pos)        /*!< 0x02000000 */
#define RTC_ALRMASSR_MASKSS_2        (0x4UL << RTC_ALRMASSR_MASKSS_Pos)        /*!< 0x04000000 */
#define RTC_ALRMASSR_MASKSS_3        (0x8UL << RTC_ALRMASSR_MASKSS_Pos)        /*!< 0x08000000 */
#define RTC_ALRMASSR_SS_Pos          (0U)
#define RTC_ALRMASSR_SS_Msk          (0x7FFFUL << RTC_ALRMASSR_SS_Pos)         /*!< 0x00007FFF */
#define RTC_ALRMASSR_SS              RTC_ALRMASSR_SS_Msk

/********************  Bits definition for RTC_ALRMBR register  ***************/
#define RTC_ALRMBR_MSK4_Pos          (31U)
#define RTC_ALRMBR_MSK4_Msk          (0x1UL << RTC_ALRMBR_MSK4_Pos)            /*!< 0x80000000 */
#define RTC_ALRMBR_MSK4              RTC_ALRMBR_MSK4_Msk
#define RTC_ALRMBR_WDSEL_Pos         (30U)
#define RTC_ALRMBR_WDSEL_Msk         (0x1UL << RTC_ALRMBR_WDSEL_Pos)           /*!< 0x40000000 */
#define RTC_ALRMBR_WDSEL             RTC_ALRMBR_WDSEL_Msk
#define RTC_ALRMBR_DT_Pos            (28U)
#define RTC_ALRMBR_DT_Msk            (0x3UL << RTC_ALRMBR_DT_Pos)              /*!< 0x30000000 */
#define RTC_ALRMBR_DT                RTC_ALRMBR_DT_Msk
#define RTC_ALRMBR_DT_0              (0x1UL << RTC_ALRMBR_DT_Pos)              /*!< 0x10000000 */
#define RTC_ALRMBR_DT_1              (0x2UL << RTC_ALRMBR_DT_Pos)              /*!< 0x20000000 */
#define RTC_ALRMBR_DU_Pos            (24U)
#define RTC_ALRMBR_DU_Msk            (0xFUL << RTC_ALRMBR_DU_Pos)              /*!< 0x0F000000 */
#define RTC_ALRMBR_DU                RTC_ALRMBR_DU_Msk
#define RTC_ALRMBR_DU_0              (0x1UL << RTC_ALRMBR_DU_Pos)              /*!< 0x01000000 */
#define RTC_ALRMBR_DU_1              (0x2UL << RTC_ALRMBR_DU_Pos)              /*!< 0x02000000 */
#define RTC_ALRMBR_DU_2              (0x4UL << RTC_ALRMBR_DU_Pos)              /*!< 0x04000000 */
#define RTC_ALRMBR_DU_3              (0x8UL << RTC_ALRMBR_DU_Pos)              /*!< 0x08000000 */
#define RTC_ALRMBR_MSK3_Pos          (23U)
#define RTC_ALRMBR_MSK3_Msk          (0x1UL << RTC_ALRMBR_MSK3_Pos)            /*!< 0x00800000 */
#define RTC_ALRMBR_MSK3              RTC_ALRMBR_MSK3_Msk
#define RTC_ALRMBR_PM_Pos            (22U)
#define RTC_ALRMBR_PM_Msk            (0x1UL << RTC_ALRMBR_PM_Pos)              /*!< 0x00400000 */
#define RTC_ALRMBR_PM                RTC_ALRMBR_PM_Msk
#define RTC_ALRMBR_HT_Pos            (20U)
#define RTC_ALRMBR_HT_Msk            (0x3UL << RTC_ALRMBR_HT_Pos)              /*!< 0x00300000 */
#define RTC_ALRMBR_HT                RTC_ALRMBR_HT_Msk
#define RTC_ALRMBR_HT_0              (0x1UL << RTC_ALRMBR_HT_Pos)              /*!< 0x00100000 */
#define RTC_ALRMBR_HT_1              (0x2UL << RTC_ALRMBR_HT_Pos)              /*!< 0x00200000 */
#define RTC_ALRMBR_HU_Pos            (16U)
#define RTC_ALRMBR_HU_Msk            (0xFUL << RTC_ALRMBR_HU_Pos)              /*!< 0x000F0000 */
#define RTC_ALRMBR_HU                RTC_ALRMBR_HU_Msk
#define RTC_ALRMBR_HU_0              (0x1UL << RTC_ALRMBR_HU_Pos)              /*!< 0x00010000 */
#define RTC_ALRMBR_HU_1              (0x2UL << RTC_ALRMBR_HU_Pos)              /*!< 0x00020000 */
#define RTC_ALRMBR_HU_2              (0x4UL << RTC_ALRMBR_HU_Pos)              /*!< 0x00040000 */
#define RTC_ALRMBR_HU_3              (0x8UL << RTC_ALRMBR_HU_Pos)              /*!< 0x00080000 */
#define RTC_ALRMBR_MSK2_Pos          (15U)
#define RTC_ALRMBR_MSK2_Msk          (0x1UL << RTC_ALRMBR_MSK2_Pos)            /*!< 0x00008000 */
#define RTC_ALRMBR_MSK2              RTC_ALRMBR_MSK2_Msk
#define RTC_ALRMBR_MNT_Pos           (12U)
#define RTC_ALRMBR_MNT_Msk           (0x7UL << RTC_ALRMBR_MNT_Pos)             /*!< 0x00007000 */
#define RTC_ALRMBR_MNT               RTC_ALRMBR_MNT_Msk
#define RTC_ALRMBR_MNT_0             (0x1UL << RTC_ALRMBR_MNT_Pos)             /*!< 0x00001000 */
#define RTC_ALRMBR_MNT_1             (0x2UL << RTC_ALRMBR_MNT_Pos)             /*!< 0x00002000 */
#define RTC_ALRMBR_MNT_2             (0x4UL << RTC_ALRMBR_MNT_Pos)             /*!< 0x00004000 */
#define RTC_ALRMBR_MNU_Pos           (8U)
#define RTC_ALRMBR_MNU_Msk           (0xFUL << RTC_ALRMBR_MNU_Pos)             /*!< 0x00000F00 */
#define RTC_ALRMBR_MNU               RTC_ALRMBR_MNU_Msk
#define RTC_ALRMBR_MNU_0             (0x1UL << RTC_ALRMBR_MNU_Pos)             /*!< 0x00000100 */
#define RTC_ALRMBR_MNU_1             (0x2UL << RTC_ALRMBR_MNU_Pos)             /*!< 0x00000200 */
#define RTC_ALRMBR_MNU_2             (0x4UL << RTC_ALRMBR_MNU_Pos)             /*!< 0x00000400 */
#define RTC_ALRMBR_MNU_3             (0x8UL << RTC_ALRMBR_MNU_Pos)             /*!< 0x00000800 */
#define RTC_ALRMBR_MSK1_Pos          (7U)
#define RTC_ALRMBR_MSK1_Msk          (0x1UL << RTC_ALRMBR_MSK1_Pos)            /*!< 0x00000080 */
#define RTC_ALRMBR_MSK1              RTC_ALRMBR_MSK1_Msk
#define RTC_ALRMBR_ST_Pos            (4U)
#define RTC_ALRMBR_ST_Msk            (0x7UL << RTC_ALRMBR_ST_Pos)              /*!< 0x00000070 */
#define RTC_ALRMBR_ST                RTC_ALRMBR_ST_Msk
#define RTC_ALRMBR_ST_0              (0x1UL << RTC_ALRMBR_ST_Pos)              /*!< 0x00000010 */
#define RTC_ALRMBR_ST_1              (0x2UL << RTC_ALRMBR_ST_Pos)              /*!< 0x00000020 */
#define RTC_ALRMBR_ST_2              (0x4UL << RTC_ALRMBR_ST_Pos)              /*!< 0x00000040 */
#define RTC_ALRMBR_SU_Pos            (0U)
#define RTC_ALRMBR_SU_Msk            (0xFUL << RTC_ALRMBR_SU_Pos)              /*!< 0x0000000F */
#define RTC_ALRMBR_SU                RTC_ALRMBR_SU_Msk
#define RTC_ALRMBR_SU_0              (0x1UL << RTC_ALRMBR_SU_Pos)              /*!< 0x00000001 */
#define RTC_ALRMBR_SU_1              (0x2UL << RTC_ALRMBR_SU_Pos)              /*!< 0x00000002 */
#define RTC_ALRMBR_SU_2              (0x4UL << RTC_ALRMBR_SU_Pos)              /*!< 0x00000004 */
#define RTC_ALRMBR_SU_3              (0x8UL << RTC_ALRMBR_SU_Pos)              /*!< 0x00000008 */

/********************  Bits definition for RTC_ALRMBSSR register  *************/
#define RTC_ALRMBSSR_MASKSS_Pos      (24U)
#define RTC_ALRMBSSR_MASKSS_Msk      (0xFUL << RTC_ALRMBSSR_MASKSS_Pos)        /*!< 0x0F000000 */
#define RTC_ALRMBSSR_MASKSS          RTC_ALRMBSSR_MASKSS_Msk
#define RTC_ALRMBSSR_MASKSS_0        (0x1UL << RTC_ALRMBSSR_MASKSS_Pos)        /*!< 0x01000000 */
#define RTC_ALRMBSSR_MASKSS_1        (0x2UL << RTC_ALRMBSSR_MASKSS_Pos)        /*!< 0x02000000 */
#define RTC_ALRMBSSR_MASKSS_2        (0x4UL << RTC_ALRMBSSR_MASKSS_Pos)        /*!< 0x04000000 */
#define RTC_ALRMBSSR_MASKSS_3        (0x8UL << RTC_ALRMBSSR_MASKSS_Pos)        /*!< 0x08000000 */
#define RTC_ALRMBSSR_SS_Pos          (0U)
#define RTC_ALRMBSSR_SS_Msk          (0x7FFFUL << RTC_ALRMBSSR_SS_Pos)         /*!< 0x00007FFF */
#define RTC_ALRMBSSR_SS              RTC_ALRMBSSR_SS_Msk

/********************  Bits definition for RTC_SR register  *******************/
#define RTC_SR_ITSF_Pos              (5U)
#define RTC_SR_ITSF_Msk              (0x1UL << RTC_SR_ITSF_Pos)                /*!< 0x00000020 */
#define RTC_SR_ITSF                  RTC_SR_ITSF_Msk
#define RTC_SR_TSOVF_Pos             (4U)
#define RTC_SR_TSOVF_Msk             (0x1UL << RTC_SR_TSOVF_Pos)               /*!< 0x00000010 */
#define RTC_SR_TSOVF                 RTC_SR_TSOVF_Msk
#define RTC_SR_TSF_Pos               (3U)
#define RTC_SR_TSF_Msk               (0x1UL << RTC_SR_TSF_Pos)                 /*!< 0x00000008 */
#define RTC_SR_TSF                   RTC_SR_TSF_Msk
#define RTC_SR_WUTF_Pos              (2U)
#define RTC_SR_WUTF_Msk              (0x1UL << RTC_SR_WUTF_Pos)                /*!< 0x00000004 */
#define RTC_SR_WUTF                  RTC_SR_WUTF_Msk
#define RTC_SR_ALRBF_Pos             (1U)
#define RTC_SR_ALRBF_Msk             (0x1UL << RTC_SR_ALRBF_Pos)               /*!< 0x00000002 */
#define RTC_SR_ALRBF                 RTC_SR_ALRBF_Msk
#define RTC_SR_ALRAF_Pos             (0U)
#define RTC_SR_ALRAF_Msk             (0x1UL << RTC_SR_ALRAF_Pos)               /*!< 0x00000001 */
#define RTC_SR_ALRAF                 RTC_SR_ALRAF_Msk

/********************  Bits definition for RTC_MISR register  *****************/
#define RTC_MISR_ITSMF_Pos           (5U)
#define RTC_MISR_ITSMF_Msk           (0x1UL << RTC_MISR_ITSMF_Pos)             /*!< 0x00000020 */
#define RTC_MISR_ITSMF               RTC_MISR_ITSMF_Msk
#define RTC_MISR_TSOVMF_Pos          (4U)
#define RTC_MISR_TSOVMF_Msk          (0x1UL << RTC_MISR_TSOVMF_Pos)            /*!< 0x00000010 */
#define RTC_MISR_TSOVMF              RTC_MISR_TSOVMF_Msk
#define RTC_MISR_TSMF_Pos            (3U)
#define RTC_MISR_TSMF_Msk            (0x1UL << RTC_MISR_TSMF_Pos)              /*!< 0x00000008 */
#define RTC_MISR_TSMF                RTC_MISR_TSMF_Msk
#define RTC_MISR_WUTMF_Pos           (2U)
#define RTC_MISR_WUTMF_Msk           (0x1UL << RTC_MISR_WUTMF_Pos)             /*!< 0x00000004 */
#define RTC_MISR_WUTMF               RTC_MISR_WUTMF_Msk
#define RTC_MISR_ALRBMF_Pos          (1U)
#define RTC_MISR_ALRBMF_Msk          (0x1UL << RTC_MISR_ALRBMF_Pos)            /*!< 0x00000002 */
#define RTC_MISR_ALRBMF              RTC_MISR_ALRBMF_Msk
#define RTC_MISR_ALRAMF_Pos          (0U)
#define RTC_MISR_ALRAMF_Msk          (0x1UL << RTC_MISR_ALRAMF_Pos)            /*!< 0x00000001 */
#define RTC_MISR_ALRAMF              RTC_MISR_ALRAMF_Msk

/********************  Bits definition for RTC_SMISR register  *****************/
#define RTC_SMISR_ITSMF_Pos          (5U)
#define RTC_SMISR_ITSMF_Msk          (0x1UL << RTC_SMISR_ITSMF_Pos)            /*!< 0x00000020 */
#define RTC_SMISR_ITSMF              RTC_SMISR_ITSMF_Msk
#define RTC_SMISR_TSOVMF_Pos         (4U)
#define RTC_SMISR_TSOVMF_Msk         (0x1UL << RTC_SMISR_TSOVMF_Pos)           /*!< 0x00000010 */
#define RTC_SMISR_TSOVMF             RTC_SMISR_TSOVMF_Msk
#define RTC_SMISR_TSMF_Pos           (3U)
#define RTC_SMISR_TSMF_Msk           (0x1UL << RTC_SMISR_TSMF_Pos)             /*!< 0x00000008 */
#define RTC_SMISR_TSMF               RTC_SMISR_TSMF_Msk
#define RTC_SMISR_WUTMF_Pos          (2U)
#define RTC_SMISR_WUTMF_Msk          (0x1UL << RTC_SMISR_WUTMF_Pos)            /*!< 0x00000004 */
#define RTC_SMISR_WUTMF              RTC_SMISR_WUTMF_Msk
#define RTC_SMISR_ALRBMF_Pos         (1U)
#define RTC_SMISR_ALRBMF_Msk         (0x1UL << RTC_SMISR_ALRBMF_Pos)           /*!< 0x00000002 */
#define RTC_SMISR_ALRBMF             RTC_SMISR_ALRBMF_Msk
#define RTC_SMISR_ALRAMF_Pos         (0U)
#define RTC_SMISR_ALRAMF_Msk         (0x1UL << RTC_SMISR_ALRAMF_Pos)           /*!< 0x00000001 */
#define RTC_SMISR_ALRAMF             RTC_SMISR_ALRAMF_Msk

/********************  Bits definition for RTC_SCR register  ******************/
#define RTC_SCR_CITSF_Pos            (5U)
#define RTC_SCR_CITSF_Msk            (0x1UL << RTC_SCR_CITSF_Pos)              /*!< 0x00000020 */
#define RTC_SCR_CITSF                RTC_SCR_CITSF_Msk
#define RTC_SCR_CTSOVF_Pos           (4U)
#define RTC_SCR_CTSOVF_Msk           (0x1UL << RTC_SCR_CTSOVF_Pos)             /*!< 0x00000010 */
#define RTC_SCR_CTSOVF               RTC_SCR_CTSOVF_Msk
#define RTC_SCR_CTSF_Pos             (3U)
#define RTC_SCR_CTSF_Msk             (0x1UL << RTC_SCR_CTSF_Pos)               /*!< 0x00000008 */
#define RTC_SCR_CTSF                 RTC_SCR_CTSF_Msk
#define RTC_SCR_CWUTF_Pos            (2U)
#define RTC_SCR_CWUTF_Msk            (0x1UL << RTC_SCR_CWUTF_Pos)              /*!< 0x00000004 */
#define RTC_SCR_CWUTF                RTC_SCR_CWUTF_Msk
#define RTC_SCR_CALRBF_Pos           (1U)
#define RTC_SCR_CALRBF_Msk           (0x1UL << RTC_SCR_CALRBF_Pos)             /*!< 0x00000002 */
#define RTC_SCR_CALRBF               RTC_SCR_CALRBF_Msk
#define RTC_SCR_CALRAF_Pos           (0U)
#define RTC_SCR_CALRAF_Msk           (0x1UL << RTC_SCR_CALRAF_Pos)             /*!< 0x00000001 */
#define RTC_SCR_CALRAF               RTC_SCR_CALRAF_Msk


/******************************************************************************/
/*                                                                            */
/*                        Serial Peripheral Interface (SPI)                   */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for SPI_CR1 register  ********************/
#define SPI_CR1_CPHA_Pos            (0U)
#define SPI_CR1_CPHA_Msk            (0x1UL << SPI_CR1_CPHA_Pos)                /*!< 0x00000001 */
#define SPI_CR1_CPHA                SPI_CR1_CPHA_Msk                           /*!<Clock Phase      */
#define SPI_CR1_CPOL_Pos            (1U)
#define SPI_CR1_CPOL_Msk            (0x1UL << SPI_CR1_CPOL_Pos)                /*!< 0x00000002 */
#define SPI_CR1_CPOL                SPI_CR1_CPOL_Msk                           /*!<Clock Polarity   */
#define SPI_CR1_MSTR_Pos            (2U)
#define SPI_CR1_MSTR_Msk            (0x1UL << SPI_CR1_MSTR_Pos)                /*!< 0x00000004 */
#define SPI_CR1_MSTR                SPI_CR1_MSTR_Msk                           /*!<Master Selection */

#define SPI_CR1_BR_Pos              (3U)
#define SPI_CR1_BR_Msk              (0x7UL << SPI_CR1_BR_Pos)                  /*!< 0x00000038 */
#define SPI_CR1_BR                  SPI_CR1_BR_Msk                             /*!<BR[2:0] bits (Baud Rate Control) */
#define SPI_CR1_BR_0                (0x1UL << SPI_CR1_BR_Pos)                  /*!< 0x00000008 */
#define SPI_CR1_BR_1                (0x2UL << SPI_CR1_BR_Pos)                  /*!< 0x00000010 */
#define SPI_CR1_BR_2                (0x4UL << SPI_CR1_BR_Pos)                  /*!< 0x00000020 */

#define SPI_CR1_SPE_Pos             (6U)
#define SPI_CR1_SPE_Msk             (0x1UL << SPI_CR1_SPE_Pos)                 /*!< 0x00000040 */
#define SPI_CR1_SPE                 SPI_CR1_SPE_Msk                            /*!<SPI Enable                          */
#define SPI_CR1_LSBFIRST_Pos        (7U)
#define SPI_CR1_LSBFIRST_Msk        (0x1UL << SPI_CR1_LSBFIRST_Pos)            /*!< 0x00000080 */
#define SPI_CR1_LSBFIRST            SPI_CR1_LSBFIRST_Msk                       /*!<Frame Format                        */
#define SPI_CR1_SSI_Pos             (8U)
#define SPI_CR1_SSI_Msk             (0x1UL << SPI_CR1_SSI_Pos)                 /*!< 0x00000100 */
#define SPI_CR1_SSI                 SPI_CR1_SSI_Msk                            /*!<Internal slave select               */
#define SPI_CR1_SSM_Pos             (9U)
#define SPI_CR1_SSM_Msk             (0x1UL << SPI_CR1_SSM_Pos)                 /*!< 0x00000200 */
#define SPI_CR1_SSM                 SPI_CR1_SSM_Msk                            /*!<Software slave management           */
#define SPI_CR1_RXONLY_Pos          (10U)
#define SPI_CR1_RXONLY_Msk          (0x1UL << SPI_CR1_RXONLY_Pos)              /*!< 0x00000400 */
#define SPI_CR1_RXONLY              SPI_CR1_RXONLY_Msk                         /*!<Receive only                        */
#define SPI_CR1_CRCL_Pos            (11U)
#define SPI_CR1_CRCL_Msk            (0x1UL << SPI_CR1_CRCL_Pos)                /*!< 0x00000800 */
#define SPI_CR1_CRCL                SPI_CR1_CRCL_Msk                           /*!< CRC Length */
#define SPI_CR1_CRCNEXT_Pos         (12U)
#define SPI_CR1_CRCNEXT_Msk         (0x1UL << SPI_CR1_CRCNEXT_Pos)             /*!< 0x00001000 */
#define SPI_CR1_CRCNEXT             SPI_CR1_CRCNEXT_Msk                        /*!<Transmit CRC next                   */
#define SPI_CR1_CRCEN_Pos           (13U)
#define SPI_CR1_CRCEN_Msk           (0x1UL << SPI_CR1_CRCEN_Pos)               /*!< 0x00002000 */
#define SPI_CR1_CRCEN               SPI_CR1_CRCEN_Msk                          /*!<Hardware CRC calculation enable     */
#define SPI_CR1_BIDIOE_Pos          (14U)
#define SPI_CR1_BIDIOE_Msk          (0x1UL << SPI_CR1_BIDIOE_Pos)              /*!< 0x00004000 */
#define SPI_CR1_BIDIOE              SPI_CR1_BIDIOE_Msk                         /*!<Output enable in bidirectional mode */
#define SPI_CR1_BIDIMODE_Pos        (15U)
#define SPI_CR1_BIDIMODE_Msk        (0x1UL << SPI_CR1_BIDIMODE_Pos)            /*!< 0x00008000 */
#define SPI_CR1_BIDIMODE            SPI_CR1_BIDIMODE_Msk                       /*!<Bidirectional data mode enable      */

/*******************  Bit definition for SPI_CR2 register  ********************/
#define SPI_CR2_RXDMAEN_Pos         (0U)
#define SPI_CR2_RXDMAEN_Msk         (0x1UL << SPI_CR2_RXDMAEN_Pos)             /*!< 0x00000001 */
#define SPI_CR2_RXDMAEN             SPI_CR2_RXDMAEN_Msk                        /*!< Rx Buffer DMA Enable */
#define SPI_CR2_TXDMAEN_Pos         (1U)
#define SPI_CR2_TXDMAEN_Msk         (0x1UL << SPI_CR2_TXDMAEN_Pos)             /*!< 0x00000002 */
#define SPI_CR2_TXDMAEN             SPI_CR2_TXDMAEN_Msk                        /*!< Tx Buffer DMA Enable */
#define SPI_CR2_SSOE_Pos            (2U)
#define SPI_CR2_SSOE_Msk            (0x1UL << SPI_CR2_SSOE_Pos)                /*!< 0x00000004 */
#define SPI_CR2_SSOE                SPI_CR2_SSOE_Msk                           /*!< SS Output Enable */
#define SPI_CR2_NSSP_Pos            (3U)
#define SPI_CR2_NSSP_Msk            (0x1UL << SPI_CR2_NSSP_Pos)                /*!< 0x00000008 */
#define SPI_CR2_NSSP                SPI_CR2_NSSP_Msk                           /*!< NSS pulse management Enable */
#define SPI_CR2_FRF_Pos             (4U)
#define SPI_CR2_FRF_Msk             (0x1UL << SPI_CR2_FRF_Pos)                 /*!< 0x00000010 */
#define SPI_CR2_FRF                 SPI_CR2_FRF_Msk                            /*!< Frame Format Enable */
#define SPI_CR2_ERRIE_Pos           (5U)
#define SPI_CR2_ERRIE_Msk           (0x1UL << SPI_CR2_ERRIE_Pos)               /*!< 0x00000020 */
#define SPI_CR2_ERRIE               SPI_CR2_ERRIE_Msk                          /*!< Error Interrupt Enable */
#define SPI_CR2_RXNEIE_Pos          (6U)
#define SPI_CR2_RXNEIE_Msk          (0x1UL << SPI_CR2_RXNEIE_Pos)              /*!< 0x00000040 */
#define SPI_CR2_RXNEIE              SPI_CR2_RXNEIE_Msk                         /*!< RX buffer Not Empty Interrupt Enable */
#define SPI_CR2_TXEIE_Pos           (7U)
#define SPI_CR2_TXEIE_Msk           (0x1UL << SPI_CR2_TXEIE_Pos)               /*!< 0x00000080 */
#define SPI_CR2_TXEIE               SPI_CR2_TXEIE_Msk                          /*!< Tx buffer Empty Interrupt Enable */
#define SPI_CR2_DS_Pos              (8U)
#define SPI_CR2_DS_Msk              (0xFUL << SPI_CR2_DS_Pos)                  /*!< 0x00000F00 */
#define SPI_CR2_DS                  SPI_CR2_DS_Msk                             /*!< DS[3:0] Data Size */
#define SPI_CR2_DS_0                (0x1UL << SPI_CR2_DS_Pos)                  /*!< 0x00000100 */
#define SPI_CR2_DS_1                (0x2UL << SPI_CR2_DS_Pos)                  /*!< 0x00000200 */
#define SPI_CR2_DS_2                (0x4UL << SPI_CR2_DS_Pos)                  /*!< 0x00000400 */
#define SPI_CR2_DS_3                (0x8UL << SPI_CR2_DS_Pos)                  /*!< 0x00000800 */
#define SPI_CR2_FRXTH_Pos           (12U)
#define SPI_CR2_FRXTH_Msk           (0x1UL << SPI_CR2_FRXTH_Pos)               /*!< 0x00001000 */
#define SPI_CR2_FRXTH               SPI_CR2_FRXTH_Msk                          /*!< FIFO reception Threshold */
#define SPI_CR2_LDMARX_Pos          (13U)
#define SPI_CR2_LDMARX_Msk          (0x1UL << SPI_CR2_LDMARX_Pos)              /*!< 0x00002000 */
#define SPI_CR2_LDMARX              SPI_CR2_LDMARX_Msk                         /*!< Last DMA transfer for reception */
#define SPI_CR2_LDMATX_Pos          (14U)
#define SPI_CR2_LDMATX_Msk          (0x1UL << SPI_CR2_LDMATX_Pos)              /*!< 0x00004000 */
#define SPI_CR2_LDMATX              SPI_CR2_LDMATX_Msk                         /*!< Last DMA transfer for transmission */

/********************  Bit definition for SPI_SR register  ********************/
#define SPI_SR_RXNE_Pos             (0U)
#define SPI_SR_RXNE_Msk             (0x1UL << SPI_SR_RXNE_Pos)                 /*!< 0x00000001 */
#define SPI_SR_RXNE                 SPI_SR_RXNE_Msk                            /*!< Receive buffer Not Empty */
#define SPI_SR_TXE_Pos              (1U)
#define SPI_SR_TXE_Msk              (0x1UL << SPI_SR_TXE_Pos)                  /*!< 0x00000002 */
#define SPI_SR_TXE                  SPI_SR_TXE_Msk                             /*!< Transmit buffer Empty */
#define SPI_SR_CRCERR_Pos           (4U)
#define SPI_SR_CRCERR_Msk           (0x1UL << SPI_SR_CRCERR_Pos)               /*!< 0x00000010 */
#define SPI_SR_CRCERR               SPI_SR_CRCERR_Msk                          /*!< CRC Error flag */
#define SPI_SR_MODF_Pos             (5U)
#define SPI_SR_MODF_Msk             (0x1UL << SPI_SR_MODF_Pos)                 /*!< 0x00000020 */
#define SPI_SR_MODF                 SPI_SR_MODF_Msk                            /*!< Mode fault */
#define SPI_SR_OVR_Pos              (6U)
#define SPI_SR_OVR_Msk              (0x1UL << SPI_SR_OVR_Pos)                  /*!< 0x00000040 */
#define SPI_SR_OVR                  SPI_SR_OVR_Msk                             /*!< Overrun flag */
#define SPI_SR_BSY_Pos              (7U)
#define SPI_SR_BSY_Msk              (0x1UL << SPI_SR_BSY_Pos)                  /*!< 0x00000080 */
#define SPI_SR_BSY                  SPI_SR_BSY_Msk                             /*!< Busy flag */
#define SPI_SR_FRE_Pos              (8U)
#define SPI_SR_FRE_Msk              (0x1UL << SPI_SR_FRE_Pos)                  /*!< 0x00000100 */
#define SPI_SR_FRE                  SPI_SR_FRE_Msk                             /*!< TI frame format error */
#define SPI_SR_FRLVL_Pos            (9U)
#define SPI_SR_FRLVL_Msk            (0x3UL << SPI_SR_FRLVL_Pos)                /*!< 0x00000600 */
#define SPI_SR_FRLVL                SPI_SR_FRLVL_Msk                           /*!< FIFO Reception Level */
#define SPI_SR_FRLVL_0              (0x1UL << SPI_SR_FRLVL_Pos)                /*!< 0x00000200 */
#define SPI_SR_FRLVL_1              (0x2UL << SPI_SR_FRLVL_Pos)                /*!< 0x00000400 */
#define SPI_SR_FTLVL_Pos            (11U)
#define SPI_SR_FTLVL_Msk            (0x3UL << SPI_SR_FTLVL_Pos)                /*!< 0x00001800 */
#define SPI_SR_FTLVL                SPI_SR_FTLVL_Msk                           /*!< FIFO Transmission Level */
#define SPI_SR_FTLVL_0              (0x1UL << SPI_SR_FTLVL_Pos)                /*!< 0x00000800 */
#define SPI_SR_FTLVL_1              (0x2UL << SPI_SR_FTLVL_Pos)                /*!< 0x00001000 */

/********************  Bit definition for SPI_DR register  ********************/
#define SPI_DR_DR_Pos               (0U)
#define SPI_DR_DR_Msk               (0xFFFFUL << SPI_DR_DR_Pos)                /*!< 0x0000FFFF */
#define SPI_DR_DR                   SPI_DR_DR_Msk                              /*!<Data Register           */

/*******************  Bit definition for SPI_CRCPR register  ******************/
#define SPI_CRCPR_CRCPOLY_Pos       (0U)
#define SPI_CRCPR_CRCPOLY_Msk       (0xFFFFUL << SPI_CRCPR_CRCPOLY_Pos)        /*!< 0x0000FFFF */
#define SPI_CRCPR_CRCPOLY           SPI_CRCPR_CRCPOLY_Msk                      /*!<CRC polynomial register */

/******************  Bit definition for SPI_RXCRCR register  ******************/
#define SPI_RXCRCR_RXCRC_Pos        (0U)
#define SPI_RXCRCR_RXCRC_Msk        (0xFFFFUL << SPI_RXCRCR_RXCRC_Pos)         /*!< 0x0000FFFF */
#define SPI_RXCRCR_RXCRC            SPI_RXCRCR_RXCRC_Msk                       /*!<Rx CRC Register         */

/******************  Bit definition for SPI_TXCRCR register  ******************/
#define 