/****************************************************************************
 *
 * Copyright 2020 Samsung Electronics All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 *
 ****************************************************************************/

#ifndef MBED_CMSIS_H
#define MBED_CMSIS_H

#include "s5js100.h"
#include "s5js100_type.h"
#include "s5js100_rtos.h"
/* s5js100 System Core */
#include "system_s5js100.h"
#include "system_core_s5js100.h"
/* s5js100 System Clock */
#include "s5js100_cmu.h"
#include "s5js100_vclk.h"
/* Embedded Flash Driver */
#include "sflash_api.h"
/* s5js100 Power */
#include "s5js100_pwr.h"
/* NVIC Driver */
#include "cmsis_nvic.h"
/* System Core Version */
#include "system_core_version.h"
/* HAL implementation */
#include "s5js100_hal.h"

#endif
