/****************************************************************************
 *
 * Copyright 2020 Samsung Electronics All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 *
 ****************************************************************************/

#ifndef __S5JS100_PMUSFR_H__
#define __S5JS100_PMUSFR_H__

#define PMU_ALIVE_BASE  (0x81000000)
#define PMU_SYS_BASE    (0x82020000)
#define PMU_MCPU_BASE   (0x84014000)
#define SYS_CFG_BASE    (0x85040000)
#define BAAW_BASE       (0x85010000)

#define PMU_ALIVE_BACKUP0   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0000))
#define PMU_ALIVE_BACKUP1   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0004))
#define PMU_ALIVE_BACKUP2   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0008))
#define PMU_ALIVE_BACKUP3   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x000c))
#define PMU_ALIVE_SYSOFF    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x001c))
#define PMU_ALIVE_SILENTRST ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0020))
#define PMU_ALIVE_BOOTFLAG  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0030))
#define PMU_ALIVE_IDSSUPPORT    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0034))
#define PMU_ALIVE_IORET ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0038))
#define PMU_ALIVE_TCXODCXOSEL   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x003c))
#define PMU_ALIVE_WKUPSRCEN ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0040))
#define PMU_ALIVE_WKUPSRCRAWSTS ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0044))
#define PMU_ALIVE_WKUPINTSNAPSHOT   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0048))
#define PMU_ALIVE_ALVSYSCTRLCFG ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0050))
#define PMU_ALIVE_ALVSYSCTRL_FSMBYPASS  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0054))
#define PMU_ALIVE_PMIPCTRL_ONTIMING ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0060))
#define PMU_ALIVE_PMIPCTRL_OFFTIMING    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0064))
#define PMU_ALIVE_PMIPCTRL_OVRD ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0068))
#define PMU_ALIVE_DCXOCTRL_CFG0 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0070))
#define PMU_ALIVE_TEMPMON_CFG0  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0080))
#define PMU_ALIVE_TEMPMON_CFG1  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0084))
#define PMU_ALIVE_TEMPMON_CFG2  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0088))
#define PMU_ALIVE_TEMPMON_CFG3  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x008c))
#define PMU_ALIVE_TSUINT    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0090))
#define PMU_ALIVE_SLPCLK_CFG    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00a0))
#define PMU_ALIVE_DCXODIV_CFG   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00a4))
#define PMU_ALIVE_RECALC_CFG0   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00b0))
#define PMU_ALIVE_RECALC_CFG1   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00b4))
#define PMU_ALIVE_RECALC_CFG2   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00b8))
#define PMU_ALIVE_RECALC_CFG3   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00bc))
#define PMU_ALIVE_RECALC_STS    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00c0))
#define PMU_ALIVE_NSLEEP_CFG    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00e0))
#define PMU_ALIVE_NSLEEP_STS0   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00e4))
#define PMU_ALIVE_NSLEEP_STS1   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00e8))
#define PMU_ALIVE_GPIOALV0CTRL  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00f0))
#define PMU_ALIVE_GPIOALV1CTRL  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00f4))
#define PMU_ALIVE_XTALPADCTRL   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x00f8))
#define PMU_ALIVE_APSLPCNT_CFG0 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0100))
#define PMU_ALIVE_APSLPCNT_CFG1 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0104))
#define PMU_ALIVE_APSLPCNT_CFG2 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0108))
#define PMU_ALIVE_APSLPCNT_CFG3 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x010c))
#define PMU_ALIVE_APSLPCNT_CFG4 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0110))
#define PMU_ALIVE_PROFILERCTRL  ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0400))
#define PMU_ALIVE_SYSCTRLFSM    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0404))
#define PMU_ALIVE_DCGOVRD   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0460))
#define PMU_ALIVE_PMIP_BUCK1_CFG0   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0500))
#define PMU_ALIVE_PMIP_BUCK1_CFG1   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0504))
#define PMU_ALIVE_PMIP_DBB10_LDO    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0508))
#define PMU_ALIVE_PMIP_DCXO_LDO ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x050c))
#define PMU_ALIVE_PMIP_MPBGR_LDO    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0510))
#define PMU_ALIVE_PMIP_LP_LDO   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0514))
#define PMU_ALIVE_PMIP_TCXO_LDO ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0518))
#define PMU_ALIVE_DCXO_CFG0 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0520))
#define PMU_ALIVE_DCXO_CFG1 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0524))
#define PMU_ALIVE_DCXO_CFG2 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0528))
#define PMU_ALIVE_DCXO_CFG3 ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x052c))
#define PMU_ALIVE_ROTSU_CFG0    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0530))
#define PMU_ALIVE_ROTSU_CFG1    ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0534))
#define PMU_ALIVE_RCO_CFG   ((volatile unsigned int *)(PMU_ALIVE_BASE + 0x0540))

#define PMU_SYS_SYSCTRL_SYSOFF  ((volatile unsigned int *)(PMU_SYS_BASE + 0x0000))
#define PMU_SYS_ACPUCTRL_CFG0   ((volatile unsigned int *)(PMU_SYS_BASE + 0x0010))
#define PMU_SYS_ACPUCTRL_FSMBYPASS  ((volatile unsigned int *)(PMU_SYS_BASE + 0x0014))
#define PMU_SYS_RSTDUMPCTRL ((volatile unsigned int *)(PMU_SYS_BASE + 0x0018))
#define PMU_SYS_RCOCOPIER   ((volatile unsigned int *)(PMU_SYS_BASE + 0x0030))
#define PMU_SYS_CMU_SYS_PMLINKDATA0 ((volatile unsigned int *)(PMU_SYS_BASE + 0x0084))
#define PMU_SYS_CMU_SYS_PMLINKDATA1 ((volatile unsigned int *)(PMU_SYS_BASE + 0x0088))
#define PMU_SYS_CMU_ACPU_PMLINKDATA0    ((volatile unsigned int *)(PMU_SYS_BASE + 0x008c))
#define PMU_SYS_CMU_ACPU_PMLINKDATA1    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0090))
#define PMU_SYS_CMU_MIF_PMLINKDATA0 ((volatile unsigned int *)(PMU_SYS_BASE + 0x0094))
#define PMU_SYS_CMU_MIF_PMLINKDATA1 ((volatile unsigned int *)(PMU_SYS_BASE + 0x0098))
#define PMU_SYS_LH_PSTATE   ((volatile unsigned int *)(PMU_SYS_BASE + 0x0100))
#define PMU_SYS_LH_PREQ ((volatile unsigned int *)(PMU_SYS_BASE + 0x0104))
#define PMU_SYS_LH_PACCEPT  ((volatile unsigned int *)(PMU_SYS_BASE + 0x0108))
#define PMU_SYS_PASMASK ((volatile unsigned int *)(PMU_SYS_BASE + 0x0110))
#define PMU_SYS_CMURST_N    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0114))
#define PMU_SYS_IPRST_N ((volatile unsigned int *)(PMU_SYS_BASE + 0x0118))
#define PMU_SYS_MCPUMON ((volatile unsigned int *)(PMU_SYS_BASE + 0x0200))
#define PMU_SYS_PROFILERCTRL    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0400))
#define PMU_SYS_ACPUCTRL_FSM    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0408))
#define PMU_SYS_ACPUWORK    ((volatile unsigned int *)(PMU_SYS_BASE + 0x040c))
#define PMU_SYS_MCPUWORK    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0410))
#define PMU_SYS_SPAREREG    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0450))
#define PMU_SYS_DCGOVRD ((volatile unsigned int *)(PMU_SYS_BASE + 0x0460))
#define PMU_SYS_ABX_PWRCTRL ((volatile unsigned int *)(PMU_SYS_BASE + 0x0500))
#define PMU_SYS_DAC_PWRCTRL ((volatile unsigned int *)(PMU_SYS_BASE + 0x0520))
#define PMU_SYS_PMIP_BUCK0_CFG0 ((volatile unsigned int *)(PMU_SYS_BASE + 0x0600))
#define PMU_SYS_PMIP_BUCK0_CFG1 ((volatile unsigned int *)(PMU_SYS_BASE + 0x0604))
#define PMU_SYS_PMIP_ABB10_LDO  ((volatile unsigned int *)(PMU_SYS_BASE + 0x0608))
#define PMU_SYS_PMIP_ANARF12_LDO    ((volatile unsigned int *)(PMU_SYS_BASE + 0x060c))
#define PMU_SYS_PMIP_ANARF18_LDO    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0610))
#define PMU_SYS_PMIP_EFUSE18_LDO    ((volatile unsigned int *)(PMU_SYS_BASE + 0x0614))
#define PMU_SYS_PMIP_IO18_LDO   ((volatile unsigned int *)(PMU_SYS_BASE + 0x0618))
#define PMU_SYS_SMC_LPI ((volatile unsigned int *)(PMU_SYS_BASE + 0x0700))

#define PMU_MCPU_LH_PSTATE  ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0000))
#define PMU_MCPU_LH_PREQ    ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0004))
#define PMU_MCPU_LH_PACCEPT ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0008))
#define PMU_MCPU_CLKOFFREQ  ((volatile unsigned int *)(PMU_MCPU_BASE + 0x000c))
#define PMU_MCPU_PASMASK    ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0020))
#define PMU_MCPU_CMURST_N   ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0030))
#define PMU_MCPU_IPRST_N    ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0034))
#define PMU_MCPU_MDMCLKSYNC ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0040))
#define PMU_MCPU_DCGOVRD    ((volatile unsigned int *)(PMU_MCPU_BASE + 0x0050))

/* SYS CFG ADRESS */
#define SYS_CFG_BAAW_ERR_LOG_AWID       ((volatile unsigned int *)(SYS_CFG_BASE + 0x0000))
#define SYS_CFG_BAAW_ERR_LOG_AWADDR     ((volatile unsigned int *)(SYS_CFG_BASE + 0x0004))
#define SYS_CFG_BAAW_ERR_LOG_ARID       ((volatile unsigned int *)(SYS_CFG_BASE + 0x0008))
#define SYS_CFG_BAAW_ERR_LOG_ARADDR     ((volatile unsigned int *)(SYS_CFG_BASE + 0x000C))
#define SYS_CFG_GNSS_MCPU2GNSS_BUS_WAKE_REQ     ((volatile unsigned int *)(SYS_CFG_BASE + 0x0200))
#define SYS_CFG_GNSS_PWRDWN_REQ     ((volatile unsigned int *)(SYS_CFG_BASE + 0x0204))
#define SYS_CFG_GNSS_BOOT_CPU_CLK_SEL       ((volatile unsigned int *)(SYS_CFG_BASE + 0x0208))
#define SYS_CFG_GNSS_AVAIL  ((volatile unsigned int *)(SYS_CFG_BASE + 0x020C))
#define SYS_CFG_PM_BST_CFG0 ((volatile unsigned int *)(SYS_CFG_BASE + 0x0400))
#define SYS_CFG_PM_BST_CFG1 ((volatile unsigned int *)(SYS_CFG_BASE + 0x0404))
#define SYS_CFG_CHIP_VER    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1000))
#define SYS_CFG_LH_RCG_EN   ((volatile unsigned int *)(SYS_CFG_BASE + 0x1010))
#define SYS_CFG_PAS ((volatile unsigned int *)(SYS_CFG_BASE + 0x1014))
#define SYS_CFG_PPMU    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1018))
#define SYS_CFG_CELLULAR_GNSS_SEL       ((volatile unsigned int *)(SYS_CFG_BASE + 0x101C))
#define SYS_CFG_UARTWCI_SEL ((volatile unsigned int *)(SYS_CFG_BASE + 0x1020))
#define SYS_CFG_CFG_SSS_EXT_ACCESS      ((volatile unsigned int *)(SYS_CFG_BASE + 0x102C))
#define SYS_CFG_USI0_SW_CONF    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1030))
#define SYS_CFG_USI0_IPCLK  ((volatile unsigned int *)(SYS_CFG_BASE + 0x1034))
#define SYS_CFG_USI1_SW_CONF    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1038))
#define SYS_CFG_USI1_IPCLK  ((volatile unsigned int *)(SYS_CFG_BASE + 0x103C))
#define SYS_CFG_MCPU_HALTN  ((volatile unsigned int *)(SYS_CFG_BASE + 0x1040))
#define SYS_CFG_CM7_HALTED_MASK     ((volatile unsigned int *)(SYS_CFG_BASE + 0x1044))
#define SYS_CFG_CM0_HALTED  ((volatile unsigned int *)(SYS_CFG_BASE + 0x1048))
#define SYS_CFG_CM0_HRESETN_CTL     ((volatile unsigned int *)(SYS_CFG_BASE + 0x104C))
#define SYS_CFG_SRAM_RA1_HS     ((volatile unsigned int *)(SYS_CFG_BASE + 0x1050))
#define SYS_CFG_SRAM_RF1_HS ((volatile unsigned int *)(SYS_CFG_BASE + 0x1054))
#define SYS_CFG_SRAM_RA1_HD ((volatile unsigned int *)(SYS_CFG_BASE + 0x1060))
#define SYS_CFG_SRAM_RF1_HD ((volatile unsigned int *)(SYS_CFG_BASE + 0x1064))
#define SYS_CFG_SRAM_RF2_HD ((volatile unsigned int *)(SYS_CFG_BASE + 0x1068))
#define SYS_CFG_VROM_HD     ((volatile unsigned int *)(SYS_CFG_BASE + 0x106C))
#define SYS_CFG_RXADC_RCCAL0    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1200))
#define SYS_CFG_RXADC_RCCAL1    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1204))
#define SYS_CFG_RXADC_RCCAL2    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1208))
#define SYS_CFG_RXADC_RCCAL3    ((volatile unsigned int *)(SYS_CFG_BASE + 0x120C))
#define SYS_CFG_BLK_CTRL    ((volatile unsigned int *)(SYS_CFG_BASE + 0x1800))

/* BAAW ADRESS */
#define BAAW_SRC_START_ADDR_0   ((volatile unsigned int *)(BAAW_BASE + 0x0000))
#define BAAW_SRC_END_ADDR_0  ((volatile unsigned int *)(BAAW_BASE + 0x0004))
#define BAAW_REMAPPED_ADDR_0    ((volatile unsigned int *)(BAAW_BASE + 0x0008))
#define BAAW_ACCESS_ENABLE_OF_WINDOW_0    ((volatile unsigned int *)(BAAW_BASE + 0x000c))
#define BAAW_SRC_START_ADDR_1       ((volatile unsigned int *)(BAAW_BASE + 0x0010))
#define BAAW_SRC_END_ADDR_1  ((volatile unsigned int *)(BAAW_BASE + 0x0014))
#define BAAW_REMAPPED_ADDR_1    ((volatile unsigned int *)(BAAW_BASE + 0x0018))
#define BAAW_ACCESS_ENABLE_OF_WINDOW_1    ((volatile unsigned int *)(BAAW_BASE + 0x001c))
#define BAAW_SRC_START_ADDR_2   ((volatile unsigned int *)(BAAW_BASE + 0x0020))
#define BAAW_SRC_END_ADDR_2  ((volatile unsigned int *)(BAAW_BASE + 0x0024))
#define BAAW_REMAPPED_ADDR_2    ((volatile unsigned int *)(BAAW_BASE + 0x0028))
#define BAAW_ACCESS_ENABLE_OF_WINDOW_2    ((volatile unsigned int *)(BAAW_BASE + 0x002C))
#define BAAW_SRC_START_ADDR_3   ((volatile unsigned int *)(BAAW_BASE + 0x0030))
#define BAAW_SRC_END_ADDR_3  ((volatile unsigned int *)(BAAW_BASE + 0x0034))
#define BAAW_REMAPPED_ADDR_3    ((volatile unsigned int *)(BAAW_BASE + 0x0038))
#define BAAW_ACCESS_ENABLE_OF_WINDOW_3    ((volatile unsigned int *)(BAAW_BASE + 0x003C))

#endif
