![GSOC 2019](https://img.shields.io/static/v1.svg?label=GSOC&message=Google%20Summer%20of%20Code%202019&color=blue&logo=%20data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAABLFJREFUSA2tVV1sVFUQ/s45d7ulpT+63VSkQC1IIsHyAugDAWLwQSEQI/EnaGL0QWOQ6AMo+uAzJooJJJiIiQ8qkWDURIxGIlLUqEQTKz9REEpbMFhKt7ss7e49P35zb9jaqKEkTnL33jNn5ps538ycBa5D7MH8etuTX38dLlM3jQ+2rXRf1Q/LI99T9VRTMYy/rF+hUflAIeTEPkANe2Tvz9w1fuha/pMChE/RbDNRd83JWnigwzTO2Gma5+ec6eCWgnEDcMXfhl35j43cH4yiqOYSxbZX3YviVcXEDjVWR4tMRvUEegUXQzfNRtT1PJBbw7WFjocTv5DJwZgoZy7t3+N/34YwdhbKZKA0MO6i5UQ6/K8BYBC8gNsYKr8a6rZdCJePwx97EmH0e+rTxFTUDNW8FHrOs9CLD8OdeBp+6BOoKAPBuAou70knSDaYucrfA73wXbhTW+EHdqX2ypCdlNHgigjDn8Pz0R1PwSx8B+7oBuDi/n9ATgoQW+vqp8+EWrCb4C/B9xPciMnfSuVjLhlMM1sm6/vfSNZmwZvwR5YilAZdmlH6S9YmxFjMVl2bEcon08wTcO4LqEhwMHNfhm65E+BJE2GB/SCpLP8K3bUFgpFupL+1AGNfTF8ZtbbtQNt9zOo17iaV5ltDz3iErzpyTO7bH6KOBZ/xYHoSBmXl4M++ymZYh6g1v0OwaJRIEiBwcOrMlX26cV4+eAU/+l2yqTJtiLr3Qd1EMDsONNzKzMvwpaPUbYC5fS9AG5FQZBMwJ8EQLMEUvbaH2tZ6lD4kbM7pmwl0CagOQzXOh1ncg1D9E66XWTNT1byELXmaNmW4Xx6m3RAi2ohtqNLPjsCZmTyzzwmmPdS+VhvYQmBp0gaRDmNBZSG829GUFtPAAFS33AEUf0i/RUfK6E7bqiRLkWYQQ/kOJYNKQasVhR7nMmt8QJ/xA3S6EUJNGDsD++MqHvsKqXiPgaZBNTDT4hGeO6JuT0KX/elu2vZB1eUTX8EQLEtMwU5qkF1V7rUe6/zlU6eV5hzcsDxJBH4M7tjjaQEbyT8n2JdPEKiOjbAd7vgTDDKWJt26jJPMq6V08rRgCaaco9ZF2VXoDcXCJlzYwwndzP5nnwtVnH8/9JkcGf7cbiAm16TED3Go5G4QG86E7qQPfePiyCbBEnCRWgBZhAxG/JnXSRHvms4XmJ0VbRIsuTL6XuFaCE5Bkz25o27ZklDkz2yHJwYNajJpksmtDvEQaXkUZtFHiZHr28ZALKJmLuQ+AZV+5KWlDGdj7laY2c/B/byOpxvioSIaSmKpTA5AnSY1vvANPB30greg82vg+ncgFA4nbZm4ZdugWpcT+BnWowW+l+CFr9PLzkonTsjkAKSbHTDuFfkf+ZZ3yzLoWRvrzLwXdVDSkqW0EU0T3yX48+97P7CzGqoXmTl9iB2IMQGfElpbh72YhvZsR6VCVZYPP0wFM9X0prdNU+ccpziIpN+E8/zD6TsbLpcec1mcE2Mxl5/BC5XBWQ+ArZWKVOyaUjlQ1x3p+GOtQqcY+6D6rM+wFau1bvkvkCkFEOfKgcbuyMTsTTLlMquv9rms/zepHmheIs/1AP4F9DYB6+AcwCcAAAAASUVORK5CYII=)

____

## OWASP iGoat (Swift) - A Damn Vulnerable Swift Application for iOS [![Twitter Follow](https://img.shields.io/twitter/follow/espadrine.svg?style=social&label=Follow)](https://twitter.com/OWASPiGoat/)

This is a Swift version of original iGoat [![Objective C](https://img.shields.io/badge/Objective-C-blue.svg)](https://github.com/OWASP/igoat) project. Using OWASP iGoat, you can learn exploiting and defending vulnerabilities in iOS Swift applications. Developed using [![Swift 4](https://img.shields.io/badge/Swift-4-blue.svg)](https://developer.apple.com/swift/) [![Ruby](https://img.shields.io/badge/Ruby--blue.svg)]()

iGoat (Objective C) was presented at:
[![AppSec USA 2017](https://img.shields.io/badge/AppSec%20USA-2017-red.svg)](https://appsecusa2017.sched.com/event/B2Xk/igoat-a-self-learning-tool-for-ios-app-pentesting-and-security) &nbsp; [![c0c0n 2017](https://img.shields.io/badge/c0c0n-2017-red.svg)](http://is-ra.org/c0c0n/2017/agenda) &nbsp; [![SEC-T 2017](https://img.shields.io/badge/SEC--T-2017-red.svg)](https://www.sec-t.org/archive/2017_events/schedule/) &nbsp; [![BruCON 2017](https://img.shields.io/badge/BruCON-2017-red.svg)](https://2017.brucon.org/index.php/Practical_iOS_App_Exploitation_and_Defense_using_iGoat) &nbsp; [![Bugcrowd Levelup 2017](https://img.shields.io/badge/BugcrowdLevelUp-2017-red.svg)](https://forum.bugcrowd.com/t/levelup-2017-discussion-swaroop-owasp-igoat/3052)

__Vulnerabilities Covered (version 1.0):__ [![Download iGoat](https://img.shields.io/badge/Download-iGoat-orange.svg)](https://codeload.github.com/OWASP/iGoat-Swift/zip/master) Documentation: https://docs.igoatapp.com/

Summary            |  Snapshot
:-------------------------:|:-------------------------:
__OWASP TOP 10 Mobile__ </br><p align="left">* __Reverse Engineering__</br>* __Runtime Analysis__</br>* __Data Protection (Rest)__</br>* __Data Protection (Transit)__</br>* __Key Management__</br>* __Tampering__</br>* __Injection Flaws__</br>* __Broken Cryptography__</br>* __Memory Management__</br>* __URL Scheme Attack__</br>* __Social Engineering__</br>* __SSL Pinning__</br>* __Authentication__</br>* __Jailbreak Detection__</br>* __Side Channel Data Leaks__</br>* __Cloud Misconfiguration__</br>* __Crypto Challenges__ | <img src="https://github.com/swaroopsy/test/blob/master/h1.gif?raw=true" width="256" title="iGoat App">

## Demo
![Demo](https://github.com/swaroopsy/test/blob/master/OWASP_iGoat_Demo.gif)

__Documentation:__ <a href="https://github.com/OWASP/iGoat-Swift/wiki">iGoat Wiki</a>

__iGoat Quick Setup__ `git clone https://github.com/OWASP/iGoat-Swift.git`and open iGoat-Swift.xcodeproj with xcode.
__Setup iGoat Server__ Navigate to server > docker_packaging and then use command `docker compose up` <br>
__Using Cydia Repo__ - Open Cydia -> Sources -> Edit and add source http://swiftigoat.yourepo.com/ and then search for iGoat and install it.

__Project Lead__ - Swaroop Yermalkar [![Twitter Follow](https://img.shields.io/twitter/follow/espadrine.svg?style=social&label=Follow)](https://twitter.com/swaroopsy)

__Lead Developer__ - Anthony Gonsalves

## Architecture
![Architecture](https://github.com/swaroopsy/test/blob/master/Architecture.png?raw=true)

### How to Contribute? ###
* You can add new exercises
* Testing iGoat and checking if any issues
* Suggest us new attacks
* Writing blogs / article about iGoat
* Spreading iGoat :)

To contribute to iGoat project, please contact __Swaroop__ ( swaroop.yermalkar@owasp.org or @swaroopsy )

### Project Contributors - ###
[Junard Lebajan](https://twitter.com/junard) <br>
[Tim](https://twitter.com/0xff7) <br>
[masbog](https://github.com/masbog) <br>
[Arun](https://twitter.com/he_hacks)
<br> Your name can be here :) We give cool iGoat t-shirt and swag!
