#import <Foundation/Foundation.h>

/**
 * A change-set represents the set of changes that will be given to a CKModifyRecordsOperation.
 *
 * A change-set is automatically generated by a readWriteTransaction
 * that makes one or more changes that result in modifications that need to be pushed to the CloudKit server.
 * 
 * Changes are grouped by databaseIdentifier.
 * So if a single readWriteTransaction makes several modifications that span multiple databaseIdentifiers,
 * then the transaction will result in multiple generated change-sets.
 *
 * You are free to inspect the change-set, however, it is not possible to modify it.
**/
@interface YDBCKChangeSet : NSObject

@property (nonatomic, readonly) NSString *databaseIdentifier;
@property (nonatomic, readonly) NSString *uuid;

@property (nonatomic, readonly) BOOL isInFlight;

@property (nonatomic, readonly) NSArray *recordIDsToDelete; // Array of CKRecordID's for CKModifyRecordsOperation
@property (nonatomic, readonly) NSArray *recordsToSave;     // Array of CKRecord's for CKModifyRecordsOperation
@property (nonatomic, readonly) NSArray *recordIDsToSave;   // Array of CKRecordID's (from recordsToSave)

@property (nonatomic, readonly) NSUInteger recordIDsToDeleteCount; // shortcut if you just want the count
@property (nonatomic, readonly) NSUInteger recordsToSaveCount;     // shortcut if you just want the count

@end
