#  Build CRUD RESTful API Server with Golang, Gin, and MongoDB

In this article, you'll learn how to build a CRUD RESTful API server with Golang, Gin Gonic, MongoDB-Go-driver, Docker, and Docker-compose.

![Build CRUD RESTful API Server with Golang, Gin, and MongoDB](https://codevoweb.com/wp-content/uploads/2022/05/Build-CRUD-RESTful-API-Server-with-Golang-Gin-and-MongoDB.webp)

## Topics Covered

- Golang, Gin Gonic, MongoDB CRUD RESTful API Overview
- Create the Models with Structs
- Create the Service Interface
- Create Methods to Implement the Interface
    - Initialize the Service Struct
    - Define a Service to Create a Post
    - Define a Service to Update Post
    - Define a Service to Delete Post
    - Define a Service to Get Single Post
    - Define a Service to Get All Posts
- Create Controllers to Perform the CRUD Operations
    - Initialize the Controller Struct
    - Define a Controller to Create a Post
    - Define a Controller to Update a Post
    - Define a Controller to Delete a Post
    - Define a Controller to Get a Single Post
    - Define a Controller to Get All Posts
- Create the Routes for the Controllers
- Initialize the Constructors and Start the Gin Server

Read the entire article here: [https://codevoweb.com/crud-restful-api-server-with-golang-and-mongodb](https://codevoweb.com/crud-restful-api-server-with-golang-and-mongodb)

Articles in this series:

### 1. API with Golang + MongoDB + Redis + Gin Gonic: Project Setup

[API with Golang + MongoDB + Redis + Gin Gonic: Project Setup](https://codevoweb.com/api-golang-mongodb-gin-gonic-project-setup)

### 2. Golang & MongoDB: JWT Authentication and Authorization

[Golang & MongoDB: JWT Authentication and Authorization](https://codevoweb.com/golang-mongodb-jwt-authentication-authorization)

### 3. API with Golang + MongoDB: Send HTML Emails with Gomail

[API with Golang + MongoDB: Send HTML Emails with Gomail](https://codevoweb.com/api-golang-mongodb-send-html-emails-gomail)

### 4. API with Golang, Gin Gonic & MongoDB: Forget/Reset Password

[API with Golang, Gin Gonic & MongoDB: Forget/Reset Password](https://codevoweb.com/api-golang-gin-gonic-mongodb-forget-reset-password)

### 5. Build Golang gRPC Server and Client: SignUp User & Verify Email

[Build Golang gRPC Server and Client: SignUp User & Verify Email](https://codevoweb.com/golang-grpc-server-and-client-signup-user-verify-email)

### 6. Build Golang gRPC Server and Client: Access & Refresh Tokens

[Build Golang gRPC Server and Client: Access & Refresh Tokens](https://codevoweb.com/golang-grpc-server-and-client-access-refresh-tokens)

### 7. Build CRUD RESTful API Server with Golang, Gin, and MongoDB

[Build CRUD RESTful API Server with Golang, Gin, and MongoDB](https://codevoweb.com/crud-restful-api-server-with-golang-and-mongodb)

### 8. Build CRUD gRPC Server API & Client with Golang and MongoDB

[Build CRUD gRPC Server API & Client with Golang and MongoDB](https://codevoweb.com/crud-grpc-server-api-client-with-golang-and-mongodb)
